/*
=============================================================================
Module Information
------------------
Name:			cldraw.cpp
Author:			Rich Whitehouse
Description:	client module draw routines.
=============================================================================
*/

#include "clmain.h"
#include <gl/gl.h>

//draw hud
void LCl_DrawHudElements(void)
{
	if (!g_clRes.novaTex.inuse || !g_clRes.lifeTex.inuse)
	{
		return;
	}

	int lives = g_clientObjects[g_selfClientNum].net.lives;
	int bombs = g_clientObjects[g_selfClientNum].net.plAmmo;

	glAlphaFunc(GL_GREATER, 0.65f);
	glEnable(GL_ALPHA_TEST);

	glDisable(GL_DEPTH_TEST);
	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	glDisable(GL_TEXTURE_2D);
	glColor4f(1.0f, 1.0f, 1.0f, 0.7f);

	glEnable(GL_TEXTURE_2D);
	g_sharedFn->GL_BindTexContainer(&g_clRes.novaTex);
	float wantW = 24.0f;
	float wantH = 24.0f;
	float pad = 2.0f;
	float wantX = 640.0f-((wantW+pad)*3.0f)-4.0f;
	float wantY = 480.0f-wantH-6.0f;

	if (bombs > 3)
	{
		wantX += (wantW+pad)-8;
		float x = g_sharedFn->GL_ScaleBasedOnResW((float)wantX);
		float y = g_sharedFn->GL_ScaleBasedOnResH((float)wantY);
		float w = g_sharedFn->GL_ScaleBasedOnResW((float)wantW);
		float h = g_sharedFn->GL_ScaleBasedOnResH((float)wantH);
		g_sharedFn->GL_VertProgramBegin(false);
		g_sharedFn->GL_PrepareForDraw();
		glBegin(GL_QUADS);
			glTexCoord2f(0.0f, 0.0f);
			glVertex2f(x, y);

			glTexCoord2f(0.0f, 1.0f);
			glVertex2f(x, y+h);

			glTexCoord2f(1.0f, 1.0f);
			glVertex2f(x+w, y+h);

			glTexCoord2f(1.0f, 0.0f);
			glVertex2f(x+w, y);
		glEnd();
		g_sharedFn->GL_VertProgramEnd();
		wantX += (wantW+pad);
		float fontScaleX = 1.0f;
		float fontScaleY = 1.5f;
		int renderW = (int)(16*fontScaleX);
		int renderH = (int)(18*fontScaleY);

		g_sharedFn->GL_DrawRawText((int)wantX-4, (int)wantY+8, renderW, renderH, fontScaleX, fontScaleY,
			"x", false, false);
		char str[128];
		sprintf(str, "%i", bombs);
		fontScaleX = 2.0f;
		fontScaleY = 3.0f;
		renderW = (int)(16*fontScaleX);
		renderH = (int)(18*fontScaleY);
		g_sharedFn->GL_DrawRawText((int)wantX+6, (int)wantY, renderW, renderH, fontScaleX, fontScaleY,
			str, false, false);
	}
	else
	{
		for (int i = 0; i < bombs; i++)
		{
			float x = g_sharedFn->GL_ScaleBasedOnResW((float)wantX);
			float y = g_sharedFn->GL_ScaleBasedOnResH((float)wantY);
			float w = g_sharedFn->GL_ScaleBasedOnResW((float)wantW);
			float h = g_sharedFn->GL_ScaleBasedOnResH((float)wantH);
			g_sharedFn->GL_VertProgramBegin(false);
			g_sharedFn->GL_PrepareForDraw();
			glBegin(GL_QUADS);
				glTexCoord2f(0.0f, 0.0f);
				glVertex2f(x, y);

				glTexCoord2f(0.0f, 1.0f);
				glVertex2f(x, y+h);

				glTexCoord2f(1.0f, 1.0f);
				glVertex2f(x+w, y+h);

				glTexCoord2f(1.0f, 0.0f);
				glVertex2f(x+w, y);
			glEnd();
			g_sharedFn->GL_VertProgramEnd();
			wantX += (wantW+pad);
		}
	}

	if (!g_musicalMode)
	{
		glEnable(GL_TEXTURE_2D);
		g_sharedFn->GL_BindTexContainer(&g_clRes.lifeTex);
		wantW = 24.0f;
		wantH = 24.0f;
		pad = 2.0f;
		wantX = 4.0f+pad;
		wantY = 480.0f-wantH-6.0f;
		//for (int i = 0; i < lives; i++)
		if (1)
		{
			float x = g_sharedFn->GL_ScaleBasedOnResW((float)wantX);
			float y = g_sharedFn->GL_ScaleBasedOnResH((float)wantY);
			float w = g_sharedFn->GL_ScaleBasedOnResW((float)wantW);
			float h = g_sharedFn->GL_ScaleBasedOnResH((float)wantH);
			g_sharedFn->GL_VertProgramBegin(false);
			g_sharedFn->GL_PrepareForDraw();
			glBegin(GL_QUADS);
				glTexCoord2f(0.0f, 0.0f);
				glVertex2f(x, y);

				glTexCoord2f(0.0f, 1.0f);
				glVertex2f(x, y+h);

				glTexCoord2f(1.0f, 1.0f);
				glVertex2f(x+w, y+h);

				glTexCoord2f(1.0f, 0.0f);
				glVertex2f(x+w, y);
			glEnd();
			g_sharedFn->GL_VertProgramEnd();
			wantX += (wantW+pad);
		}

		float fontScaleX = 1.0f;
		float fontScaleY = 1.5f;
		int renderW = (int)(16*fontScaleX);
		int renderH = (int)(18*fontScaleY);

		g_sharedFn->GL_DrawRawText((int)wantX, (int)wantY + 12, renderW, renderH, fontScaleX, fontScaleY,
			"x", false, true);
		char str[128];
		sprintf(str, "%i", lives);
		fontScaleX = 2.0f;
		fontScaleY = 3.0f;
		renderW = (int)(16*fontScaleX);
		renderH = (int)(18*fontScaleY);
		g_sharedFn->GL_DrawRawText((int)wantX + 10, (int)wantY + 2, renderW, renderH, fontScaleX, fontScaleY,
			str, false, true);
		g_musicScoreMulTime = 0;
	}
	else
	{ //draw high score instead for musical mode
		pad = 2.0f;
		wantX = 4.0f+pad;
		wantY = 480.0f-wantH-6.0f;
		float fontScaleX = 1.0f;
		float fontScaleY = 1.5f;
		int renderW = (int)(16*fontScaleX);
		int renderH = (int)(18*fontScaleY);

		char str[128];
		sprintf(str, "Score: %08i", lives);
		g_sharedFn->GL_DrawRawText((int)wantX, (int)wantY + 12, renderW, renderH, fontScaleX, fontScaleY,
			str, false, true);
		sprintf(str, "Best: %08i", g_musicClHighScore);
		g_sharedFn->GL_DrawRawText((int)wantX + 160, (int)wantY + 12, renderW, renderH, fontScaleX, fontScaleY,
			str, false, true);
		if (g_musicScoreMulTime)
		{
			if (g_musicScoreMulTime > g_curTime)
			{
				glDisable(GL_ALPHA_TEST);

				wantX = 16.0f+pad;
				wantY = 480.0f-wantH-32.0f;
				fontScaleX = 6.0f;
				fontScaleY = 9.0f;
				float tfact = (float)(g_musicScoreMulTime - g_curTime)/3000.0f;
				if (tfact < 0.0f)
				{
					tfact = 0.0f;
				}
				else if (tfact > 1.0f)
				{
					tfact = 1.0f;
				}
				float alphaVal = 1.0f;
				if (tfact < 0.5f)
				{
					alphaVal = tfact*2.0f;
				}
				glColor4f(1.0f, 1.0f, 1.0f, alphaVal);
				//for (int i = 0; i < 4; i++)
				{
					renderW = (int)(16*fontScaleX);
					renderH = (int)(18*fontScaleY);
					sprintf(str, "%ix", g_musicScoreMul);
					g_sharedFn->GL_DrawRawText((int)wantX, (int)wantY - 32, renderW, renderH, fontScaleX, fontScaleY,
						str, false, true);
					fontScaleX += tfact * 0.25f;
					fontScaleY = fontScaleX + (fontScaleX*0.5f);
				}
				glColor4f(1.0f, 1.0f, 1.0f, 0.7f);
				glEnable(GL_ALPHA_TEST);
			}
			else
			{
				g_musicScoreMulTime = 0;
			}
		}
	}

    glDisable(GL_BLEND);
	glEnable(GL_DEPTH_TEST);

	glDisable(GL_ALPHA_TEST);

	glColor4f(1.0f, 1.0f, 1.0f, 1.0f);

	glDisable(GL_TEXTURE_2D);
}