/*
=============================================================================
Module Information
------------------
Name:			physics.cpp
Author:			Rich Whitehouse
Description:	server logic module physics routines.

This is using my own collision system and disregarding novodex support.
This code is all horrible and from several years ago.
=============================================================================
*/

#include "main.h"

static float g_gravFactor = DEFAULT_GRAVITY;

//interpolate difference
float Phys_InterpolateAngle(float old, float cur, float val, float tresh)
{
	if ((cur-old) > 180.0f)
	{
		cur -= 360.0f;
	}
	if ((cur-old) < -180.0f)
	{
		cur += 360.0f;
	}

	if (fabsf(cur-old) > tresh)
	{ //too big of a difference.
		return cur;
	}

	return Math_AngleMod(old + (val*(cur-old)));
}

//clip velocity
static void Phys_ClipVel(float *vel, float *normal)
{
	float dp = Math_DotProduct(vel, normal);
	vel[0] -= dp*normal[0];
	vel[1] -= dp*normal[1];
	vel[2] -= dp*normal[2];
}

//translate an object which pushes other collidable objects
void Phys_TranslatePusher(gameObject_t *pusher, float *dest)
{
	if (pusher->net.pos[0] == dest[0])

	if (!pusher || !pusher->rcColModel)
	{
		assert(!"bad object for Phys_TranslatePusher");
		return;
	}

	bool pushBlocked = false;
	float travelVecTowardPusher[3];
	float travelVecAwayFromPusherN[3];
	Math_VecSub(pusher->net.pos, dest, travelVecTowardPusher);
	float moveLen = Math_VecLen(travelVecTowardPusher);
	travelVecAwayFromPusherN[0] = -travelVecTowardPusher[0];
	travelVecAwayFromPusherN[1] = -travelVecTowardPusher[1];
	travelVecAwayFromPusherN[2] = -travelVecTowardPusher[2];
	Math_VecNorm(travelVecAwayFromPusherN);

	for (int i = 0; i < g_gameObjectSlots; i++)
	{
		gameObject_t *other = &g_gameObjects[i];
		if (other->inuse && other->rcColModel && other->radius != 0.0f)
		{
			if (other->net.staticIndex != -1)
			{ //don't care about static things
				continue;
			}
			float goalPos[3];
			Math_VecAdd(other->net.pos, travelVecTowardPusher, goalPos);
			collObj_t col;
			g_sharedFn->Coll_MovementTranslation(other->rcColModel, &col, other->net.pos,
				goalPos, pusher->rcColModel);
			if (col.hit)
			{ //the pusher will hit this thing during the translation
				Util_TouchObjects(pusher, other, &col);
				Math_VecMA(other->net.pos, col.distance+moveLen+1.0f, travelVecAwayFromPusherN, goalPos);
				g_sharedFn->Coll_MovementTranslation(other->rcColModel, &col, other->net.pos,
					goalPos, NULL);
				if (!col.hit && g_fpsMode)
				{ //successful push
					Math_VecCopy(col.endPos, other->net.pos);
					LServ_UpdateRClip(other);
				}
				else
				{ //crush!
					Util_DamageObject(pusher, other, 10000);
					if (other->net.index < MAX_NET_CLIENTS &&
						g_fpsMode && other->net.lives > 0)
					{ //hack for fps mode
						other->net.lives = 0;
						g_sharedFn->Common_MapChange(NULL);
						ObjSound_Create(other->net.pos, "assets/sound/weapons/explode2.wav", 2.0f, -1);
					}
					if (g_fpsMode)
					{
						pushBlocked = true;
					}
				}
			}
		}
	}

	if (!pushBlocked)
	{
		Math_VecCopy(dest, pusher->net.pos);
		LServ_UpdateRClip(pusher);
	}
}

//apply physics
void Phys_ApplyObjectPhysics(gameObject_t *obj, float timeMod, float objRad, float gravFactor, float bounceFactor)
{
	collObj_t collision;
	float ground[3];
	float projected[3];
	float velDir[3];
	float velFactor;
	float xyFriction = 0.6f;//0.4f;
	float zFriction = 0.1f;
	float groundPl[3] = {0.0f, 0.0f, 1.0f};
	float groundDot = 0.6f;
	if (gravFactor == 0.0f)
	{
		groundDot = 1.0f;
	}
	float oldPos[3];
	Math_VecCopy(obj->net.pos, oldPos);
	if (gravFactor != 0.0f)
	{
		//gravity/ground check
		Math_VecCopy(obj->net.pos, ground);
		ground[2] -= 8.0f;
		g_sharedFn->Coll_MovementTranslation(obj->rcColModel, &collision, obj->net.pos, ground, NULL);
		if (collision.hit && collision.inSolid)
		{
			float test[3], testNormal[3];
			Math_VecCopy(obj->net.pos, test);
			//Math_VecCopy(collision.endNormal, testNormal);
			testNormal[0] = 0.0f;
			testNormal[1] = 0.0f;
			testNormal[2] = 1.0f;
			float fudge = 32.0f;
			while (fudge < 512.0f)
			{
				test[0] = obj->net.pos[0] + (testNormal[0]*fudge);
				test[1] = obj->net.pos[1] + (testNormal[1]*fudge);
				test[2] = obj->net.pos[2] + (testNormal[2]*fudge);
				Math_VecCopy(test, ground);
				ground[2] -= 8.0f;
				g_sharedFn->Coll_MovementTranslation(obj->rcColModel, &collision, test, ground, NULL);
				if (!collision.inSolid)
				{
					Math_VecCopy(test, obj->net.pos);
					break;
				}
				fudge += 32.0f;
			}
		}
		
		if (!collision.hit)
		{ //add it
			obj->onGround = false;
			obj->net.vel[2] -= gravFactor*timeMod;
		}
		else if (!collision.inSolid)
		{ //be even with ground
			if (collision.hitObjectIndex != -1)
			{
				Util_TouchObjects(obj, &g_gameObjects[collision.hitObjectIndex], &collision);
			}
			float dp = Math_DotProduct(groundPl, collision.endNormal);
			if (dp >= groundDot)
			{
				obj->onGround = true;
				Math_VecCopy(collision.endPos, obj->net.pos);
				if (obj->net.vel[2] < 0.0f)
				{
					obj->net.vel[2] = 0.0f;
				}
			}
			else
			{
				obj->onGround = false;
				float d[3];
				d[0] = collision.endNormal[0] + (-groundPl[0]);
				d[1] = collision.endNormal[1] + (-groundPl[1]);
				d[2] = collision.endNormal[2] + (-groundPl[2]);
				Math_VecNorm(d);
				obj->net.vel[0] += d[0]*(gravFactor*timeMod);
				obj->net.vel[1] += d[1]*(gravFactor*timeMod);
				obj->net.vel[2] += d[2]*(gravFactor*timeMod);
			}
		}
		if (!obj->onGround)
		{
			xyFriction = 0.06f; //low friction in air
		}
	}
	else
	{
		obj->onGround = false;
		xyFriction = 0.06f; //low friction in air
	}
	//check projected spot for velocity
	Math_VecCopy(obj->net.vel, velDir);
	velFactor = Math_VecNorm(velDir);
	if (!velDir[0] && !velDir[1] && !velDir[2])
	{
		velFactor = 1.0f;
	}
	velFactor *= 0.2f;
	velFactor *= timeMod;
	Math_VecMA(obj->net.pos, velFactor, velDir, projected);

	//todo: check for bounce
	//g_sharedFn->Common_Collide(obj->net.pos, projected, obj->net.mins, obj->net.maxs, obj->net.index, &collision);
	g_sharedFn->Coll_MovementTranslation(obj->rcColModel, &collision, obj->net.pos, projected, NULL);

	bool climbed = false;
	if (obj->onGround && collision.hit && !collision.inSolid && gravFactor != 0.0f)
	{ //try stair-climbing
		float dp = Math_DotProduct(groundPl, collision.endNormal);
		if (dp < groundDot || dp > -groundDot)
		{
			collObj_t stair;
			float up[3];
			float stairHop = 48.0f;//32.0f;
			Math_VecCopy(collision.endPos, up);
			up[2] += stairHop;
			g_sharedFn->Coll_MovementTranslation(obj->rcColModel, &stair, obj->net.pos, up, NULL);
			if (!stair.hit)
			{
				float stepFwdLen = velFactor;
				Math_VecCopy(obj->net.vel, velDir);
				velDir[2] = 0.0f;
				Math_VecNorm(velDir);
				float n[3];
				n[0] = up[0] + (velDir[0]*stepFwdLen);
				n[1] = up[1] + (velDir[1]*stepFwdLen);
				n[2] = up[2];
				g_sharedFn->Coll_MovementTranslation(obj->rcColModel, &stair, up, n, NULL);
				if (!stair.hit)
				{
					up[0] = n[0];
					up[1] = n[1];
					n[2] -= stairHop;
					g_sharedFn->Coll_MovementTranslation(obj->rcColModel, &stair, up, n, NULL);
					if (stair.hit && !stair.inSolid)
					{
						Math_VecCopy(stair.endPos, obj->net.pos);
						
						Math_VecMA(obj->net.pos, velFactor, velDir, projected);
						g_sharedFn->Coll_MovementTranslation(obj->rcColModel, &collision, obj->net.pos, projected, NULL);
						climbed = true;
					}
				}
			}
		}
	}

	if (collision.hit && !collision.inSolid)
	{ //slide along the wall instead
		if (bounceFactor != 0.0f)
		{ //bounce
			float velL = Math_VecNorm(obj->net.vel);
			obj->net.vel[0] += collision.endNormal[0]*2.0f;
			obj->net.vel[1] += collision.endNormal[1]*2.0f;
			obj->net.vel[2] += collision.endNormal[2]*2.0f;
			Math_VecNorm(obj->net.vel);
            obj->net.vel[0] *= (velL*bounceFactor);
			obj->net.vel[1] *= (velL*bounceFactor);
			obj->net.vel[2] *= (velL*bounceFactor);
		}
		else
		{ //slide
			Phys_ClipVel(obj->net.vel, collision.endNormal);
			Math_VecCopy(obj->net.vel, velDir);
			Math_VecNorm(velDir);
			float oldVelDir[3];
			Math_VecCopy(velDir, oldVelDir);
			//oldVelDir[2] = 0.0f;
			float dp = Math_DotProduct(groundPl, collision.endNormal);
			if (dp < groundDot && dp > -groundDot &&
				(velDir[0] || velDir[1] || velDir[2]))
			{
				float e[3];

	//				obj->net.vel[0] = velDir[0]*(velL*b);
	//				obj->net.vel[1] = velDir[1]*(velL*b);
	//				obj->net.vel[2] = velDir[2]*(velL*b);
				Math_VecMA(obj->net.pos, velFactor, velDir, projected);
				//g_sharedFn->Common_Collide(obj->net.pos, projected, obj->net.mins, obj->net.maxs, obj->net.index, &collision);
				g_sharedFn->Coll_MovementTranslation(obj->rcColModel, &collision, obj->net.pos, projected, NULL);
				if (collision.hit)
				{ //smooth over intersecting planes
					Math_VecCopy(collision.endPos, e);
					dp = Math_DotProduct(velDir, collision.endNormal);
					if (dp < 0.0f && dp != -1.0f)// && dp > -0.99f)
					{
						float mFact = 0.25f;
						Math_VecAdd(velDir, collision.endNormal, velDir);
						velDir[2] = 0.0f;
						Math_VecNorm(velDir);
						//ObjPlayer_ClipVel(obj->net.vel, velDir);
						Math_VecMA(e, velFactor*mFact, velDir, projected);
						g_sharedFn->Coll_MovementTranslation(obj->rcColModel, &collision, e, projected, NULL);
						if (!collision.hit)
						{
							Math_VecCopy(oldVelDir, velDir);
							Math_VecMA(collision.endPos, velFactor*mFact, velDir, projected);
							Math_VecCopy(collision.endPos, e);
							g_sharedFn->Coll_MovementTranslation(obj->rcColModel, &collision, e, projected, NULL);
						}
					}
				}
				//Util_DebugFX(collision.endPos, velDir);
			}
		}
	}

	const float maxVel = 8192.0f;//4096.0f;
	for (int i = 0; i < 3; i++)
	{
		if (obj->net.vel[i] > maxVel)
		{
			obj->net.vel[i] = maxVel;
		}
		else if (obj->net.vel[i] < -maxVel)
		{
			obj->net.vel[i] = -maxVel;
		}
	}

	if (!collision.inSolid)
	{ //i pulled these numbers out of my ass.
		Math_VecCopy(collision.endPos, obj->net.pos);
		if (collision.hitObjectIndex != -1)
		{
			Util_TouchObjects(obj, &g_gameObjects[collision.hitObjectIndex], &collision);
		}
		float fxy = (xyFriction*timeMod);
		float fz = (zFriction*timeMod);
		int k;
		if (fxy > 1.0f)
		{
			fxy = 1.0f;
		}
		if (fz > 1.0f)
		{
			fz = 1.0f;
		}
		obj->net.vel[0] *= 1.0f-fxy;
		obj->net.vel[1] *= 1.0f-fxy;
		obj->net.vel[2] *= 1.0f-fz;

		k = 0;
		while (k < 3)
		{
			if (fabsf(obj->net.vel[k]) < 0.0001f)
			{
				obj->net.vel[k] = 0.0f;
			}
			k++;
		}
	}
	else
	{ //oh no!
		obj->net.pos[2] += 200.0f;
	}

	if (obj->net.pos[0] != oldPos[0] ||
		obj->net.pos[1] != oldPos[1] ||
		obj->net.pos[2] != oldPos[2])
	{ //update the clip model
		LServ_UpdateRClip(obj);
	}
}
