/*
=============================================================================
Module Information
------------------
Name:			obj_soundemit.cpp
Author:			Rich Whitehouse
Description:	server logic object: sound emitter
=============================================================================
*/

#include "main.h"

//frame function
void ObjSoundEmit_Think(gameObject_t *obj, float timeMod)
{
	int objAttach = -1;
	if (obj->target && obj->target->inuse)
	{
		objAttach = obj->target->net.index;
	}
	ObjSound_CreateFromIndex(obj->net.pos, obj->net.strIndex, obj->net.modelScale[0], objAttach);
	obj->thinkTime = g_curTime+obj->debounce;
	if (obj->generalFlag)
	{ //one-time
		obj->think = ObjGeneral_RemoveThink;
	}
}

//spawn
void ObjSoundEmit_Spawn(gameObject_t *obj, BYTE *b, const objArgs_t *args, int numArgs)
{
	obj->localFlags |= LFL_NONET;
	obj->inuse |= INUSE_NONET; //don't need emitters sent to the client ever.

	int oneTime = 0;
	int delay = 50;
	obj->net.modelScale[0] = 1.0f; //default volume
	const char *sound = NULL;
	if (obj->spawnArgs && obj->numSpawnArgs > 0)
	{
		int i = 0;
		while (i < obj->numSpawnArgs)
		{
			const objArgs_t *arg = obj->spawnArgs+i;
			if (!_stricmp(arg->key, "onetime"))
			{
				oneTime = atoi(arg->val);
			}
			else if (!_stricmp(arg->key, "sound"))
			{
				sound = arg->val;
			}
			else if (!_stricmp(arg->key, "delay"))
			{
				delay = atoi(arg->val);
			}
			else if (!_stricmp(arg->key, "volume"))
			{
				obj->net.modelScale[0] = (float)atof(arg->val);
			}
			i++;
		}
	}

	if (!sound)
	{
		obj->think = ObjGeneral_RemoveThink;
		obj->thinkTime = g_curTime+50;
		return;
	}

	obj->debounce = delay;

	obj->think = ObjSoundEmit_Think;
	if (oneTime)
	{
		obj->thinkTime = g_curTime+obj->debounce;
	}
	else
	{
		obj->thinkTime = g_curTime+50;
	}
	obj->generalFlag = oneTime;

	char str[64];
    sprintf(str, "$%s", sound);
	obj->net.strIndex = g_sharedFn->Common_ServerString(str);
}
