/*
=============================================================================
Module Information
------------------
Name:			obj_snakedhead.cpp
Author:			Rich Whitehouse
Description:	(__))=============D
=============================================================================
*/

#include "main.h"

//think
void ObjSnakeHead_Think(gameObject_t *obj, float timeMod)
{
	gameObject_t *pl = &g_gameObjects[0];
	if (pl->inuse)
	{
		float angleBlend = 0.1f;
		float d[3], dAng[3];
		Math_VecSub(pl->net.pos, obj->net.pos, d);
		float dToPlayer = Math_VecNorm(d);
		Math_VecToAngles(d, dAng);
		float angMin[3] = {-320.0f, 120.0f, 0.0f};
		float angMax[3] = {40.0f, 240.0f, 0.0f};
		for (int i = 0; i < 3; i++)
		{
			float ang = (360.0f/65536.0f)*((int)(dAng[i]*(65536.0f/360.0f)) & 65535);
			if (ang < angMin[i])
			{
				ang = angMin[i];
			}
			else if (ang > angMax[i])
			{
				ang = angMax[i];
			}
			obj->net.ang[i] = Math_BlendAngle(obj->net.ang[i], ang, timeMod*angleBlend);
		}
		Math_AngleVectors(obj->net.ang, d, 0, 0);

		if (obj->child && obj->child->inuse)
		{
			float lightDist = 768.0f;
			obj->child->clAngles[0] = d[0]*lightDist;
			obj->child->clAngles[1] = d[1]*lightDist;
			obj->child->clAngles[2] = d[2]*lightDist;

			float rad = 2048.0f;
			if (obj->generalFlag)
			{
				rad = 1024.0f;
			}
			obj->child->net.modelScale[0] = rad;
			obj->child->net.modelScale[1] = rad;
			obj->child->net.modelScale[2] = rad;
			if (obj->generalFlag)
			{ //huge atten for sound
				rad *= 5.0f;
			}
			obj->child->spawnMins[0] = -(rad);
			obj->child->spawnMins[1] = -(rad);
			obj->child->spawnMins[2] = -(rad);
			obj->child->spawnMaxs[0] = (rad);
			obj->child->spawnMaxs[1] = (rad);
			obj->child->spawnMaxs[2] = (rad);

			if (obj->generalFlag)
			{
				obj->child->net.renderEffects |= FXFL_VIEWFLARE;
			}
		}

		if (dToPlayer < 2048.0f && !obj->generalFlag)
		{
			int atIn = -1;
			if (obj->child && obj->child->inuse)
			{
				atIn = obj->child->net.index;
			}
			ObjSound_Create(obj->net.pos, "assets/sound/other/test.wav", 2.0f, atIn);
			obj->generalFlag = 1;
			obj->debounce = g_curTime+19000;
		}
		if (obj->generalFlag && obj->debounce < g_curTime && !obj->debounce2)
		{ //next map
			g_sharedFn->Common_MapChange("assets/maps/l2");
			obj->debounce2 = 1;
		}
	}

	obj->thinkTime = g_curTime;
}

//snakehead spawn
void ObjSnakeHead_Spawn(gameObject_t *obj, BYTE *b, const objArgs_t *args, int numArgs)
{
	g_sharedFn->Common_ServerString("$assets/sound/other/test.wav");
	obj->think = ObjSnakeHead_Think;
	obj->thinkTime = g_curTime+50;
}
