/*
=============================================================================
Module Information
------------------
Name:			obj_pulser.cpp
Author:			Rich Whitehouse
Description:	pulsers~
=============================================================================
*/

#include "main.h"

//pulser think
void ObjPulser_Think(gameObject_t *obj, float timeMod)
{
	if (obj->debounce < g_curTime)
	{
		for (int i = 0; i < MAX_NET_CLIENTS; i++)
		{ //push away from players
			gameObject_t *pl = &g_gameObjects[i];
			if (pl->inuse)
			{
				float d[3];
				Math_VecSub(obj->net.pos, pl->net.pos, d);
				if (Math_VecLen(d) < 800.0f)
				{
					float factor = 0.7f;
					obj->net.vel[0] += d[0]*factor;
					obj->net.vel[1] += d[1]*factor;
					obj->net.vel[2] += d[2]*factor;

					obj->debounce = g_curTime+800;
				}
			}
		}
	}

	float f = 0.01f;
	obj->net.ang[0] += obj->net.vel[0]*f;
	obj->net.ang[1] += obj->net.vel[1]*f;
	obj->net.ang[2] += obj->net.vel[2]*f;

	Phys_ApplyObjectPhysics(obj, timeMod, obj->radius, 0.0f, 1.0f);

	obj->thinkTime = g_curTime;//+10;
}

//pulser touch
void ObjPulser_Touch(gameObject_s *obj, gameObject_s *other, const collObj_t *col)
{
	float hitPlane[3];
	if (col->hitObjectIndex == obj->net.index)
	{
		hitPlane[0] = -col->endNormal[0];
		hitPlane[1] = -col->endNormal[1];
		hitPlane[2] = -col->endNormal[2];
		obj->net.vel[0] += -other->net.vel[0];
		obj->net.vel[1] += -other->net.vel[1];
		obj->net.vel[2] += -other->net.vel[2];
	}
	else
	{
		hitPlane[0] = col->endNormal[0];
		hitPlane[1] = col->endNormal[1];
		hitPlane[2] = col->endNormal[2];
	}

	char *snd, *dcl;
	int r = rand()%30;
	if (r > 20)
	{
		snd = "assets/sound/other/pulse_b1.wav";
	}
	else if (r > 10)
	{
		snd = "assets/sound/other/pulse_b2.wav";
	}
	else
	{
		snd = "assets/sound/other/pulse_b3.wav";
	}

	r = rand()%30;
	if (r > 20)
	{
		dcl = "assets/textures/blood";
	}
	else if (r > 10)
	{
		dcl = "assets/textures/blood2";
	}
	else
	{
		dcl = "assets/textures/blood3";
	}

	ObjSound_Create(obj->net.pos, snd, 1.0f, -1);

	if (other && other->inuse)
	{
		float posFwd[3], dclNormal[3];
		//Math_AngleVectors(obj->projVelAng, dclNormal, 0, 0);
		dclNormal[0] = -hitPlane[0];
		dclNormal[1] = -hitPlane[1];
		dclNormal[2] = -hitPlane[2];
		posFwd[0] = col->endPos[0] + dclNormal[0]*(obj->radius-1.0f);
		posFwd[1] = col->endPos[1] + dclNormal[1]*(obj->radius-1.0f);
		posFwd[2] = col->endPos[2] + dclNormal[2]*(obj->radius-1.0f);
		Util_ProjectDecal(other, col->endPos, posFwd, dcl, 512.0f,
			10000, 4500);
	}

	if (!obj->net.solid)
	{
		return;
	}

	if (other && other->inuse && other->net.index < MAX_NET_CLIENTS)
	{ //touched by the player, pop!
		Util_DamageObject(other, obj, 10000);
	}
}

//pulser die
void ObjPulser_Death(gameObject_s *obj, gameObject_s *killer)
{
	ObjSound_Create(obj->net.pos, "assets/sound/other/pulse_blow.wav", 1.0f, -1);
	float up[3] = {-90.0f, 0.0f, 0.0f};
	ObjParticles_Create("pulser/death", obj->net.pos, up, -1);
	obj->think = ObjGeneral_RemoveThink;
	obj->thinkTime = g_curTime+50;
	obj->net.solid = 0;
}

//pulser spawn
void ObjPulser_Spawn(gameObject_t *obj, BYTE *b, const objArgs_t *args, int numArgs)
{
	g_sharedFn->Common_ServerString("$assets/sound/other/pulse_b1.wav");
	g_sharedFn->Common_ServerString("$assets/sound/other/pulse_b2.wav");
	g_sharedFn->Common_ServerString("$assets/sound/other/pulse_b3.wav");
	g_sharedFn->Common_ServerString("$assets/sound/other/pulse_blow.wav");
	g_sharedFn->Common_ServerString("^assets/textures/blood");
	g_sharedFn->Common_ServerString("^assets/textures/blood2");
	g_sharedFn->Common_ServerString("^assets/textures/blood3");
	g_sharedFn->Common_ServerString("&&pulser/death");

	obj->touch = ObjPulser_Touch;
	obj->think = ObjPulser_Think;
	obj->death = ObjPulser_Death;
	obj->health = 1;
	obj->thinkTime = g_curTime+50;
}
