/*
=============================================================================
Module Information
------------------
Name:			obj_light.cpp
Author:			Rich Whitehouse
Description:	map light objects (static and dynamic)
=============================================================================
*/

#include "main.h"

//think
void ObjLight_Think(gameObject_t *obj, float timeMod)
{
	if (obj->target && obj->target->inuse)
	{
		obj->net.pos[0] = obj->target->net.pos[0]+obj->clAngles[0];
		obj->net.pos[1] = obj->target->net.pos[1]+obj->clAngles[1];
		obj->net.pos[2] = obj->target->net.pos[2]+obj->clAngles[2];
	}

	obj->thinkTime = g_curTime;
}

//post spawn routine
void ObjLight_PostSpawn(gameObject_t *obj)
{
	if (obj->target && obj->target->inuse)
	{
		obj->parent = obj->target;
		obj->target->child = obj;
		obj->think = ObjLight_Think;
		obj->thinkTime = g_curTime+50;
		obj->net.staticIndex = -1; //bound lights cannot be static
		Math_VecSub(obj->net.pos, obj->target->net.pos, obj->clAngles);
	}
}

//light spawn
void ObjLight_Spawn(gameObject_t *obj, BYTE *b, const objArgs_t *args, int numArgs)
{
	obj->net.solid = -1; //default to no light volume

	obj->postSpawn = ObjLight_PostSpawn;

	bool gotRadius = false;
	bool gotColor = false;
	int lightVolumeIndex = -1;
	obj->net.lerpDuration = 1; //default to shadows
	obj->net.staticIndex = obj->net.index;
	obj->net.frame = 0;
	if (obj->spawnArgs && obj->numSpawnArgs > 0)
	{
		int i = 0;
		while (i < obj->numSpawnArgs)
		{
			const objArgs_t *arg = obj->spawnArgs+i;
			if (!_stricmp(arg->key, "radius"))
			{ //todo - stop being lazy, add non-uniform light support
				obj->net.modelScale[0] = (float)atof(arg->val);
				obj->net.modelScale[1] = obj->net.modelScale[0];
				obj->net.modelScale[2] = obj->net.modelScale[0];
				gotRadius = true;
			}
			else if (!_stricmp(arg->key, "color"))
			{
				Util_ParseVector(arg->val, obj->net.mins);
				gotColor = true;
			}
			else if (!_stricmp(arg->key, "lightVolumeIndex"))
			{
				const char *s = Common_GetValForKey(b, "static");
				if (s && s[0] && atoi(s) == 1)
				{ //made sure the light was static. if it is, use this lightVolumeIndex.
					obj->net.solid = atoi(arg->val);
				}
			}
			else if (!_stricmp(arg->key, "shadows"))
			{
				obj->net.lerpDuration = atoi(arg->val);
			}
			else if (!_stricmp(arg->key, "notmapstatic"))
			{ //force non-static, for moving lights etc
				obj->net.staticIndex = -1;
			}
			else if (!_stricmp(arg->key, "double") && atoi(arg->val) == 1)
			{
				obj->net.frame |= LIGHTFL_DOUBLE;
			}
			else if (!_stricmp(arg->key, "ambprogram") && atoi(arg->val) == 1)
			{
				obj->net.frame |= LIGHTFL_AMBPROG;
			}
			else if (!_stricmp(arg->key, "fullambient") && atoi(arg->val) == 1)
			{
				obj->net.frame |= LIGHTFL_FULLAMB;
			}
			i++;
		}
	}

	if (!gotRadius)
	{
		const char *s = Common_GetValForKey(b, "defaultRadius");
		if (s && s[0])
		{
			obj->net.modelScale[0] = (float)atof(s);
		}
		else
		{
			obj->net.modelScale[0] = 256.0f;
		}
		obj->net.modelScale[1] = obj->net.modelScale[0];
		obj->net.modelScale[2] = obj->net.modelScale[0];
	}

	obj->spawnMins[0] = -obj->net.modelScale[0];
	obj->spawnMins[1] = -obj->net.modelScale[0];
	obj->spawnMins[2] = -obj->net.modelScale[0];
	obj->spawnMaxs[0] = obj->net.modelScale[0];
	obj->spawnMaxs[1] = obj->net.modelScale[0];
	obj->spawnMaxs[2] = obj->net.modelScale[0];

	if (!gotColor)
	{
		const char *s = Common_GetValForKey(b, "defaultColor");
		if (s && s[0])
		{
			Util_ParseVector(s, obj->net.mins);
		}
		else
		{
			obj->net.mins[0] = 1.0f;
			obj->net.mins[1] = 1.0f;
			obj->net.mins[2] = 1.0f;
		}
	}
}
