/*
=============================================================================
Module Information
------------------
Name:			obj_fighter.cpp
Author:			Rich Whitehouse
Description:	fighters
=============================================================================
*/

#include "main.h"

#define FIGHTERFL_ENGAGE	(1<<0)
#define FIGHTERFL_SPINNER	(1<<1)
#define FIGHTERFL_SHOOTER	(1<<2)
#define FIGHTERFL_NAUGHTY	(1<<3)

//die
void ObjFighter_Explode(gameObject_t *obj)
{
	if (!obj->net.solid)
	{
		return;
	}
	float up[3] = {90.0f, 0.0f, 0.0f};
	ObjParticles_Create("fighter/death", obj->net.pos, up, -1);
	ObjSound_Create(obj->net.pos, "assets/sound/other/fighterblow.wav", 1.0f, -1);

	if (obj->generalFlag & FIGHTERFL_NAUGHTY)
	{
		ObjSound_Create(obj->net.pos, "assets/sound/other/pulse_blow.wav", 1.0f, -1);
		float up[3] = {-90.0f, 0.0f, 0.0f};
		ObjParticles_Create("pulser/death", obj->net.pos, up, -1);
	}

	obj->think = ObjGeneral_RemoveThink;
	obj->thinkTime = g_curTime+50;
	obj->net.solid = 0;
	if (obj->rcColModel)
	{
		obj->rcColModel->solid = 0;
	}
}

//fighter die
void ObjFighter_Death(gameObject_s *obj, gameObject_s *killer)
{
	if (g_musical && killer && killer->inuse)
	{
		if (killer->net.index >= MAX_NET_CLIENTS && killer->net.owner < MAX_NET_CLIENTS)
		{
			if (g_gameObjects[killer->net.owner].inuse)
			{
				killer = &g_gameObjects[killer->net.owner];
			}
		}
		if (killer->net.index < MAX_NET_CLIENTS)
		{
			killer->musicalKills++;
			int mul = 1;
			if (killer->musicalKills >= 375)
			{
				mul = 16;
			}
			else if (killer->musicalKills >= 175)
			{
				mul = 8;
			}
			else if (killer->musicalKills >= 75)
			{
				mul = 4;
			}
			else if (killer->musicalKills >= 25)
			{
				mul = 2;
			}
			if (killer->musicalKills == 25 ||
				killer->musicalKills == 75 ||
				killer->musicalKills == 175 ||
				killer->musicalKills == 375)
			{
				int bombAdd = mul/2;
				if (bombAdd > 4)
				{
					bombAdd = 4;
				}
				killer->altFls.clWeaponAmmo += bombAdd;
				killer->net.plAmmo = killer->altFls.clWeaponAmmo;

				g_sharedFn->Net_SendEventType(CLEV_DISPLAYMUL, &mul, sizeof(mul), killer->net.index);
				ObjSound_Create(killer->net.pos, "assets/sound/menu/introsnd.wav", 4.0f, -1);
			}
			killer->net.lives += (100*mul);
			if (killer->net.lives > 99999999)
			{
				killer->net.lives = 99999999;
			}
			LServ_MusicalScoreLog(killer);
		}
	}
	ObjFighter_Explode(obj);
}

//touch
void ObjFighter_Touch(gameObject_s *obj, gameObject_s *other, const collObj_t *col)
{
	if (!(obj->generalFlag & FIGHTERFL_NAUGHTY))
	{
		return;
	}

	char *snd;
	int r = rand()%30;
	if (r > 20)
	{
		snd = "assets/sound/other/pulse_b1.wav";
	}
	else if (r > 10)
	{
		snd = "assets/sound/other/pulse_b2.wav";
	}
	else
	{
		snd = "assets/sound/other/pulse_b3.wav";
	}
	ObjSound_Create(obj->net.pos, snd, 1.0f, -1);
}

//pain
void ObjFighter_Pain(gameObject_s *obj, gameObject_s *hurter, int dmg)
{
	if (!(obj->generalFlag & FIGHTERFL_NAUGHTY))
	{
		return;
	}

	if (hurter && hurter->inuse && (hurter->projDamage || (hurter->net.renderEffects & FXFL_SPECIALBLEND)))
	{
		float scaleInc = 1.01f;
		obj->net.modelScale[0] *= scaleInc;
		obj->net.modelScale[1] *= scaleInc;
		obj->net.modelScale[2] *= scaleInc;
		obj->radius *= scaleInc;
		obj->spawnMins[0] *= scaleInc;
		obj->spawnMins[1] *= scaleInc;
		obj->spawnMins[2] *= scaleInc;
		obj->spawnMaxs[0] *= scaleInc;
		obj->spawnMaxs[1] *= scaleInc;
		obj->spawnMaxs[2] *= scaleInc;
		obj->net.mins[0] *= scaleInc;
		obj->net.mins[1] *= scaleInc;
		obj->net.mins[2] *= scaleInc;
		obj->net.maxs[0] *= scaleInc;
		obj->net.maxs[1] *= scaleInc;
		obj->net.maxs[2] *= scaleInc;
	}
	ObjFighter_Touch(obj, hurter, NULL);
}

//perform fighter "ai"
bool ObjFighter_AI(gameObject_t *obj, float timeMod)
{
	float xyDist = 0.0f;
	gameObject_t *cam = &g_gameObjects[CAM_TRACK_NUM];
	if (cam->inuse)
	{
		float xyD[2] = {cam->net.pos[0]-obj->net.pos[0], cam->net.pos[1]-obj->net.pos[1]};
		xyDist = (xyD[0]*xyD[0] + xyD[1]*xyD[1]);
	}

	if (!obj->enemy || !obj->enemy->inuse || xyDist > 5000.0f*5000.0f)
	{ //go away
		ObjFighter_Explode(obj);
		return false;
	}

	gameObject_t *en = obj->enemy;

	float d[3];
	Math_VecSub(en->net.pos, obj->net.pos, d);
	float enDist = Math_VecLen(d);

	Math_VecNorm(d);
	float slingFactor = 15.0f;//0.005f;
	if (g_musical)
	{
		float musBase = (g_musicalRunningAvg/(float)g_musicalRunningCount);
		if (musBase > 0.35f)
		{
			musBase = 0.35f;
		}
		slingFactor *= musBase*3.0f;
	}
	if (en->net.index < MAX_NET_CLIENTS &&
		en->debounce2 > g_curTime)
	{ //don't go after invincible enemy as quickly
		slingFactor *= 0.2f;
	}
	slingFactor *= timeMod;
	float bounce = 0.0f;

	if (obj->generalFlag & FIGHTERFL_NAUGHTY)
	{
		obj->net.ang[YAW] += timeMod*4.0f;
		slingFactor *= 1.2f;
		bounce = 0.7f;
	}

	if (enDist < 1800.0f)
	{
		if (obj->generalFlag & FIGHTERFL_SPINNER)
		{
			if (obj->debounce4 < g_curTime)
			{
				obj->debounce4 = g_curTime + 2500 + rand()%3000;
				obj->debounce3 = g_curTime + 1500 + rand()%3000;
			}

			if (obj->debounce3 >= g_curTime)
			{
				obj->net.ang[YAW] += timeMod*30.0f;
				if (!g_musical && obj->debounce5 < g_curTime)
				{
					float fwd[3];
					Math_AngleVectors(obj->net.ang, fwd, 0, 0);
					ObjProjectile_Create(obj, "obj_proj_smallbeam_blue", obj->net.pos, fwd);
					obj->debounce5 = g_curTime + 50;// + rand()%100;
				}
			}
		}
		if (!g_musical && (obj->generalFlag & FIGHTERFL_SHOOTER))
		{
			if (obj->debounce5 < g_curTime)
			{
				float fwd[3];
				Math_AngleVectors(obj->net.ang, fwd, 0, 0);
				gameObject_t *prj = ObjProjectile_Create(obj, "obj_proj_smallbeam_blue", obj->net.pos, fwd);
				if (prj && prj->inuse)
				{ //hax
					prj->projVelocity[0] *= 2.2f;
				}
				obj->debounce5 = g_curTime + 100 + rand()%100;
			}
		}
		if (g_musical &&
			((obj->generalFlag & FIGHTERFL_SHOOTER) || (obj->generalFlag & FIGHTERFL_SPINNER)))
		{
			if ((g_musicalAmp-g_musicalLastFrame) > 0.04f || g_musicalAmp >= 0.5f)// && rand()%10 <= 8)
			{ //large change last frame in the music
				if (obj->debounce5 < g_curTime)
				{
					float fwd[3];
					Math_AngleVectors(obj->net.ang, fwd, 0, 0);
					gameObject_t *prj = ObjProjectile_Create(obj, "obj_proj_smallbeam_blue", obj->net.pos, fwd);
					if (prj && prj->inuse)
					{ //hax
						prj->projVelocity[0] *= (0.1f+(g_musicalAmp*3.0f));
					}
					if ((g_musicalAmp-g_musicalLastFrame) > 0.04f)
					{
						obj->debounce5 = g_curTime + 50;
					}
					else
					{
						obj->debounce5 = g_curTime + 250;
					}
				}
			}
		}
	}

	float oldPos[3];
	Math_VecCopy(obj->net.pos, oldPos);

	if (obj->debounce3 < g_curTime)
	{
		obj->net.vel[0] += d[0]*slingFactor;
		obj->net.vel[1] += d[1]*slingFactor;
		obj->net.vel[2] += d[2]*slingFactor;

		if (!(obj->generalFlag & FIGHTERFL_NAUGHTY))
		{
			float nang[3];
			Math_VecToAngles(obj->net.vel, nang);
			float angleBlend = 0.1f;
			if (g_musical)
			{
				angleBlend = 0.4f;
			}
			if (obj->generalFlag & FIGHTERFL_SHOOTER)
			{
				angleBlend = 0.4f;
			}
			for (int i = 0; i < 3; i++)
			{
				float ang = (360.0f/65536.0f)*((int)(nang[i]*(65536.0f/360.0f)) & 65535);
				obj->net.ang[i] = Math_BlendAngle(obj->net.ang[i], ang, timeMod*angleBlend);
			}
		}
	}

	float attackRad = obj->radius*0.5f;
//	if (obj->generalFlag & FIGHTERFL_NAUGHTY)
//	{
//		attackRad = obj->radius;
//	}

	Phys_ApplyObjectPhysics(obj, timeMod, attackRad, 0.0f, bounce);
	if (obj->net.pos[2] != g_fetusPilotZ)
	{
		float check[3];
		check[0] = obj->net.pos[0];
		check[1] = obj->net.pos[1];
		check[2] = g_fetusPilotZ;

		collObj_t collision;
		g_sharedFn->Coll_RadiusTranslation(obj->rcColModel, &collision, obj->net.pos, check, obj->radius, NULL, false);
		if (!collision.hit && !collision.containsSolid)
		{
			obj->net.pos[2] = g_fetusPilotZ;//en->net.pos[2];
		}
	}

	collObj_t col;
	g_sharedFn->Coll_RadiusTranslation(obj->rcColModel, &col, obj->net.pos, obj->net.pos, attackRad, NULL, false);
	if (col.containsSolid && col.hitObjectIndex >= 0 &&
		col.hitObjectIndex < MAX_GAME_OBJECTS &&
		g_gameObjects[col.hitObjectIndex].net.staticIndex != -1)
	{ //bad move
		Math_VecCopy(oldPos, obj->net.pos);
	}

	if (enDist <= attackRad*2.0f)
	{ //touch death
		if (obj->net.solid)
		{
			int touchDmg = 10000;
			if (g_musical)
			{
				touchDmg = 50;
			}
			Util_DamageObject(obj, en, touchDmg);
		}
		//me too~
		ObjFighter_Explode(obj);
		return false;
	}

	return true;
}

//fighter think
void ObjFighter_Think(gameObject_t *obj, float timeMod)
{
	if (obj->spawnLife && obj->spawnLife < g_curTime)
	{
		ObjFighter_Explode(obj);
		return;
	}

	if (!(obj->generalFlag & FIGHTERFL_ENGAGE))
	{ //waiting for the player(s)
		gameObject_t *cam = &g_gameObjects[CAM_TRACK_NUM];
		if (cam->inuse && g_camFrustumFresh)
		{
			const float waitDist = 4096.0f*4096.0f;
			if (Util_CamProx2D(obj->net.pos, waitDist))
			{ //go
				obj->generalFlag |= FIGHTERFL_ENGAGE;

				//find the closest player at time of activation
				gameObject_t *closestPl = NULL;
				float bestDist;
				for (int i = 0; i < MAX_NET_CLIENTS; i++)
				{
					gameObject_t *pl = &g_gameObjects[i];
					if (!pl->inuse)
					{
						continue;
					}
					float d[3];
					Math_VecSub(pl->net.pos, obj->net.pos, d);
					float dist = Math_VecLen(d);
					if (!closestPl || dist < bestDist)
					{
						closestPl = pl;
						bestDist = dist;
					}
					obj->enemy = closestPl;
				}
			}
		}
	}

	if (obj->generalFlag & FIGHTERFL_ENGAGE)
	{ //g0g0g0
		obj->localFlags &= ~LFL_NONET;
		if (!ObjFighter_AI(obj, timeMod))
		{ //done
			return;
		}
	}
	else
	{ //no sense in sending to client while hiding offscreen, avoid frustum cull expense
		obj->localFlags |= LFL_NONET;
	}

	obj->thinkTime = g_curTime;
}

//fighter spawn
void ObjFighter_Spawn(gameObject_t *obj, BYTE *b, const objArgs_t *args, int numArgs)
{
	if (g_musical)
	{
		obj->spawnLife = g_curTime+5000;
	}

	g_sharedFn->Common_ServerString("&&fighter/death");
	g_sharedFn->Common_ServerString("$assets/sound/other/fighterblow.wav");

	const char *spinner = Common_GetValForKey(b, "spinner");
	if (spinner && atoi(spinner) == 1)
	{
        obj->generalFlag |= FIGHTERFL_SPINNER;
	}
	const char *shooter = Common_GetValForKey(b, "shooter");
	if (shooter && atoi(shooter) == 1)
	{
        obj->generalFlag |= FIGHTERFL_SHOOTER;
	}
	const char *naughty = Common_GetValForKey(b, "naughty");
	if (naughty && atoi(naughty) == 1)
	{
		g_sharedFn->Common_ServerString("$assets/sound/other/pulse_blow.wav");
		g_sharedFn->Common_ServerString("$assets/sound/other/pulse_b1.wav");
		g_sharedFn->Common_ServerString("$assets/sound/other/pulse_b2.wav");
		g_sharedFn->Common_ServerString("$assets/sound/other/pulse_b3.wav");
		g_sharedFn->Common_ServerString("&&pulser/death");
        obj->generalFlag |= FIGHTERFL_NAUGHTY;
		obj->pain = ObjFighter_Pain;
	}

	obj->localFlags |= LFL_ENEMY;

	obj->hurtable = 1;
	//obj->health = 20;

	obj->touch = ObjFighter_Touch;
	obj->death = ObjFighter_Death;
	obj->think = ObjFighter_Think;
	obj->thinkTime = g_curTime+50;
}
