/*
=============================================================================
Module Information
------------------
Name:			obj_camtrack.cpp
Author:			Rich Whitehouse
Description:	server logic object: fetus camera tracker
=============================================================================
*/

#include "main.h"

extern float g_initialFPSPos[3];

viewFrustum_t g_camFrustum;
viewFrustum_t g_wideCamFrustum;
bool g_camFrustumFresh = false;
bool g_fpsMode = false;

unsigned long g_noConfineTime = 0;

//do stuff if appropriate
void ObjCamMarker_Trigger(gameObject_s *obj, gameObject_s *other, const collObj_t *col)
{
	if (obj->spawnArgs && obj->numSpawnArgs > 0)
	{
		int i = 0;
		while (i < obj->numSpawnArgs)
		{
			const objArgs_t *arg = obj->spawnArgs+i;
			if (!_stricmp(arg->key, "camflip"))
			{
				g_fetusSideMode = !!atoi(arg->val);
				g_noConfineTime = g_curTime+2000;
			}
			else if (!_stricmp(arg->key, "camspeed"))
			{
				sscanf(arg->val, "(%f %f %f)", &g_levelScroll[0], &g_levelScroll[1], &g_levelScroll[2]);
			}
			i++;
		}
	}
}

//camera marker spawn function
void ObjCamMarker_Spawn(gameObject_t *obj, BYTE *b, const objArgs_t *args, int numArgs)
{
	obj->localFlags |= LFL_NONET;
	obj->inuse |= INUSE_NONET; //don't need markers sent to the client ever.
	obj->touch = ObjCamMarker_Trigger;

	g_fpsMode = false;
	if (obj->spawnArgs && obj->numSpawnArgs > 0)
	{
		int i = 0;
		while (i < obj->numSpawnArgs)
		{
			const objArgs_t *arg = obj->spawnArgs+i;
			if (!_stricmp(arg->key, "fps"))
			{
				if (atoi(arg->val) == 1)
				{
					gameObject_t *cam = &g_gameObjects[CAM_TRACK_NUM];
					if (cam->inuse)
					{
						cam->net.renderEffects |= FXFL_FPSMODE;
					}
					g_fpsMode = true;
					g_initialFPSPos[0] = obj->net.pos[0];
					g_initialFPSPos[1] = obj->net.pos[1];
					g_initialFPSPos[2] = obj->net.pos[2];
				}
				break;
			}
			else if (!_stricmp(arg->key, "musical"))
			{
				gameObject_t *cam = &g_gameObjects[CAM_TRACK_NUM];
				if (cam->inuse)
				{
					cam->net.renderEffects |= FXFL_MUSICAL;
				}
				g_musical = true;
			}
			i++;
		}
	}

	//hack - stage music
	if (g_musical)
	{
		g_musicStrIndex = g_sharedFn->Common_ServerString("$@assets/music/l2boss.mp3");
	}
	else if (g_fpsMode)
	{ //no music
		g_sharedFn->Common_ServerString("$$");
	}
	else
	{ //music
		g_sharedFn->Common_ServerString("$$assets/music/l2.mp3");
	}
}

//remove something if it is not within the camera visibility range
void ObjCam_Removal(gameObject_t *obj)
{
	if (!g_camFrustumFresh)
	{
		return;
	}

	float radius = Util_RadiusFromBounds(obj->spawnMins, obj->spawnMaxs, 3.0f);
	if (!radius)
	{
		radius = 128.0f;
	}
	if (!Math_PointInFrustum(&g_camFrustum, obj->net.pos, radius))
	{
		LServ_FreeObject(obj);
	}
}

//frame function
void ObjCam_Think(gameObject_t *obj, float timeMod)
{
	if (g_fpsMode)
	{ //no cam thinking in fps mode
		//update cam frustum
		float ang[3];
		ang[0] = (-90.0f)+obj->net.ang[0];
		ang[1] = obj->net.ang[1];
		ang[2] = obj->net.ang[2];
		Math_CreateFrustum(70.0f, obj->net.pos, ang, &g_camFrustum);
		Math_CreateFrustum(93.33334f, obj->net.pos, ang, &g_wideCamFrustum);
		g_camFrustumFresh = true;
		ObjVisBlock_Update(obj->net.pos);
		return;
	}
	float mus = 1.0f;
	if (g_musical)
	{
		mus = (g_musicalRunningAvg/(float)g_musicalRunningCount)*3.0f;
	}
	//obj->camTrackPos[0] += g_levelScroll[0]*timeMod;
	//obj->camTrackPos[1] += g_levelScroll[1]*timeMod;
	float d[3];
	float nDist = 999.0f;
	float tol = g_levelScroll[0]*mus*2;
	if (obj->target && obj->target->inuse)
	{
		Math_VecSub(obj->target->net.pos, obj->camTrackPos, d);
		nDist = Math_VecNorm(d);
	}
	else
	{
		d[0] = 0.0f;
		d[1] = 0.0f;
		d[2] = 0.0f;
	}

	obj->camTrackPos[0] += (d[0]*g_levelScroll[0])*mus*timeMod;
	obj->camTrackPos[1] += (d[1]*g_levelScroll[1])*mus*timeMod;
	obj->camTrackPos[2] += (d[2]*g_levelScroll[2])*mus*timeMod;

	const float angleBlendScale = 0.07f;//0.1f;
	const float moveBlendScale = 0.1f;
	if (g_fetusSideMode)
	{
		g_fetusSideModeX = obj->camTrackPos[1]+2048;
		/*
		if (g_gameObjects[0].inuse)
		{
			obj->net.pos[1] = Util_NudgeValue(obj->net.pos[1], g_gameObjects[0].net.pos[1]-2048.0f, timeMod*moveBlendScale);
		}
		*/
		obj->net.pos[0] = obj->camTrackPos[0];
		obj->net.pos[1] = obj->camTrackPos[1];
		obj->net.pos[2] = obj->camTrackPos[2];//Util_NudgeValue(obj->net.pos[2], obj->camTrackPos[2], timeMod*moveBlendScale);
		obj->net.ang[YAW] = Math_BlendAngle(obj->net.ang[YAW], 90.0f, timeMod*angleBlendScale);
		//obj->net.ang[ROLL] = Math_BlendAngle(obj->net.ang[ROLL], 90.0f, timeMod*angleBlendScale);
		obj->net.ang[ROLL] = Math_BlendAngle(obj->net.ang[ROLL], 0.0f, timeMod*angleBlendScale);
		obj->net.ang[PITCH] = Math_BlendAngle(obj->net.ang[PITCH], 90.0f, timeMod*angleBlendScale);
	}
	else
	{
		obj->net.pos[0] = obj->camTrackPos[0];
		obj->net.pos[1] = obj->camTrackPos[1];//Util_NudgeValue(obj->net.pos[1], obj->camTrackPos[1], timeMod*moveBlendScale);
		obj->net.pos[2] = obj->camTrackPos[2];//Util_NudgeValue(obj->net.pos[2], obj->camTrackPos[2], timeMod*moveBlendScale);
		obj->net.ang[YAW] = Math_BlendAngle(obj->net.ang[YAW], 0.0f, timeMod*angleBlendScale);
		obj->net.ang[ROLL] = Math_BlendAngle(obj->net.ang[ROLL], 0.0f, timeMod*angleBlendScale);
		obj->net.ang[PITCH] = Math_BlendAngle(obj->net.ang[PITCH], 180.0f, timeMod*angleBlendScale);
	}

	//move player objects along with the cam
	int i = 0;
	while (i < MAX_NET_CLIENTS)
	{
		if (g_gameObjects[i].inuse)
		{
			float oldPos[3];
			Math_VecCopy(g_gameObjects[i].net.pos, oldPos);
            //g_gameObjects[i].net.pos[0] += g_levelScroll[0]*timeMod;
			//g_gameObjects[i].net.pos[1] += g_levelScroll[1]*timeMod;
			g_gameObjects[i].net.pos[0] += (d[0]*g_levelScroll[0])*mus*timeMod;
			g_gameObjects[i].net.pos[1] += (d[1]*g_levelScroll[1])*mus*timeMod;
			g_gameObjects[i].net.pos[2] += (d[2]*g_levelScroll[2])*mus*timeMod;
			ObjPlayer_CameraConfine(&g_gameObjects[i]);
			if (g_gameObjects[i].net.pos[0] != oldPos[0] ||
				g_gameObjects[i].net.pos[1] != oldPos[1] ||
				g_gameObjects[i].net.pos[2] != oldPos[2])
			{
				collObj_t col;
				g_sharedFn->Coll_RadiusTranslation(g_gameObjects[i].rcColModel, &col, oldPos, g_gameObjects[i].net.pos, g_gameObjects[i].radius, NULL, false);
				if ((col.hit || col.containsSolid) && col.hitObjectIndex >= 0 &&
					col.hitObjectIndex < MAX_GAME_OBJECTS)
				{
					gameObject_t *other = &g_gameObjects[col.hitObjectIndex];
					if (other->inuse)
					{
						Util_TouchObjects(&g_gameObjects[i], other, &col);
					}
				}
			}
		}
		i++;
	}

	//2d background is scrolled on client based on camera maxs values
	if (g_fetusSideMode)
	{
		obj->net.maxs[0] = d[2]*g_levelScroll[2]*mus;
		obj->net.maxs[1] = -d[0]*g_levelScroll[0]*mus;
	}
	else
	{
		obj->net.maxs[0] = d[0]*g_levelScroll[0]*mus;
		obj->net.maxs[1] = d[1]*g_levelScroll[1]*mus;
	}

	if (nDist < tol)
	{ //move to the next target
		if (obj->target->touch)
		{
			obj->target->touch(obj->target, obj, NULL);
		}
		obj->target = obj->target->target;
	}

	//update cam frustum
	float ang[3];
	ang[0] = (-90.0f)+obj->net.ang[0];
	ang[1] = obj->net.ang[1];
	ang[2] = obj->net.ang[2];
	Math_CreateFrustum(70.0f, obj->net.pos, ang, &g_camFrustum);
	Math_CreateFrustum(93.33334f, obj->net.pos, ang, &g_wideCamFrustum);
	g_camFrustumFresh = true;
	ObjVisBlock_Update(obj->net.pos);
}
