#ifndef _MAIN_H
#define _MAIN_H

#include <windows.h>
#include <stdio.h>
#include <io.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <math.h>
#include <assert.h>
#include "sharedtypes.h"
#include "sharedfn.h"

extern float g_timeScale;
extern float g_invTimeScale;

extern sharedSVFunctions_t *g_sharedFn;
extern unsigned long g_curTime;
extern bool g_runningMultiplayer;

extern float g_fetusPilotZ;
#define DEFAULT_CAM_Z 2560.0f
#define DEFAULT_PLR_Z 512.0f
extern float g_levelScroll[3];

extern bool g_fetusSideMode;
extern float g_fetusSideModeX;

extern viewFrustum_t g_camFrustum;
extern viewFrustum_t g_wideCamFrustum;
extern bool g_camFrustumFresh;
extern bool g_fpsMode;

extern bool g_musical;
extern int g_musicStrIndex;
extern float g_musicalAmp;
extern float g_musicalRunningAvg;
extern float g_musicalLastFrame;
extern int g_musicalRunningCount;

extern unsigned long g_noConfineTime;

#define DEFAULT_GRAVITY		80

#define	DEFAULT_PLAYER_HEALTH	40//20//100
#define DEFAULT_PLAYER_LIVES	9//6//3

#define MAX_GAME_OBJECTS	8192//1024

//for convenience
#define Math_CalcPlaneEq						g_sharedFn->Math_CalcPlaneEq
#define Math_VecNorm2							g_sharedFn->Math_VecNorm2
#define Math_VecNorm							g_sharedFn->Math_VecNorm
#define Math_PlaneNorm							g_sharedFn->Math_PlaneNorm
#define Math_VecLen								g_sharedFn->Math_VecLen
#define Math_PlaneDist							g_sharedFn->Math_PlaneDist
#define Math_ProjectOntoPlane					g_sharedFn->Math_ProjectOntoPlane
#define Math_VecCopy							g_sharedFn->Math_VecCopy
#define Math_VecSub								g_sharedFn->Math_VecSub
#define Math_VecAdd								g_sharedFn->Math_VecAdd
#define Math_VecScale							g_sharedFn->Math_VecScale
#define Math_Max2								g_sharedFn->Math_Max2
#define Math_Max3								g_sharedFn->Math_Max3
#define Math_TransformPointByMatrix				g_sharedFn->Math_TransformPointByMatrix
#define Math_TransformPointByMatrix3x3			g_sharedFn->Math_TransformPointByMatrix3x3
#define Math_TransformPoint						g_sharedFn->Math_TransformPoint
#define Math_VecMA								g_sharedFn->Math_VecMA
#define Math_VecToAngles						g_sharedFn->Math_VecToAngles
#define Math_TransformPoint2					g_sharedFn->Math_TransformPoint2
#define Math_MatrixInverse						g_sharedFn->Math_MatrixInverse
#define Math_MatrixMultiply						g_sharedFn->Math_MatrixMultiply
#define Math_MatrixMultiply3x3					g_sharedFn->Math_MatrixMultiply3x3
#define Math_MatrixMultiply4x4					g_sharedFn->Math_MatrixMultiply4x4
#define Math_AnglesToMat						g_sharedFn->Math_AnglesToMat
#define Math_CrossProduct						g_sharedFn->Math_CrossProduct
#define Math_DotProduct							g_sharedFn->Math_DotProduct
#define Math_AngleMod							g_sharedFn->Math_AngleMod
#define Math_InterpolateVector					g_sharedFn->Math_InterpolateVector
#define Math_BlendAngle							g_sharedFn->Math_BlendAngle
#define Math_AngleVectors						g_sharedFn->Math_AngleVectors
#define Math_CreateMatrixFromOrientation		g_sharedFn->Math_CreateMatrixFromOrientation
#define Math_RotationMatrix						g_sharedFn->Math_RotationMatrix
#define Math_BoxesOverlap						g_sharedFn->Math_BoxesOverlap
#define Math_ExpandBounds						g_sharedFn->Math_ExpandBounds
#define Math_CreateFrustum						g_sharedFn->Math_CreateFrustum
#define Math_PointRelativeToPlane				g_sharedFn->Math_PointRelativeToPlane
#define Math_GetBoundsPoints					g_sharedFn->Math_GetBoundsPoints
#define Math_PointInFrustum						g_sharedFn->Math_PointInFrustum
#define Math_BoxInFrustum						g_sharedFn->Math_BoxInFrustum

#define Common_GetEntryForObject				g_sharedFn->Common_GetEntryForObject
#define Common_GetValForKey						g_sharedFn->Common_GetValForKey
#define Common_SetValForKey						g_sharedFn->Common_SetValForKey

typedef struct fetusLiveState_s
{
	int					clWeapon;
	int					clWeaponPressShots;
	unsigned long		clWeaponDelay;
	unsigned long		clWeaponCharge;
	unsigned long		clWeaponDepressDur;
	int					clWeaponAmmo;
	bool				playerSpawnSeq;
} fetusLiveState_t;

#define LFL_NONET	(1<<0)
#define LFL_ENEMY	(1<<1)

//extra vis blocker data
typedef struct gameVisBlocker_s
{
	float		plane[4];
	float		minsS1[3];
	float		maxsS1[3];
	float		minsS2[3];
	float		maxsS2[3];
} gameVisBlocker_t;

typedef struct clientInfo_s
{
	char		infoStr[MAX_CLIENT_INFO_SIZE];
} clientInfo_t;

//main game object structure
typedef struct gameObject_s
{
	//the inuse int and gameObjectNet_t object must always be
	//at the top. this is because the engine makes this
	//assumption when reading the net data from a game object.
	int					inuse;
	gameObjNet_t		net;
#ifdef _RC_NOVODEX
	void				*nxActor;
#endif
	rcColModel_t		*rcColModel;

	//you may modify below here freely
	unsigned long		noReuseTime;
	void				(*customSpawn)(gameObject_s *obj, BYTE *b, const objArgs_t *args, int numArgs);
	void				(*postSpawn)(gameObject_s *obj);
	void				(*think)(gameObject_s *obj, float timeMod);
	void				(*touch)(gameObject_s *obj, gameObject_s *other, const collObj_t *col);
	void				(*pain)(gameObject_s *obj, gameObject_s *hurter, int dmg);
	void				(*death)(gameObject_s *obj, gameObject_s *killer);
	unsigned long		thinkTime;
	BYTE				clButtons[MAX_BUTTONS];
	float				clAngles[3];
	WORD				clAnalog[4];
	bool				hasClAnalog;
	float				lastClAngles[3];
	bool				hasLastClAngles;

	bool				getPhysFromNovodex;

	float				spawnMins[3];
	float				spawnMaxs[3];

	int					hurtable;
	int					health;

	BYTE				*objData;

	gameVisBlocker_t	*visBlockData;

	float				radius;

	fetusLiveState_t	fls;
	fetusLiveState_t	altFls;

#ifdef _RC_NOVODEX
	int					dynphys;
	int					staticphys;
#endif

	unsigned long		debounce;
	unsigned long		debounce2;
	unsigned long		debounce3;
	unsigned long		debounce4;
	unsigned long		debounce5;
	int					generalFlag;

	unsigned long		spawnLife;

	int					localFlags;

	int					musicalKills;

	//physics
	float				bounceFactor;
	bool				onGround;

	float				camTrackPos[3];

	float				projVelAng[3];
	float				projVelocity[3];
	float				projFriction[3];
	int					projDamage;

	float				safePos[3];

	int					localRecursionTick;

	gameObject_s		*enemy;
	gameObject_s		*target;
	gameObject_s		*child;
	gameObject_s		*parent;

	const objArgs_t		*spawnArgs;
	int					numSpawnArgs;

	bool				localAngles;
} gameObject_t;

extern gameObject_t g_gameObjects[MAX_GAME_OBJECTS];
extern int g_gameObjectSlots;

//all permanent game values, that remain persistant through
//level transitions and are used for saving/loading
typedef struct gameValues_s
{
	int					bling;
} gameValues_t;

extern gameValues_t g_gameValues;

//main.cpp
extern gameObject_t *LServ_CreateObject(void);
extern void LServ_FreeObject(gameObject_t *obj);
extern void LServ_CacheObj(const char *objName);
gameObject_t *LServ_ObjectFromName(const char *objName, float *pos, float *ang, const objArgs_t *args, int numArgs);
extern void LServ_UpdateRClip(gameObject_t *obj);
extern void LServ_MusicalScoreLog(gameObject_t *client);

//obj_bigjesus.cpp
extern void ObjBigJesus_Spawn(gameObject_t *obj, BYTE *b, const objArgs_t *args, int numArgs);

//obj_camtrack.cpp
extern void ObjCamMarker_Spawn(gameObject_t *obj, BYTE *b, const objArgs_t *args, int numArgs);
extern void ObjCam_Removal(gameObject_t *obj);
extern void ObjCam_Think(gameObject_t *obj, float timeMod);

//obj_fighter.cpp
extern void ObjFighter_Spawn(gameObject_t *obj, BYTE *b, const objArgs_t *args, int numArgs);

//obj_general.cpp
extern void ObjGeneral_RemoveThink(gameObject_t *obj, float timeMod);
extern void ObjGeneral_Think(gameObject_t *obj, float timeMod);

//obj_lift.cpp
extern void ObjLift_Spawn(gameObject_t *obj, BYTE *b, const objArgs_t *args, int numArgs);

//obj_light.cpp
extern void ObjLight_Spawn(gameObject_t *obj, BYTE *b, const objArgs_t *args, int numArgs);

//obj_player.cpp
extern void ObjPlayer_Touch(gameObject_s *obj, gameObject_s *other, const collObj_t *col);
extern void ObjPlayer_Death(gameObject_s *obj, gameObject_s *killer);
extern void ObjPlayer_Think(gameObject_t *obj, float timeMod);
extern void ObjPlayer_CameraConfine(gameObject_t *obj);

//obj_pulser.cpp
extern void ObjPulser_Spawn(gameObject_t *obj, BYTE *b, const objArgs_t *args, int numArgs);

//obj_particles.cpp
extern void ObjParticles_Create(const char *particles, const float *pos, const float *ang, int owner);

//obj_projectiles.cpp
extern void ObjProjectile_Init(void);
extern void ObjProjectile_Spawn(gameObject_t *obj, BYTE *b, const objArgs_t *args, int numArgs);
extern gameObject_t *ObjProjectile_Create(gameObject_t *owner, const char *name, float *pos, float *dir);
extern void ObjProjectile_Think(gameObject_t *obj, float timeMod);

//obj_snakehead.cpp
extern void ObjSnakeHead_Spawn(gameObject_t *obj, BYTE *b, const objArgs_t *args, int numArgs);

//obj_sound.cpp
extern void ObjSound_CreateFromIndex(float *pos, int index, float volume, int attachIndex);
extern void ObjSound_Create(float *pos, const char *sound, float volume, int attachIndex);

//obj_soundemit.cpp
extern void ObjSoundEmit_Spawn(gameObject_t *obj, BYTE *b, const objArgs_t *args, int numArgs);

//obj_supernova.cpp
extern void ObjSupernova_Spawn(gameObject_t *obj, BYTE *b, const objArgs_t *args, int numArgs);

//obj_visblock.cpp
extern void ObjVisBlock_Update(float *pos);
extern bool ObjVisBlock_CheckVis(gameObject_t *obj);
extern void ObjVisBlock_DebugDraw(void);
extern void ObjVisBlock_EstablishVis(void);
extern void ObjVisBlock_Spawn(gameObject_t *obj, BYTE *b, const objArgs_t *args, int numArgs);

//physics.cpp
extern float Phys_InterpolateAngle(float old, float cur, float val, float tresh);
extern void Phys_TranslatePusher(gameObject_t *pusher, float *dest);
extern void Phys_ApplyObjectPhysics(gameObject_t *obj, float timeMod, float objRad, float gravFactor, float bounceFactor);

//util.cpp
extern bool Util_ParseObjSpawn(const char *str, gameObject_t *obj);
extern bool Util_ParseObjType(const char *str, int *out);
extern bool Util_ParseVector(const char *str, float *out);
extern bool Util_ParseInt(const char *str, int *out);
extern float Util_NudgeValue(float cur, float dst, float fact);
extern float Util_RadiusFromBounds(float *mins, float *maxs, float padMul);
extern bool Util_GameObjectsOverlap(gameObject_t *obja, gameObject_t *objb);
extern void Util_TouchObjects(gameObject_t *obj1, gameObject_t *obj2, const collObj_t *col);
extern void Util_ProjectDecal(gameObject_t *obj, const float *start, const float *end, const char *decal, float decalSize, int decalLife, int decalFade);
extern bool Util_DamageObject(gameObject_t *damager, gameObject_t *victim, int damage);
extern bool Util_CamProx2D(float *pos, const float d);
extern void Util_DebugBox(float *mins, float *maxs, float *color);
extern void Util_DebugFX(float *pos, float *dir);

#endif //_MAIN_H
