!!ARBfp1.0

#standard lighting with normal mapping and per pixel attenuation
#written by Rich Whitehouse
#---------------------------------------------------------------------
#please credit me if you find something here useful or informative. ^^
#it is written to closely imitate the general behaviour of register
#combiners (thus the normal expansion) because the implementation in
#my engine is mostly shared between the nv combiner path and the
#fragment program path.
#---------------------------------------------------------------------

#texture3 is the reference cubemap
#texture2 is the decal
#texture1 is the 3d attenuation texture
#texture0 is the normal map

PARAM	mulf = {2.0, 2.0, 2.0};
PARAM	subf = {1.0, 1.0, 1.0};

OUTPUT	out = result.color;
TEMP	cbrf, nrml, dcal, attn, temp;

#fetch the textures
TEX	cbrf, fragment.texcoord[3], texture[3], CUBE;
TEX	nrml, fragment.texcoord[0], texture[0], 2D;
TEX	dcal, fragment.texcoord[2], texture[2], 2D;
TEX	attn, fragment.texcoord[1], texture[1], 3D;

#expand the normals
MUL	nrml, nrml, mulf;
SUB	nrml, nrml, subf;
MUL	cbrf, cbrf, mulf;
SUB	cbrf, cbrf, subf;

DP3	temp, nrml, cbrf; #do the dot3

MUL	temp, temp, fragment.color; #factor in light color
MUL	temp, dcal, temp; #factor in decal
MUL	temp, attn, temp; #factor in attenuation

MOV	temp.a, dcal.a; #set alpha component by decal

MOV	out, temp;

END
