#ifndef _DS_SOUND_MGR_H
#define _DS_SOUND_MGR_H

#define _EWRAM_AUDIO_BUFFER

#define APU_SOUND_FREQ 22050 //11025

enum sound_buf_pos
{
	SOUND_BUF_LOW,
	SOUND_BUF_HIGH
};
extern uint32 g_sample_rate NESTER_ARM7EWRAM_BSS;
extern uint32 g_sample_size NESTER_ARM7EWRAM_BSS;
extern uint32 buffer_len NESTER_ARM7EWRAM_BSS;

extern uint8 g_whichHalfDoYouOwn;
extern uint32 g_sampleRateFlag; //DSPIP6
extern uint32 g_bufPlace; //DSPIP6

#ifdef _EWRAM_AUDIO_BUFFER
extern uint8 *g_audioBuffer; //DSPIP3
#else
#define STATIC_SND_BUFFER_SIZE 16384 //1600
extern uint8 g_audioBuffer[STATIC_SND_BUFFER_SIZE];
#endif

void DSSM_FakeConstructor(uint32 sample_rate, uint32 sample_size, uint32 buffer_length_in_frames);
void DSSM_reset();
void DSSM_freeze();
void DSSM_thaw();
void DSSM_clear_buffer(); // clears out sound buffer with silence
uint8 *DSSM_lock(sound_buf_pos which, uint32* buf_len);
void DSSM_unlock();
uint32 DSSM_get_buffer_len();
sound_buf_pos DSSM_get_currently_playing_half();
boolean DSSM_IsNull();

__inline uint32 DSSM_get_sample_rate() { return g_sample_rate; }
__inline uint32 DSSM_get_sample_size() { return g_sample_size; }
#endif
