#include <NDS/NDS.h>
//#include "nes/apu/nes_apu_wrapper.h"
#include <stdio.h>
#include <string.h> //DSPIP3
#include <stdlib.h> //DSPIP3
#include "../../src/types.h"
#include "../../../src/nes/cpu/nes6502.h"
#include "../../../src/arm7_shared.h"
#include "ds_sound_mgr.h"

uint32 g_sample_rate NESTER_ARM7EWRAM_BSS;
uint32 g_sample_size NESTER_ARM7EWRAM_BSS;
uint32 buffer_len NESTER_ARM7EWRAM_BSS;
boolean buffer_locked NESTER_ARM7EWRAM_BSS;
boolean playing NESTER_ARM7EWRAM_BSS;
uint8 g_whichHalfDoYouOwn = 0; //DSPIP3
#ifdef _EWRAM_AUDIO_BUFFER
uint8 *g_audioBuffer = 0; //DSPIP3
#else
uint8 g_audioBuffer[STATIC_SND_BUFFER_SIZE];
#endif
uint32 g_sampleRateFlag = 0; //DSPIP6
uint32 g_bufPlace = 0; //DSPIP6

boolean IsNull();

void DSSM_FakeConstructor(uint32 sample_rate, uint32 sample_size, uint32 buffer_length_in_frames)
{
	//DSPIP6
	g_sample_rate = sample_rate;
	g_sample_size = sample_size;

	buffer_len = (uint32)((DSSM_get_sample_rate()*(DSSM_get_sample_size()/8)*buffer_length_in_frames)/60.0);

	//DSPIP6
	g_sampleRateFlag = SOUND_8BIT;
	if (g_sample_rate == 16)
	{
		g_sampleRateFlag = SOUND_16BIT;
	}

	// make SURE the buffer length is even for 16-bit samples
	if((sample_size > 8) && (buffer_len & 1))
	{
		buffer_len++;
	}

	// there are two halves to the buffer
	buffer_len *= 2;

	//DSPIP3
#ifdef _EWRAM_AUDIO_BUFFER
	//g_audioBuffer = (uint8 *)armmalloc(buffer_len);
	while (!g_sharedPData->audioBuffer); //stick around til arm9 gives me something.

	g_audioBuffer = (uint8 *)g_sharedPData->audioBuffer;
#endif
	memset(g_audioBuffer, 0, buffer_len);
}
void DSSM_reset()
{ //todo: implement
}
void DSSM_freeze()
{ //todo: implement
}
void DSSM_thaw()
{ //todo: implement
}
void DSSM_clear_buffer()
{ //DSPIP3
#ifdef _EWRAM_AUDIO_BUFFER
	if (g_audioBuffer)
#endif
	{
		memset(g_audioBuffer, 0, buffer_len);
	}
}
uint8 *DSSM_lock(sound_buf_pos which, uint32* buf_len)
{
	*buf_len = buffer_len/2;
	if (which == SOUND_BUF_HIGH)
	{ //DSPIP3
		return (uint8 *)(((uint32)g_audioBuffer)+(buffer_len/2));
	}
	return g_audioBuffer;
}
void DSSM_unlock()
{
}
uint32 DSSM_get_buffer_len()
{
	return buffer_len;
}
sound_buf_pos DSSM_get_currently_playing_half()
{
	if (g_whichHalfDoYouOwn)
	{ //DSPIP3
		return SOUND_BUF_HIGH;
	}
	return SOUND_BUF_LOW;
}
boolean DSSM_IsNull()
{
	return FALSE;
}
