#include "../GBA_main.h"

#include <stdarg.h>

//#define _EXLUDE_NES_MODULES
#define _GBA_SCREEN_MGR

//512 is correct, but 256 will make it look right with current version of iDeaS
#define DS_BG_WIDTH 512

#ifndef _EXLUDE_NES_MODULES
#include "../nes/NES.h"
#include "../nes/NES_screen_mgr.h"
#include "../nes/NES_ROM.h"
#include "../nes/ppu/NES_PPU.h"
#include "../pixmap.h"
#include "../nes/SNSS.h"
#endif

#include <nds/arm9/console.h>

#include "../GBA_globals.h"
#include "../arm7_shared.h"

#define PRIMARY_VRAM_BUFFER VRAM_A

#ifdef _STATIC_MALLOC
#define STATIC_MALLOC_SIZE 262144
uint8 g_staticMallocBuffer[STATIC_MALLOC_SIZE] EWRAM_DATA;
uint32 g_staticMallocInc = 0;
void *nestermalloc(size_t size)
{
	if (g_staticMallocInc+size >= STATIC_MALLOC_SIZE)
	{
		consolePrintf("\n==================\nMALLOC OVERFLOW!!!\n==================\n");
	}

	void *p = &g_staticMallocBuffer[g_staticMallocInc];
	g_staticMallocInc += size;
	return p;
}
void nesterfree(void *ptr)
{
}
#endif

int GetRawTime(void)
{
	return (TIMER1_DATA*(1<<16))+TIMER0_DATA;
}

#define TIMER_MS_DIV	32
int GetTimeMS(void)
{
	return GetRawTime()/TIMER_MS_DIV;
}

void AdjustDSScale(void)
{
	if (globals->hwScale)
	{
		BG3_XDY = 0;
		BG3_YDX = 0;
		BG3_XDX = 256;
		BG3_YDY = 256+44;
	}
	else
	{
		BG3_XDY = 0;
		BG3_YDX = 0;
		BG3_XDX = 256;
		BG3_YDY = 256;
	}
}

//direct framebuffer versions
//need nes-pal-graphics versions. or something, whatever.
/*
INLINE void DrawToFramebuffer(uint16 *dsBuffer, const unsigned char *raw, int w, int h, int x, int y)
{
	uint16 *to = dsBuffer+x+(y*SCREEN_WIDTH);
	int toW = 0;
	int toH = 0;
	int isrc = 0;
	while (toH < h)
	{
		toW = 0;
		while (toW < w)
		{
			*to = RGB15(raw[isrc]/8, raw[isrc+1]/8, raw[isrc+2]/8);
			toW++;
			to++;

			isrc += 3;
		}
		toH++;
		to = dsBuffer+x+((y+toH)*SCREEN_WIDTH);
	}
}

INLINE void DrawNumberToFramebuffer(uint16 *dsBuffer, int num, int x, int y)
{
	char str[128];
	int i = 0;
	int cX = x;
	int cY = y;
	const unsigned char *raw;

	memset(str, 0, sizeof(str));

	sprintf(str, "%i", num);
	while (str[i] && i < 3)
	{
		if (str[i] == '1')
		{
			raw = gfx_one;
		}
		else if (str[i] == '2')
		{
			raw = gfx_two;
		}
		else if (str[i] == '3')
		{
			raw = gfx_three;
		}
		else if (str[i] == '4')
		{
			raw = gfx_four;
		}
		else if (str[i] == '5')
		{
			raw = gfx_five;
		}
		else if (str[i] == '6')
		{
			raw = gfx_six;
		}
		else if (str[i] == '7')
		{
			raw = gfx_seven;
		}
		else if (str[i] == '8')
		{
			raw = gfx_eight;
		}
		else if (str[i] == '9')
		{
			raw = gfx_nine;
		}
		else
		{
			raw = gfx_zero;
		}
		DrawToFramebuffer(dsBuffer, raw, 12, 12, cX, cY);
		cX += 12;
		i++;
	}
}
*/

#if 0
int g_debugTimerStart = 0;
int g_debugTime = 0;
INLINE void DBGTIMER_START(void)
{
	g_debugTimerStart = GetRawTime();
}
INLINE void DBGTIMER_END(void)
{
	g_debugTime = GetRawTime()-g_debugTimerStart;
}
INLINE void DBGTIMER_DRAW(void)
{
	DrawNumberToFramebuffer(PRIMARY_VRAM_BUFFER, g_debugTime, 0, 0);
}
#else
#define DBGTIMER_START(x)
#define DBGTIMER_END(x)
#define DBGTIMER_DRAW(x)
#endif

gbaGlobals_t *globals NESTER_DTCM;

//FIXME - use gbfs, read nesrom from cart rom
static const unsigned char g_nesRom[1000000] = { "INSERTROMHERE:unknowntitle\0" };
//gbaGlobals_t staticGlobals;

#define PBUFFER_W (256+16)
#define PBUFFER_H (224+8)

#ifdef _GBA_SCREEN_MGR
void gbaScreenManager::setParentNES(NES *parent)
{
	NES_screen_mgr::setParentNES(parent);
	screen = NULL;
}

boolean gbaScreenManager::lock(pixmap &p)
{
	p.width  = PBUFFER_W;
	p.height = PBUFFER_H;
	p.pitch  = PBUFFER_W;
	p.data   = (PIXEL *)globals->pixelBuffer;
	return TRUE;
}

boolean gbaScreenManager::unlock()
{
	globals->newBuffer = true;
	globals->bufferLines = globals->altLineFrame;
	return TRUE;
}

void gbaScreenManager::blt()
{
}

void gbaScreenManager::flip()
{
}

void gbaScreenManager::clear(PIXEL color)
{
}

boolean gbaScreenManager::set_palette(const uint8 pal[256][3])
{
	return TRUE;
}

boolean gbaScreenManager::get_palette(uint8 pal[256][3])
{
	return TRUE;
}

int CapRGB(int x)
{
	if (x < 0)
	{
		return 0;
	}
	if (x > 31)
	{
		return 31;
	}

	return x;
}
boolean gbaScreenManager::set_palette_section(uint8 start, uint8 len, const uint8 pal[][3])
{
	float scale = 8.0f;
	int i = start;
	int j = 0;
	int total;

	total = i+len;
	while (i < total)
	{
		int irgb[3];
		irgb[0] = CapRGB((int)(pal[j][0]/scale));
		irgb[1] = CapRGB((int)(pal[j][1]/scale));
		irgb[2] = CapRGB((int)(pal[j][2]/scale));

		BG_PALETTE[i] = ((irgb[0])|(irgb[1]<<5)|(irgb[2]<<10)|(1<<15));

		j++;
		i++;
	}

	return TRUE;
}

boolean gbaScreenManager::get_palette_section(uint8 start, uint8 len, uint8 pal[][3])
{
	return TRUE;
}

void gbaScreenManager::assert_palette()
{
	set_NES_palette();
}
#endif


//assign some global var values
void AssignGBAGlobals(void)
{
	globals = (gbaGlobals_t *)nestermalloc(sizeof(gbaGlobals_t));
	memset_gba(globals, 0, sizeof(gbaGlobals_t));

	globals->nesRom = (nesRom_t *)g_nesRom;

	//now in dtcm
	//globals->nesPal = (uint16 *)nestermalloc(256*sizeof(uint16));

	globals->altLineRendering = 1;
	globals->altLineFrame = 0;
	globals->heightOffset = 16;
	globals->frameSkip = 3;
	globals->hwScale = 0;
	globals->speedHack = 0;

	globals->g_lastTime = 0;
	globals->g_Time = 0;

	globals->emuDrawEnabled = 1;
	globals->frames = 0;
	globals->logOps = 0;
}

//emulator globals
#ifndef _EXLUDE_NES_MODULES
int NESEmuGlobals(void)
{
	globals->c_emu = new NES;
	if (!globals->c_emu)
	{
		return 0;
	}
	globals->c_cpu = new NES_6502;
	if (!globals->c_cpu)
	{
		return 0;
	}
	globals->c_ppu = new NES_PPU;
	if (!globals->c_ppu)
	{
		return 0;
	}

	//arm7
	/*
	globals->c_apu = new NES_APU;
	if (!globals->c_apu)
	{
		return 0;
	}
	*/

	globals->scrn_mgr = new gbaScreenManager;
	if (!globals->scrn_mgr)
	{
		return 0;
	}

	globals->nesPad = new NES_pad;
	if (!globals->nesPad)
	{
		return 0;
	}

	globals->pixelBuffer = (PIXEL *)nestermalloc(sizeof(PIXEL)*((PBUFFER_W+16)*PBUFFER_H));
	if (!globals->pixelBuffer)
	{
		return 0;
	}
	else
	{
		memset_gba(globals->pixelBuffer, 0, sizeof(PIXEL)*((PBUFFER_W+16)*PBUFFER_H));
	}
	return 1;
}
#else
int NESEmuGlobals(void)
{
	return 1;
}
#endif

//debug log function
void GBA_Log(const char *msg)
{
	/*
	if (!globals->emuDrawEnabled)
	{
		int waitTime = strlen(msg)*20;

		PrintText("", -1);

		PrintText(msg, 0);

		while (waitTime > 0)
		{
			GBA_VSyncWait();
			waitTime--;
		}
	}
	*/
}

void *GBA_RomAlloc(int size)
{
	return nestermalloc(size);
}

void UpdateFrameBuffer(void)
{
#if 0 //old framebuffer method
	PIXEL *buf = globals->pixelBuffer;
	int w = 0;
	int h = 0;
	uint16 *frameBuffer = BG_BMP_RAM(0);
	buf += 8+(PBUFFER_W*globals->heightOffset);
	int scanDraw = -1;
	bool alr = (globals->altLineRendering == 2);

	if (globals->altLineRendering)
	{
		scanDraw = globals->bufferLines;
	}

	while (h < SCREEN_HEIGHT)
	{
		w = 0;
		if (scanDraw != -1)
		{
			if (!scanDraw)
			{
				if (alr)
				{
					memset_gba(frameBuffer, 0, sizeof(uint16)*SCREEN_WIDTH);
				}
				w = SCREEN_WIDTH;
				buf += SCREEN_WIDTH;
			}
			scanDraw = !scanDraw;
		}
		while (w < SCREEN_WIDTH)
		{
			frameBuffer[w] = BG_PALETTE[*buf];
			buf++;
			w++;
		}
		frameBuffer += SCREEN_WIDTH;
		buf += (PBUFFER_W-SCREEN_WIDTH);

		h++;
	}

	if (globals->clearNextRender)
	{
		memset_gba(PRIMARY_VRAM_BUFFER, 0, sizeof(uint16)*(SCREEN_WIDTH*SCREEN_HEIGHT));
		globals->clearNextRender = false;
	}
#else
#define PBUFFER_OFF_W	0
#define PBUFFER_OFF_H	8
	PIXEL *buf = globals->pixelBuffer+PBUFFER_OFF_W+(PBUFFER_OFF_H*PBUFFER_W)+8;
	uint8 *out = (uint8 *)BG_BMP_RAM(0);
	int h = 0;
	//uint8 channel = 0;
	bool skipLines = false;//!!globals->altLineRendering;

	if (!globals->hwScale)
	{
		buf += (PBUFFER_W*globals->heightOffset);
		h += globals->heightOffset;
	}

	if (globals->clearNextRender)
	{
		memset_gba(globals->pixelBuffer, 0, sizeof(PIXEL)*((PBUFFER_W+16)*PBUFFER_H));
		skipLines = 0;
		globals->clearNextRender = false;
	}

	if (skipLines)
	{
		h = 1;
	}

	while (h < PBUFFER_H-PBUFFER_OFF_H)
	{
#if 0
		while (dmaBusy(channel))
		{
			channel = (channel+1)%4;
		}
		dmaCopyWordsAsynch(channel, buf, out, PBUFFER_W-PBUFFER_OFF_W);
#else
		dmaCopyWords(0, buf, out, PBUFFER_W-PBUFFER_OFF_W);
#endif
		buf += PBUFFER_W;
		out += DS_BG_WIDTH;
		h++;
		if (skipLines)
		{
			buf += PBUFFER_W;
			out += DS_BG_WIDTH;
			h++;
		}
	}

#endif
}

void on_irq_vblank() 
{	
	// Disable interrupts
	IME = 0;

	//draw frame
	if (globals->newBuffer)
	{
		globals->newBuffer = false;
		UpdateFrameBuffer();
	}

	// Tell the DS we handled the VBLANK interrupt
	IF = IF;
	VBLANK_INTR_WAIT_FLAGS = IF | IE;

	// Enable interrupts
	IME = 1;
}

//stolen from a tutorial because i'm lazy.
static int key_prev = 0;
static int key_curr = 0;
#define key_poll() { key_prev=key_curr; key_curr = KEYS_CUR; }
#define key_transit(key) ((key_curr^key_prev) & key)
#define key_held(key) (~(key_curr|key_prev) & key)
#define key_hit(key) ((~key_curr&key_prev) & key)
#define key_released(key) ((key_curr&~key_prev) & key)

const char *TextForOption(int option)
{
	if (option)
	{
		return " (ON)";
	}
	else
	{
		return " (OFF)";
	}
}

const char *TextForFrameskip(int skip)
{
	if (skip == -1)
	{
		return " - AUTO";
	}

	static char str[128];
	sprintf(str, " - %i", skip);
	return str;
}

void PrintConsoleText(void)
{
	consoleClear();

	consolePrintf("\nNesterDS (v0.2)");
	consolePrintf("\nNester written by");
	consolePrintf("\nDarren Ranalli");
	consolePrintf("\nDS port by Rich Whitehouse");
	consolePrintf("\nwww.telefragged.com/thefatal/");
	consolePrintf("\n\nL/R adjusts height offset.\nHold X for functions:");
	consolePrintf("\n X+A - toggle line mode");
	consolePrintf(TextForOption(globals->altLineRendering));
	consolePrintf("\n X+B - swap screens");
	consolePrintf("\n X+Y - toggle hw scale");
	consolePrintf(TextForOption(globals->hwScale));
	consolePrintf("\n X+UP - toggle sound");
	consolePrintf(TextForOption(g_sharedPData->soundEnabled));
	consolePrintf("\n X+L/R - frameskip");
	consolePrintf(TextForFrameskip(globals->frameSkip));
	consolePrintf("\n X+SEL - toggle speedhack");
	consolePrintf(TextForOption(globals->speedHack));
	consolePrintf("\n X+START - reset");

#if 0
	extern uint32 __dtcm_used, __dtcm_start;
	char str[128];
	int a = (int)&__dtcm_used - (int)&__dtcm_start;
	const int targetMem = 15000;
	if (a > targetMem)
	{
		sprintf(str, "\n\nWARNING! dtcm using %i bytes, over target of %i.", a, targetMem);
		consolePrintf(str);
	}

	uint32 endIPCAddr = (uint32)(g_sharedPData+1);
	sprintf(str, "\n%i bytes remaining for active IPC.\n", 0x2800000-endIPCAddr);
	consolePrintf(str);
#endif
}

void SetNESInput(void)
{
	if (KEYS_CUR & (KEY_X))
	{ //x acts as a "function" key
		globals->nesPad->set_button_state(NES_UP,     false);
		globals->nesPad->set_button_state(NES_DOWN,   false);
		globals->nesPad->set_button_state(NES_LEFT,   false);
		globals->nesPad->set_button_state(NES_RIGHT,  false);
		globals->nesPad->set_button_state(NES_SELECT, false);
		globals->nesPad->set_button_state(NES_START,  false);
		globals->nesPad->set_button_state(NES_B,      false);
		globals->nesPad->set_button_state(NES_A,      false);

		bool changed = false;
		if (key_hit(KEY_A))
		{ //toggle rendering mode
			globals->altLineRendering = !globals->altLineRendering;
			globals->clearNextRender = true;
			changed = true;
		}
		if (key_hit(KEY_B))
		{ //swap screens
			lcdSwap();
		}
		if (key_hit(KEY_UP))
		{ //toggle sound
			g_sharedPData->soundEnabled = !g_sharedPData->soundEnabled;
			changed = true;
		}
		if (key_hit(KEY_R))
		{
			globals->frameSkip++;
			if (globals->frameSkip > 10)
			{
				globals->frameSkip = 10;
			}
			changed = true;
		}
		if (key_hit(KEY_L))
		{
			globals->frameSkip--;
			if (globals->frameSkip < -1)
			{
				globals->frameSkip = -1;
			}
			changed = true;
		}
		if (key_hit(KEY_Y))
		{
			globals->hwScale = !globals->hwScale;
			AdjustDSScale();
			changed = true;
		}
		if (key_hit(KEY_SELECT))
		{
			globals->speedHack = !globals->speedHack;
			changed = true;
		}
		if (key_hit(KEY_START))
		{
			globals->c_cpu->Reset();
		}

		if (changed)
		{
			PrintConsoleText();
		}
		return;
	}

	if (key_held(KEY_R))
	{
		globals->heightOffset += 2;
		if (globals->heightOffset > PBUFFER_H-SCREEN_HEIGHT-8)
		{
			globals->heightOffset = PBUFFER_H-SCREEN_HEIGHT-8;
		}
	}
	if (key_held(KEY_L))
	{
		globals->heightOffset -= 2;
		if (globals->heightOffset < 0)
		{
			globals->heightOffset = 0;
		}
	}

	globals->nesPad->set_button_state(NES_UP,     (KEYS_CUR & (KEY_UP)));
	globals->nesPad->set_button_state(NES_DOWN,   (KEYS_CUR & (KEY_DOWN)));
	globals->nesPad->set_button_state(NES_LEFT,   (KEYS_CUR & (KEY_LEFT)));
	globals->nesPad->set_button_state(NES_RIGHT,  (KEYS_CUR & (KEY_RIGHT)));
	globals->nesPad->set_button_state(NES_SELECT, (KEYS_CUR & (KEY_SELECT)));
	globals->nesPad->set_button_state(NES_START,  (KEYS_CUR & (KEY_START)));
	globals->nesPad->set_button_state(NES_B,      (KEYS_CUR & (KEY_B)));
	globals->nesPad->set_button_state(NES_A,      (KEYS_CUR & (KEY_A)));
}

int NES_Init(void)
{
	if (!NESEmuGlobals())
	{
		return 0;
	}
#ifndef _EXLUDE_NES_MODULES
	if (!globals->c_emu->FakeConstructor(globals->scrn_mgr, 0, globals->c_cpu, globals->c_ppu))
	{
		return 0;
	}
	globals->c_emu->set_pad1(globals->nesPad);
#endif

	return 1;
}

//pass this to the arm7
uint8 g_apuBuffer[16384] EWRAM_DATA;

#define NTSC_FRAMERATE (60000.0/1001.0)
#define FRAME_PERIOD   (1000.0/NTSC_FRAMERATE)

#define THROTTLE_SPEED  (NESTER_settings.nes.preferences.speed_throttling && 1)
#define SKIP_FRAMES     (NESTER_settings.nes.preferences.auto_frameskip && THROTTLE_SPEED)
void NES_InitialArmShare(void);
int main(char *argv[])
{
	powerON(POWER_ALL);

	// IRQ basic setup
	irqInitHandler(irqDefaultHandler);
	irqSet(IRQ_VBLANK, on_irq_vblank);
	irqEnable(IRQ_VBLANK);

	//setup the main display
	videoSetMode(MODE_5_2D|DISPLAY_BG3_ACTIVE);
	vramSetBankA(VRAM_A_MAIN_BG);
	BG3_CR = BG_BMP8_512x512|BG_BMP_BASE(0);

	//setup the sub display
	videoSetModeSub(MODE_0_2D|DISPLAY_BG0_ACTIVE);
	vramSetBankC(VRAM_C_SUB_BG);
	SUB_BG0_CR = BG_MAP_BASE(31);
	BG_PALETTE_SUB[255] = RGB15(31,31,31);

	//enable sound by default
	g_sharedPData->soundEnabled = 1;

	//give the arm7 some scratch mem
	g_sharedPData->audioBuffer = (uint32)(&g_apuBuffer[0]);

	//todo: draw some kewl stuff in here, maybe an nes pad for the touch screen, and also
	//put options here instead of using x as a function key.
	consoleInitDefault((u16*)SCREEN_BASE_BLOCK_SUB(31), (u16*)CHAR_BASE_BLOCK_SUB(0), 16);

	//enable timers for keeping track of a normal time value every frame.
	TIMER0_CR = TIMER_ENABLE|TIMER_DIV_1024;
	TIMER1_CR = TIMER_ENABLE|TIMER_CASCADE;

	g_sharedPData->nesRomRunning = 0;
	g_sharedPData->nesBurn = 0;

	AssignGBAGlobals();

	AdjustDSScale();

	PrintConsoleText();

	int success = NES_Init();
	if (!success)
	{
		consolePrintf("\n\nNo NES ROM found, or unsupported mapper.");
		while (1)
		{
			swiWaitForVBlank();
		}
	}

	NES_InitialArmShare();

	globals->randomPixels = 0;

	int last_frame_time_i = GetTimeMS();
	double last_frame_time = (double)last_frame_time_i;

	while (1)
	{
		// get the current time
		int cur_time_i = GetTimeMS();
		double cur_time = (double)cur_time_i;//SYS_TimeInMilliseconds();

		key_poll();

		SetNESInput();

#if 0
		char str[128];
		sprintf(str, "%i\n", g_sharedPData->debugValue);
		consolePrintf(str);
#endif

		if (success)
		{
			// make up for missed frames
			if (1)//SKIP_FRAMES)
			{
				uint32 frames_since_last;
				if (cur_time < last_frame_time)
				{ //rollover, just don't frameskip.
					frames_since_last = 0;
				}
				else
				{
					frames_since_last = (uint32)((cur_time - last_frame_time) / FRAME_PERIOD);
				}

				if (globals->frameSkip != -1)
				{
					frames_since_last = globals->frameSkip;
				}
				// are there extra frames?
				if(frames_since_last > 1)
				{
					for(uint32 i = 1; i < frames_since_last; i++)
					{
						if(i == 10) break;
						key_poll();
						SetNESInput();

						last_frame_time += FRAME_PERIOD;
						globals->c_emu->emulate_frame(FALSE);
					}
				}
			}

			last_frame_time_i = cur_time_i;
			last_frame_time = cur_time;
			globals->c_emu->emulate_frame(TRUE);
			globals->frames++;
			/*
			if (globals->randomPixels)
			{
				for (i = 0; i < (SCREEN_WIDTH*SCREEN_HEIGHT); i++) 
				{
					frameBuffer[i] = RGB15(rand()%31,rand()%31,rand()%31);
				}
			}
			*/
		}
		else
		{
			/*
			globals->randomPixels = 1;
			if (globals->randomPixels)
			{
				for (uint32 i = 0; i < (SCREEN_WIDTH*SCREEN_HEIGHT); i++) 
				{
					frameBuffer[i] = RGB15(rand()%31,0,0);
				}
			}
			*/
		}

		//DrawNumberToFramebuffer(frameBuffer, cur_time_i, 0, 0);
		//swiWaitForVBlank();
	}
	
	return 0;
}
