typedef struct vitalAPUData_s
{
	uint8				rect0Enabled;
	uint8				rect1Enabled;
	uint8				noiseEnabled;
	uint8				triEnabled;
	
	uint32				dmcEnabled;

	uint32				rect0VblLen;
	uint32				rect1VblLen;
	uint32				triVblLen;
	uint32				noiseVblLen;
	uint32				dmcIrqOccured;
} vitalAPUData_t;

typedef struct apuIncoming_s
{
   uint32 timestamp, address;
   uint8 value;
} apuIncoming_t;

#define MAX_PENDING_APU_COUNT	256

#define SETSOUNDEXT_VRC6	1

typedef struct customSharedData_s
{
	uint32				nesRomRunning;

	uint32				nesCycles;
	uint32				nesBurn;

	uint32				soundEnabled;

	uint32				debugValue;

	vitalAPUData_t		apuData;
	apuIncoming_t		apuIncoming[MAX_PENDING_APU_COUNT];
	uint32				apuNumIncoming;

	uint32				setSoundExt;

	uint32				audioBuffer;
	uint32				nes_mem_page[16];
} customSharedData_t;

#define g_sharedPData ((customSharedData_t volatile *)(0x027FF000+sizeof(TransferRegion)))

extern void *armmallocfn(int size);
extern void armfreefn(void *p);

#define armmalloc armmallocfn
#define armfree armfreefn
//#define armmalloc malloc
//#define armfree free

#define NESTER_ARM7EWRAM //EWRAM_DATA
#define NESTER_ARM7EWRAM_BSS //EWRAM_BSS
