#ifndef _GBA_GLOBALS_H
#define _GBA_GLOBALS_H

#ifdef __cplusplus
#include "nes/NES_screen_mgr.h"

class gbaScreenManager : public NES_screen_mgr
{
public:
	void setParentNES(NES *parent);

	boolean lock(pixmap &p);
	boolean unlock();

	void blt();
	void flip();

	void clear(PIXEL color);

	boolean set_palette(const uint8 pal[256][3]);
	boolean get_palette(uint8 pal[256][3]);
	boolean set_palette_section(uint8 start, uint8 len, const uint8 pal[][3]);
	boolean get_palette_section(uint8 start, uint8 len, uint8 pal[][3]);

	void assert_palette();

protected:
	NES_screen_mgr *screen; // ptr windowed/fullscreen screen manager
};

//#define _SHOW_LAST_OP

#define MAX_ROM_SIZE		524434 //max rom size in bytes
typedef struct nesRom_s
{
#if !defined(__GNUC__)
	char				romName[128];
	int					romLen;
	unsigned char		romData[MAX_ROM_SIZE];
#else
	char				romName[128]					__attribute__((packed)) ;
	int					romLen							__attribute__((packed)) ;
	unsigned char		romData[MAX_ROM_SIZE]			__attribute__((packed)) ;
#endif
} nesRom_t;

#define GLOBALS_PACKED //__attribute__((packed))

typedef struct gbaGlobals_s
{
	WORD g_lastTime GLOBALS_PACKED;
	WORD g_Time GLOBALS_PACKED;

	int g_ignoreButtons GLOBALS_PACKED;
	int emuDrawEnabled GLOBALS_PACKED;
	int frames GLOBALS_PACKED;
	int logOps GLOBALS_PACKED;

	int debug1, debug2 GLOBALS_PACKED;

	int altLineRendering GLOBALS_PACKED;
	int altLineFrame GLOBALS_PACKED;
	int heightOffset GLOBALS_PACKED;
	int frameSkip GLOBALS_PACKED;
	int hwScale GLOBALS_PACKED;
	int speedHack GLOBALS_PACKED;

	int lastOp GLOBALS_PACKED;

	//arm7
	//apu_t *apu GLOBALS_PACKED;

	NES *c_emu GLOBALS_PACKED;
	NES_6502 *c_cpu GLOBALS_PACKED;
	NES_PPU *c_ppu GLOBALS_PACKED;

	PIXEL *pixelBuffer GLOBALS_PACKED;
	bool newBuffer GLOBALS_PACKED;
	bool clearNextRender GLOBALS_PACKED;
	int bufferLines GLOBALS_PACKED;

	//now in dtcm
	//uint16 *nesPal GLOBALS_PACKED;

	gbaScreenManager *scrn_mgr GLOBALS_PACKED;

	nesRom_t *nesRom GLOBALS_PACKED;

	int randomPixels GLOBALS_PACKED;

	uint8 testOp GLOBALS_PACKED;

	NES_6502 *NES_6502_nes GLOBALS_PACKED;

	//arm7
	/*
	int32 decay_lut[16] GLOBALS_PACKED;
	int vbl_lut[32] GLOBALS_PACKED;
	int trilength_lut[128] GLOBALS_PACKED;
	int8 noise_long_lut[APU_NOISE_32K] GLOBALS_PACKED;
	int8 noise_short_lut[APU_NOISE_93] GLOBALS_PACKED;
	*/

	NES_pad *nesPad GLOBALS_PACKED;

	//moved to arm7
	/*
	vrcvisnd_t vrcvi GLOBALS_PACKED;
	int32 vrcvi_incsize GLOBALS_PACKED;
	*/
} gbaGlobals_t;

extern gbaGlobals_t *globals;
#endif
#endif //_GBA_GLOBALS_H
