#include "../GBA_main.h"

#include <stdarg.h>

//#define _EXLUDE_NES_MODULES
#define _GBA_SCREEN_MGR

#ifndef _EXLUDE_NES_MODULES
#include "../nes/NES.h"
#include "../nes/NES_screen_mgr.h"
#include "../nes/NES_ROM.h"
#include "../nes/ppu/NES_PPU.h"
#include "../pixmap.h"
#include "../nes/SNSS.h"
#endif

#include <nds/arm9/console.h>

#include "../GBA_globals.h"

#include "../assets/0.cpp"
#include "../assets/1.cpp"
#include "../assets/2.cpp"
#include "../assets/3.cpp"
#include "../assets/4.cpp"
#include "../assets/5.cpp"
#include "../assets/6.cpp"
#include "../assets/7.cpp"
#include "../assets/8.cpp"
#include "../assets/9.cpp"



gbaGlobals_t *globals;

//FIXME - use gbfs, read nesrom from cart rom
static const unsigned char g_nesRom[1000000] = { "INSERTROMHERE:unknowntitle\0" };
//gbaGlobals_t staticGlobals;

#ifndef _RUNTIMES_THAT_DONT_SUCK_ASS

//#define NESTER_MEMPOOL_SIZE			1048576//2097152//524288//2097152//131072
//const unsigned char nesterMemPool[NESTER_MEMPOOL_SIZE] = {0};
unsigned char *nesterMemPool = (unsigned char *)0;
int memPoolPoint = 0;

extern int __ewram_used; //set in ld
extern int __data_end;
void nestermeminit(void)
{
	nesterMemPool = (unsigned char *)(__data_end);
	memPoolPoint = 0;
}

void *nestermalloc(size_t size)
{
	/*
	if ((memPoolPoint+size+4096) >= NESTER_MEMPOOL_SIZE)
	{
		return NULL;
	}
	*/
	memPoolPoint += 1024;
	void *p = (void *)&nesterMemPool[memPoolPoint];
	memPoolPoint += size+1024;
	return p;
}

void nesterfree(void *ptr)
{
}
#else
void nestermeminit(void)
{
}
#endif

#define PBUFFER_W 272//320
#define PBUFFER_H 240//240

#ifdef _GBA_SCREEN_MGR
void gbaScreenManager::setParentNES(NES *parent)
{
	NES_screen_mgr::setParentNES(parent);
	screen = NULL;
}

boolean gbaScreenManager::lock(pixmap &p)
{
	p.width  = PBUFFER_W;
	p.height = PBUFFER_H;
	p.pitch  = PBUFFER_W;
	p.data   = (PIXEL *)globals->pixelBuffer;
	return TRUE;
}

//#define _SPRITE_BASED_RENDER

boolean gbaScreenManager::unlock()
{
	if (!globals->emuDrawEnabled)
	{
	}
#ifndef _SPRITE_BASED_RENDER
	else
	{ //k. draw stuff. this is way too incredibly slow for gba. just here for debug.
#if 1
		PIXEL *buf = globals->pixelBuffer;
		int w = 0;
		int h = 0;
		int i = 0;
		uint16 *frameBuffer = VRAM_A;
		buf += 8+(PBUFFER_W*globals->heightOffset);
		int scanDraw = -1;

		if (globals->altLineRendering)
		{
			scanDraw = globals->altLineFrame;
		}

		while (h < SCREEN_HEIGHT)
		{
			w = 0;
			if (scanDraw != -1)
			{
				if (!scanDraw)
				{
					if (globals->altLineRendering == 2)
					{
						memset_gba(&frameBuffer[i], 0, sizeof(uint16)*SCREEN_WIDTH);
					}
					w = SCREEN_WIDTH;
					buf += SCREEN_WIDTH;
					i += SCREEN_WIDTH;
				}
				scanDraw = !scanDraw;
			}
			while (w < SCREEN_WIDTH)
			{
				frameBuffer[i] = globals->nesPal[*buf];
				i++;
				buf++;
				w++;
			}
			buf += (PBUFFER_W-SCREEN_WIDTH);

			h++;
		}
#else
		for (int i = 0; i < (PBUFFER_W*PBUFFER_H); i++)
		{
			VRAM_A[i] = globals->nesPal[globals->pixelBuffer[i+8]];
		}
#endif
	}
#endif

	return TRUE;
}

void gbaScreenManager::blt()
{
}

void gbaScreenManager::flip()
{
}

void gbaScreenManager::clear(PIXEL color)
{
}

boolean gbaScreenManager::set_palette(const uint8 pal[256][3])
{
	return TRUE;
}

boolean gbaScreenManager::get_palette(uint8 pal[256][3])
{
	return TRUE;
}

int CapRGB(int x)
{
	if (x < 0)
	{
		return 0;
	}
	if (x > 31)
	{
		return 31;
	}

	return x;
}
boolean gbaScreenManager::set_palette_section(uint8 start, uint8 len, const uint8 pal[][3])
{
	float scale = 8.0f;
	int i = start;
	int j = 0;
	int total;
	/*
	while (i < start)
	{
		globals->g_BGPaletteMem[i] = 0;
		i++;
	}
	*/

	total = i+len;
	while (i < total)
	{
		int irgb[3];
		irgb[0] = CapRGB((int)(pal[j][0]/scale));
		irgb[1] = CapRGB((int)(pal[j][1]/scale));
		irgb[2] = CapRGB((int)(pal[j][2]/scale));

		globals->nesPal[i] = ((irgb[0])|(irgb[1]<<5)|(irgb[2]<<10));

		j++;
		i++;
	}

	/*
	//finish filling it out
	while (i < 256)
	{
		globals->g_BGPaletteMem[i] = 0;
		i++;
	}
	*/

	return TRUE;
}

boolean gbaScreenManager::get_palette_section(uint8 start, uint8 len, uint8 pal[][3])
{
	return TRUE;
}

void gbaScreenManager::assert_palette()
{
	set_NES_palette();
}
#endif


//assign some global var values
void AssignGBAGlobals(void)
{
	globals = (gbaGlobals_t *)nestermalloc(sizeof(gbaGlobals_t));
	//globals = (gbaGlobals_t *)staticGlobals;
	memset_gba(globals, 0, sizeof(gbaGlobals_t));

	globals->nesRom = (nesRom_t *)g_nesRom;

	globals->nesPal = (uint16 *)nestermalloc(256*sizeof(uint16));

	globals->altLineRendering = 3;
	globals->altLineFrame = 0;
	globals->heightOffset = 16;
	globals->frameSkip = 3;

	globals->g_lastTime = 0;
	globals->g_Time = 0;

	/*
	globals->g_vertTraceCounter		=	(WORD *)0x4000006; //vertical trace counter (used for vsync wait)
	globals->g_inputMem				=	(DWORD *)0x04000130; //user input memory

	globals->g_OAMmem				=	(DWORD *)0x7000000;		//Object Attribute Memory
	globals->g_videoBuffer			=	(WORD *)0x6000000;		//Display Memory (the screen)
	globals->g_OAMData				=	(WORD *)0x6010000;		//Graphics (0x6010000 = Characters, 0x6004000 = Backgrounds)
	globals->g_BGPaletteMem			=	(WORD *)0x5000000;		//Background Palette
	globals->g_OBJPaletteMem		=	(WORD *)0x5000200;		//Sprite Palette
	globals->g_BG0CharMem			=	(WORD *)0x600C000;		//char base for bg0
	globals->g_BG2CharMem			=	(WORD *)0x6004000;		//char base for bg2

	globals->g_BG0 = (WORD *)0x600F000;		//Memory for BG0's map
	globals->g_BG1 = (WORD *)0x6002000;		//Memory for BG1's map (needs 8192 because it's 512x512)
	globals->g_BG2 = (WORD *)0x6000000;		//Memory for BG2's map (needs 8192 because it's 512x512)
	globals->g_BG3 = (WORD *)0x600F800;		//Memory for BG3's map
	*/

	globals->emuDrawEnabled = 1;
	globals->frames = 0;
	globals->logOps = 0;
}

/*
	NES g_nes;
//	unsigned char pad1[HACK_PAD_SIZE];
	NES_6502 g_cpu;
//	unsigned char pad2[HACK_PAD_SIZE];
	NES_PPU g_ppu;
//	unsigned char pad3[HACK_PAD_SIZE];
	NES_APU g_apu;
//	unsigned char pad4[HACK_PAD_SIZE];
*/

//emulator globals
#ifndef _EXLUDE_NES_MODULES
int NESEmuGlobals(void)
{
	/*
	globals->tmp_apu = (apu_t *)nestermalloc(sizeof(apu_t));
	if (!globals->tmp_apu)
	{
		return 0;
	}
	*/
#if 0
	globals->c_emu = (NES *)&g_nes;//new NES;
	if (!globals->c_emu)
	{
		return 0;
	}
	globals->c_cpu = (NES_6502 *)&g_cpu;//new NES_6502;
	if (!globals->c_cpu)
	{
		return 0;
	}
	globals->c_ppu = (NES_PPU *)&g_ppu;//new NES_PPU;
	if (!globals->c_ppu)
	{
		return 0;
	}

	globals->c_apu = (NES_APU *)&g_apu;//new NES_APU;
	if (!globals->c_apu)
	{
		return 0;
	}

	//globals->scrn_mgr = (gbaScreenManager *)&globals->g_screenMsg;//new gbaScreenManager;
	globals->scrn_mgr = new gbaScreenManager;
	if (!globals->scrn_mgr)
	{
		return 0;
	}
#else
	globals->c_emu = new NES;
	if (!globals->c_emu)
	{
		return 0;
	}
	globals->c_cpu = new NES_6502;
	if (!globals->c_cpu)
	{
		return 0;
	}
	globals->c_ppu = new NES_PPU;
	if (!globals->c_ppu)
	{
		return 0;
	}

	globals->c_apu = new NES_APU;
	if (!globals->c_apu)
	{
		return 0;
	}

	globals->scrn_mgr = new gbaScreenManager;
	if (!globals->scrn_mgr)
	{
		return 0;
	}

	globals->nesPad = new NES_pad;
	if (!globals->nesPad)
	{
		return 0;
	}
#endif
	globals->pixelBuffer = (PIXEL *)nestermalloc(sizeof(PIXEL)*((PBUFFER_W+16)*PBUFFER_H));
	if (!globals->pixelBuffer)
	{
		return 0;
	}
	else
	{
		memset_gba(globals->pixelBuffer, 0, sizeof(PIXEL)*((PBUFFER_W+16)*PBUFFER_H));
		//memset_gba(globals->pixelBuffer, 0, 2);
	}
	return 1;
}
#else
int NESEmuGlobals(void)
{
	return 1;
}
#endif

//debug log function
void GBA_Log(const char *msg)
{
	/*
	if (!globals->emuDrawEnabled)
	{
		int waitTime = strlen(msg)*20;

		PrintText("", -1);

		PrintText(msg, 0);

		while (waitTime > 0)
		{
			GBA_VSyncWait();
			waitTime--;
		}
	}
	*/
}

//mmmhmm
void *GBA_RomAlloc(int size)
{
	/*
	#define BIG_CHUNK_SIZE 524434
	static char g_gbaRomSpace[BIG_CHUNK_SIZE];
	static int g_gbaRomUsed = 0;

	void *p = (void *)&g_gbaRomSpace[g_gbaRomUsed];

	if ((g_gbaRomUsed+size) >= BIG_CHUNK_SIZE)
	{
		return NULL;
	}

	{
		char inf[1024];
		sprintf(inf, "alloc at %i", (int)p);
		GBA_Log(inf);
	}

	g_gbaRomUsed += size;
	return p;
	*/
	return nestermalloc(size);
}

void DrawToFramebuffer(uint16 *dsBuffer, const unsigned char *raw, int w, int h, int x, int y)
{
	uint16 *to = dsBuffer+x+(y*SCREEN_WIDTH);
	int toW = 0;
	int toH = 0;
	int isrc = 0;
	while (toH < h)
	{
		toW = 0;
		while (toW < w)
		{
			*to = RGB15(raw[isrc]/8, raw[isrc+1]/8, raw[isrc+2]/8);
			toW++;
			to++;

			isrc += 3;
		}
		toH++;
		to = dsBuffer+x+((y+toH)*SCREEN_WIDTH);
	}
}

void DrawNumberToFramebuffer(uint16 *dsBuffer, int num, int x, int y)
{
	char str[128];
	int i = 0;
	int cX = x;
	int cY = y;
	const unsigned char *raw;

	sprintf(str, "%i", num);
	while (str[i])
	{
		if (str[i] == '1')
		{
			raw = gfx_one;
		}
		else if (str[i] == '2')
		{
			raw = gfx_two;
		}
		else if (str[i] == '3')
		{
			raw = gfx_three;
		}
		else if (str[i] == '4')
		{
			raw = gfx_four;
		}
		else if (str[i] == '5')
		{
			raw = gfx_five;
		}
		else if (str[i] == '6')
		{
			raw = gfx_six;
		}
		else if (str[i] == '7')
		{
			raw = gfx_seven;
		}
		else if (str[i] == '8')
		{
			raw = gfx_eight;
		}
		else if (str[i] == '9')
		{
			raw = gfx_nine;
		}
		else
		{
			raw = gfx_zero;
		}
		DrawToFramebuffer(dsBuffer, raw, 12, 12, cX, cY);
		//DrawToFramebuffer(dsBuffer, gfx_zero, 12, 12, 0, 0);
		cX += 12;
		i++;
	}
}

#define TIMER_SPEED_FACTOR	500

double GetTime(void)
{
	//uint16 *t = (uint16 *)IPC->curtime;
	//return (double)(*t);

	return (double)TIMER0_DATA/TIMER_SPEED_FACTOR;
}

uint16 GetTimeMS(void)
{
	//uint16 *t = (uint16 *)IPC->curtime;
	//return (double)(*t);

	return TIMER0_DATA/TIMER_SPEED_FACTOR;
}

void on_irq_vblank() 
{	
	// Disable interrupts
	IME = 0;

	//draw frame

	// Tell the DS we handled the VBLANK interrupt
	IF = IF;
	VBLANK_INTR_WAIT_FLAGS = IF | IE;

	// Enable interrupts
	IME = 1;
}

//stolen from a tutorial because i'm lazy.
static int key_prev = 0;
static int key_curr = 0;
#define key_poll() { key_prev=key_curr; key_curr = KEYS_CUR; }
#define key_transit(key) ((key_curr^key_prev) & key)
#define key_held(key) (~(key_curr|key_prev) & key)
#define key_hit(key) ((~key_curr&key_prev) & key)
#define key_released(key) ((key_curr&~key_prev) & key)

/*
#define DSKEY_X				(1<<0)
#define DSKEY_Y				(1<<1)
#define DSKEY_STYLUS		(1<<6)
#define DSKEY_HINGE			(1<<7)
*/

void SetNESInput(void)
{
	if (KEYS_CUR & (KEY_X))
	{ //x acts as a "function" key
		globals->nesPad->set_button_state(NES_UP,     false);
		globals->nesPad->set_button_state(NES_DOWN,   false);
		globals->nesPad->set_button_state(NES_LEFT,   false);
		globals->nesPad->set_button_state(NES_RIGHT,  false);
		globals->nesPad->set_button_state(NES_SELECT, false);
		globals->nesPad->set_button_state(NES_START,  false);
		globals->nesPad->set_button_state(NES_B,      false);
		globals->nesPad->set_button_state(NES_A,      false);

		if (key_hit(KEY_A))
		{ //toggle rendering mode
			globals->altLineRendering++;
			if (globals->altLineRendering == 3)
			{ //clear buffer
				memset(VRAM_A, 0, sizeof(uint16)*(SCREEN_WIDTH*SCREEN_HEIGHT));
			}
			if (globals->altLineRendering > 3)
			{
				globals->altLineRendering = 0;
			}
		}
		if (key_hit(KEY_B))
		{ //swap screens
			lcdSwap();
		}
		if (key_hit(KEY_R))
		{
			globals->frameSkip++;
			if (globals->frameSkip > 10)
			{
				globals->frameSkip = 10;
			}
		}
		if (key_hit(KEY_L))
		{
			globals->frameSkip--;
			if (globals->frameSkip < -1)
			{
				globals->frameSkip = -1;
			}
		}
		return;
	}

	if (key_held(KEY_R))
	{
		globals->heightOffset += 2;
		if (globals->heightOffset > PBUFFER_H-SCREEN_HEIGHT)
		{
			globals->heightOffset = PBUFFER_H-SCREEN_HEIGHT;
		}
	}
	if (key_held(KEY_L))
	{
		globals->heightOffset -= 2;
		if (globals->heightOffset < 0)
		{
			globals->heightOffset = 0;
		}
	}

	globals->nesPad->set_button_state(NES_UP,     (KEYS_CUR & (KEY_UP)));
	globals->nesPad->set_button_state(NES_DOWN,   (KEYS_CUR & (KEY_DOWN)));
	globals->nesPad->set_button_state(NES_LEFT,   (KEYS_CUR & (KEY_LEFT)));
	globals->nesPad->set_button_state(NES_RIGHT,  (KEYS_CUR & (KEY_RIGHT)));
	globals->nesPad->set_button_state(NES_SELECT, (KEYS_CUR & (KEY_SELECT)));
	globals->nesPad->set_button_state(NES_START,  (KEYS_CUR & (KEY_START)));
	globals->nesPad->set_button_state(NES_B,      (KEYS_CUR & (KEY_B)));
	globals->nesPad->set_button_state(NES_A,      (KEYS_CUR & (KEY_A)));
}

extern void ARM7InterruptHandler(void);
#define NTSC_FRAMERATE (60000.0/1001.0)
#define FRAME_PERIOD   (1000.0/NTSC_FRAMERATE)

#define THROTTLE_SPEED  (NESTER_settings.nes.preferences.speed_throttling && 1)
#define SKIP_FRAMES     (NESTER_settings.nes.preferences.auto_frameskip && THROTTLE_SPEED)
int main(char *argv[])
{
	powerON(POWER_ALL);
	videoSetMode(MODE_FB0);
	vramSetBankA(VRAM_A_LCD);

	
	// IRQ basic setup
	irqInitHandler(irqDefaultHandler);
//	irqSet(IRQ_VBLANK, on_irq_vblank);
//	irqEnable(IRQ_VBLANK);
//these are disabled because they currently freeze dsemu

	videoSetModeSub(MODE_0_2D|DISPLAY_BG0_ACTIVE);
	vramSetBankC(VRAM_C_SUB_BG);
	SUB_BG0_CR = BG_MAP_BASE(31);
	BG_PALETTE_SUB[255] = RGB15(31,31,31);

	//todo: draw some kewl stuff in here, maybe an nes pad for the touch screen, and also
	//put options here instead of using x as a function key.
	consoleInitDefault((u16*)SCREEN_BASE_BLOCK_SUB(31), (u16*)CHAR_BASE_BLOCK_SUB(0), 16);
	consolePrintf("\nNesterDS\nNester written by\nDarren Ranalli\nDS port by Rich Whitehouse\nwww.telefragged.com/thefatal/\n\nL/R adjusts height offset.\nHold X for functions:\n X+A - toggle line mode\n X+B - swap screens\n X+L/R - adjust frameskip\n");

	//enable timers for keeping track of a normal time value every frame.
	TIMER0_CR = TIMER_ENABLE;

#if 1
	nestermeminit();
	AssignGBAGlobals();


	int i;
	uint16 *frameBuffer = VRAM_A;
	memset(frameBuffer, 0, sizeof(uint16)*(SCREEN_WIDTH*SCREEN_HEIGHT));

	int success = NESEmuGlobals();
#ifndef _EXLUDE_NES_MODULES
	if (!globals->c_emu->FakeConstructor(globals->scrn_mgr, 0, globals->c_cpu, globals->c_ppu, globals->c_apu))
	{
		success = 0;
	}
	else
	{
		globals->c_emu->set_pad1(globals->nesPad);
	}

	if (!success)
	{
		consolePrintf("\nNo NES ROM found, or unsupported mapper.");
	}
#endif
	globals->randomPixels = 0;

	uint16 last_frame_time_i = GetTimeMS();
	double last_frame_time = (double)last_frame_time_i;

	while (1)
	{
		key_poll();

		SetNESInput();

		if (success)
		{
			// get the current time
			uint16 cur_time_i = GetTimeMS();
			double cur_time = (double)cur_time_i;//SYS_TimeInMilliseconds();

			// make up for missed frames
			if (1)//SKIP_FRAMES)
			{
				uint32 frames_since_last;
				if (cur_time < last_frame_time)
				{
					uint16 t_i = last_frame_time_i+(((1<<16)/TIMER_SPEED_FACTOR)-last_frame_time_i)+cur_time_i;
					double t = (double)t_i;
					frames_since_last = (uint32)((t - last_frame_time) / FRAME_PERIOD);
				}
				else
				{
					frames_since_last = (uint32)((cur_time - last_frame_time) / FRAME_PERIOD);
				}

				if (globals->frameSkip != -1)
				{
					frames_since_last = globals->frameSkip;
				}
				// are there extra frames?
				if(frames_since_last > 1)
				{
					for(uint32 i = 1; i < frames_since_last; i++)
					{
						if(i == 10) break;
						last_frame_time += FRAME_PERIOD;
						globals->c_emu->emulate_frame(FALSE);
					}
				}
			}
			//DrawNumberToFramebuffer(frameBuffer, (int)KEYS_CUR, 0, 0);

			last_frame_time_i = cur_time_i;
			last_frame_time = cur_time;
			globals->c_emu->emulate_frame(TRUE);
			globals->frames++;
			if (globals->randomPixels)
			{
				for (i = 0; i < (SCREEN_WIDTH*SCREEN_HEIGHT); i++) 
				{
					frameBuffer[i] = RGB15(rand()%31,rand()%31,rand()%31);
				}
			}
			//DrawToFramebuffer(frameBuffer, gfx_zero, 12, 12, 0, 0);
		}
		else
		{
			globals->randomPixels = 1;
			if (globals->randomPixels)
			{
				for (i = 0; i < (SCREEN_WIDTH*SCREEN_HEIGHT); i++) 
				{
					frameBuffer[i] = RGB15(rand()%31,0,0);
					//frameBuffer[i] = RGB15(rand()%31,rand()%31,rand()%31);
				}
			}
			//DrawNumberToFramebuffer(frameBuffer, 0, 0, 0);
		}

		//swiWaitForVBlank();
	}
#else
	while (1)
	{
		swiWaitForVBlank();
	}
#endif
	
	return 0;
}
