#ifndef _GBA_GLOBALS_H
#define _GBA_GLOBALS_H

#include "nes/NES_screen_mgr.h"

class gbaScreenManager : public NES_screen_mgr
{
public:
	void setParentNES(NES *parent);

	boolean lock(pixmap &p);
	boolean unlock();

	void blt();
	void flip();

	void clear(PIXEL color);

	boolean set_palette(const uint8 pal[256][3]);
	boolean get_palette(uint8 pal[256][3]);
	boolean set_palette_section(uint8 start, uint8 len, const uint8 pal[][3]);
	boolean get_palette_section(uint8 start, uint8 len, uint8 pal[][3]);

	void assert_palette();

protected:
	NES_screen_mgr *screen; // ptr windowed/fullscreen screen manager
};

//#define _SHOW_LAST_OP

#define MAX_ROM_SIZE		524434 //max rom size in bytes
typedef struct nesRom_s
{
#if !defined(__GNUC__)
	char				romName[128];
	int					romLen;
	unsigned char		romData[MAX_ROM_SIZE];
#else
	char				romName[128]					__attribute__((packed)) ;
	int					romLen							__attribute__((packed)) ;
	unsigned char		romData[MAX_ROM_SIZE]			__attribute__((packed)) ;
#endif
} nesRom_t;

#define GLOBALS_PACKED __attribute__((packed))

typedef struct gbaGlobals_s
{
	WORD g_lastTime GLOBALS_PACKED;
	WORD g_Time GLOBALS_PACKED;

	/*
	WORD *g_vertTraceCounter;
	DWORD *g_inputMem;

	DWORD *g_OAMmem;
	WORD *g_videoBuffer;
	WORD *g_OAMData;
	WORD *g_BGPaletteMem;
	WORD *g_OBJPaletteMem;
	WORD *g_BG0CharMem;
	WORD *g_BG2CharMem;

	WORD *g_BG0;
	WORD *g_BG1;
	WORD *g_BG2;
	WORD *g_BG3;
	*/

	int g_ignoreButtons GLOBALS_PACKED;
	int emuDrawEnabled GLOBALS_PACKED;
	int frames GLOBALS_PACKED;
	int logOps GLOBALS_PACKED;

	int debug1, debug2 GLOBALS_PACKED;

	int altLineRendering GLOBALS_PACKED;
	int altLineFrame GLOBALS_PACKED;
	int heightOffset GLOBALS_PACKED;
	int frameSkip GLOBALS_PACKED;

	int lastOp GLOBALS_PACKED;

	apu_t *apu GLOBALS_PACKED;

	NES *c_emu GLOBALS_PACKED;
	NES_6502 *c_cpu GLOBALS_PACKED;
	NES_PPU *c_ppu GLOBALS_PACKED;
	NES_APU *c_apu GLOBALS_PACKED;

	PIXEL *pixelBuffer GLOBALS_PACKED;

	uint16 *nesPal GLOBALS_PACKED;

	gbaScreenManager *scrn_mgr GLOBALS_PACKED;

	nesRom_t *nesRom GLOBALS_PACKED;

	int randomPixels GLOBALS_PACKED;

	uint8 testOp GLOBALS_PACKED;

	NES_6502 *NES_6502_nes GLOBALS_PACKED;

	int32 decay_lut[16] GLOBALS_PACKED;
	int vbl_lut[32] GLOBALS_PACKED;
	int trilength_lut[128] GLOBALS_PACKED;
	int8 noise_long_lut[APU_NOISE_32K] GLOBALS_PACKED;
	int8 noise_short_lut[APU_NOISE_93] GLOBALS_PACKED;

	NES_pad *nesPad GLOBALS_PACKED;

	vrcvisnd_t vrcvi GLOBALS_PACKED;
	int32 vrcvi_incsize GLOBALS_PACKED;

//#define HACK_PAD_SIZE	16384
	/*
	NES g_nes;
//	unsigned char pad1[HACK_PAD_SIZE];
	NES_6502 g_cpu;
//	unsigned char pad2[HACK_PAD_SIZE];
	NES_PPU g_ppu;
//	unsigned char pad3[HACK_PAD_SIZE];
	NES_APU g_apu;
//	unsigned char pad4[HACK_PAD_SIZE];
	gbaScreenManager g_screenMsg;
//	unsigned char pad5[HACK_PAD_SIZE];

	NES_ROM g_nesROM;
//	unsigned char pad6[HACK_PAD_SIZE];
	*/

	/*
	NES_mapper0 g_mapper0;
//	unsigned char pad7[HACK_PAD_SIZE];
	NES_mapper1 g_mapper1;
//	unsigned char pad8[HACK_PAD_SIZE];
	NES_mapper2 g_mapper2;
//	unsigned char pad9[HACK_PAD_SIZE];
	NES_mapper3 g_mapper3;
//	unsigned char pad10[HACK_PAD_SIZE];
	NES_mapper4 g_mapper4;
//	unsigned char pad11[HACK_PAD_SIZE];
	NES_mapper7 g_mapper7;
//	unsigned char pad12[HACK_PAD_SIZE];
	NES_mapper9 g_mapper9;
//	unsigned char pad13[HACK_PAD_SIZE];
	NES_mapper24 g_mapper24;
//	unsigned char pad14[HACK_PAD_SIZE];
	NES_mapper40 g_mapper40;
//	unsigned char pad15[HACK_PAD_SIZE];
	*/
} gbaGlobals_t;

extern gbaGlobals_t *globals;

#endif //_GBA_GLOBALS_H
