!!ARBfp1.0

#shadowmap projection in screenspace
#Author: Rich Whitehouse
#---------------------------------------------------------------------

OUTPUT	out = result.color;
PARAM	screenScale = program.local[0];
PARAM	toLightScreen[4] = {program.local[1..4]};
PARAM	shadowEpsilon = 0.03;
PARAM	sampleStepXY = {0.006, 0.006};
PARAM	sampleStepXYA = {-0.006, 0.006};
PARAM	sampleStepXYB = {0.006, -0.006};
PARAM	sampleStepX = {0.006, 0.0};
PARAM	sampleStepY = {0.0, 0.006};
TEMP	depthTex, screenTC, sampleTC, t, screenPos, lightScreenPos;

#scale the rasterized coordinate into screenspace for the depth lookup
MUL	screenTC.xy, fragment.position, screenScale;

#derive a projected screen position from the fragment x/y and depth
TEX	depthTex, screenTC, texture[0], 2D;
RCP	t.x, fragment.texcoord[0].w;
MUL	screenPos.xy, fragment.texcoord[0], t.x;
MOV	screenPos.z, depthTex.x;
MOV	screenPos.w, 1.0;

#transform into the light's screenspace
DP4	lightScreenPos.x, toLightScreen[0], screenPos;
DP4	lightScreenPos.y, toLightScreen[1], screenPos;
DP4	lightScreenPos.z, toLightScreen[2], screenPos;
DP4	lightScreenPos.w, toLightScreen[3], screenPos;

#pre-divide by w in light screenspace
RCP	t.x, lightScreenPos.w;
MUL	screenTC.xyz, lightScreenPos, t.x;

#scale into texture coordinate space
MAD	screenTC.xy, screenTC, 0.5, 0.5;

#do the samples
TEX	depthTex, screenTC, texture[1], 2D;
SUB	depthTex.x, screenTC.z, depthTex.x;
SGE	depthTex.x, depthTex.x, shadowEpsilon;
MOV	t.x, depthTex.x;

SUB	sampleTC, screenTC, sampleStepXY;
TEX	depthTex, sampleTC, texture[1], 2D;
SUB	depthTex.x, screenTC.z, depthTex.x;
SGE	depthTex.x, depthTex.x, shadowEpsilon;
ADD	t.x, t.x, depthTex.x;

ADD	sampleTC, screenTC, sampleStepXY;
TEX	depthTex, sampleTC, texture[1], 2D;
SUB	depthTex.x, screenTC.z, depthTex.x;
SGE	depthTex.x, depthTex.x, shadowEpsilon;
ADD	t.x, t.x, depthTex.x;

ADD	sampleTC, screenTC, sampleStepXYA;
TEX	depthTex, sampleTC, texture[1], 2D;
SUB	depthTex.x, screenTC.z, depthTex.x;
SGE	depthTex.x, depthTex.x, shadowEpsilon;
ADD	t.x, t.x, depthTex.x;

ADD	sampleTC, screenTC, sampleStepXYB;
TEX	depthTex, sampleTC, texture[1], 2D;
SUB	depthTex.x, screenTC.z, depthTex.x;
SGE	depthTex.x, depthTex.x, shadowEpsilon;
ADD	t.x, t.x, depthTex.x;

SUB	sampleTC, screenTC, sampleStepX;
TEX	depthTex, sampleTC, texture[1], 2D;
SUB	depthTex.x, screenTC.z, depthTex.x;
SGE	depthTex.x, depthTex.x, shadowEpsilon;
ADD	t.x, t.x, depthTex.x;

ADD	sampleTC, screenTC, sampleStepX;
TEX	depthTex, sampleTC, texture[1], 2D;
SUB	depthTex.x, screenTC.z, depthTex.x;
SGE	depthTex.x, depthTex.x, shadowEpsilon;
ADD	t.x, t.x, depthTex.x;

SUB	sampleTC, screenTC, sampleStepY;
TEX	depthTex, sampleTC, texture[1], 2D;
SUB	depthTex.x, screenTC.z, depthTex.x;
SGE	depthTex.x, depthTex.x, shadowEpsilon;
ADD	t.x, t.x, depthTex.x;

ADD	sampleTC.y, screenTC, sampleStepY;
TEX	depthTex, sampleTC, texture[1], 2D;
SUB	depthTex.x, screenTC.z, depthTex.x;
SGE	depthTex.x, depthTex.x, shadowEpsilon;
ADD	t.x, t.x, depthTex.x;

MUL_SAT	t.x, t.x, 0.111111111112;

MOV	out, t.x;

END
