!!ARBfp1.0

#shadowmap projection in screenspace
#Author: Rich Whitehouse
#---------------------------------------------------------------------

OUTPUT	out = result.color;
PARAM	screenScale = program.local[0];
PARAM	toLightScreen[4] = {program.local[1..4]};
PARAM	shadowEpsilon = 0.05;
PARAM	sampleStepX = {0.001953125, 0.0};
PARAM	sampleStepY = {0.0, 0.001953125};
PARAM	sampleStepXY = {0.001953125, 0.001953125};
PARAM	smapRes = 512.0;
PARAM	smapResInv = 0.001953125;
TEMP	depthTex, screenTC, sampleTC, texelTC, t, screenPos, lightScreenPos, lerpFrac, res;

#scale the rasterized coordinate into screenspace for the depth lookup
MUL	screenTC.xy, fragment.position, screenScale;

#derive a projected screen position from the fragment x/y and depth
TEX	depthTex, screenTC, texture[0], 2D;
RCP	t.x, fragment.texcoord[0].w;
MUL	screenPos.xy, fragment.texcoord[0], t.x;
MOV	screenPos.z, depthTex.x;
MOV	screenPos.w, 1.0;

#transform into the light's screenspace
DP4	lightScreenPos.x, toLightScreen[0], screenPos;
DP4	lightScreenPos.y, toLightScreen[1], screenPos;
DP4	lightScreenPos.z, toLightScreen[2], screenPos;
DP4	lightScreenPos.w, toLightScreen[3], screenPos;

#pre-divide by w in light screenspace
RCP	t.x, lightScreenPos.w;
MUL	screenTC.xyz, lightScreenPos, t.x;

#scale into texture coordinate space
MAD	screenTC.xy, screenTC, 0.5, 0.5;

#get the lerp fraction
MUL	texelTC.xy, screenTC, smapRes;
FRC	lerpFrac.xy, texelTC;

#do the samples
TEX	depthTex, screenTC, texture[1], 2D;
SUB	depthTex.x, screenTC.z, depthTex.x;
SGE	t.x, depthTex.x, shadowEpsilon;

ADD	sampleTC, screenTC, sampleStepX;
TEX	depthTex, sampleTC, texture[1], 2D;
SUB	depthTex.x, screenTC.z, depthTex.x;
SGE	res.y, depthTex.x, shadowEpsilon;

ADD	sampleTC, screenTC, sampleStepY;
TEX	depthTex, sampleTC, texture[1], 2D;
SUB	depthTex.x, screenTC.z, depthTex.x;
SGE	res.z, depthTex.x, shadowEpsilon;

ADD	sampleTC, screenTC, sampleStepXY;
TEX	depthTex, sampleTC, texture[1], 2D;
SUB	depthTex.x, screenTC.z, depthTex.x;
SGE	res.w, depthTex.x, shadowEpsilon;

LRP	t.x, lerpFrac.x, res.y, t.x;
LRP	t.y, lerpFrac.x, res.w, res.z;
LRP	out, lerpFrac.y, t.y, t.x;

END
