!!ARBfp1.0

#standard lighting with normal mapping and per pixel attenuation
#Author: Rich Whitehouse
#---------------------------------------------------------------------

#this has become somewhat of a mess.
#texture0 is the decal
#texture1 is the normal map, with dynamic shadow coords in .texcoord
#texture2 is the dynamic shadow texture, with light vectors in .texcoord
#texture3 is the 3d attenuation texture

PARAM	mulf = {2.0, 2.0, 2.0};
PARAM	subf = {-1.0, -1.0, -1.0};
PARAM	lightColor = program.env[1];

OUTPUT	out = result.color;
TEMP	cbrf, nrml, dcal, attn, temp, dshd;

#fetch the textures
TEX	dcal, fragment.texcoord[0], texture[0], 2D;
TEX	nrml, fragment.texcoord[0], texture[1], 2D;
TXP	dshd, fragment.texcoord[1], texture[2], 2D;
TEX	attn, fragment.texcoord[3], texture[3], 3D;

MOV	cbrf, fragment.texcoord[2];

#expand the normal
MAD	nrml, nrml, mulf, subf;
#re-normalize interpolated normal
DP3	temp, nrml, nrml;
RSQ	temp, temp.x;
MUL	nrml, nrml, temp;

#re-normalize interpolated light vector
DP3	temp, cbrf, cbrf;
RSQ	temp, temp.x;
MUL	temp, temp.x, cbrf;

DP3	temp, nrml, temp;

MUL	temp, temp, lightColor; #factor in light color

#apply minimum light level
MAX	temp, lightColor.w, temp;

MUL	temp, dcal, temp; #factor in decal
MUL	temp, fragment.color, temp; #factor in ambient color
MUL	temp, attn, temp; #factor in attenuation
SUB	dshd, 1.0, dshd;
MUL	temp, dshd, temp; #factor in dynamic shadows

MOV	temp.a, dcal.a; #set alpha component by decal

MOV	out, temp;

END
