!!ARBfp1.0

#standard lighting with normal mapping and per pixel attenuation and parallax mapping
#written by Rich Whitehouse
#---------------------------------------------------------------------

#texture0 is the decal
#texture1 is the normal map, with dynamic shadow coords in .texcoord
#texture2 is the dynamic shadow texture, with light vectors in .texcoord
#texture3 is the viewangle vectors

PARAM	mulf = {2.0, 2.0, 2.0};
PARAM	subf = {-1.0, -1.0, -1.0};

OUTPUT	out = result.color;
TEMP	cbrf, nrml, dcal, temp, height, eyevects, newtexcoord, dshd;

#as per parallax_mapping.pdf by Terry Welsh
DP3	temp, fragment.texcoord[3], fragment.texcoord[3];
RSQ	temp, temp.x;
MUL	eyevects, fragment.texcoord[3], temp;

#fetch normal map texture
TEX	height, fragment.texcoord[0], texture[1], 2D;

#copy alpha into rgb
MOV	height.r, height.a;
MOV	height.g, height.a;
MOV	height.b, height.a;

#scale and bias
MAD	height, height, 0.08, -0.03;
#MAD	height, height, 0.02, -0.01;
MAD	newtexcoord, height, eyevects, fragment.texcoord[0];

#fetch the textures
TEX	dcal, newtexcoord, texture[0], 2D;
TEX	nrml, newtexcoord, texture[1], 2D;
TXP	dshd, fragment.texcoord[1], texture[2], 2D;

MOV	cbrf, fragment.texcoord[2];

#expand the normals
MAD	nrml, nrml, mulf, subf;
MAD	cbrf, cbrf, mulf, subf;

#now done here instead of relying on cubemap
DP3	temp, cbrf, cbrf;
RSQ	temp, temp.x;
MUL	temp, temp.x, cbrf;
DP3	temp, nrml, temp;

MUL	temp, temp, fragment.color; #factor in light color

#apply minimum light level
MAX	temp, fragment.color.primary.a, temp;

MUL	temp, dcal, temp; #factor in decal
MUL	temp, dshd, temp; #factor in dynamic shadows

MOV	temp.a, dcal.a; #set alpha component by decal

MOV	out, temp;

END
