#define MAX_RSCRIPT_REGISTERS	8
#define MAX_RSCRIPT_STACK		16
#define MAX_RSCRIPT_ARGS		16
#define MAX_RSCRIPT_NAME_STR	128
#define MAX_RSCRIPT_LABELS		512
#define MAX_RSCRIPTS			512

typedef struct rscriptNode_s rscriptNode_t;
typedef struct rscriptLabel_s rscriptLabel_t;

#define ROP_CMPBIT_LESS			(1<<1)
#define ROP_CMPBIT_GREATER		(1<<2)
#define ROP_CMPBIT_EQUAL		(1<<3)

typedef enum
{
	ROP_INTREG_CMP,
	ROP_INTREG_COUNT,
	ROP_INTREG_STORE1,
	NUM_ROP_INTREGS
} rscriptInternalRegs_e;

typedef struct rscriptArg_s
{
	char			p[MAX_RSCRIPT_NAME_STR];
} rscriptArg_t;

typedef struct rscriptHandler_s
{
	char			*name;
	bool			(*handlerFunc)(rscriptNode_t *node, rscript_t *rscript, float timeMod);
	int				argNum;
} rscriptHandler_t;

typedef struct rscriptNode_s
{
	rscriptArg_t		menuArgs[MAX_RSCRIPT_ARGS];
	rscriptHandler_t	*nodeHandler;

	rscriptNode_t		*next;
} rscriptNode_t;

typedef struct rscriptLabel_s
{
	char				name[MAX_RSCRIPT_NAME_STR];
	rscriptNode_t		*node;
} rscriptLabel_t;

typedef struct rscriptBase_s
{
	char				name[MAX_RSCRIPT_NAME_STR];
	rscriptNode_t		*nodes;
} rscriptBase_t;

typedef struct rscript_s
{
	rscriptBase_t		*curScript;
	rscriptNode_t		*curNode;
	rscriptNode_t		*retNode;
	serverTime_t		scriptTime;

	unsigned int		ropRegs[MAX_RSCRIPT_REGISTERS];
	unsigned int		ropIntRegs[NUM_ROP_INTREGS];
	char				*ropStack[MAX_RSCRIPT_STACK];
	int					ropStackPtr;
} rscript_t;

typedef struct rscriptDefine_s rscriptDefine_t;
typedef struct rscriptDefine_s
{
	char				*name;
	char				*val;
	rscriptDefine_t		*next;
} rscriptDefine_t;

//rscript.cpp
extern void RScr_Init(void);
extern void RScr_Shutdown(void);
extern rscriptLabel_t *RScr_GetLabel(char *labelName);
extern void RScr_ParseScriptFile(const char *filename);
extern rscript_t *RScr_CreateScript(const char *scriptName);
extern void RScr_DestroyScript(rscript_t *rscr);
extern bool RScr_RunScript(rscript_t *rscr, float timeMod);

//rscript_han.cpp
extern char *RScr_GetArgStr(rscriptNode_t *node, rscript_t *rscript, int argIdx);
extern bool RSHan_Delay(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_DelayRand(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_CacheRes(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_CacheObj(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_RunScript(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_ChangeMap(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_WaitOnScript(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_WaitOnFrame(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_WaitOnInput(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_WaitOnEnemiesDead(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_WaitOnDyingEnemies(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_WaitOnEnemiesNum(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_WaitOnDead(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_KillEnemies(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_KillEnemiesPassive(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_KillEnemiesQuiet(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_ToggleNoTarget(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_ToggleConfuse(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_MagicModeCheck(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_StatMsg(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_ArenaMsg(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_SetFade(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_SetFadeColor(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_LerpFade(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_SetPicFade(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_LerpPicFade(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_PushPic(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_ShowHUD(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_RunMenuScript(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_RollCredits(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_SetCinema(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_SetMusic(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_CycleMusic(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_SetBattleMusic(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_SetMagicMode(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_SetEndlessBattle(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_EndlessBattleSpawns(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_SetMPVersusMode(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_SetSkyModel(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_SetSkyTerrain(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_SetSkyColor(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_SetSkyColorRand(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_SetPropFrames(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_ForceNextAnim(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_SetPlMoveSpeed(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_SetPlCamTarg(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_SetPlCamRange(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_GivePlItem(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_GivePlMako(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_GivePlCharge(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_SetCamBolt(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_SetCamAbsOfs(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_SetCamSlack(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_SetCamFov(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_LerpCamFov(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_SetActionTime(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_SetActionTimeScale(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_SetAmbientLight(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_LerpAmbientLight(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_LerpAmbientLightEvil(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_SetViewTrails(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_SetBloomMod(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_SetPclTimeScale(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_SetViewFlash(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_SetViewShake(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_SetEnSpawnBlock(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_MPShowStats(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_MPMatchCheck(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_MPBeginMatch(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_MPEndMatch(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_ObjCreate(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_ObjCreateNamed(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_ObjCreateNamedAtObj(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_ObjCreateNamedInObj(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_ObjCreateNamedInObjRnd(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_ObjCreateEnemy(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_ObjCreateEnemyForce(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_ObjCreateEnemyMax(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_ObjCreateSneaky(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_ObjCreateItem(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_ObjCreateItemAlt(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_ObjRemoveTempItems(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_ObjRemove(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_ObjActivate(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_ObjMovePos(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_ObjSetPos(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_ObjPutGround(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_ObjGiveHealth(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_ObjSetTarget(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_ObjSetDebounce(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_ObjMoveAng(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_ObjLookAt(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_ObjSetAng(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_ObjSound(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_ObjSoundRand(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_ObjFX(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_ObjFXBolted(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_ObjRFXSetBit(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_ObjRFXUnsetBit(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_ObjRFX2SetBit(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_ObjRFX2UnsetBit(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_ObjSetAnim(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_ObjSetAnimNum(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_ObjSetAIGoal(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_ObjSetAIEnemy(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_ObjSetAILookGoal(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_ObjSetAIMoveSpeed(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_ObjTalkBubble(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_ObjDamage(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_ObjSetLight(rscriptNode_t *node, rscript_t *rscript, float timeMod);

//rscript_rop.cpp
extern bool RSHan_ROP_JMP(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_ROP_JR(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_ROP_JE(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_ROP_JNE(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_ROP_JGE(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_ROP_JLE(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_ROP_JG(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_ROP_JL(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_ROP_PUSH(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_ROP_POP(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_ROP_POPGVAR(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_ROP_LDRI(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_ROP_LDRU(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_ROP_LDRF(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_ROP_LDRO(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_ROP_LDRINV(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_ROP_STRO(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_ROP_STRGI(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_ROP_STRGF(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_ROP_ADDI(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_ROP_ADDU(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_ROP_ADDF(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_ROP_SUBI(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_ROP_SUBU(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_ROP_SUBF(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_ROP_MULI(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_ROP_MULU(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_ROP_MULF(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_ROP_DIVI(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_ROP_DIVU(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_ROP_DIVF(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_ROP_SHL(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_ROP_SHR(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_ROP_AND(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_ROP_OR(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_ROP_XOR(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_ROP_CMPI(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_ROP_CMPU(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_ROP_CMPF(rscriptNode_t *node, rscript_t *rscript, float timeMod);
extern bool RSHan_ROP_CMPS(rscriptNode_t *node, rscript_t *rscript, float timeMod);
