/*
=============================================================================
Module Information
------------------
Name:			shared.cpp
Author:			Rich Whitehouse
Description:	compiled into both server and client modules, shared code.
=============================================================================
*/

#include <windows.h>
#include <stdio.h>
#include <io.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <math.h>
#include <assert.h>
#include <malloc.h>
#include "sharedtypes.h"

statInfo_t g_statInfo[5] =
{
	{"HP",
	"Dictates the maximum number of hitpoints that can be accumulated.",
	50, 1000, 2000},	//hp

	{"Strength",
	"Increases damage dealt.",
	1, 255, 500},		//str

	{"Defense",
	"Decreases damage taken.",
	1, 255, 500},		//def

	{"Dexterity",
	"Increases the rate of the charge meter, among other things.",
	1, 255, 300},		//dex

	{"Luck",
	"Increases drop rates and other favorable random chances.",
	1, 255, 500}		//luck
};

const aiDesc_t g_aiDesc[NUM_AI_DESC] =
{
	//AIDESC_NONE
	{
		"???"
	},

	//AIDESC_E30BLUE
	{
		"Grunt"
	},

	//AIDESC_E30PURPLE
	{
		"Fighter"
	},

	//AIDESC_E30PURPLEWEAK
	{
		"Fighter Trainee"
	},

	//AIDESC_E30RED
	{
		"Fighter Captain"
	},

	//AIDESC_E30BLACK
	{
		"Assassin"
	},

	//AIDESC_THEDOLLAR
	{
		"The Dollar"
	},

	//AIDESC_DOG1
	{
		"Guard Dog"
	},

	//AIDESC_DOG2
	{
		"Blood Taste"
	},

	//AIDESC_DOG3
	{
		"Hell Beast"
	},

	//AIDESC_EAT1
	{
		"Whole Eater"
	},

	//AIDESC_EAT2
	{
		"Soul Eater"
	},

	//AIDESC_BOMB1
	{
		"Bomb"
	},

	//AIDESC_BOMB2
	{
		"Grenade"
	},

	//AIDESC_GIG1
	{
		"Gigas"
	},

	//AIDESC_GIG2
	{
		"Death Gigas"
	},

	//AIDESC_GIG3
	{
		"Hell Gigas"
	},

	//AIDESC_IRON1
	{
		"Iron Man"
	},

	//AIDESC_IRON2
	{
		"Wolfmeister"
	},

	//AIDESC_TON1
	{
		"Tonberry"
	},

	//AIDESC_TON2
	{
		"Bloodberry"
	},

	//AIDESC_HORN1
	{
		"Grand Horn"
	},

	//AIDESC_HORN2
	{
		"Horned Devil"
	},

	//AIDESC_MAD1
	{
		"Madouge"
	},

	//AIDESC_MAD2
	{
		"Screamer"
	},

	//AIDESC_CLOUD
	{
		"Cloud"
	},

	//AIDESC_BARRETT
	{
		"Barrett"
	},

	//AIDESC_AERITH
	{
		"Aerith"
	},

	//AIDESC_JENOVA
	{
		"Jenova Manifestation"
	},

	//AIDESC_SEPHFIN
	{
		"Sephiroth"
	},

	//AIDESC_CHOCO
	{
		"Chocobo"
	},

	//AIDESC_CCON
	{
		"Defense System"
	}
};

invItemDef_t g_invItems[NUM_INVENTORY_ITEM_DEFS] =
{
	//INVITEM_NONE
	{"None", "", "", "", INVITEM_BEHAVIOR_ADDHEALTH, 0, 0, 0, 0, 99},

	//INVITEM_POTION
	{"Potion", "assets/textures/items/item_potion", "Restores some health.", "items/potion", INVITEM_BEHAVIOR_ADDHEALTH, 150, 1, 50, 0, 99},

	//INVITEM_HIPOTION
	{"Hi-Potion", "assets/textures/items/item_potion2", "Restores a lot of health.", "items/potion", INVITEM_BEHAVIOR_ADDHEALTH, 400, 1, 500, 0, 99},

	//INVITEM_XPOTION
	{"X-Potion", "assets/textures/items/item_potion3", "Restores all health.", "items/potion", INVITEM_BEHAVIOR_ADDHEALTH, 9999, 1, 2000, 0, 99},

	//INVITEM_ETHER
	{"Ether", "assets/textures/items/item_ether", "Restores one mako charge.", "items/ether", INVITEM_BEHAVIOR_ADDCHARGE, 1, 1, 2000, 0, 99},

	//INVITEM_ELIXER
	{"Elixer", "assets/textures/items/item_potion4", "Restores all health and mako charges.", "items/elixer", INVITEM_BEHAVIOR_FULLHEALTHCHARGE, 9999, 1, 6000, 0, 99},

	//INVITEM_MMTS
	{"Mmts", "assets/textures/items/item_mmts", "Mamitasu-sama, goodsmr!", "items/elixer", INVITEM_BEHAVIOR_MMTS, 50, 1, 0, 0, 1},

	//INVITEM_PHOENIXDOWN
	{"Phoenix Down", "assets/textures/items/item_phoenix", "Prevents death while equipped.", "", INVITEM_BEHAVIOR_PHOENIX, 1, 0, 6000, 0, 99},

	//INVITEM_BATTLEKEY
	{"Battle Key", "assets/textures/items/item_key", "Allows access to the battle arena.", "", INVITEM_BEHAVIOR_SPECIAL, 1, 0, 200, 1, 1},

	//INVITEM_WONDROUSMAP
	{"Wondrous Map", "assets/textures/items/item_key", "A strange map, pointing the way to a place called Chocobo Wonderland.", "", INVITEM_BEHAVIOR_SPECIAL, 1, 0, 0, 1, 1},

	//INVITEM_TIFERET
	{"Tiferet", "assets/textures/items/item_key", "It emanates a feeling of balance.", "", INVITEM_BEHAVIOR_SPECIAL, 1, 0, 0, 1, 1},

	//INVITEM_RINGOFSIGHT
	{"Vision Ring", "assets/textures/items/item_ring", "View enemy health.", "", INVITEM_BEHAVIOR_VIEWHEALTH, 1, 0, 0, 0, 1},

	//INVITEM_SHRAPNEL
	{"Shrapnel", "assets/textures/items/item_sack", "Deals explosive damage.", "other/bombblow", INVITEM_BEHAVIOR_RADIUSDMG, 500, 1, 300, 0, 99},

	//INVITEM_RIGHTARM
	{"Right Arm", "assets/textures/items/item_sack", "Deals heavy explosive damage.", "other/bombblow", INVITEM_BEHAVIOR_RADIUSDMG, 900, 1, 0, 0, 99},

	//INVITEM_VAMPIREFANG
	{"Vampire Fang", "assets/textures/items/item_sack", "Drains energy from opponents.", "items/drain", INVITEM_BEHAVIOR_DRAIN, 100, 1, 2000, 0, 99},

	//INVITEM_HELLFANG
	{"Hell Fang", "assets/textures/items/item_sack", "Drains vast amounts of energy from opponents.", "items/drain", INVITEM_BEHAVIOR_DRAIN, 500, 1, 0, 0, 99},

	//INVITEM_LOCOWEED
	{"Loco Weed", "assets/textures/items/item_sack", "Confuses opponents.", "items/speed", INVITEM_BEHAVIOR_CONFUSE, 20000, 1, 900, 0, 99},

	//INVITEM_GRAVIBALL
	{"Graviball", "assets/textures/items/item_sack", "Creates a vortex of energy.", "", INVITEM_BEHAVIOR_VORTEX, 1600, 1, 5000, 0, 99},

	//INVITEM_EARTHDRUM
	{"Earth Drum", "assets/textures/items/item_sack", "Sends tremors through the ground.", "", INVITEM_BEHAVIOR_QUAKE, 200, 1, 400, 0, 99},

	//INVITEM_SPEEDDRINK
	{"Speed Drink", "assets/textures/items/item_sack", "Gives a boost of speed.", "items/speed", INVITEM_BEHAVIOR_HASTEUSE, 10000, 1, 500, 0, 99},

	//INVITEM_CHOCONECTAR
	{"ChocoNectar", "assets/textures/items/item_sack", "You can taste the wark.", "items/speed", INVITEM_BEHAVIOR_HASTEUSE, 20000, 1, 0, 0, 99},

	//INVITEM_OMEGA
	{"Omega", "assets/textures/items/item_sword", "A blade embodying the essence of destruction.", "*obj_omega", INVITEM_BEHAVIOR_SWORD, 1, 0, 5000, 0, 1},

	//INVITEM_EINSOF
	{"Ein-Sof", "assets/textures/items/item_sword", "An ever-changing blade, formed at the origin of creation.", "*obj_einsof", INVITEM_BEHAVIOR_SWORD, 1, 0, 15000, 1, 1},

	//INVITEM_TASTYGREENS
	{"Tasty Greens", "assets/textures/items/item_sack", "A nice chocobo snack.", "", INVITEM_BEHAVIOR_GREENS, 1, 1, 500, 0, 99},

	//INVITEM_SPANISHGREENS
	{"Spanish Greens", "assets/textures/items/item_sack", "A bit crude, but they do the job.", "", INVITEM_BEHAVIOR_GREENS, 2, 1, 1000, 0, 99},

	//INVITEM_CLASSYGREENS
	{"Classy Greens", "assets/textures/items/item_sack", "A fine dining experience, for the more refined chocobo.", "", INVITEM_BEHAVIOR_GREENS, 3, 1, 2000, 0, 99},

	//INVITEM_KINKYGREENS
	{"Kinky Greens", "assets/textures/items/item_sack", "It's best not to think about it.", "", INVITEM_BEHAVIOR_GREENS, 4, 1, 5000, 0, 99},

	//INVITEM_POWERWRIST
	{"Power Wrist", "assets/textures/items/item_ring", "Enhances strength by 30.", "", INVITEM_BEHAVIOR_MODSTR, 30, 0, 3000, 1, 1},

	//INVITEM_CHAMPIONBELT
	{"Champion Belt", "assets/textures/items/item_ring", "Enhances strength by 50.", "", INVITEM_BEHAVIOR_MODSTR, 50, 0, 0, 1, 1},

	//INVITEM_PROTECTRING
	{"Protect Ring", "assets/textures/items/item_ring", "Enhances defense by 30.", "", INVITEM_BEHAVIOR_MODDEF, 30, 0, 3000, 1, 1},

	//INVITEM_SHIELDRING
	{"Shield Ring", "assets/textures/items/item_ring", "Enhances defense by 50.", "", INVITEM_BEHAVIOR_MODDEF, 50, 0, 0, 1, 1},

	//INVITEM_CHOCOFEATHER
	{"ChocoFeather", "assets/textures/items/item_ring", "Enhances dexterity by 30.", "", INVITEM_BEHAVIOR_MODDEX, 30, 0, 3000, 1, 1},

	//INVITEM_AMULET
	{"Amulet", "assets/textures/items/item_ring", "Enhances luck by 20.", "", INVITEM_BEHAVIOR_MODLUCK, 20, 0, 4000, 1, 1},

	//INVITEM_MOOGLECHARM
	{"Moogle Charm", "assets/textures/items/item_ring", "Enhances luck by 40.", "", INVITEM_BEHAVIOR_MODLUCK, 40, 0, 0, 0, 1},

	//INVITEM_FIREFANG
	{"Fire Fang", "assets/textures/items/item_sack", "Deal fire damage.", "", INVITEM_BEHAVIOR_MAKOFIRE, 20000, 1, 500, 0, 99},

	//INVITEM_STARDUST
	{"Stardust", "assets/textures/items/item_sack", "Deal cosmic force.", "", INVITEM_BEHAVIOR_MAKOAURA, 20000, 1, 1000, 0, 99},

	//INVITEM_HOURGLASS
	{"Hourglass", "assets/textures/items/item_sack", "Slow the passage of time.", "", INVITEM_BEHAVIOR_MAKOTIME, 4000, 1, 1000, 0, 99},

	//INVITEM_SPRINTSHOES
	{"Sprint Shoes", "assets/textures/items/item_ring", "Provides a boost in speed.", "", INVITEM_BEHAVIOR_HASTE, 1, 0, 0, 0, 1},

	//INVITEM_FURYRING
	{"Fury Ring", "assets/textures/items/item_ring", "Pain is veiled through fury.", "", INVITEM_BEHAVIOR_NOPAIN, 1, 0, 10000, 1, 1},

	//INVITEM_CATSBELL
	{"Cat's Bell", "assets/textures/items/item_ring", "Walking slowly restores health.", "", INVITEM_BEHAVIOR_HEALSTEP, 1, 0, 0, 0, 1},

	//INVITEM_FINALHEAVEN
	{"Final Heaven", "assets/textures/items/item_ring", "The force is unstoppable.", "", INVITEM_BEHAVIOR_FINALHEAVEN, 1, 0, 0, 0, 1},

	//INVITEM_GLOCK
	{"Glock", "assets/textures/items/item_gun", "A ranged weapon of some sort. An inscription indicates that it once belonged to someone named Aya Brea.", "*obj_glock", INVITEM_BEHAVIOR_GUN, 1, 0, 8000, 1, 1},

	//INVITEM_FLASHLIGHT
	{"Flashlight", "assets/textures/items/item_ring", "A hip-mounted flashlight.", "*obj_flashlight", INVITEM_BEHAVIOR_FLASHLIGHT, 1, 0, 0, 0, 1},

	//INVITEM_HATCHET
	{"Midget Force", "assets/textures/items/item_sword", "A rusty old hatchet, covered in strange juices.", "*obj_hatchet", INVITEM_BEHAVIOR_SWORD, 1, 0, 0, 1, 1},

	//INVITEM_BUSTER
	{"Buster-Yesod", "assets/textures/items/item_sword", "A complex variant of Cloud's Buster Sword.", "*obj_buster", INVITEM_BEHAVIOR_SWORD, 1, 0, 0, 1, 1},

	//INVITEM_BLOODBUSTER
	{"Buster-Kor", "assets/textures/items/item_sword", "A transmogrified Buster Sword, which appears to feed on the essence of life.", "*obj_buster2", INVITEM_BEHAVIOR_SWORD, 1, 0, 0, 1, 1},

	//INVITEM_PURITY
	{"Purity", "assets/textures/items/item_sack", "The thriving physical essence of purity, from deep within the planet.", "items/addmako", INVITEM_BEHAVIOR_ADDMAKO, 50000, 1, 0, 1, 1},

	//INVITEM_MAKO1
	{"Mako Deposit", "assets/textures/items/item_sack", "A large deposit of raw, unrefined mako.", "items/addmako", INVITEM_BEHAVIOR_ADDMAKO, 2000, 1, 0, 1, 1},

	//INVITEM_MAKO2
	{"Planet Energy", "assets/textures/items/item_sack", "A sample of raw planet energy from the lifestream.", "items/addmako", INVITEM_BEHAVIOR_ADDMAKO, 8000, 1, 0, 1, 1},

	//INVITEM_MASAMUNE
	{"Masamune", "assets/textures/items/item_sword", "The legendary blade, Masamune.", "*obj_masamune", INVITEM_BEHAVIOR_SWORD, 1, 0, 0, 1, 1},

	//INVITEM_USERMOD01
	{"User Item 1", "assets/textures/items/item_sack", "Reserved for user mods.", "", INVITEM_BEHAVIOR_SPECIAL, 1, 0, 0, 0, 1},
	//INVITEM_USERMOD02
	{"User Item 2", "assets/textures/items/item_sack", "Reserved for user mods.", "", INVITEM_BEHAVIOR_SPECIAL, 1, 0, 0, 0, 1},
	//INVITEM_USERMOD03
	{"User Item 3", "assets/textures/items/item_sack", "Reserved for user mods.", "", INVITEM_BEHAVIOR_SPECIAL, 1, 0, 0, 0, 1},
	//INVITEM_USERMOD04
	{"User Item 4", "assets/textures/items/item_sack", "Reserved for user mods.", "", INVITEM_BEHAVIOR_SPECIAL, 1, 0, 0, 0, 1},
	//INVITEM_USERMOD05
	{"User Item 5", "assets/textures/items/item_sack", "Reserved for user mods.", "", INVITEM_BEHAVIOR_SPECIAL, 1, 0, 0, 0, 1},
	//INVITEM_USERMOD06
	{"User Item 6", "assets/textures/items/item_sack", "Reserved for user mods.", "", INVITEM_BEHAVIOR_SPECIAL, 1, 0, 0, 0, 1},
	//INVITEM_USERMOD07
	{"User Item 7", "assets/textures/items/item_sack", "Reserved for user mods.", "", INVITEM_BEHAVIOR_SPECIAL, 1, 0, 0, 0, 1},
	//INVITEM_USERMOD08
	{"User Item 8", "assets/textures/items/item_sack", "Reserved for user mods.", "", INVITEM_BEHAVIOR_SPECIAL, 1, 0, 0, 0, 1},
	//INVITEM_USERMOD09
	{"User Item 9", "assets/textures/items/item_sack", "Reserved for user mods.", "", INVITEM_BEHAVIOR_SPECIAL, 1, 0, 0, 0, 1},
	//INVITEM_USERMOD10
	{"User Item 10", "assets/textures/items/item_sack", "Reserved for user mods.", "", INVITEM_BEHAVIOR_SPECIAL, 1, 0, 0, 0, 1},
	//INVITEM_USERMOD11
	{"User Item 11", "assets/textures/items/item_sack", "Reserved for user mods.", "", INVITEM_BEHAVIOR_SPECIAL, 1, 0, 0, 0, 1},
	//INVITEM_USERMOD12
	{"User Item 12", "assets/textures/items/item_sack", "Reserved for user mods.", "", INVITEM_BEHAVIOR_SPECIAL, 1, 0, 0, 0, 1},
	//INVITEM_USERMOD13
	{"User Item 13", "assets/textures/items/item_sack", "Reserved for user mods.", "", INVITEM_BEHAVIOR_SPECIAL, 1, 0, 0, 0, 1},
	//INVITEM_USERMOD14
	{"User Item 14", "assets/textures/items/item_sack", "Reserved for user mods.", "", INVITEM_BEHAVIOR_SPECIAL, 1, 0, 0, 0, 1},
	//INVITEM_USERMOD15
	{"User Item 15", "assets/textures/items/item_sack", "Reserved for user mods.", "", INVITEM_BEHAVIOR_SPECIAL, 1, 0, 0, 0, 1},
	//INVITEM_USERMOD16
	{"User Item 16", "assets/textures/items/item_sack", "Reserved for user mods.", "", INVITEM_BEHAVIOR_SPECIAL, 1, 0, 0, 0, 1},
	//INVITEM_USERMOD17
	{"User Item 17", "assets/textures/items/item_sack", "Reserved for user mods.", "", INVITEM_BEHAVIOR_SPECIAL, 1, 0, 0, 0, 1},
	//INVITEM_USERMOD18
	{"User Item 18", "assets/textures/items/item_sack", "Reserved for user mods.", "", INVITEM_BEHAVIOR_SPECIAL, 1, 0, 0, 0, 1},
	//INVITEM_USERMOD19
	{"User Item 19", "assets/textures/items/item_sack", "Reserved for user mods.", "", INVITEM_BEHAVIOR_SPECIAL, 1, 0, 0, 0, 1},
	//INVITEM_USERMOD20
	{"User Item 20", "assets/textures/items/item_sack", "Reserved for user mods.", "", INVITEM_BEHAVIOR_SPECIAL, 1, 0, 0, 0, 1}
};

//load user items
void Shared_LoadUserItems(sharedInterface_t *si)
{
	char *filename = "assets/objects/invitems.rci";
	textParser_t *parser = si->Parse_InitParserFromFile(filename);
	if (!parser)
	{
		return;
	}

	char groupName[MAX_TOKEN_SIZE];
	groupName[0] = 0;
	parseToken_t tok;
	int itemNum = 0;
	invItemDef_t *targItem = &g_invItems[INVITEM_USERMOD01];
	while (si->Parse_GetNextToken(parser, &tok))
	{
		if (tok.groupName && strcmp(tok.groupName, groupName))
		{
			targItem = &g_invItems[INVITEM_USERMOD01+itemNum];
			strcpy(groupName, tok.groupName);
			itemNum++;
		}

		if (!stricmp(tok.text, "name"))
		{
			if (si->Parse_GetNextToken(parser, &tok))
			{
				strcpy(targItem->name, tok.text);
			}
		}
		else if (!stricmp(tok.text, "icon"))
		{
			if (si->Parse_GetNextToken(parser, &tok))
			{
				strcpy(targItem->icon, tok.text);
			}
		}
		else if (!stricmp(tok.text, "desc"))
		{
			if (si->Parse_GetNextToken(parser, &tok))
			{
				strcpy(targItem->desc, tok.text);
			}
		}
		else if (!stricmp(tok.text, "useFX"))
		{
			if (si->Parse_GetNextToken(parser, &tok))
			{
				strcpy(targItem->useFX, tok.text);
			}
		}
		else if (!stricmp(tok.text, "itemBehavior"))
		{
			if (si->Parse_GetNextToken(parser, &tok))
			{
				targItem->itemBehavior = atoi(tok.text);
			}
		}
		else if (!stricmp(tok.text, "itemValue"))
		{
			if (si->Parse_GetNextToken(parser, &tok))
			{
				targItem->itemValue = atoi(tok.text);
			}
		}
		else if (!stricmp(tok.text, "usable"))
		{
			if (si->Parse_GetNextToken(parser, &tok))
			{
				targItem->usable = atoi(tok.text);
			}
		}
		else if (!stricmp(tok.text, "cost"))
		{
			if (si->Parse_GetNextToken(parser, &tok))
			{
				targItem->cost = atoi(tok.text);
			}
		}
		else if (!stricmp(tok.text, "secret"))
		{
			if (si->Parse_GetNextToken(parser, &tok))
			{
				targItem->secret = atoi(tok.text);
			}
		}
	}

	si->Parse_FreeParser(parser);
}

//can the player have it?
bool Shared_CanHaveItem(playerData_t *plData, int itemIndex)
{
	const invItemDef_t *item = &g_invItems[itemIndex];
	bool anyFreeSlots = false;
	for (int i = 1; i < MAX_PLAYER_INVENTORY_ITEMS; i++)
	{
		if (plData->inventory[i].itemIndex == itemIndex &&
			plData->inventory[i].itemQuantity >= item->maxAmount)
		{
			return false;
		}
		else if (plData->inventory[i].itemQuantity == 0)
		{
			anyFreeSlots = true;
		}
	}

	return anyFreeSlots;
}

//give item
bool Shared_GiveItem(playerData_t *plData, int itemIndex)
{
	const invItemDef_t *item = &g_invItems[itemIndex];
	playerInvItem_t *plItem;
	int freeSlot = -1;
	bool gave = false;
	for (int i = 0; i < MAX_PLAYER_INVENTORY_ITEMS; i++)
	{
		plItem = &plData->inventory[i];
		if (plItem->itemIndex == itemIndex)
		{ //already have it, add one
			plItem->itemQuantity++;
			if (plItem->itemQuantity > item->maxAmount)
			{
				plItem->itemQuantity = item->maxAmount;
			}
			gave = true;
			break;
		}
		else if (freeSlot == -1 && plItem->itemQuantity == 0)
		{ //free slot
			freeSlot = i;
		}
	}

	if (!gave)
	{
		if (freeSlot == -1)
		{ //full
			return false;
		}
		plItem = &plData->inventory[freeSlot];
		plItem->itemIndex = itemIndex;
		plItem->itemQuantity = 1;
		gave = true;
	}

	return gave;
}

//does the player have it?
int Shared_HasItem(playerData_t *plData, int itemIndex)
{
	const invItemDef_t *item = &g_invItems[itemIndex];
	bool anyFreeSlots = false;
	for (int i = 1; i < MAX_PLAYER_INVENTORY_ITEMS; i++)
	{
		if (plData->inventory[i].itemIndex == itemIndex &&
			plData->inventory[i].itemQuantity > 0)
		{
			return plData->inventory[i].itemQuantity;
		}
	}
	return 0;
}

//forge item
void Shared_ForgeItem(playerData_t *plData, int itemIndex, int &makoStash)
{
	const invItemDef_t *item = &g_invItems[itemIndex];
	if (makoStash < item->cost)
	{
		return;
	}
	if (!Shared_CanHaveItem(plData, itemIndex))
	{
		return;
	}
	Shared_GiveItem(plData, itemIndex);
	makoStash -= item->cost;
}

const playerAbility_t g_plAbilities[NUM_PLAYER_ABILITIES] =
{
	//PLABIL_FLURRY
	{
		"Flurry",
		"",
		"A large chain of attacks, which deal increasing damage with each strike.\n*$button_p$*(0.25 1 0.25 1), *$button_p$*(0.25 1 0.25 1), *$button_k$*(0.25 1 0.25 1), *$button_p$*(0.25 1 0.25 1), *$button_k$*(0.25 1 0.25 1), *$button_p$*(0.25 1 0.25 1), *$button_p$",
		0,
		0
	},

	//PLABIL_WALLJUMP
	{
		"Wall Jump",
		"",
		"Gain height by jumping off of surfaces.\n*$button_stick$*(0.25 1 0.25 1) toward surface + *$button_j$",
		0,
		400
	},

	//PLABIL_GETUP
	{
		"Fall Evasion",
		"",
		"Quickly jump or roll out of harm's way.\n*$button_j$*(0.25 1 0.25 1) while landing from a fall",
		(1<<PLABIL_WALLJUMP),
		200
	},

	//PLABIL_FLIPKICK
	{
		"Flip Kick",
		"",
		"Evade by flipping backward, with a defensive kick.\n*$button_stick$*(0.25 1 0.25 1) away from foe + *$button_k$",
		0,
		100
	},

	//PLABIL_THRUST
	{
		"Thrust",
		"",
		"A charging power attack that sends enemies flying.\n*$button_stick$*(0.25 1 0.25 1) toward foe + *$button_p$",
		0,
		500
	},

	//PLABIL_TACKLE
	{
		"Tackle",
		"",
		"Rush an opponent and chain into a combination attack.\n*(0.25 1 0.25 1)Thrust, then *$button_k$",
		(1<<PLABIL_THRUST),
		500
	},

	//PLABIL_GROUNDCRUSH
	{
		"Ground Crush",
		"",
		"Release an explosive blast that clears the floor.\n*$button_p$*(0.25 1 0.25 1) while in air",
		0,
		1000
	},

	//PLABIL_METEORKICK
	{
		"Meteor Kick",
		"",
		"An aerial attack, which sends the opponent flying downward into the ground.\n*(0.25 1 0.25 1)While in air, *$button_k$*(0.25 1 0.25 1), *$button_k$*(0.25 1 0.25 1), *$button_stick$*(0.25 1 0.25 1) toward foe + *$button_k$",
		0,
		800
	},

	//PLABIL_MAKOFLAME
	{
		"Fist of Flames",
		"",
		"Set enemies ablaze with your burning flames of passion!\n*$button_c$*(0.25 1 0.25 1)+*$button_p$",
		0,
		3000
	},

	//PLABIL_MAKOTIME
	{
		"Standstill",
		"",
		"Slow time to a crawl around you.\n*$button_c$*(0.25 1 0.25 1)+*$button_j$",
		0,
		3000
	},

	//PLABIL_MAKOHEAL
	{
		"Cleansing",
		"",
		"Raw energy continually restores wounds.\n*$button_c$*(0.25 1 0.25 1)+*$button_i$",
		0,
		4000
	},

	//PLABIL_MAKOAURA
	{
		"Lion's Aura",
		"",
		"Become enveloped in an aura of incredibly destructive force. All attacks inflict bursts of explosive damage.\n*$button_c$*(0.25 1 0.25 1)+*$button_k$",
		(1<<PLABIL_MAKOHEAL)|(1<<PLABIL_MAKOTIME)|(1<<PLABIL_MAKOFLAME),
		6000
	},

	//PLABIL_CHARGEFORCE
	{
		"Charge Force",
		"",
		"All mako charge attacks are doubled in duration.",
		(1<<PLABIL_MAKOAURA)|(1<<PLABIL_MAKOHEAL)|(1<<PLABIL_MAKOTIME)|(1<<PLABIL_MAKOFLAME),
		3000
	}
};

//forge ability
void Shared_ForgeAbility(playerData_t *plData, int ability, int &makoStash)
{
	const playerAbility_t *ab = &g_plAbilities[ability];
	if (makoStash < ab->cost)
	{
		return;
	}
	plData->abilities |= (1<<ability);
	makoStash -= ab->cost;
	plData->maxMakoCharges = 0;
	if (plData->abilities & (1<<PLABIL_MAKOFLAME))
	{
		plData->maxMakoCharges++;
	}
	if (plData->abilities & (1<<PLABIL_MAKOTIME))
	{
		plData->maxMakoCharges++;
	}
	if (plData->abilities & (1<<PLABIL_MAKOHEAL))
	{
		plData->maxMakoCharges++;
	}
	if (plData->abilities & (1<<PLABIL_MAKOAURA))
	{
		plData->maxMakoCharges++;
	}
}

//get the cost for a stat upgrade
int Shared_StatCost(int *stats, int statIndex)
{
	statInfo_t *stat = &g_statInfo[statIndex];
	if (statIndex == 0)
	{ //max health
		int m = stats[0]/50;
		return (stat->cost/40)*m;
	}
	if (stats[statIndex] >= 200)
	{
		return stats[statIndex]*4;
	}
	return stats[statIndex]*2;//stat->cost;
}

//forge stat
void Shared_ForgeStat(playerData_t *plData, int statIndex, int &makoStash)
{
	int stats[5] = {plData->maxHealth, plData->statStr,
		plData->statDef, plData->statDex, plData->statLuck};
	statInfo_t *stat = &g_statInfo[statIndex];
	int statCost = Shared_StatCost(stats, statIndex);
	if (stats[statIndex] >= stat->maxVal)
	{
		return;
	}
	else if (statCost > makoStash)
	{
		return;
	}

	switch (statIndex)
	{
	case 0:
		plData->maxHealth += stat->incr;
		break;
	case 1:
		plData->statStr += stat->incr;
		break;
	case 2:
		plData->statDef += stat->incr;
		break;
	case 3:
		plData->statDex += stat->incr;
		break;
	case 4:
		plData->statLuck += stat->incr;
		break;
	default:
		break;
	}
	makoStash -= statCost;
}
