#ifndef _SHAREDTYPES_H
#define _SHAREDTYPES_H

//DO NOT modify this file (except where otherwise noted). These types
//are all shared with the engine code and if they are modified, then
//obviously the engine will not be aware of the change and it will
//break things.

#define _CRT_SECURE_NO_DEPRECATE
#pragma warning(disable:4996)

//millisecond precision turned out to be insufficient for low timescales and high
//time differentials
//typedef unsigned long serverTime_t;
typedef float serverTime_t;

#define MAX_JOB_THREADS				16
typedef enum
{
	CRITSECT_INTERACTIONMEM = MAX_JOB_THREADS,
	CRITSECT_LIGHTCOUNTS,
	CRITSECT_FILESYS,
	CRITSECT_FRAMEALLOC,
	CRITSECT_MODELALLOC,
	CRITSECT_DOJOB,
	CRITSECT_PCL1,
	CRITSECT_PCL2,
	CRITSECT_SNDDEF,
	CRITSECT_MUSICSTATE,
	CRITSECT_ADDDRAWOBJECT,
	CRITSECT_ADDSCENELIGHT,
	CRITSECT_THREADSTATUS,
	CRITSECT_MEMALLOC,
	CRITSECT_SVMSG,
	CRITSECT_QUEUEMSG,
	CRITSECT_SOCKETS,
	CRITSECT_SOCKETS2,
	CRITSECT_RESV5,
	NUM_CRITICAL_SECTIONS
} critSectionNames_e;
#define MAX_CRITICAL_SECTIONS		8

typedef struct jobHandle_s
{
	int				index;
	int				count;
} jobHandle_t;

typedef struct cntArray_s cntArray_t;
typedef struct cntHash_s cntHash_t;
typedef struct strHash_s strHash_t;
typedef struct cntStream_s cntStream_t;

typedef struct cntHashList_s cntHashList_t;
typedef struct cntHashList_s
{
	unsigned int		index;
	cntHashList_t		*next;
} cntHashList_t;

#define PITCH		0
#define YAW			1
#define ROLL		2

#define MAX_NET_CLIENTS		16
#define CAM_TRACK_NUM		(MAX_NET_CLIENTS+1) //fetus blaster
#define MAP_OBJ_NUM			(CAM_TRACK_NUM+1)

#define MAX_CLIENT_INFO_SIZE	32
#define	MAX_GAME_STRINGS		1024

typedef struct modelMatrix_s
{
	float				x1[3];
	float				x2[3];
	float				x3[3];
	float				o[3];
} modelMatrix_t;

typedef struct fourxMatrix_s
{
	float				c1[4];
	float				c2[4];
	float				c3[4];
	float				c4[4];
} fourxMatrix_t;

typedef struct viewFrustum_s
{
	float			planes[6][4];
	modelMatrix_t	ori;
	BYTE			planeSides[6];
	int				pls;

	float			lenNear;
	float			lenFar;
	float			lenRight;
	float			lenUp;
} viewFrustum_t;

typedef enum
{
	OBJ_TYPE_SPRITE,
	OBJ_TYPE_MAP,
	OBJ_TYPE_MODEL,
	OBJ_TYPE_NETEVENT,
	OBJ_TYPE_CAM,
	OBJ_TYPE_PROJECTILE,
	OBJ_TYPE_GENERAL,
	OBJ_TYPE_LIGHT,
	OBJ_TYPE_VISBLOCK,
	OBJ_TYPE_BEAM,
	OBJ_TYPE_USER, //reserved for custom logic modules
	NUM_OBJ_TYPES
} objTypes_e;

typedef enum
{
	NETEVENT_SOUND,
	NETEVENT_PARTICLES,
	NETEVENT_DECAL,
	NETEVENT_DEBUGBOX,
	NETEVENT_DEBUGLINE,
	NUM_NETEVENT_TYPES
} objNetEvent_e;

typedef enum
{
	CLEV_UPDATEHIGHSCORE,
	CLEV_DISPLAYMUL,
	CLEV_TRIGGERFLASH,
	CLEV_VIEWTRAILS,
	CLEV_BLOOMMOD,
	CLEV_PCLTIME,
	CLEV_PLAYERDATA,
	CLEV_GLOBALDATA,
	CLEV_ITEMPICKUP,
	CLEV_STATMESSAGE,
	CLEV_ERRORMESSAGE,
	CLEV_SETFADE,
	CLEV_SETFADECOLOR,
	CLEV_SETPICFADE,
	CLEV_SETPIC,
	CLEV_SHOWHUD,
	CLEV_RUNMENUSCRIPT,
	CLEV_TALKBUBBLE,
	CLEV_THESHAKES,
	CLEV_THESHAKES2,
	CLEV_ENEMYHEALTH,
	NUM_CL_EVENTS
} clientEventTypes_e;

typedef enum
{
	SVEV_FORGEABILITY,
	SVEV_FORGEITEM,
	SVEV_FORGESTAT,
	SVEV_INVSORT,
	NUM_SV_EVENTS
} serverEventTypes_e;

typedef enum
{
	PLABIL_FLURRY,
	PLABIL_WALLJUMP,
	PLABIL_GETUP,
	PLABIL_FLIPKICK,
	PLABIL_THRUST,
	PLABIL_TACKLE,
	PLABIL_GROUNDCRUSH,
	PLABIL_METEORKICK,
	PLABIL_MAKOFLAME,
	PLABIL_MAKOTIME,
	PLABIL_MAKOHEAL,
	PLABIL_MAKOAURA,
	PLABIL_CHARGEFORCE,
	NUM_PLAYER_ABILITIES
} playerAbilities_e;
typedef struct playerAbility_s
{
	char			*name;
	char			*pic;
	char			*desc;
	int				needsOther;
	int				cost;
} playerAbility_t;
extern const playerAbility_t g_plAbilities[NUM_PLAYER_ABILITIES];

typedef enum
{
	AIDESC_NONE,
	AIDESC_E30BLUE,
	AIDESC_E30PURPLE,
	AIDESC_E30PURPLEWEAK,
	AIDESC_E30RED,
	AIDESC_E30BLACK,
	AIDESC_THEDOLLAR,
	AIDESC_DOG1,
	AIDESC_DOG2,
	AIDESC_DOG3,
	AIDESC_EAT1,
	AIDESC_EAT2,
	AIDESC_BOMB1,
	AIDESC_BOMB2,
	AIDESC_GIG1,
	AIDESC_GIG2,
	AIDESC_GIG3,
	AIDESC_IRON1,
	AIDESC_IRON2,
	AIDESC_TON1,
	AIDESC_TON2,
	AIDESC_HORN1,
	AIDESC_HORN2,
	AIDESC_MAD1,
	AIDESC_MAD2,
	AIDESC_CLOUD,
	AIDESC_BARRETT,
	AIDESC_AERITH,
	AIDESC_JENOVA,
	AIDESC_SEPHFIN,
	AIDESC_CHOCO,
	AIDESC_CCON,
	NUM_AI_DESC
} aiDesc_e;

typedef struct aiDesc_s
{
	char		*name;
} aiDesc_t;
extern const aiDesc_t g_aiDesc[NUM_AI_DESC];

typedef struct statInfo_s
{
	char		*name;
	char		*desc;
	int			incr;
	int			maxVal;
	int			cost;
} statInfo_t ;

typedef enum
{
	INVITEM_NONE,
	INVITEM_POTION,
	INVITEM_HIPOTION,
	INVITEM_XPOTION,
	INVITEM_ETHER,
	INVITEM_ELIXER,
	INVITEM_MMTS,
	INVITEM_PHOENIXDOWN,
	INVITEM_BATTLEKEY,
	INVITEM_WONDROUSMAP,
	INVITEM_TIFERET,
	INVITEM_RINGOFSIGHT,
	INVITEM_SHRAPNEL,
	INVITEM_RIGHTARM,
	INVITEM_VAMPIREFANG,
	INVITEM_HELLFANG,
	INVITEM_LOCOWEED,
	INVITEM_GRAVIBALL,
	INVITEM_EARTHDRUM,
	INVITEM_SPEEDDRINK,
	INVITEM_CHOCONECTAR,
	INVITEM_OMEGA,
	INVITEM_EINSOF,
	INVITEM_TASTYGREENS,
	INVITEM_SPANISHGREENS,
	INVITEM_CLASSYGREENS,
	INVITEM_KINKYGREENS,
	INVITEM_POWERWRIST,
	INVITEM_CHAMPIONBELT,
	INVITEM_PROTECTRING,
	INVITEM_SHIELDRING,
	INVITEM_CHOCOFEATHER,
	INVITEM_AMULET,
	INVITEM_MOOGLECHARM,
	INVITEM_FIREFANG,
	INVITEM_STARDUST,
	INVITEM_HOURGLASS,
	INVITEM_SPRINTSHOES,
	INVITEM_FURYRING,
	INVITEM_CATSBELL,
	INVITEM_FINALHEAVEN,
	INVITEM_GLOCK,
	INVITEM_FLASHLIGHT,
	INVITEM_HATCHET,
	INVITEM_BUSTER,
	INVITEM_BLOODBUSTER,
	INVITEM_PURITY,
	INVITEM_MAKO1,
	INVITEM_MAKO2,
	INVITEM_MASAMUNE,
	INVITEM_USERMOD01,
	INVITEM_USERMOD02,
	INVITEM_USERMOD03,
	INVITEM_USERMOD04,
	INVITEM_USERMOD05,
	INVITEM_USERMOD06,
	INVITEM_USERMOD07,
	INVITEM_USERMOD08,
	INVITEM_USERMOD09,
	INVITEM_USERMOD10,
	INVITEM_USERMOD11,
	INVITEM_USERMOD12,
	INVITEM_USERMOD13,
	INVITEM_USERMOD14,
	INVITEM_USERMOD15,
	INVITEM_USERMOD16,
	INVITEM_USERMOD17,
	INVITEM_USERMOD18,
	INVITEM_USERMOD19,
	INVITEM_USERMOD20,
	NUM_INVENTORY_ITEM_DEFS
} invItemDefs_e;
#define INVITEM_BEHAVIOR_ADDHEALTH			0
#define INVITEM_BEHAVIOR_ADDCHARGE			1
#define INVITEM_BEHAVIOR_PHOENIX			2
#define INVITEM_BEHAVIOR_SPECIAL			3
#define INVITEM_BEHAVIOR_FULLHEALTHCHARGE	4
#define INVITEM_BEHAVIOR_GUN				5
#define INVITEM_BEHAVIOR_NOPAIN				6
#define INVITEM_BEHAVIOR_VIEWHEALTH			7
#define INVITEM_BEHAVIOR_RADIUSDMG			8
#define INVITEM_BEHAVIOR_DRAIN				9
#define INVITEM_BEHAVIOR_VORTEX				10
#define INVITEM_BEHAVIOR_MODSTR				11
#define INVITEM_BEHAVIOR_MODDEF				12
#define INVITEM_BEHAVIOR_MODDEX				13
#define INVITEM_BEHAVIOR_MODLUCK			14
#define INVITEM_BEHAVIOR_MAKOFIRE			15
#define INVITEM_BEHAVIOR_MAKOAURA			16
#define INVITEM_BEHAVIOR_MAKOTIME			17
#define INVITEM_BEHAVIOR_HEALSTEP			18
#define INVITEM_BEHAVIOR_HASTE				19
#define INVITEM_BEHAVIOR_HASTEUSE			20
#define INVITEM_BEHAVIOR_QUAKE				21
#define INVITEM_BEHAVIOR_FINALHEAVEN		22
#define INVITEM_BEHAVIOR_CONFUSE			23
#define INVITEM_BEHAVIOR_SWORD				24
#define INVITEM_BEHAVIOR_FLASHLIGHT			25
#define INVITEM_BEHAVIOR_MMTS				26
#define INVITEM_BEHAVIOR_ADDMAKO			27
#define INVITEM_BEHAVIOR_GREENS				28
typedef struct invItemDef_s
{
	char			name[128];
	char			icon[128];
	char			desc[128];
	char			useFX[128];
	int				itemBehavior;
	int				itemValue;
	int				usable;
	int				cost;
	int				secret;
	int				maxAmount;
} invItemDef_t;
extern invItemDef_t g_invItems[NUM_INVENTORY_ITEM_DEFS];

typedef struct playerInvItem_s
{
	BYTE			itemIndex;
	BYTE			itemQuantity;
} playerInvItem_t;

#define MAX_PLAYER_INVENTORY_ITEMS		256
typedef struct playerData_s
{
	int				maxHealth;
	int				maxMakoCharges;
	BYTE			statStr;
	BYTE			statDef;
	BYTE			statDex;
	BYTE			statLuck;
	unsigned int	abilities;
	playerInvItem_t	inventory[MAX_PLAYER_INVENTORY_ITEMS];
} playerData_t;

typedef struct globalNetData_s
{
	int				skyboxModel;
	int				skyboxTerrain;
	float			skyboxColor[3];
	float			creditRoll;

	char			vsNames[2][16];
	int				vsHealth[2];
	int				vsMaxHealth[2];
} globalNetData_t;

#define OBJPHYS_NOROTATION				(1<<0)
#define OBJPHYS_NOPHYSREACTION			(1<<1)
#define OBJPHYS_NOFRICTION				(1<<2)
#define OBJPHYS_NOGRAVITY				(1<<3)
#define OBJPHYS_NOTRANSLATION			(1<<4)

//collision structure
typedef struct collObj_s
{
	float			endPos[3];
	float			endNormal[3];
	bool			containsSolid;
	int				hitObjectIndex;
	float			distance;
	bool			hit;
	void			*hitTex;
	float			hitTexPos[2];
} collObj_t;

typedef struct collOpt_s
{
	bool			ignoreBoxModels;
	int				ignoreTexNum;
	char			**ignoreTexList;
} collOpt_t;

#define CLIPFL_PROJECTILE	(1<<0)
#define CLIPFL_BOXMOVE		(1<<1)
//collision model format
typedef struct rcColModel_s
{
	void			*intrnModel;
	int				frame;
	int				blendFrame;
	float			lerpAmount;
	float			pos[3];
	float			ang[3];
	float			modelScale[3];
	float			mins[3];
	float			maxs[3];
	float			radius;
	int				gameOwner;
	int				gameIgnore;
	int				solid;
	int				clipFlags;
} rcColModel_t;

typedef struct textParser_s textParser_t;
typedef struct textParser_s
{
	char				*groupName;
	char				*basePtr;
	char				*curPtr;
	int					lineNum;
	textParser_t		*subGroup;
	bool				textOwner;
	const char			*includeKey;
	bool				isInclude;
	bool				unformattedText;
} textParser_t;
#define MAX_TOKEN_SIZE		1024
typedef struct parseToken_s
{
	const char			*groupName;
	char				text[MAX_TOKEN_SIZE];
	int					lineNum;
} parseToken_t;

#define INUSE_ACTIVE	(1<<0)
#define INUSE_NONET		(1<<1)

#define FXFL_SHELLRED		(1<<0)
#define FXFL_HIDDEN			(1<<1)
#define FXFL_ILLUMINATE		(1<<2)
#define FXFL_VIEWFLARE		(1<<3)
#define FXFL_REDFLAME		(1<<4)
#define FXFL_FPSMODE		(1<<5)
#define FXFL_SPECIALBLEND	(1<<6)
#define FXFL_TARGET2		(1<<7)
#define FXFL_SHELL1			(1<<8)
#define FXFL_SHELL2			(1<<9)
#define FXFL_TARGET			(1<<10)
#define FXFL_TRAIL			(1<<11)
#define FXFL_POSTTRAIL		(1<<12)
#define FXFL_BONETRAIL		(1<<13)
#define FXFL_MODELTRAIL		(1<<14)
#define FXFL_MODELTRAIL2	(1<<15)
#define FXFL_DEATH			(1<<16)
#define FXFL_CONTRAST		(1<<17)
#define FXFL_AURA			(1<<18)
#define FXFL_FLAMES			(1<<19)
#define FXFL_CONTRAST2		(1<<20)
#define FXFL_AURA2			(1<<21)
#define FXFL_BONEAURA		(1<<22)
#define FXFL_METEORSTREAM	(1<<23)
#define FXFL_HEALINGAURA	(1<<24)
#define FXFL_BLADETRAIL		(1<<25)
#define FXFL_ITEMSPARKLE	(1<<26)
#define FXFL_BEAMBOX		(1<<27)
#define FXFL_SPECIALBLEND2	(1<<28)
#define FXFL_UNDERLIGHT		(1<<29)
#define FXFL_BOLTED1		(1<<30)
#define FXFL_GUNARM			(1<<31)

#define FXFL2_NOSHADOWS		(1<<0)
#define FXFL2_SPAWN			(1<<1)
#define FXFL2_SPAWN2		(1<<2)
#define FXFL2_GODLIGHT		(1<<3)
#define FXFL2_DRAINAURA		(1<<4)
#define FXFL2_DEATH2		(1<<5)
#define FXFL2_INVINCIBLE	(1<<6)
#define FXFL2_LANTERN		(1<<7)
#define FXFL2_IKBALL		(1<<8)
#define FXFL2_CONFUSE		(1<<9)
#define FXFL2_BLADETRAIL2	(1<<10)
#define FXFL2_FLASHLIGHT	(1<<11)
#define FXFL2_FORCEFIELD	(1<<12)
#define FXFL2_DEATH3		(1<<13)
#define FXFL2_BLADETRAIL3	(1<<14)
#define FXFL2_CHOCOBLUE		(1<<15)
#define FXFL2_CHOCOGREEN	(1<<16)
#define FXFL2_CHOCOPINK		(1<<17)
#define FXFL2_CHOCORED		(1<<18)
#define FXFL2_SKINMAP		(1<<19)
#define FXFL2_SKIPDEPTH		(1<<20)
#define FXFL2_IKHAIR		(1<<21)
#define FXFL2_AURAFIST		(1<<22)
#define FXFL2_DEATH4		(1<<23)
#define FXFL2_PLICON		(1<<24)
#define FXFL2_MUSICAL		(1<<25)

#define LIGHTFL_DOUBLE		(1<<0)
#define LIGHTFL_AMBPROG		(1<<1)
#define LIGHTFL_FULLAMB		(1<<2)
#define LIGHTFL_SPOTLIGHT	(1<<3)
#define LIGHTFL_NOVOL		(1<<4)

#define BONEOFS_PARENTABS		0
#define BONEOFS_ABSOLUTE		1
#define BONEOFS_ADD				2

#define SAVE_GAME_VERSION		6251
typedef struct saveHeader_s
{
	int				version;
	char			map[512];
	char			desc[1024];
	int				timeSec;
	int				dataSize;
} saveHeader_t;

//shared between client and server, one per game object.
//THIS STRUCTURE MUST REMAIN DWORD-ALIGNED. otherwise everything
//will explode. horribly. i suggest not adding anything but
//ints, unless you want to do something like 2 shorts right
//next to each other.
typedef struct gameObjNet_s
{
	int					index;

	int					type;

	float				pos[3];
	float				ang[3];
	float				vel[3];

	float				mins[3];
	float				maxs[3];

	int					renderEffects;
	int					renderEffects2;
	float				effectLen;

	float				modelScale[3];

	float				deformOverride;

	int					solid;
	int					owner;	//quake-style logic, don't collide with
								//my owner or things i own

	int					frame; //for simple server-logic-based animating
	int					lerpDuration;

	int					aiDescIndex;

	//string index for object entry name
	int					entNameIndex;

	//used for sprites or whatever else.
	int					strIndex;
	int					strIndexB;
	int					strIndexC;
	int					strIndexD;
	int					strIndexE;

	//optimizations for static objects and lights
	int					staticIndex;

	//hack, player stuff (can be reused for other things)
	int					lives;
	int					plAmmo;
	int					spare1;

	float				boltOffsets[3];
	float				spareVec1[3];

	//Below here you can add more values if you want them
	//to be sent across the network. Don't modify anything
	//above here, since the above values may be referenced
	//by engine code.
} gameObjNet_t;

typedef struct objArgs_s
{
	char		*key;
	char		*val;
} objArgs_t;

typedef enum
{
	BUTTON_UP,
	BUTTON_DOWN,
	BUTTON_LEFT,
	BUTTON_RIGHT,
	BUTTON_CHARMENU,
	BUTTON_ACTION,
	BUTTON_JUMP,
	BUTTON_EVENT1,
	BUTTON_EVENT2,
	BUTTON_EVENT3,
	BUTTON_EVENT4,
	BUTTON_EVENT5,
	BUTTON_EVENT6,
	BUTTON_EVENT7,
	BUTTON_EVENT8,
	BUTTON_EVENT9,
	MAX_BUTTONS
} buttonEnum_e;

typedef struct
{
	textParser_t			*(*Parse_InitParser)(char *rawText);
	textParser_t			*(*Parse_InitParserFromFile)(const char *filename);
	void					(*Parse_FreeParser)(textParser_t *parser);
	void					(*Parse_EnableInclude)(textParser_t *parser, const char *includeKey);
	bool					(*Parse_GetNextToken)(textParser_t *parser, parseToken_t *parseToken);
} sharedInterface_t;

//shared.cpp functions
extern void Shared_LoadUserItems(sharedInterface_t *si);
extern bool Shared_CanHaveItem(playerData_t *plData, int itemIndex);
extern int Shared_HasItem(playerData_t *plData, int itemIndex);
extern bool Shared_GiveItem(playerData_t *plData, int itemIndex);
extern void Shared_ForgeItem(playerData_t *plData, int itemIndex, int &makoStash);
extern void Shared_ForgeAbility(playerData_t *plData, int ability, int &makoStash);
extern int Shared_StatCost(int *stats, int statIndex);
extern void Shared_ForgeStat(playerData_t *plData, int statIndex, int &makoStash);

#endif //_SHAREDTYPES_H
