#ifndef _CLMAIN_H
#define _CLMAIN_H

#include <windows.h>
#include <stdio.h>
#include <io.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <math.h>
#include <assert.h>
#include "../logicsv_ava/sharedtypes.h"
#include "clshared.h"

extern sharedCLFunctions_t *g_sharedFn;
extern clientObject_t *g_clientObjects;
extern clientString_t *g_clientStrings;
extern unsigned long g_curTime;
extern unsigned long g_prvTime;
extern int g_numActiveGameObj;
extern int g_selfClientNum;
extern float g_musicFrac;
extern bool g_musicalMode;

extern int g_musicClHighScore;
extern int g_musicScoreMul;
extern unsigned long g_musicScoreMulTime;

typedef struct clientResources_s
{
	texContainer_t			whiteTex;
	texContainer_t			trailTex;
	texContainer_t			streamTex;
	texContainer_t			spawnGoo;
	texContainer_t			targTex;
	texContainer_t			targTex2;
	texContainer_t			confuseTex;
	texContainer_t			coreTex;
	texContainer_t			beamCoreTex;
	texContainer_t			specShellTex;
	texContainer_t			specShell2Tex;
	texContainer_t			specShell3Tex;
	texContainer_t			holyJustice;

	texContainer_t			hudKnuckle;
	texContainer_t			hudKnuckleGlow;
	texContainer_t			hudLifePiece;
	texContainer_t			hudLifePieceGlow;
	texContainer_t			hudLifeChunk;
	texContainer_t			hudLifeChunkGlow;
	texContainer_t			hudLifeEnd;
	texContainer_t			hudLifeEndGlow;
	texContainer_t			hudLifeSliver;
	texContainer_t			hudLifeSliver2;
	texContainer_t			hudChargeSphere;
	texContainer_t			hudMako1;
	texContainer_t			hudMako2;
	texContainer_t			hudMakoGlow;
	texContainer_t			hudChargeMeter;
	texContainer_t			hudChargeMeterGlow;
	texContainer_t			hudBar;
	texContainer_t			hudP2Icon;

	texContainer_t			talkBubbleBack;

	texContainer_t			buttonStick;
	texContainer_t			buttonPad;
	texContainer_t			buttonP;
	texContainer_t			buttonK;
	texContainer_t			buttonJ;
	texContainer_t			buttonI;
	texContainer_t			buttonC;
	texContainer_t			buttonT;

	texContainer_t			invItemIcons[NUM_INVENTORY_ITEM_DEFS];
} clientResources_t;
extern clientResources_t g_clRes;

#define	HUD_STATUS_DEFAULT_DURATION		3000
#define MAX_HUD_STATUS_MSG				6
typedef struct hudStatusMsg_s
{
	char			str[256];
	unsigned long	time;

	float			idealX;
	float			idealY;
	float			curX;
	float			curY;
} hudStatusMsg_t;

#define MAX_TALK_BUBBLES				8
typedef struct talkBubble_s
{
	int				objIndex;
	char			talkName[256];
	char			talkText[256];
	unsigned long	time;
	bool			indef;
	float			scale;
	float			distToPlane;
} talkBubble_t;

typedef struct hudState_s
{
	bool			hideHud;

	int				healthRed;
	int				lastMakoStash;
	unsigned long	makoShowTime;
	float			makoStrength;
	float			chargeAlpha;
	int				lastMakoChargeCount;
	float			makoChargeStrength[4];
	int				lastHealth;
	int				lastMaxHealth;
	int				lastMakoChargeCountMax;
	int				lastEquippedItem;

	float			screenFade;
	float			screenFadeColor[3];
	float			screenPicFade;
	texContainer_t	screenPic;

	float			theShakes;
	float			shakeDec;

	const char		*enemyHealthName;
	float			enemyHealthFrac;
	float			enemyHealthFade;
	unsigned long	enemyHealthTime;

	unsigned long	itemNameTime;

	hudStatusMsg_t	statusMessages[MAX_HUD_STATUS_MSG];
	talkBubble_t	talkBubbles[MAX_TALK_BUBBLES];
	char			errorMessage[256];
} hudState_t;
extern hudState_t g_hudState;

typedef struct clientState_s
{
	int				desiredItem;
	int				makoStash;
	unsigned long	makoStashUpdateTime;
	CSafeModelPtr	*skyModel;
	CSafeModelPtr	*skyTerrain;
	playerData_t	plData[MAX_NET_CLIENTS];
	playerData_t	*localPl;
	globalNetData_t	globalNet;
} clientState_t;
extern clientState_t g_clientState;

//for convenience
#define Math_CalcPlaneEq						g_sharedFn->Math_CalcPlaneEq
#define Math_VecNorm2							g_sharedFn->Math_VecNorm2
#define Math_VecNorm							g_sharedFn->Math_VecNorm
#define Math_PlaneNorm							g_sharedFn->Math_PlaneNorm
#define Math_VecLen								g_sharedFn->Math_VecLen
#define Math_PlaneDist							g_sharedFn->Math_PlaneDist
#define Math_ProjectOntoPlane					g_sharedFn->Math_ProjectOntoPlane
#define Math_VecCopy							g_sharedFn->Math_VecCopy
#define Math_VecSub								g_sharedFn->Math_VecSub
#define Math_VecAdd								g_sharedFn->Math_VecAdd
#define Math_VecScale							g_sharedFn->Math_VecScale
#define Math_Max2								g_sharedFn->Math_Max2
#define Math_Max3								g_sharedFn->Math_Max3
#define Math_TransformPointByMatrix				g_sharedFn->Math_TransformPointByMatrix
#define Math_TransformPointByMatrix3x3			g_sharedFn->Math_TransformPointByMatrix3x3
#define Math_TransformPoint						g_sharedFn->Math_TransformPoint
#define Math_VecMA								g_sharedFn->Math_VecMA
#define Math_VecToAngles						g_sharedFn->Math_VecToAngles
#define Math_TransformPoint2					g_sharedFn->Math_TransformPoint2
#define Math_MatrixInverse						g_sharedFn->Math_MatrixInverse
#define Math_MatrixMultiply						g_sharedFn->Math_MatrixMultiply
#define Math_MatrixMultiply3x3					g_sharedFn->Math_MatrixMultiply3x3
#define Math_MatrixMultiply4x4					g_sharedFn->Math_MatrixMultiply4x4
#define Math_RotateMatrix						g_sharedFn->Math_RotateMatrix
#define Math_AnglesToMat						g_sharedFn->Math_AnglesToMat
#define Math_CrossProduct						g_sharedFn->Math_CrossProduct
#define Math_DotProduct							g_sharedFn->Math_DotProduct
#define Math_AngleMod							g_sharedFn->Math_AngleMod
#define Math_InterpolateVector					g_sharedFn->Math_InterpolateVector
#define Math_BlendAngle							g_sharedFn->Math_BlendAngle
#define Math_BlendAngleLinear					g_sharedFn->Math_BlendAngleLinear
#define Math_AngleVectors						g_sharedFn->Math_AngleVectors
#define Math_AxisForNormal						g_sharedFn->Math_AxisForNormal
#define Math_CreateMatrixFromOrientation		g_sharedFn->Math_CreateMatrixFromOrientation
#define Math_RotationMatrix						g_sharedFn->Math_RotationMatrix
#define Math_BoxesOverlap						g_sharedFn->Math_BoxesOverlap
#define Math_ExpandBounds						g_sharedFn->Math_ExpandBounds
#define Math_CreateFrustum						g_sharedFn->Math_CreateFrustum
#define Math_CreateFrustumForViewAxis			g_sharedFn->Math_CreateFrustumForViewAxis
#define Math_GetFrustumPoints					g_sharedFn->Math_GetFrustumPoints
#define Math_BoundsFromPoints					g_sharedFn->Math_BoundsFromPoints
#define Math_PointRelativeToPlane				g_sharedFn->Math_PointRelativeToPlane
#define Math_GetBoundsPoints					g_sharedFn->Math_GetBoundsPoints
#define Math_PointInFrustum						g_sharedFn->Math_PointInFrustum
#define Math_BoxInFrustum						g_sharedFn->Math_BoxInFrustum
#define Math_MatToAngles						g_sharedFn->Math_MatToAngles
#define Math_MatToAngles2						g_sharedFn->Math_MatToAngles2

//cldraw.cpp
extern void LCl_UpdateEnemyHealth(int health, int maxHealth, const aiDesc_t *aiDesc);
extern void LCl_AddTalkBubble(int objIndex, char *talkName, char *talkText, unsigned long duration);
extern void LCl_AddStatusMessage(const char *msg, unsigned long duration = HUD_STATUS_DEFAULT_DURATION);
extern void LCl_DrawHudMakoStash(int makoStash);
extern void LCl_DrawHudElements(viewFrustum_t *viewFrust);

//clevents.cpp
extern void LCl_NetEvent(clientEventTypes_e e, BYTE *data, int dataSize);
extern void LCl_FreshClientObject(clientObject_t *obj);

//clmenus.cpp
extern void LCl_UpdateStatMenu(void);
extern void LCl_UserMenu(const char *callName, mscriptNode_t *node, menuScript_t *mscript);
extern bool LCl_UserSort(const char *sortName, menu_t *menu);

#endif //_CLMAIN_H
