/*
=============================================================================
Module Information
------------------
Name:			clmain.cpp
Author:			Rich Whitehouse
Description:	core client logic module implementation.
=============================================================================
*/

#include "clmain.h"

sharedCLFunctions_t *g_sharedFn;
clientObject_t *g_clientObjects;
clientString_t *g_clientStrings;
unsigned long g_curTime = 0;
unsigned long g_prvTime = 0;
int g_numActiveGameObj = 0;
int g_selfClientNum = 0;
float g_musicFrac = 0.0f;
bool g_musicalMode = false;
float *g_viewPos;
float *g_viewAng;
clientResources_t g_clRes;

clientState_t g_clientState;

const float g_angleBlendRate = 0.3f;//0.1f;
const float g_transBlendRate = 0.3f;

int g_musicClHighScore = 0;
int g_musicScoreMul = 0;
unsigned long g_musicScoreMulTime = 0;

//return api version
int LCl_GetAPIVersion(void)
{
	return CL_LOGIC_API_VERSION;
}

//set the render view
void LCl_SetViewPos(void)
{
	g_viewAng[YAW] = 90.0f;
	g_viewAng[PITCH] = 0.0f;
	g_viewAng[ROLL] = 0.0f;
	//Math_VecCopy(g_clientObjects[g_selfClientNum].projPos, g_viewPos);
	g_viewPos[0] = 0.0f;
	g_viewPos[1] = 0.0f;
	g_viewPos[2] = 0.0f;

	if (g_clientObjects[CAM_TRACK_NUM].active)
	{
		g_viewPos[0] = g_clientObjects[CAM_TRACK_NUM].projPos[0];
		g_viewPos[1] = g_clientObjects[CAM_TRACK_NUM].projPos[1];
		g_viewPos[2] = g_clientObjects[CAM_TRACK_NUM].projPos[2];
		g_viewAng[PITCH] += g_clientObjects[CAM_TRACK_NUM].projAng[PITCH];
		g_viewAng[YAW] += g_clientObjects[CAM_TRACK_NUM].projAng[YAW];
		g_viewAng[ROLL] += g_clientObjects[CAM_TRACK_NUM].projAng[ROLL];
	}

	if (g_hudState.theShakes > 0.0f)
	{
		float r = (float)(rand()%16384)/16384.0f;
		g_viewAng[PITCH] += (-g_hudState.theShakes + g_hudState.theShakes*2.0f*r);
		r = (float)(rand()%16384)/16384.0f;
		g_viewAng[YAW] += (-g_hudState.theShakes + g_hudState.theShakes*2.0f*r);
		if (g_hudState.shakeDec)
		{
			float timeDif = ((float)g_curTime-(float)g_prvTime)/50.0f;
			g_hudState.theShakes -= g_hudState.shakeDec*timeDif;
			if (g_hudState.theShakes < 0.0f)
			{
				g_hudState.theShakes = 0.0f;
			}
		}
	}

	int x = 0;
	while (x < 3)
	{
		while (g_viewAng[x] < 0.0f)
		{
			g_viewAng[x] += 360.0f;
		}
		while (g_viewAng[x] > 360.0f)
		{
			g_viewAng[x] -= 360.0f;
		}
		x++;
	}
}

//decide position
void LCl_InterpolateObjectPos(clientObject_t *obj, bool clientInterpolate)
{
	if (clientInterpolate)
	{
		if (obj->net.index == CAM_TRACK_NUM)
		{
			Math_InterpolateVector(obj->projPos, obj->net.pos, g_transBlendRate*1.25f, 8192.0f, obj->obj.pos);
		}
		else
		{
			Math_InterpolateVector(obj->projPos, obj->net.pos, g_transBlendRate, 2048.0f, obj->obj.pos);
		}
	}
	else
	{
		Math_VecCopy(obj->net.pos, obj->obj.pos);
	}

	if (obj->net.type == OBJ_TYPE_PROJECTILE)
	{
		Math_VecCopy(obj->net.ang, obj->obj.ang);
	}
	else
	{
		if (clientInterpolate)
		{
			int i = 0;
			while (i < 3)
			{
				float ang = (360.0f / 65536) * ((int)(obj->net.ang[i] * (65536 / 360.0f)) & 65535);
				obj->obj.ang[i] = Math_BlendAngle(obj->projAng[i], ang, g_angleBlendRate);
				i++;
			}
		}
		else
		{
			Math_VecCopy(obj->net.ang, obj->obj.ang);
		}
	}

	Math_VecCopy(obj->obj.pos, obj->projPos);
	Math_VecCopy(obj->obj.ang, obj->projAng);
}

//cycle inventory
void LCl_InventoryCycle(int dir)
{
	if (g_clientState.desiredItem <= -1)
	{
		return;
	}
	for (int i = g_clientState.desiredItem+dir; 1; i += dir)
	{
		if (i >= MAX_PLAYER_INVENTORY_ITEMS)
		{
			i = 0;
		}
		else if (i < 0)
		{
			i = MAX_PLAYER_INVENTORY_ITEMS-1;
		}

		if (g_clientState.localPl->inventory[i].itemQuantity > 0)
		{
			g_clientState.desiredItem = i;
			break;
		}
	}
}

//frame
void LCl_Frame(unsigned long time, int numObj, int localCl, bool clientInterpolate,
			   bool isMulti, float musicFrac, float *viewPos, float *viewAng)
{
	g_prvTime = g_curTime;
	g_curTime = time;
	if (!g_prvTime)
	{
		g_prvTime = time;
	}
	g_viewPos = viewPos;
	g_viewAng = viewAng;
	g_numActiveGameObj = numObj;
	g_selfClientNum = localCl;
	g_clientState.localPl = (localCl >= 0) ? &g_clientState.plData[localCl] : NULL;
	g_musicFrac = musicFrac;

	if (g_clientState.desiredItem == -1)
	{ //set initial desired item to the server's state
		clientObject_t *pl = (g_numActiveGameObj > g_selfClientNum && g_clientObjects[g_selfClientNum].active) ? &g_clientObjects[g_selfClientNum] : NULL;
		if (pl && pl->net.spare1 != 255)
		{
			g_clientState.desiredItem = (pl->net.spare1&((1<<8)-1));
		}
	}
	else
	{
		if (g_clientState.localPl->inventory[g_clientState.desiredItem].itemQuantity <= 0)
		{ //ran out of the equipped item
			g_clientState.desiredItem = 0;
		}
		else
		{
			static WORD lastAnalogs[5] = {32767, 32767, 32767, 32767, 32767};
			WORD analogs[5];
			g_sharedFn->DInput_GetAnalogs(analogs);
			if (lastAnalogs[4] > 20000 && lastAnalogs[4] < 44000 &&
				!(analogs[4] > 20000 && analogs[4] < 44000) &&
				!g_hudState.hideHud)
			{ //pressing analog trigger
				int curItem = g_clientState.desiredItem;
				if (analogs[4] > 32767)
				{
					LCl_InventoryCycle(-1);
				}
				else
				{
					LCl_InventoryCycle(1);
				}

				if (curItem != g_clientState.desiredItem)
				{
					g_sharedFn->S_PlayWave(g_sharedFn->S_CacheSound("assets/sound/items/invcycle.wav"), NULL, 1.0f, false, -1, -1);
					g_hudState.itemNameTime = g_curTime+2000;
				}
			}
			lastAnalogs[0] = analogs[0];
			lastAnalogs[1] = analogs[1];
			lastAnalogs[2] = analogs[2];
			lastAnalogs[3] = analogs[3];
			lastAnalogs[4] = analogs[4];
		}
	}

	g_sharedFn->Net_SetClientUserData((BYTE *)&g_clientState.desiredItem, sizeof(int));

	clientObject_t *cam = (g_numActiveGameObj > CAM_TRACK_NUM && g_clientObjects[CAM_TRACK_NUM].active) ? &g_clientObjects[CAM_TRACK_NUM] : NULL;

	if (cam && (cam->net.renderEffects2 & FXFL2_MUSICAL))
	{ //musical!
		g_musicalMode = true;
	}
	else
	{
		g_musicalMode = false;
	}

	int i = 0;
	while (i < g_numActiveGameObj)
	{
		if (g_clientObjects[i].active)
		{
			LCl_InterpolateObjectPos(&g_clientObjects[i], clientInterpolate);
		}
		i++;
	}

	LCl_SetViewPos();

	g_sharedFn->Cl_AddAllObjects();

	if (g_clientState.globalNet.skyboxModel > 0)
	{ //add a sky model
		char *skyModel = g_clientStrings[g_clientState.globalNet.skyboxModel].p;
		if (skyModel[0] == '&')
		{
			skyModel++;
			if (!g_clientState.skyModel || stricmp(skyModel, g_sharedFn->Model_GetName(g_clientState.skyModel)))
			{
				if (g_clientState.skyModel)
				{
					g_sharedFn->Model_Free(g_clientState.skyModel);
				}
				g_clientState.skyModel = g_sharedFn->Model_Allocate(skyModel);
			}

			char *skyTerrain = g_clientStrings[g_clientState.globalNet.skyboxTerrain].p;
			if (skyTerrain[0] == '&')
			{
				skyTerrain++;
				if (!g_clientState.skyTerrain || stricmp(skyTerrain, g_sharedFn->Model_GetName(g_clientState.skyTerrain)))
				{
					if (g_clientState.skyTerrain)
					{
						g_sharedFn->Model_Free(g_clientState.skyTerrain);
					}
					g_clientState.skyTerrain = g_sharedFn->Model_Allocate(skyTerrain);
				}
			}
			if (g_clientState.globalNet.skyboxTerrain && g_clientState.skyTerrain)
			{
				drawObject_t dobj;
				memset(&dobj, 0, sizeof(dobj));
				dobj.ang[0] = 0.0f;
				dobj.ang[1] = 180.0f;
				dobj.ang[2] = 0.0f;
				dobj.modelScale[0] = 2.5f;
				dobj.modelScale[1] = 2.5f;
				dobj.modelScale[2] = 2.5f;
				dobj.pos[0] = (g_viewPos[0]-2000.0f) - g_viewPos[0]*0.1f;
				dobj.pos[1] = (g_viewPos[1]-4000.0f) - g_viewPos[1]*0.1f;
				dobj.pos[2] = (g_viewPos[2]-400.0f) - g_viewPos[2]*0.1f;
				dobj.model = g_clientState.skyTerrain;

				g_sharedFn->GL_AddSkyObject(&dobj);
			}
			drawObject_t dobj;
			memset(&dobj, 0, sizeof(dobj));
			dobj.ang[0] = 0.0f;
			dobj.ang[1] = 0.0f;
			dobj.ang[2] = 0.0f;
			if (g_clientState.globalNet.skyboxTerrain)
			{
				dobj.modelScale[0] = 1.5f;
				dobj.modelScale[1] = 1.5f;
				dobj.modelScale[2] = 1.5f;
				dobj.pos[0] = g_viewPos[0] - g_viewPos[0]*0.05f;
				dobj.pos[1] = g_viewPos[1] - g_viewPos[1]*0.05f;
				dobj.pos[2] = g_viewPos[2] - g_viewPos[2]*0.05f;
			}
			else
			{
				dobj.pos[0] = g_viewPos[0] - g_viewPos[0]*0.1f;
				dobj.pos[1] = g_viewPos[1] - g_viewPos[1]*0.1f;
				dobj.pos[2] = g_viewPos[2] - g_viewPos[2]*0.1f;
			}
			dobj.model = g_clientState.skyModel;

			if (g_clientState.globalNet.skyboxColor[0] ||
				g_clientState.globalNet.skyboxColor[1] ||
				g_clientState.globalNet.skyboxColor[2])
			{
				dobj.blendSrc = 2;
				dobj.blendDst = 2;
				dobj.blendRGBA[0] = g_clientState.globalNet.skyboxColor[0];
				dobj.blendRGBA[1] = g_clientState.globalNet.skyboxColor[1];
				dobj.blendRGBA[2] = g_clientState.globalNet.skyboxColor[2];
				dobj.blendRGBA[3] = 1.0f;
			}

			g_sharedFn->GL_AddSkyObject(&dobj);
		}
	}
}

//draw hud and other game-specific elements
void LCl_Draw2D(viewFrustum_t *viewFrust)
{
	LCl_DrawHudElements(viewFrust);
}

//draw post-menu
void LCl_DrawPostMenu(viewFrustum_t *viewFrust)
{
	clientObject_t *obj = &g_clientObjects[0]; //g_selfClientNum
	if (obj->active && g_sharedFn->Menu_AnyActiveMenus())
	{
		g_hudState.lastMakoStash = g_clientState.makoStash;
		g_hudState.makoShowTime = g_curTime + 1000;
		g_hudState.makoStrength = 0.25f;
		LCl_DrawHudMakoStash(g_clientState.makoStash);
	}
}

//load resources
void LCl_CacheResources(void)
{
	g_sharedFn->Img_TextureLoad("assets/textures/test_white", &g_clRes.whiteTex);
	g_sharedFn->Img_TextureLoad("assets/textures/trail01", &g_clRes.trailTex);
	g_sharedFn->Img_TextureLoad("assets/textures/lstream", &g_clRes.streamTex);
	g_sharedFn->Img_TextureLoad("assets/textures/goop", &g_clRes.spawnGoo);
	g_sharedFn->Img_TextureLoad("assets/textures/targptr", &g_clRes.targTex);
	g_sharedFn->Img_TextureLoad("assets/textures/targptr2", &g_clRes.targTex2);
	g_sharedFn->Img_TextureLoad("assets/textures/confuse", &g_clRes.confuseTex);
	g_sharedFn->Img_TextureLoad("assets/textures/brightcoreglow", &g_clRes.coreTex);
	g_sharedFn->Img_TextureLoad("assets/textures/beamcore", &g_clRes.beamCoreTex);
	g_sharedFn->Img_TextureLoad("assets/textures/specshell", &g_clRes.specShellTex);
	g_sharedFn->Img_TextureLoad("assets/textures/specshell2", &g_clRes.specShell2Tex);
	g_sharedFn->Img_TextureLoad("assets/textures/specshell3", &g_clRes.specShell3Tex);
	g_sharedFn->Img_TextureLoad("assets/textures/holyjustice", &g_clRes.holyJustice);

	g_sharedFn->Img_TextureLoad("assets/textures/hud/knucklepiece", &g_clRes.hudKnuckle);
	g_sharedFn->Img_TextureLoad("assets/textures/hud/knucklepieceglow", &g_clRes.hudKnuckleGlow);
	g_sharedFn->Img_TextureLoad("assets/textures/hud/lifepiece", &g_clRes.hudLifePiece);
	g_sharedFn->Img_TextureLoad("assets/textures/hud/lifepieceglow", &g_clRes.hudLifePieceGlow);
	g_sharedFn->Img_TextureLoad("assets/textures/hud/lifechunk", &g_clRes.hudLifeChunk);
	g_sharedFn->Img_TextureLoad("assets/textures/hud/lifechunkglow", &g_clRes.hudLifeChunkGlow);
	g_sharedFn->Img_TextureLoad("assets/textures/hud/lifeend", &g_clRes.hudLifeEnd);
	g_sharedFn->Img_TextureLoad("assets/textures/hud/lifeendglow", &g_clRes.hudLifeEndGlow);
	g_sharedFn->Img_TextureLoad("assets/textures/hud/lifesliver", &g_clRes.hudLifeSliver);
	g_sharedFn->Img_TextureLoad("assets/textures/hud/lifesliver2", &g_clRes.hudLifeSliver2);
	g_sharedFn->Img_TextureLoad("assets/textures/hud/chargesphere", &g_clRes.hudChargeSphere);
	g_sharedFn->Img_TextureLoad("assets/textures/hud/mako1", &g_clRes.hudMako1);
	g_sharedFn->Img_TextureLoad("assets/textures/hud/mako2", &g_clRes.hudMako2);
	g_sharedFn->Img_TextureLoad("assets/textures/hud/makoglow", &g_clRes.hudMakoGlow);
	g_sharedFn->Img_TextureLoad("assets/textures/hud/chargemeter", &g_clRes.hudChargeMeter);
	g_sharedFn->Img_TextureLoad("assets/textures/hud/chargemeterglow", &g_clRes.hudChargeMeterGlow);
	g_sharedFn->Img_TextureLoad("assets/textures/hud/bar", &g_clRes.hudBar);
	g_sharedFn->Img_TextureLoad("assets/textures/hud/p2ico", &g_clRes.hudP2Icon);
	g_sharedFn->Img_TextureLoad("assets/menus/textures/menubg1", &g_clRes.talkBubbleBack);

	g_sharedFn->Img_TextureLoad("button_stick", &g_clRes.buttonStick);
	g_sharedFn->Img_TextureLoad("button_pad", &g_clRes.buttonPad);
	g_sharedFn->Img_TextureLoad("button_p", &g_clRes.buttonP);
	g_sharedFn->Img_TextureLoad("button_k", &g_clRes.buttonK);
	g_sharedFn->Img_TextureLoad("button_j", &g_clRes.buttonJ);
	g_sharedFn->Img_TextureLoad("button_i", &g_clRes.buttonI);
	g_sharedFn->Img_TextureLoad("button_c", &g_clRes.buttonC);
	g_sharedFn->Img_TextureLoad("button_t", &g_clRes.buttonT);

	for (int i = 0; i < NUM_INVENTORY_ITEM_DEFS; i++)
	{
		const invItemDef_t *item = &g_invItems[i];
		if (item->icon && item->icon[0])
		{
			g_sharedFn->Img_TextureLoad(item->icon, &g_clRes.invItemIcons[i]);
		}
	}

	g_sharedFn->ClPcl_CacheParticleSystemAssets("general/makodeath", NULL);
	g_sharedFn->ClPcl_CacheParticleSystemAssets("general/energydeath", NULL);
	g_sharedFn->ClPcl_CacheParticleSystemAssets("general/makopower", NULL);
	g_sharedFn->ClPcl_CacheParticleSystemAssets("general/flameaura", NULL);
	g_sharedFn->ClPcl_CacheParticleSystemAssets("general/boneaura", NULL);
	g_sharedFn->ClPcl_CacheParticleSystemAssets("general/healingaura", NULL);
	g_sharedFn->ClPcl_CacheParticleSystemAssets("general/invinaura", NULL);
	g_sharedFn->ClPcl_CacheParticleSystemAssets("general/drainaura", NULL);
	g_sharedFn->ClPcl_CacheParticleSystemAssets("general/itemsparkle", NULL);
	g_sharedFn->ClPcl_CacheParticleSystemAssets("general/phoenix", NULL);
	g_sharedFn->ClPcl_CacheParticleSystemAssets("general/aurafist", NULL);

	g_sharedFn->S_CacheSound("assets/sound/menu/menuerr.wav");
	g_sharedFn->S_CacheSound("assets/sound/items/invcycle.wav");
}

//can i pause?
bool LCl_CanPause(void)
{
	if (g_hudState.hideHud)
	{
		return false;
	}
	return true;
}

//module init
int LCl_Initialize(sharedCLFunctions_t *sharedFunc, clientObject_t *clientObjects, clientString_t *clientStrings)
{
	g_sharedFn = sharedFunc;
	g_clientObjects = clientObjects;
	g_clientStrings = clientStrings;

	g_sharedFn->LCl_Frame = LCl_Frame;
	g_sharedFn->LCl_Draw2D = LCl_Draw2D;
	g_sharedFn->LCl_DrawPostMenu = LCl_DrawPostMenu;
	g_sharedFn->LCl_CanPause = LCl_CanPause;
	g_sharedFn->LCl_CacheResources = LCl_CacheResources;
	g_sharedFn->LCl_NetEvent = LCl_NetEvent;
	g_sharedFn->LCl_FreshClientObject = LCl_FreshClientObject;
	g_sharedFn->LCl_UserMenu = LCl_UserMenu;
	g_sharedFn->LCl_UserSort = LCl_UserSort;

	sharedInterface_t si;
	si.Parse_InitParser = g_sharedFn->Parse_InitParser;
	si.Parse_InitParserFromFile = g_sharedFn->Parse_InitParserFromFile;
	si.Parse_FreeParser = g_sharedFn->Parse_FreeParser;
	si.Parse_EnableInclude = g_sharedFn->Parse_EnableInclude;
	si.Parse_GetNextToken = g_sharedFn->Parse_GetNextToken;
	Shared_LoadUserItems(&si);

	memset(&g_clientState, 0, sizeof(g_clientState));
	memset(&g_hudState, 0, sizeof(g_hudState));
	g_clientState.localPl = &g_clientState.plData[0];
	g_clientState.desiredItem = -1;
	return 1;
}

//module shutdown
void LCl_Shutdown(void)
{
}
