/*
=============================================================================
Module Information
------------------
Name:			clevents.cpp
Author:			Rich Whitehouse
Description:	client object event routines
=============================================================================
*/

#include "clmain.h"

//incoming network event
void LCl_NetEvent(clientEventTypes_e e, BYTE *data, int dataSize)
{
	switch (e)
	{
	case CLEV_UPDATEHIGHSCORE:
		if (dataSize >= sizeof(int))
		{
			g_musicClHighScore = *((int *)data);			
		}
		break;
	case CLEV_DISPLAYMUL:
		if (dataSize >= sizeof(int))
		{
			g_musicScoreMul = *((int *)data);
			g_musicScoreMulTime = g_curTime + 1500;
			float clr[3] = {1.0f, 1.0f, 1.0f};
			g_sharedFn->GL_SetFlash(300, g_curTime+300, clr);
		}
		break;
	case CLEV_TRIGGERFLASH:
		if (dataSize >= sizeof(int)+sizeof(float)*3)
		{
			int flash = *((int *)data);
			float *clr = (float *)(((int *)data)+1);
			g_sharedFn->GL_SetFlash(flash, g_curTime+flash, clr);
		}
		break;
	case CLEV_VIEWTRAILS:
		if (dataSize >= sizeof(float)*2)
		{
			float amount = *((float *)data);
			float decay = *(((float *)data)+1);
			g_sharedFn->GL_SetViewTrails(amount, decay);
		}
		break;
	case CLEV_BLOOMMOD:
		if (dataSize == sizeof(float))
		{
			float amount = *((float *)data);
			g_sharedFn->GL_SetBloomMod(amount);
		}
		break;
	case CLEV_PCLTIME:
		if (dataSize == sizeof(float))
		{
			float timescale = *((float *)data);
			g_sharedFn->ClPcl_SetParticleTimeScale(timescale);
		}
		break;
	case CLEV_PLAYERDATA:
		if (dataSize > sizeof(int))
		{
			WORD clientIndex = *((WORD *)data);
			WORD deltaSize = *(((WORD *)data)+1);
			if (dataSize >= deltaSize+4)
			{
				g_sharedFn->Net_ParseDelta(&g_clientState.plData[clientIndex], sizeof(g_clientState.plData[clientIndex]), data+4);
			}
		}
		break;
	case CLEV_GLOBALDATA:
		if (dataSize > sizeof(WORD))
		{
			WORD deltaSize = *((WORD *)data);
			if (dataSize >= deltaSize+2)
			{
				g_sharedFn->Net_ParseDelta(&g_clientState.globalNet, sizeof(g_clientState.globalNet), data+2);
			}
		}
		break;
	case CLEV_ITEMPICKUP:
		if (dataSize == sizeof(int))
		{
			int itemIndex = *((int *)data);
			if (itemIndex >= 0 && itemIndex < NUM_INVENTORY_ITEM_DEFS)
			{
				const invItemDef_t *item = &g_invItems[itemIndex];
				char str[256];
				sprintf(str, "*$%s$%s", item->icon, item->name);
				LCl_AddStatusMessage(str);
			}
		}
		break;
	case CLEV_STATMESSAGE:
		if (dataSize < 128)
		{
			char str[256];
			memcpy(str, data, dataSize);
			str[dataSize] = 0;
			LCl_AddStatusMessage(str);
		}
		break;
	case CLEV_ERRORMESSAGE:
		if (dataSize < 128)
		{
			strcpy(g_hudState.errorMessage, "*(1.0 0.0 0.0 1.0)");
			int l = (int)strlen(g_hudState.errorMessage);
			memcpy(g_hudState.errorMessage+l, data, dataSize);
			g_hudState.errorMessage[l+dataSize] = 0;
		}
		break;
	case CLEV_SETFADE:
		if (dataSize == sizeof(float))
		{
			g_sharedFn->GL_SetFadein(0);
			g_hudState.screenFade = *((float *)data);
		}
		break;
	case CLEV_SETFADECOLOR:
		if (dataSize == sizeof(float)*3)
		{
			memcpy(g_hudState.screenFadeColor, data, sizeof(float)*3);
		}
		break;
	case CLEV_SETPICFADE:
		if (dataSize == sizeof(float))
		{
			g_hudState.screenPicFade = *((float *)data);
		}
		break;
	case CLEV_SETPIC:
		if (dataSize < 128)
		{
			char str[256];
			memcpy(str, data, dataSize);
			str[dataSize] = 0;

			g_sharedFn->Img_TextureLoad(str, &g_hudState.screenPic);
		}
		break;
	case CLEV_SHOWHUD:
		if (dataSize == sizeof(int))
		{
			g_hudState.hideHud = !(*((int *)data));
		}
		break;
	case CLEV_RUNMENUSCRIPT:
		if (dataSize < 128)
		{
			if (!g_sharedFn->Menu_AnyActiveMenus())
			{
				char str[256];
				memcpy(str, data, dataSize);
				str[dataSize] = 0;

				g_sharedFn->Menu_StartScript(str);
			}
		}
		break;
	case CLEV_TALKBUBBLE:
		if (dataSize < 256 && dataSize >= sizeof(int)*2)
		{
			int objIndex = *((int *)data);
			if (objIndex >= 0 && objIndex < g_numActiveGameObj)
			{
				int duration = *(((int *)data)+1);
				char *src = (char *)(data+sizeof(int)*2);
				char talkName[256];
				char talkText[256];
				int i, j;
				for (i = 0, j = 0; src[i] && i < dataSize; i++, j++)
				{
					talkName[j] = src[i];
				}
				talkName[j] = 0;
				i++;
				for (j = 0; src[i] && i < dataSize; i++, j++)
				{
					talkText[j] = src[i];
				}
				talkText[j] = 0;
				LCl_AddTalkBubble(objIndex, talkName, talkText, duration);
			}
		}
		break;
	case CLEV_THESHAKES:
		if (dataSize == sizeof(float))
		{
			g_hudState.theShakes = *((float *)data);
			g_hudState.shakeDec = 0.0f;
		}
		break;
	case CLEV_THESHAKES2:
		if (dataSize == sizeof(float)*2)
		{
			g_hudState.theShakes = *((float *)data);
			g_hudState.shakeDec = *(((float *)data)+1);
		}
		break;
	case CLEV_ENEMYHEALTH:
		if (dataSize == sizeof(int)*3)
		{
			int *val = (int *)data;
			if (val[2] >= 0 && val[2] < NUM_AI_DESC)
			{
				LCl_UpdateEnemyHealth(val[0], val[1], &g_aiDesc[val[2]]);
			}
		}
		break;
	default:
		break;
	}
}

//just receieved this in the object list.
void LCl_FreshClientObject(clientObject_t *obj)
{
	Math_VecCopy(obj->net.pos, obj->projPos);
	Math_VecCopy(obj->net.ang, obj->projAng);
	Math_VecCopy(obj->net.modelScale, obj->projScale);

	if (obj->net.entNameIndex >= 0 && g_clientStrings[obj->net.entNameIndex].p)
	{
        obj->objectData = g_sharedFn->RCO_GetEntryForObject(g_clientStrings[obj->net.entNameIndex].p);
	}
	else
	{
		obj->objectData = NULL;
	}

	switch (obj->net.type)
	{
	case OBJ_TYPE_NETEVENT:
		if (obj->net.frame == NETEVENT_SOUND)
		{
			if (g_clientStrings[obj->net.strIndex].p[0] == '$')
			{
				//g_clientStrings[obj->net.strIndex].p+1;
				waveFile_t *w = g_sharedFn->S_CacheSound(g_clientStrings[obj->net.strIndex].p+1);
				if (w)
				{
					g_sharedFn->S_PlayWave(w, obj->net.pos, obj->net.modelScale[0], !!obj->net.owner, obj->net.solid, -1);
				}
			}
		}
		else if (obj->net.frame == NETEVENT_PARTICLES)
		{
			if (g_clientStrings[obj->net.strIndex].p[0] == '&' && g_clientStrings[obj->net.strIndex].p[1] == '&')
			{
				g_sharedFn->ClPcl_CreateParticles(g_clientStrings[obj->net.strIndex].p+2, obj->net.pos, obj->net.ang, obj->net.owner, -1);
			}
		}
		else if (obj->net.frame == NETEVENT_DECAL)
		{
			if (g_clientObjects && obj->net.solid >= 0 && obj->net.solid < g_numActiveGameObj &&
				g_clientStrings[obj->net.strIndex].p[0] == '^')
			{
				clientObject_t *clObj = &g_clientObjects[obj->net.solid];
				if (clObj->active && clObj->obj.model)
				{
					texContainer_t decal;
					if (g_sharedFn->Img_TextureLoad(g_clientStrings[obj->net.strIndex].p+1, &decal))
					{
						g_sharedFn->Model_ProjectDecal(&clObj->obj, obj->net.pos, obj->net.ang, obj->net.modelScale[0], &decal, (int)obj->net.modelScale[1], (int)obj->net.modelScale[2]);
					}
				}
			}
		}
		else if (obj->net.frame == NETEVENT_DEBUGBOX)
		{
#ifdef _DEBUG
			static float verts[4096];
			static float colors[4096];
			static int tempMemPt = 0;
			genericDraw_t g;
			memset(&g, 0, sizeof(g));
			float *v = &verts[tempMemPt];
			float *c = &colors[tempMemPt];
			tempMemPt += 32;
			if (tempMemPt >= 4096)
			{
				tempMemPt = 0;
			}
			c[0] = obj->net.ang[0];
			c[1] = obj->net.ang[1];
			c[2] = obj->net.ang[2];
			c[3] = 1.0f;
			Math_VecCopy(obj->net.mins, v);
			//Math_VecAdd(v, obj->net.pos, v);
			Math_VecCopy(obj->net.maxs, &v[3]);
			//Math_VecAdd(&v[3], obj->net.pos, &v[3]);
			g.verts = v;
			g.numVerts = 2;
			g.colors = c;
			g.primType = -1;
			g_sharedFn->GL_AddGenericObject(&g);
#endif
		}
		else if (obj->net.frame == NETEVENT_DEBUGLINE)
		{
			genericDraw_t g;
			float *v = (float *)g_sharedFn->Common_RCMalloc(sizeof(float)*6);
			float *c = (float *)g_sharedFn->Common_RCMalloc(sizeof(float)*6);
			memset(&g, 0, sizeof(g));
			g.freeBuffers = true;
			c[0] = 0.0f;
			c[1] = 1.0f;
			c[2] = 0.0f;
			c[3] = 0.0f;
			c[4] = 0.0f;
			c[5] = 1.0f;
			Math_VecCopy(obj->net.mins, v);
			Math_VecCopy(obj->net.maxs, &v[3]);
			g.verts = v;
			g.numVerts = 2;
			g.colors = c;
			g.primType = -2;
			g_sharedFn->GL_AddGenericObject(&g);
		}
		break;

	default:
		break;
	}
}
