//Shared6502.cpp: shared data types for Virtual6502

//processor status flag bits
#define		STATUS_CARRY			(1<<0)
#define		STATUS_ZERO				(1<<1)
#define		STATUS_INTDISABLE		(1<<2)
#define		STATUS_DECIMAL			(1<<3)
#define		STATUS_BRK				(1<<4)
#define		STATUS_UNUSED			(1<<5)
#define		STATUS_OVERFLOW			(1<<6)
#define		STATUS_NEGATIVE			(1<<7)

#define		MEM_BANK_SIZE			0x10000 //64KB
#define		MEM_STACK_LOC			0x0100

#define		MAX_OP_STR				1024

#define		OPMODE_STANDARD			0x00
#define		OPMODE_IMMEDIATE		0x01
#define		OPMODE_ZPAGE			0x02
#define		OPMODE_ZPAGEX			0x03
#define		OPMODE_ZPAGEY			0x04
#define		OPMODE_INDIRECTX		0x05
#define		OPMODE_INDIRECTY		0x06
#define		OPMODE_ABSOLUTE			0x07
#define		OPMODE_ABSOLUTEX		0x08
#define		OPMODE_ABSOLUTEY		0x09
#define		OPMODE_IND				0x0A
#define		OPMODE_REL				0x0B
typedef struct emuOpCode_s
{
	wchar_t			*str;
	BYTE			mode;
	BYTE			cycles;
	void			(*opHandler)(void);
} emuOpCode_t;

typedef struct emuContext_s
{
	WORD			pc;
	BYTE			sp;
	BYTE			a;
	BYTE			x;
	BYTE			y;
	BYTE			st;

	//stored on the context for convenience
	BYTE			*activeBank;
	emuOpCode_t		*opCur;
	BYTE			*opMem;
} emuContext_t;

class CPluginAPI
{
public:
	//you are expected to fill these in
					//called every tick by the emulator
	void			(*Plugin_TickFunction)(emuContext_t *context, BYTE *bank, bool cpuActive);
					//the emulator is about to shut down
	void			(*Plugin_Shutdown)(void);

	//this is optional, if you want to handle custom opcodes
	//returns number of cycles to add to counter.
	int				(*Plugin_OpCodeHandler)(emuContext_t *context, BYTE *bank, emuOpCode_t *op, BYTE *opMem);
};
