#include <windows.h>

//Main callback class. Do not modify this class, as it is
//shared with the client executeable.
class CUserAPI
{
public:
	//Send an IM to the specified name with the specified
	//message. If isAuto is true, the message will be
	//flagged as an away message response.
	virtual void		SendIM(char *name, char *msg, bool isAuto);

	//Buffer functions. StatusMessage will print a status
	//message to the buffer, BufferPrint will print directly
	//to the buffer, and GetBuffer will give you a pointer
	//to the current buffer text.
	virtual void		StatusMessage(char *text);
	virtual void		BufferPrint(char *text);
	virtual char		*GetBuffer(void);

	//Sends a message directly to the server. Be careful
	//with this as if you make the server unhappy it may
	//drop you or do any number of other things.
	virtual void		SendServerMessage(char *message);

	//Adds/removes strings on the buddy list window directly.
	//Could be useful for implementing a chat feature within
	//the existing UI. Returns true if the operation was
	//success, or false if it failed (nothing happened).
	virtual bool		AddListString(char *str);
	virtual bool		RemoveListString(char *str);

	//Disconnects the client from the AIM service.
	virtual void		Disconnect(void);

	//Sets "away" status. If text is "", then away status is cleared.
	//This is the internal client away status, and not the AIM user
	//away status. For that you will have to use SendServerMessage
	//with toc_set_away.
	virtual void		SetAway(char *text);
};

//On init, this will be set to the client API object.
//After it is set we can use it for exe callbacks.
static CUserAPI *g_userAPI = NULL;

//On init, we will set this to the handle of the main
//client window.
static HWND g_clientWindow = 0;

//You can use this to keep track of if the user
//is actually actively connected to the AIM server
//or not.
#define	STATE_DISCONNECTED		0
#define	STATE_CONNECTED			1

static int g_connectionState = STATE_DISCONNECTED;


/*
============================
EXPORT FUNC
Initialize

Get a pointer to our CUserAPI object, as well as some
other useful stuff such as the main client window handle.
This is called just after the DLL has been loaded. If
you return 0, the DLL will fail and be unloaded. If you
return 1, the DLL will be kept in memory with the other
user modules.
============================
*/
int Initialize(HWND clientWindow, CUserAPI *userAPI)
{
	g_clientWindow = clientWindow;
	g_userAPI = userAPI;

	return 1;
}

/*
============================
EXPORT FUNC
Shutdown

Called just before the DLL is unloaded. If you have any
"cleanup" work to do, then now is the time to do it.
============================
*/
void Shutdown(void)
{
}

/*
============================
EXPORT FUNC
OnServerCommand

Called when the client receives a command from the server.
============================
*/
void OnServerCommand(char *cmd, char *args)
{
}

/*
============================
EXPORT FUNC
OnUserCommand

The user has issued a "/" command. You should return 1
if your DLL recognizes this command, otherwise 0.
============================
*/
int OnUserCommand(char *cmd, char *args)
{
	return 0;
}

/*
============================
EXPORT FUNC
OnSendIM

Called right before the user sends off an IM.
Return -1 if you wish to stop the IM from sending.
Any other return value will proceed. If autoReply
is true, the IM being sent is flagged as an away
message response.
============================
*/
int OnSendIM(char *toUser, char *message, bool autoReply)
{
	return 0;
}

/*
============================
EXPORT FUNC
OnReceiveIM

Called upon reception of an instant message from another user.
You could also check for "IM_IN" within OnServerCommand, so
this is basically just a convenience function.
============================
*/
void OnReceiveIM(char *fromUser, char *message)
{
}

/*
============================
EXPORT FUNC
OnConnect

We have connected to the AIM server.
============================
*/
void OnConnect(void)
{
	g_connectionState = STATE_CONNECTED;
}

/*
============================
EXPORT FUNC
OnDisconnect

Disconnected by some means, whether by the user's
decision or not.
============================
*/
void OnDisconnect(void)
{
	g_connectionState = STATE_DISCONNECTED;
}
