/*
==============================================================================

Model View - Erik and Roland Karlsson (roland@cslab.ericsson.se)

==============================================================================
*/

#include "g_local.h"
#include "m_player.h"

struct animations
{
  int begin;
  char *name;
}
animations[] =
{
  {FRAME_stand01, "stand"},
  {FRAME_run1, "run"},
  {FRAME_attack1, "attack"},
  {FRAME_pain101, "pain1"},
  {FRAME_pain201, "pain2"},
  {FRAME_pain301, "pain3"},
  {FRAME_jump1, "jump"},
  {FRAME_flip01, "flip"},
  {FRAME_salute01, "salute"},
  {FRAME_taunt01, "taunt"},
  {FRAME_wave01, "wave"},
  {FRAME_point01, "point"},
  {FRAME_crstnd01, "crstnd"},
  {FRAME_crwalk1, "crwalk"},
  {FRAME_crattak1, "crattak"},
  {FRAME_crpain1, "crpain"},
  {FRAME_crdeath1, "crdeath"},
  {FRAME_death101, "death1"},
  {FRAME_death201, "death2"},
  {FRAME_death301, "death3"},
  {FRAME_death308+1, NULL}
};

static int animindex = 0;
static int showweapon = 0;
static int delaymult = 1;

static void ShowWeapon()
{
  edict_t *t = NULL;
  
  while ((t = G_Find (t, FOFS(classname), "misc_modelview")))
    t->s.modelindex2 = (showweapon && animations[animindex].begin < FRAME_crdeath1) ? 255 : 0;
}

char *GetModelAnim()
{
  return animations[animindex].name;
}

qboolean SetModelAnim(char *name)
{
  int i;

  for (i=0; animations[i].name; i++)
    if (!Q_stricmp(animations[i].name, name))
      {
	animindex = i;
	ShowWeapon();
	return 1;
      }

  return 0;
}

char *NextModelAnim()
{
  animindex++;

  if (!animations[animindex].name) animindex = 0;

  ShowWeapon();

  return animations[animindex].name;
}

char *PrevModelAnim()
{
  animindex--;

  if (animindex < 0)
    {
      int i;

      for (i=0; animations[i].name; i++) ;
      animindex = i - 1;
    }

  ShowWeapon();

  return animations[animindex].name;
}

void ModelAnimWeapon()
{
  showweapon = !showweapon;

  ShowWeapon();
}

void ModelAnimSpeed()
{
  if (delaymult == 1) delaymult = 4;
  else delaymult = 1;
}

void Think_Modelview (edict_t *ent)
{
  ent->s.frame++;

  if (ent->s.frame >= animations[animindex+1].begin ||
      ent->s.frame < animations[animindex].begin )
    ent->s.frame = animations[animindex].begin;

  ent->nextthink = level.time + FRAMETIME*delaymult;
}

void SP_misc_modelview (edict_t *self)
{
  self->movetype = MOVETYPE_STEP;
  self->solid = SOLID_BBOX;
  self->s.modelindex = 255;
  self->s.modelindex2 = 0;
  self->s.frame = FRAME_stand01;

  self->client = &game.clients[0];

  VectorSet (self->mins, -16, -16, -24);
  VectorSet (self->maxs, 16, 16, 32);

  self->use = NULL;
  self->think = Think_Modelview;
  self->nextthink = level.time + FRAMETIME;
  gi.linkentity (self);
}
