

#include "bg_vehicles.h"

//////////////////////////////
// vehicle helper functions //
//////////////////////////////
int Vehicle_InitVehicle(vehicle_t *vehicle) {
   int i;

   if(vehicle) {
      vehicle->vehicleId = -1;
      vehicle->entityId = -1;
      vehicle->templateNum = -1;

      strcpy(vehicle->vehicleInfo.vehicleName, "");

      vehicle->vehicleInfo.vehicleType = 0;

      vehicle->vehicleInfo.vehicleStats.health = 0;
      vehicle->vehicleInfo.vehicleStats.armor = 0;
      
      vehicle->vehicleInfo.weaponInfo.baseWeapon = 0;
      vehicle->vehicleInfo.weaponInfo.weapons = 0;

		for(i = 0; i < MAX_VEHICLE_MODELS; i++) {
			VehicleModel_Init(&(vehicle->vehicleInfo.displayInfo.models[i]));
		}

      vehicle->vehicleInfo.soundInfo.movesound1 = 0;
      vehicle->vehicleInfo.soundInfo.movesound2 = 0;

      vehicle->vehicleInfo.physicsInfo.maxSpeed = 0;
      vehicle->vehicleInfo.physicsInfo.movementType = 0;
      vehicle->vehicleInfo.physicsInfo.width = 0;
      vehicle->vehicleInfo.physicsInfo.height = 0;
      
      return 1;
   }
   return 0;
}

int Vehicle_CopyVehicle(vehicle_t *target, const vehicle_t *source) {
   int i;

   if(source && target) {
      target->vehicleId = source->vehicleId;
      target->entityId = source->entityId;
      target->templateNum = source->templateNum;

      for(i = 0; i < 64; i++)
         target->vehicleInfo.vehicleName[i] = source->vehicleInfo.vehicleName[i];
      //strcpy(target->vehicleInfo.vehicleName, source->vehicleInfo.vehicleName);

      target->vehicleInfo.vehicleType = source->vehicleInfo.vehicleType;

      target->vehicleInfo.vehicleStats.health = source->vehicleInfo.vehicleStats.health;
      target->vehicleInfo.vehicleStats.armor = source->vehicleInfo.vehicleStats.armor;
      
      target->vehicleInfo.weaponInfo.baseWeapon = source->vehicleInfo.weaponInfo.baseWeapon;
      target->vehicleInfo.weaponInfo.weapons = source->vehicleInfo.weaponInfo.weapons;

		for(i = 0; i < MAX_VEHICLE_MODELS; i++) {
			VehicleModel_Copy(&(target->vehicleInfo.displayInfo.models[i]), &(source->vehicleInfo.displayInfo.models[i]));
		}

      target->vehicleInfo.soundInfo.movesound1 = source->vehicleInfo.soundInfo.movesound1;
      target->vehicleInfo.soundInfo.movesound2 = source->vehicleInfo.soundInfo.movesound2;

      target->vehicleInfo.physicsInfo.maxSpeed = source->vehicleInfo.physicsInfo.maxSpeed;
      target->vehicleInfo.physicsInfo.movementType = source->vehicleInfo.physicsInfo.movementType;
      target->vehicleInfo.physicsInfo.width = source->vehicleInfo.physicsInfo.width;
      target->vehicleInfo.physicsInfo.height = source->vehicleInfo.physicsInfo.height;

      return 1;
   }
   return 0;
}

int VehicleModel_Init(vehicleModel_t *vehicleModel) {
	if(vehicleModel) {
		vehicleModel->modelType = -1;
		vehicleModel->model = 0;
		vehicleModel->skin = 0;
		vehicleModel->shader = 0;
		vehicleModel->scale = 0;
		vehicleModel->radius = 0;
		vehicleModel->offset[0] = 0;
		vehicleModel->offset[1] = 0;
		vehicleModel->offset[2] = 0;
		vehicleModel->angles[0] = 0;
		vehicleModel->angles[1] = 0;
		vehicleModel->angles[2] = 0;

		return 1;
	} else {
		return 0;
	}
}

int VehicleModel_Copy(vehicleModel_t *target, vehicleModel_t *source) {
	if(source && target) {
		target->modelType = source->modelType;
		target->model = source->model;
		target->skin = source->skin;
		target->shader = source->shader;
		target->scale = source->scale;
		target->radius = source->radius;
		target->offset[0] = source->offset[0];
		target->offset[1] = source->offset[1];
		target->offset[2] = source->offset[2];
		target->angles[0] = source->angles[0];
		target->angles[1] = source->angles[1];
		target->angles[2] = source->angles[2];
   
		return 1;
	} else {
		return 0;
	}
}

//////////////////////////
// info lookup routines //
//////////////////////////
int VehicleInfo_GetBitForVehicleType(char *name) {
   if(strcmp(name, "tank") == 0) {
      return VEHICLE_TANK;
   } else {
      return -1;
   }
}


int VehicleInfo_GetBitForWeapon(char *name) {
   if(strcmp(name, "wp_knife") == 0) {
      return WEAPON_KNIFE;
   } else if (strcmp(name, "wp_venom") == 0) {
      return WEAPON_VENOM;
   } else if (strcmp(name, "wp_panzerfaust") == 0) {
      return WEAPON_PANZERFAUST;
   } else if (strcmp(name, "wp_mp40") == 0) {
      return WEAPON_MP40;
   } else {
      return 0;
   }
}

char *VehicleInfo_GetNameForWeapon(int bit) {
   if (bit == WEAPON_KNIFE)
      return "wp_knife";
   else if (bit == WEAPON_VENOM)
      return "wp_venom";
   else if (bit == WEAPON_PANZERFAUST)
      return "wp_panzerfaust";
   else if (bit == WEAPON_MP40)
      return "wp_mp40";
   else
      return 0;
}

int VehicleInfo_GetIndexForWeapon(int weapon) {
   switch(weapon) {
      case WEAPON_KNIFE:
         return 0;
      case WEAPON_VENOM:
         return 1;
      case WEAPON_PANZERFAUST:
         return 2;
      case WEAPON_MP40:
         return 3;
      default: 
         return -1;
   }
   return -1;
}

char *VehicleInfo_GetNameForVehicleType(int bit) {
   if(bit == VEHICLE_TANK)
      return "tank";
   else
      return 0;
}

int VehicleInfo_GetBitForMovementType(char *name) {
   if(strcmp(name, "treads") == 0) {
      return VEHICLE_TANK;
   } else {
      return -1;
   }
}

int VehicleInfo_GetIndexForModelName(char *name) {
	// convert name to lower case
	
	int i;
	
	for(i = 0; i < strlen(name); i++) {
		name[i] = tolower(name[i]);
	}

	if(strcmp(name, "vehicle") == 0) {
		return MODEL_VEHICLE;
	} else if (strcmp(name, "cockpit") == 0) {
		return MODEL_COCKPIT;
	} else if (strcmp(name, "gib0") == 0) {
		return MODEL_GIB0;
	} else if (strcmp(name, "gib1") == 0) {
		return MODEL_GIB1;
	} else if (strcmp(name, "gib2") == 0) {
		return MODEL_GIB2;
	} else if (strcmp(name, "gib3") == 0) {
		return MODEL_GIB3;
	} else {
		// didnt find it in the modelTypes_t enum
		return 0;
	}
}

char *VehicleInfo_GetNameForModelType(int modelType) {
	switch(modelType) {
		case MODEL_VEHICLE:
			return "vehicle";
		case MODEL_COCKPIT:
			return "cockpit";
		case MODEL_GIB0:
			return "gib0";
		case MODEL_GIB1:
			return "gib1";
		case MODEL_GIB2:
			return "gib2";
		case MODEL_GIB3:
			return "gib3";
		default:
			// no name for current index
			return "none";
	}
}