code
proc vehicles_clear_string 4 0
file "../g_vehicles.c"
line 15
;1:/*
;2:
;3:	g_botf_vehicle.c
;4:
;5:	Author: AFZ
;6:	Date: 6/01/02
;7:
;8:	- This file contains the implementations for all of the vehicle specific code
;9:*/
;10:
;11:#include "g_vehicles.h"
;12:
;13:#include "g_local.h"
;14:
;15:static void vehicles_clear_string(char *string, int length) {
line 16
;16:   int i = 0;
ADDRLP4 0
CNSTI4 0
ASGNI4
line 17
;17:   for(i; i < length; i++) {
ADDRGP4 $93
JUMPV
LABELV $90
line 18
;18:      string[i] = '\0';
ADDRLP4 0
INDIRI4
ADDRFP4 0
INDIRP4
ADDP4
CNSTI1 0
ASGNI1
line 19
;19:   }
LABELV $91
line 17
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $93
ADDRLP4 0
INDIRI4
ADDRFP4 4
INDIRI4
LTI4 $90
line 20
;20:}
LABELV $89
endproc vehicles_clear_string 4 0
export Touch_Vehicle
proc Touch_Vehicle 12 4
line 25
;21:
;22://///////////////////////////////
;23:// vehicle entity helper funcs //
;24://///////////////////////////////
;25:void Touch_Vehicle (gentity_t *ent, gentity_t *other, trace_t *trace) {
line 28
;26:   vec3_t   v;
;27:
;28:   G_Printf("Vehicle: Touched.\n");
ADDRGP4 $95
ARGP4
ADDRGP4 G_Printf
CALLV
pop
line 31
;29:
;30:	// make sure whoever touched this vehicle is a client
;31:   if (!other->client)
ADDRFP4 4
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $96
line 32
;32:		return;
ADDRGP4 $94
JUMPV
LABELV $96
line 42
;33:
;34:   /*
;35:   // make sure this client has his WBUTTON_USE_VEHICLE button held down
;36:   if ( other->client->ps.stats[STAT_VEHICLE] || !(other->client->buttons & WBUTTON_USE_VEHICLE) ) {
;37:      return;
;38:   }
;39:   */
;40:
;41:   // set the vehicleId to a stat for the client
;42:   other->client->ps.stats[STAT_VEHICLE] = ent->s.otherEntityNum2;
ADDRFP4 4
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 260
ADDP4
ADDRFP4 0
INDIRP4
CNSTI4 188
ADDP4
INDIRI4
ASGNI4
line 65
;43:
;44:   /*
;45:   // get a unit vector in the direction of the velocity of the toucher
;46:   VectorCopy(other->client->ps.velocity, v);
;47:   VectorNormalize(v);
;48:
;49:   // scale the vector to a speed of 10units/sec
;50:   VectorScale(v, 10, v);
;51:
;52:   // set the vel vector to the trDelta of the entity being touched...
;53:   VectorCopy(v, ent->s.pos.trDelta);
;54:   
;55:   VectorCopy( ent->s.origin, ent->s.pos.trBase );
;56:	VectorCopy( ent->s.pos.trBase, ent->r.currentOrigin );
;57:   
;58:   //VectorCopy(ent->s.pos.trBase, other->r.currentOrigin);
;59:   //VectorCopy(ent->s.origin, other->r.currentOrigin);
;60:   //VectorCopy(ent->r.currentOrigin, other->r.currentOrigin);
;61:   ent->s.pos.trType = TR_LINEAR;
;62:   //VectorAdd(ent->s.origin, v, ent->s.origin);
;63:   */
;64:
;65:   trap_LinkEntity(ent);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 trap_LinkEntity
CALLV
pop
line 66
;66:}
LABELV $94
endproc Touch_Vehicle 12 4
export Vehicle_Die
proc Vehicle_Die 0 8
line 69
;67:
;68:// monster dies
;69:void Vehicle_Die( gentity_t *self, gentity_t *inflictor, gentity_t *attacker, int damage, int meansOfDeath ) {
line 70
;70:	GibEntity( self, 0 );
ADDRFP4 0
INDIRP4
ARGP4
CNSTI4 0
ARGI4
ADDRGP4 GibEntity
CALLI4
pop
line 73
;71:
;72:   // remove the vehicle from the server list
;73:   VehicleArray_RemoveVehicleForId(self->s.otherEntityNum2);
ADDRFP4 0
INDIRP4
CNSTI4 188
ADDP4
INDIRI4
ARGI4
ADDRGP4 VehicleArray_RemoveVehicleForId
CALLI4
pop
line 77
;74:   // tell the client to remove the vehicle as well
;75:   //...
;76:
;77:	G_FreeEntity( self );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 G_FreeEntity
CALLV
pop
line 78
;78:}
LABELV $98
endproc Vehicle_Die 0 8
export G_SpawnVehicle
proc G_SpawnVehicle 96 16
line 80
;79:
;80:int G_SpawnVehicle(vehicle_t *v, gentity_t *e, gentity_t *owner) {
line 86
;81:   vec3_t	dir;
;82:   vec3_t maxs, mins;
;83:   int i;
;84:
;85:	// spawn klonky
;86:	e = G_Spawn();
ADDRLP4 40
ADDRGP4 G_Spawn
CALLP4
ASGNP4
ADDRFP4 4
ADDRLP4 40
INDIRP4
ASGNP4
line 89
;87:
;88:	// tell klonky who his master is...
;89:	if(owner) {
ADDRFP4 8
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $100
line 90
;90:		e->parent = owner;
ADDRFP4 4
INDIRP4
CNSTI4 536
ADDP4
ADDRFP4 8
INDIRP4
ASGNP4
line 91
;91:		e->r.ownerNum = owner->s.number;
ADDRFP4 4
INDIRP4
CNSTI4 396
ADDP4
ADDRFP4 8
INDIRP4
INDIRI4
ASGNI4
line 92
;92:	}
LABELV $100
line 94
;93:	
;94:	VectorCopy(owner->r.currentOrigin, e->s.origin);
ADDRFP4 4
INDIRP4
CNSTI4 92
ADDP4
ADDRFP4 8
INDIRP4
CNSTI4 368
ADDP4
INDIRB
ASGNB 12
line 96
;95:	// set its initial position and zero out 2 and 3
;96:	VectorCopy(e->s.origin, e->s.pos.trBase);
ADDRLP4 44
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 44
INDIRP4
CNSTI4 24
ADDP4
ADDRLP4 44
INDIRP4
CNSTI4 92
ADDP4
INDIRB
ASGNB 12
line 97
;97:	VectorCopy(owner->s.angles, e->s.angles);
ADDRLP4 48
CNSTI4 116
ASGNI4
ADDRFP4 4
INDIRP4
ADDRLP4 48
INDIRI4
ADDP4
ADDRFP4 8
INDIRP4
ADDRLP4 48
INDIRI4
ADDP4
INDIRB
ASGNB 12
line 98
;98:	AngleVectors(owner->s.angles, dir, NULL, NULL);
ADDRFP4 8
INDIRP4
CNSTI4 116
ADDP4
ARGP4
ADDRLP4 4
ARGP4
ADDRLP4 52
CNSTP4 0
ASGNP4
ADDRLP4 52
INDIRP4
ARGP4
ADDRLP4 52
INDIRP4
ARGP4
ADDRGP4 AngleVectors
CALLV
pop
line 100
;99:	//VectorMA(ent->s.pos.trBase, dir, 100, ent->s.pos.trBase);
;100:	VectorNormalize(dir);
ADDRLP4 4
ARGP4
ADDRGP4 VectorNormalize
CALLF4
pop
line 101
;101:	dir[0] *= 20;
ADDRLP4 4
CNSTF4 1101004800
ADDRLP4 4
INDIRF4
MULF4
ASGNF4
line 102
;102:	dir[1] *= 20;
ADDRLP4 4+4
CNSTF4 1101004800
ADDRLP4 4+4
INDIRF4
MULF4
ASGNF4
line 103
;103:	dir[2] *= 20;
ADDRLP4 4+8
CNSTF4 1101004800
ADDRLP4 4+8
INDIRF4
MULF4
ASGNF4
line 104
;104:	VectorAdd(e->s.origin, dir, e->s.origin);
ADDRLP4 56
ADDRFP4 4
INDIRP4
CNSTI4 92
ADDP4
ASGNP4
ADDRLP4 56
INDIRP4
ADDRLP4 56
INDIRP4
INDIRF4
ADDRLP4 4
INDIRF4
ADDF4
ASGNF4
ADDRLP4 60
ADDRFP4 4
INDIRP4
CNSTI4 96
ADDP4
ASGNP4
ADDRLP4 60
INDIRP4
ADDRLP4 60
INDIRP4
INDIRF4
ADDRLP4 4+4
INDIRF4
ADDF4
ASGNF4
ADDRLP4 64
ADDRFP4 4
INDIRP4
CNSTI4 100
ADDP4
ASGNP4
ADDRLP4 64
INDIRP4
ADDRLP4 64
INDIRP4
INDIRF4
ADDRLP4 4+8
INDIRF4
ADDF4
ASGNF4
line 106
;105:	//VectorCopy(e->s.origin, e->s.pos.trBase);
;106:	e->s.pos.trType = TR_GRAVITY;
ADDRFP4 4
INDIRP4
CNSTI4 12
ADDP4
CNSTI4 5
ASGNI4
line 107
;107:	e->s.pos.trTime = level.time;
ADDRFP4 4
INDIRP4
CNSTI4 16
ADDP4
ADDRGP4 level+32
INDIRI4
ASGNI4
line 115
;108:	
;109:	//VectorSet(e->pos2, 0, 0, 0);
;110:	//VectorSet(e->pos3, 0, 0, 0);
;111:
;112:	// set vehicles bounding box
;113:   
;114:	//e->clipmask = MASK_PLAYERSOLID;
;115:   e->r.contents = CONTENTS_TRIGGER|CONTENTS_BODY|CONTENTS_SOLID;
ADDRFP4 4
INDIRP4
CNSTI4 340
ADDP4
CNSTI4 1281
ASGNI4
line 117
;116:   
;117:   e->clipmask   = MASK_SHOT;
ADDRFP4 4
INDIRP4
CNSTI4 508
ADDP4
CNSTI4 769
ASGNI4
line 124
;118:	//e->r.contents = CONTENTS_SOLID | CONTENTS_PLAYERCLIP | CONTENTS_MONSTERCLIP | CONTENTS_BODY;
;119:   
;120:   /*
;121:   VectorSet(maxs, g_vehicleTemplates[v->templateNum].vehicleInfo.physicsInfo.width / 2, g_vehicleTemplates[v->templateNum].vehicleInfo.physicsInfo.width / 2, g_vehicleTemplates[v->templateNum].vehicleInfo.physicsInfo.height / 2);
;122:   VectorSet(mins, -1 * g_vehicleTemplates[v->templateNum].vehicleInfo.physicsInfo.width / 2, -1 * g_vehicleTemplates[v->templateNum].vehicleInfo.physicsInfo.width / 2, -1 * g_vehicleTemplates[v->templateNum].vehicleInfo.physicsInfo.height / 2);
;123:   */
;124:   VectorSet(maxs, 15, 15, 24);
ADDRLP4 68
CNSTF4 1097859072
ASGNF4
ADDRLP4 16
ADDRLP4 68
INDIRF4
ASGNF4
ADDRLP4 16+4
ADDRLP4 68
INDIRF4
ASGNF4
ADDRLP4 16+8
CNSTF4 1103101952
ASGNF4
line 125
;125:   VectorSet(mins, -15, -15, -10);
ADDRLP4 72
CNSTF4 3245342720
ASGNF4
ADDRLP4 28
ADDRLP4 72
INDIRF4
ASGNF4
ADDRLP4 28+4
ADDRLP4 72
INDIRF4
ASGNF4
ADDRLP4 28+8
CNSTF4 3240099840
ASGNF4
line 127
;126:
;127:   VectorCopy(mins, e->r.mins);
ADDRFP4 4
INDIRP4
CNSTI4 316
ADDP4
ADDRLP4 28
INDIRB
ASGNB 12
line 128
;128:	VectorCopy(maxs, e->r.maxs);
ADDRFP4 4
INDIRP4
CNSTI4 328
ADDP4
ADDRLP4 16
INDIRB
ASGNB 12
line 133
;129:
;130:   
;131:	
;132:	// give vehicle some attributes
;133:	e->r.svFlags = SVF_USE_CURRENT_ORIGIN | SVF_BROADCAST;
ADDRFP4 4
INDIRP4
CNSTI4 304
ADDP4
CNSTI4 160
ASGNI4
line 134
;134:	e->s.eType = ET_VEHICLE;
ADDRFP4 4
INDIRP4
CNSTI4 4
ADDP4
CNSTI4 16
ASGNI4
line 135
;135:	e->classname = "Vehicle";
ADDRFP4 4
INDIRP4
CNSTI4 416
ADDP4
ADDRGP4 $111
ASGNP4
line 139
;136:
;137:	//v->think = Vehicle_think;
;138:	//v->nextthink = level.time + 1500;
;139:   e->touch = Touch_Vehicle;
ADDRFP4 4
INDIRP4
CNSTI4 648
ADDP4
ADDRGP4 Touch_Vehicle
ASGNP4
line 142
;140:
;141:   // setup mortality
;142:	e->takedamage = qtrue;
ADDRFP4 4
INDIRP4
CNSTI4 680
ADDP4
CNSTI4 1
ASGNI4
line 143
;143:   e->health = g_vehicleTemplates[e->s.otherEntityNum].vehicleInfo.vehicleStats.health;
ADDRLP4 76
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 76
INDIRP4
CNSTI4 676
ADDP4
CNSTI4 80
ADDRLP4 76
INDIRP4
CNSTI4 184
ADDP4
INDIRI4
MULI4
ADDRGP4 g_vehicleTemplates+12+20
ADDP4
INDIRU1
CVUI4 1
ASGNI4
line 144
;144:	e->die = Vehicle_Die;
ADDRFP4 4
INDIRP4
CNSTI4 660
ADDP4
ADDRGP4 Vehicle_Die
ASGNP4
line 148
;145:
;146:	//v->s.modelindex = G_ModelIndex( "models/weapons2/shells/pf_shell.md3" );
;147:
;148:	G_SetOrigin (e, e->s.origin);
ADDRLP4 80
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 80
INDIRP4
ARGP4
ADDRLP4 80
INDIRP4
CNSTI4 92
ADDP4
ARGP4
ADDRGP4 G_SetOrigin
CALLV
pop
line 149
;149:	G_SetAngles (e, e->s.angles);
ADDRLP4 84
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 84
INDIRP4
ARGP4
ADDRLP4 84
INDIRP4
CNSTI4 116
ADDP4
ARGP4
ADDRGP4 G_SetAngles
CALLV
pop
line 153
;150:
;151:	//G_RunThink( v );
;152:
;153:   g_vehicles[v->vehicleId].entityId = e->s.number;
CNSTI4 80
ADDRFP4 0
INDIRP4
INDIRI4
MULI4
ADDRGP4 g_vehicles+4
ADDP4
ADDRFP4 4
INDIRP4
INDIRI4
ASGNI4
line 156
;154:   
;155:   // set vars to be used for asset lookup in cg_vehicle
;156:   e->s.otherEntityNum = v->templateNum;
ADDRFP4 4
INDIRP4
CNSTI4 184
ADDP4
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ASGNI4
line 157
;157:   e->s.otherEntityNum2 = v->vehicleId;
ADDRFP4 4
INDIRP4
CNSTI4 188
ADDP4
ADDRFP4 0
INDIRP4
INDIRI4
ASGNI4
line 159
;158:
;159:   for(i = 0; i < MAX_CLIENTS; i++) {
ADDRLP4 0
CNSTI4 0
ASGNI4
LABELV $115
line 160
;160:      if(g_entities[i].client) {
CNSTI4 828
ADDRLP4 0
INDIRI4
MULI4
ADDRGP4 g_entities+408
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $119
line 161
;161:         trap_SendServerCommand( i, va("vehicleSpawnCG %d %d %d\n", g_vehicles[v->vehicleId].templateNum, g_vehicles[v->vehicleId].vehicleId, g_vehicles[v->vehicleId].entityId) );
ADDRGP4 $122
ARGP4
ADDRLP4 88
CNSTI4 80
ADDRFP4 0
INDIRP4
INDIRI4
MULI4
ASGNI4
ADDRLP4 88
INDIRI4
ADDRGP4 g_vehicles+8
ADDP4
INDIRI4
ARGI4
ADDRLP4 88
INDIRI4
ADDRGP4 g_vehicles
ADDP4
INDIRI4
ARGI4
ADDRLP4 88
INDIRI4
ADDRGP4 g_vehicles+4
ADDP4
INDIRI4
ARGI4
ADDRLP4 92
ADDRGP4 va
CALLP4
ASGNP4
ADDRLP4 0
INDIRI4
ARGI4
ADDRLP4 92
INDIRP4
ARGP4
ADDRGP4 trap_SendServerCommand
CALLV
pop
line 162
;162:      }
LABELV $119
line 163
;163:   }
LABELV $116
line 159
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 32
LTI4 $115
line 165
;164:
;165:   G_Printf("GAME: Spawned vehicle: %s at index %d with entityNum %d\n", g_vehicles[v->vehicleId].vehicleInfo.vehicleName, g_vehicles[v->vehicleId].vehicleId, g_vehicles[v->vehicleId].entityId);
ADDRGP4 $125
ARGP4
ADDRLP4 88
CNSTI4 80
ADDRFP4 0
INDIRP4
INDIRI4
MULI4
ASGNI4
ADDRLP4 88
INDIRI4
ADDRGP4 g_vehicles+12+4
ADDP4
ARGP4
ADDRLP4 88
INDIRI4
ADDRGP4 g_vehicles
ADDP4
INDIRI4
ARGI4
ADDRLP4 88
INDIRI4
ADDRGP4 g_vehicles+4
ADDP4
INDIRI4
ARGI4
ADDRGP4 G_Printf
CALLV
pop
line 170
;166:
;167:   
;168:
;169:	// throw vehicle into the mix
;170:	trap_LinkEntity (e);
ADDRFP4 4
INDIRP4
ARGP4
ADDRGP4 trap_LinkEntity
CALLV
pop
line 174
;171:
;172:   // make it solid...
;173:   //g_entities[e->s.number].s.solid = 2;//SOLID_BBOX;
;174:}
CNSTI4 0
RETI4
LABELV $99
endproc G_SpawnVehicle 96 16
export VehicleArray_InitVehicleArray
proc VehicleArray_InitVehicleArray 4 4
line 179
;175:
;176:////////////////////////////////////
;177:// vehicle array helper functions //
;178:////////////////////////////////////
;179:int VehicleArray_InitVehicleArray() {
line 181
;180:   int i;
;181:   for(i = 0; i < MAX_CLIENTS; i++) {
ADDRLP4 0
CNSTI4 0
ASGNI4
LABELV $130
line 182
;182:      Vehicle_InitVehicle(&(g_vehicles[i]));
CNSTI4 80
ADDRLP4 0
INDIRI4
MULI4
ADDRGP4 g_vehicles
ADDP4
ARGP4
ADDRGP4 Vehicle_InitVehicle
CALLI4
pop
line 183
;183:   }
LABELV $131
line 181
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 32
LTI4 $130
line 185
;184:
;185:   return 1;
CNSTI4 1
RETI4
LABELV $129
endproc VehicleArray_InitVehicleArray 4 4
export VehicleArray_GetVehicleForId
proc VehicleArray_GetVehicleForId 4 0
line 188
;186:}
;187:
;188:vehicle_t *VehicleArray_GetVehicleForId(int vehicleId) {
line 190
;189:   int i;
;190:   if(vehicleId >= 0) {
ADDRFP4 0
INDIRI4
CNSTI4 0
LTI4 $135
line 191
;191:      for(i = 0; i < MAX_CLIENTS; i++) {
ADDRLP4 0
CNSTI4 0
ASGNI4
LABELV $137
line 192
;192:         if(g_vehicles[i].vehicleId == vehicleId)
CNSTI4 80
ADDRLP4 0
INDIRI4
MULI4
ADDRGP4 g_vehicles
ADDP4
INDIRI4
ADDRFP4 0
INDIRI4
NEI4 $141
line 193
;193:            return &(g_vehicles[i]);
CNSTI4 80
ADDRLP4 0
INDIRI4
MULI4
ADDRGP4 g_vehicles
ADDP4
RETP4
ADDRGP4 $134
JUMPV
LABELV $141
line 194
;194:      }
LABELV $138
line 191
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 32
LTI4 $137
line 195
;195:   }
LABELV $135
line 196
;196:   return (vehicle_t*)0;
CNSTP4 0
RETP4
LABELV $134
endproc VehicleArray_GetVehicleForId 4 0
export VehicleArray_SetVehicleForId
proc VehicleArray_SetVehicleForId 4 8
line 199
;197:}
;198:
;199:int VehicleArray_SetVehicleForId(int vehicleId, vehicle_t *vehicle) {
line 201
;200:   int i;
;201:   if(vehicle && vehicleId) {
ADDRFP4 4
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $144
ADDRFP4 0
INDIRI4
CNSTI4 0
EQI4 $144
line 202
;202:      for(i = 0; i < MAX_CLIENTS; i++) {
ADDRLP4 0
CNSTI4 0
ASGNI4
LABELV $146
line 203
;203:         if(g_vehicles[i].vehicleId == vehicleId) {
CNSTI4 80
ADDRLP4 0
INDIRI4
MULI4
ADDRGP4 g_vehicles
ADDP4
INDIRI4
ADDRFP4 0
INDIRI4
NEI4 $150
line 204
;204:            Vehicle_CopyVehicle(&(g_vehicles[i]), vehicle);
CNSTI4 80
ADDRLP4 0
INDIRI4
MULI4
ADDRGP4 g_vehicles
ADDP4
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRGP4 Vehicle_CopyVehicle
CALLI4
pop
line 205
;205:            return 1;
CNSTI4 1
RETI4
ADDRGP4 $143
JUMPV
LABELV $150
line 207
;206:         }
;207:      }
LABELV $147
line 202
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 32
LTI4 $146
line 208
;208:   }
LABELV $144
line 209
;209:   return 0;
CNSTI4 0
RETI4
LABELV $143
endproc VehicleArray_SetVehicleForId 4 8
export VehicleArray_AddVehicle
proc VehicleArray_AddVehicle 8 8
line 213
;210:}
;211:
;212:
;213:int VehicleArray_AddVehicle(vehicle_t *vehicle) {
line 215
;214:   int i;
;215:   if(vehicle) {
ADDRFP4 0
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $153
line 216
;216:      for(i = 0; i < MAX_CLIENTS; i++) {
ADDRLP4 0
CNSTI4 0
ASGNI4
LABELV $155
line 217
;217:         if(g_vehicles[i].vehicleId == -1) {
CNSTI4 80
ADDRLP4 0
INDIRI4
MULI4
ADDRGP4 g_vehicles
ADDP4
INDIRI4
CNSTI4 -1
NEI4 $159
line 218
;218:            vehicle->vehicleId = i;
ADDRFP4 0
INDIRP4
ADDRLP4 0
INDIRI4
ASGNI4
line 219
;219:            return Vehicle_CopyVehicle(&(g_vehicles[i]), vehicle);
CNSTI4 80
ADDRLP4 0
INDIRI4
MULI4
ADDRGP4 g_vehicles
ADDP4
ARGP4
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 4
ADDRGP4 Vehicle_CopyVehicle
CALLI4
ASGNI4
ADDRLP4 4
INDIRI4
RETI4
ADDRGP4 $152
JUMPV
LABELV $159
line 221
;220:         }
;221:      }
LABELV $156
line 216
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 32
LTI4 $155
line 222
;222:   }
LABELV $153
line 223
;223:   return -1;
CNSTI4 -1
RETI4
LABELV $152
endproc VehicleArray_AddVehicle 8 8
export VehicleArray_RemoveVehicleForId
proc VehicleArray_RemoveVehicleForId 8 4
line 226
;224:}
;225:
;226:int VehicleArray_RemoveVehicleForId(int vehicleId) {
line 228
;227:   int i;
;228:   if(vehicleId) {
ADDRFP4 0
INDIRI4
CNSTI4 0
EQI4 $162
line 229
;229:      for(i = 0; i < MAX_CLIENTS; i++) {
ADDRLP4 0
CNSTI4 0
ASGNI4
LABELV $164
line 230
;230:         if(g_vehicles[i].vehicleId == vehicleId) {
CNSTI4 80
ADDRLP4 0
INDIRI4
MULI4
ADDRGP4 g_vehicles
ADDP4
INDIRI4
ADDRFP4 0
INDIRI4
NEI4 $168
line 231
;231:            return Vehicle_InitVehicle(&(g_vehicles[i]));
CNSTI4 80
ADDRLP4 0
INDIRI4
MULI4
ADDRGP4 g_vehicles
ADDP4
ARGP4
ADDRLP4 4
ADDRGP4 Vehicle_InitVehicle
CALLI4
ASGNI4
ADDRLP4 4
INDIRI4
RETI4
ADDRGP4 $161
JUMPV
LABELV $168
line 233
;232:         }
;233:      }
LABELV $165
line 229
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 32
LTI4 $164
line 234
;234:   }
LABELV $162
line 235
;235:   return 0;
CNSTI4 0
RETI4
LABELV $161
endproc VehicleArray_RemoveVehicleForId 8 4
export VehicleArray_OutputVehicles
proc VehicleArray_OutputVehicles 84 8
line 238
;236:}
;237:
;238:int VehicleArray_OutputVehicles(int clientNum) {
line 242
;239:   int i, j, k;
;240:   char buffer[64];
;241:
;242:   vehicles_clear_string(buffer, 64);
ADDRLP4 4
ARGP4
CNSTI4 64
ARGI4
ADDRGP4 vehicles_clear_string
CALLV
pop
line 244
;243:
;244:   trap_SendServerCommand( clientNum, "print \"Vehicles:\n\n\"" );
ADDRFP4 0
INDIRI4
ARGI4
ADDRGP4 $171
ARGP4
ADDRGP4 trap_SendServerCommand
CALLV
pop
line 246
;245:
;246:   for(i = 0; i < MAX_CLIENTS; i++) {
ADDRLP4 0
CNSTI4 0
ASGNI4
LABELV $172
line 247
;247:      if(g_vehicles[i].vehicleId != -1) {
CNSTI4 80
ADDRLP4 0
INDIRI4
MULI4
ADDRGP4 g_vehicles
ADDP4
INDIRI4
CNSTI4 -1
EQI4 $176
line 248
;248:         trap_SendServerCommand( clientNum, va("print \"  Vehicle: %d\n\"", i) );
ADDRGP4 $178
ARGP4
ADDRLP4 0
INDIRI4
ARGI4
ADDRLP4 76
ADDRGP4 va
CALLP4
ASGNP4
ADDRFP4 0
INDIRI4
ARGI4
ADDRLP4 76
INDIRP4
ARGP4
ADDRGP4 trap_SendServerCommand
CALLV
pop
line 249
;249:         trap_SendServerCommand( clientNum, va("print \"    Name:    %s\n\\n\"", g_vehicles[i].vehicleInfo.vehicleName) );
ADDRGP4 $179
ARGP4
CNSTI4 80
ADDRLP4 0
INDIRI4
MULI4
ADDRGP4 g_vehicles+12+4
ADDP4
ARGP4
ADDRLP4 80
ADDRGP4 va
CALLP4
ASGNP4
ADDRFP4 0
INDIRI4
ARGI4
ADDRLP4 80
INDIRP4
ARGP4
ADDRGP4 trap_SendServerCommand
CALLV
pop
line 256
;250:         /*
;251:         trap_SendServerCommand( clientNum, va("print \"    Type:    %s\n\"", VehicleInfo_GetNameForVehicleType(g_vehicleTemplates[i].vehicleInfo.vehicleType) ) );
;252:         trap_SendServerCommand( clientNum, va("print \"    Weapons: \n\""));
;253:         trap_SendServerCommand( clientNum, va("print \"             %s\n\"", ) );
;254:         */
;255:
;256:      }
LABELV $176
line 257
;257:   }
LABELV $173
line 246
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 32
LTI4 $172
line 258
;258:}
CNSTI4 0
RETI4
LABELV $170
endproc VehicleArray_OutputVehicles 84 8
export VehicleTemplateArray_InitVehicleTemplateArray
proc VehicleTemplateArray_InitVehicleTemplateArray 4 4
line 264
;259:
;260://////////////////////////////
;261:// vehicle template helpers //
;262://////////////////////////////
;263:
;264:int VehicleTemplateArray_InitVehicleTemplateArray() {
line 266
;265:   int i;
;266:   for(i = 0; i < MAX_CLIENTS; i++) {
ADDRLP4 0
CNSTI4 0
ASGNI4
LABELV $183
line 267
;267:      Vehicle_InitVehicle(&(g_vehicleTemplates[i]));
CNSTI4 80
ADDRLP4 0
INDIRI4
MULI4
ADDRGP4 g_vehicleTemplates
ADDP4
ARGP4
ADDRGP4 Vehicle_InitVehicle
CALLI4
pop
line 268
;268:   }
LABELV $184
line 266
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 32
LTI4 $183
line 270
;269:
;270:   return 1;
CNSTI4 1
RETI4
LABELV $182
endproc VehicleTemplateArray_InitVehicleTemplateArray 4 4
export VehicleTemplateArray_OutputTemplates
proc VehicleTemplateArray_OutputTemplates 80 8
line 273
;271:}
;272:
;273:int VehicleTemplateArray_OutputTemplates(int clientNum) {
line 277
;274:   int i, j, k;
;275:   char buffer[64];
;276:
;277:   vehicles_clear_string(buffer, 64);
ADDRLP4 4
ARGP4
CNSTI4 64
ARGI4
ADDRGP4 vehicles_clear_string
CALLV
pop
line 279
;278:
;279:   trap_SendServerCommand( clientNum, "print \"Vehicle Templates:\n\n\"" );
ADDRFP4 0
INDIRI4
ARGI4
ADDRGP4 $188
ARGP4
ADDRGP4 trap_SendServerCommand
CALLV
pop
line 280
;280:   trap_SendServerCommand( clientNum, "print \"  Vehicle:\n\"" );
ADDRFP4 0
INDIRI4
ARGI4
ADDRGP4 $189
ARGP4
ADDRGP4 trap_SendServerCommand
CALLV
pop
line 282
;281:
;282:   for(i = 0; i < MAX_CLIENTS; i++) {
ADDRLP4 0
CNSTI4 0
ASGNI4
LABELV $190
line 283
;283:      if(g_vehicleTemplates[i].templateNum != -1) {
CNSTI4 80
ADDRLP4 0
INDIRI4
MULI4
ADDRGP4 g_vehicleTemplates+8
ADDP4
INDIRI4
CNSTI4 -1
EQI4 $194
line 284
;284:         trap_SendServerCommand( clientNum, va("print \"    Name:    %s\n\\n\"", g_vehicleTemplates[i].vehicleInfo.vehicleName) );
ADDRGP4 $179
ARGP4
CNSTI4 80
ADDRLP4 0
INDIRI4
MULI4
ADDRGP4 g_vehicleTemplates+12+4
ADDP4
ARGP4
ADDRLP4 76
ADDRGP4 va
CALLP4
ASGNP4
ADDRFP4 0
INDIRI4
ARGI4
ADDRLP4 76
INDIRP4
ARGP4
ADDRGP4 trap_SendServerCommand
CALLV
pop
line 290
;285:         /*
;286:         trap_SendServerCommand( clientNum, va("print \"    Type:    %s\n\"", VehicleInfo_GetNameForVehicleType(g_vehicleTemplates[i].vehicleInfo.vehicleType) ) );
;287:         trap_SendServerCommand( clientNum, va("print \"    Weapons: \n\""));
;288:         trap_SendServerCommand( clientNum, va("print \"             %s\n\"", ) );
;289:         */
;290:      }
LABELV $194
line 291
;291:   }
LABELV $191
line 282
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 32
LTI4 $190
line 292
;292:}
CNSTI4 0
RETI4
LABELV $187
endproc VehicleTemplateArray_OutputTemplates 80 8
export VehicleTemplateArray_GetTemplateIndexForName
proc VehicleTemplateArray_GetTemplateIndexForName 8 8
line 294
;293:
;294:int VehicleTemplateArray_GetTemplateIndexForName(char *name) {
line 296
;295:   int i;
;296:   for(i = 0; i < MAX_CLIENTS; i++) {
ADDRLP4 0
CNSTI4 0
ASGNI4
LABELV $200
line 297
;297:      if(Q_stricmp(g_vehicleTemplates[i].vehicleInfo.vehicleName, name) == 0)
CNSTI4 80
ADDRLP4 0
INDIRI4
MULI4
ADDRGP4 g_vehicleTemplates+12+4
ADDP4
ARGP4
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 4
ADDRGP4 Q_stricmp
CALLI4
ASGNI4
ADDRLP4 4
INDIRI4
CNSTI4 0
NEI4 $204
line 298
;298:         return i;
ADDRLP4 0
INDIRI4
RETI4
ADDRGP4 $199
JUMPV
LABELV $204
line 299
;299:   }
LABELV $201
line 296
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 32
LTI4 $200
line 301
;300:
;301:   return -1;
CNSTI4 -1
RETI4
LABELV $199
endproc VehicleTemplateArray_GetTemplateIndexForName 8 8
import GibEntity
import trap_ROFF_Purge_Ent
import trap_ROFF_Play
import trap_ROFF_Cache
import trap_ROFF_UpdateEntities
import trap_ROFF_Clean
import trap_SP_GetStringTextString
import trap_SP_Register
import trap_SP_RegisterServer
import trap_SnapVector
import trap_GeneticParentsAndChildSelection
import trap_BotResetWeaponState
import trap_BotFreeWeaponState
import trap_BotAllocWeaponState
import trap_BotLoadWeaponWeights
import trap_BotGetWeaponInfo
import trap_BotChooseBestFightWeapon
import trap_BotAddAvoidSpot
import trap_BotInitMoveState
import trap_BotFreeMoveState
import trap_BotAllocMoveState
import trap_BotPredictVisiblePosition
import trap_BotMovementViewTarget
import trap_BotReachabilityArea
import trap_BotResetLastAvoidReach
import trap_BotResetAvoidReach
import trap_BotMoveInDirection
import trap_BotMoveToGoal
import trap_BotResetMoveState
import trap_BotFreeGoalState
import trap_BotAllocGoalState
import trap_BotMutateGoalFuzzyLogic
import trap_BotSaveGoalFuzzyLogic
import trap_BotInterbreedGoalFuzzyLogic
import trap_BotFreeItemWeights
import trap_BotLoadItemWeights
import trap_BotUpdateEntityItems
import trap_BotInitLevelItems
import trap_BotSetAvoidGoalTime
import trap_BotAvoidGoalTime
import trap_BotGetLevelItemGoal
import trap_BotGetMapLocationGoal
import trap_BotGetNextCampSpotGoal
import trap_BotItemGoalInVisButNotVisible
import trap_BotTouchingGoal
import trap_BotChooseNBGItem
import trap_BotChooseLTGItem
import trap_BotGetSecondGoal
import trap_BotGetTopGoal
import trap_BotGoalName
import trap_BotDumpGoalStack
import trap_BotDumpAvoidGoals
import trap_BotEmptyGoalStack
import trap_BotPopGoal
import trap_BotPushGoal
import trap_BotResetAvoidGoals
import trap_BotRemoveFromAvoidGoals
import trap_BotResetGoalState
import trap_BotSetChatName
import trap_BotSetChatGender
import trap_BotLoadChatFile
import trap_BotReplaceSynonyms
import trap_UnifyWhiteSpaces
import trap_BotMatchVariable
import trap_BotFindMatch
import trap_StringContains
import trap_BotGetChatMessage
import trap_BotEnterChat
import trap_BotChatLength
import trap_BotReplyChat
import trap_BotNumInitialChats
import trap_BotInitialChat
import trap_BotNumConsoleMessages
import trap_BotNextConsoleMessage
import trap_BotRemoveConsoleMessage
import trap_BotQueueConsoleMessage
import trap_BotFreeChatState
import trap_BotAllocChatState
import trap_Characteristic_String
import trap_Characteristic_BInteger
import trap_Characteristic_Integer
import trap_Characteristic_BFloat
import trap_Characteristic_Float
import trap_BotFreeCharacter
import trap_BotLoadCharacter
import trap_EA_ResetInput
import trap_EA_GetInput
import trap_EA_EndRegular
import trap_EA_ForcePower
import trap_EA_Alt_Attack
import trap_EA_View
import trap_EA_Move
import trap_EA_DelayedJump
import trap_EA_Jump
import trap_EA_SelectWeapon
import trap_EA_MoveRight
import trap_EA_MoveLeft
import trap_EA_MoveBack
import trap_EA_MoveForward
import trap_EA_MoveDown
import trap_EA_MoveUp
import trap_EA_Crouch
import trap_EA_Respawn
import trap_EA_Use
import trap_EA_Attack
import trap_EA_Talk
import trap_EA_Gesture
import trap_EA_Action
import trap_EA_Command
import trap_EA_SayTeam
import trap_EA_Say
import trap_AAS_PredictClientMovement
import trap_AAS_Swimming
import trap_AAS_AlternativeRouteGoals
import trap_AAS_PredictRoute
import trap_AAS_EnableRoutingArea
import trap_AAS_AreaTravelTimeToGoalArea
import trap_AAS_AreaReachability
import trap_AAS_IntForBSPEpairKey
import trap_AAS_FloatForBSPEpairKey
import trap_AAS_VectorForBSPEpairKey
import trap_AAS_ValueForBSPEpairKey
import trap_AAS_NextBSPEntity
import trap_AAS_PointContents
import trap_AAS_TraceAreas
import trap_AAS_PointReachabilityAreaIndex
import trap_AAS_PointAreaNum
import trap_AAS_Time
import trap_AAS_PresenceTypeBoundingBox
import trap_AAS_Initialized
import trap_AAS_EntityInfo
import trap_AAS_AreaInfo
import trap_AAS_BBoxAreas
import trap_BotUserCommand
import trap_BotGetServerCommand
import trap_BotGetSnapshotEntity
import trap_BotLibTest
import trap_BotLibUpdateEntity
import trap_BotLibLoadMap
import trap_BotLibStartFrame
import trap_BotLibDefine
import trap_BotLibVarGet
import trap_BotLibVarSet
import trap_BotLibShutdown
import trap_BotLibSetup
import trap_DebugPolygonDelete
import trap_DebugPolygonCreate
import trap_GetEntityToken
import trap_GetUsercmd
import trap_BotFreeClient
import trap_BotAllocateClient
import trap_EntityContact
import trap_EntitiesInBox
import trap_UnlinkEntity
import trap_LinkEntity
import trap_AreasConnected
import trap_AdjustAreaPortalState
import trap_InPVSIgnorePortals
import trap_InPVS
import trap_PointContents
import trap_Trace
import trap_SetBrushModel
import trap_GetServerinfo
import trap_SetUserinfo
import trap_GetUserinfo
import trap_GetConfigstring
import trap_SetConfigstring
import trap_SendServerCommand
import trap_DropClient
import trap_LocateGameData
import trap_Cvar_VariableStringBuffer
import trap_Cvar_VariableValue
import trap_Cvar_VariableIntegerValue
import trap_Cvar_Set
import trap_Cvar_Update
import trap_Cvar_Register
import trap_SendConsoleCommand
import trap_FS_GetFileList
import trap_FS_FCloseFile
import trap_FS_Write
import trap_FS_Read
import trap_FS_FOpenFile
import trap_Args
import trap_Argv
import trap_Argc
import trap_Milliseconds
import trap_Error
import trap_Printf
import g_austrian
import g_saberDebugPrint
import g_saberDmgDelay_Wound
import g_saberDmgDelay_Idle
import g_saberDmgVelocityScale
import g_timeouttospec
import g_forceDodge
import g_dismember
import g_singlePlayer
import g_enableBreath
import g_enableDust
import g_rankings
import pmove_msec
import pmove_fixed
import g_smoothClients
import g_blueteam
import g_redteam
import g_debugUp
import g_debugRight
import g_debugForward
import g_filterBan
import g_banIPs
import g_teamForceBalance
import g_teamAutoJoin
import g_allowVote
import g_blood
import g_doWarmup
import g_warmup
import g_motd
import g_synchronousClients
import g_adaptRespawn
import g_weaponTeamRespawn
import g_weaponRespawn
import g_debugDamage
import g_debugAlloc
import g_debugMove
import g_inactivity
import g_forcerespawn
import g_quadfactor
import g_knockback
import g_speed
import g_gravity
import g_needpass
import g_password
import g_friendlySaber
import g_friendlyFire
import g_saberInterpolate
import g_capturelimit
import g_timelimit
import g_duel_fraglimit
import g_fraglimit
import g_duelWeaponDisable
import g_fraglimitVoteCorrection
import g_allowDuelSuicide
import g_weaponDisable
import g_forcePowerDisable
import g_spawnInvulnerability
import g_forceRegenTime
import g_saberDamageScale
import g_slowmoDuelEnd
import g_logClientInfo
import g_saberBoxTraceSize
import g_saberAlwaysBoxTrace
import g_saberGhoul2Collision
import g_saberTraceSaberFirst
import g_saberLockFactor
import g_saberLocking
import g_privateDuel
import g_forceBasedTeams
import g_maxForceRank
import g_dmflags
import g_autoMapCycle
import g_trueJedi
import g_restarted
import g_maxGameClients
import g_maxclients
import g_cheats
import g_dedicated
import g_gametype
import g_vehicles
import g_vehicleTemplates
import vehicleId
import g_entities
import level
import Pickup_Team
import CheckTeamStatus
import TeamplayInfoMessage
import Team_GetLocationMsg
import Team_GetLocation
import SelectSagaSpawnPoint
import SelectCTFSpawnPoint
import Team_FreeEntity
import Team_ReturnFlag
import Team_InitGame
import Team_CheckHurtCarrier
import Team_FragBonuses
import Team_DroppedFlagThink
import AddTeamScore
import TeamColorString
import OtherTeamName
import TeamName
import OtherTeam
import BotAIStartFrame
import BotAIShutdownClient
import BotAISetupClient
import BotAILoadMap
import BotAIShutdown
import BotAISetup
import B_CleanupAlloc
import B_InitAlloc
import InFieldOfVision
import BotOrder
import OrgVisible
import InitSagaMode
import G_ClearClientLog
import G_LogExit
import G_LogWeaponOutput
import G_LogWeaponInit
import G_LogWeaponItem
import G_LogWeaponPowerup
import G_LogWeaponFrag
import G_LogWeaponDeath
import G_LogWeaponKill
import G_LogWeaponDamage
import G_LogWeaponFire
import G_LogWeaponPickup
import Jedi_DodgeEvasion
import ForceTelepathy
import ForceThrow
import ForceSeeing
import ForceTeamForceReplenish
import ForceTeamHeal
import ForceAbsorb
import ForceProtect
import ForceGrip
import ForceRage
import ForceSpeed
import ForceHeal
import ForcePowerUsableOn
import WP_ForcePowersUpdate
import WP_SpawnInitForcePowers
import WP_InitForcePowers
import WP_SaberInitBladeData
import WP_SaberCanBlock
import WP_SaberPositionUpdate
import WP_ForcePowerStop
import HasSetSaberOnly
import G_PreDefSound
import G_RefreshNextMap
import G_DoesMapSupportGametype
import BotInterbreedEndMatch
import Svcmd_BotList_f
import Svcmd_AddBot_f
import G_BotConnect
import G_RemoveQueuedBotBegin
import G_CheckBotSpawn
import G_GetBotInfoByName
import G_GetBotInfoByNumber
import G_InitBots
import UpdateTournamentInfo
import G_WriteSessionData
import G_InitWorldSession
import G_InitSessionData
import G_ReadSessionData
import Svcmd_GameMem_f
import G_InitMemory
import G_Alloc
import Team_CheckDroppedItem
import OnSameTeam
import G_RunClient
import ClientEndFrame
import ClientThink
import G_CheckClientTimeouts
import ClientCommand
import ClientBegin
import ClientDisconnect
import ClientUserinfoChanged
import ClientConnect
import G_GetStripEdString
import G_Error
import G_Printf
import SendScoreboardMessageToAllClients
import G_LogPrintf
import G_RunThink
import CheckTeamLeader
import SetLeader
import FindIntermissionPoint
import gSlowMoDuelTime
import gDoSlowMoDuel
import g_ff_objectives
import DeathmatchScoreboardMessage
import G_SetStats
import MoveClientToIntermission
import BlowDetpacks
import FireWeapon
import G_FilterPacket
import G_ProcessIPBans
import ConsoleCommand
import gJMSaberEnt
import SpotWouldTelefrag
import CalculateRanks
import AddScore
import player_die
import ClientSpawn
import InitBodyQue
import BeginIntermission
import respawn
import CopyToBodyQue
import SelectSpawnPoint
import SetClientViewAngle
import PickTeam
import TeamLeader
import TeamCount
import CheckGauntletAttack
import SnapVectorTowards
import CalcMuzzlePoint
import LogAccuracyHit
import WP_FireGenericBlasterMissile
import WP_FireTurretMissile
import G_CreateExampleAnimEnt
import G_PlayerBecomeATST
import ATST_ManageDamageBoxes
import TeleportPlayer
import trigger_teleporter_touch
import Touch_DoorTrigger
import G_RunMover
import WP_FireBlasterMissile
import G_ExplodeMissile
import G_BounceProjectile
import CreateMissile
import G_RunMissile
import G_ReflectMissile
import gGAvoidDismember
import G_CheckForDismemberment
import ExplodeDeath
import TossClientCubes
import TossClientItems
import TossClientWeapon
import body_die
import G_RadiusDamage
import G_Damage
import CanDamage
import trap_G2API_SetBoneAnim
import trap_G2API_GetGLAName
import trap_G2API_SetBoneAngles
import trap_G2API_CollisionDetect
import trap_G2API_CleanGhoul2Models
import trap_G2API_RemoveGhoul2Model
import trap_G2API_HasGhoul2ModelOnIndex
import trap_G2API_DuplicateGhoul2Instance
import trap_G2API_CopySpecificGhoul2Model
import trap_G2API_CopyGhoul2Instance
import trap_G2API_SetBoltInfo
import trap_G2API_AddBolt
import trap_G2API_InitGhoul2Model
import trap_G2API_GetBoltMatrix_NoRecNoRot
import trap_G2API_GetBoltMatrix_NoReconstruct
import trap_G2API_GetBoltMatrix
import trap_G2_HaveWeGhoul2Models
import trap_G2_SetGhoul2ModelIndexes
import trap_G2_ListModelBones
import trap_G2_ListModelSurfaces
import G_SkinIndex
import BuildShaderStateConfig
import AddRemap
import G_SetOrigin
import G_AddEvent
import G_AddPredictableEvent
import vtos
import tv
import G_RunObject
import G_TouchSolids
import G_TouchTriggers
import G_EntitiesFree
import G_FreeEntity
import G_KillG2Queue
import G_SendG2KillQueue
import TryUse
import G_EntitySound
import G_SoundAtLoc
import G_Sound
import G_MuteSound
import G_ScreenShake
import G_PlayEffect
import G_TempEntity
import G_Spawn
import G_InitGentity
import G_SetAngles
import G_SetMovedir
import G_UseTargets
import G_PickTarget
import G_RadiusList
import G_Find
import G_KillBox
import G_TeamCommand
import G_EffectIndex
import G_SoundIndex
import G_ModelIndex
import SaveRegisteredItems
import RegisterItem
import ClearRegisteredItems
import Touch_Item
import Add_Ammo
import ArmorIndex
import Think_Weapon
import FinishSpawningItem
import G_SpawnItem
import SetRespawn
import LaunchItem
import Drop_Item
import PrecacheItem
import UseHoldableItem
import RespawnItem
import G_RunItem
import G_CheckTeamItems
import ItemUse_MedPack
import ItemUse_Seeker
import ItemUse_Sentry
import ItemUse_Shield
import ItemUse_Binoculars
import G_GetDuelWinner
import Cmd_EngageDuel_f
import Cmd_ToggleSaber_f
import G_ItemUsable
import Cmd_SaberAttackCycle_f
import Cmd_FollowCycle_f
import SetTeam
import BroadcastTeamChange
import StopFollowing
import Cmd_Score_f
import G_NewString
import G_SpawnEntitiesFromString
import G_SpawnVector
import G_SpawnInt
import G_SpawnFloat
import G_SpawnString
import gEscapeTime
import gEscaping
import g2SaberInstance
import precachedKyle
import forcePowerDarkLight
import WeaponAttackAnim
import WeaponReadyAnim
import BG_OutOfMemory
import BG_StringAlloc
import BG_TempFree
import BG_TempAlloc
import BG_AllocUnaligned
import BG_Alloc
import BG_CanUseFPNow
import BG_HasYsalamiri
import BG_GetItemIndexByTag
import BG_ParseAnimationFile
import BG_PlayerTouchesItem
import BG_PlayerStateToEntityStateExtraPolate
import BG_PlayerStateToEntityState
import BG_TouchJumpPad
import BG_AddPredictableEventToPlayerstate
import BG_EvaluateTrajectoryDelta
import BG_EvaluateTrajectory
import BG_ForcePowerDrain
import BG_SaberStartTransAnim
import BG_InDeathAnim
import BG_InRoll
import BG_KnockawayForParry
import BG_BrokenParryForParry
import BG_BrokenParryForAttack
import BG_SaberInSpecialAttack
import BG_SpinningSaberAnim
import BG_FlippingAnim
import BG_SaberInIdle
import BG_SaberInSpecial
import BG_SaberInAttack
import BG_DirectFlippingAnim
import BG_InSaberStandAnim
import BG_InSpecialJump
import BG_LegalizedForcePowers
import saberMoveData
import BG_CanItemBeGrabbed
import BG_FindItemForHoldable
import BG_FindItemForPowerup
import BG_FindItemForWeapon
import BG_FindItem
import vectoyaw
import bg_numItems
import bg_itemlist
import PM_CalculateRelativeViewAngles
import Pmove
import PM_QuaternionViewAngles
import PM_UpdateViewAngles
import pm
import bgForcePowerCost
import forceMasteryPoints
import forceMasteryLevels
import bgGlobalAnimations
import BGPAFtextLoaded
import forcePowerSorted
import WP_MuzzlePoint
import ammoData
import weaponData
import VehicleInfo_GetNameForMovementType
import VehicleInfo_GetBitForMovementType
import VehicleInfo_GetNameForWeapon
import VehicleInfo_GetIndexForWeapon
import VehicleInfo_GetBitForWeapon
import VehicleInfo_GetBitForVehicleType
import Vehicle_CopyVehicle
import Vehicle_InitVehicle
import GetStringForID
import GetIDForString
import Q_irand
import irand
import flrand
import Rand_Init
import Com_Printf
import Com_Error
import Info_NextPair
import Info_Validate
import Info_SetValueForKey_Big
import Info_SetValueForKey
import Info_RemoveKey_big
import Info_RemoveKey
import Info_ValueForKey
import va
import Q_CleanStr
import Q_PrintStrlen
import Q_strcat
import Q_strncpyz
import Q_strrchr
import Q_strupr
import Q_strlwr
import Q_stricmpn
import Q_strncmp
import Q_stricmp
import Q_isalpha
import Q_isupper
import Q_islower
import Q_isprint
import Com_sprintf
import Parse3DMatrix
import Parse2DMatrix
import Parse1DMatrix
import SkipRestOfLine
import SkipBracedSection
import COM_MatchToken
import COM_ParseVec4
import COM_ParseFloat
import COM_ParseInt
import COM_ParseString
import COM_ParseWarning
import COM_ParseError
import COM_Compress
import COM_ParseExt
import COM_Parse
import SkipWhitespace
import COM_GetCurrentParseLine
import COM_BeginParseSession
import COM_DefaultExtension
import COM_StripExtension
import COM_SkipPath
import Com_Clamp
import MatrixToEuler
import QuatToAngles
import QuatMul
import AnglesToQuat
import AxisToQuaternion
import QuaternionToAxis
import QuaternionToEuler
import QuatToAxis
import QuaternionMultiply
import QuaternionNormalize
import QuaternionMagnitude
import QuaternionFromString
import AnglesToTieFloats
import AnglesFromTieFloats
import QuaternionToTieFloats
import QuaternionFromTieFloats
import QuaternionCopy
import PerpendicularVector
import AngleVectors
import RotationMatrixAroundDir
import MatrixMultiply
import MakeNormalVectors
import RotateAroundDirection
import RotatePointAroundVector
import ProjectPointOnPlane
import PlaneFromPoints
import AngleDelta
import AngleNormalize180
import AngleNormalize360
import AnglesSubtract
import AngleSubtract
import LerpAngle
import AngleMod
import BoxOnPlaneSide
import SetPlaneSignbits
import AxisCopy
import AxisClear
import AnglesToAxis
import vectoangles
import Q_crandom
import Q_random
import Q_rand
import Q_acos
import Q_log2
import VectorRotate
import Vector4Scale
import VectorNormalize2
import VectorNormalize
import CrossProduct
import VectorInverse
import VectorNormalizeFast
import DistanceSquared
import Distance
import VectorLengthSquared
import VectorLength
import VectorCompare
import AddPointToBounds
import ClearBounds
import RadiusFromBounds
import NormalizeColor
import ColorBytes4
import ColorBytes3
import _VectorMA
import _VectorScale
import _VectorCopy
import _VectorAdd
import _VectorSubtract
import _DotProduct
import ByteToDir
import DirToByte
import powf
import ClampShort
import ClampChar
import Q_rsqrt
import Q_fabs
import axisDefault
import vec3_origin
import g_color_table
import colorDkBlue
import colorLtBlue
import colorDkGrey
import colorMdGrey
import colorLtGrey
import colorWhite
import colorCyan
import colorMagenta
import colorYellow
import colorBlue
import colorGreen
import colorRed
import colorBlack
import colorTable
import bytedirs
import Com_Memcpy
import Com_Memset
import Hunk_Alloc
import forceSpeedLevels
import FloatSwap
import LongSwap
import ShortSwap
import acos
import fabs
import abs
import tan
import atan2
import cos
import sin
import sqrt
import floor
import ceil
import memcpy
import memset
import memmove
import sscanf
import vsprintf
import _atoi
import atoi
import _atof
import atof
import toupper
import tolower
import strncpy
import strstr
import strchr
import strcmp
import strcpy
import strcat
import strlen
import rand
import srand
import qsort
lit
align 1
LABELV $189
byte 1 112
byte 1 114
byte 1 105
byte 1 110
byte 1 116
byte 1 32
byte 1 34
byte 1 32
byte 1 32
byte 1 86
byte 1 101
byte 1 104
byte 1 105
byte 1 99
byte 1 108
byte 1 101
byte 1 58
byte 1 10
byte 1 34
byte 1 0
align 1
LABELV $188
byte 1 112
byte 1 114
byte 1 105
byte 1 110
byte 1 116
byte 1 32
byte 1 34
byte 1 86
byte 1 101
byte 1 104
byte 1 105
byte 1 99
byte 1 108
byte 1 101
byte 1 32
byte 1 84
byte 1 101
byte 1 109
byte 1 112
byte 1 108
byte 1 97
byte 1 116
byte 1 101
byte 1 115
byte 1 58
byte 1 10
byte 1 10
byte 1 34
byte 1 0
align 1
LABELV $179
byte 1 112
byte 1 114
byte 1 105
byte 1 110
byte 1 116
byte 1 32
byte 1 34
byte 1 32
byte 1 32
byte 1 32
byte 1 32
byte 1 78
byte 1 97
byte 1 109
byte 1 101
byte 1 58
byte 1 32
byte 1 32
byte 1 32
byte 1 32
byte 1 37
byte 1 115
byte 1 10
byte 1 92
byte 1 110
byte 1 34
byte 1 0
align 1
LABELV $178
byte 1 112
byte 1 114
byte 1 105
byte 1 110
byte 1 116
byte 1 32
byte 1 34
byte 1 32
byte 1 32
byte 1 86
byte 1 101
byte 1 104
byte 1 105
byte 1 99
byte 1 108
byte 1 101
byte 1 58
byte 1 32
byte 1 37
byte 1 100
byte 1 10
byte 1 34
byte 1 0
align 1
LABELV $171
byte 1 112
byte 1 114
byte 1 105
byte 1 110
byte 1 116
byte 1 32
byte 1 34
byte 1 86
byte 1 101
byte 1 104
byte 1 105
byte 1 99
byte 1 108
byte 1 101
byte 1 115
byte 1 58
byte 1 10
byte 1 10
byte 1 34
byte 1 0
align 1
LABELV $125
byte 1 71
byte 1 65
byte 1 77
byte 1 69
byte 1 58
byte 1 32
byte 1 83
byte 1 112
byte 1 97
byte 1 119
byte 1 110
byte 1 101
byte 1 100
byte 1 32
byte 1 118
byte 1 101
byte 1 104
byte 1 105
byte 1 99
byte 1 108
byte 1 101
byte 1 58
byte 1 32
byte 1 37
byte 1 115
byte 1 32
byte 1 97
byte 1 116
byte 1 32
byte 1 105
byte 1 110
byte 1 100
byte 1 101
byte 1 120
byte 1 32
byte 1 37
byte 1 100
byte 1 32
byte 1 119
byte 1 105
byte 1 116
byte 1 104
byte 1 32
byte 1 101
byte 1 110
byte 1 116
byte 1 105
byte 1 116
byte 1 121
byte 1 78
byte 1 117
byte 1 109
byte 1 32
byte 1 37
byte 1 100
byte 1 10
byte 1 0
align 1
LABELV $122
byte 1 118
byte 1 101
byte 1 104
byte 1 105
byte 1 99
byte 1 108
byte 1 101
byte 1 83
byte 1 112
byte 1 97
byte 1 119
byte 1 110
byte 1 67
byte 1 71
byte 1 32
byte 1 37
byte 1 100
byte 1 32
byte 1 37
byte 1 100
byte 1 32
byte 1 37
byte 1 100
byte 1 10
byte 1 0
align 1
LABELV $111
byte 1 86
byte 1 101
byte 1 104
byte 1 105
byte 1 99
byte 1 108
byte 1 101
byte 1 0
align 1
LABELV $95
byte 1 86
byte 1 101
byte 1 104
byte 1 105
byte 1 99
byte 1 108
byte 1 101
byte 1 58
byte 1 32
byte 1 84
byte 1 111
byte 1 117
byte 1 99
byte 1 104
byte 1 101
byte 1 100
byte 1 46
byte 1 10
byte 1 0
