data
align 4
LABELV playerMins
byte 4 3245342720
byte 4 3245342720
byte 4 3250585600
align 4
LABELV playerMaxs
byte 4 1097859072
byte 4 1097859072
byte 4 1109393408
export SP_info_player_deathmatch
code
proc SP_info_player_deathmatch 8 12
file "../g_client.c"
line 20
;1:// Copyright (C) 1999-2000 Id Software, Inc.
;2://
;3:#include "g_local.h"
;4:#include "..\ghoul2\g2.h"
;5:
;6:// g_client.c -- client functions that don't happen every frame
;7:
;8:static vec3_t	playerMins = {-15, -15, DEFAULT_MINS_2};
;9:static vec3_t	playerMaxs = {15, 15, DEFAULT_MAXS_2};
;10:
;11:forcedata_t Client_Force[MAX_CLIENTS];
;12:
;13:/*QUAKED info_player_deathmatch (1 0 1) (-16 -16 -24) (16 16 32) initial
;14:potential spawning position for deathmatch games.
;15:The first time a player enters the game, they will be at an 'initial' spot.
;16:Targets will be fired when someone spawns in on them.
;17:"nobots" will prevent bots from using this spot.
;18:"nohumans" will prevent non-bots from using this spot.
;19:*/
;20:void SP_info_player_deathmatch( gentity_t *ent ) {
line 23
;21:	int		i;
;22:
;23:	G_SpawnInt( "nobots", "0", &i);
ADDRGP4 $90
ARGP4
ADDRGP4 $91
ARGP4
ADDRLP4 0
ARGP4
ADDRGP4 G_SpawnInt
CALLI4
pop
line 24
;24:	if ( i ) {
ADDRLP4 0
INDIRI4
CNSTI4 0
EQI4 $92
line 25
;25:		ent->flags |= FL_NO_BOTS;
ADDRLP4 4
ADDRFP4 0
INDIRP4
CNSTI4 472
ADDP4
ASGNP4
ADDRLP4 4
INDIRP4
ADDRLP4 4
INDIRP4
INDIRI4
CNSTI4 8192
BORI4
ASGNI4
line 26
;26:	}
LABELV $92
line 27
;27:	G_SpawnInt( "nohumans", "0", &i );
ADDRGP4 $94
ARGP4
ADDRGP4 $91
ARGP4
ADDRLP4 0
ARGP4
ADDRGP4 G_SpawnInt
CALLI4
pop
line 28
;28:	if ( i ) {
ADDRLP4 0
INDIRI4
CNSTI4 0
EQI4 $95
line 29
;29:		ent->flags |= FL_NO_HUMANS;
ADDRLP4 4
ADDRFP4 0
INDIRP4
CNSTI4 472
ADDP4
ASGNP4
ADDRLP4 4
INDIRP4
ADDRLP4 4
INDIRP4
INDIRI4
CNSTI4 16384
BORI4
ASGNI4
line 30
;30:	}
LABELV $95
line 31
;31:}
LABELV $89
endproc SP_info_player_deathmatch 8 12
export SP_info_player_start
proc SP_info_player_start 0 4
line 36
;32:
;33:/*QUAKED info_player_start (1 0 0) (-16 -16 -24) (16 16 32)
;34:equivelant to info_player_deathmatch
;35:*/
;36:void SP_info_player_start(gentity_t *ent) {
line 37
;37:	ent->classname = "info_player_deathmatch";
ADDRFP4 0
INDIRP4
CNSTI4 416
ADDP4
ADDRGP4 $98
ASGNP4
line 38
;38:	SP_info_player_deathmatch( ent );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 SP_info_player_deathmatch
CALLV
pop
line 39
;39:}
LABELV $97
endproc SP_info_player_start 0 4
export SP_info_player_imperial
proc SP_info_player_imperial 0 4
line 44
;40:
;41:/*QUAKED info_player_imperial (1 0 0) (-16 -16 -24) (16 16 32)
;42:saga start point - imperial
;43:*/
;44:void SP_info_player_imperial(gentity_t *ent) {
line 45
;45:	if (g_gametype.integer != GT_SAGA)
ADDRGP4 g_gametype+12
INDIRI4
CNSTI4 6
EQI4 $100
line 46
;46:	{ //turn into a DM spawn if not in saga game mode
line 47
;47:		ent->classname = "info_player_deathmatch";
ADDRFP4 0
INDIRP4
CNSTI4 416
ADDP4
ADDRGP4 $98
ASGNP4
line 48
;48:		SP_info_player_deathmatch( ent );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 SP_info_player_deathmatch
CALLV
pop
line 49
;49:	}
LABELV $100
line 50
;50:}
LABELV $99
endproc SP_info_player_imperial 0 4
export SP_info_player_rebel
proc SP_info_player_rebel 0 4
line 55
;51:
;52:/*QUAKED info_player_rebel (1 0 0) (-16 -16 -24) (16 16 32)
;53:saga start point - rebel
;54:*/
;55:void SP_info_player_rebel(gentity_t *ent) {
line 56
;56:	if (g_gametype.integer != GT_SAGA)
ADDRGP4 g_gametype+12
INDIRI4
CNSTI4 6
EQI4 $104
line 57
;57:	{ //turn into a DM spawn if not in saga game mode
line 58
;58:		ent->classname = "info_player_deathmatch";
ADDRFP4 0
INDIRP4
CNSTI4 416
ADDP4
ADDRGP4 $98
ASGNP4
line 59
;59:		SP_info_player_deathmatch( ent );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 SP_info_player_deathmatch
CALLV
pop
line 60
;60:	}
LABELV $104
line 61
;61:}
LABELV $103
endproc SP_info_player_rebel 0 4
export SP_info_player_intermission
proc SP_info_player_intermission 0 0
line 66
;62:
;63:/*QUAKED info_player_intermission (1 0 1) (-16 -16 -24) (16 16 32)
;64:The intermission will be viewed from this point.  Target an info_notnull for the view direction.
;65:*/
;66:void SP_info_player_intermission( gentity_t *ent ) {
line 68
;67:
;68:}
LABELV $107
endproc SP_info_player_intermission 0 0
export ThrowSaberToAttacker
proc ThrowSaberToAttacker 68 8
line 73
;69:
;70:#define JMSABER_RESPAWN_TIME 20000 //in case it gets stuck somewhere no one can reach
;71:
;72:void ThrowSaberToAttacker(gentity_t *self, gentity_t *attacker)
;73:{
line 74
;74:	gentity_t *ent = &g_entities[self->client->ps.saberIndex];
ADDRLP4 0
CNSTI4 828
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 620
ADDP4
INDIRI4
MULI4
ADDRGP4 g_entities
ADDP4
ASGNP4
line 76
;75:	vec3_t a;
;76:	int altVelocity = 0;
ADDRLP4 16
CNSTI4 0
ASGNI4
line 78
;77:
;78:	if (!ent || ent->enemy != self)
ADDRLP4 0
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $111
ADDRLP4 0
INDIRP4
CNSTI4 728
ADDP4
INDIRP4
CVPU4 4
ADDRFP4 0
INDIRP4
CVPU4 4
EQU4 $109
LABELV $111
line 79
;79:	{ //something has gone very wrong (this should never happen)
line 84
;80:		//but in case it does.. find the saber manually
;81:#ifdef _DEBUG
;82:		Com_Printf("Lost the saber! Attempting to use global pointer..\n");
;83:#endif
;84:		ent = gJMSaberEnt;
ADDRLP4 0
ADDRGP4 gJMSaberEnt
INDIRP4
ASGNP4
line 86
;85:
;86:		if (!ent)
ADDRLP4 0
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $112
line 87
;87:		{
line 91
;88:#ifdef _DEBUG
;89:			Com_Printf("The global pointer was NULL. This is a bad thing.\n");
;90:#endif
;91:			return;
ADDRGP4 $108
JUMPV
LABELV $112
line 98
;92:		}
;93:
;94:#ifdef _DEBUG
;95:		Com_Printf("Got it (%i). Setting enemy to client %i.\n", ent->s.number, self->s.number);
;96:#endif
;97:
;98:		ent->enemy = self;
ADDRLP4 0
INDIRP4
CNSTI4 728
ADDP4
ADDRFP4 0
INDIRP4
ASGNP4
line 99
;99:		self->client->ps.saberIndex = ent->s.number;
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 620
ADDP4
ADDRLP4 0
INDIRP4
INDIRI4
ASGNI4
line 100
;100:	}
LABELV $109
line 102
;101:
;102:	trap_SetConfigstring ( CS_CLIENT_JEDIMASTER, "-1" );
CNSTI4 28
ARGI4
ADDRGP4 $114
ARGP4
ADDRGP4 trap_SetConfigstring
CALLV
pop
line 104
;103:
;104:	if (attacker && attacker->client && self->client->ps.saberInFlight)
ADDRLP4 24
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 28
CNSTU4 0
ASGNU4
ADDRLP4 24
INDIRP4
CVPU4 4
ADDRLP4 28
INDIRU4
EQU4 $115
ADDRLP4 32
CNSTI4 408
ASGNI4
ADDRLP4 24
INDIRP4
ADDRLP4 32
INDIRI4
ADDP4
INDIRP4
CVPU4 4
ADDRLP4 28
INDIRU4
EQU4 $115
ADDRFP4 0
INDIRP4
ADDRLP4 32
INDIRI4
ADDP4
INDIRP4
CNSTI4 504
ADDP4
INDIRI4
CNSTI4 0
EQI4 $115
line 105
;105:	{ //someone killed us and we had the saber thrown, so actually move this saber to the saber location
line 108
;106:	  //if we killed ourselves with saber thrown, however, same suicide rules of respawning at spawn spot still
;107:	  //apply.
;108:		gentity_t *flyingsaber = &g_entities[self->client->ps.saberEntityNum];
ADDRLP4 36
CNSTI4 828
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 544
ADDP4
INDIRI4
MULI4
ADDRGP4 g_entities
ADDP4
ASGNP4
line 110
;109:
;110:		if (flyingsaber && flyingsaber->inuse)
ADDRLP4 36
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $117
ADDRLP4 36
INDIRP4
CNSTI4 412
ADDP4
INDIRI4
CNSTI4 0
EQI4 $117
line 111
;111:		{
line 112
;112:			VectorCopy(flyingsaber->s.pos.trBase, ent->s.pos.trBase);
ADDRLP4 44
CNSTI4 24
ASGNI4
ADDRLP4 0
INDIRP4
ADDRLP4 44
INDIRI4
ADDP4
ADDRLP4 36
INDIRP4
ADDRLP4 44
INDIRI4
ADDP4
INDIRB
ASGNB 12
line 113
;113:			VectorCopy(flyingsaber->s.pos.trDelta, ent->s.pos.trDelta);
ADDRLP4 48
CNSTI4 36
ASGNI4
ADDRLP4 0
INDIRP4
ADDRLP4 48
INDIRI4
ADDP4
ADDRLP4 36
INDIRP4
ADDRLP4 48
INDIRI4
ADDP4
INDIRB
ASGNB 12
line 114
;114:			VectorCopy(flyingsaber->s.apos.trBase, ent->s.apos.trBase);
ADDRLP4 52
CNSTI4 60
ASGNI4
ADDRLP4 0
INDIRP4
ADDRLP4 52
INDIRI4
ADDP4
ADDRLP4 36
INDIRP4
ADDRLP4 52
INDIRI4
ADDP4
INDIRB
ASGNB 12
line 115
;115:			VectorCopy(flyingsaber->s.apos.trDelta, ent->s.apos.trDelta);
ADDRLP4 56
CNSTI4 72
ASGNI4
ADDRLP4 0
INDIRP4
ADDRLP4 56
INDIRI4
ADDP4
ADDRLP4 36
INDIRP4
ADDRLP4 56
INDIRI4
ADDP4
INDIRB
ASGNB 12
line 117
;116:
;117:			VectorCopy(flyingsaber->r.currentOrigin, ent->r.currentOrigin);
ADDRLP4 60
CNSTI4 368
ASGNI4
ADDRLP4 0
INDIRP4
ADDRLP4 60
INDIRI4
ADDP4
ADDRLP4 36
INDIRP4
ADDRLP4 60
INDIRI4
ADDP4
INDIRB
ASGNB 12
line 118
;118:			VectorCopy(flyingsaber->r.currentAngles, ent->r.currentAngles);
ADDRLP4 64
CNSTI4 380
ASGNI4
ADDRLP4 0
INDIRP4
ADDRLP4 64
INDIRI4
ADDP4
ADDRLP4 36
INDIRP4
ADDRLP4 64
INDIRI4
ADDP4
INDIRB
ASGNB 12
line 119
;119:			altVelocity = 1;
ADDRLP4 16
CNSTI4 1
ASGNI4
line 120
;120:		}
LABELV $117
line 121
;121:	}
LABELV $115
line 123
;122:
;123:	self->client->ps.saberInFlight = qtrue; //say he threw it anyway in order to properly remove from dead body
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 504
ADDP4
CNSTI4 1
ASGNI4
line 125
;124:
;125:	ent->s.modelindex = G_ModelIndex("models/weapons2/saber/saber_w.glm");
ADDRGP4 $119
ARGP4
ADDRLP4 36
ADDRGP4 G_ModelIndex
CALLI4
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 212
ADDP4
ADDRLP4 36
INDIRI4
ASGNI4
line 126
;126:	ent->s.eFlags &= ~(EF_NODRAW);
ADDRLP4 40
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
ASGNP4
ADDRLP4 40
INDIRP4
ADDRLP4 40
INDIRP4
INDIRI4
CNSTI4 -129
BANDI4
ASGNI4
line 127
;127:	ent->s.modelGhoul2 = 1;
ADDRLP4 0
INDIRP4
CNSTI4 204
ADDP4
CNSTI4 1
ASGNI4
line 128
;128:	ent->s.eType = ET_MISSILE;
ADDRLP4 0
INDIRP4
CNSTI4 4
ADDP4
CNSTI4 3
ASGNI4
line 129
;129:	ent->enemy = NULL;
ADDRLP4 0
INDIRP4
CNSTI4 728
ADDP4
CNSTP4 0
ASGNP4
line 131
;130:
;131:	if (!attacker || !attacker->client)
ADDRLP4 44
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 48
CNSTU4 0
ASGNU4
ADDRLP4 44
INDIRP4
CVPU4 4
ADDRLP4 48
INDIRU4
EQU4 $122
ADDRLP4 44
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CVPU4 4
ADDRLP4 48
INDIRU4
NEU4 $120
LABELV $122
line 132
;132:	{
line 133
;133:		VectorCopy(ent->s.origin2, ent->s.pos.trBase);
ADDRLP4 0
INDIRP4
CNSTI4 24
ADDP4
ADDRLP4 0
INDIRP4
CNSTI4 104
ADDP4
INDIRB
ASGNB 12
line 134
;134:		VectorCopy(ent->s.origin2, ent->s.origin);
ADDRLP4 0
INDIRP4
CNSTI4 92
ADDP4
ADDRLP4 0
INDIRP4
CNSTI4 104
ADDP4
INDIRB
ASGNB 12
line 135
;135:		VectorCopy(ent->s.origin2, ent->r.currentOrigin);
ADDRLP4 0
INDIRP4
CNSTI4 368
ADDP4
ADDRLP4 0
INDIRP4
CNSTI4 104
ADDP4
INDIRB
ASGNB 12
line 136
;136:		ent->pos2[0] = 0;
ADDRLP4 0
INDIRP4
CNSTI4 560
ADDP4
CNSTF4 0
ASGNF4
line 137
;137:		trap_LinkEntity(ent);
ADDRLP4 0
INDIRP4
ARGP4
ADDRGP4 trap_LinkEntity
CALLV
pop
line 138
;138:		return;
ADDRGP4 $108
JUMPV
LABELV $120
line 141
;139:	}
;140:
;141:	if (!altVelocity)
ADDRLP4 16
INDIRI4
CNSTI4 0
NEI4 $123
line 142
;142:	{
line 143
;143:		VectorCopy(self->s.pos.trBase, ent->s.pos.trBase);
ADDRLP4 52
CNSTI4 24
ASGNI4
ADDRLP4 0
INDIRP4
ADDRLP4 52
INDIRI4
ADDP4
ADDRFP4 0
INDIRP4
ADDRLP4 52
INDIRI4
ADDP4
INDIRB
ASGNB 12
line 144
;144:		VectorCopy(self->s.pos.trBase, ent->s.origin);
ADDRLP4 0
INDIRP4
CNSTI4 92
ADDP4
ADDRFP4 0
INDIRP4
CNSTI4 24
ADDP4
INDIRB
ASGNB 12
line 145
;145:		VectorCopy(self->s.pos.trBase, ent->r.currentOrigin);
ADDRLP4 0
INDIRP4
CNSTI4 368
ADDP4
ADDRFP4 0
INDIRP4
CNSTI4 24
ADDP4
INDIRB
ASGNB 12
line 147
;146:
;147:		VectorSubtract(attacker->client->ps.origin, ent->s.pos.trBase, a);
ADDRLP4 56
ADDRFP4 4
INDIRP4
CNSTI4 408
ADDP4
ASGNP4
ADDRLP4 64
CNSTI4 24
ASGNI4
ADDRLP4 4
ADDRLP4 56
INDIRP4
INDIRP4
CNSTI4 20
ADDP4
INDIRF4
ADDRLP4 0
INDIRP4
ADDRLP4 64
INDIRI4
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 4+4
ADDRLP4 56
INDIRP4
INDIRP4
ADDRLP4 64
INDIRI4
ADDP4
INDIRF4
ADDRLP4 0
INDIRP4
CNSTI4 28
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 4+8
ADDRFP4 4
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 28
ADDP4
INDIRF4
ADDRLP4 0
INDIRP4
CNSTI4 32
ADDP4
INDIRF4
SUBF4
ASGNF4
line 149
;148:
;149:		VectorNormalize(a);
ADDRLP4 4
ARGP4
ADDRGP4 VectorNormalize
CALLF4
pop
line 151
;150:
;151:		ent->s.pos.trDelta[0] = a[0]*256;
ADDRLP4 0
INDIRP4
CNSTI4 36
ADDP4
CNSTF4 1132462080
ADDRLP4 4
INDIRF4
MULF4
ASGNF4
line 152
;152:		ent->s.pos.trDelta[1] = a[1]*256;
ADDRLP4 0
INDIRP4
CNSTI4 40
ADDP4
CNSTF4 1132462080
ADDRLP4 4+4
INDIRF4
MULF4
ASGNF4
line 153
;153:		ent->s.pos.trDelta[2] = 256;
ADDRLP4 0
INDIRP4
CNSTI4 44
ADDP4
CNSTF4 1132462080
ASGNF4
line 154
;154:	}
LABELV $123
line 156
;155:
;156:	trap_LinkEntity(ent);
ADDRLP4 0
INDIRP4
ARGP4
ADDRGP4 trap_LinkEntity
CALLV
pop
line 157
;157:}
LABELV $108
endproc ThrowSaberToAttacker 68 8
export JMSaberThink
proc JMSaberThink 28 4
line 160
;158:
;159:void JMSaberThink(gentity_t *ent)
;160:{
line 161
;161:	gJMSaberEnt = ent;
ADDRGP4 gJMSaberEnt
ADDRFP4 0
INDIRP4
ASGNP4
line 163
;162:
;163:	if (ent->enemy)
ADDRFP4 0
INDIRP4
CNSTI4 728
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $129
line 164
;164:	{
line 165
;165:		if (!ent->enemy->client || !ent->enemy->inuse)
ADDRLP4 0
ADDRFP4 0
INDIRP4
CNSTI4 728
ADDP4
INDIRP4
ASGNP4
ADDRLP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $133
ADDRLP4 0
INDIRP4
CNSTI4 412
ADDP4
INDIRI4
CNSTI4 0
NEI4 $131
LABELV $133
line 166
;166:		{ //disconnected?
line 167
;167:			VectorCopy(ent->enemy->s.pos.trBase, ent->s.pos.trBase);
ADDRLP4 4
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 8
CNSTI4 24
ASGNI4
ADDRLP4 4
INDIRP4
ADDRLP4 8
INDIRI4
ADDP4
ADDRLP4 4
INDIRP4
CNSTI4 728
ADDP4
INDIRP4
ADDRLP4 8
INDIRI4
ADDP4
INDIRB
ASGNB 12
line 168
;168:			VectorCopy(ent->enemy->s.pos.trBase, ent->s.origin);
ADDRLP4 12
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 12
INDIRP4
CNSTI4 92
ADDP4
ADDRLP4 12
INDIRP4
CNSTI4 728
ADDP4
INDIRP4
CNSTI4 24
ADDP4
INDIRB
ASGNB 12
line 169
;169:			VectorCopy(ent->enemy->s.pos.trBase, ent->r.currentOrigin);
ADDRLP4 16
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 16
INDIRP4
CNSTI4 368
ADDP4
ADDRLP4 16
INDIRP4
CNSTI4 728
ADDP4
INDIRP4
CNSTI4 24
ADDP4
INDIRB
ASGNB 12
line 170
;170:			ent->s.modelindex = G_ModelIndex("models/weapons2/saber/saber_w.glm");
ADDRGP4 $119
ARGP4
ADDRLP4 20
ADDRGP4 G_ModelIndex
CALLI4
ASGNI4
ADDRFP4 0
INDIRP4
CNSTI4 212
ADDP4
ADDRLP4 20
INDIRI4
ASGNI4
line 171
;171:			ent->s.eFlags &= ~(EF_NODRAW);
ADDRLP4 24
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
ASGNP4
ADDRLP4 24
INDIRP4
ADDRLP4 24
INDIRP4
INDIRI4
CNSTI4 -129
BANDI4
ASGNI4
line 172
;172:			ent->s.modelGhoul2 = 1;
ADDRFP4 0
INDIRP4
CNSTI4 204
ADDP4
CNSTI4 1
ASGNI4
line 173
;173:			ent->s.eType = ET_MISSILE;
ADDRFP4 0
INDIRP4
CNSTI4 4
ADDP4
CNSTI4 3
ASGNI4
line 174
;174:			ent->enemy = NULL;
ADDRFP4 0
INDIRP4
CNSTI4 728
ADDP4
CNSTP4 0
ASGNP4
line 176
;175:
;176:			ent->pos2[0] = 1;
ADDRFP4 0
INDIRP4
CNSTI4 560
ADDP4
CNSTF4 1065353216
ASGNF4
line 177
;177:			ent->pos2[1] = 0; //respawn next think
ADDRFP4 0
INDIRP4
CNSTI4 564
ADDP4
CNSTF4 0
ASGNF4
line 178
;178:			trap_LinkEntity(ent);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 trap_LinkEntity
CALLV
pop
line 179
;179:		}
ADDRGP4 $130
JUMPV
LABELV $131
line 181
;180:		else
;181:		{
line 182
;182:			ent->pos2[1] = level.time + JMSABER_RESPAWN_TIME;
ADDRFP4 0
INDIRP4
CNSTI4 564
ADDP4
ADDRGP4 level+32
INDIRI4
CNSTI4 20000
ADDI4
CVIF4 4
ASGNF4
line 183
;183:		}
line 184
;184:	}
ADDRGP4 $130
JUMPV
LABELV $129
line 185
;185:	else if (ent->pos2[0] && ent->pos2[1] < level.time)
ADDRLP4 0
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 0
INDIRP4
CNSTI4 560
ADDP4
INDIRF4
CNSTF4 0
EQF4 $135
ADDRLP4 0
INDIRP4
CNSTI4 564
ADDP4
INDIRF4
ADDRGP4 level+32
INDIRI4
CVIF4 4
GEF4 $135
line 186
;186:	{
line 187
;187:		VectorCopy(ent->s.origin2, ent->s.pos.trBase);
ADDRLP4 4
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 4
INDIRP4
CNSTI4 24
ADDP4
ADDRLP4 4
INDIRP4
CNSTI4 104
ADDP4
INDIRB
ASGNB 12
line 188
;188:		VectorCopy(ent->s.origin2, ent->s.origin);
ADDRLP4 8
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 8
INDIRP4
CNSTI4 92
ADDP4
ADDRLP4 8
INDIRP4
CNSTI4 104
ADDP4
INDIRB
ASGNB 12
line 189
;189:		VectorCopy(ent->s.origin2, ent->r.currentOrigin);
ADDRLP4 12
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 12
INDIRP4
CNSTI4 368
ADDP4
ADDRLP4 12
INDIRP4
CNSTI4 104
ADDP4
INDIRB
ASGNB 12
line 190
;190:		ent->pos2[0] = 0;
ADDRFP4 0
INDIRP4
CNSTI4 560
ADDP4
CNSTF4 0
ASGNF4
line 191
;191:		trap_LinkEntity(ent);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 trap_LinkEntity
CALLV
pop
line 192
;192:	}
LABELV $135
LABELV $130
line 194
;193:
;194:	ent->nextthink = level.time + 50;
ADDRFP4 0
INDIRP4
CNSTI4 632
ADDP4
ADDRGP4 level+32
INDIRI4
CNSTI4 50
ADDI4
ASGNI4
line 195
;195:	G_RunObject(ent);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 G_RunObject
CALLV
pop
line 196
;196:}
LABELV $128
endproc JMSaberThink 28 4
export JMSaberTouch
proc JMSaberTouch 36 12
line 199
;197:
;198:void JMSaberTouch(gentity_t *self, gentity_t *other, trace_t *trace)
;199:{
line 200
;200:	int i = 0;
ADDRLP4 0
CNSTI4 0
ASGNI4
line 203
;201://	gentity_t *te;
;202:
;203:	if (!other || !other->client || other->health < 1)
ADDRLP4 4
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 8
CNSTU4 0
ASGNU4
ADDRLP4 4
INDIRP4
CVPU4 4
ADDRLP4 8
INDIRU4
EQU4 $143
ADDRLP4 4
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CVPU4 4
ADDRLP4 8
INDIRU4
EQU4 $143
ADDRLP4 4
INDIRP4
CNSTI4 676
ADDP4
INDIRI4
CNSTI4 1
GEI4 $140
LABELV $143
line 204
;204:	{
line 205
;205:		return;
ADDRGP4 $139
JUMPV
LABELV $140
line 208
;206:	}
;207:
;208:	if (self->enemy)
ADDRFP4 0
INDIRP4
CNSTI4 728
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $144
line 209
;209:	{
line 210
;210:		return;
ADDRGP4 $139
JUMPV
LABELV $144
line 213
;211:	}
;212:
;213:	if (!self->s.modelindex)
ADDRFP4 0
INDIRP4
CNSTI4 212
ADDP4
INDIRI4
CNSTI4 0
NEI4 $146
line 214
;214:	{
line 215
;215:		return;
ADDRGP4 $139
JUMPV
LABELV $146
line 218
;216:	}
;217:
;218:	if (other->client->ps.stats[STAT_WEAPONS] & (1 << WP_SABER))
ADDRFP4 4
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 232
ADDP4
INDIRI4
CNSTI4 4
BANDI4
CNSTI4 0
EQI4 $148
line 219
;219:	{
line 220
;220:		return;
ADDRGP4 $139
JUMPV
LABELV $148
line 223
;221:	}
;222:
;223:	if (other->client->ps.isJediMaster)
ADDRFP4 4
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 604
ADDP4
INDIRI4
CNSTI4 0
EQI4 $150
line 224
;224:	{
line 225
;225:		return;
ADDRGP4 $139
JUMPV
LABELV $150
line 228
;226:	}
;227:
;228:	self->enemy = other;
ADDRFP4 0
INDIRP4
CNSTI4 728
ADDP4
ADDRFP4 4
INDIRP4
ASGNP4
line 229
;229:	other->client->ps.stats[STAT_WEAPONS] = (1 << WP_SABER);
ADDRFP4 4
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 232
ADDP4
CNSTI4 4
ASGNI4
line 230
;230:	other->client->ps.weapon = WP_SABER;
ADDRFP4 4
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 148
ADDP4
CNSTI4 2
ASGNI4
line 231
;231:	other->s.weapon = WP_SABER;
ADDRFP4 4
INDIRP4
CNSTI4 276
ADDP4
CNSTI4 2
ASGNI4
line 232
;232:	G_AddEvent(other, EV_BECOME_JEDIMASTER, 0);
ADDRFP4 4
INDIRP4
ARGP4
CNSTI4 30
ARGI4
CNSTI4 0
ARGI4
ADDRGP4 G_AddEvent
CALLV
pop
line 235
;233:
;234:	// Track the jedi master 
;235:	trap_SetConfigstring ( CS_CLIENT_JEDIMASTER, va("%i", other->s.number ) );
ADDRGP4 $152
ARGP4
ADDRFP4 4
INDIRP4
INDIRI4
ARGI4
ADDRLP4 12
ADDRGP4 va
CALLP4
ASGNP4
CNSTI4 28
ARGI4
ADDRLP4 12
INDIRP4
ARGP4
ADDRGP4 trap_SetConfigstring
CALLV
pop
line 237
;236:
;237:	if (g_spawnInvulnerability.integer)
ADDRGP4 g_spawnInvulnerability+12
INDIRI4
CNSTI4 0
EQI4 $153
line 238
;238:	{
line 239
;239:		other->client->ps.eFlags |= EF_INVULNERABLE;
ADDRLP4 16
ADDRFP4 4
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 108
ADDP4
ASGNP4
ADDRLP4 16
INDIRP4
ADDRLP4 16
INDIRP4
INDIRI4
CNSTI4 67108864
BORI4
ASGNI4
line 240
;240:		other->client->invulnerableTimer = level.time + g_spawnInvulnerability.integer;
ADDRFP4 4
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 1580
ADDP4
ADDRGP4 level+32
INDIRI4
ADDRGP4 g_spawnInvulnerability+12
INDIRI4
ADDI4
ASGNI4
line 241
;241:	}
LABELV $153
line 243
;242:
;243:	trap_SendServerCommand( -1, va("cp \"%s %s\n\"", other->client->pers.netname, G_GetStripEdString("SVINGAME", "BECOMEJM")) );
ADDRGP4 $159
ARGP4
ADDRGP4 $160
ARGP4
ADDRLP4 16
ADDRGP4 G_GetStripEdString
CALLP4
ASGNP4
ADDRGP4 $158
ARGP4
ADDRFP4 4
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 1428
ADDP4
ARGP4
ADDRLP4 16
INDIRP4
ARGP4
ADDRLP4 20
ADDRGP4 va
CALLP4
ASGNP4
CNSTI4 -1
ARGI4
ADDRLP4 20
INDIRP4
ARGP4
ADDRGP4 trap_SendServerCommand
CALLV
pop
line 245
;244:
;245:	other->client->ps.isJediMaster = qtrue;
ADDRFP4 4
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 604
ADDP4
CNSTI4 1
ASGNI4
line 246
;246:	other->client->ps.saberIndex = self->s.number;
ADDRFP4 4
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 620
ADDP4
ADDRFP4 0
INDIRP4
INDIRI4
ASGNI4
line 248
;247:
;248:	if (other->health < 200 && other->health > 0)
ADDRLP4 24
ADDRFP4 4
INDIRP4
CNSTI4 676
ADDP4
INDIRI4
ASGNI4
ADDRLP4 24
INDIRI4
CNSTI4 200
GEI4 $161
ADDRLP4 24
INDIRI4
CNSTI4 0
LEI4 $161
line 249
;249:	{ //full health when you become the Jedi Master
line 250
;250:		other->client->ps.stats[STAT_HEALTH] = other->health = 200;
ADDRLP4 28
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 32
CNSTI4 200
ASGNI4
ADDRLP4 28
INDIRP4
CNSTI4 676
ADDP4
ADDRLP4 32
INDIRI4
ASGNI4
ADDRLP4 28
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 216
ADDP4
ADDRLP4 32
INDIRI4
ASGNI4
line 251
;251:	}
LABELV $161
line 253
;252:
;253:	if (other->client->ps.fd.forcePower < 100)
ADDRFP4 4
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 932
ADDP4
INDIRI4
CNSTI4 100
GEI4 $166
line 254
;254:	{
line 255
;255:		other->client->ps.fd.forcePower = 100;
ADDRFP4 4
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 932
ADDP4
CNSTI4 100
ASGNI4
line 256
;256:	}
ADDRGP4 $166
JUMPV
LABELV $165
line 259
;257:
;258:	while (i < NUM_FORCE_POWERS)
;259:	{
line 260
;260:		other->client->ps.fd.forcePowersKnown |= (1 << i);
ADDRLP4 28
ADDRFP4 4
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 844
ADDP4
ASGNP4
ADDRLP4 28
INDIRP4
ADDRLP4 28
INDIRP4
INDIRI4
CNSTI4 1
ADDRLP4 0
INDIRI4
LSHI4
BORI4
ASGNI4
line 261
;261:		other->client->ps.fd.forcePowerLevel[i] = FORCE_LEVEL_3;
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRFP4 4
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 944
ADDP4
ADDP4
CNSTI4 3
ASGNI4
line 263
;262:
;263:		i++;
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 264
;264:	}
LABELV $166
line 258
ADDRLP4 0
INDIRI4
CNSTI4 18
LTI4 $165
line 266
;265:
;266:	self->pos2[0] = 1;
ADDRFP4 0
INDIRP4
CNSTI4 560
ADDP4
CNSTF4 1065353216
ASGNF4
line 267
;267:	self->pos2[1] = level.time + JMSABER_RESPAWN_TIME;
ADDRFP4 0
INDIRP4
CNSTI4 564
ADDP4
ADDRGP4 level+32
INDIRI4
CNSTI4 20000
ADDI4
CVIF4 4
ASGNF4
line 269
;268:
;269:	self->s.modelindex = 0;
ADDRFP4 0
INDIRP4
CNSTI4 212
ADDP4
CNSTI4 0
ASGNI4
line 270
;270:	self->s.eFlags |= EF_NODRAW;
ADDRLP4 28
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
ASGNP4
ADDRLP4 28
INDIRP4
ADDRLP4 28
INDIRP4
INDIRI4
CNSTI4 128
BORI4
ASGNI4
line 271
;271:	self->s.modelGhoul2 = 0;
ADDRFP4 0
INDIRP4
CNSTI4 204
ADDP4
CNSTI4 0
ASGNI4
line 272
;272:	self->s.eType = ET_GENERAL;
ADDRFP4 0
INDIRP4
CNSTI4 4
ADDP4
CNSTI4 0
ASGNI4
line 279
;273:
;274:	/*
;275:	te = G_TempEntity( vec3_origin, EV_DESTROY_GHOUL2_INSTANCE );
;276:	te->r.svFlags |= SVF_BROADCAST;
;277:	te->s.eventParm = self->s.number;
;278:	*/
;279:	G_KillG2Queue(self->s.number);
ADDRFP4 0
INDIRP4
INDIRI4
ARGI4
ADDRGP4 G_KillG2Queue
CALLV
pop
line 281
;280:
;281:	return;
LABELV $139
endproc JMSaberTouch 36 12
data
export gJMSaberEnt
align 4
LABELV gJMSaberEnt
byte 4 0
export SP_info_jedimaster_start
code
proc SP_info_jedimaster_start 8 4
line 290
;282:}
;283:
;284:gentity_t *gJMSaberEnt = NULL;
;285:
;286:/*QUAKED info_jedimaster_start (1 0 0) (-16 -16 -24) (16 16 32)
;287:"jedi master" saber spawn point
;288:*/
;289:void SP_info_jedimaster_start(gentity_t *ent)
;290:{
line 291
;291:	if (g_gametype.integer != GT_JEDIMASTER)
ADDRGP4 g_gametype+12
INDIRI4
CNSTI4 2
EQI4 $170
line 292
;292:	{
line 293
;293:		gJMSaberEnt = NULL;
ADDRGP4 gJMSaberEnt
CNSTP4 0
ASGNP4
line 294
;294:		G_FreeEntity(ent);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 G_FreeEntity
CALLV
pop
line 295
;295:		return;
ADDRGP4 $169
JUMPV
LABELV $170
line 298
;296:	}
;297:
;298:	ent->enemy = NULL;
ADDRFP4 0
INDIRP4
CNSTI4 728
ADDP4
CNSTP4 0
ASGNP4
line 300
;299:
;300:	ent->s.eFlags = EF_BOUNCE_HALF;
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
CNSTI4 32
ASGNI4
line 302
;301:
;302:	ent->s.modelindex = G_ModelIndex("models/weapons2/saber/saber_w.glm");
ADDRGP4 $119
ARGP4
ADDRLP4 0
ADDRGP4 G_ModelIndex
CALLI4
ASGNI4
ADDRFP4 0
INDIRP4
CNSTI4 212
ADDP4
ADDRLP4 0
INDIRI4
ASGNI4
line 303
;303:	ent->s.modelGhoul2 = 1;
ADDRFP4 0
INDIRP4
CNSTI4 204
ADDP4
CNSTI4 1
ASGNI4
line 304
;304:	ent->s.g2radius = 20;
ADDRFP4 0
INDIRP4
CNSTI4 208
ADDP4
CNSTI4 20
ASGNI4
line 306
;305:	//ent->s.eType = ET_GENERAL;
;306:	ent->s.eType = ET_MISSILE;
ADDRFP4 0
INDIRP4
CNSTI4 4
ADDP4
CNSTI4 3
ASGNI4
line 307
;307:	ent->s.weapon = WP_SABER;
ADDRFP4 0
INDIRP4
CNSTI4 276
ADDP4
CNSTI4 2
ASGNI4
line 308
;308:	ent->s.pos.trType = TR_GRAVITY;
ADDRFP4 0
INDIRP4
CNSTI4 12
ADDP4
CNSTI4 5
ASGNI4
line 309
;309:	ent->s.pos.trTime = level.time;
ADDRFP4 0
INDIRP4
CNSTI4 16
ADDP4
ADDRGP4 level+32
INDIRI4
ASGNI4
line 310
;310:	VectorSet( ent->r.maxs, 3, 3, 3 );
ADDRFP4 0
INDIRP4
CNSTI4 328
ADDP4
CNSTF4 1077936128
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 332
ADDP4
CNSTF4 1077936128
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 336
ADDP4
CNSTF4 1077936128
ASGNF4
line 311
;311:	VectorSet( ent->r.mins, -3, -3, -3 );
ADDRFP4 0
INDIRP4
CNSTI4 316
ADDP4
CNSTF4 3225419776
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 320
ADDP4
CNSTF4 3225419776
ASGNF4
ADDRFP4 0
INDIRP4
CNSTI4 324
ADDP4
CNSTF4 3225419776
ASGNF4
line 312
;312:	ent->r.contents = CONTENTS_TRIGGER;
ADDRFP4 0
INDIRP4
CNSTI4 340
ADDP4
CNSTI4 1024
ASGNI4
line 313
;313:	ent->clipmask = MASK_SOLID;
ADDRFP4 0
INDIRP4
CNSTI4 508
ADDP4
CNSTI4 1
ASGNI4
line 315
;314:
;315:	ent->isSaberEntity = qtrue;
ADDRFP4 0
INDIRP4
CNSTI4 812
ADDP4
CNSTI4 1
ASGNI4
line 317
;316:
;317:	ent->bounceCount = -5;
ADDRFP4 0
INDIRP4
CNSTI4 716
ADDP4
CNSTI4 -5
ASGNI4
line 319
;318:
;319:	ent->physicsObject = qtrue;
ADDRFP4 0
INDIRP4
CNSTI4 500
ADDP4
CNSTI4 1
ASGNI4
line 321
;320:
;321:	VectorCopy(ent->s.pos.trBase, ent->s.origin2); //remember the spawn spot
ADDRLP4 4
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 4
INDIRP4
CNSTI4 104
ADDP4
ADDRLP4 4
INDIRP4
CNSTI4 24
ADDP4
INDIRB
ASGNB 12
line 323
;322:
;323:	ent->touch = JMSaberTouch;
ADDRFP4 0
INDIRP4
CNSTI4 648
ADDP4
ADDRGP4 JMSaberTouch
ASGNP4
line 325
;324:
;325:	trap_LinkEntity(ent);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 trap_LinkEntity
CALLV
pop
line 327
;326:
;327:	ent->think = JMSaberThink;
ADDRFP4 0
INDIRP4
CNSTI4 636
ADDP4
ADDRGP4 JMSaberThink
ASGNP4
line 328
;328:	ent->nextthink = level.time + 50;
ADDRFP4 0
INDIRP4
CNSTI4 632
ADDP4
ADDRGP4 level+32
INDIRI4
CNSTI4 50
ADDI4
ASGNI4
line 329
;329:}
LABELV $169
endproc SP_info_jedimaster_start 8 4
export SpotWouldTelefrag
proc SpotWouldTelefrag 4144 16
line 345
;330:
;331:/*
;332:=======================================================================
;333:
;334:  SelectSpawnPoint
;335:
;336:=======================================================================
;337:*/
;338:
;339:/*
;340:================
;341:SpotWouldTelefrag
;342:
;343:================
;344:*/
;345:qboolean SpotWouldTelefrag( gentity_t *spot ) {
line 351
;346:	int			i, num;
;347:	int			touch[MAX_GENTITIES];
;348:	gentity_t	*hit;
;349:	vec3_t		mins, maxs;
;350:
;351:	VectorAdd( spot->s.origin, playerMins, mins );
ADDRLP4 4132
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 4108
ADDRLP4 4132
INDIRP4
CNSTI4 92
ADDP4
INDIRF4
ADDRGP4 playerMins
INDIRF4
ADDF4
ASGNF4
ADDRLP4 4108+4
ADDRLP4 4132
INDIRP4
CNSTI4 96
ADDP4
INDIRF4
ADDRGP4 playerMins+4
INDIRF4
ADDF4
ASGNF4
ADDRLP4 4108+8
ADDRFP4 0
INDIRP4
CNSTI4 100
ADDP4
INDIRF4
ADDRGP4 playerMins+8
INDIRF4
ADDF4
ASGNF4
line 352
;352:	VectorAdd( spot->s.origin, playerMaxs, maxs );
ADDRLP4 4136
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 4120
ADDRLP4 4136
INDIRP4
CNSTI4 92
ADDP4
INDIRF4
ADDRGP4 playerMaxs
INDIRF4
ADDF4
ASGNF4
ADDRLP4 4120+4
ADDRLP4 4136
INDIRP4
CNSTI4 96
ADDP4
INDIRF4
ADDRGP4 playerMaxs+4
INDIRF4
ADDF4
ASGNF4
ADDRLP4 4120+8
ADDRFP4 0
INDIRP4
CNSTI4 100
ADDP4
INDIRF4
ADDRGP4 playerMaxs+8
INDIRF4
ADDF4
ASGNF4
line 353
;353:	num = trap_EntitiesInBox( mins, maxs, touch, MAX_GENTITIES );
ADDRLP4 4108
ARGP4
ADDRLP4 4120
ARGP4
ADDRLP4 12
ARGP4
CNSTI4 1024
ARGI4
ADDRLP4 4140
ADDRGP4 trap_EntitiesInBox
CALLI4
ASGNI4
ADDRLP4 8
ADDRLP4 4140
INDIRI4
ASGNI4
line 355
;354:
;355:	for (i=0 ; i<num ; i++) {
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 $187
JUMPV
LABELV $184
line 356
;356:		hit = &g_entities[touch[i]];
ADDRLP4 4
CNSTI4 828
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 12
ADDP4
INDIRI4
MULI4
ADDRGP4 g_entities
ADDP4
ASGNP4
line 358
;357:		//if ( hit->client && hit->client->ps.stats[STAT_HEALTH] > 0 ) {
;358:		if ( hit->client) {
ADDRLP4 4
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $188
line 359
;359:			return qtrue;
CNSTI4 1
RETI4
ADDRGP4 $175
JUMPV
LABELV $188
line 362
;360:		}
;361:
;362:	}
LABELV $185
line 355
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $187
ADDRLP4 0
INDIRI4
ADDRLP4 8
INDIRI4
LTI4 $184
line 364
;363:
;364:	return qfalse;
CNSTI4 0
RETI4
LABELV $175
endproc SpotWouldTelefrag 4144 16
export SelectNearestDeathmatchSpawnPoint
proc SelectNearestDeathmatchSpawnPoint 40 12
line 375
;365:}
;366:
;367:/*
;368:================
;369:SelectNearestDeathmatchSpawnPoint
;370:
;371:Find the spot that we DON'T want to use
;372:================
;373:*/
;374:#define	MAX_SPAWN_POINTS	128
;375:gentity_t *SelectNearestDeathmatchSpawnPoint( vec3_t from ) {
line 381
;376:	gentity_t	*spot;
;377:	vec3_t		delta;
;378:	float		dist, nearestDist;
;379:	gentity_t	*nearestSpot;
;380:
;381:	nearestDist = 999999;
ADDRLP4 20
CNSTF4 1232348144
ASGNF4
line 382
;382:	nearestSpot = NULL;
ADDRLP4 24
CNSTP4 0
ASGNP4
line 383
;383:	spot = NULL;
ADDRLP4 0
CNSTP4 0
ASGNP4
ADDRGP4 $192
JUMPV
LABELV $191
line 385
;384:
;385:	while ((spot = G_Find (spot, FOFS(classname), "info_player_deathmatch")) != NULL) {
line 387
;386:
;387:		VectorSubtract( spot->s.origin, from, delta );
ADDRLP4 32
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 4
ADDRLP4 0
INDIRP4
CNSTI4 92
ADDP4
INDIRF4
ADDRLP4 32
INDIRP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 4+4
ADDRLP4 0
INDIRP4
CNSTI4 96
ADDP4
INDIRF4
ADDRLP4 32
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 4+8
ADDRLP4 0
INDIRP4
CNSTI4 100
ADDP4
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
SUBF4
ASGNF4
line 388
;388:		dist = VectorLength( delta );
ADDRLP4 4
ARGP4
ADDRLP4 36
ADDRGP4 VectorLength
CALLF4
ASGNF4
ADDRLP4 16
ADDRLP4 36
INDIRF4
ASGNF4
line 389
;389:		if ( dist < nearestDist ) {
ADDRLP4 16
INDIRF4
ADDRLP4 20
INDIRF4
GEF4 $196
line 390
;390:			nearestDist = dist;
ADDRLP4 20
ADDRLP4 16
INDIRF4
ASGNF4
line 391
;391:			nearestSpot = spot;
ADDRLP4 24
ADDRLP4 0
INDIRP4
ASGNP4
line 392
;392:		}
LABELV $196
line 393
;393:	}
LABELV $192
line 385
ADDRLP4 0
INDIRP4
ARGP4
CNSTI4 416
ARGI4
ADDRGP4 $98
ARGP4
ADDRLP4 28
ADDRGP4 G_Find
CALLP4
ASGNP4
ADDRLP4 0
ADDRLP4 28
INDIRP4
ASGNP4
ADDRLP4 28
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $191
line 395
;394:
;395:	return nearestSpot;
ADDRLP4 24
INDIRP4
RETP4
LABELV $190
endproc SelectNearestDeathmatchSpawnPoint 40 12
export SelectRandomDeathmatchSpawnPoint
proc SelectRandomDeathmatchSpawnPoint 532 12
line 407
;396:}
;397:
;398:
;399:/*
;400:================
;401:SelectRandomDeathmatchSpawnPoint
;402:
;403:go to a random point that doesn't telefrag
;404:================
;405:*/
;406:#define	MAX_SPAWN_POINTS	128
;407:gentity_t *SelectRandomDeathmatchSpawnPoint( void ) {
line 413
;408:	gentity_t	*spot;
;409:	int			count;
;410:	int			selection;
;411:	gentity_t	*spots[MAX_SPAWN_POINTS];
;412:
;413:	count = 0;
ADDRLP4 4
CNSTI4 0
ASGNI4
line 414
;414:	spot = NULL;
ADDRLP4 0
CNSTP4 0
ASGNP4
ADDRGP4 $200
JUMPV
LABELV $199
line 416
;415:
;416:	while ((spot = G_Find (spot, FOFS(classname), "info_player_deathmatch")) != NULL) {
line 417
;417:		if ( SpotWouldTelefrag( spot ) ) {
ADDRLP4 0
INDIRP4
ARGP4
ADDRLP4 524
ADDRGP4 SpotWouldTelefrag
CALLI4
ASGNI4
ADDRLP4 524
INDIRI4
CNSTI4 0
EQI4 $202
line 418
;418:			continue;
ADDRGP4 $200
JUMPV
LABELV $202
line 420
;419:		}
;420:		spots[ count ] = spot;
ADDRLP4 4
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 8
ADDP4
ADDRLP4 0
INDIRP4
ASGNP4
line 421
;421:		count++;
ADDRLP4 4
ADDRLP4 4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 422
;422:	}
LABELV $200
line 416
ADDRLP4 0
INDIRP4
ARGP4
CNSTI4 416
ARGI4
ADDRGP4 $98
ARGP4
ADDRLP4 524
ADDRGP4 G_Find
CALLP4
ASGNP4
ADDRLP4 0
ADDRLP4 524
INDIRP4
ASGNP4
ADDRLP4 524
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $199
line 424
;423:
;424:	if ( !count ) {	// no spots that won't telefrag
ADDRLP4 4
INDIRI4
CNSTI4 0
NEI4 $204
line 425
;425:		return G_Find( NULL, FOFS(classname), "info_player_deathmatch");
CNSTP4 0
ARGP4
CNSTI4 416
ARGI4
ADDRGP4 $98
ARGP4
ADDRLP4 528
ADDRGP4 G_Find
CALLP4
ASGNP4
ADDRLP4 528
INDIRP4
RETP4
ADDRGP4 $198
JUMPV
LABELV $204
line 428
;426:	}
;427:
;428:	selection = rand() % count;
ADDRLP4 528
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 520
ADDRLP4 528
INDIRI4
ADDRLP4 4
INDIRI4
MODI4
ASGNI4
line 429
;429:	return spots[ selection ];
ADDRLP4 520
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 8
ADDP4
INDIRP4
RETP4
LABELV $198
endproc SelectRandomDeathmatchSpawnPoint 532 12
export SelectRandomFurthestSpawnPoint
proc SelectRandomFurthestSpawnPoint 572 12
line 439
;430:}
;431:
;432:/*
;433:===========
;434:SelectRandomFurthestSpawnPoint
;435:
;436:Chooses a player start, deathmatch start, etc
;437:============
;438:*/
;439:gentity_t *SelectRandomFurthestSpawnPoint ( vec3_t avoidPoint, vec3_t origin, vec3_t angles ) {
line 447
;440:	gentity_t	*spot;
;441:	vec3_t		delta;
;442:	float		dist;
;443:	float		list_dist[64];
;444:	gentity_t	*list_spot[64];
;445:	int			numSpots, rnd, i, j;
;446:
;447:	numSpots = 0;
ADDRLP4 520
CNSTI4 0
ASGNI4
line 448
;448:	spot = NULL;
ADDRLP4 528
CNSTP4 0
ASGNP4
ADDRGP4 $208
JUMPV
LABELV $207
line 450
;449:
;450:	while ((spot = G_Find (spot, FOFS(classname), "info_player_deathmatch")) != NULL) {
line 451
;451:		if ( SpotWouldTelefrag( spot ) ) {
ADDRLP4 528
INDIRP4
ARGP4
ADDRLP4 548
ADDRGP4 SpotWouldTelefrag
CALLI4
ASGNI4
ADDRLP4 548
INDIRI4
CNSTI4 0
EQI4 $210
line 452
;452:			continue;
ADDRGP4 $208
JUMPV
LABELV $210
line 454
;453:		}
;454:		VectorSubtract( spot->s.origin, avoidPoint, delta );
ADDRLP4 556
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 532
ADDRLP4 528
INDIRP4
CNSTI4 92
ADDP4
INDIRF4
ADDRLP4 556
INDIRP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 532+4
ADDRLP4 528
INDIRP4
CNSTI4 96
ADDP4
INDIRF4
ADDRLP4 556
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 532+8
ADDRLP4 528
INDIRP4
CNSTI4 100
ADDP4
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
SUBF4
ASGNF4
line 455
;455:		dist = VectorLength( delta );
ADDRLP4 532
ARGP4
ADDRLP4 560
ADDRGP4 VectorLength
CALLF4
ASGNF4
ADDRLP4 524
ADDRLP4 560
INDIRF4
ASGNF4
line 456
;456:		for (i = 0; i < numSpots; i++) {
ADDRLP4 516
CNSTI4 0
ASGNI4
ADDRGP4 $217
JUMPV
LABELV $214
line 457
;457:			if ( dist > list_dist[i] ) {
ADDRLP4 524
INDIRF4
ADDRLP4 516
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 4
ADDP4
INDIRF4
LEF4 $218
line 458
;458:				if ( numSpots >= 64 )
ADDRLP4 520
INDIRI4
CNSTI4 64
LTI4 $220
line 459
;459:					numSpots = 64-1;
ADDRLP4 520
CNSTI4 63
ASGNI4
LABELV $220
line 460
;460:				for (j = numSpots; j > i; j--) {
ADDRLP4 0
ADDRLP4 520
INDIRI4
ASGNI4
ADDRGP4 $225
JUMPV
LABELV $222
line 461
;461:					list_dist[j] = list_dist[j-1];
ADDRLP4 564
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ASGNI4
ADDRLP4 564
INDIRI4
ADDRLP4 4
ADDP4
ADDRLP4 564
INDIRI4
ADDRLP4 4-4
ADDP4
INDIRF4
ASGNF4
line 462
;462:					list_spot[j] = list_spot[j-1];
ADDRLP4 568
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ASGNI4
ADDRLP4 568
INDIRI4
ADDRLP4 260
ADDP4
ADDRLP4 568
INDIRI4
ADDRLP4 260-4
ADDP4
INDIRP4
ASGNP4
line 463
;463:				}
LABELV $223
line 460
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
SUBI4
ASGNI4
LABELV $225
ADDRLP4 0
INDIRI4
ADDRLP4 516
INDIRI4
GTI4 $222
line 464
;464:				list_dist[i] = dist;
ADDRLP4 516
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 4
ADDP4
ADDRLP4 524
INDIRF4
ASGNF4
line 465
;465:				list_spot[i] = spot;
ADDRLP4 516
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 260
ADDP4
ADDRLP4 528
INDIRP4
ASGNP4
line 466
;466:				numSpots++;
ADDRLP4 520
ADDRLP4 520
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 467
;467:				if (numSpots > 64)
ADDRLP4 520
INDIRI4
CNSTI4 64
LEI4 $216
line 468
;468:					numSpots = 64;
ADDRLP4 520
CNSTI4 64
ASGNI4
line 469
;469:				break;
ADDRGP4 $216
JUMPV
LABELV $218
line 471
;470:			}
;471:		}
LABELV $215
line 456
ADDRLP4 516
ADDRLP4 516
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $217
ADDRLP4 516
INDIRI4
ADDRLP4 520
INDIRI4
LTI4 $214
LABELV $216
line 472
;472:		if (i >= numSpots && numSpots < 64) {
ADDRLP4 516
INDIRI4
ADDRLP4 520
INDIRI4
LTI4 $230
ADDRLP4 520
INDIRI4
CNSTI4 64
GEI4 $230
line 473
;473:			list_dist[numSpots] = dist;
ADDRLP4 520
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 4
ADDP4
ADDRLP4 524
INDIRF4
ASGNF4
line 474
;474:			list_spot[numSpots] = spot;
ADDRLP4 520
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 260
ADDP4
ADDRLP4 528
INDIRP4
ASGNP4
line 475
;475:			numSpots++;
ADDRLP4 520
ADDRLP4 520
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 476
;476:		}
LABELV $230
line 477
;477:	}
LABELV $208
line 450
ADDRLP4 528
INDIRP4
ARGP4
CNSTI4 416
ARGI4
ADDRGP4 $98
ARGP4
ADDRLP4 548
ADDRGP4 G_Find
CALLP4
ASGNP4
ADDRLP4 528
ADDRLP4 548
INDIRP4
ASGNP4
ADDRLP4 548
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $207
line 478
;478:	if (!numSpots) {
ADDRLP4 520
INDIRI4
CNSTI4 0
NEI4 $232
line 479
;479:		spot = G_Find( NULL, FOFS(classname), "info_player_deathmatch");
CNSTP4 0
ARGP4
CNSTI4 416
ARGI4
ADDRGP4 $98
ARGP4
ADDRLP4 552
ADDRGP4 G_Find
CALLP4
ASGNP4
ADDRLP4 528
ADDRLP4 552
INDIRP4
ASGNP4
line 480
;480:		if (!spot)
ADDRLP4 528
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $234
line 481
;481:			G_Error( "Couldn't find a spawn point" );
ADDRGP4 $236
ARGP4
ADDRGP4 G_Error
CALLV
pop
LABELV $234
line 482
;482:		VectorCopy (spot->s.origin, origin);
ADDRFP4 4
INDIRP4
ADDRLP4 528
INDIRP4
CNSTI4 92
ADDP4
INDIRB
ASGNB 12
line 483
;483:		origin[2] += 9;
ADDRLP4 556
ADDRFP4 4
INDIRP4
CNSTI4 8
ADDP4
ASGNP4
ADDRLP4 556
INDIRP4
ADDRLP4 556
INDIRP4
INDIRF4
CNSTF4 1091567616
ADDF4
ASGNF4
line 484
;484:		VectorCopy (spot->s.angles, angles);
ADDRFP4 8
INDIRP4
ADDRLP4 528
INDIRP4
CNSTI4 116
ADDP4
INDIRB
ASGNB 12
line 485
;485:		return spot;
ADDRLP4 528
INDIRP4
RETP4
ADDRGP4 $206
JUMPV
LABELV $232
line 489
;486:	}
;487:
;488:	// select a random spot from the spawn points furthest away
;489:	rnd = random() * (numSpots / 2);
ADDRLP4 552
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 544
ADDRLP4 552
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
ADDRLP4 520
INDIRI4
CNSTI4 2
DIVI4
CVIF4 4
MULF4
CVFI4 4
ASGNI4
line 491
;490:
;491:	VectorCopy (list_spot[rnd]->s.origin, origin);
ADDRFP4 4
INDIRP4
ADDRLP4 544
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 260
ADDP4
INDIRP4
CNSTI4 92
ADDP4
INDIRB
ASGNB 12
line 492
;492:	origin[2] += 9;
ADDRLP4 556
ADDRFP4 4
INDIRP4
CNSTI4 8
ADDP4
ASGNP4
ADDRLP4 556
INDIRP4
ADDRLP4 556
INDIRP4
INDIRF4
CNSTF4 1091567616
ADDF4
ASGNF4
line 493
;493:	VectorCopy (list_spot[rnd]->s.angles, angles);
ADDRFP4 8
INDIRP4
ADDRLP4 544
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 260
ADDP4
INDIRP4
CNSTI4 116
ADDP4
INDIRB
ASGNB 12
line 495
;494:
;495:	return list_spot[rnd];
ADDRLP4 544
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 260
ADDP4
INDIRP4
RETP4
LABELV $206
endproc SelectRandomFurthestSpawnPoint 572 12
export SelectSpawnPoint
proc SelectSpawnPoint 4 12
line 505
;496:}
;497:
;498:/*
;499:===========
;500:SelectSpawnPoint
;501:
;502:Chooses a player start, deathmatch start, etc
;503:============
;504:*/
;505:gentity_t *SelectSpawnPoint ( vec3_t avoidPoint, vec3_t origin, vec3_t angles ) {
line 506
;506:	return SelectRandomFurthestSpawnPoint( avoidPoint, origin, angles );
ADDRFP4 0
INDIRP4
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRFP4 8
INDIRP4
ARGP4
ADDRLP4 0
ADDRGP4 SelectRandomFurthestSpawnPoint
CALLP4
ASGNP4
ADDRLP4 0
INDIRP4
RETP4
LABELV $237
endproc SelectSpawnPoint 4 12
export SelectInitialSpawnPoint
proc SelectInitialSpawnPoint 20 12
line 545
;507:
;508:	/*
;509:	gentity_t	*spot;
;510:	gentity_t	*nearestSpot;
;511:
;512:	nearestSpot = SelectNearestDeathmatchSpawnPoint( avoidPoint );
;513:
;514:	spot = SelectRandomDeathmatchSpawnPoint ( );
;515:	if ( spot == nearestSpot ) {
;516:		// roll again if it would be real close to point of death
;517:		spot = SelectRandomDeathmatchSpawnPoint ( );
;518:		if ( spot == nearestSpot ) {
;519:			// last try
;520:			spot = SelectRandomDeathmatchSpawnPoint ( );
;521:		}		
;522:	}
;523:
;524:	// find a single player start spot
;525:	if (!spot) {
;526:		G_Error( "Couldn't find a spawn point" );
;527:	}
;528:
;529:	VectorCopy (spot->s.origin, origin);
;530:	origin[2] += 9;
;531:	VectorCopy (spot->s.angles, angles);
;532:
;533:	return spot;
;534:	*/
;535:}
;536:
;537:/*
;538:===========
;539:SelectInitialSpawnPoint
;540:
;541:Try to find a spawn point marked 'initial', otherwise
;542:use normal spawn selection.
;543:============
;544:*/
;545:gentity_t *SelectInitialSpawnPoint( vec3_t origin, vec3_t angles ) {
line 548
;546:	gentity_t	*spot;
;547:
;548:	spot = NULL;
ADDRLP4 0
CNSTP4 0
ASGNP4
ADDRGP4 $240
JUMPV
LABELV $239
line 549
;549:	while ((spot = G_Find (spot, FOFS(classname), "info_player_deathmatch")) != NULL) {
line 550
;550:		if ( spot->spawnflags & 1 ) {
ADDRLP4 0
INDIRP4
CNSTI4 420
ADDP4
INDIRI4
CNSTI4 1
BANDI4
CNSTI4 0
EQI4 $242
line 551
;551:			break;
ADDRGP4 $241
JUMPV
LABELV $242
line 553
;552:		}
;553:	}
LABELV $240
line 549
ADDRLP4 0
INDIRP4
ARGP4
CNSTI4 416
ARGI4
ADDRGP4 $98
ARGP4
ADDRLP4 4
ADDRGP4 G_Find
CALLP4
ASGNP4
ADDRLP4 0
ADDRLP4 4
INDIRP4
ASGNP4
ADDRLP4 4
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $239
LABELV $241
line 555
;554:
;555:	if ( !spot || SpotWouldTelefrag( spot ) ) {
ADDRLP4 0
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $246
ADDRLP4 0
INDIRP4
ARGP4
ADDRLP4 12
ADDRGP4 SpotWouldTelefrag
CALLI4
ASGNI4
ADDRLP4 12
INDIRI4
CNSTI4 0
EQI4 $244
LABELV $246
line 556
;556:		return SelectSpawnPoint( vec3_origin, origin, angles );
ADDRGP4 vec3_origin
ARGP4
ADDRFP4 0
INDIRP4
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRLP4 16
ADDRGP4 SelectSpawnPoint
CALLP4
ASGNP4
ADDRLP4 16
INDIRP4
RETP4
ADDRGP4 $238
JUMPV
LABELV $244
line 559
;557:	}
;558:
;559:	VectorCopy (spot->s.origin, origin);
ADDRFP4 0
INDIRP4
ADDRLP4 0
INDIRP4
CNSTI4 92
ADDP4
INDIRB
ASGNB 12
line 560
;560:	origin[2] += 9;
ADDRLP4 16
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
ASGNP4
ADDRLP4 16
INDIRP4
ADDRLP4 16
INDIRP4
INDIRF4
CNSTF4 1091567616
ADDF4
ASGNF4
line 561
;561:	VectorCopy (spot->s.angles, angles);
ADDRFP4 4
INDIRP4
ADDRLP4 0
INDIRP4
CNSTI4 116
ADDP4
INDIRB
ASGNB 12
line 563
;562:
;563:	return spot;
ADDRLP4 0
INDIRP4
RETP4
LABELV $238
endproc SelectInitialSpawnPoint 20 12
export SelectSpectatorSpawnPoint
proc SelectSpectatorSpawnPoint 0 0
line 572
;564:}
;565:
;566:/*
;567:===========
;568:SelectSpectatorSpawnPoint
;569:
;570:============
;571:*/
;572:gentity_t *SelectSpectatorSpawnPoint( vec3_t origin, vec3_t angles ) {
line 573
;573:	FindIntermissionPoint();
ADDRGP4 FindIntermissionPoint
CALLV
pop
line 575
;574:
;575:	VectorCopy( level.intermission_origin, origin );
ADDRFP4 0
INDIRP4
ADDRGP4 level+9024
INDIRB
ASGNB 12
line 576
;576:	VectorCopy( level.intermission_angle, angles );
ADDRFP4 4
INDIRP4
ADDRGP4 level+9036
INDIRB
ASGNB 12
line 578
;577:
;578:	return NULL;
CNSTP4 0
RETP4
LABELV $247
endproc SelectSpectatorSpawnPoint 0 0
export InitBodyQue
proc InitBodyQue 12 0
line 604
;579:}
;580:
;581:/*
;582:=======================================================================
;583:
;584:BODYQUE
;585:
;586:=======================================================================
;587:*/
;588:
;589:/*
;590:=======================================================================
;591:
;592:BODYQUE
;593:
;594:=======================================================================
;595:*/
;596:
;597:#define BODY_SINK_TIME		45000
;598:
;599:/*
;600:===============
;601:InitBodyQue
;602:===============
;603:*/
;604:void InitBodyQue (void) {
line 608
;605:	int		i;
;606:	gentity_t	*ent;
;607:
;608:	level.bodyQueIndex = 0;
ADDRGP4 level+9056
CNSTI4 0
ASGNI4
line 609
;609:	for (i=0; i<BODY_QUEUE_SIZE ; i++) {
ADDRLP4 4
CNSTI4 0
ASGNI4
LABELV $252
line 610
;610:		ent = G_Spawn();
ADDRLP4 8
ADDRGP4 G_Spawn
CALLP4
ASGNP4
ADDRLP4 0
ADDRLP4 8
INDIRP4
ASGNP4
line 611
;611:		ent->classname = "bodyque";
ADDRLP4 0
INDIRP4
CNSTI4 416
ADDP4
ADDRGP4 $256
ASGNP4
line 612
;612:		ent->neverFree = qtrue;
ADDRLP4 0
INDIRP4
CNSTI4 468
ADDP4
CNSTI4 1
ASGNI4
line 613
;613:		level.bodyQue[i] = ent;
ADDRLP4 4
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 level+9060
ADDP4
ADDRLP4 0
INDIRP4
ASGNP4
line 614
;614:	}
LABELV $253
line 609
ADDRLP4 4
ADDRLP4 4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 4
INDIRI4
CNSTI4 8
LTI4 $252
line 615
;615:}
LABELV $250
endproc InitBodyQue 12 0
export BodySink
proc BodySink 4 4
line 624
;616:
;617:/*
;618:=============
;619:BodySink
;620:
;621:After sitting around for five seconds, fall into the ground and dissapear
;622:=============
;623:*/
;624:void BodySink( gentity_t *ent ) {
line 625
;625:	if ( level.time - ent->timestamp > BODY_SINK_TIME + 1500 ) {
ADDRGP4 level+32
INDIRI4
ADDRFP4 0
INDIRP4
CNSTI4 576
ADDP4
INDIRI4
SUBI4
CNSTI4 46500
LEI4 $259
line 627
;626:		// the body ques are never actually freed, they are just unlinked
;627:		trap_UnlinkEntity( ent );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 trap_UnlinkEntity
CALLV
pop
line 628
;628:		ent->physicsObject = qfalse;
ADDRFP4 0
INDIRP4
CNSTI4 500
ADDP4
CNSTI4 0
ASGNI4
line 629
;629:		return;	
ADDRGP4 $258
JUMPV
LABELV $259
line 631
;630:	}
;631:	ent->nextthink = level.time + 100;
ADDRFP4 0
INDIRP4
CNSTI4 632
ADDP4
ADDRGP4 level+32
INDIRI4
CNSTI4 100
ADDI4
ASGNI4
line 632
;632:	ent->s.pos.trBase[2] -= 1;
ADDRLP4 0
ADDRFP4 0
INDIRP4
CNSTI4 32
ADDP4
ASGNP4
ADDRLP4 0
INDIRP4
ADDRLP4 0
INDIRP4
INDIRF4
CNSTF4 1065353216
SUBF4
ASGNF4
line 633
;633:}
LABELV $258
endproc BodySink 4 4
export CopyToBodyQue
proc CopyToBodyQue 64 12
line 643
;634:
;635:/*
;636:=============
;637:CopyToBodyQue
;638:
;639:A player is respawning, so make an entity that looks
;640:just like the existing corpse to leave behind.
;641:=============
;642:*/
;643:void CopyToBodyQue( gentity_t *ent ) {
line 647
;644:	gentity_t		*body;
;645:	int			contents;
;646:
;647:	if (level.intermissiontime)
ADDRGP4 level+9008
INDIRI4
CNSTI4 0
EQI4 $264
line 648
;648:	{
line 649
;649:		return;
ADDRGP4 $263
JUMPV
LABELV $264
line 652
;650:	}
;651:
;652:	trap_UnlinkEntity (ent);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 trap_UnlinkEntity
CALLV
pop
line 655
;653:
;654:	// if client is in a nodrop area, don't leave the body
;655:	contents = trap_PointContents( ent->s.origin, -1 );
ADDRFP4 0
INDIRP4
CNSTI4 92
ADDP4
ARGP4
CNSTI4 -1
ARGI4
ADDRLP4 8
ADDRGP4 trap_PointContents
CALLI4
ASGNI4
ADDRLP4 4
ADDRLP4 8
INDIRI4
ASGNI4
line 656
;656:	if ( contents & CONTENTS_NODROP ) {
ADDRLP4 4
INDIRI4
CNSTI4 2048
BANDI4
CNSTI4 0
EQI4 $267
line 657
;657:		return;
ADDRGP4 $263
JUMPV
LABELV $267
line 660
;658:	}
;659:
;660:	if (ent->client && (ent->client->ps.eFlags & EF_DISINTEGRATION))
ADDRLP4 12
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
ASGNP4
ADDRLP4 12
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $269
ADDRLP4 12
INDIRP4
CNSTI4 108
ADDP4
INDIRI4
CNSTI4 33554432
BANDI4
CNSTI4 0
EQI4 $269
line 661
;661:	{ //for now, just don't spawn a body if you got disint'd
line 662
;662:		return;
ADDRGP4 $263
JUMPV
LABELV $269
line 666
;663:	}
;664:
;665:	// grab a body que and cycle to the next one
;666:	body = level.bodyQue[ level.bodyQueIndex ];
ADDRLP4 0
ADDRGP4 level+9056
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 level+9060
ADDP4
INDIRP4
ASGNP4
line 667
;667:	level.bodyQueIndex = (level.bodyQueIndex + 1) % BODY_QUEUE_SIZE;
ADDRGP4 level+9056
ADDRGP4 level+9056
INDIRI4
CNSTI4 1
ADDI4
CNSTI4 8
MODI4
ASGNI4
line 669
;668:
;669:	trap_UnlinkEntity (body);
ADDRLP4 0
INDIRP4
ARGP4
ADDRGP4 trap_UnlinkEntity
CALLV
pop
line 670
;670:	body->s = ent->s;
ADDRLP4 0
INDIRP4
ADDRFP4 0
INDIRP4
INDIRB
ASGNB 296
line 673
;671:
;672:	//avoid oddly angled corpses floating around
;673:	body->s.angles[PITCH] = body->s.angles[ROLL] = body->s.apos.trBase[PITCH] = body->s.apos.trBase[ROLL] = 0;
ADDRLP4 20
CNSTF4 0
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 68
ADDP4
ADDRLP4 20
INDIRF4
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 60
ADDP4
ADDRLP4 20
INDIRF4
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 124
ADDP4
ADDRLP4 20
INDIRF4
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 116
ADDP4
ADDRLP4 20
INDIRF4
ASGNF4
line 675
;674:
;675:	body->s.g2radius = 100;
ADDRLP4 0
INDIRP4
CNSTI4 208
ADDP4
CNSTI4 100
ASGNI4
line 677
;676:
;677:	body->s.eType = ET_BODY;
ADDRLP4 0
INDIRP4
CNSTI4 4
ADDP4
CNSTI4 15
ASGNI4
line 678
;678:	body->s.eFlags = EF_DEAD;		// clear EF_TALK, etc
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
CNSTI4 1
ASGNI4
line 680
;679:
;680:	if (ent->client && (ent->client->ps.eFlags & EF_DISINTEGRATION))
ADDRLP4 24
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
ASGNP4
ADDRLP4 24
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $275
ADDRLP4 24
INDIRP4
CNSTI4 108
ADDP4
INDIRI4
CNSTI4 33554432
BANDI4
CNSTI4 0
EQI4 $275
line 681
;681:	{
line 682
;682:		body->s.eFlags |= EF_DISINTEGRATION;
ADDRLP4 28
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
ASGNP4
ADDRLP4 28
INDIRP4
ADDRLP4 28
INDIRP4
INDIRI4
CNSTI4 33554432
BORI4
ASGNI4
line 683
;683:	}
LABELV $275
line 685
;684:
;685:	VectorCopy(ent->client->ps.lastHitLoc, body->s.origin2);
ADDRLP4 0
INDIRP4
CNSTI4 104
ADDP4
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 1368
ADDP4
INDIRB
ASGNB 12
line 687
;686:
;687:	body->s.powerups = 0;	// clear powerups
ADDRLP4 0
INDIRP4
CNSTI4 272
ADDP4
CNSTI4 0
ASGNI4
line 688
;688:	body->s.loopSound = 0;	// clear lava burning
ADDRLP4 0
INDIRP4
CNSTI4 200
ADDP4
CNSTI4 0
ASGNI4
line 689
;689:	body->s.number = body - g_entities;
ADDRLP4 0
INDIRP4
ADDRLP4 0
INDIRP4
CVPU4 4
ADDRGP4 g_entities
CVPU4 4
SUBU4
CVUI4 4
CNSTI4 828
DIVI4
ASGNI4
line 690
;690:	body->timestamp = level.time;
ADDRLP4 0
INDIRP4
CNSTI4 576
ADDP4
ADDRGP4 level+32
INDIRI4
ASGNI4
line 691
;691:	body->physicsObject = qtrue;
ADDRLP4 0
INDIRP4
CNSTI4 500
ADDP4
CNSTI4 1
ASGNI4
line 692
;692:	body->physicsBounce = 0;		// don't bounce
ADDRLP4 0
INDIRP4
CNSTI4 504
ADDP4
CNSTF4 0
ASGNF4
line 693
;693:	if ( body->s.groundEntityNum == ENTITYNUM_NONE ) {
ADDRLP4 0
INDIRP4
CNSTI4 192
ADDP4
INDIRI4
CNSTI4 1023
NEI4 $278
line 694
;694:		body->s.pos.trType = TR_GRAVITY;
ADDRLP4 0
INDIRP4
CNSTI4 12
ADDP4
CNSTI4 5
ASGNI4
line 695
;695:		body->s.pos.trTime = level.time;
ADDRLP4 0
INDIRP4
CNSTI4 16
ADDP4
ADDRGP4 level+32
INDIRI4
ASGNI4
line 696
;696:		VectorCopy( ent->client->ps.velocity, body->s.pos.trDelta );
ADDRLP4 0
INDIRP4
CNSTI4 36
ADDP4
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 32
ADDP4
INDIRB
ASGNB 12
line 697
;697:	} else {
ADDRGP4 $279
JUMPV
LABELV $278
line 698
;698:		body->s.pos.trType = TR_STATIONARY;
ADDRLP4 0
INDIRP4
CNSTI4 12
ADDP4
CNSTI4 0
ASGNI4
line 699
;699:	}
LABELV $279
line 700
;700:	body->s.event = 0;
ADDRLP4 0
INDIRP4
CNSTI4 252
ADDP4
CNSTI4 0
ASGNI4
line 702
;701:
;702:	body->s.weapon = ent->s.bolt2;
ADDRLP4 0
INDIRP4
CNSTI4 276
ADDP4
ADDRFP4 0
INDIRP4
CNSTI4 144
ADDP4
INDIRI4
ASGNI4
line 704
;703:
;704:	if (body->s.weapon == WP_SABER && ent->client->ps.saberInFlight)
ADDRLP4 0
INDIRP4
CNSTI4 276
ADDP4
INDIRI4
CNSTI4 2
NEI4 $281
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 504
ADDP4
INDIRI4
CNSTI4 0
EQI4 $281
line 705
;705:	{
line 706
;706:		body->s.weapon = WP_BLASTER; //lie to keep from putting a saber on the corpse, because it was thrown at death
ADDRLP4 0
INDIRP4
CNSTI4 276
ADDP4
CNSTI4 4
ASGNI4
line 707
;707:	}
LABELV $281
line 709
;708:
;709:	G_AddEvent(body, EV_BODY_QUEUE_COPY, ent->s.clientNum);
ADDRLP4 0
INDIRP4
ARGP4
CNSTI4 109
ARGI4
ADDRFP4 0
INDIRP4
CNSTI4 220
ADDP4
INDIRI4
ARGI4
ADDRGP4 G_AddEvent
CALLV
pop
line 711
;710:
;711:	body->r.svFlags = ent->r.svFlags | SVF_BROADCAST;
ADDRLP4 32
CNSTI4 304
ASGNI4
ADDRLP4 0
INDIRP4
ADDRLP4 32
INDIRI4
ADDP4
ADDRFP4 0
INDIRP4
ADDRLP4 32
INDIRI4
ADDP4
INDIRI4
CNSTI4 32
BORI4
ASGNI4
line 712
;712:	VectorCopy (ent->r.mins, body->r.mins);
ADDRLP4 36
CNSTI4 316
ASGNI4
ADDRLP4 0
INDIRP4
ADDRLP4 36
INDIRI4
ADDP4
ADDRFP4 0
INDIRP4
ADDRLP4 36
INDIRI4
ADDP4
INDIRB
ASGNB 12
line 713
;713:	VectorCopy (ent->r.maxs, body->r.maxs);
ADDRLP4 40
CNSTI4 328
ASGNI4
ADDRLP4 0
INDIRP4
ADDRLP4 40
INDIRI4
ADDP4
ADDRFP4 0
INDIRP4
ADDRLP4 40
INDIRI4
ADDP4
INDIRB
ASGNB 12
line 714
;714:	VectorCopy (ent->r.absmin, body->r.absmin);
ADDRLP4 44
CNSTI4 344
ASGNI4
ADDRLP4 0
INDIRP4
ADDRLP4 44
INDIRI4
ADDP4
ADDRFP4 0
INDIRP4
ADDRLP4 44
INDIRI4
ADDP4
INDIRB
ASGNB 12
line 715
;715:	VectorCopy (ent->r.absmax, body->r.absmax);
ADDRLP4 48
CNSTI4 356
ASGNI4
ADDRLP4 0
INDIRP4
ADDRLP4 48
INDIRI4
ADDP4
ADDRFP4 0
INDIRP4
ADDRLP4 48
INDIRI4
ADDP4
INDIRB
ASGNB 12
line 717
;716:
;717:	body->s.torsoAnim = body->s.legsAnim = ent->client->ps.legsAnim & ~ANIM_TOGGLEBIT;
ADDRLP4 56
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 92
ADDP4
INDIRI4
CNSTI4 -2049
BANDI4
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 280
ADDP4
ADDRLP4 56
INDIRI4
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 284
ADDP4
ADDRLP4 56
INDIRI4
ASGNI4
line 719
;718:
;719:	body->clipmask = CONTENTS_SOLID | CONTENTS_PLAYERCLIP;
ADDRLP4 0
INDIRP4
CNSTI4 508
ADDP4
CNSTI4 17
ASGNI4
line 720
;720:	body->r.contents = CONTENTS_CORPSE;
ADDRLP4 0
INDIRP4
CNSTI4 340
ADDP4
CNSTI4 512
ASGNI4
line 721
;721:	body->r.ownerNum = ent->s.number;
ADDRLP4 0
INDIRP4
CNSTI4 396
ADDP4
ADDRFP4 0
INDIRP4
INDIRI4
ASGNI4
line 723
;722:
;723:	body->nextthink = level.time + BODY_SINK_TIME;
ADDRLP4 0
INDIRP4
CNSTI4 632
ADDP4
ADDRGP4 level+32
INDIRI4
CNSTI4 45000
ADDI4
ASGNI4
line 724
;724:	body->think = BodySink;
ADDRLP4 0
INDIRP4
CNSTI4 636
ADDP4
ADDRGP4 BodySink
ASGNP4
line 726
;725:
;726:	body->die = body_die;
ADDRLP4 0
INDIRP4
CNSTI4 660
ADDP4
ADDRGP4 body_die
ASGNP4
line 729
;727:
;728:	// don't take more damage if already gibbed
;729:	if ( ent->health <= GIB_HEALTH ) {
ADDRFP4 0
INDIRP4
CNSTI4 676
ADDP4
INDIRI4
CNSTI4 -40
GTI4 $284
line 730
;730:		body->takedamage = qfalse;
ADDRLP4 0
INDIRP4
CNSTI4 680
ADDP4
CNSTI4 0
ASGNI4
line 731
;731:	} else {
ADDRGP4 $285
JUMPV
LABELV $284
line 732
;732:		body->takedamage = qtrue;
ADDRLP4 0
INDIRP4
CNSTI4 680
ADDP4
CNSTI4 1
ASGNI4
line 733
;733:	}
LABELV $285
line 735
;734:
;735:	VectorCopy ( body->s.pos.trBase, body->r.currentOrigin );
ADDRLP4 0
INDIRP4
CNSTI4 368
ADDP4
ADDRLP4 0
INDIRP4
CNSTI4 24
ADDP4
INDIRB
ASGNB 12
line 736
;736:	trap_LinkEntity (body);
ADDRLP4 0
INDIRP4
ARGP4
ADDRGP4 trap_LinkEntity
CALLV
pop
line 737
;737:}
LABELV $263
endproc CopyToBodyQue 64 12
export SetClientViewAngle
proc SetClientViewAngle 48 16
line 748
;738:
;739://======================================================================
;740:
;741:
;742:/*
;743:==================
;744:SetClientViewAngle
;745:
;746:==================
;747:*/
;748:void SetClientViewAngle( gentity_t *ent, vec3_t angle ) {
line 758
;749:	int			i;
;750:
;751:   vec3_t forward, right, up;
;752:   int		cmdAngle;
;753:
;754:	
;755:
;756:	// adnan
;757:   // lets try something...
;758:   AngleVectors(ent->s.angles, forward, right, up);
ADDRFP4 0
INDIRP4
CNSTI4 116
ADDP4
ARGP4
ADDRLP4 0
ARGP4
ADDRLP4 16
ARGP4
ADDRLP4 28
ARGP4
ADDRGP4 AngleVectors
CALLV
pop
line 761
;759:   
;760:   // right
;761:   cmdAngle = ANGLE2SHORT(angle[ROLL]);
ADDRLP4 12
CNSTF4 1199570944
ADDRFP4 4
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
MULF4
CNSTF4 1135869952
DIVF4
CVFI4 4
CNSTI4 65535
BANDI4
ASGNI4
line 762
;762:   cmdAngle -= ent->client->pers.cmd.angles[YAW];
ADDRLP4 12
ADDRLP4 12
INDIRI4
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 1392
ADDP4
INDIRI4
SUBI4
ASGNI4
line 763
;763:   RotatePointAroundVector(right, forward, right, cmdAngle);
ADDRLP4 16
ARGP4
ADDRLP4 0
ARGP4
ADDRLP4 16
ARGP4
ADDRLP4 12
INDIRI4
CVIF4 4
ARGF4
ADDRGP4 RotatePointAroundVector
CALLV
pop
line 766
;764:
;765:   // forward
;766:   cmdAngle = ANGLE2SHORT(angle[YAW]);
ADDRLP4 12
CNSTF4 1199570944
ADDRFP4 4
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
MULF4
CNSTF4 1135869952
DIVF4
CVFI4 4
CNSTI4 65535
BANDI4
ASGNI4
line 767
;767:   cmdAngle -= ent->client->pers.cmd.angles[PITCH];
ADDRLP4 12
ADDRLP4 12
INDIRI4
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 1388
ADDP4
INDIRI4
SUBI4
ASGNI4
line 768
;768:   RotatePointAroundVector(forward, up, forward, cmdAngle);
ADDRLP4 0
ARGP4
ADDRLP4 28
ARGP4
ADDRLP4 0
ARGP4
ADDRLP4 12
INDIRI4
CVIF4 4
ARGF4
ADDRGP4 RotatePointAroundVector
CALLV
pop
line 771
;769:
;770:   // up
;771:   cmdAngle = ANGLE2SHORT(angle[ROLL]);
ADDRLP4 12
CNSTF4 1199570944
ADDRFP4 4
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
MULF4
CNSTF4 1135869952
DIVF4
CVFI4 4
CNSTI4 65535
BANDI4
ASGNI4
line 772
;772:   cmdAngle -= ent->client->pers.cmd.angles[ROLL];
ADDRLP4 12
ADDRLP4 12
INDIRI4
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 1396
ADDP4
INDIRI4
SUBI4
ASGNI4
line 773
;773:   RotatePointAroundVector(up, right, up, cmdAngle);
ADDRLP4 28
ARGP4
ADDRLP4 16
ARGP4
ADDRLP4 28
ARGP4
ADDRLP4 12
INDIRI4
CVIF4 4
ARGF4
ADDRGP4 RotatePointAroundVector
CALLV
pop
line 775
;774:   
;775:   VectorAdd(forward, up, forward);
ADDRLP4 0
ADDRLP4 0
INDIRF4
ADDRLP4 28
INDIRF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 0+4
INDIRF4
ADDRLP4 28+4
INDIRF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRLP4 0+8
INDIRF4
ADDRLP4 28+8
INDIRF4
ADDF4
ASGNF4
line 776
;776:   VectorAdd(forward, right, forward);
ADDRLP4 0
ADDRLP4 0
INDIRF4
ADDRLP4 16
INDIRF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 0+4
INDIRF4
ADDRLP4 16+4
INDIRF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRLP4 0+8
INDIRF4
ADDRLP4 16+8
INDIRF4
ADDF4
ASGNF4
line 778
;777:   
;778:   VectorCopy(forward, angle);
ADDRFP4 4
INDIRP4
ADDRLP4 0
INDIRB
ASGNB 12
line 790
;779:   
;780:   /*
;781:   // set the delta angle
;782:   for (i=0 ; i<3 ; i++) {
;783:		int		cmdAngle;
;784:
;785:		cmdAngle = ANGLE2SHORT(angle[i]);
;786:		ent->client->ps.delta_angles[i] = cmdAngle - ent->client->pers.cmd.angles[i];
;787:	}
;788:   */
;789:
;790:	VectorCopy( angle, ent->s.angles );
ADDRFP4 0
INDIRP4
CNSTI4 116
ADDP4
ADDRFP4 4
INDIRP4
INDIRB
ASGNB 12
line 791
;791:	VectorCopy (ent->s.angles, ent->client->ps.viewangles);
ADDRLP4 44
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 44
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 156
ADDP4
ADDRLP4 44
INDIRP4
CNSTI4 116
ADDP4
INDIRB
ASGNB 12
line 792
;792:}
LABELV $286
endproc SetClientViewAngle 48 16
export respawn
proc respawn 12 8
line 799
;793:
;794:/*
;795:================
;796:respawn
;797:================
;798:*/
;799:void respawn( gentity_t *ent ) {
line 802
;800:	gentity_t	*tent;
;801:
;802:	CopyToBodyQue (ent);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 CopyToBodyQue
CALLV
pop
line 804
;803:
;804:	if (gEscaping)
ADDRGP4 gEscaping
INDIRI4
CNSTI4 0
EQI4 $300
line 805
;805:	{
line 806
;806:		ent->client->sess.sessionTeam = TEAM_SPECTATOR;
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 1536
ADDP4
CNSTI4 3
ASGNI4
line 807
;807:		ent->client->sess.spectatorState = SPECTATOR_FREE;
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 1544
ADDP4
CNSTI4 1
ASGNI4
line 808
;808:		ent->client->sess.spectatorClient = 0;
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 1548
ADDP4
CNSTI4 0
ASGNI4
line 810
;809:
;810:		ent->client->pers.teamState.state = TEAM_BEGIN;
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 1472
ADDP4
CNSTI4 0
ASGNI4
line 811
;811:	}
LABELV $300
line 813
;812:
;813:	trap_UnlinkEntity (ent);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 trap_UnlinkEntity
CALLV
pop
line 814
;814:	ClientSpawn(ent);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 ClientSpawn
CALLV
pop
line 817
;815:
;816:	// add a teleportation effect
;817:	tent = G_TempEntity( ent->client->ps.origin, EV_PLAYER_TELEPORT_IN );
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 20
ADDP4
ARGP4
CNSTI4 59
ARGI4
ADDRLP4 4
ADDRGP4 G_TempEntity
CALLP4
ASGNP4
ADDRLP4 0
ADDRLP4 4
INDIRP4
ASGNP4
line 818
;818:	tent->s.clientNum = ent->s.clientNum;
ADDRLP4 8
CNSTI4 220
ASGNI4
ADDRLP4 0
INDIRP4
ADDRLP4 8
INDIRI4
ADDP4
ADDRFP4 0
INDIRP4
ADDRLP4 8
INDIRI4
ADDP4
INDIRI4
ASGNI4
line 819
;819:}
LABELV $299
endproc respawn 12 8
export TeamCount
proc TeamCount 8 0
line 828
;820:
;821:/*
;822:================
;823:TeamCount
;824:
;825:Returns number of players on a team
;826:================
;827:*/
;828:team_t TeamCount( int ignoreClientNum, int team ) {
line 830
;829:	int		i;
;830:	int		count = 0;
ADDRLP4 4
CNSTI4 0
ASGNI4
line 832
;831:
;832:	for ( i = 0 ; i < level.maxclients ; i++ ) {
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 $306
JUMPV
LABELV $303
line 833
;833:		if ( i == ignoreClientNum ) {
ADDRLP4 0
INDIRI4
ADDRFP4 0
INDIRI4
NEI4 $308
line 834
;834:			continue;
ADDRGP4 $304
JUMPV
LABELV $308
line 836
;835:		}
;836:		if ( level.clients[i].pers.connected == CON_DISCONNECTED ) {
CNSTI4 1804
ADDRLP4 0
INDIRI4
MULI4
ADDRGP4 level
INDIRP4
ADDP4
CNSTI4 1380
ADDP4
INDIRI4
CNSTI4 0
NEI4 $310
line 837
;837:			continue;
ADDRGP4 $304
JUMPV
LABELV $310
line 839
;838:		}
;839:		if ( level.clients[i].sess.sessionTeam == team ) {
CNSTI4 1804
ADDRLP4 0
INDIRI4
MULI4
ADDRGP4 level
INDIRP4
ADDP4
CNSTI4 1536
ADDP4
INDIRI4
ADDRFP4 4
INDIRI4
NEI4 $312
line 840
;840:			count++;
ADDRLP4 4
ADDRLP4 4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 841
;841:		}
LABELV $312
line 842
;842:	}
LABELV $304
line 832
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $306
ADDRLP4 0
INDIRI4
ADDRGP4 level+24
INDIRI4
LTI4 $303
line 844
;843:
;844:	return count;
ADDRLP4 4
INDIRI4
RETI4
LABELV $302
endproc TeamCount 8 0
export TeamLeader
proc TeamLeader 4 0
line 854
;845:}
;846:
;847:/*
;848:================
;849:TeamLeader
;850:
;851:Returns the client number of the team leader
;852:================
;853:*/
;854:int TeamLeader( int team ) {
line 857
;855:	int		i;
;856:
;857:	for ( i = 0 ; i < level.maxclients ; i++ ) {
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 $318
JUMPV
LABELV $315
line 858
;858:		if ( level.clients[i].pers.connected == CON_DISCONNECTED ) {
CNSTI4 1804
ADDRLP4 0
INDIRI4
MULI4
ADDRGP4 level
INDIRP4
ADDP4
CNSTI4 1380
ADDP4
INDIRI4
CNSTI4 0
NEI4 $320
line 859
;859:			continue;
ADDRGP4 $316
JUMPV
LABELV $320
line 861
;860:		}
;861:		if ( level.clients[i].sess.sessionTeam == team ) {
CNSTI4 1804
ADDRLP4 0
INDIRI4
MULI4
ADDRGP4 level
INDIRP4
ADDP4
CNSTI4 1536
ADDP4
INDIRI4
ADDRFP4 0
INDIRI4
NEI4 $322
line 862
;862:			if ( level.clients[i].sess.teamLeader )
CNSTI4 1804
ADDRLP4 0
INDIRI4
MULI4
ADDRGP4 level
INDIRP4
ADDP4
CNSTI4 1576
ADDP4
INDIRI4
CNSTI4 0
EQI4 $324
line 863
;863:				return i;
ADDRLP4 0
INDIRI4
RETI4
ADDRGP4 $314
JUMPV
LABELV $324
line 864
;864:		}
LABELV $322
line 865
;865:	}
LABELV $316
line 857
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $318
ADDRLP4 0
INDIRI4
ADDRGP4 level+24
INDIRI4
LTI4 $315
line 867
;866:
;867:	return -1;
CNSTI4 -1
RETI4
LABELV $314
endproc TeamLeader 4 0
export PickTeam
proc PickTeam 24 8
line 877
;868:}
;869:
;870:
;871:/*
;872:================
;873:PickTeam
;874:
;875:================
;876:*/
;877:team_t PickTeam( int ignoreClientNum ) {
line 880
;878:	int		counts[TEAM_NUM_TEAMS];
;879:
;880:	counts[TEAM_BLUE] = TeamCount( ignoreClientNum, TEAM_BLUE );
ADDRFP4 0
INDIRI4
ARGI4
CNSTI4 2
ARGI4
ADDRLP4 16
ADDRGP4 TeamCount
CALLI4
ASGNI4
ADDRLP4 0+8
ADDRLP4 16
INDIRI4
ASGNI4
line 881
;881:	counts[TEAM_RED] = TeamCount( ignoreClientNum, TEAM_RED );
ADDRFP4 0
INDIRI4
ARGI4
CNSTI4 1
ARGI4
ADDRLP4 20
ADDRGP4 TeamCount
CALLI4
ASGNI4
ADDRLP4 0+4
ADDRLP4 20
INDIRI4
ASGNI4
line 883
;882:
;883:	if ( counts[TEAM_BLUE] > counts[TEAM_RED] ) {
ADDRLP4 0+8
INDIRI4
ADDRLP4 0+4
INDIRI4
LEI4 $329
line 884
;884:		return TEAM_RED;
CNSTI4 1
RETI4
ADDRGP4 $326
JUMPV
LABELV $329
line 886
;885:	}
;886:	if ( counts[TEAM_RED] > counts[TEAM_BLUE] ) {
ADDRLP4 0+4
INDIRI4
ADDRLP4 0+8
INDIRI4
LEI4 $333
line 887
;887:		return TEAM_BLUE;
CNSTI4 2
RETI4
ADDRGP4 $326
JUMPV
LABELV $333
line 890
;888:	}
;889:	// equal team count, so join the team with the lowest score
;890:	if ( level.teamScores[TEAM_BLUE] > level.teamScores[TEAM_RED] ) {
ADDRGP4 level+44+8
INDIRI4
ADDRGP4 level+44+4
INDIRI4
LEI4 $337
line 891
;891:		return TEAM_RED;
CNSTI4 1
RETI4
ADDRGP4 $326
JUMPV
LABELV $337
line 893
;892:	}
;893:	return TEAM_BLUE;
CNSTI4 2
RETI4
LABELV $326
endproc PickTeam 24 8
proc ClientCleanName 40 12
line 921
;894:}
;895:
;896:/*
;897:===========
;898:ForceClientSkin
;899:
;900:Forces a client's skin (for teamplay)
;901:===========
;902:*/
;903:/*
;904:static void ForceClientSkin( gclient_t *client, char *model, const char *skin ) {
;905:	char *p;
;906:
;907:	if ((p = Q_strrchr(model, '/')) != 0) {
;908:		*p = 0;
;909:	}
;910:
;911:	Q_strcat(model, MAX_QPATH, "/");
;912:	Q_strcat(model, MAX_QPATH, skin);
;913:}
;914:*/
;915:
;916:/*
;917:===========
;918:ClientCheckName
;919:============
;920:*/
;921:static void ClientCleanName( const char *in, char *out, int outSize ) {
line 928
;922:	int		len, colorlessLen;
;923:	char	ch;
;924:	char	*p;
;925:	int		spaces;
;926:
;927:	//save room for trailing null byte
;928:	outSize--;
ADDRFP4 8
ADDRFP4 8
INDIRI4
CNSTI4 1
SUBI4
ASGNI4
line 930
;929:
;930:	len = 0;
ADDRLP4 4
CNSTI4 0
ASGNI4
line 931
;931:	colorlessLen = 0;
ADDRLP4 16
CNSTI4 0
ASGNI4
line 932
;932:	p = out;
ADDRLP4 12
ADDRFP4 4
INDIRP4
ASGNP4
line 933
;933:	*p = 0;
ADDRLP4 12
INDIRP4
CNSTI1 0
ASGNI1
line 934
;934:	spaces = 0;
ADDRLP4 8
CNSTI4 0
ASGNI4
ADDRGP4 $345
JUMPV
LABELV $344
line 936
;935:
;936:	while( 1 ) {
line 937
;937:		ch = *in++;
ADDRLP4 20
ADDRFP4 0
INDIRP4
ASGNP4
ADDRFP4 0
ADDRLP4 20
INDIRP4
CNSTI4 1
ADDP4
ASGNP4
ADDRLP4 0
ADDRLP4 20
INDIRP4
INDIRI1
ASGNI1
line 938
;938:		if( !ch ) {
ADDRLP4 0
INDIRI1
CVII4 1
CNSTI4 0
NEI4 $347
line 939
;939:			break;
ADDRGP4 $346
JUMPV
LABELV $347
line 943
;940:		}
;941:
;942:		// don't allow leading spaces
;943:		if( !*p && ch == ' ' ) {
ADDRLP4 12
INDIRP4
INDIRI1
CVII4 1
CNSTI4 0
NEI4 $349
ADDRLP4 0
INDIRI1
CVII4 1
CNSTI4 32
NEI4 $349
line 944
;944:			continue;
ADDRGP4 $345
JUMPV
LABELV $349
line 948
;945:		}
;946:
;947:		// check colors
;948:		if( ch == Q_COLOR_ESCAPE ) {
ADDRLP4 0
INDIRI1
CVII4 1
CNSTI4 94
NEI4 $351
line 950
;949:			// solo trailing carat is not a color prefix
;950:			if( !*in ) {
ADDRFP4 0
INDIRP4
INDIRI1
CVII4 1
CNSTI4 0
NEI4 $353
line 951
;951:				break;
ADDRGP4 $346
JUMPV
LABELV $353
line 955
;952:			}
;953:
;954:			// don't allow black in a name, period
;955:			if( ColorIndex(*in) == 0 ) {
ADDRFP4 0
INDIRP4
INDIRI1
CVII4 1
CNSTI4 48
SUBI4
CNSTI4 7
BANDI4
CNSTI4 0
NEI4 $355
line 956
;956:				in++;
ADDRFP4 0
ADDRFP4 0
INDIRP4
CNSTI4 1
ADDP4
ASGNP4
line 957
;957:				continue;
ADDRGP4 $345
JUMPV
LABELV $355
line 961
;958:			}
;959:
;960:			// make sure room in dest for both chars
;961:			if( len > outSize - 2 ) {
ADDRLP4 4
INDIRI4
ADDRFP4 8
INDIRI4
CNSTI4 2
SUBI4
LEI4 $357
line 962
;962:				break;
ADDRGP4 $346
JUMPV
LABELV $357
line 965
;963:			}
;964:
;965:			*out++ = ch;
ADDRLP4 24
ADDRFP4 4
INDIRP4
ASGNP4
ADDRFP4 4
ADDRLP4 24
INDIRP4
CNSTI4 1
ADDP4
ASGNP4
ADDRLP4 24
INDIRP4
ADDRLP4 0
INDIRI1
ASGNI1
line 966
;966:			*out++ = *in++;
ADDRLP4 28
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 36
CNSTI4 1
ASGNI4
ADDRFP4 4
ADDRLP4 28
INDIRP4
ADDRLP4 36
INDIRI4
ADDP4
ASGNP4
ADDRLP4 32
ADDRFP4 0
INDIRP4
ASGNP4
ADDRFP4 0
ADDRLP4 32
INDIRP4
ADDRLP4 36
INDIRI4
ADDP4
ASGNP4
ADDRLP4 28
INDIRP4
ADDRLP4 32
INDIRP4
INDIRI1
ASGNI1
line 967
;967:			len += 2;
ADDRLP4 4
ADDRLP4 4
INDIRI4
CNSTI4 2
ADDI4
ASGNI4
line 968
;968:			continue;
ADDRGP4 $345
JUMPV
LABELV $351
line 972
;969:		}
;970:
;971:		// don't allow too many consecutive spaces
;972:		if( ch == ' ' ) {
ADDRLP4 0
INDIRI1
CVII4 1
CNSTI4 32
NEI4 $359
line 973
;973:			spaces++;
ADDRLP4 8
ADDRLP4 8
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 974
;974:			if( spaces > 3 ) {
ADDRLP4 8
INDIRI4
CNSTI4 3
LEI4 $360
line 975
;975:				continue;
ADDRGP4 $345
JUMPV
line 977
;976:			}
;977:		}
LABELV $359
line 978
;978:		else {
line 979
;979:			spaces = 0;
ADDRLP4 8
CNSTI4 0
ASGNI4
line 980
;980:		}
LABELV $360
line 982
;981:
;982:		if( len > outSize - 1 ) {
ADDRLP4 4
INDIRI4
ADDRFP4 8
INDIRI4
CNSTI4 1
SUBI4
LEI4 $363
line 983
;983:			break;
ADDRGP4 $346
JUMPV
LABELV $363
line 986
;984:		}
;985:
;986:		*out++ = ch;
ADDRLP4 24
ADDRFP4 4
INDIRP4
ASGNP4
ADDRFP4 4
ADDRLP4 24
INDIRP4
CNSTI4 1
ADDP4
ASGNP4
ADDRLP4 24
INDIRP4
ADDRLP4 0
INDIRI1
ASGNI1
line 987
;987:		colorlessLen++;
ADDRLP4 16
ADDRLP4 16
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 988
;988:		len++;
ADDRLP4 4
ADDRLP4 4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 989
;989:	}
LABELV $345
line 936
ADDRGP4 $344
JUMPV
LABELV $346
line 990
;990:	*out = 0;
ADDRFP4 4
INDIRP4
CNSTI1 0
ASGNI1
line 993
;991:
;992:	// don't allow empty names
;993:	if( *p == 0 || colorlessLen == 0 ) {
ADDRLP4 20
CNSTI4 0
ASGNI4
ADDRLP4 12
INDIRP4
INDIRI1
CVII4 1
ADDRLP4 20
INDIRI4
EQI4 $367
ADDRLP4 16
INDIRI4
ADDRLP4 20
INDIRI4
NEI4 $365
LABELV $367
line 994
;994:		Q_strncpyz( p, "Padawan", outSize );
ADDRLP4 12
INDIRP4
ARGP4
ADDRGP4 $368
ARGP4
ADDRFP4 8
INDIRI4
ARGI4
ADDRGP4 Q_strncpyz
CALLV
pop
line 995
;995:	}
LABELV $365
line 996
;996:}
LABELV $343
endproc ClientCleanName 40 12
data
export g2SaberInstance
align 4
LABELV g2SaberInstance
byte 4 0
lit
align 4
LABELV $370
byte 4 0
byte 4 0
byte 4 0
export SetupGameGhoul2Model
code
proc SetupGameGhoul2Model 188 44
line 1021
;997:
;998:#ifdef _DEBUG
;999:void G_DebugWrite(const char *path, const char *text)
;1000:{
;1001:	fileHandle_t f;
;1002:
;1003:	trap_FS_FOpenFile( path, &f, FS_APPEND );
;1004:	trap_FS_Write(text, strlen(text), f);
;1005:	trap_FS_FCloseFile(f);
;1006:}
;1007:#endif
;1008:
;1009:/*
;1010:===========
;1011:SetupGameGhoul2Model
;1012:
;1013:There are two ghoul2 model instances per player (actually three).  One is on the clientinfo (the base for the client side 
;1014:player, and copied for player spawns and for corpses).  One is attached to the centity itself, which is the model acutally 
;1015:animated and rendered by the system.  The final is the game ghoul2 model.  This is animated by pmove on the server, and
;1016:is used for determining where the lightsaber should be, and for per-poly collision tests.
;1017:===========
;1018:*/
;1019:void *g2SaberInstance = NULL;
;1020:void SetupGameGhoul2Model(gclient_t *client, char *modelname)
;1021:{
line 1026
;1022:	int handle;
;1023:	char		afilename[MAX_QPATH];
;1024:	char		/**GLAName,*/ *slash;
;1025:	char		GLAName[MAX_QPATH];
;1026:	vec3_t	tempVec = {0,0,0};
ADDRLP4 64
ADDRGP4 $370
INDIRB
ASGNB 12
line 1029
;1027:
;1028:	// First things first.  If this is a ghoul2 model, then let's make sure we demolish this first.
;1029:	if (client->ghoul2 && trap_G2_HaveWeGhoul2Models(client->ghoul2))
ADDRLP4 148
ADDRFP4 0
INDIRP4
CNSTI4 1732
ADDP4
INDIRP4
ASGNP4
ADDRLP4 148
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $371
ADDRLP4 148
INDIRP4
ARGP4
ADDRLP4 152
ADDRGP4 trap_G2_HaveWeGhoul2Models
CALLI4
ASGNI4
ADDRLP4 152
INDIRI4
CNSTI4 0
EQI4 $371
line 1030
;1030:	{
line 1031
;1031:		trap_G2API_CleanGhoul2Models(&(client->ghoul2));
ADDRFP4 0
INDIRP4
CNSTI4 1732
ADDP4
ARGP4
ADDRGP4 trap_G2API_CleanGhoul2Models
CALLV
pop
line 1032
;1032:	}
LABELV $371
line 1050
;1033:
;1034:	/*
;1035:	Com_sprintf( afilename, sizeof( afilename ), "models/players/%s/model.glm", modelname );
;1036:	handle = trap_G2API_InitGhoul2Model(&client->ghoul2, afilename, 0, 0, -20, 0, 0);
;1037:	if (handle<0)
;1038:	{
;1039:		Com_sprintf( afilename, sizeof( afilename ), "models/players/kyle/model.glm" );
;1040:		handle = trap_G2API_InitGhoul2Model(&client->ghoul2, afilename, 0, 0, -20, 0, 0);
;1041:
;1042:		if (handle<0)
;1043:		{
;1044:			return;
;1045:		}
;1046:	}
;1047:	*/
;1048:
;1049:	//rww - just load the "standard" model for the server"
;1050:	if (!precachedKyle)
ADDRGP4 precachedKyle
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $373
line 1051
;1051:	{
line 1052
;1052:		Com_sprintf( afilename, sizeof( afilename ), "models/players/kyle/model.glm" );
ADDRLP4 0
ARGP4
CNSTI4 64
ARGI4
ADDRGP4 $375
ARGP4
ADDRGP4 Com_sprintf
CALLV
pop
line 1053
;1053:		handle = trap_G2API_InitGhoul2Model(&precachedKyle, afilename, 0, 0, -20, 0, 0);
ADDRGP4 precachedKyle
ARGP4
ADDRLP4 0
ARGP4
ADDRLP4 156
CNSTI4 0
ASGNI4
ADDRLP4 156
INDIRI4
ARGI4
ADDRLP4 156
INDIRI4
ARGI4
CNSTI4 -20
ARGI4
ADDRLP4 156
INDIRI4
ARGI4
ADDRLP4 156
INDIRI4
ARGI4
ADDRLP4 160
ADDRGP4 trap_G2API_InitGhoul2Model
CALLI4
ASGNI4
ADDRLP4 144
ADDRLP4 160
INDIRI4
ASGNI4
line 1055
;1054:
;1055:		if (handle<0)
ADDRLP4 144
INDIRI4
CNSTI4 0
GEI4 $376
line 1056
;1056:		{
line 1057
;1057:			return;
ADDRGP4 $369
JUMPV
LABELV $376
line 1059
;1058:		}
;1059:	}
LABELV $373
line 1061
;1060:
;1061:	if (precachedKyle && trap_G2_HaveWeGhoul2Models(precachedKyle))
ADDRLP4 156
ADDRGP4 precachedKyle
INDIRP4
ASGNP4
ADDRLP4 156
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $369
ADDRLP4 156
INDIRP4
ARGP4
ADDRLP4 160
ADDRGP4 trap_G2_HaveWeGhoul2Models
CALLI4
ASGNI4
ADDRLP4 160
INDIRI4
CNSTI4 0
EQI4 $369
line 1062
;1062:	{
line 1063
;1063:		trap_G2API_DuplicateGhoul2Instance(precachedKyle, &client->ghoul2);
ADDRGP4 precachedKyle
INDIRP4
ARGP4
ADDRFP4 0
INDIRP4
CNSTI4 1732
ADDP4
ARGP4
ADDRGP4 trap_G2API_DuplicateGhoul2Instance
CALLV
pop
line 1064
;1064:	}
line 1066
;1065:	else
;1066:	{
line 1067
;1067:		return;
LABELV $379
line 1072
;1068:	}
;1069:
;1070:	// The model is now loaded.
;1071:
;1072:	GLAName[0] = 0;
ADDRLP4 76
CNSTI1 0
ASGNI1
line 1074
;1073:
;1074:	if (!BGPAFtextLoaded)
ADDRGP4 BGPAFtextLoaded
INDIRI4
CNSTI4 0
NEI4 $380
line 1075
;1075:	{
line 1078
;1076:		//get the location of the animation.cfg
;1077:		//GLAName = trap_G2API_GetGLAName( client->ghoul2, 0);
;1078:		trap_G2API_GetGLAName( client->ghoul2, 0, GLAName);
ADDRFP4 0
INDIRP4
CNSTI4 1732
ADDP4
INDIRP4
ARGP4
CNSTI4 0
ARGI4
ADDRLP4 76
ARGP4
ADDRGP4 trap_G2API_GetGLAName
CALLV
pop
line 1080
;1079:
;1080:		if (!GLAName[0])
ADDRLP4 76
INDIRI1
CVII4 1
CNSTI4 0
NEI4 $382
line 1081
;1081:		{
line 1082
;1082:			if (!BG_ParseAnimationFile("models/players/_humanoid/animation.cfg"))
ADDRGP4 $386
ARGP4
ADDRLP4 164
ADDRGP4 BG_ParseAnimationFile
CALLI4
ASGNI4
ADDRLP4 164
INDIRI4
CNSTI4 0
NEI4 $369
line 1083
;1083:			{
line 1084
;1084:				Com_Printf( "Failed to load animation file %s\n", afilename );
ADDRGP4 $387
ARGP4
ADDRLP4 0
ARGP4
ADDRGP4 Com_Printf
CALLV
pop
line 1085
;1085:				return;
ADDRGP4 $369
JUMPV
line 1087
;1086:			}
;1087:			return;
LABELV $382
line 1089
;1088:		}
;1089:		Q_strncpyz( afilename, GLAName, sizeof( afilename ));
ADDRLP4 0
ARGP4
ADDRLP4 76
ARGP4
CNSTI4 64
ARGI4
ADDRGP4 Q_strncpyz
CALLV
pop
line 1090
;1090:		slash = Q_strrchr( afilename, '/' );
ADDRLP4 0
ARGP4
CNSTI4 47
ARGI4
ADDRLP4 164
ADDRGP4 Q_strrchr
CALLP4
ASGNP4
ADDRLP4 140
ADDRLP4 164
INDIRP4
ASGNP4
line 1091
;1091:		if ( slash )
ADDRLP4 140
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $369
line 1092
;1092:		{
line 1093
;1093:			strcpy(slash, "/animation.cfg");
ADDRLP4 140
INDIRP4
ARGP4
ADDRGP4 $390
ARGP4
ADDRGP4 strcpy
CALLP4
pop
line 1094
;1094:		}	// Now afilename holds just the path to the animation.cfg
line 1096
;1095:		else 
;1096:		{	// Didn't find any slashes, this is a raw filename right in base (whish isn't a good thing)
line 1097
;1097:			return;
LABELV $389
line 1101
;1098:		}
;1099:
;1100:		// Try to load the animation.cfg for this model then.
;1101:		if ( !BG_ParseAnimationFile( afilename ) )
ADDRLP4 0
ARGP4
ADDRLP4 168
ADDRGP4 BG_ParseAnimationFile
CALLI4
ASGNI4
ADDRLP4 168
INDIRI4
CNSTI4 0
NEI4 $391
line 1102
;1102:		{	// The GLA's animations failed
line 1103
;1103:			if (!BG_ParseAnimationFile("models/players/_humanoid/animation.cfg"))
ADDRGP4 $386
ARGP4
ADDRLP4 172
ADDRGP4 BG_ParseAnimationFile
CALLI4
ASGNI4
ADDRLP4 172
INDIRI4
CNSTI4 0
NEI4 $393
line 1104
;1104:			{
line 1105
;1105:				Com_Printf( "Failed to load animation file %s\n", afilename );
ADDRGP4 $387
ARGP4
ADDRLP4 0
ARGP4
ADDRGP4 Com_Printf
CALLV
pop
line 1106
;1106:				return;
ADDRGP4 $369
JUMPV
LABELV $393
line 1108
;1107:			}
;1108:		}
LABELV $391
line 1109
;1109:	}
LABELV $380
line 1111
;1110:
;1111:	trap_G2API_AddBolt(client->ghoul2, 0, "*r_hand");
ADDRFP4 0
INDIRP4
CNSTI4 1732
ADDP4
INDIRP4
ARGP4
CNSTI4 0
ARGI4
ADDRGP4 $395
ARGP4
ADDRGP4 trap_G2API_AddBolt
CALLI4
pop
line 1112
;1112:	trap_G2API_AddBolt(client->ghoul2, 0, "*l_hand");
ADDRFP4 0
INDIRP4
CNSTI4 1732
ADDP4
INDIRP4
ARGP4
CNSTI4 0
ARGI4
ADDRGP4 $396
ARGP4
ADDRGP4 trap_G2API_AddBolt
CALLI4
pop
line 1115
;1113:
;1114:	// NOTE - ensure this sequence of bolt and bone accessing are always the same because the client expects them in a certain order
;1115:	trap_G2API_SetBoneAnim(client->ghoul2, 0, "model_root", 0, 12, BONE_ANIM_OVERRIDE_LOOP, 1.0f, level.time, -1, -1);
ADDRFP4 0
INDIRP4
CNSTI4 1732
ADDP4
INDIRP4
ARGP4
ADDRLP4 164
CNSTI4 0
ASGNI4
ADDRLP4 164
INDIRI4
ARGI4
ADDRGP4 $397
ARGP4
ADDRLP4 164
INDIRI4
ARGI4
CNSTI4 12
ARGI4
CNSTI4 16
ARGI4
CNSTF4 1065353216
ARGF4
ADDRGP4 level+32
INDIRI4
ARGI4
CNSTF4 3212836864
ARGF4
CNSTI4 -1
ARGI4
ADDRGP4 trap_G2API_SetBoneAnim
CALLI4
pop
line 1116
;1116:	trap_G2API_SetBoneAngles(client->ghoul2, 0, "upper_lumbar", tempVec, BONE_ANGLES_POSTMULT, POSITIVE_X, NEGATIVE_Y, NEGATIVE_Z, NULL, 0, level.time);
ADDRFP4 0
INDIRP4
CNSTI4 1732
ADDP4
INDIRP4
ARGP4
ADDRLP4 168
CNSTI4 0
ASGNI4
ADDRLP4 168
INDIRI4
ARGI4
ADDRGP4 $399
ARGP4
ADDRLP4 64
ARGP4
CNSTI4 2
ARGI4
CNSTI4 1
ARGI4
CNSTI4 6
ARGI4
CNSTI4 5
ARGI4
CNSTP4 0
ARGP4
ADDRLP4 168
INDIRI4
ARGI4
ADDRGP4 level+32
INDIRI4
ARGI4
ADDRGP4 trap_G2API_SetBoneAngles
CALLI4
pop
line 1117
;1117:	trap_G2API_SetBoneAngles(client->ghoul2, 0, "cranium", tempVec, BONE_ANGLES_POSTMULT, POSITIVE_Z, NEGATIVE_Y, POSITIVE_X, NULL, 0, level.time);
ADDRFP4 0
INDIRP4
CNSTI4 1732
ADDP4
INDIRP4
ARGP4
ADDRLP4 172
CNSTI4 0
ASGNI4
ADDRLP4 172
INDIRI4
ARGI4
ADDRGP4 $401
ARGP4
ADDRLP4 64
ARGP4
ADDRLP4 176
CNSTI4 2
ASGNI4
ADDRLP4 176
INDIRI4
ARGI4
ADDRLP4 176
INDIRI4
ARGI4
CNSTI4 6
ARGI4
CNSTI4 1
ARGI4
CNSTP4 0
ARGP4
ADDRLP4 172
INDIRI4
ARGI4
ADDRGP4 level+32
INDIRI4
ARGI4
ADDRGP4 trap_G2API_SetBoneAngles
CALLI4
pop
line 1119
;1118:
;1119:	if (!g2SaberInstance)
ADDRGP4 g2SaberInstance
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $403
line 1120
;1120:	{
line 1121
;1121:		trap_G2API_InitGhoul2Model(&g2SaberInstance, "models/weapons2/saber/saber_w.glm", 0, 0, -20, 0, 0);
ADDRGP4 g2SaberInstance
ARGP4
ADDRGP4 $119
ARGP4
ADDRLP4 180
CNSTI4 0
ASGNI4
ADDRLP4 180
INDIRI4
ARGI4
ADDRLP4 180
INDIRI4
ARGI4
CNSTI4 -20
ARGI4
ADDRLP4 180
INDIRI4
ARGI4
ADDRLP4 180
INDIRI4
ARGI4
ADDRGP4 trap_G2API_InitGhoul2Model
CALLI4
pop
line 1123
;1122:
;1123:		if (g2SaberInstance)
ADDRGP4 g2SaberInstance
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $405
line 1124
;1124:		{
line 1126
;1125:			// indicate we will be bolted to model 0 (ie the player) on bolt 0 (always the right hand) when we get copied
;1126:			trap_G2API_SetBoltInfo(g2SaberInstance, 0, 0);
ADDRGP4 g2SaberInstance
INDIRP4
ARGP4
ADDRLP4 184
CNSTI4 0
ASGNI4
ADDRLP4 184
INDIRI4
ARGI4
ADDRLP4 184
INDIRI4
ARGI4
ADDRGP4 trap_G2API_SetBoltInfo
CALLV
pop
line 1128
;1127:			// now set up the gun bolt on it
;1128:			trap_G2API_AddBolt(g2SaberInstance, 0, "*flash");
ADDRGP4 g2SaberInstance
INDIRP4
ARGP4
CNSTI4 0
ARGI4
ADDRGP4 $407
ARGP4
ADDRGP4 trap_G2API_AddBolt
CALLI4
pop
line 1129
;1129:		}
LABELV $405
line 1130
;1130:	}
LABELV $403
line 1132
;1131:
;1132:	if (g2SaberInstance)
ADDRGP4 g2SaberInstance
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $408
line 1133
;1133:	{
line 1134
;1134:		trap_G2API_CopySpecificGhoul2Model(g2SaberInstance, 0, client->ghoul2, 1); 
ADDRGP4 g2SaberInstance
INDIRP4
ARGP4
CNSTI4 0
ARGI4
ADDRFP4 0
INDIRP4
CNSTI4 1732
ADDP4
INDIRP4
ARGP4
CNSTI4 1
ARGI4
ADDRGP4 trap_G2API_CopySpecificGhoul2Model
CALLV
pop
line 1135
;1135:	}
LABELV $408
line 1136
;1136:}
LABELV $369
endproc SetupGameGhoul2Model 188 44
export ClientUserinfoChanged
proc ClientUserinfoChanged 6372 52
line 1152
;1137:
;1138:
;1139:
;1140:
;1141:/*
;1142:===========
;1143:ClientUserInfoChanged
;1144:
;1145:Called from ClientConnect when the player first connects and
;1146:directly by the server system when the player updates a userinfo variable.
;1147:
;1148:The game can override any of the settings and call trap_SetUserinfo
;1149:if desired.
;1150:============
;1151:*/
;1152:void ClientUserinfoChanged( int clientNum ) {
line 1167
;1153:	gentity_t *ent;
;1154:	int		teamTask, teamLeader, team, health;
;1155:	char	*s;
;1156:	char	model[MAX_QPATH];
;1157:	//char	headModel[MAX_QPATH];
;1158:	char	forcePowers[MAX_QPATH];
;1159:	char	oldname[MAX_STRING_CHARS];
;1160:	gclient_t	*client;
;1161:	char	c1[MAX_INFO_STRING];
;1162:	char	c2[MAX_INFO_STRING];
;1163:	char	redTeam[MAX_INFO_STRING];
;1164:	char	blueTeam[MAX_INFO_STRING];
;1165:	char	userinfo[MAX_INFO_STRING];
;1166:
;1167:	ent = g_entities + clientNum;
ADDRLP4 1032
CNSTI4 828
ADDRFP4 0
INDIRI4
MULI4
ADDRGP4 g_entities
ADDP4
ASGNP4
line 1168
;1168:	client = ent->client;
ADDRLP4 0
ADDRLP4 1032
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
ASGNP4
line 1170
;1169:
;1170:	trap_GetUserinfo( clientNum, userinfo, sizeof( userinfo ) );
ADDRFP4 0
INDIRI4
ARGI4
ADDRLP4 4
ARGP4
CNSTI4 1024
ARGI4
ADDRGP4 trap_GetUserinfo
CALLV
pop
line 1173
;1171:
;1172:	// check for malformed or illegal info strings
;1173:	if ( !Info_Validate(userinfo) ) {
ADDRLP4 4
ARGP4
ADDRLP4 6300
ADDRGP4 Info_Validate
CALLI4
ASGNI4
ADDRLP4 6300
INDIRI4
CNSTI4 0
NEI4 $411
line 1174
;1174:		strcpy (userinfo, "\\name\\badinfo");
ADDRLP4 4
ARGP4
ADDRGP4 $413
ARGP4
ADDRGP4 strcpy
CALLP4
pop
line 1175
;1175:	}
LABELV $411
line 1178
;1176:
;1177:	// check for local client
;1178:	s = Info_ValueForKey( userinfo, "ip" );
ADDRLP4 4
ARGP4
ADDRGP4 $414
ARGP4
ADDRLP4 6304
ADDRGP4 Info_ValueForKey
CALLP4
ASGNP4
ADDRLP4 1028
ADDRLP4 6304
INDIRP4
ASGNP4
line 1179
;1179:	if ( !strcmp( s, "localhost" ) ) {
ADDRLP4 1028
INDIRP4
ARGP4
ADDRGP4 $417
ARGP4
ADDRLP4 6308
ADDRGP4 strcmp
CALLI4
ASGNI4
ADDRLP4 6308
INDIRI4
CNSTI4 0
NEI4 $415
line 1180
;1180:		client->pers.localClient = qtrue;
ADDRLP4 0
INDIRP4
CNSTI4 1412
ADDP4
CNSTI4 1
ASGNI4
line 1181
;1181:	}
LABELV $415
line 1184
;1182:
;1183:	// check the item prediction
;1184:	s = Info_ValueForKey( userinfo, "cg_predictItems" );
ADDRLP4 4
ARGP4
ADDRGP4 $418
ARGP4
ADDRLP4 6312
ADDRGP4 Info_ValueForKey
CALLP4
ASGNP4
ADDRLP4 1028
ADDRLP4 6312
INDIRP4
ASGNP4
line 1185
;1185:	if ( !atoi( s ) ) {
ADDRLP4 1028
INDIRP4
ARGP4
ADDRLP4 6316
ADDRGP4 atoi
CALLI4
ASGNI4
ADDRLP4 6316
INDIRI4
CNSTI4 0
NEI4 $419
line 1186
;1186:		client->pers.predictItemPickup = qfalse;
ADDRLP4 0
INDIRP4
CNSTI4 1420
ADDP4
CNSTI4 0
ASGNI4
line 1187
;1187:	} else {
ADDRGP4 $420
JUMPV
LABELV $419
line 1188
;1188:		client->pers.predictItemPickup = qtrue;
ADDRLP4 0
INDIRP4
CNSTI4 1420
ADDP4
CNSTI4 1
ASGNI4
line 1189
;1189:	}
LABELV $420
line 1192
;1190:
;1191:	// set name
;1192:	Q_strncpyz ( oldname, client->pers.netname, sizeof( oldname ) );
ADDRLP4 1100
ARGP4
ADDRLP4 0
INDIRP4
CNSTI4 1428
ADDP4
ARGP4
CNSTI4 1024
ARGI4
ADDRGP4 Q_strncpyz
CALLV
pop
line 1193
;1193:	s = Info_ValueForKey (userinfo, "name");
ADDRLP4 4
ARGP4
ADDRGP4 $421
ARGP4
ADDRLP4 6320
ADDRGP4 Info_ValueForKey
CALLP4
ASGNP4
ADDRLP4 1028
ADDRLP4 6320
INDIRP4
ASGNP4
line 1194
;1194:	ClientCleanName( s, client->pers.netname, sizeof(client->pers.netname) );
ADDRLP4 1028
INDIRP4
ARGP4
ADDRLP4 0
INDIRP4
CNSTI4 1428
ADDP4
ARGP4
CNSTI4 36
ARGI4
ADDRGP4 ClientCleanName
CALLV
pop
line 1196
;1195:
;1196:	if ( client->sess.sessionTeam == TEAM_SPECTATOR ) {
ADDRLP4 0
INDIRP4
CNSTI4 1536
ADDP4
INDIRI4
CNSTI4 3
NEI4 $422
line 1197
;1197:		if ( client->sess.spectatorState == SPECTATOR_SCOREBOARD ) {
ADDRLP4 0
INDIRP4
CNSTI4 1544
ADDP4
INDIRI4
CNSTI4 3
NEI4 $424
line 1198
;1198:			Q_strncpyz( client->pers.netname, "scoreboard", sizeof(client->pers.netname) );
ADDRLP4 0
INDIRP4
CNSTI4 1428
ADDP4
ARGP4
ADDRGP4 $426
ARGP4
CNSTI4 36
ARGI4
ADDRGP4 Q_strncpyz
CALLV
pop
line 1199
;1199:		}
LABELV $424
line 1200
;1200:	}
LABELV $422
line 1202
;1201:
;1202:	if ( client->pers.connected == CON_CONNECTED ) {
ADDRLP4 0
INDIRP4
CNSTI4 1380
ADDP4
INDIRI4
CNSTI4 2
NEI4 $427
line 1203
;1203:		if ( strcmp( oldname, client->pers.netname ) ) {
ADDRLP4 1100
ARGP4
ADDRLP4 0
INDIRP4
CNSTI4 1428
ADDP4
ARGP4
ADDRLP4 6324
ADDRGP4 strcmp
CALLI4
ASGNI4
ADDRLP4 6324
INDIRI4
CNSTI4 0
EQI4 $429
line 1204
;1204:			trap_SendServerCommand( -1, va("print \"%s" S_COLOR_WHITE " %s %s\n\"", oldname, G_GetStripEdString("SVINGAME", "PLRENAME"),
ADDRGP4 $159
ARGP4
ADDRGP4 $432
ARGP4
ADDRLP4 6328
ADDRGP4 G_GetStripEdString
CALLP4
ASGNP4
ADDRGP4 $431
ARGP4
ADDRLP4 1100
ARGP4
ADDRLP4 6328
INDIRP4
ARGP4
ADDRLP4 0
INDIRP4
CNSTI4 1428
ADDP4
ARGP4
ADDRLP4 6332
ADDRGP4 va
CALLP4
ASGNP4
CNSTI4 -1
ARGI4
ADDRLP4 6332
INDIRP4
ARGP4
ADDRGP4 trap_SendServerCommand
CALLV
pop
line 1206
;1205:				client->pers.netname) );
;1206:		}
LABELV $429
line 1207
;1207:	}
LABELV $427
line 1210
;1208:
;1209:	// set max health
;1210:	health = 100; //atoi( Info_ValueForKey( userinfo, "handicap" ) );
ADDRLP4 2132
CNSTI4 100
ASGNI4
line 1211
;1211:	client->pers.maxHealth = health;
ADDRLP4 0
INDIRP4
CNSTI4 1464
ADDP4
ADDRLP4 2132
INDIRI4
ASGNI4
line 1212
;1212:	if ( client->pers.maxHealth < 1 || client->pers.maxHealth > 100 ) {
ADDRLP4 6324
ADDRLP4 0
INDIRP4
CNSTI4 1464
ADDP4
INDIRI4
ASGNI4
ADDRLP4 6324
INDIRI4
CNSTI4 1
LTI4 $435
ADDRLP4 6324
INDIRI4
CNSTI4 100
LEI4 $433
LABELV $435
line 1213
;1213:		client->pers.maxHealth = 100;
ADDRLP4 0
INDIRP4
CNSTI4 1464
ADDP4
CNSTI4 100
ASGNI4
line 1214
;1214:	}
LABELV $433
line 1215
;1215:	client->ps.stats[STAT_MAX_HEALTH] = client->pers.maxHealth;
ADDRLP4 0
INDIRP4
CNSTI4 248
ADDP4
ADDRLP4 0
INDIRP4
CNSTI4 1464
ADDP4
INDIRI4
ASGNI4
line 1218
;1216:
;1217:	// set model
;1218:	if( g_gametype.integer >= GT_TEAM ) {
ADDRGP4 g_gametype+12
INDIRI4
CNSTI4 5
LTI4 $436
line 1219
;1219:		Q_strncpyz( model, Info_ValueForKey (userinfo, "team_model"), sizeof( model ) );
ADDRLP4 4
ARGP4
ADDRGP4 $439
ARGP4
ADDRLP4 6332
ADDRGP4 Info_ValueForKey
CALLP4
ASGNP4
ADDRLP4 1036
ARGP4
ADDRLP4 6332
INDIRP4
ARGP4
CNSTI4 64
ARGI4
ADDRGP4 Q_strncpyz
CALLV
pop
line 1221
;1220:		//Q_strncpyz( headModel, Info_ValueForKey (userinfo, "team_headmodel"), sizeof( headModel ) );
;1221:	} else {
ADDRGP4 $437
JUMPV
LABELV $436
line 1222
;1222:		Q_strncpyz( model, Info_ValueForKey (userinfo, "model"), sizeof( model ) );
ADDRLP4 4
ARGP4
ADDRGP4 $440
ARGP4
ADDRLP4 6332
ADDRGP4 Info_ValueForKey
CALLP4
ASGNP4
ADDRLP4 1036
ARGP4
ADDRLP4 6332
INDIRP4
ARGP4
CNSTI4 64
ARGI4
ADDRGP4 Q_strncpyz
CALLV
pop
line 1224
;1223:		//Q_strncpyz( headModel, Info_ValueForKey (userinfo, "headmodel"), sizeof( headModel ) );
;1224:	}
LABELV $437
line 1226
;1225:
;1226:	Q_strncpyz( forcePowers, Info_ValueForKey (userinfo, "forcepowers"), sizeof( forcePowers ) );
ADDRLP4 4
ARGP4
ADDRGP4 $441
ARGP4
ADDRLP4 6332
ADDRGP4 Info_ValueForKey
CALLP4
ASGNP4
ADDRLP4 2136
ARGP4
ADDRLP4 6332
INDIRP4
ARGP4
CNSTI4 64
ARGI4
ADDRGP4 Q_strncpyz
CALLV
pop
line 1229
;1227:
;1228:	// bots set their team a few frames later
;1229:	if (g_gametype.integer >= GT_TEAM && g_entities[clientNum].r.svFlags & SVF_BOT) {
ADDRGP4 g_gametype+12
INDIRI4
CNSTI4 5
LTI4 $442
CNSTI4 828
ADDRFP4 0
INDIRI4
MULI4
ADDRGP4 g_entities+296+8
ADDP4
INDIRI4
CNSTI4 8
BANDI4
CNSTI4 0
EQI4 $442
line 1230
;1230:		s = Info_ValueForKey( userinfo, "team" );
ADDRLP4 4
ARGP4
ADDRGP4 $447
ARGP4
ADDRLP4 6336
ADDRGP4 Info_ValueForKey
CALLP4
ASGNP4
ADDRLP4 1028
ADDRLP4 6336
INDIRP4
ASGNP4
line 1231
;1231:		if ( !Q_stricmp( s, "red" ) || !Q_stricmp( s, "r" ) ) {
ADDRLP4 1028
INDIRP4
ARGP4
ADDRGP4 $450
ARGP4
ADDRLP4 6340
ADDRGP4 Q_stricmp
CALLI4
ASGNI4
ADDRLP4 6340
INDIRI4
CNSTI4 0
EQI4 $452
ADDRLP4 1028
INDIRP4
ARGP4
ADDRGP4 $451
ARGP4
ADDRLP4 6344
ADDRGP4 Q_stricmp
CALLI4
ASGNI4
ADDRLP4 6344
INDIRI4
CNSTI4 0
NEI4 $448
LABELV $452
line 1232
;1232:			team = TEAM_RED;
ADDRLP4 4248
CNSTI4 1
ASGNI4
line 1233
;1233:		} else if ( !Q_stricmp( s, "blue" ) || !Q_stricmp( s, "b" ) ) {
ADDRGP4 $443
JUMPV
LABELV $448
ADDRLP4 1028
INDIRP4
ARGP4
ADDRGP4 $455
ARGP4
ADDRLP4 6348
ADDRGP4 Q_stricmp
CALLI4
ASGNI4
ADDRLP4 6348
INDIRI4
CNSTI4 0
EQI4 $457
ADDRLP4 1028
INDIRP4
ARGP4
ADDRGP4 $456
ARGP4
ADDRLP4 6352
ADDRGP4 Q_stricmp
CALLI4
ASGNI4
ADDRLP4 6352
INDIRI4
CNSTI4 0
NEI4 $453
LABELV $457
line 1234
;1234:			team = TEAM_BLUE;
ADDRLP4 4248
CNSTI4 2
ASGNI4
line 1235
;1235:		} else {
ADDRGP4 $443
JUMPV
LABELV $453
line 1237
;1236:			// pick the team with the least number of players
;1237:			team = PickTeam( clientNum );
ADDRFP4 0
INDIRI4
ARGI4
ADDRLP4 6356
ADDRGP4 PickTeam
CALLI4
ASGNI4
ADDRLP4 4248
ADDRLP4 6356
INDIRI4
ASGNI4
line 1238
;1238:		}
line 1239
;1239:	}
ADDRGP4 $443
JUMPV
LABELV $442
line 1240
;1240:	else {
line 1241
;1241:		team = client->sess.sessionTeam;
ADDRLP4 4248
ADDRLP4 0
INDIRP4
CNSTI4 1536
ADDP4
INDIRI4
ASGNI4
line 1242
;1242:	}
LABELV $443
line 1265
;1243:
;1244:/*	NOTE: all client side now
;1245:
;1246:	// team
;1247:	switch( team ) {
;1248:	case TEAM_RED:
;1249:		ForceClientSkin(client, model, "red");
;1250://		ForceClientSkin(client, headModel, "red");
;1251:		break;
;1252:	case TEAM_BLUE:
;1253:		ForceClientSkin(client, model, "blue");
;1254://		ForceClientSkin(client, headModel, "blue");
;1255:		break;
;1256:	}
;1257:	// don't ever use a default skin in teamplay, it would just waste memory
;1258:	// however bots will always join a team but they spawn in as spectator
;1259:	if ( g_gametype.integer >= GT_TEAM && team == TEAM_SPECTATOR) {
;1260:		ForceClientSkin(client, model, "red");
;1261://		ForceClientSkin(client, headModel, "red");
;1262:	}
;1263:*/
;1264:
;1265:	if (g_gametype.integer >= GT_TEAM) {
ADDRGP4 g_gametype+12
INDIRI4
CNSTI4 5
LTI4 $458
line 1266
;1266:		client->pers.teamInfo = qtrue;
ADDRLP4 0
INDIRP4
CNSTI4 1528
ADDP4
CNSTI4 1
ASGNI4
line 1267
;1267:	} else {
ADDRGP4 $459
JUMPV
LABELV $458
line 1268
;1268:		s = Info_ValueForKey( userinfo, "teamoverlay" );
ADDRLP4 4
ARGP4
ADDRGP4 $461
ARGP4
ADDRLP4 6336
ADDRGP4 Info_ValueForKey
CALLP4
ASGNP4
ADDRLP4 1028
ADDRLP4 6336
INDIRP4
ASGNP4
line 1269
;1269:		if ( ! *s || atoi( s ) != 0 ) {
ADDRLP4 1028
INDIRP4
INDIRI1
CVII4 1
CNSTI4 0
EQI4 $464
ADDRLP4 1028
INDIRP4
ARGP4
ADDRLP4 6344
ADDRGP4 atoi
CALLI4
ASGNI4
ADDRLP4 6344
INDIRI4
CNSTI4 0
EQI4 $462
LABELV $464
line 1270
;1270:			client->pers.teamInfo = qtrue;
ADDRLP4 0
INDIRP4
CNSTI4 1528
ADDP4
CNSTI4 1
ASGNI4
line 1271
;1271:		} else {
ADDRGP4 $463
JUMPV
LABELV $462
line 1272
;1272:			client->pers.teamInfo = qfalse;
ADDRLP4 0
INDIRP4
CNSTI4 1528
ADDP4
CNSTI4 0
ASGNI4
line 1273
;1273:		}
LABELV $463
line 1274
;1274:	}
LABELV $459
line 1286
;1275:	/*
;1276:	s = Info_ValueForKey( userinfo, "cg_pmove_fixed" );
;1277:	if ( !*s || atoi( s ) == 0 ) {
;1278:		client->pers.pmoveFixed = qfalse;
;1279:	}
;1280:	else {
;1281:		client->pers.pmoveFixed = qtrue;
;1282:	}
;1283:	*/
;1284:
;1285:	// team task (0 = none, 1 = offence, 2 = defence)
;1286:	teamTask = atoi(Info_ValueForKey(userinfo, "teamtask"));
ADDRLP4 4
ARGP4
ADDRGP4 $465
ARGP4
ADDRLP4 6336
ADDRGP4 Info_ValueForKey
CALLP4
ASGNP4
ADDRLP4 6336
INDIRP4
ARGP4
ADDRLP4 6340
ADDRGP4 atoi
CALLI4
ASGNI4
ADDRLP4 2124
ADDRLP4 6340
INDIRI4
ASGNI4
line 1288
;1287:	// team Leader (1 = leader, 0 is normal player)
;1288:	teamLeader = client->sess.teamLeader;
ADDRLP4 2128
ADDRLP4 0
INDIRP4
CNSTI4 1576
ADDP4
INDIRI4
ASGNI4
line 1291
;1289:
;1290:	// colors
;1291:	strcpy(c1, Info_ValueForKey( userinfo, "color1" ));
ADDRLP4 4
ARGP4
ADDRGP4 $466
ARGP4
ADDRLP4 6344
ADDRGP4 Info_ValueForKey
CALLP4
ASGNP4
ADDRLP4 2200
ARGP4
ADDRLP4 6344
INDIRP4
ARGP4
ADDRGP4 strcpy
CALLP4
pop
line 1292
;1292:	strcpy(c2, Info_ValueForKey( userinfo, "color2" ));
ADDRLP4 4
ARGP4
ADDRGP4 $467
ARGP4
ADDRLP4 6348
ADDRGP4 Info_ValueForKey
CALLP4
ASGNP4
ADDRLP4 3224
ARGP4
ADDRLP4 6348
INDIRP4
ARGP4
ADDRGP4 strcpy
CALLP4
pop
line 1294
;1293:
;1294:	strcpy(redTeam, Info_ValueForKey( userinfo, "g_redteam" ));
ADDRLP4 4
ARGP4
ADDRGP4 $468
ARGP4
ADDRLP4 6352
ADDRGP4 Info_ValueForKey
CALLP4
ASGNP4
ADDRLP4 4252
ARGP4
ADDRLP4 6352
INDIRP4
ARGP4
ADDRGP4 strcpy
CALLP4
pop
line 1295
;1295:	strcpy(blueTeam, Info_ValueForKey( userinfo, "g_blueteam" ));
ADDRLP4 4
ARGP4
ADDRGP4 $469
ARGP4
ADDRLP4 6356
ADDRGP4 Info_ValueForKey
CALLP4
ASGNP4
ADDRLP4 5276
ARGP4
ADDRLP4 6356
INDIRP4
ARGP4
ADDRGP4 strcpy
CALLP4
pop
line 1299
;1296:
;1297:	// send over a subset of the userinfo keys so other clients can
;1298:	// print scoreboards, display models, and play custom sounds
;1299:	if ( ent->r.svFlags & SVF_BOT ) {
ADDRLP4 1032
INDIRP4
CNSTI4 304
ADDP4
INDIRI4
CNSTI4 8
BANDI4
CNSTI4 0
EQI4 $470
line 1300
;1300:		s = va("n\\%s\\t\\%i\\model\\%s\\c1\\%s\\c2\\%s\\hc\\%i\\w\\%i\\l\\%i\\skill\\%s\\tt\\%d\\tl\\%d",
ADDRLP4 4
ARGP4
ADDRGP4 $473
ARGP4
ADDRLP4 6360
ADDRGP4 Info_ValueForKey
CALLP4
ASGNP4
ADDRGP4 $472
ARGP4
ADDRLP4 0
INDIRP4
CNSTI4 1428
ADDP4
ARGP4
ADDRLP4 4248
INDIRI4
ARGI4
ADDRLP4 1036
ARGP4
ADDRLP4 2200
ARGP4
ADDRLP4 3224
ARGP4
ADDRLP4 0
INDIRP4
CNSTI4 1464
ADDP4
INDIRI4
ARGI4
ADDRLP4 0
INDIRP4
CNSTI4 1552
ADDP4
INDIRI4
ARGI4
ADDRLP4 0
INDIRP4
CNSTI4 1556
ADDP4
INDIRI4
ARGI4
ADDRLP4 6360
INDIRP4
ARGP4
ADDRLP4 2124
INDIRI4
ARGI4
ADDRLP4 2128
INDIRI4
ARGI4
ADDRLP4 6368
ADDRGP4 va
CALLP4
ASGNP4
ADDRLP4 1028
ADDRLP4 6368
INDIRP4
ASGNP4
line 1304
;1301:			client->pers.netname, team, model,  c1, c2, 
;1302:			client->pers.maxHealth, client->sess.wins, client->sess.losses,
;1303:			Info_ValueForKey( userinfo, "skill" ), teamTask, teamLeader );
;1304:	} else {
ADDRGP4 $471
JUMPV
LABELV $470
line 1305
;1305:		s = va("n\\%s\\t\\%i\\model\\%s\\g_redteam\\%s\\g_blueteam\\%s\\c1\\%s\\c2\\%s\\hc\\%i\\w\\%i\\l\\%i\\tt\\%d\\tl\\%d",
ADDRGP4 $474
ARGP4
ADDRLP4 0
INDIRP4
CNSTI4 1428
ADDP4
ARGP4
ADDRLP4 0
INDIRP4
CNSTI4 1536
ADDP4
INDIRI4
ARGI4
ADDRLP4 1036
ARGP4
ADDRLP4 4252
ARGP4
ADDRLP4 5276
ARGP4
ADDRLP4 2200
ARGP4
ADDRLP4 3224
ARGP4
ADDRLP4 0
INDIRP4
CNSTI4 1464
ADDP4
INDIRI4
ARGI4
ADDRLP4 0
INDIRP4
CNSTI4 1552
ADDP4
INDIRI4
ARGI4
ADDRLP4 0
INDIRP4
CNSTI4 1556
ADDP4
INDIRI4
ARGI4
ADDRLP4 2124
INDIRI4
ARGI4
ADDRLP4 2128
INDIRI4
ARGI4
ADDRLP4 6364
ADDRGP4 va
CALLP4
ASGNP4
ADDRLP4 1028
ADDRLP4 6364
INDIRP4
ASGNP4
line 1308
;1306:			client->pers.netname, client->sess.sessionTeam, model, redTeam, blueTeam, c1, c2, 
;1307:			client->pers.maxHealth, client->sess.wins, client->sess.losses, teamTask, teamLeader);
;1308:	}
LABELV $471
line 1317
;1309:
;1310:   // adnan
;1311:   // tie fighter throttle stuff
;1312:   // - doing it with BUTTON defines now.
;1313:
;1314:   // adnan
;1315:   
;1316:   //client->pers.throttle = atoi(Info_ValueForKey( userinfo, "cg_throttle" ));
;1317:   client->ps.stats[STAT_THROTTLE] = client->pers.throttle;
ADDRLP4 0
INDIRP4
CNSTI4 252
ADDP4
ADDRLP4 0
INDIRP4
CNSTI4 1532
ADDP4
INDIRI4
ASGNI4
line 1322
;1318:   
;1319:   //client->ps.stats[STAT_ROLL] = atoi(Info_ValueForKey( userinfo, "cg_roll" ));
;1320:   
;1321:
;1322:	trap_SetConfigstring( CS_PLAYERS+clientNum, s );
ADDRFP4 0
INDIRI4
CNSTI4 544
ADDI4
ARGI4
ADDRLP4 1028
INDIRP4
ARGP4
ADDRGP4 trap_SetConfigstring
CALLV
pop
line 1324
;1323:
;1324:	if (g_logClientInfo.integer)
ADDRGP4 g_logClientInfo+12
INDIRI4
CNSTI4 0
EQI4 $475
line 1325
;1325:	{
line 1326
;1326:		G_LogPrintf( "ClientUserinfoChanged: %i %s\n", clientNum, s );
ADDRGP4 $478
ARGP4
ADDRFP4 0
INDIRI4
ARGI4
ADDRLP4 1028
INDIRP4
ARGP4
ADDRGP4 G_LogPrintf
CALLV
pop
line 1327
;1327:	}
LABELV $475
line 1328
;1328:}
LABELV $410
endproc ClientUserinfoChanged 6372 52
bss
align 1
LABELV $493
skip 1024
export ClientConnect
code
proc ClientConnect 1068 12
line 1351
;1329:
;1330:
;1331:/*
;1332:===========
;1333:ClientConnect
;1334:
;1335:Called when a player begins connecting to the server.
;1336:Called again for every map change or tournement restart.
;1337:
;1338:The session information will be valid after exit.
;1339:
;1340:Return NULL if the client should be allowed, otherwise return
;1341:a string with the reason for denial.
;1342:
;1343:Otherwise, the client will be sent the current gamestate
;1344:and will eventually get to ClientBegin.
;1345:
;1346:firstTime will be qtrue the very first time a client connects
;1347:to the server machine, but qfalse on map changes and tournement
;1348:restarts.
;1349:============
;1350:*/
;1351:char *ClientConnect( int clientNum, qboolean firstTime, qboolean isBot ) {
line 1359
;1352:	char		*value;
;1353://	char		*areabits;
;1354:	gclient_t	*client;
;1355:	char		userinfo[MAX_INFO_STRING];
;1356:	gentity_t	*ent;
;1357:	gentity_t	*te;
;1358:
;1359:	ent = &g_entities[ clientNum ];
ADDRLP4 4
CNSTI4 828
ADDRFP4 0
INDIRI4
MULI4
ADDRGP4 g_entities
ADDP4
ASGNP4
line 1361
;1360:
;1361:	trap_GetUserinfo( clientNum, userinfo, sizeof( userinfo ) );
ADDRFP4 0
INDIRI4
ARGI4
ADDRLP4 8
ARGP4
CNSTI4 1024
ARGI4
ADDRGP4 trap_GetUserinfo
CALLV
pop
line 1364
;1362:
;1363:	// check to see if they are on the banned IP list
;1364:	value = Info_ValueForKey (userinfo, "ip");
ADDRLP4 8
ARGP4
ADDRGP4 $414
ARGP4
ADDRLP4 1040
ADDRGP4 Info_ValueForKey
CALLP4
ASGNP4
ADDRLP4 1032
ADDRLP4 1040
INDIRP4
ASGNP4
line 1365
;1365:	if ( G_FilterPacket( value ) ) {
ADDRLP4 1032
INDIRP4
ARGP4
ADDRLP4 1044
ADDRGP4 G_FilterPacket
CALLI4
ASGNI4
ADDRLP4 1044
INDIRI4
CNSTI4 0
EQI4 $480
line 1366
;1366:		return "Banned.";
ADDRGP4 $482
RETP4
ADDRGP4 $479
JUMPV
LABELV $480
line 1369
;1367:	}
;1368:
;1369:	if ( !( ent->r.svFlags & SVF_BOT ) && !isBot && g_needpass.integer ) {
ADDRLP4 1048
CNSTI4 0
ASGNI4
ADDRLP4 4
INDIRP4
CNSTI4 304
ADDP4
INDIRI4
CNSTI4 8
BANDI4
ADDRLP4 1048
INDIRI4
NEI4 $483
ADDRFP4 8
INDIRI4
ADDRLP4 1048
INDIRI4
NEI4 $483
ADDRGP4 g_needpass+12
INDIRI4
ADDRLP4 1048
INDIRI4
EQI4 $483
line 1371
;1370:		// check for a password
;1371:		value = Info_ValueForKey (userinfo, "password");
ADDRLP4 8
ARGP4
ADDRGP4 $486
ARGP4
ADDRLP4 1052
ADDRGP4 Info_ValueForKey
CALLP4
ASGNP4
ADDRLP4 1032
ADDRLP4 1052
INDIRP4
ASGNP4
line 1372
;1372:		if ( g_password.string[0] && Q_stricmp( g_password.string, "none" ) &&
ADDRGP4 g_password+16
INDIRI1
CVII4 1
CNSTI4 0
EQI4 $487
ADDRGP4 g_password+16
ARGP4
ADDRGP4 $491
ARGP4
ADDRLP4 1056
ADDRGP4 Q_stricmp
CALLI4
ASGNI4
ADDRLP4 1056
INDIRI4
CNSTI4 0
EQI4 $487
ADDRGP4 g_password+16
ARGP4
ADDRLP4 1032
INDIRP4
ARGP4
ADDRLP4 1060
ADDRGP4 strcmp
CALLI4
ASGNI4
ADDRLP4 1060
INDIRI4
CNSTI4 0
EQI4 $487
line 1373
;1373:			strcmp( g_password.string, value) != 0) {
line 1375
;1374:			static char sTemp[1024];
;1375:			Q_strncpyz(sTemp, G_GetStripEdString("SVINGAME","INVALID_PASSWORD"), sizeof (sTemp) );
ADDRGP4 $159
ARGP4
ADDRGP4 $494
ARGP4
ADDRLP4 1064
ADDRGP4 G_GetStripEdString
CALLP4
ASGNP4
ADDRGP4 $493
ARGP4
ADDRLP4 1064
INDIRP4
ARGP4
CNSTI4 1024
ARGI4
ADDRGP4 Q_strncpyz
CALLV
pop
line 1376
;1376:			return sTemp;// return "Invalid password";
ADDRGP4 $493
RETP4
ADDRGP4 $479
JUMPV
LABELV $487
line 1378
;1377:		}
;1378:	}
LABELV $483
line 1381
;1379:
;1380:	// they can connect
;1381:	ent->client = level.clients + clientNum;
ADDRLP4 4
INDIRP4
CNSTI4 408
ADDP4
CNSTI4 1804
ADDRFP4 0
INDIRI4
MULI4
ADDRGP4 level
INDIRP4
ADDP4
ASGNP4
line 1382
;1382:	client = ent->client;
ADDRLP4 0
ADDRLP4 4
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
ASGNP4
line 1386
;1383:
;1384://	areabits = client->areabits;
;1385:
;1386:	memset( client, 0, sizeof(*client) );
ADDRLP4 0
INDIRP4
ARGP4
CNSTI4 0
ARGI4
CNSTI4 1804
ARGI4
ADDRGP4 memset
CALLP4
pop
line 1388
;1387:
;1388:	client->pers.connected = CON_CONNECTING;
ADDRLP4 0
INDIRP4
CNSTI4 1380
ADDP4
CNSTI4 1
ASGNI4
line 1391
;1389:
;1390:	// read or initialize the session data
;1391:	if ( firstTime || level.newSession ) {
ADDRLP4 1052
CNSTI4 0
ASGNI4
ADDRFP4 4
INDIRI4
ADDRLP4 1052
INDIRI4
NEI4 $498
ADDRGP4 level+64
INDIRI4
ADDRLP4 1052
INDIRI4
EQI4 $495
LABELV $498
line 1392
;1392:		G_InitSessionData( client, userinfo, isBot );
ADDRLP4 0
INDIRP4
ARGP4
ADDRLP4 8
ARGP4
ADDRFP4 8
INDIRI4
ARGI4
ADDRGP4 G_InitSessionData
CALLV
pop
line 1393
;1393:	}
LABELV $495
line 1394
;1394:	G_ReadSessionData( client );
ADDRLP4 0
INDIRP4
ARGP4
ADDRGP4 G_ReadSessionData
CALLV
pop
line 1396
;1395:
;1396:	if( isBot ) {
ADDRFP4 8
INDIRI4
CNSTI4 0
EQI4 $499
line 1397
;1397:		ent->r.svFlags |= SVF_BOT;
ADDRLP4 1056
ADDRLP4 4
INDIRP4
CNSTI4 304
ADDP4
ASGNP4
ADDRLP4 1056
INDIRP4
ADDRLP4 1056
INDIRP4
INDIRI4
CNSTI4 8
BORI4
ASGNI4
line 1398
;1398:		ent->inuse = qtrue;
ADDRLP4 4
INDIRP4
CNSTI4 412
ADDP4
CNSTI4 1
ASGNI4
line 1399
;1399:		if( !G_BotConnect( clientNum, !firstTime ) ) {
ADDRFP4 0
INDIRI4
ARGI4
ADDRFP4 4
INDIRI4
CNSTI4 0
NEI4 $504
ADDRLP4 1060
CNSTI4 1
ASGNI4
ADDRGP4 $505
JUMPV
LABELV $504
ADDRLP4 1060
CNSTI4 0
ASGNI4
LABELV $505
ADDRLP4 1060
INDIRI4
ARGI4
ADDRLP4 1064
ADDRGP4 G_BotConnect
CALLI4
ASGNI4
ADDRLP4 1064
INDIRI4
CNSTI4 0
NEI4 $501
line 1400
;1400:			return "BotConnectfailed";
ADDRGP4 $506
RETP4
ADDRGP4 $479
JUMPV
LABELV $501
line 1402
;1401:		}
;1402:	}
LABELV $499
line 1405
;1403:
;1404:	// get and distribute relevent paramters
;1405:	G_LogPrintf( "ClientConnect: %i\n", clientNum );
ADDRGP4 $507
ARGP4
ADDRFP4 0
INDIRI4
ARGI4
ADDRGP4 G_LogPrintf
CALLV
pop
line 1406
;1406:	ClientUserinfoChanged( clientNum );
ADDRFP4 0
INDIRI4
ARGI4
ADDRGP4 ClientUserinfoChanged
CALLV
pop
line 1409
;1407:
;1408:	// don't do the "xxx connected" messages if they were caried over from previous level
;1409:	if ( firstTime ) {
ADDRFP4 4
INDIRI4
CNSTI4 0
EQI4 $508
line 1410
;1410:		trap_SendServerCommand( -1, va("print \"%s" S_COLOR_WHITE " %s\n\"", client->pers.netname, G_GetStripEdString("SVINGAME", "PLCONNECT")) );
ADDRGP4 $159
ARGP4
ADDRGP4 $511
ARGP4
ADDRLP4 1056
ADDRGP4 G_GetStripEdString
CALLP4
ASGNP4
ADDRGP4 $510
ARGP4
ADDRLP4 0
INDIRP4
CNSTI4 1428
ADDP4
ARGP4
ADDRLP4 1056
INDIRP4
ARGP4
ADDRLP4 1060
ADDRGP4 va
CALLP4
ASGNP4
CNSTI4 -1
ARGI4
ADDRLP4 1060
INDIRP4
ARGP4
ADDRGP4 trap_SendServerCommand
CALLV
pop
line 1411
;1411:	}
LABELV $508
line 1413
;1412:
;1413:	if ( g_gametype.integer >= GT_TEAM &&
ADDRGP4 g_gametype+12
INDIRI4
CNSTI4 5
LTI4 $512
ADDRLP4 0
INDIRP4
CNSTI4 1536
ADDP4
INDIRI4
CNSTI4 3
EQI4 $512
line 1414
;1414:		client->sess.sessionTeam != TEAM_SPECTATOR ) {
line 1415
;1415:		BroadcastTeamChange( client, -1 );
ADDRLP4 0
INDIRP4
ARGP4
CNSTI4 -1
ARGI4
ADDRGP4 BroadcastTeamChange
CALLV
pop
line 1416
;1416:	}
LABELV $512
line 1419
;1417:
;1418:	// count current clients and rank for scoreboard
;1419:	CalculateRanks();
ADDRGP4 CalculateRanks
CALLV
pop
line 1421
;1420:
;1421:	te = G_TempEntity( vec3_origin, EV_CLIENTJOIN );
ADDRGP4 vec3_origin
ARGP4
CNSTI4 1
ARGI4
ADDRLP4 1056
ADDRGP4 G_TempEntity
CALLP4
ASGNP4
ADDRLP4 1036
ADDRLP4 1056
INDIRP4
ASGNP4
line 1422
;1422:	te->r.svFlags |= SVF_BROADCAST;
ADDRLP4 1060
ADDRLP4 1036
INDIRP4
CNSTI4 304
ADDP4
ASGNP4
ADDRLP4 1060
INDIRP4
ADDRLP4 1060
INDIRP4
INDIRI4
CNSTI4 32
BORI4
ASGNI4
line 1423
;1423:	te->s.eventParm = clientNum;
ADDRLP4 1036
INDIRP4
CNSTI4 256
ADDP4
ADDRFP4 0
INDIRI4
ASGNI4
line 1430
;1424:
;1425:	// for statistics
;1426://	client->areabits = areabits;
;1427://	if ( !client->areabits )
;1428://		client->areabits = G_Alloc( (trap_AAS_PointReachabilityAreaIndex( NULL ) + 7) / 8 );
;1429:
;1430:	return NULL;
CNSTP4 0
RETP4
LABELV $479
endproc ClientConnect 1068 12
export ClientBegin
proc ClientBegin 1108 12
line 1444
;1431:}
;1432:
;1433:void G_WriteClientSessionData( gclient_t *client );
;1434:
;1435:/*
;1436:===========
;1437:ClientBegin
;1438:
;1439:called when a client has finished connecting, and is ready
;1440:to be placed into the level.  This will happen every level load,
;1441:and on transition between teams, but doesn't happen on respawns
;1442:============
;1443:*/
;1444:void ClientBegin( int clientNum, qboolean allowTeamReset ) {
line 1451
;1445:	gentity_t	*ent;
;1446:	gclient_t	*client;
;1447:	gentity_t	*tent;
;1448:	int			flags, i;
;1449:	char		userinfo[MAX_INFO_VALUE], *modelname;
;1450:
;1451:	ent = g_entities + clientNum;
ADDRLP4 4
CNSTI4 828
ADDRFP4 0
INDIRI4
MULI4
ADDRGP4 g_entities
ADDP4
ASGNP4
line 1453
;1452:
;1453:	if ((ent->r.svFlags & SVF_BOT) && g_gametype.integer >= GT_TEAM)
ADDRLP4 4
INDIRP4
CNSTI4 304
ADDP4
INDIRI4
CNSTI4 8
BANDI4
CNSTI4 0
EQI4 $516
ADDRGP4 g_gametype+12
INDIRI4
CNSTI4 5
LTI4 $516
line 1454
;1454:	{
line 1455
;1455:		if (allowTeamReset)
ADDRFP4 4
INDIRI4
CNSTI4 0
EQI4 $519
line 1456
;1456:		{
line 1457
;1457:			const char *team = "Red";
ADDRLP4 1048
ADDRGP4 $521
ASGNP4
line 1461
;1458:			int preSess;
;1459:
;1460:			//SetTeam(ent, "");
;1461:			ent->client->sess.sessionTeam = PickTeam(-1);
CNSTI4 -1
ARGI4
ADDRLP4 1056
ADDRGP4 PickTeam
CALLI4
ASGNI4
ADDRLP4 4
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 1536
ADDP4
ADDRLP4 1056
INDIRI4
ASGNI4
line 1462
;1462:			trap_GetUserinfo(clientNum, userinfo, MAX_INFO_STRING);
ADDRFP4 0
INDIRI4
ARGI4
ADDRLP4 12
ARGP4
CNSTI4 1024
ARGI4
ADDRGP4 trap_GetUserinfo
CALLV
pop
line 1464
;1463:
;1464:			if (ent->client->sess.sessionTeam == TEAM_SPECTATOR)
ADDRLP4 4
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 1536
ADDP4
INDIRI4
CNSTI4 3
NEI4 $522
line 1465
;1465:			{
line 1466
;1466:				ent->client->sess.sessionTeam = TEAM_RED;
ADDRLP4 4
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 1536
ADDP4
CNSTI4 1
ASGNI4
line 1467
;1467:			}
LABELV $522
line 1469
;1468:
;1469:			if (ent->client->sess.sessionTeam == TEAM_RED)
ADDRLP4 4
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 1536
ADDP4
INDIRI4
CNSTI4 1
NEI4 $524
line 1470
;1470:			{
line 1471
;1471:				team = "Red";
ADDRLP4 1048
ADDRGP4 $521
ASGNP4
line 1472
;1472:			}
ADDRGP4 $525
JUMPV
LABELV $524
line 1474
;1473:			else
;1474:			{
line 1475
;1475:				team = "Blue";
ADDRLP4 1048
ADDRGP4 $526
ASGNP4
line 1476
;1476:			}
LABELV $525
line 1478
;1477:
;1478:			Info_SetValueForKey( userinfo, "team", team );
ADDRLP4 12
ARGP4
ADDRGP4 $447
ARGP4
ADDRLP4 1048
INDIRP4
ARGP4
ADDRGP4 Info_SetValueForKey
CALLV
pop
line 1480
;1479:
;1480:			trap_SetUserinfo( clientNum, userinfo );
ADDRFP4 0
INDIRI4
ARGI4
ADDRLP4 12
ARGP4
ADDRGP4 trap_SetUserinfo
CALLV
pop
line 1482
;1481:
;1482:			ent->client->ps.persistant[ PERS_TEAM ] = ent->client->sess.sessionTeam;
ADDRLP4 1060
ADDRLP4 4
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
ASGNP4
ADDRLP4 1060
INDIRP4
CNSTI4 292
ADDP4
ADDRLP4 1060
INDIRP4
CNSTI4 1536
ADDP4
INDIRI4
ASGNI4
line 1484
;1483:
;1484:			preSess = ent->client->sess.sessionTeam;
ADDRLP4 1052
ADDRLP4 4
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 1536
ADDP4
INDIRI4
ASGNI4
line 1485
;1485:			G_ReadSessionData( ent->client );
ADDRLP4 4
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
ARGP4
ADDRGP4 G_ReadSessionData
CALLV
pop
line 1486
;1486:			ent->client->sess.sessionTeam = preSess;
ADDRLP4 4
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 1536
ADDP4
ADDRLP4 1052
INDIRI4
ASGNI4
line 1487
;1487:			G_WriteClientSessionData(ent->client);
ADDRLP4 4
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
ARGP4
ADDRGP4 G_WriteClientSessionData
CALLV
pop
line 1488
;1488:			ClientUserinfoChanged( clientNum );
ADDRFP4 0
INDIRI4
ARGI4
ADDRGP4 ClientUserinfoChanged
CALLV
pop
line 1489
;1489:			ClientBegin(clientNum, qfalse);
ADDRFP4 0
INDIRI4
ARGI4
CNSTI4 0
ARGI4
ADDRGP4 ClientBegin
CALLV
pop
line 1490
;1490:			return;
ADDRGP4 $515
JUMPV
LABELV $519
line 1492
;1491:		}
;1492:	}
LABELV $516
line 1494
;1493:
;1494:	client = level.clients + clientNum;
ADDRLP4 8
CNSTI4 1804
ADDRFP4 0
INDIRI4
MULI4
ADDRGP4 level
INDIRP4
ADDP4
ASGNP4
line 1496
;1495:
;1496:	if ( ent->r.linked ) {
ADDRLP4 4
INDIRP4
CNSTI4 296
ADDP4
INDIRI4
CNSTI4 0
EQI4 $527
line 1497
;1497:		trap_UnlinkEntity( ent );
ADDRLP4 4
INDIRP4
ARGP4
ADDRGP4 trap_UnlinkEntity
CALLV
pop
line 1498
;1498:	}
LABELV $527
line 1499
;1499:	G_InitGentity( ent );
ADDRLP4 4
INDIRP4
ARGP4
ADDRGP4 G_InitGentity
CALLV
pop
line 1500
;1500:	ent->touch = 0;
ADDRLP4 4
INDIRP4
CNSTI4 648
ADDP4
CNSTP4 0
ASGNP4
line 1501
;1501:	ent->pain = 0;
ADDRLP4 4
INDIRP4
CNSTI4 656
ADDP4
CNSTP4 0
ASGNP4
line 1502
;1502:	ent->client = client;
ADDRLP4 4
INDIRP4
CNSTI4 408
ADDP4
ADDRLP4 8
INDIRP4
ASGNP4
line 1504
;1503:
;1504:	client->pers.connected = CON_CONNECTED;
ADDRLP4 8
INDIRP4
CNSTI4 1380
ADDP4
CNSTI4 2
ASGNI4
line 1505
;1505:	client->pers.enterTime = level.time;
ADDRLP4 8
INDIRP4
CNSTI4 1468
ADDP4
ADDRGP4 level+32
INDIRI4
ASGNI4
line 1506
;1506:	client->pers.teamState.state = TEAM_BEGIN;
ADDRLP4 8
INDIRP4
CNSTI4 1472
ADDP4
CNSTI4 0
ASGNI4
line 1513
;1507:
;1508:	// save eflags around this, because changing teams will
;1509:	// cause this to happen with a valid entity, and we
;1510:	// want to make sure the teleport bit is set right
;1511:	// so the viewpoint doesn't interpolate through the
;1512:	// world to the new position
;1513:	flags = client->ps.eFlags;
ADDRLP4 1036
ADDRLP4 8
INDIRP4
CNSTI4 108
ADDP4
INDIRI4
ASGNI4
line 1515
;1514:
;1515:	i = 0;
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 $531
JUMPV
LABELV $530
line 1518
;1516:
;1517:	while (i < NUM_FORCE_POWERS)
;1518:	{
line 1519
;1519:		if (ent->client->ps.fd.forcePowersActive & (1 << i))
ADDRLP4 4
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 848
ADDP4
INDIRI4
CNSTI4 1
ADDRLP4 0
INDIRI4
LSHI4
BANDI4
CNSTI4 0
EQI4 $533
line 1520
;1520:		{
line 1521
;1521:			WP_ForcePowerStop(ent, i);
ADDRLP4 4
INDIRP4
ARGP4
ADDRLP4 0
INDIRI4
ARGI4
ADDRGP4 WP_ForcePowerStop
CALLV
pop
line 1522
;1522:		}
LABELV $533
line 1523
;1523:		i++;
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 1524
;1524:	}
LABELV $531
line 1517
ADDRLP4 0
INDIRI4
CNSTI4 18
LTI4 $530
line 1526
;1525:
;1526:	i = TRACK_CHANNEL_1;
ADDRLP4 0
CNSTI4 51
ASGNI4
ADDRGP4 $536
JUMPV
LABELV $535
line 1529
;1527:
;1528:	while (i < NUM_TRACK_CHANNELS)
;1529:	{
line 1530
;1530:		if (ent->client->ps.fd.killSoundEntIndex[i-50] && ent->client->ps.fd.killSoundEntIndex[i-50] < MAX_GENTITIES && ent->client->ps.fd.killSoundEntIndex[i-50] > 0)
ADDRLP4 1048
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
CNSTI4 200
SUBI4
ADDRLP4 4
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 1200
ADDP4
ADDP4
INDIRI4
ASGNI4
ADDRLP4 1052
CNSTI4 0
ASGNI4
ADDRLP4 1048
INDIRI4
ADDRLP4 1052
INDIRI4
EQI4 $538
ADDRLP4 1048
INDIRI4
CNSTI4 1024
GEI4 $538
ADDRLP4 1048
INDIRI4
ADDRLP4 1052
INDIRI4
LEI4 $538
line 1531
;1531:		{
line 1532
;1532:			G_MuteSound(ent->client->ps.fd.killSoundEntIndex[i-50], CHAN_VOICE);
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
CNSTI4 200
SUBI4
ADDRLP4 4
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 1200
ADDP4
ADDP4
INDIRI4
ARGI4
CNSTI4 3
ARGI4
ADDRGP4 G_MuteSound
CALLV
pop
line 1533
;1533:		}
LABELV $538
line 1534
;1534:		i++;
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 1535
;1535:	}
LABELV $536
line 1528
ADDRLP4 0
INDIRI4
CNSTI4 56
LTI4 $535
line 1536
;1536:	i = 0;
ADDRLP4 0
CNSTI4 0
ASGNI4
line 1538
;1537:
;1538:	memset( &client->ps, 0, sizeof( client->ps ) );
ADDRLP4 8
INDIRP4
ARGP4
CNSTI4 0
ARGI4
CNSTI4 1380
ARGI4
ADDRGP4 memset
CALLP4
pop
line 1539
;1539:	client->ps.eFlags = flags;
ADDRLP4 8
INDIRP4
CNSTI4 108
ADDP4
ADDRLP4 1036
INDIRI4
ASGNI4
line 1541
;1540:
;1541:	client->ps.hasDetPackPlanted = qfalse;
ADDRLP4 8
INDIRP4
CNSTI4 640
ADDP4
CNSTI4 0
ASGNI4
line 1544
;1542:
;1543:	//first-time force power initialization
;1544:	WP_InitForcePowers( ent );
ADDRLP4 4
INDIRP4
ARGP4
ADDRGP4 WP_InitForcePowers
CALLV
pop
line 1547
;1545:
;1546:	//init saber ent
;1547:	WP_SaberInitBladeData( ent );
ADDRLP4 4
INDIRP4
ARGP4
ADDRGP4 WP_SaberInitBladeData
CALLV
pop
line 1550
;1548:
;1549:	// First time model setup for that player.
;1550:	trap_GetUserinfo( clientNum, userinfo, sizeof(userinfo) );
ADDRFP4 0
INDIRI4
ARGI4
ADDRLP4 12
ARGP4
CNSTI4 1024
ARGI4
ADDRGP4 trap_GetUserinfo
CALLV
pop
line 1551
;1551:	modelname = Info_ValueForKey (userinfo,  "model");
ADDRLP4 12
ARGP4
ADDRGP4 $440
ARGP4
ADDRLP4 1048
ADDRGP4 Info_ValueForKey
CALLP4
ASGNP4
ADDRLP4 1040
ADDRLP4 1048
INDIRP4
ASGNP4
line 1554
;1552:	// adnan
;1553:   // dont use ghoul2
;1554:   SetupGameGhoul2Model(client, modelname);
ADDRLP4 8
INDIRP4
ARGP4
ADDRLP4 1040
INDIRP4
ARGP4
ADDRGP4 SetupGameGhoul2Model
CALLV
pop
line 1557
;1555:   //ent->re = trap_R_RegisterModel(forceHolocronModels[s1->modelindex+128]);
;1556:
;1557:	if (ent->client->ghoul2)
ADDRLP4 4
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 1732
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $540
line 1558
;1558:	{
line 1559
;1559:		ent->bolt_Head = trap_G2API_AddBolt(ent->client->ghoul2, 0, "cranium");
ADDRLP4 4
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 1732
ADDP4
INDIRP4
ARGP4
CNSTI4 0
ARGI4
ADDRGP4 $401
ARGP4
ADDRLP4 1056
ADDRGP4 trap_G2API_AddBolt
CALLI4
ASGNI4
ADDRLP4 4
INDIRP4
CNSTI4 784
ADDP4
ADDRLP4 1056
INDIRI4
ASGNI4
line 1560
;1560:		ent->bolt_Waist = trap_G2API_AddBolt(ent->client->ghoul2, 0, "thoracic");
ADDRLP4 4
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 1732
ADDP4
INDIRP4
ARGP4
CNSTI4 0
ARGI4
ADDRGP4 $542
ARGP4
ADDRLP4 1064
ADDRGP4 trap_G2API_AddBolt
CALLI4
ASGNI4
ADDRLP4 4
INDIRP4
CNSTI4 804
ADDP4
ADDRLP4 1064
INDIRI4
ASGNI4
line 1561
;1561:		ent->bolt_LArm = trap_G2API_AddBolt(ent->client->ghoul2, 0, "lradius");
ADDRLP4 4
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 1732
ADDP4
INDIRP4
ARGP4
CNSTI4 0
ARGI4
ADDRGP4 $543
ARGP4
ADDRLP4 1072
ADDRGP4 trap_G2API_AddBolt
CALLI4
ASGNI4
ADDRLP4 4
INDIRP4
CNSTI4 788
ADDP4
ADDRLP4 1072
INDIRI4
ASGNI4
line 1562
;1562:		ent->bolt_RArm = trap_G2API_AddBolt(ent->client->ghoul2, 0, "rradius");
ADDRLP4 4
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 1732
ADDP4
INDIRP4
ARGP4
CNSTI4 0
ARGI4
ADDRGP4 $544
ARGP4
ADDRLP4 1080
ADDRGP4 trap_G2API_AddBolt
CALLI4
ASGNI4
ADDRLP4 4
INDIRP4
CNSTI4 792
ADDP4
ADDRLP4 1080
INDIRI4
ASGNI4
line 1563
;1563:		ent->bolt_LLeg = trap_G2API_AddBolt(ent->client->ghoul2, 0, "ltibia");
ADDRLP4 4
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 1732
ADDP4
INDIRP4
ARGP4
CNSTI4 0
ARGI4
ADDRGP4 $545
ARGP4
ADDRLP4 1088
ADDRGP4 trap_G2API_AddBolt
CALLI4
ASGNI4
ADDRLP4 4
INDIRP4
CNSTI4 796
ADDP4
ADDRLP4 1088
INDIRI4
ASGNI4
line 1564
;1564:		ent->bolt_RLeg = trap_G2API_AddBolt(ent->client->ghoul2, 0, "rtibia");
ADDRLP4 4
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 1732
ADDP4
INDIRP4
ARGP4
CNSTI4 0
ARGI4
ADDRGP4 $546
ARGP4
ADDRLP4 1096
ADDRGP4 trap_G2API_AddBolt
CALLI4
ASGNI4
ADDRLP4 4
INDIRP4
CNSTI4 800
ADDP4
ADDRLP4 1096
INDIRI4
ASGNI4
line 1565
;1565:		ent->bolt_Motion = trap_G2API_AddBolt(ent->client->ghoul2, 0, "Motion");
ADDRLP4 4
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 1732
ADDP4
INDIRP4
ARGP4
CNSTI4 0
ARGI4
ADDRGP4 $547
ARGP4
ADDRLP4 1104
ADDRGP4 trap_G2API_AddBolt
CALLI4
ASGNI4
ADDRLP4 4
INDIRP4
CNSTI4 808
ADDP4
ADDRLP4 1104
INDIRI4
ASGNI4
line 1566
;1566:	}
LABELV $540
line 1569
;1567:
;1568:	// locate ent at a spawn point
;1569:	ClientSpawn( ent );
ADDRLP4 4
INDIRP4
ARGP4
ADDRGP4 ClientSpawn
CALLV
pop
line 1571
;1570:
;1571:	if ( client->sess.sessionTeam != TEAM_SPECTATOR ) {
ADDRLP4 8
INDIRP4
CNSTI4 1536
ADDP4
INDIRI4
CNSTI4 3
EQI4 $548
line 1573
;1572:		// send event
;1573:		tent = G_TempEntity( ent->client->ps.origin, EV_PLAYER_TELEPORT_IN );
ADDRLP4 4
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 20
ADDP4
ARGP4
CNSTI4 59
ARGI4
ADDRLP4 1052
ADDRGP4 G_TempEntity
CALLP4
ASGNP4
ADDRLP4 1044
ADDRLP4 1052
INDIRP4
ASGNP4
line 1574
;1574:		tent->s.clientNum = ent->s.clientNum;
ADDRLP4 1056
CNSTI4 220
ASGNI4
ADDRLP4 1044
INDIRP4
ADDRLP4 1056
INDIRI4
ADDP4
ADDRLP4 4
INDIRP4
ADDRLP4 1056
INDIRI4
ADDP4
INDIRI4
ASGNI4
line 1576
;1575:
;1576:		if ( g_gametype.integer != GT_TOURNAMENT  ) {
ADDRGP4 g_gametype+12
INDIRI4
CNSTI4 3
EQI4 $550
line 1577
;1577:			trap_SendServerCommand( -1, va("print \"%s" S_COLOR_WHITE " %s\n\"", client->pers.netname, G_GetStripEdString("SVINGAME", "PLENTER")) );
ADDRGP4 $159
ARGP4
ADDRGP4 $553
ARGP4
ADDRLP4 1060
ADDRGP4 G_GetStripEdString
CALLP4
ASGNP4
ADDRGP4 $510
ARGP4
ADDRLP4 8
INDIRP4
CNSTI4 1428
ADDP4
ARGP4
ADDRLP4 1060
INDIRP4
ARGP4
ADDRLP4 1064
ADDRGP4 va
CALLP4
ASGNP4
CNSTI4 -1
ARGI4
ADDRLP4 1064
INDIRP4
ARGP4
ADDRGP4 trap_SendServerCommand
CALLV
pop
line 1578
;1578:		}
LABELV $550
line 1579
;1579:	}
LABELV $548
line 1580
;1580:	G_LogPrintf( "ClientBegin: %i\n", clientNum );
ADDRGP4 $554
ARGP4
ADDRFP4 0
INDIRI4
ARGI4
ADDRGP4 G_LogPrintf
CALLV
pop
line 1583
;1581:
;1582:	// count current clients and rank for scoreboard
;1583:	CalculateRanks();
ADDRGP4 CalculateRanks
CALLV
pop
line 1585
;1584:
;1585:	G_ClearClientLog(clientNum);
ADDRFP4 0
INDIRI4
ARGI4
ADDRGP4 G_ClearClientLog
CALLV
pop
line 1586
;1586:}
LABELV $515
endproc ClientBegin 1108 12
proc AllForceDisabled 4 0
line 1589
;1587:
;1588:static qboolean AllForceDisabled(int force)
;1589:{
line 1592
;1590:	int i;
;1591:
;1592:	if (force)
ADDRFP4 0
INDIRI4
CNSTI4 0
EQI4 $556
line 1593
;1593:	{
line 1594
;1594:		for (i=0;i<NUM_FORCE_POWERS;i++)
ADDRLP4 0
CNSTI4 0
ASGNI4
LABELV $558
line 1595
;1595:		{
line 1596
;1596:			if (!(force & (1<<i)))
ADDRFP4 0
INDIRI4
CNSTI4 1
ADDRLP4 0
INDIRI4
LSHI4
BANDI4
CNSTI4 0
NEI4 $562
line 1597
;1597:			{
line 1598
;1598:				return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $555
JUMPV
LABELV $562
line 1600
;1599:			}
;1600:		}
LABELV $559
line 1594
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 18
LTI4 $558
line 1602
;1601:
;1602:		return qtrue;
CNSTI4 1
RETI4
ADDRGP4 $555
JUMPV
LABELV $556
line 1605
;1603:	}
;1604:
;1605:	return qfalse;
CNSTI4 0
RETI4
LABELV $555
endproc AllForceDisabled 4 0
export ClientSpawn
proc ClientSpawn 876 16
line 1618
;1606:}
;1607:
;1608:/*
;1609:===========
;1610:ClientSpawn
;1611:
;1612:Called every time a client is placed fresh in the world:
;1613:after the first ClientBegin, and after each respawn
;1614:Initializes all non-persistant parts of playerState
;1615:============
;1616:*/
;1617:extern qboolean WP_HasForcePowers( const playerState_t *ps );
;1618:void ClientSpawn(gentity_t *ent) {
line 1635
;1619:	int		index;
;1620:	vec3_t	spawn_origin, spawn_angles;
;1621:	gclient_t	*client;
;1622:	int		i;
;1623:	clientPersistant_t	saved;
;1624:	clientSession_t		savedSess;
;1625:	int		persistant[MAX_PERSISTANT];
;1626:	gentity_t	*spawnPoint;
;1627:	int		flags;
;1628:	int		savedPing;
;1629://	char	*savedAreaBits;
;1630:	int		accuracy_hits, accuracy_shots;
;1631:	int		eventSequence;
;1632://	char	userinfo[MAX_INFO_STRING];
;1633:	forcedata_t			savedForce;
;1634:	void		*ghoul2save;
;1635:	int		saveSaberNum = ENTITYNUM_NONE;
ADDRLP4 112
CNSTI4 1023
ASGNI4
line 1636
;1636:	int		wDisable = 0;
ADDRLP4 76
CNSTI4 0
ASGNI4
line 1638
;1637:
;1638:	index = ent - g_entities;
ADDRLP4 104
ADDRFP4 0
INDIRP4
CVPU4 4
ADDRGP4 g_entities
CVPU4 4
SUBU4
CVUI4 4
CNSTI4 828
DIVI4
ASGNI4
line 1639
;1639:	client = ent->client;
ADDRLP4 0
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
ASGNP4
line 1641
;1640:
;1641:	if (client->ps.fd.forceDoInit)
ADDRLP4 0
INDIRP4
CNSTI4 1184
ADDP4
INDIRI4
CNSTI4 0
EQI4 $565
line 1642
;1642:	{ //force a reread of force powers
line 1643
;1643:		WP_InitForcePowers( ent );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 WP_InitForcePowers
CALLV
pop
line 1644
;1644:		client->ps.fd.forceDoInit = 0;
ADDRLP4 0
INDIRP4
CNSTI4 1184
ADDP4
CNSTI4 0
ASGNI4
line 1645
;1645:	}
LABELV $565
line 1649
;1646:	// find a spawn point
;1647:	// do it before setting health back up, so farthest
;1648:	// ranging doesn't count this client
;1649:	if ( client->sess.sessionTeam == TEAM_SPECTATOR ) {
ADDRLP4 0
INDIRP4
CNSTI4 1536
ADDP4
INDIRI4
CNSTI4 3
NEI4 $567
line 1650
;1650:		spawnPoint = SelectSpectatorSpawnPoint ( 
ADDRLP4 80
ARGP4
ADDRLP4 92
ARGP4
ADDRLP4 808
ADDRGP4 SelectSpectatorSpawnPoint
CALLP4
ASGNP4
ADDRLP4 72
ADDRLP4 808
INDIRP4
ASGNP4
line 1652
;1651:						spawn_origin, spawn_angles);
;1652:	} else if (g_gametype.integer == GT_CTF || g_gametype.integer == GT_CTY) {
ADDRGP4 $568
JUMPV
LABELV $567
ADDRGP4 g_gametype+12
INDIRI4
CNSTI4 7
EQI4 $573
ADDRGP4 g_gametype+12
INDIRI4
CNSTI4 8
NEI4 $569
LABELV $573
line 1654
;1653:		// all base oriented team games use the CTF spawn points
;1654:		spawnPoint = SelectCTFSpawnPoint ( 
ADDRLP4 0
INDIRP4
CNSTI4 1536
ADDP4
INDIRI4
ARGI4
ADDRLP4 0
INDIRP4
CNSTI4 1472
ADDP4
INDIRI4
ARGI4
ADDRLP4 80
ARGP4
ADDRLP4 92
ARGP4
ADDRLP4 812
ADDRGP4 SelectCTFSpawnPoint
CALLP4
ASGNP4
ADDRLP4 72
ADDRLP4 812
INDIRP4
ASGNP4
line 1658
;1655:						client->sess.sessionTeam, 
;1656:						client->pers.teamState.state, 
;1657:						spawn_origin, spawn_angles);
;1658:	}
ADDRGP4 $570
JUMPV
LABELV $569
line 1659
;1659:	else if (g_gametype.integer == GT_SAGA)
ADDRGP4 g_gametype+12
INDIRI4
CNSTI4 6
NEI4 $574
line 1660
;1660:	{
line 1661
;1661:		spawnPoint = SelectSagaSpawnPoint ( 
ADDRLP4 0
INDIRP4
CNSTI4 1536
ADDP4
INDIRI4
ARGI4
ADDRLP4 0
INDIRP4
CNSTI4 1472
ADDP4
INDIRI4
ARGI4
ADDRLP4 80
ARGP4
ADDRLP4 92
ARGP4
ADDRLP4 812
ADDRGP4 SelectSagaSpawnPoint
CALLP4
ASGNP4
ADDRLP4 72
ADDRLP4 812
INDIRP4
ASGNP4
line 1665
;1662:						client->sess.sessionTeam, 
;1663:						client->pers.teamState.state, 
;1664:						spawn_origin, spawn_angles);
;1665:	}
ADDRGP4 $575
JUMPV
LABELV $574
line 1666
;1666:	else {
LABELV $577
line 1667
;1667:		do {
line 1669
;1668:			// the first spawn should be at a good looking spot
;1669:			if ( !client->pers.initialSpawn && client->pers.localClient ) {
ADDRLP4 812
CNSTI4 0
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 1416
ADDP4
INDIRI4
ADDRLP4 812
INDIRI4
NEI4 $580
ADDRLP4 0
INDIRP4
CNSTI4 1412
ADDP4
INDIRI4
ADDRLP4 812
INDIRI4
EQI4 $580
line 1670
;1670:				client->pers.initialSpawn = qtrue;
ADDRLP4 0
INDIRP4
CNSTI4 1416
ADDP4
CNSTI4 1
ASGNI4
line 1671
;1671:				spawnPoint = SelectInitialSpawnPoint( spawn_origin, spawn_angles );
ADDRLP4 80
ARGP4
ADDRLP4 92
ARGP4
ADDRLP4 816
ADDRGP4 SelectInitialSpawnPoint
CALLP4
ASGNP4
ADDRLP4 72
ADDRLP4 816
INDIRP4
ASGNP4
line 1672
;1672:			} else {
ADDRGP4 $581
JUMPV
LABELV $580
line 1674
;1673:				// don't spawn near existing origin if possible
;1674:				spawnPoint = SelectSpawnPoint ( 
ADDRLP4 0
INDIRP4
CNSTI4 20
ADDP4
ARGP4
ADDRLP4 80
ARGP4
ADDRLP4 92
ARGP4
ADDRLP4 816
ADDRGP4 SelectSpawnPoint
CALLP4
ASGNP4
ADDRLP4 72
ADDRLP4 816
INDIRP4
ASGNP4
line 1677
;1675:					client->ps.origin, 
;1676:					spawn_origin, spawn_angles);
;1677:			}
LABELV $581
line 1681
;1678:
;1679:			// Tim needs to prevent bots from spawning at the initial point
;1680:			// on q3dm0...
;1681:			if ( ( spawnPoint->flags & FL_NO_BOTS ) && ( ent->r.svFlags & SVF_BOT ) ) {
ADDRLP4 816
CNSTI4 0
ASGNI4
ADDRLP4 72
INDIRP4
CNSTI4 472
ADDP4
INDIRI4
CNSTI4 8192
BANDI4
ADDRLP4 816
INDIRI4
EQI4 $582
ADDRFP4 0
INDIRP4
CNSTI4 304
ADDP4
INDIRI4
CNSTI4 8
BANDI4
ADDRLP4 816
INDIRI4
EQI4 $582
line 1682
;1682:				continue;	// try again
ADDRGP4 $578
JUMPV
LABELV $582
line 1685
;1683:			}
;1684:			// just to be symetric, we have a nohumans option...
;1685:			if ( ( spawnPoint->flags & FL_NO_HUMANS ) && !( ent->r.svFlags & SVF_BOT ) ) {
ADDRLP4 820
CNSTI4 0
ASGNI4
ADDRLP4 72
INDIRP4
CNSTI4 472
ADDP4
INDIRI4
CNSTI4 16384
BANDI4
ADDRLP4 820
INDIRI4
EQI4 $579
ADDRFP4 0
INDIRP4
CNSTI4 304
ADDP4
INDIRI4
CNSTI4 8
BANDI4
ADDRLP4 820
INDIRI4
NEI4 $579
line 1686
;1686:				continue;	// try again
line 1689
;1687:			}
;1688:
;1689:			break;
LABELV $578
line 1691
;1690:
;1691:		} while ( 1 );
ADDRGP4 $577
JUMPV
LABELV $579
line 1692
;1692:	}
LABELV $575
LABELV $570
LABELV $568
line 1693
;1693:	client->pers.teamState.state = TEAM_ACTIVE;
ADDRLP4 0
INDIRP4
CNSTI4 1472
ADDP4
CNSTI4 1
ASGNI4
line 1697
;1694:
;1695:	// toggle the teleport bit so the client knows to not lerp
;1696:	// and never clear the voted flag
;1697:	flags = ent->client->ps.eFlags & (EF_TELEPORT_BIT | EF_VOTED | EF_TEAMVOTED);
ADDRLP4 108
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 108
ADDP4
INDIRI4
CNSTI4 540676
BANDI4
ASGNI4
line 1698
;1698:	flags ^= EF_TELEPORT_BIT;
ADDRLP4 108
ADDRLP4 108
INDIRI4
CNSTI4 4
BXORI4
ASGNI4
line 1702
;1699:
;1700:	// clear everything but the persistant data
;1701:
;1702:	saved = client->pers;
ADDRLP4 116
ADDRLP4 0
INDIRP4
CNSTI4 1380
ADDP4
INDIRB
ASGNB 156
line 1703
;1703:	savedSess = client->sess;
ADDRLP4 272
ADDRLP4 0
INDIRP4
CNSTI4 1536
ADDP4
INDIRB
ASGNB 44
line 1704
;1704:	savedPing = client->ps.ping;
ADDRLP4 316
ADDRLP4 0
INDIRP4
CNSTI4 484
ADDP4
INDIRI4
ASGNI4
line 1706
;1705://	savedAreaBits = client->areabits;
;1706:	accuracy_hits = client->accuracy_hits;
ADDRLP4 320
ADDRLP4 0
INDIRP4
CNSTI4 1672
ADDP4
INDIRI4
ASGNI4
line 1707
;1707:	accuracy_shots = client->accuracy_shots;
ADDRLP4 324
ADDRLP4 0
INDIRP4
CNSTI4 1668
ADDP4
INDIRI4
ASGNI4
line 1708
;1708:	for ( i = 0 ; i < MAX_PERSISTANT ; i++ ) {
ADDRLP4 4
CNSTI4 0
ASGNI4
LABELV $586
line 1709
;1709:		persistant[i] = client->ps.persistant[i];
ADDRLP4 808
ADDRLP4 4
INDIRI4
CNSTI4 2
LSHI4
ASGNI4
ADDRLP4 808
INDIRI4
ADDRLP4 8
ADDP4
ADDRLP4 808
INDIRI4
ADDRLP4 0
INDIRP4
CNSTI4 280
ADDP4
ADDP4
INDIRI4
ASGNI4
line 1710
;1710:	}
LABELV $587
line 1708
ADDRLP4 4
ADDRLP4 4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 4
INDIRI4
CNSTI4 16
LTI4 $586
line 1711
;1711:	eventSequence = client->ps.eventSequence;
ADDRLP4 328
ADDRLP4 0
INDIRP4
CNSTI4 112
ADDP4
INDIRI4
ASGNI4
line 1713
;1712:
;1713:	savedForce = client->ps.fd;
ADDRLP4 332
ADDRLP4 0
INDIRP4
CNSTI4 772
ADDP4
INDIRB
ASGNB 472
line 1715
;1714:
;1715:	ghoul2save = client->ghoul2;
ADDRLP4 804
ADDRLP4 0
INDIRP4
CNSTI4 1732
ADDP4
INDIRP4
ASGNP4
line 1717
;1716:
;1717:	saveSaberNum = client->ps.saberEntityNum;
ADDRLP4 112
ADDRLP4 0
INDIRP4
CNSTI4 544
ADDP4
INDIRI4
ASGNI4
line 1719
;1718:
;1719:	memset (client, 0, sizeof(*client)); // bk FIXME: Com_Memset?
ADDRLP4 0
INDIRP4
ARGP4
CNSTI4 0
ARGI4
CNSTI4 1804
ARGI4
ADDRGP4 memset
CALLP4
pop
line 1722
;1720:
;1721:	//rww - Don't wipe the ghoul2 instance or the animation data
;1722:	client->ghoul2 = ghoul2save;
ADDRLP4 0
INDIRP4
CNSTI4 1732
ADDP4
ADDRLP4 804
INDIRP4
ASGNP4
line 1725
;1723:
;1724:	//or the saber ent num
;1725:	client->ps.saberEntityNum = saveSaberNum;
ADDRLP4 0
INDIRP4
CNSTI4 544
ADDP4
ADDRLP4 112
INDIRI4
ASGNI4
line 1727
;1726:
;1727:	client->ps.fd = savedForce;
ADDRLP4 0
INDIRP4
CNSTI4 772
ADDP4
ADDRLP4 332
INDIRB
ASGNB 472
line 1729
;1728:
;1729:	client->ps.duelIndex = ENTITYNUM_NONE;
ADDRLP4 0
INDIRP4
CNSTI4 1296
ADDP4
CNSTI4 1023
ASGNI4
line 1731
;1730:
;1731:	client->pers = saved;
ADDRLP4 0
INDIRP4
CNSTI4 1380
ADDP4
ADDRLP4 116
INDIRB
ASGNB 156
line 1732
;1732:	client->sess = savedSess;
ADDRLP4 0
INDIRP4
CNSTI4 1536
ADDP4
ADDRLP4 272
INDIRB
ASGNB 44
line 1733
;1733:	client->ps.ping = savedPing;
ADDRLP4 0
INDIRP4
CNSTI4 484
ADDP4
ADDRLP4 316
INDIRI4
ASGNI4
line 1735
;1734://	client->areabits = savedAreaBits;
;1735:	client->accuracy_hits = accuracy_hits;
ADDRLP4 0
INDIRP4
CNSTI4 1672
ADDP4
ADDRLP4 320
INDIRI4
ASGNI4
line 1736
;1736:	client->accuracy_shots = accuracy_shots;
ADDRLP4 0
INDIRP4
CNSTI4 1668
ADDP4
ADDRLP4 324
INDIRI4
ASGNI4
line 1737
;1737:	client->lastkilled_client = -1;
ADDRLP4 0
INDIRP4
CNSTI4 1676
ADDP4
CNSTI4 -1
ASGNI4
line 1739
;1738:
;1739:	for ( i = 0 ; i < MAX_PERSISTANT ; i++ ) {
ADDRLP4 4
CNSTI4 0
ASGNI4
LABELV $590
line 1740
;1740:		client->ps.persistant[i] = persistant[i];
ADDRLP4 808
ADDRLP4 4
INDIRI4
CNSTI4 2
LSHI4
ASGNI4
ADDRLP4 808
INDIRI4
ADDRLP4 0
INDIRP4
CNSTI4 280
ADDP4
ADDP4
ADDRLP4 808
INDIRI4
ADDRLP4 8
ADDP4
INDIRI4
ASGNI4
line 1741
;1741:	}
LABELV $591
line 1739
ADDRLP4 4
ADDRLP4 4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 4
INDIRI4
CNSTI4 16
LTI4 $590
line 1742
;1742:	client->ps.eventSequence = eventSequence;
ADDRLP4 0
INDIRP4
CNSTI4 112
ADDP4
ADDRLP4 328
INDIRI4
ASGNI4
line 1744
;1743:	// increment the spawncount so the client will detect the respawn
;1744:	client->ps.persistant[PERS_SPAWN_COUNT]++;
ADDRLP4 808
ADDRLP4 0
INDIRP4
CNSTI4 296
ADDP4
ASGNP4
ADDRLP4 808
INDIRP4
ADDRLP4 808
INDIRP4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 1745
;1745:	client->ps.persistant[PERS_TEAM] = client->sess.sessionTeam;
ADDRLP4 0
INDIRP4
CNSTI4 292
ADDP4
ADDRLP4 0
INDIRP4
CNSTI4 1536
ADDP4
INDIRI4
ASGNI4
line 1747
;1746:
;1747:	client->airOutTime = level.time + 12000;
ADDRLP4 0
INDIRP4
CNSTI4 1704
ADDP4
ADDRGP4 level+32
INDIRI4
CNSTI4 12000
ADDI4
ASGNI4
line 1751
;1748:
;1749://	trap_GetUserinfo( index, userinfo, sizeof(userinfo) );
;1750:	// set max health
;1751:	client->pers.maxHealth = 100;//atoi( Info_ValueForKey( userinfo, "handicap" ) );
ADDRLP4 0
INDIRP4
CNSTI4 1464
ADDP4
CNSTI4 100
ASGNI4
line 1752
;1752:	if ( client->pers.maxHealth < 1 || client->pers.maxHealth > 100 ) {
ADDRLP4 816
ADDRLP4 0
INDIRP4
CNSTI4 1464
ADDP4
INDIRI4
ASGNI4
ADDRLP4 816
INDIRI4
CNSTI4 1
LTI4 $597
ADDRLP4 816
INDIRI4
CNSTI4 100
LEI4 $595
LABELV $597
line 1753
;1753:		client->pers.maxHealth = 100;
ADDRLP4 0
INDIRP4
CNSTI4 1464
ADDP4
CNSTI4 100
ASGNI4
line 1754
;1754:	}
LABELV $595
line 1756
;1755:	// clear entity values
;1756:	client->ps.stats[STAT_MAX_HEALTH] = client->pers.maxHealth;
ADDRLP4 0
INDIRP4
CNSTI4 248
ADDP4
ADDRLP4 0
INDIRP4
CNSTI4 1464
ADDP4
INDIRI4
ASGNI4
line 1757
;1757:	client->ps.eFlags = flags;
ADDRLP4 0
INDIRP4
CNSTI4 108
ADDP4
ADDRLP4 108
INDIRI4
ASGNI4
line 1759
;1758:
;1759:	ent->s.groundEntityNum = ENTITYNUM_NONE;
ADDRFP4 0
INDIRP4
CNSTI4 192
ADDP4
CNSTI4 1023
ASGNI4
line 1760
;1760:	ent->client = &level.clients[index];
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
CNSTI4 1804
ADDRLP4 104
INDIRI4
MULI4
ADDRGP4 level
INDIRP4
ADDP4
ASGNP4
line 1761
;1761:	ent->takedamage = qtrue;
ADDRFP4 0
INDIRP4
CNSTI4 680
ADDP4
CNSTI4 1
ASGNI4
line 1762
;1762:	ent->inuse = qtrue;
ADDRFP4 0
INDIRP4
CNSTI4 412
ADDP4
CNSTI4 1
ASGNI4
line 1763
;1763:	ent->classname = "player";
ADDRFP4 0
INDIRP4
CNSTI4 416
ADDP4
ADDRGP4 $598
ASGNP4
line 1764
;1764:	ent->r.contents = CONTENTS_BODY;
ADDRFP4 0
INDIRP4
CNSTI4 340
ADDP4
CNSTI4 256
ASGNI4
line 1765
;1765:	ent->clipmask = MASK_PLAYERSOLID;
ADDRFP4 0
INDIRP4
CNSTI4 508
ADDP4
CNSTI4 273
ASGNI4
line 1766
;1766:	ent->die = player_die;
ADDRFP4 0
INDIRP4
CNSTI4 660
ADDP4
ADDRGP4 player_die
ASGNP4
line 1767
;1767:	ent->waterlevel = 0;
ADDRFP4 0
INDIRP4
CNSTI4 748
ADDP4
CNSTI4 0
ASGNI4
line 1768
;1768:	ent->watertype = 0;
ADDRFP4 0
INDIRP4
CNSTI4 744
ADDP4
CNSTI4 0
ASGNI4
line 1769
;1769:	ent->flags = 0;
ADDRFP4 0
INDIRP4
CNSTI4 472
ADDP4
CNSTI4 0
ASGNI4
line 1771
;1770:	
;1771:	VectorCopy (playerMins, ent->r.mins);
ADDRFP4 0
INDIRP4
CNSTI4 316
ADDP4
ADDRGP4 playerMins
INDIRB
ASGNB 12
line 1772
;1772:	VectorCopy (playerMaxs, ent->r.maxs);
ADDRFP4 0
INDIRP4
CNSTI4 328
ADDP4
ADDRGP4 playerMaxs
INDIRB
ASGNB 12
line 1774
;1773:
;1774:	client->ps.clientNum = index;
ADDRLP4 0
INDIRP4
CNSTI4 144
ADDP4
ADDRLP4 104
INDIRI4
ASGNI4
line 1776
;1775:	//give default weapons
;1776:	client->ps.stats[STAT_WEAPONS] = ( 1 << WP_NONE );
ADDRLP4 0
INDIRP4
CNSTI4 232
ADDP4
CNSTI4 1
ASGNI4
line 1778
;1777:
;1778:	if (g_gametype.integer == GT_TOURNAMENT)
ADDRGP4 g_gametype+12
INDIRI4
CNSTI4 3
NEI4 $599
line 1779
;1779:	{
line 1780
;1780:		wDisable = g_duelWeaponDisable.integer;
ADDRLP4 76
ADDRGP4 g_duelWeaponDisable+12
INDIRI4
ASGNI4
line 1781
;1781:	}
ADDRGP4 $600
JUMPV
LABELV $599
line 1783
;1782:	else
;1783:	{
line 1784
;1784:		wDisable = g_weaponDisable.integer;
ADDRLP4 76
ADDRGP4 g_weaponDisable+12
INDIRI4
ASGNI4
line 1785
;1785:	}
LABELV $600
line 1789
;1786:
;1787:
;1788:
;1789:	if ( g_gametype.integer != GT_HOLOCRON 
ADDRGP4 g_gametype+12
INDIRI4
CNSTI4 1
EQI4 $604
ADDRGP4 g_gametype+12
INDIRI4
CNSTI4 2
EQI4 $604
ADDRLP4 824
ADDRGP4 HasSetSaberOnly
CALLI4
ASGNI4
ADDRLP4 824
INDIRI4
CNSTI4 0
NEI4 $604
ADDRGP4 g_forcePowerDisable+12
INDIRI4
ARGI4
ADDRLP4 828
ADDRGP4 AllForceDisabled
CALLI4
ASGNI4
ADDRLP4 832
CNSTI4 0
ASGNI4
ADDRLP4 828
INDIRI4
ADDRLP4 832
INDIRI4
NEI4 $604
ADDRGP4 g_trueJedi+12
INDIRI4
ADDRLP4 832
INDIRI4
EQI4 $604
line 1794
;1790:		&& g_gametype.integer != GT_JEDIMASTER 
;1791:		&& !HasSetSaberOnly()
;1792:		&& !AllForceDisabled( g_forcePowerDisable.integer )
;1793:		&& g_trueJedi.integer )
;1794:	{
line 1795
;1795:		if ( g_gametype.integer >= GT_TEAM && (client->sess.sessionTeam == TEAM_BLUE || client->sess.sessionTeam == TEAM_RED) )
ADDRGP4 g_gametype+12
INDIRI4
CNSTI4 5
LTI4 $610
ADDRLP4 836
ADDRLP4 0
INDIRP4
CNSTI4 1536
ADDP4
INDIRI4
ASGNI4
ADDRLP4 836
INDIRI4
CNSTI4 2
EQI4 $613
ADDRLP4 836
INDIRI4
CNSTI4 1
NEI4 $610
LABELV $613
line 1796
;1796:		{//In Team games, force one side to be merc and other to be jedi
line 1797
;1797:			if ( level.numPlayingClients > 0 )
ADDRGP4 level+80
INDIRI4
CNSTI4 0
LEI4 $614
line 1798
;1798:			{//already someone in the game
line 1799
;1799:				int		i, forceTeam = TEAM_SPECTATOR;
ADDRLP4 844
CNSTI4 3
ASGNI4
line 1800
;1800:				for ( i = 0 ; i < level.maxclients ; i++ ) 
ADDRLP4 840
CNSTI4 0
ASGNI4
ADDRGP4 $620
JUMPV
LABELV $617
line 1801
;1801:				{
line 1802
;1802:					if ( level.clients[i].pers.connected == CON_DISCONNECTED ) {
CNSTI4 1804
ADDRLP4 840
INDIRI4
MULI4
ADDRGP4 level
INDIRP4
ADDP4
CNSTI4 1380
ADDP4
INDIRI4
CNSTI4 0
NEI4 $622
line 1803
;1803:						continue;
ADDRGP4 $618
JUMPV
LABELV $622
line 1805
;1804:					}
;1805:					if ( level.clients[i].sess.sessionTeam == TEAM_BLUE || level.clients[i].sess.sessionTeam == TEAM_RED ) 
ADDRLP4 848
CNSTI4 1804
ADDRLP4 840
INDIRI4
MULI4
ADDRGP4 level
INDIRP4
ADDP4
CNSTI4 1536
ADDP4
INDIRI4
ASGNI4
ADDRLP4 848
INDIRI4
CNSTI4 2
EQI4 $626
ADDRLP4 848
INDIRI4
CNSTI4 1
NEI4 $624
LABELV $626
line 1806
;1806:					{//in-game
line 1807
;1807:						if ( WP_HasForcePowers( &level.clients[i].ps ) )
CNSTI4 1804
ADDRLP4 840
INDIRI4
MULI4
ADDRGP4 level
INDIRP4
ADDP4
ARGP4
ADDRLP4 852
ADDRGP4 WP_HasForcePowers
CALLI4
ASGNI4
ADDRLP4 852
INDIRI4
CNSTI4 0
EQI4 $627
line 1808
;1808:						{//this side is using force
line 1809
;1809:							forceTeam = level.clients[i].sess.sessionTeam;
ADDRLP4 844
CNSTI4 1804
ADDRLP4 840
INDIRI4
MULI4
ADDRGP4 level
INDIRP4
ADDP4
CNSTI4 1536
ADDP4
INDIRI4
ASGNI4
line 1810
;1810:						}
ADDRGP4 $619
JUMPV
LABELV $627
line 1812
;1811:						else
;1812:						{//other team is using force
line 1813
;1813:							if ( level.clients[i].sess.sessionTeam == TEAM_BLUE )
CNSTI4 1804
ADDRLP4 840
INDIRI4
MULI4
ADDRGP4 level
INDIRP4
ADDP4
CNSTI4 1536
ADDP4
INDIRI4
CNSTI4 2
NEI4 $629
line 1814
;1814:							{
line 1815
;1815:								forceTeam = TEAM_RED;
ADDRLP4 844
CNSTI4 1
ASGNI4
line 1816
;1816:							}
ADDRGP4 $619
JUMPV
LABELV $629
line 1818
;1817:							else
;1818:							{
line 1819
;1819:								forceTeam = TEAM_BLUE;
ADDRLP4 844
CNSTI4 2
ASGNI4
line 1820
;1820:							}
line 1821
;1821:						}
line 1822
;1822:						break;
ADDRGP4 $619
JUMPV
LABELV $624
line 1824
;1823:					}
;1824:				}
LABELV $618
line 1800
ADDRLP4 840
ADDRLP4 840
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $620
ADDRLP4 840
INDIRI4
ADDRGP4 level+24
INDIRI4
LTI4 $617
LABELV $619
line 1825
;1825:				if ( WP_HasForcePowers( &client->ps ) && client->sess.sessionTeam != forceTeam )
ADDRLP4 0
INDIRP4
ARGP4
ADDRLP4 848
ADDRGP4 WP_HasForcePowers
CALLI4
ASGNI4
ADDRLP4 848
INDIRI4
CNSTI4 0
EQI4 $631
ADDRLP4 0
INDIRP4
CNSTI4 1536
ADDP4
INDIRI4
ADDRLP4 844
INDIRI4
EQI4 $631
line 1826
;1826:				{//using force but not on right team, switch him over
line 1827
;1827:					const char *teamName = TeamName( forceTeam );
ADDRLP4 844
INDIRI4
ARGI4
ADDRLP4 856
ADDRGP4 TeamName
CALLP4
ASGNP4
ADDRLP4 852
ADDRLP4 856
INDIRP4
ASGNP4
line 1829
;1828:					//client->sess.sessionTeam = forceTeam;
;1829:					SetTeam( ent, (char *)teamName );
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 852
INDIRP4
ARGP4
ADDRGP4 SetTeam
CALLV
pop
line 1830
;1830:					return;
ADDRGP4 $564
JUMPV
LABELV $631
line 1832
;1831:				}
;1832:			}
LABELV $614
line 1833
;1833:		}
LABELV $610
line 1835
;1834:
;1835:		if ( WP_HasForcePowers( &client->ps ) )
ADDRLP4 0
INDIRP4
ARGP4
ADDRLP4 840
ADDRGP4 WP_HasForcePowers
CALLI4
ASGNI4
ADDRLP4 840
INDIRI4
CNSTI4 0
EQI4 $633
line 1836
;1836:		{
line 1837
;1837:			client->ps.trueNonJedi = qfalse;
ADDRLP4 0
INDIRP4
CNSTI4 616
ADDP4
CNSTI4 0
ASGNI4
line 1838
;1838:			client->ps.trueJedi = qtrue;
ADDRLP4 0
INDIRP4
CNSTI4 612
ADDP4
CNSTI4 1
ASGNI4
line 1840
;1839:			//make sure they only use the saber
;1840:			client->ps.weapon = WP_SABER;
ADDRLP4 0
INDIRP4
CNSTI4 148
ADDP4
CNSTI4 2
ASGNI4
line 1841
;1841:			client->ps.stats[STAT_WEAPONS] = (1 << WP_SABER);
ADDRLP4 0
INDIRP4
CNSTI4 232
ADDP4
CNSTI4 4
ASGNI4
line 1842
;1842:		}
ADDRGP4 $605
JUMPV
LABELV $633
line 1844
;1843:		else
;1844:		{//no force powers set
line 1845
;1845:			client->ps.trueNonJedi = qtrue;
ADDRLP4 0
INDIRP4
CNSTI4 616
ADDP4
CNSTI4 1
ASGNI4
line 1846
;1846:			client->ps.trueJedi = qfalse;
ADDRLP4 0
INDIRP4
CNSTI4 612
ADDP4
CNSTI4 0
ASGNI4
line 1847
;1847:			if (!wDisable || !(wDisable & (1 << WP_BRYAR_PISTOL)))
ADDRLP4 848
CNSTI4 0
ASGNI4
ADDRLP4 76
INDIRI4
ADDRLP4 848
INDIRI4
EQI4 $637
ADDRLP4 76
INDIRI4
CNSTI4 8
BANDI4
ADDRLP4 848
INDIRI4
NEI4 $635
LABELV $637
line 1848
;1848:			{
line 1849
;1849:				client->ps.stats[STAT_WEAPONS] |= ( 1 << WP_BRYAR_PISTOL );
ADDRLP4 852
ADDRLP4 0
INDIRP4
CNSTI4 232
ADDP4
ASGNP4
ADDRLP4 852
INDIRP4
ADDRLP4 852
INDIRP4
INDIRI4
CNSTI4 8
BORI4
ASGNI4
line 1850
;1850:			}
LABELV $635
line 1851
;1851:			if (!wDisable || !(wDisable & (1 << WP_BLASTER)))
ADDRLP4 856
CNSTI4 0
ASGNI4
ADDRLP4 76
INDIRI4
ADDRLP4 856
INDIRI4
EQI4 $640
ADDRLP4 76
INDIRI4
CNSTI4 16
BANDI4
ADDRLP4 856
INDIRI4
NEI4 $638
LABELV $640
line 1852
;1852:			{
line 1853
;1853:				client->ps.stats[STAT_WEAPONS] |= ( 1 << WP_BLASTER );
ADDRLP4 860
ADDRLP4 0
INDIRP4
CNSTI4 232
ADDP4
ASGNP4
ADDRLP4 860
INDIRP4
ADDRLP4 860
INDIRP4
INDIRI4
CNSTI4 16
BORI4
ASGNI4
line 1854
;1854:			}
LABELV $638
line 1855
;1855:			if (!wDisable || !(wDisable & (1 << WP_BOWCASTER)))
ADDRLP4 864
CNSTI4 0
ASGNI4
ADDRLP4 76
INDIRI4
ADDRLP4 864
INDIRI4
EQI4 $643
ADDRLP4 76
INDIRI4
CNSTI4 64
BANDI4
ADDRLP4 864
INDIRI4
NEI4 $641
LABELV $643
line 1856
;1856:			{
line 1857
;1857:				client->ps.stats[STAT_WEAPONS] |= ( 1 << WP_BOWCASTER );
ADDRLP4 868
ADDRLP4 0
INDIRP4
CNSTI4 232
ADDP4
ASGNP4
ADDRLP4 868
INDIRP4
ADDRLP4 868
INDIRP4
INDIRI4
CNSTI4 64
BORI4
ASGNI4
line 1858
;1858:			}
LABELV $641
line 1859
;1859:			client->ps.stats[STAT_WEAPONS] &= ~(1 << WP_SABER);
ADDRLP4 868
ADDRLP4 0
INDIRP4
CNSTI4 232
ADDP4
ASGNP4
ADDRLP4 868
INDIRP4
ADDRLP4 868
INDIRP4
INDIRI4
CNSTI4 -5
BANDI4
ASGNI4
line 1860
;1860:			client->ps.stats[STAT_WEAPONS] |= (1 << WP_STUN_BATON);
ADDRLP4 872
ADDRLP4 0
INDIRP4
CNSTI4 232
ADDP4
ASGNP4
ADDRLP4 872
INDIRP4
ADDRLP4 872
INDIRP4
INDIRI4
CNSTI4 2
BORI4
ASGNI4
line 1861
;1861:			client->ps.ammo[AMMO_POWERCELL] = ammoData[AMMO_POWERCELL].max;
ADDRLP4 0
INDIRP4
CNSTI4 420
ADDP4
ADDRGP4 ammoData+12
INDIRI4
ASGNI4
line 1862
;1862:			client->ps.weapon = WP_BRYAR_PISTOL;
ADDRLP4 0
INDIRP4
CNSTI4 148
ADDP4
CNSTI4 3
ASGNI4
line 1863
;1863:		}
line 1864
;1864:	}
ADDRGP4 $605
JUMPV
LABELV $604
line 1866
;1865:	else
;1866:	{//jediVmerc is incompatible with this gametype, turn it off!
line 1867
;1867:		trap_Cvar_Set( "g_jediVmerc", "0" );
ADDRGP4 $645
ARGP4
ADDRGP4 $91
ARGP4
ADDRGP4 trap_Cvar_Set
CALLV
pop
line 1868
;1868:		if (g_gametype.integer == GT_HOLOCRON)
ADDRGP4 g_gametype+12
INDIRI4
CNSTI4 1
NEI4 $646
line 1869
;1869:		{
line 1871
;1870:			//always get free saber level 1 in holocron
;1871:			client->ps.stats[STAT_WEAPONS] |= ( 1 << WP_SABER );	//these are precached in g_items, ClearRegisteredItems()
ADDRLP4 836
ADDRLP4 0
INDIRP4
CNSTI4 232
ADDP4
ASGNP4
ADDRLP4 836
INDIRP4
ADDRLP4 836
INDIRP4
INDIRI4
CNSTI4 4
BORI4
ASGNI4
line 1872
;1872:		}
ADDRGP4 $647
JUMPV
LABELV $646
line 1874
;1873:		else
;1874:		{
line 1875
;1875:			if (client->ps.fd.forcePowerLevel[FP_SABERATTACK])
ADDRLP4 0
INDIRP4
CNSTI4 1004
ADDP4
INDIRI4
CNSTI4 0
EQI4 $649
line 1876
;1876:			{
line 1877
;1877:				client->ps.stats[STAT_WEAPONS] |= ( 1 << WP_SABER );	//these are precached in g_items, ClearRegisteredItems()
ADDRLP4 836
ADDRLP4 0
INDIRP4
CNSTI4 232
ADDP4
ASGNP4
ADDRLP4 836
INDIRP4
ADDRLP4 836
INDIRP4
INDIRI4
CNSTI4 4
BORI4
ASGNI4
line 1878
;1878:			}
ADDRGP4 $650
JUMPV
LABELV $649
line 1880
;1879:			else
;1880:			{ //if you don't have saber attack rank then you don't get a saber
line 1881
;1881:				client->ps.stats[STAT_WEAPONS] |= (1 << WP_STUN_BATON);
ADDRLP4 836
ADDRLP4 0
INDIRP4
CNSTI4 232
ADDP4
ASGNP4
ADDRLP4 836
INDIRP4
ADDRLP4 836
INDIRP4
INDIRI4
CNSTI4 2
BORI4
ASGNI4
line 1882
;1882:			}
LABELV $650
line 1883
;1883:		}
LABELV $647
line 1885
;1884:
;1885:		if (!wDisable || !(wDisable & (1 << WP_BRYAR_PISTOL)))
ADDRLP4 840
CNSTI4 0
ASGNI4
ADDRLP4 76
INDIRI4
ADDRLP4 840
INDIRI4
EQI4 $653
ADDRLP4 76
INDIRI4
CNSTI4 8
BANDI4
ADDRLP4 840
INDIRI4
NEI4 $651
LABELV $653
line 1886
;1886:		{
line 1887
;1887:			client->ps.stats[STAT_WEAPONS] |= ( 1 << WP_BRYAR_PISTOL );
ADDRLP4 844
ADDRLP4 0
INDIRP4
CNSTI4 232
ADDP4
ASGNP4
ADDRLP4 844
INDIRP4
ADDRLP4 844
INDIRP4
INDIRI4
CNSTI4 8
BORI4
ASGNI4
line 1888
;1888:		}
ADDRGP4 $652
JUMPV
LABELV $651
line 1889
;1889:		else if (g_gametype.integer == GT_JEDIMASTER)
ADDRGP4 g_gametype+12
INDIRI4
CNSTI4 2
NEI4 $654
line 1890
;1890:		{
line 1891
;1891:			client->ps.stats[STAT_WEAPONS] |= ( 1 << WP_BRYAR_PISTOL );
ADDRLP4 844
ADDRLP4 0
INDIRP4
CNSTI4 232
ADDP4
ASGNP4
ADDRLP4 844
INDIRP4
ADDRLP4 844
INDIRP4
INDIRI4
CNSTI4 8
BORI4
ASGNI4
line 1892
;1892:		}
LABELV $654
LABELV $652
line 1894
;1893:
;1894:		if (g_gametype.integer == GT_JEDIMASTER)
ADDRGP4 g_gametype+12
INDIRI4
CNSTI4 2
NEI4 $657
line 1895
;1895:		{
line 1896
;1896:			client->ps.stats[STAT_WEAPONS] &= ~(1 << WP_SABER);
ADDRLP4 844
ADDRLP4 0
INDIRP4
CNSTI4 232
ADDP4
ASGNP4
ADDRLP4 844
INDIRP4
ADDRLP4 844
INDIRP4
INDIRI4
CNSTI4 -5
BANDI4
ASGNI4
line 1897
;1897:			client->ps.stats[STAT_WEAPONS] |= (1 << WP_STUN_BATON);
ADDRLP4 848
ADDRLP4 0
INDIRP4
CNSTI4 232
ADDP4
ASGNP4
ADDRLP4 848
INDIRP4
ADDRLP4 848
INDIRP4
INDIRI4
CNSTI4 2
BORI4
ASGNI4
line 1898
;1898:		}
LABELV $657
line 1900
;1899:
;1900:		if (client->ps.stats[STAT_WEAPONS] & (1 << WP_BRYAR_PISTOL))
ADDRLP4 0
INDIRP4
CNSTI4 232
ADDP4
INDIRI4
CNSTI4 8
BANDI4
CNSTI4 0
EQI4 $660
line 1901
;1901:		{
line 1902
;1902:			client->ps.weapon = WP_BRYAR_PISTOL;
ADDRLP4 0
INDIRP4
CNSTI4 148
ADDP4
CNSTI4 3
ASGNI4
line 1903
;1903:		}
ADDRGP4 $661
JUMPV
LABELV $660
line 1904
;1904:		else if (client->ps.stats[STAT_WEAPONS] & (1 << WP_SABER))
ADDRLP4 0
INDIRP4
CNSTI4 232
ADDP4
INDIRI4
CNSTI4 4
BANDI4
CNSTI4 0
EQI4 $662
line 1905
;1905:		{
line 1906
;1906:			client->ps.weapon = WP_SABER;
ADDRLP4 0
INDIRP4
CNSTI4 148
ADDP4
CNSTI4 2
ASGNI4
line 1907
;1907:		}
ADDRGP4 $663
JUMPV
LABELV $662
line 1909
;1908:		else
;1909:		{
line 1910
;1910:			client->ps.weapon = WP_STUN_BATON;
ADDRLP4 0
INDIRP4
CNSTI4 148
ADDP4
CNSTI4 1
ASGNI4
line 1911
;1911:		}
LABELV $663
LABELV $661
line 1912
;1912:	}
LABELV $605
line 1916
;1913:
;1914:   // adnan
;1915:   // give em the blaster
;1916:   client->ps.weapon = WP_BLASTER;
ADDRLP4 0
INDIRP4
CNSTI4 148
ADDP4
CNSTI4 4
ASGNI4
line 1917
;1917:	client->ps.stats[STAT_WEAPONS] = (1 << WP_BLASTER);
ADDRLP4 0
INDIRP4
CNSTI4 232
ADDP4
CNSTI4 16
ASGNI4
line 1924
;1918:
;1919:	/*
;1920:	client->ps.stats[STAT_HOLDABLE_ITEMS] |= ( 1 << HI_BINOCULARS );
;1921:	client->ps.stats[STAT_HOLDABLE_ITEM] = BG_GetItemIndexByTag(HI_BINOCULARS, IT_HOLDABLE);
;1922:	*/
;1923:
;1924:	client->ps.stats[STAT_HOLDABLE_ITEMS] = 0;
ADDRLP4 0
INDIRP4
CNSTI4 224
ADDP4
CNSTI4 0
ASGNI4
line 1925
;1925:	client->ps.stats[STAT_HOLDABLE_ITEM] = 0;
ADDRLP4 0
INDIRP4
CNSTI4 220
ADDP4
CNSTI4 0
ASGNI4
line 1927
;1926:
;1927:	if ( client->sess.sessionTeam == TEAM_SPECTATOR )
ADDRLP4 0
INDIRP4
CNSTI4 1536
ADDP4
INDIRI4
CNSTI4 3
NEI4 $664
line 1928
;1928:	{
line 1929
;1929:		client->ps.stats[STAT_WEAPONS] = 0;
ADDRLP4 0
INDIRP4
CNSTI4 232
ADDP4
CNSTI4 0
ASGNI4
line 1930
;1930:		client->ps.stats[STAT_HOLDABLE_ITEMS] = 0;
ADDRLP4 0
INDIRP4
CNSTI4 224
ADDP4
CNSTI4 0
ASGNI4
line 1931
;1931:		client->ps.stats[STAT_HOLDABLE_ITEM] = 0;
ADDRLP4 0
INDIRP4
CNSTI4 220
ADDP4
CNSTI4 0
ASGNI4
line 1932
;1932:	}
LABELV $664
line 1935
;1933:
;1934:	// adnan
;1935:   client->ps.ammo[AMMO_BLASTER] = 300; //ammoData[AMMO_BLASTER].max; //100 seems fair.
ADDRLP4 0
INDIRP4
CNSTI4 416
ADDP4
CNSTI4 300
ASGNI4
line 1948
;1936://	client->ps.ammo[AMMO_POWERCELL] = ammoData[AMMO_POWERCELL].max;
;1937://	client->ps.ammo[AMMO_FORCE] = ammoData[AMMO_FORCE].max;
;1938://	client->ps.ammo[AMMO_METAL_BOLTS] = ammoData[AMMO_METAL_BOLTS].max;
;1939://	client->ps.ammo[AMMO_ROCKETS] = ammoData[AMMO_ROCKETS].max;
;1940:/*
;1941:	client->ps.stats[STAT_WEAPONS] = ( 1 << WP_BRYAR_PISTOL);
;1942:	if ( g_gametype.integer == GT_TEAM ) {
;1943:		client->ps.ammo[WP_BRYAR_PISTOL] = 50;
;1944:	} else {
;1945:		client->ps.ammo[WP_BRYAR_PISTOL] = 100;
;1946:	}
;1947:*/
;1948:	client->ps.rocketLockIndex = MAX_CLIENTS;
ADDRLP4 0
INDIRP4
CNSTI4 580
ADDP4
CNSTI4 32
ASGNI4
line 1949
;1949:	client->ps.rocketLockTime = 0;
ADDRLP4 0
INDIRP4
CNSTI4 588
ADDP4
CNSTF4 0
ASGNF4
line 1960
;1950:
;1951:	//rww - Set here to initialize the circling seeker drone to off.
;1952:	//A quick note about this so I don't forget how it works again:
;1953:	//ps.genericEnemyIndex is kept in sync between the server and client.
;1954:	//When it gets set then an entitystate value of the same name gets
;1955:	//set along with an entitystate flag in the shared bg code. Which
;1956:	//is why a value needs to be both on the player state and entity state.
;1957:	//(it doesn't seem to just carry over the entitystate value automatically
;1958:	//because entity state value is derived from player state data or some
;1959:	//such)
;1960:	client->ps.genericEnemyIndex = -1;
ADDRLP4 0
INDIRP4
CNSTI4 624
ADDP4
CNSTI4 -1
ASGNI4
line 1962
;1961:
;1962:	client->ps.isJediMaster = qfalse;
ADDRLP4 0
INDIRP4
CNSTI4 604
ADDP4
CNSTI4 0
ASGNI4
line 1964
;1963:
;1964:	client->ps.fallingToDeath = 0;
ADDRLP4 0
INDIRP4
CNSTI4 1352
ADDP4
CNSTI4 0
ASGNI4
line 1967
;1965:
;1966:	//Do per-spawn force power initialization
;1967:	WP_SpawnInitForcePowers( ent );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 WP_SpawnInitForcePowers
CALLV
pop
line 1970
;1968:
;1969:	// health will count down towards max_health
;1970:	ent->health = client->ps.stats[STAT_HEALTH] = client->ps.stats[STAT_MAX_HEALTH] * 1.25;
ADDRLP4 840
CNSTF4 1067450368
ADDRLP4 0
INDIRP4
CNSTI4 248
ADDP4
INDIRI4
CVIF4 4
MULF4
CVFI4 4
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 216
ADDP4
ADDRLP4 840
INDIRI4
ASGNI4
ADDRFP4 0
INDIRP4
CNSTI4 676
ADDP4
ADDRLP4 840
INDIRI4
ASGNI4
line 1973
;1971:
;1972:	// Start with a small amount of armor as well.
;1973:	client->ps.stats[STAT_ARMOR] = client->ps.stats[STAT_MAX_HEALTH] * 0.25;
ADDRLP4 0
INDIRP4
CNSTI4 236
ADDP4
CNSTF4 1048576000
ADDRLP4 0
INDIRP4
CNSTI4 248
ADDP4
INDIRI4
CVIF4 4
MULF4
CVFI4 4
ASGNI4
line 1975
;1974:
;1975:	G_SetOrigin( ent, spawn_origin );
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 80
ARGP4
ADDRGP4 G_SetOrigin
CALLV
pop
line 1976
;1976:	VectorCopy( spawn_origin, client->ps.origin );
ADDRLP4 0
INDIRP4
CNSTI4 20
ADDP4
ADDRLP4 80
INDIRB
ASGNB 12
line 1979
;1977:
;1978:	// the respawned flag will be cleared after the attack and jump keys come up
;1979:	client->ps.pm_flags |= PMF_RESPAWNED;
ADDRLP4 848
ADDRLP4 0
INDIRP4
CNSTI4 12
ADDP4
ASGNP4
ADDRLP4 848
INDIRP4
ADDRLP4 848
INDIRP4
INDIRI4
CNSTI4 512
BORI4
ASGNI4
line 1981
;1980:
;1981:	trap_GetUsercmd( client - level.clients, &ent->client->pers.cmd );
ADDRLP4 0
INDIRP4
CVPU4 4
ADDRGP4 level
INDIRP4
CVPU4 4
SUBU4
CVUI4 4
CNSTI4 1804
DIVI4
ARGI4
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 1384
ADDP4
ARGP4
ADDRGP4 trap_GetUsercmd
CALLV
pop
line 1982
;1982:	SetClientViewAngle( ent, spawn_angles );
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 92
ARGP4
ADDRGP4 SetClientViewAngle
CALLV
pop
line 1984
;1983:
;1984:	if ( ent->client->sess.sessionTeam == TEAM_SPECTATOR ) {
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 1536
ADDP4
INDIRI4
CNSTI4 3
NEI4 $666
line 1986
;1985:
;1986:	} else {
ADDRGP4 $667
JUMPV
LABELV $666
line 1987
;1987:		G_KillBox( ent );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 G_KillBox
CALLV
pop
line 1988
;1988:		trap_LinkEntity (ent);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 trap_LinkEntity
CALLV
pop
line 1991
;1989:
;1990:		// force the base weapon up
;1991:		client->ps.weapon = WP_BRYAR_PISTOL;
ADDRLP4 0
INDIRP4
CNSTI4 148
ADDP4
CNSTI4 3
ASGNI4
line 1992
;1992:		client->ps.weaponstate = FIRST_WEAPON;
ADDRLP4 0
INDIRP4
CNSTI4 152
ADDP4
CNSTI4 3
ASGNI4
line 1994
;1993:
;1994:	}
LABELV $667
line 1997
;1995:
;1996:	// don't allow full run speed for a bit
;1997:	client->ps.pm_flags |= PMF_TIME_KNOCKBACK;
ADDRLP4 852
ADDRLP4 0
INDIRP4
CNSTI4 12
ADDP4
ASGNP4
ADDRLP4 852
INDIRP4
ADDRLP4 852
INDIRP4
INDIRI4
CNSTI4 64
BORI4
ASGNI4
line 1998
;1998:	client->ps.pm_time = 100;
ADDRLP4 0
INDIRP4
CNSTI4 16
ADDP4
CNSTI4 100
ASGNI4
line 2000
;1999:
;2000:	client->respawnTime = level.time;
ADDRLP4 0
INDIRP4
CNSTI4 1688
ADDP4
ADDRGP4 level+32
INDIRI4
ASGNI4
line 2001
;2001:	client->inactivityTime = level.time + g_inactivity.integer * 1000;
ADDRLP4 0
INDIRP4
CNSTI4 1692
ADDP4
ADDRGP4 level+32
INDIRI4
CNSTI4 1000
ADDRGP4 g_inactivity+12
INDIRI4
MULI4
ADDI4
ASGNI4
line 2002
;2002:	client->latched_buttons = 0;
ADDRLP4 0
INDIRP4
CNSTI4 1608
ADDP4
CNSTI4 0
ASGNI4
line 2005
;2003:
;2004:	// set default animations
;2005:	client->ps.torsoAnim = WeaponReadyAnim[client->ps.weapon];
ADDRLP4 0
INDIRP4
CNSTI4 100
ADDP4
ADDRLP4 0
INDIRP4
CNSTI4 148
ADDP4
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 WeaponReadyAnim
ADDP4
INDIRI4
ASGNI4
line 2006
;2006:	client->ps.legsAnim = WeaponReadyAnim[client->ps.weapon];
ADDRLP4 0
INDIRP4
CNSTI4 92
ADDP4
ADDRLP4 0
INDIRP4
CNSTI4 148
ADDP4
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 WeaponReadyAnim
ADDP4
INDIRI4
ASGNI4
line 2008
;2007:
;2008:	if ( level.intermissiontime ) {
ADDRGP4 level+9008
INDIRI4
CNSTI4 0
EQI4 $671
line 2009
;2009:		MoveClientToIntermission( ent );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 MoveClientToIntermission
CALLV
pop
line 2010
;2010:	} else {
ADDRGP4 $672
JUMPV
LABELV $671
line 2012
;2011:		// fire the targets of the spawn point
;2012:		G_UseTargets( spawnPoint, ent );
ADDRLP4 72
INDIRP4
ARGP4
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 G_UseTargets
CALLV
pop
line 2016
;2013:
;2014:		// select the highest weapon number available, after any
;2015:		// spawn given items have fired
;2016:		client->ps.weapon = 1;
ADDRLP4 0
INDIRP4
CNSTI4 148
ADDP4
CNSTI4 1
ASGNI4
line 2017
;2017:		for ( i = WP_NUM_WEAPONS - 1 ; i > 0 ; i-- ) {
ADDRLP4 4
CNSTI4 15
ASGNI4
LABELV $674
line 2018
;2018:			if ( client->ps.stats[STAT_WEAPONS] & ( 1 << i ) ) {
ADDRLP4 0
INDIRP4
CNSTI4 232
ADDP4
INDIRI4
CNSTI4 1
ADDRLP4 4
INDIRI4
LSHI4
BANDI4
CNSTI4 0
EQI4 $678
line 2019
;2019:				client->ps.weapon = i;
ADDRLP4 0
INDIRP4
CNSTI4 148
ADDP4
ADDRLP4 4
INDIRI4
ASGNI4
line 2020
;2020:				break;
ADDRGP4 $676
JUMPV
LABELV $678
line 2022
;2021:			}
;2022:		}
LABELV $675
line 2017
ADDRLP4 4
ADDRLP4 4
INDIRI4
CNSTI4 1
SUBI4
ASGNI4
ADDRLP4 4
INDIRI4
CNSTI4 0
GTI4 $674
LABELV $676
line 2023
;2023:	}
LABELV $672
line 2027
;2024:
;2025:	// run a client frame to drop exactly to the floor,
;2026:	// initialize animations and other things
;2027:	client->ps.commandTime = level.time - 100;
ADDRLP4 0
INDIRP4
ADDRGP4 level+32
INDIRI4
CNSTI4 100
SUBI4
ASGNI4
line 2028
;2028:	ent->client->pers.cmd.serverTime = level.time;
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 1384
ADDP4
ADDRGP4 level+32
INDIRI4
ASGNI4
line 2029
;2029:	ClientThink( ent-g_entities );
ADDRFP4 0
INDIRP4
CVPU4 4
ADDRGP4 g_entities
CVPU4 4
SUBU4
CVUI4 4
CNSTI4 828
DIVI4
ARGI4
ADDRGP4 ClientThink
CALLV
pop
line 2032
;2030:
;2031:	// positively link the client, even if the command times are weird
;2032:	if ( ent->client->sess.sessionTeam != TEAM_SPECTATOR ) {
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 1536
ADDP4
INDIRI4
CNSTI4 3
EQI4 $682
line 2033
;2033:		BG_PlayerStateToEntityState( &client->ps, &ent->s, qtrue );
ADDRLP4 0
INDIRP4
ARGP4
ADDRFP4 0
INDIRP4
ARGP4
CNSTI4 1
ARGI4
ADDRGP4 BG_PlayerStateToEntityState
CALLV
pop
line 2034
;2034:		VectorCopy( ent->client->ps.origin, ent->r.currentOrigin );
ADDRLP4 864
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 864
INDIRP4
CNSTI4 368
ADDP4
ADDRLP4 864
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 20
ADDP4
INDIRB
ASGNB 12
line 2035
;2035:		trap_LinkEntity( ent );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 trap_LinkEntity
CALLV
pop
line 2036
;2036:	}
LABELV $682
line 2038
;2037:
;2038:	if (g_spawnInvulnerability.integer)
ADDRGP4 g_spawnInvulnerability+12
INDIRI4
CNSTI4 0
EQI4 $684
line 2039
;2039:	{
line 2040
;2040:		ent->client->ps.eFlags |= EF_INVULNERABLE;
ADDRLP4 864
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 108
ADDP4
ASGNP4
ADDRLP4 864
INDIRP4
ADDRLP4 864
INDIRP4
INDIRI4
CNSTI4 67108864
BORI4
ASGNI4
line 2041
;2041:		ent->client->invulnerableTimer = level.time + g_spawnInvulnerability.integer;
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 1580
ADDP4
ADDRGP4 level+32
INDIRI4
ADDRGP4 g_spawnInvulnerability+12
INDIRI4
ADDI4
ASGNI4
line 2042
;2042:	}
LABELV $684
line 2045
;2043:
;2044:	// run the presend to set anything else
;2045:	ClientEndFrame( ent );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 ClientEndFrame
CALLV
pop
line 2048
;2046:
;2047:	// clear entity state values
;2048:	BG_PlayerStateToEntityState( &client->ps, &ent->s, qtrue );
ADDRLP4 0
INDIRP4
ARGP4
ADDRFP4 0
INDIRP4
ARGP4
CNSTI4 1
ARGI4
ADDRGP4 BG_PlayerStateToEntityState
CALLV
pop
line 2049
;2049:}
LABELV $564
endproc ClientSpawn 876 16
export ClientDisconnect
proc ClientDisconnect 24 8
line 2064
;2050:
;2051:
;2052:/*
;2053:===========
;2054:ClientDisconnect
;2055:
;2056:Called when a player drops from the server.
;2057:Will not be called between levels.
;2058:
;2059:This should NOT be called directly by any game logic,
;2060:call trap_DropClient(), which will call this and do
;2061:server system housekeeping.
;2062:============
;2063:*/
;2064:void ClientDisconnect( int clientNum ) {
line 2071
;2065:	gentity_t	*ent;
;2066:	gentity_t	*tent;
;2067:	int			i;
;2068:
;2069:	// cleanup if we are kicking a bot that
;2070:	// hasn't spawned yet
;2071:	G_RemoveQueuedBotBegin( clientNum );
ADDRFP4 0
INDIRI4
ARGI4
ADDRGP4 G_RemoveQueuedBotBegin
CALLV
pop
line 2073
;2072:
;2073:	ent = g_entities + clientNum;
ADDRLP4 4
CNSTI4 828
ADDRFP4 0
INDIRI4
MULI4
ADDRGP4 g_entities
ADDP4
ASGNP4
line 2074
;2074:	if ( !ent->client ) {
ADDRLP4 4
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $690
line 2075
;2075:		return;
ADDRGP4 $689
JUMPV
LABELV $690
line 2078
;2076:	}
;2077:
;2078:	i = 0;
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 $693
JUMPV
LABELV $692
line 2081
;2079:
;2080:	while (i < NUM_FORCE_POWERS)
;2081:	{
line 2082
;2082:		if (ent->client->ps.fd.forcePowersActive & (1 << i))
ADDRLP4 4
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 848
ADDP4
INDIRI4
CNSTI4 1
ADDRLP4 0
INDIRI4
LSHI4
BANDI4
CNSTI4 0
EQI4 $695
line 2083
;2083:		{
line 2084
;2084:			WP_ForcePowerStop(ent, i);
ADDRLP4 4
INDIRP4
ARGP4
ADDRLP4 0
INDIRI4
ARGI4
ADDRGP4 WP_ForcePowerStop
CALLV
pop
line 2085
;2085:		}
LABELV $695
line 2086
;2086:		i++;
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 2087
;2087:	}
LABELV $693
line 2080
ADDRLP4 0
INDIRI4
CNSTI4 18
LTI4 $692
line 2089
;2088:
;2089:	i = TRACK_CHANNEL_1;
ADDRLP4 0
CNSTI4 51
ASGNI4
ADDRGP4 $698
JUMPV
LABELV $697
line 2092
;2090:
;2091:	while (i < NUM_TRACK_CHANNELS)
;2092:	{
line 2093
;2093:		if (ent->client->ps.fd.killSoundEntIndex[i-50] && ent->client->ps.fd.killSoundEntIndex[i-50] < MAX_GENTITIES && ent->client->ps.fd.killSoundEntIndex[i-50] > 0)
ADDRLP4 12
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
CNSTI4 200
SUBI4
ADDRLP4 4
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 1200
ADDP4
ADDP4
INDIRI4
ASGNI4
ADDRLP4 16
CNSTI4 0
ASGNI4
ADDRLP4 12
INDIRI4
ADDRLP4 16
INDIRI4
EQI4 $700
ADDRLP4 12
INDIRI4
CNSTI4 1024
GEI4 $700
ADDRLP4 12
INDIRI4
ADDRLP4 16
INDIRI4
LEI4 $700
line 2094
;2094:		{
line 2095
;2095:			G_MuteSound(ent->client->ps.fd.killSoundEntIndex[i-50], CHAN_VOICE);
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
CNSTI4 200
SUBI4
ADDRLP4 4
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 1200
ADDP4
ADDP4
INDIRI4
ARGI4
CNSTI4 3
ARGI4
ADDRGP4 G_MuteSound
CALLV
pop
line 2096
;2096:		}
LABELV $700
line 2097
;2097:		i++;
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 2098
;2098:	}
LABELV $698
line 2091
ADDRLP4 0
INDIRI4
CNSTI4 56
LTI4 $697
line 2099
;2099:	i = 0;
ADDRLP4 0
CNSTI4 0
ASGNI4
line 2102
;2100:
;2101:	// stop any following clients
;2102:	for ( i = 0 ; i < level.maxclients ; i++ ) {
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 $705
JUMPV
LABELV $702
line 2103
;2103:		if ( level.clients[i].sess.sessionTeam == TEAM_SPECTATOR
ADDRLP4 12
CNSTI4 1804
ADDRLP4 0
INDIRI4
MULI4
ADDRGP4 level
INDIRP4
ADDP4
ASGNP4
ADDRLP4 12
INDIRP4
CNSTI4 1536
ADDP4
INDIRI4
CNSTI4 3
NEI4 $707
ADDRLP4 12
INDIRP4
CNSTI4 1544
ADDP4
INDIRI4
CNSTI4 2
NEI4 $707
ADDRLP4 12
INDIRP4
CNSTI4 1548
ADDP4
INDIRI4
ADDRFP4 0
INDIRI4
NEI4 $707
line 2105
;2104:			&& level.clients[i].sess.spectatorState == SPECTATOR_FOLLOW
;2105:			&& level.clients[i].sess.spectatorClient == clientNum ) {
line 2106
;2106:			StopFollowing( &g_entities[i] );
CNSTI4 828
ADDRLP4 0
INDIRI4
MULI4
ADDRGP4 g_entities
ADDP4
ARGP4
ADDRGP4 StopFollowing
CALLV
pop
line 2107
;2107:		}
LABELV $707
line 2108
;2108:	}
LABELV $703
line 2102
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $705
ADDRLP4 0
INDIRI4
ADDRGP4 level+24
INDIRI4
LTI4 $702
line 2111
;2109:
;2110:	// send effect if they were completely connected
;2111:	if ( ent->client->pers.connected == CON_CONNECTED 
ADDRLP4 12
ADDRLP4 4
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
ASGNP4
ADDRLP4 12
INDIRP4
CNSTI4 1380
ADDP4
INDIRI4
CNSTI4 2
NEI4 $709
ADDRLP4 12
INDIRP4
CNSTI4 1536
ADDP4
INDIRI4
CNSTI4 3
EQI4 $709
line 2112
;2112:		&& ent->client->sess.sessionTeam != TEAM_SPECTATOR ) {
line 2113
;2113:		tent = G_TempEntity( ent->client->ps.origin, EV_PLAYER_TELEPORT_OUT );
ADDRLP4 4
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 20
ADDP4
ARGP4
CNSTI4 60
ARGI4
ADDRLP4 16
ADDRGP4 G_TempEntity
CALLP4
ASGNP4
ADDRLP4 8
ADDRLP4 16
INDIRP4
ASGNP4
line 2114
;2114:		tent->s.clientNum = ent->s.clientNum;
ADDRLP4 20
CNSTI4 220
ASGNI4
ADDRLP4 8
INDIRP4
ADDRLP4 20
INDIRI4
ADDP4
ADDRLP4 4
INDIRP4
ADDRLP4 20
INDIRI4
ADDP4
INDIRI4
ASGNI4
line 2118
;2115:
;2116:		// They don't get to take powerups with them!
;2117:		// Especially important for stuff like CTF flags
;2118:		TossClientItems( ent );
ADDRLP4 4
INDIRP4
ARGP4
ADDRGP4 TossClientItems
CALLV
pop
line 2119
;2119:	}
LABELV $709
line 2121
;2120:
;2121:	G_LogPrintf( "ClientDisconnect: %i\n", clientNum );
ADDRGP4 $711
ARGP4
ADDRFP4 0
INDIRI4
ARGI4
ADDRGP4 G_LogPrintf
CALLV
pop
line 2124
;2122:
;2123:	// if we are playing in tourney mode, give a win to the other player and clear his frags for this round
;2124:	if ( (g_gametype.integer == GT_TOURNAMENT )
ADDRGP4 g_gametype+12
INDIRI4
CNSTI4 3
NEI4 $712
ADDRLP4 16
CNSTI4 0
ASGNI4
ADDRGP4 level+9008
INDIRI4
ADDRLP4 16
INDIRI4
NEI4 $712
ADDRGP4 level+16
INDIRI4
ADDRLP4 16
INDIRI4
NEI4 $712
line 2126
;2125:		&& !level.intermissiontime
;2126:		&& !level.warmupTime ) {
line 2127
;2127:		if ( level.sortedClients[1] == clientNum ) {
ADDRGP4 level+84+4
INDIRI4
ADDRFP4 0
INDIRI4
NEI4 $717
line 2128
;2128:			level.clients[ level.sortedClients[0] ].ps.persistant[PERS_SCORE] = 0;
CNSTI4 1804
ADDRGP4 level+84
INDIRI4
MULI4
ADDRGP4 level
INDIRP4
ADDP4
CNSTI4 280
ADDP4
CNSTI4 0
ASGNI4
line 2129
;2129:			level.clients[ level.sortedClients[0] ].sess.wins++;
ADDRLP4 20
CNSTI4 1804
ADDRGP4 level+84
INDIRI4
MULI4
ADDRGP4 level
INDIRP4
ADDP4
CNSTI4 1552
ADDP4
ASGNP4
ADDRLP4 20
INDIRP4
ADDRLP4 20
INDIRP4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 2130
;2130:			ClientUserinfoChanged( level.sortedClients[0] );
ADDRGP4 level+84
INDIRI4
ARGI4
ADDRGP4 ClientUserinfoChanged
CALLV
pop
line 2131
;2131:		}
ADDRGP4 $718
JUMPV
LABELV $717
line 2132
;2132:		else if ( level.sortedClients[0] == clientNum ) {
ADDRGP4 level+84
INDIRI4
ADDRFP4 0
INDIRI4
NEI4 $724
line 2133
;2133:			level.clients[ level.sortedClients[1] ].ps.persistant[PERS_SCORE] = 0;
CNSTI4 1804
ADDRGP4 level+84+4
INDIRI4
MULI4
ADDRGP4 level
INDIRP4
ADDP4
CNSTI4 280
ADDP4
CNSTI4 0
ASGNI4
line 2134
;2134:			level.clients[ level.sortedClients[1] ].sess.wins++;
ADDRLP4 20
CNSTI4 1804
ADDRGP4 level+84+4
INDIRI4
MULI4
ADDRGP4 level
INDIRP4
ADDP4
CNSTI4 1552
ADDP4
ASGNP4
ADDRLP4 20
INDIRP4
ADDRLP4 20
INDIRP4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 2135
;2135:			ClientUserinfoChanged( level.sortedClients[1] );
ADDRGP4 level+84+4
INDIRI4
ARGI4
ADDRGP4 ClientUserinfoChanged
CALLV
pop
line 2136
;2136:		}
LABELV $724
LABELV $718
line 2137
;2137:	}
LABELV $712
line 2139
;2138:
;2139:	trap_UnlinkEntity (ent);
ADDRLP4 4
INDIRP4
ARGP4
ADDRGP4 trap_UnlinkEntity
CALLV
pop
line 2140
;2140:	ent->s.modelindex = 0;
ADDRLP4 4
INDIRP4
CNSTI4 212
ADDP4
CNSTI4 0
ASGNI4
line 2141
;2141:	ent->inuse = qfalse;
ADDRLP4 4
INDIRP4
CNSTI4 412
ADDP4
CNSTI4 0
ASGNI4
line 2142
;2142:	ent->classname = "disconnected";
ADDRLP4 4
INDIRP4
CNSTI4 416
ADDP4
ADDRGP4 $733
ASGNP4
line 2143
;2143:	ent->client->pers.connected = CON_DISCONNECTED;
ADDRLP4 4
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 1380
ADDP4
CNSTI4 0
ASGNI4
line 2144
;2144:	ent->client->ps.persistant[PERS_TEAM] = TEAM_FREE;
ADDRLP4 4
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 292
ADDP4
CNSTI4 0
ASGNI4
line 2145
;2145:	ent->client->sess.sessionTeam = TEAM_FREE;
ADDRLP4 4
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 1536
ADDP4
CNSTI4 0
ASGNI4
line 2147
;2146:
;2147:	trap_SetConfigstring( CS_PLAYERS + clientNum, "");
ADDRFP4 0
INDIRI4
CNSTI4 544
ADDI4
ARGI4
ADDRGP4 $734
ARGP4
ADDRGP4 trap_SetConfigstring
CALLV
pop
line 2149
;2148:
;2149:	CalculateRanks();
ADDRGP4 CalculateRanks
CALLV
pop
line 2151
;2150:
;2151:	if ( ent->r.svFlags & SVF_BOT ) {
ADDRLP4 4
INDIRP4
CNSTI4 304
ADDP4
INDIRI4
CNSTI4 8
BANDI4
CNSTI4 0
EQI4 $735
line 2152
;2152:		BotAIShutdownClient( clientNum, qfalse );
ADDRFP4 0
INDIRI4
ARGI4
CNSTI4 0
ARGI4
ADDRGP4 BotAIShutdownClient
CALLI4
pop
line 2153
;2153:	}
LABELV $735
line 2155
;2154:
;2155:	G_ClearClientLog(clientNum);
ADDRFP4 0
INDIRI4
ARGI4
ADDRGP4 G_ClearClientLog
CALLV
pop
line 2156
;2156:}
LABELV $689
endproc ClientDisconnect 24 8
import WP_HasForcePowers
import G_WriteClientSessionData
bss
export Client_Force
align 4
LABELV Client_Force
skip 15104
import trap_ROFF_Purge_Ent
import trap_ROFF_Play
import trap_ROFF_Cache
import trap_ROFF_UpdateEntities
import trap_ROFF_Clean
import trap_SP_GetStringTextString
import trap_SP_Register
import trap_SP_RegisterServer
import trap_SnapVector
import trap_GeneticParentsAndChildSelection
import trap_BotResetWeaponState
import trap_BotFreeWeaponState
import trap_BotAllocWeaponState
import trap_BotLoadWeaponWeights
import trap_BotGetWeaponInfo
import trap_BotChooseBestFightWeapon
import trap_BotAddAvoidSpot
import trap_BotInitMoveState
import trap_BotFreeMoveState
import trap_BotAllocMoveState
import trap_BotPredictVisiblePosition
import trap_BotMovementViewTarget
import trap_BotReachabilityArea
import trap_BotResetLastAvoidReach
import trap_BotResetAvoidReach
import trap_BotMoveInDirection
import trap_BotMoveToGoal
import trap_BotResetMoveState
import trap_BotFreeGoalState
import trap_BotAllocGoalState
import trap_BotMutateGoalFuzzyLogic
import trap_BotSaveGoalFuzzyLogic
import trap_BotInterbreedGoalFuzzyLogic
import trap_BotFreeItemWeights
import trap_BotLoadItemWeights
import trap_BotUpdateEntityItems
import trap_BotInitLevelItems
import trap_BotSetAvoidGoalTime
import trap_BotAvoidGoalTime
import trap_BotGetLevelItemGoal
import trap_BotGetMapLocationGoal
import trap_BotGetNextCampSpotGoal
import trap_BotItemGoalInVisButNotVisible
import trap_BotTouchingGoal
import trap_BotChooseNBGItem
import trap_BotChooseLTGItem
import trap_BotGetSecondGoal
import trap_BotGetTopGoal
import trap_BotGoalName
import trap_BotDumpGoalStack
import trap_BotDumpAvoidGoals
import trap_BotEmptyGoalStack
import trap_BotPopGoal
import trap_BotPushGoal
import trap_BotResetAvoidGoals
import trap_BotRemoveFromAvoidGoals
import trap_BotResetGoalState
import trap_BotSetChatName
import trap_BotSetChatGender
import trap_BotLoadChatFile
import trap_BotReplaceSynonyms
import trap_UnifyWhiteSpaces
import trap_BotMatchVariable
import trap_BotFindMatch
import trap_StringContains
import trap_BotGetChatMessage
import trap_BotEnterChat
import trap_BotChatLength
import trap_BotReplyChat
import trap_BotNumInitialChats
import trap_BotInitialChat
import trap_BotNumConsoleMessages
import trap_BotNextConsoleMessage
import trap_BotRemoveConsoleMessage
import trap_BotQueueConsoleMessage
import trap_BotFreeChatState
import trap_BotAllocChatState
import trap_Characteristic_String
import trap_Characteristic_BInteger
import trap_Characteristic_Integer
import trap_Characteristic_BFloat
import trap_Characteristic_Float
import trap_BotFreeCharacter
import trap_BotLoadCharacter
import trap_EA_ResetInput
import trap_EA_GetInput
import trap_EA_EndRegular
import trap_EA_ForcePower
import trap_EA_Alt_Attack
import trap_EA_View
import trap_EA_Move
import trap_EA_DelayedJump
import trap_EA_Jump
import trap_EA_SelectWeapon
import trap_EA_MoveRight
import trap_EA_MoveLeft
import trap_EA_MoveBack
import trap_EA_MoveForward
import trap_EA_MoveDown
import trap_EA_MoveUp
import trap_EA_Crouch
import trap_EA_Respawn
import trap_EA_Use
import trap_EA_Attack
import trap_EA_Talk
import trap_EA_Gesture
import trap_EA_Action
import trap_EA_Command
import trap_EA_SayTeam
import trap_EA_Say
import trap_AAS_PredictClientMovement
import trap_AAS_Swimming
import trap_AAS_AlternativeRouteGoals
import trap_AAS_PredictRoute
import trap_AAS_EnableRoutingArea
import trap_AAS_AreaTravelTimeToGoalArea
import trap_AAS_AreaReachability
import trap_AAS_IntForBSPEpairKey
import trap_AAS_FloatForBSPEpairKey
import trap_AAS_VectorForBSPEpairKey
import trap_AAS_ValueForBSPEpairKey
import trap_AAS_NextBSPEntity
import trap_AAS_PointContents
import trap_AAS_TraceAreas
import trap_AAS_PointReachabilityAreaIndex
import trap_AAS_PointAreaNum
import trap_AAS_Time
import trap_AAS_PresenceTypeBoundingBox
import trap_AAS_Initialized
import trap_AAS_EntityInfo
import trap_AAS_AreaInfo
import trap_AAS_BBoxAreas
import trap_BotUserCommand
import trap_BotGetServerCommand
import trap_BotGetSnapshotEntity
import trap_BotLibTest
import trap_BotLibUpdateEntity
import trap_BotLibLoadMap
import trap_BotLibStartFrame
import trap_BotLibDefine
import trap_BotLibVarGet
import trap_BotLibVarSet
import trap_BotLibShutdown
import trap_BotLibSetup
import trap_DebugPolygonDelete
import trap_DebugPolygonCreate
import trap_GetEntityToken
import trap_GetUsercmd
import trap_BotFreeClient
import trap_BotAllocateClient
import trap_EntityContact
import trap_EntitiesInBox
import trap_UnlinkEntity
import trap_LinkEntity
import trap_AreasConnected
import trap_AdjustAreaPortalState
import trap_InPVSIgnorePortals
import trap_InPVS
import trap_PointContents
import trap_Trace
import trap_SetBrushModel
import trap_GetServerinfo
import trap_SetUserinfo
import trap_GetUserinfo
import trap_GetConfigstring
import trap_SetConfigstring
import trap_SendServerCommand
import trap_DropClient
import trap_LocateGameData
import trap_Cvar_VariableStringBuffer
import trap_Cvar_VariableValue
import trap_Cvar_VariableIntegerValue
import trap_Cvar_Set
import trap_Cvar_Update
import trap_Cvar_Register
import trap_SendConsoleCommand
import trap_FS_GetFileList
import trap_FS_FCloseFile
import trap_FS_Write
import trap_FS_Read
import trap_FS_FOpenFile
import trap_Args
import trap_Argv
import trap_Argc
import trap_Milliseconds
import trap_Error
import trap_Printf
import g_austrian
import g_saberDebugPrint
import g_saberDmgDelay_Wound
import g_saberDmgDelay_Idle
import g_saberDmgVelocityScale
import g_timeouttospec
import g_forceDodge
import g_dismember
import g_singlePlayer
import g_enableBreath
import g_enableDust
import g_rankings
import pmove_msec
import pmove_fixed
import g_smoothClients
import g_blueteam
import g_redteam
import g_debugUp
import g_debugRight
import g_debugForward
import g_filterBan
import g_banIPs
import g_teamForceBalance
import g_teamAutoJoin
import g_allowVote
import g_blood
import g_doWarmup
import g_warmup
import g_motd
import g_synchronousClients
import g_adaptRespawn
import g_weaponTeamRespawn
import g_weaponRespawn
import g_debugDamage
import g_debugAlloc
import g_debugMove
import g_inactivity
import g_forcerespawn
import g_quadfactor
import g_knockback
import g_speed
import g_gravity
import g_needpass
import g_password
import g_friendlySaber
import g_friendlyFire
import g_saberInterpolate
import g_capturelimit
import g_timelimit
import g_duel_fraglimit
import g_fraglimit
import g_duelWeaponDisable
import g_fraglimitVoteCorrection
import g_allowDuelSuicide
import g_weaponDisable
import g_forcePowerDisable
import g_spawnInvulnerability
import g_forceRegenTime
import g_saberDamageScale
import g_slowmoDuelEnd
import g_logClientInfo
import g_saberBoxTraceSize
import g_saberAlwaysBoxTrace
import g_saberGhoul2Collision
import g_saberTraceSaberFirst
import g_saberLockFactor
import g_saberLocking
import g_privateDuel
import g_forceBasedTeams
import g_maxForceRank
import g_dmflags
import g_autoMapCycle
import g_trueJedi
import g_restarted
import g_maxGameClients
import g_maxclients
import g_cheats
import g_dedicated
import g_gametype
import g_vehicles
import g_vehicleTemplates
import vehicleId
import VehicleTemplateArray_GetTemplateIndexForName
import VehicleTemplateArray_OutputTemplates
import VehicleTemplateArray_InitVehicleTemplateArray
import VehicleArray_OutputVehicles
import VehicleArray_RemoveVehicleForId
import VehicleArray_AddVehicle
import VehicleArray_SetVehicleForId
import VehicleArray_GetVehicleForId
import VehicleArray_InitVehicleArray
import G_SpawnVehicle
import Touch_Vehicle
import VehicleInfo_GetNameForMovementType
import VehicleInfo_GetBitForMovementType
import VehicleInfo_GetNameForWeapon
import VehicleInfo_GetIndexForWeapon
import VehicleInfo_GetBitForWeapon
import VehicleInfo_GetBitForVehicleType
import Vehicle_CopyVehicle
import Vehicle_InitVehicle
import g_entities
import level
import Pickup_Team
import CheckTeamStatus
import TeamplayInfoMessage
import Team_GetLocationMsg
import Team_GetLocation
import SelectSagaSpawnPoint
import SelectCTFSpawnPoint
import Team_FreeEntity
import Team_ReturnFlag
import Team_InitGame
import Team_CheckHurtCarrier
import Team_FragBonuses
import Team_DroppedFlagThink
import AddTeamScore
import TeamColorString
import OtherTeamName
import TeamName
import OtherTeam
import BotAIStartFrame
import BotAIShutdownClient
import BotAISetupClient
import BotAILoadMap
import BotAIShutdown
import BotAISetup
import B_CleanupAlloc
import B_InitAlloc
import InFieldOfVision
import BotOrder
import OrgVisible
import InitSagaMode
import G_ClearClientLog
import G_LogExit
import G_LogWeaponOutput
import G_LogWeaponInit
import G_LogWeaponItem
import G_LogWeaponPowerup
import G_LogWeaponFrag
import G_LogWeaponDeath
import G_LogWeaponKill
import G_LogWeaponDamage
import G_LogWeaponFire
import G_LogWeaponPickup
import Jedi_DodgeEvasion
import ForceTelepathy
import ForceThrow
import ForceSeeing
import ForceTeamForceReplenish
import ForceTeamHeal
import ForceAbsorb
import ForceProtect
import ForceGrip
import ForceRage
import ForceSpeed
import ForceHeal
import ForcePowerUsableOn
import WP_ForcePowersUpdate
import WP_SpawnInitForcePowers
import WP_InitForcePowers
import WP_SaberInitBladeData
import WP_SaberCanBlock
import WP_SaberPositionUpdate
import WP_ForcePowerStop
import HasSetSaberOnly
import G_PreDefSound
import G_RefreshNextMap
import G_DoesMapSupportGametype
import BotInterbreedEndMatch
import Svcmd_BotList_f
import Svcmd_AddBot_f
import G_BotConnect
import G_RemoveQueuedBotBegin
import G_CheckBotSpawn
import G_GetBotInfoByName
import G_GetBotInfoByNumber
import G_InitBots
import UpdateTournamentInfo
import G_WriteSessionData
import G_InitWorldSession
import G_InitSessionData
import G_ReadSessionData
import Svcmd_GameMem_f
import G_InitMemory
import G_Alloc
import Team_CheckDroppedItem
import OnSameTeam
import G_RunClient
import ClientEndFrame
import ClientThink
import G_CheckClientTimeouts
import ClientCommand
import G_GetStripEdString
import G_Error
import G_Printf
import SendScoreboardMessageToAllClients
import G_LogPrintf
import G_RunThink
import CheckTeamLeader
import SetLeader
import FindIntermissionPoint
import gSlowMoDuelTime
import gDoSlowMoDuel
import g_ff_objectives
import DeathmatchScoreboardMessage
import G_SetStats
import MoveClientToIntermission
import BlowDetpacks
import FireWeapon
import G_FilterPacket
import G_ProcessIPBans
import ConsoleCommand
import CalculateRanks
import AddScore
import player_die
import BeginIntermission
import CheckGauntletAttack
import SnapVectorTowards
import CalcMuzzlePoint
import LogAccuracyHit
import WP_FireGenericBlasterMissile
import WP_FireTurretMissile
import G_CreateExampleAnimEnt
import G_PlayerBecomeATST
import ATST_ManageDamageBoxes
import TeleportPlayer
import trigger_teleporter_touch
import Touch_DoorTrigger
import G_RunMover
import WP_FireBlasterMissile
import G_ExplodeMissile
import G_BounceProjectile
import CreateMissile
import G_RunMissile
import G_ReflectMissile
import gGAvoidDismember
import G_CheckForDismemberment
import ExplodeDeath
import TossClientCubes
import TossClientItems
import TossClientWeapon
import body_die
import G_RadiusDamage
import G_Damage
import CanDamage
import trap_G2API_SetBoneAnim
import trap_G2API_GetGLAName
import trap_G2API_SetBoneAngles
import trap_G2API_CollisionDetect
import trap_G2API_CleanGhoul2Models
import trap_G2API_RemoveGhoul2Model
import trap_G2API_HasGhoul2ModelOnIndex
import trap_G2API_DuplicateGhoul2Instance
import trap_G2API_CopySpecificGhoul2Model
import trap_G2API_CopyGhoul2Instance
import trap_G2API_SetBoltInfo
import trap_G2API_AddBolt
import trap_G2API_InitGhoul2Model
import trap_G2API_GetBoltMatrix_NoRecNoRot
import trap_G2API_GetBoltMatrix_NoReconstruct
import trap_G2API_GetBoltMatrix
import trap_G2_HaveWeGhoul2Models
import trap_G2_SetGhoul2ModelIndexes
import trap_G2_ListModelBones
import trap_G2_ListModelSurfaces
import G_SkinIndex
import BuildShaderStateConfig
import AddRemap
import G_SetOrigin
import G_AddEvent
import G_AddPredictableEvent
import vtos
import tv
import G_RunObject
import G_TouchSolids
import G_TouchTriggers
import G_EntitiesFree
import G_FreeEntity
import G_KillG2Queue
import G_SendG2KillQueue
import TryUse
import G_EntitySound
import G_SoundAtLoc
import G_Sound
import G_MuteSound
import G_ScreenShake
import G_PlayEffect
import G_TempEntity
import G_Spawn
import G_InitGentity
import G_SetAngles
import G_SetMovedir
import G_UseTargets
import G_PickTarget
import G_RadiusList
import G_Find
import G_KillBox
import G_TeamCommand
import G_EffectIndex
import G_SoundIndex
import G_ModelIndex
import SaveRegisteredItems
import RegisterItem
import ClearRegisteredItems
import Touch_Item
import Add_Ammo
import ArmorIndex
import Think_Weapon
import FinishSpawningItem
import G_SpawnItem
import SetRespawn
import LaunchItem
import Drop_Item
import PrecacheItem
import UseHoldableItem
import RespawnItem
import G_RunItem
import G_CheckTeamItems
import ItemUse_MedPack
import ItemUse_Seeker
import ItemUse_Sentry
import ItemUse_Shield
import ItemUse_Binoculars
import G_GetDuelWinner
import Cmd_EngageDuel_f
import Cmd_ToggleSaber_f
import G_ItemUsable
import Cmd_SaberAttackCycle_f
import Cmd_FollowCycle_f
import SetTeam
import BroadcastTeamChange
import StopFollowing
import Cmd_Score_f
import G_NewString
import G_SpawnEntitiesFromString
import G_SpawnVector
import G_SpawnInt
import G_SpawnFloat
import G_SpawnString
import gEscapeTime
import gEscaping
import precachedKyle
import forcePowerDarkLight
import WeaponAttackAnim
import WeaponReadyAnim
import BG_OutOfMemory
import BG_StringAlloc
import BG_TempFree
import BG_TempAlloc
import BG_AllocUnaligned
import BG_Alloc
import BG_CanUseFPNow
import BG_HasYsalamiri
import BG_GetItemIndexByTag
import BG_ParseAnimationFile
import BG_PlayerTouchesItem
import BG_PlayerStateToEntityStateExtraPolate
import BG_PlayerStateToEntityState
import BG_TouchJumpPad
import BG_AddPredictableEventToPlayerstate
import BG_EvaluateTrajectoryDelta
import BG_EvaluateTrajectory
import BG_ForcePowerDrain
import BG_SaberStartTransAnim
import BG_InDeathAnim
import BG_InRoll
import BG_KnockawayForParry
import BG_BrokenParryForParry
import BG_BrokenParryForAttack
import BG_SaberInSpecialAttack
import BG_SpinningSaberAnim
import BG_FlippingAnim
import BG_SaberInIdle
import BG_SaberInSpecial
import BG_SaberInAttack
import BG_DirectFlippingAnim
import BG_InSaberStandAnim
import BG_InSpecialJump
import BG_LegalizedForcePowers
import saberMoveData
import BG_CanItemBeGrabbed
import BG_FindItemForHoldable
import BG_FindItemForPowerup
import BG_FindItemForWeapon
import BG_FindItem
import vectoyaw
import bg_numItems
import bg_itemlist
import PM_CalculateRelativeViewAngles
import Pmove
import PM_QuaternionViewAngles
import PM_UpdateViewAngles
import pm
import bgForcePowerCost
import forceMasteryPoints
import forceMasteryLevels
import bgGlobalAnimations
import BGPAFtextLoaded
import forcePowerSorted
import WP_MuzzlePoint
import ammoData
import weaponData
import GetStringForID
import GetIDForString
import Q_irand
import irand
import flrand
import Rand_Init
import Com_Printf
import Com_Error
import Info_NextPair
import Info_Validate
import Info_SetValueForKey_Big
import Info_SetValueForKey
import Info_RemoveKey_big
import Info_RemoveKey
import Info_ValueForKey
import va
import Q_CleanStr
import Q_PrintStrlen
import Q_strcat
import Q_strncpyz
import Q_strrchr
import Q_strupr
import Q_strlwr
import Q_stricmpn
import Q_strncmp
import Q_stricmp
import Q_isalpha
import Q_isupper
import Q_islower
import Q_isprint
import Com_sprintf
import Parse3DMatrix
import Parse2DMatrix
import Parse1DMatrix
import SkipRestOfLine
import SkipBracedSection
import COM_MatchToken
import COM_ParseVec4
import COM_ParseFloat
import COM_ParseInt
import COM_ParseString
import COM_ParseWarning
import COM_ParseError
import COM_Compress
import COM_ParseExt
import COM_Parse
import SkipWhitespace
import COM_GetCurrentParseLine
import COM_BeginParseSession
import COM_DefaultExtension
import COM_StripExtension
import COM_SkipPath
import Com_Clamp
import MatrixToEuler
import QuatToAngles
import QuatMul
import AnglesToQuat
import AxisToQuaternion
import QuaternionToAxis
import QuaternionToEuler
import QuatToAxis
import QuaternionMultiply
import QuaternionNormalize
import QuaternionMagnitude
import QuaternionFromString
import AnglesToTieFloats
import AnglesFromTieFloats
import QuaternionToTieFloats
import QuaternionFromTieFloats
import QuaternionCopy
import PerpendicularVector
import AngleVectors
import RotationMatrixAroundDir
import MatrixMultiply
import MakeNormalVectors
import RotateAroundDirection
import RotatePointAroundVector
import ProjectPointOnPlane
import PlaneFromPoints
import AngleDelta
import AngleNormalize180
import AngleNormalize360
import AnglesSubtract
import AngleSubtract
import LerpAngle
import AngleMod
import BoxOnPlaneSide
import SetPlaneSignbits
import AxisCopy
import AxisClear
import AnglesToAxis
import vectoangles
import Q_crandom
import Q_random
import Q_rand
import Q_acos
import Q_log2
import VectorRotate
import Vector4Scale
import VectorNormalize2
import VectorNormalize
import CrossProduct
import VectorInverse
import VectorNormalizeFast
import DistanceSquared
import Distance
import VectorLengthSquared
import VectorLength
import VectorCompare
import AddPointToBounds
import ClearBounds
import RadiusFromBounds
import NormalizeColor
import ColorBytes4
import ColorBytes3
import _VectorMA
import _VectorScale
import _VectorCopy
import _VectorAdd
import _VectorSubtract
import _DotProduct
import ByteToDir
import DirToByte
import powf
import ClampShort
import ClampChar
import Q_rsqrt
import Q_fabs
import axisDefault
import vec3_origin
import g_color_table
import colorDkBlue
import colorLtBlue
import colorDkGrey
import colorMdGrey
import colorLtGrey
import colorWhite
import colorCyan
import colorMagenta
import colorYellow
import colorBlue
import colorGreen
import colorRed
import colorBlack
import colorTable
import bytedirs
import Com_Memcpy
import Com_Memset
import Hunk_Alloc
import forceSpeedLevels
import FloatSwap
import LongSwap
import ShortSwap
import acos
import fabs
import abs
import tan
import atan2
import cos
import sin
import sqrt
import floor
import ceil
import memcpy
import memset
import memmove
import sscanf
import vsprintf
import _atoi
import atoi
import _atof
import atof
import toupper
import tolower
import strncpy
import strstr
import strchr
import strcmp
import strcpy
import strcat
import strlen
import rand
import srand
import qsort
lit
align 1
LABELV $734
byte 1 0
align 1
LABELV $733
byte 1 100
byte 1 105
byte 1 115
byte 1 99
byte 1 111
byte 1 110
byte 1 110
byte 1 101
byte 1 99
byte 1 116
byte 1 101
byte 1 100
byte 1 0
align 1
LABELV $711
byte 1 67
byte 1 108
byte 1 105
byte 1 101
byte 1 110
byte 1 116
byte 1 68
byte 1 105
byte 1 115
byte 1 99
byte 1 111
byte 1 110
byte 1 110
byte 1 101
byte 1 99
byte 1 116
byte 1 58
byte 1 32
byte 1 37
byte 1 105
byte 1 10
byte 1 0
align 1
LABELV $645
byte 1 103
byte 1 95
byte 1 106
byte 1 101
byte 1 100
byte 1 105
byte 1 86
byte 1 109
byte 1 101
byte 1 114
byte 1 99
byte 1 0
align 1
LABELV $598
byte 1 112
byte 1 108
byte 1 97
byte 1 121
byte 1 101
byte 1 114
byte 1 0
align 1
LABELV $554
byte 1 67
byte 1 108
byte 1 105
byte 1 101
byte 1 110
byte 1 116
byte 1 66
byte 1 101
byte 1 103
byte 1 105
byte 1 110
byte 1 58
byte 1 32
byte 1 37
byte 1 105
byte 1 10
byte 1 0
align 1
LABELV $553
byte 1 80
byte 1 76
byte 1 69
byte 1 78
byte 1 84
byte 1 69
byte 1 82
byte 1 0
align 1
LABELV $547
byte 1 77
byte 1 111
byte 1 116
byte 1 105
byte 1 111
byte 1 110
byte 1 0
align 1
LABELV $546
byte 1 114
byte 1 116
byte 1 105
byte 1 98
byte 1 105
byte 1 97
byte 1 0
align 1
LABELV $545
byte 1 108
byte 1 116
byte 1 105
byte 1 98
byte 1 105
byte 1 97
byte 1 0
align 1
LABELV $544
byte 1 114
byte 1 114
byte 1 97
byte 1 100
byte 1 105
byte 1 117
byte 1 115
byte 1 0
align 1
LABELV $543
byte 1 108
byte 1 114
byte 1 97
byte 1 100
byte 1 105
byte 1 117
byte 1 115
byte 1 0
align 1
LABELV $542
byte 1 116
byte 1 104
byte 1 111
byte 1 114
byte 1 97
byte 1 99
byte 1 105
byte 1 99
byte 1 0
align 1
LABELV $526
byte 1 66
byte 1 108
byte 1 117
byte 1 101
byte 1 0
align 1
LABELV $521
byte 1 82
byte 1 101
byte 1 100
byte 1 0
align 1
LABELV $511
byte 1 80
byte 1 76
byte 1 67
byte 1 79
byte 1 78
byte 1 78
byte 1 69
byte 1 67
byte 1 84
byte 1 0
align 1
LABELV $510
byte 1 112
byte 1 114
byte 1 105
byte 1 110
byte 1 116
byte 1 32
byte 1 34
byte 1 37
byte 1 115
byte 1 94
byte 1 55
byte 1 32
byte 1 37
byte 1 115
byte 1 10
byte 1 34
byte 1 0
align 1
LABELV $507
byte 1 67
byte 1 108
byte 1 105
byte 1 101
byte 1 110
byte 1 116
byte 1 67
byte 1 111
byte 1 110
byte 1 110
byte 1 101
byte 1 99
byte 1 116
byte 1 58
byte 1 32
byte 1 37
byte 1 105
byte 1 10
byte 1 0
align 1
LABELV $506
byte 1 66
byte 1 111
byte 1 116
byte 1 67
byte 1 111
byte 1 110
byte 1 110
byte 1 101
byte 1 99
byte 1 116
byte 1 102
byte 1 97
byte 1 105
byte 1 108
byte 1 101
byte 1 100
byte 1 0
align 1
LABELV $494
byte 1 73
byte 1 78
byte 1 86
byte 1 65
byte 1 76
byte 1 73
byte 1 68
byte 1 95
byte 1 80
byte 1 65
byte 1 83
byte 1 83
byte 1 87
byte 1 79
byte 1 82
byte 1 68
byte 1 0
align 1
LABELV $491
byte 1 110
byte 1 111
byte 1 110
byte 1 101
byte 1 0
align 1
LABELV $486
byte 1 112
byte 1 97
byte 1 115
byte 1 115
byte 1 119
byte 1 111
byte 1 114
byte 1 100
byte 1 0
align 1
LABELV $482
byte 1 66
byte 1 97
byte 1 110
byte 1 110
byte 1 101
byte 1 100
byte 1 46
byte 1 0
align 1
LABELV $478
byte 1 67
byte 1 108
byte 1 105
byte 1 101
byte 1 110
byte 1 116
byte 1 85
byte 1 115
byte 1 101
byte 1 114
byte 1 105
byte 1 110
byte 1 102
byte 1 111
byte 1 67
byte 1 104
byte 1 97
byte 1 110
byte 1 103
byte 1 101
byte 1 100
byte 1 58
byte 1 32
byte 1 37
byte 1 105
byte 1 32
byte 1 37
byte 1 115
byte 1 10
byte 1 0
align 1
LABELV $474
byte 1 110
byte 1 92
byte 1 37
byte 1 115
byte 1 92
byte 1 116
byte 1 92
byte 1 37
byte 1 105
byte 1 92
byte 1 109
byte 1 111
byte 1 100
byte 1 101
byte 1 108
byte 1 92
byte 1 37
byte 1 115
byte 1 92
byte 1 103
byte 1 95
byte 1 114
byte 1 101
byte 1 100
byte 1 116
byte 1 101
byte 1 97
byte 1 109
byte 1 92
byte 1 37
byte 1 115
byte 1 92
byte 1 103
byte 1 95
byte 1 98
byte 1 108
byte 1 117
byte 1 101
byte 1 116
byte 1 101
byte 1 97
byte 1 109
byte 1 92
byte 1 37
byte 1 115
byte 1 92
byte 1 99
byte 1 49
byte 1 92
byte 1 37
byte 1 115
byte 1 92
byte 1 99
byte 1 50
byte 1 92
byte 1 37
byte 1 115
byte 1 92
byte 1 104
byte 1 99
byte 1 92
byte 1 37
byte 1 105
byte 1 92
byte 1 119
byte 1 92
byte 1 37
byte 1 105
byte 1 92
byte 1 108
byte 1 92
byte 1 37
byte 1 105
byte 1 92
byte 1 116
byte 1 116
byte 1 92
byte 1 37
byte 1 100
byte 1 92
byte 1 116
byte 1 108
byte 1 92
byte 1 37
byte 1 100
byte 1 0
align 1
LABELV $473
byte 1 115
byte 1 107
byte 1 105
byte 1 108
byte 1 108
byte 1 0
align 1
LABELV $472
byte 1 110
byte 1 92
byte 1 37
byte 1 115
byte 1 92
byte 1 116
byte 1 92
byte 1 37
byte 1 105
byte 1 92
byte 1 109
byte 1 111
byte 1 100
byte 1 101
byte 1 108
byte 1 92
byte 1 37
byte 1 115
byte 1 92
byte 1 99
byte 1 49
byte 1 92
byte 1 37
byte 1 115
byte 1 92
byte 1 99
byte 1 50
byte 1 92
byte 1 37
byte 1 115
byte 1 92
byte 1 104
byte 1 99
byte 1 92
byte 1 37
byte 1 105
byte 1 92
byte 1 119
byte 1 92
byte 1 37
byte 1 105
byte 1 92
byte 1 108
byte 1 92
byte 1 37
byte 1 105
byte 1 92
byte 1 115
byte 1 107
byte 1 105
byte 1 108
byte 1 108
byte 1 92
byte 1 37
byte 1 115
byte 1 92
byte 1 116
byte 1 116
byte 1 92
byte 1 37
byte 1 100
byte 1 92
byte 1 116
byte 1 108
byte 1 92
byte 1 37
byte 1 100
byte 1 0
align 1
LABELV $469
byte 1 103
byte 1 95
byte 1 98
byte 1 108
byte 1 117
byte 1 101
byte 1 116
byte 1 101
byte 1 97
byte 1 109
byte 1 0
align 1
LABELV $468
byte 1 103
byte 1 95
byte 1 114
byte 1 101
byte 1 100
byte 1 116
byte 1 101
byte 1 97
byte 1 109
byte 1 0
align 1
LABELV $467
byte 1 99
byte 1 111
byte 1 108
byte 1 111
byte 1 114
byte 1 50
byte 1 0
align 1
LABELV $466
byte 1 99
byte 1 111
byte 1 108
byte 1 111
byte 1 114
byte 1 49
byte 1 0
align 1
LABELV $465
byte 1 116
byte 1 101
byte 1 97
byte 1 109
byte 1 116
byte 1 97
byte 1 115
byte 1 107
byte 1 0
align 1
LABELV $461
byte 1 116
byte 1 101
byte 1 97
byte 1 109
byte 1 111
byte 1 118
byte 1 101
byte 1 114
byte 1 108
byte 1 97
byte 1 121
byte 1 0
align 1
LABELV $456
byte 1 98
byte 1 0
align 1
LABELV $455
byte 1 98
byte 1 108
byte 1 117
byte 1 101
byte 1 0
align 1
LABELV $451
byte 1 114
byte 1 0
align 1
LABELV $450
byte 1 114
byte 1 101
byte 1 100
byte 1 0
align 1
LABELV $447
byte 1 116
byte 1 101
byte 1 97
byte 1 109
byte 1 0
align 1
LABELV $441
byte 1 102
byte 1 111
byte 1 114
byte 1 99
byte 1 101
byte 1 112
byte 1 111
byte 1 119
byte 1 101
byte 1 114
byte 1 115
byte 1 0
align 1
LABELV $440
byte 1 109
byte 1 111
byte 1 100
byte 1 101
byte 1 108
byte 1 0
align 1
LABELV $439
byte 1 116
byte 1 101
byte 1 97
byte 1 109
byte 1 95
byte 1 109
byte 1 111
byte 1 100
byte 1 101
byte 1 108
byte 1 0
align 1
LABELV $432
byte 1 80
byte 1 76
byte 1 82
byte 1 69
byte 1 78
byte 1 65
byte 1 77
byte 1 69
byte 1 0
align 1
LABELV $431
byte 1 112
byte 1 114
byte 1 105
byte 1 110
byte 1 116
byte 1 32
byte 1 34
byte 1 37
byte 1 115
byte 1 94
byte 1 55
byte 1 32
byte 1 37
byte 1 115
byte 1 32
byte 1 37
byte 1 115
byte 1 10
byte 1 34
byte 1 0
align 1
LABELV $426
byte 1 115
byte 1 99
byte 1 111
byte 1 114
byte 1 101
byte 1 98
byte 1 111
byte 1 97
byte 1 114
byte 1 100
byte 1 0
align 1
LABELV $421
byte 1 110
byte 1 97
byte 1 109
byte 1 101
byte 1 0
align 1
LABELV $418
byte 1 99
byte 1 103
byte 1 95
byte 1 112
byte 1 114
byte 1 101
byte 1 100
byte 1 105
byte 1 99
byte 1 116
byte 1 73
byte 1 116
byte 1 101
byte 1 109
byte 1 115
byte 1 0
align 1
LABELV $417
byte 1 108
byte 1 111
byte 1 99
byte 1 97
byte 1 108
byte 1 104
byte 1 111
byte 1 115
byte 1 116
byte 1 0
align 1
LABELV $414
byte 1 105
byte 1 112
byte 1 0
align 1
LABELV $413
byte 1 92
byte 1 110
byte 1 97
byte 1 109
byte 1 101
byte 1 92
byte 1 98
byte 1 97
byte 1 100
byte 1 105
byte 1 110
byte 1 102
byte 1 111
byte 1 0
align 1
LABELV $407
byte 1 42
byte 1 102
byte 1 108
byte 1 97
byte 1 115
byte 1 104
byte 1 0
align 1
LABELV $401
byte 1 99
byte 1 114
byte 1 97
byte 1 110
byte 1 105
byte 1 117
byte 1 109
byte 1 0
align 1
LABELV $399
byte 1 117
byte 1 112
byte 1 112
byte 1 101
byte 1 114
byte 1 95
byte 1 108
byte 1 117
byte 1 109
byte 1 98
byte 1 97
byte 1 114
byte 1 0
align 1
LABELV $397
byte 1 109
byte 1 111
byte 1 100
byte 1 101
byte 1 108
byte 1 95
byte 1 114
byte 1 111
byte 1 111
byte 1 116
byte 1 0
align 1
LABELV $396
byte 1 42
byte 1 108
byte 1 95
byte 1 104
byte 1 97
byte 1 110
byte 1 100
byte 1 0
align 1
LABELV $395
byte 1 42
byte 1 114
byte 1 95
byte 1 104
byte 1 97
byte 1 110
byte 1 100
byte 1 0
align 1
LABELV $390
byte 1 47
byte 1 97
byte 1 110
byte 1 105
byte 1 109
byte 1 97
byte 1 116
byte 1 105
byte 1 111
byte 1 110
byte 1 46
byte 1 99
byte 1 102
byte 1 103
byte 1 0
align 1
LABELV $387
byte 1 70
byte 1 97
byte 1 105
byte 1 108
byte 1 101
byte 1 100
byte 1 32
byte 1 116
byte 1 111
byte 1 32
byte 1 108
byte 1 111
byte 1 97
byte 1 100
byte 1 32
byte 1 97
byte 1 110
byte 1 105
byte 1 109
byte 1 97
byte 1 116
byte 1 105
byte 1 111
byte 1 110
byte 1 32
byte 1 102
byte 1 105
byte 1 108
byte 1 101
byte 1 32
byte 1 37
byte 1 115
byte 1 10
byte 1 0
align 1
LABELV $386
byte 1 109
byte 1 111
byte 1 100
byte 1 101
byte 1 108
byte 1 115
byte 1 47
byte 1 112
byte 1 108
byte 1 97
byte 1 121
byte 1 101
byte 1 114
byte 1 115
byte 1 47
byte 1 95
byte 1 104
byte 1 117
byte 1 109
byte 1 97
byte 1 110
byte 1 111
byte 1 105
byte 1 100
byte 1 47
byte 1 97
byte 1 110
byte 1 105
byte 1 109
byte 1 97
byte 1 116
byte 1 105
byte 1 111
byte 1 110
byte 1 46
byte 1 99
byte 1 102
byte 1 103
byte 1 0
align 1
LABELV $375
byte 1 109
byte 1 111
byte 1 100
byte 1 101
byte 1 108
byte 1 115
byte 1 47
byte 1 112
byte 1 108
byte 1 97
byte 1 121
byte 1 101
byte 1 114
byte 1 115
byte 1 47
byte 1 107
byte 1 121
byte 1 108
byte 1 101
byte 1 47
byte 1 109
byte 1 111
byte 1 100
byte 1 101
byte 1 108
byte 1 46
byte 1 103
byte 1 108
byte 1 109
byte 1 0
align 1
LABELV $368
byte 1 80
byte 1 97
byte 1 100
byte 1 97
byte 1 119
byte 1 97
byte 1 110
byte 1 0
align 1
LABELV $256
byte 1 98
byte 1 111
byte 1 100
byte 1 121
byte 1 113
byte 1 117
byte 1 101
byte 1 0
align 1
LABELV $236
byte 1 67
byte 1 111
byte 1 117
byte 1 108
byte 1 100
byte 1 110
byte 1 39
byte 1 116
byte 1 32
byte 1 102
byte 1 105
byte 1 110
byte 1 100
byte 1 32
byte 1 97
byte 1 32
byte 1 115
byte 1 112
byte 1 97
byte 1 119
byte 1 110
byte 1 32
byte 1 112
byte 1 111
byte 1 105
byte 1 110
byte 1 116
byte 1 0
align 1
LABELV $160
byte 1 66
byte 1 69
byte 1 67
byte 1 79
byte 1 77
byte 1 69
byte 1 74
byte 1 77
byte 1 0
align 1
LABELV $159
byte 1 83
byte 1 86
byte 1 73
byte 1 78
byte 1 71
byte 1 65
byte 1 77
byte 1 69
byte 1 0
align 1
LABELV $158
byte 1 99
byte 1 112
byte 1 32
byte 1 34
byte 1 37
byte 1 115
byte 1 32
byte 1 37
byte 1 115
byte 1 10
byte 1 34
byte 1 0
align 1
LABELV $152
byte 1 37
byte 1 105
byte 1 0
align 1
LABELV $119
byte 1 109
byte 1 111
byte 1 100
byte 1 101
byte 1 108
byte 1 115
byte 1 47
byte 1 119
byte 1 101
byte 1 97
byte 1 112
byte 1 111
byte 1 110
byte 1 115
byte 1 50
byte 1 47
byte 1 115
byte 1 97
byte 1 98
byte 1 101
byte 1 114
byte 1 47
byte 1 115
byte 1 97
byte 1 98
byte 1 101
byte 1 114
byte 1 95
byte 1 119
byte 1 46
byte 1 103
byte 1 108
byte 1 109
byte 1 0
align 1
LABELV $114
byte 1 45
byte 1 49
byte 1 0
align 1
LABELV $98
byte 1 105
byte 1 110
byte 1 102
byte 1 111
byte 1 95
byte 1 112
byte 1 108
byte 1 97
byte 1 121
byte 1 101
byte 1 114
byte 1 95
byte 1 100
byte 1 101
byte 1 97
byte 1 116
byte 1 104
byte 1 109
byte 1 97
byte 1 116
byte 1 99
byte 1 104
byte 1 0
align 1
LABELV $94
byte 1 110
byte 1 111
byte 1 104
byte 1 117
byte 1 109
byte 1 97
byte 1 110
byte 1 115
byte 1 0
align 1
LABELV $91
byte 1 48
byte 1 0
align 1
LABELV $90
byte 1 110
byte 1 111
byte 1 98
byte 1 111
byte 1 116
byte 1 115
byte 1 0
