export P_SetTwitchInfo
code
proc P_SetTwitchInfo 4 0
file "../g_active.c"
line 11
;1:// Copyright (C) 1999-2000 Id Software, Inc.
;2://
;3:
;4:#include "g_local.h"
;5:
;6:qboolean PM_SaberInTransition( int move );
;7:qboolean PM_SaberInStart( int move );
;8:qboolean PM_SaberInReturn( int move );
;9:
;10:void P_SetTwitchInfo(gclient_t	*client)
;11:{
line 12
;12:	client->ps.painTime = level.time;
ADDRFP4 0
INDIRP4
CNSTI4 192
ADDP4
ADDRGP4 level+32
INDIRI4
ASGNI4
line 13
;13:	client->ps.painDirection ^= 1;
ADDRLP4 0
ADDRFP4 0
INDIRP4
CNSTI4 196
ADDP4
ASGNP4
ADDRLP4 0
INDIRP4
ADDRLP4 0
INDIRP4
INDIRI4
CNSTI4 1
BXORI4
ASGNI4
line 14
;14:}
LABELV $89
endproc P_SetTwitchInfo 4 0
export P_DamageFeedback
proc P_DamageFeedback 48 12
line 26
;15:
;16:/*
;17:===============
;18:G_DamageFeedback
;19:
;20:Called just before a snapshot is sent to the given player.
;21:Totals up all damage and generates both the player_state_t
;22:damage values to that client for pain blends and kicks, and
;23:global pain sound events for all clients.
;24:===============
;25:*/
;26:void P_DamageFeedback( gentity_t *player ) {
line 31
;27:	gclient_t	*client;
;28:	float	count;
;29:	vec3_t	angles;
;30:
;31:	client = player->client;
ADDRLP4 0
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
ASGNP4
line 32
;32:	if ( client->ps.pm_type == PM_DEAD ) {
ADDRLP4 20
CNSTI4 4
ASGNI4
ADDRLP4 0
INDIRP4
ADDRLP4 20
INDIRI4
ADDP4
INDIRI4
ADDRLP4 20
INDIRI4
NEI4 $92
line 33
;33:		return;
ADDRGP4 $91
JUMPV
LABELV $92
line 37
;34:	}
;35:
;36:	// total points of damage shot at the player this frame
;37:	count = client->damage_blood + client->damage_armor;
ADDRLP4 4
ADDRLP4 0
INDIRP4
CNSTI4 1628
ADDP4
INDIRI4
ADDRLP4 0
INDIRP4
CNSTI4 1624
ADDP4
INDIRI4
ADDI4
CVIF4 4
ASGNF4
line 38
;38:	if ( count == 0 ) {
ADDRLP4 4
INDIRF4
CNSTF4 0
NEF4 $94
line 39
;39:		return;		// didn't take any damage
ADDRGP4 $91
JUMPV
LABELV $94
line 42
;40:	}
;41:
;42:	if ( count > 255 ) {
ADDRLP4 4
INDIRF4
CNSTF4 1132396544
LEF4 $96
line 43
;43:		count = 255;
ADDRLP4 4
CNSTF4 1132396544
ASGNF4
line 44
;44:	}
LABELV $96
line 50
;45:
;46:	// send the information to the client
;47:
;48:	// world damage (falling, slime, etc) uses a special code
;49:	// to make the blend blob centered instead of positional
;50:	if ( client->damage_fromWorld ) {
ADDRLP4 0
INDIRP4
CNSTI4 1648
ADDP4
INDIRI4
CNSTI4 0
EQI4 $98
line 51
;51:		client->ps.damagePitch = 255;
ADDRLP4 0
INDIRP4
CNSTI4 180
ADDP4
CNSTI4 255
ASGNI4
line 52
;52:		client->ps.damageYaw = 255;
ADDRLP4 0
INDIRP4
CNSTI4 176
ADDP4
CNSTI4 255
ASGNI4
line 54
;53:
;54:		client->damage_fromWorld = qfalse;
ADDRLP4 0
INDIRP4
CNSTI4 1648
ADDP4
CNSTI4 0
ASGNI4
line 55
;55:	} else {
ADDRGP4 $99
JUMPV
LABELV $98
line 56
;56:		vectoangles( client->damage_from, angles );
ADDRLP4 0
INDIRP4
CNSTI4 1636
ADDP4
ARGP4
ADDRLP4 8
ARGP4
ADDRGP4 vectoangles
CALLV
pop
line 57
;57:		client->ps.damagePitch = angles[PITCH]/360.0 * 256;
ADDRLP4 0
INDIRP4
CNSTI4 180
ADDP4
CNSTF4 1132462080
ADDRLP4 8
INDIRF4
CNSTF4 1135869952
DIVF4
MULF4
CVFI4 4
ASGNI4
line 58
;58:		client->ps.damageYaw = angles[YAW]/360.0 * 256;
ADDRLP4 0
INDIRP4
CNSTI4 176
ADDP4
CNSTF4 1132462080
ADDRLP4 8+4
INDIRF4
CNSTF4 1135869952
DIVF4
MULF4
CVFI4 4
ASGNI4
line 59
;59:	}
LABELV $99
line 62
;60:
;61:	// play an apropriate pain sound
;62:	if ( (level.time > player->pain_debounce_time) && !(player->flags & FL_GODMODE) ) {
ADDRLP4 28
ADDRFP4 0
INDIRP4
ASGNP4
ADDRGP4 level+32
INDIRI4
ADDRLP4 28
INDIRP4
CNSTI4 664
ADDP4
INDIRI4
LEI4 $101
ADDRLP4 28
INDIRP4
CNSTI4 472
ADDP4
INDIRI4
CNSTI4 16
BANDI4
CNSTI4 0
NEI4 $101
line 65
;63:
;64:		// don't do more than two pain sounds a second
;65:		if ( level.time - client->ps.painTime < 500 ) {
ADDRGP4 level+32
INDIRI4
ADDRLP4 0
INDIRP4
CNSTI4 192
ADDP4
INDIRI4
SUBI4
CNSTI4 500
GEI4 $104
line 66
;66:			return;
ADDRGP4 $91
JUMPV
LABELV $104
line 68
;67:		}
;68:		P_SetTwitchInfo(client);
ADDRLP4 0
INDIRP4
ARGP4
ADDRGP4 P_SetTwitchInfo
CALLV
pop
line 69
;69:		player->pain_debounce_time = level.time + 700;
ADDRFP4 0
INDIRP4
CNSTI4 664
ADDP4
ADDRGP4 level+32
INDIRI4
CNSTI4 700
ADDI4
ASGNI4
line 70
;70:		G_AddEvent( player, EV_PAIN, player->health );
ADDRLP4 32
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 32
INDIRP4
ARGP4
CNSTI4 77
ARGI4
ADDRLP4 32
INDIRP4
CNSTI4 676
ADDP4
INDIRI4
ARGI4
ADDRGP4 G_AddEvent
CALLV
pop
line 71
;71:		client->ps.damageEvent++;
ADDRLP4 36
ADDRLP4 0
INDIRP4
CNSTI4 172
ADDP4
ASGNP4
ADDRLP4 36
INDIRP4
ADDRLP4 36
INDIRP4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 73
;72:
;73:		if (client->damage_armor && !client->damage_blood)
ADDRLP4 44
CNSTI4 0
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 1624
ADDP4
INDIRI4
ADDRLP4 44
INDIRI4
EQI4 $108
ADDRLP4 0
INDIRP4
CNSTI4 1628
ADDP4
INDIRI4
ADDRLP4 44
INDIRI4
NEI4 $108
line 74
;74:		{
line 75
;75:			client->ps.damageType = 1; //pure shields
ADDRLP4 0
INDIRP4
CNSTI4 188
ADDP4
CNSTI4 1
ASGNI4
line 76
;76:		}
ADDRGP4 $109
JUMPV
LABELV $108
line 77
;77:		else if (client->damage_armor)
ADDRLP4 0
INDIRP4
CNSTI4 1624
ADDP4
INDIRI4
CNSTI4 0
EQI4 $110
line 78
;78:		{
line 79
;79:			client->ps.damageType = 2; //shields and health
ADDRLP4 0
INDIRP4
CNSTI4 188
ADDP4
CNSTI4 2
ASGNI4
line 80
;80:		}
ADDRGP4 $111
JUMPV
LABELV $110
line 82
;81:		else
;82:		{
line 83
;83:			client->ps.damageType = 0; //pure health
ADDRLP4 0
INDIRP4
CNSTI4 188
ADDP4
CNSTI4 0
ASGNI4
line 84
;84:		}
LABELV $111
LABELV $109
line 85
;85:	}
LABELV $101
line 88
;86:
;87:
;88:	client->ps.damageCount = count;
ADDRLP4 0
INDIRP4
CNSTI4 184
ADDP4
ADDRLP4 4
INDIRF4
CVFI4 4
ASGNI4
line 93
;89:
;90:	//
;91:	// clear totals
;92:	//
;93:	client->damage_blood = 0;
ADDRLP4 0
INDIRP4
CNSTI4 1628
ADDP4
CNSTI4 0
ASGNI4
line 94
;94:	client->damage_armor = 0;
ADDRLP4 0
INDIRP4
CNSTI4 1624
ADDP4
CNSTI4 0
ASGNI4
line 95
;95:	client->damage_knockback = 0;
ADDRLP4 0
INDIRP4
CNSTI4 1632
ADDP4
CNSTI4 0
ASGNI4
line 96
;96:}
LABELV $91
endproc P_DamageFeedback 48 12
export P_WorldEffects
proc P_WorldEffects 40 32
line 107
;97:
;98:
;99:
;100:/*
;101:=============
;102:P_WorldEffects
;103:
;104:Check for lava / slime contents and drowning
;105:=============
;106:*/
;107:void P_WorldEffects( gentity_t *ent ) {
line 111
;108:	qboolean	envirosuit;
;109:	int			waterlevel;
;110:
;111:	if ( ent->client->noclip ) {
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 1592
ADDP4
INDIRI4
CNSTI4 0
EQI4 $113
line 112
;112:		ent->client->airOutTime = level.time + 12000;	// don't need air
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 1704
ADDP4
ADDRGP4 level+32
INDIRI4
CNSTI4 12000
ADDI4
ASGNI4
line 113
;113:		return;
ADDRGP4 $112
JUMPV
LABELV $113
line 116
;114:	}
;115:
;116:	waterlevel = ent->waterlevel;
ADDRLP4 0
ADDRFP4 0
INDIRP4
CNSTI4 748
ADDP4
INDIRI4
ASGNI4
line 118
;117:
;118:	envirosuit = ent->client->ps.powerups[PW_BATTLESUIT] > level.time;
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 352
ADDP4
INDIRI4
ADDRGP4 level+32
INDIRI4
LEI4 $118
ADDRLP4 8
CNSTI4 1
ASGNI4
ADDRGP4 $119
JUMPV
LABELV $118
ADDRLP4 8
CNSTI4 0
ASGNI4
LABELV $119
ADDRLP4 4
ADDRLP4 8
INDIRI4
ASGNI4
line 123
;119:
;120:	//
;121:	// check for drowning
;122:	//
;123:	if ( waterlevel == 3 ) {
ADDRLP4 0
INDIRI4
CNSTI4 3
NEI4 $120
line 125
;124:		// envirosuit give air
;125:		if ( envirosuit ) {
ADDRLP4 4
INDIRI4
CNSTI4 0
EQI4 $122
line 126
;126:			ent->client->airOutTime = level.time + 10000;
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 1704
ADDP4
ADDRGP4 level+32
INDIRI4
CNSTI4 10000
ADDI4
ASGNI4
line 127
;127:		}
LABELV $122
line 130
;128:
;129:		// if out of air, start drowning
;130:		if ( ent->client->airOutTime < level.time) {
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 1704
ADDP4
INDIRI4
ADDRGP4 level+32
INDIRI4
GEI4 $121
line 132
;131:			// drown!
;132:			ent->client->airOutTime += 1000;
ADDRLP4 12
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 1704
ADDP4
ASGNP4
ADDRLP4 12
INDIRP4
ADDRLP4 12
INDIRP4
INDIRI4
CNSTI4 1000
ADDI4
ASGNI4
line 133
;133:			if ( ent->health > 0 ) {
ADDRFP4 0
INDIRP4
CNSTI4 676
ADDP4
INDIRI4
CNSTI4 0
LEI4 $121
line 135
;134:				// take more damage the longer underwater
;135:				ent->damage += 2;
ADDRLP4 16
ADDRFP4 0
INDIRP4
CNSTI4 688
ADDP4
ASGNP4
ADDRLP4 16
INDIRP4
ADDRLP4 16
INDIRP4
INDIRI4
CNSTI4 2
ADDI4
ASGNI4
line 136
;136:				if (ent->damage > 15)
ADDRFP4 0
INDIRP4
CNSTI4 688
ADDP4
INDIRI4
CNSTI4 15
LEI4 $130
line 137
;137:					ent->damage = 15;
ADDRFP4 0
INDIRP4
CNSTI4 688
ADDP4
CNSTI4 15
ASGNI4
LABELV $130
line 140
;138:
;139:				// play a gurp sound instead of a normal pain sound
;140:				if (ent->health <= ent->damage) {
ADDRLP4 20
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 20
INDIRP4
CNSTI4 676
ADDP4
INDIRI4
ADDRLP4 20
INDIRP4
CNSTI4 688
ADDP4
INDIRI4
GTI4 $132
line 141
;141:					G_Sound(ent, CHAN_VOICE, G_SoundIndex(/*"*drown.wav"*/"sound/player/gurp1.wav"));
ADDRGP4 $134
ARGP4
ADDRLP4 24
ADDRGP4 G_SoundIndex
CALLI4
ASGNI4
ADDRFP4 0
INDIRP4
ARGP4
CNSTI4 3
ARGI4
ADDRLP4 24
INDIRI4
ARGI4
ADDRGP4 G_Sound
CALLV
pop
line 142
;142:				} else if (rand()&1) {
ADDRGP4 $133
JUMPV
LABELV $132
ADDRLP4 24
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 24
INDIRI4
CNSTI4 1
BANDI4
CNSTI4 0
EQI4 $135
line 143
;143:					G_Sound(ent, CHAN_VOICE, G_SoundIndex("sound/player/gurp1.wav"));
ADDRGP4 $134
ARGP4
ADDRLP4 28
ADDRGP4 G_SoundIndex
CALLI4
ASGNI4
ADDRFP4 0
INDIRP4
ARGP4
CNSTI4 3
ARGI4
ADDRLP4 28
INDIRI4
ARGI4
ADDRGP4 G_Sound
CALLV
pop
line 144
;144:				} else {
ADDRGP4 $136
JUMPV
LABELV $135
line 145
;145:					G_Sound(ent, CHAN_VOICE, G_SoundIndex("sound/player/gurp2.wav"));
ADDRGP4 $137
ARGP4
ADDRLP4 28
ADDRGP4 G_SoundIndex
CALLI4
ASGNI4
ADDRFP4 0
INDIRP4
ARGP4
CNSTI4 3
ARGI4
ADDRLP4 28
INDIRI4
ARGI4
ADDRGP4 G_Sound
CALLV
pop
line 146
;146:				}
LABELV $136
LABELV $133
line 149
;147:
;148:				// don't play a normal pain sound
;149:				ent->pain_debounce_time = level.time + 200;
ADDRFP4 0
INDIRP4
CNSTI4 664
ADDP4
ADDRGP4 level+32
INDIRI4
CNSTI4 200
ADDI4
ASGNI4
line 151
;150:
;151:				G_Damage (ent, NULL, NULL, NULL, NULL, 
ADDRLP4 28
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 28
INDIRP4
ARGP4
ADDRLP4 32
CNSTP4 0
ASGNP4
ADDRLP4 32
INDIRP4
ARGP4
ADDRLP4 32
INDIRP4
ARGP4
ADDRLP4 36
CNSTP4 0
ASGNP4
ADDRLP4 36
INDIRP4
ARGP4
ADDRLP4 36
INDIRP4
ARGP4
ADDRLP4 28
INDIRP4
CNSTI4 688
ADDP4
INDIRI4
ARGI4
CNSTI4 2
ARGI4
CNSTI4 29
ARGI4
ADDRGP4 G_Damage
CALLV
pop
line 153
;152:					ent->damage, DAMAGE_NO_ARMOR, MOD_WATER);
;153:			}
line 154
;154:		}
line 155
;155:	} else {
ADDRGP4 $121
JUMPV
LABELV $120
line 156
;156:		ent->client->airOutTime = level.time + 12000;
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 1704
ADDP4
ADDRGP4 level+32
INDIRI4
CNSTI4 12000
ADDI4
ASGNI4
line 157
;157:		ent->damage = 2;
ADDRFP4 0
INDIRP4
CNSTI4 688
ADDP4
CNSTI4 2
ASGNI4
line 158
;158:	}
LABELV $121
line 163
;159:
;160:	//
;161:	// check for sizzle damage (move to pmove?)
;162:	//
;163:	if (waterlevel && 
ADDRLP4 12
CNSTI4 0
ASGNI4
ADDRLP4 0
INDIRI4
ADDRLP4 12
INDIRI4
EQI4 $140
ADDRFP4 0
INDIRP4
CNSTI4 744
ADDP4
INDIRI4
CNSTI4 131074
BANDI4
ADDRLP4 12
INDIRI4
EQI4 $140
line 164
;164:		(ent->watertype&(CONTENTS_LAVA|CONTENTS_SLIME)) ) {
line 165
;165:		if (ent->health > 0
ADDRLP4 16
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 16
INDIRP4
CNSTI4 676
ADDP4
INDIRI4
CNSTI4 0
LEI4 $142
ADDRLP4 16
INDIRP4
CNSTI4 664
ADDP4
INDIRI4
ADDRGP4 level+32
INDIRI4
GTI4 $142
line 166
;166:			&& ent->pain_debounce_time <= level.time	) {
line 168
;167:
;168:			if ( envirosuit ) {
ADDRLP4 4
INDIRI4
CNSTI4 0
EQI4 $145
line 169
;169:				G_AddEvent( ent, EV_POWERUP_BATTLESUIT, 0 );
ADDRFP4 0
INDIRP4
ARGP4
CNSTI4 83
ARGI4
CNSTI4 0
ARGI4
ADDRGP4 G_AddEvent
CALLV
pop
line 170
;170:			} else {
ADDRGP4 $146
JUMPV
LABELV $145
line 171
;171:				if (ent->watertype & CONTENTS_LAVA) {
ADDRFP4 0
INDIRP4
CNSTI4 744
ADDP4
INDIRI4
CNSTI4 2
BANDI4
CNSTI4 0
EQI4 $147
line 172
;172:					G_Damage (ent, NULL, NULL, NULL, NULL, 
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 20
CNSTP4 0
ASGNP4
ADDRLP4 20
INDIRP4
ARGP4
ADDRLP4 20
INDIRP4
ARGP4
ADDRLP4 24
CNSTP4 0
ASGNP4
ADDRLP4 24
INDIRP4
ARGP4
ADDRLP4 24
INDIRP4
ARGP4
CNSTI4 30
ADDRLP4 0
INDIRI4
MULI4
ARGI4
CNSTI4 0
ARGI4
CNSTI4 31
ARGI4
ADDRGP4 G_Damage
CALLV
pop
line 174
;173:						30*waterlevel, 0, MOD_LAVA);
;174:				}
LABELV $147
line 176
;175:
;176:				if (ent->watertype & CONTENTS_SLIME) {
ADDRFP4 0
INDIRP4
CNSTI4 744
ADDP4
INDIRI4
CNSTI4 131072
BANDI4
CNSTI4 0
EQI4 $149
line 177
;177:					G_Damage (ent, NULL, NULL, NULL, NULL, 
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 20
CNSTP4 0
ASGNP4
ADDRLP4 20
INDIRP4
ARGP4
ADDRLP4 20
INDIRP4
ARGP4
ADDRLP4 24
CNSTP4 0
ASGNP4
ADDRLP4 24
INDIRP4
ARGP4
ADDRLP4 24
INDIRP4
ARGP4
CNSTI4 10
ADDRLP4 0
INDIRI4
MULI4
ARGI4
CNSTI4 0
ARGI4
CNSTI4 30
ARGI4
ADDRGP4 G_Damage
CALLV
pop
line 179
;178:						10*waterlevel, 0, MOD_SLIME);
;179:				}
LABELV $149
line 180
;180:			}
LABELV $146
line 181
;181:		}
LABELV $142
line 182
;182:	}
LABELV $140
line 183
;183:}
LABELV $112
endproc P_WorldEffects 40 32
export DoImpact
proc DoImpact 96 32
line 192
;184:
;185:
;186:
;187:
;188:
;189://==============================================================
;190:extern void G_ApplyKnockback( gentity_t *targ, vec3_t newDir, float knockback );
;191:void DoImpact( gentity_t *self, gentity_t *other, qboolean damageSelf )
;192:{
line 197
;193:	float magnitude, my_mass;
;194:	vec3_t	velocity;
;195:	int cont;
;196:
;197:	if( self->client )
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $152
line 198
;198:	{
line 199
;199:		VectorCopy( self->client->ps.velocity, velocity );
ADDRLP4 4
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 32
ADDP4
INDIRB
ASGNB 12
line 200
;200:		my_mass = self->mass;
ADDRLP4 16
ADDRFP4 0
INDIRP4
CNSTI4 624
ADDP4
INDIRF4
ASGNF4
line 201
;201:	}
ADDRGP4 $153
JUMPV
LABELV $152
line 203
;202:	else 
;203:	{
line 204
;204:		VectorCopy( self->s.pos.trDelta, velocity );
ADDRLP4 4
ADDRFP4 0
INDIRP4
CNSTI4 36
ADDP4
INDIRB
ASGNB 12
line 205
;205:		if ( self->s.pos.trType == TR_GRAVITY )
ADDRFP4 0
INDIRP4
CNSTI4 12
ADDP4
INDIRI4
CNSTI4 5
NEI4 $154
line 206
;206:		{
line 207
;207:			velocity[2] -= 0.25f * g_gravity.value;
ADDRLP4 4+8
ADDRLP4 4+8
INDIRF4
CNSTF4 1048576000
ADDRGP4 g_gravity+8
INDIRF4
MULF4
SUBF4
ASGNF4
line 208
;208:		}
LABELV $154
line 209
;209:		if( !self->mass )
ADDRFP4 0
INDIRP4
CNSTI4 624
ADDP4
INDIRF4
CNSTF4 0
NEF4 $158
line 210
;210:		{
line 211
;211:			my_mass = 1;
ADDRLP4 16
CNSTF4 1065353216
ASGNF4
line 212
;212:		}
ADDRGP4 $159
JUMPV
LABELV $158
line 213
;213:		else if ( self->mass <= 10 )
ADDRFP4 0
INDIRP4
CNSTI4 624
ADDP4
INDIRF4
CNSTF4 1092616192
GTF4 $160
line 214
;214:		{
line 215
;215:			my_mass = 10;
ADDRLP4 16
CNSTF4 1092616192
ASGNF4
line 216
;216:		}
ADDRGP4 $161
JUMPV
LABELV $160
line 218
;217:		else
;218:		{
line 219
;219:			my_mass = self->mass;///10;
ADDRLP4 16
ADDRFP4 0
INDIRP4
CNSTI4 624
ADDP4
INDIRF4
ASGNF4
line 220
;220:		}
LABELV $161
LABELV $159
line 221
;221:	}
LABELV $153
line 223
;222:
;223:	magnitude = VectorLength( velocity ) * my_mass / 10;
ADDRLP4 4
ARGP4
ADDRLP4 24
ADDRGP4 VectorLength
CALLF4
ASGNF4
ADDRLP4 0
ADDRLP4 24
INDIRF4
ADDRLP4 16
INDIRF4
MULF4
CNSTF4 1092616192
DIVF4
ASGNF4
line 236
;224:
;225:	/*
;226:	if(pointcontents(self.absmax)==CONTENT_WATER)//FIXME: or other watertypes
;227:		magnitude/=3;							//water absorbs 2/3 velocity
;228:
;229:	if(self.classname=="barrel"&&self.aflag)//rolling barrels are made for impacts!
;230:		magnitude*=3;
;231:
;232:	if(self.frozen>0&&magnitude<300&&self.flags&FL_ONGROUND&&loser==world&&self.velocity_z<-20&&self.last_onground+0.3<time)
;233:		magnitude=300;
;234:	*/
;235:
;236:	if ( !self->client || self->client->ps.lastOnGround+300<level.time || ( self->client->ps.lastOnGround+100 < level.time && other->material >= MAT_GLASS ) )
ADDRLP4 28
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
ASGNP4
ADDRLP4 28
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $167
ADDRLP4 32
ADDRLP4 28
INDIRP4
CNSTI4 500
ADDP4
INDIRI4
ASGNI4
ADDRLP4 32
INDIRI4
CNSTI4 300
ADDI4
ADDRGP4 level+32
INDIRI4
LTI4 $167
ADDRLP4 32
INDIRI4
CNSTI4 100
ADDI4
ADDRGP4 level+32
INDIRI4
GEI4 $162
ADDRFP4 4
INDIRP4
CNSTI4 684
ADDP4
INDIRI4
CNSTI4 1
LTI4 $162
LABELV $167
line 237
;237:	{
line 239
;238:		vec3_t dir1, dir2;
;239:		float force = 0, dot;
ADDRLP4 36
CNSTF4 0
ASGNF4
line 241
;240:
;241:		if ( other->material >= MAT_GLASS )
ADDRFP4 4
INDIRP4
CNSTI4 684
ADDP4
INDIRI4
CNSTI4 1
LTI4 $168
line 242
;242:			magnitude *= 2;
ADDRLP4 0
CNSTF4 1073741824
ADDRLP4 0
INDIRF4
MULF4
ASGNF4
LABELV $168
line 245
;243:
;244:		//damage them
;245:		if ( magnitude >= 100 && other->s.number < ENTITYNUM_WORLD )
ADDRLP4 0
INDIRF4
CNSTF4 1120403456
LTF4 $170
ADDRFP4 4
INDIRP4
INDIRI4
CNSTI4 1022
GEI4 $170
line 246
;246:		{
line 247
;247:			VectorCopy( velocity, dir1 );
ADDRLP4 52
ADDRLP4 4
INDIRB
ASGNB 12
line 248
;248:			VectorNormalize( dir1 );
ADDRLP4 52
ARGP4
ADDRGP4 VectorNormalize
CALLF4
pop
line 249
;249:			if( VectorCompare( other->r.currentOrigin, vec3_origin ) )
ADDRFP4 4
INDIRP4
CNSTI4 368
ADDP4
ARGP4
ADDRGP4 vec3_origin
ARGP4
ADDRLP4 68
ADDRGP4 VectorCompare
CALLI4
ASGNI4
ADDRLP4 68
INDIRI4
CNSTI4 0
EQI4 $172
line 250
;250:			{//a brush with no origin
line 251
;251:				VectorCopy ( dir1, dir2 );
ADDRLP4 40
ADDRLP4 52
INDIRB
ASGNB 12
line 252
;252:			}
ADDRGP4 $173
JUMPV
LABELV $172
line 254
;253:			else
;254:			{
line 255
;255:				VectorSubtract( other->r.currentOrigin, self->r.currentOrigin, dir2 );
ADDRLP4 72
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 76
CNSTI4 368
ASGNI4
ADDRLP4 80
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 40
ADDRLP4 72
INDIRP4
ADDRLP4 76
INDIRI4
ADDP4
INDIRF4
ADDRLP4 80
INDIRP4
ADDRLP4 76
INDIRI4
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 84
CNSTI4 372
ASGNI4
ADDRLP4 40+4
ADDRLP4 72
INDIRP4
ADDRLP4 84
INDIRI4
ADDP4
INDIRF4
ADDRLP4 80
INDIRP4
ADDRLP4 84
INDIRI4
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 88
CNSTI4 376
ASGNI4
ADDRLP4 40+8
ADDRFP4 4
INDIRP4
ADDRLP4 88
INDIRI4
ADDP4
INDIRF4
ADDRFP4 0
INDIRP4
ADDRLP4 88
INDIRI4
ADDP4
INDIRF4
SUBF4
ASGNF4
line 256
;256:				VectorNormalize( dir2 );
ADDRLP4 40
ARGP4
ADDRGP4 VectorNormalize
CALLF4
pop
line 257
;257:			}
LABELV $173
line 259
;258:
;259:			dot = DotProduct( dir1, dir2 );
ADDRLP4 64
ADDRLP4 52
INDIRF4
ADDRLP4 40
INDIRF4
MULF4
ADDRLP4 52+4
INDIRF4
ADDRLP4 40+4
INDIRF4
MULF4
ADDF4
ADDRLP4 52+8
INDIRF4
ADDRLP4 40+8
INDIRF4
MULF4
ADDF4
ASGNF4
line 261
;260:
;261:			if ( dot >= 0.2 )
ADDRLP4 64
INDIRF4
CNSTF4 1045220557
LTF4 $180
line 262
;262:			{
line 263
;263:				force = dot;
ADDRLP4 36
ADDRLP4 64
INDIRF4
ASGNF4
line 264
;264:			}
ADDRGP4 $181
JUMPV
LABELV $180
line 266
;265:			else
;266:			{
line 267
;267:				force = 0;
ADDRLP4 36
CNSTF4 0
ASGNF4
line 268
;268:			}
LABELV $181
line 270
;269:
;270:			force *= (magnitude/50);
ADDRLP4 36
ADDRLP4 36
INDIRF4
ADDRLP4 0
INDIRF4
CNSTF4 1112014848
DIVF4
MULF4
ASGNF4
line 272
;271:
;272:			cont = trap_PointContents( other->r.absmax, other->s.number );
ADDRLP4 72
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 72
INDIRP4
CNSTI4 356
ADDP4
ARGP4
ADDRLP4 72
INDIRP4
INDIRI4
ARGI4
ADDRLP4 76
ADDRGP4 trap_PointContents
CALLI4
ASGNI4
ADDRLP4 20
ADDRLP4 76
INDIRI4
ASGNI4
line 273
;273:			if( (cont&CONTENTS_WATER) )//|| (self.classname=="barrel"&&self.aflag))//FIXME: or other watertypes
ADDRLP4 20
INDIRI4
CNSTI4 4
BANDI4
CNSTI4 0
EQI4 $182
line 274
;274:			{
line 275
;275:				force /= 3;							//water absorbs 2/3 velocity
ADDRLP4 36
ADDRLP4 36
INDIRF4
CNSTF4 1077936128
DIVF4
ASGNF4
line 276
;276:			}
LABELV $182
line 283
;277:
;278:			/*
;279:			if(self.frozen>0&&force>10)
;280:				force=10;
;281:			*/
;282:
;283:			if( ( force >= 1 && other->s.number != 0 ) || force >= 10)
ADDRLP4 36
INDIRF4
CNSTF4 1065353216
LTF4 $187
ADDRFP4 4
INDIRP4
INDIRI4
CNSTI4 0
NEI4 $186
LABELV $187
ADDRLP4 36
INDIRF4
CNSTF4 1092616192
LTF4 $184
LABELV $186
line 284
;284:			{
line 292
;285:	/*			
;286:				dprint("Damage other (");
;287:				dprint(loser.classname);
;288:				dprint("): ");
;289:				dprint(ftos(force));
;290:				dprint("\n");
;291:	*/
;292:				if ( other->r.svFlags & SVF_GLASS_BRUSH )
ADDRFP4 4
INDIRP4
CNSTI4 304
ADDP4
INDIRI4
CNSTI4 134217728
BANDI4
CNSTI4 0
EQI4 $188
line 293
;293:				{
line 294
;294:					other->splashRadius = (float)(self->r.maxs[0] - self->r.mins[0])/4.0f;
ADDRLP4 80
ADDRFP4 0
INDIRP4
ASGNP4
ADDRFP4 4
INDIRP4
CNSTI4 700
ADDP4
ADDRLP4 80
INDIRP4
CNSTI4 328
ADDP4
INDIRF4
ADDRLP4 80
INDIRP4
CNSTI4 316
ADDP4
INDIRF4
SUBF4
CNSTF4 1082130432
DIVF4
CVFI4 4
ASGNI4
line 295
;295:				}
LABELV $188
line 296
;296:				if ( other->takedamage )
ADDRFP4 4
INDIRP4
CNSTI4 680
ADDP4
INDIRI4
CNSTI4 0
EQI4 $190
line 297
;297:				{
line 298
;298:					G_Damage( other, self, self, velocity, self->r.currentOrigin, force, DAMAGE_NO_ARMOR, MOD_CRUSH);//FIXME: MOD_IMPACT
ADDRFP4 4
INDIRP4
ARGP4
ADDRLP4 80
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 80
INDIRP4
ARGP4
ADDRLP4 80
INDIRP4
ARGP4
ADDRLP4 4
ARGP4
ADDRLP4 80
INDIRP4
CNSTI4 368
ADDP4
ARGP4
ADDRLP4 36
INDIRF4
CVFI4 4
ARGI4
CNSTI4 2
ARGI4
CNSTI4 32
ARGI4
ADDRGP4 G_Damage
CALLV
pop
line 299
;299:				}
ADDRGP4 $191
JUMPV
LABELV $190
line 301
;300:				else
;301:				{
line 302
;302:					G_ApplyKnockback( other, dir2, force );
ADDRFP4 4
INDIRP4
ARGP4
ADDRLP4 40
ARGP4
ADDRLP4 36
INDIRF4
ARGF4
ADDRGP4 G_ApplyKnockback
CALLV
pop
line 303
;303:				}
LABELV $191
line 304
;304:			}
LABELV $184
line 305
;305:		}
LABELV $170
line 307
;306:
;307:		if ( damageSelf && self->takedamage )
ADDRLP4 68
CNSTI4 0
ASGNI4
ADDRFP4 8
INDIRI4
ADDRLP4 68
INDIRI4
EQI4 $192
ADDRFP4 0
INDIRP4
CNSTI4 680
ADDP4
INDIRI4
ADDRLP4 68
INDIRI4
EQI4 $192
line 308
;308:		{
line 311
;309:			//Now damage me
;310:			//FIXME: more lenient falling damage, especially for when driving a vehicle
;311:			if ( self->client && self->client->ps.fd.forceJumpZStart )
ADDRLP4 72
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
ASGNP4
ADDRLP4 72
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $194
ADDRLP4 72
INDIRP4
CNSTI4 1092
ADDP4
INDIRF4
CNSTF4 0
EQF4 $194
line 312
;312:			{//we were force-jumping
line 313
;313:				if ( self->r.currentOrigin[2] >= self->client->ps.fd.forceJumpZStart )
ADDRLP4 76
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 76
INDIRP4
CNSTI4 376
ADDP4
INDIRF4
ADDRLP4 76
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 1092
ADDP4
INDIRF4
LTF4 $196
line 314
;314:				{//we landed at same height or higher than we landed
line 315
;315:					magnitude = 0;
ADDRLP4 0
CNSTF4 0
ASGNF4
line 316
;316:				}
ADDRGP4 $197
JUMPV
LABELV $196
line 318
;317:				else
;318:				{//FIXME: take off some of it, at least?
line 319
;319:					magnitude = (self->client->ps.fd.forceJumpZStart-self->r.currentOrigin[2])/3;
ADDRLP4 80
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 0
ADDRLP4 80
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 1092
ADDP4
INDIRF4
ADDRLP4 80
INDIRP4
CNSTI4 376
ADDP4
INDIRF4
SUBF4
CNSTF4 1077936128
DIVF4
ASGNF4
line 320
;320:				}
LABELV $197
line 321
;321:			}
LABELV $194
line 323
;322:			//if(self.classname!="monster_mezzoman"&&self.netname!="spider")//Cats always land on their feet
;323:				if( ( magnitude >= 100 + self->health && self->s.number != 0 && self->s.weapon != WP_SABER ) || ( magnitude >= 700 ) )//&& self.safe_time < level.time ))//health here is used to simulate structural integrity
ADDRLP4 76
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 0
INDIRF4
ADDRLP4 76
INDIRP4
CNSTI4 676
ADDP4
INDIRI4
CNSTI4 100
ADDI4
CVIF4 4
LTF4 $202
ADDRLP4 76
INDIRP4
INDIRI4
CNSTI4 0
EQI4 $202
ADDRLP4 76
INDIRP4
CNSTI4 276
ADDP4
INDIRI4
CNSTI4 2
NEI4 $200
LABELV $202
ADDRLP4 0
INDIRF4
CNSTF4 1143930880
LTF4 $198
LABELV $200
line 324
;324:				{
line 325
;325:					if ( (self->s.weapon == WP_SABER || self->s.number == 0) && self->client && self->client->ps.groundEntityNum < ENTITYNUM_NONE && magnitude < 1000 )
ADDRLP4 80
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 80
INDIRP4
CNSTI4 276
ADDP4
INDIRI4
CNSTI4 2
EQI4 $205
ADDRLP4 80
INDIRP4
INDIRI4
CNSTI4 0
NEI4 $203
LABELV $205
ADDRLP4 84
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
ASGNP4
ADDRLP4 84
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $203
ADDRLP4 84
INDIRP4
CNSTI4 84
ADDP4
INDIRI4
CNSTI4 1023
GEI4 $203
ADDRLP4 0
INDIRF4
CNSTF4 1148846080
GEF4 $203
line 326
;326:					{//players and jedi take less impact damage
line 328
;327:						//allow for some lenience on high falls
;328:						magnitude /= 2;
ADDRLP4 0
ADDRLP4 0
INDIRF4
CNSTF4 1073741824
DIVF4
ASGNF4
line 335
;329:						/*
;330:						if ( self.absorb_time >= time )//crouching on impact absorbs 1/2 the damage
;331:						{
;332:							magnitude/=2;
;333:						}
;334:						*/
;335:					}
LABELV $203
line 336
;336:					magnitude /= 40;
ADDRLP4 0
ADDRLP4 0
INDIRF4
CNSTF4 1109393408
DIVF4
ASGNF4
line 337
;337:					magnitude = magnitude - force/2;//If damage other, subtract half of that damage off of own injury
ADDRLP4 0
ADDRLP4 0
INDIRF4
ADDRLP4 36
INDIRF4
CNSTF4 1073741824
DIVF4
SUBF4
ASGNF4
line 338
;338:					if ( magnitude >= 1 )
ADDRLP4 0
INDIRF4
CNSTF4 1065353216
LTF4 $206
line 339
;339:					{
line 352
;340:		//FIXME: Put in a thingtype impact sound function
;341:		/*					
;342:						dprint("Damage self (");
;343:						dprint(self.classname);
;344:						dprint("): ");
;345:						dprint(ftos(magnitude));
;346:						dprint("\n");
;347:		*/
;348:						/*
;349:						if ( self.classname=="player_sheep "&& self.flags&FL_ONGROUND && self.velocity_z > -50 )
;350:							return;
;351:						*/
;352:						G_Damage( self, NULL, NULL, NULL, self->r.currentOrigin, magnitude/2, DAMAGE_NO_ARMOR, MOD_FALLING );//FIXME: MOD_IMPACT
ADDRLP4 88
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 88
INDIRP4
ARGP4
ADDRLP4 92
CNSTP4 0
ASGNP4
ADDRLP4 92
INDIRP4
ARGP4
ADDRLP4 92
INDIRP4
ARGP4
CNSTP4 0
ARGP4
ADDRLP4 88
INDIRP4
CNSTI4 368
ADDP4
ARGP4
ADDRLP4 0
INDIRF4
CNSTF4 1073741824
DIVF4
CVFI4 4
ARGI4
CNSTI4 2
ARGI4
CNSTI4 34
ARGI4
ADDRGP4 G_Damage
CALLV
pop
line 353
;353:					}
LABELV $206
line 354
;354:				}
LABELV $198
line 355
;355:		}
LABELV $192
line 366
;356:
;357:		//FIXME: slow my velocity some?
;358:
;359:		// NOTENOTE We don't use lastimpact as of yet
;360://		self->lastImpact = level.time;
;361:
;362:		/*
;363:		if(self.flags&FL_ONGROUND)
;364:			self.last_onground=time;
;365:		*/
;366:	}
LABELV $162
line 367
;367:}
LABELV $151
endproc DoImpact 96 32
export G_SetClientSound
proc G_SetClientSound 8 0
line 374
;368:
;369:/*
;370:===============
;371:G_SetClientSound
;372:===============
;373:*/
;374:void G_SetClientSound( gentity_t *ent ) {
line 375
;375:	if (ent->waterlevel && (ent->watertype&(CONTENTS_LAVA|CONTENTS_SLIME)) ) {
ADDRLP4 0
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 4
CNSTI4 0
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 748
ADDP4
INDIRI4
ADDRLP4 4
INDIRI4
EQI4 $209
ADDRLP4 0
INDIRP4
CNSTI4 744
ADDP4
INDIRI4
CNSTI4 131074
BANDI4
ADDRLP4 4
INDIRI4
EQI4 $209
line 376
;376:		ent->client->ps.loopSound = level.snd_fry;
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 476
ADDP4
ADDRGP4 level+220
INDIRI4
ASGNI4
line 377
;377:	} else {
ADDRGP4 $210
JUMPV
LABELV $209
line 378
;378:		ent->client->ps.loopSound = 0;
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 476
ADDP4
CNSTI4 0
ASGNI4
line 379
;379:	}
LABELV $210
line 380
;380:}
LABELV $208
endproc G_SetClientSound 8 0
export ClientImpacts
proc ClientImpacts 1100 12
line 391
;381:
;382:
;383:
;384://==============================================================
;385:
;386:/*
;387:==============
;388:ClientImpacts
;389:==============
;390:*/
;391:void ClientImpacts( gentity_t *ent, pmove_t *pm ) {
line 396
;392:	int		i, j;
;393:	trace_t	trace;
;394:	gentity_t	*other;
;395:
;396:	memset( &trace, 0, sizeof( trace ) );
ADDRLP4 12
ARGP4
CNSTI4 0
ARGI4
CNSTI4 1080
ARGI4
ADDRGP4 memset
CALLP4
pop
line 397
;397:	for (i=0 ; i<pm->numtouch ; i++) {
ADDRLP4 4
CNSTI4 0
ASGNI4
ADDRGP4 $216
JUMPV
LABELV $213
line 398
;398:		for (j=0 ; j<i ; j++) {
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 $220
JUMPV
LABELV $217
line 399
;399:			if (pm->touchents[j] == pm->touchents[i] ) {
ADDRLP4 1092
CNSTI4 2
ASGNI4
ADDRLP4 1096
ADDRFP4 4
INDIRP4
CNSTI4 56
ADDP4
ASGNP4
ADDRLP4 0
INDIRI4
ADDRLP4 1092
INDIRI4
LSHI4
ADDRLP4 1096
INDIRP4
ADDP4
INDIRI4
ADDRLP4 4
INDIRI4
ADDRLP4 1092
INDIRI4
LSHI4
ADDRLP4 1096
INDIRP4
ADDP4
INDIRI4
NEI4 $221
line 400
;400:				break;
ADDRGP4 $219
JUMPV
LABELV $221
line 402
;401:			}
;402:		}
LABELV $218
line 398
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $220
ADDRLP4 0
INDIRI4
ADDRLP4 4
INDIRI4
LTI4 $217
LABELV $219
line 403
;403:		if (j != i) {
ADDRLP4 0
INDIRI4
ADDRLP4 4
INDIRI4
EQI4 $223
line 404
;404:			continue;	// duplicated
ADDRGP4 $214
JUMPV
LABELV $223
line 406
;405:		}
;406:		other = &g_entities[ pm->touchents[i] ];
ADDRLP4 8
CNSTI4 828
ADDRLP4 4
INDIRI4
CNSTI4 2
LSHI4
ADDRFP4 4
INDIRP4
CNSTI4 56
ADDP4
ADDP4
INDIRI4
MULI4
ADDRGP4 g_entities
ADDP4
ASGNP4
line 408
;407:
;408:		if ( ( ent->r.svFlags & SVF_BOT ) && ( ent->touch ) ) {
ADDRLP4 1092
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 1092
INDIRP4
CNSTI4 304
ADDP4
INDIRI4
CNSTI4 8
BANDI4
CNSTI4 0
EQI4 $225
ADDRLP4 1092
INDIRP4
CNSTI4 648
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $225
line 409
;409:			ent->touch( ent, other, &trace );
ADDRLP4 1096
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 1096
INDIRP4
ARGP4
ADDRLP4 8
INDIRP4
ARGP4
ADDRLP4 12
ARGP4
ADDRLP4 1096
INDIRP4
CNSTI4 648
ADDP4
INDIRP4
CALLV
pop
line 410
;410:		}
LABELV $225
line 412
;411:
;412:		if ( !other->touch ) {
ADDRLP4 8
INDIRP4
CNSTI4 648
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $227
line 413
;413:			continue;
ADDRGP4 $214
JUMPV
LABELV $227
line 416
;414:		}
;415:
;416:		other->touch( other, ent, &trace );
ADDRLP4 8
INDIRP4
ARGP4
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 12
ARGP4
ADDRLP4 8
INDIRP4
CNSTI4 648
ADDP4
INDIRP4
CALLV
pop
line 417
;417:	}
LABELV $214
line 397
ADDRLP4 4
ADDRLP4 4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $216
ADDRLP4 4
INDIRI4
ADDRFP4 4
INDIRP4
CNSTI4 52
ADDP4
INDIRI4
LTI4 $213
line 419
;418:
;419:}
LABELV $212
endproc ClientImpacts 1100 12
data
align 4
LABELV $230
byte 4 1109393408
byte 4 1109393408
byte 4 1112539136
export G_TouchTriggers
code
proc G_TouchTriggers 5264 16
line 429
;420:
;421:/*
;422:============
;423:G_TouchTriggers
;424:
;425:Find all trigger entities that ent's current position touches.
;426:Spectators will only interact with teleporters.
;427:============
;428:*/
;429:void	G_TouchTriggers( gentity_t *ent ) {
line 437
;430:	int			i, num;
;431:	int			touch[MAX_GENTITIES];
;432:	gentity_t	*hit;
;433:	trace_t		trace;
;434:	vec3_t		mins, maxs;
;435:	static vec3_t	range = { 40, 40, 52 };
;436:
;437:	if ( !ent->client ) {
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $231
line 438
;438:		return;
ADDRGP4 $229
JUMPV
LABELV $231
line 442
;439:	}
;440:
;441:	// dead clients don't activate triggers!
;442:	if ( ent->client->ps.stats[STAT_HEALTH] <= 0 ) {
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 216
ADDP4
INDIRI4
CNSTI4 0
GTI4 $233
line 443
;443:		return;
ADDRGP4 $229
JUMPV
LABELV $233
line 446
;444:	}
;445:
;446:	VectorSubtract( ent->client->ps.origin, range, mins );
ADDRLP4 5212
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
ASGNP4
ADDRLP4 1088
ADDRLP4 5212
INDIRP4
INDIRP4
CNSTI4 20
ADDP4
INDIRF4
ADDRGP4 $230
INDIRF4
SUBF4
ASGNF4
ADDRLP4 1088+4
ADDRLP4 5212
INDIRP4
INDIRP4
CNSTI4 24
ADDP4
INDIRF4
ADDRGP4 $230+4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 1088+8
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 28
ADDP4
INDIRF4
ADDRGP4 $230+8
INDIRF4
SUBF4
ASGNF4
line 447
;447:	VectorAdd( ent->client->ps.origin, range, maxs );
ADDRLP4 5216
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
ASGNP4
ADDRLP4 1100
ADDRLP4 5216
INDIRP4
INDIRP4
CNSTI4 20
ADDP4
INDIRF4
ADDRGP4 $230
INDIRF4
ADDF4
ASGNF4
ADDRLP4 1100+4
ADDRLP4 5216
INDIRP4
INDIRP4
CNSTI4 24
ADDP4
INDIRF4
ADDRGP4 $230+4
INDIRF4
ADDF4
ASGNF4
ADDRLP4 1100+8
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 28
ADDP4
INDIRF4
ADDRGP4 $230+8
INDIRF4
ADDF4
ASGNF4
line 449
;448:
;449:	num = trap_EntitiesInBox( mins, maxs, touch, MAX_GENTITIES );
ADDRLP4 1088
ARGP4
ADDRLP4 1100
ARGP4
ADDRLP4 1116
ARGP4
CNSTI4 1024
ARGI4
ADDRLP4 5220
ADDRGP4 trap_EntitiesInBox
CALLI4
ASGNI4
ADDRLP4 1112
ADDRLP4 5220
INDIRI4
ASGNI4
line 452
;450:
;451:	// can't use ent->r.absmin, because that has a one unit pad
;452:	VectorAdd( ent->client->ps.origin, ent->r.mins, mins );
ADDRLP4 5224
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 5228
ADDRLP4 5224
INDIRP4
CNSTI4 408
ADDP4
ASGNP4
ADDRLP4 1088
ADDRLP4 5228
INDIRP4
INDIRP4
CNSTI4 20
ADDP4
INDIRF4
ADDRLP4 5224
INDIRP4
CNSTI4 316
ADDP4
INDIRF4
ADDF4
ASGNF4
ADDRLP4 1088+4
ADDRLP4 5228
INDIRP4
INDIRP4
CNSTI4 24
ADDP4
INDIRF4
ADDRLP4 5224
INDIRP4
CNSTI4 320
ADDP4
INDIRF4
ADDF4
ASGNF4
ADDRLP4 5232
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 1088+8
ADDRLP4 5232
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 28
ADDP4
INDIRF4
ADDRLP4 5232
INDIRP4
CNSTI4 324
ADDP4
INDIRF4
ADDF4
ASGNF4
line 453
;453:	VectorAdd( ent->client->ps.origin, ent->r.maxs, maxs );
ADDRLP4 5236
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 5240
ADDRLP4 5236
INDIRP4
CNSTI4 408
ADDP4
ASGNP4
ADDRLP4 1100
ADDRLP4 5240
INDIRP4
INDIRP4
CNSTI4 20
ADDP4
INDIRF4
ADDRLP4 5236
INDIRP4
CNSTI4 328
ADDP4
INDIRF4
ADDF4
ASGNF4
ADDRLP4 1100+4
ADDRLP4 5240
INDIRP4
INDIRP4
CNSTI4 24
ADDP4
INDIRF4
ADDRLP4 5236
INDIRP4
CNSTI4 332
ADDP4
INDIRF4
ADDF4
ASGNF4
ADDRLP4 5244
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 1100+8
ADDRLP4 5244
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 28
ADDP4
INDIRF4
ADDRLP4 5244
INDIRP4
CNSTI4 336
ADDP4
INDIRF4
ADDF4
ASGNF4
line 455
;454:
;455:	for ( i=0 ; i<num ; i++ ) {
ADDRLP4 4
CNSTI4 0
ASGNI4
ADDRGP4 $250
JUMPV
LABELV $247
line 456
;456:		hit = &g_entities[touch[i]];
ADDRLP4 0
CNSTI4 828
ADDRLP4 4
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 1116
ADDP4
INDIRI4
MULI4
ADDRGP4 g_entities
ADDP4
ASGNP4
line 458
;457:
;458:		if ( !hit->touch && !ent->touch ) {
ADDRLP4 5248
CNSTI4 648
ASGNI4
ADDRLP4 5252
CNSTU4 0
ASGNU4
ADDRLP4 0
INDIRP4
ADDRLP4 5248
INDIRI4
ADDP4
INDIRP4
CVPU4 4
ADDRLP4 5252
INDIRU4
NEU4 $251
ADDRFP4 0
INDIRP4
ADDRLP4 5248
INDIRI4
ADDP4
INDIRP4
CVPU4 4
ADDRLP4 5252
INDIRU4
NEU4 $251
line 459
;459:			continue;
ADDRGP4 $248
JUMPV
LABELV $251
line 461
;460:		}
;461:		if ( !( hit->r.contents & CONTENTS_TRIGGER ) ) {
ADDRLP4 0
INDIRP4
CNSTI4 340
ADDP4
INDIRI4
CNSTI4 1024
BANDI4
CNSTI4 0
NEI4 $253
line 462
;462:			continue;
ADDRGP4 $248
JUMPV
LABELV $253
line 466
;463:		}
;464:
;465:		// ignore most entities if a spectator
;466:		if ( ent->client->sess.sessionTeam == TEAM_SPECTATOR ) {
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 1536
ADDP4
INDIRI4
CNSTI4 3
NEI4 $255
line 467
;467:			if ( hit->s.eType != ET_TELEPORT_TRIGGER &&
ADDRLP4 0
INDIRP4
CNSTI4 4
ADDP4
INDIRI4
CNSTI4 11
EQI4 $257
ADDRLP4 0
INDIRP4
CNSTI4 648
ADDP4
INDIRP4
CVPU4 4
ADDRGP4 Touch_DoorTrigger
CVPU4 4
EQU4 $257
line 470
;468:				// this is ugly but adding a new ET_? type will
;469:				// most likely cause network incompatibilities
;470:				hit->touch != Touch_DoorTrigger) {
line 471
;471:				continue;
ADDRGP4 $248
JUMPV
LABELV $257
line 473
;472:			}
;473:		}
LABELV $255
line 477
;474:
;475:		// use seperate code for determining if an item is picked up
;476:		// so you don't have to actually contact its bounding box
;477:		if ( hit->s.eType == ET_ITEM ) {
ADDRLP4 0
INDIRP4
CNSTI4 4
ADDP4
INDIRI4
CNSTI4 2
NEI4 $259
line 478
;478:			if ( !BG_PlayerTouchesItem( &ent->client->ps, &hit->s, level.time ) ) {
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
ARGP4
ADDRLP4 0
INDIRP4
ARGP4
ADDRGP4 level+32
INDIRI4
ARGI4
ADDRLP4 5256
ADDRGP4 BG_PlayerTouchesItem
CALLI4
ASGNI4
ADDRLP4 5256
INDIRI4
CNSTI4 0
NEI4 $260
line 479
;479:				continue;
ADDRGP4 $248
JUMPV
line 481
;480:			}
;481:		} else {
LABELV $259
line 482
;482:			if ( !trap_EntityContact( mins, maxs, hit ) ) {
ADDRLP4 1088
ARGP4
ADDRLP4 1100
ARGP4
ADDRLP4 0
INDIRP4
ARGP4
ADDRLP4 5256
ADDRGP4 trap_EntityContact
CALLI4
ASGNI4
ADDRLP4 5256
INDIRI4
CNSTI4 0
NEI4 $264
line 483
;483:				continue;
ADDRGP4 $248
JUMPV
LABELV $264
line 485
;484:			}
;485:		}
LABELV $260
line 487
;486:
;487:		memset( &trace, 0, sizeof(trace) );
ADDRLP4 8
ARGP4
CNSTI4 0
ARGI4
CNSTI4 1080
ARGI4
ADDRGP4 memset
CALLP4
pop
line 489
;488:
;489:		if ( hit->touch ) {
ADDRLP4 0
INDIRP4
CNSTI4 648
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $266
line 490
;490:			hit->touch (hit, ent, &trace);
ADDRLP4 0
INDIRP4
ARGP4
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 8
ARGP4
ADDRLP4 0
INDIRP4
CNSTI4 648
ADDP4
INDIRP4
CALLV
pop
line 491
;491:		}
LABELV $266
line 493
;492:
;493:		if ( ( ent->r.svFlags & SVF_BOT ) && ( ent->touch ) ) {
ADDRLP4 5256
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 5256
INDIRP4
CNSTI4 304
ADDP4
INDIRI4
CNSTI4 8
BANDI4
CNSTI4 0
EQI4 $268
ADDRLP4 5256
INDIRP4
CNSTI4 648
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $268
line 494
;494:			ent->touch( ent, hit, &trace );
ADDRLP4 5260
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 5260
INDIRP4
ARGP4
ADDRLP4 0
INDIRP4
ARGP4
ADDRLP4 8
ARGP4
ADDRLP4 5260
INDIRP4
CNSTI4 648
ADDP4
INDIRP4
CALLV
pop
line 495
;495:		}
LABELV $268
line 496
;496:	}
LABELV $248
line 455
ADDRLP4 4
ADDRLP4 4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $250
ADDRLP4 4
INDIRI4
ADDRLP4 1112
INDIRI4
LTI4 $247
line 499
;497:
;498:	// if we didn't touch a jump pad this pmove frame
;499:	if ( ent->client->ps.jumppad_frame != ent->client->ps.pmove_framecount ) {
ADDRLP4 5248
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
ASGNP4
ADDRLP4 5248
INDIRP4
CNSTI4 492
ADDP4
INDIRI4
ADDRLP4 5248
INDIRP4
CNSTI4 488
ADDP4
INDIRI4
EQI4 $270
line 500
;500:		ent->client->ps.jumppad_frame = 0;
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 492
ADDP4
CNSTI4 0
ASGNI4
line 501
;501:		ent->client->ps.jumppad_ent = 0;
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 480
ADDP4
CNSTI4 0
ASGNI4
line 502
;502:	}
LABELV $270
line 503
;503:}
LABELV $229
endproc G_TouchTriggers 5264 16
lit
align 4
LABELV $273
byte 4 1109393408
byte 4 1109393408
byte 4 1112539136
export G_MoverTouchPushTriggers
code
proc G_MoverTouchPushTriggers 5328 16
line 515
;504:
;505:
;506:/*
;507:============
;508:G_MoverTouchTriggers
;509:
;510:Find all trigger entities that ent's current position touches.
;511:Spectators will only interact with teleporters.
;512:============
;513:*/
;514:void G_MoverTouchPushTriggers( gentity_t *ent, vec3_t oldOrg ) 
;515:{
line 522
;516:	int			i, num;
;517:	float		step, stepSize, dist;
;518:	int			touch[MAX_GENTITIES];
;519:	gentity_t	*hit;
;520:	trace_t		trace;
;521:	vec3_t		mins, maxs, dir, size, checkSpot;
;522:	const vec3_t	range = { 40, 40, 52 };
ADDRLP4 5224
ADDRGP4 $273
INDIRB
ASGNB 12
line 525
;523:
;524:	// non-moving movers don't hit triggers!
;525:	if ( !VectorLengthSquared( ent->s.pos.trDelta ) ) 
ADDRFP4 0
INDIRP4
CNSTI4 36
ADDP4
ARGP4
ADDRLP4 5272
ADDRGP4 VectorLengthSquared
CALLF4
ASGNF4
ADDRLP4 5272
INDIRF4
CNSTF4 0
NEF4 $274
line 526
;526:	{
line 527
;527:		return;
ADDRGP4 $272
JUMPV
LABELV $274
line 530
;528:	}
;529:
;530:	VectorSubtract( ent->r.mins, ent->r.maxs, size );
ADDRLP4 5276
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 5260
ADDRLP4 5276
INDIRP4
CNSTI4 316
ADDP4
INDIRF4
ADDRLP4 5276
INDIRP4
CNSTI4 328
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 5260+4
ADDRLP4 5276
INDIRP4
CNSTI4 320
ADDP4
INDIRF4
ADDRLP4 5276
INDIRP4
CNSTI4 332
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 5280
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 5260+8
ADDRLP4 5280
INDIRP4
CNSTI4 324
ADDP4
INDIRF4
ADDRLP4 5280
INDIRP4
CNSTI4 336
ADDP4
INDIRF4
SUBF4
ASGNF4
line 531
;531:	stepSize = VectorLength( size );
ADDRLP4 5260
ARGP4
ADDRLP4 5284
ADDRGP4 VectorLength
CALLF4
ASGNF4
ADDRLP4 5252
ADDRLP4 5284
INDIRF4
ASGNF4
line 532
;532:	if ( stepSize < 1 )
ADDRLP4 5252
INDIRF4
CNSTF4 1065353216
GEF4 $278
line 533
;533:	{
line 534
;534:		stepSize = 1;
ADDRLP4 5252
CNSTF4 1065353216
ASGNF4
line 535
;535:	}
LABELV $278
line 537
;536:
;537:	VectorSubtract( ent->r.currentOrigin, oldOrg, dir );
ADDRLP4 5288
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 5292
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 5240
ADDRLP4 5288
INDIRP4
CNSTI4 368
ADDP4
INDIRF4
ADDRLP4 5292
INDIRP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 5240+4
ADDRLP4 5288
INDIRP4
CNSTI4 372
ADDP4
INDIRF4
ADDRLP4 5292
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 5240+8
ADDRFP4 0
INDIRP4
CNSTI4 376
ADDP4
INDIRF4
ADDRFP4 4
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
SUBF4
ASGNF4
line 538
;538:	dist = VectorNormalize( dir );
ADDRLP4 5240
ARGP4
ADDRLP4 5296
ADDRGP4 VectorNormalize
CALLF4
ASGNF4
ADDRLP4 5256
ADDRLP4 5296
INDIRF4
ASGNF4
line 539
;539:	for ( step = 0; step <= dist; step += stepSize )
ADDRLP4 5236
CNSTF4 0
ASGNF4
ADDRGP4 $285
JUMPV
LABELV $282
line 540
;540:	{
line 541
;541:		VectorMA( ent->r.currentOrigin, step, dir, checkSpot );
ADDRLP4 5300
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 1112
ADDRLP4 5300
INDIRP4
CNSTI4 368
ADDP4
INDIRF4
ADDRLP4 5240
INDIRF4
ADDRLP4 5236
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 1112+4
ADDRLP4 5300
INDIRP4
CNSTI4 372
ADDP4
INDIRF4
ADDRLP4 5240+4
INDIRF4
ADDRLP4 5236
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 1112+8
ADDRFP4 0
INDIRP4
CNSTI4 376
ADDP4
INDIRF4
ADDRLP4 5240+8
INDIRF4
ADDRLP4 5236
INDIRF4
MULF4
ADDF4
ASGNF4
line 542
;542:		VectorSubtract( checkSpot, range, mins );
ADDRLP4 1088
ADDRLP4 1112
INDIRF4
ADDRLP4 5224
INDIRF4
SUBF4
ASGNF4
ADDRLP4 1088+4
ADDRLP4 1112+4
INDIRF4
ADDRLP4 5224+4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 1088+8
ADDRLP4 1112+8
INDIRF4
ADDRLP4 5224+8
INDIRF4
SUBF4
ASGNF4
line 543
;543:		VectorAdd( checkSpot, range, maxs );
ADDRLP4 1100
ADDRLP4 1112
INDIRF4
ADDRLP4 5224
INDIRF4
ADDF4
ASGNF4
ADDRLP4 1100+4
ADDRLP4 1112+4
INDIRF4
ADDRLP4 5224+4
INDIRF4
ADDF4
ASGNF4
ADDRLP4 1100+8
ADDRLP4 1112+8
INDIRF4
ADDRLP4 5224+8
INDIRF4
ADDF4
ASGNF4
line 545
;544:
;545:		num = trap_EntitiesInBox( mins, maxs, touch, MAX_GENTITIES );
ADDRLP4 1088
ARGP4
ADDRLP4 1100
ARGP4
ADDRLP4 1128
ARGP4
CNSTI4 1024
ARGI4
ADDRLP4 5308
ADDRGP4 trap_EntitiesInBox
CALLI4
ASGNI4
ADDRLP4 1124
ADDRLP4 5308
INDIRI4
ASGNI4
line 548
;546:
;547:		// can't use ent->r.absmin, because that has a one unit pad
;548:		VectorAdd( checkSpot, ent->r.mins, mins );
ADDRLP4 5312
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 1088
ADDRLP4 1112
INDIRF4
ADDRLP4 5312
INDIRP4
CNSTI4 316
ADDP4
INDIRF4
ADDF4
ASGNF4
ADDRLP4 1088+4
ADDRLP4 1112+4
INDIRF4
ADDRLP4 5312
INDIRP4
CNSTI4 320
ADDP4
INDIRF4
ADDF4
ASGNF4
ADDRLP4 1088+8
ADDRLP4 1112+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 324
ADDP4
INDIRF4
ADDF4
ASGNF4
line 549
;549:		VectorAdd( checkSpot, ent->r.maxs, maxs );
ADDRLP4 5316
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 1100
ADDRLP4 1112
INDIRF4
ADDRLP4 5316
INDIRP4
CNSTI4 328
ADDP4
INDIRF4
ADDF4
ASGNF4
ADDRLP4 1100+4
ADDRLP4 1112+4
INDIRF4
ADDRLP4 5316
INDIRP4
CNSTI4 332
ADDP4
INDIRF4
ADDF4
ASGNF4
ADDRLP4 1100+8
ADDRLP4 1112+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 336
ADDP4
INDIRF4
ADDF4
ASGNF4
line 551
;550:
;551:		for ( i=0 ; i<num ; i++ ) 
ADDRLP4 4
CNSTI4 0
ASGNI4
ADDRGP4 $313
JUMPV
LABELV $310
line 552
;552:		{
line 553
;553:			hit = &g_entities[touch[i]];
ADDRLP4 0
CNSTI4 828
ADDRLP4 4
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 1128
ADDP4
INDIRI4
MULI4
ADDRGP4 g_entities
ADDP4
ASGNP4
line 555
;554:
;555:			if ( hit->s.eType != ET_PUSH_TRIGGER )
ADDRLP4 0
INDIRP4
CNSTI4 4
ADDP4
INDIRI4
CNSTI4 10
EQI4 $314
line 556
;556:			{
line 557
;557:				continue;
ADDRGP4 $311
JUMPV
LABELV $314
line 560
;558:			}
;559:
;560:			if ( hit->touch == NULL ) 
ADDRLP4 0
INDIRP4
CNSTI4 648
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $316
line 561
;561:			{
line 562
;562:				continue;
ADDRGP4 $311
JUMPV
LABELV $316
line 565
;563:			}
;564:
;565:			if ( !( hit->r.contents & CONTENTS_TRIGGER ) ) 
ADDRLP4 0
INDIRP4
CNSTI4 340
ADDP4
INDIRI4
CNSTI4 1024
BANDI4
CNSTI4 0
NEI4 $318
line 566
;566:			{
line 567
;567:				continue;
ADDRGP4 $311
JUMPV
LABELV $318
line 571
;568:			}
;569:
;570:
;571:			if ( !trap_EntityContact( mins, maxs, hit ) ) 
ADDRLP4 1088
ARGP4
ADDRLP4 1100
ARGP4
ADDRLP4 0
INDIRP4
ARGP4
ADDRLP4 5320
ADDRGP4 trap_EntityContact
CALLI4
ASGNI4
ADDRLP4 5320
INDIRI4
CNSTI4 0
NEI4 $320
line 572
;572:			{
line 573
;573:				continue;
ADDRGP4 $311
JUMPV
LABELV $320
line 576
;574:			}
;575:
;576:			memset( &trace, 0, sizeof(trace) );
ADDRLP4 8
ARGP4
CNSTI4 0
ARGI4
CNSTI4 1080
ARGI4
ADDRGP4 memset
CALLP4
pop
line 578
;577:
;578:			if ( hit->touch != NULL ) 
ADDRLP4 0
INDIRP4
CNSTI4 648
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $322
line 579
;579:			{
line 580
;580:				hit->touch(hit, ent, &trace);
ADDRLP4 0
INDIRP4
ARGP4
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 8
ARGP4
ADDRLP4 0
INDIRP4
CNSTI4 648
ADDP4
INDIRP4
CALLV
pop
line 581
;581:			}
LABELV $322
line 582
;582:		}
LABELV $311
line 551
ADDRLP4 4
ADDRLP4 4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $313
ADDRLP4 4
INDIRI4
ADDRLP4 1124
INDIRI4
LTI4 $310
line 583
;583:	}
LABELV $283
line 539
ADDRLP4 5236
ADDRLP4 5236
INDIRF4
ADDRLP4 5252
INDIRF4
ADDF4
ASGNF4
LABELV $285
ADDRLP4 5236
INDIRF4
ADDRLP4 5256
INDIRF4
LEF4 $282
line 584
;584:}
LABELV $272
endproc G_MoverTouchPushTriggers 5328 16
export SpectatorThink
proc SpectatorThink 400 12
line 591
;585:
;586:/*
;587:=================
;588:SpectatorThink
;589:=================
;590:*/
;591:void SpectatorThink( gentity_t *ent, usercmd_t *ucmd ) {
line 599
;592:	pmove_t	pm;
;593:	gclient_t	*client;
;594:
;595:   // adnan
;596:   // rotation quat
;597:   //quat_t *qrot;
;598:
;599:	client = ent->client;
ADDRLP4 0
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
ASGNP4
line 601
;600:
;601:	if ( client->sess.spectatorState != SPECTATOR_FOLLOW ) {
ADDRLP4 0
INDIRP4
CNSTI4 1544
ADDP4
INDIRI4
CNSTI4 2
EQI4 $325
line 602
;602:		client->ps.pm_type = PM_SPECTATOR;
ADDRLP4 0
INDIRP4
CNSTI4 4
ADDP4
CNSTI4 3
ASGNI4
line 603
;603:		client->ps.speed = 400;	// faster than normal
ADDRLP4 0
INDIRP4
CNSTI4 60
ADDP4
CNSTI4 400
ASGNI4
line 604
;604:		client->ps.basespeed = 400;
ADDRLP4 0
INDIRP4
CNSTI4 64
ADDP4
CNSTI4 400
ASGNI4
line 607
;605:
;606:		// set up for pmove
;607:		memset (&pm, 0, sizeof(pm));
ADDRLP4 4
ARGP4
CNSTI4 0
ARGI4
CNSTI4 380
ARGI4
ADDRGP4 memset
CALLP4
pop
line 608
;608:		pm.ps = &client->ps;
ADDRLP4 4
ADDRLP4 0
INDIRP4
ASGNP4
line 609
;609:		pm.cmd = *ucmd;
ADDRLP4 4+4
ADDRFP4 4
INDIRP4
INDIRB
ASGNB 28
line 610
;610:		pm.tracemask = MASK_PLAYERSOLID & ~CONTENTS_BODY;	// spectators can fly through bodies
ADDRLP4 4+32
CNSTI4 17
ASGNI4
line 611
;611:		pm.trace = trap_Trace;
ADDRLP4 4+240
ADDRGP4 trap_Trace
ASGNP4
line 612
;612:		pm.pointcontents = trap_PointContents;
ADDRLP4 4+244
ADDRGP4 trap_PointContents
ASGNP4
line 614
;613:
;614:		pm.animations = NULL;
ADDRLP4 4+224
CNSTP4 0
ASGNP4
line 618
;615:
;616:		// perform a pmove
;617:		// adnan
;618:      Pmove (&pm);
ADDRLP4 4
ARGP4
ADDRGP4 Pmove
CALLP4
pop
line 623
;619:      //qrot = Pmove (&pm);
;620:      //QuaternionToAxis(*q, ent
;621:
;622:		// save results of pmove
;623:		VectorCopy( client->ps.origin, ent->s.origin );
ADDRFP4 0
INDIRP4
CNSTI4 92
ADDP4
ADDRLP4 0
INDIRP4
CNSTI4 20
ADDP4
INDIRB
ASGNB 12
line 625
;624:
;625:		G_TouchTriggers( ent );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 G_TouchTriggers
CALLV
pop
line 626
;626:		trap_UnlinkEntity( ent );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 trap_UnlinkEntity
CALLV
pop
line 627
;627:	}
LABELV $325
line 629
;628:
;629:	client->oldbuttons = client->buttons;
ADDRLP4 0
INDIRP4
CNSTI4 1604
ADDP4
ADDRLP4 0
INDIRP4
CNSTI4 1600
ADDP4
INDIRI4
ASGNI4
line 630
;630:	client->buttons = ucmd->buttons;
ADDRLP4 0
INDIRP4
CNSTI4 1600
ADDP4
ADDRFP4 4
INDIRP4
CNSTI4 16
ADDP4
INDIRI4
ASGNI4
line 633
;631:
;632:	// attack button cycles through spectators
;633:	if ( ( client->buttons & BUTTON_ATTACK ) && ! ( client->oldbuttons & BUTTON_ATTACK ) ) {
ADDRLP4 392
CNSTI4 1
ASGNI4
ADDRLP4 396
CNSTI4 0
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 1600
ADDP4
INDIRI4
ADDRLP4 392
INDIRI4
BANDI4
ADDRLP4 396
INDIRI4
EQI4 $332
ADDRLP4 0
INDIRP4
CNSTI4 1604
ADDP4
INDIRI4
ADDRLP4 392
INDIRI4
BANDI4
ADDRLP4 396
INDIRI4
NEI4 $332
line 634
;634:		Cmd_FollowCycle_f( ent, 1 );
ADDRFP4 0
INDIRP4
ARGP4
CNSTI4 1
ARGI4
ADDRGP4 Cmd_FollowCycle_f
CALLV
pop
line 635
;635:	}
LABELV $332
line 637
;636:
;637:	if (client->sess.spectatorState == SPECTATOR_FOLLOW && (ucmd->upmove > 0))
ADDRLP4 0
INDIRP4
CNSTI4 1544
ADDP4
INDIRI4
CNSTI4 2
NEI4 $334
ADDRFP4 4
INDIRP4
CNSTI4 26
ADDP4
INDIRI1
CVII4 1
CNSTI4 0
LEI4 $334
line 638
;638:	{ //jump now removes you from follow mode
line 639
;639:		StopFollowing(ent);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 StopFollowing
CALLV
pop
line 640
;640:	}
LABELV $334
line 641
;641:}
LABELV $324
endproc SpectatorThink 400 12
export ClientInactivityTimer
proc ClientInactivityTimer 12 8
line 652
;642:
;643:
;644:
;645:/*
;646:=================
;647:ClientInactivityTimer
;648:
;649:Returns qfalse if the client is dropped
;650:=================
;651:*/
;652:qboolean ClientInactivityTimer( gclient_t *client ) {
line 653
;653:	if ( ! g_inactivity.integer ) {
ADDRGP4 g_inactivity+12
INDIRI4
CNSTI4 0
NEI4 $337
line 656
;654:		// give everyone some time, so if the operator sets g_inactivity during
;655:		// gameplay, everyone isn't kicked
;656:		client->inactivityTime = level.time + 60 * 1000;
ADDRFP4 0
INDIRP4
CNSTI4 1692
ADDP4
ADDRGP4 level+32
INDIRI4
CNSTI4 60000
ADDI4
ASGNI4
line 657
;657:		client->inactivityWarning = qfalse;
ADDRFP4 0
INDIRP4
CNSTI4 1696
ADDP4
CNSTI4 0
ASGNI4
line 658
;658:	} else if ( client->pers.cmd.forwardmove || 
ADDRGP4 $338
JUMPV
LABELV $337
ADDRLP4 0
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 4
CNSTI4 0
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 1408
ADDP4
INDIRI1
CVII4 1
ADDRLP4 4
INDIRI4
NEI4 $345
ADDRLP4 0
INDIRP4
CNSTI4 1409
ADDP4
INDIRI1
CVII4 1
ADDRLP4 4
INDIRI4
NEI4 $345
ADDRLP4 0
INDIRP4
CNSTI4 1410
ADDP4
INDIRI1
CVII4 1
ADDRLP4 4
INDIRI4
NEI4 $345
ADDRLP4 0
INDIRP4
CNSTI4 1400
ADDP4
INDIRI4
CNSTI4 129
BANDI4
ADDRLP4 4
INDIRI4
EQI4 $341
LABELV $345
line 661
;659:		client->pers.cmd.rightmove || 
;660:		client->pers.cmd.upmove ||
;661:		(client->pers.cmd.buttons & (BUTTON_ATTACK|BUTTON_ALT_ATTACK)) ) {
line 662
;662:		client->inactivityTime = level.time + g_inactivity.integer * 1000;
ADDRFP4 0
INDIRP4
CNSTI4 1692
ADDP4
ADDRGP4 level+32
INDIRI4
CNSTI4 1000
ADDRGP4 g_inactivity+12
INDIRI4
MULI4
ADDI4
ASGNI4
line 663
;663:		client->inactivityWarning = qfalse;
ADDRFP4 0
INDIRP4
CNSTI4 1696
ADDP4
CNSTI4 0
ASGNI4
line 664
;664:	} else if ( !client->pers.localClient ) {
ADDRGP4 $342
JUMPV
LABELV $341
ADDRFP4 0
INDIRP4
CNSTI4 1412
ADDP4
INDIRI4
CNSTI4 0
NEI4 $348
line 665
;665:		if ( level.time > client->inactivityTime ) {
ADDRGP4 level+32
INDIRI4
ADDRFP4 0
INDIRP4
CNSTI4 1692
ADDP4
INDIRI4
LEI4 $350
line 666
;666:			trap_DropClient( client - level.clients, "Dropped due to inactivity" );
ADDRFP4 0
INDIRP4
CVPU4 4
ADDRGP4 level
INDIRP4
CVPU4 4
SUBU4
CVUI4 4
CNSTI4 1804
DIVI4
ARGI4
ADDRGP4 $353
ARGP4
ADDRGP4 trap_DropClient
CALLV
pop
line 667
;667:			return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $336
JUMPV
LABELV $350
line 669
;668:		}
;669:		if ( level.time > client->inactivityTime - 10000 && !client->inactivityWarning ) {
ADDRLP4 8
ADDRFP4 0
INDIRP4
ASGNP4
ADDRGP4 level+32
INDIRI4
ADDRLP4 8
INDIRP4
CNSTI4 1692
ADDP4
INDIRI4
CNSTI4 10000
SUBI4
LEI4 $354
ADDRLP4 8
INDIRP4
CNSTI4 1696
ADDP4
INDIRI4
CNSTI4 0
NEI4 $354
line 670
;670:			client->inactivityWarning = qtrue;
ADDRFP4 0
INDIRP4
CNSTI4 1696
ADDP4
CNSTI4 1
ASGNI4
line 671
;671:			trap_SendServerCommand( client - level.clients, "cp \"Ten seconds until inactivity drop!\n\"" );
ADDRFP4 0
INDIRP4
CVPU4 4
ADDRGP4 level
INDIRP4
CVPU4 4
SUBU4
CVUI4 4
CNSTI4 1804
DIVI4
ARGI4
ADDRGP4 $357
ARGP4
ADDRGP4 trap_SendServerCommand
CALLV
pop
line 672
;672:		}
LABELV $354
line 673
;673:	}
LABELV $348
LABELV $342
LABELV $338
line 674
;674:	return qtrue;
CNSTI4 1
RETI4
LABELV $336
endproc ClientInactivityTimer 12 8
export ClientTimerActions
proc ClientTimerActions 20 0
line 684
;675:}
;676:
;677:/*
;678:==================
;679:ClientTimerActions
;680:
;681:Actions that happen once a second
;682:==================
;683:*/
;684:void ClientTimerActions( gentity_t *ent, int msec ) {
line 687
;685:	gclient_t	*client;
;686:
;687:	client = ent->client;
ADDRLP4 0
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
ASGNP4
line 688
;688:	client->timeResidual += msec;
ADDRLP4 4
ADDRLP4 0
INDIRP4
CNSTI4 1724
ADDP4
ASGNP4
ADDRLP4 4
INDIRP4
ADDRLP4 4
INDIRP4
INDIRI4
ADDRFP4 4
INDIRI4
ADDI4
ASGNI4
ADDRGP4 $360
JUMPV
LABELV $359
line 691
;689:
;690:	while ( client->timeResidual >= 1000 ) 
;691:	{
line 692
;692:		client->timeResidual -= 1000;
ADDRLP4 8
ADDRLP4 0
INDIRP4
CNSTI4 1724
ADDP4
ASGNP4
ADDRLP4 8
INDIRP4
ADDRLP4 8
INDIRP4
INDIRI4
CNSTI4 1000
SUBI4
ASGNI4
line 695
;693:
;694:		// count down health when over max
;695:		if ( ent->health > client->ps.stats[STAT_MAX_HEALTH] ) {
ADDRFP4 0
INDIRP4
CNSTI4 676
ADDP4
INDIRI4
ADDRLP4 0
INDIRP4
CNSTI4 248
ADDP4
INDIRI4
LEI4 $362
line 696
;696:			ent->health--;
ADDRLP4 12
ADDRFP4 0
INDIRP4
CNSTI4 676
ADDP4
ASGNP4
ADDRLP4 12
INDIRP4
ADDRLP4 12
INDIRP4
INDIRI4
CNSTI4 1
SUBI4
ASGNI4
line 697
;697:		}
LABELV $362
line 700
;698:
;699:		// count down armor when over max
;700:		if ( client->ps.stats[STAT_ARMOR] > client->ps.stats[STAT_MAX_HEALTH] ) {
ADDRLP4 0
INDIRP4
CNSTI4 236
ADDP4
INDIRI4
ADDRLP4 0
INDIRP4
CNSTI4 248
ADDP4
INDIRI4
LEI4 $364
line 701
;701:			client->ps.stats[STAT_ARMOR]--;
ADDRLP4 16
ADDRLP4 0
INDIRP4
CNSTI4 236
ADDP4
ASGNP4
ADDRLP4 16
INDIRP4
ADDRLP4 16
INDIRP4
INDIRI4
CNSTI4 1
SUBI4
ASGNI4
line 702
;702:		}
LABELV $364
line 703
;703:	}
LABELV $360
line 690
ADDRLP4 0
INDIRP4
CNSTI4 1724
ADDP4
INDIRI4
CNSTI4 1000
GEI4 $359
line 704
;704:}
LABELV $358
endproc ClientTimerActions 20 0
export ClientIntermissionThink
proc ClientIntermissionThink 24 0
line 711
;705:
;706:/*
;707:====================
;708:ClientIntermissionThink
;709:====================
;710:*/
;711:void ClientIntermissionThink( gclient_t *client ) {
line 712
;712:	client->ps.eFlags &= ~EF_TALK;
ADDRLP4 0
ADDRFP4 0
INDIRP4
CNSTI4 108
ADDP4
ASGNP4
ADDRLP4 0
INDIRP4
ADDRLP4 0
INDIRP4
INDIRI4
CNSTI4 -4097
BANDI4
ASGNI4
line 713
;713:	client->ps.eFlags &= ~EF_FIRING;
ADDRLP4 4
ADDRFP4 0
INDIRP4
CNSTI4 108
ADDP4
ASGNP4
ADDRLP4 4
INDIRP4
ADDRLP4 4
INDIRP4
INDIRI4
CNSTI4 -257
BANDI4
ASGNI4
line 718
;714:
;715:	// the level will exit when everyone wants to or after timeouts
;716:
;717:	// swap and latch button actions
;718:	client->oldbuttons = client->buttons;
ADDRLP4 8
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 8
INDIRP4
CNSTI4 1604
ADDP4
ADDRLP4 8
INDIRP4
CNSTI4 1600
ADDP4
INDIRI4
ASGNI4
line 719
;719:	client->buttons = client->pers.cmd.buttons;
ADDRLP4 12
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 12
INDIRP4
CNSTI4 1600
ADDP4
ADDRLP4 12
INDIRP4
CNSTI4 1400
ADDP4
INDIRI4
ASGNI4
line 720
;720:	if ( client->buttons & ( BUTTON_ATTACK | BUTTON_USE_HOLDABLE ) & ( client->oldbuttons ^ client->buttons ) ) {
ADDRLP4 16
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 20
ADDRLP4 16
INDIRP4
CNSTI4 1600
ADDP4
INDIRI4
ASGNI4
ADDRLP4 20
INDIRI4
CNSTI4 5
BANDI4
ADDRLP4 16
INDIRP4
CNSTI4 1604
ADDP4
INDIRI4
ADDRLP4 20
INDIRI4
BXORI4
BANDI4
CNSTI4 0
EQI4 $367
line 722
;721:		// this used to be an ^1 but once a player says ready, it should stick
;722:		client->readyToExit = 1;
ADDRFP4 0
INDIRP4
CNSTI4 1588
ADDP4
CNSTI4 1
ASGNI4
line 723
;723:	}
LABELV $367
line 724
;724:}
LABELV $366
endproc ClientIntermissionThink 24 0
export ClientEvents
proc ClientEvents 68 32
line 735
;725:
;726:
;727:/*
;728:================
;729:ClientEvents
;730:
;731:Events will be passed on to the clients for presentation,
;732:but any server game effects are handled here
;733:================
;734:*/
;735:void ClientEvents( gentity_t *ent, int oldEventSequence ) {
line 746
;736:	int		i;//, j;
;737:	int		event;
;738:	gclient_t *client;
;739:	int		damage;
;740:	vec3_t	dir;
;741://	vec3_t	origin, angles;
;742://	qboolean	fired;
;743://	gitem_t *item;
;744://	gentity_t *drop;
;745:
;746:	client = ent->client;
ADDRLP4 8
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
ASGNP4
line 748
;747:
;748:	if ( oldEventSequence < client->ps.eventSequence - MAX_PS_EVENTS ) {
ADDRFP4 4
INDIRI4
ADDRLP4 8
INDIRP4
CNSTI4 112
ADDP4
INDIRI4
CNSTI4 2
SUBI4
GEI4 $370
line 749
;749:		oldEventSequence = client->ps.eventSequence - MAX_PS_EVENTS;
ADDRFP4 4
ADDRLP4 8
INDIRP4
CNSTI4 112
ADDP4
INDIRI4
CNSTI4 2
SUBI4
ASGNI4
line 750
;750:	}
LABELV $370
line 751
;751:	for ( i = oldEventSequence ; i < client->ps.eventSequence ; i++ ) {
ADDRLP4 0
ADDRFP4 4
INDIRI4
ASGNI4
ADDRGP4 $375
JUMPV
LABELV $372
line 752
;752:		event = client->ps.events[ i & (MAX_PS_EVENTS-1) ];
ADDRLP4 4
ADDRLP4 0
INDIRI4
CNSTI4 1
BANDI4
CNSTI4 2
LSHI4
ADDRLP4 8
INDIRP4
CNSTI4 116
ADDP4
ADDP4
INDIRI4
ASGNI4
line 754
;753:
;754:		switch ( event ) {
ADDRLP4 32
CNSTI4 15
ASGNI4
ADDRLP4 4
INDIRI4
ADDRLP4 32
INDIRI4
EQI4 $378
ADDRLP4 4
INDIRI4
ADDRLP4 32
INDIRI4
GTI4 $404
LABELV $403
ADDRLP4 4
INDIRI4
CNSTI4 11
EQI4 $378
ADDRGP4 $377
JUMPV
LABELV $404
ADDRLP4 40
CNSTI4 24
ASGNI4
ADDRLP4 4
INDIRI4
ADDRLP4 40
INDIRI4
EQI4 $391
ADDRLP4 4
INDIRI4
CNSTI4 25
EQI4 $393
ADDRLP4 4
INDIRI4
CNSTI4 26
EQI4 $395
ADDRLP4 4
INDIRI4
ADDRLP4 40
INDIRI4
LTI4 $377
LABELV $405
ADDRLP4 4
INDIRI4
CNSTI4 41
LTI4 $377
ADDRLP4 4
INDIRI4
CNSTI4 46
GTI4 $377
ADDRLP4 4
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 $406-164
ADDP4
INDIRP4
JUMPV
lit
align 4
LABELV $406
address $397
address $398
address $399
address $377
address $401
address $402
code
LABELV $378
line 757
;755:		case EV_FALL:
;756:		case EV_ROLL:
;757:			{
line 758
;758:				int delta = client->ps.eventParms[ i & (MAX_PS_EVENTS-1) ];
ADDRLP4 48
ADDRLP4 0
INDIRI4
CNSTI4 1
BANDI4
CNSTI4 2
LSHI4
ADDRLP4 8
INDIRP4
CNSTI4 124
ADDP4
ADDP4
INDIRI4
ASGNI4
line 760
;759:
;760:				if (ent->client && ent->client->ps.fallingToDeath)
ADDRLP4 52
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
ASGNP4
ADDRLP4 52
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $379
ADDRLP4 52
INDIRP4
CNSTI4 1352
ADDP4
INDIRI4
CNSTI4 0
EQI4 $379
line 761
;761:				{
line 762
;762:					break;
ADDRGP4 $377
JUMPV
LABELV $379
line 765
;763:				}
;764:
;765:				if ( ent->s.eType != ET_PLAYER )
ADDRFP4 0
INDIRP4
CNSTI4 4
ADDP4
INDIRI4
CNSTI4 1
EQI4 $381
line 766
;766:				{
line 767
;767:					break;		// not in the player model
ADDRGP4 $377
JUMPV
LABELV $381
line 770
;768:				}
;769:				
;770:				if ( g_dmflags.integer & DF_NO_FALLING )
ADDRGP4 g_dmflags+12
INDIRI4
CNSTI4 8
BANDI4
CNSTI4 0
EQI4 $383
line 771
;771:				{
line 772
;772:					break;
ADDRGP4 $377
JUMPV
LABELV $383
line 775
;773:				}
;774:
;775:				if (delta <= 44)
ADDRLP4 48
INDIRI4
CNSTI4 44
GTI4 $386
line 776
;776:				{
line 777
;777:					break;
ADDRGP4 $377
JUMPV
LABELV $386
line 780
;778:				}
;779:
;780:				damage = delta*0.16; //good enough for now, I guess
ADDRLP4 24
CNSTF4 1042536202
ADDRLP4 48
INDIRI4
CVIF4 4
MULF4
CVFI4 4
ASGNI4
line 782
;781:
;782:				VectorSet (dir, 0, 0, 1);
ADDRLP4 56
CNSTF4 0
ASGNF4
ADDRLP4 12
ADDRLP4 56
INDIRF4
ASGNF4
ADDRLP4 12+4
ADDRLP4 56
INDIRF4
ASGNF4
ADDRLP4 12+8
CNSTF4 1065353216
ASGNF4
line 783
;783:				ent->pain_debounce_time = level.time + 200;	// no normal pain sound
ADDRFP4 0
INDIRP4
CNSTI4 664
ADDP4
ADDRGP4 level+32
INDIRI4
CNSTI4 200
ADDI4
ASGNI4
line 784
;784:				G_Damage (ent, NULL, NULL, NULL, NULL, damage, DAMAGE_NO_ARMOR, MOD_FALLING);
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 60
CNSTP4 0
ASGNP4
ADDRLP4 60
INDIRP4
ARGP4
ADDRLP4 60
INDIRP4
ARGP4
ADDRLP4 64
CNSTP4 0
ASGNP4
ADDRLP4 64
INDIRP4
ARGP4
ADDRLP4 64
INDIRP4
ARGP4
ADDRLP4 24
INDIRI4
ARGI4
CNSTI4 2
ARGI4
CNSTI4 34
ARGI4
ADDRGP4 G_Damage
CALLV
pop
line 785
;785:			}
line 786
;786:			break;
ADDRGP4 $377
JUMPV
LABELV $391
line 788
;787:		case EV_FIRE_WEAPON:
;788:			FireWeapon( ent, qfalse );
ADDRFP4 0
INDIRP4
ARGP4
CNSTI4 0
ARGI4
ADDRGP4 FireWeapon
CALLV
pop
line 789
;789:			ent->client->dangerTime = level.time;
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 1792
ADDP4
ADDRGP4 level+32
INDIRI4
ASGNI4
line 790
;790:			ent->client->ps.eFlags &= ~EF_INVULNERABLE;
ADDRLP4 48
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 108
ADDP4
ASGNP4
ADDRLP4 48
INDIRP4
ADDRLP4 48
INDIRP4
INDIRI4
CNSTI4 -67108865
BANDI4
ASGNI4
line 791
;791:			ent->client->invulnerableTimer = 0;
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 1580
ADDP4
CNSTI4 0
ASGNI4
line 792
;792:			break;
ADDRGP4 $377
JUMPV
LABELV $393
line 795
;793:
;794:		case EV_ALT_FIRE:
;795:			FireWeapon( ent, qtrue );
ADDRFP4 0
INDIRP4
ARGP4
CNSTI4 1
ARGI4
ADDRGP4 FireWeapon
CALLV
pop
line 796
;796:			ent->client->dangerTime = level.time;
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 1792
ADDP4
ADDRGP4 level+32
INDIRI4
ASGNI4
line 797
;797:			ent->client->ps.eFlags &= ~EF_INVULNERABLE;
ADDRLP4 52
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 108
ADDP4
ASGNP4
ADDRLP4 52
INDIRP4
ADDRLP4 52
INDIRP4
INDIRI4
CNSTI4 -67108865
BANDI4
ASGNI4
line 798
;798:			ent->client->invulnerableTimer = 0;
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 1580
ADDP4
CNSTI4 0
ASGNI4
line 799
;799:			break;
ADDRGP4 $377
JUMPV
LABELV $395
line 802
;800:
;801:		case EV_SABER_ATTACK:
;802:			ent->client->dangerTime = level.time;
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 1792
ADDP4
ADDRGP4 level+32
INDIRI4
ASGNI4
line 803
;803:			ent->client->ps.eFlags &= ~EF_INVULNERABLE;
ADDRLP4 56
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 108
ADDP4
ASGNP4
ADDRLP4 56
INDIRP4
ADDRLP4 56
INDIRP4
INDIRI4
CNSTI4 -67108865
BANDI4
ASGNI4
line 804
;804:			ent->client->invulnerableTimer = 0;
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 1580
ADDP4
CNSTI4 0
ASGNI4
line 805
;805:			break;
ADDRGP4 $377
JUMPV
LABELV $397
line 809
;806:
;807:		//rww - Note that these must be in the same order (ITEM#-wise) as they are in holdable_t
;808:		case EV_USE_ITEM1: //seeker droid
;809:			ItemUse_Seeker(ent);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 ItemUse_Seeker
CALLV
pop
line 810
;810:			break;
ADDRGP4 $377
JUMPV
LABELV $398
line 812
;811:		case EV_USE_ITEM2: //shield
;812:			ItemUse_Shield(ent);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 ItemUse_Shield
CALLV
pop
line 813
;813:			break;
ADDRGP4 $377
JUMPV
LABELV $399
line 815
;814:		case EV_USE_ITEM3: //medpack
;815:			ItemUse_MedPack(ent);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 ItemUse_MedPack
CALLV
pop
line 816
;816:			break;
ADDRGP4 $377
JUMPV
line 819
;817:		case EV_USE_ITEM4: //datapad
;818:			//G_Printf("Used Datapad\n");
;819:			break;
LABELV $401
line 821
;820:		case EV_USE_ITEM5: //binoculars
;821:			ItemUse_Binoculars(ent);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 ItemUse_Binoculars
CALLV
pop
line 822
;822:			break;
ADDRGP4 $377
JUMPV
LABELV $402
line 824
;823:		case EV_USE_ITEM6: //sentry gun
;824:			ItemUse_Sentry(ent);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 ItemUse_Sentry
CALLV
pop
line 825
;825:			break;
line 828
;826:
;827:		default:
;828:			break;
LABELV $377
line 830
;829:		}
;830:	}
LABELV $373
line 751
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $375
ADDRLP4 0
INDIRI4
ADDRLP4 8
INDIRP4
CNSTI4 112
ADDP4
INDIRI4
LTI4 $372
line 832
;831:
;832:}
LABELV $369
endproc ClientEvents 68 32
export SendPendingPredictableEvents
proc SendPendingPredictableEvents 40 12
line 839
;833:
;834:/*
;835:==============
;836:SendPendingPredictableEvents
;837:==============
;838:*/
;839:void SendPendingPredictableEvents( playerState_t *ps ) {
line 845
;840:	gentity_t *t;
;841:	int event, seq;
;842:	int extEvent, number;
;843:
;844:	// if there are still events pending
;845:	if ( ps->entityEventSequence < ps->eventSequence ) {
ADDRLP4 20
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 20
INDIRP4
CNSTI4 496
ADDP4
INDIRI4
ADDRLP4 20
INDIRP4
CNSTI4 112
ADDP4
INDIRI4
GEI4 $409
line 848
;846:		// create a temporary entity for this event which is sent to everyone
;847:		// except the client who generated the event
;848:		seq = ps->entityEventSequence & (MAX_PS_EVENTS-1);
ADDRLP4 8
ADDRFP4 0
INDIRP4
CNSTI4 496
ADDP4
INDIRI4
CNSTI4 1
BANDI4
ASGNI4
line 849
;849:		event = ps->events[ seq ] | ( ( ps->entityEventSequence & 3 ) << 8 );
ADDRLP4 24
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 4
ADDRLP4 8
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 24
INDIRP4
CNSTI4 116
ADDP4
ADDP4
INDIRI4
ADDRLP4 24
INDIRP4
CNSTI4 496
ADDP4
INDIRI4
CNSTI4 3
BANDI4
CNSTI4 8
LSHI4
BORI4
ASGNI4
line 851
;850:		// set external event to zero before calling BG_PlayerStateToEntityState
;851:		extEvent = ps->externalEvent;
ADDRLP4 12
ADDRFP4 0
INDIRP4
CNSTI4 132
ADDP4
INDIRI4
ASGNI4
line 852
;852:		ps->externalEvent = 0;
ADDRFP4 0
INDIRP4
CNSTI4 132
ADDP4
CNSTI4 0
ASGNI4
line 854
;853:		// create temporary entity for event
;854:		t = G_TempEntity( ps->origin, event );
ADDRFP4 0
INDIRP4
CNSTI4 20
ADDP4
ARGP4
ADDRLP4 4
INDIRI4
ARGI4
ADDRLP4 28
ADDRGP4 G_TempEntity
CALLP4
ASGNP4
ADDRLP4 0
ADDRLP4 28
INDIRP4
ASGNP4
line 855
;855:		number = t->s.number;
ADDRLP4 16
ADDRLP4 0
INDIRP4
INDIRI4
ASGNI4
line 856
;856:		BG_PlayerStateToEntityState( ps, &t->s, qtrue );
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 0
INDIRP4
ARGP4
CNSTI4 1
ARGI4
ADDRGP4 BG_PlayerStateToEntityState
CALLV
pop
line 857
;857:		t->s.number = number;
ADDRLP4 0
INDIRP4
ADDRLP4 16
INDIRI4
ASGNI4
line 858
;858:		t->s.eType = ET_EVENTS + event;
ADDRLP4 0
INDIRP4
CNSTI4 4
ADDP4
ADDRLP4 4
INDIRI4
CNSTI4 17
ADDI4
ASGNI4
line 859
;859:		t->s.eFlags |= EF_PLAYER_EVENT;
ADDRLP4 32
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
ASGNP4
ADDRLP4 32
INDIRP4
ADDRLP4 32
INDIRP4
INDIRI4
CNSTI4 16
BORI4
ASGNI4
line 860
;860:		t->s.otherEntityNum = ps->clientNum;
ADDRLP4 0
INDIRP4
CNSTI4 184
ADDP4
ADDRFP4 0
INDIRP4
CNSTI4 144
ADDP4
INDIRI4
ASGNI4
line 862
;861:		// send to everyone except the client who generated the event
;862:		t->r.svFlags |= SVF_NOTSINGLECLIENT;
ADDRLP4 36
ADDRLP4 0
INDIRP4
CNSTI4 304
ADDP4
ASGNP4
ADDRLP4 36
INDIRP4
ADDRLP4 36
INDIRP4
INDIRI4
CNSTI4 2048
BORI4
ASGNI4
line 863
;863:		t->r.singleClient = ps->clientNum;
ADDRLP4 0
INDIRP4
CNSTI4 308
ADDP4
ADDRFP4 0
INDIRP4
CNSTI4 144
ADDP4
INDIRI4
ASGNI4
line 865
;864:		// set back external event
;865:		ps->externalEvent = extEvent;
ADDRFP4 0
INDIRP4
CNSTI4 132
ADDP4
ADDRLP4 12
INDIRI4
ASGNI4
line 866
;866:	}
LABELV $409
line 867
;867:}
LABELV $408
endproc SendPendingPredictableEvents 40 12
proc G_UpdateForceSightBroadcasts 72 12
line 887
;868:
;869:extern int saberOffSound;
;870:extern int saberOnSound;
;871:
;872:/*
;873:==================
;874:G_UpdateClientBroadcasts
;875:
;876:Determines whether this client should be broadcast to any other clients.  
;877:A client is broadcast when another client is using force sight or is
;878:==================
;879:*/
;880:#define MAX_JEDIMASTER_DISTANCE	2500
;881:#define MAX_JEDIMASTER_FOV		100
;882:
;883:#define MAX_SIGHT_DISTANCE		1500
;884:#define MAX_SIGHT_FOV			100
;885:
;886:static void G_UpdateForceSightBroadcasts ( gentity_t *self )
;887:{
line 891
;888:	int i;
;889:
;890:	// Any clients with force sight on should see this client
;891:	for ( i = 0; i < level.numConnectedClients; i ++ )
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 $415
JUMPV
LABELV $412
line 892
;892:	{
line 893
;893:		gentity_t *ent = &g_entities[level.sortedClients[i]];
ADDRLP4 4
CNSTI4 828
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 level+84
ADDP4
INDIRI4
MULI4
ADDRGP4 g_entities
ADDP4
ASGNP4
line 897
;894:		float	  dist;
;895:		vec3_t	  angles;
;896:	
;897:		if ( ent == self )
ADDRLP4 4
INDIRP4
CVPU4 4
ADDRFP4 0
INDIRP4
CVPU4 4
NEU4 $418
line 898
;898:		{
line 899
;899:			continue;
ADDRGP4 $413
JUMPV
LABELV $418
line 903
;900:		}
;901:
;902:		// Not using force sight so we shouldnt broadcast to this one
;903:		if ( !(ent->client->ps.fd.forcePowersActive & (1<<FP_SEE) ) )
ADDRLP4 4
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 848
ADDP4
INDIRI4
CNSTI4 16384
BANDI4
CNSTI4 0
NEI4 $420
line 904
;904:		{
line 905
;905:			continue;
ADDRGP4 $413
JUMPV
LABELV $420
line 908
;906:		}
;907:
;908:		VectorSubtract( self->client->ps.origin, ent->client->ps.origin, angles );
ADDRLP4 24
CNSTI4 408
ASGNI4
ADDRLP4 28
ADDRFP4 0
INDIRP4
ADDRLP4 24
INDIRI4
ADDP4
ASGNP4
ADDRLP4 32
CNSTI4 20
ASGNI4
ADDRLP4 36
ADDRLP4 4
INDIRP4
ADDRLP4 24
INDIRI4
ADDP4
ASGNP4
ADDRLP4 8
ADDRLP4 28
INDIRP4
INDIRP4
ADDRLP4 32
INDIRI4
ADDP4
INDIRF4
ADDRLP4 36
INDIRP4
INDIRP4
ADDRLP4 32
INDIRI4
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 40
CNSTI4 24
ASGNI4
ADDRLP4 8+4
ADDRLP4 28
INDIRP4
INDIRP4
ADDRLP4 40
INDIRI4
ADDP4
INDIRF4
ADDRLP4 36
INDIRP4
INDIRP4
ADDRLP4 40
INDIRI4
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 44
CNSTI4 408
ASGNI4
ADDRLP4 48
CNSTI4 28
ASGNI4
ADDRLP4 8+8
ADDRFP4 0
INDIRP4
ADDRLP4 44
INDIRI4
ADDP4
INDIRP4
ADDRLP4 48
INDIRI4
ADDP4
INDIRF4
ADDRLP4 4
INDIRP4
ADDRLP4 44
INDIRI4
ADDP4
INDIRP4
ADDRLP4 48
INDIRI4
ADDP4
INDIRF4
SUBF4
ASGNF4
line 909
;909:		dist = VectorLengthSquared ( angles );
ADDRLP4 8
ARGP4
ADDRLP4 52
ADDRGP4 VectorLengthSquared
CALLF4
ASGNF4
ADDRLP4 20
ADDRLP4 52
INDIRF4
ASGNF4
line 910
;910:		vectoangles ( angles, angles );
ADDRLP4 8
ARGP4
ADDRLP4 8
ARGP4
ADDRGP4 vectoangles
CALLV
pop
line 913
;911:
;912:		// Too far away then just forget it
;913:		if ( dist > MAX_SIGHT_DISTANCE * MAX_SIGHT_DISTANCE )
ADDRLP4 20
INDIRF4
CNSTF4 1242125376
LEF4 $424
line 914
;914:		{
line 915
;915:			continue;
ADDRGP4 $413
JUMPV
LABELV $424
line 919
;916:		}
;917:		
;918:		// If not within the field of view then forget it
;919:		if ( !InFieldOfVision ( ent->client->ps.viewangles, MAX_SIGHT_FOV, angles ) )
ADDRLP4 4
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 156
ADDP4
ARGP4
CNSTF4 1120403456
ARGF4
ADDRLP4 8
ARGP4
ADDRLP4 56
ADDRGP4 InFieldOfVision
CALLI4
ASGNI4
ADDRLP4 56
INDIRI4
CNSTI4 0
NEI4 $426
line 920
;920:		{
line 921
;921:			break;
ADDRGP4 $414
JUMPV
LABELV $426
line 926
;922:		}
;923:
;924:		// Turn on the broadcast bit for the master and since there is only one
;925:		// master we are done
;926:		self->r.broadcastClients[ent->s.clientNum/32] |= (1 << (ent->s.clientNum%32));
ADDRLP4 60
ADDRLP4 4
INDIRP4
CNSTI4 220
ADDP4
INDIRI4
ASGNI4
ADDRLP4 64
CNSTI4 32
ASGNI4
ADDRLP4 68
ADDRLP4 60
INDIRI4
ADDRLP4 64
INDIRI4
DIVI4
CNSTI4 2
LSHI4
ADDRFP4 0
INDIRP4
CNSTI4 400
ADDP4
ADDP4
ASGNP4
ADDRLP4 68
INDIRP4
ADDRLP4 68
INDIRP4
INDIRI4
CNSTI4 1
ADDRLP4 60
INDIRI4
ADDRLP4 64
INDIRI4
MODI4
LSHI4
BORI4
ASGNI4
line 928
;927:	
;928:		break;
ADDRGP4 $414
JUMPV
LABELV $413
line 891
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $415
ADDRLP4 0
INDIRI4
ADDRGP4 level+72
INDIRI4
LTI4 $412
LABELV $414
line 930
;929:	}
;930:}
LABELV $411
endproc G_UpdateForceSightBroadcasts 72 12
proc G_UpdateJediMasterBroadcasts 72 12
line 933
;931:
;932:static void G_UpdateJediMasterBroadcasts ( gentity_t *self )
;933:{
line 937
;934:	int i;
;935:
;936:	// Not jedi master mode then nothing to do
;937:	if ( g_gametype.integer != GT_JEDIMASTER )
ADDRGP4 g_gametype+12
INDIRI4
CNSTI4 2
EQI4 $429
line 938
;938:	{
line 939
;939:		return;
ADDRGP4 $428
JUMPV
LABELV $429
line 943
;940:	}
;941:
;942:	// This client isnt the jedi master so it shouldnt broadcast
;943:	if ( !self->client->ps.isJediMaster )
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 604
ADDP4
INDIRI4
CNSTI4 0
NEI4 $432
line 944
;944:	{
line 945
;945:		return;
ADDRGP4 $428
JUMPV
LABELV $432
line 949
;946:	}
;947:
;948:	// Broadcast ourself to all clients within range
;949:	for ( i = 0; i < level.numConnectedClients; i ++ )
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 $437
JUMPV
LABELV $434
line 950
;950:	{
line 951
;951:		gentity_t *ent = &g_entities[level.sortedClients[i]];
ADDRLP4 4
CNSTI4 828
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 level+84
ADDP4
INDIRI4
MULI4
ADDRGP4 g_entities
ADDP4
ASGNP4
line 955
;952:		float	  dist;
;953:		vec3_t	  angles;
;954:
;955:		if ( ent == self )
ADDRLP4 4
INDIRP4
CVPU4 4
ADDRFP4 0
INDIRP4
CVPU4 4
NEU4 $440
line 956
;956:		{
line 957
;957:			continue;
ADDRGP4 $435
JUMPV
LABELV $440
line 960
;958:		}
;959:
;960:		VectorSubtract( self->client->ps.origin, ent->client->ps.origin, angles );
ADDRLP4 24
CNSTI4 408
ASGNI4
ADDRLP4 28
ADDRFP4 0
INDIRP4
ADDRLP4 24
INDIRI4
ADDP4
ASGNP4
ADDRLP4 32
CNSTI4 20
ASGNI4
ADDRLP4 36
ADDRLP4 4
INDIRP4
ADDRLP4 24
INDIRI4
ADDP4
ASGNP4
ADDRLP4 8
ADDRLP4 28
INDIRP4
INDIRP4
ADDRLP4 32
INDIRI4
ADDP4
INDIRF4
ADDRLP4 36
INDIRP4
INDIRP4
ADDRLP4 32
INDIRI4
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 40
CNSTI4 24
ASGNI4
ADDRLP4 8+4
ADDRLP4 28
INDIRP4
INDIRP4
ADDRLP4 40
INDIRI4
ADDP4
INDIRF4
ADDRLP4 36
INDIRP4
INDIRP4
ADDRLP4 40
INDIRI4
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 44
CNSTI4 408
ASGNI4
ADDRLP4 48
CNSTI4 28
ASGNI4
ADDRLP4 8+8
ADDRFP4 0
INDIRP4
ADDRLP4 44
INDIRI4
ADDP4
INDIRP4
ADDRLP4 48
INDIRI4
ADDP4
INDIRF4
ADDRLP4 4
INDIRP4
ADDRLP4 44
INDIRI4
ADDP4
INDIRP4
ADDRLP4 48
INDIRI4
ADDP4
INDIRF4
SUBF4
ASGNF4
line 961
;961:		dist = VectorLengthSquared ( angles );
ADDRLP4 8
ARGP4
ADDRLP4 52
ADDRGP4 VectorLengthSquared
CALLF4
ASGNF4
ADDRLP4 20
ADDRLP4 52
INDIRF4
ASGNF4
line 962
;962:		vectoangles ( angles, angles );
ADDRLP4 8
ARGP4
ADDRLP4 8
ARGP4
ADDRGP4 vectoangles
CALLV
pop
line 965
;963:
;964:		// Too far away then just forget it
;965:		if ( dist > MAX_JEDIMASTER_DISTANCE * MAX_JEDIMASTER_DISTANCE )
ADDRLP4 20
INDIRF4
CNSTF4 1254013984
LEF4 $444
line 966
;966:		{
line 967
;967:			continue;
ADDRGP4 $435
JUMPV
LABELV $444
line 971
;968:		}
;969:		
;970:		// If not within the field of view then forget it
;971:		if ( !InFieldOfVision ( ent->client->ps.viewangles, MAX_JEDIMASTER_FOV, angles ) )
ADDRLP4 4
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 156
ADDP4
ARGP4
CNSTF4 1120403456
ARGF4
ADDRLP4 8
ARGP4
ADDRLP4 56
ADDRGP4 InFieldOfVision
CALLI4
ASGNI4
ADDRLP4 56
INDIRI4
CNSTI4 0
NEI4 $446
line 972
;972:		{
line 973
;973:			continue;
ADDRGP4 $435
JUMPV
LABELV $446
line 978
;974:		}
;975:
;976:		// Turn on the broadcast bit for the master and since there is only one
;977:		// master we are done
;978:		self->r.broadcastClients[ent->s.clientNum/32] |= (1 << (ent->s.clientNum%32));
ADDRLP4 60
ADDRLP4 4
INDIRP4
CNSTI4 220
ADDP4
INDIRI4
ASGNI4
ADDRLP4 64
CNSTI4 32
ASGNI4
ADDRLP4 68
ADDRLP4 60
INDIRI4
ADDRLP4 64
INDIRI4
DIVI4
CNSTI4 2
LSHI4
ADDRFP4 0
INDIRP4
CNSTI4 400
ADDP4
ADDP4
ASGNP4
ADDRLP4 68
INDIRP4
ADDRLP4 68
INDIRP4
INDIRI4
CNSTI4 1
ADDRLP4 60
INDIRI4
ADDRLP4 64
INDIRI4
MODI4
LSHI4
BORI4
ASGNI4
line 979
;979:	}
LABELV $435
line 949
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $437
ADDRLP4 0
INDIRI4
ADDRGP4 level+72
INDIRI4
LTI4 $434
line 980
;980:}
LABELV $428
endproc G_UpdateJediMasterBroadcasts 72 12
export G_UpdateClientBroadcasts
proc G_UpdateClientBroadcasts 0 12
line 983
;981:
;982:void G_UpdateClientBroadcasts ( gentity_t *self )
;983:{
line 985
;984:	// Clear all the broadcast bits for this client
;985:	memset ( self->r.broadcastClients, 0, sizeof ( self->r.broadcastClients ) );
ADDRFP4 0
INDIRP4
CNSTI4 400
ADDP4
ARGP4
CNSTI4 0
ARGI4
CNSTI4 8
ARGI4
ADDRGP4 memset
CALLP4
pop
line 988
;986:
;987:	// The jedi master is broadcast to everyone in range
;988:	G_UpdateJediMasterBroadcasts ( self );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 G_UpdateJediMasterBroadcasts
CALLV
pop
line 991
;989:
;990:	// Anyone with force sight on should see this client
;991:	G_UpdateForceSightBroadcasts ( self );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 G_UpdateForceSightBroadcasts
CALLV
pop
line 992
;992:}
LABELV $448
endproc G_UpdateClientBroadcasts 0 12
export ClientThink_real
proc ClientThink_real 600 32
line 1005
;993:
;994:/*
;995:==============
;996:ClientThink
;997:
;998:This will be called once for each client frame, which will
;999:usually be a couple times for each server frame on fast clients.
;1000:
;1001:If "g_synchronousClients 1" is set, this will be called exactly
;1002:once for each server frame, which makes for smooth demo recording.
;1003:==============
;1004:*/
;1005:void ClientThink_real( gentity_t *ent ) {
line 1014
;1006:	gclient_t	*client;
;1007:	pmove_t		pm;
;1008:	int			oldEventSequence;
;1009:	int			msec;
;1010:	int			i;
;1011:	usercmd_t	*ucmd;
;1012:
;1013:   // adnan
;1014:   quat_t *qrot = NULL;
ADDRLP4 400
CNSTP4 0
ASGNP4
line 1016
;1015:
;1016:	client = ent->client;
ADDRLP4 4
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
ASGNP4
line 1019
;1017:
;1018:	// don't think if the client is not yet connected (and thus not yet spawned in)
;1019:	if (client->pers.connected != CON_CONNECTED) {
ADDRLP4 4
INDIRP4
CNSTI4 1380
ADDP4
INDIRI4
CNSTI4 2
EQI4 $450
line 1020
;1020:		return;
ADDRGP4 $449
JUMPV
LABELV $450
line 1023
;1021:	}
;1022:	// mark the time, so the connection sprite can be removed
;1023:	ucmd = &ent->client->pers.cmd;
ADDRLP4 388
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 1384
ADDP4
ASGNP4
line 1026
;1024:
;1025:	// sanity check the command time to prevent speedup cheating
;1026:	if ( ucmd->serverTime > level.time + 200 ) {
ADDRLP4 388
INDIRP4
INDIRI4
ADDRGP4 level+32
INDIRI4
CNSTI4 200
ADDI4
LEI4 $452
line 1027
;1027:		ucmd->serverTime = level.time + 200;
ADDRLP4 388
INDIRP4
ADDRGP4 level+32
INDIRI4
CNSTI4 200
ADDI4
ASGNI4
line 1029
;1028://		G_Printf("serverTime <<<<<\n" );
;1029:	}
LABELV $452
line 1030
;1030:	if ( ucmd->serverTime < level.time - 1000 ) {
ADDRLP4 388
INDIRP4
INDIRI4
ADDRGP4 level+32
INDIRI4
CNSTI4 1000
SUBI4
GEI4 $456
line 1031
;1031:		ucmd->serverTime = level.time - 1000;
ADDRLP4 388
INDIRP4
ADDRGP4 level+32
INDIRI4
CNSTI4 1000
SUBI4
ASGNI4
line 1033
;1032://		G_Printf("serverTime >>>>>\n" );
;1033:	} 
LABELV $456
line 1035
;1034:
;1035:	msec = ucmd->serverTime - client->ps.commandTime;
ADDRLP4 392
ADDRLP4 388
INDIRP4
INDIRI4
ADDRLP4 4
INDIRP4
INDIRI4
SUBI4
ASGNI4
line 1038
;1036:	// following others may result in bad times, but we still want
;1037:	// to check for follow toggles
;1038:	if ( msec < 1 && client->sess.spectatorState != SPECTATOR_FOLLOW ) {
ADDRLP4 392
INDIRI4
CNSTI4 1
GEI4 $460
ADDRLP4 4
INDIRP4
CNSTI4 1544
ADDP4
INDIRI4
CNSTI4 2
EQI4 $460
line 1039
;1039:		return;
ADDRGP4 $449
JUMPV
LABELV $460
line 1041
;1040:	}
;1041:	if ( msec > 200 ) {
ADDRLP4 392
INDIRI4
CNSTI4 200
LEI4 $462
line 1042
;1042:		msec = 200;
ADDRLP4 392
CNSTI4 200
ASGNI4
line 1043
;1043:	}
LABELV $462
line 1045
;1044:
;1045:	if ( pmove_msec.integer < 8 ) {
ADDRGP4 pmove_msec+12
INDIRI4
CNSTI4 8
GEI4 $464
line 1046
;1046:		trap_Cvar_Set("pmove_msec", "8");
ADDRGP4 $467
ARGP4
ADDRGP4 $468
ARGP4
ADDRGP4 trap_Cvar_Set
CALLV
pop
line 1047
;1047:	}
ADDRGP4 $465
JUMPV
LABELV $464
line 1048
;1048:	else if (pmove_msec.integer > 33) {
ADDRGP4 pmove_msec+12
INDIRI4
CNSTI4 33
LEI4 $469
line 1049
;1049:		trap_Cvar_Set("pmove_msec", "33");
ADDRGP4 $467
ARGP4
ADDRGP4 $472
ARGP4
ADDRGP4 trap_Cvar_Set
CALLV
pop
line 1050
;1050:	}
LABELV $469
LABELV $465
line 1052
;1051:
;1052:	if ( pmove_fixed.integer || client->pers.pmoveFixed ) {
ADDRLP4 404
CNSTI4 0
ASGNI4
ADDRGP4 pmove_fixed+12
INDIRI4
ADDRLP4 404
INDIRI4
NEI4 $476
ADDRLP4 4
INDIRP4
CNSTI4 1424
ADDP4
INDIRI4
ADDRLP4 404
INDIRI4
EQI4 $473
LABELV $476
line 1053
;1053:		ucmd->serverTime = ((ucmd->serverTime + pmove_msec.integer-1) / pmove_msec.integer) * pmove_msec.integer;
ADDRLP4 388
INDIRP4
ADDRLP4 388
INDIRP4
INDIRI4
ADDRGP4 pmove_msec+12
INDIRI4
ADDI4
CNSTI4 1
SUBI4
ADDRGP4 pmove_msec+12
INDIRI4
DIVI4
ADDRGP4 pmove_msec+12
INDIRI4
MULI4
ASGNI4
line 1056
;1054:		//if (ucmd->serverTime - client->ps.commandTime <= 0)
;1055:		//	return;
;1056:	}
LABELV $473
line 1061
;1057:
;1058:	//
;1059:	// check for exiting intermission
;1060:	//
;1061:	if ( level.intermissiontime ) {
ADDRGP4 level+9008
INDIRI4
CNSTI4 0
EQI4 $480
line 1062
;1062:		ClientIntermissionThink( client );
ADDRLP4 4
INDIRP4
ARGP4
ADDRGP4 ClientIntermissionThink
CALLV
pop
line 1063
;1063:		return;
ADDRGP4 $449
JUMPV
LABELV $480
line 1067
;1064:	}
;1065:
;1066:	// spectators don't do much
;1067:	if ( client->sess.sessionTeam == TEAM_SPECTATOR ) {
ADDRLP4 4
INDIRP4
CNSTI4 1536
ADDP4
INDIRI4
CNSTI4 3
NEI4 $483
line 1068
;1068:		if ( client->sess.spectatorState == SPECTATOR_SCOREBOARD ) {
ADDRLP4 4
INDIRP4
CNSTI4 1544
ADDP4
INDIRI4
CNSTI4 3
NEI4 $485
line 1069
;1069:			return;
ADDRGP4 $449
JUMPV
LABELV $485
line 1071
;1070:		}
;1071:		SpectatorThink( ent, ucmd );
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 388
INDIRP4
ARGP4
ADDRGP4 SpectatorThink
CALLV
pop
line 1072
;1072:		return;
ADDRGP4 $449
JUMPV
LABELV $483
line 1075
;1073:	}
;1074:
;1075:	if (ent && ent->client && (ent->client->ps.eFlags & EF_INVULNERABLE))
ADDRLP4 408
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 412
CNSTU4 0
ASGNU4
ADDRLP4 408
INDIRP4
CVPU4 4
ADDRLP4 412
INDIRU4
EQU4 $487
ADDRLP4 416
ADDRLP4 408
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
ASGNP4
ADDRLP4 416
INDIRP4
CVPU4 4
ADDRLP4 412
INDIRU4
EQU4 $487
ADDRLP4 416
INDIRP4
CNSTI4 108
ADDP4
INDIRI4
CNSTI4 67108864
BANDI4
CNSTI4 0
EQI4 $487
line 1076
;1076:	{
line 1077
;1077:		if (ent->client->invulnerableTimer <= level.time)
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 1580
ADDP4
INDIRI4
ADDRGP4 level+32
INDIRI4
GTI4 $489
line 1078
;1078:		{
line 1079
;1079:			ent->client->ps.eFlags &= ~EF_INVULNERABLE;
ADDRLP4 420
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 108
ADDP4
ASGNP4
ADDRLP4 420
INDIRP4
ADDRLP4 420
INDIRP4
INDIRI4
CNSTI4 -67108865
BANDI4
ASGNI4
line 1080
;1080:		}
LABELV $489
line 1081
;1081:	}
LABELV $487
line 1084
;1082:
;1083:	// check for inactivity timer, but never drop the local client of a non-dedicated server
;1084:	if ( !ClientInactivityTimer( client ) ) {
ADDRLP4 4
INDIRP4
ARGP4
ADDRLP4 420
ADDRGP4 ClientInactivityTimer
CALLI4
ASGNI4
ADDRLP4 420
INDIRI4
CNSTI4 0
NEI4 $492
line 1085
;1085:		return;
ADDRGP4 $449
JUMPV
LABELV $492
line 1089
;1086:	}
;1087:
;1088:	// clear the rewards if time
;1089:	if ( level.time > client->rewardTime ) {
ADDRGP4 level+32
INDIRI4
ADDRLP4 4
INDIRP4
CNSTI4 1700
ADDP4
INDIRI4
LEI4 $494
line 1090
;1090:		client->ps.eFlags &= ~(EF_AWARD_IMPRESSIVE | EF_AWARD_EXCELLENT | EF_AWARD_GAUNTLET | EF_AWARD_ASSIST | EF_AWARD_DEFEND | EF_AWARD_CAP );
ADDRLP4 424
ADDRLP4 4
INDIRP4
CNSTI4 108
ADDP4
ASGNP4
ADDRLP4 424
INDIRP4
ADDRLP4 424
INDIRP4
INDIRI4
CNSTI4 -231497
BANDI4
ASGNI4
line 1091
;1091:	}
LABELV $494
line 1093
;1092:
;1093:	if ( client->noclip ) {
ADDRLP4 4
INDIRP4
CNSTI4 1592
ADDP4
INDIRI4
CNSTI4 0
EQI4 $497
line 1094
;1094:		client->ps.pm_type = PM_NOCLIP;
ADDRLP4 4
INDIRP4
CNSTI4 4
ADDP4
CNSTI4 2
ASGNI4
line 1095
;1095:	} else if ( client->ps.eFlags & EF_DISINTEGRATION ) {
ADDRGP4 $498
JUMPV
LABELV $497
ADDRLP4 4
INDIRP4
CNSTI4 108
ADDP4
INDIRI4
CNSTI4 33554432
BANDI4
CNSTI4 0
EQI4 $499
line 1096
;1096:		client->ps.pm_type = PM_NOCLIP;
ADDRLP4 4
INDIRP4
CNSTI4 4
ADDP4
CNSTI4 2
ASGNI4
line 1097
;1097:	} else if ( client->ps.stats[STAT_HEALTH] <= 0 ) {
ADDRGP4 $500
JUMPV
LABELV $499
ADDRLP4 4
INDIRP4
CNSTI4 216
ADDP4
INDIRI4
CNSTI4 0
GTI4 $501
line 1098
;1098:		client->ps.pm_type = PM_DEAD;
ADDRLP4 424
CNSTI4 4
ASGNI4
ADDRLP4 4
INDIRP4
ADDRLP4 424
INDIRI4
ADDP4
ADDRLP4 424
INDIRI4
ASGNI4
line 1099
;1099:	} else {
ADDRGP4 $502
JUMPV
LABELV $501
line 1100
;1100:		if (client->ps.forceGripChangeMovetype)
ADDRLP4 4
INDIRP4
CNSTI4 1288
ADDP4
INDIRI4
CNSTI4 0
EQI4 $503
line 1101
;1101:		{
line 1102
;1102:			client->ps.pm_type = client->ps.forceGripChangeMovetype;
ADDRLP4 4
INDIRP4
CNSTI4 4
ADDP4
ADDRLP4 4
INDIRP4
CNSTI4 1288
ADDP4
INDIRI4
ASGNI4
line 1103
;1103:		}
ADDRGP4 $504
JUMPV
LABELV $503
line 1105
;1104:		else
;1105:		{
line 1106
;1106:			client->ps.pm_type = PM_NORMAL;
ADDRLP4 4
INDIRP4
CNSTI4 4
ADDP4
CNSTI4 0
ASGNI4
line 1107
;1107:		}
LABELV $504
line 1108
;1108:	}
LABELV $502
LABELV $500
LABELV $498
line 1110
;1109:
;1110:	client->ps.gravity = g_gravity.value;
ADDRLP4 4
INDIRP4
CNSTI4 56
ADDP4
ADDRGP4 g_gravity+8
INDIRF4
CVFI4 4
ASGNI4
line 1113
;1111:
;1112:	// set speed
;1113:	client->ps.speed = g_speed.value;
ADDRLP4 4
INDIRP4
CNSTI4 60
ADDP4
ADDRGP4 g_speed+8
INDIRF4
CVFI4 4
ASGNI4
line 1114
;1114:	client->ps.basespeed = g_speed.value;
ADDRLP4 4
INDIRP4
CNSTI4 64
ADDP4
ADDRGP4 g_speed+8
INDIRF4
CVFI4 4
ASGNI4
line 1116
;1115:
;1116:	if (ent->client->ps.duelInProgress)
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 1304
ADDP4
INDIRI4
CNSTI4 0
EQI4 $508
line 1117
;1117:	{
line 1118
;1118:		gentity_t *duelAgainst = &g_entities[ent->client->ps.duelIndex];
ADDRLP4 424
CNSTI4 828
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 1296
ADDP4
INDIRI4
MULI4
ADDRGP4 g_entities
ADDP4
ASGNP4
line 1123
;1119:
;1120:		//Keep the time updated, so once this duel ends this player can't engage in a duel for another
;1121:		//10 seconds. This will give other people a chance to engage in duels in case this player wants
;1122:		//to engage again right after he's done fighting and someone else is waiting.
;1123:		ent->client->ps.fd.privateDuelTime = level.time + 10000;
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 1240
ADDP4
ADDRGP4 level+32
INDIRI4
CNSTI4 10000
ADDI4
ASGNI4
line 1125
;1124:
;1125:		if (ent->client->ps.duelTime < level.time)
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 1300
ADDP4
INDIRI4
ADDRGP4 level+32
INDIRI4
GEI4 $511
line 1126
;1126:		{
line 1128
;1127:			//Bring out the sabers
;1128:			if (ent->client->ps.weapon == WP_SABER && ent->client->ps.saberHolstered &&
ADDRLP4 428
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
ASGNP4
ADDRLP4 428
INDIRP4
CNSTI4 148
ADDP4
INDIRI4
CNSTI4 2
NEI4 $514
ADDRLP4 432
CNSTI4 0
ASGNI4
ADDRLP4 428
INDIRP4
CNSTI4 1312
ADDP4
INDIRI4
ADDRLP4 432
INDIRI4
EQI4 $514
ADDRLP4 428
INDIRP4
CNSTI4 1300
ADDP4
INDIRI4
ADDRLP4 432
INDIRI4
EQI4 $514
line 1130
;1129:				ent->client->ps.duelTime)
;1130:			{
line 1131
;1131:				if (!saberOffSound || !saberOnSound)
ADDRLP4 436
CNSTI4 0
ASGNI4
ADDRGP4 saberOffSound
INDIRI4
ADDRLP4 436
INDIRI4
EQI4 $518
ADDRGP4 saberOnSound
INDIRI4
ADDRLP4 436
INDIRI4
NEI4 $516
LABELV $518
line 1132
;1132:				{
line 1133
;1133:					saberOffSound = G_SoundIndex("sound/weapons/saber/saberoffquick.wav");
ADDRGP4 $519
ARGP4
ADDRLP4 440
ADDRGP4 G_SoundIndex
CALLI4
ASGNI4
ADDRGP4 saberOffSound
ADDRLP4 440
INDIRI4
ASGNI4
line 1134
;1134:					saberOnSound = G_SoundIndex("sound/weapons/saber/saberon.wav");
ADDRGP4 $520
ARGP4
ADDRLP4 444
ADDRGP4 G_SoundIndex
CALLI4
ASGNI4
ADDRGP4 saberOnSound
ADDRLP4 444
INDIRI4
ASGNI4
line 1135
;1135:				}
LABELV $516
line 1137
;1136:
;1137:				ent->client->ps.saberHolstered = qfalse;
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 1312
ADDP4
CNSTI4 0
ASGNI4
line 1138
;1138:				G_Sound(ent, CHAN_AUTO, saberOnSound);
ADDRFP4 0
INDIRP4
ARGP4
CNSTI4 0
ARGI4
ADDRGP4 saberOnSound
INDIRI4
ARGI4
ADDRGP4 G_Sound
CALLV
pop
line 1140
;1139:
;1140:				G_AddEvent(ent, EV_PRIVATE_DUEL, 2);
ADDRFP4 0
INDIRP4
ARGP4
CNSTI4 13
ARGI4
CNSTI4 2
ARGI4
ADDRGP4 G_AddEvent
CALLV
pop
line 1142
;1141:
;1142:				ent->client->ps.duelTime = 0;
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 1300
ADDP4
CNSTI4 0
ASGNI4
line 1143
;1143:			}
LABELV $514
line 1145
;1144:
;1145:			if (duelAgainst && duelAgainst->client && duelAgainst->inuse &&
ADDRLP4 440
CNSTU4 0
ASGNU4
ADDRLP4 424
INDIRP4
CVPU4 4
ADDRLP4 440
INDIRU4
EQU4 $512
ADDRLP4 444
ADDRLP4 424
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
ASGNP4
ADDRLP4 444
INDIRP4
CVPU4 4
ADDRLP4 440
INDIRU4
EQU4 $512
ADDRLP4 448
CNSTI4 0
ASGNI4
ADDRLP4 424
INDIRP4
CNSTI4 412
ADDP4
INDIRI4
ADDRLP4 448
INDIRI4
EQI4 $512
ADDRLP4 444
INDIRP4
CNSTI4 148
ADDP4
INDIRI4
CNSTI4 2
NEI4 $512
ADDRLP4 444
INDIRP4
CNSTI4 1312
ADDP4
INDIRI4
ADDRLP4 448
INDIRI4
EQI4 $512
ADDRLP4 444
INDIRP4
CNSTI4 1300
ADDP4
INDIRI4
ADDRLP4 448
INDIRI4
EQI4 $512
line 1148
;1146:				duelAgainst->client->ps.weapon == WP_SABER && duelAgainst->client->ps.saberHolstered &&
;1147:				duelAgainst->client->ps.duelTime)
;1148:			{
line 1149
;1149:				if (!saberOffSound || !saberOnSound)
ADDRLP4 452
CNSTI4 0
ASGNI4
ADDRGP4 saberOffSound
INDIRI4
ADDRLP4 452
INDIRI4
EQI4 $525
ADDRGP4 saberOnSound
INDIRI4
ADDRLP4 452
INDIRI4
NEI4 $523
LABELV $525
line 1150
;1150:				{
line 1151
;1151:					saberOffSound = G_SoundIndex("sound/weapons/saber/saberoffquick.wav");
ADDRGP4 $519
ARGP4
ADDRLP4 456
ADDRGP4 G_SoundIndex
CALLI4
ASGNI4
ADDRGP4 saberOffSound
ADDRLP4 456
INDIRI4
ASGNI4
line 1152
;1152:					saberOnSound = G_SoundIndex("sound/weapons/saber/saberon.wav");
ADDRGP4 $520
ARGP4
ADDRLP4 460
ADDRGP4 G_SoundIndex
CALLI4
ASGNI4
ADDRGP4 saberOnSound
ADDRLP4 460
INDIRI4
ASGNI4
line 1153
;1153:				}
LABELV $523
line 1155
;1154:
;1155:				duelAgainst->client->ps.saberHolstered = qfalse;
ADDRLP4 424
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 1312
ADDP4
CNSTI4 0
ASGNI4
line 1156
;1156:				G_Sound(duelAgainst, CHAN_AUTO, saberOnSound);
ADDRLP4 424
INDIRP4
ARGP4
CNSTI4 0
ARGI4
ADDRGP4 saberOnSound
INDIRI4
ARGI4
ADDRGP4 G_Sound
CALLV
pop
line 1158
;1157:
;1158:				G_AddEvent(duelAgainst, EV_PRIVATE_DUEL, 2);
ADDRLP4 424
INDIRP4
ARGP4
CNSTI4 13
ARGI4
CNSTI4 2
ARGI4
ADDRGP4 G_AddEvent
CALLV
pop
line 1160
;1159:
;1160:				duelAgainst->client->ps.duelTime = 0;
ADDRLP4 424
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 1300
ADDP4
CNSTI4 0
ASGNI4
line 1161
;1161:			}
line 1162
;1162:		}
ADDRGP4 $512
JUMPV
LABELV $511
line 1164
;1163:		else
;1164:		{
line 1165
;1165:			client->ps.speed = 0;
ADDRLP4 4
INDIRP4
CNSTI4 60
ADDP4
CNSTI4 0
ASGNI4
line 1166
;1166:			client->ps.basespeed = 0;
ADDRLP4 4
INDIRP4
CNSTI4 64
ADDP4
CNSTI4 0
ASGNI4
line 1167
;1167:			ucmd->forwardmove = 0;
ADDRLP4 388
INDIRP4
CNSTI4 24
ADDP4
CNSTI1 0
ASGNI1
line 1168
;1168:			ucmd->rightmove = 0;
ADDRLP4 388
INDIRP4
CNSTI4 25
ADDP4
CNSTI1 0
ASGNI1
line 1169
;1169:			ucmd->upmove = 0;
ADDRLP4 388
INDIRP4
CNSTI4 26
ADDP4
CNSTI1 0
ASGNI1
line 1170
;1170:		}
LABELV $512
line 1172
;1171:
;1172:		if (!duelAgainst || !duelAgainst->client || !duelAgainst->inuse ||
ADDRLP4 432
CNSTU4 0
ASGNU4
ADDRLP4 424
INDIRP4
CVPU4 4
ADDRLP4 432
INDIRU4
EQU4 $530
ADDRLP4 436
ADDRLP4 424
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
ASGNP4
ADDRLP4 436
INDIRP4
CVPU4 4
ADDRLP4 432
INDIRU4
EQU4 $530
ADDRLP4 424
INDIRP4
CNSTI4 412
ADDP4
INDIRI4
CNSTI4 0
EQI4 $530
ADDRLP4 436
INDIRP4
CNSTI4 1296
ADDP4
INDIRI4
ADDRFP4 0
INDIRP4
INDIRI4
EQI4 $526
LABELV $530
line 1174
;1173:			duelAgainst->client->ps.duelIndex != ent->s.number)
;1174:		{
line 1175
;1175:			ent->client->ps.duelInProgress = 0;
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 1304
ADDP4
CNSTI4 0
ASGNI4
line 1176
;1176:			G_AddEvent(ent, EV_PRIVATE_DUEL, 0);
ADDRFP4 0
INDIRP4
ARGP4
CNSTI4 13
ARGI4
CNSTI4 0
ARGI4
ADDRGP4 G_AddEvent
CALLV
pop
line 1177
;1177:		}
ADDRGP4 $527
JUMPV
LABELV $526
line 1178
;1178:		else if (duelAgainst->health < 1 || duelAgainst->client->ps.stats[STAT_HEALTH] < 1)
ADDRLP4 444
CNSTI4 1
ASGNI4
ADDRLP4 424
INDIRP4
CNSTI4 676
ADDP4
INDIRI4
ADDRLP4 444
INDIRI4
LTI4 $533
ADDRLP4 424
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 216
ADDP4
INDIRI4
ADDRLP4 444
INDIRI4
GEI4 $531
LABELV $533
line 1179
;1179:		{
line 1180
;1180:			ent->client->ps.duelInProgress = 0;
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 1304
ADDP4
CNSTI4 0
ASGNI4
line 1181
;1181:			duelAgainst->client->ps.duelInProgress = 0;
ADDRLP4 424
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 1304
ADDP4
CNSTI4 0
ASGNI4
line 1183
;1182:
;1183:			G_AddEvent(ent, EV_PRIVATE_DUEL, 0);
ADDRFP4 0
INDIRP4
ARGP4
CNSTI4 13
ARGI4
CNSTI4 0
ARGI4
ADDRGP4 G_AddEvent
CALLV
pop
line 1184
;1184:			G_AddEvent(duelAgainst, EV_PRIVATE_DUEL, 0);
ADDRLP4 424
INDIRP4
ARGP4
CNSTI4 13
ARGI4
CNSTI4 0
ARGI4
ADDRGP4 G_AddEvent
CALLV
pop
line 1187
;1185:
;1186:			//Winner gets full health.. providing he's still alive
;1187:			if (ent->health > 0 && ent->client->ps.stats[STAT_HEALTH] > 0)
ADDRLP4 448
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 452
CNSTI4 0
ASGNI4
ADDRLP4 448
INDIRP4
CNSTI4 676
ADDP4
INDIRI4
ADDRLP4 452
INDIRI4
LEI4 $534
ADDRLP4 448
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 216
ADDP4
INDIRI4
ADDRLP4 452
INDIRI4
LEI4 $534
line 1188
;1188:			{
line 1189
;1189:				if (ent->health < ent->client->ps.stats[STAT_MAX_HEALTH])
ADDRLP4 456
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 456
INDIRP4
CNSTI4 676
ADDP4
INDIRI4
ADDRLP4 456
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 248
ADDP4
INDIRI4
GEI4 $536
line 1190
;1190:				{
line 1191
;1191:					ent->client->ps.stats[STAT_HEALTH] = ent->health = ent->client->ps.stats[STAT_MAX_HEALTH];
ADDRLP4 460
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 464
ADDRLP4 460
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
ASGNP4
ADDRLP4 468
ADDRLP4 464
INDIRP4
CNSTI4 248
ADDP4
INDIRI4
ASGNI4
ADDRLP4 460
INDIRP4
CNSTI4 676
ADDP4
ADDRLP4 468
INDIRI4
ASGNI4
ADDRLP4 464
INDIRP4
CNSTI4 216
ADDP4
ADDRLP4 468
INDIRI4
ASGNI4
line 1192
;1192:				}
LABELV $536
line 1194
;1193:
;1194:				if (g_spawnInvulnerability.integer)
ADDRGP4 g_spawnInvulnerability+12
INDIRI4
CNSTI4 0
EQI4 $538
line 1195
;1195:				{
line 1196
;1196:					ent->client->ps.eFlags |= EF_INVULNERABLE;
ADDRLP4 460
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 108
ADDP4
ASGNP4
ADDRLP4 460
INDIRP4
ADDRLP4 460
INDIRP4
INDIRI4
CNSTI4 67108864
BORI4
ASGNI4
line 1197
;1197:					ent->client->invulnerableTimer = level.time + g_spawnInvulnerability.integer;
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 1580
ADDP4
ADDRGP4 level+32
INDIRI4
ADDRGP4 g_spawnInvulnerability+12
INDIRI4
ADDI4
ASGNI4
line 1198
;1198:				}
LABELV $538
line 1199
;1199:			}
LABELV $534
line 1206
;1200:
;1201:			/*
;1202:			trap_SendServerCommand( ent-g_entities, va("print \"%s %s\n\"", ent->client->pers.netname, G_GetStripEdString("SVINGAME", "PLDUELWINNER")) );
;1203:			trap_SendServerCommand( duelAgainst-g_entities, va("print \"%s %s\n\"", ent->client->pers.netname, G_GetStripEdString("SVINGAME", "PLDUELWINNER")) );
;1204:			*/
;1205:			//Private duel announcements are now made globally because we only want one duel at a time.
;1206:			if (ent->health > 0 && ent->client->ps.stats[STAT_HEALTH] > 0)
ADDRLP4 456
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 460
CNSTI4 0
ASGNI4
ADDRLP4 456
INDIRP4
CNSTI4 676
ADDP4
INDIRI4
ADDRLP4 460
INDIRI4
LEI4 $543
ADDRLP4 456
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 216
ADDP4
INDIRI4
ADDRLP4 460
INDIRI4
LEI4 $543
line 1207
;1207:			{
line 1208
;1208:				trap_SendServerCommand( -1, va("cp \"%s %s %s!\n\"", ent->client->pers.netname, G_GetStripEdString("SVINGAME", "PLDUELWINNER"), duelAgainst->client->pers.netname) );
ADDRGP4 $546
ARGP4
ADDRGP4 $547
ARGP4
ADDRLP4 464
ADDRGP4 G_GetStripEdString
CALLP4
ASGNP4
ADDRGP4 $545
ARGP4
ADDRLP4 468
CNSTI4 408
ASGNI4
ADDRLP4 472
CNSTI4 1428
ASGNI4
ADDRFP4 0
INDIRP4
ADDRLP4 468
INDIRI4
ADDP4
INDIRP4
ADDRLP4 472
INDIRI4
ADDP4
ARGP4
ADDRLP4 464
INDIRP4
ARGP4
ADDRLP4 424
INDIRP4
ADDRLP4 468
INDIRI4
ADDP4
INDIRP4
ADDRLP4 472
INDIRI4
ADDP4
ARGP4
ADDRLP4 476
ADDRGP4 va
CALLP4
ASGNP4
CNSTI4 -1
ARGI4
ADDRLP4 476
INDIRP4
ARGP4
ADDRGP4 trap_SendServerCommand
CALLV
pop
line 1209
;1209:			}
ADDRGP4 $532
JUMPV
LABELV $543
line 1211
;1210:			else
;1211:			{ //it was a draw, because we both managed to die in the same frame
line 1212
;1212:				trap_SendServerCommand( -1, va("cp \"%s\n\"", G_GetStripEdString("SVINGAME", "PLDUELTIE")) );
ADDRGP4 $546
ARGP4
ADDRGP4 $549
ARGP4
ADDRLP4 464
ADDRGP4 G_GetStripEdString
CALLP4
ASGNP4
ADDRGP4 $548
ARGP4
ADDRLP4 464
INDIRP4
ARGP4
ADDRLP4 468
ADDRGP4 va
CALLP4
ASGNP4
CNSTI4 -1
ARGI4
ADDRLP4 468
INDIRP4
ARGP4
ADDRGP4 trap_SendServerCommand
CALLV
pop
line 1213
;1213:			}
line 1214
;1214:		}
ADDRGP4 $532
JUMPV
LABELV $531
line 1216
;1215:		else
;1216:		{
line 1218
;1217:			vec3_t vSub;
;1218:			float subLen = 0;
ADDRLP4 448
CNSTF4 0
ASGNF4
line 1220
;1219:
;1220:			VectorSubtract(ent->client->ps.origin, duelAgainst->client->ps.origin, vSub);
ADDRLP4 464
CNSTI4 408
ASGNI4
ADDRLP4 468
ADDRFP4 0
INDIRP4
ADDRLP4 464
INDIRI4
ADDP4
ASGNP4
ADDRLP4 472
CNSTI4 20
ASGNI4
ADDRLP4 476
ADDRLP4 424
INDIRP4
ADDRLP4 464
INDIRI4
ADDP4
ASGNP4
ADDRLP4 452
ADDRLP4 468
INDIRP4
INDIRP4
ADDRLP4 472
INDIRI4
ADDP4
INDIRF4
ADDRLP4 476
INDIRP4
INDIRP4
ADDRLP4 472
INDIRI4
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 480
CNSTI4 24
ASGNI4
ADDRLP4 452+4
ADDRLP4 468
INDIRP4
INDIRP4
ADDRLP4 480
INDIRI4
ADDP4
INDIRF4
ADDRLP4 476
INDIRP4
INDIRP4
ADDRLP4 480
INDIRI4
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 484
CNSTI4 408
ASGNI4
ADDRLP4 488
CNSTI4 28
ASGNI4
ADDRLP4 452+8
ADDRFP4 0
INDIRP4
ADDRLP4 484
INDIRI4
ADDP4
INDIRP4
ADDRLP4 488
INDIRI4
ADDP4
INDIRF4
ADDRLP4 424
INDIRP4
ADDRLP4 484
INDIRI4
ADDP4
INDIRP4
ADDRLP4 488
INDIRI4
ADDP4
INDIRF4
SUBF4
ASGNF4
line 1221
;1221:			subLen = VectorLength(vSub);
ADDRLP4 452
ARGP4
ADDRLP4 492
ADDRGP4 VectorLength
CALLF4
ASGNF4
ADDRLP4 448
ADDRLP4 492
INDIRF4
ASGNF4
line 1223
;1222:
;1223:			if (subLen >= 1024)
ADDRLP4 448
INDIRF4
CNSTF4 1149239296
LTF4 $552
line 1224
;1224:			{
line 1225
;1225:				ent->client->ps.duelInProgress = 0;
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 1304
ADDP4
CNSTI4 0
ASGNI4
line 1226
;1226:				duelAgainst->client->ps.duelInProgress = 0;
ADDRLP4 424
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 1304
ADDP4
CNSTI4 0
ASGNI4
line 1228
;1227:
;1228:				G_AddEvent(ent, EV_PRIVATE_DUEL, 0);
ADDRFP4 0
INDIRP4
ARGP4
CNSTI4 13
ARGI4
CNSTI4 0
ARGI4
ADDRGP4 G_AddEvent
CALLV
pop
line 1229
;1229:				G_AddEvent(duelAgainst, EV_PRIVATE_DUEL, 0);
ADDRLP4 424
INDIRP4
ARGP4
CNSTI4 13
ARGI4
CNSTI4 0
ARGI4
ADDRGP4 G_AddEvent
CALLV
pop
line 1231
;1230:
;1231:				trap_SendServerCommand( -1, va("print \"%s\n\"", G_GetStripEdString("SVINGAME", "PLDUELSTOP")) );
ADDRGP4 $546
ARGP4
ADDRGP4 $555
ARGP4
ADDRLP4 496
ADDRGP4 G_GetStripEdString
CALLP4
ASGNP4
ADDRGP4 $554
ARGP4
ADDRLP4 496
INDIRP4
ARGP4
ADDRLP4 500
ADDRGP4 va
CALLP4
ASGNP4
CNSTI4 -1
ARGI4
ADDRLP4 500
INDIRP4
ARGP4
ADDRGP4 trap_SendServerCommand
CALLV
pop
line 1232
;1232:			}
LABELV $552
line 1233
;1233:		}
LABELV $532
LABELV $527
line 1234
;1234:	}
LABELV $508
line 1242
;1235:
;1236:	/*
;1237:	if ( client->ps.powerups[PW_HASTE] ) {
;1238:		client->ps.speed *= 1.3;
;1239:	}
;1240:	*/
;1241:
;1242:	if (client->ps.usingATST && ent->health > 0)
ADDRLP4 424
CNSTI4 0
ASGNI4
ADDRLP4 4
INDIRP4
CNSTI4 1316
ADDP4
INDIRI4
ADDRLP4 424
INDIRI4
EQI4 $556
ADDRFP4 0
INDIRP4
CNSTI4 676
ADDP4
INDIRI4
ADDRLP4 424
INDIRI4
LEI4 $556
line 1243
;1243:	{ //we have special shot clip boxes as an ATST
line 1244
;1244:		ent->r.contents |= CONTENTS_NOSHOT;
ADDRLP4 428
ADDRFP4 0
INDIRP4
CNSTI4 340
ADDP4
ASGNP4
ADDRLP4 428
INDIRP4
ADDRLP4 428
INDIRP4
INDIRI4
CNSTI4 2097152
BORI4
ASGNI4
line 1245
;1245:		ATST_ManageDamageBoxes(ent);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 ATST_ManageDamageBoxes
CALLV
pop
line 1246
;1246:	}
ADDRGP4 $557
JUMPV
LABELV $556
line 1248
;1247:	else
;1248:	{
line 1249
;1249:		ent->r.contents &= ~CONTENTS_NOSHOT;
ADDRLP4 428
ADDRFP4 0
INDIRP4
CNSTI4 340
ADDP4
ASGNP4
ADDRLP4 428
INDIRP4
ADDRLP4 428
INDIRP4
INDIRI4
CNSTI4 -2097153
BANDI4
ASGNI4
line 1250
;1250:		client->damageBoxHandle_Head = 0;
ADDRLP4 4
INDIRP4
CNSTI4 1652
ADDP4
CNSTI4 0
ASGNI4
line 1251
;1251:		client->damageBoxHandle_RLeg = 0;
ADDRLP4 4
INDIRP4
CNSTI4 1656
ADDP4
CNSTI4 0
ASGNI4
line 1252
;1252:		client->damageBoxHandle_LLeg = 0;
ADDRLP4 4
INDIRP4
CNSTI4 1660
ADDP4
CNSTI4 0
ASGNI4
line 1253
;1253:	}
LABELV $557
line 1259
;1254:
;1255:	//rww - moved this stuff into the pmove code so that it's predicted properly
;1256:	//BG_AdjustClientSpeed(&client->ps, &client->pers.cmd, level.time);
;1257:
;1258:	// set up for pmove
;1259:	oldEventSequence = client->ps.eventSequence;
ADDRLP4 396
ADDRLP4 4
INDIRP4
CNSTI4 112
ADDP4
INDIRI4
ASGNI4
line 1261
;1260:
;1261:	memset (&pm, 0, sizeof(pm));
ADDRLP4 8
ARGP4
CNSTI4 0
ARGI4
CNSTI4 380
ARGI4
ADDRGP4 memset
CALLP4
pop
line 1263
;1262:
;1263:	if ( ent->flags & FL_FORCE_GESTURE ) {
ADDRFP4 0
INDIRP4
CNSTI4 472
ADDP4
INDIRI4
CNSTI4 32768
BANDI4
CNSTI4 0
EQI4 $558
line 1264
;1264:		ent->flags &= ~FL_FORCE_GESTURE;
ADDRLP4 428
ADDRFP4 0
INDIRP4
CNSTI4 472
ADDP4
ASGNP4
ADDRLP4 428
INDIRP4
ADDRLP4 428
INDIRP4
INDIRI4
CNSTI4 -32769
BANDI4
ASGNI4
line 1265
;1265:		ent->client->pers.cmd.buttons |= BUTTON_GESTURE;
ADDRLP4 432
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 1400
ADDP4
ASGNP4
ADDRLP4 432
INDIRP4
ADDRLP4 432
INDIRP4
INDIRI4
CNSTI4 8
BORI4
ASGNI4
line 1266
;1266:	}
LABELV $558
line 1268
;1267:
;1268:	if (ent->client && ent->client->ps.fallingToDeath &&
ADDRLP4 428
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
ASGNP4
ADDRLP4 428
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $560
ADDRLP4 432
ADDRLP4 428
INDIRP4
CNSTI4 1352
ADDP4
INDIRI4
ASGNI4
ADDRLP4 432
INDIRI4
CNSTI4 0
EQI4 $560
ADDRGP4 level+32
INDIRI4
CNSTI4 3000
SUBI4
ADDRLP4 432
INDIRI4
LEI4 $560
line 1270
;1269:		(level.time - FALL_FADE_TIME) > ent->client->ps.fallingToDeath)
;1270:	{ //die!
line 1271
;1271:		player_die(ent, ent, ent, 100000, MOD_FALLING);
ADDRLP4 436
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 436
INDIRP4
ARGP4
ADDRLP4 436
INDIRP4
ARGP4
ADDRLP4 436
INDIRP4
ARGP4
CNSTI4 100000
ARGI4
CNSTI4 34
ARGI4
ADDRGP4 player_die
CALLV
pop
line 1272
;1272:		respawn(ent);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 respawn
CALLV
pop
line 1273
;1273:		ent->client->ps.fallingToDeath = 0;
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 1352
ADDP4
CNSTI4 0
ASGNI4
line 1275
;1274:
;1275:		G_MuteSound(ent->s.number, CHAN_VOICE); //stop screaming, because you are dead!
ADDRFP4 0
INDIRP4
INDIRI4
ARGI4
CNSTI4 3
ARGI4
ADDRGP4 G_MuteSound
CALLV
pop
line 1276
;1276:	}
LABELV $560
line 1278
;1277:
;1278:	if (ent->client->ps.otherKillerTime > level.time &&
ADDRLP4 436
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
ASGNP4
ADDRLP4 436
INDIRP4
CNSTI4 764
ADDP4
INDIRI4
ADDRGP4 level+32
INDIRI4
LEI4 $563
ADDRLP4 436
INDIRP4
CNSTI4 84
ADDP4
INDIRI4
CNSTI4 1023
EQI4 $563
ADDRLP4 436
INDIRP4
CNSTI4 768
ADDP4
INDIRI4
ADDRGP4 level+32
INDIRI4
GEI4 $563
line 1281
;1279:		ent->client->ps.groundEntityNum != ENTITYNUM_NONE &&
;1280:		ent->client->ps.otherKillerDebounceTime < level.time)
;1281:	{
line 1282
;1282:		ent->client->ps.otherKillerTime = 0;
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 764
ADDP4
CNSTI4 0
ASGNI4
line 1283
;1283:		ent->client->ps.otherKiller = ENTITYNUM_NONE;
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 760
ADDP4
CNSTI4 1023
ASGNI4
line 1284
;1284:	}
ADDRGP4 $564
JUMPV
LABELV $563
line 1285
;1285:	else if (ent->client->ps.otherKillerTime > level.time &&
ADDRLP4 440
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
ASGNP4
ADDRLP4 440
INDIRP4
CNSTI4 764
ADDP4
INDIRI4
ADDRGP4 level+32
INDIRI4
LEI4 $567
ADDRLP4 440
INDIRP4
CNSTI4 84
ADDP4
INDIRI4
CNSTI4 1023
NEI4 $567
line 1287
;1286:		ent->client->ps.groundEntityNum == ENTITYNUM_NONE)
;1287:	{
line 1288
;1288:		if (ent->client->ps.otherKillerDebounceTime < (level.time + 100))
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 768
ADDP4
INDIRI4
ADDRGP4 level+32
INDIRI4
CNSTI4 100
ADDI4
GEI4 $570
line 1289
;1289:		{
line 1290
;1290:			ent->client->ps.otherKillerDebounceTime = level.time + 100;
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 768
ADDP4
ADDRGP4 level+32
INDIRI4
CNSTI4 100
ADDI4
ASGNI4
line 1291
;1291:		}
LABELV $570
line 1292
;1292:	}
LABELV $567
LABELV $564
line 1297
;1293:
;1294://	WP_ForcePowersUpdate( ent, msec, ucmd); //update any active force powers
;1295://	WP_SaberPositionUpdate(ent, ucmd); //check the server-side saber point, do apprioriate server-side actions (effects are cs-only)
;1296:
;1297:	if ((ent->client->pers.cmd.buttons & BUTTON_USE) && ent->client->ps.useDelay < level.time)
ADDRLP4 444
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
ASGNP4
ADDRLP4 444
INDIRP4
CNSTI4 1400
ADDP4
INDIRI4
CNSTI4 32
BANDI4
CNSTI4 0
EQI4 $574
ADDRLP4 444
INDIRP4
CNSTI4 1356
ADDP4
INDIRI4
ADDRGP4 level+32
INDIRI4
GEI4 $574
line 1298
;1298:	{
line 1299
;1299:		TryUse(ent);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 TryUse
CALLV
pop
line 1300
;1300:		ent->client->ps.useDelay = level.time + 100;
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 1356
ADDP4
ADDRGP4 level+32
INDIRI4
CNSTI4 100
ADDI4
ASGNI4
line 1301
;1301:	}
LABELV $574
line 1303
;1302:
;1303:	pm.ps = &client->ps;
ADDRLP4 8
ADDRLP4 4
INDIRP4
ASGNP4
line 1304
;1304:	pm.cmd = *ucmd;
ADDRLP4 8+4
ADDRLP4 388
INDIRP4
INDIRB
ASGNB 28
line 1305
;1305:	if ( pm.ps->pm_type == PM_DEAD ) {
ADDRLP4 448
CNSTI4 4
ASGNI4
ADDRLP4 8
INDIRP4
ADDRLP4 448
INDIRI4
ADDP4
INDIRI4
ADDRLP4 448
INDIRI4
NEI4 $579
line 1306
;1306:		pm.tracemask = MASK_PLAYERSOLID & ~CONTENTS_BODY;
ADDRLP4 8+32
CNSTI4 17
ASGNI4
line 1307
;1307:	}
ADDRGP4 $580
JUMPV
LABELV $579
line 1308
;1308:	else if ( ent->r.svFlags & SVF_BOT ) {
ADDRFP4 0
INDIRP4
CNSTI4 304
ADDP4
INDIRI4
CNSTI4 8
BANDI4
CNSTI4 0
EQI4 $582
line 1309
;1309:		pm.tracemask = MASK_PLAYERSOLID | CONTENTS_MONSTERCLIP;
ADDRLP4 8+32
CNSTI4 305
ASGNI4
line 1310
;1310:	}
ADDRGP4 $583
JUMPV
LABELV $582
line 1311
;1311:	else {
line 1312
;1312:		pm.tracemask = MASK_PLAYERSOLID;
ADDRLP4 8+32
CNSTI4 273
ASGNI4
line 1313
;1313:	}
LABELV $583
LABELV $580
line 1314
;1314:	pm.trace = trap_Trace;
ADDRLP4 8+240
ADDRGP4 trap_Trace
ASGNP4
line 1315
;1315:	pm.pointcontents = trap_PointContents;
ADDRLP4 8+244
ADDRGP4 trap_PointContents
ASGNP4
line 1316
;1316:	pm.debugLevel = g_debugMove.integer;
ADDRLP4 8+36
ADDRGP4 g_debugMove+12
INDIRI4
ASGNI4
line 1317
;1317:	pm.noFootsteps = ( g_dmflags.integer & DF_NO_FOOTSTEPS ) > 0;
ADDRGP4 g_dmflags+12
INDIRI4
CNSTI4 32
BANDI4
CNSTI4 0
LEI4 $593
ADDRLP4 452
CNSTI4 1
ASGNI4
ADDRGP4 $594
JUMPV
LABELV $593
ADDRLP4 452
CNSTI4 0
ASGNI4
LABELV $594
ADDRLP4 8+40
ADDRLP4 452
INDIRI4
ASGNI4
line 1319
;1318:
;1319:	pm.pmove_fixed = pmove_fixed.integer | client->pers.pmoveFixed;
ADDRLP4 8+232
ADDRGP4 pmove_fixed+12
INDIRI4
ADDRLP4 4
INDIRP4
CNSTI4 1424
ADDP4
INDIRI4
BORI4
ASGNI4
line 1320
;1320:	pm.pmove_msec = pmove_msec.integer;
ADDRLP4 8+236
ADDRGP4 pmove_msec+12
INDIRI4
ASGNI4
line 1322
;1321:
;1322:	pm.animations = bgGlobalAnimations;//NULL;
ADDRLP4 8+224
ADDRGP4 bgGlobalAnimations
ASGNP4
line 1324
;1323:
;1324:	pm.gametype = g_gametype.integer;
ADDRLP4 8+220
ADDRGP4 g_gametype+12
INDIRI4
ASGNI4
line 1326
;1325:
;1326:	VectorCopy( client->ps.origin, client->oldOrigin );
ADDRLP4 4
INDIRP4
CNSTI4 1612
ADDP4
ADDRLP4 4
INDIRP4
CNSTI4 20
ADDP4
INDIRB
ASGNB 12
line 1328
;1327:
;1328:	if (level.intermissionQueued != 0 && g_singlePlayer.integer) {
ADDRLP4 460
CNSTI4 0
ASGNI4
ADDRGP4 level+9004
INDIRI4
ADDRLP4 460
INDIRI4
EQI4 $602
ADDRGP4 g_singlePlayer+12
INDIRI4
ADDRLP4 460
INDIRI4
EQI4 $602
line 1329
;1329:		if ( level.time - level.intermissionQueued >= 1000  ) {
ADDRGP4 level+32
INDIRI4
ADDRGP4 level+9004
INDIRI4
SUBI4
CNSTI4 1000
LTI4 $606
line 1330
;1330:			pm.cmd.buttons = 0;
ADDRLP4 8+4+16
CNSTI4 0
ASGNI4
line 1331
;1331:			pm.cmd.forwardmove = 0;
ADDRLP4 8+4+24
CNSTI1 0
ASGNI1
line 1332
;1332:			pm.cmd.rightmove = 0;
ADDRLP4 8+4+25
CNSTI1 0
ASGNI1
line 1333
;1333:			pm.cmd.upmove = 0;
ADDRLP4 8+4+26
CNSTI1 0
ASGNI1
line 1334
;1334:			if ( level.time - level.intermissionQueued >= 2000 && level.time - level.intermissionQueued <= 2500 ) {
ADDRGP4 level+32
INDIRI4
ADDRGP4 level+9004
INDIRI4
SUBI4
CNSTI4 2000
LTI4 $618
ADDRGP4 level+32
INDIRI4
ADDRGP4 level+9004
INDIRI4
SUBI4
CNSTI4 2500
GTI4 $618
line 1335
;1335:				trap_SendConsoleCommand( EXEC_APPEND, "centerview\n");
CNSTI4 2
ARGI4
ADDRGP4 $624
ARGP4
ADDRGP4 trap_SendConsoleCommand
CALLV
pop
line 1336
;1336:			}
LABELV $618
line 1337
;1337:			ent->client->ps.pm_type = PM_SPINTERMISSION;
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 4
ADDP4
CNSTI4 7
ASGNI4
line 1338
;1338:		}
LABELV $606
line 1339
;1339:	}
LABELV $602
line 1341
;1340:
;1341:	for ( i = 0 ; i < MAX_CLIENTS ; i++ )
ADDRLP4 0
CNSTI4 0
ASGNI4
LABELV $625
line 1342
;1342:	{
line 1343
;1343:		if (g_entities[i].inuse && g_entities[i].client)
ADDRLP4 464
CNSTI4 828
ADDRLP4 0
INDIRI4
MULI4
ASGNI4
ADDRLP4 464
INDIRI4
ADDRGP4 g_entities+412
ADDP4
INDIRI4
CNSTI4 0
EQI4 $629
ADDRLP4 464
INDIRI4
ADDRGP4 g_entities+408
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $629
line 1344
;1344:		{
line 1345
;1345:			pm.bgClients[i] = &g_entities[i].client->ps;
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 8+248
ADDP4
CNSTI4 828
ADDRLP4 0
INDIRI4
MULI4
ADDRGP4 g_entities+408
ADDP4
INDIRP4
ASGNP4
line 1346
;1346:		}
LABELV $629
line 1347
;1347:	}
LABELV $626
line 1341
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 32
LTI4 $625
line 1349
;1348:
;1349:	if (ent->client->ps.saberLockTime > level.time)
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 524
ADDP4
INDIRI4
ADDRGP4 level+32
INDIRI4
LEI4 $635
line 1350
;1350:	{
line 1351
;1351:		gentity_t *blockOpp = &g_entities[ent->client->ps.saberLockEnemy];
ADDRLP4 464
CNSTI4 828
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 528
ADDP4
INDIRI4
MULI4
ADDRGP4 g_entities
ADDP4
ASGNP4
line 1353
;1352:
;1353:		if (blockOpp && blockOpp->inuse && blockOpp->client)
ADDRLP4 472
CNSTU4 0
ASGNU4
ADDRLP4 464
INDIRP4
CVPU4 4
ADDRLP4 472
INDIRU4
EQU4 $638
ADDRLP4 464
INDIRP4
CNSTI4 412
ADDP4
INDIRI4
CNSTI4 0
EQI4 $638
ADDRLP4 464
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CVPU4 4
ADDRLP4 472
INDIRU4
EQU4 $638
line 1354
;1354:		{
line 1358
;1355:			vec3_t lockDir, lockAng;
;1356:
;1357:			//VectorClear( ent->client->ps.velocity );
;1358:			VectorSubtract( blockOpp->r.currentOrigin, ent->r.currentOrigin, lockDir );
ADDRLP4 504
CNSTI4 368
ASGNI4
ADDRLP4 508
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 476
ADDRLP4 464
INDIRP4
ADDRLP4 504
INDIRI4
ADDP4
INDIRF4
ADDRLP4 508
INDIRP4
ADDRLP4 504
INDIRI4
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 512
CNSTI4 372
ASGNI4
ADDRLP4 476+4
ADDRLP4 464
INDIRP4
ADDRLP4 512
INDIRI4
ADDP4
INDIRF4
ADDRLP4 508
INDIRP4
ADDRLP4 512
INDIRI4
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 516
CNSTI4 376
ASGNI4
ADDRLP4 476+8
ADDRLP4 464
INDIRP4
ADDRLP4 516
INDIRI4
ADDP4
INDIRF4
ADDRFP4 0
INDIRP4
ADDRLP4 516
INDIRI4
ADDP4
INDIRF4
SUBF4
ASGNF4
line 1360
;1359:			//lockAng[YAW] = vectoyaw( defDir );
;1360:			vectoangles(lockDir, lockAng);
ADDRLP4 476
ARGP4
ADDRLP4 488
ARGP4
ADDRGP4 vectoangles
CALLV
pop
line 1361
;1361:			SetClientViewAngle( ent, lockAng );
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 488
ARGP4
ADDRGP4 SetClientViewAngle
CALLV
pop
line 1362
;1362:		}
LABELV $638
line 1364
;1363:
;1364:		if ( ( ent->client->buttons & BUTTON_ATTACK ) && ! ( ent->client->oldbuttons & BUTTON_ATTACK ) )
ADDRLP4 476
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
ASGNP4
ADDRLP4 480
CNSTI4 1
ASGNI4
ADDRLP4 484
CNSTI4 0
ASGNI4
ADDRLP4 476
INDIRP4
CNSTI4 1600
ADDP4
INDIRI4
ADDRLP4 480
INDIRI4
BANDI4
ADDRLP4 484
INDIRI4
EQI4 $642
ADDRLP4 476
INDIRP4
CNSTI4 1604
ADDP4
INDIRI4
ADDRLP4 480
INDIRI4
BANDI4
ADDRLP4 484
INDIRI4
NEI4 $642
line 1365
;1365:		{
line 1366
;1366:			ent->client->ps.saberLockHits++;
ADDRLP4 488
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 536
ADDP4
ASGNP4
ADDRLP4 488
INDIRP4
ADDRLP4 488
INDIRP4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 1367
;1367:		}
LABELV $642
line 1368
;1368:		if (ent->client->ps.saberLockHits > 2)
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 536
ADDP4
INDIRI4
CNSTI4 2
LEI4 $636
line 1369
;1369:		{
line 1370
;1370:			if (!ent->client->ps.saberLockAdvance)
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 540
ADDP4
INDIRI4
CNSTI4 0
NEI4 $646
line 1371
;1371:			{
line 1372
;1372:				ent->client->ps.saberLockHits -= 3;
ADDRLP4 488
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 536
ADDP4
ASGNP4
ADDRLP4 488
INDIRP4
ADDRLP4 488
INDIRP4
INDIRI4
CNSTI4 3
SUBI4
ASGNI4
line 1373
;1373:			}
LABELV $646
line 1374
;1374:			ent->client->ps.saberLockAdvance = qtrue;
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 540
ADDP4
CNSTI4 1
ASGNI4
line 1375
;1375:		}
line 1376
;1376:	}
ADDRGP4 $636
JUMPV
LABELV $635
line 1378
;1377:	else
;1378:	{
line 1379
;1379:		ent->client->ps.saberLockFrame = 0;
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 532
ADDP4
CNSTI4 0
ASGNI4
line 1381
;1380:		//check for taunt
;1381:		if ( (pm.cmd.generic_cmd == GENCMD_ENGAGE_DUEL) && (g_gametype.integer == GT_TOURNAMENT) )
ADDRLP4 8+4+23
INDIRU1
CVUI4 1
CNSTI4 2
NEI4 $648
ADDRGP4 g_gametype+12
INDIRI4
CNSTI4 3
NEI4 $648
line 1382
;1382:		{//already in a duel, make it a taunt command
line 1383
;1383:			pm.cmd.buttons |= BUTTON_GESTURE;
ADDRLP4 8+4+16
ADDRLP4 8+4+16
INDIRI4
CNSTI4 8
BORI4
ASGNI4
line 1384
;1384:		}
LABELV $648
line 1385
;1385:	}
LABELV $636
line 1388
;1386:
;1387:	//qrot = Pmove (&pm);
;1388:   Pmove (&pm);
ADDRLP4 8
ARGP4
ADDRGP4 Pmove
CALLP4
pop
line 1391
;1389:   // adnan
;1390:   // put quat and angles into configstrings for current client
;1391:   if(ent->client) {
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $655
line 1392
;1392:      trap_SetConfigstring( CS_QUATERNIONS + ent->client->ps.clientNum, 
ADDRGP4 $657
ARGP4
ADDRLP4 464
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
ASGNP4
ADDRLP4 464
INDIRP4
CNSTI4 688
ADDP4
INDIRF4
ARGF4
ADDRLP4 464
INDIRP4
CNSTI4 692
ADDP4
INDIRF4
ARGF4
ADDRLP4 464
INDIRP4
CNSTI4 696
ADDP4
INDIRF4
ARGF4
ADDRLP4 464
INDIRP4
CNSTI4 684
ADDP4
INDIRF4
ARGF4
ADDRLP4 468
ADDRGP4 va
CALLP4
ASGNP4
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 144
ADDP4
INDIRI4
CNSTI4 1054
ADDI4
ARGI4
ADDRLP4 468
INDIRP4
ARGP4
ADDRGP4 trap_SetConfigstring
CALLV
pop
line 1399
;1393:         va("%f,%f,%f,%f",
;1394:         ent->client->ps.tieFloats[Q_X],
;1395:         ent->client->ps.tieFloats[Q_Y],
;1396:         ent->client->ps.tieFloats[Q_Z],
;1397:         ent->client->ps.tieFloats[Q_W])
;1398:      );
;1399:      trap_SetConfigstring( CS_VIEWANGLES + ent->client->ps.clientNum, 
ADDRGP4 $658
ARGP4
ADDRLP4 472
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
ASGNP4
ADDRLP4 472
INDIRP4
CNSTI4 672
ADDP4
INDIRF4
ARGF4
ADDRLP4 472
INDIRP4
CNSTI4 676
ADDP4
INDIRF4
ARGF4
ADDRLP4 472
INDIRP4
CNSTI4 680
ADDP4
INDIRF4
ARGF4
ADDRLP4 476
ADDRGP4 va
CALLP4
ASGNP4
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 144
ADDP4
INDIRI4
CNSTI4 1086
ADDI4
ARGI4
ADDRLP4 476
INDIRP4
ARGP4
ADDRGP4 trap_SetConfigstring
CALLV
pop
line 1405
;1400:         va("%f,%f,%f",
;1401:         ent->client->ps.tieFloats[PREV_ANGLES_PITCH],
;1402:         ent->client->ps.tieFloats[PREV_ANGLES_YAW],
;1403:         ent->client->ps.tieFloats[PREV_ANGLES_ROLL])
;1404:      );
;1405:   }
LABELV $655
line 1407
;1406:
;1407:	if (pm.checkDuelLoss)
ADDRLP4 8+376
INDIRI4
CNSTI4 0
EQI4 $659
line 1408
;1408:	{
line 1409
;1409:		if (pm.checkDuelLoss > 0 && pm.checkDuelLoss <= MAX_CLIENTS)
ADDRLP4 8+376
INDIRI4
CNSTI4 0
LEI4 $662
ADDRLP4 8+376
INDIRI4
CNSTI4 32
GTI4 $662
line 1410
;1410:		{
line 1411
;1411:			gentity_t *clientLost = &g_entities[pm.checkDuelLoss-1];
ADDRLP4 464
CNSTI4 828
ADDRLP4 8+376
INDIRI4
MULI4
ADDRGP4 g_entities-828
ADDP4
ASGNP4
line 1413
;1412:
;1413:			if (clientLost && clientLost->inuse && clientLost->client && Q_irand(0, 40) > clientLost->health)
ADDRLP4 472
CNSTU4 0
ASGNU4
ADDRLP4 464
INDIRP4
CVPU4 4
ADDRLP4 472
INDIRU4
EQU4 $668
ADDRLP4 476
CNSTI4 0
ASGNI4
ADDRLP4 464
INDIRP4
CNSTI4 412
ADDP4
INDIRI4
ADDRLP4 476
INDIRI4
EQI4 $668
ADDRLP4 464
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CVPU4 4
ADDRLP4 472
INDIRU4
EQU4 $668
ADDRLP4 476
INDIRI4
ARGI4
CNSTI4 40
ARGI4
ADDRLP4 480
ADDRGP4 Q_irand
CALLI4
ASGNI4
ADDRLP4 480
INDIRI4
ADDRLP4 464
INDIRP4
CNSTI4 676
ADDP4
INDIRI4
LEI4 $668
line 1414
;1414:			{
line 1416
;1415:				vec3_t attDir;
;1416:				VectorSubtract(ent->client->ps.origin, clientLost->client->ps.origin, attDir);
ADDRLP4 496
CNSTI4 408
ASGNI4
ADDRLP4 500
ADDRFP4 0
INDIRP4
ADDRLP4 496
INDIRI4
ADDP4
ASGNP4
ADDRLP4 504
CNSTI4 20
ASGNI4
ADDRLP4 508
ADDRLP4 464
INDIRP4
ADDRLP4 496
INDIRI4
ADDP4
ASGNP4
ADDRLP4 484
ADDRLP4 500
INDIRP4
INDIRP4
ADDRLP4 504
INDIRI4
ADDP4
INDIRF4
ADDRLP4 508
INDIRP4
INDIRP4
ADDRLP4 504
INDIRI4
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 512
CNSTI4 24
ASGNI4
ADDRLP4 484+4
ADDRLP4 500
INDIRP4
INDIRP4
ADDRLP4 512
INDIRI4
ADDP4
INDIRF4
ADDRLP4 508
INDIRP4
INDIRP4
ADDRLP4 512
INDIRI4
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 516
CNSTI4 408
ASGNI4
ADDRLP4 520
CNSTI4 28
ASGNI4
ADDRLP4 484+8
ADDRFP4 0
INDIRP4
ADDRLP4 516
INDIRI4
ADDP4
INDIRP4
ADDRLP4 520
INDIRI4
ADDP4
INDIRF4
ADDRLP4 464
INDIRP4
ADDRLP4 516
INDIRI4
ADDP4
INDIRP4
ADDRLP4 520
INDIRI4
ADDP4
INDIRF4
SUBF4
ASGNF4
line 1417
;1417:				VectorNormalize(attDir);
ADDRLP4 484
ARGP4
ADDRGP4 VectorNormalize
CALLF4
pop
line 1419
;1418:
;1419:				VectorClear(clientLost->client->ps.velocity);
ADDRLP4 524
ADDRLP4 464
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
ASGNP4
ADDRLP4 528
CNSTF4 0
ASGNF4
ADDRLP4 524
INDIRP4
CNSTI4 40
ADDP4
ADDRLP4 528
INDIRF4
ASGNF4
ADDRLP4 524
INDIRP4
CNSTI4 36
ADDP4
ADDRLP4 528
INDIRF4
ASGNF4
ADDRLP4 524
INDIRP4
CNSTI4 32
ADDP4
ADDRLP4 528
INDIRF4
ASGNF4
line 1420
;1420:				clientLost->client->ps.forceHandExtend = HANDEXTEND_NONE;
ADDRLP4 464
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 1248
ADDP4
CNSTI4 0
ASGNI4
line 1421
;1421:				clientLost->client->ps.forceHandExtendTime = 0;
ADDRLP4 464
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 1252
ADDP4
CNSTI4 0
ASGNI4
line 1423
;1422:
;1423:				gGAvoidDismember = 1;
ADDRGP4 gGAvoidDismember
CNSTI4 1
ASGNI4
line 1424
;1424:				G_Damage(clientLost, ent, ent, attDir, clientLost->client->ps.origin, 9999, DAMAGE_NO_PROTECTION, MOD_SABER);
ADDRLP4 464
INDIRP4
ARGP4
ADDRLP4 536
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 536
INDIRP4
ARGP4
ADDRLP4 536
INDIRP4
ARGP4
ADDRLP4 484
ARGP4
ADDRLP4 464
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 20
ADDP4
ARGP4
CNSTI4 9999
ARGI4
CNSTI4 8
ARGI4
CNSTI4 3
ARGI4
ADDRGP4 G_Damage
CALLV
pop
line 1426
;1425:
;1426:				if (clientLost->health < 1)
ADDRLP4 464
INDIRP4
CNSTI4 676
ADDP4
INDIRI4
CNSTI4 1
GEI4 $672
line 1427
;1427:				{
line 1428
;1428:					gGAvoidDismember = 2;
ADDRGP4 gGAvoidDismember
CNSTI4 2
ASGNI4
line 1429
;1429:					G_CheckForDismemberment(clientLost, clientLost->client->ps.origin, 999, (clientLost->client->ps.legsAnim&~ANIM_TOGGLEBIT));
ADDRLP4 464
INDIRP4
ARGP4
ADDRLP4 544
ADDRLP4 464
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
ASGNP4
ADDRLP4 544
INDIRP4
CNSTI4 20
ADDP4
ARGP4
CNSTI4 999
ARGI4
ADDRLP4 544
INDIRP4
CNSTI4 92
ADDP4
INDIRI4
CNSTI4 -2049
BANDI4
ARGI4
ADDRGP4 G_CheckForDismemberment
CALLV
pop
line 1430
;1430:				}
LABELV $672
line 1432
;1431:
;1432:				gGAvoidDismember = 0;
ADDRGP4 gGAvoidDismember
CNSTI4 0
ASGNI4
line 1433
;1433:			}
LABELV $668
line 1434
;1434:		}
LABELV $662
line 1436
;1435:
;1436:		pm.checkDuelLoss = 0;
ADDRLP4 8+376
CNSTI4 0
ASGNI4
line 1437
;1437:	}
LABELV $659
line 1439
;1438:
;1439:	switch(pm.cmd.generic_cmd)
ADDRLP4 464
ADDRLP4 8+4+23
INDIRU1
CVUI4 1
ASGNI4
ADDRLP4 464
INDIRI4
CNSTI4 0
LTI4 $676
ADDRLP4 464
INDIRI4
CNSTI4 20
GTI4 $676
ADDRLP4 464
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 $720
ADDP4
INDIRP4
JUMPV
lit
align 4
LABELV $720
address $676
address $681
address $682
address $686
address $687
address $688
address $689
address $690
address $691
address $692
address $693
address $694
address $695
address $696
address $697
address $700
address $703
address $706
address $711
address $716
address $719
code
line 1440
;1440:	{
line 1442
;1441:	case 0:
;1442:		break;
LABELV $681
line 1444
;1443:	case GENCMD_SABERSWITCH:
;1444:		Cmd_ToggleSaber_f(ent);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 Cmd_ToggleSaber_f
CALLV
pop
line 1445
;1445:		break;
ADDRGP4 $676
JUMPV
LABELV $682
line 1447
;1446:	case GENCMD_ENGAGE_DUEL:
;1447:		if ( g_gametype.integer == GT_TOURNAMENT )
ADDRGP4 g_gametype+12
INDIRI4
CNSTI4 3
NEI4 $683
line 1448
;1448:		{//already in a duel, made it a taunt command
line 1449
;1449:		}
ADDRGP4 $676
JUMPV
LABELV $683
line 1451
;1450:		else
;1451:		{
line 1452
;1452:			Cmd_EngageDuel_f(ent);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 Cmd_EngageDuel_f
CALLV
pop
line 1453
;1453:		}
line 1454
;1454:		break;
ADDRGP4 $676
JUMPV
LABELV $686
line 1456
;1455:	case GENCMD_FORCE_HEAL:
;1456:		ForceHeal(ent);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 ForceHeal
CALLV
pop
line 1457
;1457:		break;
ADDRGP4 $676
JUMPV
LABELV $687
line 1459
;1458:	case GENCMD_FORCE_SPEED:
;1459:		ForceSpeed(ent, 0);
ADDRFP4 0
INDIRP4
ARGP4
CNSTI4 0
ARGI4
ADDRGP4 ForceSpeed
CALLV
pop
line 1460
;1460:		break;
ADDRGP4 $676
JUMPV
LABELV $688
line 1462
;1461:	case GENCMD_FORCE_THROW:
;1462:		ForceThrow(ent, qfalse);
ADDRFP4 0
INDIRP4
ARGP4
CNSTI4 0
ARGI4
ADDRGP4 ForceThrow
CALLV
pop
line 1463
;1463:		break;
ADDRGP4 $676
JUMPV
LABELV $689
line 1465
;1464:	case GENCMD_FORCE_PULL:
;1465:		ForceThrow(ent, qtrue);
ADDRFP4 0
INDIRP4
ARGP4
CNSTI4 1
ARGI4
ADDRGP4 ForceThrow
CALLV
pop
line 1466
;1466:		break;
ADDRGP4 $676
JUMPV
LABELV $690
line 1468
;1467:	case GENCMD_FORCE_DISTRACT:
;1468:		ForceTelepathy(ent);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 ForceTelepathy
CALLV
pop
line 1469
;1469:		break;
ADDRGP4 $676
JUMPV
LABELV $691
line 1471
;1470:	case GENCMD_FORCE_RAGE:
;1471:		ForceRage(ent);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 ForceRage
CALLV
pop
line 1472
;1472:		break;
ADDRGP4 $676
JUMPV
LABELV $692
line 1474
;1473:	case GENCMD_FORCE_PROTECT:
;1474:		ForceProtect(ent);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 ForceProtect
CALLV
pop
line 1475
;1475:		break;
ADDRGP4 $676
JUMPV
LABELV $693
line 1477
;1476:	case GENCMD_FORCE_ABSORB:
;1477:		ForceAbsorb(ent);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 ForceAbsorb
CALLV
pop
line 1478
;1478:		break;
ADDRGP4 $676
JUMPV
LABELV $694
line 1480
;1479:	case GENCMD_FORCE_HEALOTHER:
;1480:		ForceTeamHeal(ent);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 ForceTeamHeal
CALLV
pop
line 1481
;1481:		break;
ADDRGP4 $676
JUMPV
LABELV $695
line 1483
;1482:	case GENCMD_FORCE_FORCEPOWEROTHER:
;1483:		ForceTeamForceReplenish(ent);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 ForceTeamForceReplenish
CALLV
pop
line 1484
;1484:		break;
ADDRGP4 $676
JUMPV
LABELV $696
line 1486
;1485:	case GENCMD_FORCE_SEEING:
;1486:		ForceSeeing(ent);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 ForceSeeing
CALLV
pop
line 1487
;1487:		break;
ADDRGP4 $676
JUMPV
LABELV $697
line 1489
;1488:	case GENCMD_USE_SEEKER:
;1489:		if ( (ent->client->ps.stats[STAT_HOLDABLE_ITEMS] & (1 << HI_SEEKER)) &&
ADDRLP4 472
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
ASGNP4
ADDRLP4 472
INDIRP4
CNSTI4 224
ADDP4
INDIRI4
CNSTI4 2
BANDI4
CNSTI4 0
EQI4 $676
ADDRLP4 472
INDIRP4
ARGP4
CNSTI4 1
ARGI4
ADDRLP4 476
ADDRGP4 G_ItemUsable
CALLI4
ASGNI4
ADDRLP4 476
INDIRI4
CNSTI4 0
EQI4 $676
line 1491
;1490:			G_ItemUsable(&ent->client->ps, HI_SEEKER) )
;1491:		{
line 1492
;1492:			ItemUse_Seeker(ent);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 ItemUse_Seeker
CALLV
pop
line 1493
;1493:			G_AddEvent(ent, EV_USE_ITEM0+HI_SEEKER, 0);
ADDRFP4 0
INDIRP4
ARGP4
CNSTI4 41
ARGI4
CNSTI4 0
ARGI4
ADDRGP4 G_AddEvent
CALLV
pop
line 1494
;1494:			ent->client->ps.stats[STAT_HOLDABLE_ITEMS] &= ~(1 << HI_SEEKER);
ADDRLP4 480
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 224
ADDP4
ASGNP4
ADDRLP4 480
INDIRP4
ADDRLP4 480
INDIRP4
INDIRI4
CNSTI4 -3
BANDI4
ASGNI4
line 1495
;1495:		}
line 1496
;1496:		break;
ADDRGP4 $676
JUMPV
LABELV $700
line 1498
;1497:	case GENCMD_USE_FIELD:
;1498:		if ( (ent->client->ps.stats[STAT_HOLDABLE_ITEMS] & (1 << HI_SHIELD)) &&
ADDRLP4 480
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
ASGNP4
ADDRLP4 480
INDIRP4
CNSTI4 224
ADDP4
INDIRI4
CNSTI4 4
BANDI4
CNSTI4 0
EQI4 $676
ADDRLP4 480
INDIRP4
ARGP4
CNSTI4 2
ARGI4
ADDRLP4 484
ADDRGP4 G_ItemUsable
CALLI4
ASGNI4
ADDRLP4 484
INDIRI4
CNSTI4 0
EQI4 $676
line 1500
;1499:			G_ItemUsable(&ent->client->ps, HI_SHIELD) )
;1500:		{
line 1501
;1501:			ItemUse_Shield(ent);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 ItemUse_Shield
CALLV
pop
line 1502
;1502:			G_AddEvent(ent, EV_USE_ITEM0+HI_SHIELD, 0);
ADDRFP4 0
INDIRP4
ARGP4
CNSTI4 42
ARGI4
CNSTI4 0
ARGI4
ADDRGP4 G_AddEvent
CALLV
pop
line 1503
;1503:			ent->client->ps.stats[STAT_HOLDABLE_ITEMS] &= ~(1 << HI_SHIELD);
ADDRLP4 488
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 224
ADDP4
ASGNP4
ADDRLP4 488
INDIRP4
ADDRLP4 488
INDIRP4
INDIRI4
CNSTI4 -5
BANDI4
ASGNI4
line 1504
;1504:		}
line 1505
;1505:		break;
ADDRGP4 $676
JUMPV
LABELV $703
line 1507
;1506:	case GENCMD_USE_BACTA:
;1507:		if ( (ent->client->ps.stats[STAT_HOLDABLE_ITEMS] & (1 << HI_MEDPAC)) &&
ADDRLP4 488
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
ASGNP4
ADDRLP4 488
INDIRP4
CNSTI4 224
ADDP4
INDIRI4
CNSTI4 8
BANDI4
CNSTI4 0
EQI4 $676
ADDRLP4 488
INDIRP4
ARGP4
CNSTI4 3
ARGI4
ADDRLP4 492
ADDRGP4 G_ItemUsable
CALLI4
ASGNI4
ADDRLP4 492
INDIRI4
CNSTI4 0
EQI4 $676
line 1509
;1508:			G_ItemUsable(&ent->client->ps, HI_MEDPAC) )
;1509:		{
line 1510
;1510:			ItemUse_MedPack(ent);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 ItemUse_MedPack
CALLV
pop
line 1511
;1511:			G_AddEvent(ent, EV_USE_ITEM0+HI_MEDPAC, 0);
ADDRFP4 0
INDIRP4
ARGP4
CNSTI4 43
ARGI4
CNSTI4 0
ARGI4
ADDRGP4 G_AddEvent
CALLV
pop
line 1512
;1512:			ent->client->ps.stats[STAT_HOLDABLE_ITEMS] &= ~(1 << HI_MEDPAC);
ADDRLP4 496
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 224
ADDP4
ASGNP4
ADDRLP4 496
INDIRP4
ADDRLP4 496
INDIRP4
INDIRI4
CNSTI4 -9
BANDI4
ASGNI4
line 1513
;1513:		}
line 1514
;1514:		break;
ADDRGP4 $676
JUMPV
LABELV $706
line 1516
;1515:	case GENCMD_USE_ELECTROBINOCULARS:
;1516:		if ( (ent->client->ps.stats[STAT_HOLDABLE_ITEMS] & (1 << HI_BINOCULARS)) &&
ADDRLP4 496
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
ASGNP4
ADDRLP4 496
INDIRP4
CNSTI4 224
ADDP4
INDIRI4
CNSTI4 32
BANDI4
CNSTI4 0
EQI4 $676
ADDRLP4 496
INDIRP4
ARGP4
CNSTI4 5
ARGI4
ADDRLP4 500
ADDRGP4 G_ItemUsable
CALLI4
ASGNI4
ADDRLP4 500
INDIRI4
CNSTI4 0
EQI4 $676
line 1518
;1517:			G_ItemUsable(&ent->client->ps, HI_BINOCULARS) )
;1518:		{
line 1519
;1519:			ItemUse_Binoculars(ent);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 ItemUse_Binoculars
CALLV
pop
line 1520
;1520:			if (ent->client->ps.zoomMode == 0)
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 1332
ADDP4
INDIRI4
CNSTI4 0
NEI4 $709
line 1521
;1521:			{
line 1522
;1522:				G_AddEvent(ent, EV_USE_ITEM0+HI_BINOCULARS, 1);
ADDRFP4 0
INDIRP4
ARGP4
CNSTI4 45
ARGI4
CNSTI4 1
ARGI4
ADDRGP4 G_AddEvent
CALLV
pop
line 1523
;1523:			}
ADDRGP4 $676
JUMPV
LABELV $709
line 1525
;1524:			else
;1525:			{
line 1526
;1526:				G_AddEvent(ent, EV_USE_ITEM0+HI_BINOCULARS, 2);
ADDRFP4 0
INDIRP4
ARGP4
CNSTI4 45
ARGI4
CNSTI4 2
ARGI4
ADDRGP4 G_AddEvent
CALLV
pop
line 1527
;1527:			}
line 1528
;1528:		}
line 1529
;1529:		break;
ADDRGP4 $676
JUMPV
LABELV $711
line 1531
;1530:	case GENCMD_ZOOM:
;1531:		if ( (ent->client->ps.stats[STAT_HOLDABLE_ITEMS] & (1 << HI_BINOCULARS)) &&
ADDRLP4 504
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
ASGNP4
ADDRLP4 504
INDIRP4
CNSTI4 224
ADDP4
INDIRI4
CNSTI4 32
BANDI4
CNSTI4 0
EQI4 $676
ADDRLP4 504
INDIRP4
ARGP4
CNSTI4 5
ARGI4
ADDRLP4 508
ADDRGP4 G_ItemUsable
CALLI4
ASGNI4
ADDRLP4 508
INDIRI4
CNSTI4 0
EQI4 $676
line 1533
;1532:			G_ItemUsable(&ent->client->ps, HI_BINOCULARS) )
;1533:		{
line 1534
;1534:			ItemUse_Binoculars(ent);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 ItemUse_Binoculars
CALLV
pop
line 1535
;1535:			if (ent->client->ps.zoomMode == 0)
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 1332
ADDP4
INDIRI4
CNSTI4 0
NEI4 $714
line 1536
;1536:			{
line 1537
;1537:				G_AddEvent(ent, EV_USE_ITEM0+HI_BINOCULARS, 1);
ADDRFP4 0
INDIRP4
ARGP4
CNSTI4 45
ARGI4
CNSTI4 1
ARGI4
ADDRGP4 G_AddEvent
CALLV
pop
line 1538
;1538:			}
ADDRGP4 $676
JUMPV
LABELV $714
line 1540
;1539:			else
;1540:			{
line 1541
;1541:				G_AddEvent(ent, EV_USE_ITEM0+HI_BINOCULARS, 2);
ADDRFP4 0
INDIRP4
ARGP4
CNSTI4 45
ARGI4
CNSTI4 2
ARGI4
ADDRGP4 G_AddEvent
CALLV
pop
line 1542
;1542:			}
line 1543
;1543:		}
line 1544
;1544:		break;
ADDRGP4 $676
JUMPV
LABELV $716
line 1546
;1545:	case GENCMD_USE_SENTRY:
;1546:		if ( (ent->client->ps.stats[STAT_HOLDABLE_ITEMS] & (1 << HI_SENTRY_GUN)) &&
ADDRLP4 512
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
ASGNP4
ADDRLP4 512
INDIRP4
CNSTI4 224
ADDP4
INDIRI4
CNSTI4 64
BANDI4
CNSTI4 0
EQI4 $676
ADDRLP4 512
INDIRP4
ARGP4
CNSTI4 6
ARGI4
ADDRLP4 516
ADDRGP4 G_ItemUsable
CALLI4
ASGNI4
ADDRLP4 516
INDIRI4
CNSTI4 0
EQI4 $676
line 1548
;1547:			G_ItemUsable(&ent->client->ps, HI_SENTRY_GUN) )
;1548:		{
line 1549
;1549:			ItemUse_Sentry(ent);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 ItemUse_Sentry
CALLV
pop
line 1550
;1550:			G_AddEvent(ent, EV_USE_ITEM0+HI_SENTRY_GUN, 0);
ADDRFP4 0
INDIRP4
ARGP4
CNSTI4 46
ARGI4
CNSTI4 0
ARGI4
ADDRGP4 G_AddEvent
CALLV
pop
line 1551
;1551:			ent->client->ps.stats[STAT_HOLDABLE_ITEMS] &= ~(1 << HI_SENTRY_GUN);
ADDRLP4 520
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 224
ADDP4
ASGNP4
ADDRLP4 520
INDIRP4
ADDRLP4 520
INDIRP4
INDIRI4
CNSTI4 -65
BANDI4
ASGNI4
line 1552
;1552:		}
line 1553
;1553:		break;
ADDRGP4 $676
JUMPV
LABELV $719
line 1555
;1554:	case GENCMD_SABERATTACKCYCLE:
;1555:		Cmd_SaberAttackCycle_f(ent);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 Cmd_SaberAttackCycle_f
CALLV
pop
line 1556
;1556:		break;
line 1558
;1557:	default:
;1558:		break;
LABELV $676
line 1587
;1559:	}
;1560:
;1561:	// save results of pmove
;1562:
;1563:   // adnan
;1564:   // set the roll shit...
;1565:   //ent->client->ps.viewangles[ROLL] = ent->client->ps.stats[STAT_ROLL];
;1566:
;1567:   /*
;1568:   // use the buttons...
;1569:   if(ent->client->buttons & BUTTON_ROLL_RIGHT) {
;1570:      ent->client->ps.viewangles[ROLL] += 1;
;1571:      G_Printf("rolled right: %f\n", ent->client->ps.viewangles[ROLL]);
;1572:   } else if (ent->client->buttons & BUTTON_ROLL_LEFT) {
;1573:      ent->client->ps.viewangles[ROLL] -= 1;
;1574:      G_Printf("rolled left: %f\n", ent->client->ps.viewangles[ROLL]);
;1575:   }
;1576:   */
;1577:
;1578:   
;1579:   /*
;1580:   // clamp the roll...
;1581:   if(ent->client->ps.viewangles[ROLL] < -360)
;1582:		ent->client->ps.viewangles[ROLL] = 0;
;1583:	else if(ent->client->ps.viewangles[ROLL] > 360)
;1584:		ent->client->ps.viewangles[ROLL] = 0;
;1585:   */
;1586:
;1587:	if ( ent->client->ps.eventSequence != oldEventSequence ) {
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 112
ADDP4
INDIRI4
ADDRLP4 396
INDIRI4
EQI4 $721
line 1588
;1588:		ent->eventTime = level.time;
ADDRFP4 0
INDIRP4
CNSTI4 488
ADDP4
ADDRGP4 level+32
INDIRI4
ASGNI4
line 1589
;1589:	}
LABELV $721
line 1590
;1590:	if (g_smoothClients.integer) {
ADDRGP4 g_smoothClients+12
INDIRI4
CNSTI4 0
EQI4 $724
line 1591
;1591:		BG_PlayerStateToEntityStateExtraPolate( &ent->client->ps, &ent->s, ent->client->ps.commandTime, qtrue );
ADDRLP4 472
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 476
ADDRLP4 472
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
ASGNP4
ADDRLP4 476
INDIRP4
ARGP4
ADDRLP4 472
INDIRP4
ARGP4
ADDRLP4 476
INDIRP4
INDIRI4
ARGI4
CNSTI4 1
ARGI4
ADDRGP4 BG_PlayerStateToEntityStateExtraPolate
CALLV
pop
line 1592
;1592:	}
ADDRGP4 $725
JUMPV
LABELV $724
line 1593
;1593:	else {
line 1594
;1594:		BG_PlayerStateToEntityState( &ent->client->ps, &ent->s, qtrue );
ADDRLP4 472
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 472
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
ARGP4
ADDRLP4 472
INDIRP4
ARGP4
CNSTI4 1
ARGI4
ADDRGP4 BG_PlayerStateToEntityState
CALLV
pop
line 1595
;1595:	}
LABELV $725
line 1596
;1596:	SendPendingPredictableEvents( &ent->client->ps );
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
ARGP4
ADDRGP4 SendPendingPredictableEvents
CALLV
pop
line 1598
;1597:
;1598:	if ( !( ent->client->ps.eFlags & EF_FIRING ) ) {
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 108
ADDP4
INDIRI4
CNSTI4 256
BANDI4
CNSTI4 0
NEI4 $727
line 1599
;1599:		client->fireHeld = qfalse;		// for grapple
ADDRLP4 4
INDIRP4
CNSTI4 1712
ADDP4
CNSTI4 0
ASGNI4
line 1600
;1600:	}
LABELV $727
line 1603
;1601:
;1602:	// use the snapped origin for linking so it matches client predicted versions
;1603:	VectorCopy( ent->s.pos.trBase, ent->r.currentOrigin );
ADDRLP4 472
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 472
INDIRP4
CNSTI4 368
ADDP4
ADDRLP4 472
INDIRP4
CNSTI4 24
ADDP4
INDIRB
ASGNB 12
line 1605
;1604:
;1605:	VectorCopy (pm.mins, ent->r.mins);
ADDRFP4 0
INDIRP4
CNSTI4 316
ADDP4
ADDRLP4 8+188
INDIRB
ASGNB 12
line 1606
;1606:	VectorCopy (pm.maxs, ent->r.maxs);
ADDRFP4 0
INDIRP4
CNSTI4 328
ADDP4
ADDRLP4 8+200
INDIRB
ASGNB 12
line 1608
;1607:
;1608:	ent->waterlevel = pm.waterlevel;
ADDRFP4 0
INDIRP4
CNSTI4 748
ADDP4
ADDRLP4 8+216
INDIRI4
ASGNI4
line 1609
;1609:	ent->watertype = pm.watertype;
ADDRFP4 0
INDIRP4
CNSTI4 744
ADDP4
ADDRLP4 8+212
INDIRI4
ASGNI4
line 1612
;1610:
;1611:	// execute client events
;1612:	ClientEvents( ent, oldEventSequence );
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 396
INDIRI4
ARGI4
ADDRGP4 ClientEvents
CALLV
pop
line 1614
;1613:
;1614:	if ( pm.useEvent )
ADDRLP4 8+184
INDIRI4
CNSTI4 0
EQI4 $733
line 1615
;1615:	{
line 1618
;1616:		//TODO: Use
;1617://		TryUse( ent );
;1618:	}
LABELV $733
line 1621
;1619:
;1620:	// link entity now, after any personal teleporters have been used
;1621:	trap_LinkEntity (ent);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 trap_LinkEntity
CALLV
pop
line 1622
;1622:	if ( !ent->client->noclip ) {
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 1592
ADDP4
INDIRI4
CNSTI4 0
NEI4 $736
line 1623
;1623:		G_TouchTriggers( ent );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 G_TouchTriggers
CALLV
pop
line 1624
;1624:	}
LABELV $736
line 1627
;1625:
;1626:	// NOTE: now copy the exact origin over otherwise clients can be snapped into solid
;1627:	VectorCopy( ent->client->ps.origin, ent->r.currentOrigin );
ADDRLP4 476
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 476
INDIRP4
CNSTI4 368
ADDP4
ADDRLP4 476
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 20
ADDP4
INDIRB
ASGNB 12
line 1633
;1628:
;1629:	//test for solid areas in the AAS file
;1630://	BotTestAAS(ent->r.currentOrigin);
;1631:
;1632:	// touch other objects
;1633:	ClientImpacts( ent, &pm );
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 8
ARGP4
ADDRGP4 ClientImpacts
CALLV
pop
line 1636
;1634:
;1635:	// save results of triggers and client events
;1636:	if (ent->client->ps.eventSequence != oldEventSequence) {
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 112
ADDP4
INDIRI4
ADDRLP4 396
INDIRI4
EQI4 $738
line 1637
;1637:		ent->eventTime = level.time;
ADDRFP4 0
INDIRP4
CNSTI4 488
ADDP4
ADDRGP4 level+32
INDIRI4
ASGNI4
line 1638
;1638:	}
LABELV $738
line 1641
;1639:
;1640:	// swap and latch button actions
;1641:	client->oldbuttons = client->buttons;
ADDRLP4 4
INDIRP4
CNSTI4 1604
ADDP4
ADDRLP4 4
INDIRP4
CNSTI4 1600
ADDP4
INDIRI4
ASGNI4
line 1642
;1642:	client->buttons = ucmd->buttons;
ADDRLP4 4
INDIRP4
CNSTI4 1600
ADDP4
ADDRLP4 388
INDIRP4
CNSTI4 16
ADDP4
INDIRI4
ASGNI4
line 1643
;1643:	client->latched_buttons |= client->buttons & ~client->oldbuttons;
ADDRLP4 488
ADDRLP4 4
INDIRP4
CNSTI4 1608
ADDP4
ASGNP4
ADDRLP4 488
INDIRP4
ADDRLP4 488
INDIRP4
INDIRI4
ADDRLP4 4
INDIRP4
CNSTI4 1600
ADDP4
INDIRI4
ADDRLP4 4
INDIRP4
CNSTI4 1604
ADDP4
INDIRI4
BCOMI4
BANDI4
BORI4
ASGNI4
line 1646
;1644:
;1645:	// Did we kick someone in our pmove sequence?
;1646:	if (client->ps.forceKickFlip)
ADDRLP4 4
INDIRP4
CNSTI4 1292
ADDP4
INDIRI4
CNSTI4 0
EQI4 $741
line 1647
;1647:	{
line 1648
;1648:		gentity_t *faceKicked = &g_entities[client->ps.forceKickFlip-1];
ADDRLP4 492
CNSTI4 828
ADDRLP4 4
INDIRP4
CNSTI4 1292
ADDP4
INDIRI4
MULI4
ADDRGP4 g_entities-828
ADDP4
ASGNP4
line 1650
;1649:
;1650:		if (faceKicked && faceKicked->client && (!OnSameTeam(ent, faceKicked) || g_friendlyFire.integer) &&
ADDRLP4 500
CNSTU4 0
ASGNU4
ADDRLP4 492
INDIRP4
CVPU4 4
ADDRLP4 500
INDIRU4
EQU4 $744
ADDRLP4 492
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CVPU4 4
ADDRLP4 500
INDIRU4
EQU4 $744
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 492
INDIRP4
ARGP4
ADDRLP4 504
ADDRGP4 OnSameTeam
CALLI4
ASGNI4
ADDRLP4 508
CNSTI4 0
ASGNI4
ADDRLP4 504
INDIRI4
ADDRLP4 508
INDIRI4
EQI4 $747
ADDRGP4 g_friendlyFire+12
INDIRI4
ADDRLP4 508
INDIRI4
EQI4 $744
LABELV $747
ADDRLP4 512
ADDRLP4 492
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
ASGNP4
ADDRLP4 512
INDIRP4
CNSTI4 1304
ADDP4
INDIRI4
CNSTI4 0
EQI4 $748
ADDRLP4 512
INDIRP4
CNSTI4 1296
ADDP4
INDIRI4
ADDRFP4 0
INDIRP4
INDIRI4
NEI4 $744
LABELV $748
ADDRLP4 516
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
ASGNP4
ADDRLP4 516
INDIRP4
CNSTI4 1304
ADDP4
INDIRI4
CNSTI4 0
EQI4 $749
ADDRLP4 516
INDIRP4
CNSTI4 1296
ADDP4
INDIRI4
ADDRLP4 492
INDIRP4
INDIRI4
NEI4 $744
LABELV $749
line 1653
;1651:			(!faceKicked->client->ps.duelInProgress || faceKicked->client->ps.duelIndex == ent->s.number) &&
;1652:			(!ent->client->ps.duelInProgress || ent->client->ps.duelIndex == faceKicked->s.number))
;1653:		{
line 1654
;1654:			if ( faceKicked && faceKicked->client && faceKicked->health && faceKicked->takedamage )
ADDRLP4 524
CNSTU4 0
ASGNU4
ADDRLP4 492
INDIRP4
CVPU4 4
ADDRLP4 524
INDIRU4
EQU4 $750
ADDRLP4 492
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CVPU4 4
ADDRLP4 524
INDIRU4
EQU4 $750
ADDRLP4 528
CNSTI4 0
ASGNI4
ADDRLP4 492
INDIRP4
CNSTI4 676
ADDP4
INDIRI4
ADDRLP4 528
INDIRI4
EQI4 $750
ADDRLP4 492
INDIRP4
CNSTI4 680
ADDP4
INDIRI4
ADDRLP4 528
INDIRI4
EQI4 $750
line 1655
;1655:			{//push them away and do pain
line 1657
;1656:				vec3_t oppDir;
;1657:				int strength = (int)VectorNormalize2( client->ps.velocity, oppDir );
ADDRLP4 4
INDIRP4
CNSTI4 32
ADDP4
ARGP4
ADDRLP4 536
ARGP4
ADDRLP4 548
ADDRGP4 VectorNormalize2
CALLF4
ASGNF4
ADDRLP4 532
ADDRLP4 548
INDIRF4
CVFI4 4
ASGNI4
line 1659
;1658:
;1659:				strength *= 0.05;
ADDRLP4 532
CNSTF4 1028443341
ADDRLP4 532
INDIRI4
CVIF4 4
MULF4
CVFI4 4
ASGNI4
line 1661
;1660:
;1661:				VectorScale( oppDir, -1, oppDir );
ADDRLP4 552
CNSTF4 3212836864
ASGNF4
ADDRLP4 536
ADDRLP4 552
INDIRF4
ADDRLP4 536
INDIRF4
MULF4
ASGNF4
ADDRLP4 536+4
ADDRLP4 552
INDIRF4
ADDRLP4 536+4
INDIRF4
MULF4
ASGNF4
ADDRLP4 536+8
CNSTF4 3212836864
ADDRLP4 536+8
INDIRF4
MULF4
ASGNF4
line 1663
;1662:
;1663:				G_Damage( faceKicked, ent, ent, oppDir, client->ps.origin, strength, DAMAGE_NO_ARMOR, MOD_MELEE );
ADDRLP4 492
INDIRP4
ARGP4
ADDRLP4 556
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 556
INDIRP4
ARGP4
ADDRLP4 556
INDIRP4
ARGP4
ADDRLP4 536
ARGP4
ADDRLP4 4
INDIRP4
CNSTI4 20
ADDP4
ARGP4
ADDRLP4 532
INDIRI4
ARGI4
ADDRLP4 560
CNSTI4 2
ASGNI4
ADDRLP4 560
INDIRI4
ARGI4
ADDRLP4 560
INDIRI4
ARGI4
ADDRGP4 G_Damage
CALLV
pop
line 1665
;1664:
;1665:				if ( faceKicked->client->ps.weapon != WP_SABER ||
ADDRLP4 564
ADDRLP4 492
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
ASGNP4
ADDRLP4 564
INDIRP4
CNSTI4 148
ADDP4
INDIRI4
CNSTI4 2
NEI4 $759
ADDRLP4 564
INDIRP4
CNSTI4 1228
ADDP4
INDIRI4
CNSTI4 3
LTI4 $759
ADDRLP4 564
INDIRP4
CNSTI4 512
ADDP4
INDIRI4
ARGI4
ADDRLP4 568
ADDRGP4 BG_SaberInAttack
CALLI4
ASGNI4
ADDRLP4 568
INDIRI4
CNSTI4 0
NEI4 $756
ADDRLP4 492
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 512
ADDP4
INDIRI4
ARGI4
ADDRLP4 572
ADDRGP4 PM_SaberInStart
CALLI4
ASGNI4
ADDRLP4 572
INDIRI4
CNSTI4 0
NEI4 $756
ADDRLP4 492
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 512
ADDP4
INDIRI4
ARGI4
ADDRLP4 576
ADDRGP4 PM_SaberInReturn
CALLI4
ASGNI4
ADDRLP4 576
INDIRI4
CNSTI4 0
NEI4 $756
ADDRLP4 492
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 512
ADDP4
INDIRI4
ARGI4
ADDRLP4 580
ADDRGP4 PM_SaberInTransition
CALLI4
ASGNI4
ADDRLP4 580
INDIRI4
CNSTI4 0
NEI4 $756
LABELV $759
line 1668
;1666:					 faceKicked->client->ps.fd.saberAnimLevel < FORCE_LEVEL_3 ||
;1667:					 (!BG_SaberInAttack(faceKicked->client->ps.saberMove) && !PM_SaberInStart(faceKicked->client->ps.saberMove) && !PM_SaberInReturn(faceKicked->client->ps.saberMove) && !PM_SaberInTransition(faceKicked->client->ps.saberMove)) )
;1668:				{
line 1669
;1669:					if (faceKicked->health > 0 &&
ADDRLP4 588
CNSTI4 0
ASGNI4
ADDRLP4 492
INDIRP4
CNSTI4 676
ADDP4
INDIRI4
ADDRLP4 588
INDIRI4
LEI4 $760
ADDRLP4 592
ADDRLP4 492
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
ASGNP4
ADDRLP4 592
INDIRP4
CNSTI4 216
ADDP4
INDIRI4
ADDRLP4 588
INDIRI4
LEI4 $760
ADDRLP4 592
INDIRP4
CNSTI4 1248
ADDP4
INDIRI4
CNSTI4 8
EQI4 $760
line 1672
;1670:						faceKicked->client->ps.stats[STAT_HEALTH] > 0 &&
;1671:						faceKicked->client->ps.forceHandExtend != HANDEXTEND_KNOCKDOWN)
;1672:					{
line 1673
;1673:						if (Q_irand(1, 10) <= 3)
CNSTI4 1
ARGI4
CNSTI4 10
ARGI4
ADDRLP4 596
ADDRGP4 Q_irand
CALLI4
ASGNI4
ADDRLP4 596
INDIRI4
CNSTI4 3
GTI4 $762
line 1674
;1674:						{ //only actually knock over sometimes, but always do velocity hit
line 1675
;1675:							faceKicked->client->ps.forceHandExtend = HANDEXTEND_KNOCKDOWN;
ADDRLP4 492
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 1248
ADDP4
CNSTI4 8
ASGNI4
line 1676
;1676:							faceKicked->client->ps.forceHandExtendTime = level.time + 1100;
ADDRLP4 492
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 1252
ADDP4
ADDRGP4 level+32
INDIRI4
CNSTI4 1100
ADDI4
ASGNI4
line 1677
;1677:							faceKicked->client->ps.forceDodgeAnim = 0; //this toggles between 1 and 0, when it's 1 we should play the get up anim
ADDRLP4 492
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 1260
ADDP4
CNSTI4 0
ASGNI4
line 1678
;1678:						}
LABELV $762
line 1680
;1679:
;1680:						faceKicked->client->ps.otherKiller = ent->s.number;
ADDRLP4 492
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 760
ADDP4
ADDRFP4 0
INDIRP4
INDIRI4
ASGNI4
line 1681
;1681:						faceKicked->client->ps.otherKillerTime = level.time + 5000;
ADDRLP4 492
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 764
ADDP4
ADDRGP4 level+32
INDIRI4
CNSTI4 5000
ADDI4
ASGNI4
line 1682
;1682:						faceKicked->client->ps.otherKillerDebounceTime = level.time + 100;
ADDRLP4 492
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 768
ADDP4
ADDRGP4 level+32
INDIRI4
CNSTI4 100
ADDI4
ASGNI4
line 1684
;1683:
;1684:						faceKicked->client->ps.velocity[0] = oppDir[0]*(strength*40);
ADDRLP4 492
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 32
ADDP4
ADDRLP4 536
INDIRF4
CNSTI4 40
ADDRLP4 532
INDIRI4
MULI4
CVIF4 4
MULF4
ASGNF4
line 1685
;1685:						faceKicked->client->ps.velocity[1] = oppDir[1]*(strength*40);
ADDRLP4 492
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 36
ADDP4
ADDRLP4 536+4
INDIRF4
CNSTI4 40
ADDRLP4 532
INDIRI4
MULI4
CVIF4 4
MULF4
ASGNF4
line 1686
;1686:						faceKicked->client->ps.velocity[2] = 200;
ADDRLP4 492
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 40
ADDP4
CNSTF4 1128792064
ASGNF4
line 1687
;1687:					}
LABELV $760
line 1688
;1688:				}
LABELV $756
line 1690
;1689:
;1690:				G_Sound( faceKicked, CHAN_AUTO, G_SoundIndex( va("sound/weapons/melee/punch%d", Q_irand(1, 4)) ) );
CNSTI4 1
ARGI4
CNSTI4 4
ARGI4
ADDRLP4 584
ADDRGP4 Q_irand
CALLI4
ASGNI4
ADDRGP4 $768
ARGP4
ADDRLP4 584
INDIRI4
ARGI4
ADDRLP4 588
ADDRGP4 va
CALLP4
ASGNP4
ADDRLP4 588
INDIRP4
ARGP4
ADDRLP4 592
ADDRGP4 G_SoundIndex
CALLI4
ASGNI4
ADDRLP4 492
INDIRP4
ARGP4
CNSTI4 0
ARGI4
ADDRLP4 592
INDIRI4
ARGI4
ADDRGP4 G_Sound
CALLV
pop
line 1691
;1691:			}
LABELV $750
line 1692
;1692:		}
LABELV $744
line 1694
;1693:
;1694:		client->ps.forceKickFlip = 0;
ADDRLP4 4
INDIRP4
CNSTI4 1292
ADDP4
CNSTI4 0
ASGNI4
line 1695
;1695:	}
LABELV $741
line 1698
;1696:
;1697:	// check for respawning
;1698:	if ( client->ps.stats[STAT_HEALTH] <= 0 ) {
ADDRLP4 4
INDIRP4
CNSTI4 216
ADDP4
INDIRI4
CNSTI4 0
GTI4 $769
line 1700
;1699:		// wait for the attack button to be pressed
;1700:		if ( level.time > client->respawnTime && !gDoSlowMoDuel ) {
ADDRGP4 level+32
INDIRI4
ADDRLP4 4
INDIRP4
CNSTI4 1688
ADDP4
INDIRI4
LEI4 $771
ADDRGP4 gDoSlowMoDuel
INDIRI4
CNSTI4 0
NEI4 $771
line 1702
;1701:			// forcerespawn is to prevent users from waiting out powerups
;1702:			if ( g_forcerespawn.integer > 0 && 
ADDRGP4 g_forcerespawn+12
INDIRI4
CNSTI4 0
LEI4 $774
ADDRGP4 level+32
INDIRI4
ADDRLP4 4
INDIRP4
CNSTI4 1688
ADDP4
INDIRI4
SUBI4
CNSTI4 1000
ADDRGP4 g_forcerespawn+12
INDIRI4
MULI4
LEI4 $774
line 1703
;1703:				( level.time - client->respawnTime ) > g_forcerespawn.integer * 1000 ) {
line 1704
;1704:				respawn( ent );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 respawn
CALLV
pop
line 1705
;1705:				return;
ADDRGP4 $449
JUMPV
LABELV $774
line 1709
;1706:			}
;1707:		
;1708:			// pressing attack or use is the normal respawn method
;1709:			if ( ucmd->buttons & ( BUTTON_ATTACK | BUTTON_USE_HOLDABLE ) ) {
ADDRLP4 388
INDIRP4
CNSTI4 16
ADDP4
INDIRI4
CNSTI4 5
BANDI4
CNSTI4 0
EQI4 $449
line 1710
;1710:				respawn( ent );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 respawn
CALLV
pop
line 1711
;1711:			}
line 1712
;1712:		}
ADDRGP4 $449
JUMPV
LABELV $771
line 1713
;1713:		else if (gDoSlowMoDuel)
ADDRGP4 gDoSlowMoDuel
INDIRI4
CNSTI4 0
EQI4 $449
line 1714
;1714:		{
line 1715
;1715:			client->respawnTime = level.time + 1000;
ADDRLP4 4
INDIRP4
CNSTI4 1688
ADDP4
ADDRGP4 level+32
INDIRI4
CNSTI4 1000
ADDI4
ASGNI4
line 1716
;1716:		}
line 1717
;1717:		return;
ADDRGP4 $449
JUMPV
LABELV $769
line 1721
;1718:	}
;1719:
;1720:	// perform once-a-second actions
;1721:	ClientTimerActions( ent, msec );
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 392
INDIRI4
ARGI4
ADDRGP4 ClientTimerActions
CALLV
pop
line 1723
;1722:
;1723:	G_UpdateClientBroadcasts ( ent );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 G_UpdateClientBroadcasts
CALLV
pop
line 1724
;1724:}
LABELV $449
endproc ClientThink_real 600 32
export G_CheckClientTimeouts
proc G_CheckClientTimeouts 0 8
line 1734
;1725:
;1726:/*
;1727:==================
;1728:G_CheckClientTimeouts
;1729:
;1730:Checks whether a client has exceded any timeouts and act accordingly
;1731:==================
;1732:*/
;1733:void G_CheckClientTimeouts ( gentity_t *ent )
;1734:{
line 1736
;1735:	// Only timeout supported right now is the timeout to spectator mode
;1736:	if ( !g_timeouttospec.integer )
ADDRGP4 g_timeouttospec+12
INDIRI4
CNSTI4 0
NEI4 $785
line 1737
;1737:	{
line 1738
;1738:		return;
ADDRGP4 $784
JUMPV
LABELV $785
line 1742
;1739:	}
;1740:
;1741:	// Already a spectator, no need to boot them to spectator
;1742:	if ( ent->client->sess.sessionTeam == TEAM_SPECTATOR )
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 1536
ADDP4
INDIRI4
CNSTI4 3
NEI4 $788
line 1743
;1743:	{
line 1744
;1744:		return;
ADDRGP4 $784
JUMPV
LABELV $788
line 1749
;1745:	}
;1746:
;1747:	// See how long its been since a command was received by the client and if its 
;1748:	// longer than the timeout to spectator then force this client into spectator mode
;1749:	if ( level.time - ent->client->pers.cmd.serverTime > g_timeouttospec.integer * 1000 )
ADDRGP4 level+32
INDIRI4
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 1384
ADDP4
INDIRI4
SUBI4
CNSTI4 1000
ADDRGP4 g_timeouttospec+12
INDIRI4
MULI4
LEI4 $790
line 1750
;1750:	{
line 1751
;1751:		SetTeam ( ent, "spectator" );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 $794
ARGP4
ADDRGP4 SetTeam
CALLV
pop
line 1752
;1752:	}
LABELV $790
line 1753
;1753:}
LABELV $784
endproc G_CheckClientTimeouts 0 8
export ClientThink
proc ClientThink 8 8
line 1762
;1754:
;1755:/*
;1756:==================
;1757:ClientThink
;1758:
;1759:A new command has arrived from the client
;1760:==================
;1761:*/
;1762:void ClientThink( int clientNum ) {
line 1765
;1763:	gentity_t *ent;
;1764:
;1765:	ent = g_entities + clientNum;
ADDRLP4 0
CNSTI4 828
ADDRFP4 0
INDIRI4
MULI4
ADDRGP4 g_entities
ADDP4
ASGNP4
line 1767
;1766:	// adnan
;1767:   trap_GetUsercmd( clientNum, &ent->client->pers.cmd );
ADDRFP4 0
INDIRI4
ARGI4
ADDRLP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 1384
ADDP4
ARGP4
ADDRGP4 trap_GetUsercmd
CALLV
pop
line 1771
;1768:
;1769:	// mark the time we got info, so we can display the
;1770:	// phone jack if they don't get any for a while
;1771:	ent->client->lastCmdTime = level.time;
ADDRLP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 1596
ADDP4
ADDRGP4 level+32
INDIRI4
ASGNI4
line 1773
;1772:
;1773:	if ( !(ent->r.svFlags & SVF_BOT) && !g_synchronousClients.integer ) {
ADDRLP4 4
CNSTI4 0
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 304
ADDP4
INDIRI4
CNSTI4 8
BANDI4
ADDRLP4 4
INDIRI4
NEI4 $797
ADDRGP4 g_synchronousClients+12
INDIRI4
ADDRLP4 4
INDIRI4
NEI4 $797
line 1774
;1774:		ClientThink_real( ent );
ADDRLP4 0
INDIRP4
ARGP4
ADDRGP4 ClientThink_real
CALLV
pop
line 1775
;1775:	}
LABELV $797
line 1776
;1776:}
LABELV $795
endproc ClientThink 8 8
export G_RunClient
proc G_RunClient 4 4
line 1779
;1777:
;1778:
;1779:void G_RunClient( gentity_t *ent ) {
line 1780
;1780:	if ( !(ent->r.svFlags & SVF_BOT) && !g_synchronousClients.integer ) {
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRFP4 0
INDIRP4
CNSTI4 304
ADDP4
INDIRI4
CNSTI4 8
BANDI4
ADDRLP4 0
INDIRI4
NEI4 $801
ADDRGP4 g_synchronousClients+12
INDIRI4
ADDRLP4 0
INDIRI4
NEI4 $801
line 1781
;1781:		return;
ADDRGP4 $800
JUMPV
LABELV $801
line 1783
;1782:	}
;1783:	ent->client->pers.cmd.serverTime = level.time;
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 1384
ADDP4
ADDRGP4 level+32
INDIRI4
ASGNI4
line 1784
;1784:	ClientThink_real( ent );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 ClientThink_real
CALLV
pop
line 1785
;1785:}
LABELV $800
endproc G_RunClient 4 4
export SpectatorClientEndFrame
proc SpectatorClientEndFrame 24 8
line 1794
;1786:
;1787:
;1788:/*
;1789:==================
;1790:SpectatorClientEndFrame
;1791:
;1792:==================
;1793:*/
;1794:void SpectatorClientEndFrame( gentity_t *ent ) {
line 1798
;1795:	gclient_t	*cl;
;1796:
;1797:	// if we are doing a chase cam or a remote view, grab the latest info
;1798:	if ( ent->client->sess.spectatorState == SPECTATOR_FOLLOW ) {
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 1544
ADDP4
INDIRI4
CNSTI4 2
NEI4 $806
line 1801
;1799:		int		clientNum, flags;
;1800:
;1801:		clientNum = ent->client->sess.spectatorClient;
ADDRLP4 4
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 1548
ADDP4
INDIRI4
ASGNI4
line 1804
;1802:
;1803:		// team follow1 and team follow2 go to whatever clients are playing
;1804:		if ( clientNum == -1 ) {
ADDRLP4 4
INDIRI4
CNSTI4 -1
NEI4 $808
line 1805
;1805:			clientNum = level.follow1;
ADDRLP4 4
ADDRGP4 level+212
INDIRI4
ASGNI4
line 1806
;1806:		} else if ( clientNum == -2 ) {
ADDRGP4 $809
JUMPV
LABELV $808
ADDRLP4 4
INDIRI4
CNSTI4 -2
NEI4 $811
line 1807
;1807:			clientNum = level.follow2;
ADDRLP4 4
ADDRGP4 level+216
INDIRI4
ASGNI4
line 1808
;1808:		}
LABELV $811
LABELV $809
line 1809
;1809:		if ( clientNum >= 0 ) {
ADDRLP4 4
INDIRI4
CNSTI4 0
LTI4 $814
line 1810
;1810:			cl = &level.clients[ clientNum ];
ADDRLP4 0
CNSTI4 1804
ADDRLP4 4
INDIRI4
MULI4
ADDRGP4 level
INDIRP4
ADDP4
ASGNP4
line 1811
;1811:			if ( cl->pers.connected == CON_CONNECTED && cl->sess.sessionTeam != TEAM_SPECTATOR ) {
ADDRLP4 12
ADDRLP4 0
INDIRP4
ASGNP4
ADDRLP4 12
INDIRP4
CNSTI4 1380
ADDP4
INDIRI4
CNSTI4 2
NEI4 $816
ADDRLP4 12
INDIRP4
CNSTI4 1536
ADDP4
INDIRI4
CNSTI4 3
EQI4 $816
line 1812
;1812:				flags = (cl->ps.eFlags & ~(EF_VOTED | EF_TEAMVOTED)) | (ent->client->ps.eFlags & (EF_VOTED | EF_TEAMVOTED));
ADDRLP4 16
CNSTI4 108
ASGNI4
ADDRLP4 8
ADDRLP4 0
INDIRP4
ADDRLP4 16
INDIRI4
ADDP4
INDIRI4
CNSTI4 -540673
BANDI4
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
ADDRLP4 16
INDIRI4
ADDP4
INDIRI4
CNSTI4 540672
BANDI4
BORI4
ASGNI4
line 1813
;1813:				ent->client->ps = cl->ps;
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
ADDRLP4 0
INDIRP4
INDIRB
ASGNB 1380
line 1814
;1814:				ent->client->ps.pm_flags |= PMF_FOLLOW;
ADDRLP4 20
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 12
ADDP4
ASGNP4
ADDRLP4 20
INDIRP4
ADDRLP4 20
INDIRP4
INDIRI4
CNSTI4 4096
BORI4
ASGNI4
line 1815
;1815:				ent->client->ps.eFlags = flags;
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 108
ADDP4
ADDRLP4 8
INDIRI4
ASGNI4
line 1816
;1816:				return;
ADDRGP4 $805
JUMPV
LABELV $816
line 1817
;1817:			} else {
line 1819
;1818:				// drop them to free spectators unless they are dedicated camera followers
;1819:				if ( ent->client->sess.spectatorClient >= 0 ) {
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 1548
ADDP4
INDIRI4
CNSTI4 0
LTI4 $818
line 1820
;1820:					ent->client->sess.spectatorState = SPECTATOR_FREE;
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 1544
ADDP4
CNSTI4 1
ASGNI4
line 1821
;1821:					ClientBegin( ent->client - level.clients, qtrue );
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CVPU4 4
ADDRGP4 level
INDIRP4
CVPU4 4
SUBU4
CVUI4 4
CNSTI4 1804
DIVI4
ARGI4
CNSTI4 1
ARGI4
ADDRGP4 ClientBegin
CALLV
pop
line 1822
;1822:				}
LABELV $818
line 1823
;1823:			}
line 1824
;1824:		}
LABELV $814
line 1825
;1825:	}
LABELV $806
line 1827
;1826:
;1827:	if ( ent->client->sess.spectatorState == SPECTATOR_SCOREBOARD ) {
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 1544
ADDP4
INDIRI4
CNSTI4 3
NEI4 $820
line 1828
;1828:		ent->client->ps.pm_flags |= PMF_SCOREBOARD;
ADDRLP4 4
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 12
ADDP4
ASGNP4
ADDRLP4 4
INDIRP4
ADDRLP4 4
INDIRP4
INDIRI4
CNSTI4 8192
BORI4
ASGNI4
line 1829
;1829:	} else {
ADDRGP4 $821
JUMPV
LABELV $820
line 1830
;1830:		ent->client->ps.pm_flags &= ~PMF_SCOREBOARD;
ADDRLP4 4
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 12
ADDP4
ASGNP4
ADDRLP4 4
INDIRP4
ADDRLP4 4
INDIRP4
INDIRI4
CNSTI4 -8193
BANDI4
ASGNI4
line 1831
;1831:	}
LABELV $821
line 1832
;1832:}
LABELV $805
endproc SpectatorClientEndFrame 24 8
export ClientEndFrame
proc ClientEndFrame 20 16
line 1843
;1833:
;1834:/*
;1835:==============
;1836:ClientEndFrame
;1837:
;1838:Called at the end of each server frame for each connected client
;1839:A fast client will have multiple ClientThink for each ClientEdFrame,
;1840:while a slow client may have multiple ClientEndFrame between ClientThink.
;1841:==============
;1842:*/
;1843:void ClientEndFrame( gentity_t *ent ) {
line 1847
;1844:	int			i;
;1845:	clientPersistant_t	*pers;
;1846:
;1847:	if ( ent->client->sess.sessionTeam == TEAM_SPECTATOR ) {
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 1536
ADDP4
INDIRI4
CNSTI4 3
NEI4 $823
line 1848
;1848:		SpectatorClientEndFrame( ent );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 SpectatorClientEndFrame
CALLV
pop
line 1849
;1849:		return;
ADDRGP4 $822
JUMPV
LABELV $823
line 1852
;1850:	}
;1851:
;1852:	pers = &ent->client->pers;
ADDRLP4 4
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 1380
ADDP4
ASGNP4
line 1855
;1853:
;1854:	// turn off any expired powerups
;1855:	for ( i = 0 ; i < MAX_POWERUPS ; i++ ) {
ADDRLP4 0
CNSTI4 0
ASGNI4
LABELV $825
line 1856
;1856:		if ( ent->client->ps.powerups[ i ] < level.time ) {
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 344
ADDP4
ADDP4
INDIRI4
ADDRGP4 level+32
INDIRI4
GEI4 $829
line 1857
;1857:			ent->client->ps.powerups[ i ] = 0;
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 344
ADDP4
ADDP4
CNSTI4 0
ASGNI4
line 1858
;1858:		}
LABELV $829
line 1859
;1859:	}
LABELV $826
line 1855
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 16
LTI4 $825
line 1873
;1860:
;1861:	// save network bandwidth
;1862:#if 0
;1863:	if ( !g_synchronousClients->integer && (ent->client->ps.pm_type == PM_NORMAL || ent->client->ps.pm_type == PM_FLOAT) ) {
;1864:		// FIXME: this must change eventually for non-sync demo recording
;1865:		VectorClear( ent->client->ps.viewangles );
;1866:	}
;1867:#endif
;1868:
;1869:	//
;1870:	// If the end of unit layout is displayed, don't give
;1871:	// the player any normal movement attributes
;1872:	//
;1873:	if ( level.intermissiontime ) {
ADDRGP4 level+9008
INDIRI4
CNSTI4 0
EQI4 $832
line 1874
;1874:		return;
ADDRGP4 $822
JUMPV
LABELV $832
line 1878
;1875:	}
;1876:
;1877:	// burn from lava, etc
;1878:	P_WorldEffects (ent);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 P_WorldEffects
CALLV
pop
line 1881
;1879:
;1880:	// apply all the damage taken this frame
;1881:	P_DamageFeedback (ent);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 P_DamageFeedback
CALLV
pop
line 1884
;1882:
;1883:	// add the EF_CONNECTION flag if we haven't gotten commands recently
;1884:	if ( level.time - ent->client->lastCmdTime > 1000 ) {
ADDRGP4 level+32
INDIRI4
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 1596
ADDP4
INDIRI4
SUBI4
CNSTI4 1000
LEI4 $835
line 1885
;1885:		ent->s.eFlags |= EF_CONNECTION;
ADDRLP4 8
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
ASGNP4
ADDRLP4 8
INDIRP4
ADDRLP4 8
INDIRP4
INDIRI4
CNSTI4 8192
BORI4
ASGNI4
line 1886
;1886:	} else {
ADDRGP4 $836
JUMPV
LABELV $835
line 1887
;1887:		ent->s.eFlags &= ~EF_CONNECTION;
ADDRLP4 8
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
ASGNP4
ADDRLP4 8
INDIRP4
ADDRLP4 8
INDIRP4
INDIRI4
CNSTI4 -8193
BANDI4
ASGNI4
line 1888
;1888:	}
LABELV $836
line 1890
;1889:
;1890:	ent->client->ps.stats[STAT_HEALTH] = ent->health;	// FIXME: get rid of ent->health...
ADDRLP4 8
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 8
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
CNSTI4 216
ADDP4
ADDRLP4 8
INDIRP4
CNSTI4 676
ADDP4
INDIRI4
ASGNI4
line 1892
;1891:
;1892:	G_SetClientSound (ent);
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 G_SetClientSound
CALLV
pop
line 1895
;1893:
;1894:	// set the latest infor
;1895:	if (g_smoothClients.integer) {
ADDRGP4 g_smoothClients+12
INDIRI4
CNSTI4 0
EQI4 $838
line 1896
;1896:		BG_PlayerStateToEntityStateExtraPolate( &ent->client->ps, &ent->s, ent->client->ps.commandTime, qtrue );
ADDRLP4 12
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 16
ADDRLP4 12
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
ASGNP4
ADDRLP4 16
INDIRP4
ARGP4
ADDRLP4 12
INDIRP4
ARGP4
ADDRLP4 16
INDIRP4
INDIRI4
ARGI4
CNSTI4 1
ARGI4
ADDRGP4 BG_PlayerStateToEntityStateExtraPolate
CALLV
pop
line 1897
;1897:	}
ADDRGP4 $839
JUMPV
LABELV $838
line 1898
;1898:	else {
line 1899
;1899:		BG_PlayerStateToEntityState( &ent->client->ps, &ent->s, qtrue );
ADDRLP4 12
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 12
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
ARGP4
ADDRLP4 12
INDIRP4
ARGP4
CNSTI4 1
ARGI4
ADDRGP4 BG_PlayerStateToEntityState
CALLV
pop
line 1900
;1900:	}
LABELV $839
line 1901
;1901:	SendPendingPredictableEvents( &ent->client->ps );
ADDRFP4 0
INDIRP4
CNSTI4 408
ADDP4
INDIRP4
ARGP4
ADDRGP4 SendPendingPredictableEvents
CALLV
pop
line 1906
;1902:
;1903:	// set the bit for the reachability area the client is currently in
;1904://	i = trap_AAS_PointReachabilityAreaIndex( ent->client->ps.origin );
;1905://	ent->client->areabits[i >> 3] |= 1 << (i & 7);
;1906:}
LABELV $822
endproc ClientEndFrame 20 16
import saberOnSound
import saberOffSound
import G_ApplyKnockback
import PM_SaberInReturn
import PM_SaberInStart
import PM_SaberInTransition
import trap_ROFF_Purge_Ent
import trap_ROFF_Play
import trap_ROFF_Cache
import trap_ROFF_UpdateEntities
import trap_ROFF_Clean
import trap_SP_GetStringTextString
import trap_SP_Register
import trap_SP_RegisterServer
import trap_SnapVector
import trap_GeneticParentsAndChildSelection
import trap_BotResetWeaponState
import trap_BotFreeWeaponState
import trap_BotAllocWeaponState
import trap_BotLoadWeaponWeights
import trap_BotGetWeaponInfo
import trap_BotChooseBestFightWeapon
import trap_BotAddAvoidSpot
import trap_BotInitMoveState
import trap_BotFreeMoveState
import trap_BotAllocMoveState
import trap_BotPredictVisiblePosition
import trap_BotMovementViewTarget
import trap_BotReachabilityArea
import trap_BotResetLastAvoidReach
import trap_BotResetAvoidReach
import trap_BotMoveInDirection
import trap_BotMoveToGoal
import trap_BotResetMoveState
import trap_BotFreeGoalState
import trap_BotAllocGoalState
import trap_BotMutateGoalFuzzyLogic
import trap_BotSaveGoalFuzzyLogic
import trap_BotInterbreedGoalFuzzyLogic
import trap_BotFreeItemWeights
import trap_BotLoadItemWeights
import trap_BotUpdateEntityItems
import trap_BotInitLevelItems
import trap_BotSetAvoidGoalTime
import trap_BotAvoidGoalTime
import trap_BotGetLevelItemGoal
import trap_BotGetMapLocationGoal
import trap_BotGetNextCampSpotGoal
import trap_BotItemGoalInVisButNotVisible
import trap_BotTouchingGoal
import trap_BotChooseNBGItem
import trap_BotChooseLTGItem
import trap_BotGetSecondGoal
import trap_BotGetTopGoal
import trap_BotGoalName
import trap_BotDumpGoalStack
import trap_BotDumpAvoidGoals
import trap_BotEmptyGoalStack
import trap_BotPopGoal
import trap_BotPushGoal
import trap_BotResetAvoidGoals
import trap_BotRemoveFromAvoidGoals
import trap_BotResetGoalState
import trap_BotSetChatName
import trap_BotSetChatGender
import trap_BotLoadChatFile
import trap_BotReplaceSynonyms
import trap_UnifyWhiteSpaces
import trap_BotMatchVariable
import trap_BotFindMatch
import trap_StringContains
import trap_BotGetChatMessage
import trap_BotEnterChat
import trap_BotChatLength
import trap_BotReplyChat
import trap_BotNumInitialChats
import trap_BotInitialChat
import trap_BotNumConsoleMessages
import trap_BotNextConsoleMessage
import trap_BotRemoveConsoleMessage
import trap_BotQueueConsoleMessage
import trap_BotFreeChatState
import trap_BotAllocChatState
import trap_Characteristic_String
import trap_Characteristic_BInteger
import trap_Characteristic_Integer
import trap_Characteristic_BFloat
import trap_Characteristic_Float
import trap_BotFreeCharacter
import trap_BotLoadCharacter
import trap_EA_ResetInput
import trap_EA_GetInput
import trap_EA_EndRegular
import trap_EA_ForcePower
import trap_EA_Alt_Attack
import trap_EA_View
import trap_EA_Move
import trap_EA_DelayedJump
import trap_EA_Jump
import trap_EA_SelectWeapon
import trap_EA_MoveRight
import trap_EA_MoveLeft
import trap_EA_MoveBack
import trap_EA_MoveForward
import trap_EA_MoveDown
import trap_EA_MoveUp
import trap_EA_Crouch
import trap_EA_Respawn
import trap_EA_Use
import trap_EA_Attack
import trap_EA_Talk
import trap_EA_Gesture
import trap_EA_Action
import trap_EA_Command
import trap_EA_SayTeam
import trap_EA_Say
import trap_AAS_PredictClientMovement
import trap_AAS_Swimming
import trap_AAS_AlternativeRouteGoals
import trap_AAS_PredictRoute
import trap_AAS_EnableRoutingArea
import trap_AAS_AreaTravelTimeToGoalArea
import trap_AAS_AreaReachability
import trap_AAS_IntForBSPEpairKey
import trap_AAS_FloatForBSPEpairKey
import trap_AAS_VectorForBSPEpairKey
import trap_AAS_ValueForBSPEpairKey
import trap_AAS_NextBSPEntity
import trap_AAS_PointContents
import trap_AAS_TraceAreas
import trap_AAS_PointReachabilityAreaIndex
import trap_AAS_PointAreaNum
import trap_AAS_Time
import trap_AAS_PresenceTypeBoundingBox
import trap_AAS_Initialized
import trap_AAS_EntityInfo
import trap_AAS_AreaInfo
import trap_AAS_BBoxAreas
import trap_BotUserCommand
import trap_BotGetServerCommand
import trap_BotGetSnapshotEntity
import trap_BotLibTest
import trap_BotLibUpdateEntity
import trap_BotLibLoadMap
import trap_BotLibStartFrame
import trap_BotLibDefine
import trap_BotLibVarGet
import trap_BotLibVarSet
import trap_BotLibShutdown
import trap_BotLibSetup
import trap_DebugPolygonDelete
import trap_DebugPolygonCreate
import trap_GetEntityToken
import trap_GetUsercmd
import trap_BotFreeClient
import trap_BotAllocateClient
import trap_EntityContact
import trap_EntitiesInBox
import trap_UnlinkEntity
import trap_LinkEntity
import trap_AreasConnected
import trap_AdjustAreaPortalState
import trap_InPVSIgnorePortals
import trap_InPVS
import trap_PointContents
import trap_Trace
import trap_SetBrushModel
import trap_GetServerinfo
import trap_SetUserinfo
import trap_GetUserinfo
import trap_GetConfigstring
import trap_SetConfigstring
import trap_SendServerCommand
import trap_DropClient
import trap_LocateGameData
import trap_Cvar_VariableStringBuffer
import trap_Cvar_VariableValue
import trap_Cvar_VariableIntegerValue
import trap_Cvar_Set
import trap_Cvar_Update
import trap_Cvar_Register
import trap_SendConsoleCommand
import trap_FS_GetFileList
import trap_FS_FCloseFile
import trap_FS_Write
import trap_FS_Read
import trap_FS_FOpenFile
import trap_Args
import trap_Argv
import trap_Argc
import trap_Milliseconds
import trap_Error
import trap_Printf
import g_austrian
import g_saberDebugPrint
import g_saberDmgDelay_Wound
import g_saberDmgDelay_Idle
import g_saberDmgVelocityScale
import g_timeouttospec
import g_forceDodge
import g_dismember
import g_singlePlayer
import g_enableBreath
import g_enableDust
import g_rankings
import pmove_msec
import pmove_fixed
import g_smoothClients
import g_blueteam
import g_redteam
import g_debugUp
import g_debugRight
import g_debugForward
import g_filterBan
import g_banIPs
import g_teamForceBalance
import g_teamAutoJoin
import g_allowVote
import g_blood
import g_doWarmup
import g_warmup
import g_motd
import g_synchronousClients
import g_adaptRespawn
import g_weaponTeamRespawn
import g_weaponRespawn
import g_debugDamage
import g_debugAlloc
import g_debugMove
import g_inactivity
import g_forcerespawn
import g_quadfactor
import g_knockback
import g_speed
import g_gravity
import g_needpass
import g_password
import g_friendlySaber
import g_friendlyFire
import g_saberInterpolate
import g_capturelimit
import g_timelimit
import g_duel_fraglimit
import g_fraglimit
import g_duelWeaponDisable
import g_fraglimitVoteCorrection
import g_allowDuelSuicide
import g_weaponDisable
import g_forcePowerDisable
import g_spawnInvulnerability
import g_forceRegenTime
import g_saberDamageScale
import g_slowmoDuelEnd
import g_logClientInfo
import g_saberBoxTraceSize
import g_saberAlwaysBoxTrace
import g_saberGhoul2Collision
import g_saberTraceSaberFirst
import g_saberLockFactor
import g_saberLocking
import g_privateDuel
import g_forceBasedTeams
import g_maxForceRank
import g_dmflags
import g_autoMapCycle
import g_trueJedi
import g_restarted
import g_maxGameClients
import g_maxclients
import g_cheats
import g_dedicated
import g_gametype
import g_vehicles
import g_vehicleTemplates
import vehicleId
import VehicleTemplateArray_GetTemplateIndexForName
import VehicleTemplateArray_OutputTemplates
import VehicleTemplateArray_InitVehicleTemplateArray
import VehicleArray_OutputVehicles
import VehicleArray_RemoveVehicleForId
import VehicleArray_AddVehicle
import VehicleArray_SetVehicleForId
import VehicleArray_GetVehicleForId
import VehicleArray_InitVehicleArray
import G_SpawnVehicle
import Touch_Vehicle
import VehicleInfo_GetNameForMovementType
import VehicleInfo_GetBitForMovementType
import VehicleInfo_GetNameForWeapon
import VehicleInfo_GetIndexForWeapon
import VehicleInfo_GetBitForWeapon
import VehicleInfo_GetBitForVehicleType
import Vehicle_CopyVehicle
import Vehicle_InitVehicle
import g_entities
import level
import Pickup_Team
import CheckTeamStatus
import TeamplayInfoMessage
import Team_GetLocationMsg
import Team_GetLocation
import SelectSagaSpawnPoint
import SelectCTFSpawnPoint
import Team_FreeEntity
import Team_ReturnFlag
import Team_InitGame
import Team_CheckHurtCarrier
import Team_FragBonuses
import Team_DroppedFlagThink
import AddTeamScore
import TeamColorString
import OtherTeamName
import TeamName
import OtherTeam
import BotAIStartFrame
import BotAIShutdownClient
import BotAISetupClient
import BotAILoadMap
import BotAIShutdown
import BotAISetup
import B_CleanupAlloc
import B_InitAlloc
import InFieldOfVision
import BotOrder
import OrgVisible
import InitSagaMode
import G_ClearClientLog
import G_LogExit
import G_LogWeaponOutput
import G_LogWeaponInit
import G_LogWeaponItem
import G_LogWeaponPowerup
import G_LogWeaponFrag
import G_LogWeaponDeath
import G_LogWeaponKill
import G_LogWeaponDamage
import G_LogWeaponFire
import G_LogWeaponPickup
import Jedi_DodgeEvasion
import ForceTelepathy
import ForceThrow
import ForceSeeing
import ForceTeamForceReplenish
import ForceTeamHeal
import ForceAbsorb
import ForceProtect
import ForceGrip
import ForceRage
import ForceSpeed
import ForceHeal
import ForcePowerUsableOn
import WP_ForcePowersUpdate
import WP_SpawnInitForcePowers
import WP_InitForcePowers
import WP_SaberInitBladeData
import WP_SaberCanBlock
import WP_SaberPositionUpdate
import WP_ForcePowerStop
import HasSetSaberOnly
import G_PreDefSound
import G_RefreshNextMap
import G_DoesMapSupportGametype
import BotInterbreedEndMatch
import Svcmd_BotList_f
import Svcmd_AddBot_f
import G_BotConnect
import G_RemoveQueuedBotBegin
import G_CheckBotSpawn
import G_GetBotInfoByName
import G_GetBotInfoByNumber
import G_InitBots
import UpdateTournamentInfo
import G_WriteSessionData
import G_InitWorldSession
import G_InitSessionData
import G_ReadSessionData
import Svcmd_GameMem_f
import G_InitMemory
import G_Alloc
import Team_CheckDroppedItem
import OnSameTeam
import ClientCommand
import ClientBegin
import ClientDisconnect
import ClientUserinfoChanged
import ClientConnect
import G_GetStripEdString
import G_Error
import G_Printf
import SendScoreboardMessageToAllClients
import G_LogPrintf
import G_RunThink
import CheckTeamLeader
import SetLeader
import FindIntermissionPoint
import gSlowMoDuelTime
import gDoSlowMoDuel
import g_ff_objectives
import DeathmatchScoreboardMessage
import G_SetStats
import MoveClientToIntermission
import BlowDetpacks
import FireWeapon
import G_FilterPacket
import G_ProcessIPBans
import ConsoleCommand
import gJMSaberEnt
import SpotWouldTelefrag
import CalculateRanks
import AddScore
import player_die
import ClientSpawn
import InitBodyQue
import BeginIntermission
import respawn
import CopyToBodyQue
import SelectSpawnPoint
import SetClientViewAngle
import PickTeam
import TeamLeader
import TeamCount
import CheckGauntletAttack
import SnapVectorTowards
import CalcMuzzlePoint
import LogAccuracyHit
import WP_FireGenericBlasterMissile
import WP_FireTurretMissile
import G_CreateExampleAnimEnt
import G_PlayerBecomeATST
import ATST_ManageDamageBoxes
import TeleportPlayer
import trigger_teleporter_touch
import Touch_DoorTrigger
import G_RunMover
import WP_FireBlasterMissile
import G_ExplodeMissile
import G_BounceProjectile
import CreateMissile
import G_RunMissile
import G_ReflectMissile
import gGAvoidDismember
import G_CheckForDismemberment
import ExplodeDeath
import TossClientCubes
import TossClientItems
import TossClientWeapon
import body_die
import G_RadiusDamage
import G_Damage
import CanDamage
import trap_G2API_SetBoneAnim
import trap_G2API_GetGLAName
import trap_G2API_SetBoneAngles
import trap_G2API_CollisionDetect
import trap_G2API_CleanGhoul2Models
import trap_G2API_RemoveGhoul2Model
import trap_G2API_HasGhoul2ModelOnIndex
import trap_G2API_DuplicateGhoul2Instance
import trap_G2API_CopySpecificGhoul2Model
import trap_G2API_CopyGhoul2Instance
import trap_G2API_SetBoltInfo
import trap_G2API_AddBolt
import trap_G2API_InitGhoul2Model
import trap_G2API_GetBoltMatrix_NoRecNoRot
import trap_G2API_GetBoltMatrix_NoReconstruct
import trap_G2API_GetBoltMatrix
import trap_G2_HaveWeGhoul2Models
import trap_G2_SetGhoul2ModelIndexes
import trap_G2_ListModelBones
import trap_G2_ListModelSurfaces
import G_SkinIndex
import BuildShaderStateConfig
import AddRemap
import G_SetOrigin
import G_AddEvent
import G_AddPredictableEvent
import vtos
import tv
import G_RunObject
import G_TouchSolids
import G_EntitiesFree
import G_FreeEntity
import G_KillG2Queue
import G_SendG2KillQueue
import TryUse
import G_EntitySound
import G_SoundAtLoc
import G_Sound
import G_MuteSound
import G_ScreenShake
import G_PlayEffect
import G_TempEntity
import G_Spawn
import G_InitGentity
import G_SetAngles
import G_SetMovedir
import G_UseTargets
import G_PickTarget
import G_RadiusList
import G_Find
import G_KillBox
import G_TeamCommand
import G_EffectIndex
import G_SoundIndex
import G_ModelIndex
import SaveRegisteredItems
import RegisterItem
import ClearRegisteredItems
import Touch_Item
import Add_Ammo
import ArmorIndex
import Think_Weapon
import FinishSpawningItem
import G_SpawnItem
import SetRespawn
import LaunchItem
import Drop_Item
import PrecacheItem
import UseHoldableItem
import RespawnItem
import G_RunItem
import G_CheckTeamItems
import ItemUse_MedPack
import ItemUse_Seeker
import ItemUse_Sentry
import ItemUse_Shield
import ItemUse_Binoculars
import G_GetDuelWinner
import Cmd_EngageDuel_f
import Cmd_ToggleSaber_f
import G_ItemUsable
import Cmd_SaberAttackCycle_f
import Cmd_FollowCycle_f
import SetTeam
import BroadcastTeamChange
import StopFollowing
import Cmd_Score_f
import G_NewString
import G_SpawnEntitiesFromString
import G_SpawnVector
import G_SpawnInt
import G_SpawnFloat
import G_SpawnString
import gEscapeTime
import gEscaping
import g2SaberInstance
import precachedKyle
import forcePowerDarkLight
import WeaponAttackAnim
import WeaponReadyAnim
import BG_OutOfMemory
import BG_StringAlloc
import BG_TempFree
import BG_TempAlloc
import BG_AllocUnaligned
import BG_Alloc
import BG_CanUseFPNow
import BG_HasYsalamiri
import BG_GetItemIndexByTag
import BG_ParseAnimationFile
import BG_PlayerTouchesItem
import BG_PlayerStateToEntityStateExtraPolate
import BG_PlayerStateToEntityState
import BG_TouchJumpPad
import BG_AddPredictableEventToPlayerstate
import BG_EvaluateTrajectoryDelta
import BG_EvaluateTrajectory
import BG_ForcePowerDrain
import BG_SaberStartTransAnim
import BG_InDeathAnim
import BG_InRoll
import BG_KnockawayForParry
import BG_BrokenParryForParry
import BG_BrokenParryForAttack
import BG_SaberInSpecialAttack
import BG_SpinningSaberAnim
import BG_FlippingAnim
import BG_SaberInIdle
import BG_SaberInSpecial
import BG_SaberInAttack
import BG_DirectFlippingAnim
import BG_InSaberStandAnim
import BG_InSpecialJump
import BG_LegalizedForcePowers
import saberMoveData
import BG_CanItemBeGrabbed
import BG_FindItemForHoldable
import BG_FindItemForPowerup
import BG_FindItemForWeapon
import BG_FindItem
import vectoyaw
import bg_numItems
import bg_itemlist
import PM_CalculateRelativeViewAngles
import Pmove
import PM_QuaternionViewAngles
import PM_UpdateViewAngles
import pm
import bgForcePowerCost
import forceMasteryPoints
import forceMasteryLevels
import bgGlobalAnimations
import BGPAFtextLoaded
import forcePowerSorted
import WP_MuzzlePoint
import ammoData
import weaponData
import GetStringForID
import GetIDForString
import Q_irand
import irand
import flrand
import Rand_Init
import Com_Printf
import Com_Error
import Info_NextPair
import Info_Validate
import Info_SetValueForKey_Big
import Info_SetValueForKey
import Info_RemoveKey_big
import Info_RemoveKey
import Info_ValueForKey
import va
import Q_CleanStr
import Q_PrintStrlen
import Q_strcat
import Q_strncpyz
import Q_strrchr
import Q_strupr
import Q_strlwr
import Q_stricmpn
import Q_strncmp
import Q_stricmp
import Q_isalpha
import Q_isupper
import Q_islower
import Q_isprint
import Com_sprintf
import Parse3DMatrix
import Parse2DMatrix
import Parse1DMatrix
import SkipRestOfLine
import SkipBracedSection
import COM_MatchToken
import COM_ParseVec4
import COM_ParseFloat
import COM_ParseInt
import COM_ParseString
import COM_ParseWarning
import COM_ParseError
import COM_Compress
import COM_ParseExt
import COM_Parse
import SkipWhitespace
import COM_GetCurrentParseLine
import COM_BeginParseSession
import COM_DefaultExtension
import COM_StripExtension
import COM_SkipPath
import Com_Clamp
import MatrixToEuler
import QuatToAngles
import QuatMul
import AnglesToQuat
import AxisToQuaternion
import QuaternionToAxis
import QuaternionToEuler
import QuatToAxis
import QuaternionMultiply
import QuaternionNormalize
import QuaternionMagnitude
import QuaternionFromString
import AnglesToTieFloats
import AnglesFromTieFloats
import QuaternionToTieFloats
import QuaternionFromTieFloats
import QuaternionCopy
import PerpendicularVector
import AngleVectors
import RotationMatrixAroundDir
import MatrixMultiply
import MakeNormalVectors
import RotateAroundDirection
import RotatePointAroundVector
import ProjectPointOnPlane
import PlaneFromPoints
import AngleDelta
import AngleNormalize180
import AngleNormalize360
import AnglesSubtract
import AngleSubtract
import LerpAngle
import AngleMod
import BoxOnPlaneSide
import SetPlaneSignbits
import AxisCopy
import AxisClear
import AnglesToAxis
import vectoangles
import Q_crandom
import Q_random
import Q_rand
import Q_acos
import Q_log2
import VectorRotate
import Vector4Scale
import VectorNormalize2
import VectorNormalize
import CrossProduct
import VectorInverse
import VectorNormalizeFast
import DistanceSquared
import Distance
import VectorLengthSquared
import VectorLength
import VectorCompare
import AddPointToBounds
import ClearBounds
import RadiusFromBounds
import NormalizeColor
import ColorBytes4
import ColorBytes3
import _VectorMA
import _VectorScale
import _VectorCopy
import _VectorAdd
import _VectorSubtract
import _DotProduct
import ByteToDir
import DirToByte
import powf
import ClampShort
import ClampChar
import Q_rsqrt
import Q_fabs
import axisDefault
import vec3_origin
import g_color_table
import colorDkBlue
import colorLtBlue
import colorDkGrey
import colorMdGrey
import colorLtGrey
import colorWhite
import colorCyan
import colorMagenta
import colorYellow
import colorBlue
import colorGreen
import colorRed
import colorBlack
import colorTable
import bytedirs
import Com_Memcpy
import Com_Memset
import Hunk_Alloc
import forceSpeedLevels
import FloatSwap
import LongSwap
import ShortSwap
import acos
import fabs
import abs
import tan
import atan2
import cos
import sin
import sqrt
import floor
import ceil
import memcpy
import memset
import memmove
import sscanf
import vsprintf
import _atoi
import atoi
import _atof
import atof
import toupper
import tolower
import strncpy
import strstr
import strchr
import strcmp
import strcpy
import strcat
import strlen
import rand
import srand
import qsort
lit
align 1
LABELV $794
byte 1 115
byte 1 112
byte 1 101
byte 1 99
byte 1 116
byte 1 97
byte 1 116
byte 1 111
byte 1 114
byte 1 0
align 1
LABELV $768
byte 1 115
byte 1 111
byte 1 117
byte 1 110
byte 1 100
byte 1 47
byte 1 119
byte 1 101
byte 1 97
byte 1 112
byte 1 111
byte 1 110
byte 1 115
byte 1 47
byte 1 109
byte 1 101
byte 1 108
byte 1 101
byte 1 101
byte 1 47
byte 1 112
byte 1 117
byte 1 110
byte 1 99
byte 1 104
byte 1 37
byte 1 100
byte 1 0
align 1
LABELV $658
byte 1 37
byte 1 102
byte 1 44
byte 1 37
byte 1 102
byte 1 44
byte 1 37
byte 1 102
byte 1 0
align 1
LABELV $657
byte 1 37
byte 1 102
byte 1 44
byte 1 37
byte 1 102
byte 1 44
byte 1 37
byte 1 102
byte 1 44
byte 1 37
byte 1 102
byte 1 0
align 1
LABELV $624
byte 1 99
byte 1 101
byte 1 110
byte 1 116
byte 1 101
byte 1 114
byte 1 118
byte 1 105
byte 1 101
byte 1 119
byte 1 10
byte 1 0
align 1
LABELV $555
byte 1 80
byte 1 76
byte 1 68
byte 1 85
byte 1 69
byte 1 76
byte 1 83
byte 1 84
byte 1 79
byte 1 80
byte 1 0
align 1
LABELV $554
byte 1 112
byte 1 114
byte 1 105
byte 1 110
byte 1 116
byte 1 32
byte 1 34
byte 1 37
byte 1 115
byte 1 10
byte 1 34
byte 1 0
align 1
LABELV $549
byte 1 80
byte 1 76
byte 1 68
byte 1 85
byte 1 69
byte 1 76
byte 1 84
byte 1 73
byte 1 69
byte 1 0
align 1
LABELV $548
byte 1 99
byte 1 112
byte 1 32
byte 1 34
byte 1 37
byte 1 115
byte 1 10
byte 1 34
byte 1 0
align 1
LABELV $547
byte 1 80
byte 1 76
byte 1 68
byte 1 85
byte 1 69
byte 1 76
byte 1 87
byte 1 73
byte 1 78
byte 1 78
byte 1 69
byte 1 82
byte 1 0
align 1
LABELV $546
byte 1 83
byte 1 86
byte 1 73
byte 1 78
byte 1 71
byte 1 65
byte 1 77
byte 1 69
byte 1 0
align 1
LABELV $545
byte 1 99
byte 1 112
byte 1 32
byte 1 34
byte 1 37
byte 1 115
byte 1 32
byte 1 37
byte 1 115
byte 1 32
byte 1 37
byte 1 115
byte 1 33
byte 1 10
byte 1 34
byte 1 0
align 1
LABELV $520
byte 1 115
byte 1 111
byte 1 117
byte 1 110
byte 1 100
byte 1 47
byte 1 119
byte 1 101
byte 1 97
byte 1 112
byte 1 111
byte 1 110
byte 1 115
byte 1 47
byte 1 115
byte 1 97
byte 1 98
byte 1 101
byte 1 114
byte 1 47
byte 1 115
byte 1 97
byte 1 98
byte 1 101
byte 1 114
byte 1 111
byte 1 110
byte 1 46
byte 1 119
byte 1 97
byte 1 118
byte 1 0
align 1
LABELV $519
byte 1 115
byte 1 111
byte 1 117
byte 1 110
byte 1 100
byte 1 47
byte 1 119
byte 1 101
byte 1 97
byte 1 112
byte 1 111
byte 1 110
byte 1 115
byte 1 47
byte 1 115
byte 1 97
byte 1 98
byte 1 101
byte 1 114
byte 1 47
byte 1 115
byte 1 97
byte 1 98
byte 1 101
byte 1 114
byte 1 111
byte 1 102
byte 1 102
byte 1 113
byte 1 117
byte 1 105
byte 1 99
byte 1 107
byte 1 46
byte 1 119
byte 1 97
byte 1 118
byte 1 0
align 1
LABELV $472
byte 1 51
byte 1 51
byte 1 0
align 1
LABELV $468
byte 1 56
byte 1 0
align 1
LABELV $467
byte 1 112
byte 1 109
byte 1 111
byte 1 118
byte 1 101
byte 1 95
byte 1 109
byte 1 115
byte 1 101
byte 1 99
byte 1 0
align 1
LABELV $357
byte 1 99
byte 1 112
byte 1 32
byte 1 34
byte 1 84
byte 1 101
byte 1 110
byte 1 32
byte 1 115
byte 1 101
byte 1 99
byte 1 111
byte 1 110
byte 1 100
byte 1 115
byte 1 32
byte 1 117
byte 1 110
byte 1 116
byte 1 105
byte 1 108
byte 1 32
byte 1 105
byte 1 110
byte 1 97
byte 1 99
byte 1 116
byte 1 105
byte 1 118
byte 1 105
byte 1 116
byte 1 121
byte 1 32
byte 1 100
byte 1 114
byte 1 111
byte 1 112
byte 1 33
byte 1 10
byte 1 34
byte 1 0
align 1
LABELV $353
byte 1 68
byte 1 114
byte 1 111
byte 1 112
byte 1 112
byte 1 101
byte 1 100
byte 1 32
byte 1 100
byte 1 117
byte 1 101
byte 1 32
byte 1 116
byte 1 111
byte 1 32
byte 1 105
byte 1 110
byte 1 97
byte 1 99
byte 1 116
byte 1 105
byte 1 118
byte 1 105
byte 1 116
byte 1 121
byte 1 0
align 1
LABELV $137
byte 1 115
byte 1 111
byte 1 117
byte 1 110
byte 1 100
byte 1 47
byte 1 112
byte 1 108
byte 1 97
byte 1 121
byte 1 101
byte 1 114
byte 1 47
byte 1 103
byte 1 117
byte 1 114
byte 1 112
byte 1 50
byte 1 46
byte 1 119
byte 1 97
byte 1 118
byte 1 0
align 1
LABELV $134
byte 1 115
byte 1 111
byte 1 117
byte 1 110
byte 1 100
byte 1 47
byte 1 112
byte 1 108
byte 1 97
byte 1 121
byte 1 101
byte 1 114
byte 1 47
byte 1 103
byte 1 117
byte 1 114
byte 1 112
byte 1 49
byte 1 46
byte 1 119
byte 1 97
byte 1 118
byte 1 0
