#include "g_local.h"
#include "g_vehicles_parser.h"

char *Parser_ParseStats(char *ptr, int *vehiclenum) {
   int success = -1, i;
   
   char *new_ptr;
   int health = -1, armor = -1;

   new_ptr = ptr;

   //new_ptr = parser_strstr(new_ptr, "stats {\n");
   new_ptr = strstr(new_ptr, "stats {\n");

   // if we found the "weapons #" substring
   if(new_ptr) {
      //printf("        starting weapons for vehicle... \n");
      
      success = sscanf(new_ptr, "health %d\n", &health);
      if(success)
         g_vehicleTemplates[*vehiclenum].vehicleInfo.vehicleStats.health = health;

      success = sscanf(new_ptr, "armor %d\n", &armor);
      if(success)
         g_vehicleTemplates[*vehiclenum].vehicleInfo.vehicleStats.armor = armor;

		new_ptr = strstr(new_ptr, "}\n");

      return new_ptr;
   }
   return ptr;
}

char *Parser_ParseWeapon(char *ptr, int *weaponnum, int *vehiclenum) {
   int success = -1;
   char *new_ptr;

   char weapon_name[16];
   int weapon_ammo;
   
   new_ptr = ptr;

   //printf("          attempting to get the weapon...\n");
   //new_ptr = parser_strstr(new_ptr, "weapon ");
   new_ptr = strstr(new_ptr, "weapon ");

   if(new_ptr) {
      parser_clear_string(weapon_name, 16);
      success = sscanf(new_ptr, "weapon %s %d\n", weapon_name, &weapon_ammo);
      
      if(success) {
         //printf("          weapon %d: weapon_name: %s, weapon_ammo: %d\n", *weaponnum, weapon_name, weapon_ammo);
         
         // fill up the structs
         g_vehicleTemplates[*vehiclenum].vehicleInfo.weaponInfo.weapons |= VehicleInfo_GetBitForWeapon(weapon_name);
         g_vehicleTemplates[*vehiclenum].vehicleInfo.weaponInfo.ammo[VehicleInfo_GetIndexForWeapon(VehicleInfo_GetBitForWeapon(weapon_name))] = weapon_ammo;
         
         return new_ptr;
      }
   }
   
   return ptr;
}

char *Parser_ParseWeapons(char *ptr, int *vehiclenum) {
   int success = -1, i;
   
   char *new_ptr;
   int weapons = -1;

   new_ptr = ptr;

   //new_ptr = parser_strstr(new_ptr, "weapons ");
   new_ptr = strstr(new_ptr, "weapons ");

   // if we found the "weapons #" substring
   if(new_ptr) {
      //printf("        starting weapons for vehicle... \n");
      
      // read the number of classes from the current "weapons #" substring
      success = sscanf(new_ptr, "weapons %d {\n", &weapons);

      // if we read the number of weapons successfully
      if(success) {
         // parse items
         //printf("        weapons %d {\n", weapons);
         
         for(i = 0; i < weapons; i++) {
            new_ptr = Parser_ParseWeapon(new_ptr, &i, vehiclenum);
            
            // force it to the next line...
            // should fix this...
            new_ptr++;
         }
         
         //printf("        }\n");

			new_ptr = strstr(new_ptr, "}");
			new_ptr++;

         return new_ptr;
      }
   }
   return ptr;
}

char *Parser_ParseModel(char *ptr, int *vehiclenum, int *modelnum) {
	// dont actually process any of the info here...
	//  just parse it to properly skip it...
   int success = -1, i;
   
   char *new_ptr;

   new_ptr = ptr;

   //new_ptr = parser_strstr(new_ptr, "model {\n");
   new_ptr = strstr(new_ptr, "model ");

   if(new_ptr) {
		// skip them all
		/*
		new_ptr = parser_strstr(new_ptr, "path");
		new_ptr = parser_strstr(new_ptr, "skin");
		new_ptr = parser_strstr(new_ptr, "shader");
		new_ptr = parser_strstr(new_ptr, "g2radius");
		new_ptr = parser_strstr(new_ptr, "offset");
		new_ptr = parser_strstr(new_ptr, "scale");
		*/
		new_ptr = strstr(new_ptr, "path ");
		new_ptr = strstr(new_ptr, "skin ");
		new_ptr = strstr(new_ptr, "shader ");
		new_ptr = strstr(new_ptr, "g2radius ");
		new_ptr = strstr(new_ptr, "offset ");
		new_ptr = strstr(new_ptr, "angles ");
		new_ptr = strstr(new_ptr, "scale ");
		
		new_ptr = strstr(new_ptr, "}");
		new_ptr++;

		return new_ptr;
	}
   return ptr;
}

char *Parser_ParseModels(char *ptr, int *vehiclenum) {
	// dont actually process any of the info here...
	//  just parse it to skip it correctly
   int success = -1, i;
   
   char *new_ptr;
   int models = -1;
   
   new_ptr = ptr;

   //new_ptr = strstr(new_ptr, "models");
	new_ptr = strstr(new_ptr, "models");

   // if the "models #" substring exists, being processing vehicles
   if(new_ptr) {

      // read the number of vehicles to expect
      success = sscanf(new_ptr, "models %d {\n", &models);
      
      // if the number of vehicles exists and we read it properly
      if(success) {
         //printf("models %d {\n", models);
         
			if(models < MAX_VEHICLE_MODELS) {
				// process each model individually
				for(i = 0; i < models; i++) {
					new_ptr = Parser_ParseModel(new_ptr, vehiclenum, &i);
				}
			} else {
				for(i = 0; i < MAX_VEHICLE_MODELS; i++) {
					new_ptr = Parser_ParseModel(new_ptr, vehiclenum, &i);
				}
			}

			new_ptr = strstr(new_ptr, "}");
			new_ptr++;

         return new_ptr;
      }
   }
   return ptr;
}

char *Parser_ParseDisplay(char *ptr, int *vehiclenum) {
	// dont actually process any of the info here... 
	//  just parse it to properly skip it
   int success = -1, i;
   
   char *new_ptr;

   new_ptr = ptr;

   new_ptr = parser_strstr(new_ptr, "display ");

   if(new_ptr) {

		new_ptr = Parser_ParseModels(new_ptr, vehiclenum);
		
		new_ptr = parser_strstr(new_ptr, "}");
		new_ptr++;

      return new_ptr;
   }
   return ptr;
}

char *Parser_ParseSound(char *ptr, int *vehiclenum) {
	// dont actually process any of this info...
	//  just parse it to properly skip it
   int success = -1, i;
   
   char *new_ptr;

   new_ptr = ptr;

   //new_ptr = parser_strstr(new_ptr, "sound {\n");
   new_ptr = strstr(new_ptr, "sound {\n");

   if(new_ptr) {
      new_ptr = sscanf(new_ptr, "movesound1");
		new_ptr = sscanf(new_ptr, "movesound2");

      return new_ptr;
   }
   return ptr;
}

char *Parser_ParsePhysics(char *ptr, int *vehiclenum) {
   int success = -1, i;
   
   char *new_ptr;

   new_ptr = ptr;

   //new_ptr = parser_strstr(new_ptr, "physics {\n");
   new_ptr = strstr(new_ptr, "physics {\n");

   if(new_ptr) {
      char type[16];
      int width = -1, height = -1, maxspeed = -1;

      parser_clear_string(type, 16);

      success = sscanf(new_ptr, "type %s\n", &type);
      if(success)
         g_vehicleTemplates[*vehiclenum].vehicleInfo.physicsInfo.movementType = VehicleInfo_GetBitForMovementType(type);

      success = sscanf(new_ptr, "width %s\n", &width);
      if(success)
         g_vehicleTemplates[*vehiclenum].vehicleInfo.physicsInfo.width = width;

      success = sscanf(new_ptr, "height %s\n", &height);
      if(success)
         g_vehicleTemplates[*vehiclenum].vehicleInfo.physicsInfo.height = height;

      success = sscanf(new_ptr, "maxspeed %s\n", &maxspeed);
      if(success)
         g_vehicleTemplates[*vehiclenum].vehicleInfo.physicsInfo.maxSpeed = maxspeed;

		//new_ptr = strstr(new_ptr, "}\n");

      return new_ptr;
   }
   return ptr;
}

char *Parser_ParseVehicle(char *ptr, int *vehiclenum) {
   char *new_ptr;
   int success = -1;
   char vehiclename[MAX_QPATH];

	int i = 0;

   new_ptr = ptr;
   new_ptr = strstr(new_ptr, "vehicle ");
      
   // if the "vehicle #" substring exists...
   if(new_ptr) {
      g_vehicleTemplates[*vehiclenum].templateNum = *vehiclenum;

      parser_clear_string(vehiclename, MAX_QPATH);
      // scan the vehicle # from the "vehicle #" substring
      success = sscanf(new_ptr, "vehicle %s {\n", vehiclename);
            
      // process current vehicle
      if(success) {
         char vehicletype[MAX_QPATH];
         parser_clear_string(vehicletype, MAX_QPATH);

         //printf("      vehiclename %d: vehiclename name: %s {\n", *vehiclenum, vehiclename);
         
         // fill the structs

         strcpy(g_vehicleTemplates[*vehiclenum].vehicleInfo.vehicleName, vehiclename);

			Com_Printf("GAME: PARSED VEHICLE: %s\n", g_vehicleTemplates[*vehiclenum].vehicleInfo.vehicleName);

         // scan the type
			new_ptr = strstr(new_ptr, "type ");
         success = sscanf(new_ptr, "type %s {\n", vehicletype);
         g_vehicleTemplates[*vehiclenum].vehicleInfo.vehicleType = VehicleInfo_GetBitForVehicleType(vehicletype);
         
         new_ptr = Parser_ParseStats(new_ptr, vehiclenum);
         new_ptr = Parser_ParseWeapons(new_ptr, vehiclenum);
         // display and sound should be done on client side...
			//  - FIX: doing them here to skip them properly
         new_ptr = Parser_ParseDisplay(new_ptr, vehiclenum);
         new_ptr = Parser_ParseSound(new_ptr, vehiclenum);
         new_ptr = Parser_ParsePhysics(new_ptr, vehiclenum);

         //printf("      }\n");
         return new_ptr;
      }
   }

   return ptr;
}

char *Parser_ParseVehicles(char *ptr) {
   int success = -1, i;
   
   char *new_ptr;
   int vehicles = -1;
   
   new_ptr = ptr;

   new_ptr = strstr(new_ptr, "vehicles");

   // if the "vehicles #" substring exists, being processing vehicles
   if(new_ptr) {

      // read the number of vehicles to expect
      success = sscanf(new_ptr, "vehicles %d {\n", &vehicles);
      
      // if the number of vehicles exists and we read it properly
      if(success) {
         //printf("vehicles %d {\n", vehicles);
         
         // process each level individually
         for(i = 0; i < vehicles; i++) {
            new_ptr = Parser_ParseVehicle(new_ptr, &i);
         }
         //printf("}\n");

         return new_ptr;
      }
   }
   return ptr;
}

int Parser_ParseVehicleInfo(char *filename) {
   int success;

   int file_size = 0;
   fileHandle_t script_file;

   //char *filename = "./scripts/test.classinfo.small";

   // get the file length, reset the file pointer, and allocate a buffer
   file_size = trap_FS_FOpenFile (filename, &script_file, FS_READ);

   // begin parsing
   if(file_size > 0) {
      char *ptr = 0;
      char buffer[10000];
      
      //fseek(script_file, 0L, 0);
      //buffer = malloc(sizeof(char) * file_size + 1);
      //buffer = G_Alloc(sizeof(char) * file_size + 1);

      //printf("file_size: %d\n", file_size);

      // read in the file to the buffer and terminate the buffer
      trap_FS_Read(&buffer, file_size, script_file);
      buffer[sizeof(char) * file_size] = '\0';

      //Com_Printf("%d\n%s\n", file_size, buffer);
      
      // start at the beginning of the buffer
      ptr = buffer;

      // and awaaaayyyyy we go!
      ptr = Parser_ParseVehicles(ptr);

      trap_FS_FCloseFile(script_file);
      //getch();

      //if(buffer)
      //   free(buffer);
      //BG_TempFree(sizeof(char) * file_size + 1);

      return 1;
   }

   return 0;
}