/*

	g_vehicles.h

	Author: AFZ
	Date: 10/12/02

	- This file contains the prototypes for all of the vehicle specific code
*/

#ifndef __G_VEHICLES_H__
#define __G_VEHICLES_H__

#include "../tiecommon/bg_vehicles.h"
#include "g_local.h"


void Vehicle_Touch (gentity_t *ent, gentity_t *other, trace_t *trace);
void Vehicle_Pain(gentity_t *self, gentity_t *attacker, int damage);
void Vehicle_Die( gentity_t *self, gentity_t *inflictor, gentity_t *attacker, int damage, int meansOfDeath );
void Vehicle_Use( gentity_t *self, gentity_t *other, gentity_t *activator );
void Vehicle_Think( gentity_t *ent );

void G_OrientVehicle( gentity_t *ent );
void G_PositionVehicle( gentity_t *ent );

void G_RunVehicle( gentity_t *ent );

int G_SpawnVehicle(vehicle_t *v, gentity_t *e, gentity_t *owner);

////////////////////////////////////
// vehicle array helper functions //
////////////////////////////////////
int VehicleArray_InitVehicleArray();

vehicle_t *VehicleArray_GetVehicleForId(int vehicleId);
int VehicleArray_SetVehicleForId(int vehicleId, vehicle_t *vehicle);

// the following functions dont actually add and remove anything,
// they just set the data in the array at the first clear index

// returns the vehicleId, not the index
int VehicleArray_AddVehicle(vehicle_t *vehicle);
int VehicleArray_RemoveVehicleForId(int vehicleId);

int VehicleArray_OutputVehicles(int clientNum);

///////////////////////////////////////
// vehicle template helper functions //
///////////////////////////////////////

int VehicleTemplateArray_InitVehicleTemplateArray();
int VehicleTemplateArray_OutputTemplates(int clientNum);

int VehicleTemplateArray_GetTemplateIndexForName(char *name);

#endif