/*

	g_combat_vehicles.h

	Author: AFZ
	Date: 10/12/02

	- This file contains the prototypes for all of the vehicle specific code
*/

#ifndef __BG_COMBAT_VEHICLES_H__
#define __BG_COMBAT_VEHICLES_H__

//typedef unsigned char byte;
#include "q_shared.h"

/////////////////////////////////////////////////
// defined bits for storing weapons in structs //
/////////////////////////////////////////////////

// all possible weapon bits to set in structs
#define WEAPON_KNIFE          0x00000001 // 0
#define WEAPON_VENOM          0x00000002 // 1
#define WEAPON_PANZERFAUST    0x00000004 // 2
#define WEAPON_MP40           0x00000008 // 3
#define MAX_VEHICLE_WEAPONS 4 // 4

// other defines
//#define MAX_VEHICLE_MODELS 8;
typedef enum {
	MODEL_COCKPIT,
	MODEL_VEHICLE,
	MODEL_GIB0,
	MODEL_GIB1,
	MODEL_GIB2,
	MODEL_GIB3,

	MAX_VEHICLE_MODELS
} modelTypes_t;

// define the types of vehicles
typedef enum {
   VEHICLE_TANK,
   MAX_VEHICLE_TYPES   
} vehicleTypes_t;

typedef enum {
   MOVEMENT_TREADS,
   MAX_MOVEMENT_TYPES
} movementTypes_t;

//////////////////////////////
// vehicle specific structs //
//////////////////////////////

// stats struct keeps track of armor, health, etc
typedef struct {
   byte health;
   byte armor;
} vehicleStats_t;

// item struct contains all possible weapons for vehicle type
typedef struct {
   int weapons;
   // i dont think we need to take complete control of the weapons code...
   char ammo[MAX_VEHICLE_WEAPONS];
   char baseWeapon;
} vehicleWeaponInfo_t;

typedef struct {
	//char modelName[16];
	byte modelType;
	int model;
	int skin;
	int shader;
	float scale;
	int radius;
	float offset[3];
} vehicleModel_t;

typedef struct {
   vehicleModel_t models[MAX_VEHICLE_MODELS];
} vehicleDisplayInfo_t;

typedef struct {
   int movesound1;
   int movesound2;
} vehicleSoundInfo_t;

typedef struct {
   byte movementType;
   byte width;
   byte height;
   int maxSpeed;
} vehiclePhysicsInfo_t;

typedef struct {
   int vehicleType;
   char vehicleName[16];
   
   vehicleStats_t        vehicleStats;

   vehicleWeaponInfo_t   weaponInfo;
   vehicleDisplayInfo_t  displayInfo;
   vehicleSoundInfo_t    soundInfo;
   vehiclePhysicsInfo_t  physicsInfo;
} vehicleInfo_t;

typedef struct {
   int vehicleId;
   int entityId;
   int templateNum;

   vehicleInfo_t vehicleInfo;
} vehicle_t;

//////////////////////////////
// vehicle helper functions //
//////////////////////////////
int Vehicle_InitVehicle(vehicle_t *vehicle);
int Vehicle_CopyVehicle(vehicle_t *target, const vehicle_t *source);

int VehicleModel_Init(vehicleModel_t *vehicleModel);
int VehicleModel_Copy(vehicleModel_t *target, vehicleModel_t *source);

//////////////////////////////////
// vehicle info lookup routines //
//////////////////////////////////
int VehicleInfo_GetBitForVehicleType(char *name);

int VehicleInfo_GetBitForWeapon(char *name);
int VehicleInfo_GetIndexForWeapon(int weapon);
char *VehicleInfo_GetNameForWeapon(int bit);

int VehicleInfo_GetBitForMovementType(char *name);
char *VehicleInfo_GetNameForMovementType(int bit);

int VehicleInfo_GetIndexForModelName(char *name);
char *VehicleInfo_GetNameForModelType(int modelType);


#endif