export CG_SetGhoul2InfoRef
code
proc CG_SetGhoul2InfoRef 16 0
file "../cg_weapons.c"
line 16
;1:// Copyright (C) 1999-2000 Id Software, Inc.
;2://
;3:// cg_weapons.c -- events and effects dealing with weapons
;4:#include "cg_local.h"
;5:#include "fx_local.h"
;6:
;7:extern vec4_t	bluehudtint;
;8:extern vec4_t	redhudtint;
;9:extern float	*hudTintColor;
;10:
;11:/*
;12:Ghoul2 Insert Start
;13:*/
;14:// set up the appropriate ghoul2 info to a refent
;15:void CG_SetGhoul2InfoRef( refEntity_t *ent, refEntity_t	*s1)
;16:{
line 17
;17:	ent->ghoul2 = s1->ghoul2;
ADDRLP4 0
CNSTI4 208
ASGNI4
ADDRFP4 0
INDIRP4
ADDRLP4 0
INDIRI4
ADDP4
ADDRFP4 4
INDIRP4
ADDRLP4 0
INDIRI4
ADDP4
INDIRP4
ASGNP4
line 18
;18:	VectorCopy( s1->modelScale, ent->modelScale);
ADDRLP4 4
CNSTI4 196
ASGNI4
ADDRFP4 0
INDIRP4
ADDRLP4 4
INDIRI4
ADDP4
ADDRFP4 4
INDIRP4
ADDRLP4 4
INDIRI4
ADDP4
INDIRB
ASGNB 12
line 19
;19:	ent->radius = s1->radius;
ADDRLP4 8
CNSTI4 92
ASGNI4
ADDRFP4 0
INDIRP4
ADDRLP4 8
INDIRI4
ADDP4
ADDRFP4 4
INDIRP4
ADDRLP4 8
INDIRI4
ADDP4
INDIRF4
ASGNF4
line 20
;20:	VectorCopy( s1->angles, ent->angles);
ADDRLP4 12
CNSTI4 184
ASGNI4
ADDRFP4 0
INDIRP4
ADDRLP4 12
INDIRI4
ADDP4
ADDRFP4 4
INDIRP4
ADDRLP4 12
INDIRI4
ADDP4
INDIRB
ASGNB 12
line 21
;21:}
LABELV $131
endproc CG_SetGhoul2InfoRef 16 0
export CG_RegisterItemVisuals
proc CG_RegisterItemVisuals 48 28
line 34
;22:
;23:/*
;24:Ghoul2 Insert End
;25:*/
;26:
;27:/*
;28:=================
;29:CG_RegisterItemVisuals
;30:
;31:The server says this item is used on this level
;32:=================
;33:*/
;34:void CG_RegisterItemVisuals( int itemNum ) {
line 39
;35:	itemInfo_t		*itemInfo;
;36:	gitem_t			*item;
;37:	int				handle;
;38:
;39:	if ( itemNum < 0 || itemNum >= bg_numItems ) {
ADDRLP4 12
ADDRFP4 0
INDIRI4
ASGNI4
ADDRLP4 12
INDIRI4
CNSTI4 0
LTI4 $135
ADDRLP4 12
INDIRI4
ADDRGP4 bg_numItems
INDIRI4
LTI4 $133
LABELV $135
line 40
;40:		CG_Error( "CG_RegisterItemVisuals: itemNum %d out of range [0-%d]", itemNum, bg_numItems-1 );
ADDRGP4 $136
ARGP4
ADDRFP4 0
INDIRI4
ARGI4
ADDRGP4 bg_numItems
INDIRI4
CNSTI4 1
SUBI4
ARGI4
ADDRGP4 CG_Error
CALLV
pop
line 41
;41:	}
LABELV $133
line 43
;42:
;43:	itemInfo = &cg_items[ itemNum ];
ADDRLP4 4
CNSTI4 56
ADDRFP4 0
INDIRI4
MULI4
ADDRGP4 cg_items
ADDP4
ASGNP4
line 44
;44:	if ( itemInfo->registered ) {
ADDRLP4 4
INDIRP4
INDIRI4
CNSTI4 0
EQI4 $137
line 45
;45:		return;
ADDRGP4 $132
JUMPV
LABELV $137
line 48
;46:	}
;47:
;48:	item = &bg_itemlist[ itemNum ];
ADDRLP4 0
CNSTI4 52
ADDRFP4 0
INDIRI4
MULI4
ADDRGP4 bg_itemlist
ADDP4
ASGNP4
line 50
;49:
;50:	memset( itemInfo, 0, sizeof( &itemInfo ) );
ADDRLP4 4
INDIRP4
ARGP4
CNSTI4 0
ARGI4
CNSTI4 4
ARGI4
ADDRGP4 memset
CALLP4
pop
line 51
;51:	itemInfo->registered = qtrue;
ADDRLP4 4
INDIRP4
CNSTI4 1
ASGNI4
line 53
;52:
;53:	if (item->giType == IT_TEAM &&
ADDRLP4 0
INDIRP4
CNSTI4 36
ADDP4
INDIRI4
CNSTI4 8
NEI4 $139
ADDRLP4 20
ADDRLP4 0
INDIRP4
CNSTI4 40
ADDP4
INDIRI4
ASGNI4
ADDRLP4 20
INDIRI4
CNSTI4 4
EQI4 $142
ADDRLP4 20
INDIRI4
CNSTI4 5
NEI4 $139
LABELV $142
ADDRGP4 cgs+32960
INDIRI4
CNSTI4 8
NEI4 $139
line 56
;54:		(item->giTag == PW_REDFLAG || item->giTag == PW_BLUEFLAG) &&
;55:		cgs.gametype == GT_CTY)
;56:	{ //in CTY the flag model is different
line 57
;57:		itemInfo->models[0] = trap_R_RegisterModel( item->world_model[1] );
ADDRLP4 0
INDIRP4
CNSTI4 12
ADDP4
INDIRP4
ARGP4
ADDRLP4 24
ADDRGP4 trap_R_RegisterModel
CALLI4
ASGNI4
ADDRLP4 4
INDIRP4
CNSTI4 4
ADDP4
ADDRLP4 24
INDIRI4
ASGNI4
line 58
;58:	}
ADDRGP4 $140
JUMPV
LABELV $139
line 59
;59:	else if (item->giType == IT_WEAPON &&
ADDRLP4 0
INDIRP4
CNSTI4 36
ADDP4
INDIRI4
CNSTI4 1
NEI4 $143
ADDRLP4 28
ADDRLP4 0
INDIRP4
CNSTI4 40
ADDP4
INDIRI4
ASGNI4
ADDRLP4 28
INDIRI4
CNSTI4 11
EQI4 $146
ADDRLP4 28
INDIRI4
CNSTI4 12
EQI4 $146
ADDRLP4 28
INDIRI4
CNSTI4 13
NEI4 $143
LABELV $146
line 61
;60:		(item->giTag == WP_THERMAL || item->giTag == WP_TRIP_MINE || item->giTag == WP_DET_PACK))
;61:	{
line 62
;62:		itemInfo->models[0] = trap_R_RegisterModel( item->world_model[1] );
ADDRLP4 0
INDIRP4
CNSTI4 12
ADDP4
INDIRP4
ARGP4
ADDRLP4 32
ADDRGP4 trap_R_RegisterModel
CALLI4
ASGNI4
ADDRLP4 4
INDIRP4
CNSTI4 4
ADDP4
ADDRLP4 32
INDIRI4
ASGNI4
line 63
;63:	}
ADDRGP4 $144
JUMPV
LABELV $143
line 65
;64:	else
;65:	{
line 66
;66:		itemInfo->models[0] = trap_R_RegisterModel( item->world_model[0] );
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRP4
ARGP4
ADDRLP4 32
ADDRGP4 trap_R_RegisterModel
CALLI4
ASGNI4
ADDRLP4 4
INDIRP4
CNSTI4 4
ADDP4
ADDRLP4 32
INDIRI4
ASGNI4
line 67
;67:	}
LABELV $144
LABELV $140
line 71
;68:/*
;69:Ghoul2 Insert Start
;70:*/
;71:	if (!Q_stricmp(&item->world_model[0][strlen(item->world_model[0]) - 4], ".glm"))
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRP4
ARGP4
ADDRLP4 32
ADDRGP4 strlen
CALLI4
ASGNI4
ADDRLP4 32
INDIRI4
CNSTI4 4
SUBI4
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRP4
ADDP4
ARGP4
ADDRGP4 $149
ARGP4
ADDRLP4 36
ADDRGP4 Q_stricmp
CALLI4
ASGNI4
ADDRLP4 36
INDIRI4
CNSTI4 0
NEI4 $147
line 72
;72:	{
line 73
;73:		handle = trap_G2API_InitGhoul2Model(&itemInfo->g2Models[0], item->world_model[0], 0 , 0, 0, 0, 0);
ADDRLP4 4
INDIRP4
CNSTI4 24
ADDP4
ARGP4
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRP4
ARGP4
ADDRLP4 40
CNSTI4 0
ASGNI4
ADDRLP4 40
INDIRI4
ARGI4
ADDRLP4 40
INDIRI4
ARGI4
ADDRLP4 40
INDIRI4
ARGI4
ADDRLP4 40
INDIRI4
ARGI4
ADDRLP4 40
INDIRI4
ARGI4
ADDRLP4 44
ADDRGP4 trap_G2API_InitGhoul2Model
CALLI4
ASGNI4
ADDRLP4 8
ADDRLP4 44
INDIRI4
ASGNI4
line 74
;74:		if (handle<0)
ADDRLP4 8
INDIRI4
CNSTI4 0
GEI4 $150
line 75
;75:		{
line 76
;76:			itemInfo->g2Models[0] = NULL;
ADDRLP4 4
INDIRP4
CNSTI4 24
ADDP4
CNSTP4 0
ASGNP4
line 77
;77:		}
ADDRGP4 $151
JUMPV
LABELV $150
line 79
;78:		else
;79:		{
line 80
;80:			itemInfo->radius[0] = 60;
ADDRLP4 4
INDIRP4
CNSTI4 40
ADDP4
CNSTF4 1114636288
ASGNF4
line 81
;81:		}
LABELV $151
line 82
;82:	}
LABELV $147
line 86
;83:/*
;84:Ghoul2 Insert End
;85:*/
;86:	if (item->icon)
ADDRLP4 0
INDIRP4
CNSTI4 28
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $152
line 87
;87:	{
line 88
;88:		itemInfo->icon = trap_R_RegisterShader( item->icon );
ADDRLP4 0
INDIRP4
CNSTI4 28
ADDP4
INDIRP4
ARGP4
ADDRLP4 40
ADDRGP4 trap_R_RegisterShader
CALLI4
ASGNI4
ADDRLP4 4
INDIRP4
CNSTI4 20
ADDP4
ADDRLP4 40
INDIRI4
ASGNI4
line 89
;89:	}
ADDRGP4 $153
JUMPV
LABELV $152
line 91
;90:	else
;91:	{
line 92
;92:		itemInfo->icon = 0;
ADDRLP4 4
INDIRP4
CNSTI4 20
ADDP4
CNSTI4 0
ASGNI4
line 93
;93:	}
LABELV $153
line 95
;94:
;95:	if ( item->giType == IT_WEAPON ) {
ADDRLP4 0
INDIRP4
CNSTI4 36
ADDP4
INDIRI4
CNSTI4 1
NEI4 $154
line 96
;96:		CG_RegisterWeapon( item->giTag );
ADDRLP4 0
INDIRP4
CNSTI4 40
ADDP4
INDIRI4
ARGI4
ADDRGP4 CG_RegisterWeapon
CALLV
pop
line 97
;97:	}
LABELV $154
line 102
;98:
;99:	//
;100:	// powerups have an accompanying ring or sphere
;101:	//
;102:	if ( item->giType == IT_POWERUP || item->giType == IT_HEALTH || 
ADDRLP4 40
ADDRLP4 0
INDIRP4
CNSTI4 36
ADDP4
INDIRI4
ASGNI4
ADDRLP4 40
INDIRI4
CNSTI4 5
EQI4 $160
ADDRLP4 40
INDIRI4
CNSTI4 4
EQI4 $160
ADDRLP4 40
INDIRI4
CNSTI4 3
EQI4 $160
ADDRLP4 40
INDIRI4
CNSTI4 6
NEI4 $156
LABELV $160
line 103
;103:		item->giType == IT_ARMOR || item->giType == IT_HOLDABLE ) {
line 104
;104:		if ( item->world_model[1] ) {
ADDRLP4 0
INDIRP4
CNSTI4 12
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $161
line 105
;105:			itemInfo->models[1] = trap_R_RegisterModel( item->world_model[1] );
ADDRLP4 0
INDIRP4
CNSTI4 12
ADDP4
INDIRP4
ARGP4
ADDRLP4 44
ADDRGP4 trap_R_RegisterModel
CALLI4
ASGNI4
ADDRLP4 4
INDIRP4
CNSTI4 8
ADDP4
ADDRLP4 44
INDIRI4
ASGNI4
line 106
;106:		}
LABELV $161
line 107
;107:	}
LABELV $156
line 108
;108:}
LABELV $132
endproc CG_RegisterItemVisuals 48 28
data
align 4
LABELV cgWeapFrame
byte 4 0
align 4
LABELV cgWeapFrameTime
byte 4 0
code
proc CG_MapTorsoToWeaponFrame 40 0
line 133
;109:
;110:
;111:/*
;112:========================================================================================
;113:
;114:VIEW WEAPON
;115:
;116:========================================================================================
;117:*/
;118:
;119:#define WEAPON_FORCE_BUSY_HOLSTER
;120:
;121:#ifdef WEAPON_FORCE_BUSY_HOLSTER
;122://rww - this was done as a last resort. Forgive me.
;123:static int cgWeapFrame = 0;
;124:static int cgWeapFrameTime = 0;
;125:#endif
;126:
;127:/*
;128:=================
;129:CG_MapTorsoToWeaponFrame
;130:
;131:=================
;132:*/
;133:static int CG_MapTorsoToWeaponFrame( clientInfo_t *ci, int frame, int animNum ) {
line 134
;134:	animation_t *animations = bgGlobalAnimations;
ADDRLP4 0
ADDRGP4 bgGlobalAnimations
ASGNP4
line 136
;135:#ifdef WEAPON_FORCE_BUSY_HOLSTER
;136:	if (cg.snap->ps.forceHandExtend != HANDEXTEND_NONE || cgWeapFrameTime > cg.time)
ADDRGP4 cg+36
INDIRP4
CNSTI4 1292
ADDP4
INDIRI4
CNSTI4 0
NEI4 $168
ADDRGP4 cgWeapFrameTime
INDIRI4
ADDRGP4 cg+64
INDIRI4
LEI4 $164
LABELV $168
line 137
;137:	{ //the reason for the after delay is so that it doesn't snap the weapon frame to the "idle" (0) frame
line 139
;138:		//for a very quick moment
;139:		if (cgWeapFrame < 6)
ADDRGP4 cgWeapFrame
INDIRI4
CNSTI4 6
GEI4 $169
line 140
;140:		{
line 141
;141:			cgWeapFrame = 6;
ADDRGP4 cgWeapFrame
CNSTI4 6
ASGNI4
line 142
;142:			cgWeapFrameTime = cg.time + 10;
ADDRGP4 cgWeapFrameTime
ADDRGP4 cg+64
INDIRI4
CNSTI4 10
ADDI4
ASGNI4
line 143
;143:		}
LABELV $169
line 145
;144:
;145:		if (cgWeapFrameTime < cg.time && cgWeapFrame < 10)
ADDRGP4 cgWeapFrameTime
INDIRI4
ADDRGP4 cg+64
INDIRI4
GEI4 $172
ADDRGP4 cgWeapFrame
INDIRI4
CNSTI4 10
GEI4 $172
line 146
;146:		{
line 147
;147:			cgWeapFrame++;
ADDRLP4 4
ADDRGP4 cgWeapFrame
ASGNP4
ADDRLP4 4
INDIRP4
ADDRLP4 4
INDIRP4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 148
;148:			cgWeapFrameTime = cg.time + 10;
ADDRGP4 cgWeapFrameTime
ADDRGP4 cg+64
INDIRI4
CNSTI4 10
ADDI4
ASGNI4
line 149
;149:		}
LABELV $172
line 151
;150:
;151:		if (cg.snap->ps.forceHandExtend != HANDEXTEND_NONE &&
ADDRGP4 cg+36
INDIRP4
CNSTI4 1292
ADDP4
INDIRI4
CNSTI4 0
EQI4 $176
ADDRGP4 cgWeapFrame
INDIRI4
CNSTI4 10
NEI4 $176
line 153
;152:			cgWeapFrame == 10)
;153:		{
line 154
;154:			cgWeapFrameTime = cg.time + 100;
ADDRGP4 cgWeapFrameTime
ADDRGP4 cg+64
INDIRI4
CNSTI4 100
ADDI4
ASGNI4
line 155
;155:		}
LABELV $176
line 157
;156:
;157:		return cgWeapFrame;
ADDRGP4 cgWeapFrame
INDIRI4
RETI4
ADDRGP4 $163
JUMPV
LABELV $164
line 160
;158:	}
;159:	else
;160:	{
line 161
;161:		cgWeapFrame = 0;
ADDRGP4 cgWeapFrame
CNSTI4 0
ASGNI4
line 162
;162:		cgWeapFrameTime = 0;
ADDRGP4 cgWeapFrameTime
CNSTI4 0
ASGNI4
line 163
;163:	}
line 166
;164:#endif
;165:
;166:	switch( animNum )
ADDRLP4 4
ADDRFP4 8
INDIRI4
ASGNI4
ADDRLP4 8
CNSTI4 1091
ASGNI4
ADDRLP4 4
INDIRI4
ADDRLP4 8
INDIRI4
EQI4 $182
ADDRLP4 4
INDIRI4
ADDRLP4 8
INDIRI4
GTI4 $192
LABELV $191
ADDRLP4 12
ADDRFP4 8
INDIRI4
ASGNI4
ADDRLP4 12
INDIRI4
CNSTI4 117
LTI4 $180
ADDRLP4 12
INDIRI4
CNSTI4 137
GTI4 $180
ADDRLP4 12
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 $193-468
ADDP4
INDIRP4
JUMPV
lit
align 4
LABELV $193
address $188
address $188
address $180
address $188
address $188
address $188
address $188
address $188
address $188
address $188
address $188
address $188
address $188
address $180
address $180
address $180
address $180
address $180
address $180
address $180
address $188
code
LABELV $192
ADDRFP4 8
INDIRI4
CNSTI4 1095
EQI4 $185
ADDRGP4 $180
JUMPV
line 167
;167:	{
LABELV $182
line 169
;168:	case TORSO_DROPWEAP1:
;169:		if ( frame >= animations[animNum].firstFrame && frame < animations[animNum].firstFrame + 5 ) 
ADDRLP4 16
ADDRFP4 4
INDIRI4
ASGNI4
ADDRLP4 20
CNSTI4 28
ADDRFP4 8
INDIRI4
MULI4
ADDRLP4 0
INDIRP4
ADDP4
INDIRI4
ASGNI4
ADDRLP4 16
INDIRI4
ADDRLP4 20
INDIRI4
LTI4 $181
ADDRLP4 16
INDIRI4
ADDRLP4 20
INDIRI4
CNSTI4 5
ADDI4
GEI4 $181
line 170
;170:		{
line 171
;171:			return frame - animations[animNum].firstFrame + 6;
ADDRFP4 4
INDIRI4
CNSTI4 28
ADDRFP4 8
INDIRI4
MULI4
ADDRLP4 0
INDIRP4
ADDP4
INDIRI4
SUBI4
CNSTI4 6
ADDI4
RETI4
ADDRGP4 $163
JUMPV
line 173
;172:		}
;173:		break;
LABELV $185
line 176
;174:
;175:	case TORSO_RAISEWEAP1:
;176:		if ( frame >= animations[animNum].firstFrame && frame < animations[animNum].firstFrame + 4 ) 
ADDRLP4 24
ADDRFP4 4
INDIRI4
ASGNI4
ADDRLP4 28
CNSTI4 28
ADDRFP4 8
INDIRI4
MULI4
ADDRLP4 0
INDIRP4
ADDP4
INDIRI4
ASGNI4
ADDRLP4 24
INDIRI4
ADDRLP4 28
INDIRI4
LTI4 $181
ADDRLP4 24
INDIRI4
ADDRLP4 28
INDIRI4
CNSTI4 4
ADDI4
GEI4 $181
line 177
;177:		{
line 178
;178:			return frame - animations[animNum].firstFrame + 6 + 4;
ADDRFP4 4
INDIRI4
CNSTI4 28
ADDRFP4 8
INDIRI4
MULI4
ADDRLP4 0
INDIRP4
ADDP4
INDIRI4
SUBI4
CNSTI4 6
ADDI4
CNSTI4 4
ADDI4
RETI4
ADDRGP4 $163
JUMPV
line 180
;179:		}
;180:		break;
LABELV $188
line 194
;181:	case BOTH_ATTACK1:
;182:	case BOTH_ATTACK2:
;183:	case BOTH_ATTACK3:
;184:	case BOTH_ATTACK4:
;185:	case BOTH_ATTACK5:
;186:	case BOTH_ATTACK6:
;187:	case BOTH_ATTACK7:
;188:	case BOTH_ATTACK8:
;189:	case BOTH_ATTACK9:
;190:	case BOTH_ATTACK10:
;191:	case BOTH_ATTACK11:
;192:	case BOTH_ATTACK12:
;193:	case BOTH_THERMAL_THROW:
;194:		if ( frame >= animations[animNum].firstFrame && frame < animations[animNum].firstFrame + 6 ) 
ADDRLP4 32
ADDRFP4 4
INDIRI4
ASGNI4
ADDRLP4 36
CNSTI4 28
ADDRFP4 8
INDIRI4
MULI4
ADDRLP4 0
INDIRP4
ADDP4
INDIRI4
ASGNI4
ADDRLP4 32
INDIRI4
ADDRLP4 36
INDIRI4
LTI4 $181
ADDRLP4 32
INDIRI4
ADDRLP4 36
INDIRI4
CNSTI4 6
ADDI4
GEI4 $181
line 195
;195:		{
line 196
;196:			return 1 + ( frame - animations[animNum].firstFrame );
ADDRFP4 4
INDIRI4
CNSTI4 28
ADDRFP4 8
INDIRI4
MULI4
ADDRLP4 0
INDIRP4
ADDP4
INDIRI4
SUBI4
CNSTI4 1
ADDI4
RETI4
ADDRGP4 $163
JUMPV
line 199
;197:		}
;198:
;199:		break;
LABELV $180
LABELV $181
line 201
;200:	}	
;201:	return -1;
CNSTI4 -1
RETI4
LABELV $163
endproc CG_MapTorsoToWeaponFrame 40 0
proc CG_CalculateWeaponPosition 40 4
line 210
;202:}
;203:
;204:
;205:/*
;206:==============
;207:CG_CalculateWeaponPosition
;208:==============
;209:*/
;210:static void CG_CalculateWeaponPosition( vec3_t origin, vec3_t angles ) {
line 215
;211:	float	scale;
;212:	int		delta;
;213:	float	fracsin;
;214:
;215:	VectorCopy( cg.refdef.vieworg, origin );
ADDRFP4 0
INDIRP4
ADDRGP4 cg+3616+24
INDIRB
ASGNB 12
line 216
;216:	VectorCopy( cg.refdefViewAngles, angles );
ADDRFP4 4
INDIRP4
ADDRGP4 cg+3984
INDIRB
ASGNB 12
line 219
;217:
;218:	// on odd legs, invert some angles
;219:	if ( cg.bobcycle & 1 ) {
ADDRGP4 cg+13468
INDIRI4
CNSTI4 1
BANDI4
CNSTI4 0
EQI4 $199
line 220
;220:		scale = -cg.xyspeed;
ADDRLP4 0
ADDRGP4 cg+13472
INDIRF4
NEGF4
ASGNF4
line 221
;221:	} else {
ADDRGP4 $200
JUMPV
LABELV $199
line 222
;222:		scale = cg.xyspeed;
ADDRLP4 0
ADDRGP4 cg+13472
INDIRF4
ASGNF4
line 223
;223:	}
LABELV $200
line 226
;224:
;225:	// gun angles from bobbing
;226:	angles[ROLL] += scale * cg.bobfracsin * 0.005;
ADDRLP4 12
ADDRFP4 4
INDIRP4
CNSTI4 8
ADDP4
ASGNP4
ADDRLP4 12
INDIRP4
ADDRLP4 12
INDIRP4
INDIRF4
CNSTF4 1000593162
ADDRLP4 0
INDIRF4
ADDRGP4 cg+13464
INDIRF4
MULF4
MULF4
ADDF4
ASGNF4
line 227
;227:	angles[YAW] += scale * cg.bobfracsin * 0.01;
ADDRLP4 16
ADDRFP4 4
INDIRP4
CNSTI4 4
ADDP4
ASGNP4
ADDRLP4 16
INDIRP4
ADDRLP4 16
INDIRP4
INDIRF4
CNSTF4 1008981770
ADDRLP4 0
INDIRF4
ADDRGP4 cg+13464
INDIRF4
MULF4
MULF4
ADDF4
ASGNF4
line 228
;228:	angles[PITCH] += cg.xyspeed * cg.bobfracsin * 0.005;
ADDRLP4 20
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 20
INDIRP4
ADDRLP4 20
INDIRP4
INDIRF4
CNSTF4 1000593162
ADDRGP4 cg+13472
INDIRF4
ADDRGP4 cg+13464
INDIRF4
MULF4
MULF4
ADDF4
ASGNF4
line 231
;229:
;230:	// drop the weapon when landing
;231:	delta = cg.time - cg.landTime;
ADDRLP4 8
ADDRGP4 cg+64
INDIRI4
ADDRGP4 cg+3504
INDIRI4
SUBI4
ASGNI4
line 232
;232:	if ( delta < LAND_DEFLECT_TIME ) {
ADDRLP4 8
INDIRI4
CNSTI4 150
GEI4 $210
line 233
;233:		origin[2] += cg.landChange*0.25 * delta / LAND_DEFLECT_TIME;
ADDRLP4 24
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
ASGNP4
ADDRLP4 24
INDIRP4
ADDRLP4 24
INDIRP4
INDIRF4
CNSTF4 1048576000
ADDRGP4 cg+3500
INDIRF4
MULF4
ADDRLP4 8
INDIRI4
CVIF4 4
MULF4
CNSTF4 1125515264
DIVF4
ADDF4
ASGNF4
line 234
;234:	} else if ( delta < LAND_DEFLECT_TIME + LAND_RETURN_TIME ) {
ADDRGP4 $211
JUMPV
LABELV $210
ADDRLP4 8
INDIRI4
CNSTI4 450
GEI4 $213
line 235
;235:		origin[2] += cg.landChange*0.25 * 
ADDRLP4 24
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
ASGNP4
ADDRLP4 24
INDIRP4
ADDRLP4 24
INDIRP4
INDIRF4
CNSTF4 1048576000
ADDRGP4 cg+3500
INDIRF4
MULF4
CNSTI4 450
ADDRLP4 8
INDIRI4
SUBI4
CVIF4 4
MULF4
CNSTF4 1133903872
DIVF4
ADDF4
ASGNF4
line 237
;236:			(LAND_DEFLECT_TIME + LAND_RETURN_TIME - delta) / LAND_RETURN_TIME;
;237:	}
LABELV $213
LABELV $211
line 250
;238:
;239:#if 0
;240:	// drop the weapon when stair climbing
;241:	delta = cg.time - cg.stepTime;
;242:	if ( delta < STEP_TIME/2 ) {
;243:		origin[2] -= cg.stepChange*0.25 * delta / (STEP_TIME/2);
;244:	} else if ( delta < STEP_TIME ) {
;245:		origin[2] -= cg.stepChange*0.25 * (STEP_TIME - delta) / (STEP_TIME/2);
;246:	}
;247:#endif
;248:
;249:	// idle drift
;250:	scale = cg.xyspeed + 40;
ADDRLP4 0
ADDRGP4 cg+13472
INDIRF4
CNSTF4 1109393408
ADDF4
ASGNF4
line 251
;251:	fracsin = sin( cg.time * 0.001 );
CNSTF4 981668463
ADDRGP4 cg+64
INDIRI4
CVIF4 4
MULF4
ARGF4
ADDRLP4 24
ADDRGP4 sin
CALLF4
ASGNF4
ADDRLP4 4
ADDRLP4 24
INDIRF4
ASGNF4
line 252
;252:	angles[ROLL] += scale * fracsin * 0.01;
ADDRLP4 28
ADDRFP4 4
INDIRP4
CNSTI4 8
ADDP4
ASGNP4
ADDRLP4 28
INDIRP4
ADDRLP4 28
INDIRP4
INDIRF4
CNSTF4 1008981770
ADDRLP4 0
INDIRF4
ADDRLP4 4
INDIRF4
MULF4
MULF4
ADDF4
ASGNF4
line 253
;253:	angles[YAW] += scale * fracsin * 0.01;
ADDRLP4 32
ADDRFP4 4
INDIRP4
CNSTI4 4
ADDP4
ASGNP4
ADDRLP4 32
INDIRP4
ADDRLP4 32
INDIRP4
INDIRF4
CNSTF4 1008981770
ADDRLP4 0
INDIRF4
ADDRLP4 4
INDIRF4
MULF4
MULF4
ADDF4
ASGNF4
line 254
;254:	angles[PITCH] += scale * fracsin * 0.01;
ADDRLP4 36
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 36
INDIRP4
ADDRLP4 36
INDIRP4
INDIRF4
CNSTF4 1008981770
ADDRLP4 0
INDIRF4
ADDRLP4 4
INDIRF4
MULF4
MULF4
ADDF4
ASGNF4
line 255
;255:}
LABELV $195
endproc CG_CalculateWeaponPosition 40 4
proc CG_LightningBolt 220 12
line 269
;256:
;257:
;258:/*
;259:===============
;260:CG_LightningBolt
;261:
;262:Origin will be the exact tag point, which is slightly
;263:different than the muzzle point used for determining hits.
;264:The cent should be the non-predicted cent if it is from the player,
;265:so the endpoint will reflect the simulated strike (lagging the predicted
;266:angle)
;267:===============
;268:*/
;269:static void CG_LightningBolt( centity_t *cent, vec3_t origin ) {
line 276
;270://	trace_t  trace;
;271:	refEntity_t  beam;
;272://	vec3_t   forward;
;273://	vec3_t   muzzlePoint, endPoint;
;274:
;275:	//Must be a durational weapon that continuously generates an effect.
;276:	if ( cent->currentState.weapon == WP_DEMP2 && cent->currentState.eFlags & EF_ALT_FIRING ) 
ADDRLP4 212
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 216
CNSTI4 8
ASGNI4
ADDRLP4 212
INDIRP4
CNSTI4 276
ADDP4
INDIRI4
ADDRLP4 216
INDIRI4
NEI4 $218
ADDRLP4 212
INDIRP4
ADDRLP4 216
INDIRI4
ADDP4
INDIRI4
CNSTI4 512
BANDI4
CNSTI4 0
EQI4 $218
line 277
;277:	{ /*nothing*/ }
line 279
;278:	else
;279:	{
line 280
;280:		return;
LABELV $220
line 283
;281:	}
;282:
;283:	memset( &beam, 0, sizeof( beam ) );
ADDRLP4 0
ARGP4
CNSTI4 0
ARGI4
CNSTI4 212
ARGI4
ADDRGP4 memset
CALLP4
pop
line 366
;284:
;285:	// NOTENOTE No lightning gun-ish stuff yet.
;286:/*
;287:	// CPMA  "true" lightning
;288:	if ((cent->currentState.number == cg.predictedPlayerState.clientNum) && (cg_trueLightning.value != 0)) {
;289:		vec3_t angle;
;290:		int i;
;291:
;292:		for (i = 0; i < 3; i++) {
;293:			float a = cent->lerpAngles[i] - cg.refdefViewAngles[i];
;294:			if (a > 180) {
;295:				a -= 360;
;296:			}
;297:			if (a < -180) {
;298:				a += 360;
;299:			}
;300:
;301:			angle[i] = cg.refdefViewAngles[i] + a * (1.0 - cg_trueLightning.value);
;302:			if (angle[i] < 0) {
;303:				angle[i] += 360;
;304:			}
;305:			if (angle[i] > 360) {
;306:				angle[i] -= 360;
;307:			}
;308:		}
;309:
;310:		AngleVectors(angle, forward, NULL, NULL );
;311:		VectorCopy(cent->lerpOrigin, muzzlePoint );
;312://		VectorCopy(cg.refdef.vieworg, muzzlePoint );
;313:	} else {
;314:		// !CPMA
;315:		AngleVectors( cent->lerpAngles, forward, NULL, NULL );
;316:		VectorCopy(cent->lerpOrigin, muzzlePoint );
;317:	}
;318:
;319:	// FIXME: crouch
;320:	muzzlePoint[2] += DEFAULT_VIEWHEIGHT;
;321:
;322:	VectorMA( muzzlePoint, 14, forward, muzzlePoint );
;323:
;324:	// project forward by the lightning range
;325:	VectorMA( muzzlePoint, LIGHTNING_RANGE, forward, endPoint );
;326:
;327:	// see if it hit a wall
;328:	CG_Trace( &trace, muzzlePoint, vec3_origin, vec3_origin, endPoint, 
;329:		cent->currentState.number, MASK_SHOT );
;330:
;331:	// this is the endpoint
;332:	VectorCopy( trace.endpos, beam.oldorigin );
;333:
;334:	// use the provided origin, even though it may be slightly
;335:	// different than the muzzle origin
;336:	VectorCopy( origin, beam.origin );
;337:
;338:	beam.reType = RT_LIGHTNING;
;339:	beam.customShader = cgs.media.lightningShader;
;340:	trap_R_AddRefEntityToScene( &beam );
;341:*/
;342:
;343:	// NOTENOTE No lightning gun-ish stuff yet.
;344:/*
;345:	// add the impact flare if it hit something
;346:	if ( trace.fraction < 1.0 ) {
;347:		vec3_t	angles;
;348:		vec3_t	dir;
;349:
;350:		VectorSubtract( beam.oldorigin, beam.origin, dir );
;351:		VectorNormalize( dir );
;352:
;353:		memset( &beam, 0, sizeof( beam ) );
;354:		beam.hModel = cgs.media.lightningExplosionModel;
;355:
;356:		VectorMA( trace.endpos, -16, dir, beam.origin );
;357:
;358:		// make a random orientation
;359:		angles[0] = rand() % 360;
;360:		angles[1] = rand() % 360;
;361:		angles[2] = rand() % 360;
;362:		AnglesToAxis( angles, beam.axis );
;363:		trap_R_AddRefEntityToScene( &beam );
;364:	}
;365:*/
;366:}
LABELV $218
endproc CG_LightningBolt 220 12
proc CG_AddWeaponWithPowerups 0 4
line 374
;367:
;368:
;369:/*
;370:========================
;371:CG_AddWeaponWithPowerups
;372:========================
;373:*/
;374:static void CG_AddWeaponWithPowerups( refEntity_t *gun, int powerups ) {
line 376
;375:	// add powerup effects
;376:	trap_R_AddRefEntityToScene( gun );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 trap_R_AddRefEntityToScene
CALLV
pop
line 378
;377:
;378:	if ( powerups & ( 1 << PW_BATTLESUIT ) ) {
ADDRFP4 4
INDIRI4
CNSTI4 4
BANDI4
CNSTI4 0
EQI4 $222
line 379
;379:		gun->customShader = cgs.media.battleWeaponShader;
ADDRFP4 0
INDIRP4
CNSTI4 76
ADDP4
ADDRGP4 cgs+71064+472
INDIRI4
ASGNI4
line 380
;380:		trap_R_AddRefEntityToScene( gun );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 trap_R_AddRefEntityToScene
CALLV
pop
line 381
;381:	}
LABELV $222
line 382
;382:	if ( powerups & ( 1 << PW_QUAD ) ) {
ADDRFP4 4
INDIRI4
CNSTI4 2
BANDI4
CNSTI4 0
EQI4 $226
line 383
;383:		gun->customShader = cgs.media.quadWeaponShader;
ADDRFP4 0
INDIRP4
CNSTI4 76
ADDP4
ADDRGP4 cgs+71064+456
INDIRI4
ASGNI4
line 384
;384:		trap_R_AddRefEntityToScene( gun );
ADDRFP4 0
INDIRP4
ARGP4
ADDRGP4 trap_R_AddRefEntityToScene
CALLV
pop
line 385
;385:	}
LABELV $226
line 386
;386:}
LABELV $221
endproc CG_AddWeaponWithPowerups 0 4
export CG_AddPlayerWeapon
proc CG_AddPlayerWeapon 988 36
line 398
;387:
;388:
;389:/*
;390:=============
;391:CG_AddPlayerWeapon
;392:
;393:Used for both the view weapon (ps is valid) and the world modelother character models (ps is NULL)
;394:The main player will have this called for BOTH cases, so effects like light and
;395:sound should only be done on the world model case.
;396:=============
;397:*/
;398:void CG_AddPlayerWeapon( refEntity_t *parent, playerState_t *ps, centity_t *cent, int team, vec3_t newAngles, qboolean thirdPerson ) {
line 411
;399:	refEntity_t	gun;
;400:	refEntity_t	barrel;
;401:	vec3_t		angles;
;402:	weapon_t	weaponNum;
;403:	weaponInfo_t	*weapon;
;404:	centity_t	*nonPredictedCent;
;405:	refEntity_t	flash;
;406:
;407:   // adnan
;408:   // use quaternions for weapon orientation
;409:   quat_t      q;
;410:
;411:	weaponNum = cent->currentState.weapon;
ADDRLP4 440
ADDRFP4 8
INDIRP4
CNSTI4 276
ADDP4
INDIRI4
ASGNI4
line 413
;412:
;413:	if (cent->currentState.weapon == WP_EMPLACED_GUN)
ADDRFP4 8
INDIRP4
CNSTI4 276
ADDP4
INDIRI4
CNSTI4 14
NEI4 $231
line 414
;414:	{
line 415
;415:		return;
ADDRGP4 $230
JUMPV
LABELV $231
line 418
;416:	}
;417:
;418:	CG_RegisterWeapon( weaponNum );
ADDRLP4 440
INDIRI4
ARGI4
ADDRGP4 CG_RegisterWeapon
CALLV
pop
line 419
;419:	weapon = &cg_weapons[weaponNum];
ADDRLP4 436
CNSTI4 208
ADDRLP4 440
INDIRI4
MULI4
ADDRGP4 cg_weapons
ADDP4
ASGNP4
line 424
;420:/*
;421:Ghoul2 Insert Start
;422:*/
;423:
;424:	memset( &gun, 0, sizeof( gun ) );
ADDRLP4 224
ARGP4
CNSTI4 0
ARGI4
CNSTI4 212
ARGI4
ADDRGP4 memset
CALLP4
pop
line 427
;425:
;426:	// only do this if we are in first person, since world weapons are now handled on the server by Ghoul2
;427:	if (!thirdPerson)
ADDRFP4 20
INDIRI4
CNSTI4 0
NEI4 $233
line 428
;428:	{
line 431
;429:
;430:		// add the weapon
;431:		VectorCopy( parent->lightingOrigin, gun.lightingOrigin );
ADDRLP4 224+108
ADDRFP4 0
INDIRP4
CNSTI4 108
ADDP4
INDIRB
ASGNB 12
line 432
;432:		gun.shadowPlane = parent->shadowPlane;
ADDRLP4 224+120
ADDRFP4 0
INDIRP4
CNSTI4 120
ADDP4
INDIRF4
ASGNF4
line 433
;433:		gun.renderfx = parent->renderfx;
ADDRLP4 224+4
ADDRFP4 0
INDIRP4
CNSTI4 4
ADDP4
INDIRI4
ASGNI4
line 435
;434:
;435:		if (ps)
ADDRFP4 4
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $238
line 436
;436:		{	// this player, in first person view
line 437
;437:			gun.hModel = weapon->viewModel;
ADDRLP4 224+8
ADDRLP4 436
INDIRP4
CNSTI4 16
ADDP4
INDIRI4
ASGNI4
line 440
;438:
;439:         // get the quat from the ps
;440:         QuaternionFromTieFloats(ps->tieFloats, &q);
ADDRFP4 4
INDIRP4
CNSTI4 656
ADDP4
ARGP4
ADDRLP4 660
ARGP4
ADDRGP4 QuaternionFromTieFloats
CALLV
pop
line 441
;441:		}
ADDRGP4 $239
JUMPV
LABELV $238
line 443
;442:		else
;443:		{
line 444
;444:			gun.hModel = weapon->weaponModel;
ADDRLP4 224+8
ADDRLP4 436
INDIRP4
CNSTI4 12
ADDP4
INDIRI4
ASGNI4
line 447
;445:
;446:         // get the quat from config strings
;447:         QuaternionFromString((char*)CG_ConfigString(CS_QUATERNIONS + cent->currentState.clientNum), &q);
ADDRFP4 8
INDIRP4
CNSTI4 220
ADDP4
INDIRI4
CNSTI4 1054
ADDI4
ARGI4
ADDRLP4 676
ADDRGP4 CG_ConfigString
CALLP4
ASGNP4
ADDRLP4 676
INDIRP4
ARGP4
ADDRLP4 660
ARGP4
ADDRGP4 QuaternionFromString
CALLV
pop
line 448
;448:		}
LABELV $239
line 449
;449:		if (!gun.hModel) {
ADDRLP4 224+8
INDIRI4
CNSTI4 0
NEI4 $242
line 450
;450:			return;
ADDRGP4 $230
JUMPV
LABELV $242
line 453
;451:		}
;452:
;453:		if ( !ps ) {
ADDRFP4 4
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $245
line 455
;454:			// add weapon ready sound
;455:			cent->pe.lightningFiring = qfalse;
ADDRFP4 8
INDIRP4
CNSTI4 844
ADDP4
CNSTI4 0
ASGNI4
line 456
;456:			if ( ( cent->currentState.eFlags & EF_FIRING ) && weapon->firingSound ) {
ADDRLP4 676
CNSTI4 0
ASGNI4
ADDRFP4 8
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
CNSTI4 256
BANDI4
ADDRLP4 676
INDIRI4
EQI4 $247
ADDRLP4 436
INDIRP4
CNSTI4 84
ADDP4
INDIRI4
ADDRLP4 676
INDIRI4
EQI4 $247
line 458
;457:				// lightning gun and guantlet make a different sound when fire is held down
;458:				trap_S_AddLoopingSound( cent->currentState.number, cent->lerpOrigin, vec3_origin, weapon->firingSound );
ADDRLP4 680
ADDRFP4 8
INDIRP4
ASGNP4
ADDRLP4 680
INDIRP4
INDIRI4
ARGI4
ADDRLP4 680
INDIRP4
CNSTI4 928
ADDP4
ARGP4
ADDRGP4 vec3_origin
ARGP4
ADDRLP4 436
INDIRP4
CNSTI4 84
ADDP4
INDIRI4
ARGI4
ADDRGP4 trap_S_AddLoopingSound
CALLV
pop
line 459
;459:				cent->pe.lightningFiring = qtrue;
ADDRFP4 8
INDIRP4
CNSTI4 844
ADDP4
CNSTI4 1
ASGNI4
line 460
;460:			} else if ( weapon->readySound ) {
ADDRGP4 $248
JUMPV
LABELV $247
ADDRLP4 436
INDIRP4
CNSTI4 196
ADDP4
INDIRI4
CNSTI4 0
EQI4 $249
line 461
;461:				trap_S_AddLoopingSound( cent->currentState.number, cent->lerpOrigin, vec3_origin, weapon->readySound );
ADDRLP4 680
ADDRFP4 8
INDIRP4
ASGNP4
ADDRLP4 680
INDIRP4
INDIRI4
ARGI4
ADDRLP4 680
INDIRP4
CNSTI4 928
ADDP4
ARGP4
ADDRGP4 vec3_origin
ARGP4
ADDRLP4 436
INDIRP4
CNSTI4 196
ADDP4
INDIRI4
ARGI4
ADDRGP4 trap_S_AddLoopingSound
CALLV
pop
line 462
;462:			}
LABELV $249
LABELV $248
line 463
;463:		}
LABELV $245
line 465
;464:	
;465:		CG_PositionEntityOnTag( &gun, parent, parent->hModel, "tag_weapon");
ADDRLP4 224
ARGP4
ADDRLP4 676
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 676
INDIRP4
ARGP4
ADDRLP4 676
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
ADDRGP4 $251
ARGP4
ADDRGP4 CG_PositionEntityOnTag
CALLV
pop
line 467
;466:
;467:		if (!CG_IsMindTricked(cent->currentState.trickedentindex,
ADDRLP4 680
ADDRFP4 8
INDIRP4
ASGNP4
ADDRLP4 680
INDIRP4
CNSTI4 148
ADDP4
INDIRI4
ARGI4
ADDRLP4 680
INDIRP4
CNSTI4 152
ADDP4
INDIRI4
ARGI4
ADDRLP4 680
INDIRP4
CNSTI4 156
ADDP4
INDIRI4
ARGI4
ADDRLP4 680
INDIRP4
CNSTI4 160
ADDP4
INDIRI4
ARGI4
ADDRGP4 cg+36
INDIRP4
CNSTI4 188
ADDP4
INDIRI4
ARGI4
ADDRLP4 684
ADDRGP4 CG_IsMindTricked
CALLI4
ASGNI4
ADDRLP4 684
INDIRI4
CNSTI4 0
NEI4 $252
line 472
;468:			cent->currentState.trickedentindex2,
;469:			cent->currentState.trickedentindex3,
;470:			cent->currentState.trickedentindex4,
;471:			cg.snap->ps.clientNum))
;472:		{
line 473
;473:			CG_AddWeaponWithPowerups( &gun, cent->currentState.powerups ); //don't draw the weapon if the player is invisible
ADDRLP4 224
ARGP4
ADDRFP4 8
INDIRP4
CNSTI4 272
ADDP4
INDIRI4
ARGI4
ADDRGP4 CG_AddWeaponWithPowerups
CALLV
pop
line 484
;474:			/*
;475:			if ( weaponNum == WP_STUN_BATON )
;476:			{
;477:				gun.shaderRGBA[0] = gun.shaderRGBA[1] = gun.shaderRGBA[2] = 25;
;478:	
;479:				gun.customShader = trap_R_RegisterShader( "gfx/effects/stunPass" );
;480:				gun.renderfx = RF_RGB_TINT | RF_FIRST_PERSON | RF_DEPTHHACK;
;481:				trap_R_AddRefEntityToScene( &gun );
;482:			}
;483:			*/
;484:		}
LABELV $252
line 488
;485:
;486:      // adnan
;487:      // orient the weapon based on the quat
;488:      QuaternionToAxis(q, gun.axis);
ADDRLP4 688
ADDRLP4 660
INDIRB
ASGNB 16
ADDRLP4 688
ARGP4
ADDRLP4 224+12
ARGP4
ADDRGP4 QuaternionToAxis
CALLF4
pop
line 490
;489:
;490:		if (weaponNum == WP_STUN_BATON)
ADDRLP4 440
INDIRI4
CNSTI4 1
NEI4 $256
line 491
;491:		{
line 492
;492:			int i = 0;
ADDRLP4 704
CNSTI4 0
ASGNI4
ADDRGP4 $259
JUMPV
LABELV $258
line 495
;493:
;494:			while (i < 3)
;495:			{
line 496
;496:				memset( &barrel, 0, sizeof( barrel ) );
ADDRLP4 0
ARGP4
CNSTI4 0
ARGI4
CNSTI4 212
ARGI4
ADDRGP4 memset
CALLP4
pop
line 497
;497:				VectorCopy( parent->lightingOrigin, barrel.lightingOrigin );
ADDRLP4 0+108
ADDRFP4 0
INDIRP4
CNSTI4 108
ADDP4
INDIRB
ASGNB 12
line 498
;498:				barrel.shadowPlane = parent->shadowPlane;
ADDRLP4 0+120
ADDRFP4 0
INDIRP4
CNSTI4 120
ADDP4
INDIRF4
ASGNF4
line 499
;499:				barrel.renderfx = parent->renderfx;
ADDRLP4 0+4
ADDRFP4 0
INDIRP4
CNSTI4 4
ADDP4
INDIRI4
ASGNI4
line 501
;500:
;501:				if (i == 0)
ADDRLP4 704
INDIRI4
CNSTI4 0
NEI4 $264
line 502
;502:				{
line 503
;503:					barrel.hModel = trap_R_RegisterModel("models/weapons2/stun_baton/baton_barrel.md3");
ADDRGP4 $267
ARGP4
ADDRLP4 708
ADDRGP4 trap_R_RegisterModel
CALLI4
ASGNI4
ADDRLP4 0+8
ADDRLP4 708
INDIRI4
ASGNI4
line 504
;504:				}
ADDRGP4 $265
JUMPV
LABELV $264
line 505
;505:				else if (i == 1)
ADDRLP4 704
INDIRI4
CNSTI4 1
NEI4 $268
line 506
;506:				{
line 507
;507:					barrel.hModel = trap_R_RegisterModel("models/weapons2/stun_baton/baton_barrel2.md3");
ADDRGP4 $271
ARGP4
ADDRLP4 708
ADDRGP4 trap_R_RegisterModel
CALLI4
ASGNI4
ADDRLP4 0+8
ADDRLP4 708
INDIRI4
ASGNI4
line 508
;508:				}
ADDRGP4 $269
JUMPV
LABELV $268
line 510
;509:				else
;510:				{
line 511
;511:					barrel.hModel = trap_R_RegisterModel("models/weapons2/stun_baton/baton_barrel3.md3");
ADDRGP4 $273
ARGP4
ADDRLP4 708
ADDRGP4 trap_R_RegisterModel
CALLI4
ASGNI4
ADDRLP4 0+8
ADDRLP4 708
INDIRI4
ASGNI4
line 512
;512:				}
LABELV $269
LABELV $265
line 513
;513:				angles[YAW] = 0;
ADDRLP4 212+4
CNSTF4 0
ASGNF4
line 514
;514:				angles[PITCH] = 0;
ADDRLP4 212
CNSTF4 0
ASGNF4
line 515
;515:				angles[ROLL] = 0;
ADDRLP4 212+8
CNSTF4 0
ASGNF4
line 517
;516:
;517:				AnglesToAxis( angles, barrel.axis );
ADDRLP4 212
ARGP4
ADDRLP4 0+12
ARGP4
ADDRGP4 AnglesToAxis
CALLV
pop
line 519
;518:
;519:				if (i == 0)
ADDRLP4 704
INDIRI4
CNSTI4 0
NEI4 $277
line 520
;520:				{
line 521
;521:					CG_PositionRotatedEntityOnTag( &barrel, parent/*&gun*/, /*weapon->weaponModel*/weapon->handsModel, "tag_barrel" );
ADDRLP4 0
ARGP4
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 436
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
ADDRGP4 $279
ARGP4
ADDRGP4 CG_PositionRotatedEntityOnTag
CALLV
pop
line 522
;522:				}
ADDRGP4 $278
JUMPV
LABELV $277
line 523
;523:				else if (i == 1)
ADDRLP4 704
INDIRI4
CNSTI4 1
NEI4 $280
line 524
;524:				{
line 525
;525:					CG_PositionRotatedEntityOnTag( &barrel, parent/*&gun*/, /*weapon->weaponModel*/weapon->handsModel, "tag_barrel2" );
ADDRLP4 0
ARGP4
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 436
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
ADDRGP4 $282
ARGP4
ADDRGP4 CG_PositionRotatedEntityOnTag
CALLV
pop
line 526
;526:				}
ADDRGP4 $281
JUMPV
LABELV $280
line 528
;527:				else
;528:				{
line 529
;529:					CG_PositionRotatedEntityOnTag( &barrel, parent/*&gun*/, /*weapon->weaponModel*/weapon->handsModel, "tag_barrel3" );
ADDRLP4 0
ARGP4
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 436
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
ADDRGP4 $283
ARGP4
ADDRGP4 CG_PositionRotatedEntityOnTag
CALLV
pop
line 530
;530:				}
LABELV $281
LABELV $278
line 531
;531:				CG_AddWeaponWithPowerups( &barrel, cent->currentState.powerups );
ADDRLP4 0
ARGP4
ADDRFP4 8
INDIRP4
CNSTI4 272
ADDP4
INDIRI4
ARGI4
ADDRGP4 CG_AddWeaponWithPowerups
CALLV
pop
line 533
;532:
;533:				i++;
ADDRLP4 704
ADDRLP4 704
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 534
;534:			}
LABELV $259
line 494
ADDRLP4 704
INDIRI4
CNSTI4 3
LTI4 $258
line 535
;535:		}
ADDRGP4 $257
JUMPV
LABELV $256
line 537
;536:		else
;537:		{
line 539
;538:			// add the spinning barrel
;539:			if ( weapon->barrelModel ) {
ADDRLP4 436
INDIRP4
CNSTI4 20
ADDP4
INDIRI4
CNSTI4 0
EQI4 $284
line 540
;540:				memset( &barrel, 0, sizeof( barrel ) );
ADDRLP4 0
ARGP4
CNSTI4 0
ARGI4
CNSTI4 212
ARGI4
ADDRGP4 memset
CALLP4
pop
line 541
;541:				VectorCopy( parent->lightingOrigin, barrel.lightingOrigin );
ADDRLP4 0+108
ADDRFP4 0
INDIRP4
CNSTI4 108
ADDP4
INDIRB
ASGNB 12
line 542
;542:				barrel.shadowPlane = parent->shadowPlane;
ADDRLP4 0+120
ADDRFP4 0
INDIRP4
CNSTI4 120
ADDP4
INDIRF4
ASGNF4
line 543
;543:				barrel.renderfx = parent->renderfx;
ADDRLP4 0+4
ADDRFP4 0
INDIRP4
CNSTI4 4
ADDP4
INDIRI4
ASGNI4
line 545
;544:
;545:				barrel.hModel = weapon->barrelModel;
ADDRLP4 0+8
ADDRLP4 436
INDIRP4
CNSTI4 20
ADDP4
INDIRI4
ASGNI4
line 546
;546:				angles[YAW] = 0;
ADDRLP4 212+4
CNSTF4 0
ASGNF4
line 547
;547:				angles[PITCH] = 0;
ADDRLP4 212
CNSTF4 0
ASGNF4
line 548
;548:				angles[ROLL] = 0;
ADDRLP4 212+8
CNSTF4 0
ASGNF4
line 550
;549:
;550:				AnglesToAxis( angles, barrel.axis );
ADDRLP4 212
ARGP4
ADDRLP4 0+12
ARGP4
ADDRGP4 AnglesToAxis
CALLV
pop
line 552
;551:
;552:				CG_PositionRotatedEntityOnTag( &barrel, parent/*&gun*/, /*weapon->weaponModel*/weapon->handsModel, "tag_barrel" );
ADDRLP4 0
ARGP4
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 436
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ARGI4
ADDRGP4 $279
ARGP4
ADDRGP4 CG_PositionRotatedEntityOnTag
CALLV
pop
line 554
;553:
;554:				CG_AddWeaponWithPowerups( &barrel, cent->currentState.powerups );
ADDRLP4 0
ARGP4
ADDRFP4 8
INDIRP4
CNSTI4 272
ADDP4
INDIRI4
ARGI4
ADDRGP4 CG_AddWeaponWithPowerups
CALLV
pop
line 555
;555:			}
LABELV $284
line 556
;556:		}
LABELV $257
line 557
;557:	}
LABELV $233
line 562
;558:/*
;559:Ghoul2 Insert End
;560:*/
;561:
;562:	memset (&flash, 0, sizeof(flash));
ADDRLP4 444
ARGP4
CNSTI4 0
ARGI4
CNSTI4 212
ARGI4
ADDRGP4 memset
CALLP4
pop
line 563
;563:	CG_PositionEntityOnTag( &flash, &gun, gun.hModel, "tag_flash");
ADDRLP4 444
ARGP4
ADDRLP4 224
ARGP4
ADDRLP4 224+8
INDIRI4
ARGI4
ADDRGP4 $294
ARGP4
ADDRGP4 CG_PositionEntityOnTag
CALLV
pop
line 565
;564:
;565:	VectorCopy(flash.origin, cg.lastFPFlashPoint);
ADDRGP4 cg+13796
ADDRLP4 444+52
INDIRB
ASGNB 12
line 569
;566:
;567:	// Do special charge bits
;568:	//-----------------------
;569:	if ( (ps || cg.renderingThirdPerson || cg.predictedPlayerState.clientNum != cent->currentState.number) &&
ADDRFP4 4
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $303
ADDRGP4 cg+88
INDIRI4
CNSTI4 0
NEI4 $303
ADDRGP4 cg+96+144
INDIRI4
ADDRFP4 8
INDIRP4
INDIRI4
EQI4 $297
LABELV $303
ADDRLP4 676
ADDRFP4 8
INDIRP4
ASGNP4
ADDRLP4 676
INDIRP4
CNSTI4 216
ADDP4
INDIRI4
CNSTI4 5
NEI4 $305
ADDRLP4 676
INDIRP4
CNSTI4 276
ADDP4
INDIRI4
CNSTI4 3
EQI4 $306
LABELV $305
ADDRLP4 680
ADDRFP4 8
INDIRP4
ASGNP4
ADDRLP4 680
INDIRP4
CNSTI4 276
ADDP4
INDIRI4
CNSTI4 6
NEI4 $307
ADDRLP4 680
INDIRP4
CNSTI4 216
ADDP4
INDIRI4
CNSTI4 4
EQI4 $306
LABELV $307
ADDRLP4 684
ADDRFP4 8
INDIRP4
ASGNP4
ADDRLP4 684
INDIRP4
CNSTI4 276
ADDP4
INDIRI4
CNSTI4 8
NEI4 $297
ADDRLP4 684
INDIRP4
CNSTI4 216
ADDP4
INDIRI4
CNSTI4 5
NEI4 $297
LABELV $306
line 573
;570:		( ( cent->currentState.modelindex2 == WEAPON_CHARGING_ALT && cent->currentState.weapon == WP_BRYAR_PISTOL ) ||
;571:		  ( cent->currentState.weapon == WP_BOWCASTER && cent->currentState.modelindex2 == WEAPON_CHARGING ) ||
;572:		  ( cent->currentState.weapon == WP_DEMP2 && cent->currentState.modelindex2 == WEAPON_CHARGING_ALT) ) )
;573:	{
line 574
;574:		int		shader = 0;
ADDRLP4 764
CNSTI4 0
ASGNI4
line 575
;575:		float	val = 0.0f;
ADDRLP4 760
CNSTF4 0
ASGNF4
line 576
;576:		float	scale = 1.0f;
ADDRLP4 768
CNSTF4 1065353216
ASGNF4
line 580
;577:		addspriteArgStruct_t fxSArgs;
;578:		vec3_t flashorigin, flashdir;
;579:
;580:		if (!thirdPerson)
ADDRFP4 20
INDIRI4
CNSTI4 0
NEI4 $308
line 581
;581:		{
line 582
;582:			VectorCopy(flash.origin, flashorigin);
ADDRLP4 772
ADDRLP4 444+52
INDIRB
ASGNB 12
line 583
;583:			VectorCopy(flash.axis[0], flashdir);
ADDRLP4 784
ADDRLP4 444+12
INDIRB
ASGNB 12
line 584
;584:		}
ADDRGP4 $309
JUMPV
LABELV $308
line 586
;585:		else
;586:		{
line 589
;587:			mdxaBone_t 		boltMatrix;
;588:
;589:			if (!trap_G2API_HasGhoul2ModelOnIndex(&(cent->ghoul2), 1))
ADDRFP4 8
INDIRP4
CNSTI4 952
ADDP4
ARGP4
CNSTI4 1
ARGI4
ADDRLP4 844
ADDRGP4 trap_G2API_HasGhoul2ModelOnIndex
CALLI4
ASGNI4
ADDRLP4 844
INDIRI4
CNSTI4 0
NEI4 $312
line 590
;590:			{ //it's quite possible that we may have have no weapon model and be in a valid state, so return here if this is the case
line 591
;591:				return;
ADDRGP4 $230
JUMPV
LABELV $312
line 595
;592:			}
;593:
;594:			// go away and get me the bolt position for this frame please
;595: 			if (!(trap_G2API_GetBoltMatrix(cent->ghoul2, 1, 0, &boltMatrix, newAngles, cent->lerpOrigin, cg.time, cgs.gameModels, cent->modelScale)))
ADDRLP4 848
ADDRFP4 8
INDIRP4
ASGNP4
ADDRLP4 848
INDIRP4
CNSTI4 952
ADDP4
INDIRP4
ARGP4
CNSTI4 1
ARGI4
CNSTI4 0
ARGI4
ADDRLP4 796
ARGP4
ADDRFP4 16
INDIRP4
ARGP4
ADDRLP4 848
INDIRP4
CNSTI4 928
ADDP4
ARGP4
ADDRGP4 cg+64
INDIRI4
ARGI4
ADDRGP4 cgs+36364
ARGP4
ADDRLP4 848
INDIRP4
CNSTI4 964
ADDP4
ARGP4
ADDRLP4 852
ADDRGP4 trap_G2API_GetBoltMatrix
CALLI4
ASGNI4
ADDRLP4 852
INDIRI4
CNSTI4 0
NEI4 $314
line 596
;596:			{	// Couldn't find bolt point.
line 597
;597:				return;
ADDRGP4 $230
JUMPV
LABELV $314
line 600
;598:			}
;599:			
;600:			trap_G2API_GiveMeVectorFromMatrix(&boltMatrix, ORIGIN, flashorigin);
ADDRLP4 796
ARGP4
CNSTI4 0
ARGI4
ADDRLP4 772
ARGP4
ADDRGP4 trap_G2API_GiveMeVectorFromMatrix
CALLV
pop
line 601
;601:			trap_G2API_GiveMeVectorFromMatrix(&boltMatrix, POSITIVE_X, flashdir);
ADDRLP4 796
ARGP4
CNSTI4 1
ARGI4
ADDRLP4 784
ARGP4
ADDRGP4 trap_G2API_GiveMeVectorFromMatrix
CALLV
pop
line 602
;602:		}
LABELV $309
line 604
;603:
;604:		if ( cent->currentState.weapon == WP_BRYAR_PISTOL )
ADDRFP4 8
INDIRP4
CNSTI4 276
ADDP4
INDIRI4
CNSTI4 3
NEI4 $318
line 605
;605:		{
line 607
;606:			// Hardcoded max charge time of 1 second
;607:			val = ( cg.time - cent->currentState.constantLight ) * 0.001f;
ADDRLP4 760
CNSTF4 981668463
ADDRGP4 cg+64
INDIRI4
ADDRFP4 8
INDIRP4
CNSTI4 196
ADDP4
INDIRI4
SUBI4
CVIF4 4
MULF4
ASGNF4
line 608
;608:			shader = cgs.media.bryarFrontFlash;
ADDRLP4 764
ADDRGP4 cgs+71064+20
INDIRI4
ASGNI4
line 609
;609:		}
ADDRGP4 $319
JUMPV
LABELV $318
line 610
;610:		else if ( cent->currentState.weapon == WP_BOWCASTER )
ADDRFP4 8
INDIRP4
CNSTI4 276
ADDP4
INDIRI4
CNSTI4 6
NEI4 $323
line 611
;611:		{
line 613
;612:			// Hardcoded max charge time of 1 second
;613:			val = ( cg.time - cent->currentState.constantLight ) * 0.001f;
ADDRLP4 760
CNSTF4 981668463
ADDRGP4 cg+64
INDIRI4
ADDRFP4 8
INDIRP4
CNSTI4 196
ADDP4
INDIRI4
SUBI4
CVIF4 4
MULF4
ASGNF4
line 614
;614:			shader = cgs.media.greenFrontFlash;
ADDRLP4 764
ADDRGP4 cgs+71064+24
INDIRI4
ASGNI4
line 615
;615:		}
ADDRGP4 $324
JUMPV
LABELV $323
line 616
;616:		else if ( cent->currentState.weapon == WP_DEMP2 )
ADDRFP4 8
INDIRP4
CNSTI4 276
ADDP4
INDIRI4
CNSTI4 8
NEI4 $328
line 617
;617:		{
line 618
;618:			val = ( cg.time - cent->currentState.constantLight ) * 0.001f;
ADDRLP4 760
CNSTF4 981668463
ADDRGP4 cg+64
INDIRI4
ADDRFP4 8
INDIRP4
CNSTI4 196
ADDP4
INDIRI4
SUBI4
CVIF4 4
MULF4
ASGNF4
line 619
;619:			shader = cgs.media.lightningFlash;
ADDRLP4 764
ADDRGP4 cgs+71064+28
INDIRI4
ASGNI4
line 620
;620:			scale = 1.75f;
ADDRLP4 768
CNSTF4 1071644672
ASGNF4
line 621
;621:		}
LABELV $328
LABELV $324
LABELV $319
line 623
;622:
;623:		if ( val < 0.0f )
ADDRLP4 760
INDIRF4
CNSTF4 0
GEF4 $333
line 624
;624:		{
line 625
;625:			val = 0.0f;
ADDRLP4 760
CNSTF4 0
ASGNF4
line 626
;626:		}
ADDRGP4 $334
JUMPV
LABELV $333
line 627
;627:		else if ( val > 1.0f )
ADDRLP4 760
INDIRF4
CNSTF4 1065353216
LEF4 $335
line 628
;628:		{
line 629
;629:			val = 1.0f;
ADDRLP4 760
CNSTF4 1065353216
ASGNF4
line 630
;630:			if (ps && cent->currentState.number == ps->clientNum)
ADDRLP4 796
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 796
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $336
ADDRFP4 8
INDIRP4
INDIRI4
ADDRLP4 796
INDIRP4
CNSTI4 144
ADDP4
INDIRI4
NEI4 $336
line 631
;631:			{
line 632
;632:				CGCam_Shake( /*0.1f*/0.2f, 100 );
CNSTF4 1045220557
ARGF4
CNSTI4 100
ARGI4
ADDRGP4 CGCam_Shake
CALLV
pop
line 633
;633:			}
line 634
;634:		}
ADDRGP4 $336
JUMPV
LABELV $335
line 636
;635:		else
;636:		{
line 637
;637:			if (ps && cent->currentState.number == ps->clientNum)
ADDRLP4 796
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 796
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $339
ADDRFP4 8
INDIRP4
INDIRI4
ADDRLP4 796
INDIRP4
CNSTI4 144
ADDP4
INDIRI4
NEI4 $339
line 638
;638:			{
line 639
;639:				CGCam_Shake( val * val * /*0.3f*/0.6f, 100 );
CNSTF4 1058642330
ADDRLP4 760
INDIRF4
ADDRLP4 760
INDIRF4
MULF4
MULF4
ARGF4
CNSTI4 100
ARGI4
ADDRGP4 CGCam_Shake
CALLV
pop
line 640
;640:			}
LABELV $339
line 641
;641:		}
LABELV $336
LABELV $334
line 643
;642:
;643:		val += random() * 0.5f;
ADDRLP4 796
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 760
ADDRLP4 760
INDIRF4
CNSTF4 1056964608
ADDRLP4 796
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
MULF4
ADDF4
ASGNF4
line 645
;644:
;645:		VectorCopy(flashorigin, fxSArgs.origin);
ADDRLP4 688
ADDRLP4 772
INDIRB
ASGNB 12
line 646
;646:		VectorClear(fxSArgs.vel);
ADDRLP4 800
CNSTF4 0
ASGNF4
ADDRLP4 688+12+8
ADDRLP4 800
INDIRF4
ASGNF4
ADDRLP4 688+12+4
ADDRLP4 800
INDIRF4
ASGNF4
ADDRLP4 688+12
ADDRLP4 800
INDIRF4
ASGNF4
line 647
;647:		VectorClear(fxSArgs.accel);
ADDRLP4 804
CNSTF4 0
ASGNF4
ADDRLP4 688+24+8
ADDRLP4 804
INDIRF4
ASGNF4
ADDRLP4 688+24+4
ADDRLP4 804
INDIRF4
ASGNF4
ADDRLP4 688+24
ADDRLP4 804
INDIRF4
ASGNF4
line 648
;648:		fxSArgs.scale = 3.0f*val*scale;
ADDRLP4 688+36
CNSTF4 1077936128
ADDRLP4 760
INDIRF4
MULF4
ADDRLP4 768
INDIRF4
MULF4
ASGNF4
line 649
;649:		fxSArgs.dscale = 0.0f;
ADDRLP4 688+40
CNSTF4 0
ASGNF4
line 650
;650:		fxSArgs.sAlpha = 0.7f;
ADDRLP4 688+44
CNSTF4 1060320051
ASGNF4
line 651
;651:		fxSArgs.eAlpha = 0.7f;
ADDRLP4 688+48
CNSTF4 1060320051
ASGNF4
line 652
;652:		fxSArgs.rotation = random()*360;
ADDRLP4 808
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 688+52
CNSTF4 1135869952
ADDRLP4 808
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
MULF4
ASGNF4
line 653
;653:		fxSArgs.bounce = 0.0f;
ADDRLP4 688+56
CNSTF4 0
ASGNF4
line 654
;654:		fxSArgs.life = 1.0f;
ADDRLP4 688+60
CNSTI4 1
ASGNI4
line 655
;655:		fxSArgs.shader = shader;
ADDRLP4 688+64
ADDRLP4 764
INDIRI4
ASGNI4
line 656
;656:		fxSArgs.flags = 0x08000000;
ADDRLP4 688+68
CNSTI4 134217728
ASGNI4
line 659
;657:
;658:		//FX_AddSprite( flash.origin, NULL, NULL, 3.0f * val, 0.0f, 0.7f, 0.7f, WHITE, WHITE, random() * 360, 0.0f, 1.0f, shader, FX_USE_ALPHA );
;659:		trap_FX_AddSprite(&fxSArgs);
ADDRLP4 688
ARGP4
ADDRGP4 trap_FX_AddSprite
CALLV
pop
line 660
;660:	}
LABELV $297
line 663
;661:
;662:	// make sure we aren't looking at cg.predictedPlayerEntity for LG
;663:	nonPredictedCent = &cg_entities[cent->currentState.clientNum];
ADDRLP4 656
CNSTI4 1920
ADDRFP4 8
INDIRP4
CNSTI4 220
ADDP4
INDIRI4
MULI4
ADDRGP4 cg_entities
ADDP4
ASGNP4
line 668
;664:
;665:	// if the index of the nonPredictedCent is not the same as the clientNum
;666:	// then this is a fake player (like on teh single player podiums), so
;667:	// go ahead and use the cent
;668:	if( ( nonPredictedCent - cg_entities ) != cent->currentState.clientNum ) {
ADDRLP4 656
INDIRP4
CVPU4 4
ADDRGP4 cg_entities
CVPU4 4
SUBU4
CVUI4 4
CNSTI4 1920
DIVI4
ADDRFP4 8
INDIRP4
CNSTI4 220
ADDP4
INDIRI4
EQI4 $360
line 669
;669:		nonPredictedCent = cent;
ADDRLP4 656
ADDRFP4 8
INDIRP4
ASGNP4
line 670
;670:	}
LABELV $360
line 673
;671:
;672:	// add the flash
;673:	if ( ( weaponNum == WP_DEMP2)
ADDRLP4 688
CNSTI4 8
ASGNI4
ADDRLP4 440
INDIRI4
ADDRLP4 688
INDIRI4
NEI4 $362
ADDRLP4 656
INDIRP4
ADDRLP4 688
INDIRI4
ADDP4
INDIRI4
CNSTI4 256
BANDI4
CNSTI4 0
EQI4 $362
line 675
;674:		&& ( nonPredictedCent->currentState.eFlags & EF_FIRING ) ) 
;675:	{
line 677
;676:		// continuous flash
;677:	} else {
ADDRGP4 $363
JUMPV
LABELV $362
line 679
;678:		// impulse flash
;679:		if ( cg.time - cent->muzzleFlashTime > MUZZLE_FLASH_TIME) {
ADDRGP4 cg+64
INDIRI4
ADDRFP4 8
INDIRP4
CNSTI4 600
ADDP4
INDIRI4
SUBI4
CNSTI4 20
LEI4 $364
line 680
;680:			return;
ADDRGP4 $230
JUMPV
LABELV $364
line 682
;681:		}
;682:	}
LABELV $363
line 684
;683:
;684:	if ( ps || cg.renderingThirdPerson ||
ADDRFP4 4
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $373
ADDRGP4 cg+88
INDIRI4
CNSTI4 0
NEI4 $373
ADDRFP4 8
INDIRP4
INDIRI4
ADDRGP4 cg+96+144
INDIRI4
EQI4 $367
LABELV $373
line 686
;685:			cent->currentState.number != cg.predictedPlayerState.clientNum ) 
;686:	{	// Make sure we don't do the thirdperson model effects for the local player if we're in first person
line 690
;687:		vec3_t flashorigin, flashdir;
;688:		refEntity_t	flash;
;689:
;690:		memset (&flash, 0, sizeof(flash));
ADDRLP4 692
ARGP4
CNSTI4 0
ARGI4
CNSTI4 212
ARGI4
ADDRGP4 memset
CALLP4
pop
line 692
;691:
;692:		if (!thirdPerson)
ADDRFP4 20
INDIRI4
CNSTI4 0
NEI4 $374
line 693
;693:		{
line 694
;694:			CG_PositionEntityOnTag( &flash, &gun, gun.hModel, "tag_flash");
ADDRLP4 692
ARGP4
ADDRLP4 224
ARGP4
ADDRLP4 224+8
INDIRI4
ARGI4
ADDRGP4 $294
ARGP4
ADDRGP4 CG_PositionEntityOnTag
CALLV
pop
line 695
;695:			VectorCopy(flash.origin, flashorigin);
ADDRLP4 904
ADDRLP4 692+52
INDIRB
ASGNB 12
line 696
;696:			VectorCopy(flash.axis[0], flashdir);
ADDRLP4 916
ADDRLP4 692+12
INDIRB
ASGNB 12
line 697
;697:		}
ADDRGP4 $375
JUMPV
LABELV $374
line 699
;698:		else
;699:		{
line 702
;700:			mdxaBone_t 		boltMatrix;
;701:
;702:			if (!trap_G2API_HasGhoul2ModelOnIndex(&(cent->ghoul2), 1))
ADDRFP4 8
INDIRP4
CNSTI4 952
ADDP4
ARGP4
CNSTI4 1
ARGI4
ADDRLP4 976
ADDRGP4 trap_G2API_HasGhoul2ModelOnIndex
CALLI4
ASGNI4
ADDRLP4 976
INDIRI4
CNSTI4 0
NEI4 $379
line 703
;703:			{ //it's quite possible that we may have have no weapon model and be in a valid state, so return here if this is the case
line 704
;704:				return;
ADDRGP4 $230
JUMPV
LABELV $379
line 708
;705:			}
;706:
;707:			// go away and get me the bolt position for this frame please
;708: 			if (!(trap_G2API_GetBoltMatrix(cent->ghoul2, 1, 0, &boltMatrix, newAngles, cent->lerpOrigin, cg.time, cgs.gameModels, cent->modelScale)))
ADDRLP4 980
ADDRFP4 8
INDIRP4
ASGNP4
ADDRLP4 980
INDIRP4
CNSTI4 952
ADDP4
INDIRP4
ARGP4
CNSTI4 1
ARGI4
CNSTI4 0
ARGI4
ADDRLP4 928
ARGP4
ADDRFP4 16
INDIRP4
ARGP4
ADDRLP4 980
INDIRP4
CNSTI4 928
ADDP4
ARGP4
ADDRGP4 cg+64
INDIRI4
ARGI4
ADDRGP4 cgs+36364
ARGP4
ADDRLP4 980
INDIRP4
CNSTI4 964
ADDP4
ARGP4
ADDRLP4 984
ADDRGP4 trap_G2API_GetBoltMatrix
CALLI4
ASGNI4
ADDRLP4 984
INDIRI4
CNSTI4 0
NEI4 $381
line 709
;709:			{	// Couldn't find bolt point.
line 710
;710:				return;
ADDRGP4 $230
JUMPV
LABELV $381
line 713
;711:			}
;712:			
;713:			trap_G2API_GiveMeVectorFromMatrix(&boltMatrix, ORIGIN, flashorigin);
ADDRLP4 928
ARGP4
CNSTI4 0
ARGI4
ADDRLP4 904
ARGP4
ADDRGP4 trap_G2API_GiveMeVectorFromMatrix
CALLV
pop
line 714
;714:			trap_G2API_GiveMeVectorFromMatrix(&boltMatrix, POSITIVE_X, flashdir);
ADDRLP4 928
ARGP4
CNSTI4 1
ARGI4
ADDRLP4 916
ARGP4
ADDRGP4 trap_G2API_GiveMeVectorFromMatrix
CALLV
pop
line 715
;715:		}
LABELV $375
line 717
;716:
;717:		if ( cg.time - cent->muzzleFlashTime <= MUZZLE_FLASH_TIME + 10 )
ADDRGP4 cg+64
INDIRI4
ADDRFP4 8
INDIRP4
CNSTI4 600
ADDP4
INDIRI4
SUBI4
CNSTI4 30
GTI4 $385
line 718
;718:		{	// Handle muzzle flashes
line 719
;719:			if ( cent->currentState.eFlags & EF_ALT_FIRING )
ADDRFP4 8
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
CNSTI4 512
BANDI4
CNSTI4 0
EQI4 $388
line 720
;720:			{	// Check the alt firing first.
line 721
;721:				if (weapon->altMuzzleEffect)
ADDRLP4 436
INDIRP4
CNSTI4 156
ADDP4
INDIRI4
CNSTI4 0
EQI4 $389
line 722
;722:				{
line 723
;723:					trap_FX_PlayEffectID(weapon->altMuzzleEffect, flashorigin, flashdir);
ADDRLP4 436
INDIRP4
CNSTI4 156
ADDP4
INDIRI4
ARGI4
ADDRLP4 904
ARGP4
ADDRLP4 916
ARGP4
ADDRGP4 trap_FX_PlayEffectID
CALLV
pop
line 724
;724:				}
line 725
;725:			}
ADDRGP4 $389
JUMPV
LABELV $388
line 727
;726:			else
;727:			{	// Regular firing
line 728
;728:				if (weapon->muzzleEffect)
ADDRLP4 436
INDIRP4
CNSTI4 92
ADDP4
INDIRI4
CNSTI4 0
EQI4 $392
line 729
;729:				{
line 730
;730:					trap_FX_PlayEffectID(weapon->muzzleEffect, flashorigin, flashdir);
ADDRLP4 436
INDIRP4
CNSTI4 92
ADDP4
INDIRI4
ARGI4
ADDRLP4 904
ARGP4
ADDRLP4 916
ARGP4
ADDRGP4 trap_FX_PlayEffectID
CALLV
pop
line 731
;731:				}
LABELV $392
line 732
;732:			}
LABELV $389
line 733
;733:		}
LABELV $385
line 736
;734:
;735:		// add lightning bolt
;736:		CG_LightningBolt( nonPredictedCent, flashorigin );
ADDRLP4 656
INDIRP4
ARGP4
ADDRLP4 904
ARGP4
ADDRGP4 CG_LightningBolt
CALLV
pop
line 738
;737:
;738:		if ( weapon->flashDlightColor[0] || weapon->flashDlightColor[1] || weapon->flashDlightColor[2] ) {
ADDRLP4 932
CNSTF4 0
ASGNF4
ADDRLP4 436
INDIRP4
CNSTI4 44
ADDP4
INDIRF4
ADDRLP4 932
INDIRF4
NEF4 $397
ADDRLP4 436
INDIRP4
CNSTI4 48
ADDP4
INDIRF4
ADDRLP4 932
INDIRF4
NEF4 $397
ADDRLP4 436
INDIRP4
CNSTI4 52
ADDP4
INDIRF4
ADDRLP4 932
INDIRF4
EQF4 $394
LABELV $397
line 739
;739:			trap_R_AddLightToScene( flashorigin, 300 + (rand()&31), weapon->flashDlightColor[0],
ADDRLP4 936
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 904
ARGP4
ADDRLP4 936
INDIRI4
CNSTI4 31
BANDI4
CNSTI4 300
ADDI4
CVIF4 4
ARGF4
ADDRLP4 436
INDIRP4
CNSTI4 44
ADDP4
INDIRF4
ARGF4
ADDRLP4 436
INDIRP4
CNSTI4 48
ADDP4
INDIRF4
ARGF4
ADDRLP4 436
INDIRP4
CNSTI4 52
ADDP4
INDIRF4
ARGF4
ADDRGP4 trap_R_AddLightToScene
CALLV
pop
line 741
;740:				weapon->flashDlightColor[1], weapon->flashDlightColor[2] );
;741:		}
LABELV $394
line 742
;742:	}
LABELV $367
line 743
;743:}
LABELV $230
endproc CG_AddPlayerWeapon 988 36
export CG_AddViewWeapon
proc CG_AddViewWeapon 296 24
line 752
;744:
;745:/*
;746:==============
;747:CG_AddViewWeapon
;748:
;749:Add the weapon, and flash for the player's view
;750:==============
;751:*/
;752:void CG_AddViewWeapon( playerState_t *ps ) {
line 764
;753:	refEntity_t	hand;
;754:	centity_t	*cent;
;755:	clientInfo_t	*ci;
;756:	float		fovOffset;
;757:	vec3_t		angles;
;758:	weaponInfo_t	*weapon;
;759:
;760:   // adnan
;761:   // use quats for weapon orientation
;762:   quat_t      q;
;763:
;764:	float	cgFov = cg_fov.value;
ADDRLP4 212
ADDRGP4 cg_fov+8
INDIRF4
ASGNF4
line 766
;765:
;766:	if (cgFov < 1)
ADDRLP4 212
INDIRF4
CNSTF4 1065353216
GEF4 $400
line 767
;767:	{
line 768
;768:		cgFov = 1;
ADDRLP4 212
CNSTF4 1065353216
ASGNF4
line 769
;769:	}
LABELV $400
line 770
;770:	if (cgFov > 97)
ADDRLP4 212
INDIRF4
CNSTF4 1120010240
LEF4 $402
line 771
;771:	{
line 772
;772:		cgFov = 97;
ADDRLP4 212
CNSTF4 1120010240
ASGNF4
line 773
;773:	}
LABELV $402
line 775
;774:
;775:	if ( ps->persistant[PERS_TEAM] == TEAM_SPECTATOR ) {
ADDRFP4 0
INDIRP4
CNSTI4 292
ADDP4
INDIRI4
CNSTI4 3
NEI4 $404
line 776
;776:		return;
ADDRGP4 $398
JUMPV
LABELV $404
line 779
;777:	}
;778:
;779:	if ( ps->pm_type == PM_INTERMISSION ) {
ADDRFP4 0
INDIRP4
CNSTI4 4
ADDP4
INDIRI4
CNSTI4 6
NEI4 $406
line 780
;780:		return;
ADDRGP4 $398
JUMPV
LABELV $406
line 785
;781:	}
;782:
;783:	// no gun if in third person view or a camera is active
;784:	//if ( cg.renderingThirdPerson || cg.cameraMode) {
;785:	if ( cg.renderingThirdPerson ) {
ADDRGP4 cg+88
INDIRI4
CNSTI4 0
EQI4 $408
line 786
;786:		return;
ADDRGP4 $398
JUMPV
LABELV $408
line 790
;787:	}
;788:
;789:	// allow the gun to be completely removed
;790:	if ( !cg_drawGun.integer || cg.predictedPlayerState.zoomMode) {
ADDRLP4 260
CNSTI4 0
ASGNI4
ADDRGP4 cg_drawGun+12
INDIRI4
ADDRLP4 260
INDIRI4
EQI4 $416
ADDRGP4 cg+96+1332
INDIRI4
ADDRLP4 260
INDIRI4
EQI4 $411
LABELV $416
line 793
;791:		vec3_t		origin;
;792:
;793:		if ( cg.predictedPlayerState.eFlags & EF_FIRING ) {
ADDRGP4 cg+96+108
INDIRI4
CNSTI4 256
BANDI4
CNSTI4 0
EQI4 $398
line 795
;794:			// special hack for lightning gun...
;795:			VectorCopy( cg.refdef.vieworg, origin );
ADDRLP4 264
ADDRGP4 cg+3616+24
INDIRB
ASGNB 12
line 796
;796:			VectorMA( origin, -8, cg.refdef.viewaxis[2], origin );
ADDRLP4 276
CNSTF4 3238002688
ASGNF4
ADDRLP4 264
ADDRLP4 264
INDIRF4
ADDRLP4 276
INDIRF4
ADDRGP4 cg+3616+36+24
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 264+4
ADDRLP4 264+4
INDIRF4
ADDRLP4 276
INDIRF4
ADDRGP4 cg+3616+36+24+4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 264+8
ADDRLP4 264+8
INDIRF4
CNSTF4 3238002688
ADDRGP4 cg+3616+36+24+8
INDIRF4
MULF4
ADDF4
ASGNF4
line 797
;797:			CG_LightningBolt( &cg_entities[ps->clientNum], origin );
CNSTI4 1920
ADDRFP4 0
INDIRP4
CNSTI4 144
ADDP4
INDIRI4
MULI4
ADDRGP4 cg_entities
ADDP4
ARGP4
ADDRLP4 264
ARGP4
ADDRGP4 CG_LightningBolt
CALLV
pop
line 798
;798:		}
line 799
;799:		return;
ADDRGP4 $398
JUMPV
LABELV $411
line 803
;800:	}
;801:
;802:	// don't draw if testing a gun model
;803:	if ( cg.testGun ) {
ADDRGP4 cg+13760
INDIRI4
CNSTI4 0
EQI4 $438
line 804
;804:		return;
ADDRGP4 $398
JUMPV
LABELV $438
line 808
;805:	}
;806:
;807:	// drop gun lower at higher fov
;808:	if ( cgFov > 90 ) {
ADDRLP4 212
INDIRF4
CNSTF4 1119092736
LEF4 $441
line 809
;809:		fovOffset = -0.2 * ( cgFov - 90 );
ADDRLP4 220
CNSTF4 3192704205
ADDRLP4 212
INDIRF4
CNSTF4 1119092736
SUBF4
MULF4
ASGNF4
line 810
;810:	} else {
ADDRGP4 $442
JUMPV
LABELV $441
line 811
;811:		fovOffset = 0;
ADDRLP4 220
CNSTF4 0
ASGNF4
line 812
;812:	}
LABELV $442
line 814
;813:
;814:	cent = &cg.predictedPlayerEntity;	// &cg_entities[cg.snap->ps.clientNum];
ADDRLP4 216
ADDRGP4 cg+1476
ASGNP4
line 815
;815:	CG_RegisterWeapon( ps->weapon );
ADDRFP4 0
INDIRP4
CNSTI4 148
ADDP4
INDIRI4
ARGI4
ADDRGP4 CG_RegisterWeapon
CALLV
pop
line 816
;816:	weapon = &cg_weapons[ ps->weapon ];
ADDRLP4 236
CNSTI4 208
ADDRFP4 0
INDIRP4
CNSTI4 148
ADDP4
INDIRI4
MULI4
ADDRGP4 cg_weapons
ADDP4
ASGNP4
line 818
;817:
;818:	memset (&hand, 0, sizeof(hand));
ADDRLP4 0
ARGP4
CNSTI4 0
ARGI4
CNSTI4 212
ARGI4
ADDRGP4 memset
CALLP4
pop
line 821
;819:
;820:	// set up gun position
;821:	CG_CalculateWeaponPosition( hand.origin, angles );
ADDRLP4 0+52
ARGP4
ADDRLP4 224
ARGP4
ADDRGP4 CG_CalculateWeaponPosition
CALLV
pop
line 823
;822:
;823:	VectorMA( hand.origin, cg_gun_x.value, cg.refdef.viewaxis[0], hand.origin );
ADDRLP4 0+52
ADDRLP4 0+52
INDIRF4
ADDRGP4 cg+3616+36
INDIRF4
ADDRGP4 cg_gun_x+8
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+52+4
ADDRLP4 0+52+4
INDIRF4
ADDRGP4 cg+3616+36+4
INDIRF4
ADDRGP4 cg_gun_x+8
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+52+8
ADDRLP4 0+52+8
INDIRF4
ADDRGP4 cg+3616+36+8
INDIRF4
ADDRGP4 cg_gun_x+8
INDIRF4
MULF4
ADDF4
ASGNF4
line 824
;824:	VectorMA( hand.origin, cg_gun_y.value, cg.refdef.viewaxis[1], hand.origin );
ADDRLP4 0+52
ADDRLP4 0+52
INDIRF4
ADDRGP4 cg+3616+36+12
INDIRF4
ADDRGP4 cg_gun_y+8
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+52+4
ADDRLP4 0+52+4
INDIRF4
ADDRGP4 cg+3616+36+12+4
INDIRF4
ADDRGP4 cg_gun_y+8
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+52+8
ADDRLP4 0+52+8
INDIRF4
ADDRGP4 cg+3616+36+12+8
INDIRF4
ADDRGP4 cg_gun_y+8
INDIRF4
MULF4
ADDF4
ASGNF4
line 825
;825:	VectorMA( hand.origin, (cg_gun_z.value+fovOffset), cg.refdef.viewaxis[2], hand.origin );
ADDRLP4 0+52
ADDRLP4 0+52
INDIRF4
ADDRGP4 cg+3616+36+24
INDIRF4
ADDRGP4 cg_gun_z+8
INDIRF4
ADDRLP4 220
INDIRF4
ADDF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+52+4
ADDRLP4 0+52+4
INDIRF4
ADDRGP4 cg+3616+36+24+4
INDIRF4
ADDRGP4 cg_gun_z+8
INDIRF4
ADDRLP4 220
INDIRF4
ADDF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+52+8
ADDRLP4 0+52+8
INDIRF4
ADDRGP4 cg+3616+36+24+8
INDIRF4
ADDRGP4 cg_gun_z+8
INDIRF4
ADDRLP4 220
INDIRF4
ADDF4
MULF4
ADDF4
ASGNF4
line 828
;826:
;827:	//AnglesToAxis( angles, hand.axis );
;828:   QuaternionFromTieFloats(ps->tieFloats, &q);
ADDRFP4 0
INDIRP4
CNSTI4 656
ADDP4
ARGP4
ADDRLP4 240
ARGP4
ADDRGP4 QuaternionFromTieFloats
CALLV
pop
line 829
;829:   QuaternionToAxis(q, hand.axis);
ADDRLP4 264
ADDRLP4 240
INDIRB
ASGNB 16
ADDRLP4 264
ARGP4
ADDRLP4 0+12
ARGP4
ADDRGP4 QuaternionToAxis
CALLF4
pop
line 832
;830:
;831:	// map torso animations to weapon animations
;832:	if ( cg_gun_frame.integer ) {
ADDRGP4 cg_gun_frame+12
INDIRI4
CNSTI4 0
EQI4 $515
line 834
;833:		// development tool
;834:		hand.frame = hand.oldframe = cg_gun_frame.integer;
ADDRLP4 280
ADDRGP4 cg_gun_frame+12
INDIRI4
ASGNI4
ADDRLP4 0+124
ADDRLP4 280
INDIRI4
ASGNI4
ADDRLP4 0+104
ADDRLP4 280
INDIRI4
ASGNI4
line 835
;835:		hand.backlerp = 0;
ADDRLP4 0+128
CNSTF4 0
ASGNF4
line 836
;836:	} else {
ADDRGP4 $516
JUMPV
LABELV $515
line 838
;837:		// get clientinfo for animation map
;838:		ci = &cgs.clientinfo[ cent->currentState.clientNum ];
ADDRLP4 256
CNSTI4 812
ADDRLP4 216
INDIRP4
CNSTI4 220
ADDP4
INDIRI4
MULI4
ADDRGP4 cgs+43024
ADDP4
ASGNP4
line 839
;839:		hand.frame = CG_MapTorsoToWeaponFrame( ci, cent->pe.torso.frame, cent->currentState.torsoAnim & ~ANIM_TOGGLEBIT );
ADDRLP4 256
INDIRP4
ARGP4
ADDRLP4 216
INDIRP4
CNSTI4 716
ADDP4
INDIRI4
ARGI4
ADDRLP4 216
INDIRP4
CNSTI4 284
ADDP4
INDIRI4
CNSTI4 -2049
BANDI4
ARGI4
ADDRLP4 284
ADDRGP4 CG_MapTorsoToWeaponFrame
CALLI4
ASGNI4
ADDRLP4 0+104
ADDRLP4 284
INDIRI4
ASGNI4
line 840
;840:		hand.oldframe = CG_MapTorsoToWeaponFrame( ci, cent->pe.torso.oldFrame, cent->currentState.torsoAnim & ~ANIM_TOGGLEBIT );
ADDRLP4 256
INDIRP4
ARGP4
ADDRLP4 216
INDIRP4
CNSTI4 708
ADDP4
INDIRI4
ARGI4
ADDRLP4 216
INDIRP4
CNSTI4 284
ADDP4
INDIRI4
CNSTI4 -2049
BANDI4
ARGI4
ADDRLP4 292
ADDRGP4 CG_MapTorsoToWeaponFrame
CALLI4
ASGNI4
ADDRLP4 0+124
ADDRLP4 292
INDIRI4
ASGNI4
line 841
;841:		hand.backlerp = cent->pe.torso.backlerp;
ADDRLP4 0+128
ADDRLP4 216
INDIRP4
CNSTI4 724
ADDP4
INDIRF4
ASGNF4
line 844
;842:
;843:		// Handle the fringe situation where oldframe is invalid
;844:		if ( hand.frame == -1 )
ADDRLP4 0+104
INDIRI4
CNSTI4 -1
NEI4 $526
line 845
;845:		{
line 846
;846:			hand.frame = 0;
ADDRLP4 0+104
CNSTI4 0
ASGNI4
line 847
;847:			hand.oldframe = 0;
ADDRLP4 0+124
CNSTI4 0
ASGNI4
line 848
;848:			hand.backlerp = 0;
ADDRLP4 0+128
CNSTF4 0
ASGNF4
line 849
;849:		}
ADDRGP4 $527
JUMPV
LABELV $526
line 850
;850:		else if ( hand.oldframe == -1 )
ADDRLP4 0+124
INDIRI4
CNSTI4 -1
NEI4 $532
line 851
;851:		{
line 852
;852:			hand.oldframe = hand.frame;
ADDRLP4 0+124
ADDRLP4 0+104
INDIRI4
ASGNI4
line 853
;853:			hand.backlerp = 0;
ADDRLP4 0+128
CNSTF4 0
ASGNF4
line 854
;854:		}
LABELV $532
LABELV $527
line 855
;855:	}
LABELV $516
line 857
;856:
;857:	hand.hModel = weapon->handsModel;
ADDRLP4 0+8
ADDRLP4 236
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
ASGNI4
line 858
;858:	hand.renderfx = RF_DEPTHHACK | RF_FIRST_PERSON;// | RF_MINLIGHT;
ADDRLP4 0+4
CNSTI4 12
ASGNI4
line 861
;859:
;860:	// add everything onto the hand
;861:	CG_AddPlayerWeapon( &hand, ps, &cg.predictedPlayerEntity, ps->persistant[PERS_TEAM], angles, qfalse );
ADDRLP4 0
ARGP4
ADDRLP4 280
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 280
INDIRP4
ARGP4
ADDRGP4 cg+1476
ARGP4
ADDRLP4 280
INDIRP4
CNSTI4 292
ADDP4
INDIRI4
ARGI4
ADDRLP4 224
ARGP4
CNSTI4 0
ARGI4
ADDRGP4 CG_AddPlayerWeapon
CALLV
pop
line 862
;862:}
LABELV $398
endproc CG_AddViewWeapon 296 24
export CG_DrawIconBackground
proc CG_DrawIconBackground 56 20
line 877
;863:
;864:/*
;865:==============================================================================
;866:
;867:WEAPON SELECTION
;868:
;869:==============================================================================
;870:*/
;871:#define ICON_WEAPONS	0
;872:#define ICON_FORCE		1
;873:#define ICON_INVENTORY	2
;874:
;875:
;876:void CG_DrawIconBackground(void)
;877:{
line 880
;878:	int				height,xAdd,x2,y2,t;
;879:	int				prongLeftX,prongRightX;
;880:	float			inTime = cg.invenSelectTime+WEAPON_SELECT_TIME;
ADDRLP4 32
ADDRGP4 cg+13788
INDIRF4
CNSTF4 1152319488
ADDF4
ASGNF4
line 881
;881:	float			wpTime = cg.weaponSelectTime+WEAPON_SELECT_TIME;
ADDRLP4 36
ADDRGP4 cg+13372
INDIRI4
CNSTI4 1400
ADDI4
CVIF4 4
ASGNF4
line 882
;882:	float			fpTime = cg.forceSelectTime+WEAPON_SELECT_TIME;
ADDRLP4 40
ADDRGP4 cg+13792
INDIRF4
CNSTF4 1152319488
ADDF4
ASGNF4
line 884
;883:	qhandle_t		background;
;884:	int				drawType = cgs.media.weaponIconBackground;
ADDRLP4 8
ADDRGP4 cgs+71064+1216
INDIRI4
ASGNI4
line 885
;885:	int				prongsOn = cgs.media.weaponProngsOn;
ADDRLP4 28
ADDRGP4 cgs+71064+1224
INDIRI4
ASGNI4
line 888
;886:		
;887:	// don't display if dead
;888:	if ( cg.snap->ps.stats[STAT_HEALTH] <= 0 ) 
ADDRGP4 cg+36
INDIRP4
CNSTI4 260
ADDP4
INDIRI4
CNSTI4 0
GTI4 $549
line 889
;889:	{
line 890
;890:		return;
ADDRGP4 $541
JUMPV
LABELV $549
line 893
;891:	}
;892:
;893:	if (cg_hudFiles.integer)
ADDRGP4 cg_hudFiles+12
INDIRI4
CNSTI4 0
EQI4 $552
line 894
;894:	{ //simple hud
line 895
;895:		return;
ADDRGP4 $541
JUMPV
LABELV $552
line 898
;896:	}
;897:
;898:	x2 = 30;
ADDRLP4 0
CNSTI4 30
ASGNI4
line 899
;899:	y2 = SCREEN_HEIGHT-70;
ADDRLP4 4
CNSTI4 410
ASGNI4
line 901
;900:
;901:	prongLeftX =x2+37; 
ADDRLP4 20
ADDRLP4 0
INDIRI4
CNSTI4 37
ADDI4
ASGNI4
line 902
;902:	prongRightX =x2+544; 
ADDRLP4 24
ADDRLP4 0
INDIRI4
CNSTI4 544
ADDI4
ASGNI4
line 904
;903:
;904:	if (inTime > wpTime)
ADDRLP4 32
INDIRF4
ADDRLP4 36
INDIRF4
LEF4 $555
line 905
;905:	{
line 906
;906:		drawType = cgs.media.inventoryIconBackground;
ADDRLP4 8
ADDRGP4 cgs+71064+1236
INDIRI4
ASGNI4
line 907
;907:		prongsOn = cgs.media.inventoryProngsOn;
ADDRLP4 28
ADDRGP4 cgs+71064+1240
INDIRI4
ASGNI4
line 908
;908:		cg.iconSelectTime = cg.invenSelectTime;
ADDRGP4 cg+13784
ADDRGP4 cg+13788
INDIRF4
ASGNF4
line 909
;909:	}
ADDRGP4 $556
JUMPV
LABELV $555
line 911
;910:	else
;911:	{
line 912
;912:		drawType = cgs.media.weaponIconBackground;
ADDRLP4 8
ADDRGP4 cgs+71064+1216
INDIRI4
ASGNI4
line 913
;913:		prongsOn = cgs.media.weaponProngsOn;
ADDRLP4 28
ADDRGP4 cgs+71064+1224
INDIRI4
ASGNI4
line 914
;914:		cg.iconSelectTime = cg.weaponSelectTime;
ADDRGP4 cg+13784
ADDRGP4 cg+13372
INDIRI4
CVIF4 4
ASGNF4
line 915
;915:	}
LABELV $556
line 917
;916:
;917:	if (fpTime > inTime && fpTime > wpTime)
ADDRLP4 40
INDIRF4
ADDRLP4 32
INDIRF4
LEF4 $569
ADDRLP4 40
INDIRF4
ADDRLP4 36
INDIRF4
LEF4 $569
line 918
;918:	{
line 919
;919:		drawType = cgs.media.forceIconBackground;
ADDRLP4 8
ADDRGP4 cgs+71064+1228
INDIRI4
ASGNI4
line 920
;920:		prongsOn = cgs.media.forceProngsOn;
ADDRLP4 28
ADDRGP4 cgs+71064+1232
INDIRI4
ASGNI4
line 921
;921:		cg.iconSelectTime = cg.forceSelectTime;
ADDRGP4 cg+13784
ADDRGP4 cg+13792
INDIRF4
ASGNF4
line 922
;922:	}
LABELV $569
line 924
;923:
;924:	if ((cg.iconSelectTime+WEAPON_SELECT_TIME)<cg.time)	// Time is up for the HUD to display
ADDRGP4 cg+13784
INDIRF4
CNSTF4 1152319488
ADDF4
ADDRGP4 cg+64
INDIRI4
CVIF4 4
GEF4 $577
line 925
;925:	{
line 926
;926:		if (cg.iconHUDActive)		// The time is up, but we still need to move the prongs back to their original position
ADDRGP4 cg+13776
INDIRI4
CNSTI4 0
EQI4 $581
line 927
;927:		{
line 928
;928:			t =  cg.time - (cg.iconSelectTime+WEAPON_SELECT_TIME);
ADDRLP4 48
ADDRGP4 cg+64
INDIRI4
CVIF4 4
ADDRGP4 cg+13784
INDIRF4
CNSTF4 1152319488
ADDF4
SUBF4
CVFI4 4
ASGNI4
line 929
;929:			cg.iconHUDPercent = t/ 130.0f;
ADDRGP4 cg+13780
ADDRLP4 48
INDIRI4
CVIF4 4
CNSTF4 1124204544
DIVF4
ASGNF4
line 930
;930:			cg.iconHUDPercent = 1 - cg.iconHUDPercent;
ADDRGP4 cg+13780
CNSTF4 1065353216
ADDRGP4 cg+13780
INDIRF4
SUBF4
ASGNF4
line 932
;931:
;932:			if (cg.iconHUDPercent<0)
ADDRGP4 cg+13780
INDIRF4
CNSTF4 0
GEF4 $589
line 933
;933:			{
line 934
;934:				cg.iconHUDActive = qfalse;
ADDRGP4 cg+13776
CNSTI4 0
ASGNI4
line 935
;935:				cg.iconHUDPercent=0;
ADDRGP4 cg+13780
CNSTF4 0
ASGNF4
line 936
;936:			}
LABELV $589
line 938
;937:
;938:			xAdd = (int) 8*cg.iconHUDPercent;
ADDRLP4 12
CNSTF4 1090519040
ADDRGP4 cg+13780
INDIRF4
MULF4
CVFI4 4
ASGNI4
line 940
;939:
;940:			height = (int) (60.0f*cg.iconHUDPercent);
ADDRLP4 16
CNSTF4 1114636288
ADDRGP4 cg+13780
INDIRF4
MULF4
CVFI4 4
ASGNI4
line 941
;941:			CG_DrawPic( x2+60, y2+30, 460, -height, drawType);	// Top half
ADDRLP4 0
INDIRI4
CNSTI4 60
ADDI4
CVIF4 4
ARGF4
ADDRLP4 4
INDIRI4
CNSTI4 30
ADDI4
CVIF4 4
ARGF4
CNSTF4 1139146752
ARGF4
ADDRLP4 16
INDIRI4
NEGI4
CVIF4 4
ARGF4
ADDRLP4 8
INDIRI4
ARGI4
ADDRGP4 CG_DrawPic
CALLV
pop
line 942
;942:			CG_DrawPic( x2+60, y2+30-2,460, height, drawType);	// Bottom half
ADDRLP4 0
INDIRI4
CNSTI4 60
ADDI4
CVIF4 4
ARGF4
ADDRLP4 4
INDIRI4
CNSTI4 30
ADDI4
CNSTI4 2
SUBI4
CVIF4 4
ARGF4
CNSTF4 1139146752
ARGF4
ADDRLP4 16
INDIRI4
CVIF4 4
ARGF4
ADDRLP4 8
INDIRI4
ARGI4
ADDRGP4 CG_DrawPic
CALLV
pop
line 944
;943:
;944:		}
ADDRGP4 $582
JUMPV
LABELV $581
line 946
;945:		else
;946:		{
line 947
;947:			xAdd = 0;
ADDRLP4 12
CNSTI4 0
ASGNI4
line 948
;948:		}
LABELV $582
line 950
;949:
;950:		trap_R_SetColor(hudTintColor);					
ADDRGP4 hudTintColor
INDIRP4
ARGP4
ADDRGP4 trap_R_SetColor
CALLV
pop
line 951
;951:		CG_DrawPic( prongLeftX+xAdd, y2-10, 40, 80, cgs.media.weaponProngsOff);
ADDRLP4 20
INDIRI4
ADDRLP4 12
INDIRI4
ADDI4
CVIF4 4
ARGF4
ADDRLP4 4
INDIRI4
CNSTI4 10
SUBI4
CVIF4 4
ARGF4
CNSTF4 1109393408
ARGF4
CNSTF4 1117782016
ARGF4
ADDRGP4 cgs+71064+1220
INDIRI4
ARGI4
ADDRGP4 CG_DrawPic
CALLV
pop
line 952
;952:		CG_DrawPic( prongRightX-xAdd, y2-10, -40, 80, cgs.media.weaponProngsOff);
ADDRLP4 24
INDIRI4
ADDRLP4 12
INDIRI4
SUBI4
CVIF4 4
ARGF4
ADDRLP4 4
INDIRI4
CNSTI4 10
SUBI4
CVIF4 4
ARGF4
CNSTF4 3256877056
ARGF4
CNSTF4 1117782016
ARGF4
ADDRGP4 cgs+71064+1220
INDIRI4
ARGI4
ADDRGP4 CG_DrawPic
CALLV
pop
line 954
;953:
;954:		return;
ADDRGP4 $541
JUMPV
LABELV $577
line 956
;955:	}
;956:	prongLeftX =x2+37; 
ADDRLP4 20
ADDRLP4 0
INDIRI4
CNSTI4 37
ADDI4
ASGNI4
line 957
;957:	prongRightX =x2+544; 
ADDRLP4 24
ADDRLP4 0
INDIRI4
CNSTI4 544
ADDI4
ASGNI4
line 959
;958:
;959:	if (!cg.iconHUDActive)
ADDRGP4 cg+13776
INDIRI4
CNSTI4 0
NEI4 $600
line 960
;960:	{
line 961
;961:		t = cg.time - cg.iconSelectTime;
ADDRLP4 48
ADDRGP4 cg+64
INDIRI4
CVIF4 4
ADDRGP4 cg+13784
INDIRF4
SUBF4
CVFI4 4
ASGNI4
line 962
;962:		cg.iconHUDPercent = t/ 130.0f;
ADDRGP4 cg+13780
ADDRLP4 48
INDIRI4
CVIF4 4
CNSTF4 1124204544
DIVF4
ASGNF4
line 965
;963:
;964:		// Calc how far into opening sequence we are
;965:		if (cg.iconHUDPercent>1)
ADDRGP4 cg+13780
INDIRF4
CNSTF4 1065353216
LEF4 $606
line 966
;966:		{
line 967
;967:			cg.iconHUDActive = qtrue;
ADDRGP4 cg+13776
CNSTI4 1
ASGNI4
line 968
;968:			cg.iconHUDPercent=1;
ADDRGP4 cg+13780
CNSTF4 1065353216
ASGNF4
line 969
;969:		}
ADDRGP4 $601
JUMPV
LABELV $606
line 970
;970:		else if (cg.iconHUDPercent<0)
ADDRGP4 cg+13780
INDIRF4
CNSTF4 0
GEF4 $601
line 971
;971:		{
line 972
;972:			cg.iconHUDPercent=0;
ADDRGP4 cg+13780
CNSTF4 0
ASGNF4
line 973
;973:		}
line 974
;974:	}
ADDRGP4 $601
JUMPV
LABELV $600
line 976
;975:	else
;976:	{
line 977
;977:		cg.iconHUDPercent=1;
ADDRGP4 cg+13780
CNSTF4 1065353216
ASGNF4
line 978
;978:	}
LABELV $601
line 980
;979:
;980:	trap_R_SetColor( colorTable[CT_WHITE] );					
ADDRGP4 colorTable+128
ARGP4
ADDRGP4 trap_R_SetColor
CALLV
pop
line 981
;981:	height = (int) (60.0f*cg.iconHUDPercent);
ADDRLP4 16
CNSTF4 1114636288
ADDRGP4 cg+13780
INDIRF4
MULF4
CVFI4 4
ASGNI4
line 982
;982:	CG_DrawPic( x2+60, y2+30, 460, -height, drawType);	// Top half
ADDRLP4 0
INDIRI4
CNSTI4 60
ADDI4
CVIF4 4
ARGF4
ADDRLP4 4
INDIRI4
CNSTI4 30
ADDI4
CVIF4 4
ARGF4
CNSTF4 1139146752
ARGF4
ADDRLP4 16
INDIRI4
NEGI4
CVIF4 4
ARGF4
ADDRLP4 8
INDIRI4
ARGI4
ADDRGP4 CG_DrawPic
CALLV
pop
line 983
;983:	CG_DrawPic( x2+60, y2+30-2,460, height, drawType);	// Bottom half
ADDRLP4 0
INDIRI4
CNSTI4 60
ADDI4
CVIF4 4
ARGF4
ADDRLP4 4
INDIRI4
CNSTI4 30
ADDI4
CNSTI4 2
SUBI4
CVIF4 4
ARGF4
CNSTF4 1139146752
ARGF4
ADDRLP4 16
INDIRI4
CVIF4 4
ARGF4
ADDRLP4 8
INDIRI4
ARGI4
ADDRGP4 CG_DrawPic
CALLV
pop
line 993
;984:
;985:	// And now for the prongs
;986:/*	if ((cg.inventorySelectTime+WEAPON_SELECT_TIME)>cg.time)	
;987:	{
;988:		cgs.media.currentBackground = ICON_INVENTORY;
;989:		background = &cgs.media.inventoryProngsOn;
;990:	}
;991:	else if ((cg.weaponSelectTime+WEAPON_SELECT_TIME)>cg.time)	
;992:	{*/
;993:		cgs.media.currentBackground = ICON_WEAPONS;
ADDRGP4 cgs+71064+1212
CNSTI4 0
ASGNI4
line 994
;994:		background = prongsOn;
ADDRLP4 44
ADDRLP4 28
INDIRI4
ASGNI4
line 1003
;995:/*	}
;996:	else 
;997:	{
;998:		cgs.media.currentBackground = ICON_FORCE;
;999:		background = &cgs.media.forceProngsOn;
;1000:	}
;1001:*/
;1002:	// Side Prongs
;1003:	trap_R_SetColor( colorTable[CT_WHITE]);					
ADDRGP4 colorTable+128
ARGP4
ADDRGP4 trap_R_SetColor
CALLV
pop
line 1004
;1004:	xAdd = (int) 8*cg.iconHUDPercent;
ADDRLP4 12
CNSTF4 1090519040
ADDRGP4 cg+13780
INDIRF4
MULF4
CVFI4 4
ASGNI4
line 1005
;1005:	CG_DrawPic( prongLeftX+xAdd, y2-10, 40, 80, background);
ADDRLP4 20
INDIRI4
ADDRLP4 12
INDIRI4
ADDI4
CVIF4 4
ARGF4
ADDRLP4 4
INDIRI4
CNSTI4 10
SUBI4
CVIF4 4
ARGF4
CNSTF4 1109393408
ARGF4
CNSTF4 1117782016
ARGF4
ADDRLP4 44
INDIRI4
ARGI4
ADDRGP4 CG_DrawPic
CALLV
pop
line 1006
;1006:	CG_DrawPic( prongRightX-xAdd, y2-10, -40, 80, background);
ADDRLP4 24
INDIRI4
ADDRLP4 12
INDIRI4
SUBI4
CVIF4 4
ARGF4
ADDRLP4 4
INDIRI4
CNSTI4 10
SUBI4
CVIF4 4
ARGF4
CNSTF4 3256877056
ARGF4
CNSTF4 1117782016
ARGF4
ADDRLP4 44
INDIRI4
ARGI4
ADDRGP4 CG_DrawPic
CALLV
pop
line 1008
;1007:
;1008:}
LABELV $541
endproc CG_DrawIconBackground 56 20
export CG_WeaponCheck
proc CG_WeaponCheck 12 0
line 1011
;1009:
;1010:qboolean CG_WeaponCheck(int weap)
;1011:{
line 1012
;1012:	if (cg.snap->ps.ammo[weaponData[weap].ammoIndex] < weaponData[weap].energyPerShot &&
ADDRLP4 0
CNSTI4 56
ADDRFP4 0
INDIRI4
MULI4
ASGNI4
ADDRLP4 4
ADDRLP4 0
INDIRI4
ADDRGP4 weaponData
ADDP4
INDIRI4
CNSTI4 2
LSHI4
ASGNI4
ADDRLP4 8
CNSTI4 452
ASGNI4
ADDRLP4 4
INDIRI4
ADDRGP4 cg+36
INDIRP4
ADDRLP4 8
INDIRI4
ADDP4
ADDP4
INDIRI4
ADDRLP4 0
INDIRI4
ADDRGP4 weaponData+8
ADDP4
INDIRI4
GEI4 $623
ADDRLP4 4
INDIRI4
ADDRGP4 cg+36
INDIRP4
ADDRLP4 8
INDIRI4
ADDP4
ADDP4
INDIRI4
ADDRLP4 0
INDIRI4
ADDRGP4 weaponData+20
ADDP4
INDIRI4
GEI4 $623
line 1014
;1013:		cg.snap->ps.ammo[weaponData[weap].ammoIndex] < weaponData[weap].altEnergyPerShot)
;1014:	{
line 1015
;1015:		return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $622
JUMPV
LABELV $623
line 1018
;1016:	}
;1017:
;1018:	return qtrue;
CNSTI4 1
RETI4
LABELV $622
endproc CG_WeaponCheck 12 0
proc CG_WeaponSelectable 12 0
line 1026
;1019:}
;1020:
;1021:/*
;1022:===============
;1023:CG_WeaponSelectable
;1024:===============
;1025:*/
;1026:static qboolean CG_WeaponSelectable( int i ) {
line 1030
;1027:	/*if ( !cg.snap->ps.ammo[weaponData[i].ammoIndex] ) {
;1028:		return qfalse;
;1029:	}*/
;1030:	if (!i)
ADDRFP4 0
INDIRI4
CNSTI4 0
NEI4 $630
line 1031
;1031:	{
line 1032
;1032:		return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $629
JUMPV
LABELV $630
line 1035
;1033:	}
;1034:
;1035:	if (cg.predictedPlayerState.ammo[weaponData[i].ammoIndex] < weaponData[i].energyPerShot &&
ADDRLP4 0
CNSTI4 56
ADDRFP4 0
INDIRI4
MULI4
ASGNI4
ADDRLP4 4
ADDRLP4 0
INDIRI4
ADDRGP4 weaponData
ADDP4
INDIRI4
CNSTI4 2
LSHI4
ASGNI4
ADDRLP4 4
INDIRI4
ADDRGP4 cg+96+408
ADDP4
INDIRI4
ADDRLP4 0
INDIRI4
ADDRGP4 weaponData+8
ADDP4
INDIRI4
GEI4 $632
ADDRLP4 4
INDIRI4
ADDRGP4 cg+96+408
ADDP4
INDIRI4
ADDRLP4 0
INDIRI4
ADDRGP4 weaponData+20
ADDP4
INDIRI4
GEI4 $632
line 1037
;1036:		cg.predictedPlayerState.ammo[weaponData[i].ammoIndex] < weaponData[i].altEnergyPerShot)
;1037:	{
line 1038
;1038:		return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $629
JUMPV
LABELV $632
line 1041
;1039:	}
;1040:
;1041:	if (i == WP_DET_PACK && cg.predictedPlayerState.ammo[weaponData[i].ammoIndex] < 1 &&
ADDRLP4 8
ADDRFP4 0
INDIRI4
ASGNI4
ADDRLP4 8
INDIRI4
CNSTI4 13
NEI4 $640
CNSTI4 56
ADDRLP4 8
INDIRI4
MULI4
ADDRGP4 weaponData
ADDP4
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 cg+96+408
ADDP4
INDIRI4
CNSTI4 1
GEI4 $640
ADDRGP4 cg+96+640
INDIRI4
CNSTI4 0
NEI4 $640
line 1043
;1042:		!cg.predictedPlayerState.hasDetPackPlanted)
;1043:	{
line 1044
;1044:		return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $629
JUMPV
LABELV $640
line 1047
;1045:	}
;1046:
;1047:	if ( ! (cg.predictedPlayerState.stats[ STAT_WEAPONS ] & ( 1 << i ) ) ) {
ADDRGP4 cg+96+216+16
INDIRI4
CNSTI4 1
ADDRFP4 0
INDIRI4
LSHI4
BANDI4
CNSTI4 0
NEI4 $646
line 1048
;1048:		return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $629
JUMPV
LABELV $646
line 1051
;1049:	}
;1050:
;1051:	return qtrue;
CNSTI4 1
RETI4
LABELV $629
endproc CG_WeaponSelectable 12 0
lit
align 4
LABELV $764
byte 4 1063256064
byte 4 1060622041
byte 4 1039650521
byte 4 1065353216
export CG_DrawWeaponSelect
code
proc CG_DrawWeaponSelect 1112 20
line 1059
;1052:}
;1053:
;1054:/*
;1055:===================
;1056:CG_DrawWeaponSelect
;1057:===================
;1058:*/
;1059:void CG_DrawWeaponSelect( void ) {
line 1069
;1060:	int				i;
;1061:	int				bits;
;1062:	int				count;
;1063:	int				smallIconSize,bigIconSize;
;1064:	int				holdX,x,y,pad;
;1065:	int				sideLeftIconCnt,sideRightIconCnt;
;1066:	int				sideMax,holdCount,iconCnt;
;1067:	int				height;
;1068:
;1069:	if (cg.predictedPlayerState.emplacedIndex)
ADDRGP4 cg+96+596
INDIRI4
CNSTI4 0
EQI4 $652
line 1070
;1070:	{ //can't cycle when on a weapon
line 1071
;1071:		cg.weaponSelectTime = 0;
ADDRGP4 cg+13372
CNSTI4 0
ASGNI4
line 1072
;1072:	}
LABELV $652
line 1074
;1073:
;1074:	if ((cg.weaponSelectTime+WEAPON_SELECT_TIME)<cg.time)	// Time is up for the HUD to display
ADDRGP4 cg+13372
INDIRI4
CNSTI4 1400
ADDI4
ADDRGP4 cg+64
INDIRI4
GEI4 $657
line 1075
;1075:	{
line 1076
;1076:		return;
ADDRGP4 $651
JUMPV
LABELV $657
line 1080
;1077:	}
;1078:
;1079:	// don't display if dead
;1080:	if ( cg.predictedPlayerState.stats[STAT_HEALTH] <= 0 ) 
ADDRGP4 cg+96+216
INDIRI4
CNSTI4 0
GTI4 $661
line 1081
;1081:	{
line 1082
;1082:		return;
ADDRGP4 $651
JUMPV
LABELV $661
line 1086
;1083:	}
;1084:
;1085:	// showing weapon select clears pickup item display, but not the blend blob
;1086:	cg.itemPickupTime = 0;
ADDRGP4 cg+13364
CNSTI4 0
ASGNI4
line 1088
;1087:
;1088:	bits = cg.predictedPlayerState.stats[ STAT_WEAPONS ];
ADDRLP4 12
ADDRGP4 cg+96+216+16
INDIRI4
ASGNI4
line 1091
;1089:
;1090:	// count the number of weapons owned
;1091:	count = 0;
ADDRLP4 36
CNSTI4 0
ASGNI4
line 1093
;1092:
;1093:	if ( !CG_WeaponSelectable(cg.weaponSelect) &&
ADDRGP4 cg+3508
INDIRI4
ARGI4
ADDRLP4 60
ADDRGP4 CG_WeaponSelectable
CALLI4
ASGNI4
ADDRLP4 60
INDIRI4
CNSTI4 0
NEI4 $669
ADDRGP4 cg+3508
INDIRI4
CNSTI4 11
EQI4 $674
ADDRGP4 cg+3508
INDIRI4
CNSTI4 12
NEI4 $669
LABELV $674
line 1095
;1094:		(cg.weaponSelect == WP_THERMAL || cg.weaponSelect == WP_TRIP_MINE) )
;1095:	{ //display this weapon that we don't actually "have" as unhighlighted until it's deselected
line 1097
;1096:	  //since it's selected we must increase the count to display the proper number of valid selectable weapons
;1097:		count++;
ADDRLP4 36
ADDRLP4 36
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 1098
;1098:	}
LABELV $669
line 1100
;1099:
;1100:	for ( i = 1 ; i < 16 ; i++ ) 
ADDRLP4 0
CNSTI4 1
ASGNI4
LABELV $675
line 1101
;1101:	{
line 1102
;1102:		if ( bits & ( 1 << i ) ) 
ADDRLP4 12
INDIRI4
CNSTI4 1
ADDRLP4 0
INDIRI4
LSHI4
BANDI4
CNSTI4 0
EQI4 $679
line 1103
;1103:		{
line 1104
;1104:			if ( CG_WeaponSelectable(i) ||
ADDRLP4 0
INDIRI4
ARGI4
ADDRLP4 64
ADDRGP4 CG_WeaponSelectable
CALLI4
ASGNI4
ADDRLP4 64
INDIRI4
CNSTI4 0
NEI4 $683
ADDRLP4 0
INDIRI4
CNSTI4 11
EQI4 $681
ADDRLP4 0
INDIRI4
CNSTI4 12
EQI4 $681
LABELV $683
line 1106
;1105:				(i != WP_THERMAL && i != WP_TRIP_MINE) )
;1106:			{
line 1107
;1107:				count++;
ADDRLP4 36
ADDRLP4 36
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 1108
;1108:			}
LABELV $681
line 1109
;1109:		}
LABELV $679
line 1110
;1110:	}
LABELV $676
line 1100
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 16
LTI4 $675
line 1112
;1111:
;1112:	if (count == 0)	// If no weapons, don't display
ADDRLP4 36
INDIRI4
CNSTI4 0
NEI4 $684
line 1113
;1113:	{
line 1114
;1114:		return;
ADDRGP4 $651
JUMPV
LABELV $684
line 1117
;1115:	}
;1116:
;1117:	sideMax = 3;	// Max number of icons on the side
ADDRLP4 56
CNSTI4 3
ASGNI4
line 1120
;1118:
;1119:	// Calculate how many icons will appear to either side of the center one
;1120:	holdCount = count - 1;	// -1 for the center icon
ADDRLP4 52
ADDRLP4 36
INDIRI4
CNSTI4 1
SUBI4
ASGNI4
line 1121
;1121:	if (holdCount == 0)			// No icons to either side
ADDRLP4 52
INDIRI4
CNSTI4 0
NEI4 $686
line 1122
;1122:	{
line 1123
;1123:		sideLeftIconCnt = 0;
ADDRLP4 28
CNSTI4 0
ASGNI4
line 1124
;1124:		sideRightIconCnt = 0;
ADDRLP4 32
CNSTI4 0
ASGNI4
line 1125
;1125:	}
ADDRGP4 $687
JUMPV
LABELV $686
line 1126
;1126:	else if (count > (2*sideMax))	// Go to the max on each side
ADDRLP4 36
INDIRI4
ADDRLP4 56
INDIRI4
CNSTI4 1
LSHI4
LEI4 $688
line 1127
;1127:	{
line 1128
;1128:		sideLeftIconCnt = sideMax;
ADDRLP4 28
ADDRLP4 56
INDIRI4
ASGNI4
line 1129
;1129:		sideRightIconCnt = sideMax;
ADDRLP4 32
ADDRLP4 56
INDIRI4
ASGNI4
line 1130
;1130:	}
ADDRGP4 $689
JUMPV
LABELV $688
line 1132
;1131:	else							// Less than max, so do the calc
;1132:	{
line 1133
;1133:		sideLeftIconCnt = holdCount/2;
ADDRLP4 28
ADDRLP4 52
INDIRI4
CNSTI4 2
DIVI4
ASGNI4
line 1134
;1134:		sideRightIconCnt = holdCount - sideLeftIconCnt;
ADDRLP4 32
ADDRLP4 52
INDIRI4
ADDRLP4 28
INDIRI4
SUBI4
ASGNI4
line 1135
;1135:	}
LABELV $689
LABELV $687
line 1137
;1136:
;1137:	i = cg.weaponSelect - 1;
ADDRLP4 0
ADDRGP4 cg+3508
INDIRI4
CNSTI4 1
SUBI4
ASGNI4
line 1138
;1138:	if (i<1)
ADDRLP4 0
INDIRI4
CNSTI4 1
GEI4 $691
line 1139
;1139:	{
line 1140
;1140:		i = 13;
ADDRLP4 0
CNSTI4 13
ASGNI4
line 1141
;1141:	}
LABELV $691
line 1143
;1142:
;1143:	smallIconSize = 40;
ADDRLP4 8
CNSTI4 40
ASGNI4
line 1144
;1144:	bigIconSize = 80;
ADDRLP4 40
CNSTI4 80
ASGNI4
line 1145
;1145:	pad = 12;
ADDRLP4 20
CNSTI4 12
ASGNI4
line 1147
;1146:
;1147:	x = 320;
ADDRLP4 44
CNSTI4 320
ASGNI4
line 1148
;1148:	y = 410;
ADDRLP4 24
CNSTI4 410
ASGNI4
line 1156
;1149:
;1150:	// Background
;1151://	memcpy(calcColor, colorTable[CT_WHITE], sizeof(vec4_t));
;1152://	calcColor[3] = .35f;
;1153://	trap_R_SetColor( calcColor);					
;1154:
;1155:	// Left side ICONS
;1156:	trap_R_SetColor(colorTable[CT_WHITE]);
ADDRGP4 colorTable+128
ARGP4
ADDRGP4 trap_R_SetColor
CALLV
pop
line 1158
;1157:	// Work backwards from current icon
;1158:	holdX = x - ((bigIconSize/2) + pad + smallIconSize);
ADDRLP4 16
ADDRLP4 44
INDIRI4
ADDRLP4 40
INDIRI4
CNSTI4 2
DIVI4
ADDRLP4 20
INDIRI4
ADDI4
ADDRLP4 8
INDIRI4
ADDI4
SUBI4
ASGNI4
line 1159
;1159:	height = smallIconSize * 1;//cg.iconHUDPercent;
ADDRLP4 48
CNSTI4 1
ADDRLP4 8
INDIRI4
MULI4
ASGNI4
line 1161
;1160:
;1161:	for (iconCnt=1;iconCnt<(sideLeftIconCnt+1);i--)
ADDRLP4 4
CNSTI4 1
ASGNI4
ADDRGP4 $697
JUMPV
LABELV $694
line 1162
;1162:	{
line 1163
;1163:		if (i<1)
ADDRLP4 0
INDIRI4
CNSTI4 1
GEI4 $698
line 1164
;1164:		{
line 1165
;1165:			i = 13;
ADDRLP4 0
CNSTI4 13
ASGNI4
line 1166
;1166:		}
LABELV $698
line 1168
;1167:
;1168:		if ( !(bits & ( 1 << i )))	// Does he have this weapon?
ADDRLP4 12
INDIRI4
CNSTI4 1
ADDRLP4 0
INDIRI4
LSHI4
BANDI4
CNSTI4 0
NEI4 $700
line 1169
;1169:		{
line 1170
;1170:			continue;
ADDRGP4 $695
JUMPV
LABELV $700
line 1173
;1171:		}
;1172:
;1173:		if ( !CG_WeaponSelectable(i) &&
ADDRLP4 0
INDIRI4
ARGI4
ADDRLP4 64
ADDRGP4 CG_WeaponSelectable
CALLI4
ASGNI4
ADDRLP4 64
INDIRI4
CNSTI4 0
NEI4 $702
ADDRLP4 0
INDIRI4
CNSTI4 11
EQI4 $704
ADDRLP4 0
INDIRI4
CNSTI4 12
NEI4 $702
LABELV $704
line 1175
;1174:			(i == WP_THERMAL || i == WP_TRIP_MINE) )
;1175:		{ //Don't show thermal and tripmine when out of them
line 1176
;1176:			continue;
ADDRGP4 $695
JUMPV
LABELV $702
line 1179
;1177:		}
;1178:
;1179:		++iconCnt;					// Good icon
ADDRLP4 4
ADDRLP4 4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 1181
;1180:
;1181:		if (cgs.media.weaponIcons[i])
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 cgs+71064+928
ADDP4
INDIRI4
CNSTI4 0
EQI4 $705
line 1182
;1182:		{
line 1184
;1183:			weaponInfo_t	*weaponInfo;
;1184:			CG_RegisterWeapon( i );	
ADDRLP4 0
INDIRI4
ARGI4
ADDRGP4 CG_RegisterWeapon
CALLV
pop
line 1185
;1185:			weaponInfo = &cg_weapons[i];
ADDRLP4 72
CNSTI4 208
ADDRLP4 0
INDIRI4
MULI4
ADDRGP4 cg_weapons
ADDP4
ASGNP4
line 1187
;1186:
;1187:			trap_R_SetColor(colorTable[CT_WHITE]);
ADDRGP4 colorTable+128
ARGP4
ADDRGP4 trap_R_SetColor
CALLV
pop
line 1188
;1188:			if (!CG_WeaponCheck(i))
ADDRLP4 0
INDIRI4
ARGI4
ADDRLP4 76
ADDRGP4 CG_WeaponCheck
CALLI4
ASGNI4
ADDRLP4 76
INDIRI4
CNSTI4 0
NEI4 $710
line 1189
;1189:			{
line 1190
;1190:				CG_DrawPic( holdX, y+10, smallIconSize, smallIconSize, /*weaponInfo->weaponIconNoAmmo*/cgs.media.weaponIcons_NA[i] );
ADDRLP4 16
INDIRI4
CVIF4 4
ARGF4
ADDRLP4 24
INDIRI4
CNSTI4 10
ADDI4
CVIF4 4
ARGF4
ADDRLP4 80
ADDRLP4 8
INDIRI4
CVIF4 4
ASGNF4
ADDRLP4 80
INDIRF4
ARGF4
ADDRLP4 80
INDIRF4
ARGF4
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 cgs+71064+992
ADDP4
INDIRI4
ARGI4
ADDRGP4 CG_DrawPic
CALLV
pop
line 1191
;1191:			}
ADDRGP4 $711
JUMPV
LABELV $710
line 1193
;1192:			else
;1193:			{
line 1194
;1194:				CG_DrawPic( holdX, y+10, smallIconSize, smallIconSize, /*weaponInfo->weaponIcon*/cgs.media.weaponIcons[i] );
ADDRLP4 16
INDIRI4
CVIF4 4
ARGF4
ADDRLP4 24
INDIRI4
CNSTI4 10
ADDI4
CVIF4 4
ARGF4
ADDRLP4 80
ADDRLP4 8
INDIRI4
CVIF4 4
ASGNF4
ADDRLP4 80
INDIRF4
ARGF4
ADDRLP4 80
INDIRF4
ARGF4
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 cgs+71064+928
ADDP4
INDIRI4
ARGI4
ADDRGP4 CG_DrawPic
CALLV
pop
line 1195
;1195:			}
LABELV $711
line 1197
;1196:
;1197:			holdX -= (smallIconSize+pad);
ADDRLP4 16
ADDRLP4 16
INDIRI4
ADDRLP4 8
INDIRI4
ADDRLP4 20
INDIRI4
ADDI4
SUBI4
ASGNI4
line 1198
;1198:		}
LABELV $705
line 1199
;1199:	}
LABELV $695
line 1161
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
SUBI4
ASGNI4
LABELV $697
ADDRLP4 4
INDIRI4
ADDRLP4 28
INDIRI4
CNSTI4 1
ADDI4
LTI4 $694
line 1202
;1200:
;1201:	// Current Center Icon
;1202:	height = bigIconSize * cg.iconHUDPercent;
ADDRLP4 48
ADDRLP4 40
INDIRI4
CVIF4 4
ADDRGP4 cg+13780
INDIRF4
MULF4
CVFI4 4
ASGNI4
line 1203
;1203:	if (cgs.media.weaponIcons[cg.weaponSelect])
ADDRGP4 cg+3508
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 cgs+71064+928
ADDP4
INDIRI4
CNSTI4 0
EQI4 $717
line 1204
;1204:	{
line 1206
;1205:		weaponInfo_t	*weaponInfo;
;1206:		CG_RegisterWeapon( cg.weaponSelect );	
ADDRGP4 cg+3508
INDIRI4
ARGI4
ADDRGP4 CG_RegisterWeapon
CALLV
pop
line 1207
;1207:		weaponInfo = &cg_weapons[cg.weaponSelect];
ADDRLP4 64
CNSTI4 208
ADDRGP4 cg+3508
INDIRI4
MULI4
ADDRGP4 cg_weapons
ADDP4
ASGNP4
line 1209
;1208:
;1209:		trap_R_SetColor( colorTable[CT_WHITE]);
ADDRGP4 colorTable+128
ARGP4
ADDRGP4 trap_R_SetColor
CALLV
pop
line 1210
;1210:		if (!CG_WeaponCheck(cg.weaponSelect))
ADDRGP4 cg+3508
INDIRI4
ARGI4
ADDRLP4 68
ADDRGP4 CG_WeaponCheck
CALLI4
ASGNI4
ADDRLP4 68
INDIRI4
CNSTI4 0
NEI4 $725
line 1211
;1211:		{
line 1212
;1212:			CG_DrawPic( x-(bigIconSize/2), (y-((bigIconSize-smallIconSize)/2))+10, bigIconSize, bigIconSize, cgs.media.weaponIcons_NA[cg.weaponSelect] );
ADDRLP4 76
CNSTI4 2
ASGNI4
ADDRLP4 44
INDIRI4
ADDRLP4 40
INDIRI4
ADDRLP4 76
INDIRI4
DIVI4
SUBI4
CVIF4 4
ARGF4
ADDRLP4 24
INDIRI4
ADDRLP4 40
INDIRI4
ADDRLP4 8
INDIRI4
SUBI4
ADDRLP4 76
INDIRI4
DIVI4
SUBI4
CNSTI4 10
ADDI4
CVIF4 4
ARGF4
ADDRLP4 80
ADDRLP4 40
INDIRI4
CVIF4 4
ASGNF4
ADDRLP4 80
INDIRF4
ARGF4
ADDRLP4 80
INDIRF4
ARGF4
ADDRGP4 cg+3508
INDIRI4
ADDRLP4 76
INDIRI4
LSHI4
ADDRGP4 cgs+71064+992
ADDP4
INDIRI4
ARGI4
ADDRGP4 CG_DrawPic
CALLV
pop
line 1213
;1213:		}
ADDRGP4 $726
JUMPV
LABELV $725
line 1215
;1214:		else
;1215:		{
line 1216
;1216:			CG_DrawPic( x-(bigIconSize/2), (y-((bigIconSize-smallIconSize)/2))+10, bigIconSize, bigIconSize, cgs.media.weaponIcons[cg.weaponSelect] );
ADDRLP4 76
CNSTI4 2
ASGNI4
ADDRLP4 44
INDIRI4
ADDRLP4 40
INDIRI4
ADDRLP4 76
INDIRI4
DIVI4
SUBI4
CVIF4 4
ARGF4
ADDRLP4 24
INDIRI4
ADDRLP4 40
INDIRI4
ADDRLP4 8
INDIRI4
SUBI4
ADDRLP4 76
INDIRI4
DIVI4
SUBI4
CNSTI4 10
ADDI4
CVIF4 4
ARGF4
ADDRLP4 80
ADDRLP4 40
INDIRI4
CVIF4 4
ASGNF4
ADDRLP4 80
INDIRF4
ARGF4
ADDRLP4 80
INDIRF4
ARGF4
ADDRGP4 cg+3508
INDIRI4
ADDRLP4 76
INDIRI4
LSHI4
ADDRGP4 cgs+71064+928
ADDP4
INDIRI4
ARGI4
ADDRGP4 CG_DrawPic
CALLV
pop
line 1217
;1217:		}
LABELV $726
line 1218
;1218:	}
LABELV $717
line 1220
;1219:
;1220:	i = cg.weaponSelect + 1;
ADDRLP4 0
ADDRGP4 cg+3508
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 1221
;1221:	if (i> 13)
ADDRLP4 0
INDIRI4
CNSTI4 13
LEI4 $735
line 1222
;1222:	{
line 1223
;1223:		i = 1;
ADDRLP4 0
CNSTI4 1
ASGNI4
line 1224
;1224:	}
LABELV $735
line 1228
;1225:
;1226:	// Right side ICONS
;1227:	// Work forwards from current icon
;1228:	holdX = x + (bigIconSize/2) + pad;
ADDRLP4 16
ADDRLP4 44
INDIRI4
ADDRLP4 40
INDIRI4
CNSTI4 2
DIVI4
ADDI4
ADDRLP4 20
INDIRI4
ADDI4
ASGNI4
line 1229
;1229:	height = smallIconSize * cg.iconHUDPercent;
ADDRLP4 48
ADDRLP4 8
INDIRI4
CVIF4 4
ADDRGP4 cg+13780
INDIRF4
MULF4
CVFI4 4
ASGNI4
line 1230
;1230:	for (iconCnt=1;iconCnt<(sideRightIconCnt+1);i++)
ADDRLP4 4
CNSTI4 1
ASGNI4
ADDRGP4 $741
JUMPV
LABELV $738
line 1231
;1231:	{
line 1232
;1232:		if (i>13)
ADDRLP4 0
INDIRI4
CNSTI4 13
LEI4 $742
line 1233
;1233:		{
line 1234
;1234:			i = 1;
ADDRLP4 0
CNSTI4 1
ASGNI4
line 1235
;1235:		}
LABELV $742
line 1237
;1236:
;1237:		if ( !(bits & ( 1 << i )))	// Does he have this weapon?
ADDRLP4 12
INDIRI4
CNSTI4 1
ADDRLP4 0
INDIRI4
LSHI4
BANDI4
CNSTI4 0
NEI4 $744
line 1238
;1238:		{
line 1239
;1239:			continue;
ADDRGP4 $739
JUMPV
LABELV $744
line 1242
;1240:		}
;1241:
;1242:		if ( !CG_WeaponSelectable(i) &&
ADDRLP4 0
INDIRI4
ARGI4
ADDRLP4 64
ADDRGP4 CG_WeaponSelectable
CALLI4
ASGNI4
ADDRLP4 64
INDIRI4
CNSTI4 0
NEI4 $746
ADDRLP4 0
INDIRI4
CNSTI4 11
EQI4 $748
ADDRLP4 0
INDIRI4
CNSTI4 12
NEI4 $746
LABELV $748
line 1244
;1243:			(i == WP_THERMAL || i == WP_TRIP_MINE) )
;1244:		{ //Don't show thermal and tripmine when out of them
line 1245
;1245:			continue;
ADDRGP4 $739
JUMPV
LABELV $746
line 1248
;1246:		}
;1247:
;1248:		++iconCnt;					// Good icon
ADDRLP4 4
ADDRLP4 4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 1250
;1249:
;1250:		if (/*weaponData[i].weaponIcon[0]*/cgs.media.weaponIcons[i])
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 cgs+71064+928
ADDP4
INDIRI4
CNSTI4 0
EQI4 $749
line 1251
;1251:		{
line 1253
;1252:			weaponInfo_t	*weaponInfo;
;1253:			CG_RegisterWeapon( i );	
ADDRLP4 0
INDIRI4
ARGI4
ADDRGP4 CG_RegisterWeapon
CALLV
pop
line 1254
;1254:			weaponInfo = &cg_weapons[i];
ADDRLP4 72
CNSTI4 208
ADDRLP4 0
INDIRI4
MULI4
ADDRGP4 cg_weapons
ADDP4
ASGNP4
line 1256
;1255:			// No ammo for this weapon?
;1256:			trap_R_SetColor( colorTable[CT_WHITE]);
ADDRGP4 colorTable+128
ARGP4
ADDRGP4 trap_R_SetColor
CALLV
pop
line 1257
;1257:			if (!CG_WeaponCheck(i))
ADDRLP4 0
INDIRI4
ARGI4
ADDRLP4 76
ADDRGP4 CG_WeaponCheck
CALLI4
ASGNI4
ADDRLP4 76
INDIRI4
CNSTI4 0
NEI4 $754
line 1258
;1258:			{
line 1259
;1259:				CG_DrawPic( holdX, y+10, smallIconSize, smallIconSize, cgs.media.weaponIcons_NA[i] );
ADDRLP4 16
INDIRI4
CVIF4 4
ARGF4
ADDRLP4 24
INDIRI4
CNSTI4 10
ADDI4
CVIF4 4
ARGF4
ADDRLP4 80
ADDRLP4 8
INDIRI4
CVIF4 4
ASGNF4
ADDRLP4 80
INDIRF4
ARGF4
ADDRLP4 80
INDIRF4
ARGF4
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 cgs+71064+992
ADDP4
INDIRI4
ARGI4
ADDRGP4 CG_DrawPic
CALLV
pop
line 1260
;1260:			}
ADDRGP4 $755
JUMPV
LABELV $754
line 1262
;1261:			else
;1262:			{
line 1263
;1263:				CG_DrawPic( holdX, y+10, smallIconSize, smallIconSize, cgs.media.weaponIcons[i] );
ADDRLP4 16
INDIRI4
CVIF4 4
ARGF4
ADDRLP4 24
INDIRI4
CNSTI4 10
ADDI4
CVIF4 4
ARGF4
ADDRLP4 80
ADDRLP4 8
INDIRI4
CVIF4 4
ASGNF4
ADDRLP4 80
INDIRF4
ARGF4
ADDRLP4 80
INDIRF4
ARGF4
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 cgs+71064+928
ADDP4
INDIRI4
ARGI4
ADDRGP4 CG_DrawPic
CALLV
pop
line 1264
;1264:			}
LABELV $755
line 1267
;1265:
;1266:
;1267:			holdX += (smallIconSize+pad);
ADDRLP4 16
ADDRLP4 16
INDIRI4
ADDRLP4 8
INDIRI4
ADDRLP4 20
INDIRI4
ADDI4
ADDI4
ASGNI4
line 1268
;1268:		}
LABELV $749
line 1269
;1269:	}
LABELV $739
line 1230
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $741
ADDRLP4 4
INDIRI4
ADDRLP4 32
INDIRI4
CNSTI4 1
ADDI4
LTI4 $738
line 1272
;1270:
;1271:	// draw the selected name
;1272:	if ( cg_weapons[ cg.weaponSelect ].item ) 
CNSTI4 208
ADDRGP4 cg+3508
INDIRI4
MULI4
ADDRGP4 cg_weapons+4
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $760
line 1273
;1273:	{
line 1274
;1274:		vec4_t			textColor = { .875f, .718f, .121f, 1.0f };
ADDRLP4 64
ADDRGP4 $764
INDIRB
ASGNB 16
line 1277
;1275:		char	text[1024];
;1276:		
;1277:		if ( trap_SP_GetStringTextString( va("INGAME_%s",cg_weapons[ cg.weaponSelect ].item->classname), text, sizeof( text )))
ADDRGP4 $767
ARGP4
CNSTI4 208
ADDRGP4 cg+3508
INDIRI4
MULI4
ADDRGP4 cg_weapons+4
ADDP4
INDIRP4
INDIRP4
ARGP4
ADDRLP4 1104
ADDRGP4 va
CALLP4
ASGNP4
ADDRLP4 1104
INDIRP4
ARGP4
ADDRLP4 80
ARGP4
CNSTI4 1024
ARGI4
ADDRLP4 1108
ADDRGP4 trap_SP_GetStringTextString
CALLI4
ASGNI4
ADDRLP4 1108
INDIRI4
CNSTI4 0
EQI4 $765
line 1278
;1278:		{
line 1279
;1279:			UI_DrawProportionalString(320, y+45, text, UI_CENTER|UI_SMALLFONT, textColor);
CNSTI4 320
ARGI4
ADDRLP4 24
INDIRI4
CNSTI4 45
ADDI4
ARGI4
ADDRLP4 80
ARGP4
CNSTI4 17
ARGI4
ADDRLP4 64
ARGP4
ADDRGP4 UI_DrawProportionalString
CALLV
pop
line 1280
;1280:		}
ADDRGP4 $766
JUMPV
LABELV $765
line 1282
;1281:		else
;1282:		{
line 1283
;1283:			UI_DrawProportionalString(320, y+45, cg_weapons[ cg.weaponSelect ].item->classname, UI_CENTER|UI_SMALLFONT, textColor);
CNSTI4 320
ARGI4
ADDRLP4 24
INDIRI4
CNSTI4 45
ADDI4
ARGI4
CNSTI4 208
ADDRGP4 cg+3508
INDIRI4
MULI4
ADDRGP4 cg_weapons+4
ADDP4
INDIRP4
INDIRP4
ARGP4
CNSTI4 17
ARGI4
ADDRLP4 64
ARGP4
ADDRGP4 UI_DrawProportionalString
CALLV
pop
line 1284
;1284:		}
LABELV $766
line 1285
;1285:	}
LABELV $760
line 1287
;1286:
;1287:	trap_R_SetColor( NULL );
CNSTP4 0
ARGP4
ADDRGP4 trap_R_SetColor
CALLV
pop
line 1288
;1288:}
LABELV $651
endproc CG_DrawWeaponSelect 1112 20
export CG_NextWeapon_f
proc CG_NextWeapon_f 16 8
line 1296
;1289:
;1290:
;1291:/*
;1292:===============
;1293:CG_NextWeapon_f
;1294:===============
;1295:*/
;1296:void CG_NextWeapon_f( void ) {
line 1300
;1297:	int		i;
;1298:	int		original;
;1299:
;1300:	if ( !cg.snap ) {
ADDRGP4 cg+36
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $773
line 1301
;1301:		return;
ADDRGP4 $772
JUMPV
LABELV $773
line 1303
;1302:	}
;1303:	if ( cg.snap->ps.pm_flags & PMF_FOLLOW ) {
ADDRGP4 cg+36
INDIRP4
CNSTI4 56
ADDP4
INDIRI4
CNSTI4 4096
BANDI4
CNSTI4 0
EQI4 $776
line 1304
;1304:		return;
ADDRGP4 $772
JUMPV
LABELV $776
line 1307
;1305:	}
;1306:
;1307:	if (cg.snap->ps.emplacedIndex)
ADDRGP4 cg+36
INDIRP4
CNSTI4 640
ADDP4
INDIRI4
CNSTI4 0
EQI4 $779
line 1308
;1308:	{
line 1309
;1309:		return;
ADDRGP4 $772
JUMPV
LABELV $779
line 1312
;1310:	}
;1311:
;1312:	cg.weaponSelectTime = cg.time;
ADDRGP4 cg+13372
ADDRGP4 cg+64
INDIRI4
ASGNI4
line 1313
;1313:	original = cg.weaponSelect;
ADDRLP4 4
ADDRGP4 cg+3508
INDIRI4
ASGNI4
line 1315
;1314:
;1315:	for ( i = 0 ; i < 16 ; i++ ) {
ADDRLP4 0
CNSTI4 0
ASGNI4
LABELV $785
line 1316
;1316:		cg.weaponSelect++;
ADDRLP4 8
ADDRGP4 cg+3508
ASGNP4
ADDRLP4 8
INDIRP4
ADDRLP4 8
INDIRP4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 1317
;1317:		if ( cg.weaponSelect == 16 ) {
ADDRGP4 cg+3508
INDIRI4
CNSTI4 16
NEI4 $790
line 1318
;1318:			cg.weaponSelect = 0;
ADDRGP4 cg+3508
CNSTI4 0
ASGNI4
line 1319
;1319:		}
LABELV $790
line 1323
;1320:	//	if ( cg.weaponSelect == WP_STUN_BATON ) {
;1321:	//		continue;		// never cycle to gauntlet
;1322:	//	}
;1323:		if ( CG_WeaponSelectable( cg.weaponSelect ) ) {
ADDRGP4 cg+3508
INDIRI4
ARGI4
ADDRLP4 12
ADDRGP4 CG_WeaponSelectable
CALLI4
ASGNI4
ADDRLP4 12
INDIRI4
CNSTI4 0
EQI4 $794
line 1324
;1324:			break;
ADDRGP4 $787
JUMPV
LABELV $794
line 1326
;1325:		}
;1326:	}
LABELV $786
line 1315
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 16
LTI4 $785
LABELV $787
line 1327
;1327:	if ( i == 16 ) {
ADDRLP4 0
INDIRI4
CNSTI4 16
NEI4 $797
line 1328
;1328:		cg.weaponSelect = original;
ADDRGP4 cg+3508
ADDRLP4 4
INDIRI4
ASGNI4
line 1329
;1329:	}
ADDRGP4 $798
JUMPV
LABELV $797
line 1331
;1330:	else
;1331:	{
line 1332
;1332:		trap_S_MuteSound(cg.snap->ps.clientNum, CHAN_WEAPON);
ADDRGP4 cg+36
INDIRP4
CNSTI4 188
ADDP4
INDIRI4
ARGI4
CNSTI4 2
ARGI4
ADDRGP4 trap_S_MuteSound
CALLV
pop
line 1333
;1333:	}
LABELV $798
line 1334
;1334:}
LABELV $772
endproc CG_NextWeapon_f 16 8
export CG_PrevWeapon_f
proc CG_PrevWeapon_f 16 8
line 1341
;1335:
;1336:/*
;1337:===============
;1338:CG_PrevWeapon_f
;1339:===============
;1340:*/
;1341:void CG_PrevWeapon_f( void ) {
line 1345
;1342:	int		i;
;1343:	int		original;
;1344:
;1345:	if ( !cg.snap ) {
ADDRGP4 cg+36
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $802
line 1346
;1346:		return;
ADDRGP4 $801
JUMPV
LABELV $802
line 1348
;1347:	}
;1348:	if ( cg.snap->ps.pm_flags & PMF_FOLLOW ) {
ADDRGP4 cg+36
INDIRP4
CNSTI4 56
ADDP4
INDIRI4
CNSTI4 4096
BANDI4
CNSTI4 0
EQI4 $805
line 1349
;1349:		return;
ADDRGP4 $801
JUMPV
LABELV $805
line 1352
;1350:	}
;1351:
;1352:	if (cg.snap->ps.emplacedIndex)
ADDRGP4 cg+36
INDIRP4
CNSTI4 640
ADDP4
INDIRI4
CNSTI4 0
EQI4 $808
line 1353
;1353:	{
line 1354
;1354:		return;
ADDRGP4 $801
JUMPV
LABELV $808
line 1357
;1355:	}
;1356:
;1357:	cg.weaponSelectTime = cg.time;
ADDRGP4 cg+13372
ADDRGP4 cg+64
INDIRI4
ASGNI4
line 1358
;1358:	original = cg.weaponSelect;
ADDRLP4 4
ADDRGP4 cg+3508
INDIRI4
ASGNI4
line 1360
;1359:
;1360:	for ( i = 0 ; i < 16 ; i++ ) {
ADDRLP4 0
CNSTI4 0
ASGNI4
LABELV $814
line 1361
;1361:		cg.weaponSelect--;
ADDRLP4 8
ADDRGP4 cg+3508
ASGNP4
ADDRLP4 8
INDIRP4
ADDRLP4 8
INDIRP4
INDIRI4
CNSTI4 1
SUBI4
ASGNI4
line 1362
;1362:		if ( cg.weaponSelect == -1 ) {
ADDRGP4 cg+3508
INDIRI4
CNSTI4 -1
NEI4 $819
line 1363
;1363:			cg.weaponSelect = 15;
ADDRGP4 cg+3508
CNSTI4 15
ASGNI4
line 1364
;1364:		}
LABELV $819
line 1368
;1365:	//	if ( cg.weaponSelect == WP_STUN_BATON ) {
;1366:	//		continue;		// never cycle to gauntlet
;1367:	//	}
;1368:		if ( CG_WeaponSelectable( cg.weaponSelect ) ) {
ADDRGP4 cg+3508
INDIRI4
ARGI4
ADDRLP4 12
ADDRGP4 CG_WeaponSelectable
CALLI4
ASGNI4
ADDRLP4 12
INDIRI4
CNSTI4 0
EQI4 $823
line 1369
;1369:			break;
ADDRGP4 $816
JUMPV
LABELV $823
line 1371
;1370:		}
;1371:	}
LABELV $815
line 1360
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 16
LTI4 $814
LABELV $816
line 1372
;1372:	if ( i == 16 ) {
ADDRLP4 0
INDIRI4
CNSTI4 16
NEI4 $826
line 1373
;1373:		cg.weaponSelect = original;
ADDRGP4 cg+3508
ADDRLP4 4
INDIRI4
ASGNI4
line 1374
;1374:	}
ADDRGP4 $827
JUMPV
LABELV $826
line 1376
;1375:	else
;1376:	{
line 1377
;1377:		trap_S_MuteSound(cg.snap->ps.clientNum, CHAN_WEAPON);
ADDRGP4 cg+36
INDIRP4
CNSTI4 188
ADDP4
INDIRI4
ARGI4
CNSTI4 2
ARGI4
ADDRGP4 trap_S_MuteSound
CALLV
pop
line 1378
;1378:	}
LABELV $827
line 1379
;1379:}
LABELV $801
endproc CG_PrevWeapon_f 16 8
export CG_Weapon_f
proc CG_Weapon_f 32 8
line 1386
;1380:
;1381:/*
;1382:===============
;1383:CG_Weapon_f
;1384:===============
;1385:*/
;1386:void CG_Weapon_f( void ) {
line 1389
;1387:	int		num;
;1388:
;1389:	if ( !cg.snap ) {
ADDRGP4 cg+36
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $831
line 1390
;1390:		return;
ADDRGP4 $830
JUMPV
LABELV $831
line 1392
;1391:	}
;1392:	if ( cg.snap->ps.pm_flags & PMF_FOLLOW ) {
ADDRGP4 cg+36
INDIRP4
CNSTI4 56
ADDP4
INDIRI4
CNSTI4 4096
BANDI4
CNSTI4 0
EQI4 $834
line 1393
;1393:		return;
ADDRGP4 $830
JUMPV
LABELV $834
line 1396
;1394:	}
;1395:
;1396:	if (cg.snap->ps.emplacedIndex)
ADDRGP4 cg+36
INDIRP4
CNSTI4 640
ADDP4
INDIRI4
CNSTI4 0
EQI4 $837
line 1397
;1397:	{
line 1398
;1398:		return;
ADDRGP4 $830
JUMPV
LABELV $837
line 1401
;1399:	}
;1400:
;1401:	num = atoi( CG_Argv( 1 ) );
CNSTI4 1
ARGI4
ADDRLP4 4
ADDRGP4 CG_Argv
CALLP4
ASGNP4
ADDRLP4 4
INDIRP4
ARGP4
ADDRLP4 8
ADDRGP4 atoi
CALLI4
ASGNI4
ADDRLP4 0
ADDRLP4 8
INDIRI4
ASGNI4
line 1403
;1402:
;1403:	if ( num < 1 || num > 15 ) {
ADDRLP4 0
INDIRI4
CNSTI4 1
LTI4 $842
ADDRLP4 0
INDIRI4
CNSTI4 15
LEI4 $840
LABELV $842
line 1404
;1404:		return;
ADDRGP4 $830
JUMPV
LABELV $840
line 1407
;1405:	}
;1406:
;1407:	if (num == 1 && cg.snap->ps.weapon == WP_SABER)
ADDRLP4 0
INDIRI4
CNSTI4 1
NEI4 $843
ADDRGP4 cg+36
INDIRP4
CNSTI4 192
ADDP4
INDIRI4
CNSTI4 2
NEI4 $843
line 1408
;1408:	{
line 1409
;1409:		if (cg.snap->ps.weaponTime < 1)
ADDRGP4 cg+36
INDIRP4
CNSTI4 88
ADDP4
INDIRI4
CNSTI4 1
GEI4 $830
line 1410
;1410:		{
line 1412
;1411:			//trap_SendClientCommand("sv_saberswitch");
;1412:			trap_SendConsoleCommand("sv_saberswitch");
ADDRGP4 $849
ARGP4
ADDRGP4 trap_SendConsoleCommand
CALLV
pop
line 1413
;1413:		}
line 1414
;1414:		return;
ADDRGP4 $830
JUMPV
LABELV $843
line 1418
;1415:	}
;1416:
;1417:	//rww - hack to make weapon numbers same as single player
;1418:	if (num > WP_STUN_BATON)
ADDRLP4 0
INDIRI4
CNSTI4 1
LEI4 $850
line 1419
;1419:	{
line 1420
;1420:		num++;
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 1421
;1421:	}
ADDRGP4 $851
JUMPV
LABELV $850
line 1423
;1422:	else
;1423:	{
line 1424
;1424:		if (cg.snap->ps.stats[STAT_WEAPONS] & (1 << WP_SABER))
ADDRGP4 cg+36
INDIRP4
CNSTI4 276
ADDP4
INDIRI4
CNSTI4 4
BANDI4
CNSTI4 0
EQI4 $852
line 1425
;1425:		{
line 1426
;1426:			num = WP_SABER;
ADDRLP4 0
CNSTI4 2
ASGNI4
line 1427
;1427:		}
ADDRGP4 $853
JUMPV
LABELV $852
line 1429
;1428:		else
;1429:		{
line 1430
;1430:			num = WP_STUN_BATON;
ADDRLP4 0
CNSTI4 1
ASGNI4
line 1431
;1431:		}
LABELV $853
line 1432
;1432:	}
LABELV $851
line 1434
;1433:
;1434:	if (num > WP_DET_PACK+1)
ADDRLP4 0
INDIRI4
CNSTI4 14
LEI4 $855
line 1435
;1435:	{ //other weapons are off limits due to not actually being weapon weapons
line 1436
;1436:		return;
ADDRGP4 $830
JUMPV
LABELV $855
line 1439
;1437:	}
;1438:
;1439:	if (num >= WP_THERMAL)
ADDRLP4 0
INDIRI4
CNSTI4 11
LTI4 $857
line 1440
;1440:	{
line 1441
;1441:		int weap, i = 0;
ADDRLP4 20
CNSTI4 0
ASGNI4
line 1443
;1442:
;1443:		if (cg.snap->ps.weapon >= WP_THERMAL &&
ADDRLP4 24
CNSTI4 192
ASGNI4
ADDRGP4 cg+36
INDIRP4
ADDRLP4 24
INDIRI4
ADDP4
INDIRI4
CNSTI4 11
LTI4 $859
ADDRGP4 cg+36
INDIRP4
ADDRLP4 24
INDIRI4
ADDP4
INDIRI4
CNSTI4 13
GTI4 $859
line 1445
;1444:			cg.snap->ps.weapon <= WP_DET_PACK)
;1445:		{
line 1447
;1446:			// already in cycle range so start with next cycle item
;1447:			weap = cg.snap->ps.weapon + 1;
ADDRLP4 16
ADDRGP4 cg+36
INDIRP4
CNSTI4 192
ADDP4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 1448
;1448:		}
ADDRGP4 $865
JUMPV
LABELV $859
line 1450
;1449:		else
;1450:		{
line 1452
;1451:			// not in cycle range, so start with thermal detonator
;1452:			weap = WP_THERMAL;
ADDRLP4 16
CNSTI4 11
ASGNI4
line 1453
;1453:		}
ADDRGP4 $865
JUMPV
LABELV $864
line 1457
;1454:
;1455:		// prevent an endless loop
;1456:		while ( i <= 4 )
;1457:		{
line 1458
;1458:			if (weap > WP_DET_PACK)
ADDRLP4 16
INDIRI4
CNSTI4 13
LEI4 $867
line 1459
;1459:			{
line 1460
;1460:				weap = WP_THERMAL;
ADDRLP4 16
CNSTI4 11
ASGNI4
line 1461
;1461:			}
LABELV $867
line 1463
;1462:
;1463:			if (CG_WeaponSelectable(weap))
ADDRLP4 16
INDIRI4
ARGI4
ADDRLP4 28
ADDRGP4 CG_WeaponSelectable
CALLI4
ASGNI4
ADDRLP4 28
INDIRI4
CNSTI4 0
EQI4 $869
line 1464
;1464:			{
line 1465
;1465:				num = weap;
ADDRLP4 0
ADDRLP4 16
INDIRI4
ASGNI4
line 1466
;1466:				break;
ADDRGP4 $866
JUMPV
LABELV $869
line 1469
;1467:			}
;1468:
;1469:			weap++;
ADDRLP4 16
ADDRLP4 16
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 1470
;1470:			i++;
ADDRLP4 20
ADDRLP4 20
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 1471
;1471:		}
LABELV $865
line 1456
ADDRLP4 20
INDIRI4
CNSTI4 4
LEI4 $864
LABELV $866
line 1472
;1472:	}
LABELV $857
line 1474
;1473:
;1474:	if (!CG_WeaponSelectable(num))
ADDRLP4 0
INDIRI4
ARGI4
ADDRLP4 16
ADDRGP4 CG_WeaponSelectable
CALLI4
ASGNI4
ADDRLP4 16
INDIRI4
CNSTI4 0
NEI4 $871
line 1475
;1475:	{
line 1476
;1476:		return;
ADDRGP4 $830
JUMPV
LABELV $871
line 1479
;1477:	}
;1478:
;1479:	cg.weaponSelectTime = cg.time;
ADDRGP4 cg+13372
ADDRGP4 cg+64
INDIRI4
ASGNI4
line 1481
;1480:
;1481:	if ( ! ( cg.snap->ps.stats[STAT_WEAPONS] & ( 1 << num ) ) )
ADDRGP4 cg+36
INDIRP4
CNSTI4 276
ADDP4
INDIRI4
CNSTI4 1
ADDRLP4 0
INDIRI4
LSHI4
BANDI4
CNSTI4 0
NEI4 $875
line 1482
;1482:	{
line 1483
;1483:		if (num == WP_SABER)
ADDRLP4 0
INDIRI4
CNSTI4 2
NEI4 $830
line 1484
;1484:		{ //don't have saber, try the stun baton on the same slot
line 1485
;1485:			num = WP_STUN_BATON;
ADDRLP4 0
CNSTI4 1
ASGNI4
line 1487
;1486:
;1487:			if ( ! ( cg.snap->ps.stats[STAT_WEAPONS] & ( 1 << num ) ) )
ADDRGP4 cg+36
INDIRP4
CNSTI4 276
ADDP4
INDIRI4
CNSTI4 1
ADDRLP4 0
INDIRI4
LSHI4
BANDI4
CNSTI4 0
NEI4 $879
line 1488
;1488:			{
line 1489
;1489:				return;
ADDRGP4 $830
JUMPV
line 1491
;1490:			}
;1491:		}
line 1493
;1492:		else
;1493:		{
line 1494
;1494:			return;		// don't have the weapon
LABELV $879
line 1496
;1495:		}
;1496:	}
LABELV $875
line 1498
;1497:
;1498:	if (cg.weaponSelect != num)
ADDRGP4 cg+3508
INDIRI4
ADDRLP4 0
INDIRI4
EQI4 $883
line 1499
;1499:	{
line 1500
;1500:		trap_S_MuteSound(cg.snap->ps.clientNum, CHAN_WEAPON);
ADDRGP4 cg+36
INDIRP4
CNSTI4 188
ADDP4
INDIRI4
ARGI4
CNSTI4 2
ARGI4
ADDRGP4 trap_S_MuteSound
CALLV
pop
line 1501
;1501:	}
LABELV $883
line 1503
;1502:
;1503:	cg.weaponSelect = num;
ADDRGP4 cg+3508
ADDRLP4 0
INDIRI4
ASGNI4
line 1504
;1504:}
LABELV $830
endproc CG_Weapon_f 32 8
export CG_OutOfAmmoChange
proc CG_OutOfAmmoChange 12 8
line 1514
;1505:
;1506:/*
;1507:===================
;1508:CG_OutOfAmmoChange
;1509:
;1510:The current weapon has just run out of ammo
;1511:===================
;1512:*/
;1513:void CG_OutOfAmmoChange( int oldWeapon )
;1514:{
line 1517
;1515:	int		i;
;1516:
;1517:	cg.weaponSelectTime = cg.time;
ADDRGP4 cg+13372
ADDRGP4 cg+64
INDIRI4
ASGNI4
line 1519
;1518:
;1519:	for ( i = WP_DET_PACK ; i > 0 ; i-- )	//We don't want the emplaced or turret
ADDRLP4 0
CNSTI4 13
ASGNI4
LABELV $891
line 1520
;1520:	{
line 1521
;1521:		if ( CG_WeaponSelectable( i ) )
ADDRLP4 0
INDIRI4
ARGI4
ADDRLP4 4
ADDRGP4 CG_WeaponSelectable
CALLI4
ASGNI4
ADDRLP4 4
INDIRI4
CNSTI4 0
EQI4 $895
line 1522
;1522:		{
line 1528
;1523:			/*
;1524:			if ( 1 == cg_autoswitch.integer && 
;1525:				( i == WP_TRIP_MINE || i == WP_DET_PACK || i == WP_THERMAL || i == WP_ROCKET_LAUNCHER) ) // safe weapon switch
;1526:			*/
;1527:			//rww - Don't we want to make sure i != one of these if autoswitch is 1 (safe)?
;1528:			if (cg_autoswitch.integer != 1 || (i != WP_TRIP_MINE && i != WP_DET_PACK && i != WP_THERMAL && i != WP_ROCKET_LAUNCHER))
ADDRGP4 cg_autoswitch+12
INDIRI4
CNSTI4 1
NEI4 $900
ADDRLP4 0
INDIRI4
CNSTI4 12
EQI4 $897
ADDRLP4 0
INDIRI4
CNSTI4 13
EQI4 $897
ADDRLP4 0
INDIRI4
CNSTI4 11
EQI4 $897
ADDRLP4 0
INDIRI4
CNSTI4 10
EQI4 $897
LABELV $900
line 1529
;1529:			{
line 1530
;1530:				if (i != oldWeapon)
ADDRLP4 0
INDIRI4
ADDRFP4 0
INDIRI4
EQI4 $901
line 1531
;1531:				{ //don't even do anything if we're just selecting the weapon we already have/had
line 1532
;1532:					cg.weaponSelect = i;
ADDRGP4 cg+3508
ADDRLP4 0
INDIRI4
ASGNI4
line 1533
;1533:					break;
ADDRGP4 $893
JUMPV
LABELV $901
line 1535
;1534:				}
;1535:			}
LABELV $897
line 1536
;1536:		}
LABELV $895
line 1537
;1537:	}
LABELV $892
line 1519
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
SUBI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 0
GTI4 $891
LABELV $893
line 1539
;1538:
;1539:	trap_S_MuteSound(cg.snap->ps.clientNum, CHAN_WEAPON);
ADDRGP4 cg+36
INDIRP4
CNSTI4 188
ADDP4
INDIRI4
ARGI4
CNSTI4 2
ARGI4
ADDRGP4 trap_S_MuteSound
CALLV
pop
line 1540
;1540:}
LABELV $888
endproc CG_OutOfAmmoChange 12 8
export CG_FireATST
proc CG_FireATST 8 16
line 1553
;1541:
;1542:
;1543:
;1544:/*
;1545:===================================================================================================
;1546:
;1547:WEAPON EVENTS
;1548:
;1549:===================================================================================================
;1550:*/
;1551:
;1552:void CG_FireATST(centity_t *cent, qboolean altFire)
;1553:{
line 1585
;1554://No muzzle flash for now?
;1555:#if 0
;1556:	int getMeBolt = 0;
;1557:	mdxaBone_t boltMatrix;
;1558:	vec3_t flashorigin, flashdir;
;1559:
;1560:	if (!cgs.clientinfo[cent->currentState.number].bolt_lhand)
;1561:	{
;1562:		return;
;1563:	}
;1564:
;1565:	if (altFire)
;1566:	{
;1567:		getMeBolt = cgs.clientinfo[cent->currentState.number].bolt_lhand;
;1568:	}
;1569:	else
;1570:	{
;1571:		getMeBolt = cgs.clientinfo[cent->currentState.number].bolt_rhand;
;1572:	}
;1573:
;1574: 	if (!(trap_G2API_GetBoltMatrix(cent->ghoul2, 0, getMeBolt, &boltMatrix, cent->lerpAngles, cent->lerpOrigin, cg.time, cgs.gameModels, cent->modelScale)))
;1575:	{
;1576:		return;
;1577:	}
;1578:			
;1579:	trap_G2API_GiveMeVectorFromMatrix(&boltMatrix, ORIGIN, flashorigin);
;1580:	trap_G2API_GiveMeVectorFromMatrix(&boltMatrix, POSITIVE_X, flashdir);
;1581:
;1582:	trap_FX_PlayEffectID(trap_FX_RegisterEffect("turret/muzzle_flash.efx"), flashorigin, flashdir);
;1583:#endif
;1584:
;1585:	trap_S_StartSound(NULL, cent->currentState.number, CHAN_WEAPON, trap_S_RegisterSound(va("sound/weapons/atst/ATSTfire1.wav"/*, Q_irand(1,4)*/)));
ADDRGP4 $906
ARGP4
ADDRLP4 0
ADDRGP4 va
CALLP4
ASGNP4
ADDRLP4 0
INDIRP4
ARGP4
ADDRLP4 4
ADDRGP4 trap_S_RegisterSound
CALLI4
ASGNI4
CNSTP4 0
ARGP4
ADDRFP4 0
INDIRP4
INDIRI4
ARGI4
CNSTI4 2
ARGI4
ADDRLP4 4
INDIRI4
ARGI4
ADDRGP4 trap_S_StartSound
CALLV
pop
line 1586
;1586:}
LABELV $905
endproc CG_FireATST 8 16
export CG_GetClientWeaponMuzzleBoltPoint
proc CG_GetClientWeaponMuzzleBoltPoint 80 36
line 1589
;1587:
;1588:void CG_GetClientWeaponMuzzleBoltPoint(int clIndex, vec3_t to)
;1589:{
line 1593
;1590:	centity_t *cent;
;1591:	mdxaBone_t	boltMatrix;
;1592:
;1593:	if (clIndex < 0 || clIndex >= MAX_CLIENTS)
ADDRLP4 52
ADDRFP4 0
INDIRI4
ASGNI4
ADDRLP4 52
INDIRI4
CNSTI4 0
LTI4 $910
ADDRLP4 52
INDIRI4
CNSTI4 32
LTI4 $908
LABELV $910
line 1594
;1594:	{
line 1595
;1595:		return;
ADDRGP4 $907
JUMPV
LABELV $908
line 1598
;1596:	}
;1597:
;1598:	cent = &cg_entities[clIndex];
ADDRLP4 0
CNSTI4 1920
ADDRFP4 0
INDIRI4
MULI4
ADDRGP4 cg_entities
ADDP4
ASGNP4
line 1600
;1599:
;1600:	if (!cent || !cent->ghoul2 || !trap_G2_HaveWeGhoul2Models(cent->ghoul2) ||
ADDRLP4 60
CNSTU4 0
ASGNU4
ADDRLP4 0
INDIRP4
CVPU4 4
ADDRLP4 60
INDIRU4
EQU4 $915
ADDRLP4 64
ADDRLP4 0
INDIRP4
CNSTI4 952
ADDP4
INDIRP4
ASGNP4
ADDRLP4 64
INDIRP4
CVPU4 4
ADDRLP4 60
INDIRU4
EQU4 $915
ADDRLP4 64
INDIRP4
ARGP4
ADDRLP4 68
ADDRGP4 trap_G2_HaveWeGhoul2Models
CALLI4
ASGNI4
ADDRLP4 68
INDIRI4
CNSTI4 0
EQI4 $915
ADDRLP4 0
INDIRP4
CNSTI4 952
ADDP4
ARGP4
CNSTI4 1
ARGI4
ADDRLP4 72
ADDRGP4 trap_G2API_HasGhoul2ModelOnIndex
CALLI4
ASGNI4
ADDRLP4 72
INDIRI4
CNSTI4 0
NEI4 $911
LABELV $915
line 1602
;1601:		!trap_G2API_HasGhoul2ModelOnIndex(&(cent->ghoul2), 1))
;1602:	{
line 1603
;1603:		return;
ADDRGP4 $907
JUMPV
LABELV $911
line 1606
;1604:	}
;1605:
;1606:	trap_G2API_GetBoltMatrix(cent->ghoul2, 1, 0, &boltMatrix, cent->turAngles, cent->lerpOrigin, cg.time, cgs.gameModels, cent->modelScale);
ADDRLP4 0
INDIRP4
CNSTI4 952
ADDP4
INDIRP4
ARGP4
CNSTI4 1
ARGI4
CNSTI4 0
ARGI4
ADDRLP4 4
ARGP4
ADDRLP4 0
INDIRP4
CNSTI4 1016
ADDP4
ARGP4
ADDRLP4 0
INDIRP4
CNSTI4 928
ADDP4
ARGP4
ADDRGP4 cg+64
INDIRI4
ARGI4
ADDRGP4 cgs+36364
ARGP4
ADDRLP4 0
INDIRP4
CNSTI4 964
ADDP4
ARGP4
ADDRGP4 trap_G2API_GetBoltMatrix
CALLI4
pop
line 1607
;1607:	trap_G2API_GiveMeVectorFromMatrix(&boltMatrix, ORIGIN, to);
ADDRLP4 4
ARGP4
CNSTI4 0
ARGI4
ADDRFP4 4
INDIRP4
ARGP4
ADDRGP4 trap_G2API_GiveMeVectorFromMatrix
CALLV
pop
line 1608
;1608:}
LABELV $907
endproc CG_GetClientWeaponMuzzleBoltPoint 80 36
export CG_FireWeapon
proc CG_FireWeapon 20 16
line 1617
;1609:
;1610:/*
;1611:================
;1612:CG_FireWeapon
;1613:
;1614:Caused by an EV_FIRE_WEAPON event
;1615:================
;1616:*/
;1617:void CG_FireWeapon( centity_t *cent, qboolean altFire ) {
line 1622
;1618:	entityState_t *ent;
;1619:	int				c;
;1620:	weaponInfo_t	*weap;
;1621:
;1622:	if (cent->isATST)
ADDRFP4 0
INDIRP4
CNSTI4 1028
ADDP4
INDIRI4
CNSTI4 0
EQI4 $919
line 1623
;1623:	{
line 1624
;1624:		CG_FireATST(cent, altFire);
ADDRFP4 0
INDIRP4
ARGP4
ADDRFP4 4
INDIRI4
ARGI4
ADDRGP4 CG_FireATST
CALLV
pop
line 1625
;1625:		return;
ADDRGP4 $918
JUMPV
LABELV $919
line 1628
;1626:	}
;1627:
;1628:	ent = &cent->currentState;
ADDRLP4 8
ADDRFP4 0
INDIRP4
ASGNP4
line 1629
;1629:	if ( ent->weapon == WP_NONE ) {
ADDRLP4 8
INDIRP4
CNSTI4 276
ADDP4
INDIRI4
CNSTI4 0
NEI4 $921
line 1630
;1630:		return;
ADDRGP4 $918
JUMPV
LABELV $921
line 1632
;1631:	}
;1632:	if ( ent->weapon >= WP_NUM_WEAPONS ) {
ADDRLP4 8
INDIRP4
CNSTI4 276
ADDP4
INDIRI4
CNSTI4 16
LTI4 $923
line 1633
;1633:		CG_Error( "CG_FireWeapon: ent->weapon >= WP_NUM_WEAPONS" );
ADDRGP4 $925
ARGP4
ADDRGP4 CG_Error
CALLV
pop
line 1634
;1634:		return;
ADDRGP4 $918
JUMPV
LABELV $923
line 1636
;1635:	}
;1636:	weap = &cg_weapons[ ent->weapon ];
ADDRLP4 4
CNSTI4 208
ADDRLP4 8
INDIRP4
CNSTI4 276
ADDP4
INDIRI4
MULI4
ADDRGP4 cg_weapons
ADDP4
ASGNP4
line 1640
;1637:
;1638:	// mark the entity as muzzle flashing, so when it is added it will
;1639:	// append the flash to the weapon model
;1640:	cent->muzzleFlashTime = cg.time;
ADDRFP4 0
INDIRP4
CNSTI4 600
ADDP4
ADDRGP4 cg+64
INDIRI4
ASGNI4
line 1642
;1641:
;1642:	if (cg.predictedPlayerState.clientNum == cent->currentState.number)
ADDRGP4 cg+96+144
INDIRI4
ADDRFP4 0
INDIRP4
INDIRI4
NEI4 $927
line 1643
;1643:	{
line 1644
;1644:		if ((ent->weapon == WP_BRYAR_PISTOL && altFire) ||
ADDRLP4 8
INDIRP4
CNSTI4 276
ADDP4
INDIRI4
CNSTI4 3
NEI4 $934
ADDRFP4 4
INDIRI4
CNSTI4 0
NEI4 $935
LABELV $934
ADDRLP4 8
INDIRP4
CNSTI4 276
ADDP4
INDIRI4
CNSTI4 6
NEI4 $936
ADDRFP4 4
INDIRI4
CNSTI4 0
EQI4 $935
LABELV $936
ADDRLP4 8
INDIRP4
CNSTI4 276
ADDP4
INDIRI4
CNSTI4 8
NEI4 $931
ADDRFP4 4
INDIRI4
CNSTI4 0
EQI4 $931
LABELV $935
line 1647
;1645:			(ent->weapon == WP_BOWCASTER && !altFire) ||
;1646:			(ent->weapon == WP_DEMP2 && altFire))
;1647:		{
line 1648
;1648:			float val = ( cg.time - cent->currentState.constantLight ) * 0.001f;
ADDRLP4 12
CNSTF4 981668463
ADDRGP4 cg+64
INDIRI4
ADDRFP4 0
INDIRP4
CNSTI4 196
ADDP4
INDIRI4
SUBI4
CVIF4 4
MULF4
ASGNF4
line 1650
;1649:
;1650:			if (val > 3)
ADDRLP4 12
INDIRF4
CNSTF4 1077936128
LEF4 $938
line 1651
;1651:			{
line 1652
;1652:				val = 3;
ADDRLP4 12
CNSTF4 1077936128
ASGNF4
line 1653
;1653:			}
LABELV $938
line 1654
;1654:			if (val < 0.2)
ADDRLP4 12
INDIRF4
CNSTF4 1045220557
GEF4 $940
line 1655
;1655:			{
line 1656
;1656:				val = 0.2;
ADDRLP4 12
CNSTF4 1045220557
ASGNF4
line 1657
;1657:			}
LABELV $940
line 1659
;1658:
;1659:			val *= 2;
ADDRLP4 12
CNSTF4 1073741824
ADDRLP4 12
INDIRF4
MULF4
ASGNF4
line 1661
;1660:
;1661:			CGCam_Shake( val, 250 );
ADDRLP4 12
INDIRF4
ARGF4
CNSTI4 250
ARGI4
ADDRGP4 CGCam_Shake
CALLV
pop
line 1662
;1662:		}
ADDRGP4 $932
JUMPV
LABELV $931
line 1663
;1663:		else if (ent->weapon == WP_ROCKET_LAUNCHER ||
ADDRLP4 12
ADDRLP4 8
INDIRP4
CNSTI4 276
ADDP4
INDIRI4
ASGNI4
ADDRLP4 12
INDIRI4
CNSTI4 10
EQI4 $945
ADDRLP4 12
INDIRI4
CNSTI4 7
NEI4 $946
ADDRFP4 4
INDIRI4
CNSTI4 0
NEI4 $945
LABELV $946
ADDRLP4 8
INDIRP4
CNSTI4 276
ADDP4
INDIRI4
CNSTI4 9
NEI4 $942
LABELV $945
line 1666
;1664:			(ent->weapon == WP_REPEATER && altFire) ||
;1665:			ent->weapon == WP_FLECHETTE)
;1666:		{
line 1667
;1667:			if (ent->weapon == WP_ROCKET_LAUNCHER)
ADDRLP4 8
INDIRP4
CNSTI4 276
ADDP4
INDIRI4
CNSTI4 10
NEI4 $947
line 1668
;1668:			{
line 1669
;1669:				CGCam_Shake(Q_irand(2, 3), 350);
CNSTI4 2
ARGI4
CNSTI4 3
ARGI4
ADDRLP4 16
ADDRGP4 Q_irand
CALLI4
ASGNI4
ADDRLP4 16
INDIRI4
CVIF4 4
ARGF4
CNSTI4 350
ARGI4
ADDRGP4 CGCam_Shake
CALLV
pop
line 1670
;1670:			}
ADDRGP4 $948
JUMPV
LABELV $947
line 1671
;1671:			else if (ent->weapon == WP_REPEATER)
ADDRLP4 8
INDIRP4
CNSTI4 276
ADDP4
INDIRI4
CNSTI4 7
NEI4 $949
line 1672
;1672:			{
line 1673
;1673:				CGCam_Shake(Q_irand(2, 3), 350);
CNSTI4 2
ARGI4
CNSTI4 3
ARGI4
ADDRLP4 16
ADDRGP4 Q_irand
CALLI4
ASGNI4
ADDRLP4 16
INDIRI4
CVIF4 4
ARGF4
CNSTI4 350
ARGI4
ADDRGP4 CGCam_Shake
CALLV
pop
line 1674
;1674:			}
ADDRGP4 $950
JUMPV
LABELV $949
line 1675
;1675:			else if (ent->weapon == WP_FLECHETTE)
ADDRLP4 8
INDIRP4
CNSTI4 276
ADDP4
INDIRI4
CNSTI4 9
NEI4 $951
line 1676
;1676:			{
line 1677
;1677:				if (altFire)
ADDRFP4 4
INDIRI4
CNSTI4 0
EQI4 $953
line 1678
;1678:				{
line 1679
;1679:					CGCam_Shake(Q_irand(2, 3), 350);
CNSTI4 2
ARGI4
CNSTI4 3
ARGI4
ADDRLP4 16
ADDRGP4 Q_irand
CALLI4
ASGNI4
ADDRLP4 16
INDIRI4
CVIF4 4
ARGF4
CNSTI4 350
ARGI4
ADDRGP4 CGCam_Shake
CALLV
pop
line 1680
;1680:				}
ADDRGP4 $954
JUMPV
LABELV $953
line 1682
;1681:				else
;1682:				{
line 1683
;1683:					CGCam_Shake(1.5, 250);
CNSTF4 1069547520
ARGF4
CNSTI4 250
ARGI4
ADDRGP4 CGCam_Shake
CALLV
pop
line 1684
;1684:				}
LABELV $954
line 1685
;1685:			}
LABELV $951
LABELV $950
LABELV $948
line 1686
;1686:		}
LABELV $942
LABELV $932
line 1687
;1687:	}
LABELV $927
line 1689
;1688:	// lightning gun only does this this on initial press
;1689:	if ( ent->weapon == WP_DEMP2 ) {
ADDRLP4 8
INDIRP4
CNSTI4 276
ADDP4
INDIRI4
CNSTI4 8
NEI4 $955
line 1690
;1690:		if ( cent->pe.lightningFiring ) {
ADDRFP4 0
INDIRP4
CNSTI4 844
ADDP4
INDIRI4
CNSTI4 0
EQI4 $957
line 1691
;1691:			return;
ADDRGP4 $918
JUMPV
LABELV $957
line 1693
;1692:		}
;1693:	}
LABELV $955
line 1696
;1694:
;1695:	// play quad sound if needed
;1696:	if ( cent->currentState.powerups & ( 1 << PW_QUAD ) ) {
ADDRFP4 0
INDIRP4
CNSTI4 272
ADDP4
INDIRI4
CNSTI4 2
BANDI4
CNSTI4 0
EQI4 $959
line 1698
;1697:		//trap_S_StartSound (NULL, cent->currentState.number, CHAN_ITEM, cgs.media.quadSound );
;1698:	}
LABELV $959
line 1702
;1699:
;1700:
;1701:	// play a sound
;1702:	if (altFire)
ADDRFP4 4
INDIRI4
CNSTI4 0
EQI4 $961
line 1703
;1703:	{
line 1705
;1704:		// play a sound
;1705:		for ( c = 0 ; c < 4 ; c++ ) {
ADDRLP4 0
CNSTI4 0
ASGNI4
LABELV $963
line 1706
;1706:			if ( !weap->altFlashSound[c] ) {
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 4
INDIRP4
CNSTI4 132
ADDP4
ADDP4
INDIRI4
CNSTI4 0
NEI4 $967
line 1707
;1707:				break;
ADDRGP4 $965
JUMPV
LABELV $967
line 1709
;1708:			}
;1709:		}
LABELV $964
line 1705
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 4
LTI4 $963
LABELV $965
line 1710
;1710:		if ( c > 0 ) {
ADDRLP4 0
INDIRI4
CNSTI4 0
LEI4 $962
line 1711
;1711:			c = rand() % c;
ADDRLP4 12
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
ADDRLP4 12
INDIRI4
ADDRLP4 0
INDIRI4
MODI4
ASGNI4
line 1712
;1712:			if ( weap->altFlashSound[c] )
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 4
INDIRP4
CNSTI4 132
ADDP4
ADDP4
INDIRI4
CNSTI4 0
EQI4 $962
line 1713
;1713:			{
line 1714
;1714:				trap_S_StartSound( NULL, ent->number, CHAN_WEAPON, weap->altFlashSound[c] );
CNSTP4 0
ARGP4
ADDRLP4 8
INDIRP4
INDIRI4
ARGI4
ADDRLP4 16
CNSTI4 2
ASGNI4
ADDRLP4 16
INDIRI4
ARGI4
ADDRLP4 0
INDIRI4
ADDRLP4 16
INDIRI4
LSHI4
ADDRLP4 4
INDIRP4
CNSTI4 132
ADDP4
ADDP4
INDIRI4
ARGI4
ADDRGP4 trap_S_StartSound
CALLV
pop
line 1715
;1715:			}
line 1716
;1716:		}
line 1721
;1717://		if ( weap->altFlashSnd )
;1718://		{
;1719://			trap_S_StartSound( NULL, ent->number, CHAN_WEAPON, weap->altFlashSnd );
;1720://		}
;1721:	}
ADDRGP4 $962
JUMPV
LABELV $961
line 1723
;1722:	else
;1723:	{
line 1725
;1724:		// play a sound
;1725:		for ( c = 0 ; c < 4 ; c++ ) {
ADDRLP4 0
CNSTI4 0
ASGNI4
LABELV $973
line 1726
;1726:			if ( !weap->flashSound[c] ) {
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 4
INDIRP4
CNSTI4 68
ADDP4
ADDP4
INDIRI4
CNSTI4 0
NEI4 $977
line 1727
;1727:				break;
ADDRGP4 $975
JUMPV
LABELV $977
line 1729
;1728:			}
;1729:		}
LABELV $974
line 1725
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 4
LTI4 $973
LABELV $975
line 1730
;1730:		if ( c > 0 ) {
ADDRLP4 0
INDIRI4
CNSTI4 0
LEI4 $979
line 1731
;1731:			c = rand() % c;
ADDRLP4 12
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
ADDRLP4 12
INDIRI4
ADDRLP4 0
INDIRI4
MODI4
ASGNI4
line 1732
;1732:			if ( weap->flashSound[c] )
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 4
INDIRP4
CNSTI4 68
ADDP4
ADDP4
INDIRI4
CNSTI4 0
EQI4 $981
line 1733
;1733:			{
line 1734
;1734:				trap_S_StartSound( NULL, ent->number, CHAN_WEAPON, weap->flashSound[c] );
CNSTP4 0
ARGP4
ADDRLP4 8
INDIRP4
INDIRI4
ARGI4
ADDRLP4 16
CNSTI4 2
ASGNI4
ADDRLP4 16
INDIRI4
ARGI4
ADDRLP4 0
INDIRI4
ADDRLP4 16
INDIRI4
LSHI4
ADDRLP4 4
INDIRP4
CNSTI4 68
ADDP4
ADDP4
INDIRI4
ARGI4
ADDRGP4 trap_S_StartSound
CALLV
pop
line 1735
;1735:			}
LABELV $981
line 1736
;1736:		}
LABELV $979
line 1737
;1737:	}
LABELV $962
line 1738
;1738:}
LABELV $918
endproc CG_FireWeapon 20 16
lit
align 4
LABELV $984
byte 4 0
byte 4 0
byte 4 1065353216
export CG_MissileHitWall
code
proc CG_MissileHitWall 24 12
line 1749
;1739:
;1740:
;1741:/*
;1742:=================
;1743:CG_MissileHitWall
;1744:
;1745:Caused by an EV_MISSILE_MISS event, or directly by local bullet tracing
;1746:=================
;1747:*/
;1748:void CG_MissileHitWall(int weapon, int clientNum, vec3_t origin, vec3_t dir, impactSound_t soundType, qboolean altFire, int charge) 
;1749:{
line 1751
;1750:	int parm;
;1751:	vec3_t up={0,0,1};
ADDRLP4 0
ADDRGP4 $984
INDIRB
ASGNB 12
line 1753
;1752:
;1753:	switch( weapon )
ADDRLP4 16
ADDRFP4 0
INDIRI4
ASGNI4
ADDRLP4 16
INDIRI4
CNSTI4 3
LTI4 $985
ADDRLP4 16
INDIRI4
CNSTI4 15
GTI4 $985
ADDRLP4 16
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 $1011-12
ADDP4
INDIRP4
JUMPV
lit
align 4
LABELV $1011
address $987
address $991
address $992
address $993
address $994
address $997
address $1001
address $1004
address $1005
address $985
address $985
address $1010
address $990
code
line 1754
;1754:	{
LABELV $987
line 1756
;1755:	case WP_BRYAR_PISTOL:
;1756:		if ( altFire )
ADDRFP4 20
INDIRI4
CNSTI4 0
EQI4 $988
line 1757
;1757:		{
line 1758
;1758:			parm = charge;
ADDRLP4 12
ADDRFP4 24
INDIRI4
ASGNI4
line 1759
;1759:			FX_BryarAltHitWall( origin, dir, parm );
ADDRFP4 8
INDIRP4
ARGP4
ADDRFP4 12
INDIRP4
ARGP4
ADDRLP4 12
INDIRI4
ARGI4
ADDRGP4 FX_BryarAltHitWall
CALLV
pop
line 1760
;1760:		}
ADDRGP4 $986
JUMPV
LABELV $988
line 1762
;1761:		else
;1762:		{
line 1763
;1763:			FX_BryarHitWall( origin, dir );
ADDRFP4 8
INDIRP4
ARGP4
ADDRFP4 12
INDIRP4
ARGP4
ADDRGP4 FX_BryarHitWall
CALLV
pop
line 1764
;1764:		}
line 1765
;1765:		break;
ADDRGP4 $986
JUMPV
LABELV $990
line 1768
;1766:
;1767:	case WP_TURRET:
;1768:		FX_TurretHitWall( origin, dir );
ADDRFP4 8
INDIRP4
ARGP4
ADDRFP4 12
INDIRP4
ARGP4
ADDRGP4 FX_TurretHitWall
CALLV
pop
line 1769
;1769:		break;
ADDRGP4 $986
JUMPV
LABELV $991
line 1772
;1770:
;1771:	case WP_BLASTER:
;1772:		FX_BlasterWeaponHitWall( origin, dir );
ADDRFP4 8
INDIRP4
ARGP4
ADDRFP4 12
INDIRP4
ARGP4
ADDRGP4 FX_BlasterWeaponHitWall
CALLV
pop
line 1773
;1773:		break;
ADDRGP4 $986
JUMPV
LABELV $992
line 1776
;1774:
;1775:	case WP_DISRUPTOR:
;1776:		FX_DisruptorAltMiss( origin, dir );
ADDRFP4 8
INDIRP4
ARGP4
ADDRFP4 12
INDIRP4
ARGP4
ADDRGP4 FX_DisruptorAltMiss
CALLV
pop
line 1777
;1777:		break;
ADDRGP4 $986
JUMPV
LABELV $993
line 1780
;1778:
;1779:	case WP_BOWCASTER:
;1780:		FX_BowcasterHitWall( origin, dir );
ADDRFP4 8
INDIRP4
ARGP4
ADDRFP4 12
INDIRP4
ARGP4
ADDRGP4 FX_BowcasterHitWall
CALLV
pop
line 1781
;1781:		break;
ADDRGP4 $986
JUMPV
LABELV $994
line 1784
;1782:
;1783:	case WP_REPEATER:
;1784:		if ( altFire )
ADDRFP4 20
INDIRI4
CNSTI4 0
EQI4 $995
line 1785
;1785:		{
line 1786
;1786:			FX_RepeaterAltHitWall( origin, dir );
ADDRFP4 8
INDIRP4
ARGP4
ADDRFP4 12
INDIRP4
ARGP4
ADDRGP4 FX_RepeaterAltHitWall
CALLV
pop
line 1787
;1787:		}
ADDRGP4 $986
JUMPV
LABELV $995
line 1789
;1788:		else
;1789:		{
line 1790
;1790:			FX_RepeaterHitWall( origin, dir );
ADDRFP4 8
INDIRP4
ARGP4
ADDRFP4 12
INDIRP4
ARGP4
ADDRGP4 FX_RepeaterHitWall
CALLV
pop
line 1791
;1791:		}
line 1792
;1792:		break;
ADDRGP4 $986
JUMPV
LABELV $997
line 1795
;1793:
;1794:	case WP_DEMP2:
;1795:		if (altFire)
ADDRFP4 20
INDIRI4
CNSTI4 0
EQI4 $998
line 1796
;1796:		{
line 1797
;1797:			trap_FX_PlayEffectID(trap_FX_RegisterEffect("demp2/altDetonate.efx"), origin, dir);
ADDRGP4 $1000
ARGP4
ADDRLP4 20
ADDRGP4 trap_FX_RegisterEffect
CALLI4
ASGNI4
ADDRLP4 20
INDIRI4
ARGI4
ADDRFP4 8
INDIRP4
ARGP4
ADDRFP4 12
INDIRP4
ARGP4
ADDRGP4 trap_FX_PlayEffectID
CALLV
pop
line 1798
;1798:		}
ADDRGP4 $986
JUMPV
LABELV $998
line 1800
;1799:		else
;1800:		{
line 1801
;1801:			FX_DEMP2_HitWall( origin, dir );
ADDRFP4 8
INDIRP4
ARGP4
ADDRFP4 12
INDIRP4
ARGP4
ADDRGP4 FX_DEMP2_HitWall
CALLV
pop
line 1802
;1802:		}
line 1803
;1803:		break;
ADDRGP4 $986
JUMPV
LABELV $1001
line 1812
;1804:
;1805:	case WP_FLECHETTE:
;1806:		/*if (altFire)
;1807:		{
;1808:			CG_SurfaceExplosion(origin, dir, 20.0f, 12.0f, qtrue);
;1809:		}
;1810:		else
;1811:		*/
;1812:		if (!altFire)
ADDRFP4 20
INDIRI4
CNSTI4 0
NEI4 $986
line 1813
;1813:		{
line 1814
;1814:			FX_FlechetteWeaponHitWall( origin, dir );
ADDRFP4 8
INDIRP4
ARGP4
ADDRFP4 12
INDIRP4
ARGP4
ADDRGP4 FX_FlechetteWeaponHitWall
CALLV
pop
line 1815
;1815:		}
line 1816
;1816:		break;
ADDRGP4 $986
JUMPV
LABELV $1004
line 1819
;1817:
;1818:	case WP_ROCKET_LAUNCHER:
;1819:		FX_RocketHitWall( origin, dir );
ADDRFP4 8
INDIRP4
ARGP4
ADDRFP4 12
INDIRP4
ARGP4
ADDRGP4 FX_RocketHitWall
CALLV
pop
line 1820
;1820:		break;
ADDRGP4 $986
JUMPV
LABELV $1005
line 1823
;1821:
;1822:	case WP_THERMAL:
;1823:		trap_FX_PlayEffectID( cgs.effects.thermalExplosionEffect, origin, dir );
ADDRGP4 cgs+72332+132
INDIRI4
ARGI4
ADDRFP4 8
INDIRP4
ARGP4
ADDRFP4 12
INDIRP4
ARGP4
ADDRGP4 trap_FX_PlayEffectID
CALLV
pop
line 1824
;1824:		trap_FX_PlayEffectID( cgs.effects.thermalShockwaveEffect, origin, up );
ADDRGP4 cgs+72332+136
INDIRI4
ARGI4
ADDRFP4 8
INDIRP4
ARGP4
ADDRLP4 0
ARGP4
ADDRGP4 trap_FX_PlayEffectID
CALLV
pop
line 1825
;1825:		break;
ADDRGP4 $986
JUMPV
LABELV $1010
line 1828
;1826:
;1827:	case WP_EMPLACED_GUN:
;1828:		FX_BlasterWeaponHitWall( origin, dir );
ADDRFP4 8
INDIRP4
ARGP4
ADDRFP4 12
INDIRP4
ARGP4
ADDRGP4 FX_BlasterWeaponHitWall
CALLV
pop
line 1830
;1829:		//FIXME: Give it its own hit wall effect
;1830:		break;
LABELV $985
LABELV $986
line 1832
;1831:	}
;1832:}
LABELV $983
endproc CG_MissileHitWall 24 12
lit
align 4
LABELV $1014
byte 4 0
byte 4 0
byte 4 1065353216
export CG_MissileHitPlayer
code
proc CG_MissileHitPlayer 24 12
line 1841
;1833:
;1834:
;1835:/*
;1836:=================
;1837:CG_MissileHitPlayer
;1838:=================
;1839:*/
;1840:void CG_MissileHitPlayer(int weapon, vec3_t origin, vec3_t dir, int entityNum, qboolean altFire) 
;1841:{
line 1842
;1842:	qboolean	humanoid = qtrue;
ADDRLP4 0
CNSTI4 1
ASGNI4
line 1843
;1843:	vec3_t up={0,0,1};
ADDRLP4 4
ADDRGP4 $1014
INDIRB
ASGNB 12
line 1863
;1844:
;1845:	/*
;1846:	// NOTENOTE Non-portable code from single player
;1847:	if ( cent->gent )
;1848:	{
;1849:		other = &g_entities[cent->gent->s.otherEntityNum];
;1850:
;1851:		if ( other->client && other->client->playerTeam == TEAM_BOTS )
;1852:		{
;1853:			humanoid = qfalse;
;1854:		}
;1855:	}
;1856:	*/	
;1857:
;1858:	// NOTENOTE No bleeding in this game
;1859://	CG_Bleed( origin, entityNum );
;1860:
;1861:	// some weapons will make an explosion with the blood, while
;1862:	// others will just make the blood
;1863:	switch ( weapon ) {
ADDRLP4 16
ADDRFP4 0
INDIRI4
ASGNI4
ADDRLP4 16
INDIRI4
CNSTI4 3
LTI4 $1016
ADDRLP4 16
INDIRI4
CNSTI4 15
GTI4 $1016
ADDRLP4 16
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 $1038-12
ADDP4
INDIRP4
JUMPV
lit
align 4
LABELV $1038
address $1017
address $1021
address $1022
address $1023
address $1024
address $1027
address $1030
address $1031
address $1032
address $1016
address $1016
address $1037
address $1020
code
LABELV $1017
line 1865
;1864:	case WP_BRYAR_PISTOL:
;1865:		if ( altFire )
ADDRFP4 16
INDIRI4
CNSTI4 0
EQI4 $1018
line 1866
;1866:		{
line 1867
;1867:			FX_BryarAltHitPlayer( origin, dir, humanoid );
ADDRFP4 4
INDIRP4
ARGP4
ADDRFP4 8
INDIRP4
ARGP4
ADDRLP4 0
INDIRI4
ARGI4
ADDRGP4 FX_BryarAltHitPlayer
CALLV
pop
line 1868
;1868:		}
ADDRGP4 $1016
JUMPV
LABELV $1018
line 1870
;1869:		else
;1870:		{
line 1871
;1871:			FX_BryarHitPlayer( origin, dir, humanoid );
ADDRFP4 4
INDIRP4
ARGP4
ADDRFP4 8
INDIRP4
ARGP4
ADDRLP4 0
INDIRI4
ARGI4
ADDRGP4 FX_BryarHitPlayer
CALLV
pop
line 1872
;1872:		}
line 1873
;1873:		break;
ADDRGP4 $1016
JUMPV
LABELV $1020
line 1876
;1874:
;1875:	case WP_TURRET:
;1876:		FX_TurretHitPlayer( origin, dir, humanoid );
ADDRFP4 4
INDIRP4
ARGP4
ADDRFP4 8
INDIRP4
ARGP4
ADDRLP4 0
INDIRI4
ARGI4
ADDRGP4 FX_TurretHitPlayer
CALLV
pop
line 1877
;1877:		break;
ADDRGP4 $1016
JUMPV
LABELV $1021
line 1880
;1878:
;1879:	case WP_BLASTER:
;1880:		FX_BlasterWeaponHitPlayer( origin, dir, humanoid );
ADDRFP4 4
INDIRP4
ARGP4
ADDRFP4 8
INDIRP4
ARGP4
ADDRLP4 0
INDIRI4
ARGI4
ADDRGP4 FX_BlasterWeaponHitPlayer
CALLV
pop
line 1881
;1881:		break;
ADDRGP4 $1016
JUMPV
LABELV $1022
line 1884
;1882:
;1883:	case WP_DISRUPTOR:
;1884:		FX_DisruptorAltHit( origin, dir);
ADDRFP4 4
INDIRP4
ARGP4
ADDRFP4 8
INDIRP4
ARGP4
ADDRGP4 FX_DisruptorAltHit
CALLV
pop
line 1885
;1885:		break;
ADDRGP4 $1016
JUMPV
LABELV $1023
line 1888
;1886:
;1887:	case WP_BOWCASTER:
;1888:		FX_BowcasterHitPlayer( origin, dir, humanoid );
ADDRFP4 4
INDIRP4
ARGP4
ADDRFP4 8
INDIRP4
ARGP4
ADDRLP4 0
INDIRI4
ARGI4
ADDRGP4 FX_BowcasterHitPlayer
CALLV
pop
line 1889
;1889:		break;
ADDRGP4 $1016
JUMPV
LABELV $1024
line 1892
;1890:
;1891:	case WP_REPEATER:
;1892:		if ( altFire )
ADDRFP4 16
INDIRI4
CNSTI4 0
EQI4 $1025
line 1893
;1893:		{
line 1894
;1894:			FX_RepeaterAltHitPlayer( origin, dir, humanoid );
ADDRFP4 4
INDIRP4
ARGP4
ADDRFP4 8
INDIRP4
ARGP4
ADDRLP4 0
INDIRI4
ARGI4
ADDRGP4 FX_RepeaterAltHitPlayer
CALLV
pop
line 1895
;1895:		}
ADDRGP4 $1016
JUMPV
LABELV $1025
line 1897
;1896:		else
;1897:		{
line 1898
;1898:			FX_RepeaterHitPlayer( origin, dir, humanoid );
ADDRFP4 4
INDIRP4
ARGP4
ADDRFP4 8
INDIRP4
ARGP4
ADDRLP4 0
INDIRI4
ARGI4
ADDRGP4 FX_RepeaterHitPlayer
CALLV
pop
line 1899
;1899:		}
line 1900
;1900:		break;
ADDRGP4 $1016
JUMPV
LABELV $1027
line 1912
;1901:
;1902:	case WP_DEMP2:
;1903:		// Do a full body effect here for some more feedback
;1904:		// NOTENOTE The chaining of the demp2 is not yet implemented.
;1905:		/*
;1906:		if ( other )
;1907:		{
;1908:			other->s.powerups |= ( 1 << PW_DISINT_1 );
;1909:			other->client->ps.powerups[PW_DISINT_1] = cg.time + 650;
;1910:		}
;1911:		*/
;1912:		if (altFire)
ADDRFP4 16
INDIRI4
CNSTI4 0
EQI4 $1028
line 1913
;1913:		{
line 1914
;1914:			trap_FX_PlayEffectID(trap_FX_RegisterEffect("demp2/altDetonate.efx"), origin, dir);
ADDRGP4 $1000
ARGP4
ADDRLP4 20
ADDRGP4 trap_FX_RegisterEffect
CALLI4
ASGNI4
ADDRLP4 20
INDIRI4
ARGI4
ADDRFP4 4
INDIRP4
ARGP4
ADDRFP4 8
INDIRP4
ARGP4
ADDRGP4 trap_FX_PlayEffectID
CALLV
pop
line 1915
;1915:		}
ADDRGP4 $1016
JUMPV
LABELV $1028
line 1917
;1916:		else
;1917:		{
line 1918
;1918:			FX_DEMP2_HitPlayer( origin, dir, humanoid );
ADDRFP4 4
INDIRP4
ARGP4
ADDRFP4 8
INDIRP4
ARGP4
ADDRLP4 0
INDIRI4
ARGI4
ADDRGP4 FX_DEMP2_HitPlayer
CALLV
pop
line 1919
;1919:		}
line 1920
;1920:		break;
ADDRGP4 $1016
JUMPV
LABELV $1030
line 1923
;1921:
;1922:	case WP_FLECHETTE:
;1923:		FX_FlechetteWeaponHitPlayer( origin, dir, humanoid );
ADDRFP4 4
INDIRP4
ARGP4
ADDRFP4 8
INDIRP4
ARGP4
ADDRLP4 0
INDIRI4
ARGI4
ADDRGP4 FX_FlechetteWeaponHitPlayer
CALLV
pop
line 1924
;1924:		break;
ADDRGP4 $1016
JUMPV
LABELV $1031
line 1927
;1925:
;1926:	case WP_ROCKET_LAUNCHER:
;1927:		FX_RocketHitPlayer( origin, dir, humanoid );
ADDRFP4 4
INDIRP4
ARGP4
ADDRFP4 8
INDIRP4
ARGP4
ADDRLP4 0
INDIRI4
ARGI4
ADDRGP4 FX_RocketHitPlayer
CALLV
pop
line 1928
;1928:		break;
ADDRGP4 $1016
JUMPV
LABELV $1032
line 1931
;1929:
;1930:	case WP_THERMAL:
;1931:		trap_FX_PlayEffectID( cgs.effects.thermalExplosionEffect, origin, dir );
ADDRGP4 cgs+72332+132
INDIRI4
ARGI4
ADDRFP4 4
INDIRP4
ARGP4
ADDRFP4 8
INDIRP4
ARGP4
ADDRGP4 trap_FX_PlayEffectID
CALLV
pop
line 1932
;1932:		trap_FX_PlayEffectID( cgs.effects.thermalShockwaveEffect, origin, up );
ADDRGP4 cgs+72332+136
INDIRI4
ARGI4
ADDRFP4 4
INDIRP4
ARGP4
ADDRLP4 4
ARGP4
ADDRGP4 trap_FX_PlayEffectID
CALLV
pop
line 1933
;1933:		break;
ADDRGP4 $1016
JUMPV
LABELV $1037
line 1936
;1934:	case WP_EMPLACED_GUN:
;1935:		//FIXME: Its own effect?
;1936:		FX_BlasterWeaponHitPlayer( origin, dir, humanoid );
ADDRFP4 4
INDIRP4
ARGP4
ADDRFP4 8
INDIRP4
ARGP4
ADDRLP4 0
INDIRI4
ARGI4
ADDRGP4 FX_BlasterWeaponHitPlayer
CALLV
pop
line 1937
;1937:		break;
line 1940
;1938:
;1939:	default:
;1940:		break;
LABELV $1016
line 1942
;1941:	}
;1942:}
LABELV $1013
endproc CG_MissileHitPlayer 24 12
export CG_Tracer
proc CG_Tracer 224 12
line 1959
;1943:
;1944:
;1945:/*
;1946:============================================================================
;1947:
;1948:BULLETS
;1949:
;1950:============================================================================
;1951:*/
;1952:
;1953:
;1954:/*
;1955:===============
;1956:CG_Tracer
;1957:===============
;1958:*/
;1959:void CG_Tracer( vec3_t source, vec3_t dest ) {
line 1968
;1960:	vec3_t		forward, right;
;1961:	polyVert_t	verts[4];
;1962:	vec3_t		line;
;1963:	float		len, begin, end;
;1964:	vec3_t		start, finish;
;1965:	vec3_t		midpoint;
;1966:
;1967:	// tracer
;1968:	VectorSubtract( dest, source, forward );
ADDRLP4 180
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 184
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 108
ADDRLP4 180
INDIRP4
INDIRF4
ADDRLP4 184
INDIRP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 188
CNSTI4 4
ASGNI4
ADDRLP4 108+4
ADDRLP4 180
INDIRP4
ADDRLP4 188
INDIRI4
ADDP4
INDIRF4
ADDRLP4 184
INDIRP4
ADDRLP4 188
INDIRI4
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 192
CNSTI4 8
ASGNI4
ADDRLP4 108+8
ADDRFP4 4
INDIRP4
ADDRLP4 192
INDIRI4
ADDP4
INDIRF4
ADDRFP4 0
INDIRP4
ADDRLP4 192
INDIRI4
ADDP4
INDIRF4
SUBF4
ASGNF4
line 1969
;1969:	len = VectorNormalize( forward );
ADDRLP4 108
ARGP4
ADDRLP4 196
ADDRGP4 VectorNormalize
CALLF4
ASGNF4
ADDRLP4 164
ADDRLP4 196
INDIRF4
ASGNF4
line 1972
;1970:
;1971:	// start at least a little ways from the muzzle
;1972:	if ( len < 100 ) {
ADDRLP4 164
INDIRF4
CNSTF4 1120403456
GEF4 $1043
line 1973
;1973:		return;
ADDRGP4 $1040
JUMPV
LABELV $1043
line 1975
;1974:	}
;1975:	begin = 50 + random() * (len - 60);
ADDRLP4 200
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 160
ADDRLP4 200
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
ADDRLP4 164
INDIRF4
CNSTF4 1114636288
SUBF4
MULF4
CNSTF4 1112014848
ADDF4
ASGNF4
line 1976
;1976:	end = begin + cg_tracerLength.value;
ADDRLP4 156
ADDRLP4 160
INDIRF4
ADDRGP4 cg_tracerLength+8
INDIRF4
ADDF4
ASGNF4
line 1977
;1977:	if ( end > len ) {
ADDRLP4 156
INDIRF4
ADDRLP4 164
INDIRF4
LEF4 $1046
line 1978
;1978:		end = len;
ADDRLP4 156
ADDRLP4 164
INDIRF4
ASGNF4
line 1979
;1979:	}
LABELV $1046
line 1980
;1980:	VectorMA( source, begin, forward, start );
ADDRLP4 204
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 120
ADDRLP4 204
INDIRP4
INDIRF4
ADDRLP4 108
INDIRF4
ADDRLP4 160
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 120+4
ADDRLP4 204
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
ADDRLP4 108+4
INDIRF4
ADDRLP4 160
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 120+8
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ADDRLP4 108+8
INDIRF4
ADDRLP4 160
INDIRF4
MULF4
ADDF4
ASGNF4
line 1981
;1981:	VectorMA( source, end, forward, finish );
ADDRLP4 212
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 132
ADDRLP4 212
INDIRP4
INDIRF4
ADDRLP4 108
INDIRF4
ADDRLP4 156
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 132+4
ADDRLP4 212
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
ADDRLP4 108+4
INDIRF4
ADDRLP4 156
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 132+8
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ADDRLP4 108+8
INDIRF4
ADDRLP4 156
INDIRF4
MULF4
ADDF4
ASGNF4
line 1983
;1982:
;1983:	line[0] = DotProduct( forward, cg.refdef.viewaxis[1] );
ADDRLP4 144
ADDRLP4 108
INDIRF4
ADDRGP4 cg+3616+36+12
INDIRF4
MULF4
ADDRLP4 108+4
INDIRF4
ADDRGP4 cg+3616+36+12+4
INDIRF4
MULF4
ADDF4
ADDRLP4 108+8
INDIRF4
ADDRGP4 cg+3616+36+12+8
INDIRF4
MULF4
ADDF4
ASGNF4
line 1984
;1984:	line[1] = DotProduct( forward, cg.refdef.viewaxis[2] );
ADDRLP4 144+4
ADDRLP4 108
INDIRF4
ADDRGP4 cg+3616+36+24
INDIRF4
MULF4
ADDRLP4 108+4
INDIRF4
ADDRGP4 cg+3616+36+24+4
INDIRF4
MULF4
ADDF4
ADDRLP4 108+8
INDIRF4
ADDRGP4 cg+3616+36+24+8
INDIRF4
MULF4
ADDF4
ASGNF4
line 1986
;1985:
;1986:	VectorScale( cg.refdef.viewaxis[1], line[1], right );
ADDRLP4 96
ADDRGP4 cg+3616+36+12
INDIRF4
ADDRLP4 144+4
INDIRF4
MULF4
ASGNF4
ADDRLP4 96+4
ADDRGP4 cg+3616+36+12+4
INDIRF4
ADDRLP4 144+4
INDIRF4
MULF4
ASGNF4
ADDRLP4 96+8
ADDRGP4 cg+3616+36+12+8
INDIRF4
ADDRLP4 144+4
INDIRF4
MULF4
ASGNF4
line 1987
;1987:	VectorMA( right, -line[0], cg.refdef.viewaxis[2], right );
ADDRLP4 220
ADDRLP4 144
INDIRF4
NEGF4
ASGNF4
ADDRLP4 96
ADDRLP4 96
INDIRF4
ADDRGP4 cg+3616+36+24
INDIRF4
ADDRLP4 220
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 96+4
ADDRLP4 96+4
INDIRF4
ADDRGP4 cg+3616+36+24+4
INDIRF4
ADDRLP4 220
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 96+8
ADDRLP4 96+8
INDIRF4
ADDRGP4 cg+3616+36+24+8
INDIRF4
ADDRLP4 144
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
line 1988
;1988:	VectorNormalize( right );
ADDRLP4 96
ARGP4
ADDRGP4 VectorNormalize
CALLF4
pop
line 1990
;1989:
;1990:	VectorMA( finish, cg_tracerWidth.value, right, verts[0].xyz );
ADDRLP4 0
ADDRLP4 132
INDIRF4
ADDRLP4 96
INDIRF4
ADDRGP4 cg_tracerWidth+8
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 132+4
INDIRF4
ADDRLP4 96+4
INDIRF4
ADDRGP4 cg_tracerWidth+8
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRLP4 132+8
INDIRF4
ADDRLP4 96+8
INDIRF4
ADDRGP4 cg_tracerWidth+8
INDIRF4
MULF4
ADDF4
ASGNF4
line 1991
;1991:	verts[0].st[0] = 0;
ADDRLP4 0+12
CNSTF4 0
ASGNF4
line 1992
;1992:	verts[0].st[1] = 1;
ADDRLP4 0+12+4
CNSTF4 1065353216
ASGNF4
line 1993
;1993:	verts[0].modulate[0] = 255;
ADDRLP4 0+20
CNSTU1 255
ASGNU1
line 1994
;1994:	verts[0].modulate[1] = 255;
ADDRLP4 0+20+1
CNSTU1 255
ASGNU1
line 1995
;1995:	verts[0].modulate[2] = 255;
ADDRLP4 0+20+2
CNSTU1 255
ASGNU1
line 1996
;1996:	verts[0].modulate[3] = 255;
ADDRLP4 0+20+3
CNSTU1 255
ASGNU1
line 1998
;1997:
;1998:	VectorMA( finish, -cg_tracerWidth.value, right, verts[1].xyz );
ADDRLP4 0+24
ADDRLP4 132
INDIRF4
ADDRLP4 96
INDIRF4
ADDRGP4 cg_tracerWidth+8
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+24+4
ADDRLP4 132+4
INDIRF4
ADDRLP4 96+4
INDIRF4
ADDRGP4 cg_tracerWidth+8
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+24+8
ADDRLP4 132+8
INDIRF4
ADDRLP4 96+8
INDIRF4
ADDRGP4 cg_tracerWidth+8
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
line 1999
;1999:	verts[1].st[0] = 1;
ADDRLP4 0+24+12
CNSTF4 1065353216
ASGNF4
line 2000
;2000:	verts[1].st[1] = 0;
ADDRLP4 0+24+12+4
CNSTF4 0
ASGNF4
line 2001
;2001:	verts[1].modulate[0] = 255;
ADDRLP4 0+24+20
CNSTU1 255
ASGNU1
line 2002
;2002:	verts[1].modulate[1] = 255;
ADDRLP4 0+24+20+1
CNSTU1 255
ASGNU1
line 2003
;2003:	verts[1].modulate[2] = 255;
ADDRLP4 0+24+20+2
CNSTU1 255
ASGNU1
line 2004
;2004:	verts[1].modulate[3] = 255;
ADDRLP4 0+24+20+3
CNSTU1 255
ASGNU1
line 2006
;2005:
;2006:	VectorMA( start, -cg_tracerWidth.value, right, verts[2].xyz );
ADDRLP4 0+48
ADDRLP4 120
INDIRF4
ADDRLP4 96
INDIRF4
ADDRGP4 cg_tracerWidth+8
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+48+4
ADDRLP4 120+4
INDIRF4
ADDRLP4 96+4
INDIRF4
ADDRGP4 cg_tracerWidth+8
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+48+8
ADDRLP4 120+8
INDIRF4
ADDRLP4 96+8
INDIRF4
ADDRGP4 cg_tracerWidth+8
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
line 2007
;2007:	verts[2].st[0] = 1;
ADDRLP4 0+48+12
CNSTF4 1065353216
ASGNF4
line 2008
;2008:	verts[2].st[1] = 1;
ADDRLP4 0+48+12+4
CNSTF4 1065353216
ASGNF4
line 2009
;2009:	verts[2].modulate[0] = 255;
ADDRLP4 0+48+20
CNSTU1 255
ASGNU1
line 2010
;2010:	verts[2].modulate[1] = 255;
ADDRLP4 0+48+20+1
CNSTU1 255
ASGNU1
line 2011
;2011:	verts[2].modulate[2] = 255;
ADDRLP4 0+48+20+2
CNSTU1 255
ASGNU1
line 2012
;2012:	verts[2].modulate[3] = 255;
ADDRLP4 0+48+20+3
CNSTU1 255
ASGNU1
line 2014
;2013:
;2014:	VectorMA( start, cg_tracerWidth.value, right, verts[3].xyz );
ADDRLP4 0+72
ADDRLP4 120
INDIRF4
ADDRLP4 96
INDIRF4
ADDRGP4 cg_tracerWidth+8
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+72+4
ADDRLP4 120+4
INDIRF4
ADDRLP4 96+4
INDIRF4
ADDRGP4 cg_tracerWidth+8
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+72+8
ADDRLP4 120+8
INDIRF4
ADDRLP4 96+8
INDIRF4
ADDRGP4 cg_tracerWidth+8
INDIRF4
MULF4
ADDF4
ASGNF4
line 2015
;2015:	verts[3].st[0] = 0;
ADDRLP4 0+72+12
CNSTF4 0
ASGNF4
line 2016
;2016:	verts[3].st[1] = 0;
ADDRLP4 0+72+12+4
CNSTF4 0
ASGNF4
line 2017
;2017:	verts[3].modulate[0] = 255;
ADDRLP4 0+72+20
CNSTU1 255
ASGNU1
line 2018
;2018:	verts[3].modulate[1] = 255;
ADDRLP4 0+72+20+1
CNSTU1 255
ASGNU1
line 2019
;2019:	verts[3].modulate[2] = 255;
ADDRLP4 0+72+20+2
CNSTU1 255
ASGNU1
line 2020
;2020:	verts[3].modulate[3] = 255;
ADDRLP4 0+72+20+3
CNSTU1 255
ASGNU1
line 2022
;2021:
;2022:	trap_R_AddPolyToScene( cgs.media.tracerShader, 4, verts );
ADDRGP4 cgs+71064+196
INDIRI4
ARGI4
CNSTI4 4
ARGI4
ADDRLP4 0
ARGP4
ADDRGP4 trap_R_AddPolyToScene
CALLV
pop
line 2024
;2023:
;2024:	midpoint[0] = ( start[0] + finish[0] ) * 0.5;
ADDRLP4 168
CNSTF4 1056964608
ADDRLP4 120
INDIRF4
ADDRLP4 132
INDIRF4
ADDF4
MULF4
ASGNF4
line 2025
;2025:	midpoint[1] = ( start[1] + finish[1] ) * 0.5;
ADDRLP4 168+4
CNSTF4 1056964608
ADDRLP4 120+4
INDIRF4
ADDRLP4 132+4
INDIRF4
ADDF4
MULF4
ASGNF4
line 2026
;2026:	midpoint[2] = ( start[2] + finish[2] ) * 0.5;
ADDRLP4 168+8
CNSTF4 1056964608
ADDRLP4 120+8
INDIRF4
ADDRLP4 132+8
INDIRF4
ADDF4
MULF4
ASGNF4
line 2031
;2027:
;2028:	// add the tracer sound
;2029:	//trap_S_StartSound( midpoint, ENTITYNUM_WORLD, CHAN_AUTO, cgs.media.tracerSound );
;2030:
;2031:}
LABELV $1040
endproc CG_Tracer 224 12
export CG_CalcMuzzlePoint
proc CG_CalcMuzzlePoint 92 16
line 2038
;2032:
;2033:/*
;2034:======================
;2035:CG_CalcMuzzlePoint
;2036:======================
;2037:*/
;2038:qboolean CG_CalcMuzzlePoint( int entityNum, vec3_t muzzle ) {
line 2044
;2039:	vec3_t		forward, right;
;2040:	vec3_t		gunpoint;
;2041:	centity_t	*cent;
;2042:	int			anim;
;2043:
;2044:	if ( entityNum == cg.snap->ps.clientNum )
ADDRFP4 0
INDIRI4
ADDRGP4 cg+36
INDIRP4
CNSTI4 188
ADDP4
INDIRI4
NEI4 $1226
line 2045
;2045:	{ //I'm not exactly sure why we'd be rendering someone else's crosshair, but hey.
line 2046
;2046:		int weapontype = cg.snap->ps.weapon;
ADDRLP4 56
ADDRGP4 cg+36
INDIRP4
CNSTI4 192
ADDP4
INDIRI4
ASGNI4
line 2049
;2047:		vec3_t weaponMuzzle;
;2048:
;2049:		VectorCopy(WP_MuzzlePoint[weapontype], weaponMuzzle);
ADDRLP4 44
CNSTI4 12
ADDRLP4 56
INDIRI4
MULI4
ADDRGP4 WP_MuzzlePoint
ADDP4
INDIRB
ASGNB 12
line 2051
;2050:
;2051:		if (weapontype == WP_DISRUPTOR || weapontype == WP_STUN_BATON || weapontype == WP_SABER)
ADDRLP4 56
INDIRI4
CNSTI4 5
EQI4 $1233
ADDRLP4 56
INDIRI4
CNSTI4 1
EQI4 $1233
ADDRLP4 56
INDIRI4
CNSTI4 2
NEI4 $1230
LABELV $1233
line 2052
;2052:		{
line 2053
;2053:			VectorClear(weaponMuzzle);
ADDRLP4 64
CNSTF4 0
ASGNF4
ADDRLP4 44+8
ADDRLP4 64
INDIRF4
ASGNF4
ADDRLP4 44+4
ADDRLP4 64
INDIRF4
ASGNF4
ADDRLP4 44
ADDRLP4 64
INDIRF4
ASGNF4
line 2054
;2054:		}
LABELV $1230
line 2056
;2055:
;2056:		if (cg.snap->ps.usingATST)
ADDRGP4 cg+36
INDIRP4
CNSTI4 1360
ADDP4
INDIRI4
CNSTI4 0
EQI4 $1236
line 2057
;2057:		{
line 2058
;2058:			VectorClear(weaponMuzzle);
ADDRLP4 64
CNSTF4 0
ASGNF4
ADDRLP4 44+8
ADDRLP4 64
INDIRF4
ASGNF4
ADDRLP4 44+4
ADDRLP4 64
INDIRF4
ASGNF4
ADDRLP4 44
ADDRLP4 64
INDIRF4
ASGNF4
line 2059
;2059:			weaponMuzzle[0] = 16;
ADDRLP4 44
CNSTF4 1098907648
ASGNF4
line 2060
;2060:			weaponMuzzle[2] = 128;
ADDRLP4 44+8
CNSTF4 1124073472
ASGNF4
line 2061
;2061:		}
LABELV $1236
line 2063
;2062:
;2063:		if (cg.renderingThirdPerson)
ADDRGP4 cg+88
INDIRI4
CNSTI4 0
EQI4 $1242
line 2064
;2064:		{
line 2065
;2065:			VectorCopy( cg.predictedPlayerEntity.lerpOrigin, gunpoint );
ADDRLP4 32
ADDRGP4 cg+1476+928
INDIRB
ASGNB 12
line 2066
;2066:			AngleVectors( cg.predictedPlayerEntity.lerpAngles, forward, right, NULL );
ADDRGP4 cg+1476+940
ARGP4
ADDRLP4 0
ARGP4
ADDRLP4 20
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 AngleVectors
CALLV
pop
line 2067
;2067:		}
ADDRGP4 $1243
JUMPV
LABELV $1242
line 2069
;2068:		else
;2069:		{
line 2070
;2070:			VectorCopy( cg.refdef.vieworg, gunpoint );
ADDRLP4 32
ADDRGP4 cg+3616+24
INDIRB
ASGNB 12
line 2071
;2071:			AngleVectors( cg.refdefViewAngles, forward, right, NULL );
ADDRGP4 cg+3984
ARGP4
ADDRLP4 0
ARGP4
ADDRLP4 20
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 AngleVectors
CALLV
pop
line 2072
;2072:		}
LABELV $1243
line 2074
;2073:
;2074:		if (weapontype == WP_EMPLACED_GUN && cg.snap->ps.emplacedIndex)
ADDRLP4 56
INDIRI4
CNSTI4 14
NEI4 $1252
ADDRGP4 cg+36
INDIRP4
CNSTI4 640
ADDP4
INDIRI4
CNSTI4 0
EQI4 $1252
line 2075
;2075:		{
line 2076
;2076:			centity_t *gunEnt = &cg_entities[cg.snap->ps.emplacedIndex];
ADDRLP4 64
CNSTI4 1920
ADDRGP4 cg+36
INDIRP4
CNSTI4 640
ADDP4
INDIRI4
MULI4
ADDRGP4 cg_entities
ADDP4
ASGNP4
line 2078
;2077:
;2078:			if (gunEnt)
ADDRLP4 64
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $1256
line 2079
;2079:			{
line 2082
;2080:				vec3_t pitchConstraint;
;2081:
;2082:				VectorCopy(gunEnt->lerpOrigin, gunpoint);
ADDRLP4 32
ADDRLP4 64
INDIRP4
CNSTI4 928
ADDP4
INDIRB
ASGNB 12
line 2083
;2083:				gunpoint[2] += 46;
ADDRLP4 32+8
ADDRLP4 32+8
INDIRF4
CNSTF4 1110966272
ADDF4
ASGNF4
line 2085
;2084:
;2085:				if (cg.renderingThirdPerson)
ADDRGP4 cg+88
INDIRI4
CNSTI4 0
EQI4 $1259
line 2086
;2086:				{
line 2087
;2087:					VectorCopy(cg.predictedPlayerEntity.lerpAngles, pitchConstraint);
ADDRLP4 68
ADDRGP4 cg+1476+940
INDIRB
ASGNB 12
line 2088
;2088:				}
ADDRGP4 $1260
JUMPV
LABELV $1259
line 2090
;2089:				else
;2090:				{
line 2091
;2091:					VectorCopy(cg.refdefViewAngles, pitchConstraint);
ADDRLP4 68
ADDRGP4 cg+3984
INDIRB
ASGNB 12
line 2092
;2092:				}
LABELV $1260
line 2094
;2093:
;2094:				if (pitchConstraint[PITCH] > 40)
ADDRLP4 68
INDIRF4
CNSTF4 1109393408
LEF4 $1265
line 2095
;2095:				{
line 2096
;2096:					pitchConstraint[PITCH] = 40;
ADDRLP4 68
CNSTF4 1109393408
ASGNF4
line 2097
;2097:				}
LABELV $1265
line 2098
;2098:				AngleVectors( pitchConstraint, forward, right, NULL );
ADDRLP4 68
ARGP4
ADDRLP4 0
ARGP4
ADDRLP4 20
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 AngleVectors
CALLV
pop
line 2099
;2099:			}
LABELV $1256
line 2100
;2100:		}
LABELV $1252
line 2102
;2101:
;2102:		VectorCopy(gunpoint, muzzle);
ADDRFP4 4
INDIRP4
ADDRLP4 32
INDIRB
ASGNB 12
line 2104
;2103:
;2104:		VectorMA(muzzle, weaponMuzzle[0], forward, muzzle);
ADDRLP4 64
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 64
INDIRP4
ADDRLP4 64
INDIRP4
INDIRF4
ADDRLP4 0
INDIRF4
ADDRLP4 44
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 68
ADDRFP4 4
INDIRP4
CNSTI4 4
ADDP4
ASGNP4
ADDRLP4 68
INDIRP4
ADDRLP4 68
INDIRP4
INDIRF4
ADDRLP4 0+4
INDIRF4
ADDRLP4 44
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 72
ADDRFP4 4
INDIRP4
CNSTI4 8
ADDP4
ASGNP4
ADDRLP4 72
INDIRP4
ADDRLP4 72
INDIRP4
INDIRF4
ADDRLP4 0+8
INDIRF4
ADDRLP4 44
INDIRF4
MULF4
ADDF4
ASGNF4
line 2105
;2105:		VectorMA(muzzle, weaponMuzzle[1], right, muzzle);
ADDRLP4 76
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 76
INDIRP4
ADDRLP4 76
INDIRP4
INDIRF4
ADDRLP4 20
INDIRF4
ADDRLP4 44+4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 80
ADDRFP4 4
INDIRP4
CNSTI4 4
ADDP4
ASGNP4
ADDRLP4 80
INDIRP4
ADDRLP4 80
INDIRP4
INDIRF4
ADDRLP4 20+4
INDIRF4
ADDRLP4 44+4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 84
ADDRFP4 4
INDIRP4
CNSTI4 8
ADDP4
ASGNP4
ADDRLP4 84
INDIRP4
ADDRLP4 84
INDIRP4
INDIRF4
ADDRLP4 20+8
INDIRF4
ADDRLP4 44+4
INDIRF4
MULF4
ADDF4
ASGNF4
line 2107
;2106:
;2107:		if (weapontype == WP_EMPLACED_GUN && cg.snap->ps.emplacedIndex)
ADDRLP4 56
INDIRI4
CNSTI4 14
NEI4 $1274
ADDRGP4 cg+36
INDIRP4
CNSTI4 640
ADDP4
INDIRI4
CNSTI4 0
EQI4 $1274
line 2108
;2108:		{
line 2110
;2109:			//Do nothing
;2110:		}
ADDRGP4 $1275
JUMPV
LABELV $1274
line 2111
;2111:		else if (cg.renderingThirdPerson)
ADDRGP4 cg+88
INDIRI4
CNSTI4 0
EQI4 $1277
line 2112
;2112:		{
line 2113
;2113:			muzzle[2] += cg.snap->ps.viewheight + weaponMuzzle[2];
ADDRLP4 88
ADDRFP4 4
INDIRP4
CNSTI4 8
ADDP4
ASGNP4
ADDRLP4 88
INDIRP4
ADDRLP4 88
INDIRP4
INDIRF4
ADDRGP4 cg+36
INDIRP4
CNSTI4 212
ADDP4
INDIRI4
CVIF4 4
ADDRLP4 44+8
INDIRF4
ADDF4
ADDF4
ASGNF4
line 2114
;2114:		}
ADDRGP4 $1278
JUMPV
LABELV $1277
line 2116
;2115:		else
;2116:		{
line 2117
;2117:			muzzle[2] += weaponMuzzle[2];
ADDRLP4 88
ADDRFP4 4
INDIRP4
CNSTI4 8
ADDP4
ASGNP4
ADDRLP4 88
INDIRP4
ADDRLP4 88
INDIRP4
INDIRF4
ADDRLP4 44+8
INDIRF4
ADDF4
ASGNF4
line 2118
;2118:		}
LABELV $1278
LABELV $1275
line 2120
;2119:
;2120:		return qtrue;
CNSTI4 1
RETI4
ADDRGP4 $1225
JUMPV
LABELV $1226
line 2123
;2121:	}
;2122:
;2123:	cent = &cg_entities[entityNum];
ADDRLP4 12
CNSTI4 1920
ADDRFP4 0
INDIRI4
MULI4
ADDRGP4 cg_entities
ADDP4
ASGNP4
line 2124
;2124:	if ( !cent->currentValid ) {
ADDRLP4 12
INDIRP4
CNSTI4 596
ADDP4
INDIRI4
CNSTI4 0
NEI4 $1283
line 2125
;2125:		return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $1225
JUMPV
LABELV $1283
line 2128
;2126:	}
;2127:
;2128:	VectorCopy( cent->currentState.pos.trBase, muzzle );
ADDRFP4 4
INDIRP4
ADDRLP4 12
INDIRP4
CNSTI4 24
ADDP4
INDIRB
ASGNB 12
line 2130
;2129:
;2130:	AngleVectors( cent->currentState.apos.trBase, forward, NULL, NULL );
ADDRLP4 12
INDIRP4
CNSTI4 60
ADDP4
ARGP4
ADDRLP4 0
ARGP4
ADDRLP4 44
CNSTP4 0
ASGNP4
ADDRLP4 44
INDIRP4
ARGP4
ADDRLP4 44
INDIRP4
ARGP4
ADDRGP4 AngleVectors
CALLV
pop
line 2131
;2131:	anim = cent->currentState.legsAnim & ~ANIM_TOGGLEBIT;
ADDRLP4 16
ADDRLP4 12
INDIRP4
CNSTI4 280
ADDP4
INDIRI4
CNSTI4 -2049
BANDI4
ASGNI4
line 2132
;2132:	if ( anim == BOTH_CROUCH1WALK || anim == BOTH_CROUCH1IDLE ) {
ADDRLP4 16
INDIRI4
CNSTI4 798
EQI4 $1287
ADDRLP4 16
INDIRI4
CNSTI4 797
NEI4 $1285
LABELV $1287
line 2133
;2133:		muzzle[2] += CROUCH_VIEWHEIGHT;
ADDRLP4 52
ADDRFP4 4
INDIRP4
CNSTI4 8
ADDP4
ASGNP4
ADDRLP4 52
INDIRP4
ADDRLP4 52
INDIRP4
INDIRF4
CNSTF4 1094713344
ADDF4
ASGNF4
line 2134
;2134:	} else {
ADDRGP4 $1286
JUMPV
LABELV $1285
line 2135
;2135:		muzzle[2] += DEFAULT_VIEWHEIGHT;
ADDRLP4 52
ADDRFP4 4
INDIRP4
CNSTI4 8
ADDP4
ASGNP4
ADDRLP4 52
INDIRP4
ADDRLP4 52
INDIRP4
INDIRF4
CNSTF4 1108344832
ADDF4
ASGNF4
line 2136
;2136:	}
LABELV $1286
line 2138
;2137:
;2138:	VectorMA( muzzle, 14, forward, muzzle );
ADDRLP4 52
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 52
INDIRP4
ADDRLP4 52
INDIRP4
INDIRF4
CNSTF4 1096810496
ADDRLP4 0
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 56
ADDRFP4 4
INDIRP4
CNSTI4 4
ADDP4
ASGNP4
ADDRLP4 56
INDIRP4
ADDRLP4 56
INDIRP4
INDIRF4
CNSTF4 1096810496
ADDRLP4 0+4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 60
ADDRFP4 4
INDIRP4
CNSTI4 8
ADDP4
ASGNP4
ADDRLP4 60
INDIRP4
ADDRLP4 60
INDIRP4
INDIRF4
CNSTF4 1096810496
ADDRLP4 0+8
INDIRF4
MULF4
ADDF4
ASGNF4
line 2140
;2139:
;2140:	return qtrue;
CNSTI4 1
RETI4
LABELV $1225
endproc CG_CalcMuzzlePoint 92 16
export CG_InitG2Weapons
proc CG_InitG2Weapons 20 28
line 2153
;2141:
;2142:}
;2143:
;2144:
;2145:
;2146:/*
;2147:Ghoul2 Insert Start
;2148:*/
;2149:
;2150:// create one instance of all the weapons we are going to use so we can just copy this info into each clients gun ghoul2 object in fast way
;2151:void *g2WeaponInstances[MAX_WEAPONS];
;2152:void CG_InitG2Weapons(void)
;2153:{
line 2154
;2154:	int i = 0;
ADDRLP4 4
CNSTI4 0
ASGNI4
line 2156
;2155:	gitem_t		*item;
;2156:	memset(g2WeaponInstances, 0, sizeof(g2WeaponInstances));
ADDRGP4 g2WeaponInstances
ARGP4
CNSTI4 0
ARGI4
CNSTI4 64
ARGI4
ADDRGP4 memset
CALLP4
pop
line 2157
;2157:	for ( item = bg_itemlist + 1 ; item->classname ; item++ ) 
ADDRLP4 0
ADDRGP4 bg_itemlist+52
ASGNP4
ADDRGP4 $1294
JUMPV
LABELV $1291
line 2158
;2158:	{
line 2159
;2159:		if ( item->giType == IT_WEAPON )
ADDRLP4 0
INDIRP4
CNSTI4 36
ADDP4
INDIRI4
CNSTI4 1
NEI4 $1296
line 2160
;2160:		{
line 2162
;2161:			// initialise model
;2162:			trap_G2API_InitGhoul2Model(&g2WeaponInstances[/*i*/item->giTag], item->world_model[0], 0, 0, 0, 0, 0);
ADDRLP4 0
INDIRP4
CNSTI4 40
ADDP4
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 g2WeaponInstances
ADDP4
ARGP4
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRP4
ARGP4
ADDRLP4 12
CNSTI4 0
ASGNI4
ADDRLP4 12
INDIRI4
ARGI4
ADDRLP4 12
INDIRI4
ARGI4
ADDRLP4 12
INDIRI4
ARGI4
ADDRLP4 12
INDIRI4
ARGI4
ADDRLP4 12
INDIRI4
ARGI4
ADDRGP4 trap_G2API_InitGhoul2Model
CALLI4
pop
line 2164
;2163://			trap_G2API_InitGhoul2Model(&g2WeaponInstances[i], item->world_model[0],G_ModelIndex( item->world_model[0] ) , 0, 0, 0, 0);
;2164:			if (g2WeaponInstances[/*i*/item->giTag])
ADDRLP4 0
INDIRP4
CNSTI4 40
ADDP4
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 g2WeaponInstances
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $1298
line 2165
;2165:			{
line 2167
;2166:				// indicate we will be bolted to model 0 (ie the player) on bolt 0 (always the right hand) when we get copied
;2167:				trap_G2API_SetBoltInfo(g2WeaponInstances[/*i*/item->giTag], 0, 0);
ADDRLP4 0
INDIRP4
CNSTI4 40
ADDP4
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 g2WeaponInstances
ADDP4
INDIRP4
ARGP4
ADDRLP4 16
CNSTI4 0
ASGNI4
ADDRLP4 16
INDIRI4
ARGI4
ADDRLP4 16
INDIRI4
ARGI4
ADDRGP4 trap_G2API_SetBoltInfo
CALLV
pop
line 2169
;2168:				// now set up the gun bolt on it
;2169:				trap_G2API_AddBolt(g2WeaponInstances[/*i*/item->giTag], 0, "*flash");
ADDRLP4 0
INDIRP4
CNSTI4 40
ADDP4
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 g2WeaponInstances
ADDP4
INDIRP4
ARGP4
CNSTI4 0
ARGI4
ADDRGP4 $1300
ARGP4
ADDRGP4 trap_G2API_AddBolt
CALLI4
pop
line 2170
;2170:				i++;
ADDRLP4 4
ADDRLP4 4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 2171
;2171:			}
LABELV $1298
line 2172
;2172:			if (i == MAX_WEAPONS)
ADDRLP4 4
INDIRI4
CNSTI4 16
NEI4 $1301
line 2173
;2173:			{
line 2174
;2174:				assert(0);	
line 2175
;2175:				break;
ADDRGP4 $1293
JUMPV
LABELV $1301
line 2178
;2176:			}
;2177:			
;2178:		}
LABELV $1296
line 2179
;2179:	}
LABELV $1292
line 2157
ADDRLP4 0
ADDRLP4 0
INDIRP4
CNSTI4 52
ADDP4
ASGNP4
LABELV $1294
ADDRLP4 0
INDIRP4
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $1291
LABELV $1293
line 2180
;2180:}
LABELV $1290
endproc CG_InitG2Weapons 20 28
export CG_ShutDownG2Weapons
proc CG_ShutDownG2Weapons 4 4
line 2184
;2181:
;2182:// clean out any g2 models we instanciated for copying purposes
;2183:void CG_ShutDownG2Weapons(void)
;2184:{
line 2186
;2185:	int i;
;2186:	for (i=0; i<MAX_WEAPONS; i++)
ADDRLP4 0
CNSTI4 0
ASGNI4
LABELV $1304
line 2187
;2187:	{
line 2188
;2188:		trap_G2API_CleanGhoul2Models(&g2WeaponInstances[i]);
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 g2WeaponInstances
ADDP4
ARGP4
ADDRGP4 trap_G2API_CleanGhoul2Models
CALLV
pop
line 2189
;2189:	}
LABELV $1305
line 2186
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 16
LTI4 $1304
line 2190
;2190:}
LABELV $1303
endproc CG_ShutDownG2Weapons 4 4
export CG_CopyG2WeaponInstance
proc CG_CopyG2WeaponInstance 4 16
line 2194
;2191:
;2192:// what ghoul2 model do we want to copy ?
;2193:void CG_CopyG2WeaponInstance(int weaponNum, void *toGhoul2)
;2194:{
line 2196
;2195:	//rww - the -1 is because there is no "weapon" for WP_NONE
;2196:	assert(weaponNum < MAX_WEAPONS);
line 2197
;2197:	if (g2WeaponInstances[weaponNum/*-1*/])
ADDRFP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 g2WeaponInstances
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $1309
line 2198
;2198:	{
line 2199
;2199:		if (weaponNum == WP_EMPLACED_GUN)
ADDRFP4 0
INDIRI4
CNSTI4 14
NEI4 $1311
line 2200
;2200:		{ //a bit of a hack to remove gun model when using an emplaced weap
line 2201
;2201:			if (trap_G2API_HasGhoul2ModelOnIndex(&(toGhoul2), 1))
ADDRFP4 4
ARGP4
CNSTI4 1
ARGI4
ADDRLP4 0
ADDRGP4 trap_G2API_HasGhoul2ModelOnIndex
CALLI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 0
EQI4 $1312
line 2202
;2202:			{
line 2203
;2203:				trap_G2API_RemoveGhoul2Model(&(toGhoul2), 1);
ADDRFP4 4
ARGP4
CNSTI4 1
ARGI4
ADDRGP4 trap_G2API_RemoveGhoul2Model
CALLI4
pop
line 2204
;2204:			}
line 2205
;2205:		}
ADDRGP4 $1312
JUMPV
LABELV $1311
line 2207
;2206:		else
;2207:		{
line 2208
;2208:			trap_G2API_CopySpecificGhoul2Model(g2WeaponInstances[weaponNum/*-1*/], 0, toGhoul2, 1); 
ADDRFP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 g2WeaponInstances
ADDP4
INDIRP4
ARGP4
CNSTI4 0
ARGI4
ADDRFP4 4
INDIRP4
ARGP4
CNSTI4 1
ARGI4
ADDRGP4 trap_G2API_CopySpecificGhoul2Model
CALLV
pop
line 2209
;2209:		}
LABELV $1312
line 2210
;2210:	}
LABELV $1309
line 2211
;2211:}
LABELV $1308
endproc CG_CopyG2WeaponInstance 4 16
export CG_CheckPlayerG2Weapons
proc CG_CheckPlayerG2Weapons 32 16
line 2214
;2212:
;2213:void CG_CheckPlayerG2Weapons(playerState_t *ps, centity_t *cent) 
;2214:{
line 2216
;2215:	// should we change the gun model on this player?
;2216:	if (cent->currentState.saberInFlight)
ADDRFP4 4
INDIRP4
CNSTI4 228
ADDP4
INDIRI4
CNSTI4 0
EQI4 $1316
line 2217
;2217:	{
line 2218
;2218:		cent->ghoul2weapon = g2WeaponInstances[WP_SABER];
ADDRFP4 4
INDIRP4
CNSTI4 960
ADDP4
ADDRGP4 g2WeaponInstances+8
INDIRP4
ASGNP4
line 2219
;2219:	}
LABELV $1316
line 2221
;2220:
;2221:	if (cent->currentState.eFlags & EF_DEAD)
ADDRFP4 4
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
CNSTI4 1
BANDI4
CNSTI4 0
EQI4 $1319
line 2222
;2222:	{ //no updating weapons when dead
line 2223
;2223:		cent->ghoul2weapon = NULL;
ADDRFP4 4
INDIRP4
CNSTI4 960
ADDP4
CNSTP4 0
ASGNP4
line 2224
;2224:		return;
ADDRGP4 $1315
JUMPV
LABELV $1319
line 2227
;2225:	}
;2226:
;2227:	if (cent->torsoBolt)
ADDRFP4 4
INDIRP4
CNSTI4 1012
ADDP4
INDIRI4
CNSTI4 0
EQI4 $1321
line 2228
;2228:	{ //got our limb cut off, no updating weapons until it's restored
line 2229
;2229:		cent->ghoul2weapon = NULL;
ADDRFP4 4
INDIRP4
CNSTI4 960
ADDP4
CNSTP4 0
ASGNP4
line 2230
;2230:		return;
ADDRGP4 $1315
JUMPV
LABELV $1321
line 2233
;2231:	}
;2232:
;2233:	if (ps && ps->usingATST)
ADDRLP4 0
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 0
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $1323
ADDRLP4 0
INDIRP4
CNSTI4 1316
ADDP4
INDIRI4
CNSTI4 0
EQI4 $1323
line 2234
;2234:	{
line 2235
;2235:		cent->ghoul2weapon = NULL;
ADDRFP4 4
INDIRP4
CNSTI4 960
ADDP4
CNSTP4 0
ASGNP4
line 2236
;2236:	}
LABELV $1323
line 2238
;2237:
;2238:	if (cent->isATST)
ADDRFP4 4
INDIRP4
CNSTI4 1028
ADDP4
INDIRI4
CNSTI4 0
EQI4 $1325
line 2239
;2239:	{
line 2240
;2240:		cent->ghoul2weapon = NULL;
ADDRFP4 4
INDIRP4
CNSTI4 960
ADDP4
CNSTP4 0
ASGNP4
line 2241
;2241:		return;
ADDRGP4 $1315
JUMPV
LABELV $1325
line 2244
;2242:	}
;2243:
;2244:	if (cent->ghoul2 && cent->ghoul2weapon != g2WeaponInstances[ps->weapon] &&
ADDRLP4 4
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 4
INDIRP4
CNSTI4 952
ADDP4
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $1327
ADDRLP4 8
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 4
INDIRP4
CNSTI4 960
ADDP4
INDIRP4
CVPU4 4
ADDRLP4 8
INDIRP4
CNSTI4 148
ADDP4
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 g2WeaponInstances
ADDP4
INDIRP4
CVPU4 4
EQU4 $1327
ADDRLP4 8
INDIRP4
CNSTI4 144
ADDP4
INDIRI4
ADDRLP4 4
INDIRP4
INDIRI4
NEI4 $1327
line 2246
;2245:		ps->clientNum == cent->currentState.number) //don't want spectator mode forcing one client's weapon instance over another's
;2246:	{
line 2247
;2247:		CG_CopyG2WeaponInstance(ps->weapon, cent->ghoul2);
ADDRFP4 0
INDIRP4
CNSTI4 148
ADDP4
INDIRI4
ARGI4
ADDRFP4 4
INDIRP4
CNSTI4 952
ADDP4
INDIRP4
ARGP4
ADDRGP4 CG_CopyG2WeaponInstance
CALLV
pop
line 2248
;2248:		cent->ghoul2weapon = g2WeaponInstances[ps->weapon];
ADDRFP4 4
INDIRP4
CNSTI4 960
ADDP4
ADDRFP4 0
INDIRP4
CNSTI4 148
ADDP4
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 g2WeaponInstances
ADDP4
INDIRP4
ASGNP4
line 2249
;2249:		if (cent->weapon == WP_SABER && cg_entities[cent->currentState.number].weapon != ps->weapon && !ps->saberHolstered)
ADDRLP4 12
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 12
INDIRP4
CNSTI4 956
ADDP4
INDIRI4
CNSTI4 2
NEI4 $1329
ADDRLP4 16
ADDRFP4 0
INDIRP4
ASGNP4
CNSTI4 1920
ADDRLP4 12
INDIRP4
INDIRI4
MULI4
ADDRGP4 cg_entities+956
ADDP4
INDIRI4
ADDRLP4 16
INDIRP4
CNSTI4 148
ADDP4
INDIRI4
EQI4 $1329
ADDRLP4 16
INDIRP4
CNSTI4 1312
ADDP4
INDIRI4
CNSTI4 0
NEI4 $1329
line 2250
;2250:		{ //switching away from the saber
line 2251
;2251:			trap_S_StartSound(cent->lerpOrigin, cent->currentState.number, CHAN_AUTO, trap_S_RegisterSound( "sound/weapons/saber/saberoffquick.wav" ));
ADDRGP4 $1332
ARGP4
ADDRLP4 20
ADDRGP4 trap_S_RegisterSound
CALLI4
ASGNI4
ADDRLP4 24
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 24
INDIRP4
CNSTI4 928
ADDP4
ARGP4
ADDRLP4 24
INDIRP4
INDIRI4
ARGI4
CNSTI4 0
ARGI4
ADDRLP4 20
INDIRI4
ARGI4
ADDRGP4 trap_S_StartSound
CALLV
pop
line 2252
;2252:		}
ADDRGP4 $1330
JUMPV
LABELV $1329
line 2253
;2253:		else if (ps->weapon == WP_SABER && cg_entities[cent->currentState.number].weapon != ps->weapon)
ADDRLP4 20
ADDRFP4 0
INDIRP4
CNSTI4 148
ADDP4
INDIRI4
ASGNI4
ADDRLP4 20
INDIRI4
CNSTI4 2
NEI4 $1333
CNSTI4 1920
ADDRFP4 4
INDIRP4
INDIRI4
MULI4
ADDRGP4 cg_entities+956
ADDP4
INDIRI4
ADDRLP4 20
INDIRI4
EQI4 $1333
line 2254
;2254:		{ //switching to the saber
line 2255
;2255:			trap_S_StartSound(cent->lerpOrigin, cent->currentState.number, CHAN_AUTO, trap_S_RegisterSound( "sound/weapons/saber/saberon.wav" ));
ADDRGP4 $1336
ARGP4
ADDRLP4 24
ADDRGP4 trap_S_RegisterSound
CALLI4
ASGNI4
ADDRLP4 28
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 28
INDIRP4
CNSTI4 928
ADDP4
ARGP4
ADDRLP4 28
INDIRP4
INDIRI4
ARGI4
CNSTI4 0
ARGI4
ADDRLP4 24
INDIRI4
ARGI4
ADDRGP4 trap_S_StartSound
CALLV
pop
line 2256
;2256:		}
LABELV $1333
LABELV $1330
line 2257
;2257:		cent->weapon = ps->weapon;
ADDRFP4 4
INDIRP4
CNSTI4 956
ADDP4
ADDRFP4 0
INDIRP4
CNSTI4 148
ADDP4
INDIRI4
ASGNI4
line 2258
;2258:		cg_entities[cent->currentState.number].weapon = ps->weapon;
CNSTI4 1920
ADDRFP4 4
INDIRP4
INDIRI4
MULI4
ADDRGP4 cg_entities+956
ADDP4
ADDRFP4 0
INDIRP4
CNSTI4 148
ADDP4
INDIRI4
ASGNI4
line 2259
;2259:	}
LABELV $1327
line 2260
;2260:}
LABELV $1315
endproc CG_CheckPlayerG2Weapons 32 16
import hudTintColor
import redhudtint
import bluehudtint
import FX_RocketHitPlayer
import FX_RocketHitWall
import FX_RocketAltProjectileThink
import FX_RocketProjectileThink
import FX_FlechetteAltProjectileThink
import FX_FlechetteWeaponHitPlayer
import FX_FlechetteWeaponHitWall
import FX_FlechetteProjectileThink
import FX_DEMP2_AltDetonate
import FX_DEMP2_HitPlayer
import FX_DEMP2_HitWall
import FX_DEMP2_ProjectileThink
import FX_RepeaterAltHitPlayer
import FX_RepeaterHitPlayer
import FX_RepeaterAltHitWall
import FX_RepeaterHitWall
import FX_RepeaterAltProjectileThink
import FX_RepeaterProjectileThink
import FX_BowcasterHitPlayer
import FX_BowcasterHitWall
import FX_BowcasterAltProjectileThink
import FX_BowcasterProjectileThink
import FX_DisruptorHitPlayer
import FX_DisruptorHitWall
import FX_DisruptorAltHit
import FX_DisruptorAltMiss
import FX_DisruptorAltShot
import FX_DisruptorMainShot
import FX_BryarAltProjectileThink
import FX_BryarProjectileThink
bss
export g2WeaponInstances
align 4
LABELV g2WeaponInstances
skip 64
import CG_CreateBBRefEnts
import CG_SetGhoul2Info
import CG_Init_CGents
import CG_Init_CG
import trap_G2API_SetNewOrigin
import trap_G2API_SetSurfaceOnOff
import trap_G2API_SetRootSurface
import trap_G2API_SetBoneAnim
import trap_G2API_GetGLAName
import trap_G2API_SetBoneAngles
import trap_G2API_CleanGhoul2Models
import trap_G2API_SetBoltInfo
import trap_G2API_AddBolt
import trap_G2API_RemoveGhoul2Model
import trap_G2API_HasGhoul2ModelOnIndex
import trap_G2API_DuplicateGhoul2Instance
import trap_G2API_CopySpecificGhoul2Model
import trap_G2API_CopyGhoul2Instance
import trap_G2API_GiveMeVectorFromMatrix
import trap_G2API_InitGhoul2Model
import trap_G2API_GetBoltMatrix_NoRecNoRot
import trap_G2API_GetBoltMatrix_NoReconstruct
import trap_G2API_GetBoltMatrix
import trap_G2_HaveWeGhoul2Models
import trap_G2_SetGhoul2ModelIndexes
import trap_G2_ListModelBones
import trap_G2_ListModelSurfaces
import trap_G2API_CollisionDetect
import FX_ForceDrained
import FX_TieLaserAltFireThink
import FX_TieLaserWeaponHitPlayer
import FX_TieLaserWeaponHitWall
import FX_TieLaserProjectileThink
import FX_BlasterWeaponHitPlayer
import FX_BlasterWeaponHitWall
import FX_BlasterAltFireThink
import FX_BlasterProjectileThink
import FX_BryarAltHitPlayer
import FX_BryarHitPlayer
import FX_BryarAltHitWall
import FX_BryarHitWall
import CG_Spark
import FX_TurretHitPlayer
import FX_TurretHitWall
import FX_TurretProjectileThink
import CG_NewParticleArea
import initparticles
import CG_GetStripEdString
import CG_ParticleExplosion
import CG_ParticleMisc
import CG_ParticleDust
import CG_ParticleSparks
import CG_ParticleBulletDebris
import CG_ParticleSnowFlurry
import CG_AddParticleShrapnel
import CG_ParticleSmoke
import CG_ParticleSnow
import CG_AddParticles
import CG_ClearParticles
import trap_ROFF_Purge_Ent
import trap_ROFF_Play
import trap_ROFF_Cache
import trap_ROFF_UpdateEntities
import trap_ROFF_Clean
import trap_CG_RegisterSharedMemory
import trap_SP_GetStringTextString
import trap_SP_Print
import trap_FX_AddSprite
import trap_FX_AddPrimitive
import trap_FX_AddBezier
import trap_FX_AddPoly
import trap_FX_AdjustTime
import trap_FX_FreeSystem
import trap_FX_InitSystem
import trap_FX_AddScheduledEffects
import trap_FX_PlayBoltedEffectID
import trap_FX_PlayEntityEffectID
import trap_FX_PlayEffectID
import trap_FX_PlaySimpleEffectID
import trap_FX_PlayEntityEffect
import trap_FX_PlayEffect
import trap_FX_PlaySimpleEffect
import trap_FX_RegisterEffect
import trap_R_inPVS
import trap_GetEntityToken
import trap_getCameraInfo
import trap_startCamera
import trap_loadCamera
import trap_SnapVector
import trap_CIN_SetExtents
import trap_CIN_DrawCinematic
import trap_CIN_RunCinematic
import trap_CIN_StopCinematic
import trap_CIN_PlayCinematic
import BG_CycleForce
import BG_ProperForceIndex
import BG_CycleInven
import trap_Key_GetKey
import trap_Key_SetCatcher
import trap_Key_GetCatcher
import trap_Key_IsDown
import trap_MemoryRemaining
import testPrintFloat
import testPrintInt
import trap_OpenUIMenu
import trap_SetClientTurnExtent
import trap_SetClientForceAngle
import trap_SetUserCmdValue
import trap_GetUserCmd
import trap_GetCurrentCmdNumber
import trap_GetServerCommand
import trap_GetSnapshot
import trap_GetCurrentSnapshotNumber
import trap_GetGameState
import trap_GetGlconfig
import trap_FX_AddLine
import trap_R_GetBModelVerts
import trap_R_SetLightStyle
import trap_R_GetLightStyle
import trap_R_RemapShader
import trap_R_DrawRotatePic2
import trap_R_DrawRotatePic
import trap_R_LerpTag
import trap_R_ModelBounds
import trap_R_DrawStretchPic
import trap_R_SetColor
import trap_R_RenderScene
import trap_R_LightForPoint
import trap_R_AddLightToScene
import trap_R_AddPolysToScene
import trap_R_AddPolyToScene
import trap_R_AddRefEntityToScene
import trap_R_ClearScene
import trap_AnyLanguage_ReadCharFromString
import trap_Language_UsesSpaces
import trap_Language_IsAsian
import trap_R_Font_DrawString
import trap_R_Font_HeightPixels
import trap_R_Font_StrLenChars
import trap_R_Font_StrLenPixels
import trap_R_RegisterFont
import trap_R_RegisterShaderNoMip
import trap_R_RegisterShader
import trap_R_RegisterSkin
import trap_R_RegisterModel
import trap_R_LoadWorldMap
import trap_S_StopBackgroundTrack
import trap_S_StartBackgroundTrack
import trap_S_RegisterSound
import trap_S_Respatialize
import trap_S_UpdateEntityPosition
import trap_S_AddRealLoopingSound
import trap_S_AddLoopingSound
import trap_S_ClearLoopingSounds
import trap_S_StartLocalSound
import trap_S_StopLoopingSound
import trap_S_StartSound
import trap_S_MuteSound
import trap_CM_MarkFragments
import trap_CM_TransformedBoxTrace
import trap_CM_BoxTrace
import trap_CM_TransformedPointContents
import trap_CM_PointContents
import trap_CM_TempBoxModel
import trap_CM_InlineModel
import trap_CM_NumInlineModels
import trap_CM_LoadMap
import trap_UpdateScreen
import trap_SendClientCommand
import trap_AddCommand
import trap_SendConsoleCommand
import trap_FS_FCloseFile
import trap_FS_Write
import trap_FS_Read
import trap_FS_FOpenFile
import trap_Args
import trap_Argv
import trap_Argc
import trap_Cvar_VariableStringBuffer
import trap_Cvar_Set
import trap_Cvar_Update
import trap_Cvar_Register
import trap_Milliseconds
import trap_Error
import trap_Print
import CG_SagaObjectiveCompleted
import CG_SagaRoundOver
import CG_InitSagaMode
import CG_CheckChangedPredictableEvents
import CG_TransitionPlayerState
import CG_Respawn
import CG_IsMindTricked
import CG_PlayBufferedVoiceChats
import CG_VoiceChatLocal
import CG_ShaderStateChanged
import CG_LoadVoiceChats
import CG_SetConfigValues
import CG_ParseServerinfo
import CG_ExecuteNewServerCommands
import CG_InitConsoleCommands
import CG_ConsoleCommand
import CG_DrawOldTourneyScoreboard
import CG_DrawOldScoreboard
import CG_DrawInformation
import CG_LoadingClient
import CG_LoadingItem
import CG_LoadingString
import CG_ProcessSnapshots
import CG_InitGlass
import CG_TestLine
import CG_SurfaceExplosion
import CG_MakeExplosion
import CG_Bleed
import CG_ScorePlum
import CG_CreateDebris
import CG_GlassShatter
import CG_BubbleTrail
import CG_SmokePuff
import CG_AddLocalEntities
import CG_AllocLocalEntity
import CG_InitLocalEntities
import CG_ImpactMark
import CG_AddMarks
import CG_InitMarkPolys
import CG_RegisterWeapon
import TurretClientRun
import ScaleModelAxis
import CG_PositionRotatedEntityOnTag
import CG_PositionEntityOnTag
import CG_AdjustPositionForMover
import CG_Beam
import CG_ManualEntityRender
import CG_AddPacketEntities
import CG_SetEntitySoundPosition
import CG_ReattachLimb
import CG_PainEvent
import CG_EntityEvent
import CG_PlaceString
import CG_CheckEvents
import CG_LoadDeferredPlayers
import CG_PredictPlayerState
import CG_Trace
import CG_PointContents
import CG_BuildSolidList
import CG_PlayerShieldHit
import CG_CustomSound
import CG_NewClientInfo
import CG_AddRefEntityWithPowerups
import CG_ResetPlayerEntity
import CG_Player
import CG_StatusHandle
import CG_OtherTeamHasFlag
import CG_YourTeamHasFlag
import CG_GameTypeString
import CG_CheckOrderPending
import CG_Text_PaintChar
import CG_Draw3DModel
import CG_GetKillerText
import CG_GetGameStatusText
import CG_GetTeamColor
import CG_InitTeamChat
import CG_SetPrintString
import CG_ShowResponseHead
import CG_DeferMenuScript
import CG_RunMenuScript
import CG_OwnerDrawVisible
import CG_GetValue
import CG_SelectNextPlayer
import CG_SelectPrevPlayer
import CG_Text_Height
import CG_Text_Width
import CG_Text_Paint
import CG_OwnerDraw
import CG_DrawTeamBackground
import CG_DrawFlagModel
import CG_DrawActive
import CG_DrawHead
import CG_CenterPrint
import CG_AddLagometerSnapshotInfo
import CG_AddLagometerFrameInfo
import teamChat2
import teamChat1
import systemChat
import drawTeamOverlayModificationCount
import numSortedTeamPlayers
import sortedTeamPlayers
import CG_DrawTopBottom
import CG_DrawSides
import CG_DrawRect
import UI_DrawScaledProportionalString
import UI_DrawProportionalString
import CG_GetColorForHealth
import CG_ColorForHealth
import CG_TileClear
import CG_TeamColor
import CG_FadeColor
import CG_DrawStrlen
import CG_DrawSmallStringColor
import CG_DrawSmallString
import CG_DrawBigStringColor
import CG_DrawBigString
import CG_DrawStringExt
import CG_DrawNumField
import CG_DrawString
import CG_DrawRotatePic2
import CG_DrawRotatePic
import CG_DrawPic
import CG_FillRect
import CG_TestModelAnimate_f
import CG_TestModelSetAnglespost_f
import CG_TestModelSetAnglespre_f
import CG_ListModelBones_f
import CG_ListModelSurfaces_f
import CG_TestModelSurfaceOnOff_f
import CG_TestG2Model_f
import CG_DrawActiveFrame
import CG_AddBufferedSound
import CG_ZoomUp_f
import CG_ZoomDown_f
import CG_TestModelPrevSkin_f
import CG_TestModelNextSkin_f
import CG_TestModelPrevFrame_f
import CG_TestModelNextFrame_f
import CG_TestGun_f
import CG_TestModel_f
import CG_PrevForcePower_f
import CG_NextForcePower_f
import CG_PrevInventory_f
import CG_NextInventory_f
import CG_BuildSpectatorString
import CG_SetScoreSelection
import CG_RankRunFrame
import CG_EventHandling
import CG_MouseEvent
import CG_KeyEvent
import CG_LoadMenus
import CG_LastAttacker
import CG_CrosshairPlayer
import CG_UpdateCvars
import CG_StartMusic
import CG_Error
import CG_Printf
import CG_Argv
import CG_ConfigString
import cg_followCamTransition
import cg_followCam
import cg_roll
import cg_throttle
import cg_debugBB
import ui_myteam
import cg_recordSPDemoName
import cg_recordSPDemo
import cg_singlePlayerActive
import cg_enableBreath
import cg_enableDust
import cg_singlePlayer
import cg_currentSelectedPlayerName
import cg_currentSelectedPlayer
import cg_blueTeamName
import cg_redTeamName
import cg_trueLightning
import cg_noProjectileTrail
import cg_noTaunt
import cg_bigFont
import cg_smallFont
import cg_cameraMode
import cg_timescale
import cg_timescaleFadeSpeed
import cg_timescaleFadeEnd
import cg_cameraOrbitDelay
import cg_cameraOrbit
import pmove_msec
import pmove_fixed
import cg_smoothClients
import cg_hudFiles
import cg_scorePlum
import cg_noVoiceText
import cg_noVoiceChats
import cg_teamChatsOnly
import cg_drawFriend
import cg_deferPlayers
import cg_predictItems
import cg_blood
import cg_paused
import cg_buildScript
import cg_forceModel
import cg_stats
import cg_teamChatHeight
import cg_teamChatTime
import cg_synchronousClients
import cg_drawEnemyInfo
import cg_lagometer
import cg_stereoSeparation
import cg_thirdPersonHorzOffset
import cg_thirdPersonAlpha
import cg_thirdPersonTargetDamp
import cg_thirdPersonCameraDamp
import cg_thirdPersonVertOffset
import cg_thirdPersonPitchOffset
import cg_thirdPersonAngle
import cg_thirdPersonRange
import cg_thirdPerson
import cg_dismember
import cg_animBlend
import cg_auraShell
import cg_speedTrail
import cg_duelHeadAngles
import cg_saberTrail
import cg_saberContact
import cg_saberDynamicMarkTime
import cg_saberDynamicMarks
import cg_fpls
import cg_saberModelTraceEffect
import cg_oldPainSounds
import cg_swingAngles
import cg_zoomFov
import cg_fov
import cg_simpleItems
import cg_ignore
import cg_autoswitch
import cg_tracerLength
import cg_tracerWidth
import cg_tracerChance
import cg_viewsize
import cg_drawGun
import cg_gun_z
import cg_gun_y
import cg_gun_x
import cg_gun_frame
import cg_addMarks
import cg_footsteps
import cg_showmiss
import cg_noPlayerAnims
import cg_nopredict
import cg_errorDecay
import cg_debugEvents
import cg_debugPosition
import cg_debugAnim
import cg_animSpeed
import cg_draw2D
import cg_drawStatus
import cg_crosshairHealth
import cg_crosshairSize
import cg_crosshairY
import cg_crosshairX
import cg_teamOverlayUserinfo
import cg_drawTeamOverlay
import cg_drawRewards
import cg_dynamicCrosshair
import cg_drawScores
import cg_drawCrosshairNames
import cg_drawCrosshair
import cg_drawAmmoWarning
import cg_drawIcons
import cg_draw3dIcons
import cg_drawSnapshot
import cg_drawFPS
import cg_drawTimer
import cg_shadows
import cg_bobroll
import cg_bobpitch
import cg_bobup
import cg_runroll
import cg_runpitch
import cg_centertime
import cg_vehicleTemplates
import cg_vehicles
import VehicleInfo_GetNameForMovementType
import VehicleInfo_GetBitForMovementType
import VehicleInfo_GetNameForWeapon
import VehicleInfo_GetIndexForWeapon
import VehicleInfo_GetBitForWeapon
import VehicleInfo_GetBitForVehicleType
import Vehicle_CopyVehicle
import Vehicle_InitVehicle
import cg_markPolys
import cg_items
import cg_weapons
import cg_entities
import cg
import cgs
import CGCam_SetMusicMult
import CGCam_Shake
import cgScreenEffects
import ammoTicPos
import forceTicPos
import forcePowerDarkLight
import WeaponAttackAnim
import WeaponReadyAnim
import BG_OutOfMemory
import BG_StringAlloc
import BG_TempFree
import BG_TempAlloc
import BG_AllocUnaligned
import BG_Alloc
import BG_CanUseFPNow
import BG_HasYsalamiri
import BG_GetItemIndexByTag
import BG_ParseAnimationFile
import BG_PlayerTouchesItem
import BG_PlayerStateToEntityStateExtraPolate
import BG_PlayerStateToEntityState
import BG_TouchJumpPad
import BG_AddPredictableEventToPlayerstate
import BG_EvaluateTrajectoryDelta
import BG_EvaluateTrajectory
import BG_ForcePowerDrain
import BG_SaberStartTransAnim
import BG_InDeathAnim
import BG_InRoll
import BG_KnockawayForParry
import BG_BrokenParryForParry
import BG_BrokenParryForAttack
import BG_SaberInSpecialAttack
import BG_SpinningSaberAnim
import BG_FlippingAnim
import BG_SaberInIdle
import BG_SaberInSpecial
import BG_SaberInAttack
import BG_DirectFlippingAnim
import BG_InSaberStandAnim
import BG_InSpecialJump
import BG_LegalizedForcePowers
import saberMoveData
import BG_CanItemBeGrabbed
import BG_FindItemForHoldable
import BG_FindItemForPowerup
import BG_FindItemForWeapon
import BG_FindItem
import vectoyaw
import bg_numItems
import bg_itemlist
import PM_CalculateRelativeViewAngles
import Pmove
import PM_QuaternionViewAngles
import PM_UpdateViewAngles
import pm
import bgForcePowerCost
import forceMasteryPoints
import forceMasteryLevels
import bgGlobalAnimations
import BGPAFtextLoaded
import forcePowerSorted
import WP_MuzzlePoint
import ammoData
import weaponData
import GetStringForID
import GetIDForString
import Q_irand
import irand
import flrand
import Rand_Init
import Com_Printf
import Com_Error
import Info_NextPair
import Info_Validate
import Info_SetValueForKey_Big
import Info_SetValueForKey
import Info_RemoveKey_big
import Info_RemoveKey
import Info_ValueForKey
import va
import Q_CleanStr
import Q_PrintStrlen
import Q_strcat
import Q_strncpyz
import Q_strrchr
import Q_strupr
import Q_strlwr
import Q_stricmpn
import Q_strncmp
import Q_stricmp
import Q_isalpha
import Q_isupper
import Q_islower
import Q_isprint
import Com_sprintf
import Parse3DMatrix
import Parse2DMatrix
import Parse1DMatrix
import SkipRestOfLine
import SkipBracedSection
import COM_MatchToken
import COM_ParseVec4
import COM_ParseFloat
import COM_ParseInt
import COM_ParseString
import COM_ParseWarning
import COM_ParseError
import COM_Compress
import COM_ParseExt
import COM_Parse
import SkipWhitespace
import COM_GetCurrentParseLine
import COM_BeginParseSession
import COM_DefaultExtension
import COM_StripExtension
import COM_SkipPath
import Com_Clamp
import MatrixToEuler
import QuatToAngles
import QuatMul
import AnglesToQuat
import AxisToQuaternion
import QuaternionToAxis
import QuaternionToEuler
import QuatToAxis
import QuaternionMultiply
import QuaternionNormalize
import QuaternionMagnitude
import QuaternionFromString
import AnglesToTieFloats
import AnglesFromTieFloats
import QuaternionToTieFloats
import QuaternionFromTieFloats
import QuaternionCopy
import PerpendicularVector
import AngleVectors
import RotationMatrixAroundDir
import MatrixMultiply
import MakeNormalVectors
import RotateAroundDirection
import RotatePointAroundVector
import ProjectPointOnPlane
import PlaneFromPoints
import AngleDelta
import AngleNormalize180
import AngleNormalize360
import AnglesSubtract
import AngleSubtract
import LerpAngle
import AngleMod
import BoxOnPlaneSide
import SetPlaneSignbits
import AxisCopy
import AxisClear
import AnglesToAxis
import vectoangles
import Q_crandom
import Q_random
import Q_rand
import Q_acos
import Q_log2
import VectorRotate
import Vector4Scale
import VectorNormalize2
import VectorNormalize
import CrossProduct
import VectorInverse
import VectorNormalizeFast
import DistanceSquared
import Distance
import VectorLengthSquared
import VectorLength
import VectorCompare
import AddPointToBounds
import ClearBounds
import RadiusFromBounds
import NormalizeColor
import ColorBytes4
import ColorBytes3
import _VectorMA
import _VectorScale
import _VectorCopy
import _VectorAdd
import _VectorSubtract
import _DotProduct
import ByteToDir
import DirToByte
import powf
import ClampShort
import ClampChar
import Q_rsqrt
import Q_fabs
import axisDefault
import vec3_origin
import g_color_table
import colorDkBlue
import colorLtBlue
import colorDkGrey
import colorMdGrey
import colorLtGrey
import colorWhite
import colorCyan
import colorMagenta
import colorYellow
import colorBlue
import colorGreen
import colorRed
import colorBlack
import colorTable
import bytedirs
import Com_Memcpy
import Com_Memset
import Hunk_Alloc
import forceSpeedLevels
import FloatSwap
import LongSwap
import ShortSwap
import acos
import fabs
import abs
import tan
import atan2
import cos
import sin
import sqrt
import floor
import ceil
import memcpy
import memset
import memmove
import sscanf
import vsprintf
import _atoi
import atoi
import _atof
import atof
import toupper
import tolower
import strncpy
import strstr
import strchr
import strcmp
import strcpy
import strcat
import strlen
import rand
import srand
import qsort
lit
align 1
LABELV $1336
byte 1 115
byte 1 111
byte 1 117
byte 1 110
byte 1 100
byte 1 47
byte 1 119
byte 1 101
byte 1 97
byte 1 112
byte 1 111
byte 1 110
byte 1 115
byte 1 47
byte 1 115
byte 1 97
byte 1 98
byte 1 101
byte 1 114
byte 1 47
byte 1 115
byte 1 97
byte 1 98
byte 1 101
byte 1 114
byte 1 111
byte 1 110
byte 1 46
byte 1 119
byte 1 97
byte 1 118
byte 1 0
align 1
LABELV $1332
byte 1 115
byte 1 111
byte 1 117
byte 1 110
byte 1 100
byte 1 47
byte 1 119
byte 1 101
byte 1 97
byte 1 112
byte 1 111
byte 1 110
byte 1 115
byte 1 47
byte 1 115
byte 1 97
byte 1 98
byte 1 101
byte 1 114
byte 1 47
byte 1 115
byte 1 97
byte 1 98
byte 1 101
byte 1 114
byte 1 111
byte 1 102
byte 1 102
byte 1 113
byte 1 117
byte 1 105
byte 1 99
byte 1 107
byte 1 46
byte 1 119
byte 1 97
byte 1 118
byte 1 0
align 1
LABELV $1300
byte 1 42
byte 1 102
byte 1 108
byte 1 97
byte 1 115
byte 1 104
byte 1 0
align 1
LABELV $1000
byte 1 100
byte 1 101
byte 1 109
byte 1 112
byte 1 50
byte 1 47
byte 1 97
byte 1 108
byte 1 116
byte 1 68
byte 1 101
byte 1 116
byte 1 111
byte 1 110
byte 1 97
byte 1 116
byte 1 101
byte 1 46
byte 1 101
byte 1 102
byte 1 120
byte 1 0
align 1
LABELV $925
byte 1 67
byte 1 71
byte 1 95
byte 1 70
byte 1 105
byte 1 114
byte 1 101
byte 1 87
byte 1 101
byte 1 97
byte 1 112
byte 1 111
byte 1 110
byte 1 58
byte 1 32
byte 1 101
byte 1 110
byte 1 116
byte 1 45
byte 1 62
byte 1 119
byte 1 101
byte 1 97
byte 1 112
byte 1 111
byte 1 110
byte 1 32
byte 1 62
byte 1 61
byte 1 32
byte 1 87
byte 1 80
byte 1 95
byte 1 78
byte 1 85
byte 1 77
byte 1 95
byte 1 87
byte 1 69
byte 1 65
byte 1 80
byte 1 79
byte 1 78
byte 1 83
byte 1 0
align 1
LABELV $906
byte 1 115
byte 1 111
byte 1 117
byte 1 110
byte 1 100
byte 1 47
byte 1 119
byte 1 101
byte 1 97
byte 1 112
byte 1 111
byte 1 110
byte 1 115
byte 1 47
byte 1 97
byte 1 116
byte 1 115
byte 1 116
byte 1 47
byte 1 65
byte 1 84
byte 1 83
byte 1 84
byte 1 102
byte 1 105
byte 1 114
byte 1 101
byte 1 49
byte 1 46
byte 1 119
byte 1 97
byte 1 118
byte 1 0
align 1
LABELV $849
byte 1 115
byte 1 118
byte 1 95
byte 1 115
byte 1 97
byte 1 98
byte 1 101
byte 1 114
byte 1 115
byte 1 119
byte 1 105
byte 1 116
byte 1 99
byte 1 104
byte 1 0
align 1
LABELV $767
byte 1 73
byte 1 78
byte 1 71
byte 1 65
byte 1 77
byte 1 69
byte 1 95
byte 1 37
byte 1 115
byte 1 0
align 1
LABELV $294
byte 1 116
byte 1 97
byte 1 103
byte 1 95
byte 1 102
byte 1 108
byte 1 97
byte 1 115
byte 1 104
byte 1 0
align 1
LABELV $283
byte 1 116
byte 1 97
byte 1 103
byte 1 95
byte 1 98
byte 1 97
byte 1 114
byte 1 114
byte 1 101
byte 1 108
byte 1 51
byte 1 0
align 1
LABELV $282
byte 1 116
byte 1 97
byte 1 103
byte 1 95
byte 1 98
byte 1 97
byte 1 114
byte 1 114
byte 1 101
byte 1 108
byte 1 50
byte 1 0
align 1
LABELV $279
byte 1 116
byte 1 97
byte 1 103
byte 1 95
byte 1 98
byte 1 97
byte 1 114
byte 1 114
byte 1 101
byte 1 108
byte 1 0
align 1
LABELV $273
byte 1 109
byte 1 111
byte 1 100
byte 1 101
byte 1 108
byte 1 115
byte 1 47
byte 1 119
byte 1 101
byte 1 97
byte 1 112
byte 1 111
byte 1 110
byte 1 115
byte 1 50
byte 1 47
byte 1 115
byte 1 116
byte 1 117
byte 1 110
byte 1 95
byte 1 98
byte 1 97
byte 1 116
byte 1 111
byte 1 110
byte 1 47
byte 1 98
byte 1 97
byte 1 116
byte 1 111
byte 1 110
byte 1 95
byte 1 98
byte 1 97
byte 1 114
byte 1 114
byte 1 101
byte 1 108
byte 1 51
byte 1 46
byte 1 109
byte 1 100
byte 1 51
byte 1 0
align 1
LABELV $271
byte 1 109
byte 1 111
byte 1 100
byte 1 101
byte 1 108
byte 1 115
byte 1 47
byte 1 119
byte 1 101
byte 1 97
byte 1 112
byte 1 111
byte 1 110
byte 1 115
byte 1 50
byte 1 47
byte 1 115
byte 1 116
byte 1 117
byte 1 110
byte 1 95
byte 1 98
byte 1 97
byte 1 116
byte 1 111
byte 1 110
byte 1 47
byte 1 98
byte 1 97
byte 1 116
byte 1 111
byte 1 110
byte 1 95
byte 1 98
byte 1 97
byte 1 114
byte 1 114
byte 1 101
byte 1 108
byte 1 50
byte 1 46
byte 1 109
byte 1 100
byte 1 51
byte 1 0
align 1
LABELV $267
byte 1 109
byte 1 111
byte 1 100
byte 1 101
byte 1 108
byte 1 115
byte 1 47
byte 1 119
byte 1 101
byte 1 97
byte 1 112
byte 1 111
byte 1 110
byte 1 115
byte 1 50
byte 1 47
byte 1 115
byte 1 116
byte 1 117
byte 1 110
byte 1 95
byte 1 98
byte 1 97
byte 1 116
byte 1 111
byte 1 110
byte 1 47
byte 1 98
byte 1 97
byte 1 116
byte 1 111
byte 1 110
byte 1 95
byte 1 98
byte 1 97
byte 1 114
byte 1 114
byte 1 101
byte 1 108
byte 1 46
byte 1 109
byte 1 100
byte 1 51
byte 1 0
align 1
LABELV $251
byte 1 116
byte 1 97
byte 1 103
byte 1 95
byte 1 119
byte 1 101
byte 1 97
byte 1 112
byte 1 111
byte 1 110
byte 1 0
align 1
LABELV $149
byte 1 46
byte 1 103
byte 1 108
byte 1 109
byte 1 0
align 1
LABELV $136
byte 1 67
byte 1 71
byte 1 95
byte 1 82
byte 1 101
byte 1 103
byte 1 105
byte 1 115
byte 1 116
byte 1 101
byte 1 114
byte 1 73
byte 1 116
byte 1 101
byte 1 109
byte 1 86
byte 1 105
byte 1 115
byte 1 117
byte 1 97
byte 1 108
byte 1 115
byte 1 58
byte 1 32
byte 1 105
byte 1 116
byte 1 101
byte 1 109
byte 1 78
byte 1 117
byte 1 109
byte 1 32
byte 1 37
byte 1 100
byte 1 32
byte 1 111
byte 1 117
byte 1 116
byte 1 32
byte 1 111
byte 1 102
byte 1 32
byte 1 114
byte 1 97
byte 1 110
byte 1 103
byte 1 101
byte 1 32
byte 1 91
byte 1 48
byte 1 45
byte 1 37
byte 1 100
byte 1 93
byte 1 0
