export CG_TestModel_f
code
proc CG_TestModel_f 36 12
file "../cg_view.c"
line 58
;1:// Copyright (C) 1999-2000 Id Software, Inc.
;2://
;3:// cg_view.c -- setup all the parameters (position, angle, etc)
;4:// for a 3D rendering
;5:#include "cg_local.h"
;6:
;7:#if !defined(CL_LIGHT_H_INC)
;8:	#include "cg_lights.h"
;9:#endif
;10:
;11:#define MASK_CAMERACLIP (MASK_SOLID|CONTENTS_PLAYERCLIP)
;12:#define CAMERA_SIZE	4
;13:
;14:
;15:/*
;16:=============================================================================
;17:
;18:  MODEL TESTING
;19:
;20:The viewthing and gun positioning tools from Q2 have been integrated and
;21:enhanced into a single model testing facility.
;22:
;23:Model viewing can begin with either "testmodel <modelname>" or "testgun <modelname>".
;24:
;25:The names must be the full pathname after the basedir, like 
;26:"models/weapons/v_launch/tris.md3" or "players/male/tris.md3"
;27:
;28:Testmodel will create a fake entity 100 units in front of the current view
;29:position, directly facing the viewer.  It will remain immobile, so you can
;30:move around it to view it from different angles.
;31:
;32:Testgun will cause the model to follow the player around and supress the real
;33:view weapon model.  The default frame 0 of most guns is completely off screen,
;34:so you will probably have to cycle a couple frames to see it.
;35:
;36:"nextframe", "prevframe", "nextskin", and "prevskin" commands will change the
;37:frame or skin of the testmodel.  These are bound to F5, F6, F7, and F8 in
;38:q3default.cfg.
;39:
;40:If a gun is being tested, the "gun_x", "gun_y", and "gun_z" variables will let
;41:you adjust the positioning.
;42:
;43:Note that none of the model testing features update while the game is paused, so
;44:it may be convenient to test with deathmatch set to 1 so that bringing down the
;45:console doesn't pause the game.
;46:
;47:=============================================================================
;48:*/
;49:
;50:/*
;51:=================
;52:CG_TestModel_f
;53:
;54:Creates an entity in front of the current position, which
;55:can then be moved around
;56:=================
;57:*/
;58:void CG_TestModel_f (void) {
line 61
;59:	vec3_t		angles;
;60:
;61:	memset( &cg.testModelEntity, 0, sizeof(cg.testModelEntity) );
ADDRGP4 cg+13484
ARGP4
CNSTI4 0
ARGI4
CNSTI4 212
ARGI4
ADDRGP4 memset
CALLP4
pop
line 62
;62:	if ( trap_Argc() < 2 ) {
ADDRLP4 12
ADDRGP4 trap_Argc
CALLI4
ASGNI4
ADDRLP4 12
INDIRI4
CNSTI4 2
GEI4 $135
line 63
;63:		return;
ADDRGP4 $132
JUMPV
LABELV $135
line 66
;64:	}
;65:
;66:	Q_strncpyz (cg.testModelName, CG_Argv( 1 ), MAX_QPATH );
CNSTI4 1
ARGI4
ADDRLP4 16
ADDRGP4 CG_Argv
CALLP4
ASGNP4
ADDRGP4 cg+13696
ARGP4
ADDRLP4 16
INDIRP4
ARGP4
CNSTI4 64
ARGI4
ADDRGP4 Q_strncpyz
CALLV
pop
line 67
;67:	cg.testModelEntity.hModel = trap_R_RegisterModel( cg.testModelName );
ADDRGP4 cg+13696
ARGP4
ADDRLP4 20
ADDRGP4 trap_R_RegisterModel
CALLI4
ASGNI4
ADDRGP4 cg+13484+8
ADDRLP4 20
INDIRI4
ASGNI4
line 69
;68:
;69:	if ( trap_Argc() == 3 ) {
ADDRLP4 24
ADDRGP4 trap_Argc
CALLI4
ASGNI4
ADDRLP4 24
INDIRI4
CNSTI4 3
NEI4 $141
line 70
;70:		cg.testModelEntity.backlerp = atof( CG_Argv( 2 ) );
CNSTI4 2
ARGI4
ADDRLP4 28
ADDRGP4 CG_Argv
CALLP4
ASGNP4
ADDRLP4 28
INDIRP4
ARGP4
ADDRLP4 32
ADDRGP4 atof
CALLF4
ASGNF4
ADDRGP4 cg+13484+128
ADDRLP4 32
INDIRF4
ASGNF4
line 71
;71:		cg.testModelEntity.frame = 1;
ADDRGP4 cg+13484+104
CNSTI4 1
ASGNI4
line 72
;72:		cg.testModelEntity.oldframe = 0;
ADDRGP4 cg+13484+124
CNSTI4 0
ASGNI4
line 73
;73:	}
LABELV $141
line 74
;74:	if (! cg.testModelEntity.hModel ) {
ADDRGP4 cg+13484+8
INDIRI4
CNSTI4 0
NEI4 $149
line 75
;75:		CG_Printf( "Can't register model\n" );
ADDRGP4 $153
ARGP4
ADDRGP4 CG_Printf
CALLV
pop
line 76
;76:		return;
ADDRGP4 $132
JUMPV
LABELV $149
line 79
;77:	}
;78:
;79:	VectorMA( cg.refdef.vieworg, 100, cg.refdef.viewaxis[0], cg.testModelEntity.origin );
ADDRGP4 cg+13484+52
ADDRGP4 cg+3616+24
INDIRF4
CNSTF4 1120403456
ADDRGP4 cg+3616+36
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRGP4 cg+13484+52+4
ADDRGP4 cg+3616+24+4
INDIRF4
CNSTF4 1120403456
ADDRGP4 cg+3616+36+4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRGP4 cg+13484+52+8
ADDRGP4 cg+3616+24+8
INDIRF4
CNSTF4 1120403456
ADDRGP4 cg+3616+36+8
INDIRF4
MULF4
ADDF4
ASGNF4
line 81
;80:
;81:	angles[PITCH] = 0;
ADDRLP4 0
CNSTF4 0
ASGNF4
line 82
;82:	angles[YAW] = 180 + cg.refdefViewAngles[1];
ADDRLP4 0+4
ADDRGP4 cg+3984+4
INDIRF4
CNSTF4 1127481344
ADDF4
ASGNF4
line 83
;83:	angles[ROLL] = 0;
ADDRLP4 0+8
CNSTF4 0
ASGNF4
line 85
;84:
;85:	AnglesToAxis( angles, cg.testModelEntity.axis );
ADDRLP4 0
ARGP4
ADDRGP4 cg+13484+12
ARGP4
ADDRGP4 AnglesToAxis
CALLV
pop
line 86
;86:	cg.testGun = qfalse;
ADDRGP4 cg+13760
CNSTI4 0
ASGNI4
line 87
;87:}
LABELV $132
endproc CG_TestModel_f 36 12
export CG_TestGun_f
proc CG_TestGun_f 0 0
line 96
;88:
;89:/*
;90:=================
;91:CG_TestGun_f
;92:
;93:Replaces the current view weapon with the given model
;94:=================
;95:*/
;96:void CG_TestGun_f (void) {
line 97
;97:	CG_TestModel_f();
ADDRGP4 CG_TestModel_f
CALLV
pop
line 98
;98:	cg.testGun = qtrue;
ADDRGP4 cg+13760
CNSTI4 1
ASGNI4
line 102
;99:	//cg.testModelEntity.renderfx = RF_MINLIGHT | RF_DEPTHHACK | RF_FIRST_PERSON;
;100:
;101:	// rww - 9-13-01 [1-26-01-sof2]
;102:	cg.testModelEntity.renderfx = RF_DEPTHHACK | RF_FIRST_PERSON;
ADDRGP4 cg+13484+4
CNSTI4 12
ASGNI4
line 103
;103:}
LABELV $185
endproc CG_TestGun_f 0 0
export CG_TestModelNextFrame_f
proc CG_TestModelNextFrame_f 4 8
line 106
;104:
;105:
;106:void CG_TestModelNextFrame_f (void) {
line 107
;107:	cg.testModelEntity.frame++;
ADDRLP4 0
ADDRGP4 cg+13484+104
ASGNP4
ADDRLP4 0
INDIRP4
ADDRLP4 0
INDIRP4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 108
;108:	CG_Printf( "frame %i\n", cg.testModelEntity.frame );
ADDRGP4 $192
ARGP4
ADDRGP4 cg+13484+104
INDIRI4
ARGI4
ADDRGP4 CG_Printf
CALLV
pop
line 109
;109:}
LABELV $189
endproc CG_TestModelNextFrame_f 4 8
export CG_TestModelPrevFrame_f
proc CG_TestModelPrevFrame_f 4 8
line 111
;110:
;111:void CG_TestModelPrevFrame_f (void) {
line 112
;112:	cg.testModelEntity.frame--;
ADDRLP4 0
ADDRGP4 cg+13484+104
ASGNP4
ADDRLP4 0
INDIRP4
ADDRLP4 0
INDIRP4
INDIRI4
CNSTI4 1
SUBI4
ASGNI4
line 113
;113:	if ( cg.testModelEntity.frame < 0 ) {
ADDRGP4 cg+13484+104
INDIRI4
CNSTI4 0
GEI4 $198
line 114
;114:		cg.testModelEntity.frame = 0;
ADDRGP4 cg+13484+104
CNSTI4 0
ASGNI4
line 115
;115:	}
LABELV $198
line 116
;116:	CG_Printf( "frame %i\n", cg.testModelEntity.frame );
ADDRGP4 $192
ARGP4
ADDRGP4 cg+13484+104
INDIRI4
ARGI4
ADDRGP4 CG_Printf
CALLV
pop
line 117
;117:}
LABELV $195
endproc CG_TestModelPrevFrame_f 4 8
export CG_TestModelNextSkin_f
proc CG_TestModelNextSkin_f 4 8
line 119
;118:
;119:void CG_TestModelNextSkin_f (void) {
line 120
;120:	cg.testModelEntity.skinNum++;
ADDRLP4 0
ADDRGP4 cg+13484+132
ASGNP4
ADDRLP4 0
INDIRP4
ADDRLP4 0
INDIRP4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 121
;121:	CG_Printf( "skin %i\n", cg.testModelEntity.skinNum );
ADDRGP4 $209
ARGP4
ADDRGP4 cg+13484+132
INDIRI4
ARGI4
ADDRGP4 CG_Printf
CALLV
pop
line 122
;122:}
LABELV $206
endproc CG_TestModelNextSkin_f 4 8
export CG_TestModelPrevSkin_f
proc CG_TestModelPrevSkin_f 4 8
line 124
;123:
;124:void CG_TestModelPrevSkin_f (void) {
line 125
;125:	cg.testModelEntity.skinNum--;
ADDRLP4 0
ADDRGP4 cg+13484+132
ASGNP4
ADDRLP4 0
INDIRP4
ADDRLP4 0
INDIRP4
INDIRI4
CNSTI4 1
SUBI4
ASGNI4
line 126
;126:	if ( cg.testModelEntity.skinNum < 0 ) {
ADDRGP4 cg+13484+132
INDIRI4
CNSTI4 0
GEI4 $215
line 127
;127:		cg.testModelEntity.skinNum = 0;
ADDRGP4 cg+13484+132
CNSTI4 0
ASGNI4
line 128
;128:	}
LABELV $215
line 129
;129:	CG_Printf( "skin %i\n", cg.testModelEntity.skinNum );
ADDRGP4 $209
ARGP4
ADDRGP4 cg+13484+132
INDIRI4
ARGI4
ADDRGP4 CG_Printf
CALLV
pop
line 130
;130:}
LABELV $212
endproc CG_TestModelPrevSkin_f 4 8
proc CG_AddTestModel 32 4
line 132
;131:
;132:static void CG_AddTestModel (void) {
line 136
;133:	int		i;
;134:
;135:	// re-register the model, because the level may have changed
;136:	cg.testModelEntity.hModel = trap_R_RegisterModel( cg.testModelName );
ADDRGP4 cg+13696
ARGP4
ADDRLP4 4
ADDRGP4 trap_R_RegisterModel
CALLI4
ASGNI4
ADDRGP4 cg+13484+8
ADDRLP4 4
INDIRI4
ASGNI4
line 137
;137:	if (! cg.testModelEntity.hModel ) {
ADDRGP4 cg+13484+8
INDIRI4
CNSTI4 0
NEI4 $227
line 138
;138:		CG_Printf ("Can't register model\n");
ADDRGP4 $153
ARGP4
ADDRGP4 CG_Printf
CALLV
pop
line 139
;139:		return;
ADDRGP4 $223
JUMPV
LABELV $227
line 143
;140:	}
;141:
;142:	// if testing a gun, set the origin reletive to the view origin
;143:	if ( cg.testGun ) {
ADDRGP4 cg+13760
INDIRI4
CNSTI4 0
EQI4 $231
line 144
;144:		VectorCopy( cg.refdef.vieworg, cg.testModelEntity.origin );
ADDRGP4 cg+13484+52
ADDRGP4 cg+3616+24
INDIRB
ASGNB 12
line 145
;145:		VectorCopy( cg.refdef.viewaxis[0], cg.testModelEntity.axis[0] );
ADDRGP4 cg+13484+12
ADDRGP4 cg+3616+36
INDIRB
ASGNB 12
line 146
;146:		VectorCopy( cg.refdef.viewaxis[1], cg.testModelEntity.axis[1] );
ADDRGP4 cg+13484+12+12
ADDRGP4 cg+3616+36+12
INDIRB
ASGNB 12
line 147
;147:		VectorCopy( cg.refdef.viewaxis[2], cg.testModelEntity.axis[2] );
ADDRGP4 cg+13484+12+24
ADDRGP4 cg+3616+36+24
INDIRB
ASGNB 12
line 150
;148:
;149:		// allow the position to be adjusted
;150:		for (i=0 ; i<3 ; i++) {
ADDRLP4 0
CNSTI4 0
ASGNI4
LABELV $254
line 151
;151:			cg.testModelEntity.origin[i] += cg.refdef.viewaxis[0][i] * cg_gun_x.value;
ADDRLP4 8
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ASGNI4
ADDRLP4 12
ADDRLP4 8
INDIRI4
ADDRGP4 cg+13484+52
ADDP4
ASGNP4
ADDRLP4 12
INDIRP4
ADDRLP4 12
INDIRP4
INDIRF4
ADDRLP4 8
INDIRI4
ADDRGP4 cg+3616+36
ADDP4
INDIRF4
ADDRGP4 cg_gun_x+8
INDIRF4
MULF4
ADDF4
ASGNF4
line 152
;152:			cg.testModelEntity.origin[i] += cg.refdef.viewaxis[1][i] * cg_gun_y.value;
ADDRLP4 16
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ASGNI4
ADDRLP4 20
ADDRLP4 16
INDIRI4
ADDRGP4 cg+13484+52
ADDP4
ASGNP4
ADDRLP4 20
INDIRP4
ADDRLP4 20
INDIRP4
INDIRF4
ADDRLP4 16
INDIRI4
ADDRGP4 cg+3616+36+12
ADDP4
INDIRF4
ADDRGP4 cg_gun_y+8
INDIRF4
MULF4
ADDF4
ASGNF4
line 153
;153:			cg.testModelEntity.origin[i] += cg.refdef.viewaxis[2][i] * cg_gun_z.value;
ADDRLP4 24
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ASGNI4
ADDRLP4 28
ADDRLP4 24
INDIRI4
ADDRGP4 cg+13484+52
ADDP4
ASGNP4
ADDRLP4 28
INDIRP4
ADDRLP4 28
INDIRP4
INDIRF4
ADDRLP4 24
INDIRI4
ADDRGP4 cg+3616+36+24
ADDP4
INDIRF4
ADDRGP4 cg_gun_z+8
INDIRF4
MULF4
ADDF4
ASGNF4
line 154
;154:		}
LABELV $255
line 150
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 3
LTI4 $254
line 155
;155:	}
LABELV $231
line 157
;156:
;157:	trap_R_AddRefEntityToScene( &cg.testModelEntity );
ADDRGP4 cg+13484
ARGP4
ADDRGP4 trap_R_AddRefEntityToScene
CALLV
pop
line 158
;158:}
LABELV $223
endproc CG_AddTestModel 32 4
proc CG_CalcVrect 12 8
line 172
;159:
;160:
;161:
;162://============================================================================
;163:
;164:
;165:/*
;166:=================
;167:CG_CalcVrect
;168:
;169:Sets the coordinates of the rendered window
;170:=================
;171:*/
;172:static void CG_CalcVrect (void) {
line 176
;173:	int		size;
;174:
;175:	// the intermission should allways be full screen
;176:	if ( cg.snap->ps.pm_type == PM_INTERMISSION ) {
ADDRGP4 cg+36
INDIRP4
CNSTI4 48
ADDP4
INDIRI4
CNSTI4 6
NEI4 $277
line 177
;177:		size = 100;
ADDRLP4 0
CNSTI4 100
ASGNI4
line 178
;178:	} else {
ADDRGP4 $278
JUMPV
LABELV $277
line 180
;179:		// bound normal viewsize
;180:		if (cg_viewsize.integer < 30) {
ADDRGP4 cg_viewsize+12
INDIRI4
CNSTI4 30
GEI4 $280
line 181
;181:			trap_Cvar_Set ("cg_viewsize","30");
ADDRGP4 $283
ARGP4
ADDRGP4 $284
ARGP4
ADDRGP4 trap_Cvar_Set
CALLV
pop
line 182
;182:			size = 30;
ADDRLP4 0
CNSTI4 30
ASGNI4
line 183
;183:		} else if (cg_viewsize.integer > 100) {
ADDRGP4 $281
JUMPV
LABELV $280
ADDRGP4 cg_viewsize+12
INDIRI4
CNSTI4 100
LEI4 $285
line 184
;184:			trap_Cvar_Set ("cg_viewsize","100");
ADDRGP4 $283
ARGP4
ADDRGP4 $288
ARGP4
ADDRGP4 trap_Cvar_Set
CALLV
pop
line 185
;185:			size = 100;
ADDRLP4 0
CNSTI4 100
ASGNI4
line 186
;186:		} else {
ADDRGP4 $286
JUMPV
LABELV $285
line 187
;187:			size = cg_viewsize.integer;
ADDRLP4 0
ADDRGP4 cg_viewsize+12
INDIRI4
ASGNI4
line 188
;188:		}
LABELV $286
LABELV $281
line 190
;189:
;190:	}
LABELV $278
line 191
;191:	cg.refdef.width = cgs.glconfig.vidWidth*size/100;
ADDRGP4 cg+3616+8
ADDRGP4 cgs+21604+11304
INDIRI4
ADDRLP4 0
INDIRI4
MULI4
CNSTI4 100
DIVI4
ASGNI4
line 192
;192:	cg.refdef.width &= ~1;
ADDRLP4 4
ADDRGP4 cg+3616+8
ASGNP4
ADDRLP4 4
INDIRP4
ADDRLP4 4
INDIRP4
INDIRI4
CNSTI4 -2
BANDI4
ASGNI4
line 194
;193:
;194:	cg.refdef.height = cgs.glconfig.vidHeight*size/100;
ADDRGP4 cg+3616+12
ADDRGP4 cgs+21604+11308
INDIRI4
ADDRLP4 0
INDIRI4
MULI4
CNSTI4 100
DIVI4
ASGNI4
line 195
;195:	cg.refdef.height &= ~1;
ADDRLP4 8
ADDRGP4 cg+3616+12
ASGNP4
ADDRLP4 8
INDIRP4
ADDRLP4 8
INDIRP4
INDIRI4
CNSTI4 -2
BANDI4
ASGNI4
line 197
;196:
;197:	cg.refdef.x = (cgs.glconfig.vidWidth - cg.refdef.width)/2;
ADDRGP4 cg+3616
ADDRGP4 cgs+21604+11304
INDIRI4
ADDRGP4 cg+3616+8
INDIRI4
SUBI4
CNSTI4 2
DIVI4
ASGNI4
line 198
;198:	cg.refdef.y = (cgs.glconfig.vidHeight - cg.refdef.height)/2;
ADDRGP4 cg+3616+4
ADDRGP4 cgs+21604+11308
INDIRI4
ADDRGP4 cg+3616+12
INDIRI4
SUBI4
CNSTI4 2
DIVI4
ASGNI4
line 199
;199:}
LABELV $276
endproc CG_CalcVrect 12 8
proc CG_StepOffset 8 0
line 206
;200:
;201://==============================================================================
;202:
;203://==============================================================================
;204://==============================================================================
;205:// this causes a compiler bug on mac MrC compiler
;206:static void CG_StepOffset( void ) {
line 210
;207:	int		timeDelta;
;208:	
;209:	// smooth out stair climbing
;210:	timeDelta = cg.time - cg.stepTime;
ADDRLP4 0
ADDRGP4 cg+64
INDIRI4
ADDRGP4 cg+3488
INDIRI4
SUBI4
ASGNI4
line 211
;211:	if ( timeDelta < STEP_TIME ) {
ADDRLP4 0
INDIRI4
CNSTI4 200
GEI4 $316
line 212
;212:		cg.refdef.vieworg[2] -= cg.stepChange 
ADDRLP4 4
ADDRGP4 cg+3616+24+8
ASGNP4
ADDRLP4 4
INDIRP4
ADDRLP4 4
INDIRP4
INDIRF4
ADDRGP4 cg+3484
INDIRF4
CNSTI4 200
ADDRLP4 0
INDIRI4
SUBI4
CVIF4 4
MULF4
CNSTF4 1128792064
DIVF4
SUBF4
ASGNF4
line 214
;213:			* (STEP_TIME - timeDelta) / STEP_TIME;
;214:	}
LABELV $316
line 215
;215:}
LABELV $313
endproc CG_StepOffset 8 0
data
align 4
LABELV cameramins
byte 4 3229614080
byte 4 3229614080
byte 4 3229614080
align 4
LABELV cameramaxs
byte 4 1082130432
byte 4 1082130432
byte 4 1082130432
export cameraCurTarget
align 4
LABELV cameraCurTarget
byte 4 0
byte 4 0
byte 4 0
export cameraCurLoc
align 4
LABELV cameraCurLoc
byte 4 0
byte 4 0
byte 4 0
export cameraOldLoc
align 4
LABELV cameraOldLoc
byte 4 0
byte 4 0
byte 4 0
export cameraNewLoc
align 4
LABELV cameraNewLoc
byte 4 0
byte 4 0
byte 4 0
export cameraLastFrame
align 4
LABELV cameraLastFrame
byte 4 0
export cameraLastYaw
align 4
LABELV cameraLastYaw
byte 4 0
export cameraStiffFactor
align 4
LABELV cameraStiffFactor
byte 4 0
code
proc CG_CalcIdealThirdPersonViewTarget 12 0
line 256
;216:
;217:#define CAMERA_DAMP_INTERVAL	50
;218:
;219:static vec3_t	cameramins = { -CAMERA_SIZE, -CAMERA_SIZE, -CAMERA_SIZE };
;220:static vec3_t	cameramaxs = { CAMERA_SIZE, CAMERA_SIZE, CAMERA_SIZE };
;221:vec3_t	camerafwd, cameraup;
;222:
;223:vec3_t	cameraFocusAngles,			cameraFocusLoc;
;224:vec3_t	cameraIdealTarget,			cameraIdealLoc;
;225:vec3_t	cameraCurTarget={0,0,0},	cameraCurLoc={0,0,0};
;226:vec3_t	cameraOldLoc={0,0,0},		cameraNewLoc={0,0,0};
;227:int		cameraLastFrame=0;
;228:
;229:float	cameraLastYaw=0;
;230:float	cameraStiffFactor=0.0f;
;231:
;232:/*
;233:===============
;234:Notes on the camera viewpoint in and out...
;235:
;236:cg.refdef.vieworg
;237:--at the start of the function holds the player actor's origin (center of player model).
;238:--it is set to the final view location of the camera at the end of the camera code.
;239:cg.refdefViewAngles
;240:--at the start holds the client's view angles
;241:--it is set to the final view angle of the camera at the end of the camera code.
;242:
;243:===============
;244:*/
;245:  
;246:extern qboolean gCGHasFallVector;
;247:extern vec3_t gCGFallVector;
;248:
;249:/*
;250:===============
;251:CG_CalcTargetThirdPersonViewLocation
;252:
;253:===============
;254:*/
;255:static void CG_CalcIdealThirdPersonViewTarget(void)
;256:{
line 257
;257:	float thirdPersonVertOffset = cg_thirdPersonVertOffset.value;
ADDRLP4 0
ADDRGP4 cg_thirdPersonVertOffset+8
INDIRF4
ASGNF4
line 259
;258:
;259:	if (cg.snap && cg.snap->ps.usingATST)
ADDRGP4 cg+36
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $324
ADDRGP4 cg+36
INDIRP4
CNSTI4 1360
ADDP4
INDIRI4
CNSTI4 0
EQI4 $324
line 260
;260:	{
line 261
;261:		thirdPersonVertOffset = 200;
ADDRLP4 0
CNSTF4 1128792064
ASGNF4
line 262
;262:	}
LABELV $324
line 265
;263:
;264:	// Initialize IdealTarget
;265:	if (gCGHasFallVector)
ADDRGP4 gCGHasFallVector
INDIRI4
CNSTI4 0
EQI4 $328
line 266
;266:	{
line 267
;267:		VectorCopy(gCGFallVector, cameraFocusLoc);
ADDRGP4 cameraFocusLoc
ADDRGP4 gCGFallVector
INDIRB
ASGNB 12
line 268
;268:	}
ADDRGP4 $329
JUMPV
LABELV $328
line 270
;269:	else
;270:	{
line 271
;271:		VectorCopy(cg.refdef.vieworg, cameraFocusLoc);
ADDRGP4 cameraFocusLoc
ADDRGP4 cg+3616+24
INDIRB
ASGNB 12
line 272
;272:	}
LABELV $329
line 275
;273:
;274:	// Add in the new viewheight
;275:	cameraFocusLoc[2] += cg.snap->ps.viewheight;
ADDRLP4 4
ADDRGP4 cameraFocusLoc+8
ASGNP4
ADDRLP4 4
INDIRP4
ADDRLP4 4
INDIRP4
INDIRF4
ADDRGP4 cg+36
INDIRP4
CNSTI4 212
ADDP4
INDIRI4
CVIF4 4
ADDF4
ASGNF4
line 281
;276:
;277:	// Add in a vertical offset from the viewpoint, which puts the actual target above the head, regardless of angle.
;278://	VectorMA(cameraFocusLoc, thirdPersonVertOffset, cameraup, cameraIdealTarget);
;279:	
;280:	// Add in a vertical offset from the viewpoint, which puts the actual target above the head, regardless of angle.
;281:	VectorCopy( cameraFocusLoc, cameraIdealTarget );
ADDRGP4 cameraIdealTarget
ADDRGP4 cameraFocusLoc
INDIRB
ASGNB 12
line 282
;282:	cameraIdealTarget[2] += cg_thirdPersonVertOffset.value;
ADDRLP4 8
ADDRGP4 cameraIdealTarget+8
ASGNP4
ADDRLP4 8
INDIRP4
ADDRLP4 8
INDIRP4
INDIRF4
ADDRGP4 cg_thirdPersonVertOffset+8
INDIRF4
ADDF4
ASGNF4
line 284
;283:	//VectorMA(cameraFocusLoc, cg_thirdPersonVertOffset.value, cameraup, cameraIdealTarget);
;284:}
LABELV $322
endproc CG_CalcIdealThirdPersonViewTarget 12 0
proc CG_CalcIdealThirdPersonViewLocation 8 0
line 295
;285:
;286:	
;287:
;288:/*
;289:===============
;290:CG_CalcTargetThirdPersonViewLocation
;291:
;292:===============
;293:*/
;294:static void CG_CalcIdealThirdPersonViewLocation(void)
;295:{
line 296
;296:	float thirdPersonRange = cg_thirdPersonRange.value;
ADDRLP4 0
ADDRGP4 cg_thirdPersonRange+8
INDIRF4
ASGNF4
line 298
;297:
;298:	if (cg.snap && cg.snap->ps.usingATST)
ADDRGP4 cg+36
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $338
ADDRGP4 cg+36
INDIRP4
CNSTI4 1360
ADDP4
INDIRI4
CNSTI4 0
EQI4 $338
line 299
;299:	{
line 300
;300:		thirdPersonRange = 300;
ADDRLP4 0
CNSTF4 1133903872
ASGNF4
line 301
;301:	}
LABELV $338
line 303
;302:
;303:	VectorMA(cameraIdealTarget, -(thirdPersonRange), camerafwd, cameraIdealLoc);
ADDRLP4 4
ADDRLP4 0
INDIRF4
NEGF4
ASGNF4
ADDRGP4 cameraIdealLoc
ADDRGP4 cameraIdealTarget
INDIRF4
ADDRGP4 camerafwd
INDIRF4
ADDRLP4 4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRGP4 cameraIdealLoc+4
ADDRGP4 cameraIdealTarget+4
INDIRF4
ADDRGP4 camerafwd+4
INDIRF4
ADDRLP4 4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRGP4 cameraIdealLoc+8
ADDRGP4 cameraIdealTarget+8
INDIRF4
ADDRGP4 camerafwd+8
INDIRF4
ADDRLP4 0
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
line 304
;304:}
LABELV $336
endproc CG_CalcIdealThirdPersonViewLocation 8 0
proc CG_ResetThirdPersonViewDamp 1080 28
line 309
;305:
;306:
;307:
;308:static void CG_ResetThirdPersonViewDamp(void)
;309:{
line 326
;310:	trace_t trace;
;311:
;312:	// adnan
;313:   // dont clamp the pitch...
;314:   /*
;315:   // Cap the pitch within reasonable limits
;316:	if (cameraFocusAngles[PITCH] > 89.0)
;317:	{
;318:		cameraFocusAngles[PITCH] = 89.0;
;319:	}
;320:	else if (cameraFocusAngles[PITCH] < -89.0)
;321:	{
;322:		cameraFocusAngles[PITCH] = -89.0;
;323:	}
;324:   */
;325:
;326:	AngleVectors(cameraFocusAngles, camerafwd, NULL, cameraup);
ADDRGP4 cameraFocusAngles
ARGP4
ADDRGP4 camerafwd
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 cameraup
ARGP4
ADDRGP4 AngleVectors
CALLV
pop
line 329
;327:
;328:	// Set the cameraIdealTarget
;329:	CG_CalcIdealThirdPersonViewTarget();
ADDRGP4 CG_CalcIdealThirdPersonViewTarget
CALLV
pop
line 332
;330:
;331:	// Set the cameraIdealLoc
;332:	CG_CalcIdealThirdPersonViewLocation();
ADDRGP4 CG_CalcIdealThirdPersonViewLocation
CALLV
pop
line 335
;333:
;334:	// Now, we just set everything to the new positions.
;335:	VectorCopy(cameraIdealLoc, cameraCurLoc);
ADDRGP4 cameraCurLoc
ADDRGP4 cameraIdealLoc
INDIRB
ASGNB 12
line 336
;336:	VectorCopy(cameraIdealTarget, cameraCurTarget);
ADDRGP4 cameraCurTarget
ADDRGP4 cameraIdealTarget
INDIRB
ASGNB 12
line 339
;337:
;338:	// First thing we do is trace from the first person viewpoint out to the new target location.
;339:	CG_Trace(&trace, cameraFocusLoc, cameramins, cameramaxs, cameraCurTarget, cg.snap->ps.clientNum, MASK_CAMERACLIP);
ADDRLP4 0
ARGP4
ADDRGP4 cameraFocusLoc
ARGP4
ADDRGP4 cameramins
ARGP4
ADDRGP4 cameramaxs
ARGP4
ADDRGP4 cameraCurTarget
ARGP4
ADDRGP4 cg+36
INDIRP4
CNSTI4 188
ADDP4
INDIRI4
ARGI4
CNSTI4 17
ARGI4
ADDRGP4 CG_Trace
CALLV
pop
line 340
;340:	if (trace.fraction <= 1.0)
ADDRLP4 0+8
INDIRF4
CNSTF4 1065353216
GTF4 $350
line 341
;341:	{
line 342
;342:		VectorCopy(trace.endpos, cameraCurTarget);
ADDRGP4 cameraCurTarget
ADDRLP4 0+12
INDIRB
ASGNB 12
line 343
;343:	}
LABELV $350
line 346
;344:
;345:	// Now we trace from the new target location to the new view location, to make sure there is nothing in the way.
;346:	CG_Trace(&trace, cameraCurTarget, cameramins, cameramaxs, cameraCurLoc, cg.snap->ps.clientNum, MASK_CAMERACLIP);
ADDRLP4 0
ARGP4
ADDRGP4 cameraCurTarget
ARGP4
ADDRGP4 cameramins
ARGP4
ADDRGP4 cameramaxs
ARGP4
ADDRGP4 cameraCurLoc
ARGP4
ADDRGP4 cg+36
INDIRP4
CNSTI4 188
ADDP4
INDIRI4
ARGI4
CNSTI4 17
ARGI4
ADDRGP4 CG_Trace
CALLV
pop
line 347
;347:	if (trace.fraction <= 1.0)
ADDRLP4 0+8
INDIRF4
CNSTF4 1065353216
GTF4 $355
line 348
;348:	{
line 349
;349:		VectorCopy(trace.endpos, cameraCurLoc);
ADDRGP4 cameraCurLoc
ADDRLP4 0+12
INDIRB
ASGNB 12
line 350
;350:	}
LABELV $355
line 352
;351:
;352:	cameraLastFrame = cg.time;
ADDRGP4 cameraLastFrame
ADDRGP4 cg+64
INDIRI4
ASGNI4
line 353
;353:	cameraLastYaw = cameraFocusAngles[YAW];
ADDRGP4 cameraLastYaw
ADDRGP4 cameraFocusAngles+4
INDIRF4
ASGNF4
line 354
;354:	cameraStiffFactor = 0.0f;
ADDRGP4 cameraStiffFactor
CNSTF4 0
ASGNF4
line 355
;355:}
LABELV $348
endproc CG_ResetThirdPersonViewDamp 1080 28
proc CG_UpdateThirdPersonTargetDamp 1112 28
line 359
;356:
;357:// This is called every frame.
;358:static void CG_UpdateThirdPersonTargetDamp(void)
;359:{
line 366
;360:	trace_t trace;
;361:	vec3_t	targetdiff;
;362:	float	dampfactor, dtime, ratio;
;363:
;364:	// Set the cameraIdealTarget
;365:	// Automatically get the ideal target, to avoid jittering.
;366:	CG_CalcIdealThirdPersonViewTarget();
ADDRGP4 CG_CalcIdealThirdPersonViewTarget
CALLV
pop
line 368
;367:
;368:	if (cg_thirdPersonTargetDamp.value>=1.0)
ADDRGP4 cg_thirdPersonTargetDamp+8
INDIRF4
CNSTF4 1065353216
LTF4 $362
line 369
;369:	{	// No damping.
line 370
;370:		VectorCopy(cameraIdealTarget, cameraCurTarget);
ADDRGP4 cameraCurTarget
ADDRGP4 cameraIdealTarget
INDIRB
ASGNB 12
line 371
;371:	}
ADDRGP4 $363
JUMPV
LABELV $362
line 372
;372:	else if (cg_thirdPersonTargetDamp.value>=0.0)
ADDRGP4 cg_thirdPersonTargetDamp+8
INDIRF4
CNSTF4 0
LTF4 $365
line 373
;373:	{	
line 375
;374:		// Calculate the difference from the current position to the new one.
;375:		VectorSubtract(cameraIdealTarget, cameraCurTarget, targetdiff);
ADDRLP4 1080
ADDRGP4 cameraIdealTarget
INDIRF4
ADDRGP4 cameraCurTarget
INDIRF4
SUBF4
ASGNF4
ADDRLP4 1080+4
ADDRGP4 cameraIdealTarget+4
INDIRF4
ADDRGP4 cameraCurTarget+4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 1080+8
ADDRGP4 cameraIdealTarget+8
INDIRF4
ADDRGP4 cameraCurTarget+8
INDIRF4
SUBF4
ASGNF4
line 379
;376:
;377:		// Now we calculate how much of the difference we cover in the time allotted.
;378:		// The equation is (Damp)^(time)
;379:		dampfactor = 1.0-cg_thirdPersonTargetDamp.value;	// We must exponent the amount LEFT rather than the amount bled off
ADDRLP4 1096
CNSTF4 1065353216
ADDRGP4 cg_thirdPersonTargetDamp+8
INDIRF4
SUBF4
ASGNF4
line 380
;380:		dtime = (float)(cg.time-cameraLastFrame) * (1.0/(float)CAMERA_DAMP_INTERVAL);	// Our dampfactor is geared towards a time interval equal to "1".
ADDRLP4 1100
CNSTF4 1017370378
ADDRGP4 cg+64
INDIRI4
ADDRGP4 cameraLastFrame
INDIRI4
SUBI4
CVIF4 4
MULF4
ASGNF4
line 384
;381:
;382:		// Note that since there are a finite number of "practical" delta millisecond values possible, 
;383:		// the ratio should be initialized into a chart ultimately.
;384:		ratio = powf(dampfactor, dtime);
ADDRLP4 1096
INDIRF4
ARGF4
ADDRLP4 1100
INDIRF4
CVFI4 4
ARGI4
ADDRLP4 1104
ADDRGP4 powf
CALLF4
ASGNF4
ADDRLP4 1092
ADDRLP4 1104
INDIRF4
ASGNF4
line 387
;385:		
;386:		// This value is how much distance is "left" from the ideal.
;387:		VectorMA(cameraIdealTarget, -ratio, targetdiff, cameraCurTarget);
ADDRLP4 1108
ADDRLP4 1092
INDIRF4
NEGF4
ASGNF4
ADDRGP4 cameraCurTarget
ADDRGP4 cameraIdealTarget
INDIRF4
ADDRLP4 1080
INDIRF4
ADDRLP4 1108
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRGP4 cameraCurTarget+4
ADDRGP4 cameraIdealTarget+4
INDIRF4
ADDRLP4 1080+4
INDIRF4
ADDRLP4 1108
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRGP4 cameraCurTarget+8
ADDRGP4 cameraIdealTarget+8
INDIRF4
ADDRLP4 1080+8
INDIRF4
ADDRLP4 1092
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
line 389
;388:		/////////////////////////////////////////////////////////////////////////////////////////////////////////
;389:	}
LABELV $365
LABELV $363
line 394
;390:
;391:	// Now we trace to see if the new location is cool or not.
;392:
;393:	// First thing we do is trace from the first person viewpoint out to the new target location.
;394:	CG_Trace(&trace, cameraFocusLoc, cameramins, cameramaxs, cameraCurTarget, cg.snap->ps.clientNum, MASK_CAMERACLIP);
ADDRLP4 0
ARGP4
ADDRGP4 cameraFocusLoc
ARGP4
ADDRGP4 cameramins
ARGP4
ADDRGP4 cameramaxs
ARGP4
ADDRGP4 cameraCurTarget
ARGP4
ADDRGP4 cg+36
INDIRP4
CNSTI4 188
ADDP4
INDIRI4
ARGI4
CNSTI4 17
ARGI4
ADDRGP4 CG_Trace
CALLV
pop
line 395
;395:	if (trace.fraction < 1.0)
ADDRLP4 0+8
INDIRF4
CNSTF4 1065353216
GEF4 $383
line 396
;396:	{
line 397
;397:		VectorCopy(trace.endpos, cameraCurTarget);
ADDRGP4 cameraCurTarget
ADDRLP4 0+12
INDIRB
ASGNB 12
line 398
;398:	}
LABELV $383
line 404
;399:
;400:	// Note that previously there was an upper limit to the number of physics traces that are done through the world
;401:	// for the sake of camera collision, since it wasn't calced per frame.  Now it is calculated every frame.
;402:	// This has the benefit that the camera is a lot smoother now (before it lerped between tested points),
;403:	// however two full volume traces each frame is a bit scary to think about.
;404:}
LABELV $361
endproc CG_UpdateThirdPersonTargetDamp 1112 28
proc CG_UpdateThirdPersonCameraDamp 1120 28
line 408
;405:
;406:// This can be called every interval, at the user's discretion.
;407:static void CG_UpdateThirdPersonCameraDamp(void)
;408:{
line 414
;409:	trace_t trace;
;410:	vec3_t	locdiff;
;411:	float dampfactor, dtime, ratio;
;412:
;413:	// Set the cameraIdealLoc
;414:	CG_CalcIdealThirdPersonViewLocation();
ADDRGP4 CG_CalcIdealThirdPersonViewLocation
CALLV
pop
line 418
;415:	
;416:	
;417:	// First thing we do is calculate the appropriate damping factor for the camera.
;418:	dampfactor=0.0;
ADDRLP4 0
CNSTF4 0
ASGNF4
line 419
;419:	if (cg_thirdPersonCameraDamp.value != 0.0)
ADDRGP4 cg_thirdPersonCameraDamp+8
INDIRF4
CNSTF4 0
EQF4 $388
line 420
;420:	{
line 424
;421:		double pitch;
;422:
;423:		// Note that the camera pitch has already been capped off to 89.
;424:		pitch = Q_fabs(cameraFocusAngles[PITCH]);
ADDRGP4 cameraFocusAngles
INDIRF4
ARGF4
ADDRLP4 1108
ADDRGP4 Q_fabs
CALLF4
ASGNF4
ADDRLP4 1104
ADDRLP4 1108
INDIRF4
ASGNF4
line 427
;425:
;426:		// The higher the pitch, the larger the factor, so as you look up, it damps a lot less.
;427:		pitch /= 89.0;	
ADDRLP4 1104
ADDRLP4 1104
INDIRF4
CNSTF4 1118961664
DIVF4
ASGNF4
line 428
;428:		dampfactor = (1.0-cg_thirdPersonCameraDamp.value)*(pitch*pitch);
ADDRLP4 1112
ADDRLP4 1104
INDIRF4
ASGNF4
ADDRLP4 0
CNSTF4 1065353216
ADDRGP4 cg_thirdPersonCameraDamp+8
INDIRF4
SUBF4
ADDRLP4 1112
INDIRF4
ADDRLP4 1112
INDIRF4
MULF4
MULF4
ASGNF4
line 430
;429:
;430:		dampfactor += cg_thirdPersonCameraDamp.value;
ADDRLP4 0
ADDRLP4 0
INDIRF4
ADDRGP4 cg_thirdPersonCameraDamp+8
INDIRF4
ADDF4
ASGNF4
line 433
;431:
;432:		// Now we also multiply in the stiff factor, so that faster yaw changes are stiffer.
;433:		if (cameraStiffFactor > 0.0f)
ADDRGP4 cameraStiffFactor
INDIRF4
CNSTF4 0
LEF4 $393
line 434
;434:		{	// The cameraStiffFactor is how much of the remaining damp below 1 should be shaved off, i.e. approach 1 as stiffening increases.
line 435
;435:			dampfactor += (1.0-dampfactor)*cameraStiffFactor;
ADDRLP4 0
ADDRLP4 0
INDIRF4
CNSTF4 1065353216
ADDRLP4 0
INDIRF4
SUBF4
ADDRGP4 cameraStiffFactor
INDIRF4
MULF4
ADDF4
ASGNF4
line 436
;436:		}
LABELV $393
line 437
;437:	}
LABELV $388
line 439
;438:
;439:	if (dampfactor>=1.0)
ADDRLP4 0
INDIRF4
CNSTF4 1065353216
LTF4 $395
line 440
;440:	{	// No damping.
line 441
;441:		VectorCopy(cameraIdealLoc, cameraCurLoc);
ADDRGP4 cameraCurLoc
ADDRGP4 cameraIdealLoc
INDIRB
ASGNB 12
line 442
;442:	}
ADDRGP4 $396
JUMPV
LABELV $395
line 443
;443:	else if (dampfactor>=0.0)
ADDRLP4 0
INDIRF4
CNSTF4 0
LTF4 $397
line 444
;444:	{	
line 446
;445:		// Calculate the difference from the current position to the new one.
;446:		VectorSubtract(cameraIdealLoc, cameraCurLoc, locdiff);
ADDRLP4 1084
ADDRGP4 cameraIdealLoc
INDIRF4
ADDRGP4 cameraCurLoc
INDIRF4
SUBF4
ASGNF4
ADDRLP4 1084+4
ADDRGP4 cameraIdealLoc+4
INDIRF4
ADDRGP4 cameraCurLoc+4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 1084+8
ADDRGP4 cameraIdealLoc+8
INDIRF4
ADDRGP4 cameraCurLoc+8
INDIRF4
SUBF4
ASGNF4
line 450
;447:
;448:		// Now we calculate how much of the difference we cover in the time allotted.
;449:		// The equation is (Damp)^(time)
;450:		dampfactor = 1.0-dampfactor;	// We must exponent the amount LEFT rather than the amount bled off
ADDRLP4 0
CNSTF4 1065353216
ADDRLP4 0
INDIRF4
SUBF4
ASGNF4
line 451
;451:		dtime = (float)(cg.time-cameraLastFrame) * (1.0/(float)CAMERA_DAMP_INTERVAL);	// Our dampfactor is geared towards a time interval equal to "1".
ADDRLP4 1100
CNSTF4 1017370378
ADDRGP4 cg+64
INDIRI4
ADDRGP4 cameraLastFrame
INDIRI4
SUBI4
CVIF4 4
MULF4
ASGNF4
line 455
;452:
;453:		// Note that since there are a finite number of "practical" delta millisecond values possible, 
;454:		// the ratio should be initialized into a chart ultimately.
;455:		ratio = powf(dampfactor, dtime);
ADDRLP4 0
INDIRF4
ARGF4
ADDRLP4 1100
INDIRF4
CVFI4 4
ARGI4
ADDRLP4 1104
ADDRGP4 powf
CALLF4
ASGNF4
ADDRLP4 1096
ADDRLP4 1104
INDIRF4
ASGNF4
line 458
;456:		
;457:		// This value is how much distance is "left" from the ideal.
;458:		VectorMA(cameraIdealLoc, -ratio, locdiff, cameraCurLoc);
ADDRLP4 1108
ADDRLP4 1096
INDIRF4
NEGF4
ASGNF4
ADDRGP4 cameraCurLoc
ADDRGP4 cameraIdealLoc
INDIRF4
ADDRLP4 1084
INDIRF4
ADDRLP4 1108
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRGP4 cameraCurLoc+4
ADDRGP4 cameraIdealLoc+4
INDIRF4
ADDRLP4 1084+4
INDIRF4
ADDRLP4 1108
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRGP4 cameraCurLoc+8
ADDRGP4 cameraIdealLoc+8
INDIRF4
ADDRLP4 1084+8
INDIRF4
ADDRLP4 1096
INDIRF4
NEGF4
MULF4
ADDF4
ASGNF4
line 460
;459:		/////////////////////////////////////////////////////////////////////////////////////////////////////////
;460:	}
LABELV $397
LABELV $396
line 463
;461:
;462:	// Now we trace from the new target location to the new view location, to make sure there is nothing in the way.
;463:	CG_Trace(&trace, cameraCurTarget, cameramins, cameramaxs, cameraCurLoc, cg.snap->ps.clientNum, MASK_CAMERACLIP);
ADDRLP4 4
ARGP4
ADDRGP4 cameraCurTarget
ARGP4
ADDRGP4 cameramins
ARGP4
ADDRGP4 cameramaxs
ARGP4
ADDRGP4 cameraCurLoc
ARGP4
ADDRGP4 cg+36
INDIRP4
CNSTI4 188
ADDP4
INDIRI4
ARGI4
CNSTI4 17
ARGI4
ADDRGP4 CG_Trace
CALLV
pop
line 465
;464:
;465:	if (trace.fraction < 1.0)
ADDRLP4 4+8
INDIRF4
CNSTF4 1065353216
GEF4 $413
line 466
;466:	{
line 467
;467:		VectorCopy( trace.endpos, cameraCurLoc );
ADDRGP4 cameraCurLoc
ADDRLP4 4+12
INDIRB
ASGNB 12
line 487
;468:
;469:		//FIXME: when the trace hits movers, it gets very very jaggy... ?
;470:		/*
;471:		//this doesn't actually help any
;472:		if ( trace.entityNum != ENTITYNUM_WORLD )
;473:		{
;474:			centity_t *cent = &cg_entities[trace.entityNum];
;475:			gentity_t *gent = &g_entities[trace.entityNum];
;476:			if ( cent != NULL && gent != NULL )
;477:			{
;478:				if ( cent->currentState.pos.trType == TR_LINEAR || cent->currentState.pos.trType == TR_LINEAR_STOP )
;479:				{
;480:					vec3_t	diff;
;481:					VectorSubtract( cent->lerpOrigin, gent->currentOrigin, diff );
;482:					VectorAdd( cameraCurLoc, diff, cameraCurLoc );
;483:				}
;484:			}
;485:		}
;486:		*/
;487:	}
LABELV $413
line 493
;488:
;489:	// Note that previously there was an upper limit to the number of physics traces that are done through the world
;490:	// for the sake of camera collision, since it wasn't calced per frame.  Now it is calculated every frame.
;491:	// This has the benefit that the camera is a lot smoother now (before it lerped between tested points),
;492:	// however two full volume traces each frame is a bit scary to think about.
;493:}
LABELV $387
endproc CG_UpdateThirdPersonCameraDamp 1120 28
proc CG_OffsetThirdPersonView 48 16
line 506
;494:
;495:
;496:
;497:
;498:/*
;499:===============`
;500:CG_OffsetThirdPersonView
;501:
;502:===============
;503:*/
;504:extern vmCvar_t cg_thirdPersonHorzOffset;
;505:static void CG_OffsetThirdPersonView( void ) 
;506:{
line 508
;507:	vec3_t diff;
;508:	float thirdPersonHorzOffset = cg_thirdPersonHorzOffset.value;
ADDRLP4 12
ADDRGP4 cg_thirdPersonHorzOffset+8
INDIRF4
ASGNF4
line 511
;509:	float deltayaw;
;510:
;511:	cameraStiffFactor = 0.0;
ADDRGP4 cameraStiffFactor
CNSTF4 0
ASGNF4
line 517
;512:
;513:	// Set camera viewing direction.
;514:	// adnan
;515:   // lets give this a shot... DIDNT WORK
;516:   //VectorCopy( cg.predictedPlayerState.viewangles, cameraFocusAngles );
;517:   VectorCopy( cg.refdefViewAngles, cameraFocusAngles );
ADDRGP4 cameraFocusAngles
ADDRGP4 cg+3984
INDIRB
ASGNB 12
line 521
;518:   
;519:
;520:	// if dead, look at killer
;521:	if ( cg.snap->ps.stats[STAT_HEALTH] <= 0 ) 
ADDRGP4 cg+36
INDIRP4
CNSTI4 260
ADDP4
INDIRI4
CNSTI4 0
GTI4 $420
line 522
;522:	{
line 523
;523:		cameraFocusAngles[YAW] = cg.snap->ps.stats[STAT_DEAD_YAW];
ADDRGP4 cameraFocusAngles+4
ADDRGP4 cg+36
INDIRP4
CNSTI4 284
ADDP4
INDIRI4
CVIF4 4
ASGNF4
line 524
;524:	}
ADDRGP4 $421
JUMPV
LABELV $420
line 526
;525:	else
;526:	{	// Add in the third Person Angle.
line 527
;527:		cameraFocusAngles[YAW] += cg_thirdPersonAngle.value;
ADDRLP4 20
ADDRGP4 cameraFocusAngles+4
ASGNP4
ADDRLP4 20
INDIRP4
ADDRLP4 20
INDIRP4
INDIRF4
ADDRGP4 cg_thirdPersonAngle+8
INDIRF4
ADDF4
ASGNF4
line 528
;528:		cameraFocusAngles[PITCH] += cg_thirdPersonPitchOffset.value;
ADDRLP4 24
ADDRGP4 cameraFocusAngles
ASGNP4
ADDRLP4 24
INDIRP4
ADDRLP4 24
INDIRP4
INDIRF4
ADDRGP4 cg_thirdPersonPitchOffset+8
INDIRF4
ADDF4
ASGNF4
line 529
;529:	}
LABELV $421
line 534
;530:
;531:	// The next thing to do is to see if we need to calculate a new camera target location.
;532:
;533:	// If we went back in time for some reason, or if we just started, reset the sample.
;534:	if (cameraLastFrame == 0 || cameraLastFrame > cg.time)
ADDRLP4 20
ADDRGP4 cameraLastFrame
INDIRI4
ASGNI4
ADDRLP4 20
INDIRI4
CNSTI4 0
EQI4 $431
ADDRLP4 20
INDIRI4
ADDRGP4 cg+64
INDIRI4
LEI4 $428
LABELV $431
line 535
;535:	{
line 536
;536:		CG_ResetThirdPersonViewDamp();
ADDRGP4 CG_ResetThirdPersonViewDamp
CALLV
pop
line 537
;537:	}
ADDRGP4 $429
JUMPV
LABELV $428
line 539
;538:	else
;539:	{
line 554
;540:		// adnan
;541:      // dont cap the camera pitch at all
;542:      /*
;543:      // Cap the pitch within reasonable limits
;544:		if (cameraFocusAngles[PITCH] > 80.0)
;545:		{
;546:			cameraFocusAngles[PITCH] = 80.0;
;547:		}
;548:		else if (cameraFocusAngles[PITCH] < -80.0)
;549:		{
;550:			cameraFocusAngles[PITCH] = -80.0;
;551:		}
;552:      */
;553:
;554:		AngleVectors(cameraFocusAngles, camerafwd, NULL, cameraup);
ADDRGP4 cameraFocusAngles
ARGP4
ADDRGP4 camerafwd
ARGP4
CNSTP4 0
ARGP4
ADDRGP4 cameraup
ARGP4
ADDRGP4 AngleVectors
CALLV
pop
line 556
;555:
;556:		deltayaw = fabs(cameraFocusAngles[YAW] - cameraLastYaw);
ADDRGP4 cameraFocusAngles+4
INDIRF4
ADDRGP4 cameraLastYaw
INDIRF4
SUBF4
ARGF4
ADDRLP4 24
ADDRGP4 fabs
CALLF4
ASGNF4
ADDRLP4 16
ADDRLP4 24
INDIRF4
ASGNF4
line 560
;557:		// adnan
;558:      // what happens if we dont fix this?
;559:      
;560:      if (deltayaw > 180.0f)
ADDRLP4 16
INDIRF4
CNSTF4 1127481344
LEF4 $433
line 561
;561:		{ // Normalize this angle so that it is between 0 and 180.
line 563
;562:			//deltayaw = fabs(deltayaw - 360.0f);
;563:		}
LABELV $433
line 565
;564:      
;565:		cameraStiffFactor = deltayaw / (float)(cg.time-cameraLastFrame);
ADDRGP4 cameraStiffFactor
ADDRLP4 16
INDIRF4
ADDRGP4 cg+64
INDIRI4
ADDRGP4 cameraLastFrame
INDIRI4
SUBI4
CVIF4 4
DIVF4
ASGNF4
line 566
;566:		if (cameraStiffFactor < 1.0)
ADDRGP4 cameraStiffFactor
INDIRF4
CNSTF4 1065353216
GEF4 $436
line 567
;567:		{
line 568
;568:			cameraStiffFactor = 0.0;
ADDRGP4 cameraStiffFactor
CNSTF4 0
ASGNF4
line 569
;569:		}
ADDRGP4 $437
JUMPV
LABELV $436
line 570
;570:		else if (cameraStiffFactor > 2.5)
ADDRGP4 cameraStiffFactor
INDIRF4
CNSTF4 1075838976
LEF4 $438
line 571
;571:		{
line 572
;572:			cameraStiffFactor = 0.75;
ADDRGP4 cameraStiffFactor
CNSTF4 1061158912
ASGNF4
line 573
;573:		}
ADDRGP4 $439
JUMPV
LABELV $438
line 575
;574:		else
;575:		{	// 1 to 2 scales from 0.0 to 0.5
line 576
;576:			cameraStiffFactor = (cameraStiffFactor-1.0f)*0.5f;
ADDRLP4 28
ADDRGP4 cameraStiffFactor
ASGNP4
ADDRLP4 28
INDIRP4
CNSTF4 1056964608
ADDRLP4 28
INDIRP4
INDIRF4
CNSTF4 1065353216
SUBF4
MULF4
ASGNF4
line 577
;577:		}
LABELV $439
LABELV $437
line 578
;578:		cameraLastYaw = cameraFocusAngles[YAW];
ADDRGP4 cameraLastYaw
ADDRGP4 cameraFocusAngles+4
INDIRF4
ASGNF4
line 581
;579:
;580:		// Move the target to the new location.
;581:		CG_UpdateThirdPersonTargetDamp();
ADDRGP4 CG_UpdateThirdPersonTargetDamp
CALLV
pop
line 582
;582:		CG_UpdateThirdPersonCameraDamp();
ADDRGP4 CG_UpdateThirdPersonCameraDamp
CALLV
pop
line 583
;583:	}
LABELV $429
line 592
;584:
;585:	// Now interestingly, the Quake method is to calculate a target focus point above the player, and point the camera at it.
;586:	// We won't do that for now.
;587:
;588:	// We must now take the angle taken from the camera target and location.
;589:	/*VectorSubtract(cameraCurTarget, cameraCurLoc, diff);
;590:	VectorNormalize(diff);
;591:	vectoangles(diff, cg.refdefViewAngles);*/
;592:	VectorSubtract(cameraCurTarget, cameraCurLoc, diff);
ADDRLP4 0
ADDRGP4 cameraCurTarget
INDIRF4
ADDRGP4 cameraCurLoc
INDIRF4
SUBF4
ASGNF4
ADDRLP4 0+4
ADDRGP4 cameraCurTarget+4
INDIRF4
ADDRGP4 cameraCurLoc+4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 0+8
ADDRGP4 cameraCurTarget+8
INDIRF4
ADDRGP4 cameraCurLoc+8
INDIRF4
SUBF4
ASGNF4
line 593
;593:	{
line 594
;594:		float dist = VectorNormalize(diff);
ADDRLP4 0
ARGP4
ADDRLP4 28
ADDRGP4 VectorNormalize
CALLF4
ASGNF4
ADDRLP4 24
ADDRLP4 28
INDIRF4
ASGNF4
line 596
;595:		//under normal circumstances, should never be 0.00000 and so on.
;596:		if ( !dist || (diff[0] == 0 || diff[1] == 0) )
ADDRLP4 32
CNSTF4 0
ASGNF4
ADDRLP4 24
INDIRF4
ADDRLP4 32
INDIRF4
EQF4 $451
ADDRLP4 0
INDIRF4
ADDRLP4 32
INDIRF4
EQF4 $451
ADDRLP4 0+4
INDIRF4
ADDRLP4 32
INDIRF4
NEF4 $447
LABELV $451
line 597
;597:		{//must be hitting something, need some value to calc angles, so use cam forward
line 598
;598:			VectorCopy( camerafwd, diff );
ADDRLP4 0
ADDRGP4 camerafwd
INDIRB
ASGNB 12
line 599
;599:		}
LABELV $447
line 600
;600:	}
line 601
;601:	vectoangles(diff, cg.refdefViewAngles);
ADDRLP4 0
ARGP4
ADDRGP4 cg+3984
ARGP4
ADDRGP4 vectoangles
CALLV
pop
line 604
;602:
;603:	// Temp: just move the camera to the side a bit
;604:	if ( thirdPersonHorzOffset != 0.0f )
ADDRLP4 12
INDIRF4
CNSTF4 0
EQF4 $453
line 605
;605:	{
line 610
;606:		// adnan
;607:      //AnglesToAxis( cg.refdefViewAngles, cg.refdef.viewaxis );
;608:      //QuaternionFromTieFloats(cg.snap->ps.tieFloats, &(cg.Q));
;609:      //QuaternionFromString(CG_ConfigString(CS_QUATERNIONS + cg.snap->ps.clientNum), &(cg.Q));
;610:      QuaternionToAxis(cg.Q, cg.refdef.viewaxis);
ADDRLP4 24
ADDRGP4 cg+168288
INDIRB
ASGNB 16
ADDRLP4 24
ARGP4
ADDRGP4 cg+3616+36
ARGP4
ADDRGP4 QuaternionToAxis
CALLF4
pop
line 617
;611:      /*
;612:      VectorCopy(cg.R[0], cg.refdef.viewaxis[0]);
;613:      VectorCopy(cg.R[1], cg.refdef.viewaxis[1]);
;614:      VectorCopy(cg.R[2], cg.refdef.viewaxis[2]);
;615:      */
;616:
;617:		VectorMA( cameraCurLoc, thirdPersonHorzOffset, cg.refdef.viewaxis[1], cameraCurLoc );
ADDRLP4 40
ADDRGP4 cameraCurLoc
ASGNP4
ADDRLP4 40
INDIRP4
ADDRLP4 40
INDIRP4
INDIRF4
ADDRGP4 cg+3616+36+12
INDIRF4
ADDRLP4 12
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRGP4 cameraCurLoc+4
ADDRGP4 cameraCurLoc+4
INDIRF4
ADDRGP4 cg+3616+36+12+4
INDIRF4
ADDRLP4 12
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRGP4 cameraCurLoc+8
ADDRGP4 cameraCurLoc+8
INDIRF4
ADDRGP4 cg+3616+36+12+8
INDIRF4
ADDRLP4 12
INDIRF4
MULF4
ADDF4
ASGNF4
line 618
;618:	}
LABELV $453
line 621
;619:
;620:	// ...and of course we should copy the new view location to the proper spot too.
;621:	VectorCopy(cameraCurLoc, cg.refdef.vieworg);
ADDRGP4 cg+3616+24
ADDRGP4 cameraCurLoc
INDIRB
ASGNB 12
line 623
;622:
;623:	cameraLastFrame=cg.time;
ADDRGP4 cameraLastFrame
ADDRGP4 cg+64
INDIRI4
ASGNI4
line 624
;624:}
LABELV $417
endproc CG_OffsetThirdPersonView 48 16
proc CG_TransitionAngles 20 0
line 634
;625:
;626:
;627:// adnan
;628:static float angles_previous[3];
;629:static int previousTurnTime;
;630:static int updateAngles;
;631:
;632:#define	FOCUS_DISTANCE	512
;633:
;634:static void CG_TransitionAngles(float *old_angles, float *new_angles) {
line 635
;635:   int i = 0;
ADDRLP4 0
CNSTI4 0
ASGNI4
line 637
;636:   
;637:   if(!previousTurnTime == 0) {
ADDRGP4 previousTurnTime
INDIRI4
CNSTI4 0
NEI4 $480
ADDRLP4 4
CNSTI4 1
ASGNI4
ADDRGP4 $481
JUMPV
LABELV $480
ADDRLP4 4
CNSTI4 0
ASGNI4
LABELV $481
ADDRLP4 4
INDIRI4
CNSTI4 0
NEI4 $477
line 638
;638:      previousTurnTime = cg.time;
ADDRGP4 previousTurnTime
ADDRGP4 cg+64
INDIRI4
ASGNI4
line 639
;639:   }
LABELV $477
line 641
;640:
;641:   if(cg.time - previousTurnTime >= 500) {
ADDRGP4 cg+64
INDIRI4
ADDRGP4 previousTurnTime
INDIRI4
SUBI4
CNSTI4 500
LTI4 $483
line 642
;642:      for(i = 0; i < 3; i++) {
ADDRLP4 0
CNSTI4 0
ASGNI4
LABELV $486
line 643
;643:         if(new_angles[i] < old_angles[i]) {
ADDRLP4 8
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ASGNI4
ADDRLP4 8
INDIRI4
ADDRFP4 4
INDIRP4
ADDP4
INDIRF4
ADDRLP4 8
INDIRI4
ADDRFP4 0
INDIRP4
ADDP4
INDIRF4
GEF4 $490
line 644
;644:            new_angles[i]--;
ADDRLP4 12
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRFP4 4
INDIRP4
ADDP4
ASGNP4
ADDRLP4 12
INDIRP4
ADDRLP4 12
INDIRP4
INDIRF4
CNSTF4 1065353216
SUBF4
ASGNF4
line 646
;645:            //old_angles[i] = new_angles[i];
;646:         } else if (new_angles[i] > old_angles[i]) {
ADDRGP4 $491
JUMPV
LABELV $490
ADDRLP4 12
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ASGNI4
ADDRLP4 12
INDIRI4
ADDRFP4 4
INDIRP4
ADDP4
INDIRF4
ADDRLP4 12
INDIRI4
ADDRFP4 0
INDIRP4
ADDP4
INDIRF4
LEF4 $492
line 647
;647:            new_angles[i]++;
ADDRLP4 16
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRFP4 4
INDIRP4
ADDP4
ASGNP4
ADDRLP4 16
INDIRP4
ADDRLP4 16
INDIRP4
INDIRF4
CNSTF4 1065353216
ADDF4
ASGNF4
line 649
;648:            //old_angles[i] = new_angles[i];
;649:         } else {
ADDRGP4 $493
JUMPV
LABELV $492
line 650
;650:            updateAngles = 1;
ADDRGP4 updateAngles
CNSTI4 1
ASGNI4
line 653
;651:            // not needed...
;652:            //old_angles[i] = new_angles[i];
;653:         }
LABELV $493
LABELV $491
line 654
;654:      }
LABELV $487
line 642
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 3
LTI4 $486
line 655
;655:      previousTurnTime = cg.time;
ADDRGP4 previousTurnTime
ADDRGP4 cg+64
INDIRI4
ASGNI4
line 656
;656:   }
LABELV $483
line 657
;657:}
LABELV $476
endproc CG_TransitionAngles 20 0
proc CG_OffsetFollowView 108 8
line 660
;658:
;659:
;660:static void CG_OffsetFollowView() {
line 673
;661:   vec3_t      forward, backward, up, R[3];
;662:   quat_t      q;
;663:   //int i;
;664:   
;665:   // smooth camera turning...
;666:   /*
;667:   if(cg_followCamTransition.integer == 1)
;668:      CG_TransitionAngles(angles_previous, cg.refdefViewAngles);
;669:   */
;670:
;671:   // set the roll...
;672:   //cg.refdefViewAngles[ROLL] = cg_roll.integer;
;673:   cg.refdefViewAngles[ROLL] = (int)cg.predictedPlayerState.stats[STAT_ROLL];
ADDRGP4 cg+3984+8
ADDRGP4 cg+96+216+40
INDIRI4
CVIF4 4
ASGNF4
line 679
;674:   
;675:   // get our reference vectors
;676:   //AngleVectors( cg.refdefViewAngles, forward, NULL, up );
;677:   //QuaternionFromTieFloats(cg.snap->ps.tieFloats, &q);
;678:   //QuaternionToAxis(q, R);
;679:   QuaternionToAxis(cg.Q, R);
ADDRLP4 88
ADDRGP4 cg+168288
INDIRB
ASGNB 16
ADDRLP4 88
ARGP4
ADDRLP4 36
ARGP4
ADDRGP4 QuaternionToAxis
CALLF4
pop
line 680
;680:   VectorCopy(R[0], forward);
ADDRLP4 24
ADDRLP4 36
INDIRB
ASGNB 12
line 681
;681:   VectorCopy(R[2], up);
ADDRLP4 12
ADDRLP4 36+24
INDIRB
ASGNB 12
line 685
;682:
;683:   
;684:   // get out backward vector
;685:   VectorScale(forward, -1, backward);
ADDRLP4 104
CNSTF4 3212836864
ASGNF4
ADDRLP4 0
ADDRLP4 104
INDIRF4
ADDRLP4 24
INDIRF4
MULF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 104
INDIRF4
ADDRLP4 24+4
INDIRF4
MULF4
ASGNF4
ADDRLP4 0+8
CNSTF4 3212836864
ADDRLP4 24+8
INDIRF4
MULF4
ASGNF4
line 686
;686:   VectorNormalize(backward);
ADDRLP4 0
ARGP4
ADDRGP4 VectorNormalize
CALLF4
pop
line 687
;687:   VectorScale(backward, cg_thirdPersonRange.integer, backward);
ADDRLP4 0
ADDRLP4 0
INDIRF4
ADDRGP4 cg_thirdPersonRange+12
INDIRI4
CVIF4 4
MULF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 0+4
INDIRF4
ADDRGP4 cg_thirdPersonRange+12
INDIRI4
CVIF4 4
MULF4
ASGNF4
ADDRLP4 0+8
ADDRLP4 0+8
INDIRF4
ADDRGP4 cg_thirdPersonRange+12
INDIRI4
CVIF4 4
MULF4
ASGNF4
line 690
;688:
;689:   // move the camera back
;690:   VectorAdd(cg.refdef.vieworg, backward, cg.refdef.vieworg);
ADDRGP4 cg+3616+24
ADDRGP4 cg+3616+24
INDIRF4
ADDRLP4 0
INDIRF4
ADDF4
ASGNF4
ADDRGP4 cg+3616+24+4
ADDRGP4 cg+3616+24+4
INDIRF4
ADDRLP4 0+4
INDIRF4
ADDF4
ASGNF4
ADDRGP4 cg+3616+24+8
ADDRGP4 cg+3616+24+8
INDIRF4
ADDRLP4 0+8
INDIRF4
ADDF4
ASGNF4
line 693
;691:
;692:   // get our up vector
;693:   VectorNormalize(up);
ADDRLP4 12
ARGP4
ADDRGP4 VectorNormalize
CALLF4
pop
line 694
;694:   VectorScale(up, cg_thirdPersonVertOffset.value, up);
ADDRLP4 12
ADDRLP4 12
INDIRF4
ADDRGP4 cg_thirdPersonVertOffset+8
INDIRF4
MULF4
ASGNF4
ADDRLP4 12+4
ADDRLP4 12+4
INDIRF4
ADDRGP4 cg_thirdPersonVertOffset+8
INDIRF4
MULF4
ASGNF4
ADDRLP4 12+8
ADDRLP4 12+8
INDIRF4
ADDRGP4 cg_thirdPersonVertOffset+8
INDIRF4
MULF4
ASGNF4
line 697
;695:   
;696:   // move the camera up
;697:   VectorAdd(cg.refdef.vieworg, up, cg.refdef.vieworg);   
ADDRGP4 cg+3616+24
ADDRGP4 cg+3616+24
INDIRF4
ADDRLP4 12
INDIRF4
ADDF4
ASGNF4
ADDRGP4 cg+3616+24+4
ADDRGP4 cg+3616+24+4
INDIRF4
ADDRLP4 12+4
INDIRF4
ADDF4
ASGNF4
ADDRGP4 cg+3616+24+8
ADDRGP4 cg+3616+24+8
INDIRF4
ADDRLP4 12+8
INDIRF4
ADDF4
ASGNF4
line 698
;698:}
LABELV $495
endproc CG_OffsetFollowView 108 8
proc CG_OffsetCockpitView 0 0
line 700
;699:
;700:static void CG_OffsetCockpitView( void ) {
line 703
;701:   // set the roll...
;702:   //cg.refdefViewAngles[ROLL] = cg_roll.integer;
;703:   cg.refdefViewAngles[ROLL] = (int)cg.predictedPlayerState.stats[STAT_ROLL];
ADDRGP4 cg+3984+8
ADDRGP4 cg+96+216+40
INDIRI4
CVIF4 4
ASGNF4
line 704
;704:}
LABELV $557
endproc CG_OffsetCockpitView 0 0
proc CG_OffsetFirstPersonView 96 0
line 803
;705:
;706:/*
;707:===============
;708:CG_OffsetThirdPersonView
;709:
;710:===============
;711:*//*
;712:#define	FOCUS_DISTANCE	512
;713:static void CG_OffsetThirdPersonView( void ) {
;714:	vec3_t		forward, right, up;
;715:	vec3_t		view;
;716:	vec3_t		focusAngles;
;717:	trace_t		trace;
;718:	static vec3_t	mins = { -4, -4, -4 };
;719:	static vec3_t	maxs = { 4, 4, 4 };
;720:	vec3_t		focusPoint;
;721:	float		focusDist;
;722:	float		forwardScale, sideScale;
;723:
;724:	cg.refdef.vieworg[2] += cg.predictedPlayerState.viewheight;
;725:
;726:	VectorCopy( cg.refdefViewAngles, focusAngles );
;727:
;728:	// if dead, look at killer
;729:	if ( cg.predictedPlayerState.stats[STAT_HEALTH] <= 0 ) {
;730:		focusAngles[YAW] = cg.predictedPlayerState.stats[STAT_DEAD_YAW];
;731:		cg.refdefViewAngles[YAW] = cg.predictedPlayerState.stats[STAT_DEAD_YAW];
;732:	}
;733:
;734:	if ( focusAngles[PITCH] > 45 ) {
;735:		focusAngles[PITCH] = 45;		// don't go too far overhead
;736:	}
;737:	AngleVectors( focusAngles, forward, NULL, NULL );
;738:
;739:	VectorMA( cg.refdef.vieworg, FOCUS_DISTANCE, forward, focusPoint );
;740:
;741:	VectorCopy( cg.refdef.vieworg, view );
;742:
;743:	view[2] += 8;
;744:
;745:	cg.refdefViewAngles[PITCH] *= 0.5;
;746:
;747:	AngleVectors( cg.refdefViewAngles, forward, right, up );
;748:
;749:	forwardScale = cos( cg_thirdPersonAngle.value / 180 * M_PI );
;750:	sideScale = sin( cg_thirdPersonAngle.value / 180 * M_PI );
;751:	VectorMA( view, -cg_thirdPersonRange.value * forwardScale, forward, view );
;752:	VectorMA( view, -cg_thirdPersonRange.value * sideScale, right, view );
;753:
;754:	// trace a ray from the origin to the viewpoint to make sure the view isn't
;755:	// in a solid block.  Use an 8 by 8 block to prevent the view from near clipping anything
;756:
;757:	if (!cg_cameraMode.integer) {
;758:		CG_Trace( &trace, cg.refdef.vieworg, mins, maxs, view, cg.predictedPlayerState.clientNum, MASK_CAMERACLIP);
;759:
;760:		if ( trace.fraction != 1.0 ) {
;761:			VectorCopy( trace.endpos, view );
;762:			view[2] += (1.0 - trace.fraction) * 32;
;763:			// try another trace to this position, because a tunnel may have the ceiling
;764:			// close enogh that this is poking out
;765:
;766:			CG_Trace( &trace, cg.refdef.vieworg, mins, maxs, view, cg.predictedPlayerState.clientNum, MASK_CAMERACLIP);
;767:			VectorCopy( trace.endpos, view );
;768:		}
;769:	}
;770:
;771:
;772:	VectorCopy( view, cg.refdef.vieworg );
;773:
;774:	// select pitch to look at focus point from vieword
;775:	VectorSubtract( focusPoint, cg.refdef.vieworg, focusPoint );
;776:	focusDist = sqrt( focusPoint[0] * focusPoint[0] + focusPoint[1] * focusPoint[1] );
;777:	if ( focusDist < 1 ) {
;778:		focusDist = 1;	// should never happen
;779:	}
;780:	cg.refdefViewAngles[PITCH] = -180 / M_PI * atan2( focusPoint[2], focusDist );
;781:	cg.refdefViewAngles[YAW] -= cg_thirdPersonAngle.value;
;782:}
;783:
;784:
;785:// this causes a compiler bug on mac MrC compiler
;786:static void CG_StepOffset( void ) {
;787:	int		timeDelta;
;788:	
;789:	// smooth out stair climbing
;790:	timeDelta = cg.time - cg.stepTime;
;791:	if ( timeDelta < STEP_TIME ) {
;792:		cg.refdef.vieworg[2] -= cg.stepChange 
;793:			* (STEP_TIME - timeDelta) / STEP_TIME;
;794:	}
;795:}*/
;796:
;797:/*
;798:===============
;799:CG_OffsetFirstPersonView
;800:
;801:===============
;802:*/
;803:static void CG_OffsetFirstPersonView( void ) {
line 814
;804:	float			*origin;
;805:	float			*angles;
;806:	float			bob;
;807:	float			ratio;
;808:	float			delta;
;809:	float			speed;
;810:	float			f;
;811:	vec3_t			predictedVelocity;
;812:	int				timeDelta;
;813:	
;814:	if ( cg.snap->ps.pm_type == PM_INTERMISSION ) {
ADDRGP4 cg+36
INDIRP4
CNSTI4 48
ADDP4
INDIRI4
CNSTI4 6
NEI4 $564
line 815
;815:		return;
ADDRGP4 $563
JUMPV
LABELV $564
line 818
;816:	}
;817:
;818:	origin = cg.refdef.vieworg;
ADDRLP4 8
ADDRGP4 cg+3616+24
ASGNP4
line 819
;819:	angles = cg.refdefViewAngles;
ADDRLP4 4
ADDRGP4 cg+3984
ASGNP4
line 822
;820:
;821:	// if dead, fix the angle and don't add any kick
;822:	if ( cg.snap->ps.stats[STAT_HEALTH] <= 0 ) {
ADDRGP4 cg+36
INDIRP4
CNSTI4 260
ADDP4
INDIRI4
CNSTI4 0
GTI4 $570
line 823
;823:		angles[ROLL] = 40;
ADDRLP4 4
INDIRP4
CNSTI4 8
ADDP4
CNSTF4 1109393408
ASGNF4
line 824
;824:		angles[PITCH] = -15;
ADDRLP4 4
INDIRP4
CNSTF4 3245342720
ASGNF4
line 825
;825:		angles[YAW] = cg.snap->ps.stats[STAT_DEAD_YAW];
ADDRLP4 4
INDIRP4
CNSTI4 4
ADDP4
ADDRGP4 cg+36
INDIRP4
CNSTI4 284
ADDP4
INDIRI4
CVIF4 4
ASGNF4
line 826
;826:		origin[2] += cg.predictedPlayerState.viewheight;
ADDRLP4 44
ADDRLP4 8
INDIRP4
CNSTI4 8
ADDP4
ASGNP4
ADDRLP4 44
INDIRP4
ADDRLP4 44
INDIRP4
INDIRF4
ADDRGP4 cg+96+168
INDIRI4
CVIF4 4
ADDF4
ASGNF4
line 827
;827:		return;
ADDRGP4 $563
JUMPV
LABELV $570
line 831
;828:	}
;829:
;830:	// add angles based on weapon kick
;831:	VectorAdd (angles, cg.kick_angles, angles);
ADDRLP4 4
INDIRP4
ADDRLP4 4
INDIRP4
INDIRF4
ADDRGP4 cg+13440
INDIRF4
ADDF4
ASGNF4
ADDRLP4 48
ADDRLP4 4
INDIRP4
CNSTI4 4
ADDP4
ASGNP4
ADDRLP4 48
INDIRP4
ADDRLP4 48
INDIRP4
INDIRF4
ADDRGP4 cg+13440+4
INDIRF4
ADDF4
ASGNF4
ADDRLP4 52
ADDRLP4 4
INDIRP4
CNSTI4 8
ADDP4
ASGNP4
ADDRLP4 52
INDIRP4
ADDRLP4 52
INDIRP4
INDIRF4
ADDRGP4 cg+13440+8
INDIRF4
ADDF4
ASGNF4
line 834
;832:
;833:	// add angles based on damage kick
;834:	if ( cg.damageTime ) {
ADDRGP4 cg+13384
INDIRF4
CNSTF4 0
EQF4 $581
line 835
;835:		ratio = cg.time - cg.damageTime;
ADDRLP4 32
ADDRGP4 cg+64
INDIRI4
CVIF4 4
ADDRGP4 cg+13384
INDIRF4
SUBF4
ASGNF4
line 836
;836:		if ( ratio < DAMAGE_DEFLECT_TIME ) {
ADDRLP4 32
INDIRF4
CNSTF4 1120403456
GEF4 $586
line 837
;837:			ratio /= DAMAGE_DEFLECT_TIME;
ADDRLP4 32
ADDRLP4 32
INDIRF4
CNSTF4 1120403456
DIVF4
ASGNF4
line 838
;838:			angles[PITCH] += ratio * cg.v_dmg_pitch;
ADDRLP4 4
INDIRP4
ADDRLP4 4
INDIRP4
INDIRF4
ADDRLP4 32
INDIRF4
ADDRGP4 cg+13432
INDIRF4
MULF4
ADDF4
ASGNF4
line 839
;839:			angles[ROLL] += ratio * cg.v_dmg_roll;
ADDRLP4 60
ADDRLP4 4
INDIRP4
CNSTI4 8
ADDP4
ASGNP4
ADDRLP4 60
INDIRP4
ADDRLP4 60
INDIRP4
INDIRF4
ADDRLP4 32
INDIRF4
ADDRGP4 cg+13436
INDIRF4
MULF4
ADDF4
ASGNF4
line 840
;840:		} else {
ADDRGP4 $587
JUMPV
LABELV $586
line 841
;841:			ratio = 1.0 - ( ratio - DAMAGE_DEFLECT_TIME ) / DAMAGE_RETURN_TIME;
ADDRLP4 32
CNSTF4 1065353216
ADDRLP4 32
INDIRF4
CNSTF4 1120403456
SUBF4
CNSTF4 1137180672
DIVF4
SUBF4
ASGNF4
line 842
;842:			if ( ratio > 0 ) {
ADDRLP4 32
INDIRF4
CNSTF4 0
LEF4 $590
line 843
;843:				angles[PITCH] += ratio * cg.v_dmg_pitch;
ADDRLP4 4
INDIRP4
ADDRLP4 4
INDIRP4
INDIRF4
ADDRLP4 32
INDIRF4
ADDRGP4 cg+13432
INDIRF4
MULF4
ADDF4
ASGNF4
line 844
;844:				angles[ROLL] += ratio * cg.v_dmg_roll;
ADDRLP4 60
ADDRLP4 4
INDIRP4
CNSTI4 8
ADDP4
ASGNP4
ADDRLP4 60
INDIRP4
ADDRLP4 60
INDIRP4
INDIRF4
ADDRLP4 32
INDIRF4
ADDRGP4 cg+13436
INDIRF4
MULF4
ADDF4
ASGNF4
line 845
;845:			}
LABELV $590
line 846
;846:		}
LABELV $587
line 847
;847:	}
LABELV $581
line 858
;848:
;849:	// add pitch based on fall kick
;850:#if 0
;851:	ratio = ( cg.time - cg.landTime) / FALL_TIME;
;852:	if (ratio < 0)
;853:		ratio = 0;
;854:	angles[PITCH] += ratio * cg.fall_value;
;855:#endif
;856:
;857:	// add angles based on velocity
;858:	VectorCopy( cg.predictedPlayerState.velocity, predictedVelocity );
ADDRLP4 12
ADDRGP4 cg+96+32
INDIRB
ASGNB 12
line 860
;859:
;860:	delta = DotProduct ( predictedVelocity, cg.refdef.viewaxis[0]);
ADDRLP4 0
ADDRLP4 12
INDIRF4
ADDRGP4 cg+3616+36
INDIRF4
MULF4
ADDRLP4 12+4
INDIRF4
ADDRGP4 cg+3616+36+4
INDIRF4
MULF4
ADDF4
ADDRLP4 12+8
INDIRF4
ADDRGP4 cg+3616+36+8
INDIRF4
MULF4
ADDF4
ASGNF4
line 861
;861:	angles[PITCH] += delta * cg_runpitch.value;
ADDRLP4 4
INDIRP4
ADDRLP4 4
INDIRP4
INDIRF4
ADDRLP4 0
INDIRF4
ADDRGP4 cg_runpitch+8
INDIRF4
MULF4
ADDF4
ASGNF4
line 863
;862:	
;863:	delta = DotProduct ( predictedVelocity, cg.refdef.viewaxis[1]);
ADDRLP4 0
ADDRLP4 12
INDIRF4
ADDRGP4 cg+3616+36+12
INDIRF4
MULF4
ADDRLP4 12+4
INDIRF4
ADDRGP4 cg+3616+36+12+4
INDIRF4
MULF4
ADDF4
ADDRLP4 12+8
INDIRF4
ADDRGP4 cg+3616+36+12+8
INDIRF4
MULF4
ADDF4
ASGNF4
line 864
;864:	angles[ROLL] -= delta * cg_runroll.value;
ADDRLP4 60
ADDRLP4 4
INDIRP4
CNSTI4 8
ADDP4
ASGNP4
ADDRLP4 60
INDIRP4
ADDRLP4 60
INDIRP4
INDIRF4
ADDRLP4 0
INDIRF4
ADDRGP4 cg_runroll+8
INDIRF4
MULF4
SUBF4
ASGNF4
line 869
;865:
;866:	// add angles based on bob
;867:
;868:	// make sure the bob is visible even at low speeds
;869:	speed = cg.xyspeed > 200 ? cg.xyspeed : 200;
ADDRGP4 cg+13472
INDIRF4
CNSTF4 1128792064
LEF4 $624
ADDRLP4 64
ADDRGP4 cg+13472
INDIRF4
ASGNF4
ADDRGP4 $625
JUMPV
LABELV $624
ADDRLP4 64
CNSTF4 1128792064
ASGNF4
LABELV $625
ADDRLP4 28
ADDRLP4 64
INDIRF4
ASGNF4
line 871
;870:
;871:	delta = cg.bobfracsin * cg_bobpitch.value * speed;
ADDRLP4 0
ADDRGP4 cg+13464
INDIRF4
ADDRGP4 cg_bobpitch+8
INDIRF4
MULF4
ADDRLP4 28
INDIRF4
MULF4
ASGNF4
line 872
;872:	if (cg.predictedPlayerState.pm_flags & PMF_DUCKED)
ADDRGP4 cg+96+12
INDIRI4
CNSTI4 1
BANDI4
CNSTI4 0
EQI4 $628
line 873
;873:		delta *= 3;		// crouching
ADDRLP4 0
CNSTF4 1077936128
ADDRLP4 0
INDIRF4
MULF4
ASGNF4
LABELV $628
line 874
;874:	angles[PITCH] += delta;
ADDRLP4 4
INDIRP4
ADDRLP4 4
INDIRP4
INDIRF4
ADDRLP4 0
INDIRF4
ADDF4
ASGNF4
line 875
;875:	delta = cg.bobfracsin * cg_bobroll.value * speed;
ADDRLP4 0
ADDRGP4 cg+13464
INDIRF4
ADDRGP4 cg_bobroll+8
INDIRF4
MULF4
ADDRLP4 28
INDIRF4
MULF4
ASGNF4
line 876
;876:	if (cg.predictedPlayerState.pm_flags & PMF_DUCKED)
ADDRGP4 cg+96+12
INDIRI4
CNSTI4 1
BANDI4
CNSTI4 0
EQI4 $634
line 877
;877:		delta *= 3;		// crouching accentuates roll
ADDRLP4 0
CNSTF4 1077936128
ADDRLP4 0
INDIRF4
MULF4
ASGNF4
LABELV $634
line 878
;878:	if (cg.bobcycle & 1)
ADDRGP4 cg+13468
INDIRI4
CNSTI4 1
BANDI4
CNSTI4 0
EQI4 $638
line 879
;879:		delta = -delta;
ADDRLP4 0
ADDRLP4 0
INDIRF4
NEGF4
ASGNF4
LABELV $638
line 880
;880:	angles[ROLL] += delta;
ADDRLP4 72
ADDRLP4 4
INDIRP4
CNSTI4 8
ADDP4
ASGNP4
ADDRLP4 72
INDIRP4
ADDRLP4 72
INDIRP4
INDIRF4
ADDRLP4 0
INDIRF4
ADDF4
ASGNF4
line 885
;881:
;882://===================================
;883:
;884:	// add view height
;885:	origin[2] += cg.predictedPlayerState.viewheight;
ADDRLP4 76
ADDRLP4 8
INDIRP4
CNSTI4 8
ADDP4
ASGNP4
ADDRLP4 76
INDIRP4
ADDRLP4 76
INDIRP4
INDIRF4
ADDRGP4 cg+96+168
INDIRI4
CVIF4 4
ADDF4
ASGNF4
line 888
;886:
;887:	// smooth out duck height changes
;888:	timeDelta = cg.time - cg.duckTime;
ADDRLP4 36
ADDRGP4 cg+64
INDIRI4
ADDRGP4 cg+3496
INDIRI4
SUBI4
ASGNI4
line 889
;889:	if ( timeDelta < DUCK_TIME) {
ADDRLP4 36
INDIRI4
CNSTI4 100
GEI4 $645
line 890
;890:		cg.refdef.vieworg[2] -= cg.duckChange 
ADDRLP4 80
ADDRGP4 cg+3616+24+8
ASGNP4
ADDRLP4 80
INDIRP4
ADDRLP4 80
INDIRP4
INDIRF4
ADDRGP4 cg+3492
INDIRF4
CNSTI4 100
ADDRLP4 36
INDIRI4
SUBI4
CVIF4 4
MULF4
CNSTF4 1120403456
DIVF4
SUBF4
ASGNF4
line 892
;891:			* (DUCK_TIME - timeDelta) / DUCK_TIME;
;892:	}
LABELV $645
line 895
;893:
;894:	// add bob height
;895:	bob = cg.bobfracsin * cg.xyspeed * cg_bobup.value;
ADDRLP4 24
ADDRGP4 cg+13464
INDIRF4
ADDRGP4 cg+13472
INDIRF4
MULF4
ADDRGP4 cg_bobup+8
INDIRF4
MULF4
ASGNF4
line 896
;896:	if (bob > 6) {
ADDRLP4 24
INDIRF4
CNSTF4 1086324736
LEF4 $654
line 897
;897:		bob = 6;
ADDRLP4 24
CNSTF4 1086324736
ASGNF4
line 898
;898:	}
LABELV $654
line 900
;899:
;900:	origin[2] += bob;
ADDRLP4 80
ADDRLP4 8
INDIRP4
CNSTI4 8
ADDP4
ASGNP4
ADDRLP4 80
INDIRP4
ADDRLP4 80
INDIRP4
INDIRF4
ADDRLP4 24
INDIRF4
ADDF4
ASGNF4
line 904
;901:
;902:
;903:	// add fall height
;904:	delta = cg.time - cg.landTime;
ADDRLP4 0
ADDRGP4 cg+64
INDIRI4
ADDRGP4 cg+3504
INDIRI4
SUBI4
CVIF4 4
ASGNF4
line 905
;905:	if ( delta < LAND_DEFLECT_TIME ) {
ADDRLP4 0
INDIRF4
CNSTF4 1125515264
GEF4 $658
line 906
;906:		f = delta / LAND_DEFLECT_TIME;
ADDRLP4 40
ADDRLP4 0
INDIRF4
CNSTF4 1125515264
DIVF4
ASGNF4
line 907
;907:		cg.refdef.vieworg[2] += cg.landChange * f;
ADDRLP4 84
ADDRGP4 cg+3616+24+8
ASGNP4
ADDRLP4 84
INDIRP4
ADDRLP4 84
INDIRP4
INDIRF4
ADDRGP4 cg+3500
INDIRF4
ADDRLP4 40
INDIRF4
MULF4
ADDF4
ASGNF4
line 908
;908:	} else if ( delta < LAND_DEFLECT_TIME + LAND_RETURN_TIME ) {
ADDRGP4 $659
JUMPV
LABELV $658
ADDRLP4 0
INDIRF4
CNSTF4 1138819072
GEF4 $664
line 909
;909:		delta -= LAND_DEFLECT_TIME;
ADDRLP4 0
ADDRLP4 0
INDIRF4
CNSTF4 1125515264
SUBF4
ASGNF4
line 910
;910:		f = 1.0 - ( delta / LAND_RETURN_TIME );
ADDRLP4 40
CNSTF4 1065353216
ADDRLP4 0
INDIRF4
CNSTF4 1133903872
DIVF4
SUBF4
ASGNF4
line 911
;911:		cg.refdef.vieworg[2] += cg.landChange * f;
ADDRLP4 84
ADDRGP4 cg+3616+24+8
ASGNP4
ADDRLP4 84
INDIRP4
ADDRLP4 84
INDIRP4
INDIRF4
ADDRGP4 cg+3500
INDIRF4
ADDRLP4 40
INDIRF4
MULF4
ADDF4
ASGNF4
line 912
;912:	}
LABELV $664
LABELV $659
line 915
;913:
;914:	// add step offset
;915:	CG_StepOffset();
ADDRGP4 CG_StepOffset
CALLV
pop
line 919
;916:
;917:	// add kick offset
;918:
;919:	VectorAdd (origin, cg.kick_origin, origin);
ADDRLP4 8
INDIRP4
ADDRLP4 8
INDIRP4
INDIRF4
ADDRGP4 cg+13452
INDIRF4
ADDF4
ASGNF4
ADDRLP4 88
ADDRLP4 8
INDIRP4
CNSTI4 4
ADDP4
ASGNP4
ADDRLP4 88
INDIRP4
ADDRLP4 88
INDIRP4
INDIRF4
ADDRGP4 cg+13452+4
INDIRF4
ADDF4
ASGNF4
ADDRLP4 92
ADDRLP4 8
INDIRP4
CNSTI4 8
ADDP4
ASGNP4
ADDRLP4 92
INDIRP4
ADDRLP4 92
INDIRP4
INDIRF4
ADDRGP4 cg+13452+8
INDIRF4
ADDF4
ASGNF4
line 933
;920:
;921:	// pivot the eye based on a neck length
;922:#if 0
;923:	{
;924:#define	NECK_LENGTH		8
;925:	vec3_t			forward, up;
;926: 
;927:	cg.refdef.vieworg[2] -= NECK_LENGTH;
;928:	AngleVectors( cg.refdefViewAngles, forward, NULL, up );
;929:	VectorMA( cg.refdef.vieworg, 3, forward, cg.refdef.vieworg );
;930:	VectorMA( cg.refdef.vieworg, NECK_LENGTH, up, cg.refdef.vieworg );
;931:	}
;932:#endif
;933:}
LABELV $563
endproc CG_OffsetFirstPersonView 96 0
export CG_ZoomDown_f
proc CG_ZoomDown_f 0 0
line 937
;934:
;935://======================================================================
;936:
;937:void CG_ZoomDown_f( void ) { 
line 938
;938:	if ( cg.zoomed ) {
ADDRGP4 cg+4008
INDIRI4
CNSTI4 0
EQI4 $676
line 939
;939:		return;
ADDRGP4 $675
JUMPV
LABELV $676
line 941
;940:	}
;941:	cg.zoomed = qtrue;
ADDRGP4 cg+4008
CNSTI4 1
ASGNI4
line 942
;942:	cg.zoomTime = cg.time;
ADDRGP4 cg+4012
ADDRGP4 cg+64
INDIRI4
ASGNI4
line 943
;943:}
LABELV $675
endproc CG_ZoomDown_f 0 0
export CG_ZoomUp_f
proc CG_ZoomUp_f 0 0
line 945
;944:
;945:void CG_ZoomUp_f( void ) { 
line 946
;946:	if ( !cg.zoomed ) {
ADDRGP4 cg+4008
INDIRI4
CNSTI4 0
NEI4 $683
line 947
;947:		return;
ADDRGP4 $682
JUMPV
LABELV $683
line 949
;948:	}
;949:	cg.zoomed = qfalse;
ADDRGP4 cg+4008
CNSTI4 0
ASGNI4
line 950
;950:	cg.zoomTime = cg.time;
ADDRGP4 cg+4012
ADDRGP4 cg+64
INDIRI4
ASGNI4
line 951
;951:}
LABELV $682
endproc CG_ZoomUp_f 0 0
export CG_CalcFOVFromX
proc CG_CalcFOVFromX 20 8
line 966
;952:
;953:
;954:
;955:/*
;956:====================
;957:CG_CalcFovFromX
;958:
;959:Calcs Y FOV from given X FOV
;960:====================
;961:*/
;962:#define	WAVE_AMPLITUDE	1
;963:#define	WAVE_FREQUENCY	0.4
;964:
;965:qboolean CG_CalcFOVFromX( float fov_x ) 
;966:{
line 974
;967:	float	x;
;968://	float	phase;
;969://	float	v;
;970://	int		contents;
;971:	float	fov_y;
;972:	qboolean	inwater;
;973:
;974:	x = cg.refdef.width / tan( fov_x / 360 * M_PI );
CNSTF4 1078530011
ADDRFP4 0
INDIRF4
CNSTF4 1135869952
DIVF4
MULF4
ARGF4
ADDRLP4 12
ADDRGP4 tan
CALLF4
ASGNF4
ADDRLP4 4
ADDRGP4 cg+3616+8
INDIRI4
CVIF4 4
ADDRLP4 12
INDIRF4
DIVF4
ASGNF4
line 975
;975:	fov_y = atan2( cg.refdef.height, x );
ADDRGP4 cg+3616+12
INDIRI4
CVIF4 4
ARGF4
ADDRLP4 4
INDIRF4
ARGF4
ADDRLP4 16
ADDRGP4 atan2
CALLF4
ASGNF4
ADDRLP4 0
ADDRLP4 16
INDIRF4
ASGNF4
line 976
;976:	fov_y = fov_y * 360 / M_PI;
ADDRLP4 0
CNSTF4 1135869952
ADDRLP4 0
INDIRF4
MULF4
CNSTF4 1078530011
DIVF4
ASGNF4
line 999
;977:
;978:	// there's a problem with this, it only takes the leafbrushes into account, not the entity brushes,
;979:	//	so if you give slime/water etc properties to a func_door area brush in order to move the whole water 
;980:	//	level up/down this doesn't take into account the door position, so warps the view the whole time
;981:	//	whether the water is up or not. Fortunately there's only one slime area in Trek that you can be under,
;982:	//	so lose it...
;983:#if 0
;984:/*
;985:	// warp if underwater
;986:	contents = CG_PointContents( cg.refdef.vieworg, -1 );
;987:	if ( contents & ( CONTENTS_WATER | CONTENTS_SLIME | CONTENTS_LAVA ) ){
;988:		phase = cg.time / 1000.0 * WAVE_FREQUENCY * M_PI * 2;
;989:		v = WAVE_AMPLITUDE * sin( phase );
;990:		fov_x += v;
;991:		fov_y -= v;
;992:		inwater = qtrue;
;993:	}
;994:	else {
;995:		inwater = qfalse;
;996:	}
;997:*/
;998:#else
;999:	inwater = qfalse;
ADDRLP4 8
CNSTI4 0
ASGNI4
line 1004
;1000:#endif
;1001:
;1002:
;1003:	// set it
;1004:	cg.refdef.fov_x = fov_x;
ADDRGP4 cg+3616+16
ADDRFP4 0
INDIRF4
ASGNF4
line 1005
;1005:	cg.refdef.fov_y = fov_y;
ADDRGP4 cg+3616+20
ADDRLP4 0
INDIRF4
ASGNF4
line 1007
;1006:
;1007:	return (inwater);
ADDRLP4 8
INDIRI4
RETI4
LABELV $689
endproc CG_CalcFOVFromX 20 8
data
align 4
LABELV $741
byte 4 0
code
proc CG_CalcFov 52 16
line 1021
;1008:}
;1009:
;1010:/*
;1011:====================
;1012:CG_CalcFov
;1013:
;1014:Fixed fov at intermissions, otherwise account for fov variable and zooms.
;1015:====================
;1016:*/
;1017:#define	WAVE_AMPLITUDE	1
;1018:#define	WAVE_FREQUENCY	0.4
;1019:float zoomFov; //this has to be global client-side
;1020:
;1021:static int CG_CalcFov( void ) {
line 1029
;1022:	float	x;
;1023:	float	phase;
;1024:	float	v;
;1025:	int		contents;
;1026:	float	fov_x, fov_y;
;1027:	float	f;
;1028:	int		inwater;
;1029:	float	cgFov = cg_fov.value;
ADDRLP4 0
ADDRGP4 cg_fov+8
INDIRF4
ASGNF4
line 1031
;1030:
;1031:	if (cgFov < 1)
ADDRLP4 0
INDIRF4
CNSTF4 1065353216
GEF4 $700
line 1032
;1032:	{
line 1033
;1033:		cgFov = 1;
ADDRLP4 0
CNSTF4 1065353216
ASGNF4
line 1034
;1034:	}
LABELV $700
line 1035
;1035:	if (cgFov > 97)
ADDRLP4 0
INDIRF4
CNSTF4 1120010240
LEF4 $702
line 1036
;1036:	{
line 1037
;1037:		cgFov = 97;
ADDRLP4 0
CNSTF4 1120010240
ASGNF4
line 1038
;1038:	}
LABELV $702
line 1040
;1039:
;1040:	if ( cg.predictedPlayerState.pm_type == PM_INTERMISSION ) {
ADDRGP4 cg+96+4
INDIRI4
CNSTI4 6
NEI4 $704
line 1042
;1041:		// if in intermission, use a fixed value
;1042:		fov_x = 80;//90;
ADDRLP4 4
CNSTF4 1117782016
ASGNF4
line 1043
;1043:	} else {
ADDRGP4 $705
JUMPV
LABELV $704
line 1045
;1044:		// user selectable
;1045:		if ( cgs.dmflags & DF_FIXED_FOV ) {
ADDRGP4 cgs+32964
INDIRI4
CNSTI4 16
BANDI4
CNSTI4 0
EQI4 $708
line 1047
;1046:			// dmflag to prevent wide fov for all clients
;1047:			fov_x = 80;//90;
ADDRLP4 4
CNSTF4 1117782016
ASGNF4
line 1048
;1048:		} else {
ADDRGP4 $709
JUMPV
LABELV $708
line 1049
;1049:			fov_x = cgFov;
ADDRLP4 4
ADDRLP4 0
INDIRF4
ASGNF4
line 1050
;1050:			if ( fov_x < 1 ) {
ADDRLP4 4
INDIRF4
CNSTF4 1065353216
GEF4 $711
line 1051
;1051:				fov_x = 1;
ADDRLP4 4
CNSTF4 1065353216
ASGNF4
line 1052
;1052:			} else if ( fov_x > 160 ) {
ADDRGP4 $712
JUMPV
LABELV $711
ADDRLP4 4
INDIRF4
CNSTF4 1126170624
LEF4 $713
line 1053
;1053:				fov_x = 160;
ADDRLP4 4
CNSTF4 1126170624
ASGNF4
line 1054
;1054:			}
LABELV $713
LABELV $712
line 1055
;1055:		}
LABELV $709
line 1057
;1056:
;1057:		if (cg.predictedPlayerState.zoomMode == 2)
ADDRGP4 cg+96+1332
INDIRI4
CNSTI4 2
NEI4 $715
line 1058
;1058:		{ //binoculars
line 1059
;1059:			if (zoomFov > 40.0f)
ADDRGP4 zoomFov
INDIRF4
CNSTF4 1109393408
LEF4 $719
line 1060
;1060:			{
line 1061
;1061:				zoomFov -= cg.frametime * 0.075f;
ADDRLP4 36
ADDRGP4 zoomFov
ASGNP4
ADDRLP4 36
INDIRP4
ADDRLP4 36
INDIRP4
INDIRF4
CNSTF4 1033476506
ADDRGP4 cg+60
INDIRI4
CVIF4 4
MULF4
SUBF4
ASGNF4
line 1063
;1062:
;1063:				if (zoomFov < 40.0f)
ADDRGP4 zoomFov
INDIRF4
CNSTF4 1109393408
GEF4 $722
line 1064
;1064:				{
line 1065
;1065:					zoomFov = 40.0f;
ADDRGP4 zoomFov
CNSTF4 1109393408
ASGNF4
line 1066
;1066:				}
ADDRGP4 $723
JUMPV
LABELV $722
line 1067
;1067:				else if (zoomFov > cgFov)
ADDRGP4 zoomFov
INDIRF4
ADDRLP4 0
INDIRF4
LEF4 $724
line 1068
;1068:				{
line 1069
;1069:					zoomFov = cgFov;
ADDRGP4 zoomFov
ADDRLP4 0
INDIRF4
ASGNF4
line 1070
;1070:				}
LABELV $724
LABELV $723
line 1071
;1071:			}
LABELV $719
line 1073
;1072:
;1073:			fov_x = zoomFov;
ADDRLP4 4
ADDRGP4 zoomFov
INDIRF4
ASGNF4
line 1074
;1074:		}
ADDRGP4 $716
JUMPV
LABELV $715
line 1075
;1075:		else if (cg.predictedPlayerState.zoomMode)
ADDRGP4 cg+96+1332
INDIRI4
CNSTI4 0
EQI4 $726
line 1076
;1076:		{
line 1077
;1077:			if (!cg.predictedPlayerState.zoomLocked)
ADDRGP4 cg+96+1340
INDIRI4
CNSTI4 0
NEI4 $730
line 1078
;1078:			{
line 1079
;1079:				if (zoomFov > 50)
ADDRGP4 zoomFov
INDIRF4
CNSTF4 1112014848
LEF4 $734
line 1080
;1080:				{ //Now starting out at nearly half zoomed in
line 1081
;1081:					zoomFov = 50;
ADDRGP4 zoomFov
CNSTF4 1112014848
ASGNF4
line 1082
;1082:				}
LABELV $734
line 1083
;1083:				zoomFov -= cg.frametime * 0.035f;//0.075f;
ADDRLP4 36
ADDRGP4 zoomFov
ASGNP4
ADDRLP4 36
INDIRP4
ADDRLP4 36
INDIRP4
INDIRF4
CNSTF4 1024416809
ADDRGP4 cg+60
INDIRI4
CVIF4 4
MULF4
SUBF4
ASGNF4
line 1085
;1084:
;1085:				if (zoomFov < MAX_ZOOM_FOV)
ADDRGP4 zoomFov
INDIRF4
CNSTF4 1077936128
GEF4 $737
line 1086
;1086:				{
line 1087
;1087:					zoomFov = MAX_ZOOM_FOV;
ADDRGP4 zoomFov
CNSTF4 1077936128
ASGNF4
line 1088
;1088:				}
ADDRGP4 $738
JUMPV
LABELV $737
line 1089
;1089:				else if (zoomFov > cgFov)
ADDRGP4 zoomFov
INDIRF4
ADDRLP4 0
INDIRF4
LEF4 $739
line 1090
;1090:				{
line 1091
;1091:					zoomFov = cgFov;
ADDRGP4 zoomFov
ADDRLP4 0
INDIRF4
ASGNF4
line 1092
;1092:				}
ADDRGP4 $740
JUMPV
LABELV $739
line 1094
;1093:				else
;1094:				{	// Still zooming
line 1097
;1095:					static zoomSoundTime = 0;
;1096:
;1097:					if (zoomSoundTime < cg.time || zoomSoundTime > cg.time + 10000)
ADDRLP4 40
ADDRGP4 $741
INDIRI4
ASGNI4
ADDRLP4 40
INDIRI4
ADDRGP4 cg+64
INDIRI4
LTI4 $746
ADDRLP4 40
INDIRI4
ADDRGP4 cg+64
INDIRI4
CNSTI4 10000
ADDI4
LEI4 $742
LABELV $746
line 1098
;1098:					{
line 1099
;1099:						trap_S_StartSound(cg.refdef.vieworg, ENTITYNUM_WORLD, CHAN_LOCAL, cgs.media.disruptorZoomLoop);
ADDRGP4 cg+3616+24
ARGP4
CNSTI4 1022
ARGI4
CNSTI4 1
ARGI4
ADDRGP4 cgs+71064+1264
INDIRI4
ARGI4
ADDRGP4 trap_S_StartSound
CALLV
pop
line 1100
;1100:						zoomSoundTime = cg.time + 300;
ADDRGP4 $741
ADDRGP4 cg+64
INDIRI4
CNSTI4 300
ADDI4
ASGNI4
line 1101
;1101:					}
LABELV $742
line 1102
;1102:				}
LABELV $740
LABELV $738
line 1103
;1103:			}
LABELV $730
line 1105
;1104:
;1105:			fov_x = zoomFov;
ADDRLP4 4
ADDRGP4 zoomFov
INDIRF4
ASGNF4
line 1106
;1106:		}
ADDRGP4 $727
JUMPV
LABELV $726
line 1108
;1107:		else 
;1108:		{
line 1109
;1109:			zoomFov = 80;
ADDRGP4 zoomFov
CNSTF4 1117782016
ASGNF4
line 1111
;1110:
;1111:			f = ( cg.time - cg.predictedPlayerState.zoomTime ) / ZOOM_OUT_TIME;
ADDRLP4 32
ADDRGP4 cg+64
INDIRI4
ADDRGP4 cg+96+1336
INDIRI4
SUBI4
CVIF4 4
CNSTF4 1120403456
DIVF4
ASGNF4
line 1112
;1112:			if ( f > 1.0 ) 
ADDRLP4 32
INDIRF4
CNSTF4 1065353216
LEF4 $755
line 1113
;1113:			{
line 1114
;1114:				fov_x = fov_x;
ADDRLP4 4
ADDRLP4 4
INDIRF4
ASGNF4
line 1115
;1115:			} 
ADDRGP4 $756
JUMPV
LABELV $755
line 1117
;1116:			else 
;1117:			{
line 1118
;1118:				fov_x = cg.predictedPlayerState.zoomFov + f * ( fov_x - cg.predictedPlayerState.zoomFov );
ADDRLP4 4
ADDRGP4 cg+96+1344
INDIRF4
ADDRLP4 32
INDIRF4
ADDRLP4 4
INDIRF4
ADDRGP4 cg+96+1344
INDIRF4
SUBF4
MULF4
ADDF4
ASGNF4
line 1119
;1119:			}
LABELV $756
line 1120
;1120:		}
LABELV $727
LABELV $716
line 1121
;1121:	}
LABELV $705
line 1123
;1122:
;1123:	x = cg.refdef.width / tan( fov_x / 360 * M_PI );
CNSTF4 1078530011
ADDRLP4 4
INDIRF4
CNSTF4 1135869952
DIVF4
MULF4
ARGF4
ADDRLP4 36
ADDRGP4 tan
CALLF4
ASGNF4
ADDRLP4 12
ADDRGP4 cg+3616+8
INDIRI4
CVIF4 4
ADDRLP4 36
INDIRF4
DIVF4
ASGNF4
line 1124
;1124:	fov_y = atan2( cg.refdef.height, x );
ADDRGP4 cg+3616+12
INDIRI4
CVIF4 4
ARGF4
ADDRLP4 12
INDIRF4
ARGF4
ADDRLP4 40
ADDRGP4 atan2
CALLF4
ASGNF4
ADDRLP4 8
ADDRLP4 40
INDIRF4
ASGNF4
line 1125
;1125:	fov_y = fov_y * 360 / M_PI;
ADDRLP4 8
CNSTF4 1135869952
ADDRLP4 8
INDIRF4
MULF4
CNSTF4 1078530011
DIVF4
ASGNF4
line 1128
;1126:
;1127:	// warp if underwater
;1128:	contents = CG_PointContents( cg.refdef.vieworg, -1 );
ADDRGP4 cg+3616+24
ARGP4
CNSTI4 -1
ARGI4
ADDRLP4 44
ADDRGP4 CG_PointContents
CALLI4
ASGNI4
ADDRLP4 16
ADDRLP4 44
INDIRI4
ASGNI4
line 1129
;1129:	if ( contents & ( CONTENTS_WATER | CONTENTS_SLIME | CONTENTS_LAVA ) ){
ADDRLP4 16
INDIRI4
CNSTI4 131078
BANDI4
CNSTI4 0
EQI4 $767
line 1130
;1130:		phase = cg.time / 1000.0 * WAVE_FREQUENCY * M_PI * 2;
ADDRLP4 28
CNSTF4 1073741824
CNSTF4 1078530011
CNSTF4 1053609165
ADDRGP4 cg+64
INDIRI4
CVIF4 4
CNSTF4 1148846080
DIVF4
MULF4
MULF4
MULF4
ASGNF4
line 1131
;1131:		v = WAVE_AMPLITUDE * sin( phase );
ADDRLP4 28
INDIRF4
ARGF4
ADDRLP4 48
ADDRGP4 sin
CALLF4
ASGNF4
ADDRLP4 24
CNSTF4 1065353216
ADDRLP4 48
INDIRF4
MULF4
ASGNF4
line 1132
;1132:		fov_x += v;
ADDRLP4 4
ADDRLP4 4
INDIRF4
ADDRLP4 24
INDIRF4
ADDF4
ASGNF4
line 1133
;1133:		fov_y -= v;
ADDRLP4 8
ADDRLP4 8
INDIRF4
ADDRLP4 24
INDIRF4
SUBF4
ASGNF4
line 1134
;1134:		inwater = qtrue;
ADDRLP4 20
CNSTI4 1
ASGNI4
line 1135
;1135:	}
ADDRGP4 $768
JUMPV
LABELV $767
line 1136
;1136:	else {
line 1137
;1137:		inwater = qfalse;
ADDRLP4 20
CNSTI4 0
ASGNI4
line 1138
;1138:	}
LABELV $768
line 1142
;1139:
;1140:
;1141:	// set it
;1142:	cg.refdef.fov_x = fov_x;
ADDRGP4 cg+3616+16
ADDRLP4 4
INDIRF4
ASGNF4
line 1143
;1143:	cg.refdef.fov_y = fov_y;
ADDRGP4 cg+3616+20
ADDRLP4 8
INDIRF4
ASGNF4
line 1145
;1144:
;1145:	if (cg.predictedPlayerState.zoomMode)
ADDRGP4 cg+96+1332
INDIRI4
CNSTI4 0
EQI4 $774
line 1146
;1146:	{
line 1147
;1147:		cg.zoomSensitivity = zoomFov/cgFov;
ADDRGP4 cg+4016
ADDRGP4 zoomFov
INDIRF4
ADDRLP4 0
INDIRF4
DIVF4
ASGNF4
line 1148
;1148:	}
ADDRGP4 $775
JUMPV
LABELV $774
line 1149
;1149:	else if ( !cg.zoomed ) {
ADDRGP4 cg+4008
INDIRI4
CNSTI4 0
NEI4 $779
line 1150
;1150:		cg.zoomSensitivity = 1;
ADDRGP4 cg+4016
CNSTF4 1065353216
ASGNF4
line 1151
;1151:	} else {
ADDRGP4 $780
JUMPV
LABELV $779
line 1152
;1152:		cg.zoomSensitivity = cg.refdef.fov_y / 75.0;
ADDRGP4 cg+4016
ADDRGP4 cg+3616+20
INDIRF4
CNSTF4 1117126656
DIVF4
ASGNF4
line 1153
;1153:	}
LABELV $780
LABELV $775
line 1155
;1154:
;1155:	return inwater;
ADDRLP4 20
INDIRI4
RETI4
LABELV $698
endproc CG_CalcFov 52 16
proc CG_DamageBlendBlob 260 12
line 1166
;1156:}
;1157:
;1158:
;1159:/*
;1160:===============
;1161:CG_DamageBlendBlob
;1162:
;1163:===============
;1164:*/
;1165:static void CG_DamageBlendBlob( void ) 
;1166:{
line 1171
;1167:	int			t;
;1168:	int			maxTime;
;1169:	refEntity_t		ent;
;1170:
;1171:	if ( !cg.damageValue ) {
ADDRGP4 cg+13396
INDIRF4
CNSTF4 0
NEF4 $787
line 1172
;1172:		return;
ADDRGP4 $786
JUMPV
LABELV $787
line 1175
;1173:	}
;1174:
;1175:	maxTime = DAMAGE_TIME;
ADDRLP4 216
CNSTI4 500
ASGNI4
line 1176
;1176:	t = cg.time - cg.damageTime;
ADDRLP4 212
ADDRGP4 cg+64
INDIRI4
CVIF4 4
ADDRGP4 cg+13384
INDIRF4
SUBF4
CVFI4 4
ASGNI4
line 1177
;1177:	if ( t <= 0 || t >= maxTime ) {
ADDRLP4 212
INDIRI4
CNSTI4 0
LEI4 $794
ADDRLP4 212
INDIRI4
ADDRLP4 216
INDIRI4
LTI4 $792
LABELV $794
line 1178
;1178:		return;
ADDRGP4 $786
JUMPV
LABELV $792
line 1181
;1179:	}
;1180:
;1181:	memset( &ent, 0, sizeof( ent ) );
ADDRLP4 0
ARGP4
CNSTI4 0
ARGI4
CNSTI4 212
ARGI4
ADDRGP4 memset
CALLP4
pop
line 1182
;1182:	ent.reType = RT_SPRITE;
ADDRLP4 0
CNSTI4 2
ASGNI4
line 1183
;1183:	ent.renderfx = RF_FIRST_PERSON;
ADDRLP4 0+4
CNSTI4 4
ASGNI4
line 1185
;1184:
;1185:	VectorMA( cg.refdef.vieworg, 8, cg.refdef.viewaxis[0], ent.origin );
ADDRLP4 0+52
ADDRGP4 cg+3616+24
INDIRF4
CNSTF4 1090519040
ADDRGP4 cg+3616+36
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+52+4
ADDRGP4 cg+3616+24+4
INDIRF4
CNSTF4 1090519040
ADDRGP4 cg+3616+36+4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+52+8
ADDRGP4 cg+3616+24+8
INDIRF4
CNSTF4 1090519040
ADDRGP4 cg+3616+36+8
INDIRF4
MULF4
ADDF4
ASGNF4
line 1186
;1186:	VectorMA( ent.origin, cg.damageX * -8, cg.refdef.viewaxis[1], ent.origin );
ADDRLP4 0+52
ADDRLP4 0+52
INDIRF4
ADDRGP4 cg+3616+36+12
INDIRF4
CNSTF4 3238002688
ADDRGP4 cg+13388
INDIRF4
MULF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+52+4
ADDRLP4 0+52+4
INDIRF4
ADDRGP4 cg+3616+36+12+4
INDIRF4
CNSTF4 3238002688
ADDRGP4 cg+13388
INDIRF4
MULF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+52+8
ADDRLP4 0+52+8
INDIRF4
ADDRGP4 cg+3616+36+12+8
INDIRF4
CNSTF4 3238002688
ADDRGP4 cg+13388
INDIRF4
MULF4
MULF4
ADDF4
ASGNF4
line 1187
;1187:	VectorMA( ent.origin, cg.damageY * 8, cg.refdef.viewaxis[2], ent.origin );
ADDRLP4 0+52
ADDRLP4 0+52
INDIRF4
ADDRGP4 cg+3616+36+24
INDIRF4
CNSTF4 1090519040
ADDRGP4 cg+13392
INDIRF4
MULF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+52+4
ADDRLP4 0+52+4
INDIRF4
ADDRGP4 cg+3616+36+24+4
INDIRF4
CNSTF4 1090519040
ADDRGP4 cg+13392
INDIRF4
MULF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+52+8
ADDRLP4 0+52+8
INDIRF4
ADDRGP4 cg+3616+36+24+8
INDIRF4
CNSTF4 1090519040
ADDRGP4 cg+13392
INDIRF4
MULF4
MULF4
ADDF4
ASGNF4
line 1189
;1188:
;1189:	ent.radius = cg.damageValue * 3 * ( 1.0 - ((float)t / maxTime) );
ADDRLP4 0+92
CNSTF4 1077936128
ADDRGP4 cg+13396
INDIRF4
MULF4
CNSTF4 1065353216
ADDRLP4 212
INDIRI4
CVIF4 4
ADDRLP4 216
INDIRI4
CVIF4 4
DIVF4
SUBF4
MULF4
ASGNF4
line 1191
;1190:
;1191:	if (cg.snap->ps.damageType == 0)
ADDRGP4 cg+36
INDIRP4
CNSTI4 232
ADDP4
INDIRI4
CNSTI4 0
NEI4 $867
line 1192
;1192:	{ //pure health
line 1193
;1193:		ent.customShader = cgs.media.viewPainShader;
ADDRLP4 0+76
ADDRGP4 cgs+71064+436
INDIRI4
ASGNI4
line 1194
;1194:		ent.shaderRGBA[0] = 180 * ( 1.0 - ((float)t / maxTime) );
ADDRLP4 228
CNSTF4 1127481344
CNSTF4 1065353216
ADDRLP4 212
INDIRI4
CVIF4 4
ADDRLP4 216
INDIRI4
CVIF4 4
DIVF4
SUBF4
MULF4
ASGNF4
ADDRLP4 232
CNSTF4 1325400064
ASGNF4
ADDRLP4 228
INDIRF4
ADDRLP4 232
INDIRF4
LTF4 $875
ADDRLP4 224
ADDRLP4 228
INDIRF4
ADDRLP4 232
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $876
JUMPV
LABELV $875
ADDRLP4 224
ADDRLP4 228
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $876
ADDRLP4 0+80
ADDRLP4 224
INDIRU4
CVUU1 4
ASGNU1
line 1195
;1195:		ent.shaderRGBA[1] = 50 * ( 1.0 - ((float)t / maxTime) );
ADDRLP4 240
CNSTF4 1112014848
CNSTF4 1065353216
ADDRLP4 212
INDIRI4
CVIF4 4
ADDRLP4 216
INDIRI4
CVIF4 4
DIVF4
SUBF4
MULF4
ASGNF4
ADDRLP4 244
CNSTF4 1325400064
ASGNF4
ADDRLP4 240
INDIRF4
ADDRLP4 244
INDIRF4
LTF4 $880
ADDRLP4 236
ADDRLP4 240
INDIRF4
ADDRLP4 244
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $881
JUMPV
LABELV $880
ADDRLP4 236
ADDRLP4 240
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $881
ADDRLP4 0+80+1
ADDRLP4 236
INDIRU4
CVUU1 4
ASGNU1
line 1196
;1196:		ent.shaderRGBA[2] = 50 * ( 1.0 - ((float)t / maxTime) );
ADDRLP4 252
CNSTF4 1112014848
CNSTF4 1065353216
ADDRLP4 212
INDIRI4
CVIF4 4
ADDRLP4 216
INDIRI4
CVIF4 4
DIVF4
SUBF4
MULF4
ASGNF4
ADDRLP4 256
CNSTF4 1325400064
ASGNF4
ADDRLP4 252
INDIRF4
ADDRLP4 256
INDIRF4
LTF4 $885
ADDRLP4 248
ADDRLP4 252
INDIRF4
ADDRLP4 256
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $886
JUMPV
LABELV $885
ADDRLP4 248
ADDRLP4 252
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $886
ADDRLP4 0+80+2
ADDRLP4 248
INDIRU4
CVUU1 4
ASGNU1
line 1197
;1197:		ent.shaderRGBA[3] = 255;
ADDRLP4 0+80+3
CNSTU1 255
ASGNU1
line 1198
;1198:	}
ADDRGP4 $868
JUMPV
LABELV $867
line 1199
;1199:	else if (cg.snap->ps.damageType == 1)
ADDRGP4 cg+36
INDIRP4
CNSTI4 232
ADDP4
INDIRI4
CNSTI4 1
NEI4 $889
line 1200
;1200:	{ //pure shields
line 1201
;1201:		ent.customShader = cgs.media.viewPainShader_Shields;
ADDRLP4 0+76
ADDRGP4 cgs+71064+440
INDIRI4
ASGNI4
line 1202
;1202:		ent.shaderRGBA[0] = 50 * ( 1.0 - ((float)t / maxTime) );
ADDRLP4 228
CNSTF4 1112014848
CNSTF4 1065353216
ADDRLP4 212
INDIRI4
CVIF4 4
ADDRLP4 216
INDIRI4
CVIF4 4
DIVF4
SUBF4
MULF4
ASGNF4
ADDRLP4 232
CNSTF4 1325400064
ASGNF4
ADDRLP4 228
INDIRF4
ADDRLP4 232
INDIRF4
LTF4 $897
ADDRLP4 224
ADDRLP4 228
INDIRF4
ADDRLP4 232
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $898
JUMPV
LABELV $897
ADDRLP4 224
ADDRLP4 228
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $898
ADDRLP4 0+80
ADDRLP4 224
INDIRU4
CVUU1 4
ASGNU1
line 1203
;1203:		ent.shaderRGBA[1] = 180 * ( 1.0 - ((float)t / maxTime) );
ADDRLP4 240
CNSTF4 1127481344
CNSTF4 1065353216
ADDRLP4 212
INDIRI4
CVIF4 4
ADDRLP4 216
INDIRI4
CVIF4 4
DIVF4
SUBF4
MULF4
ASGNF4
ADDRLP4 244
CNSTF4 1325400064
ASGNF4
ADDRLP4 240
INDIRF4
ADDRLP4 244
INDIRF4
LTF4 $902
ADDRLP4 236
ADDRLP4 240
INDIRF4
ADDRLP4 244
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $903
JUMPV
LABELV $902
ADDRLP4 236
ADDRLP4 240
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $903
ADDRLP4 0+80+1
ADDRLP4 236
INDIRU4
CVUU1 4
ASGNU1
line 1204
;1204:		ent.shaderRGBA[2] = 50 * ( 1.0 - ((float)t / maxTime) );
ADDRLP4 252
CNSTF4 1112014848
CNSTF4 1065353216
ADDRLP4 212
INDIRI4
CVIF4 4
ADDRLP4 216
INDIRI4
CVIF4 4
DIVF4
SUBF4
MULF4
ASGNF4
ADDRLP4 256
CNSTF4 1325400064
ASGNF4
ADDRLP4 252
INDIRF4
ADDRLP4 256
INDIRF4
LTF4 $907
ADDRLP4 248
ADDRLP4 252
INDIRF4
ADDRLP4 256
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $908
JUMPV
LABELV $907
ADDRLP4 248
ADDRLP4 252
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $908
ADDRLP4 0+80+2
ADDRLP4 248
INDIRU4
CVUU1 4
ASGNU1
line 1205
;1205:		ent.shaderRGBA[3] = 255;
ADDRLP4 0+80+3
CNSTU1 255
ASGNU1
line 1206
;1206:	}
ADDRGP4 $890
JUMPV
LABELV $889
line 1208
;1207:	else
;1208:	{ //shields and health
line 1209
;1209:		ent.customShader = cgs.media.viewPainShader_ShieldsAndHealth;
ADDRLP4 0+76
ADDRGP4 cgs+71064+444
INDIRI4
ASGNI4
line 1210
;1210:		ent.shaderRGBA[0] = 180 * ( 1.0 - ((float)t / maxTime) );
ADDRLP4 228
CNSTF4 1127481344
CNSTF4 1065353216
ADDRLP4 212
INDIRI4
CVIF4 4
ADDRLP4 216
INDIRI4
CVIF4 4
DIVF4
SUBF4
MULF4
ASGNF4
ADDRLP4 232
CNSTF4 1325400064
ASGNF4
ADDRLP4 228
INDIRF4
ADDRLP4 232
INDIRF4
LTF4 $916
ADDRLP4 224
ADDRLP4 228
INDIRF4
ADDRLP4 232
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $917
JUMPV
LABELV $916
ADDRLP4 224
ADDRLP4 228
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $917
ADDRLP4 0+80
ADDRLP4 224
INDIRU4
CVUU1 4
ASGNU1
line 1211
;1211:		ent.shaderRGBA[1] = 180 * ( 1.0 - ((float)t / maxTime) );
ADDRLP4 240
CNSTF4 1127481344
CNSTF4 1065353216
ADDRLP4 212
INDIRI4
CVIF4 4
ADDRLP4 216
INDIRI4
CVIF4 4
DIVF4
SUBF4
MULF4
ASGNF4
ADDRLP4 244
CNSTF4 1325400064
ASGNF4
ADDRLP4 240
INDIRF4
ADDRLP4 244
INDIRF4
LTF4 $921
ADDRLP4 236
ADDRLP4 240
INDIRF4
ADDRLP4 244
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $922
JUMPV
LABELV $921
ADDRLP4 236
ADDRLP4 240
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $922
ADDRLP4 0+80+1
ADDRLP4 236
INDIRU4
CVUU1 4
ASGNU1
line 1212
;1212:		ent.shaderRGBA[2] = 50 * ( 1.0 - ((float)t / maxTime) );
ADDRLP4 252
CNSTF4 1112014848
CNSTF4 1065353216
ADDRLP4 212
INDIRI4
CVIF4 4
ADDRLP4 216
INDIRI4
CVIF4 4
DIVF4
SUBF4
MULF4
ASGNF4
ADDRLP4 256
CNSTF4 1325400064
ASGNF4
ADDRLP4 252
INDIRF4
ADDRLP4 256
INDIRF4
LTF4 $926
ADDRLP4 248
ADDRLP4 252
INDIRF4
ADDRLP4 256
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $927
JUMPV
LABELV $926
ADDRLP4 248
ADDRLP4 252
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $927
ADDRLP4 0+80+2
ADDRLP4 248
INDIRU4
CVUU1 4
ASGNU1
line 1213
;1213:		ent.shaderRGBA[3] = 255;
ADDRLP4 0+80+3
CNSTU1 255
ASGNU1
line 1214
;1214:	}
LABELV $890
LABELV $868
line 1215
;1215:	trap_R_AddRefEntityToScene( &ent );
ADDRLP4 0
ARGP4
ADDRGP4 trap_R_AddRefEntityToScene
CALLV
pop
line 1216
;1216:}
LABELV $786
endproc CG_DamageBlendBlob 260 12
export CheckOutOfConstrict
proc CheckOutOfConstrict 20 0
line 1219
;1217:
;1218:qboolean CheckOutOfConstrict(float curAng)
;1219:{
line 1222
;1220:	float degrees_negative, degrees_positive;
;1221:
;1222:	float angle_ideal = cg.constrictValue;
ADDRLP4 4
ADDRGP4 cg+3996
INDIRF4
ASGNF4
line 1223
;1223:	float angle_current = curAng;
ADDRLP4 0
ADDRFP4 0
INDIRF4
ASGNF4
line 1225
;1224:
;1225:	float angle_dif = 0;
ADDRLP4 8
CNSTF4 0
ASGNF4
line 1227
;1226:
;1227:	if (angle_current < 0)
ADDRLP4 0
INDIRF4
CNSTF4 0
GEF4 $932
line 1228
;1228:	{
line 1229
;1229:		angle_current += 360;
ADDRLP4 0
ADDRLP4 0
INDIRF4
CNSTF4 1135869952
ADDF4
ASGNF4
line 1230
;1230:	}
LABELV $932
line 1231
;1231:	if (angle_current > 360)
ADDRLP4 0
INDIRF4
CNSTF4 1135869952
LEF4 $934
line 1232
;1232:	{
line 1233
;1233:		angle_current -= 360;
ADDRLP4 0
ADDRLP4 0
INDIRF4
CNSTF4 1135869952
SUBF4
ASGNF4
line 1234
;1234:	}
LABELV $934
line 1236
;1235:
;1236:	if (cg.doConstrict <= cg.time)
ADDRGP4 cg+4004
INDIRI4
ADDRGP4 cg+64
INDIRI4
GTI4 $936
line 1237
;1237:	{
line 1238
;1238:		return qfalse;
CNSTI4 0
RETI4
ADDRGP4 $930
JUMPV
LABELV $936
line 1241
;1239:	}
;1240:
;1241:	if (angle_ideal <= angle_current)
ADDRLP4 4
INDIRF4
ADDRLP4 0
INDIRF4
GTF4 $940
line 1242
;1242:	{
line 1243
;1243:		degrees_negative = (angle_current - angle_ideal);
ADDRLP4 12
ADDRLP4 0
INDIRF4
ADDRLP4 4
INDIRF4
SUBF4
ASGNF4
line 1245
;1244:
;1245:		degrees_positive = (360 - angle_current) + angle_ideal;
ADDRLP4 16
CNSTF4 1135869952
ADDRLP4 0
INDIRF4
SUBF4
ADDRLP4 4
INDIRF4
ADDF4
ASGNF4
line 1246
;1246:	}
ADDRGP4 $941
JUMPV
LABELV $940
line 1248
;1247:	else
;1248:	{
line 1249
;1249:		degrees_negative = angle_current + (360 - angle_ideal);
ADDRLP4 12
ADDRLP4 0
INDIRF4
CNSTF4 1135869952
ADDRLP4 4
INDIRF4
SUBF4
ADDF4
ASGNF4
line 1251
;1250:
;1251:		degrees_positive = (angle_ideal - angle_current);
ADDRLP4 16
ADDRLP4 4
INDIRF4
ADDRLP4 0
INDIRF4
SUBF4
ASGNF4
line 1252
;1252:	}
LABELV $941
line 1254
;1253:
;1254:	if (degrees_negative < degrees_positive)
ADDRLP4 12
INDIRF4
ADDRLP4 16
INDIRF4
GEF4 $942
line 1255
;1255:	{
line 1256
;1256:		angle_dif = degrees_negative;
ADDRLP4 8
ADDRLP4 12
INDIRF4
ASGNF4
line 1257
;1257:	}
ADDRGP4 $943
JUMPV
LABELV $942
line 1259
;1258:	else
;1259:	{
line 1260
;1260:		angle_dif = degrees_positive;
ADDRLP4 8
ADDRLP4 16
INDIRF4
ASGNF4
line 1261
;1261:	}
LABELV $943
line 1263
;1262:
;1263:	if (angle_dif > 60)
ADDRLP4 8
INDIRF4
CNSTF4 1114636288
LEF4 $944
line 1264
;1264:	{
line 1265
;1265:		return qtrue;
CNSTI4 1
RETI4
ADDRGP4 $930
JUMPV
LABELV $944
line 1268
;1266:	}
;1267:
;1268:	return qfalse;
CNSTI4 0
RETI4
LABELV $930
endproc CheckOutOfConstrict 20 0
proc CG_CalcViewValues 92 12
line 1282
;1269:}
;1270:
;1271:/*
;1272:===============
;1273:CG_CalcViewValues
;1274:
;1275:Sets cg.refdef view values
;1276:===============
;1277:*/
;1278:
;1279:// adnan
;1280:static int prevTime;
;1281:
;1282:static int CG_CalcViewValues( void ) {
line 1287
;1283:	playerState_t	*ps;
;1284:   vec3_t         dir, angles;
;1285:   quat_t         q;
;1286:
;1287:	memset( &cg.refdef, 0, sizeof( cg.refdef ) );
ADDRGP4 cg+3616
ARGP4
CNSTI4 0
ARGI4
CNSTI4 368
ARGI4
ADDRGP4 memset
CALLP4
pop
line 1294
;1288:
;1289:	// strings for in game rendering
;1290:	// Q_strncpyz( cg.refdef.text[0], "Park Ranger", sizeof(cg.refdef.text[0]) );
;1291:	// Q_strncpyz( cg.refdef.text[1], "19", sizeof(cg.refdef.text[1]) );
;1292:
;1293:	// calculate size of 3D view
;1294:	CG_CalcVrect();
ADDRGP4 CG_CalcVrect
CALLV
pop
line 1296
;1295:
;1296:	ps = &cg.predictedPlayerState;
ADDRLP4 0
ADDRGP4 cg+96
ASGNP4
line 1312
;1297:/*
;1298:	if (cg.cameraMode) {
;1299:		vec3_t origin, angles;
;1300:		if (trap_getCameraInfo(cg.time, &origin, &angles)) {
;1301:			VectorCopy(origin, cg.refdef.vieworg);
;1302:			angles[ROLL] = 0;
;1303:			VectorCopy(angles, cg.refdefViewAngles);
;1304:			AnglesToAxis( cg.refdefViewAngles, cg.refdef.viewaxis );
;1305:			return CG_CalcFov();
;1306:		} else {
;1307:			cg.cameraMode = qfalse;
;1308:		}
;1309:	}
;1310:*/
;1311:	// intermission view
;1312:	if ( ps->pm_type == PM_INTERMISSION ) {
ADDRLP4 0
INDIRP4
CNSTI4 4
ADDP4
INDIRI4
CNSTI4 6
NEI4 $950
line 1313
;1313:		VectorCopy( ps->origin, cg.refdef.vieworg );
ADDRGP4 cg+3616+24
ADDRLP4 0
INDIRP4
CNSTI4 20
ADDP4
INDIRB
ASGNB 12
line 1314
;1314:		VectorCopy( ps->viewangles, cg.refdefViewAngles );
ADDRGP4 cg+3984
ADDRLP4 0
INDIRP4
CNSTI4 156
ADDP4
INDIRB
ASGNB 12
line 1315
;1315:		AnglesToAxis( cg.refdefViewAngles, cg.refdef.viewaxis );
ADDRGP4 cg+3984
ARGP4
ADDRGP4 cg+3616+36
ARGP4
ADDRGP4 AnglesToAxis
CALLV
pop
line 1316
;1316:		return CG_CalcFov();
ADDRLP4 44
ADDRGP4 CG_CalcFov
CALLI4
ASGNI4
ADDRLP4 44
INDIRI4
RETI4
ADDRGP4 $946
JUMPV
LABELV $950
line 1319
;1317:	}
;1318:
;1319:	cg.bobcycle = ( ps->bobCycle & 128 ) >> 7;
ADDRGP4 cg+13468
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
CNSTI4 128
BANDI4
CNSTI4 7
RSHI4
ASGNI4
line 1320
;1320:	cg.bobfracsin = fabs( sin( ( ps->bobCycle & 127 ) / 127.0 * M_PI ) );
CNSTF4 1078530011
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
CNSTI4 127
BANDI4
CVIF4 4
CNSTF4 1123942400
DIVF4
MULF4
ARGF4
ADDRLP4 44
ADDRGP4 sin
CALLF4
ASGNF4
ADDRLP4 44
INDIRF4
ARGF4
ADDRLP4 48
ADDRGP4 fabs
CALLF4
ASGNF4
ADDRGP4 cg+13464
ADDRLP4 48
INDIRF4
ASGNF4
line 1321
;1321:	cg.xyspeed = sqrt( ps->velocity[0] * ps->velocity[0] +
ADDRLP4 56
ADDRLP4 0
INDIRP4
CNSTI4 32
ADDP4
INDIRF4
ASGNF4
ADDRLP4 60
ADDRLP4 0
INDIRP4
CNSTI4 36
ADDP4
INDIRF4
ASGNF4
ADDRLP4 56
INDIRF4
ADDRLP4 56
INDIRF4
MULF4
ADDRLP4 60
INDIRF4
ADDRLP4 60
INDIRF4
MULF4
ADDF4
ARGF4
ADDRLP4 64
ADDRGP4 sqrt
CALLF4
ASGNF4
ADDRGP4 cg+13472
ADDRLP4 64
INDIRF4
ASGNF4
line 1324
;1322:		ps->velocity[1] * ps->velocity[1] );
;1323:
;1324:	if (cg.xyspeed > 270)
ADDRGP4 cg+13472
INDIRF4
CNSTF4 1132920832
LEF4 $961
line 1325
;1325:	{
line 1326
;1326:		cg.xyspeed = 270;
ADDRGP4 cg+13472
CNSTF4 1132920832
ASGNF4
line 1327
;1327:	}
LABELV $961
line 1329
;1328:
;1329:	VectorCopy( ps->origin, cg.refdef.vieworg );
ADDRGP4 cg+3616+24
ADDRLP4 0
INDIRP4
CNSTI4 20
ADDP4
INDIRB
ASGNB 12
line 1330
;1330:	VectorCopy( ps->viewangles, cg.refdefViewAngles );
ADDRGP4 cg+3984
ADDRLP4 0
INDIRP4
CNSTI4 156
ADDP4
INDIRB
ASGNB 12
line 1332
;1331:   
;1332:	if (cg_cameraOrbit.integer) {
ADDRGP4 cg_cameraOrbit+12
INDIRI4
CNSTI4 0
EQI4 $968
line 1333
;1333:		if (cg.time > cg.nextOrbitTime) {
ADDRGP4 cg+64
INDIRI4
ADDRGP4 cg+13476
INDIRI4
LEI4 $971
line 1334
;1334:			cg.nextOrbitTime = cg.time + cg_cameraOrbitDelay.integer;
ADDRGP4 cg+13476
ADDRGP4 cg+64
INDIRI4
ADDRGP4 cg_cameraOrbitDelay+12
INDIRI4
ADDI4
ASGNI4
line 1335
;1335:			cg_thirdPersonAngle.value += cg_cameraOrbit.value;
ADDRLP4 68
ADDRGP4 cg_thirdPersonAngle+8
ASGNP4
ADDRLP4 68
INDIRP4
ADDRLP4 68
INDIRP4
INDIRF4
ADDRGP4 cg_cameraOrbit+8
INDIRF4
ADDF4
ASGNF4
line 1336
;1336:		}
LABELV $971
line 1337
;1337:	}
LABELV $968
line 1339
;1338:	// add error decay
;1339:	if ( cg_errorDecay.value > 0 ) {
ADDRGP4 cg_errorDecay+8
INDIRF4
CNSTF4 0
LEF4 $980
line 1343
;1340:		int		t;
;1341:		float	f;
;1342:
;1343:		t = cg.time - cg.predictedErrorTime;
ADDRLP4 72
ADDRGP4 cg+64
INDIRI4
ADDRGP4 cg+3400
INDIRI4
SUBI4
ASGNI4
line 1344
;1344:		f = ( cg_errorDecay.value - t ) / cg_errorDecay.value;
ADDRLP4 68
ADDRGP4 cg_errorDecay+8
INDIRF4
ADDRLP4 72
INDIRI4
CVIF4 4
SUBF4
ADDRGP4 cg_errorDecay+8
INDIRF4
DIVF4
ASGNF4
line 1345
;1345:		if ( f > 0 && f < 1 ) {
ADDRLP4 76
ADDRLP4 68
INDIRF4
ASGNF4
ADDRLP4 76
INDIRF4
CNSTF4 0
LEF4 $987
ADDRLP4 76
INDIRF4
CNSTF4 1065353216
GEF4 $987
line 1346
;1346:			VectorMA( cg.refdef.vieworg, f, cg.predictedError, cg.refdef.vieworg );
ADDRGP4 cg+3616+24
ADDRGP4 cg+3616+24
INDIRF4
ADDRGP4 cg+3404
INDIRF4
ADDRLP4 68
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRGP4 cg+3616+24+4
ADDRGP4 cg+3616+24+4
INDIRF4
ADDRGP4 cg+3404+4
INDIRF4
ADDRLP4 68
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRGP4 cg+3616+24+8
ADDRGP4 cg+3616+24+8
INDIRF4
ADDRGP4 cg+3404+8
INDIRF4
ADDRLP4 68
INDIRF4
MULF4
ADDF4
ASGNF4
line 1347
;1347:		} else {
ADDRGP4 $988
JUMPV
LABELV $987
line 1348
;1348:			cg.predictedErrorTime = 0;
ADDRGP4 cg+3400
CNSTI4 0
ASGNI4
line 1349
;1349:		}
LABELV $988
line 1350
;1350:	}
LABELV $980
line 1352
;1351:
;1352:	if ( cg.renderingThirdPerson && !cg.snap->ps.zoomMode) {
ADDRLP4 68
CNSTI4 0
ASGNI4
ADDRGP4 cg+88
INDIRI4
ADDRLP4 68
INDIRI4
EQI4 $1011
ADDRGP4 cg+36
INDIRP4
CNSTI4 1376
ADDP4
INDIRI4
ADDRLP4 68
INDIRI4
NEI4 $1011
line 1356
;1353:		// back away from character
;1354:		
;1355:      // adnan
;1356:      if(prevTime == 0)
ADDRGP4 prevTime
INDIRI4
CNSTI4 0
NEI4 $1015
line 1357
;1357:         prevTime = cg.time;
ADDRGP4 prevTime
ADDRGP4 cg+64
INDIRI4
ASGNI4
LABELV $1015
line 1359
;1358:
;1359:      if(cg_followCam.integer == 1) {
ADDRGP4 cg_followCam+12
INDIRI4
CNSTI4 1
NEI4 $1018
line 1360
;1360:         if(cg_followCamTransition.integer == 1) {
ADDRGP4 cg_followCamTransition+12
INDIRI4
CNSTI4 1
NEI4 $1021
line 1361
;1361:            if(cg.time - prevTime >= 1000) {
ADDRGP4 cg+64
INDIRI4
ADDRGP4 prevTime
INDIRI4
SUBI4
CNSTI4 1000
LTI4 $1012
line 1362
;1362:               CG_OffsetFollowView();
ADDRGP4 CG_OffsetFollowView
CALLV
pop
line 1363
;1363:               prevTime = cg.time;
ADDRGP4 prevTime
ADDRGP4 cg+64
INDIRI4
ASGNI4
line 1364
;1364:            }
line 1365
;1365:         } else {
ADDRGP4 $1012
JUMPV
LABELV $1021
line 1366
;1366:            CG_OffsetFollowView();
ADDRGP4 CG_OffsetFollowView
CALLV
pop
line 1367
;1367:         }
line 1368
;1368:      } else {
ADDRGP4 $1012
JUMPV
LABELV $1018
line 1369
;1369:         CG_OffsetThirdPersonView();
ADDRGP4 CG_OffsetThirdPersonView
CALLV
pop
line 1370
;1370:      }
line 1371
;1371:   } else {
ADDRGP4 $1012
JUMPV
LABELV $1011
line 1376
;1372:		// offset for local bobbing and kicks
;1373:		//CG_OffsetFirstPersonView();
;1374:      // adnan
;1375:      // use cockpit view rather than chopping up fp view
;1376:      CG_OffsetCockpitView();
ADDRGP4 CG_OffsetCockpitView
CALLV
pop
line 1377
;1377:	}
LABELV $1012
line 1387
;1378:
;1379:	// position eye reletive to origin
;1380:	//AnglesToAxis( cg.refdefViewAngles, cg.refdef.viewaxis );
;1381:   //VectorCopy(cg.Rangles, cg.refdefViewAngles);
;1382:   // adnan
;1383:   //QuaternionFromTieFloats(cg.snap->ps.tieFloats, &q);
;1384:   //QuaternionFromString(CG_ConfigString(CS_QUATERNIONS + cg.snap->ps.clientNum), &(cg.Q));
;1385:   //Com_Printf("%f, %f, %f, %f", q.x, q.y, q.z, q.w);
;1386:   //QuaternionCopy(cg.Q, &q);
;1387:   QuaternionToAxis(cg.Q, cg.refdef.viewaxis);
ADDRLP4 72
ADDRGP4 cg+168288
INDIRB
ASGNB 16
ADDRLP4 72
ARGP4
ADDRGP4 cg+3616+36
ARGP4
ADDRGP4 QuaternionToAxis
CALLF4
pop
line 1399
;1388:   //VectorCopy(cg.R[0], cg.refdef.viewaxis[0]);
;1389:   //VectorCopy(cg.R[1], cg.refdef.viewaxis[1]);
;1390:   //VectorCopy(cg.R[2], cg.refdef.viewaxis[2]);
;1391:   /*
;1392:   VectorSet(dir, 1, 0, 0);
;1393:   VectorRotate(dir, cg.refdef.viewaxis, angles);
;1394:   vectoangles(angles, dir);
;1395:   VectorCopy(dir, cg.refdefViewAngles);
;1396:   AnglesToAxis( cg.refdefViewAngles, cg.refdef.viewaxis );
;1397:   */
;1398:
;1399:	if ( cg.hyperspace ) {
ADDRGP4 cg+92
INDIRI4
CNSTI4 0
EQI4 $1031
line 1400
;1400:		cg.refdef.rdflags |= RDF_NOWORLDMODEL | RDF_HYPERSPACE;
ADDRLP4 88
ADDRGP4 cg+3616+76
ASGNP4
ADDRLP4 88
INDIRP4
ADDRLP4 88
INDIRP4
INDIRI4
CNSTI4 5
BORI4
ASGNI4
line 1401
;1401:	}
LABELV $1031
line 1404
;1402:
;1403:	// field of view
;1404:	return CG_CalcFov();
ADDRLP4 88
ADDRGP4 CG_CalcFov
CALLI4
ASGNI4
ADDRLP4 88
INDIRI4
RETI4
LABELV $946
endproc CG_CalcViewValues 92 12
proc CG_PowerupTimerSounds 16 0
line 1413
;1405:}
;1406:
;1407:
;1408:/*
;1409:=====================
;1410:CG_PowerupTimerSounds
;1411:=====================
;1412:*/
;1413:static void CG_PowerupTimerSounds( void ) {
line 1418
;1414:	int		i;
;1415:	int		t;
;1416:
;1417:	// powerup timers going away
;1418:	for ( i = 0 ; i < MAX_POWERUPS ; i++ ) {
ADDRLP4 4
CNSTI4 0
ASGNI4
LABELV $1037
line 1419
;1419:		t = cg.snap->ps.powerups[i];
ADDRLP4 0
ADDRLP4 4
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 cg+36
INDIRP4
CNSTI4 388
ADDP4
ADDP4
INDIRI4
ASGNI4
line 1420
;1420:		if ( t <= cg.time ) {
ADDRLP4 0
INDIRI4
ADDRGP4 cg+64
INDIRI4
GTI4 $1042
line 1421
;1421:			continue;
ADDRGP4 $1038
JUMPV
LABELV $1042
line 1423
;1422:		}
;1423:		if ( t - cg.time >= POWERUP_BLINKS * POWERUP_BLINK_TIME ) {
ADDRLP4 0
INDIRI4
ADDRGP4 cg+64
INDIRI4
SUBI4
CNSTI4 5000
LTI4 $1045
line 1424
;1424:			continue;
ADDRGP4 $1038
JUMPV
LABELV $1045
line 1426
;1425:		}
;1426:		if ( ( t - cg.time ) / POWERUP_BLINK_TIME != ( t - cg.oldTime ) / POWERUP_BLINK_TIME ) {
ADDRLP4 12
CNSTI4 1000
ASGNI4
ADDRLP4 0
INDIRI4
ADDRGP4 cg+64
INDIRI4
SUBI4
ADDRLP4 12
INDIRI4
DIVI4
ADDRLP4 0
INDIRI4
ADDRGP4 cg+68
INDIRI4
SUBI4
ADDRLP4 12
INDIRI4
DIVI4
EQI4 $1048
line 1428
;1427:			//trap_S_StartSound( NULL, cg.snap->ps.clientNum, CHAN_ITEM, cgs.media.wearOffSound );
;1428:		}
LABELV $1048
line 1429
;1429:	}
LABELV $1038
line 1418
ADDRLP4 4
ADDRLP4 4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 4
INDIRI4
CNSTI4 16
LTI4 $1037
line 1430
;1430:}
LABELV $1036
endproc CG_PowerupTimerSounds 16 0
export CG_AddBufferedSound
proc CG_AddBufferedSound 4 0
line 1437
;1431:
;1432:/*
;1433:=====================
;1434:CG_AddBufferedSound
;1435:=====================
;1436:*/
;1437:void CG_AddBufferedSound( sfxHandle_t sfx ) {
line 1438
;1438:	if ( !sfx )
ADDRFP4 0
INDIRI4
CNSTI4 0
NEI4 $1053
line 1439
;1439:		return;
ADDRGP4 $1052
JUMPV
LABELV $1053
line 1440
;1440:	cg.soundBuffer[cg.soundBufferIn] = sfx;
ADDRGP4 cg+13248
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 cg+13260
ADDP4
ADDRFP4 0
INDIRI4
ASGNI4
line 1441
;1441:	cg.soundBufferIn = (cg.soundBufferIn + 1) % MAX_SOUNDBUFFER;
ADDRGP4 cg+13248
ADDRGP4 cg+13248
INDIRI4
CNSTI4 1
ADDI4
CNSTI4 20
MODI4
ASGNI4
line 1442
;1442:	if (cg.soundBufferIn == cg.soundBufferOut) {
ADDRGP4 cg+13248
INDIRI4
ADDRGP4 cg+13252
INDIRI4
NEI4 $1059
line 1443
;1443:		cg.soundBufferOut++;
ADDRLP4 0
ADDRGP4 cg+13252
ASGNP4
ADDRLP4 0
INDIRP4
ADDRLP4 0
INDIRP4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 1444
;1444:	}
LABELV $1059
line 1445
;1445:}
LABELV $1052
endproc CG_AddBufferedSound 4 0
proc CG_PlayBufferedSounds 0 8
line 1452
;1446:
;1447:/*
;1448:=====================
;1449:CG_PlayBufferedSounds
;1450:=====================
;1451:*/
;1452:static void CG_PlayBufferedSounds( void ) {
line 1453
;1453:	if ( cg.soundTime < cg.time ) {
ADDRGP4 cg+13256
INDIRI4
ADDRGP4 cg+64
INDIRI4
GEI4 $1065
line 1454
;1454:		if (cg.soundBufferOut != cg.soundBufferIn && cg.soundBuffer[cg.soundBufferOut]) {
ADDRGP4 cg+13252
INDIRI4
ADDRGP4 cg+13248
INDIRI4
EQI4 $1069
ADDRGP4 cg+13252
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 cg+13260
ADDP4
INDIRI4
CNSTI4 0
EQI4 $1069
line 1455
;1455:			trap_S_StartLocalSound(cg.soundBuffer[cg.soundBufferOut], CHAN_ANNOUNCER);
ADDRGP4 cg+13252
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 cg+13260
ADDP4
INDIRI4
ARGI4
CNSTI4 7
ARGI4
ADDRGP4 trap_S_StartLocalSound
CALLV
pop
line 1456
;1456:			cg.soundBuffer[cg.soundBufferOut] = 0;
ADDRGP4 cg+13252
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 cg+13260
ADDP4
CNSTI4 0
ASGNI4
line 1457
;1457:			cg.soundBufferOut = (cg.soundBufferOut + 1) % MAX_SOUNDBUFFER;
ADDRGP4 cg+13252
ADDRGP4 cg+13252
INDIRI4
CNSTI4 1
ADDI4
CNSTI4 20
MODI4
ASGNI4
line 1458
;1458:			cg.soundTime = cg.time + 750;
ADDRGP4 cg+13256
ADDRGP4 cg+64
INDIRI4
CNSTI4 750
ADDI4
ASGNI4
line 1459
;1459:		}
LABELV $1069
line 1460
;1460:	}
LABELV $1065
line 1461
;1461:}
LABELV $1064
endproc CG_PlayBufferedSounds 0 8
export CG_UpdateSoundTrackers
proc CG_UpdateSoundTrackers 16 8
line 1464
;1462:
;1463:void CG_UpdateSoundTrackers()
;1464:{
line 1468
;1465:	int num;
;1466:	centity_t *cent;
;1467:
;1468:	for ( num = 0 ; num < ENTITYNUM_NONE ; num++ )
ADDRLP4 4
CNSTI4 0
ASGNI4
LABELV $1084
line 1469
;1469:	{
line 1470
;1470:		cent = &cg_entities[num];
ADDRLP4 0
CNSTI4 1920
ADDRLP4 4
INDIRI4
MULI4
ADDRGP4 cg_entities
ADDP4
ASGNP4
line 1472
;1471:
;1472:		if (cent && cent->currentState.eFlags & EF_SOUNDTRACKER)
ADDRLP4 0
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $1088
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRI4
CNSTI4 8388608
BANDI4
CNSTI4 0
EQI4 $1088
line 1473
;1473:		{ //keep sound for this entity updated in accordance with its attached entity at all times
line 1474
;1474:			if (cg.snap && cent->currentState.trickedentindex == cg.snap->ps.clientNum)
ADDRGP4 cg+36
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $1090
ADDRLP4 0
INDIRP4
CNSTI4 148
ADDP4
INDIRI4
ADDRGP4 cg+36
INDIRP4
CNSTI4 188
ADDP4
INDIRI4
NEI4 $1090
line 1475
;1475:			{ //this is actually the player, so center the sound origin right on top of us
line 1476
;1476:				VectorCopy(cg.refdef.vieworg, cent->lerpOrigin);
ADDRLP4 0
INDIRP4
CNSTI4 928
ADDP4
ADDRGP4 cg+3616+24
INDIRB
ASGNB 12
line 1477
;1477:				trap_S_UpdateEntityPosition( cent->currentState.number, cent->lerpOrigin );
ADDRLP4 0
INDIRP4
INDIRI4
ARGI4
ADDRLP4 0
INDIRP4
CNSTI4 928
ADDP4
ARGP4
ADDRGP4 trap_S_UpdateEntityPosition
CALLV
pop
line 1478
;1478:			}
ADDRGP4 $1091
JUMPV
LABELV $1090
line 1480
;1479:			else
;1480:			{
line 1481
;1481:				trap_S_UpdateEntityPosition( cent->currentState.number, cg_entities[cent->currentState.trickedentindex].lerpOrigin );
ADDRLP4 0
INDIRP4
INDIRI4
ARGI4
CNSTI4 1920
ADDRLP4 0
INDIRP4
CNSTI4 148
ADDP4
INDIRI4
MULI4
ADDRGP4 cg_entities+928
ADDP4
ARGP4
ADDRGP4 trap_S_UpdateEntityPosition
CALLV
pop
line 1482
;1482:			}
LABELV $1091
line 1483
;1483:		}
LABELV $1088
line 1484
;1484:	}
LABELV $1085
line 1468
ADDRLP4 4
ADDRLP4 4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 4
INDIRI4
CNSTI4 1023
LTI4 $1084
line 1485
;1485:}
LABELV $1083
endproc CG_UpdateSoundTrackers 16 8
export CG_SE_UpdateShake
proc CG_SE_UpdateShake 52 0
line 1500
;1486:
;1487://=========================================================================
;1488:
;1489:/*
;1490:================================
;1491:Screen Effect stuff starts here
;1492:================================
;1493:*/
;1494:#define	CAMERA_DEFAULT_FOV			90.0f
;1495:#define MAX_SHAKE_INTENSITY			16.0f
;1496:
;1497:cgscreffects_t cgScreenEffects;
;1498:
;1499:void CG_SE_UpdateShake( vec3_t origin, vec3_t angles )
;1500:{
line 1505
;1501:	vec3_t	moveDir;
;1502:	float	intensity_scale, intensity;
;1503:	int		i;
;1504:
;1505:	if ( cgScreenEffects.shake_duration <= 0 )
ADDRGP4 cgScreenEffects+12
INDIRI4
CNSTI4 0
GTI4 $1098
line 1506
;1506:		return;
ADDRGP4 $1097
JUMPV
LABELV $1098
line 1508
;1507:
;1508:	if ( cg.time > ( cgScreenEffects.shake_start + cgScreenEffects.shake_duration ) )
ADDRGP4 cg+64
INDIRI4
ADDRGP4 cgScreenEffects+16
INDIRI4
ADDRGP4 cgScreenEffects+12
INDIRI4
ADDI4
LEI4 $1101
line 1509
;1509:	{
line 1510
;1510:		cgScreenEffects.shake_intensity = 0;
ADDRGP4 cgScreenEffects+8
CNSTF4 0
ASGNF4
line 1511
;1511:		cgScreenEffects.shake_duration = 0;
ADDRGP4 cgScreenEffects+12
CNSTI4 0
ASGNI4
line 1512
;1512:		cgScreenEffects.shake_start = 0;
ADDRGP4 cgScreenEffects+16
CNSTI4 0
ASGNI4
line 1513
;1513:		return;
ADDRGP4 $1097
JUMPV
LABELV $1101
line 1516
;1514:	}
;1515:
;1516:	cgScreenEffects.FOV = CAMERA_DEFAULT_FOV;
ADDRGP4 cgScreenEffects
CNSTF4 1119092736
ASGNF4
line 1517
;1517:	cgScreenEffects.FOV2 = CAMERA_DEFAULT_FOV;
ADDRGP4 cgScreenEffects+4
CNSTF4 1119092736
ASGNF4
line 1520
;1518:
;1519:	//intensity_scale now also takes into account FOV with 90.0 as normal
;1520:	intensity_scale = 1.0f - ( (float) ( cg.time - cgScreenEffects.shake_start ) / (float) cgScreenEffects.shake_duration ) * (((cgScreenEffects.FOV+cgScreenEffects.FOV2)/2.0f)/90.0f);
ADDRLP4 20
CNSTF4 1065353216
ADDRGP4 cg+64
INDIRI4
ADDRGP4 cgScreenEffects+16
INDIRI4
SUBI4
CVIF4 4
ADDRGP4 cgScreenEffects+12
INDIRI4
CVIF4 4
DIVF4
ADDRGP4 cgScreenEffects
INDIRF4
ADDRGP4 cgScreenEffects+4
INDIRF4
ADDF4
CNSTF4 1073741824
DIVF4
CNSTF4 1119092736
DIVF4
MULF4
SUBF4
ASGNF4
line 1522
;1521:
;1522:	intensity = cgScreenEffects.shake_intensity * intensity_scale;
ADDRLP4 16
ADDRGP4 cgScreenEffects+8
INDIRF4
ADDRLP4 20
INDIRF4
MULF4
ASGNF4
line 1524
;1523:
;1524:	for ( i = 0; i < 3; i++ )
ADDRLP4 0
CNSTI4 0
ASGNI4
LABELV $1115
line 1525
;1525:	{
line 1526
;1526:		moveDir[i] = ( crandom() * intensity );
ADDRLP4 24
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 4
ADDP4
CNSTF4 1073741824
ADDRLP4 24
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
ADDRLP4 16
INDIRF4
MULF4
ASGNF4
line 1527
;1527:	}
LABELV $1116
line 1524
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 3
LTI4 $1115
line 1530
;1528:
;1529:	//Move the camera
;1530:	VectorAdd( origin, moveDir, origin );
ADDRLP4 24
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 24
INDIRP4
ADDRLP4 24
INDIRP4
INDIRF4
ADDRLP4 4
INDIRF4
ADDF4
ASGNF4
ADDRLP4 28
ADDRFP4 0
INDIRP4
CNSTI4 4
ADDP4
ASGNP4
ADDRLP4 28
INDIRP4
ADDRLP4 28
INDIRP4
INDIRF4
ADDRLP4 4+4
INDIRF4
ADDF4
ASGNF4
ADDRLP4 32
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
ASGNP4
ADDRLP4 32
INDIRP4
ADDRLP4 32
INDIRP4
INDIRF4
ADDRLP4 4+8
INDIRF4
ADDF4
ASGNF4
line 1532
;1531:
;1532:	for ( i=0; i < 2; i++ ) // Don't do ROLL
ADDRLP4 0
CNSTI4 0
ASGNI4
LABELV $1121
line 1533
;1533:		moveDir[i] = ( crandom() * intensity );
ADDRLP4 36
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ADDRLP4 4
ADDP4
CNSTF4 1073741824
ADDRLP4 36
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
ADDRLP4 16
INDIRF4
MULF4
ASGNF4
LABELV $1122
line 1532
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 2
LTI4 $1121
line 1536
;1534:
;1535:	//Move the angles
;1536:	VectorAdd( angles, moveDir, angles );
ADDRLP4 40
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 40
INDIRP4
ADDRLP4 40
INDIRP4
INDIRF4
ADDRLP4 4
INDIRF4
ADDF4
ASGNF4
ADDRLP4 44
ADDRFP4 4
INDIRP4
CNSTI4 4
ADDP4
ASGNP4
ADDRLP4 44
INDIRP4
ADDRLP4 44
INDIRP4
INDIRF4
ADDRLP4 4+4
INDIRF4
ADDF4
ASGNF4
ADDRLP4 48
ADDRFP4 4
INDIRP4
CNSTI4 8
ADDP4
ASGNP4
ADDRLP4 48
INDIRP4
ADDRLP4 48
INDIRP4
INDIRF4
ADDRLP4 4+8
INDIRF4
ADDF4
ASGNF4
line 1537
;1537:}
LABELV $1097
endproc CG_SE_UpdateShake 52 0
export CG_SE_UpdateMusic
proc CG_SE_UpdateMusic 516 16
line 1540
;1538:
;1539:void CG_SE_UpdateMusic(void)
;1540:{
line 1541
;1541:	if (cgScreenEffects.music_volume_multiplier < 0.1)
ADDRGP4 cgScreenEffects+20
INDIRF4
CNSTF4 1036831949
GEF4 $1128
line 1542
;1542:	{
line 1543
;1543:		cgScreenEffects.music_volume_multiplier = 1.0;
ADDRGP4 cgScreenEffects+20
CNSTF4 1065353216
ASGNF4
line 1544
;1544:		return;
ADDRGP4 $1127
JUMPV
LABELV $1128
line 1547
;1545:	}
;1546:
;1547:	if (cgScreenEffects.music_volume_time < cg.time)
ADDRGP4 cgScreenEffects+24
INDIRI4
ADDRGP4 cg+64
INDIRI4
GEI4 $1132
line 1548
;1548:	{
line 1549
;1549:		if (cgScreenEffects.music_volume_multiplier != 1.0 || cgScreenEffects.music_volume_set)
ADDRGP4 cgScreenEffects+20
INDIRF4
CNSTF4 1065353216
NEF4 $1140
ADDRGP4 cgScreenEffects+28
INDIRI4
CNSTI4 0
EQI4 $1127
LABELV $1140
line 1550
;1550:		{
line 1553
;1551:			char musMultStr[512];
;1552:
;1553:			cgScreenEffects.music_volume_multiplier += 0.1;
ADDRLP4 512
ADDRGP4 cgScreenEffects+20
ASGNP4
ADDRLP4 512
INDIRP4
ADDRLP4 512
INDIRP4
INDIRF4
CNSTF4 1036831949
ADDF4
ASGNF4
line 1554
;1554:			if (cgScreenEffects.music_volume_multiplier > 1.0)
ADDRGP4 cgScreenEffects+20
INDIRF4
CNSTF4 1065353216
LEF4 $1142
line 1555
;1555:			{
line 1556
;1556:				cgScreenEffects.music_volume_multiplier = 1.0;
ADDRGP4 cgScreenEffects+20
CNSTF4 1065353216
ASGNF4
line 1557
;1557:			}
LABELV $1142
line 1559
;1558:
;1559:			Com_sprintf(musMultStr, sizeof(musMultStr), "%f", cgScreenEffects.music_volume_multiplier);
ADDRLP4 0
ARGP4
CNSTI4 512
ARGI4
ADDRGP4 $1146
ARGP4
ADDRGP4 cgScreenEffects+20
INDIRF4
ARGF4
ADDRGP4 Com_sprintf
CALLV
pop
line 1560
;1560:			trap_Cvar_Set("s_musicMult", musMultStr);
ADDRGP4 $1148
ARGP4
ADDRLP4 0
ARGP4
ADDRGP4 trap_Cvar_Set
CALLV
pop
line 1562
;1561:
;1562:			if (cgScreenEffects.music_volume_multiplier == 1.0)
ADDRGP4 cgScreenEffects+20
INDIRF4
CNSTF4 1065353216
NEF4 $1149
line 1563
;1563:			{
line 1564
;1564:				cgScreenEffects.music_volume_set = qfalse;
ADDRGP4 cgScreenEffects+28
CNSTI4 0
ASGNI4
line 1565
;1565:			}
ADDRGP4 $1127
JUMPV
LABELV $1149
line 1567
;1566:			else
;1567:			{
line 1568
;1568:				cgScreenEffects.music_volume_time = cg.time + 200;
ADDRGP4 cgScreenEffects+24
ADDRGP4 cg+64
INDIRI4
CNSTI4 200
ADDI4
ASGNI4
line 1569
;1569:			}
line 1570
;1570:		}
line 1572
;1571:
;1572:		return;
ADDRGP4 $1127
JUMPV
LABELV $1132
line 1575
;1573:	}
;1574:
;1575:	if (!cgScreenEffects.music_volume_set)
ADDRGP4 cgScreenEffects+28
INDIRI4
CNSTI4 0
NEI4 $1155
line 1576
;1576:	{ //if the volume_time is >= cg.time, we should have a volume multiplier set
line 1579
;1577:		char musMultStr[512];
;1578:
;1579:		Com_sprintf(musMultStr, sizeof(musMultStr), "%f", cgScreenEffects.music_volume_multiplier);
ADDRLP4 0
ARGP4
CNSTI4 512
ARGI4
ADDRGP4 $1146
ARGP4
ADDRGP4 cgScreenEffects+20
INDIRF4
ARGF4
ADDRGP4 Com_sprintf
CALLV
pop
line 1580
;1580:		trap_Cvar_Set("s_musicMult", musMultStr);
ADDRGP4 $1148
ARGP4
ADDRLP4 0
ARGP4
ADDRGP4 trap_Cvar_Set
CALLV
pop
line 1581
;1581:		cgScreenEffects.music_volume_set = qtrue;
ADDRGP4 cgScreenEffects+28
CNSTI4 1
ASGNI4
line 1582
;1582:	}
LABELV $1155
line 1583
;1583:}
LABELV $1127
endproc CG_SE_UpdateMusic 516 16
export CG_CalcScreenEffects
proc CG_CalcScreenEffects 0 8
line 1593
;1584:
;1585:/*
;1586:=================
;1587:CG_CalcScreenEffects
;1588:
;1589:Currently just for screen shaking (and music volume management)
;1590:=================
;1591:*/
;1592:void CG_CalcScreenEffects(void)
;1593:{
line 1594
;1594:	CG_SE_UpdateShake(cg.refdef.vieworg, cg.refdefViewAngles);
ADDRGP4 cg+3616+24
ARGP4
ADDRGP4 cg+3984
ARGP4
ADDRGP4 CG_SE_UpdateShake
CALLV
pop
line 1595
;1595:	CG_SE_UpdateMusic();
ADDRGP4 CG_SE_UpdateMusic
CALLV
pop
line 1596
;1596:}
LABELV $1160
endproc CG_CalcScreenEffects 0 8
export CGCam_Shake
proc CGCam_Shake 0 0
line 1599
;1597:
;1598:void CGCam_Shake( float intensity, int duration )
;1599:{
line 1600
;1600:	if ( intensity > MAX_SHAKE_INTENSITY )
ADDRFP4 0
INDIRF4
CNSTF4 1098907648
LEF4 $1165
line 1601
;1601:		intensity = MAX_SHAKE_INTENSITY;
ADDRFP4 0
CNSTF4 1098907648
ASGNF4
LABELV $1165
line 1603
;1602:
;1603:	cgScreenEffects.shake_intensity = intensity;
ADDRGP4 cgScreenEffects+8
ADDRFP4 0
INDIRF4
ASGNF4
line 1604
;1604:	cgScreenEffects.shake_duration = duration;
ADDRGP4 cgScreenEffects+12
ADDRFP4 4
INDIRI4
ASGNI4
line 1605
;1605:	cgScreenEffects.shake_start = cg.time;
ADDRGP4 cgScreenEffects+16
ADDRGP4 cg+64
INDIRI4
ASGNI4
line 1606
;1606:}
LABELV $1164
endproc CGCam_Shake 0 0
export CGCam_SetMusicMult
proc CGCam_SetMusicMult 0 0
line 1609
;1607:
;1608:void CGCam_SetMusicMult( float multiplier, int duration )
;1609:{
line 1610
;1610:	if (multiplier < 0.1f)
ADDRFP4 0
INDIRF4
CNSTF4 1036831949
GEF4 $1172
line 1611
;1611:	{
line 1612
;1612:		multiplier = 0.1f;
ADDRFP4 0
CNSTF4 1036831949
ASGNF4
line 1613
;1613:	}
LABELV $1172
line 1615
;1614:
;1615:	if (multiplier > 1.0f)
ADDRFP4 0
INDIRF4
CNSTF4 1065353216
LEF4 $1174
line 1616
;1616:	{
line 1617
;1617:		multiplier = 1.0f;
ADDRFP4 0
CNSTF4 1065353216
ASGNF4
line 1618
;1618:	}
LABELV $1174
line 1620
;1619:
;1620:	cgScreenEffects.music_volume_multiplier = multiplier;
ADDRGP4 cgScreenEffects+20
ADDRFP4 0
INDIRF4
ASGNF4
line 1621
;1621:	cgScreenEffects.music_volume_time = cg.time + duration;
ADDRGP4 cgScreenEffects+24
ADDRGP4 cg+64
INDIRI4
ADDRFP4 4
INDIRI4
ADDI4
ASGNI4
line 1622
;1622:	cgScreenEffects.music_volume_set = qfalse;
ADDRGP4 cgScreenEffects+28
CNSTI4 0
ASGNI4
line 1623
;1623:}
LABELV $1171
endproc CGCam_SetMusicMult 0 0
export CG_DrawActiveFrame
proc CG_DrawActiveFrame 36 16
line 1638
;1624:
;1625:/*
;1626:================================
;1627:Screen Effect stuff ends here
;1628:================================
;1629:*/
;1630:
;1631:/*
;1632:=================
;1633:CG_DrawActiveFrame
;1634:
;1635:Generates and draws a game scene and status information at the given time.
;1636:=================
;1637:*/
;1638:void CG_DrawActiveFrame( int serverTime, stereoFrame_t stereoView, qboolean demoPlayback ) {
line 1641
;1639:	int		inwater;
;1640:
;1641:	cg.time = serverTime;
ADDRGP4 cg+64
ADDRFP4 0
INDIRI4
ASGNI4
line 1642
;1642:	cg.demoPlayback = demoPlayback;
ADDRGP4 cg+8
ADDRFP4 8
INDIRI4
ASGNI4
line 1644
;1643:
;1644:	if (cg.snap && ui_myteam.integer != cg.snap->ps.persistant[PERS_TEAM])
ADDRGP4 cg+36
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $1183
ADDRGP4 ui_myteam+12
INDIRI4
ADDRGP4 cg+36
INDIRP4
CNSTI4 336
ADDP4
INDIRI4
EQI4 $1183
line 1645
;1645:	{
line 1646
;1646:		trap_Cvar_Set ( "ui_myteam", va("%i", cg.snap->ps.persistant[PERS_TEAM]) );
ADDRGP4 $1189
ARGP4
ADDRGP4 cg+36
INDIRP4
CNSTI4 336
ADDP4
INDIRI4
ARGI4
ADDRLP4 4
ADDRGP4 va
CALLP4
ASGNP4
ADDRGP4 $1188
ARGP4
ADDRLP4 4
INDIRP4
ARGP4
ADDRGP4 trap_Cvar_Set
CALLV
pop
line 1647
;1647:	}
LABELV $1183
line 1650
;1648:
;1649:	// update cvars
;1650:	CG_UpdateCvars();
ADDRGP4 CG_UpdateCvars
CALLV
pop
line 1654
;1651:
;1652:	// if we are only updating the screen as a loading
;1653:	// pacifier, don't even try to read snapshots
;1654:	if ( cg.infoScreenText[0] != 0 ) {
ADDRGP4 cg+4020
INDIRI1
CVII4 1
CNSTI4 0
EQI4 $1191
line 1655
;1655:		CG_DrawInformation();
ADDRGP4 CG_DrawInformation
CALLV
pop
line 1656
;1656:		return;
ADDRGP4 $1180
JUMPV
LABELV $1191
line 1659
;1657:	}
;1658:
;1659:	trap_FX_AdjustTime( cg.time, cg.refdef.vieworg, cg.refdef.viewaxis );
ADDRGP4 cg+64
INDIRI4
ARGI4
ADDRGP4 cg+3616+24
ARGP4
ADDRGP4 cg+3616+36
ARGP4
ADDRGP4 trap_FX_AdjustTime
CALLV
pop
line 1661
;1660:
;1661:	CG_RunLightStyles();
ADDRGP4 CG_RunLightStyles
CALLV
pop
line 1665
;1662:
;1663:	// any looped sounds will be respecified as entities
;1664:	// are added to the render list
;1665:	trap_S_ClearLoopingSounds(qfalse);
CNSTI4 0
ARGI4
ADDRGP4 trap_S_ClearLoopingSounds
CALLV
pop
line 1668
;1666:
;1667:	// clear all the render lists
;1668:	trap_R_ClearScene();
ADDRGP4 trap_R_ClearScene
CALLV
pop
line 1671
;1669:
;1670:	// set up cg.snap and possibly cg.nextSnap
;1671:	CG_ProcessSnapshots();
ADDRGP4 CG_ProcessSnapshots
CALLV
pop
line 1673
;1672:
;1673:	trap_ROFF_UpdateEntities();
ADDRGP4 trap_ROFF_UpdateEntities
CALLV
pop
line 1677
;1674:
;1675:	// if we haven't received any snapshots yet, all
;1676:	// we can draw is the information screen
;1677:	if ( !cg.snap || ( cg.snap->snapFlags & SNAPFLAG_NOT_ACTIVE ) ) {
ADDRGP4 cg+36
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $1203
ADDRGP4 cg+36
INDIRP4
INDIRI4
CNSTI4 2
BANDI4
CNSTI4 0
EQI4 $1199
LABELV $1203
line 1678
;1678:		CG_DrawInformation();
ADDRGP4 CG_DrawInformation
CALLV
pop
line 1679
;1679:		return;
ADDRGP4 $1180
JUMPV
LABELV $1199
line 1683
;1680:	}
;1681:
;1682:	// let the client system know what our weapon and zoom settings are
;1683:	if (cg.snap && cg.snap->ps.saberLockTime > cg.time)
ADDRGP4 cg+36
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $1204
ADDRGP4 cg+36
INDIRP4
CNSTI4 568
ADDP4
INDIRI4
ADDRGP4 cg+64
INDIRI4
LEI4 $1204
line 1684
;1684:	{
line 1685
;1685:		trap_SetUserCmdValue( cg.weaponSelect, 0.01, cg.forceSelect, cg.itemSelect );
ADDRGP4 cg+3508
INDIRI4
ARGI4
CNSTF4 1008981770
ARGF4
ADDRGP4 cg+3512
INDIRI4
ARGI4
ADDRGP4 cg+3516
INDIRI4
ARGI4
ADDRGP4 trap_SetUserCmdValue
CALLV
pop
line 1686
;1686:	}
ADDRGP4 $1205
JUMPV
LABELV $1204
line 1687
;1687:	else if (cg.snap && cg.snap->ps.usingATST)
ADDRGP4 cg+36
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $1212
ADDRGP4 cg+36
INDIRP4
CNSTI4 1360
ADDP4
INDIRI4
CNSTI4 0
EQI4 $1212
line 1688
;1688:	{
line 1689
;1689:		trap_SetUserCmdValue( cg.weaponSelect, 0.2, cg.forceSelect, cg.itemSelect );
ADDRGP4 cg+3508
INDIRI4
ARGI4
CNSTF4 1045220557
ARGF4
ADDRGP4 cg+3512
INDIRI4
ARGI4
ADDRGP4 cg+3516
INDIRI4
ARGI4
ADDRGP4 trap_SetUserCmdValue
CALLV
pop
line 1690
;1690:	}
ADDRGP4 $1213
JUMPV
LABELV $1212
line 1692
;1691:	else
;1692:	{
line 1693
;1693:		trap_SetUserCmdValue( cg.weaponSelect, cg.zoomSensitivity, cg.forceSelect, cg.itemSelect );
ADDRGP4 cg+3508
INDIRI4
ARGI4
ADDRGP4 cg+4016
INDIRF4
ARGF4
ADDRGP4 cg+3512
INDIRI4
ARGI4
ADDRGP4 cg+3516
INDIRI4
ARGI4
ADDRGP4 trap_SetUserCmdValue
CALLV
pop
line 1694
;1694:	}
LABELV $1213
LABELV $1205
line 1697
;1695:
;1696:	// this counter will be bumped for every valid scene we generate
;1697:	cg.clientFrame++;
ADDRLP4 4
ADDRGP4 cg
ASGNP4
ADDRLP4 4
INDIRP4
ADDRLP4 4
INDIRP4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 1700
;1698:
;1699:	// update cg.predictedPlayerState
;1700:	CG_PredictPlayerState();
ADDRGP4 CG_PredictPlayerState
CALLV
pop
line 1703
;1701:
;1702:	// decide on third person view
;1703:	cg.renderingThirdPerson = cg_thirdPerson.integer || (cg.snap->ps.stats[STAT_HEALTH] <= 0);
ADDRLP4 12
CNSTI4 0
ASGNI4
ADDRGP4 cg_thirdPerson+12
INDIRI4
ADDRLP4 12
INDIRI4
NEI4 $1229
ADDRGP4 cg+36
INDIRP4
CNSTI4 260
ADDP4
INDIRI4
ADDRLP4 12
INDIRI4
GTI4 $1227
LABELV $1229
ADDRLP4 8
CNSTI4 1
ASGNI4
ADDRGP4 $1228
JUMPV
LABELV $1227
ADDRLP4 8
CNSTI4 0
ASGNI4
LABELV $1228
ADDRGP4 cg+88
ADDRLP4 8
INDIRI4
ASGNI4
line 1705
;1704:
;1705:	if (cg.snap->ps.stats[STAT_HEALTH] > 0 && (cg.predictedPlayerState.weapon == WP_SABER || cg.predictedPlayerState.usingATST ||
ADDRLP4 16
CNSTI4 0
ASGNI4
ADDRGP4 cg+36
INDIRP4
CNSTI4 260
ADDP4
INDIRI4
ADDRLP4 16
INDIRI4
LEI4 $1230
ADDRGP4 cg+96+148
INDIRI4
CNSTI4 2
EQI4 $1243
ADDRGP4 cg+96+1316
INDIRI4
ADDRLP4 16
INDIRI4
NEI4 $1243
ADDRGP4 cg+96+1248
INDIRI4
CNSTI4 8
EQI4 $1243
ADDRGP4 cg+96+1352
INDIRI4
ADDRLP4 16
INDIRI4
EQI4 $1230
LABELV $1243
line 1707
;1706:		cg.predictedPlayerState.forceHandExtend == HANDEXTEND_KNOCKDOWN || cg.predictedPlayerState.fallingToDeath))
;1707:	{
line 1708
;1708:		if (cg_fpls.integer && cg.predictedPlayerState.weapon == WP_SABER)
ADDRGP4 cg_fpls+12
INDIRI4
CNSTI4 0
EQI4 $1244
ADDRGP4 cg+96+148
INDIRI4
CNSTI4 2
NEI4 $1244
line 1709
;1709:		{ //force to first person for fpls
line 1710
;1710:			cg.renderingThirdPerson = 0;
ADDRGP4 cg+88
CNSTI4 0
ASGNI4
line 1711
;1711:		}
ADDRGP4 $1231
JUMPV
LABELV $1244
line 1713
;1712:		else
;1713:		{
line 1714
;1714:			cg.renderingThirdPerson = 1;
ADDRGP4 cg+88
CNSTI4 1
ASGNI4
line 1715
;1715:		}
line 1716
;1716:	}
ADDRGP4 $1231
JUMPV
LABELV $1230
line 1717
;1717:	else if (cg.snap->ps.zoomMode)
ADDRGP4 cg+36
INDIRP4
CNSTI4 1376
ADDP4
INDIRI4
CNSTI4 0
EQI4 $1251
line 1718
;1718:	{ //always force first person when zoomed
line 1719
;1719:		cg.renderingThirdPerson = 0;
ADDRGP4 cg+88
CNSTI4 0
ASGNI4
line 1720
;1720:	}
LABELV $1251
LABELV $1231
line 1723
;1721:
;1722:	// build cg.refdef
;1723:	inwater = CG_CalcViewValues();
ADDRLP4 20
ADDRGP4 CG_CalcViewValues
CALLI4
ASGNI4
ADDRLP4 0
ADDRLP4 20
INDIRI4
ASGNI4
line 1725
;1724:
;1725:	CG_CalcScreenEffects();
ADDRGP4 CG_CalcScreenEffects
CALLV
pop
line 1728
;1726:
;1727:	// first person blend blobs, done after AnglesToAxis
;1728:	if ( !cg.renderingThirdPerson ) {
ADDRGP4 cg+88
INDIRI4
CNSTI4 0
NEI4 $1255
line 1729
;1729:		CG_DamageBlendBlob();
ADDRGP4 CG_DamageBlendBlob
CALLV
pop
line 1730
;1730:	}
LABELV $1255
line 1733
;1731:
;1732:	// build the render lists
;1733:	if ( !cg.hyperspace ) {
ADDRGP4 cg+92
INDIRI4
CNSTI4 0
NEI4 $1258
line 1734
;1734:		CG_AddPacketEntities();			// adter calcViewValues, so predicted player state is correct
ADDRGP4 CG_AddPacketEntities
CALLV
pop
line 1735
;1735:		CG_AddMarks();
ADDRGP4 CG_AddMarks
CALLV
pop
line 1736
;1736:		CG_AddParticles ();
ADDRGP4 CG_AddParticles
CALLV
pop
line 1737
;1737:		CG_AddLocalEntities();
ADDRGP4 CG_AddLocalEntities
CALLV
pop
line 1738
;1738:	}
LABELV $1258
line 1739
;1739:	CG_AddViewWeapon( &cg.predictedPlayerState );
ADDRGP4 cg+96
ARGP4
ADDRGP4 CG_AddViewWeapon
CALLV
pop
line 1741
;1740:
;1741:	if ( !cg.hyperspace) 
ADDRGP4 cg+92
INDIRI4
CNSTI4 0
NEI4 $1262
line 1742
;1742:	{
line 1743
;1743:		trap_FX_AddScheduledEffects();
ADDRGP4 trap_FX_AddScheduledEffects
CALLV
pop
line 1744
;1744:	}
LABELV $1262
line 1747
;1745:
;1746:	// add buffered sounds
;1747:	CG_PlayBufferedSounds();
ADDRGP4 CG_PlayBufferedSounds
CALLV
pop
line 1750
;1748:
;1749:	// play buffered voice chats
;1750:	CG_PlayBufferedVoiceChats();
ADDRGP4 CG_PlayBufferedVoiceChats
CALLV
pop
line 1753
;1751:
;1752:	// finish up the rest of the refdef
;1753:	if ( cg.testModelEntity.hModel ) {
ADDRGP4 cg+13484+8
INDIRI4
CNSTI4 0
EQI4 $1265
line 1754
;1754:		CG_AddTestModel();
ADDRGP4 CG_AddTestModel
CALLV
pop
line 1755
;1755:	}
LABELV $1265
line 1756
;1756:	cg.refdef.time = cg.time;
ADDRGP4 cg+3616+72
ADDRGP4 cg+64
INDIRI4
ASGNI4
line 1757
;1757:	memcpy( cg.refdef.areamask, cg.snap->areamask, sizeof( cg.refdef.areamask ) );
ADDRGP4 cg+3616+80
ARGP4
ADDRGP4 cg+36
INDIRP4
CNSTI4 12
ADDP4
ARGP4
CNSTI4 32
ARGI4
ADDRGP4 memcpy
CALLP4
pop
line 1760
;1758:
;1759:	// warning sounds when powerup is wearing off
;1760:	CG_PowerupTimerSounds();
ADDRGP4 CG_PowerupTimerSounds
CALLV
pop
line 1763
;1761:
;1762:	// if there are any entities flagged as sound trackers and attached to other entities, update their sound pos
;1763:	CG_UpdateSoundTrackers();
ADDRGP4 CG_UpdateSoundTrackers
CALLV
pop
line 1765
;1764:
;1765:	if (gCGHasFallVector)
ADDRGP4 gCGHasFallVector
INDIRI4
CNSTI4 0
EQI4 $1277
line 1766
;1766:	{
line 1769
;1767:		vec3_t lookAng;
;1768:
;1769:		VectorSubtract(cg.snap->ps.origin, cg.refdef.vieworg, lookAng);
ADDRLP4 24
ADDRGP4 cg+36
INDIRP4
CNSTI4 64
ADDP4
INDIRF4
ADDRGP4 cg+3616+24
INDIRF4
SUBF4
ASGNF4
ADDRLP4 24+4
ADDRGP4 cg+36
INDIRP4
CNSTI4 68
ADDP4
INDIRF4
ADDRGP4 cg+3616+24+4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 24+8
ADDRGP4 cg+36
INDIRP4
CNSTI4 72
ADDP4
INDIRF4
ADDRGP4 cg+3616+24+8
INDIRF4
SUBF4
ASGNF4
line 1770
;1770:		VectorNormalize(lookAng);
ADDRLP4 24
ARGP4
ADDRGP4 VectorNormalize
CALLF4
pop
line 1771
;1771:		vectoangles(lookAng, lookAng);
ADDRLP4 24
ARGP4
ADDRLP4 24
ARGP4
ADDRGP4 vectoangles
CALLV
pop
line 1773
;1772:
;1773:		VectorCopy(gCGFallVector, cg.refdef.vieworg);
ADDRGP4 cg+3616+24
ADDRGP4 gCGFallVector
INDIRB
ASGNB 12
line 1774
;1774:		AnglesToAxis(lookAng, cg.refdef.viewaxis);
ADDRLP4 24
ARGP4
ADDRGP4 cg+3616+36
ARGP4
ADDRGP4 AnglesToAxis
CALLV
pop
line 1775
;1775:	}
LABELV $1277
line 1778
;1776:
;1777:	// update audio positions
;1778:	trap_S_Respatialize( cg.snap->ps.clientNum, cg.refdef.vieworg, cg.refdef.viewaxis, inwater );
ADDRGP4 cg+36
INDIRP4
CNSTI4 188
ADDP4
INDIRI4
ARGI4
ADDRGP4 cg+3616+24
ARGP4
ADDRGP4 cg+3616+36
ARGP4
ADDRLP4 0
INDIRI4
ARGI4
ADDRGP4 trap_S_Respatialize
CALLV
pop
line 1781
;1779:
;1780:	// make sure the lagometerSample and frame timing isn't done twice when in stereo
;1781:	if ( stereoView != STEREO_RIGHT ) {
ADDRFP4 4
INDIRI4
CNSTI4 2
EQI4 $1301
line 1782
;1782:		cg.frametime = cg.time - cg.oldTime;
ADDRGP4 cg+60
ADDRGP4 cg+64
INDIRI4
ADDRGP4 cg+68
INDIRI4
SUBI4
ASGNI4
line 1783
;1783:		if ( cg.frametime < 0 ) {
ADDRGP4 cg+60
INDIRI4
CNSTI4 0
GEI4 $1306
line 1784
;1784:			cg.frametime = 0;
ADDRGP4 cg+60
CNSTI4 0
ASGNI4
line 1785
;1785:		}
LABELV $1306
line 1786
;1786:		cg.oldTime = cg.time;
ADDRGP4 cg+68
ADDRGP4 cg+64
INDIRI4
ASGNI4
line 1787
;1787:		CG_AddLagometerFrameInfo();
ADDRGP4 CG_AddLagometerFrameInfo
CALLV
pop
line 1788
;1788:	}
LABELV $1301
line 1789
;1789:	if (cg_timescale.value != cg_timescaleFadeEnd.value) {
ADDRGP4 cg_timescale+8
INDIRF4
ADDRGP4 cg_timescaleFadeEnd+8
INDIRF4
EQF4 $1312
line 1790
;1790:		if (cg_timescale.value < cg_timescaleFadeEnd.value) {
ADDRGP4 cg_timescale+8
INDIRF4
ADDRGP4 cg_timescaleFadeEnd+8
INDIRF4
GEF4 $1316
line 1791
;1791:			cg_timescale.value += cg_timescaleFadeSpeed.value * ((float)cg.frametime) / 1000;
ADDRLP4 24
ADDRGP4 cg_timescale+8
ASGNP4
ADDRLP4 24
INDIRP4
ADDRLP4 24
INDIRP4
INDIRF4
ADDRGP4 cg_timescaleFadeSpeed+8
INDIRF4
ADDRGP4 cg+60
INDIRI4
CVIF4 4
MULF4
CNSTF4 1148846080
DIVF4
ADDF4
ASGNF4
line 1792
;1792:			if (cg_timescale.value > cg_timescaleFadeEnd.value)
ADDRGP4 cg_timescale+8
INDIRF4
ADDRGP4 cg_timescaleFadeEnd+8
INDIRF4
LEF4 $1317
line 1793
;1793:				cg_timescale.value = cg_timescaleFadeEnd.value;
ADDRGP4 cg_timescale+8
ADDRGP4 cg_timescaleFadeEnd+8
INDIRF4
ASGNF4
line 1794
;1794:		}
ADDRGP4 $1317
JUMPV
LABELV $1316
line 1795
;1795:		else {
line 1796
;1796:			cg_timescale.value -= cg_timescaleFadeSpeed.value * ((float)cg.frametime) / 1000;
ADDRLP4 24
ADDRGP4 cg_timescale+8
ASGNP4
ADDRLP4 24
INDIRP4
ADDRLP4 24
INDIRP4
INDIRF4
ADDRGP4 cg_timescaleFadeSpeed+8
INDIRF4
ADDRGP4 cg+60
INDIRI4
CVIF4 4
MULF4
CNSTF4 1148846080
DIVF4
SUBF4
ASGNF4
line 1797
;1797:			if (cg_timescale.value < cg_timescaleFadeEnd.value)
ADDRGP4 cg_timescale+8
INDIRF4
ADDRGP4 cg_timescaleFadeEnd+8
INDIRF4
GEF4 $1332
line 1798
;1798:				cg_timescale.value = cg_timescaleFadeEnd.value;
ADDRGP4 cg_timescale+8
ADDRGP4 cg_timescaleFadeEnd+8
INDIRF4
ASGNF4
LABELV $1332
line 1799
;1799:		}
LABELV $1317
line 1800
;1800:		if (cg_timescaleFadeSpeed.value) {
ADDRGP4 cg_timescaleFadeSpeed+8
INDIRF4
CNSTF4 0
EQF4 $1338
line 1801
;1801:			trap_Cvar_Set("timescale", va("%f", cg_timescale.value));
ADDRGP4 $1146
ARGP4
ADDRGP4 cg_timescale+8
INDIRF4
ARGF4
ADDRLP4 24
ADDRGP4 va
CALLP4
ASGNP4
ADDRGP4 $1341
ARGP4
ADDRLP4 24
INDIRP4
ARGP4
ADDRGP4 trap_Cvar_Set
CALLV
pop
line 1802
;1802:		}
LABELV $1338
line 1803
;1803:	}
LABELV $1312
line 1806
;1804:
;1805:	// actually issue the rendering calls
;1806:	CG_DrawActive( stereoView );
ADDRFP4 4
INDIRI4
ARGI4
ADDRGP4 CG_DrawActive
CALLV
pop
line 1808
;1807:
;1808:	if ( cg_stats.integer ) {
ADDRGP4 cg_stats+12
INDIRI4
CNSTI4 0
EQI4 $1343
line 1809
;1809:		CG_Printf( "cg.clientFrame:%i\n", cg.clientFrame );
ADDRGP4 $1346
ARGP4
ADDRGP4 cg
INDIRI4
ARGI4
ADDRGP4 CG_Printf
CALLV
pop
line 1810
;1810:	}
LABELV $1343
line 1811
;1811:}
LABELV $1180
endproc CG_DrawActiveFrame 36 16
bss
align 4
LABELV prevTime
skip 4
export zoomFov
align 4
LABELV zoomFov
skip 4
align 4
LABELV updateAngles
skip 4
align 4
LABELV previousTurnTime
skip 4
align 4
LABELV angles_previous
skip 12
import gCGFallVector
import gCGHasFallVector
export cameraIdealLoc
align 4
LABELV cameraIdealLoc
skip 12
export cameraIdealTarget
align 4
LABELV cameraIdealTarget
skip 12
export cameraFocusLoc
align 4
LABELV cameraFocusLoc
skip 12
export cameraFocusAngles
align 4
LABELV cameraFocusAngles
skip 12
export cameraup
align 4
LABELV cameraup
skip 12
export camerafwd
align 4
LABELV camerafwd
skip 12
import CG_SetLightstyle
import CG_RunLightStyles
import CG_ClearLightStyles
import g2WeaponInstances
import CG_CheckPlayerG2Weapons
import CG_CopyG2WeaponInstance
import CG_ShutDownG2Weapons
import CG_InitG2Weapons
import CG_CreateBBRefEnts
import CG_SetGhoul2Info
import CG_Init_CGents
import CG_Init_CG
import trap_G2API_SetNewOrigin
import trap_G2API_SetSurfaceOnOff
import trap_G2API_SetRootSurface
import trap_G2API_SetBoneAnim
import trap_G2API_GetGLAName
import trap_G2API_SetBoneAngles
import trap_G2API_CleanGhoul2Models
import trap_G2API_SetBoltInfo
import trap_G2API_AddBolt
import trap_G2API_RemoveGhoul2Model
import trap_G2API_HasGhoul2ModelOnIndex
import trap_G2API_DuplicateGhoul2Instance
import trap_G2API_CopySpecificGhoul2Model
import trap_G2API_CopyGhoul2Instance
import trap_G2API_GiveMeVectorFromMatrix
import trap_G2API_InitGhoul2Model
import trap_G2API_GetBoltMatrix_NoRecNoRot
import trap_G2API_GetBoltMatrix_NoReconstruct
import trap_G2API_GetBoltMatrix
import trap_G2_HaveWeGhoul2Models
import trap_G2_SetGhoul2ModelIndexes
import trap_G2_ListModelBones
import trap_G2_ListModelSurfaces
import trap_G2API_CollisionDetect
import FX_ForceDrained
import FX_TieLaserAltFireThink
import FX_TieLaserWeaponHitPlayer
import FX_TieLaserWeaponHitWall
import FX_TieLaserProjectileThink
import FX_BlasterWeaponHitPlayer
import FX_BlasterWeaponHitWall
import FX_BlasterAltFireThink
import FX_BlasterProjectileThink
import FX_BryarAltHitPlayer
import FX_BryarHitPlayer
import FX_BryarAltHitWall
import FX_BryarHitWall
import CG_Spark
import FX_TurretHitPlayer
import FX_TurretHitWall
import FX_TurretProjectileThink
import CG_NewParticleArea
import initparticles
import CG_GetStripEdString
import CG_ParticleExplosion
import CG_ParticleMisc
import CG_ParticleDust
import CG_ParticleSparks
import CG_ParticleBulletDebris
import CG_ParticleSnowFlurry
import CG_AddParticleShrapnel
import CG_ParticleSmoke
import CG_ParticleSnow
import CG_AddParticles
import CG_ClearParticles
import trap_ROFF_Purge_Ent
import trap_ROFF_Play
import trap_ROFF_Cache
import trap_ROFF_UpdateEntities
import trap_ROFF_Clean
import trap_CG_RegisterSharedMemory
import trap_SP_GetStringTextString
import trap_SP_Print
import trap_FX_AddSprite
import trap_FX_AddPrimitive
import trap_FX_AddBezier
import trap_FX_AddPoly
import trap_FX_AdjustTime
import trap_FX_FreeSystem
import trap_FX_InitSystem
import trap_FX_AddScheduledEffects
import trap_FX_PlayBoltedEffectID
import trap_FX_PlayEntityEffectID
import trap_FX_PlayEffectID
import trap_FX_PlaySimpleEffectID
import trap_FX_PlayEntityEffect
import trap_FX_PlayEffect
import trap_FX_PlaySimpleEffect
import trap_FX_RegisterEffect
import trap_R_inPVS
import trap_GetEntityToken
import trap_getCameraInfo
import trap_startCamera
import trap_loadCamera
import trap_SnapVector
import trap_CIN_SetExtents
import trap_CIN_DrawCinematic
import trap_CIN_RunCinematic
import trap_CIN_StopCinematic
import trap_CIN_PlayCinematic
import BG_CycleForce
import BG_ProperForceIndex
import BG_CycleInven
import trap_Key_GetKey
import trap_Key_SetCatcher
import trap_Key_GetCatcher
import trap_Key_IsDown
import trap_MemoryRemaining
import testPrintFloat
import testPrintInt
import trap_OpenUIMenu
import trap_SetClientTurnExtent
import trap_SetClientForceAngle
import trap_SetUserCmdValue
import trap_GetUserCmd
import trap_GetCurrentCmdNumber
import trap_GetServerCommand
import trap_GetSnapshot
import trap_GetCurrentSnapshotNumber
import trap_GetGameState
import trap_GetGlconfig
import trap_FX_AddLine
import trap_R_GetBModelVerts
import trap_R_SetLightStyle
import trap_R_GetLightStyle
import trap_R_RemapShader
import trap_R_DrawRotatePic2
import trap_R_DrawRotatePic
import trap_R_LerpTag
import trap_R_ModelBounds
import trap_R_DrawStretchPic
import trap_R_SetColor
import trap_R_RenderScene
import trap_R_LightForPoint
import trap_R_AddLightToScene
import trap_R_AddPolysToScene
import trap_R_AddPolyToScene
import trap_R_AddRefEntityToScene
import trap_R_ClearScene
import trap_AnyLanguage_ReadCharFromString
import trap_Language_UsesSpaces
import trap_Language_IsAsian
import trap_R_Font_DrawString
import trap_R_Font_HeightPixels
import trap_R_Font_StrLenChars
import trap_R_Font_StrLenPixels
import trap_R_RegisterFont
import trap_R_RegisterShaderNoMip
import trap_R_RegisterShader
import trap_R_RegisterSkin
import trap_R_RegisterModel
import trap_R_LoadWorldMap
import trap_S_StopBackgroundTrack
import trap_S_StartBackgroundTrack
import trap_S_RegisterSound
import trap_S_Respatialize
import trap_S_UpdateEntityPosition
import trap_S_AddRealLoopingSound
import trap_S_AddLoopingSound
import trap_S_ClearLoopingSounds
import trap_S_StartLocalSound
import trap_S_StopLoopingSound
import trap_S_StartSound
import trap_S_MuteSound
import trap_CM_MarkFragments
import trap_CM_TransformedBoxTrace
import trap_CM_BoxTrace
import trap_CM_TransformedPointContents
import trap_CM_PointContents
import trap_CM_TempBoxModel
import trap_CM_InlineModel
import trap_CM_NumInlineModels
import trap_CM_LoadMap
import trap_UpdateScreen
import trap_SendClientCommand
import trap_AddCommand
import trap_SendConsoleCommand
import trap_FS_FCloseFile
import trap_FS_Write
import trap_FS_Read
import trap_FS_FOpenFile
import trap_Args
import trap_Argv
import trap_Argc
import trap_Cvar_VariableStringBuffer
import trap_Cvar_Set
import trap_Cvar_Update
import trap_Cvar_Register
import trap_Milliseconds
import trap_Error
import trap_Print
import CG_SagaObjectiveCompleted
import CG_SagaRoundOver
import CG_InitSagaMode
import CG_CheckChangedPredictableEvents
import CG_TransitionPlayerState
import CG_Respawn
import CG_IsMindTricked
import CG_PlayBufferedVoiceChats
import CG_VoiceChatLocal
import CG_ShaderStateChanged
import CG_LoadVoiceChats
import CG_SetConfigValues
import CG_ParseServerinfo
import CG_ExecuteNewServerCommands
import CG_InitConsoleCommands
import CG_ConsoleCommand
import CG_DrawOldTourneyScoreboard
import CG_DrawOldScoreboard
import CG_DrawInformation
import CG_LoadingClient
import CG_LoadingItem
import CG_LoadingString
import CG_ProcessSnapshots
import CG_InitGlass
import CG_TestLine
import CG_SurfaceExplosion
import CG_MakeExplosion
import CG_Bleed
import CG_ScorePlum
import CG_CreateDebris
import CG_GlassShatter
import CG_BubbleTrail
import CG_SmokePuff
import CG_AddLocalEntities
import CG_AllocLocalEntity
import CG_InitLocalEntities
import CG_ImpactMark
import CG_AddMarks
import CG_InitMarkPolys
import CG_OutOfAmmoChange
import CG_DrawIconBackground
import CG_DrawWeaponSelect
import CG_AddPlayerWeapon
import CG_AddViewWeapon
import CG_MissileHitPlayer
import CG_MissileHitWall
import CG_FireWeapon
import CG_RegisterItemVisuals
import CG_RegisterWeapon
import CG_Weapon_f
import CG_PrevWeapon_f
import CG_NextWeapon_f
import CG_GetClientWeaponMuzzleBoltPoint
import TurretClientRun
import ScaleModelAxis
import CG_PositionRotatedEntityOnTag
import CG_PositionEntityOnTag
import CG_AdjustPositionForMover
import CG_Beam
import CG_ManualEntityRender
import CG_AddPacketEntities
import CG_SetEntitySoundPosition
import CG_ReattachLimb
import CG_PainEvent
import CG_EntityEvent
import CG_PlaceString
import CG_CheckEvents
import CG_LoadDeferredPlayers
import CG_PredictPlayerState
import CG_Trace
import CG_PointContents
import CG_BuildSolidList
import CG_PlayerShieldHit
import CG_CustomSound
import CG_NewClientInfo
import CG_AddRefEntityWithPowerups
import CG_ResetPlayerEntity
import CG_Player
import CG_StatusHandle
import CG_OtherTeamHasFlag
import CG_YourTeamHasFlag
import CG_GameTypeString
import CG_CheckOrderPending
import CG_Text_PaintChar
import CG_Draw3DModel
import CG_GetKillerText
import CG_GetGameStatusText
import CG_GetTeamColor
import CG_InitTeamChat
import CG_SetPrintString
import CG_ShowResponseHead
import CG_DeferMenuScript
import CG_RunMenuScript
import CG_OwnerDrawVisible
import CG_GetValue
import CG_SelectNextPlayer
import CG_SelectPrevPlayer
import CG_Text_Height
import CG_Text_Width
import CG_Text_Paint
import CG_OwnerDraw
import CG_DrawTeamBackground
import CG_DrawFlagModel
import CG_DrawActive
import CG_DrawHead
import CG_CenterPrint
import CG_AddLagometerSnapshotInfo
import CG_AddLagometerFrameInfo
import teamChat2
import teamChat1
import systemChat
import drawTeamOverlayModificationCount
import numSortedTeamPlayers
import sortedTeamPlayers
import CG_DrawTopBottom
import CG_DrawSides
import CG_DrawRect
import UI_DrawScaledProportionalString
import UI_DrawProportionalString
import CG_GetColorForHealth
import CG_ColorForHealth
import CG_TileClear
import CG_TeamColor
import CG_FadeColor
import CG_DrawStrlen
import CG_DrawSmallStringColor
import CG_DrawSmallString
import CG_DrawBigStringColor
import CG_DrawBigString
import CG_DrawStringExt
import CG_DrawNumField
import CG_DrawString
import CG_DrawRotatePic2
import CG_DrawRotatePic
import CG_DrawPic
import CG_FillRect
import CG_TestModelAnimate_f
import CG_TestModelSetAnglespost_f
import CG_TestModelSetAnglespre_f
import CG_ListModelBones_f
import CG_ListModelSurfaces_f
import CG_TestModelSurfaceOnOff_f
import CG_TestG2Model_f
import CG_PrevForcePower_f
import CG_NextForcePower_f
import CG_PrevInventory_f
import CG_NextInventory_f
import CG_BuildSpectatorString
import CG_SetScoreSelection
import CG_RankRunFrame
import CG_EventHandling
import CG_MouseEvent
import CG_KeyEvent
import CG_LoadMenus
import CG_LastAttacker
import CG_CrosshairPlayer
import CG_UpdateCvars
import CG_StartMusic
import CG_Error
import CG_Printf
import CG_Argv
import CG_ConfigString
import cg_followCamTransition
import cg_followCam
import cg_roll
import cg_throttle
import cg_debugBB
import ui_myteam
import cg_recordSPDemoName
import cg_recordSPDemo
import cg_singlePlayerActive
import cg_enableBreath
import cg_enableDust
import cg_singlePlayer
import cg_currentSelectedPlayerName
import cg_currentSelectedPlayer
import cg_blueTeamName
import cg_redTeamName
import cg_trueLightning
import cg_noProjectileTrail
import cg_noTaunt
import cg_bigFont
import cg_smallFont
import cg_cameraMode
import cg_timescale
import cg_timescaleFadeSpeed
import cg_timescaleFadeEnd
import cg_cameraOrbitDelay
import cg_cameraOrbit
import pmove_msec
import pmove_fixed
import cg_smoothClients
import cg_hudFiles
import cg_scorePlum
import cg_noVoiceText
import cg_noVoiceChats
import cg_teamChatsOnly
import cg_drawFriend
import cg_deferPlayers
import cg_predictItems
import cg_blood
import cg_paused
import cg_buildScript
import cg_forceModel
import cg_stats
import cg_teamChatHeight
import cg_teamChatTime
import cg_synchronousClients
import cg_drawEnemyInfo
import cg_lagometer
import cg_stereoSeparation
import cg_thirdPersonHorzOffset
import cg_thirdPersonAlpha
import cg_thirdPersonTargetDamp
import cg_thirdPersonCameraDamp
import cg_thirdPersonVertOffset
import cg_thirdPersonPitchOffset
import cg_thirdPersonAngle
import cg_thirdPersonRange
import cg_thirdPerson
import cg_dismember
import cg_animBlend
import cg_auraShell
import cg_speedTrail
import cg_duelHeadAngles
import cg_saberTrail
import cg_saberContact
import cg_saberDynamicMarkTime
import cg_saberDynamicMarks
import cg_fpls
import cg_saberModelTraceEffect
import cg_oldPainSounds
import cg_swingAngles
import cg_zoomFov
import cg_fov
import cg_simpleItems
import cg_ignore
import cg_autoswitch
import cg_tracerLength
import cg_tracerWidth
import cg_tracerChance
import cg_viewsize
import cg_drawGun
import cg_gun_z
import cg_gun_y
import cg_gun_x
import cg_gun_frame
import cg_addMarks
import cg_footsteps
import cg_showmiss
import cg_noPlayerAnims
import cg_nopredict
import cg_errorDecay
import cg_debugEvents
import cg_debugPosition
import cg_debugAnim
import cg_animSpeed
import cg_draw2D
import cg_drawStatus
import cg_crosshairHealth
import cg_crosshairSize
import cg_crosshairY
import cg_crosshairX
import cg_teamOverlayUserinfo
import cg_drawTeamOverlay
import cg_drawRewards
import cg_dynamicCrosshair
import cg_drawScores
import cg_drawCrosshairNames
import cg_drawCrosshair
import cg_drawAmmoWarning
import cg_drawIcons
import cg_draw3dIcons
import cg_drawSnapshot
import cg_drawFPS
import cg_drawTimer
import cg_shadows
import cg_bobroll
import cg_bobpitch
import cg_bobup
import cg_runroll
import cg_runpitch
import cg_centertime
import cg_vehicleTemplates
import cg_vehicles
import VehicleInfo_GetNameForMovementType
import VehicleInfo_GetBitForMovementType
import VehicleInfo_GetNameForWeapon
import VehicleInfo_GetIndexForWeapon
import VehicleInfo_GetBitForWeapon
import VehicleInfo_GetBitForVehicleType
import Vehicle_CopyVehicle
import Vehicle_InitVehicle
import cg_markPolys
import cg_items
import cg_weapons
import cg_entities
import cg
import cgs
export cgScreenEffects
align 4
LABELV cgScreenEffects
skip 32
import ammoTicPos
import forceTicPos
import forcePowerDarkLight
import WeaponAttackAnim
import WeaponReadyAnim
import BG_OutOfMemory
import BG_StringAlloc
import BG_TempFree
import BG_TempAlloc
import BG_AllocUnaligned
import BG_Alloc
import BG_CanUseFPNow
import BG_HasYsalamiri
import BG_GetItemIndexByTag
import BG_ParseAnimationFile
import BG_PlayerTouchesItem
import BG_PlayerStateToEntityStateExtraPolate
import BG_PlayerStateToEntityState
import BG_TouchJumpPad
import BG_AddPredictableEventToPlayerstate
import BG_EvaluateTrajectoryDelta
import BG_EvaluateTrajectory
import BG_ForcePowerDrain
import BG_SaberStartTransAnim
import BG_InDeathAnim
import BG_InRoll
import BG_KnockawayForParry
import BG_BrokenParryForParry
import BG_BrokenParryForAttack
import BG_SaberInSpecialAttack
import BG_SpinningSaberAnim
import BG_FlippingAnim
import BG_SaberInIdle
import BG_SaberInSpecial
import BG_SaberInAttack
import BG_DirectFlippingAnim
import BG_InSaberStandAnim
import BG_InSpecialJump
import BG_LegalizedForcePowers
import saberMoveData
import BG_CanItemBeGrabbed
import BG_FindItemForHoldable
import BG_FindItemForPowerup
import BG_FindItemForWeapon
import BG_FindItem
import vectoyaw
import bg_numItems
import bg_itemlist
import PM_CalculateRelativeViewAngles
import Pmove
import PM_QuaternionViewAngles
import PM_UpdateViewAngles
import pm
import bgForcePowerCost
import forceMasteryPoints
import forceMasteryLevels
import bgGlobalAnimations
import BGPAFtextLoaded
import forcePowerSorted
import WP_MuzzlePoint
import ammoData
import weaponData
import GetStringForID
import GetIDForString
import Q_irand
import irand
import flrand
import Rand_Init
import Com_Printf
import Com_Error
import Info_NextPair
import Info_Validate
import Info_SetValueForKey_Big
import Info_SetValueForKey
import Info_RemoveKey_big
import Info_RemoveKey
import Info_ValueForKey
import va
import Q_CleanStr
import Q_PrintStrlen
import Q_strcat
import Q_strncpyz
import Q_strrchr
import Q_strupr
import Q_strlwr
import Q_stricmpn
import Q_strncmp
import Q_stricmp
import Q_isalpha
import Q_isupper
import Q_islower
import Q_isprint
import Com_sprintf
import Parse3DMatrix
import Parse2DMatrix
import Parse1DMatrix
import SkipRestOfLine
import SkipBracedSection
import COM_MatchToken
import COM_ParseVec4
import COM_ParseFloat
import COM_ParseInt
import COM_ParseString
import COM_ParseWarning
import COM_ParseError
import COM_Compress
import COM_ParseExt
import COM_Parse
import SkipWhitespace
import COM_GetCurrentParseLine
import COM_BeginParseSession
import COM_DefaultExtension
import COM_StripExtension
import COM_SkipPath
import Com_Clamp
import MatrixToEuler
import QuatToAngles
import QuatMul
import AnglesToQuat
import AxisToQuaternion
import QuaternionToAxis
import QuaternionToEuler
import QuatToAxis
import QuaternionMultiply
import QuaternionNormalize
import QuaternionMagnitude
import QuaternionFromString
import AnglesToTieFloats
import AnglesFromTieFloats
import QuaternionToTieFloats
import QuaternionFromTieFloats
import QuaternionCopy
import PerpendicularVector
import AngleVectors
import RotationMatrixAroundDir
import MatrixMultiply
import MakeNormalVectors
import RotateAroundDirection
import RotatePointAroundVector
import ProjectPointOnPlane
import PlaneFromPoints
import AngleDelta
import AngleNormalize180
import AngleNormalize360
import AnglesSubtract
import AngleSubtract
import LerpAngle
import AngleMod
import BoxOnPlaneSide
import SetPlaneSignbits
import AxisCopy
import AxisClear
import AnglesToAxis
import vectoangles
import Q_crandom
import Q_random
import Q_rand
import Q_acos
import Q_log2
import VectorRotate
import Vector4Scale
import VectorNormalize2
import VectorNormalize
import CrossProduct
import VectorInverse
import VectorNormalizeFast
import DistanceSquared
import Distance
import VectorLengthSquared
import VectorLength
import VectorCompare
import AddPointToBounds
import ClearBounds
import RadiusFromBounds
import NormalizeColor
import ColorBytes4
import ColorBytes3
import _VectorMA
import _VectorScale
import _VectorCopy
import _VectorAdd
import _VectorSubtract
import _DotProduct
import ByteToDir
import DirToByte
import powf
import ClampShort
import ClampChar
import Q_rsqrt
import Q_fabs
import axisDefault
import vec3_origin
import g_color_table
import colorDkBlue
import colorLtBlue
import colorDkGrey
import colorMdGrey
import colorLtGrey
import colorWhite
import colorCyan
import colorMagenta
import colorYellow
import colorBlue
import colorGreen
import colorRed
import colorBlack
import colorTable
import bytedirs
import Com_Memcpy
import Com_Memset
import Hunk_Alloc
import forceSpeedLevels
import FloatSwap
import LongSwap
import ShortSwap
import acos
import fabs
import abs
import tan
import atan2
import cos
import sin
import sqrt
import floor
import ceil
import memcpy
import memset
import memmove
import sscanf
import vsprintf
import _atoi
import atoi
import _atof
import atof
import toupper
import tolower
import strncpy
import strstr
import strchr
import strcmp
import strcpy
import strcat
import strlen
import rand
import srand
import qsort
lit
align 1
LABELV $1346
byte 1 99
byte 1 103
byte 1 46
byte 1 99
byte 1 108
byte 1 105
byte 1 101
byte 1 110
byte 1 116
byte 1 70
byte 1 114
byte 1 97
byte 1 109
byte 1 101
byte 1 58
byte 1 37
byte 1 105
byte 1 10
byte 1 0
align 1
LABELV $1341
byte 1 116
byte 1 105
byte 1 109
byte 1 101
byte 1 115
byte 1 99
byte 1 97
byte 1 108
byte 1 101
byte 1 0
align 1
LABELV $1189
byte 1 37
byte 1 105
byte 1 0
align 1
LABELV $1188
byte 1 117
byte 1 105
byte 1 95
byte 1 109
byte 1 121
byte 1 116
byte 1 101
byte 1 97
byte 1 109
byte 1 0
align 1
LABELV $1148
byte 1 115
byte 1 95
byte 1 109
byte 1 117
byte 1 115
byte 1 105
byte 1 99
byte 1 77
byte 1 117
byte 1 108
byte 1 116
byte 1 0
align 1
LABELV $1146
byte 1 37
byte 1 102
byte 1 0
align 1
LABELV $288
byte 1 49
byte 1 48
byte 1 48
byte 1 0
align 1
LABELV $284
byte 1 51
byte 1 48
byte 1 0
align 1
LABELV $283
byte 1 99
byte 1 103
byte 1 95
byte 1 118
byte 1 105
byte 1 101
byte 1 119
byte 1 115
byte 1 105
byte 1 122
byte 1 101
byte 1 0
align 1
LABELV $209
byte 1 115
byte 1 107
byte 1 105
byte 1 110
byte 1 32
byte 1 37
byte 1 105
byte 1 10
byte 1 0
align 1
LABELV $192
byte 1 102
byte 1 114
byte 1 97
byte 1 109
byte 1 101
byte 1 32
byte 1 37
byte 1 105
byte 1 10
byte 1 0
align 1
LABELV $153
byte 1 67
byte 1 97
byte 1 110
byte 1 39
byte 1 116
byte 1 32
byte 1 114
byte 1 101
byte 1 103
byte 1 105
byte 1 115
byte 1 116
byte 1 101
byte 1 114
byte 1 32
byte 1 109
byte 1 111
byte 1 100
byte 1 101
byte 1 108
byte 1 10
byte 1 0
