export CG_BubbleTrail
code
proc CG_BubbleTrail 96 4
file "../cg_effects.c"
line 15
;1:// Copyright (C) 1999-2000 Id Software, Inc.
;2://
;3:// cg_effects.c -- these functions generate localentities, usually as a result
;4:// of event processing
;5:
;6:#include "cg_local.h"
;7:
;8:/*
;9:==================
;10:CG_BubbleTrail
;11:
;12:Bullets shot underwater
;13:==================
;14:*/
;15:void CG_BubbleTrail( vec3_t start, vec3_t end, float spacing ) {
line 21
;16:	vec3_t		move;
;17:	vec3_t		vec;
;18:	float		len;
;19:	int			i;
;20:
;21:	if ( cg_noProjectileTrail.integer ) {
ADDRGP4 cg_noProjectileTrail+12
INDIRI4
CNSTI4 0
EQI4 $132
line 22
;22:		return;
ADDRGP4 $131
JUMPV
LABELV $132
line 25
;23:	}
;24:
;25:	VectorCopy (start, move);
ADDRLP4 0
ADDRFP4 0
INDIRP4
INDIRB
ASGNB 12
line 26
;26:	VectorSubtract (end, start, vec);
ADDRLP4 32
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 36
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 12
ADDRLP4 32
INDIRP4
INDIRF4
ADDRLP4 36
INDIRP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 40
CNSTI4 4
ASGNI4
ADDRLP4 12+4
ADDRLP4 32
INDIRP4
ADDRLP4 40
INDIRI4
ADDP4
INDIRF4
ADDRLP4 36
INDIRP4
ADDRLP4 40
INDIRI4
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 44
CNSTI4 8
ASGNI4
ADDRLP4 12+8
ADDRFP4 4
INDIRP4
ADDRLP4 44
INDIRI4
ADDP4
INDIRF4
ADDRFP4 0
INDIRP4
ADDRLP4 44
INDIRI4
ADDP4
INDIRF4
SUBF4
ASGNF4
line 27
;27:	len = VectorNormalize (vec);
ADDRLP4 12
ARGP4
ADDRLP4 48
ADDRGP4 VectorNormalize
CALLF4
ASGNF4
ADDRLP4 28
ADDRLP4 48
INDIRF4
ASGNF4
line 30
;28:
;29:	// advance a random amount first
;30:	i = rand() % (int)spacing;
ADDRLP4 52
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 24
ADDRLP4 52
INDIRI4
ADDRFP4 8
INDIRF4
CVFI4 4
MODI4
ASGNI4
line 31
;31:	VectorMA( move, i, vec, move );
ADDRLP4 56
ADDRLP4 24
INDIRI4
CVIF4 4
ASGNF4
ADDRLP4 0
ADDRLP4 0
INDIRF4
ADDRLP4 12
INDIRF4
ADDRLP4 56
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 0+4
INDIRF4
ADDRLP4 12+4
INDIRF4
ADDRLP4 56
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRLP4 0+8
INDIRF4
ADDRLP4 12+8
INDIRF4
ADDRLP4 24
INDIRI4
CVIF4 4
MULF4
ADDF4
ASGNF4
line 33
;32:
;33:	VectorScale (vec, spacing, vec);
ADDRLP4 60
ADDRFP4 8
INDIRF4
ASGNF4
ADDRLP4 12
ADDRLP4 12
INDIRF4
ADDRLP4 60
INDIRF4
MULF4
ASGNF4
ADDRLP4 12+4
ADDRLP4 12+4
INDIRF4
ADDRLP4 60
INDIRF4
MULF4
ASGNF4
ADDRLP4 12+8
ADDRLP4 12+8
INDIRF4
ADDRFP4 8
INDIRF4
MULF4
ASGNF4
line 35
;34:
;35:	for ( ; i < len; i += spacing ) {
ADDRGP4 $150
JUMPV
LABELV $147
line 39
;36:		localEntity_t	*le;
;37:		refEntity_t		*re;
;38:
;39:		le = CG_AllocLocalEntity();
ADDRLP4 72
ADDRGP4 CG_AllocLocalEntity
CALLP4
ASGNP4
ADDRLP4 64
ADDRLP4 72
INDIRP4
ASGNP4
line 40
;40:		le->leFlags = LEF_PUFF_DONT_SCALE;
ADDRLP4 64
INDIRP4
CNSTI4 12
ADDP4
CNSTI4 1
ASGNI4
line 41
;41:		le->leType = LE_MOVE_SCALE_FADE;
ADDRLP4 64
INDIRP4
CNSTI4 8
ADDP4
CNSTI4 6
ASGNI4
line 42
;42:		le->startTime = cg.time;
ADDRLP4 64
INDIRP4
CNSTI4 16
ADDP4
ADDRGP4 cg+64
INDIRI4
ASGNI4
line 43
;43:		le->endTime = cg.time + 1000 + random() * 250;
ADDRLP4 76
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 64
INDIRP4
CNSTI4 20
ADDP4
ADDRGP4 cg+64
INDIRI4
CNSTI4 1000
ADDI4
CVIF4 4
CNSTF4 1132068864
ADDRLP4 76
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
MULF4
ADDF4
CVFI4 4
ASGNI4
line 44
;44:		le->lifeRate = 1.0 / ( le->endTime - le->startTime );
ADDRLP4 64
INDIRP4
CNSTI4 28
ADDP4
CNSTF4 1065353216
ADDRLP4 64
INDIRP4
CNSTI4 20
ADDP4
INDIRI4
ADDRLP4 64
INDIRP4
CNSTI4 16
ADDP4
INDIRI4
SUBI4
CVIF4 4
DIVF4
ASGNF4
line 46
;45:
;46:		re = &le->refEntity;
ADDRLP4 68
ADDRLP4 64
INDIRP4
CNSTI4 248
ADDP4
ASGNP4
line 47
;47:		re->shaderTime = cg.time / 1000.0f;
ADDRLP4 68
INDIRP4
CNSTI4 100
ADDP4
ADDRGP4 cg+64
INDIRI4
CVIF4 4
CNSTF4 1148846080
DIVF4
ASGNF4
line 49
;48:
;49:		re->reType = RT_SPRITE;
ADDRLP4 68
INDIRP4
CNSTI4 2
ASGNI4
line 50
;50:		re->rotation = 0;
ADDRLP4 68
INDIRP4
CNSTI4 96
ADDP4
CNSTF4 0
ASGNF4
line 51
;51:		re->radius = 3;
ADDRLP4 68
INDIRP4
CNSTI4 92
ADDP4
CNSTF4 1077936128
ASGNF4
line 52
;52:		re->customShader = cgs.media.waterBubbleShader;
ADDRLP4 68
INDIRP4
CNSTI4 76
ADDP4
ADDRGP4 cgs+71064+256
INDIRI4
ASGNI4
line 53
;53:		re->shaderRGBA[0] = 0xff;
ADDRLP4 68
INDIRP4
CNSTI4 80
ADDP4
CNSTU1 255
ASGNU1
line 54
;54:		re->shaderRGBA[1] = 0xff;
ADDRLP4 68
INDIRP4
CNSTI4 81
ADDP4
CNSTU1 255
ASGNU1
line 55
;55:		re->shaderRGBA[2] = 0xff;
ADDRLP4 68
INDIRP4
CNSTI4 82
ADDP4
CNSTU1 255
ASGNU1
line 56
;56:		re->shaderRGBA[3] = 0xff;
ADDRLP4 68
INDIRP4
CNSTI4 83
ADDP4
CNSTU1 255
ASGNU1
line 58
;57:
;58:		le->color[3] = 1.0;
ADDRLP4 64
INDIRP4
CNSTI4 136
ADDP4
CNSTF4 1065353216
ASGNF4
line 60
;59:
;60:		le->pos.trType = TR_LINEAR;
ADDRLP4 64
INDIRP4
CNSTI4 32
ADDP4
CNSTI4 2
ASGNI4
line 61
;61:		le->pos.trTime = cg.time;
ADDRLP4 64
INDIRP4
CNSTI4 36
ADDP4
ADDRGP4 cg+64
INDIRI4
ASGNI4
line 62
;62:		VectorCopy( move, le->pos.trBase );
ADDRLP4 64
INDIRP4
CNSTI4 44
ADDP4
ADDRLP4 0
INDIRB
ASGNB 12
line 63
;63:		le->pos.trDelta[0] = crandom()*5;
ADDRLP4 84
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 64
INDIRP4
CNSTI4 56
ADDP4
CNSTF4 1084227584
CNSTF4 1073741824
ADDRLP4 84
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ASGNF4
line 64
;64:		le->pos.trDelta[1] = crandom()*5;
ADDRLP4 88
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 64
INDIRP4
CNSTI4 60
ADDP4
CNSTF4 1084227584
CNSTF4 1073741824
ADDRLP4 88
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ASGNF4
line 65
;65:		le->pos.trDelta[2] = crandom()*5 + 6;
ADDRLP4 92
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 64
INDIRP4
CNSTI4 64
ADDP4
CNSTF4 1084227584
CNSTF4 1073741824
ADDRLP4 92
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
CNSTF4 1086324736
ADDF4
ASGNF4
line 67
;66:
;67:		VectorAdd (move, vec, move);
ADDRLP4 0
ADDRLP4 0
INDIRF4
ADDRLP4 12
INDIRF4
ADDF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 0+4
INDIRF4
ADDRLP4 12+4
INDIRF4
ADDF4
ASGNF4
ADDRLP4 0+8
ADDRLP4 0+8
INDIRF4
ADDRLP4 12+8
INDIRF4
ADDF4
ASGNF4
line 68
;68:	}
LABELV $148
line 35
ADDRLP4 24
ADDRLP4 24
INDIRI4
CVIF4 4
ADDRFP4 8
INDIRF4
ADDF4
CVFI4 4
ASGNI4
LABELV $150
ADDRLP4 24
INDIRI4
CVIF4 4
ADDRLP4 28
INDIRF4
LTF4 $147
line 69
;69:}
LABELV $131
endproc CG_BubbleTrail 96 4
data
align 4
LABELV $164
byte 4 146
export CG_SmokePuff
code
proc CG_SmokePuff 52 4
line 85
;70:
;71:/*
;72:=====================
;73:CG_SmokePuff
;74:
;75:Adds a smoke puff or blood trail localEntity.
;76:=====================
;77:*/
;78:localEntity_t *CG_SmokePuff( const vec3_t p, const vec3_t vel, 
;79:				   float radius,
;80:				   float r, float g, float b, float a,
;81:				   float duration,
;82:				   int startTime,
;83:				   int fadeInTime,
;84:				   int leFlags,
;85:				   qhandle_t hShader ) {
line 91
;86:	static int	seed = 0x92;
;87:	localEntity_t	*le;
;88:	refEntity_t		*re;
;89://	int fadeInTime = startTime + duration / 2;
;90:
;91:	le = CG_AllocLocalEntity();
ADDRLP4 8
ADDRGP4 CG_AllocLocalEntity
CALLP4
ASGNP4
ADDRLP4 0
ADDRLP4 8
INDIRP4
ASGNP4
line 92
;92:	le->leFlags = leFlags;
ADDRLP4 0
INDIRP4
CNSTI4 12
ADDP4
ADDRFP4 40
INDIRI4
ASGNI4
line 93
;93:	le->radius = radius;
ADDRLP4 0
INDIRP4
CNSTI4 140
ADDP4
ADDRFP4 8
INDIRF4
ASGNF4
line 95
;94:
;95:	re = &le->refEntity;
ADDRLP4 4
ADDRLP4 0
INDIRP4
CNSTI4 248
ADDP4
ASGNP4
line 96
;96:	re->rotation = Q_random( &seed ) * 360;
ADDRGP4 $164
ARGP4
ADDRLP4 12
ADDRGP4 Q_random
CALLF4
ASGNF4
ADDRLP4 4
INDIRP4
CNSTI4 96
ADDP4
CNSTF4 1135869952
ADDRLP4 12
INDIRF4
MULF4
ASGNF4
line 97
;97:	re->radius = radius;
ADDRLP4 4
INDIRP4
CNSTI4 92
ADDP4
ADDRFP4 8
INDIRF4
ASGNF4
line 98
;98:	re->shaderTime = startTime / 1000.0f;
ADDRLP4 4
INDIRP4
CNSTI4 100
ADDP4
ADDRFP4 32
INDIRI4
CVIF4 4
CNSTF4 1148846080
DIVF4
ASGNF4
line 100
;99:
;100:	le->leType = LE_MOVE_SCALE_FADE;
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
CNSTI4 6
ASGNI4
line 101
;101:	le->startTime = startTime;
ADDRLP4 0
INDIRP4
CNSTI4 16
ADDP4
ADDRFP4 32
INDIRI4
ASGNI4
line 102
;102:	le->fadeInTime = fadeInTime;
ADDRLP4 0
INDIRP4
CNSTI4 24
ADDP4
ADDRFP4 36
INDIRI4
ASGNI4
line 103
;103:	le->endTime = startTime + duration;
ADDRLP4 0
INDIRP4
CNSTI4 20
ADDP4
ADDRFP4 32
INDIRI4
CVIF4 4
ADDRFP4 28
INDIRF4
ADDF4
CVFI4 4
ASGNI4
line 104
;104:	if ( fadeInTime > startTime ) {
ADDRFP4 36
INDIRI4
ADDRFP4 32
INDIRI4
LEI4 $165
line 105
;105:		le->lifeRate = 1.0 / ( le->endTime - le->fadeInTime );
ADDRLP4 0
INDIRP4
CNSTI4 28
ADDP4
CNSTF4 1065353216
ADDRLP4 0
INDIRP4
CNSTI4 20
ADDP4
INDIRI4
ADDRLP4 0
INDIRP4
CNSTI4 24
ADDP4
INDIRI4
SUBI4
CVIF4 4
DIVF4
ASGNF4
line 106
;106:	}
ADDRGP4 $166
JUMPV
LABELV $165
line 107
;107:	else {
line 108
;108:		le->lifeRate = 1.0 / ( le->endTime - le->startTime );
ADDRLP4 0
INDIRP4
CNSTI4 28
ADDP4
CNSTF4 1065353216
ADDRLP4 0
INDIRP4
CNSTI4 20
ADDP4
INDIRI4
ADDRLP4 0
INDIRP4
CNSTI4 16
ADDP4
INDIRI4
SUBI4
CVIF4 4
DIVF4
ASGNF4
line 109
;109:	}
LABELV $166
line 110
;110:	le->color[0] = r;
ADDRLP4 0
INDIRP4
CNSTI4 124
ADDP4
ADDRFP4 12
INDIRF4
ASGNF4
line 111
;111:	le->color[1] = g; 
ADDRLP4 0
INDIRP4
CNSTI4 128
ADDP4
ADDRFP4 16
INDIRF4
ASGNF4
line 112
;112:	le->color[2] = b;
ADDRLP4 0
INDIRP4
CNSTI4 132
ADDP4
ADDRFP4 20
INDIRF4
ASGNF4
line 113
;113:	le->color[3] = a;
ADDRLP4 0
INDIRP4
CNSTI4 136
ADDP4
ADDRFP4 24
INDIRF4
ASGNF4
line 116
;114:
;115:
;116:	le->pos.trType = TR_LINEAR;
ADDRLP4 0
INDIRP4
CNSTI4 32
ADDP4
CNSTI4 2
ASGNI4
line 117
;117:	le->pos.trTime = startTime;
ADDRLP4 0
INDIRP4
CNSTI4 36
ADDP4
ADDRFP4 32
INDIRI4
ASGNI4
line 118
;118:	VectorCopy( vel, le->pos.trDelta );
ADDRLP4 0
INDIRP4
CNSTI4 56
ADDP4
ADDRFP4 4
INDIRP4
INDIRB
ASGNB 12
line 119
;119:	VectorCopy( p, le->pos.trBase );
ADDRLP4 0
INDIRP4
CNSTI4 44
ADDP4
ADDRFP4 0
INDIRP4
INDIRB
ASGNB 12
line 121
;120:
;121:	VectorCopy( p, re->origin );
ADDRLP4 4
INDIRP4
CNSTI4 52
ADDP4
ADDRFP4 0
INDIRP4
INDIRB
ASGNB 12
line 122
;122:	re->customShader = hShader;
ADDRLP4 4
INDIRP4
CNSTI4 76
ADDP4
ADDRFP4 44
INDIRI4
ASGNI4
line 124
;123:
;124:	re->shaderRGBA[0] = le->color[0] * 0xff;
ADDRLP4 20
CNSTF4 1132396544
ADDRLP4 0
INDIRP4
CNSTI4 124
ADDP4
INDIRF4
MULF4
ASGNF4
ADDRLP4 24
CNSTF4 1325400064
ASGNF4
ADDRLP4 20
INDIRF4
ADDRLP4 24
INDIRF4
LTF4 $168
ADDRLP4 16
ADDRLP4 20
INDIRF4
ADDRLP4 24
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $169
JUMPV
LABELV $168
ADDRLP4 16
ADDRLP4 20
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $169
ADDRLP4 4
INDIRP4
CNSTI4 80
ADDP4
ADDRLP4 16
INDIRU4
CVUU1 4
ASGNU1
line 125
;125:	re->shaderRGBA[1] = le->color[1] * 0xff;
ADDRLP4 32
CNSTF4 1132396544
ADDRLP4 0
INDIRP4
CNSTI4 128
ADDP4
INDIRF4
MULF4
ASGNF4
ADDRLP4 36
CNSTF4 1325400064
ASGNF4
ADDRLP4 32
INDIRF4
ADDRLP4 36
INDIRF4
LTF4 $171
ADDRLP4 28
ADDRLP4 32
INDIRF4
ADDRLP4 36
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $172
JUMPV
LABELV $171
ADDRLP4 28
ADDRLP4 32
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $172
ADDRLP4 4
INDIRP4
CNSTI4 81
ADDP4
ADDRLP4 28
INDIRU4
CVUU1 4
ASGNU1
line 126
;126:	re->shaderRGBA[2] = le->color[2] * 0xff;
ADDRLP4 44
CNSTF4 1132396544
ADDRLP4 0
INDIRP4
CNSTI4 132
ADDP4
INDIRF4
MULF4
ASGNF4
ADDRLP4 48
CNSTF4 1325400064
ASGNF4
ADDRLP4 44
INDIRF4
ADDRLP4 48
INDIRF4
LTF4 $174
ADDRLP4 40
ADDRLP4 44
INDIRF4
ADDRLP4 48
INDIRF4
SUBF4
CVFI4 4
CVIU4 4
CNSTU4 2147483648
ADDU4
ASGNU4
ADDRGP4 $175
JUMPV
LABELV $174
ADDRLP4 40
ADDRLP4 44
INDIRF4
CVFI4 4
CVIU4 4
ASGNU4
LABELV $175
ADDRLP4 4
INDIRP4
CNSTI4 82
ADDP4
ADDRLP4 40
INDIRU4
CVUU1 4
ASGNU1
line 127
;127:	re->shaderRGBA[3] = 0xff;
ADDRLP4 4
INDIRP4
CNSTI4 83
ADDP4
CNSTU1 255
ASGNU1
line 129
;128:
;129:	re->reType = RT_SPRITE;
ADDRLP4 4
INDIRP4
CNSTI4 2
ASGNI4
line 130
;130:	re->radius = le->radius;
ADDRLP4 4
INDIRP4
CNSTI4 92
ADDP4
ADDRLP4 0
INDIRP4
CNSTI4 140
ADDP4
INDIRF4
ASGNF4
line 132
;131:
;132:	return le;
ADDRLP4 0
INDIRP4
RETP4
LABELV $163
endproc CG_SmokePuff 52 4
export CG_TestLine
proc CG_TestLine 29 0
line 135
;133:}
;134:
;135:void CG_TestLine( vec3_t start, vec3_t end, int time, unsigned int color, int radius) {
line 139
;136:	localEntity_t	*le;
;137:	refEntity_t		*re;
;138:
;139:	le = CG_AllocLocalEntity();
ADDRLP4 8
ADDRGP4 CG_AllocLocalEntity
CALLP4
ASGNP4
ADDRLP4 4
ADDRLP4 8
INDIRP4
ASGNP4
line 140
;140:	le->leType = LE_LINE;
ADDRLP4 4
INDIRP4
CNSTI4 8
ADDP4
CNSTI4 13
ASGNI4
line 141
;141:	le->startTime = cg.time;
ADDRLP4 4
INDIRP4
CNSTI4 16
ADDP4
ADDRGP4 cg+64
INDIRI4
ASGNI4
line 142
;142:	le->endTime = cg.time + time;
ADDRLP4 4
INDIRP4
CNSTI4 20
ADDP4
ADDRGP4 cg+64
INDIRI4
ADDRFP4 8
INDIRI4
ADDI4
ASGNI4
line 143
;143:	le->lifeRate = 1.0 / ( le->endTime - le->startTime );
ADDRLP4 4
INDIRP4
CNSTI4 28
ADDP4
CNSTF4 1065353216
ADDRLP4 4
INDIRP4
CNSTI4 20
ADDP4
INDIRI4
ADDRLP4 4
INDIRP4
CNSTI4 16
ADDP4
INDIRI4
SUBI4
CVIF4 4
DIVF4
ASGNF4
line 145
;144:
;145:	re = &le->refEntity;
ADDRLP4 0
ADDRLP4 4
INDIRP4
CNSTI4 248
ADDP4
ASGNP4
line 146
;146:	VectorCopy( start, re->origin );
ADDRLP4 0
INDIRP4
CNSTI4 52
ADDP4
ADDRFP4 0
INDIRP4
INDIRB
ASGNB 12
line 147
;147:	VectorCopy( end, re->oldorigin);
ADDRLP4 0
INDIRP4
CNSTI4 64
ADDP4
ADDRFP4 4
INDIRP4
INDIRB
ASGNB 12
line 148
;148:	re->shaderTime = cg.time / 1000.0f;
ADDRLP4 0
INDIRP4
CNSTI4 100
ADDP4
ADDRGP4 cg+64
INDIRI4
CVIF4 4
CNSTF4 1148846080
DIVF4
ASGNF4
line 150
;149:
;150:	re->reType = RT_LINE;
ADDRLP4 0
INDIRP4
CNSTI4 8
ASGNI4
line 151
;151:	re->radius = 0.5*radius;
ADDRLP4 0
INDIRP4
CNSTI4 92
ADDP4
CNSTF4 1056964608
ADDRFP4 16
INDIRI4
CVIF4 4
MULF4
ASGNF4
line 152
;152:	re->customShader = cgs.media.whiteShader; //trap_R_RegisterShaderNoMip("textures/colombia/canvas_doublesided");
ADDRLP4 0
INDIRP4
CNSTI4 76
ADDP4
ADDRGP4 cgs+71064+4
INDIRI4
ASGNI4
line 154
;153:
;154:	re->shaderTexCoord[0] = re->shaderTexCoord[1] = 1.0f;
ADDRLP4 20
CNSTF4 1065353216
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 88
ADDP4
ADDRLP4 20
INDIRF4
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 84
ADDP4
ADDRLP4 20
INDIRF4
ASGNF4
line 156
;155:
;156:	if (color==0)
ADDRFP4 12
INDIRU4
CNSTU4 0
NEU4 $182
line 157
;157:	{
line 158
;158:		re->shaderRGBA[0] = re->shaderRGBA[1] = re->shaderRGBA[2] = re->shaderRGBA[3] = 0xff;
ADDRLP4 28
CNSTU1 255
ASGNU1
ADDRLP4 0
INDIRP4
CNSTI4 83
ADDP4
ADDRLP4 28
INDIRU1
ASGNU1
ADDRLP4 0
INDIRP4
CNSTI4 82
ADDP4
ADDRLP4 28
INDIRU1
ASGNU1
ADDRLP4 0
INDIRP4
CNSTI4 81
ADDP4
ADDRLP4 28
INDIRU1
ASGNU1
ADDRLP4 0
INDIRP4
CNSTI4 80
ADDP4
ADDRLP4 28
INDIRU1
ASGNU1
line 159
;159:	}
ADDRGP4 $183
JUMPV
LABELV $182
line 161
;160:	else
;161:	{
line 162
;162:		re->shaderRGBA[0] = color & 0xff;
ADDRLP4 0
INDIRP4
CNSTI4 80
ADDP4
ADDRFP4 12
INDIRU4
CNSTU4 255
BANDU4
CVUU1 4
ASGNU1
line 163
;163:		color >>= 8;
ADDRFP4 12
ADDRFP4 12
INDIRU4
CNSTI4 8
RSHU4
ASGNU4
line 164
;164:		re->shaderRGBA[1] = color & 0xff;
ADDRLP4 0
INDIRP4
CNSTI4 81
ADDP4
ADDRFP4 12
INDIRU4
CNSTU4 255
BANDU4
CVUU1 4
ASGNU1
line 165
;165:		color >>= 8;
ADDRFP4 12
ADDRFP4 12
INDIRU4
CNSTI4 8
RSHU4
ASGNU4
line 166
;166:		re->shaderRGBA[2] = color & 0xff;
ADDRLP4 0
INDIRP4
CNSTI4 82
ADDP4
ADDRFP4 12
INDIRU4
CNSTU4 255
BANDU4
CVUU1 4
ASGNU1
line 169
;167://		color >>= 8;
;168://		re->shaderRGBA[3] = color & 0xff;
;169:		re->shaderRGBA[3] = 0xff;
ADDRLP4 0
INDIRP4
CNSTI4 83
ADDP4
CNSTU1 255
ASGNU1
line 170
;170:	}
LABELV $183
line 172
;171:
;172:	le->color[3] = 1.0;
ADDRLP4 4
INDIRP4
CNSTI4 136
ADDP4
CNSTF4 1065353216
ASGNF4
line 173
;173:}
LABELV $176
endproc CG_TestLine 29 0
export CG_ThrowChunk
proc CG_ThrowChunk 20 8
line 180
;174:
;175:/*
;176:==================
;177:CG_ThrowChunk
;178:==================
;179:*/
;180:void CG_ThrowChunk( vec3_t origin, vec3_t velocity, qhandle_t hModel, int optionalSound, int startalpha ) {
line 184
;181:	localEntity_t	*le;
;182:	refEntity_t		*re;
;183:
;184:	le = CG_AllocLocalEntity();
ADDRLP4 8
ADDRGP4 CG_AllocLocalEntity
CALLP4
ASGNP4
ADDRLP4 0
ADDRLP4 8
INDIRP4
ASGNP4
line 185
;185:	re = &le->refEntity;
ADDRLP4 4
ADDRLP4 0
INDIRP4
CNSTI4 248
ADDP4
ASGNP4
line 187
;186:
;187:	le->leType = LE_FRAGMENT;
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
CNSTI4 4
ASGNI4
line 188
;188:	le->startTime = cg.time;
ADDRLP4 0
INDIRP4
CNSTI4 16
ADDP4
ADDRGP4 cg+64
INDIRI4
ASGNI4
line 189
;189:	le->endTime = le->startTime + 5000 + random() * 3000;
ADDRLP4 12
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 20
ADDP4
ADDRLP4 0
INDIRP4
CNSTI4 16
ADDP4
INDIRI4
CNSTI4 5000
ADDI4
CVIF4 4
CNSTF4 1161527296
ADDRLP4 12
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
MULF4
ADDF4
CVFI4 4
ASGNI4
line 191
;190:
;191:	VectorCopy( origin, re->origin );
ADDRLP4 4
INDIRP4
CNSTI4 52
ADDP4
ADDRFP4 0
INDIRP4
INDIRB
ASGNB 12
line 192
;192:	AxisCopy( axisDefault, re->axis );
ADDRGP4 axisDefault
ARGP4
ADDRLP4 4
INDIRP4
CNSTI4 12
ADDP4
ARGP4
ADDRGP4 AxisCopy
CALLV
pop
line 193
;193:	re->hModel = hModel;
ADDRLP4 4
INDIRP4
CNSTI4 8
ADDP4
ADDRFP4 8
INDIRI4
ASGNI4
line 195
;194:
;195:	le->pos.trType = TR_GRAVITY;
ADDRLP4 0
INDIRP4
CNSTI4 32
ADDP4
CNSTI4 5
ASGNI4
line 196
;196:	le->angles.trType = TR_GRAVITY;
ADDRLP4 0
INDIRP4
CNSTI4 68
ADDP4
CNSTI4 5
ASGNI4
line 197
;197:	VectorCopy( origin, le->pos.trBase );
ADDRLP4 0
INDIRP4
CNSTI4 44
ADDP4
ADDRFP4 0
INDIRP4
INDIRB
ASGNB 12
line 198
;198:	VectorCopy( velocity, le->pos.trDelta );
ADDRLP4 0
INDIRP4
CNSTI4 56
ADDP4
ADDRFP4 4
INDIRP4
INDIRB
ASGNB 12
line 199
;199:	VectorSet(le->angles.trBase, 20, 20, 20);
ADDRLP4 0
INDIRP4
CNSTI4 80
ADDP4
CNSTF4 1101004800
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 84
ADDP4
CNSTF4 1101004800
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 88
ADDP4
CNSTF4 1101004800
ASGNF4
line 200
;200:	VectorCopy( velocity, le->angles.trDelta );
ADDRLP4 0
INDIRP4
CNSTI4 92
ADDP4
ADDRFP4 4
INDIRP4
INDIRB
ASGNB 12
line 201
;201:	le->pos.trTime = cg.time;
ADDRLP4 0
INDIRP4
CNSTI4 36
ADDP4
ADDRGP4 cg+64
INDIRI4
ASGNI4
line 202
;202:	le->angles.trTime = cg.time;
ADDRLP4 0
INDIRP4
CNSTI4 72
ADDP4
ADDRGP4 cg+64
INDIRI4
ASGNI4
line 204
;203:
;204:	le->leFlags = LEF_TUMBLE;
ADDRLP4 0
INDIRP4
CNSTI4 12
ADDP4
CNSTI4 2
ASGNI4
line 206
;205:
;206:	le->angles.trBase[YAW] = 180;
ADDRLP4 0
INDIRP4
CNSTI4 84
ADDP4
CNSTF4 1127481344
ASGNF4
line 208
;207:
;208:	le->bounceFactor = 0.3f;
ADDRLP4 0
INDIRP4
CNSTI4 104
ADDP4
CNSTF4 1050253722
ASGNF4
line 209
;209:	le->bounceSound = optionalSound;
ADDRLP4 0
INDIRP4
CNSTI4 108
ADDP4
ADDRFP4 12
INDIRI4
ASGNI4
line 211
;210:
;211:	le->forceAlpha = startalpha;
ADDRLP4 0
INDIRP4
CNSTI4 120
ADDP4
ADDRFP4 16
INDIRI4
ASGNI4
line 212
;212:}
LABELV $184
endproc CG_ThrowChunk 20 8
proc CG_DoGlassQuad 280 4
line 231
;213:
;214://----------------------------
;215://
;216:// Breaking Glass Technology
;217://
;218://----------------------------
;219:
;220:// Since we have shared verts when we tesselate the glass sheet, it helps to have a 
;221://	random offset table set up up front.
;222:
;223:static float offX[20][20],
;224:			offZ[20][20];
;225:
;226:#define	FX_ALPHA_NONLINEAR	0x00000004
;227:#define FX_APPLY_PHYSICS	0x02000000
;228:#define FX_USE_ALPHA		0x08000000
;229:
;230:static void CG_DoGlassQuad( vec3_t p[4], vec2_t uv[4], qboolean stick, int time, vec3_t dmgDir )
;231:{
line 239
;232:	float	bounce;
;233:	vec3_t	rotDelta;
;234:	vec3_t	vel, accel;
;235:	vec3_t	rgb1;
;236:	addpolyArgStruct_t apArgs;
;237:	int		i, i_2;
;238:
;239:	VectorSet( vel, crandom() * 12, crandom() * 12, -1 );
ADDRLP4 240
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 188
CNSTF4 1094713344
CNSTF4 1073741824
ADDRLP4 240
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ASGNF4
ADDRLP4 244
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 188+4
CNSTF4 1094713344
CNSTF4 1073741824
ADDRLP4 244
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ASGNF4
ADDRLP4 188+8
CNSTF4 3212836864
ASGNF4
line 241
;240:
;241:	if ( !stick )
ADDRFP4 8
INDIRI4
CNSTI4 0
NEI4 $191
line 242
;242:	{
line 244
;243:		// We aren't a motion delayed chunk, so let us move quickly
;244:		VectorMA( vel, 0.3f, dmgDir, vel );
ADDRLP4 248
CNSTF4 1050253722
ASGNF4
ADDRLP4 252
ADDRFP4 16
INDIRP4
ASGNP4
ADDRLP4 188
ADDRLP4 188
INDIRF4
ADDRLP4 248
INDIRF4
ADDRLP4 252
INDIRP4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 188+4
ADDRLP4 188+4
INDIRF4
ADDRLP4 248
INDIRF4
ADDRLP4 252
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 188+8
ADDRLP4 188+8
INDIRF4
CNSTF4 1050253722
ADDRFP4 16
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
MULF4
ADDF4
ASGNF4
line 245
;245:	}
LABELV $191
line 248
;246:
;247:	// Set up acceleration due to gravity, 800 is standard QuakeIII gravity, so let's use something close
;248:	VectorSet( accel, 0.0f, 0.0f, -(600.0f + random() * 100.0f ) );
ADDRLP4 248
CNSTF4 0
ASGNF4
ADDRLP4 224
ADDRLP4 248
INDIRF4
ASGNF4
ADDRLP4 224+4
ADDRLP4 248
INDIRF4
ASGNF4
ADDRLP4 252
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 224+8
CNSTF4 1120403456
ADDRLP4 252
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
MULF4
CNSTF4 1142292480
ADDF4
NEGF4
ASGNF4
line 252
;249:
;250:	// We are using an additive shader, so let's set the RGB low so we look more like transparent glass
;251://	VectorSet( rgb1, 0.1f, 0.1f, 0.1f );
;252:	VectorSet( rgb1, 1.0f, 1.0f, 1.0f );
ADDRLP4 256
CNSTF4 1065353216
ASGNF4
ADDRLP4 200
ADDRLP4 256
INDIRF4
ASGNF4
ADDRLP4 200+4
ADDRLP4 256
INDIRF4
ASGNF4
ADDRLP4 200+8
CNSTF4 1065353216
ASGNF4
line 255
;253:
;254:	// Being glass, we don't want to bounce much
;255:	bounce = random() * 0.2f + 0.15f;
ADDRLP4 260
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 236
CNSTF4 1045220557
ADDRLP4 260
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
MULF4
CNSTF4 1041865114
ADDF4
ASGNF4
line 258
;256:
;257:	// Set up our random rotate, we only do PITCH and YAW, not ROLL.  This is something like degrees per second
;258:	VectorSet( rotDelta, crandom() * 40.0f, crandom() * 40.0f, 0.0f );
ADDRLP4 264
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 212
CNSTF4 1109393408
CNSTF4 1073741824
ADDRLP4 264
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ASGNF4
ADDRLP4 268
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 212+4
CNSTF4 1109393408
CNSTF4 1073741824
ADDRLP4 268
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ASGNF4
ADDRLP4 212+8
CNSTF4 0
ASGNF4
line 280
;259:
;260:	//In an ideal world, this might actually work.
;261:	/*
;262:	CPoly *pol = FX_AddPoly(p, uv, 4,			// verts, ST, vertCount
;263:			vel, accel,				// motion
;264:			0.15f, 0.0f, 85.0f,		// alpha start, alpha end, alpha parm ( begin alpha fade when 85% of life is complete )
;265:			rgb1, rgb1, 0.0f,		// rgb start, rgb end, rgb parm ( not used )
;266:			rotDelta, bounce, time,	// rotation amount, bounce, and time to delay motion for ( zero if no delay );
;267:			6000,					// life
;268:			cgi_R_RegisterShader( "gfx/misc/test_crackle" ), 
;269:			FX_APPLY_PHYSICS | FX_ALPHA_NONLINEAR | FX_USE_ALPHA );
;270:
;271:	if ( random() > 0.95f && pol )
;272:	{
;273:		pol->AddFlags( FX_IMPACT_RUNS_FX | FX_KILL_ON_IMPACT );
;274:		pol->SetImpactFxID( theFxScheduler.RegisterEffect( "glass_impact" ));
;275:	}
;276:	*/
;277:
;278:	//rww - this is dirty.
;279:
;280:	i = 0;
ADDRLP4 4
CNSTI4 0
ASGNI4
line 281
;281:	i_2 = 0;
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 $204
JUMPV
line 284
;282:
;283:	while (i < 4)
;284:	{
LABELV $206
line 286
;285:		while (i_2 < 3)
;286:		{
line 287
;287:			apArgs.p[i][i_2] = p[i][i_2];
ADDRLP4 272
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ASGNI4
ADDRLP4 276
CNSTI4 12
ADDRLP4 4
INDIRI4
MULI4
ASGNI4
ADDRLP4 272
INDIRI4
ADDRLP4 276
INDIRI4
ADDRLP4 8
ADDP4
ADDP4
ADDRLP4 272
INDIRI4
ADDRLP4 276
INDIRI4
ADDRFP4 0
INDIRP4
ADDP4
ADDP4
INDIRF4
ASGNF4
line 289
;288:
;289:			i_2++;
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 290
;290:		}
LABELV $207
line 285
ADDRLP4 0
INDIRI4
CNSTI4 3
LTI4 $206
line 292
;291:
;292:		i_2 = 0;
ADDRLP4 0
CNSTI4 0
ASGNI4
line 293
;293:		i++;
ADDRLP4 4
ADDRLP4 4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 294
;294:	}
LABELV $204
line 283
ADDRLP4 4
INDIRI4
CNSTI4 4
LTI4 $207
line 296
;295:
;296:	i = 0;
ADDRLP4 4
CNSTI4 0
ASGNI4
line 297
;297:	i_2 = 0;
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 $210
JUMPV
line 300
;298:
;299:	while (i < 4)
;300:	{
LABELV $212
line 302
;301:		while (i_2 < 2)
;302:		{
line 303
;303:			apArgs.ev[i][i_2] = uv[i][i_2];
ADDRLP4 272
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
ASGNI4
ADDRLP4 276
ADDRLP4 4
INDIRI4
CNSTI4 3
LSHI4
ASGNI4
ADDRLP4 272
INDIRI4
ADDRLP4 276
INDIRI4
ADDRLP4 8+48
ADDP4
ADDP4
ADDRLP4 272
INDIRI4
ADDRLP4 276
INDIRI4
ADDRFP4 4
INDIRP4
ADDP4
ADDP4
INDIRF4
ASGNF4
line 305
;304:
;305:			i_2++;
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 306
;306:		}
LABELV $213
line 301
ADDRLP4 0
INDIRI4
CNSTI4 2
LTI4 $212
line 308
;307:
;308:		i_2 = 0;
ADDRLP4 0
CNSTI4 0
ASGNI4
line 309
;309:		i++;
ADDRLP4 4
ADDRLP4 4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 310
;310:	}
LABELV $210
line 299
ADDRLP4 4
INDIRI4
CNSTI4 4
LTI4 $213
line 312
;311:
;312:	apArgs.numVerts = 4;
ADDRLP4 8+80
CNSTI4 4
ASGNI4
line 313
;313:	VectorCopy(vel, apArgs.vel);
ADDRLP4 8+84
ADDRLP4 188
INDIRB
ASGNB 12
line 314
;314:	VectorCopy(accel, apArgs.accel);
ADDRLP4 8+96
ADDRLP4 224
INDIRB
ASGNB 12
line 316
;315:
;316:	apArgs.alpha1 = 0.15f;
ADDRLP4 8+108
CNSTF4 1041865114
ASGNF4
line 317
;317:	apArgs.alpha2 = 0.0f;
ADDRLP4 8+112
CNSTF4 0
ASGNF4
line 318
;318:	apArgs.alphaParm = 85.0f;
ADDRLP4 8+116
CNSTF4 1118437376
ASGNF4
line 320
;319:
;320:	VectorCopy(rgb1, apArgs.rgb1);
ADDRLP4 8+120
ADDRLP4 200
INDIRB
ASGNB 12
line 321
;321:	VectorCopy(rgb1, apArgs.rgb2);
ADDRLP4 8+132
ADDRLP4 200
INDIRB
ASGNB 12
line 323
;322:
;323:	apArgs.rgbParm = 0.0f;
ADDRLP4 8+144
CNSTF4 0
ASGNF4
line 325
;324:
;325:	VectorCopy(rotDelta, apArgs.rotationDelta);
ADDRLP4 8+148
ADDRLP4 212
INDIRB
ASGNB 12
line 327
;326:
;327:	apArgs.bounce = bounce;
ADDRLP4 8+160
ADDRLP4 236
INDIRF4
ASGNF4
line 328
;328:	apArgs.motionDelay = time;
ADDRLP4 8+164
ADDRFP4 12
INDIRI4
ASGNI4
line 329
;329:	apArgs.killTime = 6000;
ADDRLP4 8+168
CNSTI4 6000
ASGNI4
line 330
;330:	apArgs.shader = cgs.media.glassShardShader;
ADDRLP4 8+172
ADDRGP4 cgs+71064+408
INDIRI4
ASGNI4
line 331
;331:	apArgs.flags = (FX_APPLY_PHYSICS | FX_ALPHA_NONLINEAR | FX_USE_ALPHA);
ADDRLP4 8+176
CNSTI4 167772164
ASGNI4
line 333
;332:
;333:	trap_FX_AddPoly(&apArgs);
ADDRLP4 8
ARGP4
ADDRGP4 trap_FX_AddPoly
CALLV
pop
line 334
;334:}
LABELV $188
endproc CG_DoGlassQuad 280 4
proc CG_CalcBiLerp 276 0
line 337
;335:
;336:static void CG_CalcBiLerp( vec3_t verts[4], vec3_t subVerts[4], vec2_t uv[4] )
;337:{
line 341
;338:	vec3_t	temp;
;339:
;340:	// Nasty crap
;341:	VectorScale( verts[0],	1.0f - uv[0][0],	subVerts[0] );
ADDRFP4 4
INDIRP4
ADDRFP4 0
INDIRP4
INDIRF4
CNSTF4 1065353216
ADDRFP4 8
INDIRP4
INDIRF4
SUBF4
MULF4
ASGNF4
ADDRLP4 12
CNSTI4 4
ASGNI4
ADDRFP4 4
INDIRP4
ADDRLP4 12
INDIRI4
ADDP4
ADDRFP4 0
INDIRP4
ADDRLP4 12
INDIRI4
ADDP4
INDIRF4
CNSTF4 1065353216
ADDRFP4 8
INDIRP4
INDIRF4
SUBF4
MULF4
ASGNF4
ADDRLP4 16
CNSTI4 8
ASGNI4
ADDRFP4 4
INDIRP4
ADDRLP4 16
INDIRI4
ADDP4
ADDRFP4 0
INDIRP4
ADDRLP4 16
INDIRI4
ADDP4
INDIRF4
CNSTF4 1065353216
ADDRFP4 8
INDIRP4
INDIRF4
SUBF4
MULF4
ASGNF4
line 342
;342:	VectorMA( subVerts[0],	uv[0][0],			verts[1], subVerts[0] );
ADDRLP4 20
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 20
INDIRP4
ADDRLP4 20
INDIRP4
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 12
ADDP4
INDIRF4
ADDRFP4 8
INDIRP4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 24
ADDRFP4 4
INDIRP4
CNSTI4 4
ADDP4
ASGNP4
ADDRLP4 24
INDIRP4
ADDRLP4 24
INDIRP4
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 16
ADDP4
INDIRF4
ADDRFP4 8
INDIRP4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 28
ADDRFP4 4
INDIRP4
CNSTI4 8
ADDP4
ASGNP4
ADDRLP4 28
INDIRP4
ADDRLP4 28
INDIRP4
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 20
ADDP4
INDIRF4
ADDRFP4 8
INDIRP4
INDIRF4
MULF4
ADDF4
ASGNF4
line 343
;343:	VectorScale( subVerts[0], 1.0f - uv[0][1],	temp );
ADDRLP4 32
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 36
CNSTF4 1065353216
ASGNF4
ADDRLP4 40
CNSTI4 4
ASGNI4
ADDRLP4 44
ADDRFP4 8
INDIRP4
ADDRLP4 40
INDIRI4
ADDP4
ASGNP4
ADDRLP4 0
ADDRLP4 32
INDIRP4
INDIRF4
ADDRLP4 36
INDIRF4
ADDRLP4 44
INDIRP4
INDIRF4
SUBF4
MULF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 32
INDIRP4
ADDRLP4 40
INDIRI4
ADDP4
INDIRF4
ADDRLP4 36
INDIRF4
ADDRLP4 44
INDIRP4
INDIRF4
SUBF4
MULF4
ASGNF4
ADDRLP4 0+8
ADDRFP4 4
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
CNSTF4 1065353216
ADDRFP4 8
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
SUBF4
MULF4
ASGNF4
line 344
;344:	VectorScale( verts[3],	1.0f - uv[0][0],	subVerts[0] );
ADDRFP4 4
INDIRP4
ADDRFP4 0
INDIRP4
CNSTI4 36
ADDP4
INDIRF4
CNSTF4 1065353216
ADDRFP4 8
INDIRP4
INDIRF4
SUBF4
MULF4
ASGNF4
ADDRFP4 4
INDIRP4
CNSTI4 4
ADDP4
ADDRFP4 0
INDIRP4
CNSTI4 40
ADDP4
INDIRF4
CNSTF4 1065353216
ADDRFP4 8
INDIRP4
INDIRF4
SUBF4
MULF4
ASGNF4
ADDRFP4 4
INDIRP4
CNSTI4 8
ADDP4
ADDRFP4 0
INDIRP4
CNSTI4 44
ADDP4
INDIRF4
CNSTF4 1065353216
ADDRFP4 8
INDIRP4
INDIRF4
SUBF4
MULF4
ASGNF4
line 345
;345:	VectorMA( subVerts[0],	uv[0][0],			verts[2], subVerts[0] );
ADDRLP4 48
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 48
INDIRP4
ADDRLP4 48
INDIRP4
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 24
ADDP4
INDIRF4
ADDRFP4 8
INDIRP4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 52
ADDRFP4 4
INDIRP4
CNSTI4 4
ADDP4
ASGNP4
ADDRLP4 52
INDIRP4
ADDRLP4 52
INDIRP4
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 28
ADDP4
INDIRF4
ADDRFP4 8
INDIRP4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 56
ADDRFP4 4
INDIRP4
CNSTI4 8
ADDP4
ASGNP4
ADDRLP4 56
INDIRP4
ADDRLP4 56
INDIRP4
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 32
ADDP4
INDIRF4
ADDRFP4 8
INDIRP4
INDIRF4
MULF4
ADDF4
ASGNF4
line 346
;346:	VectorMA( temp,			uv[0][1],			subVerts[0], subVerts[0] );
ADDRLP4 60
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 60
INDIRP4
ADDRLP4 0
INDIRF4
ADDRLP4 60
INDIRP4
INDIRF4
ADDRFP4 8
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 64
CNSTI4 4
ASGNI4
ADDRLP4 68
ADDRFP4 4
INDIRP4
ADDRLP4 64
INDIRI4
ADDP4
ASGNP4
ADDRLP4 68
INDIRP4
ADDRLP4 0+4
INDIRF4
ADDRLP4 68
INDIRP4
INDIRF4
ADDRFP4 8
INDIRP4
ADDRLP4 64
INDIRI4
ADDP4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 72
ADDRFP4 4
INDIRP4
CNSTI4 8
ADDP4
ASGNP4
ADDRLP4 72
INDIRP4
ADDRLP4 0+8
INDIRF4
ADDRLP4 72
INDIRP4
INDIRF4
ADDRFP4 8
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
MULF4
ADDF4
ASGNF4
line 348
;347:
;348:	VectorScale( verts[0],	1.0f - uv[1][0],	subVerts[1] );
ADDRFP4 4
INDIRP4
CNSTI4 12
ADDP4
ADDRFP4 0
INDIRP4
INDIRF4
CNSTF4 1065353216
ADDRFP4 8
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
SUBF4
MULF4
ASGNF4
ADDRFP4 4
INDIRP4
CNSTI4 16
ADDP4
ADDRFP4 0
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
CNSTF4 1065353216
ADDRFP4 8
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
SUBF4
MULF4
ASGNF4
ADDRLP4 76
CNSTI4 8
ASGNI4
ADDRFP4 4
INDIRP4
CNSTI4 20
ADDP4
ADDRFP4 0
INDIRP4
ADDRLP4 76
INDIRI4
ADDP4
INDIRF4
CNSTF4 1065353216
ADDRFP4 8
INDIRP4
ADDRLP4 76
INDIRI4
ADDP4
INDIRF4
SUBF4
MULF4
ASGNF4
line 349
;349:	VectorMA( subVerts[1],	uv[1][0],			verts[1], subVerts[1] );
ADDRLP4 80
CNSTI4 12
ASGNI4
ADDRLP4 84
ADDRFP4 4
INDIRP4
ADDRLP4 80
INDIRI4
ADDP4
ASGNP4
ADDRLP4 84
INDIRP4
ADDRLP4 84
INDIRP4
INDIRF4
ADDRFP4 0
INDIRP4
ADDRLP4 80
INDIRI4
ADDP4
INDIRF4
ADDRFP4 8
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 88
CNSTI4 16
ASGNI4
ADDRLP4 92
ADDRFP4 4
INDIRP4
ADDRLP4 88
INDIRI4
ADDP4
ASGNP4
ADDRLP4 92
INDIRP4
ADDRLP4 92
INDIRP4
INDIRF4
ADDRFP4 0
INDIRP4
ADDRLP4 88
INDIRI4
ADDP4
INDIRF4
ADDRFP4 8
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 96
CNSTI4 20
ASGNI4
ADDRLP4 100
ADDRFP4 4
INDIRP4
ADDRLP4 96
INDIRI4
ADDP4
ASGNP4
ADDRLP4 100
INDIRP4
ADDRLP4 100
INDIRP4
INDIRF4
ADDRFP4 0
INDIRP4
ADDRLP4 96
INDIRI4
ADDP4
INDIRF4
ADDRFP4 8
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
MULF4
ADDF4
ASGNF4
line 350
;350:	VectorScale( subVerts[1], 1.0f - uv[1][1],	temp );
ADDRLP4 104
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 108
CNSTI4 12
ASGNI4
ADDRLP4 112
CNSTF4 1065353216
ASGNF4
ADDRLP4 116
ADDRFP4 8
INDIRP4
ADDRLP4 108
INDIRI4
ADDP4
ASGNP4
ADDRLP4 0
ADDRLP4 104
INDIRP4
ADDRLP4 108
INDIRI4
ADDP4
INDIRF4
ADDRLP4 112
INDIRF4
ADDRLP4 116
INDIRP4
INDIRF4
SUBF4
MULF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 104
INDIRP4
CNSTI4 16
ADDP4
INDIRF4
ADDRLP4 112
INDIRF4
ADDRLP4 116
INDIRP4
INDIRF4
SUBF4
MULF4
ASGNF4
ADDRLP4 0+8
ADDRFP4 4
INDIRP4
CNSTI4 20
ADDP4
INDIRF4
CNSTF4 1065353216
ADDRFP4 8
INDIRP4
CNSTI4 12
ADDP4
INDIRF4
SUBF4
MULF4
ASGNF4
line 351
;351:	VectorScale( verts[3],	1.0f - uv[1][0],	subVerts[1] );
ADDRFP4 4
INDIRP4
CNSTI4 12
ADDP4
ADDRFP4 0
INDIRP4
CNSTI4 36
ADDP4
INDIRF4
CNSTF4 1065353216
ADDRFP4 8
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
SUBF4
MULF4
ASGNF4
ADDRFP4 4
INDIRP4
CNSTI4 16
ADDP4
ADDRFP4 0
INDIRP4
CNSTI4 40
ADDP4
INDIRF4
CNSTF4 1065353216
ADDRFP4 8
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
SUBF4
MULF4
ASGNF4
ADDRFP4 4
INDIRP4
CNSTI4 20
ADDP4
ADDRFP4 0
INDIRP4
CNSTI4 44
ADDP4
INDIRF4
CNSTF4 1065353216
ADDRFP4 8
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
SUBF4
MULF4
ASGNF4
line 352
;352:	VectorMA( subVerts[1],	uv[1][0],			verts[2], subVerts[1] );
ADDRLP4 120
ADDRFP4 4
INDIRP4
CNSTI4 12
ADDP4
ASGNP4
ADDRLP4 120
INDIRP4
ADDRLP4 120
INDIRP4
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 24
ADDP4
INDIRF4
ADDRFP4 8
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 124
ADDRFP4 4
INDIRP4
CNSTI4 16
ADDP4
ASGNP4
ADDRLP4 124
INDIRP4
ADDRLP4 124
INDIRP4
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 28
ADDP4
INDIRF4
ADDRFP4 8
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 128
ADDRFP4 4
INDIRP4
CNSTI4 20
ADDP4
ASGNP4
ADDRLP4 128
INDIRP4
ADDRLP4 128
INDIRP4
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 32
ADDP4
INDIRF4
ADDRFP4 8
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
MULF4
ADDF4
ASGNF4
line 353
;353:	VectorMA( temp,			uv[1][1],			subVerts[1], subVerts[1] );
ADDRLP4 132
CNSTI4 12
ASGNI4
ADDRLP4 136
ADDRFP4 4
INDIRP4
ADDRLP4 132
INDIRI4
ADDP4
ASGNP4
ADDRLP4 136
INDIRP4
ADDRLP4 0
INDIRF4
ADDRLP4 136
INDIRP4
INDIRF4
ADDRFP4 8
INDIRP4
ADDRLP4 132
INDIRI4
ADDP4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 140
ADDRFP4 4
INDIRP4
CNSTI4 16
ADDP4
ASGNP4
ADDRLP4 140
INDIRP4
ADDRLP4 0+4
INDIRF4
ADDRLP4 140
INDIRP4
INDIRF4
ADDRFP4 8
INDIRP4
CNSTI4 12
ADDP4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 144
ADDRFP4 4
INDIRP4
CNSTI4 20
ADDP4
ASGNP4
ADDRLP4 144
INDIRP4
ADDRLP4 0+8
INDIRF4
ADDRLP4 144
INDIRP4
INDIRF4
ADDRFP4 8
INDIRP4
CNSTI4 12
ADDP4
INDIRF4
MULF4
ADDF4
ASGNF4
line 355
;354:
;355:	VectorScale( verts[0],	1.0f - uv[2][0],	subVerts[2] );
ADDRFP4 4
INDIRP4
CNSTI4 24
ADDP4
ADDRFP4 0
INDIRP4
INDIRF4
CNSTF4 1065353216
ADDRFP4 8
INDIRP4
CNSTI4 16
ADDP4
INDIRF4
SUBF4
MULF4
ASGNF4
ADDRFP4 4
INDIRP4
CNSTI4 28
ADDP4
ADDRFP4 0
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
CNSTF4 1065353216
ADDRFP4 8
INDIRP4
CNSTI4 16
ADDP4
INDIRF4
SUBF4
MULF4
ASGNF4
ADDRFP4 4
INDIRP4
CNSTI4 32
ADDP4
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
CNSTF4 1065353216
ADDRFP4 8
INDIRP4
CNSTI4 16
ADDP4
INDIRF4
SUBF4
MULF4
ASGNF4
line 356
;356:	VectorMA( subVerts[2],	uv[2][0],			verts[1], subVerts[2] );
ADDRLP4 148
ADDRFP4 4
INDIRP4
CNSTI4 24
ADDP4
ASGNP4
ADDRLP4 148
INDIRP4
ADDRLP4 148
INDIRP4
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 12
ADDP4
INDIRF4
ADDRFP4 8
INDIRP4
CNSTI4 16
ADDP4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 152
ADDRFP4 4
INDIRP4
CNSTI4 28
ADDP4
ASGNP4
ADDRLP4 156
CNSTI4 16
ASGNI4
ADDRLP4 152
INDIRP4
ADDRLP4 152
INDIRP4
INDIRF4
ADDRFP4 0
INDIRP4
ADDRLP4 156
INDIRI4
ADDP4
INDIRF4
ADDRFP4 8
INDIRP4
ADDRLP4 156
INDIRI4
ADDP4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 160
ADDRFP4 4
INDIRP4
CNSTI4 32
ADDP4
ASGNP4
ADDRLP4 160
INDIRP4
ADDRLP4 160
INDIRP4
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 20
ADDP4
INDIRF4
ADDRFP4 8
INDIRP4
CNSTI4 16
ADDP4
INDIRF4
MULF4
ADDF4
ASGNF4
line 357
;357:	VectorScale( subVerts[2], 1.0f - uv[2][1],		temp );
ADDRLP4 164
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 168
CNSTF4 1065353216
ASGNF4
ADDRLP4 172
ADDRFP4 8
INDIRP4
CNSTI4 20
ADDP4
ASGNP4
ADDRLP4 0
ADDRLP4 164
INDIRP4
CNSTI4 24
ADDP4
INDIRF4
ADDRLP4 168
INDIRF4
ADDRLP4 172
INDIRP4
INDIRF4
SUBF4
MULF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 164
INDIRP4
CNSTI4 28
ADDP4
INDIRF4
ADDRLP4 168
INDIRF4
ADDRLP4 172
INDIRP4
INDIRF4
SUBF4
MULF4
ASGNF4
ADDRLP4 0+8
ADDRFP4 4
INDIRP4
CNSTI4 32
ADDP4
INDIRF4
CNSTF4 1065353216
ADDRFP4 8
INDIRP4
CNSTI4 20
ADDP4
INDIRF4
SUBF4
MULF4
ASGNF4
line 358
;358:	VectorScale( verts[3],	1.0f - uv[2][0],	subVerts[2] );
ADDRFP4 4
INDIRP4
CNSTI4 24
ADDP4
ADDRFP4 0
INDIRP4
CNSTI4 36
ADDP4
INDIRF4
CNSTF4 1065353216
ADDRFP4 8
INDIRP4
CNSTI4 16
ADDP4
INDIRF4
SUBF4
MULF4
ASGNF4
ADDRFP4 4
INDIRP4
CNSTI4 28
ADDP4
ADDRFP4 0
INDIRP4
CNSTI4 40
ADDP4
INDIRF4
CNSTF4 1065353216
ADDRFP4 8
INDIRP4
CNSTI4 16
ADDP4
INDIRF4
SUBF4
MULF4
ASGNF4
ADDRFP4 4
INDIRP4
CNSTI4 32
ADDP4
ADDRFP4 0
INDIRP4
CNSTI4 44
ADDP4
INDIRF4
CNSTF4 1065353216
ADDRFP4 8
INDIRP4
CNSTI4 16
ADDP4
INDIRF4
SUBF4
MULF4
ASGNF4
line 359
;359:	VectorMA( subVerts[2],	uv[2][0],			verts[2], subVerts[2] );
ADDRLP4 176
CNSTI4 24
ASGNI4
ADDRLP4 180
ADDRFP4 4
INDIRP4
ADDRLP4 176
INDIRI4
ADDP4
ASGNP4
ADDRLP4 180
INDIRP4
ADDRLP4 180
INDIRP4
INDIRF4
ADDRFP4 0
INDIRP4
ADDRLP4 176
INDIRI4
ADDP4
INDIRF4
ADDRFP4 8
INDIRP4
CNSTI4 16
ADDP4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 184
CNSTI4 28
ASGNI4
ADDRLP4 188
ADDRFP4 4
INDIRP4
ADDRLP4 184
INDIRI4
ADDP4
ASGNP4
ADDRLP4 188
INDIRP4
ADDRLP4 188
INDIRP4
INDIRF4
ADDRFP4 0
INDIRP4
ADDRLP4 184
INDIRI4
ADDP4
INDIRF4
ADDRFP4 8
INDIRP4
CNSTI4 16
ADDP4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 192
CNSTI4 32
ASGNI4
ADDRLP4 196
ADDRFP4 4
INDIRP4
ADDRLP4 192
INDIRI4
ADDP4
ASGNP4
ADDRLP4 196
INDIRP4
ADDRLP4 196
INDIRP4
INDIRF4
ADDRFP4 0
INDIRP4
ADDRLP4 192
INDIRI4
ADDP4
INDIRF4
ADDRFP4 8
INDIRP4
CNSTI4 16
ADDP4
INDIRF4
MULF4
ADDF4
ASGNF4
line 360
;360:	VectorMA( temp,			uv[2][1],			subVerts[2], subVerts[2] );
ADDRLP4 200
ADDRFP4 4
INDIRP4
CNSTI4 24
ADDP4
ASGNP4
ADDRLP4 200
INDIRP4
ADDRLP4 0
INDIRF4
ADDRLP4 200
INDIRP4
INDIRF4
ADDRFP4 8
INDIRP4
CNSTI4 20
ADDP4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 204
ADDRFP4 4
INDIRP4
CNSTI4 28
ADDP4
ASGNP4
ADDRLP4 204
INDIRP4
ADDRLP4 0+4
INDIRF4
ADDRLP4 204
INDIRP4
INDIRF4
ADDRFP4 8
INDIRP4
CNSTI4 20
ADDP4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 208
ADDRFP4 4
INDIRP4
CNSTI4 32
ADDP4
ASGNP4
ADDRLP4 208
INDIRP4
ADDRLP4 0+8
INDIRF4
ADDRLP4 208
INDIRP4
INDIRF4
ADDRFP4 8
INDIRP4
CNSTI4 20
ADDP4
INDIRF4
MULF4
ADDF4
ASGNF4
line 362
;361:
;362:	VectorScale( verts[0],	1.0f - uv[3][0],	subVerts[3] );
ADDRFP4 4
INDIRP4
CNSTI4 36
ADDP4
ADDRFP4 0
INDIRP4
INDIRF4
CNSTF4 1065353216
ADDRFP4 8
INDIRP4
CNSTI4 24
ADDP4
INDIRF4
SUBF4
MULF4
ASGNF4
ADDRFP4 4
INDIRP4
CNSTI4 40
ADDP4
ADDRFP4 0
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
CNSTF4 1065353216
ADDRFP4 8
INDIRP4
CNSTI4 24
ADDP4
INDIRF4
SUBF4
MULF4
ASGNF4
ADDRFP4 4
INDIRP4
CNSTI4 44
ADDP4
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
CNSTF4 1065353216
ADDRFP4 8
INDIRP4
CNSTI4 24
ADDP4
INDIRF4
SUBF4
MULF4
ASGNF4
line 363
;363:	VectorMA( subVerts[3],	uv[3][0],			verts[1], subVerts[3] );
ADDRLP4 212
ADDRFP4 4
INDIRP4
CNSTI4 36
ADDP4
ASGNP4
ADDRLP4 212
INDIRP4
ADDRLP4 212
INDIRP4
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 12
ADDP4
INDIRF4
ADDRFP4 8
INDIRP4
CNSTI4 24
ADDP4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 216
ADDRFP4 4
INDIRP4
CNSTI4 40
ADDP4
ASGNP4
ADDRLP4 216
INDIRP4
ADDRLP4 216
INDIRP4
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 16
ADDP4
INDIRF4
ADDRFP4 8
INDIRP4
CNSTI4 24
ADDP4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 220
ADDRFP4 4
INDIRP4
CNSTI4 44
ADDP4
ASGNP4
ADDRLP4 220
INDIRP4
ADDRLP4 220
INDIRP4
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 20
ADDP4
INDIRF4
ADDRFP4 8
INDIRP4
CNSTI4 24
ADDP4
INDIRF4
MULF4
ADDF4
ASGNF4
line 364
;364:	VectorScale( subVerts[3], 1.0f - uv[3][1],	temp );
ADDRLP4 224
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 228
CNSTF4 1065353216
ASGNF4
ADDRLP4 232
ADDRFP4 8
INDIRP4
CNSTI4 28
ADDP4
ASGNP4
ADDRLP4 0
ADDRLP4 224
INDIRP4
CNSTI4 36
ADDP4
INDIRF4
ADDRLP4 228
INDIRF4
ADDRLP4 232
INDIRP4
INDIRF4
SUBF4
MULF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 224
INDIRP4
CNSTI4 40
ADDP4
INDIRF4
ADDRLP4 228
INDIRF4
ADDRLP4 232
INDIRP4
INDIRF4
SUBF4
MULF4
ASGNF4
ADDRLP4 0+8
ADDRFP4 4
INDIRP4
CNSTI4 44
ADDP4
INDIRF4
CNSTF4 1065353216
ADDRFP4 8
INDIRP4
CNSTI4 28
ADDP4
INDIRF4
SUBF4
MULF4
ASGNF4
line 365
;365:	VectorScale( verts[3],	1.0f - uv[3][0],	subVerts[3] );
ADDRLP4 236
CNSTI4 36
ASGNI4
ADDRFP4 4
INDIRP4
ADDRLP4 236
INDIRI4
ADDP4
ADDRFP4 0
INDIRP4
ADDRLP4 236
INDIRI4
ADDP4
INDIRF4
CNSTF4 1065353216
ADDRFP4 8
INDIRP4
CNSTI4 24
ADDP4
INDIRF4
SUBF4
MULF4
ASGNF4
ADDRLP4 240
CNSTI4 40
ASGNI4
ADDRFP4 4
INDIRP4
ADDRLP4 240
INDIRI4
ADDP4
ADDRFP4 0
INDIRP4
ADDRLP4 240
INDIRI4
ADDP4
INDIRF4
CNSTF4 1065353216
ADDRFP4 8
INDIRP4
CNSTI4 24
ADDP4
INDIRF4
SUBF4
MULF4
ASGNF4
ADDRLP4 244
CNSTI4 44
ASGNI4
ADDRFP4 4
INDIRP4
ADDRLP4 244
INDIRI4
ADDP4
ADDRFP4 0
INDIRP4
ADDRLP4 244
INDIRI4
ADDP4
INDIRF4
CNSTF4 1065353216
ADDRFP4 8
INDIRP4
CNSTI4 24
ADDP4
INDIRF4
SUBF4
MULF4
ASGNF4
line 366
;366:	VectorMA( subVerts[3],	uv[3][0],			verts[2], subVerts[3] );
ADDRLP4 248
ADDRFP4 4
INDIRP4
CNSTI4 36
ADDP4
ASGNP4
ADDRLP4 252
CNSTI4 24
ASGNI4
ADDRLP4 248
INDIRP4
ADDRLP4 248
INDIRP4
INDIRF4
ADDRFP4 0
INDIRP4
ADDRLP4 252
INDIRI4
ADDP4
INDIRF4
ADDRFP4 8
INDIRP4
ADDRLP4 252
INDIRI4
ADDP4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 256
ADDRFP4 4
INDIRP4
CNSTI4 40
ADDP4
ASGNP4
ADDRLP4 256
INDIRP4
ADDRLP4 256
INDIRP4
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 28
ADDP4
INDIRF4
ADDRFP4 8
INDIRP4
CNSTI4 24
ADDP4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 260
ADDRFP4 4
INDIRP4
CNSTI4 44
ADDP4
ASGNP4
ADDRLP4 260
INDIRP4
ADDRLP4 260
INDIRP4
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 32
ADDP4
INDIRF4
ADDRFP4 8
INDIRP4
CNSTI4 24
ADDP4
INDIRF4
MULF4
ADDF4
ASGNF4
line 367
;367:	VectorMA( temp,			uv[3][1],			subVerts[3], subVerts[3] );
ADDRLP4 264
ADDRFP4 4
INDIRP4
CNSTI4 36
ADDP4
ASGNP4
ADDRLP4 264
INDIRP4
ADDRLP4 0
INDIRF4
ADDRLP4 264
INDIRP4
INDIRF4
ADDRFP4 8
INDIRP4
CNSTI4 28
ADDP4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 268
ADDRFP4 4
INDIRP4
CNSTI4 40
ADDP4
ASGNP4
ADDRLP4 268
INDIRP4
ADDRLP4 0+4
INDIRF4
ADDRLP4 268
INDIRP4
INDIRF4
ADDRFP4 8
INDIRP4
CNSTI4 28
ADDP4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 272
ADDRFP4 4
INDIRP4
CNSTI4 44
ADDP4
ASGNP4
ADDRLP4 272
INDIRP4
ADDRLP4 0+8
INDIRF4
ADDRLP4 272
INDIRP4
INDIRF4
ADDRFP4 8
INDIRP4
CNSTI4 28
ADDP4
INDIRF4
MULF4
ADDF4
ASGNF4
line 368
;368:}
LABELV $233
endproc CG_CalcBiLerp 276 0
proc CG_CalcHeightWidth 132 12
line 374
;369:// bilinear
;370://f(p',q') = (1 - y)  {[(1 - x)  f(p,q)] + [x  f(p,q+1)]} + y  {[(1 - x)  f(p+1,q)] + [x  f(p+1,q+1)]}. 
;371:
;372:
;373:static void CG_CalcHeightWidth( vec3_t verts[4], float *height, float *width )
;374:{
line 377
;375:	vec3_t	dir1, dir2, cross;
;376:
;377:	VectorSubtract( verts[3], verts[0], dir1 ); // v
ADDRLP4 36
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 12
ADDRLP4 36
INDIRP4
CNSTI4 36
ADDP4
INDIRF4
ADDRLP4 36
INDIRP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 12+4
ADDRLP4 36
INDIRP4
CNSTI4 40
ADDP4
INDIRF4
ADDRLP4 36
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 40
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 12+8
ADDRLP4 40
INDIRP4
CNSTI4 44
ADDP4
INDIRF4
ADDRLP4 40
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
SUBF4
ASGNF4
line 378
;378:	VectorSubtract( verts[1], verts[0], dir2 ); // p-a
ADDRLP4 44
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 0
ADDRLP4 44
INDIRP4
CNSTI4 12
ADDP4
INDIRF4
ADDRLP4 44
INDIRP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 44
INDIRP4
CNSTI4 16
ADDP4
INDIRF4
ADDRLP4 44
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 48
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 0+8
ADDRLP4 48
INDIRP4
CNSTI4 20
ADDP4
INDIRF4
ADDRLP4 48
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
SUBF4
ASGNF4
line 379
;379:	CrossProduct( dir1, dir2, cross );
ADDRLP4 12
ARGP4
ADDRLP4 0
ARGP4
ADDRLP4 24
ARGP4
ADDRGP4 CrossProduct
CALLV
pop
line 380
;380:	*width = VectorNormalize( cross ) / VectorNormalize( dir1 ); // v 
ADDRLP4 24
ARGP4
ADDRLP4 52
ADDRGP4 VectorNormalize
CALLF4
ASGNF4
ADDRLP4 12
ARGP4
ADDRLP4 56
ADDRGP4 VectorNormalize
CALLF4
ASGNF4
ADDRFP4 8
INDIRP4
ADDRLP4 52
INDIRF4
ADDRLP4 56
INDIRF4
DIVF4
ASGNF4
line 381
;381:	VectorSubtract( verts[2], verts[0], dir2 ); // p-a
ADDRLP4 60
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 0
ADDRLP4 60
INDIRP4
CNSTI4 24
ADDP4
INDIRF4
ADDRLP4 60
INDIRP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 60
INDIRP4
CNSTI4 28
ADDP4
INDIRF4
ADDRLP4 60
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 64
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 0+8
ADDRLP4 64
INDIRP4
CNSTI4 32
ADDP4
INDIRF4
ADDRLP4 64
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
SUBF4
ASGNF4
line 382
;382:	CrossProduct( dir1, dir2, cross );
ADDRLP4 12
ARGP4
ADDRLP4 0
ARGP4
ADDRLP4 24
ARGP4
ADDRGP4 CrossProduct
CALLV
pop
line 383
;383:	*width += VectorNormalize( cross ) / VectorNormalize( dir1 ); // v 
ADDRLP4 24
ARGP4
ADDRLP4 68
ADDRGP4 VectorNormalize
CALLF4
ASGNF4
ADDRLP4 12
ARGP4
ADDRLP4 72
ADDRGP4 VectorNormalize
CALLF4
ASGNF4
ADDRLP4 76
ADDRFP4 8
INDIRP4
ASGNP4
ADDRLP4 76
INDIRP4
ADDRLP4 76
INDIRP4
INDIRF4
ADDRLP4 68
INDIRF4
ADDRLP4 72
INDIRF4
DIVF4
ADDF4
ASGNF4
line 384
;384:	*width *= 0.5f;
ADDRLP4 80
ADDRFP4 8
INDIRP4
ASGNP4
ADDRLP4 80
INDIRP4
CNSTF4 1056964608
ADDRLP4 80
INDIRP4
INDIRF4
MULF4
ASGNF4
line 386
;385:
;386:	VectorSubtract( verts[1], verts[0], dir1 ); // v
ADDRLP4 84
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 12
ADDRLP4 84
INDIRP4
CNSTI4 12
ADDP4
INDIRF4
ADDRLP4 84
INDIRP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 12+4
ADDRLP4 84
INDIRP4
CNSTI4 16
ADDP4
INDIRF4
ADDRLP4 84
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 88
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 12+8
ADDRLP4 88
INDIRP4
CNSTI4 20
ADDP4
INDIRF4
ADDRLP4 88
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
SUBF4
ASGNF4
line 387
;387:	VectorSubtract( verts[2], verts[0], dir2 ); // p-a
ADDRLP4 92
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 0
ADDRLP4 92
INDIRP4
CNSTI4 24
ADDP4
INDIRF4
ADDRLP4 92
INDIRP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 92
INDIRP4
CNSTI4 28
ADDP4
INDIRF4
ADDRLP4 92
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 96
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 0+8
ADDRLP4 96
INDIRP4
CNSTI4 32
ADDP4
INDIRF4
ADDRLP4 96
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
SUBF4
ASGNF4
line 388
;388:	CrossProduct( dir1, dir2, cross );
ADDRLP4 12
ARGP4
ADDRLP4 0
ARGP4
ADDRLP4 24
ARGP4
ADDRGP4 CrossProduct
CALLV
pop
line 389
;389:	*height = VectorNormalize( cross ) / VectorNormalize( dir1 ); // v 
ADDRLP4 24
ARGP4
ADDRLP4 100
ADDRGP4 VectorNormalize
CALLF4
ASGNF4
ADDRLP4 12
ARGP4
ADDRLP4 104
ADDRGP4 VectorNormalize
CALLF4
ASGNF4
ADDRFP4 4
INDIRP4
ADDRLP4 100
INDIRF4
ADDRLP4 104
INDIRF4
DIVF4
ASGNF4
line 390
;390:	VectorSubtract( verts[3], verts[0], dir2 ); // p-a
ADDRLP4 108
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 0
ADDRLP4 108
INDIRP4
CNSTI4 36
ADDP4
INDIRF4
ADDRLP4 108
INDIRP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 0+4
ADDRLP4 108
INDIRP4
CNSTI4 40
ADDP4
INDIRF4
ADDRLP4 108
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 112
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 0+8
ADDRLP4 112
INDIRP4
CNSTI4 44
ADDP4
INDIRF4
ADDRLP4 112
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
SUBF4
ASGNF4
line 391
;391:	CrossProduct( dir1, dir2, cross );
ADDRLP4 12
ARGP4
ADDRLP4 0
ARGP4
ADDRLP4 24
ARGP4
ADDRGP4 CrossProduct
CALLV
pop
line 392
;392:	*height += VectorNormalize( cross ) / VectorNormalize( dir1 ); // v 
ADDRLP4 24
ARGP4
ADDRLP4 116
ADDRGP4 VectorNormalize
CALLF4
ASGNF4
ADDRLP4 12
ARGP4
ADDRLP4 120
ADDRGP4 VectorNormalize
CALLF4
ASGNF4
ADDRLP4 124
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 124
INDIRP4
ADDRLP4 124
INDIRP4
INDIRF4
ADDRLP4 116
INDIRF4
ADDRLP4 120
INDIRF4
DIVF4
ADDF4
ASGNF4
line 393
;393:	*height *= 0.5f;
ADDRLP4 128
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 128
INDIRP4
CNSTF4 1056964608
ADDRLP4 128
INDIRP4
INDIRF4
MULF4
ASGNF4
line 394
;394:}
LABELV $250
endproc CG_CalcHeightWidth 132 12
export CG_InitGlass
proc CG_InitGlass 16 0
line 400
;395://Consider a line in 3D with position vector "a" and direction vector "v" and 
;396:// let "p" be the position vector of an arbitrary point in 3D
;397://dist = len( crossprod(p-a,v) ) / len(v); 
;398:
;399:void CG_InitGlass( void )
;400:{
line 405
;401:	int i, t;
;402:
;403:	// Build a table first, so that we can do a more unpredictable crack scheme
;404:	//	do it once, up front to save a bit of time.
;405:	for ( i = 0; i < 20; i++ )
ADDRLP4 4
CNSTI4 0
ASGNI4
LABELV $264
line 406
;406:	{
line 407
;407:		for ( t = 0; t < 20; t++ )
ADDRLP4 0
CNSTI4 0
ASGNI4
LABELV $268
line 408
;408:		{
line 409
;409:			offX[t][i] = crandom() * 0.03f;
ADDRLP4 8
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 4
INDIRI4
CNSTI4 2
LSHI4
CNSTI4 80
ADDRLP4 0
INDIRI4
MULI4
ADDRGP4 offX
ADDP4
ADDP4
CNSTF4 1022739087
CNSTF4 1073741824
ADDRLP4 8
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ASGNF4
line 410
;410:			offZ[i][t] = crandom() * 0.03f;
ADDRLP4 12
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
CNSTI4 80
ADDRLP4 4
INDIRI4
MULI4
ADDRGP4 offZ
ADDP4
ADDP4
CNSTF4 1022739087
CNSTF4 1073741824
ADDRLP4 12
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ASGNF4
line 411
;411:		}
LABELV $269
line 407
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 0
INDIRI4
CNSTI4 20
LTI4 $268
line 412
;412:	}
LABELV $265
line 405
ADDRLP4 4
ADDRLP4 4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 4
INDIRI4
CNSTI4 20
LTI4 $264
line 413
;413:}
LABELV $263
endproc CG_InitGlass 16 0
export Vector2Set
proc Vector2Set 0 0
line 416
;414:
;415:void Vector2Set(vec2_t a,float b,float c)
;416:{
line 417
;417:	a[0] = b;
ADDRFP4 0
INDIRP4
ADDRFP4 4
INDIRF4
ASGNF4
line 418
;418:	a[1] = c;
ADDRFP4 0
INDIRP4
CNSTI4 4
ADDP4
ADDRFP4 8
INDIRF4
ASGNF4
line 419
;419:}
LABELV $272
endproc Vector2Set 0 0
export CG_DoGlass
proc CG_DoGlass 200 20
line 426
;420:
;421:#define TIME_DECAY_SLOW		0.1f
;422:#define TIME_DECAY_MED		0.04f
;423:#define TIME_DECAY_FAST		0.009f
;424:
;425:void CG_DoGlass( vec3_t verts[4], vec3_t normal, vec3_t dmgPt, vec3_t dmgDir, float dmgRadius, int maxShards )
;426:{
line 435
;427:	int			i, t;
;428:	int			mxHeight, mxWidth;
;429:	float		height, width;
;430:	float		stepWidth, stepHeight;
;431:	float		timeDecay;
;432:	float		x, z;
;433:	float		xx, zz;
;434:	float		dif;
;435:	int			time = 0;
ADDRLP4 124
CNSTI4 0
ASGNI4
line 436
;436:	int			glassShards = 0;
ADDRLP4 128
CNSTI4 0
ASGNI4
line 437
;437:	qboolean	stick = qtrue;
ADDRLP4 132
CNSTI4 1
ASGNI4
line 444
;438:	vec3_t		subVerts[4];
;439:	vec2_t		biPoints[4];
;440:
;441:	// To do a smarter tesselation, we should figure out the relative height and width of the brush face,
;442:	//	then use this to pick a lod value from 1-3 in each axis.  This will give us 1-9 lod levels, which will
;443:	//	hopefully be sufficient.
;444:	CG_CalcHeightWidth( verts, &height, &width );
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 144
ARGP4
ADDRLP4 140
ARGP4
ADDRGP4 CG_CalcHeightWidth
CALLV
pop
line 446
;445:
;446:	trap_S_StartSound( dmgPt, -1, CHAN_AUTO, trap_S_RegisterSound("sound/effects/glassbreak1.wav"));
ADDRGP4 $274
ARGP4
ADDRLP4 148
ADDRGP4 trap_S_RegisterSound
CALLI4
ASGNI4
ADDRFP4 8
INDIRP4
ARGP4
CNSTI4 -1
ARGI4
CNSTI4 0
ARGI4
ADDRLP4 148
INDIRI4
ARGI4
ADDRGP4 trap_S_StartSound
CALLV
pop
line 449
;447:
;448:	// Pick "LOD" for height
;449:	if ( height < 100 )
ADDRLP4 144
INDIRF4
CNSTF4 1120403456
GEF4 $275
line 450
;450:	{
line 451
;451:		stepHeight = 0.2f;
ADDRLP4 120
CNSTF4 1045220557
ASGNF4
line 452
;452:		mxHeight = 5;
ADDRLP4 60
CNSTI4 5
ASGNI4
line 453
;453:		timeDecay = TIME_DECAY_SLOW;
ADDRLP4 136
CNSTF4 1036831949
ASGNF4
line 454
;454:	}
ADDRGP4 $276
JUMPV
LABELV $275
line 455
;455:	else if ( height > 220 )
ADDRLP4 144
INDIRF4
CNSTF4 1130102784
LEF4 $277
line 456
;456:	{
line 457
;457:		stepHeight = 0.05f;
ADDRLP4 120
CNSTF4 1028443341
ASGNF4
line 458
;458:		mxHeight = 20;
ADDRLP4 60
CNSTI4 20
ASGNI4
line 459
;459:		timeDecay = TIME_DECAY_FAST;
ADDRLP4 136
CNSTF4 1007908028
ASGNF4
line 460
;460:	}
ADDRGP4 $278
JUMPV
LABELV $277
line 462
;461:	else
;462:	{
line 463
;463:		stepHeight = 0.1f;
ADDRLP4 120
CNSTF4 1036831949
ASGNF4
line 464
;464:		mxHeight = 10;
ADDRLP4 60
CNSTI4 10
ASGNI4
line 465
;465:		timeDecay = TIME_DECAY_MED;
ADDRLP4 136
CNSTF4 1025758986
ASGNF4
line 466
;466:	}
LABELV $278
LABELV $276
line 492
;467:
;468:	// Pick "LOD" for width
;469:	/*
;470:	if ( width < 100 )
;471:	{
;472:		stepWidth = 0.2f;
;473:		mxWidth = 5;
;474:		timeDecay = ( timeDecay + TIME_DECAY_SLOW ) * 0.5f;
;475:	}
;476:	else if ( width > 220 )
;477:	{
;478:		stepWidth = 0.05f;
;479:		mxWidth = 20;
;480:		timeDecay = ( timeDecay + TIME_DECAY_FAST ) * 0.5f;
;481:	}
;482:	else
;483:	{
;484:		stepWidth = 0.1f;
;485:		mxWidth = 10;
;486:		timeDecay = ( timeDecay + TIME_DECAY_MED ) * 0.5f;
;487:	}
;488:	*/
;489:
;490:	//Attempt to scale the glass directly to the size of the window
;491:
;492:	stepWidth = (0.25f - (width*0.0002)); //(width*0.0005));
ADDRLP4 68
CNSTF4 1048576000
CNSTF4 961656599
ADDRLP4 140
INDIRF4
MULF4
SUBF4
ASGNF4
line 493
;493:	mxWidth = width*0.2;
ADDRLP4 56
CNSTF4 1045220557
ADDRLP4 140
INDIRF4
MULF4
CVFI4 4
ASGNI4
line 494
;494:	timeDecay = ( timeDecay + TIME_DECAY_FAST ) * 0.5f;
ADDRLP4 136
CNSTF4 1056964608
ADDRLP4 136
INDIRF4
CNSTF4 1007908028
ADDF4
MULF4
ASGNF4
line 496
;495:
;496:	if (stepWidth < 0.01f)
ADDRLP4 68
INDIRF4
CNSTF4 1008981770
GEF4 $279
line 497
;497:	{
line 498
;498:		stepWidth = 0.01f;
ADDRLP4 68
CNSTF4 1008981770
ASGNF4
line 499
;499:	}
LABELV $279
line 500
;500:	if (mxWidth < 5)
ADDRLP4 56
INDIRI4
CNSTI4 5
GEI4 $281
line 501
;501:	{
line 502
;502:		mxWidth = 5;
ADDRLP4 56
CNSTI4 5
ASGNI4
line 503
;503:	}
LABELV $281
line 505
;504:
;505:	for ( z = 0.0f, i = 0; z < 1.0f; z += stepHeight, i++ )
ADDRLP4 52
CNSTF4 0
ASGNF4
ADDRLP4 4
CNSTI4 0
ASGNI4
ADDRGP4 $286
JUMPV
LABELV $283
line 506
;506:	{
line 507
;507:		for ( x = 0.0f, t = 0; x < 1.0f; x += stepWidth, t++ )
ADDRLP4 16
CNSTF4 0
ASGNF4
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 $290
JUMPV
LABELV $287
line 508
;508:		{
line 510
;509:			// This is nasty..
;510:			if ( t > 0 && t < mxWidth )
ADDRLP4 0
INDIRI4
CNSTI4 0
LEI4 $291
ADDRLP4 0
INDIRI4
ADDRLP4 56
INDIRI4
GEI4 $291
line 511
;511:			{
line 512
;512:				xx = x - offX[i][t];
ADDRLP4 8
ADDRLP4 16
INDIRF4
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
CNSTI4 80
ADDRLP4 4
INDIRI4
MULI4
ADDRGP4 offX
ADDP4
ADDP4
INDIRF4
SUBF4
ASGNF4
line 513
;513:			}
ADDRGP4 $292
JUMPV
LABELV $291
line 515
;514:			else
;515:			{
line 516
;516:				xx = x;
ADDRLP4 8
ADDRLP4 16
INDIRF4
ASGNF4
line 517
;517:			}
LABELV $292
line 519
;518:
;519:			if ( i > 0 && i < mxHeight )
ADDRLP4 4
INDIRI4
CNSTI4 0
LEI4 $293
ADDRLP4 4
INDIRI4
ADDRLP4 60
INDIRI4
GEI4 $293
line 520
;520:			{
line 521
;521:				zz = z - offZ[t][i];
ADDRLP4 12
ADDRLP4 52
INDIRF4
ADDRLP4 4
INDIRI4
CNSTI4 2
LSHI4
CNSTI4 80
ADDRLP4 0
INDIRI4
MULI4
ADDRGP4 offZ
ADDP4
ADDP4
INDIRF4
SUBF4
ASGNF4
line 522
;522:			}
ADDRGP4 $294
JUMPV
LABELV $293
line 524
;523:			else
;524:			{
line 525
;525:				zz = z;
ADDRLP4 12
ADDRLP4 52
INDIRF4
ASGNF4
line 526
;526:			}
LABELV $294
line 528
;527:
;528:			Vector2Set( biPoints[0], xx, zz );
ADDRLP4 20
ARGP4
ADDRLP4 8
INDIRF4
ARGF4
ADDRLP4 12
INDIRF4
ARGF4
ADDRGP4 Vector2Set
CALLV
pop
line 530
;529:
;530:			if ( t + 1 > 0 && t + 1 < mxWidth )
ADDRLP4 160
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 160
INDIRI4
CNSTI4 0
LEI4 $295
ADDRLP4 160
INDIRI4
ADDRLP4 56
INDIRI4
GEI4 $295
line 531
;531:			{
line 532
;532:				xx = x - offX[i][t + 1];
ADDRLP4 8
ADDRLP4 16
INDIRF4
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
CNSTI4 4
ADDI4
CNSTI4 80
ADDRLP4 4
INDIRI4
MULI4
ADDRGP4 offX
ADDP4
ADDP4
INDIRF4
SUBF4
ASGNF4
line 533
;533:			}
ADDRGP4 $296
JUMPV
LABELV $295
line 535
;534:			else
;535:			{
line 536
;536:				xx = x;
ADDRLP4 8
ADDRLP4 16
INDIRF4
ASGNF4
line 537
;537:			}
LABELV $296
line 539
;538:
;539:			if ( i > 0 && i < mxHeight )
ADDRLP4 4
INDIRI4
CNSTI4 0
LEI4 $297
ADDRLP4 4
INDIRI4
ADDRLP4 60
INDIRI4
GEI4 $297
line 540
;540:			{
line 541
;541:				zz = z - offZ[t + 1][i];
ADDRLP4 12
ADDRLP4 52
INDIRF4
ADDRLP4 4
INDIRI4
CNSTI4 2
LSHI4
CNSTI4 80
ADDRLP4 0
INDIRI4
MULI4
ADDRGP4 offZ+80
ADDP4
ADDP4
INDIRF4
SUBF4
ASGNF4
line 542
;542:			}
ADDRGP4 $298
JUMPV
LABELV $297
line 544
;543:			else
;544:			{
line 545
;545:				zz = z;
ADDRLP4 12
ADDRLP4 52
INDIRF4
ASGNF4
line 546
;546:			}
LABELV $298
line 548
;547:
;548:			Vector2Set( biPoints[1], xx + stepWidth, zz );
ADDRLP4 20+8
ARGP4
ADDRLP4 8
INDIRF4
ADDRLP4 68
INDIRF4
ADDF4
ARGF4
ADDRLP4 12
INDIRF4
ARGF4
ADDRGP4 Vector2Set
CALLV
pop
line 550
;549:
;550:			if ( t + 1 > 0 && t + 1 < mxWidth )
ADDRLP4 168
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 168
INDIRI4
CNSTI4 0
LEI4 $301
ADDRLP4 168
INDIRI4
ADDRLP4 56
INDIRI4
GEI4 $301
line 551
;551:			{
line 552
;552:				xx = x - offX[i + 1][t + 1];
ADDRLP4 8
ADDRLP4 16
INDIRF4
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
CNSTI4 4
ADDI4
CNSTI4 80
ADDRLP4 4
INDIRI4
MULI4
ADDRGP4 offX+80
ADDP4
ADDP4
INDIRF4
SUBF4
ASGNF4
line 553
;553:			}
ADDRGP4 $302
JUMPV
LABELV $301
line 555
;554:			else
;555:			{
line 556
;556:				xx = x;
ADDRLP4 8
ADDRLP4 16
INDIRF4
ASGNF4
line 557
;557:			}
LABELV $302
line 559
;558:
;559:			if ( i + 1 > 0 && i + 1 < mxHeight )
ADDRLP4 172
ADDRLP4 4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 172
INDIRI4
CNSTI4 0
LEI4 $304
ADDRLP4 172
INDIRI4
ADDRLP4 60
INDIRI4
GEI4 $304
line 560
;560:			{
line 561
;561:				zz = z - offZ[t + 1][i + 1];
ADDRLP4 12
ADDRLP4 52
INDIRF4
ADDRLP4 4
INDIRI4
CNSTI4 2
LSHI4
CNSTI4 4
ADDI4
CNSTI4 80
ADDRLP4 0
INDIRI4
MULI4
ADDRGP4 offZ+80
ADDP4
ADDP4
INDIRF4
SUBF4
ASGNF4
line 562
;562:			}
ADDRGP4 $305
JUMPV
LABELV $304
line 564
;563:			else
;564:			{
line 565
;565:				zz = z;
ADDRLP4 12
ADDRLP4 52
INDIRF4
ASGNF4
line 566
;566:			}
LABELV $305
line 568
;567:
;568:			Vector2Set( biPoints[2], xx + stepWidth, zz + stepHeight);
ADDRLP4 20+16
ARGP4
ADDRLP4 8
INDIRF4
ADDRLP4 68
INDIRF4
ADDF4
ARGF4
ADDRLP4 12
INDIRF4
ADDRLP4 120
INDIRF4
ADDF4
ARGF4
ADDRGP4 Vector2Set
CALLV
pop
line 570
;569:
;570:			if ( t > 0 && t < mxWidth )
ADDRLP4 0
INDIRI4
CNSTI4 0
LEI4 $308
ADDRLP4 0
INDIRI4
ADDRLP4 56
INDIRI4
GEI4 $308
line 571
;571:			{
line 572
;572:				xx = x - offX[i + 1][t];
ADDRLP4 8
ADDRLP4 16
INDIRF4
ADDRLP4 0
INDIRI4
CNSTI4 2
LSHI4
CNSTI4 80
ADDRLP4 4
INDIRI4
MULI4
ADDRGP4 offX+80
ADDP4
ADDP4
INDIRF4
SUBF4
ASGNF4
line 573
;573:			}
ADDRGP4 $309
JUMPV
LABELV $308
line 575
;574:			else
;575:			{
line 576
;576:				xx = x;
ADDRLP4 8
ADDRLP4 16
INDIRF4
ASGNF4
line 577
;577:			}
LABELV $309
line 579
;578:
;579:			if ( i + 1 > 0 && i + 1 < mxHeight )
ADDRLP4 180
ADDRLP4 4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 180
INDIRI4
CNSTI4 0
LEI4 $311
ADDRLP4 180
INDIRI4
ADDRLP4 60
INDIRI4
GEI4 $311
line 580
;580:			{
line 581
;581:				zz = z - offZ[t][i + 1];
ADDRLP4 12
ADDRLP4 52
INDIRF4
ADDRLP4 4
INDIRI4
CNSTI4 2
LSHI4
CNSTI4 4
ADDI4
CNSTI4 80
ADDRLP4 0
INDIRI4
MULI4
ADDRGP4 offZ
ADDP4
ADDP4
INDIRF4
SUBF4
ASGNF4
line 582
;582:			}
ADDRGP4 $312
JUMPV
LABELV $311
line 584
;583:			else
;584:			{
line 585
;585:				zz = z;
ADDRLP4 12
ADDRLP4 52
INDIRF4
ASGNF4
line 586
;586:			}
LABELV $312
line 588
;587:
;588:			Vector2Set( biPoints[3], xx, zz + stepHeight );
ADDRLP4 20+24
ARGP4
ADDRLP4 8
INDIRF4
ARGF4
ADDRLP4 12
INDIRF4
ADDRLP4 120
INDIRF4
ADDF4
ARGF4
ADDRGP4 Vector2Set
CALLV
pop
line 590
;589:
;590:			CG_CalcBiLerp( verts, subVerts, biPoints );
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 72
ARGP4
ADDRLP4 20
ARGP4
ADDRGP4 CG_CalcBiLerp
CALLV
pop
line 592
;591:			
;592:			dif = DistanceSquared( subVerts[0], dmgPt ) * timeDecay - random() * 32;
ADDRLP4 72
ARGP4
ADDRFP4 8
INDIRP4
ARGP4
ADDRLP4 184
ADDRGP4 DistanceSquared
CALLF4
ASGNF4
ADDRLP4 188
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 64
ADDRLP4 184
INDIRF4
ADDRLP4 136
INDIRF4
MULF4
CNSTF4 1107296256
ADDRLP4 188
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
MULF4
SUBF4
ASGNF4
line 595
;593:			
;594:			// If we decrease dif, we are increasing the impact area, making it more likely to blow out large holes
;595:			dif -= dmgRadius * dmgRadius;
ADDRLP4 192
ADDRFP4 16
INDIRF4
ASGNF4
ADDRLP4 64
ADDRLP4 64
INDIRF4
ADDRLP4 192
INDIRF4
ADDRLP4 192
INDIRF4
MULF4
SUBF4
ASGNF4
line 597
;596:
;597:			if ( dif > 1 )
ADDRLP4 64
INDIRF4
CNSTF4 1065353216
LEF4 $314
line 598
;598:			{
line 599
;599:				stick = qtrue;
ADDRLP4 132
CNSTI4 1
ASGNI4
line 600
;600:				time = dif + random() * 200;
ADDRLP4 196
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 124
ADDRLP4 64
INDIRF4
CNSTF4 1128792064
ADDRLP4 196
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
MULF4
ADDF4
CVFI4 4
ASGNI4
line 601
;601:			}
ADDRGP4 $315
JUMPV
LABELV $314
line 603
;602:			else
;603:			{
line 604
;604:				stick = qfalse;
ADDRLP4 132
CNSTI4 0
ASGNI4
line 605
;605:				time = 0;
ADDRLP4 124
CNSTI4 0
ASGNI4
line 606
;606:			}
LABELV $315
line 608
;607:
;608:			CG_DoGlassQuad( subVerts, biPoints, stick, time, dmgDir );
ADDRLP4 72
ARGP4
ADDRLP4 20
ARGP4
ADDRLP4 132
INDIRI4
ARGI4
ADDRLP4 124
INDIRI4
ARGI4
ADDRFP4 12
INDIRP4
ARGP4
ADDRGP4 CG_DoGlassQuad
CALLV
pop
line 609
;609:			glassShards++;
ADDRLP4 128
ADDRLP4 128
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 611
;610:
;611:			if (maxShards && glassShards >= maxShards)
ADDRLP4 196
ADDRFP4 20
INDIRI4
ASGNI4
ADDRLP4 196
INDIRI4
CNSTI4 0
EQI4 $316
ADDRLP4 128
INDIRI4
ADDRLP4 196
INDIRI4
LTI4 $316
line 612
;612:			{
line 613
;613:				return;
ADDRGP4 $273
JUMPV
LABELV $316
line 615
;614:			}
;615:		}
LABELV $288
line 507
ADDRLP4 16
ADDRLP4 16
INDIRF4
ADDRLP4 68
INDIRF4
ADDF4
ASGNF4
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $290
ADDRLP4 16
INDIRF4
CNSTF4 1065353216
LTF4 $287
line 616
;616:	}
LABELV $284
line 505
ADDRLP4 52
ADDRLP4 52
INDIRF4
ADDRLP4 120
INDIRF4
ADDF4
ASGNF4
ADDRLP4 4
ADDRLP4 4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $286
ADDRLP4 52
INDIRF4
CNSTF4 1065353216
LTF4 $283
line 617
;617:}
LABELV $273
endproc CG_DoGlass 200 20
export CG_GlassShatter
proc CG_GlassShatter 60 24
line 626
;618:
;619:/*
;620:==================
;621:CG_GlassShatter
;622:Break glass with fancy method
;623:==================
;624:*/
;625:void CG_GlassShatter(int entnum, vec3_t dmgPt, vec3_t dmgDir, float dmgRadius, int maxShards)
;626:{
line 629
;627:	vec3_t		verts[4], normal;
;628:
;629:	if (cgs.inlineDrawModel[cg_entities[entnum].currentState.modelindex])
CNSTI4 1920
ADDRFP4 0
INDIRI4
MULI4
ADDRGP4 cg_entities+212
ADDP4
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 cgs+38928
ADDP4
INDIRI4
CNSTI4 0
EQI4 $319
line 630
;630:	{
line 631
;631:		trap_R_GetBModelVerts(cgs.inlineDrawModel[cg_entities[entnum].currentState.modelindex], verts, normal);
CNSTI4 1920
ADDRFP4 0
INDIRI4
MULI4
ADDRGP4 cg_entities+212
ADDP4
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 cgs+38928
ADDP4
INDIRI4
ARGI4
ADDRLP4 0
ARGP4
ADDRLP4 48
ARGP4
ADDRGP4 trap_R_GetBModelVerts
CALLV
pop
line 632
;632:		CG_DoGlass(verts, normal, dmgPt, dmgDir, dmgRadius, maxShards);
ADDRLP4 0
ARGP4
ADDRLP4 48
ARGP4
ADDRFP4 4
INDIRP4
ARGP4
ADDRFP4 8
INDIRP4
ARGP4
ADDRFP4 12
INDIRF4
ARGF4
ADDRFP4 16
INDIRI4
ARGI4
ADDRGP4 CG_DoGlass
CALLV
pop
line 633
;633:	}
LABELV $319
line 635
;634:	//otherwise something awful has happened.
;635:}
LABELV $318
endproc CG_GlassShatter 60 24
export CG_GlassShatter_Old
proc CG_GlassShatter_Old 388 20
line 644
;636:
;637:/*
;638:==================
;639:CG_GlassShatter_Old
;640:Throws glass shards from within a given bounding box in the world
;641:==================
;642:*/
;643:void CG_GlassShatter_Old(int entnum, vec3_t org, vec3_t mins, vec3_t maxs)
;644:{
line 647
;645:	vec3_t velocity, a, shardorg, dif, difx;
;646:	float windowmass;
;647:	float shardsthrow = 0;
ADDRLP4 304
CNSTF4 0
ASGNF4
line 650
;648:	char chunkname[256];
;649:
;650:	trap_S_StartSound(org, entnum, CHAN_BODY, trap_S_RegisterSound("sound/effects/glassbreak1.wav"));
ADDRGP4 $274
ARGP4
ADDRLP4 324
ADDRGP4 trap_S_RegisterSound
CALLI4
ASGNI4
ADDRFP4 4
INDIRP4
ARGP4
ADDRFP4 0
INDIRI4
ARGI4
CNSTI4 5
ARGI4
ADDRLP4 324
INDIRI4
ARGI4
ADDRGP4 trap_S_StartSound
CALLV
pop
line 652
;651:
;652:	VectorSubtract(maxs, mins, a);
ADDRLP4 328
ADDRFP4 12
INDIRP4
ASGNP4
ADDRLP4 332
ADDRFP4 8
INDIRP4
ASGNP4
ADDRLP4 312
ADDRLP4 328
INDIRP4
INDIRF4
ADDRLP4 332
INDIRP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 336
CNSTI4 4
ASGNI4
ADDRLP4 312+4
ADDRLP4 328
INDIRP4
ADDRLP4 336
INDIRI4
ADDP4
INDIRF4
ADDRLP4 332
INDIRP4
ADDRLP4 336
INDIRI4
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 340
CNSTI4 8
ASGNI4
ADDRLP4 312+8
ADDRFP4 12
INDIRP4
ADDRLP4 340
INDIRI4
ADDP4
INDIRF4
ADDRFP4 8
INDIRP4
ADDRLP4 340
INDIRI4
ADDP4
INDIRF4
SUBF4
ASGNF4
line 654
;653:
;654:	windowmass = VectorLength(a); //should give us some idea of how big the chunk of glass is
ADDRLP4 312
ARGP4
ADDRLP4 344
ADDRGP4 VectorLength
CALLF4
ASGNF4
ADDRLP4 308
ADDRLP4 344
INDIRF4
ASGNF4
ADDRGP4 $329
JUMPV
LABELV $328
line 657
;655:
;656:	while (shardsthrow < windowmass)
;657:	{
line 658
;658:		velocity[0] = crandom()*150;
ADDRLP4 348
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 36
CNSTF4 1125515264
CNSTF4 1073741824
ADDRLP4 348
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ASGNF4
line 659
;659:		velocity[1] = crandom()*150;
ADDRLP4 352
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 36+4
CNSTF4 1125515264
CNSTF4 1073741824
ADDRLP4 352
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ASGNF4
line 660
;660:		velocity[2] = 150 + crandom()*75;
ADDRLP4 356
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 36+8
CNSTF4 1117126656
CNSTF4 1073741824
ADDRLP4 356
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
CNSTF4 1125515264
ADDF4
ASGNF4
line 662
;661:
;662:		Com_sprintf(chunkname, sizeof(chunkname), "models/chunks/glass/glchunks_%i.md3", Q_irand(1, 6));
CNSTI4 1
ARGI4
CNSTI4 6
ARGI4
ADDRLP4 360
ADDRGP4 Q_irand
CALLI4
ASGNI4
ADDRLP4 48
ARGP4
CNSTI4 256
ARGI4
ADDRGP4 $333
ARGP4
ADDRLP4 360
INDIRI4
ARGI4
ADDRGP4 Com_sprintf
CALLV
pop
line 663
;663:		VectorCopy(org, shardorg);
ADDRLP4 24
ADDRFP4 4
INDIRP4
INDIRB
ASGNB 12
line 665
;664:	
;665:		dif[0] = (maxs[0]-mins[0])/2;
ADDRLP4 0
ADDRFP4 12
INDIRP4
INDIRF4
ADDRFP4 8
INDIRP4
INDIRF4
SUBF4
CNSTF4 1073741824
DIVF4
ASGNF4
line 666
;666:		dif[1] = (maxs[1]-mins[1])/2;
ADDRLP4 364
CNSTI4 4
ASGNI4
ADDRLP4 0+4
ADDRFP4 12
INDIRP4
ADDRLP4 364
INDIRI4
ADDP4
INDIRF4
ADDRFP4 8
INDIRP4
ADDRLP4 364
INDIRI4
ADDP4
INDIRF4
SUBF4
CNSTF4 1073741824
DIVF4
ASGNF4
line 667
;667:		dif[2] = (maxs[2]-mins[2])/2;
ADDRLP4 368
CNSTI4 8
ASGNI4
ADDRLP4 0+8
ADDRFP4 12
INDIRP4
ADDRLP4 368
INDIRI4
ADDP4
INDIRF4
ADDRFP4 8
INDIRP4
ADDRLP4 368
INDIRI4
ADDP4
INDIRF4
SUBF4
CNSTF4 1073741824
DIVF4
ASGNF4
line 669
;668:
;669:		if (dif[0] < 2)
ADDRLP4 0
INDIRF4
CNSTF4 1073741824
GEF4 $336
line 670
;670:		{
line 671
;671:			dif[0] = 2;
ADDRLP4 0
CNSTF4 1073741824
ASGNF4
line 672
;672:		}
LABELV $336
line 673
;673:		if (dif[1] < 2)
ADDRLP4 0+4
INDIRF4
CNSTF4 1073741824
GEF4 $338
line 674
;674:		{
line 675
;675:			dif[1] = 2;
ADDRLP4 0+4
CNSTF4 1073741824
ASGNF4
line 676
;676:		}
LABELV $338
line 677
;677:		if (dif[2] < 2)
ADDRLP4 0+8
INDIRF4
CNSTF4 1073741824
GEF4 $342
line 678
;678:		{
line 679
;679:			dif[2] = 2;
ADDRLP4 0+8
CNSTF4 1073741824
ASGNF4
line 680
;680:		}
LABELV $342
line 682
;681:
;682:		difx[0] = Q_irand(1, (dif[0]*0.9)*2);
CNSTI4 1
ARGI4
CNSTF4 1073741824
CNSTF4 1063675494
ADDRLP4 0
INDIRF4
MULF4
MULF4
CVFI4 4
ARGI4
ADDRLP4 372
ADDRGP4 Q_irand
CALLI4
ASGNI4
ADDRLP4 12
ADDRLP4 372
INDIRI4
CVIF4 4
ASGNF4
line 683
;683:		difx[1] = Q_irand(1, (dif[1]*0.9)*2);
CNSTI4 1
ARGI4
CNSTF4 1073741824
CNSTF4 1063675494
ADDRLP4 0+4
INDIRF4
MULF4
MULF4
CVFI4 4
ARGI4
ADDRLP4 376
ADDRGP4 Q_irand
CALLI4
ASGNI4
ADDRLP4 12+4
ADDRLP4 376
INDIRI4
CVIF4 4
ASGNF4
line 684
;684:		difx[2] = Q_irand(1, (dif[2]*0.9)*2);
CNSTI4 1
ARGI4
CNSTF4 1073741824
CNSTF4 1063675494
ADDRLP4 0+8
INDIRF4
MULF4
MULF4
CVFI4 4
ARGI4
ADDRLP4 380
ADDRGP4 Q_irand
CALLI4
ASGNI4
ADDRLP4 12+8
ADDRLP4 380
INDIRI4
CVIF4 4
ASGNF4
line 686
;685:
;686:		if (difx[0] > dif[0])
ADDRLP4 12
INDIRF4
ADDRLP4 0
INDIRF4
LEF4 $350
line 687
;687:		{
line 688
;688:			shardorg[0] += difx[0]-(dif[0]);
ADDRLP4 24
ADDRLP4 24
INDIRF4
ADDRLP4 12
INDIRF4
ADDRLP4 0
INDIRF4
SUBF4
ADDF4
ASGNF4
line 689
;689:		}
ADDRGP4 $351
JUMPV
LABELV $350
line 691
;690:		else
;691:		{
line 692
;692:			shardorg[0] -= difx[0];
ADDRLP4 24
ADDRLP4 24
INDIRF4
ADDRLP4 12
INDIRF4
SUBF4
ASGNF4
line 693
;693:		}
LABELV $351
line 694
;694:		if (difx[1] > dif[1])
ADDRLP4 12+4
INDIRF4
ADDRLP4 0+4
INDIRF4
LEF4 $352
line 695
;695:		{
line 696
;696:			shardorg[1] += difx[1]-(dif[1]);
ADDRLP4 24+4
ADDRLP4 24+4
INDIRF4
ADDRLP4 12+4
INDIRF4
ADDRLP4 0+4
INDIRF4
SUBF4
ADDF4
ASGNF4
line 697
;697:		}
ADDRGP4 $353
JUMPV
LABELV $352
line 699
;698:		else
;699:		{
line 700
;700:			shardorg[1] -= difx[1];
ADDRLP4 24+4
ADDRLP4 24+4
INDIRF4
ADDRLP4 12+4
INDIRF4
SUBF4
ASGNF4
line 701
;701:		}
LABELV $353
line 702
;702:		if (difx[2] > dif[2])
ADDRLP4 12+8
INDIRF4
ADDRLP4 0+8
INDIRF4
LEF4 $361
line 703
;703:		{
line 704
;704:			shardorg[2] += difx[2]-(dif[2]);
ADDRLP4 24+8
ADDRLP4 24+8
INDIRF4
ADDRLP4 12+8
INDIRF4
ADDRLP4 0+8
INDIRF4
SUBF4
ADDF4
ASGNF4
line 705
;705:		}
ADDRGP4 $362
JUMPV
LABELV $361
line 707
;706:		else
;707:		{
line 708
;708:			shardorg[2] -= difx[2];
ADDRLP4 24+8
ADDRLP4 24+8
INDIRF4
ADDRLP4 12+8
INDIRF4
SUBF4
ASGNF4
line 709
;709:		}
LABELV $362
line 713
;710:
;711:		//CG_TestLine(org, shardorg, 5000, 0x0000ff, 3);
;712:
;713:		CG_ThrowChunk( shardorg, velocity, trap_R_RegisterModel( chunkname ), 0, 254 );
ADDRLP4 48
ARGP4
ADDRLP4 384
ADDRGP4 trap_R_RegisterModel
CALLI4
ASGNI4
ADDRLP4 24
ARGP4
ADDRLP4 36
ARGP4
ADDRLP4 384
INDIRI4
ARGI4
CNSTI4 0
ARGI4
CNSTI4 254
ARGI4
ADDRGP4 CG_ThrowChunk
CALLV
pop
line 715
;714:
;715:		shardsthrow += 10;
ADDRLP4 304
ADDRLP4 304
INDIRF4
CNSTF4 1092616192
ADDF4
ASGNF4
line 716
;716:	}
LABELV $329
line 656
ADDRLP4 304
INDIRF4
ADDRLP4 308
INDIRF4
LTF4 $328
line 717
;717:}
LABELV $325
endproc CG_GlassShatter_Old 388 20
export CG_CreateDebris
proc CG_CreateDebris 124 20
line 741
;718:
;719:/*
;720:==================
;721:CG_CreateDebris
;722:Throws specified debris from within a given bounding box in the world
;723:==================
;724:*/
;725:#define DEBRIS_SPECIALCASE_ROCK			-1
;726:#define DEBRIS_SPECIALCASE_CHUNKS		-2
;727:#define DEBRIS_SPECIALCASE_WOOD			-3
;728:#define DEBRIS_SPECIALCASE_GLASS		-4
;729:
;730:#define NUM_DEBRIS_MODELS_GLASS				8
;731:#define NUM_DEBRIS_MODELS_WOOD				8
;732:#define NUM_DEBRIS_MODELS_CHUNKS			3
;733:#define NUM_DEBRIS_MODELS_ROCKS				4 //12
;734:
;735:int dbModels_Glass[NUM_DEBRIS_MODELS_GLASS];
;736:int dbModels_Wood[NUM_DEBRIS_MODELS_WOOD];
;737:int dbModels_Chunks[NUM_DEBRIS_MODELS_CHUNKS];
;738:int dbModels_Rocks[NUM_DEBRIS_MODELS_ROCKS];
;739:
;740:void CG_CreateDebris(int entnum, vec3_t org, vec3_t mins, vec3_t maxs, int debrissound, int debrismodel)
;741:{
line 744
;742:	vec3_t velocity, a, shardorg, dif, difx;
;743:	float windowmass;
;744:	float shardsthrow = 0;
ADDRLP4 52
CNSTF4 0
ASGNF4
line 745
;745:	int omodel = debrismodel;
ADDRLP4 48
ADDRFP4 20
INDIRI4
ASGNI4
line 747
;746:
;747:	if (omodel == DEBRIS_SPECIALCASE_GLASS && !dbModels_Glass[0])
ADDRLP4 48
INDIRI4
CNSTI4 -4
NEI4 $371
ADDRGP4 dbModels_Glass
INDIRI4
CNSTI4 0
NEI4 $371
line 748
;748:	{ //glass no longer exists, using it for metal.
line 749
;749:		dbModels_Glass[0] = trap_R_RegisterModel("models/chunks/metal/metal1_1.md3");
ADDRGP4 $373
ARGP4
ADDRLP4 72
ADDRGP4 trap_R_RegisterModel
CALLI4
ASGNI4
ADDRGP4 dbModels_Glass
ADDRLP4 72
INDIRI4
ASGNI4
line 750
;750:		dbModels_Glass[1] = trap_R_RegisterModel("models/chunks/metal/metal1_2.md3");
ADDRGP4 $375
ARGP4
ADDRLP4 76
ADDRGP4 trap_R_RegisterModel
CALLI4
ASGNI4
ADDRGP4 dbModels_Glass+4
ADDRLP4 76
INDIRI4
ASGNI4
line 751
;751:		dbModels_Glass[2] = trap_R_RegisterModel("models/chunks/metal/metal1_3.md3");
ADDRGP4 $377
ARGP4
ADDRLP4 80
ADDRGP4 trap_R_RegisterModel
CALLI4
ASGNI4
ADDRGP4 dbModels_Glass+8
ADDRLP4 80
INDIRI4
ASGNI4
line 752
;752:		dbModels_Glass[3] = trap_R_RegisterModel("models/chunks/metal/metal1_4.md3");
ADDRGP4 $379
ARGP4
ADDRLP4 84
ADDRGP4 trap_R_RegisterModel
CALLI4
ASGNI4
ADDRGP4 dbModels_Glass+12
ADDRLP4 84
INDIRI4
ASGNI4
line 753
;753:		dbModels_Glass[4] = trap_R_RegisterModel("models/chunks/metal/metal2_1.md3");
ADDRGP4 $381
ARGP4
ADDRLP4 88
ADDRGP4 trap_R_RegisterModel
CALLI4
ASGNI4
ADDRGP4 dbModels_Glass+16
ADDRLP4 88
INDIRI4
ASGNI4
line 754
;754:		dbModels_Glass[5] = trap_R_RegisterModel("models/chunks/metal/metal2_2.md3");
ADDRGP4 $383
ARGP4
ADDRLP4 92
ADDRGP4 trap_R_RegisterModel
CALLI4
ASGNI4
ADDRGP4 dbModels_Glass+20
ADDRLP4 92
INDIRI4
ASGNI4
line 755
;755:		dbModels_Glass[6] = trap_R_RegisterModel("models/chunks/metal/metal2_3.md3");
ADDRGP4 $385
ARGP4
ADDRLP4 96
ADDRGP4 trap_R_RegisterModel
CALLI4
ASGNI4
ADDRGP4 dbModels_Glass+24
ADDRLP4 96
INDIRI4
ASGNI4
line 756
;756:		dbModels_Glass[7] = trap_R_RegisterModel("models/chunks/metal/metal2_4.md3");
ADDRGP4 $387
ARGP4
ADDRLP4 100
ADDRGP4 trap_R_RegisterModel
CALLI4
ASGNI4
ADDRGP4 dbModels_Glass+28
ADDRLP4 100
INDIRI4
ASGNI4
line 757
;757:	}
LABELV $371
line 758
;758:	if (omodel == DEBRIS_SPECIALCASE_WOOD && !dbModels_Wood[0])
ADDRLP4 48
INDIRI4
CNSTI4 -3
NEI4 $388
ADDRGP4 dbModels_Wood
INDIRI4
CNSTI4 0
NEI4 $388
line 759
;759:	{
line 760
;760:		dbModels_Wood[0] = trap_R_RegisterModel("models/chunks/crate/crate1_1.md3");
ADDRGP4 $390
ARGP4
ADDRLP4 72
ADDRGP4 trap_R_RegisterModel
CALLI4
ASGNI4
ADDRGP4 dbModels_Wood
ADDRLP4 72
INDIRI4
ASGNI4
line 761
;761:		dbModels_Wood[1] = trap_R_RegisterModel("models/chunks/crate/crate1_2.md3");
ADDRGP4 $392
ARGP4
ADDRLP4 76
ADDRGP4 trap_R_RegisterModel
CALLI4
ASGNI4
ADDRGP4 dbModels_Wood+4
ADDRLP4 76
INDIRI4
ASGNI4
line 762
;762:		dbModels_Wood[2] = trap_R_RegisterModel("models/chunks/crate/crate1_3.md3");
ADDRGP4 $394
ARGP4
ADDRLP4 80
ADDRGP4 trap_R_RegisterModel
CALLI4
ASGNI4
ADDRGP4 dbModels_Wood+8
ADDRLP4 80
INDIRI4
ASGNI4
line 763
;763:		dbModels_Wood[3] = trap_R_RegisterModel("models/chunks/crate/crate1_4.md3");
ADDRGP4 $396
ARGP4
ADDRLP4 84
ADDRGP4 trap_R_RegisterModel
CALLI4
ASGNI4
ADDRGP4 dbModels_Wood+12
ADDRLP4 84
INDIRI4
ASGNI4
line 764
;764:		dbModels_Wood[4] = trap_R_RegisterModel("models/chunks/crate/crate2_1.md3");
ADDRGP4 $398
ARGP4
ADDRLP4 88
ADDRGP4 trap_R_RegisterModel
CALLI4
ASGNI4
ADDRGP4 dbModels_Wood+16
ADDRLP4 88
INDIRI4
ASGNI4
line 765
;765:		dbModels_Wood[5] = trap_R_RegisterModel("models/chunks/crate/crate2_2.md3");
ADDRGP4 $400
ARGP4
ADDRLP4 92
ADDRGP4 trap_R_RegisterModel
CALLI4
ASGNI4
ADDRGP4 dbModels_Wood+20
ADDRLP4 92
INDIRI4
ASGNI4
line 766
;766:		dbModels_Wood[6] = trap_R_RegisterModel("models/chunks/crate/crate2_3.md3");
ADDRGP4 $402
ARGP4
ADDRLP4 96
ADDRGP4 trap_R_RegisterModel
CALLI4
ASGNI4
ADDRGP4 dbModels_Wood+24
ADDRLP4 96
INDIRI4
ASGNI4
line 767
;767:		dbModels_Wood[7] = trap_R_RegisterModel("models/chunks/crate/crate2_4.md3");
ADDRGP4 $404
ARGP4
ADDRLP4 100
ADDRGP4 trap_R_RegisterModel
CALLI4
ASGNI4
ADDRGP4 dbModels_Wood+28
ADDRLP4 100
INDIRI4
ASGNI4
line 768
;768:	}
LABELV $388
line 769
;769:	if (omodel == DEBRIS_SPECIALCASE_CHUNKS && !dbModels_Chunks[0])
ADDRLP4 48
INDIRI4
CNSTI4 -2
NEI4 $405
ADDRGP4 dbModels_Chunks
INDIRI4
CNSTI4 0
NEI4 $405
line 770
;770:	{
line 771
;771:		dbModels_Chunks[0] = trap_R_RegisterModel("models/chunks/generic/chunks_1.md3");
ADDRGP4 $407
ARGP4
ADDRLP4 72
ADDRGP4 trap_R_RegisterModel
CALLI4
ASGNI4
ADDRGP4 dbModels_Chunks
ADDRLP4 72
INDIRI4
ASGNI4
line 772
;772:		dbModels_Chunks[1] = trap_R_RegisterModel("models/chunks/generic/chunks_2.md3");
ADDRGP4 $409
ARGP4
ADDRLP4 76
ADDRGP4 trap_R_RegisterModel
CALLI4
ASGNI4
ADDRGP4 dbModels_Chunks+4
ADDRLP4 76
INDIRI4
ASGNI4
line 773
;773:	}
LABELV $405
line 774
;774:	if (omodel == DEBRIS_SPECIALCASE_ROCK && !dbModels_Rocks[0])
ADDRLP4 48
INDIRI4
CNSTI4 -1
NEI4 $410
ADDRGP4 dbModels_Rocks
INDIRI4
CNSTI4 0
NEI4 $410
line 775
;775:	{
line 776
;776:		dbModels_Rocks[0] = trap_R_RegisterModel("models/chunks/rock/rock1_1.md3");
ADDRGP4 $412
ARGP4
ADDRLP4 72
ADDRGP4 trap_R_RegisterModel
CALLI4
ASGNI4
ADDRGP4 dbModels_Rocks
ADDRLP4 72
INDIRI4
ASGNI4
line 777
;777:		dbModels_Rocks[1] = trap_R_RegisterModel("models/chunks/rock/rock1_2.md3");
ADDRGP4 $414
ARGP4
ADDRLP4 76
ADDRGP4 trap_R_RegisterModel
CALLI4
ASGNI4
ADDRGP4 dbModels_Rocks+4
ADDRLP4 76
INDIRI4
ASGNI4
line 778
;778:		dbModels_Rocks[2] = trap_R_RegisterModel("models/chunks/rock/rock1_3.md3");
ADDRGP4 $416
ARGP4
ADDRLP4 80
ADDRGP4 trap_R_RegisterModel
CALLI4
ASGNI4
ADDRGP4 dbModels_Rocks+8
ADDRLP4 80
INDIRI4
ASGNI4
line 779
;779:		dbModels_Rocks[3] = trap_R_RegisterModel("models/chunks/rock/rock1_4.md3");
ADDRGP4 $418
ARGP4
ADDRLP4 84
ADDRGP4 trap_R_RegisterModel
CALLI4
ASGNI4
ADDRGP4 dbModels_Rocks+12
ADDRLP4 84
INDIRI4
ASGNI4
line 790
;780:		/*
;781:		dbModels_Rocks[4] = trap_R_RegisterModel("models/chunks/rock/rock2_1.md3");
;782:		dbModels_Rocks[5] = trap_R_RegisterModel("models/chunks/rock/rock2_2.md3");
;783:		dbModels_Rocks[6] = trap_R_RegisterModel("models/chunks/rock/rock2_3.md3");
;784:		dbModels_Rocks[7] = trap_R_RegisterModel("models/chunks/rock/rock2_4.md3");
;785:		dbModels_Rocks[8] = trap_R_RegisterModel("models/chunks/rock/rock3_1.md3");
;786:		dbModels_Rocks[9] = trap_R_RegisterModel("models/chunks/rock/rock3_2.md3");
;787:		dbModels_Rocks[10] = trap_R_RegisterModel("models/chunks/rock/rock3_3.md3");
;788:		dbModels_Rocks[11] = trap_R_RegisterModel("models/chunks/rock/rock3_4.md3");
;789:		*/
;790:	}
LABELV $410
line 792
;791:
;792:	VectorSubtract(maxs, mins, a);
ADDRLP4 72
ADDRFP4 12
INDIRP4
ASGNP4
ADDRLP4 76
ADDRFP4 8
INDIRP4
ASGNP4
ADDRLP4 60
ADDRLP4 72
INDIRP4
INDIRF4
ADDRLP4 76
INDIRP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 80
CNSTI4 4
ASGNI4
ADDRLP4 60+4
ADDRLP4 72
INDIRP4
ADDRLP4 80
INDIRI4
ADDP4
INDIRF4
ADDRLP4 76
INDIRP4
ADDRLP4 80
INDIRI4
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 84
CNSTI4 8
ASGNI4
ADDRLP4 60+8
ADDRFP4 12
INDIRP4
ADDRLP4 84
INDIRI4
ADDP4
INDIRF4
ADDRFP4 8
INDIRP4
ADDRLP4 84
INDIRI4
ADDP4
INDIRF4
SUBF4
ASGNF4
line 794
;793:
;794:	windowmass = VectorLength(a); //should give us some idea of how big the chunk of glass is
ADDRLP4 60
ARGP4
ADDRLP4 88
ADDRGP4 VectorLength
CALLF4
ASGNF4
ADDRLP4 56
ADDRLP4 88
INDIRF4
ASGNF4
ADDRGP4 $422
JUMPV
LABELV $421
line 797
;795:
;796:	while (shardsthrow < windowmass)
;797:	{
line 798
;798:		velocity[0] = crandom()*150;
ADDRLP4 92
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 36
CNSTF4 1125515264
CNSTF4 1073741824
ADDRLP4 92
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ASGNF4
line 799
;799:		velocity[1] = crandom()*150;
ADDRLP4 96
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 36+4
CNSTF4 1125515264
CNSTF4 1073741824
ADDRLP4 96
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ASGNF4
line 800
;800:		velocity[2] = 150 + crandom()*75;
ADDRLP4 100
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 36+8
CNSTF4 1117126656
CNSTF4 1073741824
ADDRLP4 100
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
CNSTF4 1125515264
ADDF4
ASGNF4
line 802
;801:
;802:		if (omodel == DEBRIS_SPECIALCASE_GLASS)
ADDRLP4 48
INDIRI4
CNSTI4 -4
NEI4 $426
line 803
;803:		{
line 804
;804:			debrismodel = dbModels_Glass[Q_irand(0, NUM_DEBRIS_MODELS_GLASS-1)];
CNSTI4 0
ARGI4
CNSTI4 7
ARGI4
ADDRLP4 104
ADDRGP4 Q_irand
CALLI4
ASGNI4
ADDRFP4 20
ADDRLP4 104
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 dbModels_Glass
ADDP4
INDIRI4
ASGNI4
line 805
;805:		}
ADDRGP4 $427
JUMPV
LABELV $426
line 806
;806:		else if (omodel == DEBRIS_SPECIALCASE_WOOD)
ADDRLP4 48
INDIRI4
CNSTI4 -3
NEI4 $428
line 807
;807:		{
line 808
;808:			debrismodel = dbModels_Wood[Q_irand(0, NUM_DEBRIS_MODELS_WOOD-1)];
CNSTI4 0
ARGI4
CNSTI4 7
ARGI4
ADDRLP4 104
ADDRGP4 Q_irand
CALLI4
ASGNI4
ADDRFP4 20
ADDRLP4 104
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 dbModels_Wood
ADDP4
INDIRI4
ASGNI4
line 809
;809:		}
ADDRGP4 $429
JUMPV
LABELV $428
line 810
;810:		else if (omodel == DEBRIS_SPECIALCASE_CHUNKS)
ADDRLP4 48
INDIRI4
CNSTI4 -2
NEI4 $430
line 811
;811:		{
line 812
;812:			debrismodel = dbModels_Chunks[Q_irand(0, NUM_DEBRIS_MODELS_CHUNKS-1)];
CNSTI4 0
ARGI4
CNSTI4 2
ARGI4
ADDRLP4 104
ADDRGP4 Q_irand
CALLI4
ASGNI4
ADDRFP4 20
ADDRLP4 104
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 dbModels_Chunks
ADDP4
INDIRI4
ASGNI4
line 813
;813:		}
ADDRGP4 $431
JUMPV
LABELV $430
line 814
;814:		else if (omodel == DEBRIS_SPECIALCASE_ROCK)
ADDRLP4 48
INDIRI4
CNSTI4 -1
NEI4 $432
line 815
;815:		{
line 816
;816:			debrismodel = dbModels_Rocks[Q_irand(0, NUM_DEBRIS_MODELS_ROCKS-1)];
CNSTI4 0
ARGI4
CNSTI4 3
ARGI4
ADDRLP4 104
ADDRGP4 Q_irand
CALLI4
ASGNI4
ADDRFP4 20
ADDRLP4 104
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 dbModels_Rocks
ADDP4
INDIRI4
ASGNI4
line 817
;817:		}
LABELV $432
LABELV $431
LABELV $429
LABELV $427
line 819
;818:
;819:		VectorCopy(org, shardorg);
ADDRLP4 24
ADDRFP4 4
INDIRP4
INDIRB
ASGNB 12
line 821
;820:	
;821:		dif[0] = (maxs[0]-mins[0])/2;
ADDRLP4 0
ADDRFP4 12
INDIRP4
INDIRF4
ADDRFP4 8
INDIRP4
INDIRF4
SUBF4
CNSTF4 1073741824
DIVF4
ASGNF4
line 822
;822:		dif[1] = (maxs[1]-mins[1])/2;
ADDRLP4 104
CNSTI4 4
ASGNI4
ADDRLP4 0+4
ADDRFP4 12
INDIRP4
ADDRLP4 104
INDIRI4
ADDP4
INDIRF4
ADDRFP4 8
INDIRP4
ADDRLP4 104
INDIRI4
ADDP4
INDIRF4
SUBF4
CNSTF4 1073741824
DIVF4
ASGNF4
line 823
;823:		dif[2] = (maxs[2]-mins[2])/2;
ADDRLP4 108
CNSTI4 8
ASGNI4
ADDRLP4 0+8
ADDRFP4 12
INDIRP4
ADDRLP4 108
INDIRI4
ADDP4
INDIRF4
ADDRFP4 8
INDIRP4
ADDRLP4 108
INDIRI4
ADDP4
INDIRF4
SUBF4
CNSTF4 1073741824
DIVF4
ASGNF4
line 825
;824:
;825:		if (dif[0] < 2)
ADDRLP4 0
INDIRF4
CNSTF4 1073741824
GEF4 $436
line 826
;826:		{
line 827
;827:			dif[0] = 2;
ADDRLP4 0
CNSTF4 1073741824
ASGNF4
line 828
;828:		}
LABELV $436
line 829
;829:		if (dif[1] < 2)
ADDRLP4 0+4
INDIRF4
CNSTF4 1073741824
GEF4 $438
line 830
;830:		{
line 831
;831:			dif[1] = 2;
ADDRLP4 0+4
CNSTF4 1073741824
ASGNF4
line 832
;832:		}
LABELV $438
line 833
;833:		if (dif[2] < 2)
ADDRLP4 0+8
INDIRF4
CNSTF4 1073741824
GEF4 $442
line 834
;834:		{
line 835
;835:			dif[2] = 2;
ADDRLP4 0+8
CNSTF4 1073741824
ASGNF4
line 836
;836:		}
LABELV $442
line 838
;837:
;838:		difx[0] = Q_irand(1, (dif[0]*0.9)*2);
CNSTI4 1
ARGI4
CNSTF4 1073741824
CNSTF4 1063675494
ADDRLP4 0
INDIRF4
MULF4
MULF4
CVFI4 4
ARGI4
ADDRLP4 112
ADDRGP4 Q_irand
CALLI4
ASGNI4
ADDRLP4 12
ADDRLP4 112
INDIRI4
CVIF4 4
ASGNF4
line 839
;839:		difx[1] = Q_irand(1, (dif[1]*0.9)*2);
CNSTI4 1
ARGI4
CNSTF4 1073741824
CNSTF4 1063675494
ADDRLP4 0+4
INDIRF4
MULF4
MULF4
CVFI4 4
ARGI4
ADDRLP4 116
ADDRGP4 Q_irand
CALLI4
ASGNI4
ADDRLP4 12+4
ADDRLP4 116
INDIRI4
CVIF4 4
ASGNF4
line 840
;840:		difx[2] = Q_irand(1, (dif[2]*0.9)*2);
CNSTI4 1
ARGI4
CNSTF4 1073741824
CNSTF4 1063675494
ADDRLP4 0+8
INDIRF4
MULF4
MULF4
CVFI4 4
ARGI4
ADDRLP4 120
ADDRGP4 Q_irand
CALLI4
ASGNI4
ADDRLP4 12+8
ADDRLP4 120
INDIRI4
CVIF4 4
ASGNF4
line 842
;841:
;842:		if (difx[0] > dif[0])
ADDRLP4 12
INDIRF4
ADDRLP4 0
INDIRF4
LEF4 $450
line 843
;843:		{
line 844
;844:			shardorg[0] += difx[0]-(dif[0]);
ADDRLP4 24
ADDRLP4 24
INDIRF4
ADDRLP4 12
INDIRF4
ADDRLP4 0
INDIRF4
SUBF4
ADDF4
ASGNF4
line 845
;845:		}
ADDRGP4 $451
JUMPV
LABELV $450
line 847
;846:		else
;847:		{
line 848
;848:			shardorg[0] -= difx[0];
ADDRLP4 24
ADDRLP4 24
INDIRF4
ADDRLP4 12
INDIRF4
SUBF4
ASGNF4
line 849
;849:		}
LABELV $451
line 850
;850:		if (difx[1] > dif[1])
ADDRLP4 12+4
INDIRF4
ADDRLP4 0+4
INDIRF4
LEF4 $452
line 851
;851:		{
line 852
;852:			shardorg[1] += difx[1]-(dif[1]);
ADDRLP4 24+4
ADDRLP4 24+4
INDIRF4
ADDRLP4 12+4
INDIRF4
ADDRLP4 0+4
INDIRF4
SUBF4
ADDF4
ASGNF4
line 853
;853:		}
ADDRGP4 $453
JUMPV
LABELV $452
line 855
;854:		else
;855:		{
line 856
;856:			shardorg[1] -= difx[1];
ADDRLP4 24+4
ADDRLP4 24+4
INDIRF4
ADDRLP4 12+4
INDIRF4
SUBF4
ASGNF4
line 857
;857:		}
LABELV $453
line 858
;858:		if (difx[2] > dif[2])
ADDRLP4 12+8
INDIRF4
ADDRLP4 0+8
INDIRF4
LEF4 $461
line 859
;859:		{
line 860
;860:			shardorg[2] += difx[2]-(dif[2]);
ADDRLP4 24+8
ADDRLP4 24+8
INDIRF4
ADDRLP4 12+8
INDIRF4
ADDRLP4 0+8
INDIRF4
SUBF4
ADDF4
ASGNF4
line 861
;861:		}
ADDRGP4 $462
JUMPV
LABELV $461
line 863
;862:		else
;863:		{
line 864
;864:			shardorg[2] -= difx[2];
ADDRLP4 24+8
ADDRLP4 24+8
INDIRF4
ADDRLP4 12+8
INDIRF4
SUBF4
ASGNF4
line 865
;865:		}
LABELV $462
line 869
;866:
;867:		//CG_TestLine(org, shardorg, 5000, 0x0000ff, 3);
;868:
;869:		CG_ThrowChunk( shardorg, velocity, debrismodel, debrissound, 0 );
ADDRLP4 24
ARGP4
ADDRLP4 36
ARGP4
ADDRFP4 20
INDIRI4
ARGI4
ADDRFP4 16
INDIRI4
ARGI4
CNSTI4 0
ARGI4
ADDRGP4 CG_ThrowChunk
CALLV
pop
line 871
;870:
;871:		shardsthrow += 10;
ADDRLP4 52
ADDRLP4 52
INDIRF4
CNSTF4 1092616192
ADDF4
ASGNF4
line 872
;872:	}
LABELV $422
line 796
ADDRLP4 52
INDIRF4
ADDRLP4 56
INDIRF4
LTF4 $421
line 873
;873:}
LABELV $370
endproc CG_CreateDebris 124 20
bss
align 4
LABELV $471
skip 12
export CG_ScorePlum
code
proc CG_ScorePlum 48 8
line 880
;874:
;875:/*
;876:==================
;877:CG_ScorePlum
;878:==================
;879:*/
;880:void CG_ScorePlum( int client, vec3_t org, int score ) {
line 887
;881:	localEntity_t	*le;
;882:	refEntity_t		*re;
;883:	vec3_t			angles;
;884:	static vec3_t lastPos;
;885:
;886:	// only visualize for the client that scored
;887:	if (client != cg.predictedPlayerState.clientNum || cg_scorePlum.integer == 0) {
ADDRFP4 0
INDIRI4
ADDRGP4 cg+96+144
INDIRI4
NEI4 $477
ADDRGP4 cg_scorePlum+12
INDIRI4
CNSTI4 0
NEI4 $472
LABELV $477
line 888
;888:		return;
ADDRGP4 $470
JUMPV
LABELV $472
line 891
;889:	}
;890:
;891:	le = CG_AllocLocalEntity();
ADDRLP4 20
ADDRGP4 CG_AllocLocalEntity
CALLP4
ASGNP4
ADDRLP4 0
ADDRLP4 20
INDIRP4
ASGNP4
line 892
;892:	le->leFlags = 0;
ADDRLP4 0
INDIRP4
CNSTI4 12
ADDP4
CNSTI4 0
ASGNI4
line 893
;893:	le->leType = LE_SCOREPLUM;
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
CNSTI4 10
ASGNI4
line 894
;894:	le->startTime = cg.time;
ADDRLP4 0
INDIRP4
CNSTI4 16
ADDP4
ADDRGP4 cg+64
INDIRI4
ASGNI4
line 895
;895:	le->endTime = cg.time + 4000;
ADDRLP4 0
INDIRP4
CNSTI4 20
ADDP4
ADDRGP4 cg+64
INDIRI4
CNSTI4 4000
ADDI4
ASGNI4
line 896
;896:	le->lifeRate = 1.0 / ( le->endTime - le->startTime );
ADDRLP4 0
INDIRP4
CNSTI4 28
ADDP4
CNSTF4 1065353216
ADDRLP4 0
INDIRP4
CNSTI4 20
ADDP4
INDIRI4
ADDRLP4 0
INDIRP4
CNSTI4 16
ADDP4
INDIRI4
SUBI4
CVIF4 4
DIVF4
ASGNF4
line 899
;897:
;898:	
;899:	le->color[0] = le->color[1] = le->color[2] = le->color[3] = 1.0;
ADDRLP4 32
CNSTF4 1065353216
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 136
ADDP4
ADDRLP4 32
INDIRF4
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 132
ADDP4
ADDRLP4 32
INDIRF4
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 128
ADDP4
ADDRLP4 32
INDIRF4
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 124
ADDP4
ADDRLP4 32
INDIRF4
ASGNF4
line 900
;900:	le->radius = score;
ADDRLP4 0
INDIRP4
CNSTI4 140
ADDP4
ADDRFP4 8
INDIRI4
CVIF4 4
ASGNF4
line 902
;901:	
;902:	VectorCopy( org, le->pos.trBase );
ADDRLP4 0
INDIRP4
CNSTI4 44
ADDP4
ADDRFP4 4
INDIRP4
INDIRB
ASGNB 12
line 903
;903:	if (org[2] >= lastPos[2] - 20 && org[2] <= lastPos[2] + 20) {
ADDRLP4 36
ADDRFP4 4
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ASGNF4
ADDRLP4 40
CNSTF4 1101004800
ASGNF4
ADDRLP4 36
INDIRF4
ADDRGP4 $471+8
INDIRF4
ADDRLP4 40
INDIRF4
SUBF4
LTF4 $480
ADDRLP4 36
INDIRF4
ADDRGP4 $471+8
INDIRF4
ADDRLP4 40
INDIRF4
ADDF4
GTF4 $480
line 904
;904:		le->pos.trBase[2] -= 20;
ADDRLP4 44
ADDRLP4 0
INDIRP4
CNSTI4 52
ADDP4
ASGNP4
ADDRLP4 44
INDIRP4
ADDRLP4 44
INDIRP4
INDIRF4
CNSTF4 1101004800
SUBF4
ASGNF4
line 905
;905:	}
LABELV $480
line 908
;906:
;907:	//CG_Printf( "Plum origin %i %i %i -- %i\n", (int)org[0], (int)org[1], (int)org[2], (int)Distance(org, lastPos));
;908:	VectorCopy(org, lastPos);
ADDRGP4 $471
ADDRFP4 4
INDIRP4
INDIRB
ASGNB 12
line 911
;909:
;910:
;911:	re = &le->refEntity;
ADDRLP4 4
ADDRLP4 0
INDIRP4
CNSTI4 248
ADDP4
ASGNP4
line 913
;912:
;913:	re->reType = RT_SPRITE;
ADDRLP4 4
INDIRP4
CNSTI4 2
ASGNI4
line 914
;914:	re->radius = 16;
ADDRLP4 4
INDIRP4
CNSTI4 92
ADDP4
CNSTF4 1098907648
ASGNF4
line 916
;915:
;916:	VectorClear(angles);
ADDRLP4 44
CNSTF4 0
ASGNF4
ADDRLP4 8+8
ADDRLP4 44
INDIRF4
ASGNF4
ADDRLP4 8+4
ADDRLP4 44
INDIRF4
ASGNF4
ADDRLP4 8
ADDRLP4 44
INDIRF4
ASGNF4
line 917
;917:	AnglesToAxis( angles, re->axis );
ADDRLP4 8
ARGP4
ADDRLP4 4
INDIRP4
CNSTI4 12
ADDP4
ARGP4
ADDRGP4 AnglesToAxis
CALLV
pop
line 918
;918:}
LABELV $470
endproc CG_ScorePlum 48 8
export CG_ExplosionEffects
proc CG_ExplosionEffects 32 4
line 931
;919:
;920:
;921:/*
;922:-------------------------
;923:CG_ExplosionEffects
;924:
;925:Used to find the player and shake the camera if close enough
;926:intensity ranges from 1 (minor tremble) to 16 (major quake)
;927:-------------------------
;928:*/
;929:
;930:void CG_ExplosionEffects( vec3_t origin, float intensity, int radius)
;931:{
line 938
;932:	//FIXME: When exactly is the vieworg calculated in relation to the rest of the frame?s
;933:
;934:	vec3_t	dir;
;935:	float	dist, intensityScale;
;936:	float	realIntensity;
;937:
;938:	VectorSubtract( cg.refdef.vieworg, origin, dir );
ADDRLP4 24
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 0
ADDRGP4 cg+3616+24
INDIRF4
ADDRLP4 24
INDIRP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 0+4
ADDRGP4 cg+3616+24+4
INDIRF4
ADDRLP4 24
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 0+8
ADDRGP4 cg+3616+24+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
SUBF4
ASGNF4
line 939
;939:	dist = VectorNormalize( dir );
ADDRLP4 0
ARGP4
ADDRLP4 28
ADDRGP4 VectorNormalize
CALLF4
ASGNF4
ADDRLP4 12
ADDRLP4 28
INDIRF4
ASGNF4
line 943
;940:
;941:	//Use the dir to add kick to the explosion
;942:
;943:	if ( dist > radius )
ADDRLP4 12
INDIRF4
ADDRFP4 8
INDIRI4
CVIF4 4
LEF4 $497
line 944
;944:		return;
ADDRGP4 $486
JUMPV
LABELV $497
line 946
;945:
;946:	intensityScale = 1 - ( dist / (float) radius );
ADDRLP4 16
CNSTF4 1065353216
ADDRLP4 12
INDIRF4
ADDRFP4 8
INDIRI4
CVIF4 4
DIVF4
SUBF4
ASGNF4
line 947
;947:	realIntensity = intensity * intensityScale;
ADDRLP4 20
ADDRFP4 4
INDIRF4
ADDRLP4 16
INDIRF4
MULF4
ASGNF4
line 950
;948:
;949://	CGCam_Shake( realIntensity, 750 ); // 500 seemed a bit too quick
;950:}
LABELV $486
endproc CG_ExplosionEffects 32 4
export CG_MakeExplosion
proc CG_MakeExplosion 88 8
line 961
;951:
;952:
;953:/*
;954:====================
;955:CG_MakeExplosion
;956:====================
;957:*/
;958:localEntity_t *CG_MakeExplosion( vec3_t origin, vec3_t dir, 
;959:								qhandle_t hModel, int numFrames, qhandle_t shader,
;960:								int msec, qboolean isSprite, float scale, int flags )
;961:{
line 962
;962:	float			ang = 0;
ADDRLP4 32
CNSTF4 0
ASGNF4
line 967
;963:	localEntity_t	*ex;
;964:	int				offset;
;965:	vec3_t			tmpVec, newOrigin;
;966:
;967:	if ( msec <= 0 ) {
ADDRFP4 20
INDIRI4
CNSTI4 0
GTI4 $500
line 968
;968:		CG_Error( "CG_MakeExplosion: msec = %i", msec );
ADDRGP4 $502
ARGP4
ADDRFP4 20
INDIRI4
ARGI4
ADDRGP4 CG_Error
CALLV
pop
line 969
;969:	}
LABELV $500
line 972
;970:
;971:	// skew the time a bit so they aren't all in sync
;972:	offset = rand() & 63;
ADDRLP4 36
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 28
ADDRLP4 36
INDIRI4
CNSTI4 63
BANDI4
ASGNI4
line 974
;973:
;974:	ex = CG_AllocLocalEntity();
ADDRLP4 40
ADDRGP4 CG_AllocLocalEntity
CALLP4
ASGNP4
ADDRLP4 0
ADDRLP4 40
INDIRP4
ASGNP4
line 975
;975:	if ( isSprite ) {
ADDRFP4 24
INDIRI4
CNSTI4 0
EQI4 $503
line 976
;976:		ex->leType = LE_SPRITE_EXPLOSION; 
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
CNSTI4 2
ASGNI4
line 977
;977:		ex->refEntity.rotation = rand() % 360;
ADDRLP4 44
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 344
ADDP4
ADDRLP4 44
INDIRI4
CNSTI4 360
MODI4
CVIF4 4
ASGNF4
line 978
;978:		ex->radius = scale;
ADDRLP4 0
INDIRP4
CNSTI4 140
ADDP4
ADDRFP4 28
INDIRF4
ASGNF4
line 979
;979:		VectorScale( dir, 16, tmpVec );
ADDRLP4 48
CNSTF4 1098907648
ASGNF4
ADDRLP4 52
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 16
ADDRLP4 48
INDIRF4
ADDRLP4 52
INDIRP4
INDIRF4
MULF4
ASGNF4
ADDRLP4 16+4
ADDRLP4 48
INDIRF4
ADDRLP4 52
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
MULF4
ASGNF4
ADDRLP4 16+8
CNSTF4 1098907648
ADDRFP4 4
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
MULF4
ASGNF4
line 980
;980:		VectorAdd( tmpVec, origin, newOrigin );
ADDRLP4 56
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 4
ADDRLP4 16
INDIRF4
ADDRLP4 56
INDIRP4
INDIRF4
ADDF4
ASGNF4
ADDRLP4 4+4
ADDRLP4 16+4
INDIRF4
ADDRLP4 56
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
ADDF4
ASGNF4
ADDRLP4 4+8
ADDRLP4 16+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
ADDF4
ASGNF4
line 981
;981:	} else {
ADDRGP4 $504
JUMPV
LABELV $503
line 982
;982:		ex->leType = LE_EXPLOSION;
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
CNSTI4 1
ASGNI4
line 983
;983:		VectorCopy( origin, newOrigin );
ADDRLP4 4
ADDRFP4 0
INDIRP4
INDIRB
ASGNB 12
line 986
;984:
;985:		// set axis with random rotate when necessary
;986:		if ( !dir )
ADDRFP4 4
INDIRP4
CVPU4 4
CNSTU4 0
NEU4 $511
line 987
;987:		{
line 988
;988:			AxisClear( ex->refEntity.axis );
ADDRLP4 0
INDIRP4
CNSTI4 260
ADDP4
ARGP4
ADDRGP4 AxisClear
CALLV
pop
line 989
;989:		}
ADDRGP4 $512
JUMPV
LABELV $511
line 991
;990:		else
;991:		{
line 992
;992:			if ( !(flags & LEF_NO_RANDOM_ROTATE) )
ADDRFP4 32
INDIRI4
CNSTI4 8
BANDI4
CNSTI4 0
NEI4 $513
line 993
;993:				ang = rand() % 360;
ADDRLP4 44
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 32
ADDRLP4 44
INDIRI4
CNSTI4 360
MODI4
CVIF4 4
ASGNF4
LABELV $513
line 994
;994:			VectorCopy( dir, ex->refEntity.axis[0] );
ADDRLP4 0
INDIRP4
CNSTI4 260
ADDP4
ADDRFP4 4
INDIRP4
INDIRB
ASGNB 12
line 995
;995:			RotateAroundDirection( ex->refEntity.axis, ang );
ADDRLP4 0
INDIRP4
CNSTI4 260
ADDP4
ARGP4
ADDRLP4 32
INDIRF4
ARGF4
ADDRGP4 RotateAroundDirection
CALLV
pop
line 996
;996:		}
LABELV $512
line 997
;997:	}
LABELV $504
line 999
;998:
;999:	ex->startTime = cg.time - offset;
ADDRLP4 0
INDIRP4
CNSTI4 16
ADDP4
ADDRGP4 cg+64
INDIRI4
ADDRLP4 28
INDIRI4
SUBI4
ASGNI4
line 1000
;1000:	ex->endTime = ex->startTime + msec;
ADDRLP4 0
INDIRP4
CNSTI4 20
ADDP4
ADDRLP4 0
INDIRP4
CNSTI4 16
ADDP4
INDIRI4
ADDRFP4 20
INDIRI4
ADDI4
ASGNI4
line 1003
;1001:	
;1002:	// bias the time so all shader effects start correctly
;1003:	ex->refEntity.shaderTime = ex->startTime / 1000.0f;
ADDRLP4 0
INDIRP4
CNSTI4 348
ADDP4
ADDRLP4 0
INDIRP4
CNSTI4 16
ADDP4
INDIRI4
CVIF4 4
CNSTF4 1148846080
DIVF4
ASGNF4
line 1005
;1004:
;1005:	ex->refEntity.hModel = hModel;
ADDRLP4 0
INDIRP4
CNSTI4 256
ADDP4
ADDRFP4 8
INDIRI4
ASGNI4
line 1006
;1006:	ex->refEntity.customShader = shader;
ADDRLP4 0
INDIRP4
CNSTI4 324
ADDP4
ADDRFP4 16
INDIRI4
ASGNI4
line 1007
;1007:	ex->lifeRate = (float)numFrames / msec;
ADDRLP4 0
INDIRP4
CNSTI4 28
ADDP4
ADDRFP4 12
INDIRI4
CVIF4 4
ADDRFP4 20
INDIRI4
CVIF4 4
DIVF4
ASGNF4
line 1008
;1008:	ex->leFlags = flags;
ADDRLP4 0
INDIRP4
CNSTI4 12
ADDP4
ADDRFP4 32
INDIRI4
ASGNI4
line 1011
;1009:
;1010:	//Scale the explosion
;1011:	if (scale != 1) {
ADDRFP4 28
INDIRF4
CNSTF4 1065353216
EQF4 $516
line 1012
;1012:		ex->refEntity.nonNormalizedAxes = qtrue;
ADDRLP4 0
INDIRP4
CNSTI4 296
ADDP4
CNSTI4 1
ASGNI4
line 1014
;1013:
;1014:		VectorScale( ex->refEntity.axis[0], scale, ex->refEntity.axis[0] );
ADDRLP4 52
ADDRLP4 0
INDIRP4
CNSTI4 260
ADDP4
ASGNP4
ADDRLP4 52
INDIRP4
ADDRLP4 52
INDIRP4
INDIRF4
ADDRFP4 28
INDIRF4
MULF4
ASGNF4
ADDRLP4 56
ADDRLP4 0
INDIRP4
CNSTI4 264
ADDP4
ASGNP4
ADDRLP4 56
INDIRP4
ADDRLP4 56
INDIRP4
INDIRF4
ADDRFP4 28
INDIRF4
MULF4
ASGNF4
ADDRLP4 60
ADDRLP4 0
INDIRP4
CNSTI4 268
ADDP4
ASGNP4
ADDRLP4 60
INDIRP4
ADDRLP4 60
INDIRP4
INDIRF4
ADDRFP4 28
INDIRF4
MULF4
ASGNF4
line 1015
;1015:		VectorScale( ex->refEntity.axis[1], scale, ex->refEntity.axis[1] );
ADDRLP4 64
ADDRLP4 0
INDIRP4
CNSTI4 272
ADDP4
ASGNP4
ADDRLP4 64
INDIRP4
ADDRLP4 64
INDIRP4
INDIRF4
ADDRFP4 28
INDIRF4
MULF4
ASGNF4
ADDRLP4 68
ADDRLP4 0
INDIRP4
CNSTI4 276
ADDP4
ASGNP4
ADDRLP4 68
INDIRP4
ADDRLP4 68
INDIRP4
INDIRF4
ADDRFP4 28
INDIRF4
MULF4
ASGNF4
ADDRLP4 72
ADDRLP4 0
INDIRP4
CNSTI4 280
ADDP4
ASGNP4
ADDRLP4 72
INDIRP4
ADDRLP4 72
INDIRP4
INDIRF4
ADDRFP4 28
INDIRF4
MULF4
ASGNF4
line 1016
;1016:		VectorScale( ex->refEntity.axis[2], scale, ex->refEntity.axis[2] );
ADDRLP4 76
ADDRLP4 0
INDIRP4
CNSTI4 284
ADDP4
ASGNP4
ADDRLP4 76
INDIRP4
ADDRLP4 76
INDIRP4
INDIRF4
ADDRFP4 28
INDIRF4
MULF4
ASGNF4
ADDRLP4 80
ADDRLP4 0
INDIRP4
CNSTI4 288
ADDP4
ASGNP4
ADDRLP4 80
INDIRP4
ADDRLP4 80
INDIRP4
INDIRF4
ADDRFP4 28
INDIRF4
MULF4
ASGNF4
ADDRLP4 84
ADDRLP4 0
INDIRP4
CNSTI4 292
ADDP4
ASGNP4
ADDRLP4 84
INDIRP4
ADDRLP4 84
INDIRP4
INDIRF4
ADDRFP4 28
INDIRF4
MULF4
ASGNF4
line 1017
;1017:	}
LABELV $516
line 1019
;1018:	// set origin
;1019:	VectorCopy ( newOrigin, ex->refEntity.origin);
ADDRLP4 0
INDIRP4
CNSTI4 300
ADDP4
ADDRLP4 4
INDIRB
ASGNB 12
line 1020
;1020:	VectorCopy ( newOrigin, ex->refEntity.oldorigin );
ADDRLP4 0
INDIRP4
CNSTI4 312
ADDP4
ADDRLP4 4
INDIRB
ASGNB 12
line 1022
;1021:
;1022:	ex->color[0] = ex->color[1] = ex->color[2] = 1.0;
ADDRLP4 56
CNSTF4 1065353216
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 132
ADDP4
ADDRLP4 56
INDIRF4
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 128
ADDP4
ADDRLP4 56
INDIRF4
ASGNF4
ADDRLP4 0
INDIRP4
CNSTI4 124
ADDP4
ADDRLP4 56
INDIRF4
ASGNF4
line 1024
;1023:
;1024:	return ex;
ADDRLP4 0
INDIRP4
RETP4
LABELV $499
endproc CG_MakeExplosion 88 8
lit
align 4
LABELV $519
byte 4 0
byte 4 0
byte 4 0
export CG_SurfaceExplosion
code
proc CG_SurfaceExplosion 164 36
line 1041
;1025:}
;1026:
;1027:
;1028:/*
;1029:-------------------------
;1030:CG_SurfaceExplosion
;1031:
;1032:Adds an explosion to a surface
;1033:-------------------------
;1034:*/
;1035:
;1036:#define NUM_SPARKS		12
;1037:#define NUM_PUFFS		1
;1038:#define NUM_EXPLOSIONS	4
;1039:
;1040:void CG_SurfaceExplosion( vec3_t origin, vec3_t normal, float radius, float shake_speed, qboolean smoke )
;1041:{
line 1045
;1042:	localEntity_t	*le;
;1043:	//FXTrail			*particle;
;1044:	vec3_t			direction, new_org;
;1045:	vec3_t			velocity		= { 0, 0, 0 };
ADDRLP4 16
ADDRGP4 $519
INDIRB
ASGNB 12
line 1051
;1046:	vec3_t			temp_org, temp_vel;
;1047:	float			scale, dscale;
;1048:	int				i, numSparks;
;1049:
;1050:	//Sparks
;1051:	numSparks = 16 + (random() * 16.0f);
ADDRLP4 80
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 72
CNSTF4 1098907648
ADDRLP4 80
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
MULF4
CNSTF4 1098907648
ADDF4
CVFI4 4
ASGNI4
line 1053
;1052:	
;1053:	for ( i = 0; i < numSparks; i++ )
ADDRLP4 12
CNSTI4 0
ASGNI4
ADDRGP4 $523
JUMPV
LABELV $520
line 1054
;1054:	{	
line 1055
;1055:		scale = 0.25f + (random() * 2.0f);
ADDRLP4 84
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 52
CNSTF4 1073741824
ADDRLP4 84
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
MULF4
CNSTF4 1048576000
ADDF4
ASGNF4
line 1056
;1056:		dscale = -scale*0.5;
ADDRLP4 76
CNSTF4 1056964608
ADDRLP4 52
INDIRF4
NEGF4
MULF4
ASGNF4
line 1075
;1057:
;1058:/*		particle = FX_AddTrail( origin,
;1059:								NULL,
;1060:								NULL,
;1061:								32.0f,
;1062:								-64.0f,
;1063:								scale,
;1064:								-scale,
;1065:								1.0f,
;1066:								0.0f,
;1067:								0.25f,
;1068:								4000.0f,
;1069:								cgs.media.sparkShader,
;1070:								rand() & FXF_BOUNCE);
;1071:		if ( particle == NULL )
;1072:			return;
;1073:
;1074:		FXE_Spray( normal, 500, 150, 1.0f, 768 + (rand() & 255), (FXPrimitive *) particle );*/
;1075:	}
LABELV $521
line 1053
ADDRLP4 12
ADDRLP4 12
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $523
ADDRLP4 12
INDIRI4
ADDRLP4 72
INDIRI4
LTI4 $520
line 1079
;1076:
;1077:	//Smoke
;1078:	//Move this out a little from the impact surface
;1079:	VectorMA( origin, 4, normal, new_org );
ADDRLP4 84
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 88
CNSTF4 1082130432
ASGNF4
ADDRLP4 92
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 0
ADDRLP4 84
INDIRP4
INDIRF4
ADDRLP4 88
INDIRF4
ADDRLP4 92
INDIRP4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 96
CNSTI4 4
ASGNI4
ADDRLP4 0+4
ADDRLP4 84
INDIRP4
ADDRLP4 96
INDIRI4
ADDP4
INDIRF4
ADDRLP4 88
INDIRF4
ADDRLP4 92
INDIRP4
ADDRLP4 96
INDIRI4
ADDP4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 100
CNSTI4 8
ASGNI4
ADDRLP4 0+8
ADDRFP4 0
INDIRP4
ADDRLP4 100
INDIRI4
ADDP4
INDIRF4
CNSTF4 1082130432
ADDRFP4 4
INDIRP4
ADDRLP4 100
INDIRI4
ADDP4
INDIRF4
MULF4
ADDF4
ASGNF4
line 1080
;1080:	VectorSet( velocity, 0.0f, 0.0f, 16.0f );
ADDRLP4 104
CNSTF4 0
ASGNF4
ADDRLP4 16
ADDRLP4 104
INDIRF4
ASGNF4
ADDRLP4 16+4
ADDRLP4 104
INDIRF4
ASGNF4
ADDRLP4 16+8
CNSTF4 1098907648
ASGNF4
line 1082
;1081:
;1082:	for ( i = 0; i < 4; i++ )
ADDRLP4 12
CNSTI4 0
ASGNI4
LABELV $528
line 1083
;1083:	{
line 1084
;1084:		VectorSet( temp_org, new_org[0] + (crandom() * 16.0f), new_org[1] + (crandom() * 16.0f), new_org[2] + (random() * 4.0f) );
ADDRLP4 108
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 28
ADDRLP4 0
INDIRF4
CNSTF4 1098907648
CNSTF4 1073741824
ADDRLP4 108
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ADDF4
ASGNF4
ADDRLP4 112
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 28+4
ADDRLP4 0+4
INDIRF4
CNSTF4 1098907648
CNSTF4 1073741824
ADDRLP4 112
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ADDF4
ASGNF4
ADDRLP4 116
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 28+8
ADDRLP4 0+8
INDIRF4
CNSTF4 1082130432
ADDRLP4 116
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
MULF4
ADDF4
ASGNF4
line 1085
;1085:		VectorSet( temp_vel, velocity[0] + (crandom() * 8.0f), velocity[1] + (crandom() * 8.0f), velocity[2] + (crandom() * 8.0f) );
ADDRLP4 120
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 40
ADDRLP4 16
INDIRF4
CNSTF4 1090519040
CNSTF4 1073741824
ADDRLP4 120
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ADDF4
ASGNF4
ADDRLP4 124
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 40+4
ADDRLP4 16+4
INDIRF4
CNSTF4 1090519040
CNSTF4 1073741824
ADDRLP4 124
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ADDF4
ASGNF4
ADDRLP4 128
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 40+8
ADDRLP4 16+8
INDIRF4
CNSTF4 1090519040
CNSTF4 1073741824
ADDRLP4 128
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ADDF4
ASGNF4
line 1098
;1086:
;1087:/*		FX_AddSprite(	temp_org,
;1088:						temp_vel, 
;1089:						NULL, 
;1090:						64.0f + (random() * 32.0f), 
;1091:						16.0f, 
;1092:						1.0f, 
;1093:						0.0f,
;1094:						20.0f + (crandom() * 90.0f),
;1095:						0.5f,
;1096:						1500.0f, 
;1097:						cgs.media.smokeShader, FXF_USE_ALPHA_CHAN );*/
;1098:	}
LABELV $529
line 1082
ADDRLP4 12
ADDRLP4 12
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 12
INDIRI4
CNSTI4 4
LTI4 $528
line 1103
;1099:
;1100:	//Core of the explosion
;1101:
;1102:	//Orient the explosions to face the camera
;1103:	VectorSubtract( cg.refdef.vieworg, origin, direction );
ADDRLP4 108
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 60
ADDRGP4 cg+3616+24
INDIRF4
ADDRLP4 108
INDIRP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 60+4
ADDRGP4 cg+3616+24+4
INDIRF4
ADDRLP4 108
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
SUBF4
ASGNF4
ADDRLP4 60+8
ADDRGP4 cg+3616+24+8
INDIRF4
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
SUBF4
ASGNF4
line 1104
;1104:	VectorNormalize( direction );
ADDRLP4 60
ARGP4
ADDRGP4 VectorNormalize
CALLF4
pop
line 1107
;1105:
;1106:	//Tag the last one with a light
;1107:	le = CG_MakeExplosion( origin, direction, cgs.media.explosionModel, 6, cgs.media.surfaceExplosionShader, 500, qfalse, radius * 0.02f + (random() * 0.3f), 0);
ADDRLP4 112
ADDRGP4 rand
CALLI4
ASGNI4
ADDRFP4 0
INDIRP4
ARGP4
ADDRLP4 60
ARGP4
ADDRGP4 cgs+71064+552
INDIRI4
ARGI4
CNSTI4 6
ARGI4
ADDRGP4 cgs+71064+556
INDIRI4
ARGI4
CNSTI4 500
ARGI4
ADDRLP4 116
CNSTI4 0
ASGNI4
ADDRLP4 116
INDIRI4
ARGI4
CNSTF4 1017370378
ADDRFP4 8
INDIRF4
MULF4
CNSTF4 1050253722
ADDRLP4 112
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
MULF4
ADDF4
ARGF4
ADDRLP4 116
INDIRI4
ARGI4
ADDRLP4 120
ADDRGP4 CG_MakeExplosion
CALLP4
ASGNP4
ADDRLP4 56
ADDRLP4 120
INDIRP4
ASGNP4
line 1108
;1108:	le->light = 150;
ADDRLP4 56
INDIRP4
CNSTI4 144
ADDP4
CNSTF4 1125515264
ASGNF4
line 1109
;1109:	VectorSet( le->lightColor, 0.9f, 0.8f, 0.5f );
ADDRLP4 56
INDIRP4
CNSTI4 148
ADDP4
CNSTF4 1063675494
ASGNF4
ADDRLP4 56
INDIRP4
CNSTI4 152
ADDP4
CNSTF4 1061997773
ASGNF4
ADDRLP4 56
INDIRP4
CNSTI4 156
ADDP4
CNSTF4 1056964608
ASGNF4
line 1111
;1110:
;1111:	for ( i = 0; i < NUM_EXPLOSIONS-1; i ++)
ADDRLP4 12
CNSTI4 0
ASGNI4
LABELV $554
line 1112
;1112:	{
line 1113
;1113:		VectorSet( new_org, (origin[0] + (16 + (crandom() * 8))*crandom()), (origin[1] + (16 + (crandom() * 8))*crandom()), (origin[2] + (16 + (crandom() * 8))*crandom()) );
ADDRLP4 124
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 128
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
ADDRFP4 0
INDIRP4
INDIRF4
CNSTF4 1090519040
CNSTF4 1073741824
ADDRLP4 124
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
CNSTF4 1098907648
ADDF4
CNSTF4 1073741824
ADDRLP4 128
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ADDF4
ASGNF4
ADDRLP4 132
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 136
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0+4
ADDRFP4 0
INDIRP4
CNSTI4 4
ADDP4
INDIRF4
CNSTF4 1090519040
CNSTF4 1073741824
ADDRLP4 132
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
CNSTF4 1098907648
ADDF4
CNSTF4 1073741824
ADDRLP4 136
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ADDF4
ASGNF4
ADDRLP4 140
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 144
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0+8
ADDRFP4 0
INDIRP4
CNSTI4 8
ADDP4
INDIRF4
CNSTF4 1090519040
CNSTF4 1073741824
ADDRLP4 140
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
CNSTF4 1098907648
ADDF4
CNSTF4 1073741824
ADDRLP4 144
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ADDF4
ASGNF4
line 1114
;1114:		le = CG_MakeExplosion( new_org, direction, cgs.media.explosionModel, 6, cgs.media.surfaceExplosionShader, 300 + (rand() & 99), qfalse, radius * 0.05f + (crandom() *0.3f), 0);
ADDRLP4 148
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 152
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
ARGP4
ADDRLP4 60
ARGP4
ADDRGP4 cgs+71064+552
INDIRI4
ARGI4
CNSTI4 6
ARGI4
ADDRGP4 cgs+71064+556
INDIRI4
ARGI4
ADDRLP4 148
INDIRI4
CNSTI4 99
BANDI4
CNSTI4 300
ADDI4
ARGI4
ADDRLP4 156
CNSTI4 0
ASGNI4
ADDRLP4 156
INDIRI4
ARGI4
CNSTF4 1028443341
ADDRFP4 8
INDIRF4
MULF4
CNSTF4 1050253722
CNSTF4 1073741824
ADDRLP4 152
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
CNSTF4 1056964608
SUBF4
MULF4
MULF4
ADDF4
ARGF4
ADDRLP4 156
INDIRI4
ARGI4
ADDRLP4 160
ADDRGP4 CG_MakeExplosion
CALLP4
ASGNP4
ADDRLP4 56
ADDRLP4 160
INDIRP4
ASGNP4
line 1115
;1115:	}
LABELV $555
line 1111
ADDRLP4 12
ADDRLP4 12
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
ADDRLP4 12
INDIRI4
CNSTI4 3
LTI4 $554
line 1118
;1116:
;1117:	//Shake the camera
;1118:	CG_ExplosionEffects( origin, shake_speed, 350 );
ADDRFP4 0
INDIRP4
ARGP4
ADDRFP4 12
INDIRF4
ARGF4
CNSTI4 350
ARGI4
ADDRGP4 CG_ExplosionEffects
CALLV
pop
line 1123
;1119:
;1120:	// The level designers wanted to be able to turn the smoke spawners off.  The rationale is that they
;1121:	//	want to blow up catwalks and such that fall down...when that happens, it shouldn't really leave a mark
;1122:	//	and a smoke spewer at the explosion point...
;1123:	if ( smoke )
ADDRFP4 16
INDIRI4
CNSTI4 0
EQI4 $564
line 1124
;1124:	{
line 1125
;1125:		VectorMA( origin, -8, normal, temp_org );
ADDRLP4 124
ADDRFP4 0
INDIRP4
ASGNP4
ADDRLP4 128
CNSTF4 3238002688
ASGNF4
ADDRLP4 132
ADDRFP4 4
INDIRP4
ASGNP4
ADDRLP4 28
ADDRLP4 124
INDIRP4
INDIRF4
ADDRLP4 128
INDIRF4
ADDRLP4 132
INDIRP4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 136
CNSTI4 4
ASGNI4
ADDRLP4 28+4
ADDRLP4 124
INDIRP4
ADDRLP4 136
INDIRI4
ADDP4
INDIRF4
ADDRLP4 128
INDIRF4
ADDRLP4 132
INDIRP4
ADDRLP4 136
INDIRI4
ADDP4
INDIRF4
MULF4
ADDF4
ASGNF4
ADDRLP4 140
CNSTI4 8
ASGNI4
ADDRLP4 28+8
ADDRFP4 0
INDIRP4
ADDRLP4 140
INDIRI4
ADDP4
INDIRF4
CNSTF4 3238002688
ADDRFP4 4
INDIRP4
ADDRLP4 140
INDIRI4
ADDP4
INDIRF4
MULF4
ADDF4
ASGNF4
line 1131
;1126://		FX_AddSpawner( temp_org, normal, NULL, NULL, 100, random()*25.0f, 5000.0f, (void *) CG_SmokeSpawn );
;1127:
;1128:		//Impact mark
;1129:		//FIXME: Replace mark
;1130:		//CG_ImpactMark( cgs.media.burnMarkShader, origin, normal, random()*360, 1,1,1,1, qfalse, 8, qfalse );
;1131:	}
LABELV $564
line 1132
;1132:}
LABELV $518
endproc CG_SurfaceExplosion 164 36
export CG_Bleed
proc CG_Bleed 20 0
line 1141
;1133:
;1134:/*
;1135:=================
;1136:CG_Bleed
;1137:
;1138:This is the spurt of blood when a character gets hit
;1139:=================
;1140:*/
;1141:void CG_Bleed( vec3_t origin, int entityNum ) {
line 1144
;1142:	localEntity_t	*ex;
;1143:
;1144:	if ( !cg_blood.integer ) {
ADDRGP4 cg_blood+12
INDIRI4
CNSTI4 0
NEI4 $569
line 1145
;1145:		return;
ADDRGP4 $568
JUMPV
LABELV $569
line 1148
;1146:	}
;1147:
;1148:	ex = CG_AllocLocalEntity();
ADDRLP4 4
ADDRGP4 CG_AllocLocalEntity
CALLP4
ASGNP4
ADDRLP4 0
ADDRLP4 4
INDIRP4
ASGNP4
line 1149
;1149:	ex->leType = LE_EXPLOSION;
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
CNSTI4 1
ASGNI4
line 1151
;1150:
;1151:	ex->startTime = cg.time;
ADDRLP4 0
INDIRP4
CNSTI4 16
ADDP4
ADDRGP4 cg+64
INDIRI4
ASGNI4
line 1152
;1152:	ex->endTime = ex->startTime + 500;
ADDRLP4 0
INDIRP4
CNSTI4 20
ADDP4
ADDRLP4 0
INDIRP4
CNSTI4 16
ADDP4
INDIRI4
CNSTI4 500
ADDI4
ASGNI4
line 1154
;1153:	
;1154:	VectorCopy ( origin, ex->refEntity.origin);
ADDRLP4 0
INDIRP4
CNSTI4 300
ADDP4
ADDRFP4 0
INDIRP4
INDIRB
ASGNB 12
line 1155
;1155:	ex->refEntity.reType = RT_SPRITE;
ADDRLP4 0
INDIRP4
CNSTI4 248
ADDP4
CNSTI4 2
ASGNI4
line 1156
;1156:	ex->refEntity.rotation = rand() % 360;
ADDRLP4 12
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 344
ADDP4
ADDRLP4 12
INDIRI4
CNSTI4 360
MODI4
CVIF4 4
ASGNF4
line 1157
;1157:	ex->refEntity.radius = 24;
ADDRLP4 0
INDIRP4
CNSTI4 340
ADDP4
CNSTF4 1103101952
ASGNF4
line 1159
;1158:
;1159:	ex->refEntity.customShader = 0;//cgs.media.bloodExplosionShader;
ADDRLP4 0
INDIRP4
CNSTI4 324
ADDP4
CNSTI4 0
ASGNI4
line 1162
;1160:
;1161:	// don't show player's own blood in view
;1162:	if ( entityNum == cg.snap->ps.clientNum ) {
ADDRFP4 4
INDIRI4
ADDRGP4 cg+36
INDIRP4
CNSTI4 188
ADDP4
INDIRI4
NEI4 $573
line 1163
;1163:		ex->refEntity.renderfx |= RF_THIRD_PERSON;
ADDRLP4 16
ADDRLP4 0
INDIRP4
CNSTI4 252
ADDP4
ASGNP4
ADDRLP4 16
INDIRP4
ADDRLP4 16
INDIRP4
INDIRI4
CNSTI4 2
BORI4
ASGNI4
line 1164
;1164:	}
LABELV $573
line 1165
;1165:}
LABELV $568
endproc CG_Bleed 20 0
export CG_LaunchGib
proc CG_LaunchGib 20 8
line 1174
;1166:
;1167:
;1168:
;1169:/*
;1170:==================
;1171:CG_LaunchGib
;1172:==================
;1173:*/
;1174:void CG_LaunchGib( vec3_t origin, vec3_t velocity, qhandle_t hModel ) {
line 1178
;1175:	localEntity_t	*le;
;1176:	refEntity_t		*re;
;1177:
;1178:	le = CG_AllocLocalEntity();
ADDRLP4 8
ADDRGP4 CG_AllocLocalEntity
CALLP4
ASGNP4
ADDRLP4 0
ADDRLP4 8
INDIRP4
ASGNP4
line 1179
;1179:	re = &le->refEntity;
ADDRLP4 4
ADDRLP4 0
INDIRP4
CNSTI4 248
ADDP4
ASGNP4
line 1181
;1180:
;1181:	le->leType = LE_FRAGMENT;
ADDRLP4 0
INDIRP4
CNSTI4 8
ADDP4
CNSTI4 4
ASGNI4
line 1182
;1182:	le->startTime = cg.time;
ADDRLP4 0
INDIRP4
CNSTI4 16
ADDP4
ADDRGP4 cg+64
INDIRI4
ASGNI4
line 1183
;1183:	le->endTime = le->startTime + 5000 + random() * 3000;
ADDRLP4 12
ADDRGP4 rand
CALLI4
ASGNI4
ADDRLP4 0
INDIRP4
CNSTI4 20
ADDP4
ADDRLP4 0
INDIRP4
CNSTI4 16
ADDP4
INDIRI4
CNSTI4 5000
ADDI4
CVIF4 4
CNSTF4 1161527296
ADDRLP4 12
INDIRI4
CNSTI4 32767
BANDI4
CVIF4 4
CNSTF4 1191181824
DIVF4
MULF4
ADDF4
CVFI4 4
ASGNI4
line 1185
;1184:
;1185:	VectorCopy( origin, re->origin );
ADDRLP4 4
INDIRP4
CNSTI4 52
ADDP4
ADDRFP4 0
INDIRP4
INDIRB
ASGNB 12
line 1186
;1186:	AxisCopy( axisDefault, re->axis );
ADDRGP4 axisDefault
ARGP4
ADDRLP4 4
INDIRP4
CNSTI4 12
ADDP4
ARGP4
ADDRGP4 AxisCopy
CALLV
pop
line 1187
;1187:	re->hModel = hModel;
ADDRLP4 4
INDIRP4
CNSTI4 8
ADDP4
ADDRFP4 8
INDIRI4
ASGNI4
line 1189
;1188:
;1189:	le->pos.trType = TR_GRAVITY;
ADDRLP4 0
INDIRP4
CNSTI4 32
ADDP4
CNSTI4 5
ASGNI4
line 1190
;1190:	VectorCopy( origin, le->pos.trBase );
ADDRLP4 0
INDIRP4
CNSTI4 44
ADDP4
ADDRFP4 0
INDIRP4
INDIRB
ASGNB 12
line 1191
;1191:	VectorCopy( velocity, le->pos.trDelta );
ADDRLP4 0
INDIRP4
CNSTI4 56
ADDP4
ADDRFP4 4
INDIRP4
INDIRB
ASGNB 12
line 1192
;1192:	le->pos.trTime = cg.time;
ADDRLP4 0
INDIRP4
CNSTI4 36
ADDP4
ADDRGP4 cg+64
INDIRI4
ASGNI4
line 1194
;1193:
;1194:	le->bounceFactor = 0.6f;
ADDRLP4 0
INDIRP4
CNSTI4 104
ADDP4
CNSTF4 1058642330
ASGNF4
line 1196
;1195:
;1196:	le->leBounceSoundType = LEBS_BLOOD;
ADDRLP4 0
INDIRP4
CNSTI4 164
ADDP4
CNSTI4 1
ASGNI4
line 1197
;1197:	le->leMarkType = LEMT_BLOOD;
ADDRLP4 0
INDIRP4
CNSTI4 160
ADDP4
CNSTI4 2
ASGNI4
line 1198
;1198:}
LABELV $576
endproc CG_LaunchGib 20 8
bss
export dbModels_Rocks
align 4
LABELV dbModels_Rocks
skip 16
export dbModels_Chunks
align 4
LABELV dbModels_Chunks
skip 12
export dbModels_Wood
align 4
LABELV dbModels_Wood
skip 32
export dbModels_Glass
align 4
LABELV dbModels_Glass
skip 32
align 4
LABELV offZ
skip 1600
align 4
LABELV offX
skip 1600
import g2WeaponInstances
import CG_CheckPlayerG2Weapons
import CG_CopyG2WeaponInstance
import CG_ShutDownG2Weapons
import CG_InitG2Weapons
import CG_CreateBBRefEnts
import CG_SetGhoul2Info
import CG_Init_CGents
import CG_Init_CG
import trap_G2API_SetNewOrigin
import trap_G2API_SetSurfaceOnOff
import trap_G2API_SetRootSurface
import trap_G2API_SetBoneAnim
import trap_G2API_GetGLAName
import trap_G2API_SetBoneAngles
import trap_G2API_CleanGhoul2Models
import trap_G2API_SetBoltInfo
import trap_G2API_AddBolt
import trap_G2API_RemoveGhoul2Model
import trap_G2API_HasGhoul2ModelOnIndex
import trap_G2API_DuplicateGhoul2Instance
import trap_G2API_CopySpecificGhoul2Model
import trap_G2API_CopyGhoul2Instance
import trap_G2API_GiveMeVectorFromMatrix
import trap_G2API_InitGhoul2Model
import trap_G2API_GetBoltMatrix_NoRecNoRot
import trap_G2API_GetBoltMatrix_NoReconstruct
import trap_G2API_GetBoltMatrix
import trap_G2_HaveWeGhoul2Models
import trap_G2_SetGhoul2ModelIndexes
import trap_G2_ListModelBones
import trap_G2_ListModelSurfaces
import trap_G2API_CollisionDetect
import FX_ForceDrained
import FX_TieLaserAltFireThink
import FX_TieLaserWeaponHitPlayer
import FX_TieLaserWeaponHitWall
import FX_TieLaserProjectileThink
import FX_BlasterWeaponHitPlayer
import FX_BlasterWeaponHitWall
import FX_BlasterAltFireThink
import FX_BlasterProjectileThink
import FX_BryarAltHitPlayer
import FX_BryarHitPlayer
import FX_BryarAltHitWall
import FX_BryarHitWall
import CG_Spark
import FX_TurretHitPlayer
import FX_TurretHitWall
import FX_TurretProjectileThink
import CG_NewParticleArea
import initparticles
import CG_GetStripEdString
import CG_ParticleExplosion
import CG_ParticleMisc
import CG_ParticleDust
import CG_ParticleSparks
import CG_ParticleBulletDebris
import CG_ParticleSnowFlurry
import CG_AddParticleShrapnel
import CG_ParticleSmoke
import CG_ParticleSnow
import CG_AddParticles
import CG_ClearParticles
import trap_ROFF_Purge_Ent
import trap_ROFF_Play
import trap_ROFF_Cache
import trap_ROFF_UpdateEntities
import trap_ROFF_Clean
import trap_CG_RegisterSharedMemory
import trap_SP_GetStringTextString
import trap_SP_Print
import trap_FX_AddSprite
import trap_FX_AddPrimitive
import trap_FX_AddBezier
import trap_FX_AddPoly
import trap_FX_AdjustTime
import trap_FX_FreeSystem
import trap_FX_InitSystem
import trap_FX_AddScheduledEffects
import trap_FX_PlayBoltedEffectID
import trap_FX_PlayEntityEffectID
import trap_FX_PlayEffectID
import trap_FX_PlaySimpleEffectID
import trap_FX_PlayEntityEffect
import trap_FX_PlayEffect
import trap_FX_PlaySimpleEffect
import trap_FX_RegisterEffect
import trap_R_inPVS
import trap_GetEntityToken
import trap_getCameraInfo
import trap_startCamera
import trap_loadCamera
import trap_SnapVector
import trap_CIN_SetExtents
import trap_CIN_DrawCinematic
import trap_CIN_RunCinematic
import trap_CIN_StopCinematic
import trap_CIN_PlayCinematic
import BG_CycleForce
import BG_ProperForceIndex
import BG_CycleInven
import trap_Key_GetKey
import trap_Key_SetCatcher
import trap_Key_GetCatcher
import trap_Key_IsDown
import trap_MemoryRemaining
import testPrintFloat
import testPrintInt
import trap_OpenUIMenu
import trap_SetClientTurnExtent
import trap_SetClientForceAngle
import trap_SetUserCmdValue
import trap_GetUserCmd
import trap_GetCurrentCmdNumber
import trap_GetServerCommand
import trap_GetSnapshot
import trap_GetCurrentSnapshotNumber
import trap_GetGameState
import trap_GetGlconfig
import trap_FX_AddLine
import trap_R_GetBModelVerts
import trap_R_SetLightStyle
import trap_R_GetLightStyle
import trap_R_RemapShader
import trap_R_DrawRotatePic2
import trap_R_DrawRotatePic
import trap_R_LerpTag
import trap_R_ModelBounds
import trap_R_DrawStretchPic
import trap_R_SetColor
import trap_R_RenderScene
import trap_R_LightForPoint
import trap_R_AddLightToScene
import trap_R_AddPolysToScene
import trap_R_AddPolyToScene
import trap_R_AddRefEntityToScene
import trap_R_ClearScene
import trap_AnyLanguage_ReadCharFromString
import trap_Language_UsesSpaces
import trap_Language_IsAsian
import trap_R_Font_DrawString
import trap_R_Font_HeightPixels
import trap_R_Font_StrLenChars
import trap_R_Font_StrLenPixels
import trap_R_RegisterFont
import trap_R_RegisterShaderNoMip
import trap_R_RegisterShader
import trap_R_RegisterSkin
import trap_R_RegisterModel
import trap_R_LoadWorldMap
import trap_S_StopBackgroundTrack
import trap_S_StartBackgroundTrack
import trap_S_RegisterSound
import trap_S_Respatialize
import trap_S_UpdateEntityPosition
import trap_S_AddRealLoopingSound
import trap_S_AddLoopingSound
import trap_S_ClearLoopingSounds
import trap_S_StartLocalSound
import trap_S_StopLoopingSound
import trap_S_StartSound
import trap_S_MuteSound
import trap_CM_MarkFragments
import trap_CM_TransformedBoxTrace
import trap_CM_BoxTrace
import trap_CM_TransformedPointContents
import trap_CM_PointContents
import trap_CM_TempBoxModel
import trap_CM_InlineModel
import trap_CM_NumInlineModels
import trap_CM_LoadMap
import trap_UpdateScreen
import trap_SendClientCommand
import trap_AddCommand
import trap_SendConsoleCommand
import trap_FS_FCloseFile
import trap_FS_Write
import trap_FS_Read
import trap_FS_FOpenFile
import trap_Args
import trap_Argv
import trap_Argc
import trap_Cvar_VariableStringBuffer
import trap_Cvar_Set
import trap_Cvar_Update
import trap_Cvar_Register
import trap_Milliseconds
import trap_Error
import trap_Print
import CG_SagaObjectiveCompleted
import CG_SagaRoundOver
import CG_InitSagaMode
import CG_CheckChangedPredictableEvents
import CG_TransitionPlayerState
import CG_Respawn
import CG_IsMindTricked
import CG_PlayBufferedVoiceChats
import CG_VoiceChatLocal
import CG_ShaderStateChanged
import CG_LoadVoiceChats
import CG_SetConfigValues
import CG_ParseServerinfo
import CG_ExecuteNewServerCommands
import CG_InitConsoleCommands
import CG_ConsoleCommand
import CG_DrawOldTourneyScoreboard
import CG_DrawOldScoreboard
import CG_DrawInformation
import CG_LoadingClient
import CG_LoadingItem
import CG_LoadingString
import CG_ProcessSnapshots
import CG_AddLocalEntities
import CG_AllocLocalEntity
import CG_InitLocalEntities
import CG_ImpactMark
import CG_AddMarks
import CG_InitMarkPolys
import CG_OutOfAmmoChange
import CG_DrawIconBackground
import CG_DrawWeaponSelect
import CG_AddPlayerWeapon
import CG_AddViewWeapon
import CG_MissileHitPlayer
import CG_MissileHitWall
import CG_FireWeapon
import CG_RegisterItemVisuals
import CG_RegisterWeapon
import CG_Weapon_f
import CG_PrevWeapon_f
import CG_NextWeapon_f
import CG_GetClientWeaponMuzzleBoltPoint
import TurretClientRun
import ScaleModelAxis
import CG_PositionRotatedEntityOnTag
import CG_PositionEntityOnTag
import CG_AdjustPositionForMover
import CG_Beam
import CG_ManualEntityRender
import CG_AddPacketEntities
import CG_SetEntitySoundPosition
import CG_ReattachLimb
import CG_PainEvent
import CG_EntityEvent
import CG_PlaceString
import CG_CheckEvents
import CG_LoadDeferredPlayers
import CG_PredictPlayerState
import CG_Trace
import CG_PointContents
import CG_BuildSolidList
import CG_PlayerShieldHit
import CG_CustomSound
import CG_NewClientInfo
import CG_AddRefEntityWithPowerups
import CG_ResetPlayerEntity
import CG_Player
import CG_StatusHandle
import CG_OtherTeamHasFlag
import CG_YourTeamHasFlag
import CG_GameTypeString
import CG_CheckOrderPending
import CG_Text_PaintChar
import CG_Draw3DModel
import CG_GetKillerText
import CG_GetGameStatusText
import CG_GetTeamColor
import CG_InitTeamChat
import CG_SetPrintString
import CG_ShowResponseHead
import CG_DeferMenuScript
import CG_RunMenuScript
import CG_OwnerDrawVisible
import CG_GetValue
import CG_SelectNextPlayer
import CG_SelectPrevPlayer
import CG_Text_Height
import CG_Text_Width
import CG_Text_Paint
import CG_OwnerDraw
import CG_DrawTeamBackground
import CG_DrawFlagModel
import CG_DrawActive
import CG_DrawHead
import CG_CenterPrint
import CG_AddLagometerSnapshotInfo
import CG_AddLagometerFrameInfo
import teamChat2
import teamChat1
import systemChat
import drawTeamOverlayModificationCount
import numSortedTeamPlayers
import sortedTeamPlayers
import CG_DrawTopBottom
import CG_DrawSides
import CG_DrawRect
import UI_DrawScaledProportionalString
import UI_DrawProportionalString
import CG_GetColorForHealth
import CG_ColorForHealth
import CG_TileClear
import CG_TeamColor
import CG_FadeColor
import CG_DrawStrlen
import CG_DrawSmallStringColor
import CG_DrawSmallString
import CG_DrawBigStringColor
import CG_DrawBigString
import CG_DrawStringExt
import CG_DrawNumField
import CG_DrawString
import CG_DrawRotatePic2
import CG_DrawRotatePic
import CG_DrawPic
import CG_FillRect
import CG_TestModelAnimate_f
import CG_TestModelSetAnglespost_f
import CG_TestModelSetAnglespre_f
import CG_ListModelBones_f
import CG_ListModelSurfaces_f
import CG_TestModelSurfaceOnOff_f
import CG_TestG2Model_f
import CG_DrawActiveFrame
import CG_AddBufferedSound
import CG_ZoomUp_f
import CG_ZoomDown_f
import CG_TestModelPrevSkin_f
import CG_TestModelNextSkin_f
import CG_TestModelPrevFrame_f
import CG_TestModelNextFrame_f
import CG_TestGun_f
import CG_TestModel_f
import CG_PrevForcePower_f
import CG_NextForcePower_f
import CG_PrevInventory_f
import CG_NextInventory_f
import CG_BuildSpectatorString
import CG_SetScoreSelection
import CG_RankRunFrame
import CG_EventHandling
import CG_MouseEvent
import CG_KeyEvent
import CG_LoadMenus
import CG_LastAttacker
import CG_CrosshairPlayer
import CG_UpdateCvars
import CG_StartMusic
import CG_Error
import CG_Printf
import CG_Argv
import CG_ConfigString
import cg_followCamTransition
import cg_followCam
import cg_roll
import cg_throttle
import cg_debugBB
import ui_myteam
import cg_recordSPDemoName
import cg_recordSPDemo
import cg_singlePlayerActive
import cg_enableBreath
import cg_enableDust
import cg_singlePlayer
import cg_currentSelectedPlayerName
import cg_currentSelectedPlayer
import cg_blueTeamName
import cg_redTeamName
import cg_trueLightning
import cg_noProjectileTrail
import cg_noTaunt
import cg_bigFont
import cg_smallFont
import cg_cameraMode
import cg_timescale
import cg_timescaleFadeSpeed
import cg_timescaleFadeEnd
import cg_cameraOrbitDelay
import cg_cameraOrbit
import pmove_msec
import pmove_fixed
import cg_smoothClients
import cg_hudFiles
import cg_scorePlum
import cg_noVoiceText
import cg_noVoiceChats
import cg_teamChatsOnly
import cg_drawFriend
import cg_deferPlayers
import cg_predictItems
import cg_blood
import cg_paused
import cg_buildScript
import cg_forceModel
import cg_stats
import cg_teamChatHeight
import cg_teamChatTime
import cg_synchronousClients
import cg_drawEnemyInfo
import cg_lagometer
import cg_stereoSeparation
import cg_thirdPersonHorzOffset
import cg_thirdPersonAlpha
import cg_thirdPersonTargetDamp
import cg_thirdPersonCameraDamp
import cg_thirdPersonVertOffset
import cg_thirdPersonPitchOffset
import cg_thirdPersonAngle
import cg_thirdPersonRange
import cg_thirdPerson
import cg_dismember
import cg_animBlend
import cg_auraShell
import cg_speedTrail
import cg_duelHeadAngles
import cg_saberTrail
import cg_saberContact
import cg_saberDynamicMarkTime
import cg_saberDynamicMarks
import cg_fpls
import cg_saberModelTraceEffect
import cg_oldPainSounds
import cg_swingAngles
import cg_zoomFov
import cg_fov
import cg_simpleItems
import cg_ignore
import cg_autoswitch
import cg_tracerLength
import cg_tracerWidth
import cg_tracerChance
import cg_viewsize
import cg_drawGun
import cg_gun_z
import cg_gun_y
import cg_gun_x
import cg_gun_frame
import cg_addMarks
import cg_footsteps
import cg_showmiss
import cg_noPlayerAnims
import cg_nopredict
import cg_errorDecay
import cg_debugEvents
import cg_debugPosition
import cg_debugAnim
import cg_animSpeed
import cg_draw2D
import cg_drawStatus
import cg_crosshairHealth
import cg_crosshairSize
import cg_crosshairY
import cg_crosshairX
import cg_teamOverlayUserinfo
import cg_drawTeamOverlay
import cg_drawRewards
import cg_dynamicCrosshair
import cg_drawScores
import cg_drawCrosshairNames
import cg_drawCrosshair
import cg_drawAmmoWarning
import cg_drawIcons
import cg_draw3dIcons
import cg_drawSnapshot
import cg_drawFPS
import cg_drawTimer
import cg_shadows
import cg_bobroll
import cg_bobpitch
import cg_bobup
import cg_runroll
import cg_runpitch
import cg_centertime
import cg_vehicleTemplates
import cg_vehicles
import VehicleInfo_GetNameForMovementType
import VehicleInfo_GetBitForMovementType
import VehicleInfo_GetNameForWeapon
import VehicleInfo_GetIndexForWeapon
import VehicleInfo_GetBitForWeapon
import VehicleInfo_GetBitForVehicleType
import Vehicle_CopyVehicle
import Vehicle_InitVehicle
import cg_markPolys
import cg_items
import cg_weapons
import cg_entities
import cg
import cgs
import CGCam_SetMusicMult
import CGCam_Shake
import cgScreenEffects
import ammoTicPos
import forceTicPos
import forcePowerDarkLight
import WeaponAttackAnim
import WeaponReadyAnim
import BG_OutOfMemory
import BG_StringAlloc
import BG_TempFree
import BG_TempAlloc
import BG_AllocUnaligned
import BG_Alloc
import BG_CanUseFPNow
import BG_HasYsalamiri
import BG_GetItemIndexByTag
import BG_ParseAnimationFile
import BG_PlayerTouchesItem
import BG_PlayerStateToEntityStateExtraPolate
import BG_PlayerStateToEntityState
import BG_TouchJumpPad
import BG_AddPredictableEventToPlayerstate
import BG_EvaluateTrajectoryDelta
import BG_EvaluateTrajectory
import BG_ForcePowerDrain
import BG_SaberStartTransAnim
import BG_InDeathAnim
import BG_InRoll
import BG_KnockawayForParry
import BG_BrokenParryForParry
import BG_BrokenParryForAttack
import BG_SaberInSpecialAttack
import BG_SpinningSaberAnim
import BG_FlippingAnim
import BG_SaberInIdle
import BG_SaberInSpecial
import BG_SaberInAttack
import BG_DirectFlippingAnim
import BG_InSaberStandAnim
import BG_InSpecialJump
import BG_LegalizedForcePowers
import saberMoveData
import BG_CanItemBeGrabbed
import BG_FindItemForHoldable
import BG_FindItemForPowerup
import BG_FindItemForWeapon
import BG_FindItem
import vectoyaw
import bg_numItems
import bg_itemlist
import PM_CalculateRelativeViewAngles
import Pmove
import PM_QuaternionViewAngles
import PM_UpdateViewAngles
import pm
import bgForcePowerCost
import forceMasteryPoints
import forceMasteryLevels
import bgGlobalAnimations
import BGPAFtextLoaded
import forcePowerSorted
import WP_MuzzlePoint
import ammoData
import weaponData
import GetStringForID
import GetIDForString
import Q_irand
import irand
import flrand
import Rand_Init
import Com_Printf
import Com_Error
import Info_NextPair
import Info_Validate
import Info_SetValueForKey_Big
import Info_SetValueForKey
import Info_RemoveKey_big
import Info_RemoveKey
import Info_ValueForKey
import va
import Q_CleanStr
import Q_PrintStrlen
import Q_strcat
import Q_strncpyz
import Q_strrchr
import Q_strupr
import Q_strlwr
import Q_stricmpn
import Q_strncmp
import Q_stricmp
import Q_isalpha
import Q_isupper
import Q_islower
import Q_isprint
import Com_sprintf
import Parse3DMatrix
import Parse2DMatrix
import Parse1DMatrix
import SkipRestOfLine
import SkipBracedSection
import COM_MatchToken
import COM_ParseVec4
import COM_ParseFloat
import COM_ParseInt
import COM_ParseString
import COM_ParseWarning
import COM_ParseError
import COM_Compress
import COM_ParseExt
import COM_Parse
import SkipWhitespace
import COM_GetCurrentParseLine
import COM_BeginParseSession
import COM_DefaultExtension
import COM_StripExtension
import COM_SkipPath
import Com_Clamp
import MatrixToEuler
import QuatToAngles
import QuatMul
import AnglesToQuat
import AxisToQuaternion
import QuaternionToAxis
import QuaternionToEuler
import QuatToAxis
import QuaternionMultiply
import QuaternionNormalize
import QuaternionMagnitude
import QuaternionFromString
import AnglesToTieFloats
import AnglesFromTieFloats
import QuaternionToTieFloats
import QuaternionFromTieFloats
import QuaternionCopy
import PerpendicularVector
import AngleVectors
import RotationMatrixAroundDir
import MatrixMultiply
import MakeNormalVectors
import RotateAroundDirection
import RotatePointAroundVector
import ProjectPointOnPlane
import PlaneFromPoints
import AngleDelta
import AngleNormalize180
import AngleNormalize360
import AnglesSubtract
import AngleSubtract
import LerpAngle
import AngleMod
import BoxOnPlaneSide
import SetPlaneSignbits
import AxisCopy
import AxisClear
import AnglesToAxis
import vectoangles
import Q_crandom
import Q_random
import Q_rand
import Q_acos
import Q_log2
import VectorRotate
import Vector4Scale
import VectorNormalize2
import VectorNormalize
import CrossProduct
import VectorInverse
import VectorNormalizeFast
import DistanceSquared
import Distance
import VectorLengthSquared
import VectorLength
import VectorCompare
import AddPointToBounds
import ClearBounds
import RadiusFromBounds
import NormalizeColor
import ColorBytes4
import ColorBytes3
import _VectorMA
import _VectorScale
import _VectorCopy
import _VectorAdd
import _VectorSubtract
import _DotProduct
import ByteToDir
import DirToByte
import powf
import ClampShort
import ClampChar
import Q_rsqrt
import Q_fabs
import axisDefault
import vec3_origin
import g_color_table
import colorDkBlue
import colorLtBlue
import colorDkGrey
import colorMdGrey
import colorLtGrey
import colorWhite
import colorCyan
import colorMagenta
import colorYellow
import colorBlue
import colorGreen
import colorRed
import colorBlack
import colorTable
import bytedirs
import Com_Memcpy
import Com_Memset
import Hunk_Alloc
import forceSpeedLevels
import FloatSwap
import LongSwap
import ShortSwap
import acos
import fabs
import abs
import tan
import atan2
import cos
import sin
import sqrt
import floor
import ceil
import memcpy
import memset
import memmove
import sscanf
import vsprintf
import _atoi
import atoi
import _atof
import atof
import toupper
import tolower
import strncpy
import strstr
import strchr
import strcmp
import strcpy
import strcat
import strlen
import rand
import srand
import qsort
lit
align 1
LABELV $502
byte 1 67
byte 1 71
byte 1 95
byte 1 77
byte 1 97
byte 1 107
byte 1 101
byte 1 69
byte 1 120
byte 1 112
byte 1 108
byte 1 111
byte 1 115
byte 1 105
byte 1 111
byte 1 110
byte 1 58
byte 1 32
byte 1 109
byte 1 115
byte 1 101
byte 1 99
byte 1 32
byte 1 61
byte 1 32
byte 1 37
byte 1 105
byte 1 0
align 1
LABELV $418
byte 1 109
byte 1 111
byte 1 100
byte 1 101
byte 1 108
byte 1 115
byte 1 47
byte 1 99
byte 1 104
byte 1 117
byte 1 110
byte 1 107
byte 1 115
byte 1 47
byte 1 114
byte 1 111
byte 1 99
byte 1 107
byte 1 47
byte 1 114
byte 1 111
byte 1 99
byte 1 107
byte 1 49
byte 1 95
byte 1 52
byte 1 46
byte 1 109
byte 1 100
byte 1 51
byte 1 0
align 1
LABELV $416
byte 1 109
byte 1 111
byte 1 100
byte 1 101
byte 1 108
byte 1 115
byte 1 47
byte 1 99
byte 1 104
byte 1 117
byte 1 110
byte 1 107
byte 1 115
byte 1 47
byte 1 114
byte 1 111
byte 1 99
byte 1 107
byte 1 47
byte 1 114
byte 1 111
byte 1 99
byte 1 107
byte 1 49
byte 1 95
byte 1 51
byte 1 46
byte 1 109
byte 1 100
byte 1 51
byte 1 0
align 1
LABELV $414
byte 1 109
byte 1 111
byte 1 100
byte 1 101
byte 1 108
byte 1 115
byte 1 47
byte 1 99
byte 1 104
byte 1 117
byte 1 110
byte 1 107
byte 1 115
byte 1 47
byte 1 114
byte 1 111
byte 1 99
byte 1 107
byte 1 47
byte 1 114
byte 1 111
byte 1 99
byte 1 107
byte 1 49
byte 1 95
byte 1 50
byte 1 46
byte 1 109
byte 1 100
byte 1 51
byte 1 0
align 1
LABELV $412
byte 1 109
byte 1 111
byte 1 100
byte 1 101
byte 1 108
byte 1 115
byte 1 47
byte 1 99
byte 1 104
byte 1 117
byte 1 110
byte 1 107
byte 1 115
byte 1 47
byte 1 114
byte 1 111
byte 1 99
byte 1 107
byte 1 47
byte 1 114
byte 1 111
byte 1 99
byte 1 107
byte 1 49
byte 1 95
byte 1 49
byte 1 46
byte 1 109
byte 1 100
byte 1 51
byte 1 0
align 1
LABELV $409
byte 1 109
byte 1 111
byte 1 100
byte 1 101
byte 1 108
byte 1 115
byte 1 47
byte 1 99
byte 1 104
byte 1 117
byte 1 110
byte 1 107
byte 1 115
byte 1 47
byte 1 103
byte 1 101
byte 1 110
byte 1 101
byte 1 114
byte 1 105
byte 1 99
byte 1 47
byte 1 99
byte 1 104
byte 1 117
byte 1 110
byte 1 107
byte 1 115
byte 1 95
byte 1 50
byte 1 46
byte 1 109
byte 1 100
byte 1 51
byte 1 0
align 1
LABELV $407
byte 1 109
byte 1 111
byte 1 100
byte 1 101
byte 1 108
byte 1 115
byte 1 47
byte 1 99
byte 1 104
byte 1 117
byte 1 110
byte 1 107
byte 1 115
byte 1 47
byte 1 103
byte 1 101
byte 1 110
byte 1 101
byte 1 114
byte 1 105
byte 1 99
byte 1 47
byte 1 99
byte 1 104
byte 1 117
byte 1 110
byte 1 107
byte 1 115
byte 1 95
byte 1 49
byte 1 46
byte 1 109
byte 1 100
byte 1 51
byte 1 0
align 1
LABELV $404
byte 1 109
byte 1 111
byte 1 100
byte 1 101
byte 1 108
byte 1 115
byte 1 47
byte 1 99
byte 1 104
byte 1 117
byte 1 110
byte 1 107
byte 1 115
byte 1 47
byte 1 99
byte 1 114
byte 1 97
byte 1 116
byte 1 101
byte 1 47
byte 1 99
byte 1 114
byte 1 97
byte 1 116
byte 1 101
byte 1 50
byte 1 95
byte 1 52
byte 1 46
byte 1 109
byte 1 100
byte 1 51
byte 1 0
align 1
LABELV $402
byte 1 109
byte 1 111
byte 1 100
byte 1 101
byte 1 108
byte 1 115
byte 1 47
byte 1 99
byte 1 104
byte 1 117
byte 1 110
byte 1 107
byte 1 115
byte 1 47
byte 1 99
byte 1 114
byte 1 97
byte 1 116
byte 1 101
byte 1 47
byte 1 99
byte 1 114
byte 1 97
byte 1 116
byte 1 101
byte 1 50
byte 1 95
byte 1 51
byte 1 46
byte 1 109
byte 1 100
byte 1 51
byte 1 0
align 1
LABELV $400
byte 1 109
byte 1 111
byte 1 100
byte 1 101
byte 1 108
byte 1 115
byte 1 47
byte 1 99
byte 1 104
byte 1 117
byte 1 110
byte 1 107
byte 1 115
byte 1 47
byte 1 99
byte 1 114
byte 1 97
byte 1 116
byte 1 101
byte 1 47
byte 1 99
byte 1 114
byte 1 97
byte 1 116
byte 1 101
byte 1 50
byte 1 95
byte 1 50
byte 1 46
byte 1 109
byte 1 100
byte 1 51
byte 1 0
align 1
LABELV $398
byte 1 109
byte 1 111
byte 1 100
byte 1 101
byte 1 108
byte 1 115
byte 1 47
byte 1 99
byte 1 104
byte 1 117
byte 1 110
byte 1 107
byte 1 115
byte 1 47
byte 1 99
byte 1 114
byte 1 97
byte 1 116
byte 1 101
byte 1 47
byte 1 99
byte 1 114
byte 1 97
byte 1 116
byte 1 101
byte 1 50
byte 1 95
byte 1 49
byte 1 46
byte 1 109
byte 1 100
byte 1 51
byte 1 0
align 1
LABELV $396
byte 1 109
byte 1 111
byte 1 100
byte 1 101
byte 1 108
byte 1 115
byte 1 47
byte 1 99
byte 1 104
byte 1 117
byte 1 110
byte 1 107
byte 1 115
byte 1 47
byte 1 99
byte 1 114
byte 1 97
byte 1 116
byte 1 101
byte 1 47
byte 1 99
byte 1 114
byte 1 97
byte 1 116
byte 1 101
byte 1 49
byte 1 95
byte 1 52
byte 1 46
byte 1 109
byte 1 100
byte 1 51
byte 1 0
align 1
LABELV $394
byte 1 109
byte 1 111
byte 1 100
byte 1 101
byte 1 108
byte 1 115
byte 1 47
byte 1 99
byte 1 104
byte 1 117
byte 1 110
byte 1 107
byte 1 115
byte 1 47
byte 1 99
byte 1 114
byte 1 97
byte 1 116
byte 1 101
byte 1 47
byte 1 99
byte 1 114
byte 1 97
byte 1 116
byte 1 101
byte 1 49
byte 1 95
byte 1 51
byte 1 46
byte 1 109
byte 1 100
byte 1 51
byte 1 0
align 1
LABELV $392
byte 1 109
byte 1 111
byte 1 100
byte 1 101
byte 1 108
byte 1 115
byte 1 47
byte 1 99
byte 1 104
byte 1 117
byte 1 110
byte 1 107
byte 1 115
byte 1 47
byte 1 99
byte 1 114
byte 1 97
byte 1 116
byte 1 101
byte 1 47
byte 1 99
byte 1 114
byte 1 97
byte 1 116
byte 1 101
byte 1 49
byte 1 95
byte 1 50
byte 1 46
byte 1 109
byte 1 100
byte 1 51
byte 1 0
align 1
LABELV $390
byte 1 109
byte 1 111
byte 1 100
byte 1 101
byte 1 108
byte 1 115
byte 1 47
byte 1 99
byte 1 104
byte 1 117
byte 1 110
byte 1 107
byte 1 115
byte 1 47
byte 1 99
byte 1 114
byte 1 97
byte 1 116
byte 1 101
byte 1 47
byte 1 99
byte 1 114
byte 1 97
byte 1 116
byte 1 101
byte 1 49
byte 1 95
byte 1 49
byte 1 46
byte 1 109
byte 1 100
byte 1 51
byte 1 0
align 1
LABELV $387
byte 1 109
byte 1 111
byte 1 100
byte 1 101
byte 1 108
byte 1 115
byte 1 47
byte 1 99
byte 1 104
byte 1 117
byte 1 110
byte 1 107
byte 1 115
byte 1 47
byte 1 109
byte 1 101
byte 1 116
byte 1 97
byte 1 108
byte 1 47
byte 1 109
byte 1 101
byte 1 116
byte 1 97
byte 1 108
byte 1 50
byte 1 95
byte 1 52
byte 1 46
byte 1 109
byte 1 100
byte 1 51
byte 1 0
align 1
LABELV $385
byte 1 109
byte 1 111
byte 1 100
byte 1 101
byte 1 108
byte 1 115
byte 1 47
byte 1 99
byte 1 104
byte 1 117
byte 1 110
byte 1 107
byte 1 115
byte 1 47
byte 1 109
byte 1 101
byte 1 116
byte 1 97
byte 1 108
byte 1 47
byte 1 109
byte 1 101
byte 1 116
byte 1 97
byte 1 108
byte 1 50
byte 1 95
byte 1 51
byte 1 46
byte 1 109
byte 1 100
byte 1 51
byte 1 0
align 1
LABELV $383
byte 1 109
byte 1 111
byte 1 100
byte 1 101
byte 1 108
byte 1 115
byte 1 47
byte 1 99
byte 1 104
byte 1 117
byte 1 110
byte 1 107
byte 1 115
byte 1 47
byte 1 109
byte 1 101
byte 1 116
byte 1 97
byte 1 108
byte 1 47
byte 1 109
byte 1 101
byte 1 116
byte 1 97
byte 1 108
byte 1 50
byte 1 95
byte 1 50
byte 1 46
byte 1 109
byte 1 100
byte 1 51
byte 1 0
align 1
LABELV $381
byte 1 109
byte 1 111
byte 1 100
byte 1 101
byte 1 108
byte 1 115
byte 1 47
byte 1 99
byte 1 104
byte 1 117
byte 1 110
byte 1 107
byte 1 115
byte 1 47
byte 1 109
byte 1 101
byte 1 116
byte 1 97
byte 1 108
byte 1 47
byte 1 109
byte 1 101
byte 1 116
byte 1 97
byte 1 108
byte 1 50
byte 1 95
byte 1 49
byte 1 46
byte 1 109
byte 1 100
byte 1 51
byte 1 0
align 1
LABELV $379
byte 1 109
byte 1 111
byte 1 100
byte 1 101
byte 1 108
byte 1 115
byte 1 47
byte 1 99
byte 1 104
byte 1 117
byte 1 110
byte 1 107
byte 1 115
byte 1 47
byte 1 109
byte 1 101
byte 1 116
byte 1 97
byte 1 108
byte 1 47
byte 1 109
byte 1 101
byte 1 116
byte 1 97
byte 1 108
byte 1 49
byte 1 95
byte 1 52
byte 1 46
byte 1 109
byte 1 100
byte 1 51
byte 1 0
align 1
LABELV $377
byte 1 109
byte 1 111
byte 1 100
byte 1 101
byte 1 108
byte 1 115
byte 1 47
byte 1 99
byte 1 104
byte 1 117
byte 1 110
byte 1 107
byte 1 115
byte 1 47
byte 1 109
byte 1 101
byte 1 116
byte 1 97
byte 1 108
byte 1 47
byte 1 109
byte 1 101
byte 1 116
byte 1 97
byte 1 108
byte 1 49
byte 1 95
byte 1 51
byte 1 46
byte 1 109
byte 1 100
byte 1 51
byte 1 0
align 1
LABELV $375
byte 1 109
byte 1 111
byte 1 100
byte 1 101
byte 1 108
byte 1 115
byte 1 47
byte 1 99
byte 1 104
byte 1 117
byte 1 110
byte 1 107
byte 1 115
byte 1 47
byte 1 109
byte 1 101
byte 1 116
byte 1 97
byte 1 108
byte 1 47
byte 1 109
byte 1 101
byte 1 116
byte 1 97
byte 1 108
byte 1 49
byte 1 95
byte 1 50
byte 1 46
byte 1 109
byte 1 100
byte 1 51
byte 1 0
align 1
LABELV $373
byte 1 109
byte 1 111
byte 1 100
byte 1 101
byte 1 108
byte 1 115
byte 1 47
byte 1 99
byte 1 104
byte 1 117
byte 1 110
byte 1 107
byte 1 115
byte 1 47
byte 1 109
byte 1 101
byte 1 116
byte 1 97
byte 1 108
byte 1 47
byte 1 109
byte 1 101
byte 1 116
byte 1 97
byte 1 108
byte 1 49
byte 1 95
byte 1 49
byte 1 46
byte 1 109
byte 1 100
byte 1 51
byte 1 0
align 1
LABELV $333
byte 1 109
byte 1 111
byte 1 100
byte 1 101
byte 1 108
byte 1 115
byte 1 47
byte 1 99
byte 1 104
byte 1 117
byte 1 110
byte 1 107
byte 1 115
byte 1 47
byte 1 103
byte 1 108
byte 1 97
byte 1 115
byte 1 115
byte 1 47
byte 1 103
byte 1 108
byte 1 99
byte 1 104
byte 1 117
byte 1 110
byte 1 107
byte 1 115
byte 1 95
byte 1 37
byte 1 105
byte 1 46
byte 1 109
byte 1 100
byte 1 51
byte 1 0
align 1
LABELV $274
byte 1 115
byte 1 111
byte 1 117
byte 1 110
byte 1 100
byte 1 47
byte 1 101
byte 1 102
byte 1 102
byte 1 101
byte 1 99
byte 1 116
byte 1 115
byte 1 47
byte 1 103
byte 1 108
byte 1 97
byte 1 115
byte 1 115
byte 1 98
byte 1 114
byte 1 101
byte 1 97
byte 1 107
byte 1 49
byte 1 46
byte 1 119
byte 1 97
byte 1 118
byte 1 0
