export CG_TargetCommand_f
code
proc CG_TargetCommand_f 20 12
file "../cg_consolecmds.c"
line 16
;1:// Copyright (C) 1999-2000 Id Software, Inc.
;2://
;3:// cg_consolecmds.c -- text commands typed in at the local console, or
;4:// executed by a key binding
;5:
;6:#include "cg_local.h"
;7:#include "../ui/ui_shared.h"
;8:#include "cg_vehicles.h"\
;9:// adnan
;10:// tie fighter vehicles
;11:
;12:extern menuDef_t *menuScoreboard;
;13:
;14:
;15:
;16:void CG_TargetCommand_f( void ) {
line 20
;17:	int		targetNum;
;18:	char	test[4];
;19:
;20:	targetNum = CG_CrosshairPlayer();
ADDRLP4 8
ADDRGP4 CG_CrosshairPlayer
CALLI4
ASGNI4
ADDRLP4 0
ADDRLP4 8
INDIRI4
ASGNI4
line 21
;21:	if (!targetNum ) {
ADDRLP4 0
INDIRI4
CNSTI4 0
NEI4 $141
line 22
;22:		return;
ADDRGP4 $140
JUMPV
LABELV $141
line 25
;23:	}
;24:
;25:	trap_Argv( 1, test, 4 );
CNSTI4 1
ARGI4
ADDRLP4 4
ARGP4
CNSTI4 4
ARGI4
ADDRGP4 trap_Argv
CALLV
pop
line 26
;26:	trap_SendConsoleCommand( va( "gc %i %i", targetNum, atoi( test ) ) );
ADDRLP4 4
ARGP4
ADDRLP4 12
ADDRGP4 atoi
CALLI4
ASGNI4
ADDRGP4 $143
ARGP4
ADDRLP4 0
INDIRI4
ARGI4
ADDRLP4 12
INDIRI4
ARGI4
ADDRLP4 16
ADDRGP4 va
CALLP4
ASGNP4
ADDRLP4 16
INDIRP4
ARGP4
ADDRGP4 trap_SendConsoleCommand
CALLV
pop
line 27
;27:}
LABELV $140
endproc CG_TargetCommand_f 20 12
proc CG_SizeUp_f 4 8
line 38
;28:
;29:
;30:
;31:/*
;32:=================
;33:CG_SizeUp_f
;34:
;35:Keybinding command
;36:=================
;37:*/
;38:static void CG_SizeUp_f (void) {
line 39
;39:	trap_Cvar_Set("cg_viewsize", va("%i",(int)(cg_viewsize.integer+10)));
ADDRGP4 $146
ARGP4
ADDRGP4 cg_viewsize+12
INDIRI4
CNSTI4 10
ADDI4
ARGI4
ADDRLP4 0
ADDRGP4 va
CALLP4
ASGNP4
ADDRGP4 $145
ARGP4
ADDRLP4 0
INDIRP4
ARGP4
ADDRGP4 trap_Cvar_Set
CALLV
pop
line 40
;40:}
LABELV $144
endproc CG_SizeUp_f 4 8
proc CG_SizeDown_f 4 8
line 50
;41:
;42:
;43:/*
;44:=================
;45:CG_SizeDown_f
;46:
;47:Keybinding command
;48:=================
;49:*/
;50:static void CG_SizeDown_f (void) {
line 51
;51:	trap_Cvar_Set("cg_viewsize", va("%i",(int)(cg_viewsize.integer-10)));
ADDRGP4 $146
ARGP4
ADDRGP4 cg_viewsize+12
INDIRI4
CNSTI4 10
SUBI4
ARGI4
ADDRLP4 0
ADDRGP4 va
CALLP4
ASGNP4
ADDRGP4 $145
ARGP4
ADDRLP4 0
INDIRP4
ARGP4
ADDRGP4 trap_Cvar_Set
CALLV
pop
line 52
;52:}
LABELV $148
endproc CG_SizeDown_f 4 8
proc CG_Viewpos_f 0 24
line 62
;53:
;54:
;55:/*
;56:=============
;57:CG_Viewpos_f
;58:
;59:Debugging command to print the current position
;60:=============
;61:*/
;62:static void CG_Viewpos_f (void) {
line 63
;63:	CG_Printf ("%s (%i %i %i) : %i\n", cgs.mapname, (int)cg.refdef.vieworg[0],
ADDRGP4 $151
ARGP4
ADDRGP4 cgs+33008
ARGP4
ADDRGP4 cg+3616+24
INDIRF4
CVFI4 4
ARGI4
ADDRGP4 cg+3616+24+4
INDIRF4
CVFI4 4
ARGI4
ADDRGP4 cg+3616+24+8
INDIRF4
CVFI4 4
ARGI4
ADDRGP4 cg+3984+4
INDIRF4
CVFI4 4
ARGI4
ADDRGP4 CG_Printf
CALLV
pop
line 66
;64:		(int)cg.refdef.vieworg[1], (int)cg.refdef.vieworg[2], 
;65:		(int)cg.refdefViewAngles[YAW]);
;66:}
LABELV $150
endproc CG_Viewpos_f 0 24
proc CG_ScoresDown_f 0 4
line 69
;67:
;68:
;69:static void CG_ScoresDown_f( void ) {
line 71
;70:
;71:	CG_BuildSpectatorString();
ADDRGP4 CG_BuildSpectatorString
CALLV
pop
line 72
;72:	if ( cg.scoresRequestTime + 2000 < cg.time ) {
ADDRGP4 cg+5044
INDIRI4
CNSTI4 2000
ADDI4
ADDRGP4 cg+64
INDIRI4
GEI4 $164
line 75
;73:		// the scores are more than two seconds out of data,
;74:		// so request new ones
;75:		cg.scoresRequestTime = cg.time;
ADDRGP4 cg+5044
ADDRGP4 cg+64
INDIRI4
ASGNI4
line 76
;76:		trap_SendClientCommand( "score" );
ADDRGP4 $170
ARGP4
ADDRGP4 trap_SendClientCommand
CALLV
pop
line 80
;77:
;78:		// leave the current scores up if they were already
;79:		// displayed, but if this is the first hit, clear them out
;80:		if ( !cg.showScores ) {
ADDRGP4 cg+6984
INDIRI4
CNSTI4 0
NEI4 $165
line 81
;81:			cg.showScores = qtrue;
ADDRGP4 cg+6984
CNSTI4 1
ASGNI4
line 82
;82:			cg.numScores = 0;
ADDRGP4 cg+5048
CNSTI4 0
ASGNI4
line 83
;83:		}
line 84
;84:	} else {
ADDRGP4 $165
JUMPV
LABELV $164
line 87
;85:		// show the cached contents even if they just pressed if it
;86:		// is within two seconds
;87:		cg.showScores = qtrue;
ADDRGP4 cg+6984
CNSTI4 1
ASGNI4
line 88
;88:	}
LABELV $165
line 89
;89:}
LABELV $163
endproc CG_ScoresDown_f 0 4
proc CG_ScoresUp_f 0 0
line 91
;90:
;91:static void CG_ScoresUp_f( void ) {
line 92
;92:	if ( cg.showScores ) {
ADDRGP4 cg+6984
INDIRI4
CNSTI4 0
EQI4 $178
line 93
;93:		cg.showScores = qfalse;
ADDRGP4 cg+6984
CNSTI4 0
ASGNI4
line 94
;94:		cg.scoreFadeTime = cg.time;
ADDRGP4 cg+6992
ADDRGP4 cg+64
INDIRI4
ASGNI4
line 95
;95:	}
LABELV $178
line 96
;96:}
LABELV $177
endproc CG_ScoresUp_f 0 0
proc CG_scrollScoresDown_f 0 12
line 101
;97:
;98:extern menuDef_t *menuScoreboard;
;99:void Menu_Reset();			// FIXME: add to right include file
;100:
;101:static void CG_scrollScoresDown_f( void) {
line 102
;102:	if (menuScoreboard && cg.scoreBoardShowing) {
ADDRGP4 menuScoreboard
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $185
ADDRGP4 cg+6988
INDIRI4
CNSTI4 0
EQI4 $185
line 103
;103:		Menu_ScrollFeeder(menuScoreboard, FEEDER_SCOREBOARD, qtrue);
ADDRGP4 menuScoreboard
INDIRP4
ARGP4
CNSTI4 11
ARGI4
CNSTI4 1
ARGI4
ADDRGP4 Menu_ScrollFeeder
CALLV
pop
line 104
;104:		Menu_ScrollFeeder(menuScoreboard, FEEDER_REDTEAM_LIST, qtrue);
ADDRGP4 menuScoreboard
INDIRP4
ARGP4
CNSTI4 5
ARGI4
CNSTI4 1
ARGI4
ADDRGP4 Menu_ScrollFeeder
CALLV
pop
line 105
;105:		Menu_ScrollFeeder(menuScoreboard, FEEDER_BLUETEAM_LIST, qtrue);
ADDRGP4 menuScoreboard
INDIRP4
ARGP4
CNSTI4 6
ARGI4
CNSTI4 1
ARGI4
ADDRGP4 Menu_ScrollFeeder
CALLV
pop
line 106
;106:	}
LABELV $185
line 107
;107:}
LABELV $184
endproc CG_scrollScoresDown_f 0 12
proc CG_scrollScoresUp_f 0 12
line 110
;108:
;109:
;110:static void CG_scrollScoresUp_f( void) {
line 111
;111:	if (menuScoreboard && cg.scoreBoardShowing) {
ADDRGP4 menuScoreboard
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $189
ADDRGP4 cg+6988
INDIRI4
CNSTI4 0
EQI4 $189
line 112
;112:		Menu_ScrollFeeder(menuScoreboard, FEEDER_SCOREBOARD, qfalse);
ADDRGP4 menuScoreboard
INDIRP4
ARGP4
CNSTI4 11
ARGI4
CNSTI4 0
ARGI4
ADDRGP4 Menu_ScrollFeeder
CALLV
pop
line 113
;113:		Menu_ScrollFeeder(menuScoreboard, FEEDER_REDTEAM_LIST, qfalse);
ADDRGP4 menuScoreboard
INDIRP4
ARGP4
CNSTI4 5
ARGI4
CNSTI4 0
ARGI4
ADDRGP4 Menu_ScrollFeeder
CALLV
pop
line 114
;114:		Menu_ScrollFeeder(menuScoreboard, FEEDER_BLUETEAM_LIST, qfalse);
ADDRGP4 menuScoreboard
INDIRP4
ARGP4
CNSTI4 6
ARGI4
CNSTI4 0
ARGI4
ADDRGP4 Menu_ScrollFeeder
CALLV
pop
line 115
;115:	}
LABELV $189
line 116
;116:}
LABELV $188
endproc CG_scrollScoresUp_f 0 12
proc CG_spWin_f 0 12
line 119
;117:
;118:
;119:static void CG_spWin_f( void) {
line 120
;120:	trap_Cvar_Set("cg_cameraOrbit", "2");
ADDRGP4 $193
ARGP4
ADDRGP4 $194
ARGP4
ADDRGP4 trap_Cvar_Set
CALLV
pop
line 121
;121:	trap_Cvar_Set("cg_cameraOrbitDelay", "35");
ADDRGP4 $195
ARGP4
ADDRGP4 $196
ARGP4
ADDRGP4 trap_Cvar_Set
CALLV
pop
line 122
;122:	trap_Cvar_Set("cg_thirdPerson", "1");
ADDRGP4 $197
ARGP4
ADDRGP4 $198
ARGP4
ADDRGP4 trap_Cvar_Set
CALLV
pop
line 123
;123:	trap_Cvar_Set("cg_thirdPersonAngle", "0");
ADDRGP4 $199
ARGP4
ADDRGP4 $200
ARGP4
ADDRGP4 trap_Cvar_Set
CALLV
pop
line 124
;124:	trap_Cvar_Set("cg_thirdPersonRange", "100");
ADDRGP4 $201
ARGP4
ADDRGP4 $202
ARGP4
ADDRGP4 trap_Cvar_Set
CALLV
pop
line 125
;125:	CG_AddBufferedSound(cgs.media.winnerSound);
ADDRGP4 cgs+71064+668
INDIRI4
ARGI4
ADDRGP4 CG_AddBufferedSound
CALLV
pop
line 127
;126:	//trap_S_StartLocalSound(cgs.media.winnerSound, CHAN_ANNOUNCER);
;127:	CG_CenterPrint("YOU WIN!", SCREEN_HEIGHT * .30, 0);
ADDRGP4 $205
ARGP4
CNSTI4 144
ARGI4
CNSTI4 0
ARGI4
ADDRGP4 CG_CenterPrint
CALLV
pop
line 128
;128:}
LABELV $192
endproc CG_spWin_f 0 12
proc CG_spLose_f 0 12
line 130
;129:
;130:static void CG_spLose_f( void) {
line 131
;131:	trap_Cvar_Set("cg_cameraOrbit", "2");
ADDRGP4 $193
ARGP4
ADDRGP4 $194
ARGP4
ADDRGP4 trap_Cvar_Set
CALLV
pop
line 132
;132:	trap_Cvar_Set("cg_cameraOrbitDelay", "35");
ADDRGP4 $195
ARGP4
ADDRGP4 $196
ARGP4
ADDRGP4 trap_Cvar_Set
CALLV
pop
line 133
;133:	trap_Cvar_Set("cg_thirdPerson", "1");
ADDRGP4 $197
ARGP4
ADDRGP4 $198
ARGP4
ADDRGP4 trap_Cvar_Set
CALLV
pop
line 134
;134:	trap_Cvar_Set("cg_thirdPersonAngle", "0");
ADDRGP4 $199
ARGP4
ADDRGP4 $200
ARGP4
ADDRGP4 trap_Cvar_Set
CALLV
pop
line 135
;135:	trap_Cvar_Set("cg_thirdPersonRange", "100");
ADDRGP4 $201
ARGP4
ADDRGP4 $202
ARGP4
ADDRGP4 trap_Cvar_Set
CALLV
pop
line 136
;136:	CG_AddBufferedSound(cgs.media.loserSound);
ADDRGP4 cgs+71064+672
INDIRI4
ARGI4
ADDRGP4 CG_AddBufferedSound
CALLV
pop
line 138
;137:	//trap_S_StartLocalSound(cgs.media.loserSound, CHAN_ANNOUNCER);
;138:	CG_CenterPrint("YOU LOSE...", SCREEN_HEIGHT * .30, 0);
ADDRGP4 $209
ARGP4
CNSTI4 144
ARGI4
CNSTI4 0
ARGI4
ADDRGP4 CG_CenterPrint
CALLV
pop
line 139
;139:}
LABELV $206
endproc CG_spLose_f 0 12
proc CG_TellTarget_f 264 20
line 142
;140:
;141:
;142:static void CG_TellTarget_f( void ) {
line 147
;143:	int		clientNum;
;144:	char	command[128];
;145:	char	message[128];
;146:
;147:	clientNum = CG_CrosshairPlayer();
ADDRLP4 260
ADDRGP4 CG_CrosshairPlayer
CALLI4
ASGNI4
ADDRLP4 0
ADDRLP4 260
INDIRI4
ASGNI4
line 148
;148:	if ( clientNum == -1 ) {
ADDRLP4 0
INDIRI4
CNSTI4 -1
NEI4 $211
line 149
;149:		return;
ADDRGP4 $210
JUMPV
LABELV $211
line 152
;150:	}
;151:
;152:	trap_Args( message, 128 );
ADDRLP4 132
ARGP4
CNSTI4 128
ARGI4
ADDRGP4 trap_Args
CALLV
pop
line 153
;153:	Com_sprintf( command, 128, "tell %i %s", clientNum, message );
ADDRLP4 4
ARGP4
CNSTI4 128
ARGI4
ADDRGP4 $213
ARGP4
ADDRLP4 0
INDIRI4
ARGI4
ADDRLP4 132
ARGP4
ADDRGP4 Com_sprintf
CALLV
pop
line 154
;154:	trap_SendClientCommand( command );
ADDRLP4 4
ARGP4
ADDRGP4 trap_SendClientCommand
CALLV
pop
line 155
;155:}
LABELV $210
endproc CG_TellTarget_f 264 20
proc CG_TellAttacker_f 264 20
line 157
;156:
;157:static void CG_TellAttacker_f( void ) {
line 162
;158:	int		clientNum;
;159:	char	command[128];
;160:	char	message[128];
;161:
;162:	clientNum = CG_LastAttacker();
ADDRLP4 260
ADDRGP4 CG_LastAttacker
CALLI4
ASGNI4
ADDRLP4 0
ADDRLP4 260
INDIRI4
ASGNI4
line 163
;163:	if ( clientNum == -1 ) {
ADDRLP4 0
INDIRI4
CNSTI4 -1
NEI4 $215
line 164
;164:		return;
ADDRGP4 $214
JUMPV
LABELV $215
line 167
;165:	}
;166:
;167:	trap_Args( message, 128 );
ADDRLP4 132
ARGP4
CNSTI4 128
ARGI4
ADDRGP4 trap_Args
CALLV
pop
line 168
;168:	Com_sprintf( command, 128, "tell %i %s", clientNum, message );
ADDRLP4 4
ARGP4
CNSTI4 128
ARGI4
ADDRGP4 $213
ARGP4
ADDRLP4 0
INDIRI4
ARGI4
ADDRLP4 132
ARGP4
ADDRGP4 Com_sprintf
CALLV
pop
line 169
;169:	trap_SendClientCommand( command );
ADDRLP4 4
ARGP4
ADDRGP4 trap_SendClientCommand
CALLV
pop
line 170
;170:}
LABELV $214
endproc CG_TellAttacker_f 264 20
proc CG_VoiceTellTarget_f 264 20
line 172
;171:
;172:static void CG_VoiceTellTarget_f( void ) {
line 177
;173:	int		clientNum;
;174:	char	command[128];
;175:	char	message[128];
;176:
;177:	clientNum = CG_CrosshairPlayer();
ADDRLP4 260
ADDRGP4 CG_CrosshairPlayer
CALLI4
ASGNI4
ADDRLP4 0
ADDRLP4 260
INDIRI4
ASGNI4
line 178
;178:	if ( clientNum == -1 ) {
ADDRLP4 0
INDIRI4
CNSTI4 -1
NEI4 $218
line 179
;179:		return;
ADDRGP4 $217
JUMPV
LABELV $218
line 182
;180:	}
;181:
;182:	trap_Args( message, 128 );
ADDRLP4 132
ARGP4
CNSTI4 128
ARGI4
ADDRGP4 trap_Args
CALLV
pop
line 183
;183:	Com_sprintf( command, 128, "vtell %i %s", clientNum, message );
ADDRLP4 4
ARGP4
CNSTI4 128
ARGI4
ADDRGP4 $220
ARGP4
ADDRLP4 0
INDIRI4
ARGI4
ADDRLP4 132
ARGP4
ADDRGP4 Com_sprintf
CALLV
pop
line 184
;184:	trap_SendClientCommand( command );
ADDRLP4 4
ARGP4
ADDRGP4 trap_SendClientCommand
CALLV
pop
line 185
;185:}
LABELV $217
endproc CG_VoiceTellTarget_f 264 20
proc CG_VoiceTellAttacker_f 264 20
line 187
;186:
;187:static void CG_VoiceTellAttacker_f( void ) {
line 192
;188:	int		clientNum;
;189:	char	command[128];
;190:	char	message[128];
;191:
;192:	clientNum = CG_LastAttacker();
ADDRLP4 260
ADDRGP4 CG_LastAttacker
CALLI4
ASGNI4
ADDRLP4 0
ADDRLP4 260
INDIRI4
ASGNI4
line 193
;193:	if ( clientNum == -1 ) {
ADDRLP4 0
INDIRI4
CNSTI4 -1
NEI4 $222
line 194
;194:		return;
ADDRGP4 $221
JUMPV
LABELV $222
line 197
;195:	}
;196:
;197:	trap_Args( message, 128 );
ADDRLP4 132
ARGP4
CNSTI4 128
ARGI4
ADDRGP4 trap_Args
CALLV
pop
line 198
;198:	Com_sprintf( command, 128, "vtell %i %s", clientNum, message );
ADDRLP4 4
ARGP4
CNSTI4 128
ARGI4
ADDRGP4 $220
ARGP4
ADDRLP4 0
INDIRI4
ARGI4
ADDRLP4 132
ARGP4
ADDRGP4 Com_sprintf
CALLV
pop
line 199
;199:	trap_SendClientCommand( command );
ADDRLP4 4
ARGP4
ADDRGP4 trap_SendClientCommand
CALLV
pop
line 200
;200:}
LABELV $221
endproc CG_VoiceTellAttacker_f 264 20
proc CG_NextTeamMember_f 0 0
line 202
;201:
;202:static void CG_NextTeamMember_f( void ) {
line 203
;203:  CG_SelectNextPlayer();
ADDRGP4 CG_SelectNextPlayer
CALLV
pop
line 204
;204:}
LABELV $224
endproc CG_NextTeamMember_f 0 0
proc CG_PrevTeamMember_f 0 0
line 206
;205:
;206:static void CG_PrevTeamMember_f( void ) {
line 207
;207:  CG_SelectPrevPlayer();
ADDRGP4 CG_SelectPrevPlayer
CALLV
pop
line 208
;208:}
LABELV $225
endproc CG_PrevTeamMember_f 0 0
proc CG_NextOrder_f 16 0
line 212
;209:
;210:// ASS U ME's enumeration order as far as task specific orders, OFFENSE is zero, CAMP is last
;211://
;212:static void CG_NextOrder_f( void ) {
line 213
;213:	clientInfo_t *ci = cgs.clientinfo + cg.snap->ps.clientNum;
ADDRLP4 0
CNSTI4 812
ADDRGP4 cg+36
INDIRP4
CNSTI4 188
ADDP4
INDIRI4
MULI4
ADDRGP4 cgs+43024
ADDP4
ASGNP4
line 214
;214:	if (ci) {
ADDRLP4 0
INDIRP4
CVPU4 4
CNSTU4 0
EQU4 $229
line 215
;215:		if (!ci->teamLeader && sortedTeamPlayers[cg_currentSelectedPlayer.integer] != cg.snap->ps.clientNum) {
ADDRLP4 0
INDIRP4
CNSTI4 144
ADDP4
INDIRI4
CNSTI4 0
NEI4 $231
ADDRGP4 cg_currentSelectedPlayer+12
INDIRI4
CNSTI4 2
LSHI4
ADDRGP4 sortedTeamPlayers
ADDP4
INDIRI4
ADDRGP4 cg+36
INDIRP4
CNSTI4 188
ADDP4
INDIRI4
EQI4 $231
line 216
;216:			return;
ADDRGP4 $226
JUMPV
LABELV $231
line 218
;217:		}
;218:	}
LABELV $229
line 219
;219:	if (cgs.currentOrder < TEAMTASK_CAMP) {
ADDRGP4 cgs+71004
INDIRI4
CNSTI4 7
GEI4 $235
line 220
;220:		cgs.currentOrder++;
ADDRLP4 4
ADDRGP4 cgs+71004
ASGNP4
ADDRLP4 4
INDIRP4
ADDRLP4 4
INDIRP4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 222
;221:
;222:		if (cgs.currentOrder == TEAMTASK_RETRIEVE) {
ADDRGP4 cgs+71004
INDIRI4
CNSTI4 5
NEI4 $239
line 223
;223:			if (!CG_OtherTeamHasFlag()) {
ADDRLP4 8
ADDRGP4 CG_OtherTeamHasFlag
CALLI4
ASGNI4
ADDRLP4 8
INDIRI4
CNSTI4 0
NEI4 $242
line 224
;224:				cgs.currentOrder++;
ADDRLP4 12
ADDRGP4 cgs+71004
ASGNP4
ADDRLP4 12
INDIRP4
ADDRLP4 12
INDIRP4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 225
;225:			}
LABELV $242
line 226
;226:		}
LABELV $239
line 228
;227:
;228:		if (cgs.currentOrder == TEAMTASK_ESCORT) {
ADDRGP4 cgs+71004
INDIRI4
CNSTI4 6
NEI4 $236
line 229
;229:			if (!CG_YourTeamHasFlag()) {
ADDRLP4 8
ADDRGP4 CG_YourTeamHasFlag
CALLI4
ASGNI4
ADDRLP4 8
INDIRI4
CNSTI4 0
NEI4 $236
line 230
;230:				cgs.currentOrder++;
ADDRLP4 12
ADDRGP4 cgs+71004
ASGNP4
ADDRLP4 12
INDIRP4
ADDRLP4 12
INDIRP4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 231
;231:			}
line 232
;232:		}
line 234
;233:
;234:	} else {
ADDRGP4 $236
JUMPV
LABELV $235
line 235
;235:		cgs.currentOrder = TEAMTASK_OFFENSE;
ADDRGP4 cgs+71004
CNSTI4 1
ASGNI4
line 236
;236:	}
LABELV $236
line 237
;237:	cgs.orderPending = qtrue;
ADDRGP4 cgs+71008
CNSTI4 1
ASGNI4
line 238
;238:	cgs.orderTime = cg.time + 3000;
ADDRGP4 cgs+71012
ADDRGP4 cg+64
INDIRI4
CNSTI4 3000
ADDI4
ASGNI4
line 239
;239:}
LABELV $226
endproc CG_NextOrder_f 16 0
proc CG_ConfirmOrder_f 8 12
line 242
;240:
;241:
;242:static void CG_ConfirmOrder_f (void ) {
line 243
;243:	trap_SendConsoleCommand(va("cmd vtell %d %s\n", cgs.acceptLeader, VOICECHAT_YES));
ADDRGP4 $256
ARGP4
ADDRGP4 cgs+71028
INDIRI4
ARGI4
ADDRGP4 $258
ARGP4
ADDRLP4 0
ADDRGP4 va
CALLP4
ASGNP4
ADDRLP4 0
INDIRP4
ARGP4
ADDRGP4 trap_SendConsoleCommand
CALLV
pop
line 244
;244:	trap_SendConsoleCommand("+button5; wait; -button5");
ADDRGP4 $259
ARGP4
ADDRGP4 trap_SendConsoleCommand
CALLV
pop
line 245
;245:	if (cg.time < cgs.acceptOrderTime) {
ADDRGP4 cg+64
INDIRI4
ADDRGP4 cgs+71020
INDIRI4
GEI4 $260
line 246
;246:		trap_SendClientCommand(va("teamtask %d\n", cgs.acceptTask));
ADDRGP4 $264
ARGP4
ADDRGP4 cgs+71024
INDIRI4
ARGI4
ADDRLP4 4
ADDRGP4 va
CALLP4
ASGNP4
ADDRLP4 4
INDIRP4
ARGP4
ADDRGP4 trap_SendClientCommand
CALLV
pop
line 247
;247:		cgs.acceptOrderTime = 0;
ADDRGP4 cgs+71020
CNSTI4 0
ASGNI4
line 248
;248:	}
LABELV $260
line 249
;249:}
LABELV $255
endproc CG_ConfirmOrder_f 8 12
proc CG_DenyOrder_f 4 12
line 251
;250:
;251:static void CG_DenyOrder_f (void ) {
line 252
;252:	trap_SendConsoleCommand(va("cmd vtell %d %s\n", cgs.acceptLeader, VOICECHAT_NO));
ADDRGP4 $256
ARGP4
ADDRGP4 cgs+71028
INDIRI4
ARGI4
ADDRGP4 $269
ARGP4
ADDRLP4 0
ADDRGP4 va
CALLP4
ASGNP4
ADDRLP4 0
INDIRP4
ARGP4
ADDRGP4 trap_SendConsoleCommand
CALLV
pop
line 253
;253:	trap_SendConsoleCommand("+button6; wait; -button6");
ADDRGP4 $270
ARGP4
ADDRGP4 trap_SendConsoleCommand
CALLV
pop
line 254
;254:	if (cg.time < cgs.acceptOrderTime) {
ADDRGP4 cg+64
INDIRI4
ADDRGP4 cgs+71020
INDIRI4
GEI4 $271
line 255
;255:		cgs.acceptOrderTime = 0;
ADDRGP4 cgs+71020
CNSTI4 0
ASGNI4
line 256
;256:	}
LABELV $271
line 257
;257:}
LABELV $267
endproc CG_DenyOrder_f 4 12
proc CG_TaskOffense_f 4 8
line 259
;258:
;259:static void CG_TaskOffense_f (void ) {
line 260
;260:	if (cgs.gametype == GT_CTF || cgs.gametype == GT_CTY) {
ADDRGP4 cgs+32960
INDIRI4
CNSTI4 7
EQI4 $281
ADDRGP4 cgs+32960
INDIRI4
CNSTI4 8
NEI4 $277
LABELV $281
line 261
;261:		trap_SendConsoleCommand(va("cmd vsay_team %s\n", VOICECHAT_ONGETFLAG));
ADDRGP4 $282
ARGP4
ADDRGP4 $283
ARGP4
ADDRLP4 0
ADDRGP4 va
CALLP4
ASGNP4
ADDRLP4 0
INDIRP4
ARGP4
ADDRGP4 trap_SendConsoleCommand
CALLV
pop
line 262
;262:	} else {
ADDRGP4 $278
JUMPV
LABELV $277
line 263
;263:		trap_SendConsoleCommand(va("cmd vsay_team %s\n", VOICECHAT_ONOFFENSE));
ADDRGP4 $282
ARGP4
ADDRGP4 $284
ARGP4
ADDRLP4 0
ADDRGP4 va
CALLP4
ASGNP4
ADDRLP4 0
INDIRP4
ARGP4
ADDRGP4 trap_SendConsoleCommand
CALLV
pop
line 264
;264:	}
LABELV $278
line 265
;265:	trap_SendClientCommand(va("teamtask %d\n", TEAMTASK_OFFENSE));
ADDRGP4 $264
ARGP4
CNSTI4 1
ARGI4
ADDRLP4 0
ADDRGP4 va
CALLP4
ASGNP4
ADDRLP4 0
INDIRP4
ARGP4
ADDRGP4 trap_SendClientCommand
CALLV
pop
line 266
;266:}
LABELV $276
endproc CG_TaskOffense_f 4 8
proc CG_TaskDefense_f 8 8
line 268
;267:
;268:static void CG_TaskDefense_f (void ) {
line 269
;269:	trap_SendConsoleCommand(va("cmd vsay_team %s\n", VOICECHAT_ONDEFENSE));
ADDRGP4 $282
ARGP4
ADDRGP4 $286
ARGP4
ADDRLP4 0
ADDRGP4 va
CALLP4
ASGNP4
ADDRLP4 0
INDIRP4
ARGP4
ADDRGP4 trap_SendConsoleCommand
CALLV
pop
line 270
;270:	trap_SendClientCommand(va("teamtask %d\n", TEAMTASK_DEFENSE));
ADDRGP4 $264
ARGP4
CNSTI4 2
ARGI4
ADDRLP4 4
ADDRGP4 va
CALLP4
ASGNP4
ADDRLP4 4
INDIRP4
ARGP4
ADDRGP4 trap_SendClientCommand
CALLV
pop
line 271
;271:}
LABELV $285
endproc CG_TaskDefense_f 8 8
proc CG_TaskPatrol_f 8 8
line 273
;272:
;273:static void CG_TaskPatrol_f (void ) {
line 274
;274:	trap_SendConsoleCommand(va("cmd vsay_team %s\n", VOICECHAT_ONPATROL));
ADDRGP4 $282
ARGP4
ADDRGP4 $288
ARGP4
ADDRLP4 0
ADDRGP4 va
CALLP4
ASGNP4
ADDRLP4 0
INDIRP4
ARGP4
ADDRGP4 trap_SendConsoleCommand
CALLV
pop
line 275
;275:	trap_SendClientCommand(va("teamtask %d\n", TEAMTASK_PATROL));
ADDRGP4 $264
ARGP4
CNSTI4 3
ARGI4
ADDRLP4 4
ADDRGP4 va
CALLP4
ASGNP4
ADDRLP4 4
INDIRP4
ARGP4
ADDRGP4 trap_SendClientCommand
CALLV
pop
line 276
;276:}
LABELV $287
endproc CG_TaskPatrol_f 8 8
proc CG_TaskCamp_f 8 8
line 278
;277:
;278:static void CG_TaskCamp_f (void ) {
line 279
;279:	trap_SendConsoleCommand(va("cmd vsay_team %s\n", VOICECHAT_ONCAMPING));
ADDRGP4 $282
ARGP4
ADDRGP4 $290
ARGP4
ADDRLP4 0
ADDRGP4 va
CALLP4
ASGNP4
ADDRLP4 0
INDIRP4
ARGP4
ADDRGP4 trap_SendConsoleCommand
CALLV
pop
line 280
;280:	trap_SendClientCommand(va("teamtask %d\n", TEAMTASK_CAMP));
ADDRGP4 $264
ARGP4
CNSTI4 7
ARGI4
ADDRLP4 4
ADDRGP4 va
CALLP4
ASGNP4
ADDRLP4 4
INDIRP4
ARGP4
ADDRGP4 trap_SendClientCommand
CALLV
pop
line 281
;281:}
LABELV $289
endproc CG_TaskCamp_f 8 8
proc CG_TaskFollow_f 8 8
line 283
;282:
;283:static void CG_TaskFollow_f (void ) {
line 284
;284:	trap_SendConsoleCommand(va("cmd vsay_team %s\n", VOICECHAT_ONFOLLOW));
ADDRGP4 $282
ARGP4
ADDRGP4 $292
ARGP4
ADDRLP4 0
ADDRGP4 va
CALLP4
ASGNP4
ADDRLP4 0
INDIRP4
ARGP4
ADDRGP4 trap_SendConsoleCommand
CALLV
pop
line 285
;285:	trap_SendClientCommand(va("teamtask %d\n", TEAMTASK_FOLLOW));
ADDRGP4 $264
ARGP4
CNSTI4 4
ARGI4
ADDRLP4 4
ADDRGP4 va
CALLP4
ASGNP4
ADDRLP4 4
INDIRP4
ARGP4
ADDRGP4 trap_SendClientCommand
CALLV
pop
line 286
;286:}
LABELV $291
endproc CG_TaskFollow_f 8 8
proc CG_TaskRetrieve_f 8 8
line 288
;287:
;288:static void CG_TaskRetrieve_f (void ) {
line 289
;289:	trap_SendConsoleCommand(va("cmd vsay_team %s\n", VOICECHAT_ONRETURNFLAG));
ADDRGP4 $282
ARGP4
ADDRGP4 $294
ARGP4
ADDRLP4 0
ADDRGP4 va
CALLP4
ASGNP4
ADDRLP4 0
INDIRP4
ARGP4
ADDRGP4 trap_SendConsoleCommand
CALLV
pop
line 290
;290:	trap_SendClientCommand(va("teamtask %d\n", TEAMTASK_RETRIEVE));
ADDRGP4 $264
ARGP4
CNSTI4 5
ARGI4
ADDRLP4 4
ADDRGP4 va
CALLP4
ASGNP4
ADDRLP4 4
INDIRP4
ARGP4
ADDRGP4 trap_SendClientCommand
CALLV
pop
line 291
;291:}
LABELV $293
endproc CG_TaskRetrieve_f 8 8
proc CG_TaskEscort_f 8 8
line 293
;292:
;293:static void CG_TaskEscort_f (void ) {
line 294
;294:	trap_SendConsoleCommand(va("cmd vsay_team %s\n", VOICECHAT_ONFOLLOWCARRIER));
ADDRGP4 $282
ARGP4
ADDRGP4 $296
ARGP4
ADDRLP4 0
ADDRGP4 va
CALLP4
ASGNP4
ADDRLP4 0
INDIRP4
ARGP4
ADDRGP4 trap_SendConsoleCommand
CALLV
pop
line 295
;295:	trap_SendClientCommand(va("teamtask %d\n", TEAMTASK_ESCORT));
ADDRGP4 $264
ARGP4
CNSTI4 6
ARGI4
ADDRLP4 4
ADDRGP4 va
CALLP4
ASGNP4
ADDRLP4 4
INDIRP4
ARGP4
ADDRGP4 trap_SendClientCommand
CALLV
pop
line 296
;296:}
LABELV $295
endproc CG_TaskEscort_f 8 8
proc CG_TaskOwnFlag_f 4 8
line 298
;297:
;298:static void CG_TaskOwnFlag_f (void ) {
line 299
;299:	trap_SendConsoleCommand(va("cmd vsay_team %s\n", VOICECHAT_IHAVEFLAG));
ADDRGP4 $282
ARGP4
ADDRGP4 $298
ARGP4
ADDRLP4 0
ADDRGP4 va
CALLP4
ASGNP4
ADDRLP4 0
INDIRP4
ARGP4
ADDRGP4 trap_SendConsoleCommand
CALLV
pop
line 300
;300:}
LABELV $297
endproc CG_TaskOwnFlag_f 4 8
proc CG_TauntKillInsult_f 0 4
line 302
;301:
;302:static void CG_TauntKillInsult_f (void ) {
line 303
;303:	trap_SendConsoleCommand("cmd vsay kill_insult\n");
ADDRGP4 $300
ARGP4
ADDRGP4 trap_SendConsoleCommand
CALLV
pop
line 304
;304:}
LABELV $299
endproc CG_TauntKillInsult_f 0 4
proc CG_TauntPraise_f 0 4
line 306
;305:
;306:static void CG_TauntPraise_f (void ) {
line 307
;307:	trap_SendConsoleCommand("cmd vsay praise\n");
ADDRGP4 $302
ARGP4
ADDRGP4 trap_SendConsoleCommand
CALLV
pop
line 308
;308:}
LABELV $301
endproc CG_TauntPraise_f 0 4
proc CG_TauntTaunt_f 0 4
line 310
;309:
;310:static void CG_TauntTaunt_f (void ) {
line 311
;311:	trap_SendConsoleCommand("cmd vtaunt\n");
ADDRGP4 $304
ARGP4
ADDRGP4 trap_SendConsoleCommand
CALLV
pop
line 312
;312:}
LABELV $303
endproc CG_TauntTaunt_f 0 4
proc CG_TauntDeathInsult_f 0 4
line 314
;313:
;314:static void CG_TauntDeathInsult_f (void ) {
line 315
;315:	trap_SendConsoleCommand("cmd vsay death_insult\n");
ADDRGP4 $306
ARGP4
ADDRGP4 trap_SendConsoleCommand
CALLV
pop
line 316
;316:}
LABELV $305
endproc CG_TauntDeathInsult_f 0 4
proc CG_TauntGauntlet_f 0 4
line 318
;317:
;318:static void CG_TauntGauntlet_f (void ) {
line 319
;319:	trap_SendConsoleCommand("cmd vsay kill_guantlet\n");
ADDRGP4 $308
ARGP4
ADDRGP4 trap_SendConsoleCommand
CALLV
pop
line 320
;320:}
LABELV $307
endproc CG_TauntGauntlet_f 0 4
proc CG_TaskSuicide_f 136 16
line 322
;321:
;322:static void CG_TaskSuicide_f (void ) {
line 326
;323:	int		clientNum;
;324:	char	command[128];
;325:
;326:	clientNum = CG_CrosshairPlayer();
ADDRLP4 132
ADDRGP4 CG_CrosshairPlayer
CALLI4
ASGNI4
ADDRLP4 0
ADDRLP4 132
INDIRI4
ASGNI4
line 327
;327:	if ( clientNum == -1 ) {
ADDRLP4 0
INDIRI4
CNSTI4 -1
NEI4 $310
line 328
;328:		return;
ADDRGP4 $309
JUMPV
LABELV $310
line 331
;329:	}
;330:
;331:	Com_sprintf( command, 128, "tell %i suicide", clientNum );
ADDRLP4 4
ARGP4
CNSTI4 128
ARGI4
ADDRGP4 $312
ARGP4
ADDRLP4 0
INDIRI4
ARGI4
ADDRGP4 Com_sprintf
CALLV
pop
line 332
;332:	trap_SendClientCommand( command );
ADDRLP4 4
ARGP4
ADDRGP4 trap_SendClientCommand
CALLV
pop
line 333
;333:}
LABELV $309
endproc CG_TaskSuicide_f 136 16
proc CG_StartOrbit_f 1028 12
line 373
;334:
;335:
;336:
;337:/*
;338:==================
;339:CG_TeamMenu_f
;340:==================
;341:*/
;342:/*
;343:static void CG_TeamMenu_f( void ) {
;344:  if (trap_Key_GetCatcher() & KEYCATCH_CGAME) {
;345:    CG_EventHandling(CGAME_EVENT_NONE);
;346:    trap_Key_SetCatcher(0);
;347:  } else {
;348:    CG_EventHandling(CGAME_EVENT_TEAMMENU);
;349:    //trap_Key_SetCatcher(KEYCATCH_CGAME);
;350:  }
;351:}
;352:*/
;353:
;354:/*
;355:==================
;356:CG_EditHud_f
;357:==================
;358:*/
;359:/*
;360:static void CG_EditHud_f( void ) {
;361:  //cls.keyCatchers ^= KEYCATCH_CGAME;
;362:  //VM_Call (cgvm, CG_EVENT_HANDLING, (cls.keyCatchers & KEYCATCH_CGAME) ? CGAME_EVENT_EDITHUD : CGAME_EVENT_NONE);
;363:}
;364:*/
;365:
;366:
;367:/*
;368:==================
;369:CG_StartOrbit_f
;370:==================
;371:*/
;372:
;373:static void CG_StartOrbit_f( void ) {
line 376
;374:	char var[MAX_TOKEN_CHARS];
;375:
;376:	trap_Cvar_VariableStringBuffer( "developer", var, sizeof( var ) );
ADDRGP4 $314
ARGP4
ADDRLP4 0
ARGP4
CNSTI4 1024
ARGI4
ADDRGP4 trap_Cvar_VariableStringBuffer
CALLV
pop
line 377
;377:	if ( !atoi(var) ) {
ADDRLP4 0
ARGP4
ADDRLP4 1024
ADDRGP4 atoi
CALLI4
ASGNI4
ADDRLP4 1024
INDIRI4
CNSTI4 0
NEI4 $315
line 378
;378:		return;
ADDRGP4 $313
JUMPV
LABELV $315
line 380
;379:	}
;380:	if (cg_cameraOrbit.value != 0) {
ADDRGP4 cg_cameraOrbit+8
INDIRF4
CNSTF4 0
EQF4 $317
line 381
;381:		trap_Cvar_Set ("cg_cameraOrbit", "0");
ADDRGP4 $193
ARGP4
ADDRGP4 $200
ARGP4
ADDRGP4 trap_Cvar_Set
CALLV
pop
line 382
;382:		trap_Cvar_Set("cg_thirdPerson", "0");
ADDRGP4 $197
ARGP4
ADDRGP4 $200
ARGP4
ADDRGP4 trap_Cvar_Set
CALLV
pop
line 383
;383:	} else {
ADDRGP4 $318
JUMPV
LABELV $317
line 384
;384:		trap_Cvar_Set("cg_cameraOrbit", "5");
ADDRGP4 $193
ARGP4
ADDRGP4 $320
ARGP4
ADDRGP4 trap_Cvar_Set
CALLV
pop
line 385
;385:		trap_Cvar_Set("cg_thirdPerson", "1");
ADDRGP4 $197
ARGP4
ADDRGP4 $198
ARGP4
ADDRGP4 trap_Cvar_Set
CALLV
pop
line 386
;386:		trap_Cvar_Set("cg_thirdPersonAngle", "0");
ADDRGP4 $199
ARGP4
ADDRGP4 $200
ARGP4
ADDRGP4 trap_Cvar_Set
CALLV
pop
line 387
;387:		trap_Cvar_Set("cg_thirdPersonRange", "100");
ADDRGP4 $201
ARGP4
ADDRGP4 $202
ARGP4
ADDRGP4 trap_Cvar_Set
CALLV
pop
line 388
;388:	}
LABELV $318
line 389
;389:}
LABELV $313
endproc CG_StartOrbit_f 1028 12
proc CG_ThrottleClamp_f 0 0
line 408
;390:
;391:/*
;392:static void CG_Camera_f( void ) {
;393:	char name[1024];
;394:	trap_Argv( 1, name, sizeof(name));
;395:	if (trap_loadCamera(name)) {
;396:		cg.cameraMode = qtrue;
;397:		trap_startCamera(cg.time);
;398:	} else {
;399:		CG_Printf ("Unable to load camera %s\n",name);
;400:	}
;401:}
;402:*/
;403:
;404:// adnan
;405:// throttle controls
;406:
;407:
;408:static void CG_ThrottleClamp_f(void) {
line 409
;409:   if(cg_throttle.integer < 0)
ADDRGP4 cg_throttle+12
INDIRI4
CNSTI4 0
GEI4 $322
line 410
;410:		cg_throttle.integer = 0;
ADDRGP4 cg_throttle+12
CNSTI4 0
ASGNI4
ADDRGP4 $323
JUMPV
LABELV $322
line 411
;411:	else if(cg_throttle.integer > 100)
ADDRGP4 cg_throttle+12
INDIRI4
CNSTI4 100
LEI4 $326
line 412
;412:		cg_throttle.integer = 100;
ADDRGP4 cg_throttle+12
CNSTI4 100
ASGNI4
LABELV $326
LABELV $323
line 413
;413:}
LABELV $321
endproc CG_ThrottleClamp_f 0 0
proc CG_ThrottleIncrease_f 12 8
line 415
;414:
;415:static void CG_ThrottleIncrease_f(void) {
line 418
;416:   centity_t	*cent;
;417:	clientInfo_t	*ci;
;418:	cent = &cg.predictedPlayerEntity;
ADDRLP4 4
ADDRGP4 cg+1476
ASGNP4
line 419
;419:	ci = &cgs.clientinfo[ cent->currentState.clientNum ];
ADDRLP4 0
CNSTI4 812
ADDRLP4 4
INDIRP4
CNSTI4 220
ADDP4
INDIRI4
MULI4
ADDRGP4 cgs+43024
ADDP4
ASGNP4
line 421
;420:	
;421:	if(cg.throttleQuick == qtrue)	{
ADDRGP4 cg+168236
INDIRI4
CNSTI4 1
NEI4 $333
line 422
;422:		cg_throttle.integer += 100;
ADDRLP4 8
ADDRGP4 cg_throttle+12
ASGNP4
ADDRLP4 8
INDIRP4
ADDRLP4 8
INDIRP4
INDIRI4
CNSTI4 100
ADDI4
ASGNI4
line 423
;423:	} else {
ADDRGP4 $334
JUMPV
LABELV $333
line 424
;424:		cg_throttle.integer += 1;
ADDRLP4 8
ADDRGP4 cg_throttle+12
ASGNP4
ADDRLP4 8
INDIRP4
ADDRLP4 8
INDIRP4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 425
;425:	}
LABELV $334
line 426
;426:	CG_ThrottleClamp_f();
ADDRGP4 CG_ThrottleClamp_f
CALLV
pop
line 428
;427:
;428:   ci->throttleAmount = cg_throttle.integer;
ADDRLP4 0
INDIRP4
CNSTI4 788
ADDP4
ADDRGP4 cg_throttle+12
INDIRI4
ASGNI4
line 430
;429:
;430:	trap_Cvar_Set( "cg_throttle", va("%d",ci->throttleAmount));
ADDRGP4 $340
ARGP4
ADDRLP4 0
INDIRP4
CNSTI4 788
ADDP4
INDIRI4
ARGI4
ADDRLP4 8
ADDRGP4 va
CALLP4
ASGNP4
ADDRGP4 $339
ARGP4
ADDRLP4 8
INDIRP4
ARGP4
ADDRGP4 trap_Cvar_Set
CALLV
pop
line 431
;431:}
LABELV $330
endproc CG_ThrottleIncrease_f 12 8
proc CG_ThrottleDecrease_f 12 8
line 433
;432:
;433:static void CG_ThrottleDecrease_f(void) {
line 436
;434:   centity_t	*cent;
;435:	clientInfo_t	*ci;
;436:	cent = &cg.predictedPlayerEntity;
ADDRLP4 4
ADDRGP4 cg+1476
ASGNP4
line 437
;437:	ci = &cgs.clientinfo[ cent->currentState.clientNum ];
ADDRLP4 0
CNSTI4 812
ADDRLP4 4
INDIRP4
CNSTI4 220
ADDP4
INDIRI4
MULI4
ADDRGP4 cgs+43024
ADDP4
ASGNP4
line 439
;438:	
;439:	if(cg.throttleQuick == qtrue)
ADDRGP4 cg+168236
INDIRI4
CNSTI4 1
NEI4 $344
line 440
;440:	{
line 441
;441:		cg_throttle.integer -= 100;
ADDRLP4 8
ADDRGP4 cg_throttle+12
ASGNP4
ADDRLP4 8
INDIRP4
ADDRLP4 8
INDIRP4
INDIRI4
CNSTI4 100
SUBI4
ASGNI4
line 442
;442:	}
ADDRGP4 $345
JUMPV
LABELV $344
line 444
;443:	else
;444:	{
line 445
;445:		cg_throttle.integer -= 1;
ADDRLP4 8
ADDRGP4 cg_throttle+12
ASGNP4
ADDRLP4 8
INDIRP4
ADDRLP4 8
INDIRP4
INDIRI4
CNSTI4 1
SUBI4
ASGNI4
line 446
;446:	}
LABELV $345
line 447
;447:	CG_ThrottleClamp_f();
ADDRGP4 CG_ThrottleClamp_f
CALLV
pop
line 449
;448:
;449:   ci->throttleAmount = cg_throttle.integer;
ADDRLP4 0
INDIRP4
CNSTI4 788
ADDP4
ADDRGP4 cg_throttle+12
INDIRI4
ASGNI4
line 451
;450:
;451:	trap_Cvar_Set( "cg_throttle", va("%d",ci->throttleAmount));
ADDRGP4 $340
ARGP4
ADDRLP4 0
INDIRP4
CNSTI4 788
ADDP4
INDIRI4
ARGI4
ADDRLP4 8
ADDRGP4 va
CALLP4
ASGNP4
ADDRGP4 $339
ARGP4
ADDRLP4 8
INDIRP4
ARGP4
ADDRGP4 trap_Cvar_Set
CALLV
pop
line 452
;452:}
LABELV $341
endproc CG_ThrottleDecrease_f 12 8
export CG_ThrottleQuickDown_f
proc CG_ThrottleQuickDown_f 0 0
line 455
;453:
;454:// sets the throttle multiplier state
;455:void CG_ThrottleQuickDown_f( void ){
line 456
;456:	if(cg.throttleQuick){
ADDRGP4 cg+168236
INDIRI4
CNSTI4 0
EQI4 $351
line 457
;457:		return;
ADDRGP4 $350
JUMPV
LABELV $351
line 459
;458:	}
;459:	cg.throttleQuick = qtrue;
ADDRGP4 cg+168236
CNSTI4 1
ASGNI4
line 460
;460:}
LABELV $350
endproc CG_ThrottleQuickDown_f 0 0
export CG_ThrottleQuickUp_f
proc CG_ThrottleQuickUp_f 0 0
line 463
;461:
;462:// sets the throttle multiplier state
;463:void CG_ThrottleQuickUp_f( void ){
line 464
;464:	if(!cg.throttleQuick){
ADDRGP4 cg+168236
INDIRI4
CNSTI4 0
NEI4 $356
line 465
;465:		return;
ADDRGP4 $355
JUMPV
LABELV $356
line 467
;466:	}
;467:	cg.throttleQuick = qfalse;
ADDRGP4 cg+168236
CNSTI4 0
ASGNI4
line 468
;468:}
LABELV $355
endproc CG_ThrottleQuickUp_f 0 0
proc CG_RollRightDown_f 16 8
line 470
;469:
;470:static void CG_RollRightDown_f(void) {
line 473
;471:   centity_t	*cent;
;472:	clientInfo_t	*ci;
;473:	cent = &cg.predictedPlayerEntity;
ADDRLP4 4
ADDRGP4 cg+1476
ASGNP4
line 474
;474:	ci = &cgs.clientinfo[ cent->currentState.clientNum ];
ADDRLP4 0
CNSTI4 812
ADDRLP4 4
INDIRP4
CNSTI4 220
ADDP4
INDIRI4
MULI4
ADDRGP4 cgs+43024
ADDP4
ASGNP4
line 477
;475:	
;476:   
;477:   ci->roll = cg_roll.integer;
ADDRLP4 0
INDIRP4
CNSTI4 792
ADDP4
ADDRGP4 cg_roll+12
INDIRI4
ASGNI4
line 479
;478:
;479:   ci->roll += 1;
ADDRLP4 8
ADDRLP4 0
INDIRP4
CNSTI4 792
ADDP4
ASGNP4
ADDRLP4 8
INDIRP4
ADDRLP4 8
INDIRP4
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
line 481
;480:
;481:	trap_Cvar_Set( "cg_roll", va("%d",ci->roll));
ADDRGP4 $340
ARGP4
ADDRLP4 0
INDIRP4
CNSTI4 792
ADDP4
INDIRI4
ARGI4
ADDRLP4 12
ADDRGP4 va
CALLP4
ASGNP4
ADDRGP4 $364
ARGP4
ADDRLP4 12
INDIRP4
ARGP4
ADDRGP4 trap_Cvar_Set
CALLV
pop
line 483
;482:   
;483:}
LABELV $360
endproc CG_RollRightDown_f 16 8
proc CG_RollRightUp_f 0 0
line 485
;484:
;485:static void CG_RollRightUp_f(void) {
line 487
;486:
;487:}
LABELV $365
endproc CG_RollRightUp_f 0 0
proc CG_RollLeftDown_f 16 8
line 489
;488:
;489:static void CG_RollLeftDown_f(void) {
line 492
;490:   centity_t	*cent;
;491:	clientInfo_t	*ci;
;492:	cent = &cg.predictedPlayerEntity;
ADDRLP4 4
ADDRGP4 cg+1476
ASGNP4
line 493
;493:	ci = &cgs.clientinfo[ cent->currentState.clientNum ];
ADDRLP4 0
CNSTI4 812
ADDRLP4 4
INDIRP4
CNSTI4 220
ADDP4
INDIRI4
MULI4
ADDRGP4 cgs+43024
ADDP4
ASGNP4
line 495
;494:	
;495:   ci->roll = cg_roll.integer;
ADDRLP4 0
INDIRP4
CNSTI4 792
ADDP4
ADDRGP4 cg_roll+12
INDIRI4
ASGNI4
line 497
;496:
;497:   ci->roll -= 1;
ADDRLP4 8
ADDRLP4 0
INDIRP4
CNSTI4 792
ADDP4
ASGNP4
ADDRLP4 8
INDIRP4
ADDRLP4 8
INDIRP4
INDIRI4
CNSTI4 1
SUBI4
ASGNI4
line 499
;498:
;499:	trap_Cvar_Set( "cg_roll", va("%d",ci->roll));
ADDRGP4 $340
ARGP4
ADDRLP4 0
INDIRP4
CNSTI4 792
ADDP4
INDIRI4
ARGI4
ADDRLP4 12
ADDRGP4 va
CALLP4
ASGNP4
ADDRGP4 $364
ARGP4
ADDRLP4 12
INDIRP4
ARGP4
ADDRGP4 trap_Cvar_Set
CALLV
pop
line 500
;500:}
LABELV $366
endproc CG_RollLeftDown_f 16 8
proc CG_RollLeftUp_f 0 0
line 502
;501:
;502:static void CG_RollLeftUp_f(void) {
line 504
;503:
;504:}
LABELV $370
endproc CG_RollLeftUp_f 0 0
data
align 4
LABELV commands
address $372
address CG_TestGun_f
address $373
address CG_TestModel_f
address $374
address CG_TestModelNextFrame_f
address $375
address CG_TestModelPrevFrame_f
address $376
address CG_TestModelNextSkin_f
address $377
address CG_TestModelPrevSkin_f
address $378
address CG_Viewpos_f
address $379
address CG_ScoresDown_f
address $380
address CG_ScoresUp_f
address $381
address CG_SizeUp_f
address $382
address CG_SizeDown_f
address $383
address CG_NextWeapon_f
address $384
address CG_PrevWeapon_f
address $385
address CG_Weapon_f
address $386
address CG_TellTarget_f
address $387
address CG_TellAttacker_f
address $388
address CG_VoiceTellTarget_f
address $389
address CG_VoiceTellAttacker_f
address $390
address CG_TargetCommand_f
address $391
address CG_NextTeamMember_f
address $392
address CG_PrevTeamMember_f
address $393
address CG_NextOrder_f
address $394
address CG_ConfirmOrder_f
address $395
address CG_DenyOrder_f
address $396
address CG_TaskOffense_f
address $397
address CG_TaskDefense_f
address $398
address CG_TaskPatrol_f
address $399
address CG_TaskCamp_f
address $400
address CG_TaskFollow_f
address $401
address CG_TaskRetrieve_f
address $402
address CG_TaskEscort_f
address $403
address CG_TaskSuicide_f
address $404
address CG_TaskOwnFlag_f
address $405
address CG_TauntKillInsult_f
address $406
address CG_TauntPraise_f
address $407
address CG_TauntTaunt_f
address $408
address CG_TauntDeathInsult_f
address $409
address CG_TauntGauntlet_f
address $410
address CG_spWin_f
address $411
address CG_spLose_f
address $412
address CG_scrollScoresDown_f
address $413
address CG_scrollScoresUp_f
address $414
address CG_StartOrbit_f
address $415
address CG_LoadDeferredPlayers
address $416
address CG_NextInventory_f
address $417
address CG_PrevInventory_f
address $418
address CG_NextForcePower_f
address $419
address CG_PrevForcePower_f
address $420
address CG_ThrottleQuickDown_f
address $421
address CG_ThrottleQuickUp_f
address $422
address CG_ThrottleIncrease_f
address $423
address CG_ThrottleDecrease_f
address $424
address CG_RollRightDown_f
address $425
address CG_RollRightUp_f
address $426
address CG_RollLeftDown_f
address $427
address CG_RollLeftUp_f
address $428
address CG_ThrottleIncrease_f
address $429
address CG_ThrottleDecrease_f
address $430
address CG_RollRightDown_f
address $431
address CG_RollLeftDown_f
address $432
address Cmd_VehicleTemplates_f
address $433
address Cmd_Vehicles_f
export CG_ConsoleCommand
code
proc CG_ConsoleCommand 16 8
line 599
;505:
;506:
;507:typedef struct {
;508:	char	*cmd;
;509:	void	(*function)(void);
;510:} consoleCommand_t;
;511:
;512:static consoleCommand_t	commands[] = {
;513:	{ "testgun", CG_TestGun_f },
;514:	{ "testmodel", CG_TestModel_f },
;515:	{ "nextframe", CG_TestModelNextFrame_f },
;516:	{ "prevframe", CG_TestModelPrevFrame_f },
;517:	{ "nextskin", CG_TestModelNextSkin_f },
;518:	{ "prevskin", CG_TestModelPrevSkin_f },
;519:	{ "viewpos", CG_Viewpos_f },
;520:	{ "+scores", CG_ScoresDown_f },
;521:	{ "-scores", CG_ScoresUp_f },
;522:	{ "sizeup", CG_SizeUp_f },
;523:	{ "sizedown", CG_SizeDown_f },
;524:	{ "weapnext", CG_NextWeapon_f },
;525:	{ "weapprev", CG_PrevWeapon_f },
;526:	{ "weapon", CG_Weapon_f },
;527:	{ "tell_target", CG_TellTarget_f },
;528:	{ "tell_attacker", CG_TellAttacker_f },
;529:	{ "vtell_target", CG_VoiceTellTarget_f },
;530:	{ "vtell_attacker", CG_VoiceTellAttacker_f },
;531:	{ "tcmd", CG_TargetCommand_f },
;532:	{ "nextTeamMember", CG_NextTeamMember_f },
;533:	{ "prevTeamMember", CG_PrevTeamMember_f },
;534:	{ "nextOrder", CG_NextOrder_f },
;535:	{ "confirmOrder", CG_ConfirmOrder_f },
;536:	{ "denyOrder", CG_DenyOrder_f },
;537:	{ "taskOffense", CG_TaskOffense_f },
;538:	{ "taskDefense", CG_TaskDefense_f },
;539:	{ "taskPatrol", CG_TaskPatrol_f },
;540:	{ "taskCamp", CG_TaskCamp_f },
;541:	{ "taskFollow", CG_TaskFollow_f },
;542:	{ "taskRetrieve", CG_TaskRetrieve_f },
;543:	{ "taskEscort", CG_TaskEscort_f },
;544:	{ "taskSuicide", CG_TaskSuicide_f },
;545:	{ "taskOwnFlag", CG_TaskOwnFlag_f },
;546:	{ "tauntKillInsult", CG_TauntKillInsult_f },
;547:	{ "tauntPraise", CG_TauntPraise_f },
;548:	{ "tauntTaunt", CG_TauntTaunt_f },
;549:	{ "tauntDeathInsult", CG_TauntDeathInsult_f },
;550:	{ "tauntGauntlet", CG_TauntGauntlet_f },
;551:	{ "spWin", CG_spWin_f },
;552:	{ "spLose", CG_spLose_f },
;553:	{ "scoresDown", CG_scrollScoresDown_f },
;554:	{ "scoresUp", CG_scrollScoresUp_f },
;555:	{ "startOrbit", CG_StartOrbit_f },
;556:	//{ "camera", CG_Camera_f },
;557:	{ "loaddeferred", CG_LoadDeferredPlayers },
;558:	{ "invnext", CG_NextInventory_f },
;559:	{ "invprev", CG_PrevInventory_f },
;560:	{ "forcenext", CG_NextForcePower_f },
;561:	{ "forceprev", CG_PrevForcePower_f },
;562:   // adnan
;563:   // tie fighter throttle commands
;564:   
;565:   { "+throttlequick", CG_ThrottleQuickDown_f },
;566:   { "-throttlequick", CG_ThrottleQuickUp_f },
;567:   { "throttleup", CG_ThrottleIncrease_f },
;568:   { "throttledown", CG_ThrottleDecrease_f },
;569:
;570:   // new movement??????
;571:   { "+rollright", CG_RollRightDown_f },
;572:   { "-rollright", CG_RollRightUp_f },
;573:   { "+rollleft", CG_RollLeftDown_f },
;574:   { "-rollleft", CG_RollLeftUp_f },
;575:
;576:   // button based tie fighter stuff...
;577:   { "+button12", CG_ThrottleIncrease_f },
;578:   { "+button13", CG_ThrottleDecrease_f },
;579:   { "+button14", CG_RollRightDown_f },
;580:   { "+button15", CG_RollLeftDown_f },
;581:
;582:   // adnan
;583:   // tie fighter vehicles
;584:
;585:   { "vehicleTemplatesCG", Cmd_VehicleTemplates_f },
;586:   { "vehiclesCG", Cmd_Vehicles_f }
;587:   
;588:};
;589:
;590:
;591:/*
;592:=================
;593:CG_ConsoleCommand
;594:
;595:The string has been tokenized and can be retrieved with
;596:Cmd_Argc() / Cmd_Argv()
;597:=================
;598:*/
;599:qboolean CG_ConsoleCommand( void ) {
line 603
;600:	const char	*cmd;
;601:	int		i;
;602:
;603:	cmd = CG_Argv(0);
CNSTI4 0
ARGI4
ADDRLP4 8
ADDRGP4 CG_Argv
CALLP4
ASGNP4
ADDRLP4 4
ADDRLP4 8
INDIRP4
ASGNP4
line 605
;604:
;605:	for ( i = 0 ; i < sizeof( commands ) / sizeof( commands[0] ) ; i++ ) {
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 $438
JUMPV
LABELV $435
line 606
;606:		if ( !Q_stricmp( cmd, commands[i].cmd ) ) {
ADDRLP4 4
INDIRP4
ARGP4
ADDRLP4 0
INDIRI4
CNSTI4 3
LSHI4
ADDRGP4 commands
ADDP4
INDIRP4
ARGP4
ADDRLP4 12
ADDRGP4 Q_stricmp
CALLI4
ASGNI4
ADDRLP4 12
INDIRI4
CNSTI4 0
NEI4 $439
line 607
;607:			commands[i].function();
ADDRLP4 0
INDIRI4
CNSTI4 3
LSHI4
ADDRGP4 commands+4
ADDP4
INDIRP4
CALLV
pop
line 608
;608:			return qtrue;
CNSTI4 1
RETI4
ADDRGP4 $434
JUMPV
LABELV $439
line 610
;609:		}
;610:	}
LABELV $436
line 605
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $438
ADDRLP4 0
INDIRI4
CVIU4 4
CNSTU4 62
LTU4 $435
line 612
;611:
;612:	return qfalse;
CNSTI4 0
RETI4
LABELV $434
endproc CG_ConsoleCommand 16 8
export CG_InitConsoleCommands
proc CG_InitConsoleCommands 4 4
line 624
;613:}
;614:
;615:
;616:/*
;617:=================
;618:CG_InitConsoleCommands
;619:
;620:Let the client system know about all of our commands
;621:so it can perform tab completion
;622:=================
;623:*/
;624:void CG_InitConsoleCommands( void ) {
line 627
;625:	int		i;
;626:
;627:	for ( i = 0 ; i < sizeof( commands ) / sizeof( commands[0] ) ; i++ ) {
ADDRLP4 0
CNSTI4 0
ASGNI4
ADDRGP4 $446
JUMPV
LABELV $443
line 628
;628:		trap_AddCommand( commands[i].cmd );
ADDRLP4 0
INDIRI4
CNSTI4 3
LSHI4
ADDRGP4 commands
ADDP4
INDIRP4
ARGP4
ADDRGP4 trap_AddCommand
CALLV
pop
line 629
;629:	}
LABELV $444
line 627
ADDRLP4 0
ADDRLP4 0
INDIRI4
CNSTI4 1
ADDI4
ASGNI4
LABELV $446
ADDRLP4 0
INDIRI4
CVIU4 4
CNSTU4 62
LTU4 $443
line 635
;630:
;631:	//
;632:	// the game server will interpret these commands, which will be automatically
;633:	// forwarded to the server after they are not recognized locally
;634:	//
;635:	trap_AddCommand ("forcechanged");
ADDRGP4 $447
ARGP4
ADDRGP4 trap_AddCommand
CALLV
pop
line 636
;636:	trap_AddCommand ("sv_invnext");
ADDRGP4 $448
ARGP4
ADDRGP4 trap_AddCommand
CALLV
pop
line 637
;637:	trap_AddCommand ("sv_invprev");
ADDRGP4 $449
ARGP4
ADDRGP4 trap_AddCommand
CALLV
pop
line 638
;638:	trap_AddCommand ("sv_forcenext");
ADDRGP4 $450
ARGP4
ADDRGP4 trap_AddCommand
CALLV
pop
line 639
;639:	trap_AddCommand ("sv_forceprev");
ADDRGP4 $451
ARGP4
ADDRGP4 trap_AddCommand
CALLV
pop
line 640
;640:	trap_AddCommand ("sv_saberswitch");
ADDRGP4 $452
ARGP4
ADDRGP4 trap_AddCommand
CALLV
pop
line 641
;641:	trap_AddCommand ("engage_duel");
ADDRGP4 $453
ARGP4
ADDRGP4 trap_AddCommand
CALLV
pop
line 642
;642:	trap_AddCommand ("force_heal");
ADDRGP4 $454
ARGP4
ADDRGP4 trap_AddCommand
CALLV
pop
line 643
;643:	trap_AddCommand ("force_speed");
ADDRGP4 $455
ARGP4
ADDRGP4 trap_AddCommand
CALLV
pop
line 644
;644:	trap_AddCommand ("force_throw");
ADDRGP4 $456
ARGP4
ADDRGP4 trap_AddCommand
CALLV
pop
line 645
;645:	trap_AddCommand ("force_pull");
ADDRGP4 $457
ARGP4
ADDRGP4 trap_AddCommand
CALLV
pop
line 646
;646:	trap_AddCommand ("force_distract");
ADDRGP4 $458
ARGP4
ADDRGP4 trap_AddCommand
CALLV
pop
line 647
;647:	trap_AddCommand ("force_rage");
ADDRGP4 $459
ARGP4
ADDRGP4 trap_AddCommand
CALLV
pop
line 648
;648:	trap_AddCommand ("force_protect");
ADDRGP4 $460
ARGP4
ADDRGP4 trap_AddCommand
CALLV
pop
line 649
;649:	trap_AddCommand ("force_absorb");
ADDRGP4 $461
ARGP4
ADDRGP4 trap_AddCommand
CALLV
pop
line 650
;650:	trap_AddCommand ("force_healother");
ADDRGP4 $462
ARGP4
ADDRGP4 trap_AddCommand
CALLV
pop
line 651
;651:	trap_AddCommand ("force_forcepowerother");
ADDRGP4 $463
ARGP4
ADDRGP4 trap_AddCommand
CALLV
pop
line 652
;652:	trap_AddCommand ("force_seeing");
ADDRGP4 $464
ARGP4
ADDRGP4 trap_AddCommand
CALLV
pop
line 653
;653:	trap_AddCommand ("use_seeker");
ADDRGP4 $465
ARGP4
ADDRGP4 trap_AddCommand
CALLV
pop
line 654
;654:	trap_AddCommand ("use_field");
ADDRGP4 $466
ARGP4
ADDRGP4 trap_AddCommand
CALLV
pop
line 655
;655:	trap_AddCommand ("use_bacta");
ADDRGP4 $467
ARGP4
ADDRGP4 trap_AddCommand
CALLV
pop
line 656
;656:	trap_AddCommand ("use_electrobinoculars");
ADDRGP4 $468
ARGP4
ADDRGP4 trap_AddCommand
CALLV
pop
line 657
;657:	trap_AddCommand ("zoom");
ADDRGP4 $469
ARGP4
ADDRGP4 trap_AddCommand
CALLV
pop
line 658
;658:	trap_AddCommand ("use_sentry");
ADDRGP4 $470
ARGP4
ADDRGP4 trap_AddCommand
CALLV
pop
line 659
;659:	trap_AddCommand ("bot_order");
ADDRGP4 $471
ARGP4
ADDRGP4 trap_AddCommand
CALLV
pop
line 660
;660:	trap_AddCommand ("saberAttackCycle");
ADDRGP4 $472
ARGP4
ADDRGP4 trap_AddCommand
CALLV
pop
line 661
;661:	trap_AddCommand ("kill");
ADDRGP4 $473
ARGP4
ADDRGP4 trap_AddCommand
CALLV
pop
line 662
;662:	trap_AddCommand ("say");
ADDRGP4 $474
ARGP4
ADDRGP4 trap_AddCommand
CALLV
pop
line 663
;663:	trap_AddCommand ("say_team");
ADDRGP4 $475
ARGP4
ADDRGP4 trap_AddCommand
CALLV
pop
line 664
;664:	trap_AddCommand ("tell");
ADDRGP4 $476
ARGP4
ADDRGP4 trap_AddCommand
CALLV
pop
line 665
;665:	trap_AddCommand ("vsay");
ADDRGP4 $477
ARGP4
ADDRGP4 trap_AddCommand
CALLV
pop
line 666
;666:	trap_AddCommand ("vsay_team");
ADDRGP4 $478
ARGP4
ADDRGP4 trap_AddCommand
CALLV
pop
line 667
;667:	trap_AddCommand ("vtell");
ADDRGP4 $479
ARGP4
ADDRGP4 trap_AddCommand
CALLV
pop
line 668
;668:	trap_AddCommand ("vtaunt");
ADDRGP4 $480
ARGP4
ADDRGP4 trap_AddCommand
CALLV
pop
line 669
;669:	trap_AddCommand ("vosay");
ADDRGP4 $481
ARGP4
ADDRGP4 trap_AddCommand
CALLV
pop
line 670
;670:	trap_AddCommand ("vosay_team");
ADDRGP4 $482
ARGP4
ADDRGP4 trap_AddCommand
CALLV
pop
line 671
;671:	trap_AddCommand ("votell");
ADDRGP4 $483
ARGP4
ADDRGP4 trap_AddCommand
CALLV
pop
line 672
;672:	trap_AddCommand ("give");
ADDRGP4 $484
ARGP4
ADDRGP4 trap_AddCommand
CALLV
pop
line 673
;673:	trap_AddCommand ("god");
ADDRGP4 $485
ARGP4
ADDRGP4 trap_AddCommand
CALLV
pop
line 674
;674:	trap_AddCommand ("notarget");
ADDRGP4 $486
ARGP4
ADDRGP4 trap_AddCommand
CALLV
pop
line 675
;675:	trap_AddCommand ("noclip");
ADDRGP4 $487
ARGP4
ADDRGP4 trap_AddCommand
CALLV
pop
line 676
;676:	trap_AddCommand ("team");
ADDRGP4 $488
ARGP4
ADDRGP4 trap_AddCommand
CALLV
pop
line 677
;677:	trap_AddCommand ("follow");
ADDRGP4 $489
ARGP4
ADDRGP4 trap_AddCommand
CALLV
pop
line 678
;678:	trap_AddCommand ("levelshot");
ADDRGP4 $490
ARGP4
ADDRGP4 trap_AddCommand
CALLV
pop
line 679
;679:	trap_AddCommand ("addbot");
ADDRGP4 $491
ARGP4
ADDRGP4 trap_AddCommand
CALLV
pop
line 680
;680:	trap_AddCommand ("setviewpos");
ADDRGP4 $492
ARGP4
ADDRGP4 trap_AddCommand
CALLV
pop
line 681
;681:	trap_AddCommand ("callvote");
ADDRGP4 $493
ARGP4
ADDRGP4 trap_AddCommand
CALLV
pop
line 682
;682:	trap_AddCommand ("vote");
ADDRGP4 $494
ARGP4
ADDRGP4 trap_AddCommand
CALLV
pop
line 683
;683:	trap_AddCommand ("callteamvote");
ADDRGP4 $495
ARGP4
ADDRGP4 trap_AddCommand
CALLV
pop
line 684
;684:	trap_AddCommand ("teamvote");
ADDRGP4 $496
ARGP4
ADDRGP4 trap_AddCommand
CALLV
pop
line 685
;685:	trap_AddCommand ("stats");
ADDRGP4 $497
ARGP4
ADDRGP4 trap_AddCommand
CALLV
pop
line 686
;686:	trap_AddCommand ("teamtask");
ADDRGP4 $498
ARGP4
ADDRGP4 trap_AddCommand
CALLV
pop
line 687
;687:	trap_AddCommand ("loaddefered");	// spelled wrong, but not changing for demo
ADDRGP4 $499
ARGP4
ADDRGP4 trap_AddCommand
CALLV
pop
line 691
;688:
;689:   // adnan
;690:   // tie fighter vehicles
;691:   trap_AddCommand ("vehicleSpawn");
ADDRGP4 $500
ARGP4
ADDRGP4 trap_AddCommand
CALLV
pop
line 692
;692:   trap_AddCommand ("vehicleSpawnCG");
ADDRGP4 $501
ARGP4
ADDRGP4 trap_AddCommand
CALLV
pop
line 693
;693:   trap_AddCommand ("vehicles");
ADDRGP4 $502
ARGP4
ADDRGP4 trap_AddCommand
CALLV
pop
line 694
;694:   trap_AddCommand ("vehiclesCG");
ADDRGP4 $433
ARGP4
ADDRGP4 trap_AddCommand
CALLV
pop
line 695
;695:   trap_AddCommand ("vehicleTemplatesG");
ADDRGP4 $503
ARGP4
ADDRGP4 trap_AddCommand
CALLV
pop
line 696
;696:   trap_AddCommand ("vehicleTemplatesCG");
ADDRGP4 $432
ARGP4
ADDRGP4 trap_AddCommand
CALLV
pop
line 697
;697:}
LABELV $442
endproc CG_InitConsoleCommands 4 4
import menuScoreboard
import VehicleTemplateArray_OutputTemplates
import VehicleArray_RemoveVehicleForId
import VehicleArray_AddVehicle
import VehicleArray_SetVehicleForId
import VehicleArray_GetVehicleForId
import VehicleArray_InitVehicleArray
import Cmd_Vehicles_f
import Cmd_VehicleTemplates_f
import Cmd_SpawnVehicle_f
import CG_Vehicle
import trap_SP_Register
import trap_SP_RegisterServer
import trap_PC_RemoveAllGlobalDefines
import trap_PC_LoadGlobalDefines
import trap_PC_SourceFileAndLine
import trap_PC_ReadToken
import trap_PC_FreeSource
import trap_PC_LoadSource
import trap_PC_AddGlobalDefine
import Controls_SetConfig
import Controls_GetConfig
import UI_OutOfMemory
import UI_InitMemory
import UI_Alloc
import Display_CacheAll
import Menu_SetFeederSelection
import Menu_Paint
import Menus_CloseAll
import LerpColor
import Display_HandleKey
import Menus_CloseByName
import Menus_ShowByName
import Menus_FindByName
import Menus_OpenByName
import Display_KeyBindPending
import Display_CursorType
import Display_MouseMove
import Display_CaptureItem
import Display_GetContext
import Menus_Activate
import Menus_AnyFullScreenVisible
import Menu_Reset
import Menus_ActivateByName
import Menu_PaintAll
import Menu_New
import Menu_Count
import PC_Script_Parse
import PC_String_Parse
import PC_Rect_Parse
import PC_Int_Parse
import PC_Color_Parse
import PC_Float_Parse
import Script_Parse
import String_Parse
import Rect_Parse
import Int_Parse
import Color_Parse
import Float_Parse
import Menu_ScrollFeeder
import Menu_HandleMouseMove
import Menu_HandleKey
import Menu_GetFocused
import Menu_PostParse
import Item_Init
import Menu_Init
import Display_ExpandMacros
import Init_Display
import String_Report
import String_Init
import String_Alloc
import g2WeaponInstances
import CG_CheckPlayerG2Weapons
import CG_CopyG2WeaponInstance
import CG_ShutDownG2Weapons
import CG_InitG2Weapons
import CG_CreateBBRefEnts
import CG_SetGhoul2Info
import CG_Init_CGents
import CG_Init_CG
import trap_G2API_SetNewOrigin
import trap_G2API_SetSurfaceOnOff
import trap_G2API_SetRootSurface
import trap_G2API_SetBoneAnim
import trap_G2API_GetGLAName
import trap_G2API_SetBoneAngles
import trap_G2API_CleanGhoul2Models
import trap_G2API_SetBoltInfo
import trap_G2API_AddBolt
import trap_G2API_RemoveGhoul2Model
import trap_G2API_HasGhoul2ModelOnIndex
import trap_G2API_DuplicateGhoul2Instance
import trap_G2API_CopySpecificGhoul2Model
import trap_G2API_CopyGhoul2Instance
import trap_G2API_GiveMeVectorFromMatrix
import trap_G2API_InitGhoul2Model
import trap_G2API_GetBoltMatrix_NoRecNoRot
import trap_G2API_GetBoltMatrix_NoReconstruct
import trap_G2API_GetBoltMatrix
import trap_G2_HaveWeGhoul2Models
import trap_G2_SetGhoul2ModelIndexes
import trap_G2_ListModelBones
import trap_G2_ListModelSurfaces
import trap_G2API_CollisionDetect
import FX_ForceDrained
import FX_TieLaserAltFireThink
import FX_TieLaserWeaponHitPlayer
import FX_TieLaserWeaponHitWall
import FX_TieLaserProjectileThink
import FX_BlasterWeaponHitPlayer
import FX_BlasterWeaponHitWall
import FX_BlasterAltFireThink
import FX_BlasterProjectileThink
import FX_BryarAltHitPlayer
import FX_BryarHitPlayer
import FX_BryarAltHitWall
import FX_BryarHitWall
import CG_Spark
import FX_TurretHitPlayer
import FX_TurretHitWall
import FX_TurretProjectileThink
import CG_NewParticleArea
import initparticles
import CG_GetStripEdString
import CG_ParticleExplosion
import CG_ParticleMisc
import CG_ParticleDust
import CG_ParticleSparks
import CG_ParticleBulletDebris
import CG_ParticleSnowFlurry
import CG_AddParticleShrapnel
import CG_ParticleSmoke
import CG_ParticleSnow
import CG_AddParticles
import CG_ClearParticles
import trap_ROFF_Purge_Ent
import trap_ROFF_Play
import trap_ROFF_Cache
import trap_ROFF_UpdateEntities
import trap_ROFF_Clean
import trap_CG_RegisterSharedMemory
import trap_SP_GetStringTextString
import trap_SP_Print
import trap_FX_AddSprite
import trap_FX_AddPrimitive
import trap_FX_AddBezier
import trap_FX_AddPoly
import trap_FX_AdjustTime
import trap_FX_FreeSystem
import trap_FX_InitSystem
import trap_FX_AddScheduledEffects
import trap_FX_PlayBoltedEffectID
import trap_FX_PlayEntityEffectID
import trap_FX_PlayEffectID
import trap_FX_PlaySimpleEffectID
import trap_FX_PlayEntityEffect
import trap_FX_PlayEffect
import trap_FX_PlaySimpleEffect
import trap_FX_RegisterEffect
import trap_R_inPVS
import trap_GetEntityToken
import trap_getCameraInfo
import trap_startCamera
import trap_loadCamera
import trap_SnapVector
import trap_CIN_SetExtents
import trap_CIN_DrawCinematic
import trap_CIN_RunCinematic
import trap_CIN_StopCinematic
import trap_CIN_PlayCinematic
import BG_CycleForce
import BG_ProperForceIndex
import BG_CycleInven
import trap_Key_GetKey
import trap_Key_SetCatcher
import trap_Key_GetCatcher
import trap_Key_IsDown
import trap_MemoryRemaining
import testPrintFloat
import testPrintInt
import trap_OpenUIMenu
import trap_SetClientTurnExtent
import trap_SetClientForceAngle
import trap_SetUserCmdValue
import trap_GetUserCmd
import trap_GetCurrentCmdNumber
import trap_GetServerCommand
import trap_GetSnapshot
import trap_GetCurrentSnapshotNumber
import trap_GetGameState
import trap_GetGlconfig
import trap_FX_AddLine
import trap_R_GetBModelVerts
import trap_R_SetLightStyle
import trap_R_GetLightStyle
import trap_R_RemapShader
import trap_R_DrawRotatePic2
import trap_R_DrawRotatePic
import trap_R_LerpTag
import trap_R_ModelBounds
import trap_R_DrawStretchPic
import trap_R_SetColor
import trap_R_RenderScene
import trap_R_LightForPoint
import trap_R_AddLightToScene
import trap_R_AddPolysToScene
import trap_R_AddPolyToScene
import trap_R_AddRefEntityToScene
import trap_R_ClearScene
import trap_AnyLanguage_ReadCharFromString
import trap_Language_UsesSpaces
import trap_Language_IsAsian
import trap_R_Font_DrawString
import trap_R_Font_HeightPixels
import trap_R_Font_StrLenChars
import trap_R_Font_StrLenPixels
import trap_R_RegisterFont
import trap_R_RegisterShaderNoMip
import trap_R_RegisterShader
import trap_R_RegisterSkin
import trap_R_RegisterModel
import trap_R_LoadWorldMap
import trap_S_StopBackgroundTrack
import trap_S_StartBackgroundTrack
import trap_S_RegisterSound
import trap_S_Respatialize
import trap_S_UpdateEntityPosition
import trap_S_AddRealLoopingSound
import trap_S_AddLoopingSound
import trap_S_ClearLoopingSounds
import trap_S_StartLocalSound
import trap_S_StopLoopingSound
import trap_S_StartSound
import trap_S_MuteSound
import trap_CM_MarkFragments
import trap_CM_TransformedBoxTrace
import trap_CM_BoxTrace
import trap_CM_TransformedPointContents
import trap_CM_PointContents
import trap_CM_TempBoxModel
import trap_CM_InlineModel
import trap_CM_NumInlineModels
import trap_CM_LoadMap
import trap_UpdateScreen
import trap_SendClientCommand
import trap_AddCommand
import trap_SendConsoleCommand
import trap_FS_FCloseFile
import trap_FS_Write
import trap_FS_Read
import trap_FS_FOpenFile
import trap_Args
import trap_Argv
import trap_Argc
import trap_Cvar_VariableStringBuffer
import trap_Cvar_Set
import trap_Cvar_Update
import trap_Cvar_Register
import trap_Milliseconds
import trap_Error
import trap_Print
import CG_SagaObjectiveCompleted
import CG_SagaRoundOver
import CG_InitSagaMode
import CG_CheckChangedPredictableEvents
import CG_TransitionPlayerState
import CG_Respawn
import CG_IsMindTricked
import CG_PlayBufferedVoiceChats
import CG_VoiceChatLocal
import CG_ShaderStateChanged
import CG_LoadVoiceChats
import CG_SetConfigValues
import CG_ParseServerinfo
import CG_ExecuteNewServerCommands
import CG_DrawOldTourneyScoreboard
import CG_DrawOldScoreboard
import CG_DrawInformation
import CG_LoadingClient
import CG_LoadingItem
import CG_LoadingString
import CG_ProcessSnapshots
import CG_InitGlass
import CG_TestLine
import CG_SurfaceExplosion
import CG_MakeExplosion
import CG_Bleed
import CG_ScorePlum
import CG_CreateDebris
import CG_GlassShatter
import CG_BubbleTrail
import CG_SmokePuff
import CG_AddLocalEntities
import CG_AllocLocalEntity
import CG_InitLocalEntities
import CG_ImpactMark
import CG_AddMarks
import CG_InitMarkPolys
import CG_OutOfAmmoChange
import CG_DrawIconBackground
import CG_DrawWeaponSelect
import CG_AddPlayerWeapon
import CG_AddViewWeapon
import CG_MissileHitPlayer
import CG_MissileHitWall
import CG_FireWeapon
import CG_RegisterItemVisuals
import CG_RegisterWeapon
import CG_Weapon_f
import CG_PrevWeapon_f
import CG_NextWeapon_f
import CG_GetClientWeaponMuzzleBoltPoint
import TurretClientRun
import ScaleModelAxis
import CG_PositionRotatedEntityOnTag
import CG_PositionEntityOnTag
import CG_AdjustPositionForMover
import CG_Beam
import CG_ManualEntityRender
import CG_AddPacketEntities
import CG_SetEntitySoundPosition
import CG_ReattachLimb
import CG_PainEvent
import CG_EntityEvent
import CG_PlaceString
import CG_CheckEvents
import CG_LoadDeferredPlayers
import CG_PredictPlayerState
import CG_Trace
import CG_PointContents
import CG_BuildSolidList
import CG_PlayerShieldHit
import CG_CustomSound
import CG_NewClientInfo
import CG_AddRefEntityWithPowerups
import CG_ResetPlayerEntity
import CG_Player
import CG_StatusHandle
import CG_OtherTeamHasFlag
import CG_YourTeamHasFlag
import CG_GameTypeString
import CG_CheckOrderPending
import CG_Text_PaintChar
import CG_Draw3DModel
import CG_GetKillerText
import CG_GetGameStatusText
import CG_GetTeamColor
import CG_InitTeamChat
import CG_SetPrintString
import CG_ShowResponseHead
import CG_DeferMenuScript
import CG_RunMenuScript
import CG_OwnerDrawVisible
import CG_GetValue
import CG_SelectNextPlayer
import CG_SelectPrevPlayer
import CG_Text_Height
import CG_Text_Width
import CG_Text_Paint
import CG_OwnerDraw
import CG_DrawTeamBackground
import CG_DrawFlagModel
import CG_DrawActive
import CG_DrawHead
import CG_CenterPrint
import CG_AddLagometerSnapshotInfo
import CG_AddLagometerFrameInfo
import teamChat2
import teamChat1
import systemChat
import drawTeamOverlayModificationCount
import numSortedTeamPlayers
import sortedTeamPlayers
import CG_DrawTopBottom
import CG_DrawSides
import CG_DrawRect
import UI_DrawScaledProportionalString
import UI_DrawProportionalString
import CG_GetColorForHealth
import CG_ColorForHealth
import CG_TileClear
import CG_TeamColor
import CG_FadeColor
import CG_DrawStrlen
import CG_DrawSmallStringColor
import CG_DrawSmallString
import CG_DrawBigStringColor
import CG_DrawBigString
import CG_DrawStringExt
import CG_DrawNumField
import CG_DrawString
import CG_DrawRotatePic2
import CG_DrawRotatePic
import CG_DrawPic
import CG_FillRect
import CG_TestModelAnimate_f
import CG_TestModelSetAnglespost_f
import CG_TestModelSetAnglespre_f
import CG_ListModelBones_f
import CG_ListModelSurfaces_f
import CG_TestModelSurfaceOnOff_f
import CG_TestG2Model_f
import CG_DrawActiveFrame
import CG_AddBufferedSound
import CG_ZoomUp_f
import CG_ZoomDown_f
import CG_TestModelPrevSkin_f
import CG_TestModelNextSkin_f
import CG_TestModelPrevFrame_f
import CG_TestModelNextFrame_f
import CG_TestGun_f
import CG_TestModel_f
import CG_PrevForcePower_f
import CG_NextForcePower_f
import CG_PrevInventory_f
import CG_NextInventory_f
import CG_BuildSpectatorString
import CG_SetScoreSelection
import CG_RankRunFrame
import CG_EventHandling
import CG_MouseEvent
import CG_KeyEvent
import CG_LoadMenus
import CG_LastAttacker
import CG_CrosshairPlayer
import CG_UpdateCvars
import CG_StartMusic
import CG_Error
import CG_Printf
import CG_Argv
import CG_ConfigString
import cg_followCamTransition
import cg_followCam
import cg_roll
import cg_throttle
import cg_debugBB
import ui_myteam
import cg_recordSPDemoName
import cg_recordSPDemo
import cg_singlePlayerActive
import cg_enableBreath
import cg_enableDust
import cg_singlePlayer
import cg_currentSelectedPlayerName
import cg_currentSelectedPlayer
import cg_blueTeamName
import cg_redTeamName
import cg_trueLightning
import cg_noProjectileTrail
import cg_noTaunt
import cg_bigFont
import cg_smallFont
import cg_cameraMode
import cg_timescale
import cg_timescaleFadeSpeed
import cg_timescaleFadeEnd
import cg_cameraOrbitDelay
import cg_cameraOrbit
import pmove_msec
import pmove_fixed
import cg_smoothClients
import cg_hudFiles
import cg_scorePlum
import cg_noVoiceText
import cg_noVoiceChats
import cg_teamChatsOnly
import cg_drawFriend
import cg_deferPlayers
import cg_predictItems
import cg_blood
import cg_paused
import cg_buildScript
import cg_forceModel
import cg_stats
import cg_teamChatHeight
import cg_teamChatTime
import cg_synchronousClients
import cg_drawEnemyInfo
import cg_lagometer
import cg_stereoSeparation
import cg_thirdPersonHorzOffset
import cg_thirdPersonAlpha
import cg_thirdPersonTargetDamp
import cg_thirdPersonCameraDamp
import cg_thirdPersonVertOffset
import cg_thirdPersonPitchOffset
import cg_thirdPersonAngle
import cg_thirdPersonRange
import cg_thirdPerson
import cg_dismember
import cg_animBlend
import cg_auraShell
import cg_speedTrail
import cg_duelHeadAngles
import cg_saberTrail
import cg_saberContact
import cg_saberDynamicMarkTime
import cg_saberDynamicMarks
import cg_fpls
import cg_saberModelTraceEffect
import cg_oldPainSounds
import cg_swingAngles
import cg_zoomFov
import cg_fov
import cg_simpleItems
import cg_ignore
import cg_autoswitch
import cg_tracerLength
import cg_tracerWidth
import cg_tracerChance
import cg_viewsize
import cg_drawGun
import cg_gun_z
import cg_gun_y
import cg_gun_x
import cg_gun_frame
import cg_addMarks
import cg_footsteps
import cg_showmiss
import cg_noPlayerAnims
import cg_nopredict
import cg_errorDecay
import cg_debugEvents
import cg_debugPosition
import cg_debugAnim
import cg_animSpeed
import cg_draw2D
import cg_drawStatus
import cg_crosshairHealth
import cg_crosshairSize
import cg_crosshairY
import cg_crosshairX
import cg_teamOverlayUserinfo
import cg_drawTeamOverlay
import cg_drawRewards
import cg_dynamicCrosshair
import cg_drawScores
import cg_drawCrosshairNames
import cg_drawCrosshair
import cg_drawAmmoWarning
import cg_drawIcons
import cg_draw3dIcons
import cg_drawSnapshot
import cg_drawFPS
import cg_drawTimer
import cg_shadows
import cg_bobroll
import cg_bobpitch
import cg_bobup
import cg_runroll
import cg_runpitch
import cg_centertime
import cg_vehicleTemplates
import cg_vehicles
import VehicleInfo_GetNameForMovementType
import VehicleInfo_GetBitForMovementType
import VehicleInfo_GetNameForWeapon
import VehicleInfo_GetIndexForWeapon
import VehicleInfo_GetBitForWeapon
import VehicleInfo_GetBitForVehicleType
import Vehicle_CopyVehicle
import Vehicle_InitVehicle
import cg_markPolys
import cg_items
import cg_weapons
import cg_entities
import cg
import cgs
import CGCam_SetMusicMult
import CGCam_Shake
import cgScreenEffects
import ammoTicPos
import forceTicPos
import forcePowerDarkLight
import WeaponAttackAnim
import WeaponReadyAnim
import BG_OutOfMemory
import BG_StringAlloc
import BG_TempFree
import BG_TempAlloc
import BG_AllocUnaligned
import BG_Alloc
import BG_CanUseFPNow
import BG_HasYsalamiri
import BG_GetItemIndexByTag
import BG_ParseAnimationFile
import BG_PlayerTouchesItem
import BG_PlayerStateToEntityStateExtraPolate
import BG_PlayerStateToEntityState
import BG_TouchJumpPad
import BG_AddPredictableEventToPlayerstate
import BG_EvaluateTrajectoryDelta
import BG_EvaluateTrajectory
import BG_ForcePowerDrain
import BG_SaberStartTransAnim
import BG_InDeathAnim
import BG_InRoll
import BG_KnockawayForParry
import BG_BrokenParryForParry
import BG_BrokenParryForAttack
import BG_SaberInSpecialAttack
import BG_SpinningSaberAnim
import BG_FlippingAnim
import BG_SaberInIdle
import BG_SaberInSpecial
import BG_SaberInAttack
import BG_DirectFlippingAnim
import BG_InSaberStandAnim
import BG_InSpecialJump
import BG_LegalizedForcePowers
import saberMoveData
import BG_CanItemBeGrabbed
import BG_FindItemForHoldable
import BG_FindItemForPowerup
import BG_FindItemForWeapon
import BG_FindItem
import vectoyaw
import bg_numItems
import bg_itemlist
import PM_CalculateRelativeViewAngles
import Pmove
import PM_QuaternionViewAngles
import PM_UpdateViewAngles
import pm
import bgForcePowerCost
import forceMasteryPoints
import forceMasteryLevels
import bgGlobalAnimations
import BGPAFtextLoaded
import forcePowerSorted
import WP_MuzzlePoint
import ammoData
import weaponData
import GetStringForID
import GetIDForString
import Q_irand
import irand
import flrand
import Rand_Init
import Com_Printf
import Com_Error
import Info_NextPair
import Info_Validate
import Info_SetValueForKey_Big
import Info_SetValueForKey
import Info_RemoveKey_big
import Info_RemoveKey
import Info_ValueForKey
import va
import Q_CleanStr
import Q_PrintStrlen
import Q_strcat
import Q_strncpyz
import Q_strrchr
import Q_strupr
import Q_strlwr
import Q_stricmpn
import Q_strncmp
import Q_stricmp
import Q_isalpha
import Q_isupper
import Q_islower
import Q_isprint
import Com_sprintf
import Parse3DMatrix
import Parse2DMatrix
import Parse1DMatrix
import SkipRestOfLine
import SkipBracedSection
import COM_MatchToken
import COM_ParseVec4
import COM_ParseFloat
import COM_ParseInt
import COM_ParseString
import COM_ParseWarning
import COM_ParseError
import COM_Compress
import COM_ParseExt
import COM_Parse
import SkipWhitespace
import COM_GetCurrentParseLine
import COM_BeginParseSession
import COM_DefaultExtension
import COM_StripExtension
import COM_SkipPath
import Com_Clamp
import MatrixToEuler
import QuatToAngles
import QuatMul
import AnglesToQuat
import AxisToQuaternion
import QuaternionToAxis
import QuaternionToEuler
import QuatToAxis
import QuaternionMultiply
import QuaternionNormalize
import QuaternionMagnitude
import QuaternionFromString
import AnglesToTieFloats
import AnglesFromTieFloats
import QuaternionToTieFloats
import QuaternionFromTieFloats
import QuaternionCopy
import PerpendicularVector
import AngleVectors
import RotationMatrixAroundDir
import MatrixMultiply
import MakeNormalVectors
import RotateAroundDirection
import RotatePointAroundVector
import ProjectPointOnPlane
import PlaneFromPoints
import AngleDelta
import AngleNormalize180
import AngleNormalize360
import AnglesSubtract
import AngleSubtract
import LerpAngle
import AngleMod
import BoxOnPlaneSide
import SetPlaneSignbits
import AxisCopy
import AxisClear
import AnglesToAxis
import vectoangles
import Q_crandom
import Q_random
import Q_rand
import Q_acos
import Q_log2
import VectorRotate
import Vector4Scale
import VectorNormalize2
import VectorNormalize
import CrossProduct
import VectorInverse
import VectorNormalizeFast
import DistanceSquared
import Distance
import VectorLengthSquared
import VectorLength
import VectorCompare
import AddPointToBounds
import ClearBounds
import RadiusFromBounds
import NormalizeColor
import ColorBytes4
import ColorBytes3
import _VectorMA
import _VectorScale
import _VectorCopy
import _VectorAdd
import _VectorSubtract
import _DotProduct
import ByteToDir
import DirToByte
import powf
import ClampShort
import ClampChar
import Q_rsqrt
import Q_fabs
import axisDefault
import vec3_origin
import g_color_table
import colorDkBlue
import colorLtBlue
import colorDkGrey
import colorMdGrey
import colorLtGrey
import colorWhite
import colorCyan
import colorMagenta
import colorYellow
import colorBlue
import colorGreen
import colorRed
import colorBlack
import colorTable
import bytedirs
import Com_Memcpy
import Com_Memset
import Hunk_Alloc
import forceSpeedLevels
import FloatSwap
import LongSwap
import ShortSwap
import acos
import fabs
import abs
import tan
import atan2
import cos
import sin
import sqrt
import floor
import ceil
import memcpy
import memset
import memmove
import sscanf
import vsprintf
import _atoi
import atoi
import _atof
import atof
import toupper
import tolower
import strncpy
import strstr
import strchr
import strcmp
import strcpy
import strcat
import strlen
import rand
import srand
import qsort
lit
align 1
LABELV $503
byte 1 118
byte 1 101
byte 1 104
byte 1 105
byte 1 99
byte 1 108
byte 1 101
byte 1 84
byte 1 101
byte 1 109
byte 1 112
byte 1 108
byte 1 97
byte 1 116
byte 1 101
byte 1 115
byte 1 71
byte 1 0
align 1
LABELV $502
byte 1 118
byte 1 101
byte 1 104
byte 1 105
byte 1 99
byte 1 108
byte 1 101
byte 1 115
byte 1 0
align 1
LABELV $501
byte 1 118
byte 1 101
byte 1 104
byte 1 105
byte 1 99
byte 1 108
byte 1 101
byte 1 83
byte 1 112
byte 1 97
byte 1 119
byte 1 110
byte 1 67
byte 1 71
byte 1 0
align 1
LABELV $500
byte 1 118
byte 1 101
byte 1 104
byte 1 105
byte 1 99
byte 1 108
byte 1 101
byte 1 83
byte 1 112
byte 1 97
byte 1 119
byte 1 110
byte 1 0
align 1
LABELV $499
byte 1 108
byte 1 111
byte 1 97
byte 1 100
byte 1 100
byte 1 101
byte 1 102
byte 1 101
byte 1 114
byte 1 101
byte 1 100
byte 1 0
align 1
LABELV $498
byte 1 116
byte 1 101
byte 1 97
byte 1 109
byte 1 116
byte 1 97
byte 1 115
byte 1 107
byte 1 0
align 1
LABELV $497
byte 1 115
byte 1 116
byte 1 97
byte 1 116
byte 1 115
byte 1 0
align 1
LABELV $496
byte 1 116
byte 1 101
byte 1 97
byte 1 109
byte 1 118
byte 1 111
byte 1 116
byte 1 101
byte 1 0
align 1
LABELV $495
byte 1 99
byte 1 97
byte 1 108
byte 1 108
byte 1 116
byte 1 101
byte 1 97
byte 1 109
byte 1 118
byte 1 111
byte 1 116
byte 1 101
byte 1 0
align 1
LABELV $494
byte 1 118
byte 1 111
byte 1 116
byte 1 101
byte 1 0
align 1
LABELV $493
byte 1 99
byte 1 97
byte 1 108
byte 1 108
byte 1 118
byte 1 111
byte 1 116
byte 1 101
byte 1 0
align 1
LABELV $492
byte 1 115
byte 1 101
byte 1 116
byte 1 118
byte 1 105
byte 1 101
byte 1 119
byte 1 112
byte 1 111
byte 1 115
byte 1 0
align 1
LABELV $491
byte 1 97
byte 1 100
byte 1 100
byte 1 98
byte 1 111
byte 1 116
byte 1 0
align 1
LABELV $490
byte 1 108
byte 1 101
byte 1 118
byte 1 101
byte 1 108
byte 1 115
byte 1 104
byte 1 111
byte 1 116
byte 1 0
align 1
LABELV $489
byte 1 102
byte 1 111
byte 1 108
byte 1 108
byte 1 111
byte 1 119
byte 1 0
align 1
LABELV $488
byte 1 116
byte 1 101
byte 1 97
byte 1 109
byte 1 0
align 1
LABELV $487
byte 1 110
byte 1 111
byte 1 99
byte 1 108
byte 1 105
byte 1 112
byte 1 0
align 1
LABELV $486
byte 1 110
byte 1 111
byte 1 116
byte 1 97
byte 1 114
byte 1 103
byte 1 101
byte 1 116
byte 1 0
align 1
LABELV $485
byte 1 103
byte 1 111
byte 1 100
byte 1 0
align 1
LABELV $484
byte 1 103
byte 1 105
byte 1 118
byte 1 101
byte 1 0
align 1
LABELV $483
byte 1 118
byte 1 111
byte 1 116
byte 1 101
byte 1 108
byte 1 108
byte 1 0
align 1
LABELV $482
byte 1 118
byte 1 111
byte 1 115
byte 1 97
byte 1 121
byte 1 95
byte 1 116
byte 1 101
byte 1 97
byte 1 109
byte 1 0
align 1
LABELV $481
byte 1 118
byte 1 111
byte 1 115
byte 1 97
byte 1 121
byte 1 0
align 1
LABELV $480
byte 1 118
byte 1 116
byte 1 97
byte 1 117
byte 1 110
byte 1 116
byte 1 0
align 1
LABELV $479
byte 1 118
byte 1 116
byte 1 101
byte 1 108
byte 1 108
byte 1 0
align 1
LABELV $478
byte 1 118
byte 1 115
byte 1 97
byte 1 121
byte 1 95
byte 1 116
byte 1 101
byte 1 97
byte 1 109
byte 1 0
align 1
LABELV $477
byte 1 118
byte 1 115
byte 1 97
byte 1 121
byte 1 0
align 1
LABELV $476
byte 1 116
byte 1 101
byte 1 108
byte 1 108
byte 1 0
align 1
LABELV $475
byte 1 115
byte 1 97
byte 1 121
byte 1 95
byte 1 116
byte 1 101
byte 1 97
byte 1 109
byte 1 0
align 1
LABELV $474
byte 1 115
byte 1 97
byte 1 121
byte 1 0
align 1
LABELV $473
byte 1 107
byte 1 105
byte 1 108
byte 1 108
byte 1 0
align 1
LABELV $472
byte 1 115
byte 1 97
byte 1 98
byte 1 101
byte 1 114
byte 1 65
byte 1 116
byte 1 116
byte 1 97
byte 1 99
byte 1 107
byte 1 67
byte 1 121
byte 1 99
byte 1 108
byte 1 101
byte 1 0
align 1
LABELV $471
byte 1 98
byte 1 111
byte 1 116
byte 1 95
byte 1 111
byte 1 114
byte 1 100
byte 1 101
byte 1 114
byte 1 0
align 1
LABELV $470
byte 1 117
byte 1 115
byte 1 101
byte 1 95
byte 1 115
byte 1 101
byte 1 110
byte 1 116
byte 1 114
byte 1 121
byte 1 0
align 1
LABELV $469
byte 1 122
byte 1 111
byte 1 111
byte 1 109
byte 1 0
align 1
LABELV $468
byte 1 117
byte 1 115
byte 1 101
byte 1 95
byte 1 101
byte 1 108
byte 1 101
byte 1 99
byte 1 116
byte 1 114
byte 1 111
byte 1 98
byte 1 105
byte 1 110
byte 1 111
byte 1 99
byte 1 117
byte 1 108
byte 1 97
byte 1 114
byte 1 115
byte 1 0
align 1
LABELV $467
byte 1 117
byte 1 115
byte 1 101
byte 1 95
byte 1 98
byte 1 97
byte 1 99
byte 1 116
byte 1 97
byte 1 0
align 1
LABELV $466
byte 1 117
byte 1 115
byte 1 101
byte 1 95
byte 1 102
byte 1 105
byte 1 101
byte 1 108
byte 1 100
byte 1 0
align 1
LABELV $465
byte 1 117
byte 1 115
byte 1 101
byte 1 95
byte 1 115
byte 1 101
byte 1 101
byte 1 107
byte 1 101
byte 1 114
byte 1 0
align 1
LABELV $464
byte 1 102
byte 1 111
byte 1 114
byte 1 99
byte 1 101
byte 1 95
byte 1 115
byte 1 101
byte 1 101
byte 1 105
byte 1 110
byte 1 103
byte 1 0
align 1
LABELV $463
byte 1 102
byte 1 111
byte 1 114
byte 1 99
byte 1 101
byte 1 95
byte 1 102
byte 1 111
byte 1 114
byte 1 99
byte 1 101
byte 1 112
byte 1 111
byte 1 119
byte 1 101
byte 1 114
byte 1 111
byte 1 116
byte 1 104
byte 1 101
byte 1 114
byte 1 0
align 1
LABELV $462
byte 1 102
byte 1 111
byte 1 114
byte 1 99
byte 1 101
byte 1 95
byte 1 104
byte 1 101
byte 1 97
byte 1 108
byte 1 111
byte 1 116
byte 1 104
byte 1 101
byte 1 114
byte 1 0
align 1
LABELV $461
byte 1 102
byte 1 111
byte 1 114
byte 1 99
byte 1 101
byte 1 95
byte 1 97
byte 1 98
byte 1 115
byte 1 111
byte 1 114
byte 1 98
byte 1 0
align 1
LABELV $460
byte 1 102
byte 1 111
byte 1 114
byte 1 99
byte 1 101
byte 1 95
byte 1 112
byte 1 114
byte 1 111
byte 1 116
byte 1 101
byte 1 99
byte 1 116
byte 1 0
align 1
LABELV $459
byte 1 102
byte 1 111
byte 1 114
byte 1 99
byte 1 101
byte 1 95
byte 1 114
byte 1 97
byte 1 103
byte 1 101
byte 1 0
align 1
LABELV $458
byte 1 102
byte 1 111
byte 1 114
byte 1 99
byte 1 101
byte 1 95
byte 1 100
byte 1 105
byte 1 115
byte 1 116
byte 1 114
byte 1 97
byte 1 99
byte 1 116
byte 1 0
align 1
LABELV $457
byte 1 102
byte 1 111
byte 1 114
byte 1 99
byte 1 101
byte 1 95
byte 1 112
byte 1 117
byte 1 108
byte 1 108
byte 1 0
align 1
LABELV $456
byte 1 102
byte 1 111
byte 1 114
byte 1 99
byte 1 101
byte 1 95
byte 1 116
byte 1 104
byte 1 114
byte 1 111
byte 1 119
byte 1 0
align 1
LABELV $455
byte 1 102
byte 1 111
byte 1 114
byte 1 99
byte 1 101
byte 1 95
byte 1 115
byte 1 112
byte 1 101
byte 1 101
byte 1 100
byte 1 0
align 1
LABELV $454
byte 1 102
byte 1 111
byte 1 114
byte 1 99
byte 1 101
byte 1 95
byte 1 104
byte 1 101
byte 1 97
byte 1 108
byte 1 0
align 1
LABELV $453
byte 1 101
byte 1 110
byte 1 103
byte 1 97
byte 1 103
byte 1 101
byte 1 95
byte 1 100
byte 1 117
byte 1 101
byte 1 108
byte 1 0
align 1
LABELV $452
byte 1 115
byte 1 118
byte 1 95
byte 1 115
byte 1 97
byte 1 98
byte 1 101
byte 1 114
byte 1 115
byte 1 119
byte 1 105
byte 1 116
byte 1 99
byte 1 104
byte 1 0
align 1
LABELV $451
byte 1 115
byte 1 118
byte 1 95
byte 1 102
byte 1 111
byte 1 114
byte 1 99
byte 1 101
byte 1 112
byte 1 114
byte 1 101
byte 1 118
byte 1 0
align 1
LABELV $450
byte 1 115
byte 1 118
byte 1 95
byte 1 102
byte 1 111
byte 1 114
byte 1 99
byte 1 101
byte 1 110
byte 1 101
byte 1 120
byte 1 116
byte 1 0
align 1
LABELV $449
byte 1 115
byte 1 118
byte 1 95
byte 1 105
byte 1 110
byte 1 118
byte 1 112
byte 1 114
byte 1 101
byte 1 118
byte 1 0
align 1
LABELV $448
byte 1 115
byte 1 118
byte 1 95
byte 1 105
byte 1 110
byte 1 118
byte 1 110
byte 1 101
byte 1 120
byte 1 116
byte 1 0
align 1
LABELV $447
byte 1 102
byte 1 111
byte 1 114
byte 1 99
byte 1 101
byte 1 99
byte 1 104
byte 1 97
byte 1 110
byte 1 103
byte 1 101
byte 1 100
byte 1 0
align 1
LABELV $433
byte 1 118
byte 1 101
byte 1 104
byte 1 105
byte 1 99
byte 1 108
byte 1 101
byte 1 115
byte 1 67
byte 1 71
byte 1 0
align 1
LABELV $432
byte 1 118
byte 1 101
byte 1 104
byte 1 105
byte 1 99
byte 1 108
byte 1 101
byte 1 84
byte 1 101
byte 1 109
byte 1 112
byte 1 108
byte 1 97
byte 1 116
byte 1 101
byte 1 115
byte 1 67
byte 1 71
byte 1 0
align 1
LABELV $431
byte 1 43
byte 1 98
byte 1 117
byte 1 116
byte 1 116
byte 1 111
byte 1 110
byte 1 49
byte 1 53
byte 1 0
align 1
LABELV $430
byte 1 43
byte 1 98
byte 1 117
byte 1 116
byte 1 116
byte 1 111
byte 1 110
byte 1 49
byte 1 52
byte 1 0
align 1
LABELV $429
byte 1 43
byte 1 98
byte 1 117
byte 1 116
byte 1 116
byte 1 111
byte 1 110
byte 1 49
byte 1 51
byte 1 0
align 1
LABELV $428
byte 1 43
byte 1 98
byte 1 117
byte 1 116
byte 1 116
byte 1 111
byte 1 110
byte 1 49
byte 1 50
byte 1 0
align 1
LABELV $427
byte 1 45
byte 1 114
byte 1 111
byte 1 108
byte 1 108
byte 1 108
byte 1 101
byte 1 102
byte 1 116
byte 1 0
align 1
LABELV $426
byte 1 43
byte 1 114
byte 1 111
byte 1 108
byte 1 108
byte 1 108
byte 1 101
byte 1 102
byte 1 116
byte 1 0
align 1
LABELV $425
byte 1 45
byte 1 114
byte 1 111
byte 1 108
byte 1 108
byte 1 114
byte 1 105
byte 1 103
byte 1 104
byte 1 116
byte 1 0
align 1
LABELV $424
byte 1 43
byte 1 114
byte 1 111
byte 1 108
byte 1 108
byte 1 114
byte 1 105
byte 1 103
byte 1 104
byte 1 116
byte 1 0
align 1
LABELV $423
byte 1 116
byte 1 104
byte 1 114
byte 1 111
byte 1 116
byte 1 116
byte 1 108
byte 1 101
byte 1 100
byte 1 111
byte 1 119
byte 1 110
byte 1 0
align 1
LABELV $422
byte 1 116
byte 1 104
byte 1 114
byte 1 111
byte 1 116
byte 1 116
byte 1 108
byte 1 101
byte 1 117
byte 1 112
byte 1 0
align 1
LABELV $421
byte 1 45
byte 1 116
byte 1 104
byte 1 114
byte 1 111
byte 1 116
byte 1 116
byte 1 108
byte 1 101
byte 1 113
byte 1 117
byte 1 105
byte 1 99
byte 1 107
byte 1 0
align 1
LABELV $420
byte 1 43
byte 1 116
byte 1 104
byte 1 114
byte 1 111
byte 1 116
byte 1 116
byte 1 108
byte 1 101
byte 1 113
byte 1 117
byte 1 105
byte 1 99
byte 1 107
byte 1 0
align 1
LABELV $419
byte 1 102
byte 1 111
byte 1 114
byte 1 99
byte 1 101
byte 1 112
byte 1 114
byte 1 101
byte 1 118
byte 1 0
align 1
LABELV $418
byte 1 102
byte 1 111
byte 1 114
byte 1 99
byte 1 101
byte 1 110
byte 1 101
byte 1 120
byte 1 116
byte 1 0
align 1
LABELV $417
byte 1 105
byte 1 110
byte 1 118
byte 1 112
byte 1 114
byte 1 101
byte 1 118
byte 1 0
align 1
LABELV $416
byte 1 105
byte 1 110
byte 1 118
byte 1 110
byte 1 101
byte 1 120
byte 1 116
byte 1 0
align 1
LABELV $415
byte 1 108
byte 1 111
byte 1 97
byte 1 100
byte 1 100
byte 1 101
byte 1 102
byte 1 101
byte 1 114
byte 1 114
byte 1 101
byte 1 100
byte 1 0
align 1
LABELV $414
byte 1 115
byte 1 116
byte 1 97
byte 1 114
byte 1 116
byte 1 79
byte 1 114
byte 1 98
byte 1 105
byte 1 116
byte 1 0
align 1
LABELV $413
byte 1 115
byte 1 99
byte 1 111
byte 1 114
byte 1 101
byte 1 115
byte 1 85
byte 1 112
byte 1 0
align 1
LABELV $412
byte 1 115
byte 1 99
byte 1 111
byte 1 114
byte 1 101
byte 1 115
byte 1 68
byte 1 111
byte 1 119
byte 1 110
byte 1 0
align 1
LABELV $411
byte 1 115
byte 1 112
byte 1 76
byte 1 111
byte 1 115
byte 1 101
byte 1 0
align 1
LABELV $410
byte 1 115
byte 1 112
byte 1 87
byte 1 105
byte 1 110
byte 1 0
align 1
LABELV $409
byte 1 116
byte 1 97
byte 1 117
byte 1 110
byte 1 116
byte 1 71
byte 1 97
byte 1 117
byte 1 110
byte 1 116
byte 1 108
byte 1 101
byte 1 116
byte 1 0
align 1
LABELV $408
byte 1 116
byte 1 97
byte 1 117
byte 1 110
byte 1 116
byte 1 68
byte 1 101
byte 1 97
byte 1 116
byte 1 104
byte 1 73
byte 1 110
byte 1 115
byte 1 117
byte 1 108
byte 1 116
byte 1 0
align 1
LABELV $407
byte 1 116
byte 1 97
byte 1 117
byte 1 110
byte 1 116
byte 1 84
byte 1 97
byte 1 117
byte 1 110
byte 1 116
byte 1 0
align 1
LABELV $406
byte 1 116
byte 1 97
byte 1 117
byte 1 110
byte 1 116
byte 1 80
byte 1 114
byte 1 97
byte 1 105
byte 1 115
byte 1 101
byte 1 0
align 1
LABELV $405
byte 1 116
byte 1 97
byte 1 117
byte 1 110
byte 1 116
byte 1 75
byte 1 105
byte 1 108
byte 1 108
byte 1 73
byte 1 110
byte 1 115
byte 1 117
byte 1 108
byte 1 116
byte 1 0
align 1
LABELV $404
byte 1 116
byte 1 97
byte 1 115
byte 1 107
byte 1 79
byte 1 119
byte 1 110
byte 1 70
byte 1 108
byte 1 97
byte 1 103
byte 1 0
align 1
LABELV $403
byte 1 116
byte 1 97
byte 1 115
byte 1 107
byte 1 83
byte 1 117
byte 1 105
byte 1 99
byte 1 105
byte 1 100
byte 1 101
byte 1 0
align 1
LABELV $402
byte 1 116
byte 1 97
byte 1 115
byte 1 107
byte 1 69
byte 1 115
byte 1 99
byte 1 111
byte 1 114
byte 1 116
byte 1 0
align 1
LABELV $401
byte 1 116
byte 1 97
byte 1 115
byte 1 107
byte 1 82
byte 1 101
byte 1 116
byte 1 114
byte 1 105
byte 1 101
byte 1 118
byte 1 101
byte 1 0
align 1
LABELV $400
byte 1 116
byte 1 97
byte 1 115
byte 1 107
byte 1 70
byte 1 111
byte 1 108
byte 1 108
byte 1 111
byte 1 119
byte 1 0
align 1
LABELV $399
byte 1 116
byte 1 97
byte 1 115
byte 1 107
byte 1 67
byte 1 97
byte 1 109
byte 1 112
byte 1 0
align 1
LABELV $398
byte 1 116
byte 1 97
byte 1 115
byte 1 107
byte 1 80
byte 1 97
byte 1 116
byte 1 114
byte 1 111
byte 1 108
byte 1 0
align 1
LABELV $397
byte 1 116
byte 1 97
byte 1 115
byte 1 107
byte 1 68
byte 1 101
byte 1 102
byte 1 101
byte 1 110
byte 1 115
byte 1 101
byte 1 0
align 1
LABELV $396
byte 1 116
byte 1 97
byte 1 115
byte 1 107
byte 1 79
byte 1 102
byte 1 102
byte 1 101
byte 1 110
byte 1 115
byte 1 101
byte 1 0
align 1
LABELV $395
byte 1 100
byte 1 101
byte 1 110
byte 1 121
byte 1 79
byte 1 114
byte 1 100
byte 1 101
byte 1 114
byte 1 0
align 1
LABELV $394
byte 1 99
byte 1 111
byte 1 110
byte 1 102
byte 1 105
byte 1 114
byte 1 109
byte 1 79
byte 1 114
byte 1 100
byte 1 101
byte 1 114
byte 1 0
align 1
LABELV $393
byte 1 110
byte 1 101
byte 1 120
byte 1 116
byte 1 79
byte 1 114
byte 1 100
byte 1 101
byte 1 114
byte 1 0
align 1
LABELV $392
byte 1 112
byte 1 114
byte 1 101
byte 1 118
byte 1 84
byte 1 101
byte 1 97
byte 1 109
byte 1 77
byte 1 101
byte 1 109
byte 1 98
byte 1 101
byte 1 114
byte 1 0
align 1
LABELV $391
byte 1 110
byte 1 101
byte 1 120
byte 1 116
byte 1 84
byte 1 101
byte 1 97
byte 1 109
byte 1 77
byte 1 101
byte 1 109
byte 1 98
byte 1 101
byte 1 114
byte 1 0
align 1
LABELV $390
byte 1 116
byte 1 99
byte 1 109
byte 1 100
byte 1 0
align 1
LABELV $389
byte 1 118
byte 1 116
byte 1 101
byte 1 108
byte 1 108
byte 1 95
byte 1 97
byte 1 116
byte 1 116
byte 1 97
byte 1 99
byte 1 107
byte 1 101
byte 1 114
byte 1 0
align 1
LABELV $388
byte 1 118
byte 1 116
byte 1 101
byte 1 108
byte 1 108
byte 1 95
byte 1 116
byte 1 97
byte 1 114
byte 1 103
byte 1 101
byte 1 116
byte 1 0
align 1
LABELV $387
byte 1 116
byte 1 101
byte 1 108
byte 1 108
byte 1 95
byte 1 97
byte 1 116
byte 1 116
byte 1 97
byte 1 99
byte 1 107
byte 1 101
byte 1 114
byte 1 0
align 1
LABELV $386
byte 1 116
byte 1 101
byte 1 108
byte 1 108
byte 1 95
byte 1 116
byte 1 97
byte 1 114
byte 1 103
byte 1 101
byte 1 116
byte 1 0
align 1
LABELV $385
byte 1 119
byte 1 101
byte 1 97
byte 1 112
byte 1 111
byte 1 110
byte 1 0
align 1
LABELV $384
byte 1 119
byte 1 101
byte 1 97
byte 1 112
byte 1 112
byte 1 114
byte 1 101
byte 1 118
byte 1 0
align 1
LABELV $383
byte 1 119
byte 1 101
byte 1 97
byte 1 112
byte 1 110
byte 1 101
byte 1 120
byte 1 116
byte 1 0
align 1
LABELV $382
byte 1 115
byte 1 105
byte 1 122
byte 1 101
byte 1 100
byte 1 111
byte 1 119
byte 1 110
byte 1 0
align 1
LABELV $381
byte 1 115
byte 1 105
byte 1 122
byte 1 101
byte 1 117
byte 1 112
byte 1 0
align 1
LABELV $380
byte 1 45
byte 1 115
byte 1 99
byte 1 111
byte 1 114
byte 1 101
byte 1 115
byte 1 0
align 1
LABELV $379
byte 1 43
byte 1 115
byte 1 99
byte 1 111
byte 1 114
byte 1 101
byte 1 115
byte 1 0
align 1
LABELV $378
byte 1 118
byte 1 105
byte 1 101
byte 1 119
byte 1 112
byte 1 111
byte 1 115
byte 1 0
align 1
LABELV $377
byte 1 112
byte 1 114
byte 1 101
byte 1 118
byte 1 115
byte 1 107
byte 1 105
byte 1 110
byte 1 0
align 1
LABELV $376
byte 1 110
byte 1 101
byte 1 120
byte 1 116
byte 1 115
byte 1 107
byte 1 105
byte 1 110
byte 1 0
align 1
LABELV $375
byte 1 112
byte 1 114
byte 1 101
byte 1 118
byte 1 102
byte 1 114
byte 1 97
byte 1 109
byte 1 101
byte 1 0
align 1
LABELV $374
byte 1 110
byte 1 101
byte 1 120
byte 1 116
byte 1 102
byte 1 114
byte 1 97
byte 1 109
byte 1 101
byte 1 0
align 1
LABELV $373
byte 1 116
byte 1 101
byte 1 115
byte 1 116
byte 1 109
byte 1 111
byte 1 100
byte 1 101
byte 1 108
byte 1 0
align 1
LABELV $372
byte 1 116
byte 1 101
byte 1 115
byte 1 116
byte 1 103
byte 1 117
byte 1 110
byte 1 0
align 1
LABELV $364
byte 1 99
byte 1 103
byte 1 95
byte 1 114
byte 1 111
byte 1 108
byte 1 108
byte 1 0
align 1
LABELV $340
byte 1 37
byte 1 100
byte 1 0
align 1
LABELV $339
byte 1 99
byte 1 103
byte 1 95
byte 1 116
byte 1 104
byte 1 114
byte 1 111
byte 1 116
byte 1 116
byte 1 108
byte 1 101
byte 1 0
align 1
LABELV $320
byte 1 53
byte 1 0
align 1
LABELV $314
byte 1 100
byte 1 101
byte 1 118
byte 1 101
byte 1 108
byte 1 111
byte 1 112
byte 1 101
byte 1 114
byte 1 0
align 1
LABELV $312
byte 1 116
byte 1 101
byte 1 108
byte 1 108
byte 1 32
byte 1 37
byte 1 105
byte 1 32
byte 1 115
byte 1 117
byte 1 105
byte 1 99
byte 1 105
byte 1 100
byte 1 101
byte 1 0
align 1
LABELV $308
byte 1 99
byte 1 109
byte 1 100
byte 1 32
byte 1 118
byte 1 115
byte 1 97
byte 1 121
byte 1 32
byte 1 107
byte 1 105
byte 1 108
byte 1 108
byte 1 95
byte 1 103
byte 1 117
byte 1 97
byte 1 110
byte 1 116
byte 1 108
byte 1 101
byte 1 116
byte 1 10
byte 1 0
align 1
LABELV $306
byte 1 99
byte 1 109
byte 1 100
byte 1 32
byte 1 118
byte 1 115
byte 1 97
byte 1 121
byte 1 32
byte 1 100
byte 1 101
byte 1 97
byte 1 116
byte 1 104
byte 1 95
byte 1 105
byte 1 110
byte 1 115
byte 1 117
byte 1 108
byte 1 116
byte 1 10
byte 1 0
align 1
LABELV $304
byte 1 99
byte 1 109
byte 1 100
byte 1 32
byte 1 118
byte 1 116
byte 1 97
byte 1 117
byte 1 110
byte 1 116
byte 1 10
byte 1 0
align 1
LABELV $302
byte 1 99
byte 1 109
byte 1 100
byte 1 32
byte 1 118
byte 1 115
byte 1 97
byte 1 121
byte 1 32
byte 1 112
byte 1 114
byte 1 97
byte 1 105
byte 1 115
byte 1 101
byte 1 10
byte 1 0
align 1
LABELV $300
byte 1 99
byte 1 109
byte 1 100
byte 1 32
byte 1 118
byte 1 115
byte 1 97
byte 1 121
byte 1 32
byte 1 107
byte 1 105
byte 1 108
byte 1 108
byte 1 95
byte 1 105
byte 1 110
byte 1 115
byte 1 117
byte 1 108
byte 1 116
byte 1 10
byte 1 0
align 1
LABELV $298
byte 1 105
byte 1 104
byte 1 97
byte 1 118
byte 1 101
byte 1 102
byte 1 108
byte 1 97
byte 1 103
byte 1 0
align 1
LABELV $296
byte 1 111
byte 1 110
byte 1 102
byte 1 111
byte 1 108
byte 1 108
byte 1 111
byte 1 119
byte 1 99
byte 1 97
byte 1 114
byte 1 114
byte 1 105
byte 1 101
byte 1 114
byte 1 0
align 1
LABELV $294
byte 1 111
byte 1 110
byte 1 114
byte 1 101
byte 1 116
byte 1 117
byte 1 114
byte 1 110
byte 1 102
byte 1 108
byte 1 97
byte 1 103
byte 1 0
align 1
LABELV $292
byte 1 111
byte 1 110
byte 1 102
byte 1 111
byte 1 108
byte 1 108
byte 1 111
byte 1 119
byte 1 0
align 1
LABELV $290
byte 1 111
byte 1 110
byte 1 99
byte 1 97
byte 1 109
byte 1 112
byte 1 0
align 1
LABELV $288
byte 1 111
byte 1 110
byte 1 112
byte 1 97
byte 1 116
byte 1 114
byte 1 111
byte 1 108
byte 1 0
align 1
LABELV $286
byte 1 111
byte 1 110
byte 1 100
byte 1 101
byte 1 102
byte 1 101
byte 1 110
byte 1 115
byte 1 101
byte 1 0
align 1
LABELV $284
byte 1 111
byte 1 110
byte 1 111
byte 1 102
byte 1 102
byte 1 101
byte 1 110
byte 1 115
byte 1 101
byte 1 0
align 1
LABELV $283
byte 1 111
byte 1 110
byte 1 103
byte 1 101
byte 1 116
byte 1 102
byte 1 108
byte 1 97
byte 1 103
byte 1 0
align 1
LABELV $282
byte 1 99
byte 1 109
byte 1 100
byte 1 32
byte 1 118
byte 1 115
byte 1 97
byte 1 121
byte 1 95
byte 1 116
byte 1 101
byte 1 97
byte 1 109
byte 1 32
byte 1 37
byte 1 115
byte 1 10
byte 1 0
align 1
LABELV $270
byte 1 43
byte 1 98
byte 1 117
byte 1 116
byte 1 116
byte 1 111
byte 1 110
byte 1 54
byte 1 59
byte 1 32
byte 1 119
byte 1 97
byte 1 105
byte 1 116
byte 1 59
byte 1 32
byte 1 45
byte 1 98
byte 1 117
byte 1 116
byte 1 116
byte 1 111
byte 1 110
byte 1 54
byte 1 0
align 1
LABELV $269
byte 1 110
byte 1 111
byte 1 0
align 1
LABELV $264
byte 1 116
byte 1 101
byte 1 97
byte 1 109
byte 1 116
byte 1 97
byte 1 115
byte 1 107
byte 1 32
byte 1 37
byte 1 100
byte 1 10
byte 1 0
align 1
LABELV $259
byte 1 43
byte 1 98
byte 1 117
byte 1 116
byte 1 116
byte 1 111
byte 1 110
byte 1 53
byte 1 59
byte 1 32
byte 1 119
byte 1 97
byte 1 105
byte 1 116
byte 1 59
byte 1 32
byte 1 45
byte 1 98
byte 1 117
byte 1 116
byte 1 116
byte 1 111
byte 1 110
byte 1 53
byte 1 0
align 1
LABELV $258
byte 1 121
byte 1 101
byte 1 115
byte 1 0
align 1
LABELV $256
byte 1 99
byte 1 109
byte 1 100
byte 1 32
byte 1 118
byte 1 116
byte 1 101
byte 1 108
byte 1 108
byte 1 32
byte 1 37
byte 1 100
byte 1 32
byte 1 37
byte 1 115
byte 1 10
byte 1 0
align 1
LABELV $220
byte 1 118
byte 1 116
byte 1 101
byte 1 108
byte 1 108
byte 1 32
byte 1 37
byte 1 105
byte 1 32
byte 1 37
byte 1 115
byte 1 0
align 1
LABELV $213
byte 1 116
byte 1 101
byte 1 108
byte 1 108
byte 1 32
byte 1 37
byte 1 105
byte 1 32
byte 1 37
byte 1 115
byte 1 0
align 1
LABELV $209
byte 1 89
byte 1 79
byte 1 85
byte 1 32
byte 1 76
byte 1 79
byte 1 83
byte 1 69
byte 1 46
byte 1 46
byte 1 46
byte 1 0
align 1
LABELV $205
byte 1 89
byte 1 79
byte 1 85
byte 1 32
byte 1 87
byte 1 73
byte 1 78
byte 1 33
byte 1 0
align 1
LABELV $202
byte 1 49
byte 1 48
byte 1 48
byte 1 0
align 1
LABELV $201
byte 1 99
byte 1 103
byte 1 95
byte 1 116
byte 1 104
byte 1 105
byte 1 114
byte 1 100
byte 1 80
byte 1 101
byte 1 114
byte 1 115
byte 1 111
byte 1 110
byte 1 82
byte 1 97
byte 1 110
byte 1 103
byte 1 101
byte 1 0
align 1
LABELV $200
byte 1 48
byte 1 0
align 1
LABELV $199
byte 1 99
byte 1 103
byte 1 95
byte 1 116
byte 1 104
byte 1 105
byte 1 114
byte 1 100
byte 1 80
byte 1 101
byte 1 114
byte 1 115
byte 1 111
byte 1 110
byte 1 65
byte 1 110
byte 1 103
byte 1 108
byte 1 101
byte 1 0
align 1
LABELV $198
byte 1 49
byte 1 0
align 1
LABELV $197
byte 1 99
byte 1 103
byte 1 95
byte 1 116
byte 1 104
byte 1 105
byte 1 114
byte 1 100
byte 1 80
byte 1 101
byte 1 114
byte 1 115
byte 1 111
byte 1 110
byte 1 0
align 1
LABELV $196
byte 1 51
byte 1 53
byte 1 0
align 1
LABELV $195
byte 1 99
byte 1 103
byte 1 95
byte 1 99
byte 1 97
byte 1 109
byte 1 101
byte 1 114
byte 1 97
byte 1 79
byte 1 114
byte 1 98
byte 1 105
byte 1 116
byte 1 68
byte 1 101
byte 1 108
byte 1 97
byte 1 121
byte 1 0
align 1
LABELV $194
byte 1 50
byte 1 0
align 1
LABELV $193
byte 1 99
byte 1 103
byte 1 95
byte 1 99
byte 1 97
byte 1 109
byte 1 101
byte 1 114
byte 1 97
byte 1 79
byte 1 114
byte 1 98
byte 1 105
byte 1 116
byte 1 0
align 1
LABELV $170
byte 1 115
byte 1 99
byte 1 111
byte 1 114
byte 1 101
byte 1 0
align 1
LABELV $151
byte 1 37
byte 1 115
byte 1 32
byte 1 40
byte 1 37
byte 1 105
byte 1 32
byte 1 37
byte 1 105
byte 1 32
byte 1 37
byte 1 105
byte 1 41
byte 1 32
byte 1 58
byte 1 32
byte 1 37
byte 1 105
byte 1 10
byte 1 0
align 1
LABELV $146
byte 1 37
byte 1 105
byte 1 0
align 1
LABELV $145
byte 1 99
byte 1 103
byte 1 95
byte 1 118
byte 1 105
byte 1 101
byte 1 119
byte 1 115
byte 1 105
byte 1 122
byte 1 101
byte 1 0
align 1
LABELV $143
byte 1 103
byte 1 99
byte 1 32
byte 1 37
byte 1 105
byte 1 32
byte 1 37
byte 1 105
byte 1 0
