// TieLaser Weapon

#include "cg_local.h"

/*
-------------------------
FX_TieLaserProjectileThink
-------------------------
*/

void FX_TieLaserProjectileThink( centity_t *cent, const struct weaponInfo_s *weapon )
{
	vec3_t forward;

	if ( VectorNormalize2( cent->currentState.pos.trDelta, forward ) == 0.0f )
	{
		forward[2] = 1.0f;
	}

	trap_FX_PlayEffectID( cgs.effects.tieLaserShotEffect, cent->lerpOrigin, forward );
}

void FX_TieLaserAltFireThink( centity_t *cent, const struct weaponInfo_s *weapon )
{
	vec3_t forward;

	if ( VectorNormalize2( cent->currentState.pos.trDelta, forward ) == 0.0f )
	{
		forward[2] = 1.0f;
	}

	trap_FX_PlayEffectID( cgs.effects.tieLaserShotEffect, cent->lerpOrigin, forward );
}

/*
-------------------------
FX_TieLaserWeaponHitWall
-------------------------
*/
void FX_TieLaserWeaponHitWall( vec3_t origin, vec3_t normal )
{
	trap_FX_PlayEffectID( cgs.effects.tieLaserWallImpactEffect, origin, normal );
}

void FX_TieLaserWeaponHitPlayer( vec3_t origin, vec3_t normal )
{
	trap_FX_PlayEffectID( cgs.effects.tieLaserWallImpactEffect, origin, normal );
}