class ONSKamikazeSquadAI extends ONSSquadAI;

function bool FindPathToObjective(Bot B, Actor O)
{
	local vehicle OldVehicle;

	if ( B.Pawn.bStationary )
		return false;

	if ( O == None )
	{
		O = SquadObjective;
		if ( O == None )
		{
			B.GoalString = "No SquadObjective";
			return false;
		}
	}

	if ( ONSPowerNode(O) != None && (ONSPowerNode(O).CoreStage != 0 || ONSPowerCore(O).DefenderTeamIndex == Team.TeamIndex) )
	{
		B.MoveTarget = None;
		/*
    if ( (Vehicle(B.Pawn) != None) && (B.Pawn.Location.Z - O.Location.Z < 500)
		     && (VSize(B.Pawn.Location - O.Location) < Vehicle(B.Pawn).ObjectiveGetOutDist) && B.LineOfSightTo(O) )
		{
			OldVehicle = Vehicle(B.Pawn);
			Vehicle(B.Pawn).KDriverLeave(false);
			if ( (Vehicle(B.Pawn) == None) && (B.Pawn.Physics == PHYS_Falling) && B.DoWaitForLanding() )
			{
				B.Pawn.Velocity.Z = 0;
				return true;
			}
		}
		*/

		if ( B.ActorReachable(O) )
		{
			/*
      if ( (Vehicle(B.Pawn) != None) && (B.Pawn.Location.Z - O.Location.Z < 500) )
				Vehicle(B.Pawn).KDriverLeave(false);
			*/
			if ( B.Pawn.ReachedDestination(O) )
			{
				//log(B.GetHumanReadableName()$" Force touch for reached objective");
				O.Touch(B.Pawn);
				return false;
			}
			if ( OldVehicle != None )
				OldVehicle.TeamUseTime = Level.TimeSeconds + 6;
			B.RouteGoal = O;
			B.RouteCache[0] = None;
			B.GoalString = "almost at "$O;
			B.MoveTarget = O;
			B.SetAttractionState();
			return true;
		}
		if ( OldVehicle != None )
			OldVehicle.UsedBy(B.Pawn);
	}

	if ( Super.FindPathToObjective(B,O) )
		return true;

	/*
  if ( Vehicle(B.Pawn) != None && !Vehicle(B.Pawn).bKeyVehicle && (B.Enemy == None || !B.EnemyVisible()) )
	{
		if (B.Pawn.HasWeapon() && Vehicle(B.Pawn).MaxDesireability > 0.5)
			Vehicle(B.Pawn).bDefensive = true; //have bots use it as a turret instead
		else
			Vehicle(B.Pawn).VehicleLostTime = Level.TimeSeconds + 20;
		//log(B.PlayerReplicationInfo.PlayerName$" Abandoning "$Vehicle(B.Pawn)$" because can't reach "$O);
		Vehicle(B.Pawn).KDriverLeave(false);
	}
	*/
	return false;
}

function bool CheckVehicle(Bot B)
{
	local ONSPowerCore Nearest, Best;
	local GameObjective O;
	local float NewRating, BestRating;
	local byte SourceDist;

	/*
  if ( Vehicle(B.Pawn) != None && GetOrders() == 'Defend' && !Vehicle(B.Pawn).bDefensive && SquadObjective != None
	     && VSize(B.Pawn.Location - SquadObjective.Location) < 2000 && !Vehicle(B.Pawn).bKeyVehicle && (B.Enemy == None || !B.EnemyVisible()) )
	{
	     	Vehicle(B.Pawn).KDriverLeave(false);
	     	return false;
	}
	*/

	if (Vehicle(B.Pawn) == None && ONSPowerCore(SquadObjective) != None)
	{
		if (ONSPowerCore(SquadObjective).CoreStage == 0)
		{
			if ( GetOrders() == 'Defend' && (B.Enemy == None || (!B.EnemyVisible() && Level.TimeSeconds - B.LastSeenTime > 3))
			     && VSize(B.Pawn.Location - SquadObjective.Location) < GetMaxObjectiveGetOutDist()
			     && ONSPowerCore(SquadObjective).Health < ONSPowerCore(SquadObjective).DamageCapacity
			     && ((B.Pawn.Weapon != None && B.Pawn.Weapon.CanHeal(SquadObjective)) || (B.Pawn.PendingWeapon != None && B.Pawn.PendingWeapon.CanHeal(SquadObjective))) )
				return false;
		}
		if (ONSPowerCore(SquadObjective).CoreStage == 2)
		{
			if ( (B.Enemy == None || !B.EnemyVisible()) && VSize(B.Pawn.Location - SquadObjective.Location) < GetMaxObjectiveGetOutDist() )
				return false;
		}
		if ((ONSPowerCore(SquadObjective).CoreStage == 4 || ONSPowerCore(SquadObjective).CoreStage == 1) && VSize(B.Pawn.Location - SquadObjective.Location) < GetMaxObjectiveGetOutDist())
			return false;
	}

	if (Super.CheckVehicle(B))
		return true;
	if ( Vehicle(B.Pawn) != None || (B.Enemy != None && B.EnemyVisible()) || LastFailedNodeTeleportTime > Level.TimeSeconds - 20 || ONSPowerCore(SquadObjective) == None
	     || ONSPlayerReplicationInfo(B.PlayerReplicationInfo) == None || ONSPowerCore(SquadObjective).HasUsefulVehicles(B) || B.Skill + B.Tactics < 2 + FRand() )
		return false;

	//no vehicles around
	if (VSize(B.Pawn.Location - SquadObjective.Location) > 5000 && !B.LineOfSightTo(SquadObjective))
	{
		//really want a vehicle to get to SquadObjective, so teleport to a different node to find one
		if (ONSPowerCore(B.RouteGoal) != None && ONSPlayerReplicationInfo(B.PlayerReplicationInfo).GetCurrentNode() == B.RouteGoal)
		{
			SourceDist = ONSPowerCore(B.RouteGoal).FinalCoreDistance[Abs(1 - Team.TeamIndex)];
			for (O = Team.AI.Objectives; O != None; O = O.NextObjective)
				if (O != B.RouteGoal && ONSOnslaughtGame(Level.Game).ValidSpawnPoint(ONSPowerCore(O), Team.TeamIndex))
				{
					NewRating = ONSPowerCore(O).TeleportRating(B, Team.TeamIndex, SourceDist);
					if (NewRating > BestRating || (NewRating == BestRating && FRand() < 0.5))
					{
						Best = ONSPowerCore(O);
						BestRating = NewRating;
					}
				}

			if (Best != None)
				ONSPlayerReplicationInfo(B.PlayerReplicationInfo).TeleportTo(Best);
			else
				LastFailedNodeTeleportTime = Level.TimeSeconds;

			return false;
		}

		Nearest = ONSPowerCore(SquadObjective).ClosestTo(B.Pawn);
		if ( Nearest == None || Nearest.CoreStage != 0 || Nearest.DefenderTeamIndex != Team.TeamIndex
		     || VSize(Nearest.Location - B.Pawn.Location) > 2000 )
			return false;

		B.MoveTarget = B.FindPathToward(Nearest, false);
		if (B.MoveTarget != None)
		{
			B.RouteGoal = Nearest;
			B.GoalString = "Node teleport from "$B.RouteGoal;
			B.SetAttractionState();
			return true;
		}
	}

	return false;
}


//return a value indicating how useful this vehicle is to the bot
function float VehicleDesireability(Vehicle V, Bot B)
{
	if( V.bStationary == true )
	{
 	  return 0.0;
 	}
 	else
 	{
    return 100.0;
  }
}
