//================================================
// KamikazeOnslaught
// This is the gametype you need to run to spawn KamikazeBots
//================================================
class KamikazeOnslaught extends ONSOnslaughtGame;

function bool AddBot(optional string botName)
{
    local KamikazeBot NewBot;

    log("Spawning a kamikaze bot!");

    NewBot = KamikazeBot(SpawnBot(botName));
    if ( NewBot == None )
    {
        warn("Failed to spawn bot.");
        return false;
    }
    // broadcast a welcome message.
    BroadcastLocalizedMessage(GameMessageClass, 1, NewBot.PlayerReplicationInfo);

    NewBot.PlayerReplicationInfo.PlayerID = CurrentID++;
    NumBots++;
    if ( Level.NetMode == NM_Standalone )
		RestartPlayer(NewBot);
	else
		NewBot.GotoState('Dead','MPStart');

    return true;
}

defaultproperties
{
  GameName="KamikazeOnslaught"
  ScreenShotName="UT2004Thumbnails.DMShots"
  DecoTextName="XGame.Deathmatch"
  Acronym="KONS"
}
