class KamikazeMutator extends Mutator;

var bool bHasInteraction;

function ModifyPlayer(Pawn Other)
{
	Super.ModifyPlayer(Other);
	SpawnVehicle(Other);
}

function SpawnVehicle(Pawn P)
{
	local Vehicle V;

	V = spawn(class'ONSPRV',,,P.location);

	if(P != none && V != none)
	{
		V.Team = P.GetTeamNum();
    V.TryToDrive(P);
    V.UsedBy(P);
	}
}

function PostBeginPlay()
{
	local Object O;

	foreach AllObjects(class'object', O)
	{
		// set up the kamikazebot controllers
    if ( ClassIsChildOf(Class(O), class'Pawn') )
		{
			if ( class<Pawn>(O).default.ControllerClass == class'xBot' )
      {
				log('Changing Pawns ControllerClass to KamikazeBot from xBot');
        class<Pawn>(O).default.ControllerClass = class'KamikazeBot';
			}
		}

		// change the squadtype based on the gametype...
    if ( ClassIsChildOf(Class(O), class'ONSTeamAI') )
		{
      if ( class<ONSTeamAI>(O).default.SquadType == class'ONSSquadAI' )
      {
				log('Changing ONSTeamAIs SquadType to ONSKamikazeSquadAI');
        class<ONSTeamAI>(O).default.SquadType = class'ONSKamikazeSquadAI';
			}
		}
	}
	
	// allow vehicles to be used in each gametype
  Level.Game.bAllowVehicles = true;

	Super.PostBeginPlay();
}

function bool CheckReplacement(Actor Other, out byte bSuperRelevant)
{
	/*
  if (TransLauncher(Other) != None)
	{
		if (TransLauncher(Other).FireModeClass[0] == class'TransFire')
			TransLauncher(Other).FireModeClass[0] = class'SuperBotTransFire';
		else if (TransLauncher(Other).FireModeClass[0] == class'ClassicTransFire')
			TransLauncher(Other).FireModeClass[0] = class'SuperBotClassicTransFire';
	}
	else if (SuperBot(Other) != None)
		SuperBot(Other).bAlwaysDevious = bAlwaysDevious;
  */
	return true;
}

function Tick(float deltaTime)
{
	local PlayerController PC;

	if (!bHasInteraction && Level.NetMode != NM_DedicatedServer && Level.NetMode != NM_Client)
	{
		PC = Level.GetLocalPlayerController();
		PC.Player.InteractionMaster.AddInteraction("Kamikaze.ControllerClassRestorer", PC.Player);
		bHasInteraction = true;
	}
}

defaultproperties
{
  Description = "Makes the bots charge."
	FriendlyName = "Kamikaze Bot"
}
