//================================================
// KamikazeDeathMatch
// This is the gametype you need to run to spawn KamikazeBots
//================================================
class KamikazeDeathMatch extends DeathMatch;

function bool AddBot(optional string botName)
{
    local KamikazeBot NewBot;

    NewBot = KamikazeBot(SpawnBot(botName));
    if ( NewBot == None )
    {
        warn("Failed to spawn bot.");
        return false;
    }
    // broadcast a welcome message.
    BroadcastLocalizedMessage(GameMessageClass, 1, NewBot.PlayerReplicationInfo);

    NewBot.PlayerReplicationInfo.PlayerID = CurrentID++;
    NumBots++;
    if ( Level.NetMode == NM_Standalone )
		RestartPlayer(NewBot);
	else
		NewBot.GotoState('Dead','MPStart');

    return true;
}

/*
function PostBeginPlay(){
  Super.PostBeginPlay();
  Level.Game.bAllowVehicles = true;
}
*/

defaultproperties
{
  GameName="KamikazeDeathMatch"
  ScreenShotName="UT2004Thumbnails.DMShots"
  DecoTextName="XGame.Deathmatch"
  Acronym="KDM"
  bAllowVehicles=true
}
