//============================================
// KamikazeBot
// A bot that will try to ram into its enemy
//============================================
class KamikazeBot extends xBot;

var() bool spawned;

var() Vehicle SpawnedVehicle;

var() class<Vehicle> VehicleClass;

function PostBeginPlay()
{
  Super.PostBeginPlay();

  log("Spawned a Kamikaze Bot...");
  
  //Spawn( class<actor>( DynamicLoadObject( "Onslaught.ONSPRV", class'Class' ) ),,,Location + 72 * Vector(Rotation) + vect(0,0,1) * 15 );
  GotoState('VehicleSearching');

}

function Died(Controller Killer, class<DamageType> damageType, vector HitLocation)
{
  log('bot died');
  spawned = false;
  if(SpawnedVehicle != None)
    SpawnedVehicle.Died(Killer, damageType, HitLocation);
  Pawn.Died(Killer, damageType, HitLocation);
}

/*
event Destroyed()
{
  Super.Destroyed();
}
*/

function GetOutOfVehicle()
{
  log('not going to get out');
}

function bool GiveVehicle()
{
  log('KamikazeBot spawning a vehicle');

  SpawnedVehicle = Vehicle(Spawn( class<actor>( DynamicLoadObject( "Onslaught.ONSPRV", class'Class' ) ),,,Pawn.Location + vect(0,0,150), Pawn.Rotation));
  SpawnedVehicle.Team = Pawn.GetTeamNum();
  SpawnedVehicle.TryToDrive(Pawn);
  SpawnedVehicle.UsedBy(Pawn);
  Squad.BotEnteredVehicle(self);

  return (Vehicle(Pawn) != None);
}

function ChooseAttackMode()
{
	local float EnemyStrength, WeaponRating, RetreatThreshold;

  GoalString = " ChooseAttackMode last seen "$(Level.TimeSeconds - LastSeenTime);
	// should I run away?
	if ( (Squad == None) || (Enemy == None) || (Pawn == None) )
		log("HERE 1 Squad "$Squad$" Enemy "$Enemy$" pawn "$Pawn);
	EnemyStrength = RelativeStrength(Enemy);

	if ( Vehicle(Pawn) == None )
	{
    if(spawned == false) 
    {
      GiveVehicle();
      spawned = true;
    }
	}

  if ( Vehicle(Pawn) != None )
	{
		GoalString = "ChooseAttackMode VehicleFightEnemy";
    VehicleFightEnemy(true, EnemyStrength);
		return;
	}

	GoalString = "ChooseAttackMode FightEnemy";
	FightEnemy(true, EnemyStrength);
}

function DoCharge()
{
  if ( Vehicle(Pawn) == None )
	{
    /*
    V = spawn(VehicleClass);
    V.UsedBy(Pawn);
	  if (Vehicle(Pawn) != None)
	  {
	  	Squad.BotEnteredVehicle(self);
    }
    */

    GotoState('VehicleSearching');
	}

  if ( Vehicle(Pawn) != None )
	{
		// need to use our new charging state
    GotoState('VehicleCharging');
		return;
	}

  if ( Enemy.PhysicsVolume.bWaterVolume )
	{
		if ( !Pawn.bCanSwim )
		{
			DoTacticalMove();
			return;
		}
	}
	else if ( !Pawn.bCanFly && !Pawn.bCanWalk )
	{
		DoTacticalMove();
		return;
	}

	GotoState('Charging');
}

function VehicleFightEnemy(bool bCanCharge, float EnemyStrength)
{
	if ( Pawn.bStationary || Vehicle(Pawn).bKeyVehicle )
	{
		if ( !EnemyVisible() )
		{
			GoalString = "Stake Out";
			DoStakeOut();
		}
		else
			GotoState('VehicleCharging');
		return;
	}

	if ( !EnemyVisible() )
	{
		
		if( Vehicle(Pawn) != None )
		{
		  GoalString = "VehicleHunt";
      GotoState('VehicleRoaming');
		}
		else
		{
			GoalString = "Hunt";
			GotoState('Hunting');
		}
		return;
	}
	else
	{
    BlockedPath = None;
	  Target = Enemy;
    DoCharge();
	}
}

state DriveToGoal
{
	function Timer()
	{
	  log('DriveToGoal timer');
	}

	function BeginState()
	{
	  log('Beginning DriveToGoal');
	}
	
	function EndState()
	{
	  log('Ending DriveToGoal');
	}

Begin:
  if ( bSoaking )
		SoakStop("STUCK IN DriveToGoal!");
		
	sleep(1.0);
	
	goto 'Begin';
}

auto state VehicleSearching
{
  ignores Bump;

	function BeginState()
	{
	  log('Beginning VehicleSearching');
	}

	function EndState()
	{
	  log('Ending VehicleSearching');
	}

Begin:

  if ( Vehicle(Pawn) == None )
  {

    if( spawned == false )
    {
      log('dont have a vehicle yet');
      //GiveVehicle();
      log('spawned a vehicle at'@Vehicle(Pawn).Location);
      GotoState('VehicleRoaming');
      spawned = true;
    }

  }
  else
  {
    GotoState('VehicleRoaming');
  }

	if ( bSoaking )
		SoakStop("STUCK IN VehicleSearching!");
		
	sleep(1.0);

	GotoState('VehicleRoaming', 'Begin');

}

state VehicleRoaming extends DriveToGoal
{
  ignores Bump;

  function Timer()
	{
		log('VehicleRoaming timer');
	}
	
	function BeginState()
	{
	  log('Beginning VehicleRoaming');
	}
	
	function EndState()
	{
	  log('Ending VehicleRoaming');
	}

Begin:
  if ( Vehicle(Pawn) == None )
  {
    GotoState('VehicleSearching');
  }
  else
  {
		 ;//Spawn( class<actor>( DynamicLoadObject( "Onslaught.ONSPRV", class'Class' ) ),,,SpawnLoc + 72 * Vector(Rotation) + vect(0,0,1) * 15 );
  }

  if ( Enemy != None )
  {
    GotoState('VehicleCharging');
  }

	if ( bSoaking )
		SoakStop("STUCK IN VehicleRoaming!");
		
	sleep(10.0);
	
	goto 'Begin';

}

state VehicleCharging
{
  ignores Bump;

  function Timer()
	{

	}

	function BeginState()
	{
	  log('Beginning VehicleCharging');
	}
	
	function EndState()
	{
	  log('Ending VehicleCharging');
	}
	
Begin:
  if( Vehicle(Pawn) == None )
  {
    GotoState('VehicleSearching');
  }

  if ( Enemy == None )
  {
    GotoState('VehicleRoaming');
  }
  else
  {
    GoalString = "VehicleCharging Enemy";
    SetRouteToGoal(Enemy);
  }

	if ( bSoaking )
		SoakStop("STUCK IN VehicleCharging!");

	sleep( 1.0 );

	goto 'Begin';

}


state RangedAttack
{
ignores SeePlayer, HearNoise, Bump;

	function bool Stopped()
	{
		return true;
	}

	function bool IsShootingObjective()
	{
		return (Target != None && (Target == Squad.SquadObjective || Target.Owner == Squad.SquadObjective));
	}

	function CancelCampFor(Controller C)
	{
		DoTacticalMove();
	}

	function StopFiring()
	{
		if ( (Pawn != None) && (Pawn.Weapon != None) && Pawn.RecommendLongRangedAttack() && Pawn.Weapon.IsFiring() )
			return;
		Global.StopFiring();
		if ( bHasFired )
		{
			if ( IsSniping() )
				Pawn.bWantsToCrouch = (Skill > 2);
			else
			{
				bHasFired = false;
				WhatToDoNext(32);
			}
		}
	}

	function EnemyNotVisible()
	{
		//let attack animation complete
		if ( (Target == Enemy) && !Pawn.RecommendLongRangedAttack() )
			WhatToDoNext(33);
	}

	function Timer()
	{
		if ( (Pawn.Weapon != None) && Pawn.Weapon.bMeleeWeapon )
		{
			SetCombatTimer();
			StopFiring();
			WhatToDoNext(34);
		}
		else if ( Target == Enemy )
			TimedFireWeaponAtEnemy();
		else
			FireWeaponAt(Target);
	}

	function DoRangedAttackOn(Actor A)
	{
		if ( (Pawn.Weapon != None) && Pawn.Weapon.FocusOnLeader(false) )
			Target = Focus;
		else
			Target = A;
		GotoState('RangedAttack');
	}

	function BeginState()
	{
		StopStartTime = Level.TimeSeconds;
		bHasFired = false;
		if ( (Pawn.Physics != PHYS_Flying) || (Pawn.MinFlySpeed == 0) )
		Pawn.Acceleration = vect(0,0,0); //stop
		if ( Vehicle(Pawn) != None )
		{
			Vehicle(Pawn).Steering = 0;
			Vehicle(Pawn).Throttle = 0;
			Vehicle(Pawn).Rise = 0;
		}
		if ( (Pawn.Weapon != None) && Pawn.Weapon.FocusOnLeader(false) )
			Target = Focus;
		else if ( Target == None )
			Target = Enemy;
		if ( Target == None )
			log(GetHumanReadableName()$" no target in ranged attack");
	}

Begin:
	bHasFired = false;
	if ( (Pawn.Weapon != None) && Pawn.Weapon.bMeleeWeapon )
		SwitchToBestWeapon();
	GoalString = "Ranged attack";
	Focus = Target;
	Sleep(0.0);
	if ( Target == None )
		WhatToDoNext(335);

	if ( Enemy != None )
		CheckIfShouldCrouch(Pawn.Location,Enemy.Location, 1);
	if ( NeedToTurn(Target.Location) )
	{
		Focus = Target;
		FinishRotation();
	}
	bHasFired = true;
	if ( Target == Enemy )
		TimedFireWeaponAtEnemy();
	else
		FireWeaponAt(Target);
	Sleep(0.1);
	if ( ((Pawn.Weapon != None) && Pawn.Weapon.bMeleeWeapon) || (Target == None) || (Target != Enemy) )
		WhatToDoNext(35);
	if ( Enemy != None )
		CheckIfShouldCrouch(Pawn.Location,Enemy.Location, 1);
	Focus = Target;
	if ( Pawn.Weapon != None )
		Sleep(FMax(Pawn.Weapon.RangedAttackTime(),0.2 + (0.5 + 0.5 * FRand()) * 0.4 * (7 - Skill)));
	else
		Sleep(0.2 + (0.5 + 0.5 * FRand()) * 0.4 * (7 - Skill));
	WhatToDoNext(36);
	if ( bSoaking )
		SoakStop("STUCK IN RANGEDATTACK!");
}


defaultproperties
{
  VehicleClass = Onslaught.ONSPRV
  spawned = false;
}


