//Mutator doesn't get an event for level changes, so we need
//to revert the bot controller class here instead
class ControllerClassRestorer extends Interaction;

event NotifyLevelChange()
{
	local Object O;

	foreach AllObjects(class'object', O)
	{
		if ( ClassIsChildOf(Class(O), class'Pawn') )
		{
			if ( class<Pawn>(O).default.ControllerClass == class'KamikazeBot' )
			{
				log('Changing Pawns ControllerClass to xBot from KamikazeBot');
        class<Pawn>(O).default.ControllerClass = class'xBot';
			}
    }
	}

	Master.RemoveInteraction(self);
}
