#include "g_local.h"

#define __QV_LOCAL_DEFINES // do this ONCE
#include "quakevoice.h"
#undef __QV_LOCAL_DEFINES

#include <winsock.h>

int init = 0 ;
int timer = 0 ;

static int ReadInt(byte msg [  ], int start )
{
    unsigned char t1 [ 4 ] ;

    t1[0] = msg[start];
    t1[1] = msg[++start];
    t1[2] = msg[++start];
    t1[3] = msg[++start];

    return *((int *) t1 );
}
	
static void AddString ( unsigned char* d, char* s, int i)
{
	int n ;
	for ( n = 0; ; n++ )
	{
		if ( s [ n ] == '\0' )
			break ;
		d [ i + n ] = s [ n ] ;
	}
	d [ i + n ] = '\0' ;
}

static void  AddInt(unsigned char* d, int start, int val )
{
    unsigned char t1 [ 4 ] ;

	*((int*)t1) = val ;
    
	*d = t1 [ 0 ];
    *(++d) = t1 [ 1 ] ;
    *(++d) = t1 [ 2 ] ;
    *(++d) = t1 [ 3 ] ;
	gi.dprintf ( "%d\n", val ) ;
}

int QV_ProcessCommand ( char* cmd, edict_t* ent )
{
	if ( Q_stricmp (cmd, "qv_start") == 0 )
		QV_Talk ( ent, -1 ) ;
	else if ( Q_stricmp (cmd, "qv_stop") == 0 )
		QV_Talk ( ent, 0 ) ;
	else return 0 ;
	return -1 ;
}

int QV_Talk ( edict_t* ent, int action )
{
	char* serverMessage ;
	int   pNum = -1 ;
	serverMessage = (unsigned char*)malloc ( 500 ) ;

	pNum = ent - g_edicts - 1 ;
	if ( pNum < 0 || pNum > maxclients->value ) 
		return 0 ;
	gi.cprintf ( ent, PRINT_HIGH, "%d", pNum ) ;
	if ( action ) // talk!
	{
		serverMessage [ 0 ] = 0x02 ;
		AddInt ( &serverMessage [ 1 ], 0, pNum ) ;
		SendMSG ( qv_Socket, qv_ServerIP, QV_PROXY_PORT, serverMessage, 5 ) ;
		gi.cprintf ( ent, PRINT_HIGH, "Now: talking.\n" ) ;
		return -1 ;
	}
	else
	{
		serverMessage [ 0 ] = 0x03 ;
		AddInt ( &serverMessage [ 1 ], 0, pNum ) ;
		SendMSG ( qv_Socket, qv_ServerIP, QV_PROXY_PORT, serverMessage, 5 ) ;
		gi.cprintf ( ent, PRINT_HIGH, "Now: silence.\n" ) ;
		return -1 ;
	}
}

void QV_SendPacket ( int type, int pnum, char* chr)
{
	char* serverMessage ;
	serverMessage = (unsigned char*)malloc ( 500 ) ;

	if ( pnum < 0 )
		return ;
	
	switch ( type )
	{
	case QV_REG:
		serverMessage [ 0 ] = 0x00 ;
		AddString ( serverMessage, chr, 1 ) ;
		AddInt ( &serverMessage [ strlen ( chr ) + 2 ], 0, pnum ) ;
		SendMSG ( qv_Socket, qv_ServerIP, QV_PROXY_PORT, serverMessage, strlen ( chr ) + 6 ) ;
		gi.dprintf ( "Add IP: %s. Player: %d. Type: %d\n", chr, pnum, type ) ;
		break ;
	case QV_DEREG:
		serverMessage [ 0 ] = 0x01 ;
		AddInt ( &serverMessage [ 1 ], 0, pnum ) ;
		SendMSG ( qv_Socket, qv_ServerIP, QV_PROXY_PORT, serverMessage, 5 ) ;
		gi.dprintf ( "Removed player: %d.\n", pnum ) ;
		break ;
	case QV_TALK:
		break ;
	case QV_NOTALK:
		break ;
	}
	free ( serverMessage ) ;
}

void QV_Init ( ) 
{
	FILE* bawb ;
	if ( (bawb = fopen ( QV_CONFIG_FILE, "r" ) ) == NULL )
	{
		gi.dprintf ( "QuakeVoice config file %s not found.\n", QV_CONFIG_FILE ) ;
		return ;
	}
	else
	{
		fscanf ( bawb, "%s", qv_ServerIP ) ;
		gi.dprintf ( "Server IP is: %s.\n", qv_ServerIP ) ;
		fclose ( bawb ) ;
	}
	qv_Socket = soListen ( 40030 ) ;
}

void QV_AddPlayer ( edict_t* ent, char* ip )
{
	char* realIP = (char*)malloc ( strlen ( ip ) ) ;
	int i ;
	
	for ( i = 0; i < strlen ( ip ); i++ )
	{
		if ( ip [ i ] == ':' )
			break ;
		realIP [ i ] = ip [ i ] ;
	}
	realIP [ i ] = '\0' ;

	QV_SendPacket ( QV_REG, ( ent - g_edicts - 1 ), realIP ) ;

	free ( realIP ) ;
}

void QV_RemovePlayer ( edict_t* ent )
{
	QV_SendPacket ( QV_DEREG, ( ent - g_edicts - 1 ), "" ) ;
}

void QV_FrameTick ( )
{
	fd_set set ;
	RecvMSG m ;
	TIMEVAL t = { 0, 0 } ;
	char msg [ 50 ] ;
	
	if ( !init )
	{
		++timer ;
		if ( timer == 10 )
		{
			msg [ 0 ] = 0x99 ;
			SendMSG ( qv_Socket, qv_ServerIP, QV_PROXY_PORT, msg, 1 ) ;
			timer = 0 ;
		}
	}
	
	FD_ZERO ( &set ) ;
	
	FD_SET ( qv_Socket, &set ) ;
	
	select ( 0, &set, NULL, NULL, &t ) ;
	
	if ( FD_ISSET ( qv_Socket, &set ) ) 
	{ 
		m = GetMSG ( qv_Socket ) ;
		if ( m.cData [ 0 ] != 0x01 )
			return ;
		switch ( m.cData [ 1 ] )
		{
		case 0x00: // reg ack
			gi.dprintf ( "Register acknowledgement\n" ) ;
			break ;
		case 0x01: // del ack
			gi.dprintf ( "Deregister acknowledgement\n" ) ;
			break ;
		case 0x02:
			gi.dprintf ( "Talk ack\n" ) ;
			break ;
		case 0x03:
			gi.dprintf ( "Stop talk ack\n" ) ;
			break ;
		case 0x99:
			gi.dprintf ( "Hello from proxy\n");
			init = -1;
			break;
		case 0x98:
			gi.dprintf ( "Proxy is gone\n");
			init = 0 ;
			break;
		}
	}
}
