/* 
 * udp.c
 * udp library
 *
 */

#include <winsock.h>
#include "udp.h"


void SendMSG(SOCKET sock, char *pcRemoteAddr, int iPort, byte *pcPacket, int len) {
	struct sockaddr_in saLocal, saRemote;
	int err, i, iflag;
	unsigned long junk;
	char cBuffer[MAX_MSGLEN];
	struct hostent *pheDestination;

	saLocal.sin_family = AF_INET;
	saLocal.sin_addr.s_addr = htonl(INADDR_ANY);
	saLocal.sin_port = htons(0);

	/* Have to populate the saRemote sockaddr_in structure with a 
	 * valid address
	 */

	iflag = 0;
	for(i=0;i < (int)strlen(pcRemoteAddr); i++) {
		err = pcRemoteAddr[i];
		if(isalpha(err)) {
			iflag = 1;
		}
	}
	if(iflag == 1) {
		pheDestination = gethostbyname(pcRemoteAddr);
		if(pheDestination == NULL) {
			
		} else {
			memcpy(&saRemote.sin_addr, pheDestination->h_addr, pheDestination->h_length);
		}	
	} else {
		junk = inet_addr(pcRemoteAddr);
		if(junk == -1) {
			
			return;
		} else
			memcpy(&saRemote.sin_addr.s_addr, &junk, 4);
	}
		

	saRemote.sin_family = AF_INET;
	saRemote.sin_port = htons((short)iPort);
	//strcpy(cBuffer, pcPacket);
	CopyMemory ( cBuffer, pcPacket, len );
	err = sendto(sock, cBuffer, len, 0, (struct sockaddr *)&saRemote, sizeof(struct sockaddr_in));
	return;
}

SOCKET soListen(int iPort) {
	SOCKET sock;
	struct sockaddr_in saLocal;
	int err, geg;
	WORD wVersionRequested;
	WSADATA wsaData;
	
	sock = socket(AF_INET, SOCK_DGRAM, 0);
	
    saLocal.sin_family = AF_INET;
    saLocal.sin_addr.s_addr = htonl(INADDR_ANY);
    saLocal.sin_port = htons((int)iPort);

	err = bind(sock, (struct sockaddr *)&saLocal, sizeof(struct sockaddr_in));
	geg = WSAGetLastError ( ) ;
	if(err == 0) {
		
	} else {
		
		return(-1);
	}
    return sock;    
}

RecvMSG GetMSG(SOCKET sock) {
	int err, iSize;
	struct sockaddr_in saRemote;
	RecvMSG rmIncoming;
	char cBuffer[MAX_MSGLEN];

	memset ( cBuffer, 0, MAX_MSGLEN ) ;
	memset ( rmIncoming.cData, 0, MAX_MSGLEN ) ;
	
	iSize = sizeof(struct sockaddr_in);	
	err = -1;
	
	err = recvfrom(sock, (char*)rmIncoming.cData, MAX_MSGLEN, 0, (struct sockaddr *)&saRemote, &iSize);
	rmIncoming.saRemote = saRemote;
	rmIncoming.lDataLen = (long)err;
	return rmIncoming;
}